// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeRepositoryAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) identifying the association.
	//
	// AssociationArn is a required field
	AssociationArn *string `location:"uri" locationName:"AssociationArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRepositoryAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoryAssociationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRepositoryAssociationInput"}

	if s.AssociationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociationArn"))
	}
	if s.AssociationArn != nil && len(*s.AssociationArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssociationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRepositoryAssociationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AssociationArn != nil {
		v := *s.AssociationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AssociationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeRepositoryAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository association.
	RepositoryAssociation *RepositoryAssociation `type:"structure"`
}

// String returns the string representation
func (s DescribeRepositoryAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRepositoryAssociationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RepositoryAssociation != nil {
		v := s.RepositoryAssociation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RepositoryAssociation", v, metadata)
	}
	return nil
}

const opDescribeRepositoryAssociation = "DescribeRepositoryAssociation"

// DescribeRepositoryAssociationRequest returns a request value for making API operation for
// Amazon CodeGuru Reviewer.
//
// Describes a repository association.
//
//    // Example sending a request using DescribeRepositoryAssociationRequest.
//    req := client.DescribeRepositoryAssociationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/DescribeRepositoryAssociation
func (c *Client) DescribeRepositoryAssociationRequest(input *DescribeRepositoryAssociationInput) DescribeRepositoryAssociationRequest {
	op := &aws.Operation{
		Name:       opDescribeRepositoryAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/associations/{AssociationArn}",
	}

	if input == nil {
		input = &DescribeRepositoryAssociationInput{}
	}

	req := c.newRequest(op, input, &DescribeRepositoryAssociationOutput{})
	return DescribeRepositoryAssociationRequest{Request: req, Input: input, Copy: c.DescribeRepositoryAssociationRequest}
}

// DescribeRepositoryAssociationRequest is the request type for the
// DescribeRepositoryAssociation API operation.
type DescribeRepositoryAssociationRequest struct {
	*aws.Request
	Input *DescribeRepositoryAssociationInput
	Copy  func(*DescribeRepositoryAssociationInput) DescribeRepositoryAssociationRequest
}

// Send marshals and sends the DescribeRepositoryAssociation API request.
func (r DescribeRepositoryAssociationRequest) Send(ctx context.Context) (*DescribeRepositoryAssociationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRepositoryAssociationResponse{
		DescribeRepositoryAssociationOutput: r.Request.Data.(*DescribeRepositoryAssociationOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRepositoryAssociationResponse is the response type for the
// DescribeRepositoryAssociation API operation.
type DescribeRepositoryAssociationResponse struct {
	*DescribeRepositoryAssociationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRepositoryAssociation request.
func (r *DescribeRepositoryAssociationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
