// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to list user pools.
type ListUserPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pools.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListUserPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListUserPoolsInput"}

	if s.MaxResults == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response to list user pools.
type ListUserPoolsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pools from the response to list users.
	UserPools []UserPoolDescriptionType `type:"list"`
}

// String returns the string representation
func (s ListUserPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListUserPools = "ListUserPools"

// ListUserPoolsRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Lists the user pools associated with an AWS account.
//
//    // Example sending a request using ListUserPoolsRequest.
//    req := client.ListUserPoolsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserPools
func (c *Client) ListUserPoolsRequest(input *ListUserPoolsInput) ListUserPoolsRequest {
	op := &aws.Operation{
		Name:       opListUserPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserPoolsInput{}
	}

	req := c.newRequest(op, input, &ListUserPoolsOutput{})
	return ListUserPoolsRequest{Request: req, Input: input, Copy: c.ListUserPoolsRequest}
}

// ListUserPoolsRequest is the request type for the
// ListUserPools API operation.
type ListUserPoolsRequest struct {
	*aws.Request
	Input *ListUserPoolsInput
	Copy  func(*ListUserPoolsInput) ListUserPoolsRequest
}

// Send marshals and sends the ListUserPools API request.
func (r ListUserPoolsRequest) Send(ctx context.Context) (*ListUserPoolsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListUserPoolsResponse{
		ListUserPoolsOutput: r.Request.Data.(*ListUserPoolsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListUserPoolsRequestPaginator returns a paginator for ListUserPools.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListUserPoolsRequest(input)
//   p := cognitoidentityprovider.NewListUserPoolsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListUserPoolsPaginator(req ListUserPoolsRequest) ListUserPoolsPaginator {
	return ListUserPoolsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListUserPoolsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListUserPoolsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListUserPoolsPaginator struct {
	aws.Pager
}

func (p *ListUserPoolsPaginator) CurrentPage() *ListUserPoolsOutput {
	return p.Pager.CurrentPage().(*ListUserPoolsOutput)
}

// ListUserPoolsResponse is the response type for the
// ListUserPools API operation.
type ListUserPoolsResponse struct {
	*ListUserPoolsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListUserPools request.
func (r *ListUserPoolsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
