// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for the DescribeConfigurationRecorderStatus action.
type DescribeConfigurationRecorderStatusInput struct {
	_ struct{} `type:"structure"`

	// The name(s) of the configuration recorder. If the name is not specified,
	// the action returns the current status of all the configuration recorders
	// associated with the account.
	ConfigurationRecorderNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecorderStatusInput) String() string {
	return awsutil.Prettify(s)
}

// The output for the DescribeConfigurationRecorderStatus action, in JSON format.
type DescribeConfigurationRecorderStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains status of the specified recorders.
	ConfigurationRecordersStatus []ConfigurationRecorderStatus `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecorderStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConfigurationRecorderStatus = "DescribeConfigurationRecorderStatus"

// DescribeConfigurationRecorderStatusRequest returns a request value for making API operation for
// AWS Config.
//
// Returns the current status of the specified configuration recorder. If a
// configuration recorder is not specified, this action returns the status of
// all configuration recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
//    // Example sending a request using DescribeConfigurationRecorderStatusRequest.
//    req := client.DescribeConfigurationRecorderStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *Client) DescribeConfigurationRecorderStatusRequest(input *DescribeConfigurationRecorderStatusInput) DescribeConfigurationRecorderStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeConfigurationRecorderStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecorderStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigurationRecorderStatusOutput{})
	return DescribeConfigurationRecorderStatusRequest{Request: req, Input: input, Copy: c.DescribeConfigurationRecorderStatusRequest}
}

// DescribeConfigurationRecorderStatusRequest is the request type for the
// DescribeConfigurationRecorderStatus API operation.
type DescribeConfigurationRecorderStatusRequest struct {
	*aws.Request
	Input *DescribeConfigurationRecorderStatusInput
	Copy  func(*DescribeConfigurationRecorderStatusInput) DescribeConfigurationRecorderStatusRequest
}

// Send marshals and sends the DescribeConfigurationRecorderStatus API request.
func (r DescribeConfigurationRecorderStatusRequest) Send(ctx context.Context) (*DescribeConfigurationRecorderStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigurationRecorderStatusResponse{
		DescribeConfigurationRecorderStatusOutput: r.Request.Data.(*DescribeConfigurationRecorderStatusOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigurationRecorderStatusResponse is the response type for the
// DescribeConfigurationRecorderStatus API operation.
type DescribeConfigurationRecorderStatusResponse struct {
	*DescribeConfigurationRecorderStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfigurationRecorderStatus request.
func (r *DescribeConfigurationRecorderStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
