// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeBackupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the backup.
	//
	// BackupArn is a required field
	BackupArn *string `min:"37" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBackupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeBackupInput"}

	if s.BackupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupArn"))
	}
	if s.BackupArn != nil && len(*s.BackupArn) < 37 {
		invalidParams.Add(aws.NewErrParamMinLen("BackupArn", 37))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeBackupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the description of the backup created for the table.
	BackupDescription *BackupDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeBackupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeBackup = "DescribeBackup"

// DescribeBackupRequest returns a request value for making API operation for
// Amazon DynamoDB.
//
// Describes an existing backup of a table.
//
// You can call DescribeBackup at a maximum rate of 10 times per second.
//
//    // Example sending a request using DescribeBackupRequest.
//    req := client.DescribeBackupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeBackup
func (c *Client) DescribeBackupRequest(input *DescribeBackupInput) DescribeBackupRequest {
	op := &aws.Operation{
		Name:       opDescribeBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBackupInput{}
	}

	req := c.newRequest(op, input, &DescribeBackupOutput{})
	return DescribeBackupRequest{Request: req, Input: input, Copy: c.DescribeBackupRequest}
}

// DescribeBackupRequest is the request type for the
// DescribeBackup API operation.
type DescribeBackupRequest struct {
	*aws.Request
	Input *DescribeBackupInput
	Copy  func(*DescribeBackupInput) DescribeBackupRequest
}

// Send marshals and sends the DescribeBackup API request.
func (r DescribeBackupRequest) Send(ctx context.Context) (*DescribeBackupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBackupResponse{
		DescribeBackupOutput: r.Request.Data.(*DescribeBackupOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBackupResponse is the response type for the
// DescribeBackup API operation.
type DescribeBackupResponse struct {
	*DescribeBackupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBackup request.
func (r *DescribeBackupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
