// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartLifecyclePolicyPreviewInput struct {
	_ struct{} `type:"structure"`

	// The policy to be evaluated against. If you do not specify a policy, the current
	// policy for the repository is used.
	LifecyclePolicyText *string `locationName:"lifecyclePolicyText" min:"100" type:"string"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to be evaluated.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s StartLifecyclePolicyPreviewInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartLifecyclePolicyPreviewInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartLifecyclePolicyPreviewInput"}
	if s.LifecyclePolicyText != nil && len(*s.LifecyclePolicyText) < 100 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecyclePolicyText", 100))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartLifecyclePolicyPreviewOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text.
	LifecyclePolicyText *string `locationName:"lifecyclePolicyText" min:"100" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The status of the lifecycle policy preview request.
	Status LifecyclePolicyPreviewStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s StartLifecyclePolicyPreviewOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartLifecyclePolicyPreview = "StartLifecyclePolicyPreview"

// StartLifecyclePolicyPreviewRequest returns a request value for making API operation for
// Amazon EC2 Container Registry.
//
// Starts a preview of the specified lifecycle policy. This allows you to see
// the results before creating the lifecycle policy.
//
//    // Example sending a request using StartLifecyclePolicyPreviewRequest.
//    req := client.StartLifecyclePolicyPreviewRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartLifecyclePolicyPreview
func (c *Client) StartLifecyclePolicyPreviewRequest(input *StartLifecyclePolicyPreviewInput) StartLifecyclePolicyPreviewRequest {
	op := &aws.Operation{
		Name:       opStartLifecyclePolicyPreview,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartLifecyclePolicyPreviewInput{}
	}

	req := c.newRequest(op, input, &StartLifecyclePolicyPreviewOutput{})
	return StartLifecyclePolicyPreviewRequest{Request: req, Input: input, Copy: c.StartLifecyclePolicyPreviewRequest}
}

// StartLifecyclePolicyPreviewRequest is the request type for the
// StartLifecyclePolicyPreview API operation.
type StartLifecyclePolicyPreviewRequest struct {
	*aws.Request
	Input *StartLifecyclePolicyPreviewInput
	Copy  func(*StartLifecyclePolicyPreviewInput) StartLifecyclePolicyPreviewRequest
}

// Send marshals and sends the StartLifecyclePolicyPreview API request.
func (r StartLifecyclePolicyPreviewRequest) Send(ctx context.Context) (*StartLifecyclePolicyPreviewResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartLifecyclePolicyPreviewResponse{
		StartLifecyclePolicyPreviewOutput: r.Request.Data.(*StartLifecyclePolicyPreviewOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartLifecyclePolicyPreviewResponse is the response type for the
// StartLifecyclePolicyPreview API operation.
type StartLifecyclePolicyPreviewResponse struct {
	*StartLifecyclePolicyPreviewOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartLifecyclePolicyPreview request.
func (r *StartLifecyclePolicyPreviewResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
