// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/elasticache"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// AddTagsToResource
//
// Adds up to 10 tags, key/value pairs, to a cluster or snapshot resource.
func ExampleClient_AddTagsToResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.AddTagsToResourceInput{
		ResourceName: aws.String("arn:aws:elasticache:us-east-1:1234567890:cluster:my-mem-cluster"),
		Tags: []elasticache.Tag{
			{
				Key:   aws.String("APIVersion"),
				Value: aws.String("20150202"),
			},
			{
				Key:   aws.String("Service"),
				Value: aws.String("ElastiCache"),
			},
		},
	}

	req := svc.AddTagsToResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeSnapshotNotFoundFault:
				fmt.Println(elasticache.ErrCodeSnapshotNotFoundFault, aerr.Error())
			case elasticache.ErrCodeTagQuotaPerResourceExceeded:
				fmt.Println(elasticache.ErrCodeTagQuotaPerResourceExceeded, aerr.Error())
			case elasticache.ErrCodeInvalidARNFault:
				fmt.Println(elasticache.ErrCodeInvalidARNFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// AuthorizeCacheCacheSecurityGroupIngress
//
// Allows network ingress to a cache security group. Applications using ElastiCache
// must be running on Amazon EC2. Amazon EC2 security groups are used as the authorization
// mechanism.
func ExampleClient_AuthorizeCacheSecurityGroupIngressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.AuthorizeCacheSecurityGroupIngressInput{
		CacheSecurityGroupName:  aws.String("my-sec-grp"),
		EC2SecurityGroupName:    aws.String("my-ec2-sec-grp"),
		EC2SecurityGroupOwnerId: aws.String("1234567890"),
	}

	req := svc.AuthorizeCacheSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheSecurityGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheSecurityGroupStateFault, aerr.Error())
			case elasticache.ErrCodeAuthorizationAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeAuthorizationAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CopySnapshot
//
// Copies a snapshot to a specified name.
func ExampleClient_CopySnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CopySnapshotInput{
		SourceSnapshotName: aws.String("my-snapshot"),
		TargetBucket:       aws.String(""),
		TargetSnapshotName: aws.String("my-snapshot-copy"),
	}

	req := svc.CopySnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeSnapshotAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeSnapshotAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeSnapshotNotFoundFault:
				fmt.Println(elasticache.ErrCodeSnapshotNotFoundFault, aerr.Error())
			case elasticache.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidSnapshotStateFault:
				fmt.Println(elasticache.ErrCodeInvalidSnapshotStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateCacheCluster
//
// Creates a Memcached cluster with 2 nodes.
func ExampleClient_CreateCacheClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateCacheClusterInput{
		AZMode:               elasticache.AZModeCrossAz,
		CacheClusterId:       aws.String("my-memcached-cluster"),
		CacheNodeType:        aws.String("cache.r3.large"),
		CacheSubnetGroupName: aws.String("default"),
		Engine:               aws.String("memcached"),
		EngineVersion:        aws.String("1.4.24"),
		NumCacheNodes:        aws.Int64(2),
		Port:                 aws.Int64(11211),
	}

	req := svc.CreateCacheClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeCacheClusterAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeInsufficientCacheClusterCapacityFault:
				fmt.Println(elasticache.ErrCodeInsufficientCacheClusterCapacityFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeClusterQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeClusterQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForClusterExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForClusterExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(elasticache.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case elasticache.ErrCodeTagQuotaPerResourceExceeded:
				fmt.Println(elasticache.ErrCodeTagQuotaPerResourceExceeded, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateCacheCluster
//
// Creates a Redis cluster with 1 node.
func ExampleClient_CreateCacheClusterRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateCacheClusterInput{
		AutoMinorVersionUpgrade:   aws.Bool(true),
		CacheClusterId:            aws.String("my-redis"),
		CacheNodeType:             aws.String("cache.r3.larage"),
		CacheSubnetGroupName:      aws.String("default"),
		Engine:                    aws.String("redis"),
		EngineVersion:             aws.String("3.2.4"),
		NumCacheNodes:             aws.Int64(1),
		Port:                      aws.Int64(6379),
		PreferredAvailabilityZone: aws.String("us-east-1c"),
		SnapshotRetentionLimit:    aws.Int64(7),
	}

	req := svc.CreateCacheClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeCacheClusterAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeInsufficientCacheClusterCapacityFault:
				fmt.Println(elasticache.ErrCodeInsufficientCacheClusterCapacityFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeClusterQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeClusterQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForClusterExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForClusterExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(elasticache.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case elasticache.ErrCodeTagQuotaPerResourceExceeded:
				fmt.Println(elasticache.ErrCodeTagQuotaPerResourceExceeded, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateCacheParameterGroup
//
// Creates the Amazon ElastiCache parameter group custom-redis2-8.
func ExampleClient_CreateCacheParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateCacheParameterGroupInput{
		CacheParameterGroupFamily: aws.String("redis2.8"),
		CacheParameterGroupName:   aws.String("custom-redis2-8"),
		Description:               aws.String("Custom Redis 2.8 parameter group."),
	}

	req := svc.CreateCacheParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheParameterGroupQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheParameterGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheParameterGroupStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateCacheSecurityGroup
//
// Creates an ElastiCache security group. ElastiCache security groups are only for clusters
// not running in an AWS VPC.
func ExampleClient_CreateCacheSecurityGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateCacheSecurityGroupInput{
		CacheSecurityGroupName: aws.String("my-cache-sec-grp"),
		Description:            aws.String("Example ElastiCache security group."),
	}

	req := svc.CreateCacheSecurityGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSecurityGroupAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateCacheSubnet
//
// Creates a new cache subnet group.
func ExampleClient_CreateCacheSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateCacheSubnetGroupInput{
		CacheSubnetGroupDescription: aws.String("Sample subnet group"),
		CacheSubnetGroupName:        aws.String("my-sn-grp2"),
		SubnetIds: []string{
			"subnet-6f28c982",
			"subnet-bcd382f3",
			"subnet-845b3e7c0",
		},
	}

	req := svc.CreateCacheSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSubnetGroupAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetGroupQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidSubnet:
				fmt.Println(elasticache.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateCacheReplicationGroup
//
// Creates a Redis replication group with 3 nodes.
func ExampleClient_CreateReplicationGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateReplicationGroupInput{
		AutomaticFailoverEnabled:    aws.Bool(true),
		CacheNodeType:               aws.String("cache.m3.medium"),
		Engine:                      aws.String("redis"),
		EngineVersion:               aws.String("2.8.24"),
		NumCacheClusters:            aws.Int64(3),
		ReplicationGroupDescription: aws.String("A Redis replication group."),
		ReplicationGroupId:          aws.String("my-redis-rg"),
		SnapshotRetentionLimit:      aws.Int64(30),
	}

	req := svc.CreateReplicationGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeInsufficientCacheClusterCapacityFault:
				fmt.Println(elasticache.ErrCodeInsufficientCacheClusterCapacityFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeClusterQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeClusterQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForClusterExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForClusterExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(elasticache.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case elasticache.ErrCodeTagQuotaPerResourceExceeded:
				fmt.Println(elasticache.ErrCodeTagQuotaPerResourceExceeded, aerr.Error())
			case elasticache.ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateReplicationGroup
//
// Creates a Redis (cluster mode enabled) replication group with two shards. One shard
// has one read replica node and the other shard has two read replicas.
func ExampleClient_CreateReplicationGroupRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateReplicationGroupInput{
		AutoMinorVersionUpgrade: aws.Bool(true),
		CacheNodeType:           aws.String("cache.m3.medium"),
		CacheParameterGroupName: aws.String("default.redis3.2.cluster.on"),
		Engine:                  aws.String("redis"),
		EngineVersion:           aws.String("3.2.4"),
		NodeGroupConfiguration: []elasticache.NodeGroupConfiguration{
			{
				PrimaryAvailabilityZone: aws.String("us-east-1c"),
				ReplicaAvailabilityZones: []string{
					"us-east-1b",
				},
				ReplicaCount: aws.Int64(1),
				Slots:        aws.String("0-8999"),
			},
			{
				PrimaryAvailabilityZone: aws.String("us-east-1a"),
				ReplicaAvailabilityZones: []string{
					"us-east-1a",
					"us-east-1c",
				},
				ReplicaCount: aws.Int64(2),
				Slots:        aws.String("9000-16383"),
			},
		},
		NumNodeGroups:               aws.Int64(2),
		ReplicationGroupDescription: aws.String("A multi-sharded replication group"),
		ReplicationGroupId:          aws.String("clustered-redis-rg"),
		SnapshotRetentionLimit:      aws.Int64(8),
	}

	req := svc.CreateReplicationGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeInsufficientCacheClusterCapacityFault:
				fmt.Println(elasticache.ErrCodeInsufficientCacheClusterCapacityFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeClusterQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeClusterQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForClusterExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForClusterExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(elasticache.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case elasticache.ErrCodeTagQuotaPerResourceExceeded:
				fmt.Println(elasticache.ErrCodeTagQuotaPerResourceExceeded, aerr.Error())
			case elasticache.ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeNodeGroupsPerReplicationGroupQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateSnapshot - NonClustered Redis, no read-replicas
//
// Creates a snapshot of a non-clustered Redis cluster that has only one node.
func ExampleClient_CreateSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateSnapshotInput{
		CacheClusterId: aws.String("onenoderedis"),
		SnapshotName:   aws.String("snapshot-1"),
	}

	req := svc.CreateSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeSnapshotAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeSnapshotAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeSnapshotFeatureNotSupportedFault:
				fmt.Println(elasticache.ErrCodeSnapshotFeatureNotSupportedFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateSnapshot - NonClustered Redis, 2 read-replicas
//
// Creates a snapshot of a non-clustered Redis cluster that has only three nodes, primary
// and two read-replicas. CacheClusterId must be a specific node in the cluster.
func ExampleClient_CreateSnapshotRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateSnapshotInput{
		CacheClusterId: aws.String("threenoderedis-001"),
		SnapshotName:   aws.String("snapshot-2"),
	}

	req := svc.CreateSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeSnapshotAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeSnapshotAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeSnapshotFeatureNotSupportedFault:
				fmt.Println(elasticache.ErrCodeSnapshotFeatureNotSupportedFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// CreateSnapshot-clustered Redis
//
// Creates a snapshot of a clustered Redis cluster that has 2 shards, each with a primary
// and 4 read-replicas.
func ExampleClient_CreateSnapshotRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.CreateSnapshotInput{
		ReplicationGroupId: aws.String("clusteredredis"),
		SnapshotName:       aws.String("snapshot-2x5"),
	}

	req := svc.CreateSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeSnapshotAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeSnapshotAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeSnapshotFeatureNotSupportedFault:
				fmt.Println(elasticache.ErrCodeSnapshotFeatureNotSupportedFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteCacheCluster
//
// Deletes an Amazon ElastiCache cluster.
func ExampleClient_DeleteCacheClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DeleteCacheClusterInput{
		CacheClusterId: aws.String("my-memcached"),
	}

	req := svc.DeleteCacheClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeSnapshotAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeSnapshotAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeSnapshotFeatureNotSupportedFault:
				fmt.Println(elasticache.ErrCodeSnapshotFeatureNotSupportedFault, aerr.Error())
			case elasticache.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteCacheParameterGroup
//
// Deletes the Amazon ElastiCache parameter group custom-mem1-4.
func ExampleClient_DeleteCacheParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DeleteCacheParameterGroupInput{
		CacheParameterGroupName: aws.String("custom-mem1-4"),
	}

	req := svc.DeleteCacheParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidCacheParameterGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheParameterGroupStateFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteCacheSecurityGroup
//
// Deletes a cache security group.
func ExampleClient_DeleteCacheSecurityGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DeleteCacheSecurityGroupInput{
		CacheSecurityGroupName: aws.String("my-sec-group"),
	}

	req := svc.DeleteCacheSecurityGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidCacheSecurityGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheSecurityGroupStateFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteCacheSubnetGroup
//
// Deletes the Amazon ElastiCache subnet group my-subnet-group.
func ExampleClient_DeleteCacheSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DeleteCacheSubnetGroupInput{
		CacheSubnetGroupName: aws.String("my-subnet-group"),
	}

	req := svc.DeleteCacheSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSubnetGroupInUse:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupInUse, aerr.Error())
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteReplicationGroup
//
// Deletes the Amazon ElastiCache replication group my-redis-rg.
func ExampleClient_DeleteReplicationGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DeleteReplicationGroupInput{
		ReplicationGroupId:   aws.String("my-redis-rg"),
		RetainPrimaryCluster: aws.Bool(false),
	}

	req := svc.DeleteReplicationGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeSnapshotAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeSnapshotAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeSnapshotFeatureNotSupportedFault:
				fmt.Println(elasticache.ErrCodeSnapshotFeatureNotSupportedFault, aerr.Error())
			case elasticache.ErrCodeSnapshotQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeSnapshotQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DeleteSnapshot
//
// Deletes the Redis snapshot snapshot-20160822.
func ExampleClient_DeleteSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DeleteSnapshotInput{
		SnapshotName: aws.String("snapshot-20161212"),
	}

	req := svc.DeleteSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeSnapshotNotFoundFault:
				fmt.Println(elasticache.ErrCodeSnapshotNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidSnapshotStateFault:
				fmt.Println(elasticache.ErrCodeInvalidSnapshotStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheClusters
//
// Lists the details for up to 50 cache clusters.
func ExampleClient_DescribeCacheClustersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheClustersInput{
		CacheClusterId: aws.String("my-mem-cluster"),
	}

	req := svc.DescribeCacheClustersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheClusters
//
// Lists the details for the cache cluster my-mem-cluster.
func ExampleClient_DescribeCacheClustersRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheClustersInput{
		CacheClusterId:    aws.String("my-mem-cluster"),
		ShowCacheNodeInfo: aws.Bool(true),
	}

	req := svc.DescribeCacheClustersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheEngineVersions
//
// Lists the details for up to 25 Memcached and Redis cache engine versions.
func ExampleClient_DescribeCacheEngineVersionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheEngineVersionsInput{}

	req := svc.DescribeCacheEngineVersionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheEngineVersions
//
// Lists the details for up to 50 Redis cache engine versions.
func ExampleClient_DescribeCacheEngineVersionsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheEngineVersionsInput{
		DefaultOnly: aws.Bool(false),
		Engine:      aws.String("redis"),
		MaxRecords:  aws.Int64(50),
	}

	req := svc.DescribeCacheEngineVersionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheParameterGroups
//
// Returns a list of cache parameter group descriptions. If a cache parameter group
// name is specified, the list contains only the descriptions for that group.
func ExampleClient_DescribeCacheParameterGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheParameterGroupsInput{
		CacheParameterGroupName: aws.String("custom-mem1-4"),
	}

	req := svc.DescribeCacheParameterGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheParameters
//
// Lists up to 100 user parameter values for the parameter group custom.redis2.8.
func ExampleClient_DescribeCacheParametersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheParametersInput{
		CacheParameterGroupName: aws.String("custom-redis2-8"),
		MaxRecords:              aws.Int64(100),
		Source:                  aws.String("user"),
	}

	req := svc.DescribeCacheParametersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheSecurityGroups
//
// Returns a list of cache security group descriptions. If a cache security group name
// is specified, the list contains only the description of that group.
func ExampleClient_DescribeCacheSecurityGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheSecurityGroupsInput{
		CacheSecurityGroupName: aws.String("my-sec-group"),
	}

	req := svc.DescribeCacheSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheSubnetGroups
//
// Describes up to 25 cache subnet groups.
func ExampleClient_DescribeCacheSubnetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeCacheSubnetGroupsInput{
		MaxRecords: aws.Int64(25),
	}

	req := svc.DescribeCacheSubnetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEngineDefaultParameters
//
// Returns the default engine and system parameter information for the specified cache
// engine.
func ExampleClient_DescribeEngineDefaultParametersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeEngineDefaultParametersInput{
		CacheParameterGroupFamily: aws.String("redis2.8"),
		MaxRecords:                aws.Int64(25),
	}

	req := svc.DescribeEngineDefaultParametersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEvents
//
// Describes all the cache-cluster events for the past 120 minutes.
func ExampleClient_DescribeEventsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeEventsInput{
		Duration:   aws.Int64(360),
		SourceType: elasticache.SourceTypeCacheCluster,
	}

	req := svc.DescribeEventsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeEvents
//
// Describes all the replication-group events from 3:00P to 5:00P on November 11, 2016.
func ExampleClient_DescribeEventsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeEventsInput{
		StartTime: parseTime("2006-01-02T15:04:05Z", "2016-12-22T15:00:00.000Z"),
	}

	req := svc.DescribeEventsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeReplicationGroups
//
// Returns information about the replication group myreplgroup.
func ExampleClient_DescribeReplicationGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeReplicationGroupsInput{}

	req := svc.DescribeReplicationGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeReservedCacheNodes
//
// Returns information about reserved cache nodes for this account, or about a specified
// reserved cache node. If the account has no reserved cache nodes, the operation returns
// an empty list, as shown here.
func ExampleClient_DescribeReservedCacheNodesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeReservedCacheNodesInput{
		MaxRecords: aws.Int64(25),
	}

	req := svc.DescribeReservedCacheNodesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReservedCacheNodeNotFoundFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodeNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeReseredCacheNodeOfferings
//
// Lists available reserved cache node offerings.
func ExampleClient_DescribeReservedCacheNodesOfferingsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeReservedCacheNodesOfferingsInput{
		MaxRecords: aws.Int64(20),
	}

	req := svc.DescribeReservedCacheNodesOfferingsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeReseredCacheNodeOfferings
//
// Lists available reserved cache node offerings for cache.r3.large nodes with a 3 year
// commitment.
func ExampleClient_DescribeReservedCacheNodesOfferingsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeReservedCacheNodesOfferingsInput{
		CacheNodeType:                aws.String("cache.r3.large"),
		Duration:                     aws.String("3"),
		MaxRecords:                   aws.Int64(25),
		OfferingType:                 aws.String("Light Utilization"),
		ReservedCacheNodesOfferingId: aws.String(""),
	}

	req := svc.DescribeReservedCacheNodesOfferingsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeReseredCacheNodeOfferings
//
// Lists available reserved cache node offerings.
func ExampleClient_DescribeReservedCacheNodesOfferingsRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeReservedCacheNodesOfferingsInput{
		CacheNodeType:                aws.String(""),
		Duration:                     aws.String(""),
		Marker:                       aws.String(""),
		MaxRecords:                   aws.Int64(25),
		OfferingType:                 aws.String(""),
		ProductDescription:           aws.String(""),
		ReservedCacheNodesOfferingId: aws.String("438012d3-4052-4cc7-b2e3-8d3372e0e706"),
	}

	req := svc.DescribeReservedCacheNodesOfferingsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeSnapshots
//
// Returns information about the snapshot mysnapshot. By default.
func ExampleClient_DescribeSnapshotsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.DescribeSnapshotsInput{
		SnapshotName: aws.String("snapshot-20161212"),
	}

	req := svc.DescribeSnapshotsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeSnapshotNotFoundFault:
				fmt.Println(elasticache.ErrCodeSnapshotNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ListAllowedNodeTypeModifications
//
// Lists all available node types that you can scale your Redis cluster's or replication
// group's current node type up to.
func ExampleClient_ListAllowedNodeTypeModificationsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ListAllowedNodeTypeModificationsInput{
		ReplicationGroupId: aws.String("myreplgroup"),
	}

	req := svc.ListAllowedNodeTypeModificationsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ListAllowedNodeTypeModifications
//
// Lists all available node types that you can scale your Redis cluster's or replication
// group's current node type up to.
func ExampleClient_ListAllowedNodeTypeModificationsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ListAllowedNodeTypeModificationsInput{
		CacheClusterId: aws.String("mycluster"),
	}

	req := svc.ListAllowedNodeTypeModificationsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ListTagsForResource
//
// Lists all cost allocation tags currently on the named resource. A cost allocation
// tag is a key-value pair where the key is case-sensitive and the value is optional.
// You can use cost allocation tags to categorize and track your AWS costs.
func ExampleClient_ListTagsForResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ListTagsForResourceInput{
		ResourceName: aws.String("arn:aws:elasticache:us-west-2:<my-account-id>:cluster:mycluster"),
	}

	req := svc.ListTagsForResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeSnapshotNotFoundFault:
				fmt.Println(elasticache.ErrCodeSnapshotNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidARNFault:
				fmt.Println(elasticache.ErrCodeInvalidARNFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ModifyCacheCluster
//
// Copies a snapshot to a specified name.
func ExampleClient_ModifyCacheClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ModifyCacheClusterInput{
		ApplyImmediately:       aws.Bool(true),
		CacheClusterId:         aws.String("redis-cluster"),
		SnapshotRetentionLimit: aws.Int64(14),
	}

	req := svc.ModifyCacheClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheSecurityGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheSecurityGroupStateFault, aerr.Error())
			case elasticache.ErrCodeInsufficientCacheClusterCapacityFault:
				fmt.Println(elasticache.ErrCodeInsufficientCacheClusterCapacityFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForClusterExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForClusterExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(elasticache.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ModifyCacheParameterGroup
//
// Modifies one or more parameter values in the specified parameter group. You cannot
// modify any default parameter group.
func ExampleClient_ModifyCacheParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ModifyCacheParameterGroupInput{
		CacheParameterGroupName: aws.String("custom-mem1-4"),
		ParameterNameValues: []elasticache.ParameterNameValue{
			{
				ParameterName:  aws.String("binding_protocol"),
				ParameterValue: aws.String("ascii"),
			},
			{
				ParameterName:  aws.String("chunk_size"),
				ParameterValue: aws.String("96"),
			},
		},
	}

	req := svc.ModifyCacheParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheParameterGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheParameterGroupStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ModifyCacheSubnetGroup
//
// Modifies an existing ElastiCache subnet group.
func ExampleClient_ModifyCacheSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ModifyCacheSubnetGroupInput{
		CacheSubnetGroupName: aws.String("my-sn-grp"),
		SubnetIds: []string{
			"subnet-bcde2345",
		},
	}

	req := svc.ModifyCacheSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSubnetGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheSubnetQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeCacheSubnetQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeSubnetInUse:
				fmt.Println(elasticache.ErrCodeSubnetInUse, aerr.Error())
			case elasticache.ErrCodeInvalidSubnet:
				fmt.Println(elasticache.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ModifyReplicationGroup
//

func ExampleClient_ModifyReplicationGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ModifyReplicationGroupInput{
		ApplyImmediately:            aws.Bool(true),
		ReplicationGroupDescription: aws.String("Modified replication group"),
		ReplicationGroupId:          aws.String("my-redis-rg"),
		SnapshotRetentionLimit:      aws.Int64(30),
		SnapshottingClusterId:       aws.String("my-redis-rg-001"),
	}

	req := svc.ModifyReplicationGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReplicationGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeReplicationGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidReplicationGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidReplicationGroupStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheSecurityGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheSecurityGroupStateFault, aerr.Error())
			case elasticache.ErrCodeInsufficientCacheClusterCapacityFault:
				fmt.Println(elasticache.ErrCodeInsufficientCacheClusterCapacityFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForClusterExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForClusterExceededFault, aerr.Error())
			case elasticache.ErrCodeNodeQuotaForCustomerExceededFault:
				fmt.Println(elasticache.ErrCodeNodeQuotaForCustomerExceededFault, aerr.Error())
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidVPCNetworkStateFault:
				fmt.Println(elasticache.ErrCodeInvalidVPCNetworkStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidKMSKeyFault:
				fmt.Println(elasticache.ErrCodeInvalidKMSKeyFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// PurchaseReservedCacheNodesOfferings
//
// Allows you to purchase a reserved cache node offering.
func ExampleClient_PurchaseReservedCacheNodesOfferingRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.PurchaseReservedCacheNodesOfferingInput{
		ReservedCacheNodesOfferingId: aws.String("1ef01f5b-94ff-433f-a530-61a56bfc8e7a"),
	}

	req := svc.PurchaseReservedCacheNodesOfferingRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodesOfferingNotFoundFault, aerr.Error())
			case elasticache.ErrCodeReservedCacheNodeAlreadyExistsFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodeAlreadyExistsFault, aerr.Error())
			case elasticache.ErrCodeReservedCacheNodeQuotaExceededFault:
				fmt.Println(elasticache.ErrCodeReservedCacheNodeQuotaExceededFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// RebootCacheCluster
//
// Reboots the specified nodes in the names cluster.
func ExampleClient_RebootCacheClusterRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.RebootCacheClusterInput{
		CacheClusterId: aws.String("custom-mem1-4  "),
		CacheNodeIdsToReboot: []string{
			"0001",
			"0002",
		},
	}

	req := svc.RebootCacheClusterRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidCacheClusterStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheClusterStateFault, aerr.Error())
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// RemoveTagsFromResource
//
// Removes tags identified by a list of tag keys from the list of tags on the specified
// resource.
func ExampleClient_RemoveTagsFromResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.RemoveTagsFromResourceInput{
		ResourceName: aws.String("arn:aws:elasticache:us-east-1:1234567890:cluster:my-mem-cluster"),
		TagKeys: []string{
			"A",
			"C",
			"E",
		},
	}

	req := svc.RemoveTagsFromResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheClusterNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheClusterNotFoundFault, aerr.Error())
			case elasticache.ErrCodeSnapshotNotFoundFault:
				fmt.Println(elasticache.ErrCodeSnapshotNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidARNFault:
				fmt.Println(elasticache.ErrCodeInvalidARNFault, aerr.Error())
			case elasticache.ErrCodeTagNotFoundFault:
				fmt.Println(elasticache.ErrCodeTagNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ResetCacheParameterGroup
//
// Modifies the parameters of a cache parameter group to the engine or system default
// value.
func ExampleClient_ResetCacheParameterGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.ResetCacheParameterGroupInput{
		CacheParameterGroupName: aws.String("custom-mem1-4"),
		ResetAllParameters:      aws.Bool(true),
	}

	req := svc.ResetCacheParameterGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeInvalidCacheParameterGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheParameterGroupStateFault, aerr.Error())
			case elasticache.ErrCodeCacheParameterGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheParameterGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// DescribeCacheSecurityGroups
//
// Returns a list of cache security group descriptions. If a cache security group name
// is specified, the list contains only the description of that group.
func ExampleClient_RevokeCacheSecurityGroupIngressRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticache.New(cfg)
	input := &elasticache.RevokeCacheSecurityGroupIngressInput{
		CacheSecurityGroupName:  aws.String("my-sec-grp"),
		EC2SecurityGroupName:    aws.String("my-ec2-sec-grp"),
		EC2SecurityGroupOwnerId: aws.String("1234567890"),
	}

	req := svc.RevokeCacheSecurityGroupIngressRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticache.ErrCodeCacheSecurityGroupNotFoundFault:
				fmt.Println(elasticache.ErrCodeCacheSecurityGroupNotFoundFault, aerr.Error())
			case elasticache.ErrCodeAuthorizationNotFoundFault:
				fmt.Println(elasticache.ErrCodeAuthorizationNotFoundFault, aerr.Error())
			case elasticache.ErrCodeInvalidCacheSecurityGroupStateFault:
				fmt.Println(elasticache.ErrCodeInvalidCacheSecurityGroupStateFault, aerr.Error())
			case elasticache.ErrCodeInvalidParameterValueException:
				fmt.Println(elasticache.ErrCodeInvalidParameterValueException, aerr.Error())
			case elasticache.ErrCodeInvalidParameterCombinationException:
				fmt.Println(elasticache.ErrCodeInvalidParameterCombinationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
