// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDatasetGroupInput"}

	if s.DatasetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// When the dataset group was created.
	CreationTime *time.Time `type:"timestamp"`

	// An array of Amazon Resource Names (ARNs) of the datasets contained in the
	// dataset group.
	DatasetArns []string `type:"list"`

	// The ARN of the dataset group.
	DatasetGroupArn *string `type:"string"`

	// The name of the dataset group.
	DatasetGroupName *string `min:"1" type:"string"`

	// The domain associated with the dataset group.
	Domain Domain `type:"string" enum:"true"`

	// When the dataset group was created or last updated from a call to the UpdateDatasetGroup
	// operation. While the dataset group is being updated, LastModificationTime
	// is the current time of the DescribeDatasetGroup call.
	LastModificationTime *time.Time `type:"timestamp"`

	// The status of the dataset group. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The UPDATE states apply when you call the UpdateDatasetGroup operation.
	//
	// The Status of the dataset group must be ACTIVE before you can use the dataset
	// group to create a predictor.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDatasetGroup = "DescribeDatasetGroup"

// DescribeDatasetGroupRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Describes a dataset group created using the CreateDatasetGroup operation.
//
// In addition to listing the parameters provided in the CreateDatasetGroup
// request, this operation includes the following properties:
//
//    * DatasetArns - The datasets belonging to the group.
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
//    // Example sending a request using DescribeDatasetGroupRequest.
//    req := client.DescribeDatasetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeDatasetGroup
func (c *Client) DescribeDatasetGroupRequest(input *DescribeDatasetGroupInput) DescribeDatasetGroupRequest {
	op := &aws.Operation{
		Name:       opDescribeDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetGroupInput{}
	}

	req := c.newRequest(op, input, &DescribeDatasetGroupOutput{})
	return DescribeDatasetGroupRequest{Request: req, Input: input, Copy: c.DescribeDatasetGroupRequest}
}

// DescribeDatasetGroupRequest is the request type for the
// DescribeDatasetGroup API operation.
type DescribeDatasetGroupRequest struct {
	*aws.Request
	Input *DescribeDatasetGroupInput
	Copy  func(*DescribeDatasetGroupInput) DescribeDatasetGroupRequest
}

// Send marshals and sends the DescribeDatasetGroup API request.
func (r DescribeDatasetGroupRequest) Send(ctx context.Context) (*DescribeDatasetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDatasetGroupResponse{
		DescribeDatasetGroupOutput: r.Request.Data.(*DescribeDatasetGroupOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDatasetGroupResponse is the response type for the
// DescribeDatasetGroup API operation.
type DescribeDatasetGroupResponse struct {
	*DescribeDatasetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDatasetGroup request.
func (r *DescribeDatasetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
