// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateDeviceDefinitionInput struct {
	_ struct{} `type:"structure"`

	// DeviceDefinitionId is a required field
	DeviceDefinitionId *string `location:"uri" locationName:"DeviceDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateDeviceDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDeviceDefinitionInput"}

	if s.DeviceDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDeviceDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceDefinitionId != nil {
		v := *s.DeviceDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DeviceDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateDeviceDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDeviceDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateDeviceDefinition = "UpdateDeviceDefinition"

// UpdateDeviceDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Updates a device definition.
//
//    // Example sending a request using UpdateDeviceDefinitionRequest.
//    req := client.UpdateDeviceDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition
func (c *Client) UpdateDeviceDefinitionRequest(input *UpdateDeviceDefinitionInput) UpdateDeviceDefinitionRequest {
	op := &aws.Operation{
		Name:       opUpdateDeviceDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/devices/{DeviceDefinitionId}",
	}

	if input == nil {
		input = &UpdateDeviceDefinitionInput{}
	}

	req := c.newRequest(op, input, &UpdateDeviceDefinitionOutput{})
	return UpdateDeviceDefinitionRequest{Request: req, Input: input, Copy: c.UpdateDeviceDefinitionRequest}
}

// UpdateDeviceDefinitionRequest is the request type for the
// UpdateDeviceDefinition API operation.
type UpdateDeviceDefinitionRequest struct {
	*aws.Request
	Input *UpdateDeviceDefinitionInput
	Copy  func(*UpdateDeviceDefinitionInput) UpdateDeviceDefinitionRequest
}

// Send marshals and sends the UpdateDeviceDefinition API request.
func (r UpdateDeviceDefinitionRequest) Send(ctx context.Context) (*UpdateDeviceDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDeviceDefinitionResponse{
		UpdateDeviceDefinitionOutput: r.Request.Data.(*UpdateDeviceDefinitionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDeviceDefinitionResponse is the response type for the
// UpdateDeviceDefinition API operation.
type UpdateDeviceDefinitionResponse struct {
	*UpdateDeviceDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDeviceDefinition request.
func (r *UpdateDeviceDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
