// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DisassociateFromMasterAccountInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the detector of the GuardDuty member account.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFromMasterAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateFromMasterAccountInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateFromMasterAccountInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DisassociateFromMasterAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFromMasterAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateFromMasterAccountOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisassociateFromMasterAccount = "DisassociateFromMasterAccount"

// DisassociateFromMasterAccountRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Disassociates the current GuardDuty member account from its master account.
//
//    // Example sending a request using DisassociateFromMasterAccountRequest.
//    req := client.DisassociateFromMasterAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount
func (c *Client) DisassociateFromMasterAccountRequest(input *DisassociateFromMasterAccountInput) DisassociateFromMasterAccountRequest {
	op := &aws.Operation{
		Name:       opDisassociateFromMasterAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/master/disassociate",
	}

	if input == nil {
		input = &DisassociateFromMasterAccountInput{}
	}

	req := c.newRequest(op, input, &DisassociateFromMasterAccountOutput{})
	return DisassociateFromMasterAccountRequest{Request: req, Input: input, Copy: c.DisassociateFromMasterAccountRequest}
}

// DisassociateFromMasterAccountRequest is the request type for the
// DisassociateFromMasterAccount API operation.
type DisassociateFromMasterAccountRequest struct {
	*aws.Request
	Input *DisassociateFromMasterAccountInput
	Copy  func(*DisassociateFromMasterAccountInput) DisassociateFromMasterAccountRequest
}

// Send marshals and sends the DisassociateFromMasterAccount API request.
func (r DisassociateFromMasterAccountRequest) Send(ctx context.Context) (*DisassociateFromMasterAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateFromMasterAccountResponse{
		DisassociateFromMasterAccountOutput: r.Request.Data.(*DisassociateFromMasterAccountOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateFromMasterAccountResponse is the response type for the
// DisassociateFromMasterAccount API operation.
type DisassociateFromMasterAccountResponse struct {
	*DisassociateFromMasterAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateFromMasterAccount request.
func (r *DisassociateFromMasterAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
