// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type RemoveUserFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to update.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the user to remove.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveUserFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveUserFromGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveUserFromGroupInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveUserFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveUserFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opRemoveUserFromGroup = "RemoveUserFromGroup"

// RemoveUserFromGroupRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Removes the specified user from the specified group.
//
//    // Example sending a request using RemoveUserFromGroupRequest.
//    req := client.RemoveUserFromGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroup
func (c *Client) RemoveUserFromGroupRequest(input *RemoveUserFromGroupInput) RemoveUserFromGroupRequest {
	op := &aws.Operation{
		Name:       opRemoveUserFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveUserFromGroupInput{}
	}

	req := c.newRequest(op, input, &RemoveUserFromGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RemoveUserFromGroupRequest{Request: req, Input: input, Copy: c.RemoveUserFromGroupRequest}
}

// RemoveUserFromGroupRequest is the request type for the
// RemoveUserFromGroup API operation.
type RemoveUserFromGroupRequest struct {
	*aws.Request
	Input *RemoveUserFromGroupInput
	Copy  func(*RemoveUserFromGroupInput) RemoveUserFromGroupRequest
}

// Send marshals and sends the RemoveUserFromGroup API request.
func (r RemoveUserFromGroupRequest) Send(ctx context.Context) (*RemoveUserFromGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveUserFromGroupResponse{
		RemoveUserFromGroupOutput: r.Request.Data.(*RemoveUserFromGroupOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveUserFromGroupResponse is the response type for the
// RemoveUserFromGroup API operation.
type RemoveUserFromGroupResponse struct {
	*RemoveUserFromGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveUserFromGroup request.
func (r *RemoveUserFromGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
