// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDistributionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token of the distribution configuration.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The distributions of the distribution configuration.
	//
	// Distributions is a required field
	Distributions []Distribution `locationName:"distributions" type:"list" required:"true"`

	// The name of the distribution configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The tags of the distribution configuration.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateDistributionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDistributionConfigurationInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Distributions == nil {
		invalidParams.Add(aws.NewErrParamRequired("Distributions"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Distributions != nil {
		for i, v := range s.Distributions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Distributions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDistributionConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Distributions != nil {
		v := s.Distributions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "distributions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateDistributionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The idempotency token used to make this request idempotent.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration that was
	// created by this request.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateDistributionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDistributionConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ClientToken != nil {
		v := *s.ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DistributionConfigurationArn != nil {
		v := *s.DistributionConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "distributionConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateDistributionConfiguration = "CreateDistributionConfiguration"

// CreateDistributionConfigurationRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Creates a new distribution configuration. Distribution configurations define
// and configure the outputs of your pipeline.
//
//    // Example sending a request using CreateDistributionConfigurationRequest.
//    req := client.CreateDistributionConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/CreateDistributionConfiguration
func (c *Client) CreateDistributionConfigurationRequest(input *CreateDistributionConfigurationInput) CreateDistributionConfigurationRequest {
	op := &aws.Operation{
		Name:       opCreateDistributionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/CreateDistributionConfiguration",
	}

	if input == nil {
		input = &CreateDistributionConfigurationInput{}
	}

	req := c.newRequest(op, input, &CreateDistributionConfigurationOutput{})
	return CreateDistributionConfigurationRequest{Request: req, Input: input, Copy: c.CreateDistributionConfigurationRequest}
}

// CreateDistributionConfigurationRequest is the request type for the
// CreateDistributionConfiguration API operation.
type CreateDistributionConfigurationRequest struct {
	*aws.Request
	Input *CreateDistributionConfigurationInput
	Copy  func(*CreateDistributionConfigurationInput) CreateDistributionConfigurationRequest
}

// Send marshals and sends the CreateDistributionConfiguration API request.
func (r CreateDistributionConfigurationRequest) Send(ctx context.Context) (*CreateDistributionConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDistributionConfigurationResponse{
		CreateDistributionConfigurationOutput: r.Request.Data.(*CreateDistributionConfigurationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDistributionConfigurationResponse is the response type for the
// CreateDistributionConfiguration API operation.
type CreateDistributionConfigurationResponse struct {
	*CreateDistributionConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDistributionConfiguration request.
func (r *CreateDistributionConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
