// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The number of the workflow revision to retrieve.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s GetFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFlowTemplateInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetFlowTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The object that describes the specified workflow.
	Description *FlowTemplateDescription `locationName:"description" type:"structure"`
}

// String returns the string representation
func (s GetFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetFlowTemplate = "GetFlowTemplate"

// GetFlowTemplateRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Gets the latest version of the DefinitionDocument and FlowTemplateSummary
// for the specified workflow.
//
//    // Example sending a request using GetFlowTemplateRequest.
//    req := client.GetFlowTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate
func (c *Client) GetFlowTemplateRequest(input *GetFlowTemplateInput) GetFlowTemplateRequest {
	op := &aws.Operation{
		Name:       opGetFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFlowTemplateInput{}
	}

	req := c.newRequest(op, input, &GetFlowTemplateOutput{})
	return GetFlowTemplateRequest{Request: req, Input: input, Copy: c.GetFlowTemplateRequest}
}

// GetFlowTemplateRequest is the request type for the
// GetFlowTemplate API operation.
type GetFlowTemplateRequest struct {
	*aws.Request
	Input *GetFlowTemplateInput
	Copy  func(*GetFlowTemplateInput) GetFlowTemplateRequest
}

// Send marshals and sends the GetFlowTemplate API request.
func (r GetFlowTemplateRequest) Send(ctx context.Context) (*GetFlowTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFlowTemplateResponse{
		GetFlowTemplateOutput: r.Request.Data.(*GetFlowTemplateOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFlowTemplateResponse is the response type for the
// GetFlowTemplate API operation.
type GetFlowTemplateResponse struct {
	*GetFlowTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFlowTemplate request.
func (r *GetFlowTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
