// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// An array of filter objects.
	FilterList []Filter `min:"1" type:"list"`

	// The maximum number of results returned by a single call. This value must
	// be provided in the next call to retrieve the next set of results. By default,
	// this value is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `min:"1" type:"string"`

	// An object that contains two attributes, sortBy and sortOrder.
	Sort *Sort `type:"structure"`
}

// String returns the string representation
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListChangeSetsInput"}

	if s.Catalog == nil {
		invalidParams.Add(aws.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Catalog", 1))
	}
	if s.FilterList != nil && len(s.FilterList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.FilterList != nil {
		for i, v := range s.FilterList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FilterList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListChangeSetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Catalog != nil {
		v := *s.Catalog

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Catalog", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FilterList != nil {
		v := s.FilterList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FilterList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Sort != nil {
		v := s.Sort

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Sort", v, metadata)
	}
	return nil
}

type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	// Array of ChangeSetSummaryListItem objects.
	ChangeSetSummaryList []ChangeSetSummaryListItem `type:"list"`

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListChangeSetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeSetSummaryList != nil {
		v := s.ChangeSetSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ChangeSetSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest returns a request value for making API operation for
// AWS Marketplace Catalog Service.
//
// Returns the list of change sets owned by the account being used to make the
// call. You can filter this list by providing any combination of entityId,
// ChangeSetName, and status. If you provide more than one filter, the API operation
// applies a logical AND between the filters.
//
// You can describe a change during the 60-day request history retention period
// for API calls.
//
//    // Example sending a request using ListChangeSetsRequest.
//    req := client.ListChangeSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/ListChangeSets
func (c *Client) ListChangeSetsRequest(input *ListChangeSetsInput) ListChangeSetsRequest {
	op := &aws.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/ListChangeSets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	req := c.newRequest(op, input, &ListChangeSetsOutput{})
	return ListChangeSetsRequest{Request: req, Input: input, Copy: c.ListChangeSetsRequest}
}

// ListChangeSetsRequest is the request type for the
// ListChangeSets API operation.
type ListChangeSetsRequest struct {
	*aws.Request
	Input *ListChangeSetsInput
	Copy  func(*ListChangeSetsInput) ListChangeSetsRequest
}

// Send marshals and sends the ListChangeSets API request.
func (r ListChangeSetsRequest) Send(ctx context.Context) (*ListChangeSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListChangeSetsResponse{
		ListChangeSetsOutput: r.Request.Data.(*ListChangeSetsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListChangeSetsRequestPaginator returns a paginator for ListChangeSets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListChangeSetsRequest(input)
//   p := marketplacecatalog.NewListChangeSetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListChangeSetsPaginator(req ListChangeSetsRequest) ListChangeSetsPaginator {
	return ListChangeSetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListChangeSetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListChangeSetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListChangeSetsPaginator struct {
	aws.Pager
}

func (p *ListChangeSetsPaginator) CurrentPage() *ListChangeSetsOutput {
	return p.Pager.CurrentPage().(*ListChangeSetsOutput)
}

// ListChangeSetsResponse is the response type for the
// ListChangeSets API operation.
type ListChangeSetsResponse struct {
	*ListChangeSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListChangeSets request.
func (r *ListChangeSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
