// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateSchemaInput struct {
	_ struct{} `type:"structure"`

	// The name for the schema.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A schema in Avro JSON format.
	//
	// Schema is a required field
	Schema *string `locationName:"schema" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSchemaInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Schema == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schema"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created schema.
	SchemaArn *string `locationName:"schemaArn" type:"string"`
}

// String returns the string representation
func (s CreateSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSchema = "CreateSchema"

// CreateSchemaRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Creates an Amazon Personalize schema from the specified schema string. The
// schema you create must be in Avro JSON format.
//
// Amazon Personalize recognizes three schema variants. Each schema is associated
// with a dataset type and has a set of required field and keywords. You specify
// a schema when you call CreateDataset.
//
// Related APIs
//
//    * ListSchemas
//
//    * DescribeSchema
//
//    * DeleteSchema
//
//    // Example sending a request using CreateSchemaRequest.
//    req := client.CreateSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateSchema
func (c *Client) CreateSchemaRequest(input *CreateSchemaInput) CreateSchemaRequest {
	op := &aws.Operation{
		Name:       opCreateSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSchemaInput{}
	}

	req := c.newRequest(op, input, &CreateSchemaOutput{})
	return CreateSchemaRequest{Request: req, Input: input, Copy: c.CreateSchemaRequest}
}

// CreateSchemaRequest is the request type for the
// CreateSchema API operation.
type CreateSchemaRequest struct {
	*aws.Request
	Input *CreateSchemaInput
	Copy  func(*CreateSchemaInput) CreateSchemaRequest
}

// Send marshals and sends the CreateSchema API request.
func (r CreateSchemaRequest) Send(ctx context.Context) (*CreateSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSchemaResponse{
		CreateSchemaOutput: r.Request.Data.(*CreateSchemaOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSchemaResponse is the response type for the
// CreateSchema API operation.
type CreateSchemaResponse struct {
	*CreateSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSchema request.
func (r *CreateSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
