// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListIAMPolicyAssignmentsForUserInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account that contains the assignments.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The maximum number of results to be returned per request.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The namespace of the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The name of the user.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListIAMPolicyAssignmentsForUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIAMPolicyAssignmentsForUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListIAMPolicyAssignmentsForUserInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Namespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("Namespace"))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListIAMPolicyAssignmentsForUserInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UserName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListIAMPolicyAssignmentsForUserOutput struct {
	_ struct{} `type:"structure"`

	// The active assignments for this user.
	ActiveAssignments []ActiveIAMPolicyAssignment `type:"list"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s ListIAMPolicyAssignmentsForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListIAMPolicyAssignmentsForUserOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActiveAssignments != nil {
		v := s.ActiveAssignments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ActiveAssignments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opListIAMPolicyAssignmentsForUser = "ListIAMPolicyAssignmentsForUser"

// ListIAMPolicyAssignmentsForUserRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Lists all the IAM policy assignments, including the Amazon Resource Names
// (ARNs) for the IAM policies assigned to the specified user and group or groups
// that the user belongs to.
//
//    // Example sending a request using ListIAMPolicyAssignmentsForUserRequest.
//    req := client.ListIAMPolicyAssignmentsForUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *Client) ListIAMPolicyAssignmentsForUserRequest(input *ListIAMPolicyAssignmentsForUserInput) ListIAMPolicyAssignmentsForUserRequest {
	op := &aws.Operation{
		Name:       opListIAMPolicyAssignmentsForUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsForUserInput{}
	}

	req := c.newRequest(op, input, &ListIAMPolicyAssignmentsForUserOutput{})
	return ListIAMPolicyAssignmentsForUserRequest{Request: req, Input: input, Copy: c.ListIAMPolicyAssignmentsForUserRequest}
}

// ListIAMPolicyAssignmentsForUserRequest is the request type for the
// ListIAMPolicyAssignmentsForUser API operation.
type ListIAMPolicyAssignmentsForUserRequest struct {
	*aws.Request
	Input *ListIAMPolicyAssignmentsForUserInput
	Copy  func(*ListIAMPolicyAssignmentsForUserInput) ListIAMPolicyAssignmentsForUserRequest
}

// Send marshals and sends the ListIAMPolicyAssignmentsForUser API request.
func (r ListIAMPolicyAssignmentsForUserRequest) Send(ctx context.Context) (*ListIAMPolicyAssignmentsForUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListIAMPolicyAssignmentsForUserResponse{
		ListIAMPolicyAssignmentsForUserOutput: r.Request.Data.(*ListIAMPolicyAssignmentsForUserOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListIAMPolicyAssignmentsForUserResponse is the response type for the
// ListIAMPolicyAssignmentsForUser API operation.
type ListIAMPolicyAssignmentsForUserResponse struct {
	*ListIAMPolicyAssignmentsForUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListIAMPolicyAssignmentsForUser request.
func (r *ListIAMPolicyAssignmentsForUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
