// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RestoreObjectInput struct {
	_ struct{} `type:"structure" payload:"RestoreRequest"`

	// The bucket name or containing the object to restore.
	//
	// When using this API with an access point, you must direct requests to the
	// access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this operation using an access point through the AWS SDKs, you
	// provide the access point ARN in place of the bucket name. For more information
	// about access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Object key for which the operation was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// For information about downloading objects from Requester Pays buckets, see
	// Downloading Objects in Requestor Pays Buckets (https://docs.aws.amazon.com/http:/docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Container for restore job parameters.
	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.RestoreRequest != nil {
		if err := s.RestoreRequest.Validate(); err != nil {
			invalidParams.AddNested("RestoreRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *RestoreObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.RestoreRequest != nil {
		v := s.RestoreRequest

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "RestoreRequest", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Indicates the path in the provided S3 output location where Select results
	// will be restored to.
	RestoreOutputPath *string `location:"header" locationName:"x-amz-restore-output-path" type:"string"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.RestoreOutputPath != nil {
		v := *s.RestoreOutputPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-restore-output-path", protocol.StringValue(v), metadata)
	}
	return nil
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Restores an archived copy of an object back into Amazon S3
//
// This operation performs the following types of requests:
//
//    * select - Perform a select query on an archived object
//
//    * restore an archive - Restore an archived object
//
// To use this operation, you must have permissions to perform the s3:RestoreObject
// and s3:GetObject actions. The bucket owner has this permission by default
// and can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Querying Archives with Select Requests
//
// You use a select type of request to perform SQL queries on archived objects.
// The archived objects that are being queried by the select request must be
// formatted as uncompressed comma-separated values (CSV) files. You can run
// queries and custom analytics on your archived data without having to restore
// your data to a hotter Amazon S3 tier. For an overview about select requests,
// see Querying Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// When making a select request, do the following:
//
//    * Define an output location for the select query's output. This must be
//    an Amazon S3 bucket in the same AWS Region as the bucket that contains
//    the archive object that is being queried. The AWS account that initiates
//    the job must have permissions to write to the S3 bucket. You can specify
//    the storage class and encryption for the output objects stored in the
//    bucket. For more information about output, see Querying Archived Objects
//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html)
//    in the Amazon Simple Storage Service Developer Guide. For more information
//    about the S3 structure in the request body, see the following: PutObject
//    Managing Access with ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html)
//    in the Amazon Simple Storage Service Developer Guide Protecting Data Using
//    Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
//    in the Amazon Simple Storage Service Developer Guide
//
//    * Define the SQL expression for the SELECT type of restoration for your
//    query in the request body's SelectParameters structure. You can use expressions
//    like the following examples. The following expression returns all records
//    from the specified object. SELECT * FROM Object Assuming that you are
//    not using any headers for data stored in the object, you can specify columns
//    with positional headers. SELECT s._1, s._2 FROM Object s WHERE s._3 >
//    100 If you have headers and you set the fileHeaderInfo in the CSV structure
//    in the request body to USE, you can specify headers in the query. (If
//    you set the fileHeaderInfo field to IGNORE, the first row is skipped for
//    the query.) You cannot mix ordinal positions with header column names.
//    SELECT s.Id, s.FirstName, s.SSN FROM S3Object s
//
// For more information about using SQL with Glacier Select restore, see SQL
// Reference for Amazon S3 Select and Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// When making a select request, you can also do the following:
//
//    * To expedite your queries, specify the Expedited tier. For more information
//    about tiers, see "Restoring Archives," later in this topic.
//
//    * Specify details about the data serialization format of both the input
//    object that is being queried and the serialization of the CSV-encoded
//    query results.
//
// The following are additional important facts about the select feature:
//
//    * The output results are new Amazon S3 objects. Unlike archive retrievals,
//    they are stored until explicitly deleted-manually or through a lifecycle
//    policy.
//
//    * You can issue more than one select request on the same Amazon S3 object.
//    Amazon S3 doesn't deduplicate requests, so avoid issuing duplicate requests.
//
//    * Amazon S3 accepts a select request even if the object has already been
//    restored. A select request doesn’t return error response 409.
//
// Restoring Archives
//
// Objects in the GLACIER and DEEP_ARCHIVE storage classes are archived. To
// access an archived object, you must first initiate a restore request. This
// restores a temporary copy of the archived object. In a restore request, you
// specify the number of days that you want the restored copy to exist. After
// the specified period, Amazon S3 deletes the temporary copy but the object
// remains archived in the GLACIER or DEEP_ARCHIVE storage class that object
// was restored from.
//
// To restore a specific object version, you can provide a version ID. If you
// don't provide a version ID, Amazon S3 restores the current version.
//
// The time it takes restore jobs to finish depends on which storage class the
// object is being restored from and which data access tier you specify.
//
// When restoring an archived object (or using a select request), you can specify
// one of the following data access tier options in the Tier element of the
// request body:
//
//    * Expedited - Expedited retrievals allow you to quickly access your data
//    stored in the GLACIER storage class when occasional urgent requests for
//    a subset of archives are required. For all but the largest archived objects
//    (250 MB+), data accessed using Expedited retrievals are typically made
//    available within 1–5 minutes. Provisioned capacity ensures that retrieval
//    capacity for Expedited retrievals is available when you need it. Expedited
//    retrievals and provisioned capacity are not available for the DEEP_ARCHIVE
//    storage class.
//
//    * Standard - Standard retrievals allow you to access any of your archived
//    objects within several hours. This is the default option for the GLACIER
//    and DEEP_ARCHIVE retrieval requests that do not specify the retrieval
//    option. Standard retrievals typically complete within 3-5 hours from the
//    GLACIER storage class and typically complete within 12 hours from the
//    DEEP_ARCHIVE storage class.
//
//    * Bulk - Bulk retrievals are Amazon S3 Glacier’s lowest-cost retrieval
//    option, enabling you to retrieve large amounts, even petabytes, of data
//    inexpensively in a day. Bulk retrievals typically complete within 5-12
//    hours from the GLACIER storage class and typically complete within 48
//    hours from the DEEP_ARCHIVE storage class.
//
// For more information about archive retrieval options and provisioned capacity
// for Expedited data access, see Restoring Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// You can use Amazon S3 restore speed upgrade to change the restore speed to
// a faster speed while it is in progress. You upgrade the speed of an in-progress
// restoration by issuing another restore request to the same object, setting
// a new Tier request element. When issuing a request to upgrade the restore
// tier, you must choose a tier that is faster than the tier that the in-progress
// restore is using. You must not change any other parameters, such as the Days
// request element. For more information, see Upgrading the Speed of an In-Progress
// Restore (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html#restoring-objects-upgrade-tier.title.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// To get the status of object restoration, you can send a HEAD request. Operations
// return the x-amz-restore header, which provides information about the restoration
// status, in the response. You can use Amazon S3 event notifications to notify
// you when a restore is initiated or completed. For more information, see Configuring
// Amazon S3 Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// After restoring an archived object, you can update the restoration period
// by reissuing the request with a new period. Amazon S3 updates the restoration
// period relative to the current time and charges only for the request-there
// are no data transfer charges. You cannot update the restoration period when
// Amazon S3 is actively processing your current restore request for the object.
//
// If your bucket has a lifecycle configuration with a rule that includes an
// expiration action, the object expiration overrides the life span that you
// specify in a restore request. For example, if you restore an object copy
// for 10 days, but the object is scheduled to expire in 3 days, Amazon S3 deletes
// the object in 3 days. For more information about lifecycle configuration,
// see PutBucketLifecycleConfiguration and Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in Amazon Simple Storage Service Developer Guide.
//
// Responses
//
// A successful operation returns either the 200 OK or 202 Accepted status code.
//
//    * If the object copy is not previously restored, then Amazon S3 returns
//    202 Accepted in the response.
//
//    * If the object copy is previously restored, Amazon S3 returns 200 OK
//    in the response.
//
// Special Errors
//
//    * Code: RestoreAlreadyInProgress Cause: Object restore is already in progress.
//    (This error does not apply to SELECT type requests.) HTTP Status Code:
//    409 Conflict SOAP Fault Code Prefix: Client
//
//    * Code: GlacierExpeditedRetrievalNotAvailable Cause: Glacier expedited
//    retrievals are currently not available. Try again later. (Returned if
//    there is insufficient capacity to process the Expedited request. This
//    error applies only to Expedited retrievals and not to Standard or Bulk
//    retrievals.) HTTP Status Code: 503 SOAP Fault Code Prefix: N/A
//
// Related Resources
//
//    * PutBucketLifecycleConfiguration
//
//    * GetBucketNotificationConfiguration
//
//    * SQL Reference for Amazon S3 Select and Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
//    in the Amazon Simple Storage Service Developer Guide
//
//    // Example sending a request using RestoreObjectRequest.
//    req := client.RestoreObjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *Client) RestoreObjectRequest(input *RestoreObjectInput) RestoreObjectRequest {
	op := &aws.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	req := c.newRequest(op, input, &RestoreObjectOutput{})
	return RestoreObjectRequest{Request: req, Input: input, Copy: c.RestoreObjectRequest}
}

// RestoreObjectRequest is the request type for the
// RestoreObject API operation.
type RestoreObjectRequest struct {
	*aws.Request
	Input *RestoreObjectInput
	Copy  func(*RestoreObjectInput) RestoreObjectRequest
}

// Send marshals and sends the RestoreObject API request.
func (r RestoreObjectRequest) Send(ctx context.Context) (*RestoreObjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreObjectResponse{
		RestoreObjectOutput: r.Request.Data.(*RestoreObjectOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreObjectResponse is the response type for the
// RestoreObject API operation.
type RestoreObjectResponse struct {
	*RestoreObjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreObject request.
func (r *RestoreObjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
