// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to begin email address verification with Amazon SES.
// For information about email address verification, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
type VerifyEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The email address to be verified.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyEmailIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VerifyEmailIdentityInput"}

	if s.EmailAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type VerifyEmailIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opVerifyEmailIdentity = "VerifyEmailIdentity"

// VerifyEmailIdentityRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Adds an email address to the list of identities for your Amazon SES account
// in the current AWS region and attempts to verify it. As a result of executing
// this operation, a verification email is sent to the specified address.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using VerifyEmailIdentityRequest.
//    req := client.VerifyEmailIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity
func (c *Client) VerifyEmailIdentityRequest(input *VerifyEmailIdentityInput) VerifyEmailIdentityRequest {
	op := &aws.Operation{
		Name:       opVerifyEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailIdentityInput{}
	}

	req := c.newRequest(op, input, &VerifyEmailIdentityOutput{})
	return VerifyEmailIdentityRequest{Request: req, Input: input, Copy: c.VerifyEmailIdentityRequest}
}

// VerifyEmailIdentityRequest is the request type for the
// VerifyEmailIdentity API operation.
type VerifyEmailIdentityRequest struct {
	*aws.Request
	Input *VerifyEmailIdentityInput
	Copy  func(*VerifyEmailIdentityInput) VerifyEmailIdentityRequest
}

// Send marshals and sends the VerifyEmailIdentity API request.
func (r VerifyEmailIdentityRequest) Send(ctx context.Context) (*VerifyEmailIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &VerifyEmailIdentityResponse{
		VerifyEmailIdentityOutput: r.Request.Data.(*VerifyEmailIdentityOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// VerifyEmailIdentityResponse is the response type for the
// VerifyEmailIdentity API operation.
type VerifyEmailIdentityResponse struct {
	*VerifyEmailIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// VerifyEmailIdentity request.
func (r *VerifyEmailIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
