// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Input for Unsubscribe action.
type UnsubscribeInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the subscription to be deleted.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnsubscribeInput"}

	if s.SubscriptionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UnsubscribeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnsubscribe = "Unsubscribe"

// UnsubscribeRequest returns a request value for making API operation for
// Amazon Simple Notification Service.
//
// Deletes a subscription. If the subscription requires authentication for deletion,
// only the owner of the subscription or the topic's owner can unsubscribe,
// and an AWS signature is required. If the Unsubscribe call does not require
// authentication and the requester is not the subscription owner, a final cancellation
// message is delivered to the endpoint, so that the endpoint owner can easily
// resubscribe to the topic if the Unsubscribe request was unintended.
//
// This action is throttled at 100 transactions per second (TPS).
//
//    // Example sending a request using UnsubscribeRequest.
//    req := client.UnsubscribeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe
func (c *Client) UnsubscribeRequest(input *UnsubscribeInput) UnsubscribeRequest {
	op := &aws.Operation{
		Name:       opUnsubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnsubscribeInput{}
	}

	req := c.newRequest(op, input, &UnsubscribeOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UnsubscribeRequest{Request: req, Input: input, Copy: c.UnsubscribeRequest}
}

// UnsubscribeRequest is the request type for the
// Unsubscribe API operation.
type UnsubscribeRequest struct {
	*aws.Request
	Input *UnsubscribeInput
	Copy  func(*UnsubscribeInput) UnsubscribeRequest
}

// Send marshals and sends the Unsubscribe API request.
func (r UnsubscribeRequest) Send(ctx context.Context) (*UnsubscribeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnsubscribeResponse{
		UnsubscribeOutput: r.Request.Data.(*UnsubscribeOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnsubscribeResponse is the response type for the
// Unsubscribe API operation.
type UnsubscribeResponse struct {
	*UnsubscribeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Unsubscribe request.
func (r *UnsubscribeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
