// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package workdocsiface provides an interface to enable mocking the Amazon WorkDocs service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package workdocsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/workdocs"
)

// ClientAPI provides an interface to enable mocking the
// workdocs.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon WorkDocs.
//    func myFunc(svc workdocsiface.ClientAPI) bool {
//        // Make svc.AbortDocumentVersionUpload request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := workdocs.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        workdocsiface.ClientPI
//    }
//    func (m *mockClientClient) AbortDocumentVersionUpload(input *workdocs.AbortDocumentVersionUploadInput) (*workdocs.AbortDocumentVersionUploadOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AbortDocumentVersionUploadRequest(*workdocs.AbortDocumentVersionUploadInput) workdocs.AbortDocumentVersionUploadRequest

	ActivateUserRequest(*workdocs.ActivateUserInput) workdocs.ActivateUserRequest

	AddResourcePermissionsRequest(*workdocs.AddResourcePermissionsInput) workdocs.AddResourcePermissionsRequest

	CreateCommentRequest(*workdocs.CreateCommentInput) workdocs.CreateCommentRequest

	CreateCustomMetadataRequest(*workdocs.CreateCustomMetadataInput) workdocs.CreateCustomMetadataRequest

	CreateFolderRequest(*workdocs.CreateFolderInput) workdocs.CreateFolderRequest

	CreateLabelsRequest(*workdocs.CreateLabelsInput) workdocs.CreateLabelsRequest

	CreateNotificationSubscriptionRequest(*workdocs.CreateNotificationSubscriptionInput) workdocs.CreateNotificationSubscriptionRequest

	CreateUserRequest(*workdocs.CreateUserInput) workdocs.CreateUserRequest

	DeactivateUserRequest(*workdocs.DeactivateUserInput) workdocs.DeactivateUserRequest

	DeleteCommentRequest(*workdocs.DeleteCommentInput) workdocs.DeleteCommentRequest

	DeleteCustomMetadataRequest(*workdocs.DeleteCustomMetadataInput) workdocs.DeleteCustomMetadataRequest

	DeleteDocumentRequest(*workdocs.DeleteDocumentInput) workdocs.DeleteDocumentRequest

	DeleteFolderRequest(*workdocs.DeleteFolderInput) workdocs.DeleteFolderRequest

	DeleteFolderContentsRequest(*workdocs.DeleteFolderContentsInput) workdocs.DeleteFolderContentsRequest

	DeleteLabelsRequest(*workdocs.DeleteLabelsInput) workdocs.DeleteLabelsRequest

	DeleteNotificationSubscriptionRequest(*workdocs.DeleteNotificationSubscriptionInput) workdocs.DeleteNotificationSubscriptionRequest

	DeleteUserRequest(*workdocs.DeleteUserInput) workdocs.DeleteUserRequest

	DescribeActivitiesRequest(*workdocs.DescribeActivitiesInput) workdocs.DescribeActivitiesRequest

	DescribeCommentsRequest(*workdocs.DescribeCommentsInput) workdocs.DescribeCommentsRequest

	DescribeDocumentVersionsRequest(*workdocs.DescribeDocumentVersionsInput) workdocs.DescribeDocumentVersionsRequest

	DescribeFolderContentsRequest(*workdocs.DescribeFolderContentsInput) workdocs.DescribeFolderContentsRequest

	DescribeGroupsRequest(*workdocs.DescribeGroupsInput) workdocs.DescribeGroupsRequest

	DescribeNotificationSubscriptionsRequest(*workdocs.DescribeNotificationSubscriptionsInput) workdocs.DescribeNotificationSubscriptionsRequest

	DescribeResourcePermissionsRequest(*workdocs.DescribeResourcePermissionsInput) workdocs.DescribeResourcePermissionsRequest

	DescribeRootFoldersRequest(*workdocs.DescribeRootFoldersInput) workdocs.DescribeRootFoldersRequest

	DescribeUsersRequest(*workdocs.DescribeUsersInput) workdocs.DescribeUsersRequest

	GetCurrentUserRequest(*workdocs.GetCurrentUserInput) workdocs.GetCurrentUserRequest

	GetDocumentRequest(*workdocs.GetDocumentInput) workdocs.GetDocumentRequest

	GetDocumentPathRequest(*workdocs.GetDocumentPathInput) workdocs.GetDocumentPathRequest

	GetDocumentVersionRequest(*workdocs.GetDocumentVersionInput) workdocs.GetDocumentVersionRequest

	GetFolderRequest(*workdocs.GetFolderInput) workdocs.GetFolderRequest

	GetFolderPathRequest(*workdocs.GetFolderPathInput) workdocs.GetFolderPathRequest

	GetResourcesRequest(*workdocs.GetResourcesInput) workdocs.GetResourcesRequest

	InitiateDocumentVersionUploadRequest(*workdocs.InitiateDocumentVersionUploadInput) workdocs.InitiateDocumentVersionUploadRequest

	RemoveAllResourcePermissionsRequest(*workdocs.RemoveAllResourcePermissionsInput) workdocs.RemoveAllResourcePermissionsRequest

	RemoveResourcePermissionRequest(*workdocs.RemoveResourcePermissionInput) workdocs.RemoveResourcePermissionRequest

	UpdateDocumentRequest(*workdocs.UpdateDocumentInput) workdocs.UpdateDocumentRequest

	UpdateDocumentVersionRequest(*workdocs.UpdateDocumentVersionInput) workdocs.UpdateDocumentVersionRequest

	UpdateFolderRequest(*workdocs.UpdateFolderInput) workdocs.UpdateFolderRequest

	UpdateUserRequest(*workdocs.UpdateUserInput) workdocs.UpdateUserRequest
}

var _ ClientAPI = (*workdocs.Client)(nil)
