package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"io"
	"net/http"
)

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "resizing"
	// Steady ...
	Steady AllocationState = "steady"
	// Stopping ...
	Stopping AllocationState = "stopping"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady, Stopping}
}

// CertificateFormat enumerates the values for certificate format.
type CertificateFormat string

const (
	// Cer ...
	Cer CertificateFormat = "cer"
	// Pfx ...
	Pfx CertificateFormat = "pfx"
	// Unmapped ...
	Unmapped CertificateFormat = "unmapped"
)

// PossibleCertificateFormatValues returns an array of possible values for the CertificateFormat const type.
func PossibleCertificateFormatValues() []CertificateFormat {
	return []CertificateFormat{Cer, Pfx, Unmapped}
}

// CertificateState enumerates the values for certificate state.
type CertificateState string

const (
	// Active ...
	Active CertificateState = "active"
	// Deletefailed ...
	Deletefailed CertificateState = "deletefailed"
	// Deleting ...
	Deleting CertificateState = "deleting"
)

// PossibleCertificateStateValues returns an array of possible values for the CertificateState const type.
func PossibleCertificateStateValues() []CertificateState {
	return []CertificateState{Active, Deletefailed, Deleting}
}

// CertificateStoreLocation enumerates the values for certificate store location.
type CertificateStoreLocation string

const (
	// CertificateStoreLocationCurrentuser ...
	CertificateStoreLocationCurrentuser CertificateStoreLocation = "currentuser"
	// CertificateStoreLocationLocalmachine ...
	CertificateStoreLocationLocalmachine CertificateStoreLocation = "localmachine"
	// CertificateStoreLocationUnmapped ...
	CertificateStoreLocationUnmapped CertificateStoreLocation = "unmapped"
)

// PossibleCertificateStoreLocationValues returns an array of possible values for the CertificateStoreLocation const type.
func PossibleCertificateStoreLocationValues() []CertificateStoreLocation {
	return []CertificateStoreLocation{CertificateStoreLocationCurrentuser, CertificateStoreLocationLocalmachine, CertificateStoreLocationUnmapped}
}

// CertificateVisibility enumerates the values for certificate visibility.
type CertificateVisibility string

const (
	// CertificateVisibilityRemoteuser ...
	CertificateVisibilityRemoteuser CertificateVisibility = "remoteuser"
	// CertificateVisibilityStarttask ...
	CertificateVisibilityStarttask CertificateVisibility = "starttask"
	// CertificateVisibilityTask ...
	CertificateVisibilityTask CertificateVisibility = "task"
	// CertificateVisibilityUnmapped ...
	CertificateVisibilityUnmapped CertificateVisibility = "unmapped"
)

// PossibleCertificateVisibilityValues returns an array of possible values for the CertificateVisibility const type.
func PossibleCertificateVisibilityValues() []CertificateVisibility {
	return []CertificateVisibility{CertificateVisibilityRemoteuser, CertificateVisibilityStarttask, CertificateVisibilityTask, CertificateVisibilityUnmapped}
}

// ComputeNodeDeallocationOption enumerates the values for compute node deallocation option.
type ComputeNodeDeallocationOption string

const (
	// Requeue ...
	Requeue ComputeNodeDeallocationOption = "requeue"
	// Retaineddata ...
	Retaineddata ComputeNodeDeallocationOption = "retaineddata"
	// Taskcompletion ...
	Taskcompletion ComputeNodeDeallocationOption = "taskcompletion"
	// Terminate ...
	Terminate ComputeNodeDeallocationOption = "terminate"
)

// PossibleComputeNodeDeallocationOptionValues returns an array of possible values for the ComputeNodeDeallocationOption const type.
func PossibleComputeNodeDeallocationOptionValues() []ComputeNodeDeallocationOption {
	return []ComputeNodeDeallocationOption{Requeue, Retaineddata, Taskcompletion, Terminate}
}

// ComputeNodeFillType enumerates the values for compute node fill type.
type ComputeNodeFillType string

const (
	// ComputeNodeFillTypePack ...
	ComputeNodeFillTypePack ComputeNodeFillType = "pack"
	// ComputeNodeFillTypeSpread ...
	ComputeNodeFillTypeSpread ComputeNodeFillType = "spread"
	// ComputeNodeFillTypeUnmapped ...
	ComputeNodeFillTypeUnmapped ComputeNodeFillType = "unmapped"
)

// PossibleComputeNodeFillTypeValues returns an array of possible values for the ComputeNodeFillType const type.
func PossibleComputeNodeFillTypeValues() []ComputeNodeFillType {
	return []ComputeNodeFillType{ComputeNodeFillTypePack, ComputeNodeFillTypeSpread, ComputeNodeFillTypeUnmapped}
}

// ComputeNodeRebootOption enumerates the values for compute node reboot option.
type ComputeNodeRebootOption string

const (
	// ComputeNodeRebootOptionRequeue ...
	ComputeNodeRebootOptionRequeue ComputeNodeRebootOption = "requeue"
	// ComputeNodeRebootOptionRetaineddata ...
	ComputeNodeRebootOptionRetaineddata ComputeNodeRebootOption = "retaineddata"
	// ComputeNodeRebootOptionTaskcompletion ...
	ComputeNodeRebootOptionTaskcompletion ComputeNodeRebootOption = "taskcompletion"
	// ComputeNodeRebootOptionTerminate ...
	ComputeNodeRebootOptionTerminate ComputeNodeRebootOption = "terminate"
)

// PossibleComputeNodeRebootOptionValues returns an array of possible values for the ComputeNodeRebootOption const type.
func PossibleComputeNodeRebootOptionValues() []ComputeNodeRebootOption {
	return []ComputeNodeRebootOption{ComputeNodeRebootOptionRequeue, ComputeNodeRebootOptionRetaineddata, ComputeNodeRebootOptionTaskcompletion, ComputeNodeRebootOptionTerminate}
}

// ComputeNodeReimageOption enumerates the values for compute node reimage option.
type ComputeNodeReimageOption string

const (
	// ComputeNodeReimageOptionRequeue ...
	ComputeNodeReimageOptionRequeue ComputeNodeReimageOption = "requeue"
	// ComputeNodeReimageOptionRetaineddata ...
	ComputeNodeReimageOptionRetaineddata ComputeNodeReimageOption = "retaineddata"
	// ComputeNodeReimageOptionTaskcompletion ...
	ComputeNodeReimageOptionTaskcompletion ComputeNodeReimageOption = "taskcompletion"
	// ComputeNodeReimageOptionTerminate ...
	ComputeNodeReimageOptionTerminate ComputeNodeReimageOption = "terminate"
)

// PossibleComputeNodeReimageOptionValues returns an array of possible values for the ComputeNodeReimageOption const type.
func PossibleComputeNodeReimageOptionValues() []ComputeNodeReimageOption {
	return []ComputeNodeReimageOption{ComputeNodeReimageOptionRequeue, ComputeNodeReimageOptionRetaineddata, ComputeNodeReimageOptionTaskcompletion, ComputeNodeReimageOptionTerminate}
}

// ComputeNodeState enumerates the values for compute node state.
type ComputeNodeState string

const (
	// Creating ...
	Creating ComputeNodeState = "creating"
	// Idle ...
	Idle ComputeNodeState = "idle"
	// Leavingpool ...
	Leavingpool ComputeNodeState = "leavingpool"
	// Offline ...
	Offline ComputeNodeState = "offline"
	// Rebooting ...
	Rebooting ComputeNodeState = "rebooting"
	// Reimaging ...
	Reimaging ComputeNodeState = "reimaging"
	// Running ...
	Running ComputeNodeState = "running"
	// Starting ...
	Starting ComputeNodeState = "starting"
	// Starttaskfailed ...
	Starttaskfailed ComputeNodeState = "starttaskfailed"
	// Unknown ...
	Unknown ComputeNodeState = "unknown"
	// Unusable ...
	Unusable ComputeNodeState = "unusable"
	// Waitingforstarttask ...
	Waitingforstarttask ComputeNodeState = "waitingforstarttask"
)

// PossibleComputeNodeStateValues returns an array of possible values for the ComputeNodeState const type.
func PossibleComputeNodeStateValues() []ComputeNodeState {
	return []ComputeNodeState{Creating, Idle, Leavingpool, Offline, Rebooting, Reimaging, Running, Starting, Starttaskfailed, Unknown, Unusable, Waitingforstarttask}
}

// DisableComputeNodeSchedulingOption enumerates the values for disable compute node scheduling option.
type DisableComputeNodeSchedulingOption string

const (
	// DisableComputeNodeSchedulingOptionRequeue ...
	DisableComputeNodeSchedulingOptionRequeue DisableComputeNodeSchedulingOption = "requeue"
	// DisableComputeNodeSchedulingOptionTaskcompletion ...
	DisableComputeNodeSchedulingOptionTaskcompletion DisableComputeNodeSchedulingOption = "taskcompletion"
	// DisableComputeNodeSchedulingOptionTerminate ...
	DisableComputeNodeSchedulingOptionTerminate DisableComputeNodeSchedulingOption = "terminate"
)

// PossibleDisableComputeNodeSchedulingOptionValues returns an array of possible values for the DisableComputeNodeSchedulingOption const type.
func PossibleDisableComputeNodeSchedulingOptionValues() []DisableComputeNodeSchedulingOption {
	return []DisableComputeNodeSchedulingOption{DisableComputeNodeSchedulingOptionRequeue, DisableComputeNodeSchedulingOptionTaskcompletion, DisableComputeNodeSchedulingOptionTerminate}
}

// DisableJobOption enumerates the values for disable job option.
type DisableJobOption string

const (
	// DisableJobOptionRequeue ...
	DisableJobOptionRequeue DisableJobOption = "requeue"
	// DisableJobOptionTerminate ...
	DisableJobOptionTerminate DisableJobOption = "terminate"
	// DisableJobOptionWait ...
	DisableJobOptionWait DisableJobOption = "wait"
)

// PossibleDisableJobOptionValues returns an array of possible values for the DisableJobOption const type.
func PossibleDisableJobOptionValues() []DisableJobOption {
	return []DisableJobOption{DisableJobOptionRequeue, DisableJobOptionTerminate, DisableJobOptionWait}
}

// JobPreparationTaskState enumerates the values for job preparation task state.
type JobPreparationTaskState string

const (
	// JobPreparationTaskStateCompleted ...
	JobPreparationTaskStateCompleted JobPreparationTaskState = "completed"
	// JobPreparationTaskStateRunning ...
	JobPreparationTaskStateRunning JobPreparationTaskState = "running"
)

// PossibleJobPreparationTaskStateValues returns an array of possible values for the JobPreparationTaskState const type.
func PossibleJobPreparationTaskStateValues() []JobPreparationTaskState {
	return []JobPreparationTaskState{JobPreparationTaskStateCompleted, JobPreparationTaskStateRunning}
}

// JobReleaseTaskState enumerates the values for job release task state.
type JobReleaseTaskState string

const (
	// JobReleaseTaskStateCompleted ...
	JobReleaseTaskStateCompleted JobReleaseTaskState = "completed"
	// JobReleaseTaskStateRunning ...
	JobReleaseTaskStateRunning JobReleaseTaskState = "running"
)

// PossibleJobReleaseTaskStateValues returns an array of possible values for the JobReleaseTaskState const type.
func PossibleJobReleaseTaskStateValues() []JobReleaseTaskState {
	return []JobReleaseTaskState{JobReleaseTaskStateCompleted, JobReleaseTaskStateRunning}
}

// JobScheduleState enumerates the values for job schedule state.
type JobScheduleState string

const (
	// JobScheduleStateActive ...
	JobScheduleStateActive JobScheduleState = "active"
	// JobScheduleStateCompleted ...
	JobScheduleStateCompleted JobScheduleState = "completed"
	// JobScheduleStateDeleting ...
	JobScheduleStateDeleting JobScheduleState = "deleting"
	// JobScheduleStateDisabled ...
	JobScheduleStateDisabled JobScheduleState = "disabled"
	// JobScheduleStateTerminating ...
	JobScheduleStateTerminating JobScheduleState = "terminating"
)

// PossibleJobScheduleStateValues returns an array of possible values for the JobScheduleState const type.
func PossibleJobScheduleStateValues() []JobScheduleState {
	return []JobScheduleState{JobScheduleStateActive, JobScheduleStateCompleted, JobScheduleStateDeleting, JobScheduleStateDisabled, JobScheduleStateTerminating}
}

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateActive ...
	JobStateActive JobState = "active"
	// JobStateCompleted ...
	JobStateCompleted JobState = "completed"
	// JobStateDeleting ...
	JobStateDeleting JobState = "deleting"
	// JobStateDisabled ...
	JobStateDisabled JobState = "disabled"
	// JobStateDisabling ...
	JobStateDisabling JobState = "disabling"
	// JobStateEnabling ...
	JobStateEnabling JobState = "enabling"
	// JobStateTerminating ...
	JobStateTerminating JobState = "terminating"
)

// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateActive, JobStateCompleted, JobStateDeleting, JobStateDisabled, JobStateDisabling, JobStateEnabling, JobStateTerminating}
}

// OSType enumerates the values for os type.
type OSType string

const (
	// OSTypeLinux ...
	OSTypeLinux OSType = "linux"
	// OSTypeUnmapped ...
	OSTypeUnmapped OSType = "unmapped"
	// OSTypeWindows ...
	OSTypeWindows OSType = "windows"
)

// PossibleOSTypeValues returns an array of possible values for the OSType const type.
func PossibleOSTypeValues() []OSType {
	return []OSType{OSTypeLinux, OSTypeUnmapped, OSTypeWindows}
}

// PoolLifetimeOption enumerates the values for pool lifetime option.
type PoolLifetimeOption string

const (
	// PoolLifetimeOptionJob ...
	PoolLifetimeOptionJob PoolLifetimeOption = "job"
	// PoolLifetimeOptionJobschedule ...
	PoolLifetimeOptionJobschedule PoolLifetimeOption = "jobschedule"
	// PoolLifetimeOptionUnmapped ...
	PoolLifetimeOptionUnmapped PoolLifetimeOption = "unmapped"
)

// PossiblePoolLifetimeOptionValues returns an array of possible values for the PoolLifetimeOption const type.
func PossiblePoolLifetimeOptionValues() []PoolLifetimeOption {
	return []PoolLifetimeOption{PoolLifetimeOptionJob, PoolLifetimeOptionJobschedule, PoolLifetimeOptionUnmapped}
}

// PoolState enumerates the values for pool state.
type PoolState string

const (
	// PoolStateActive ...
	PoolStateActive PoolState = "active"
	// PoolStateDeleting ...
	PoolStateDeleting PoolState = "deleting"
	// PoolStateUpgrading ...
	PoolStateUpgrading PoolState = "upgrading"
)

// PossiblePoolStateValues returns an array of possible values for the PoolState const type.
func PossiblePoolStateValues() []PoolState {
	return []PoolState{PoolStateActive, PoolStateDeleting, PoolStateUpgrading}
}

// SchedulingErrorCategory enumerates the values for scheduling error category.
type SchedulingErrorCategory string

const (
	// SchedulingErrorCategoryServererror ...
	SchedulingErrorCategoryServererror SchedulingErrorCategory = "servererror"
	// SchedulingErrorCategoryUnmapped ...
	SchedulingErrorCategoryUnmapped SchedulingErrorCategory = "unmapped"
	// SchedulingErrorCategoryUsererror ...
	SchedulingErrorCategoryUsererror SchedulingErrorCategory = "usererror"
)

// PossibleSchedulingErrorCategoryValues returns an array of possible values for the SchedulingErrorCategory const type.
func PossibleSchedulingErrorCategoryValues() []SchedulingErrorCategory {
	return []SchedulingErrorCategory{SchedulingErrorCategoryServererror, SchedulingErrorCategoryUnmapped, SchedulingErrorCategoryUsererror}
}

// SchedulingState enumerates the values for scheduling state.
type SchedulingState string

const (
	// Disabled ...
	Disabled SchedulingState = "disabled"
	// Enabled ...
	Enabled SchedulingState = "enabled"
)

// PossibleSchedulingStateValues returns an array of possible values for the SchedulingState const type.
func PossibleSchedulingStateValues() []SchedulingState {
	return []SchedulingState{Disabled, Enabled}
}

// StartTaskState enumerates the values for start task state.
type StartTaskState string

const (
	// StartTaskStateCompleted ...
	StartTaskStateCompleted StartTaskState = "completed"
	// StartTaskStateRunning ...
	StartTaskStateRunning StartTaskState = "running"
)

// PossibleStartTaskStateValues returns an array of possible values for the StartTaskState const type.
func PossibleStartTaskStateValues() []StartTaskState {
	return []StartTaskState{StartTaskStateCompleted, StartTaskStateRunning}
}

// TaskAddStatus enumerates the values for task add status.
type TaskAddStatus string

const (
	// TaskAddStatusClienterror ...
	TaskAddStatusClienterror TaskAddStatus = "clienterror"
	// TaskAddStatusServererror ...
	TaskAddStatusServererror TaskAddStatus = "servererror"
	// TaskAddStatusSuccess ...
	TaskAddStatusSuccess TaskAddStatus = "success"
	// TaskAddStatusUnmapped ...
	TaskAddStatusUnmapped TaskAddStatus = "unmapped"
)

// PossibleTaskAddStatusValues returns an array of possible values for the TaskAddStatus const type.
func PossibleTaskAddStatusValues() []TaskAddStatus {
	return []TaskAddStatus{TaskAddStatusClienterror, TaskAddStatusServererror, TaskAddStatusSuccess, TaskAddStatusUnmapped}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateActive ...
	TaskStateActive TaskState = "active"
	// TaskStateCompleted ...
	TaskStateCompleted TaskState = "completed"
	// TaskStatePreparing ...
	TaskStatePreparing TaskState = "preparing"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "running"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateActive, TaskStateCompleted, TaskStatePreparing, TaskStateRunning}
}

// AccountListNodeAgentSkusResult response to an AccountOperation.ListNodeAgentSkus request.
type AccountListNodeAgentSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of supported node agent SKUs.
	Value *[]NodeAgentSku `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// AccountListNodeAgentSkusResultIterator provides access to a complete listing of NodeAgentSku values.
type AccountListNodeAgentSkusResultIterator struct {
	i    int
	page AccountListNodeAgentSkusResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListNodeAgentSkusResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListNodeAgentSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListNodeAgentSkusResultIterator) Response() AccountListNodeAgentSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListNodeAgentSkusResultIterator) Value() NodeAgentSku {
	if !iter.page.NotDone() {
		return NodeAgentSku{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alnasr AccountListNodeAgentSkusResult) IsEmpty() bool {
	return alnasr.Value == nil || len(*alnasr.Value) == 0
}

// accountListNodeAgentSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alnasr AccountListNodeAgentSkusResult) accountListNodeAgentSkusResultPreparer() (*http.Request, error) {
	if alnasr.OdataNextLink == nil || len(to.String(alnasr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alnasr.OdataNextLink)))
}

// AccountListNodeAgentSkusResultPage contains a page of NodeAgentSku values.
type AccountListNodeAgentSkusResultPage struct {
	fn     func(AccountListNodeAgentSkusResult) (AccountListNodeAgentSkusResult, error)
	alnasr AccountListNodeAgentSkusResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListNodeAgentSkusResultPage) Next() error {
	next, err := page.fn(page.alnasr)
	if err != nil {
		return err
	}
	page.alnasr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListNodeAgentSkusResultPage) NotDone() bool {
	return !page.alnasr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListNodeAgentSkusResultPage) Response() AccountListNodeAgentSkusResult {
	return page.alnasr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListNodeAgentSkusResultPage) Values() []NodeAgentSku {
	if page.alnasr.IsEmpty() {
		return nil
	}
	return *page.alnasr.Value
}

// AffinityInformation a locality hint that can be used by the Batch service to select a compute node on which to
// start a task.
type AffinityInformation struct {
	// AffinityID - An opaque string representing the location of a compute node or a task that has run previously. You can pass the AffinityId of a compute node or task to indicate that this task needs to be placed close to the node or task.
	AffinityID *string `json:"affinityId,omitempty"`
}

// ApplicationListResult response to a ApplicationOperations.List request.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of applications available in the account.
	Value *[]ApplicationSummary `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of ApplicationSummary values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() ApplicationSummary {
	if !iter.page.NotDone() {
		return ApplicationSummary{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer() (*http.Request, error) {
	if alr.OdataNextLink == nil || len(to.String(alr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.OdataNextLink)))
}

// ApplicationListResultPage contains a page of ApplicationSummary values.
type ApplicationListResultPage struct {
	fn  func(ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []ApplicationSummary {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// ApplicationPackageReference a reference to an application package to be installed on compute nodes in a pool.
type ApplicationPackageReference struct {
	// ApplicationID - The id of the application to install.
	ApplicationID *string `json:"applicationId,omitempty"`
	// Version - The version of the application to install. If omitted, the default version is installed.
	Version *string `json:"version,omitempty"`
}

// ApplicationSummary contains information about an application in an Azure Batch account.
type ApplicationSummary struct {
	autorest.Response `json:"-"`
	// ID - A string that uniquely identifies the application within the account.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the application.
	DisplayName *string   `json:"displayName,omitempty"`
	Versions    *[]string `json:"versions,omitempty"`
}

// AutoPoolSpecification specifies characteristics for a temporary 'auto pool'. The Batch service will create this
// auto pool, run all the tasks for the job on it, and will delete the pool once the job has completed.
type AutoPoolSpecification struct {
	// AutoPoolIDPrefix - A prefix to be added to the unique identifier when a pool is automatically created. The prefix can be up to 20 characters long.
	AutoPoolIDPrefix *string `json:"autoPoolIdPrefix,omitempty"`
	// PoolLifetimeOption - The minimum lifetime of created auto pools, and how multiple jobs on a schedule are assigned to pools. Possible values include: 'PoolLifetimeOptionJobschedule', 'PoolLifetimeOptionJob', 'PoolLifetimeOptionUnmapped'
	PoolLifetimeOption PoolLifetimeOption `json:"poolLifetimeOption,omitempty"`
	// KeepAlive - Whether to keep an auto pool alive after its lifetime expires.
	KeepAlive *bool `json:"keepAlive,omitempty"`
	// Pool - The pool specification for the auto pool.
	Pool *PoolSpecification `json:"pool,omitempty"`
}

// AutoScaleRun the results and errors from an execution of a pool autoscale formula.
type AutoScaleRun struct {
	autorest.Response `json:"-"`
	// Timestamp - The time at which the autoscale formula was last evaluated.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Results - The final values of all variables used in the evaluation of the autoscale formula. Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
	Results *string `json:"results,omitempty"`
	// Error - Details of the error encountered evaluating the autoscale formula on the pool, if the evaluation was unsuccessful.
	Error *AutoScaleRunError `json:"error,omitempty"`
}

// AutoScaleRunError an error that occurred when executing or evaluating a pool autoscale formula.
type AutoScaleRunError struct {
	// Code - An identifier for the autoscale error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the autoscale error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Values - A list of additional error details related to the autoscale error.
	Values *[]NameValuePair `json:"values,omitempty"`
}

// Certificate a certificate that can be installed on compute nodes and can be used to authenticate operations on
// the machine.
type Certificate struct {
	autorest.Response `json:"-"`
	// Thumbprint - The X.509 thumbprint of the certificate. This is a sequence of up to 40 hex digits (it may include spaces but these are removed).
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ThumbprintAlgorithm - The algorithm used to derive the thumbprint. This must be sha1.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// URL - The URL of the certificate.
	URL *string `json:"url,omitempty"`
	// State - The current state of the certificate. Possible values include: 'Active', 'Deleting', 'Deletefailed'
	State CertificateState `json:"state,omitempty"`
	// StateTransitionTime - The time at which the certificate entered its current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - The previous state of the certificate. This property is not set if the certificate is in its initial Active state. Possible values include: 'Active', 'Deleting', 'Deletefailed'
	PreviousState CertificateState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - The time at which the certificate entered its previous state. This property is not set if the certificate is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// PublicData - The public part of the certificate as a base-64 encoded .cer file.
	PublicData *string `json:"publicData,omitempty"`
	// DeleteCertificateError - The error that occurred on the last attempt to delete this certificate. This property is set only if the certificate is in the deletefailed state.
	DeleteCertificateError *DeleteCertificateError `json:"deleteCertificateError,omitempty"`
}

// CertificateAddParameter a certificate that can be installed on compute nodes and can be used to authenticate
// operations on the machine.
type CertificateAddParameter struct {
	// Thumbprint - The X.509 thumbprint of the certificate. This is a sequence of up to 40 hex digits (it may include spaces but these are removed).
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ThumbprintAlgorithm - The algorithm used to derive the thumbprint. This must be sha1.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// Data - The base64-encoded contents of the certificate. The maximum size is 10KB.
	Data *string `json:"data,omitempty"`
	// CertificateFormat - The format of the certificate data. Possible values include: 'Pfx', 'Cer', 'Unmapped'
	CertificateFormat CertificateFormat `json:"certificateFormat,omitempty"`
	// Password - The password to access the certificate's private key.
	Password *string `json:"password,omitempty"`
}

// CertificateListResult response to a CertificateOperation.List request.
type CertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of certificates.
	Value *[]Certificate `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// CertificateListResultIterator provides access to a complete listing of Certificate values.
type CertificateListResultIterator struct {
	i    int
	page CertificateListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateListResultIterator) Response() CertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateListResultIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CertificateListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// certificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CertificateListResult) certificateListResultPreparer() (*http.Request, error) {
	if clr.OdataNextLink == nil || len(to.String(clr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.OdataNextLink)))
}

// CertificateListResultPage contains a page of Certificate values.
type CertificateListResultPage struct {
	fn  func(CertificateListResult) (CertificateListResult, error)
	clr CertificateListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateListResultPage) Response() CertificateListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateListResultPage) Values() []Certificate {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// CertificateReference a reference to a certificate to be installed on compute nodes in a pool.
type CertificateReference struct {
	// Thumbprint - The thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ThumbprintAlgorithm - The algorithm with which the thumbprint is associated. This must be sha1.
	ThumbprintAlgorithm *string `json:"thumbprintAlgorithm,omitempty"`
	// StoreLocation - The location of the certificate store on the compute node into which to install the certificate. The default value is CurrentUser. Possible values include: 'CertificateStoreLocationCurrentuser', 'CertificateStoreLocationLocalmachine', 'CertificateStoreLocationUnmapped'
	StoreLocation CertificateStoreLocation `json:"storeLocation,omitempty"`
	// StoreName - The name of the certificate store on the compute node into which to install the certificate. The default value is My.
	StoreName *string `json:"storeName,omitempty"`
	// Visibility - Which user accounts on the compute node should have access to the private data of the certificate. This may be any subset of the values 'starttask', 'task' and 'remoteuser', separated by commas. The default is all accounts, corresponding to the string 'starttask,task,remoteuser'.
	Visibility *[]CertificateVisibility `json:"visibility,omitempty"`
}

// CloudJob an Azure Batch job.
type CloudJob struct {
	autorest.Response `json:"-"`
	// ID - A string that uniquely identifies the job within the account. The id can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. It is common to use a GUID for the id.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the job.
	DisplayName *string `json:"displayName,omitempty"`
	// UsesTaskDependencies - The flag that determines if this job will use tasks with dependencies.
	UsesTaskDependencies *bool `json:"usesTaskDependencies,omitempty"`
	// URL - The URL of the job.
	URL *string `json:"url,omitempty"`
	// ETag - The ETag of the job.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - The last modified time of the job.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// CreationTime - The creation time of the job.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - The current state of the job. Possible values include: 'JobStateActive', 'JobStateDisabling', 'JobStateDisabled', 'JobStateEnabling', 'JobStateTerminating', 'JobStateCompleted', 'JobStateDeleting'
	State JobState `json:"state,omitempty"`
	// StateTransitionTime - The time at which the job entered its current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - The previous state of the job. This property is not set if the job is in its initial Active state. Possible values include: 'JobStateActive', 'JobStateDisabling', 'JobStateDisabled', 'JobStateEnabling', 'JobStateTerminating', 'JobStateCompleted', 'JobStateDeleting'
	PreviousState JobState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - The time at which the job entered its previous state. This property is not set if the job is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// Priority - The priority of the job. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - The execution constraints for the job.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// JobManagerTask - Details of a Job Manager task to be launched when the job is started.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - The Job Preparation task.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The Job Release task.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - The list of common environment variable settings. These environment variables are set for all tasks in the job (including the Job Manager, Job Preparation and Job Release tasks).
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	// PoolInfo - The pool on which the Batch service runs the job's tasks.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - A list of name-value pairs associated with the job as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// ExecutionInfo - The execution information for the job.
	ExecutionInfo *JobExecutionInformation `json:"executionInfo,omitempty"`
	// Stats - Resource usage statistics for the entire lifetime of the job.
	Stats *JobStatistics `json:"stats,omitempty"`
}

// CloudJobListPreparationAndReleaseTaskStatusResult response to a
// CloudJobOperations.ListPreparationAndReleaseTaskStatus request.
type CloudJobListPreparationAndReleaseTaskStatusResult struct {
	autorest.Response `json:"-"`
	// Value - A list of Job Preparation and Job Release task execution information.
	Value *[]JobPreparationAndReleaseTaskExecutionInformation `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// CloudJobListPreparationAndReleaseTaskStatusResultIterator provides access to a complete listing of
// JobPreparationAndReleaseTaskExecutionInformation values.
type CloudJobListPreparationAndReleaseTaskStatusResultIterator struct {
	i    int
	page CloudJobListPreparationAndReleaseTaskStatusResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobListPreparationAndReleaseTaskStatusResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) Response() CloudJobListPreparationAndReleaseTaskStatusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobListPreparationAndReleaseTaskStatusResultIterator) Value() JobPreparationAndReleaseTaskExecutionInformation {
	if !iter.page.NotDone() {
		return JobPreparationAndReleaseTaskExecutionInformation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) IsEmpty() bool {
	return cjlpartsr.Value == nil || len(*cjlpartsr.Value) == 0
}

// cloudJobListPreparationAndReleaseTaskStatusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult) cloudJobListPreparationAndReleaseTaskStatusResultPreparer() (*http.Request, error) {
	if cjlpartsr.OdataNextLink == nil || len(to.String(cjlpartsr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlpartsr.OdataNextLink)))
}

// CloudJobListPreparationAndReleaseTaskStatusResultPage contains a page of
// JobPreparationAndReleaseTaskExecutionInformation values.
type CloudJobListPreparationAndReleaseTaskStatusResultPage struct {
	fn        func(CloudJobListPreparationAndReleaseTaskStatusResult) (CloudJobListPreparationAndReleaseTaskStatusResult, error)
	cjlpartsr CloudJobListPreparationAndReleaseTaskStatusResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobListPreparationAndReleaseTaskStatusResultPage) Next() error {
	next, err := page.fn(page.cjlpartsr)
	if err != nil {
		return err
	}
	page.cjlpartsr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) NotDone() bool {
	return !page.cjlpartsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) Response() CloudJobListPreparationAndReleaseTaskStatusResult {
	return page.cjlpartsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobListPreparationAndReleaseTaskStatusResultPage) Values() []JobPreparationAndReleaseTaskExecutionInformation {
	if page.cjlpartsr.IsEmpty() {
		return nil
	}
	return *page.cjlpartsr.Value
}

// CloudJobListResult response to a CloudJobOperation.List or ListFromJobSchedule request.
type CloudJobListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of jobs.
	Value *[]CloudJob `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// CloudJobListResultIterator provides access to a complete listing of CloudJob values.
type CloudJobListResultIterator struct {
	i    int
	page CloudJobListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobListResultIterator) Response() CloudJobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobListResultIterator) Value() CloudJob {
	if !iter.page.NotDone() {
		return CloudJob{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cjlr CloudJobListResult) IsEmpty() bool {
	return cjlr.Value == nil || len(*cjlr.Value) == 0
}

// cloudJobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjlr CloudJobListResult) cloudJobListResultPreparer() (*http.Request, error) {
	if cjlr.OdataNextLink == nil || len(to.String(cjlr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjlr.OdataNextLink)))
}

// CloudJobListResultPage contains a page of CloudJob values.
type CloudJobListResultPage struct {
	fn   func(CloudJobListResult) (CloudJobListResult, error)
	cjlr CloudJobListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobListResultPage) Next() error {
	next, err := page.fn(page.cjlr)
	if err != nil {
		return err
	}
	page.cjlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobListResultPage) NotDone() bool {
	return !page.cjlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobListResultPage) Response() CloudJobListResult {
	return page.cjlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobListResultPage) Values() []CloudJob {
	if page.cjlr.IsEmpty() {
		return nil
	}
	return *page.cjlr.Value
}

// CloudJobSchedule a job schedule that allows recurring jobs by specifying when to run jobs and a specification
// used to create each job.
type CloudJobSchedule struct {
	autorest.Response `json:"-"`
	// ID - A string that uniquely identifies the schedule within the account. A GUID is recommended.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the schedule.
	DisplayName *string `json:"displayName,omitempty"`
	// URL - The URL of the job schedule.
	URL *string `json:"url,omitempty"`
	// ETag - The ETag of the job schedule.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - The last modified time of the job schedule.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// CreationTime - The creation time of the job schedule.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - The current state of the job schedule. Possible values include: 'JobScheduleStateActive', 'JobScheduleStateCompleted', 'JobScheduleStateDisabled', 'JobScheduleStateTerminating', 'JobScheduleStateDeleting'
	State JobScheduleState `json:"state,omitempty"`
	// StateTransitionTime - The time at which the job schedule entered the current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - The previous state of the job schedule. Possible values include: 'JobScheduleStateActive', 'JobScheduleStateCompleted', 'JobScheduleStateDisabled', 'JobScheduleStateTerminating', 'JobScheduleStateDeleting'
	PreviousState JobScheduleState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - The time at which the job schedule entered its previous state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// Schedule - The schedule according to which jobs will be created.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - The details of the jobs to be created on this schedule.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// ExecutionInfo - Information about jobs that have been and will be run under this schedule.
	ExecutionInfo *JobScheduleExecutionInformation `json:"executionInfo,omitempty"`
	// Metadata - A list of name-value pairs associated with the schedule as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// Stats - The lifetime resource usage statistics for the job schedule.
	Stats *JobScheduleStatistics `json:"stats,omitempty"`
}

// CloudJobScheduleListResult response to a CloudJobScheduleOperation.List request.
type CloudJobScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of job schedules.
	Value *[]CloudJobSchedule `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// CloudJobScheduleListResultIterator provides access to a complete listing of CloudJobSchedule values.
type CloudJobScheduleListResultIterator struct {
	i    int
	page CloudJobScheduleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudJobScheduleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudJobScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudJobScheduleListResultIterator) Response() CloudJobScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudJobScheduleListResultIterator) Value() CloudJobSchedule {
	if !iter.page.NotDone() {
		return CloudJobSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cjslr CloudJobScheduleListResult) IsEmpty() bool {
	return cjslr.Value == nil || len(*cjslr.Value) == 0
}

// cloudJobScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cjslr CloudJobScheduleListResult) cloudJobScheduleListResultPreparer() (*http.Request, error) {
	if cjslr.OdataNextLink == nil || len(to.String(cjslr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cjslr.OdataNextLink)))
}

// CloudJobScheduleListResultPage contains a page of CloudJobSchedule values.
type CloudJobScheduleListResultPage struct {
	fn    func(CloudJobScheduleListResult) (CloudJobScheduleListResult, error)
	cjslr CloudJobScheduleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudJobScheduleListResultPage) Next() error {
	next, err := page.fn(page.cjslr)
	if err != nil {
		return err
	}
	page.cjslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudJobScheduleListResultPage) NotDone() bool {
	return !page.cjslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudJobScheduleListResultPage) Response() CloudJobScheduleListResult {
	return page.cjslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudJobScheduleListResultPage) Values() []CloudJobSchedule {
	if page.cjslr.IsEmpty() {
		return nil
	}
	return *page.cjslr.Value
}

// CloudPool a pool in the Azure Batch service.
type CloudPool struct {
	autorest.Response `json:"-"`
	// ID - A string that uniquely identifies the pool within the account. The id can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the pool.
	DisplayName *string `json:"displayName,omitempty"`
	// URL - The URL of the pool.
	URL *string `json:"url,omitempty"`
	// ETag - The ETag of the pool.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - The last modified time of the pool.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// CreationTime - The creation time of the pool.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - The current state of the pool. Possible values include: 'PoolStateActive', 'PoolStateDeleting', 'PoolStateUpgrading'
	State PoolState `json:"state,omitempty"`
	// StateTransitionTime - The time at which the pool entered its current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// AllocationState - Whether the pool is resizing. Possible values include: 'Steady', 'Resizing', 'Stopping'
	AllocationState AllocationState `json:"allocationState,omitempty"`
	// AllocationStateTransitionTime - The time at which the pool entered its current allocation state.
	AllocationStateTransitionTime *date.Time `json:"allocationStateTransitionTime,omitempty"`
	// VMSize - The size of virtual machines in the pool. All virtual machines in a pool are the same size.
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - The cloud service configuration for the pool. This property and VirtualMachineConfiguration are mutually exclusive and one of the properties must be specified.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - The virtual machine configuration for the pool. This property and CloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// ResizeTimeout - The timeout for allocation of compute nodes to the pool. In a Get Pool operation, this is the timeout for the most recent resize operation. The default value is 10 minutes.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// ResizeError - Details of any error encountered while performing the last resize on the pool. This property is set only if an error occurred during the last pool resize, and only when the pool AllocationState is Steady.
	ResizeError *ResizeError `json:"resizeError,omitempty"`
	// CurrentDedicated - The number of compute nodes currently in the pool.
	CurrentDedicated *int32 `json:"currentDedicated,omitempty"`
	// TargetDedicated - The desired number of compute nodes in the pool. This property must have the default value if EnableAutoScale is true. It is required if EnableAutoScale is false.
	TargetDedicated *int32 `json:"targetDedicated,omitempty"`
	// EnableAutoScale - Whether the pool size should automatically adjust over time. If true, the AutoScaleFormula property must be set. If false, the TargetDedicated property must be set.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - A formula for the desired number of compute nodes in the pool.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - A time interval for the desired AutoScale evaluation period in the pool.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// AutoScaleRun - The results and errors from the last execution of the autoscale formula.
	AutoScaleRun *AutoScaleRun `json:"autoScaleRun,omitempty"`
	// EnableInterNodeCommunication - Whether the pool permits direct communication between nodes.
	EnableInterNodeCommunication *bool `json:"enableInterNodeCommunication,omitempty"`
	// StartTask - A task specified to run on each compute node as it joins the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - The list of certificates to be installed on each compute node in the pool.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - The list of application packages to be installed on each compute node in the pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// MaxTasksPerNode - The maximum number of tasks that can run concurrently on a single compute node in the pool.
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - How the Batch service distributes tasks between compute nodes in the pool.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	// Metadata - A list of name-value pairs associated with the pool as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// Stats - Utilization and resource usage statistics for the entire lifetime of the pool.
	Stats *PoolStatistics `json:"stats,omitempty"`
}

// CloudPoolListResult response to a CloudPoolOperations.List request.
type CloudPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of pools.
	Value *[]CloudPool `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// CloudPoolListResultIterator provides access to a complete listing of CloudPool values.
type CloudPoolListResultIterator struct {
	i    int
	page CloudPoolListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudPoolListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudPoolListResultIterator) Response() CloudPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudPoolListResultIterator) Value() CloudPool {
	if !iter.page.NotDone() {
		return CloudPool{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cplr CloudPoolListResult) IsEmpty() bool {
	return cplr.Value == nil || len(*cplr.Value) == 0
}

// cloudPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cplr CloudPoolListResult) cloudPoolListResultPreparer() (*http.Request, error) {
	if cplr.OdataNextLink == nil || len(to.String(cplr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cplr.OdataNextLink)))
}

// CloudPoolListResultPage contains a page of CloudPool values.
type CloudPoolListResultPage struct {
	fn   func(CloudPoolListResult) (CloudPoolListResult, error)
	cplr CloudPoolListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudPoolListResultPage) Next() error {
	next, err := page.fn(page.cplr)
	if err != nil {
		return err
	}
	page.cplr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudPoolListResultPage) NotDone() bool {
	return !page.cplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudPoolListResultPage) Response() CloudPoolListResult {
	return page.cplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudPoolListResultPage) Values() []CloudPool {
	if page.cplr.IsEmpty() {
		return nil
	}
	return *page.cplr.Value
}

// CloudServiceConfiguration the configuration for nodes in a pool based on the Azure Cloud Services platform.
type CloudServiceConfiguration struct {
	// OsFamily - The Azure Guest OS family to be installed on the virtual machines in the pool.
	OsFamily *string `json:"osFamily,omitempty"`
	// TargetOSVersion - The Azure Guest OS version to be installed on the virtual machines in the pool. The default value is * which specifies the latest operating system version for the specified OS family.
	TargetOSVersion *string `json:"targetOSVersion,omitempty"`
	// CurrentOSVersion - The Azure Guest OS Version currently installed on the virtual machines in the pool. This may differ from TargetOSVersion if the pool state is Upgrading.
	CurrentOSVersion *string `json:"currentOSVersion,omitempty"`
}

// CloudTask an Azure Batch task.
type CloudTask struct {
	autorest.Response `json:"-"`
	// ID - A string that uniquely identifies the task within the job. The id can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - A display name for the task.
	DisplayName *string `json:"displayName,omitempty"`
	// URL - The URL of the task.
	URL *string `json:"url,omitempty"`
	// ETag - The ETag of the task.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - The last modified time of the task.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// CreationTime - The creation time of the task.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// State - The current state of the task. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	State TaskState `json:"state,omitempty"`
	// StateTransitionTime - The time at which the task entered its current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - The previous state of the task. This property is not set if the task is in its initial Active state. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	PreviousState TaskState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - The time at which the task entered its previous state. This property is not set if the task is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
	// CommandLine - The command line of the task. For multi-instance tasks, the command line is executed on the primary subtask after all the subtasks have finished executing the coordianation command line.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - A list of files that the Batch service will download to the compute node before running the command line. For multi-instance tasks, the resource files will only be downloaded to the compute node on which the primary subtask is executed.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// EnvironmentSettings - A list of environment variable settings for the task.
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// AffinityInfo - A locality hint that can be used by the Batch service to select a compute node on which to start the new task.
	AffinityInfo *AffinityInformation `json:"affinityInfo,omitempty"`
	// Constraints - The execution constraints that apply to this task.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
	// RunElevated - Whether to run the task in elevated mode.
	RunElevated *bool `json:"runElevated,omitempty"`
	// ExecutionInfo - Information about the execution of the task.
	ExecutionInfo *TaskExecutionInformation `json:"executionInfo,omitempty"`
	// NodeInfo - Information about the compute node on which the task ran.
	NodeInfo *ComputeNodeInformation `json:"nodeInfo,omitempty"`
	// MultiInstanceSettings - Information about how to run the multi-instance task.
	MultiInstanceSettings *MultiInstanceSettings `json:"multiInstanceSettings,omitempty"`
	// Stats - Resource usage statistics for the task.
	Stats *TaskStatistics `json:"stats,omitempty"`
	// DependsOn - Any dependencies this task has.
	DependsOn *TaskDependencies `json:"dependsOn,omitempty"`
}

// CloudTaskListResult response to a CloudTaskOperations.List request.
type CloudTaskListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of tasks.
	Value *[]CloudTask `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// CloudTaskListResultIterator provides access to a complete listing of CloudTask values.
type CloudTaskListResultIterator struct {
	i    int
	page CloudTaskListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CloudTaskListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CloudTaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CloudTaskListResultIterator) Response() CloudTaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CloudTaskListResultIterator) Value() CloudTask {
	if !iter.page.NotDone() {
		return CloudTask{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ctlr CloudTaskListResult) IsEmpty() bool {
	return ctlr.Value == nil || len(*ctlr.Value) == 0
}

// cloudTaskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ctlr CloudTaskListResult) cloudTaskListResultPreparer() (*http.Request, error) {
	if ctlr.OdataNextLink == nil || len(to.String(ctlr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ctlr.OdataNextLink)))
}

// CloudTaskListResultPage contains a page of CloudTask values.
type CloudTaskListResultPage struct {
	fn   func(CloudTaskListResult) (CloudTaskListResult, error)
	ctlr CloudTaskListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CloudTaskListResultPage) Next() error {
	next, err := page.fn(page.ctlr)
	if err != nil {
		return err
	}
	page.ctlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CloudTaskListResultPage) NotDone() bool {
	return !page.ctlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CloudTaskListResultPage) Response() CloudTaskListResult {
	return page.ctlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CloudTaskListResultPage) Values() []CloudTask {
	if page.ctlr.IsEmpty() {
		return nil
	}
	return *page.ctlr.Value
}

// CloudTaskListSubtasksResult response to a CloudTaskOperations.ListSubtasks request.
type CloudTaskListSubtasksResult struct {
	autorest.Response `json:"-"`
	// Value - The list of information of subtasks.
	Value *[]SubtaskInformation `json:"value,omitempty"`
}

// ComputeNode a compute node in the Batch service.
type ComputeNode struct {
	autorest.Response `json:"-"`
	// ID - The id of the compute node.
	ID *string `json:"id,omitempty"`
	// URL - The URL of the compute node.
	URL *string `json:"url,omitempty"`
	// State - The current state of the compute node. Possible values include: 'Idle', 'Rebooting', 'Reimaging', 'Running', 'Unusable', 'Creating', 'Starting', 'Waitingforstarttask', 'Starttaskfailed', 'Unknown', 'Leavingpool', 'Offline'
	State ComputeNodeState `json:"state,omitempty"`
	// SchedulingState - Whether the compute node should be available for task scheduling. Possible values include: 'Enabled', 'Disabled'
	SchedulingState SchedulingState `json:"schedulingState,omitempty"`
	// StateTransitionTime - The time at which the compute node entered its current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// LastBootTime - The time at which the compute node was started.
	LastBootTime *date.Time `json:"lastBootTime,omitempty"`
	// AllocationTime - The time at which this compute node was allocated to the pool.
	AllocationTime *date.Time `json:"allocationTime,omitempty"`
	// IPAddress - The IP address that other compute nodes can use to communicate with this compute node.
	IPAddress *string `json:"ipAddress,omitempty"`
	// AffinityID - An identifier which can be passed in the Add Task API to request that the task be scheduled close to this compute node.
	AffinityID *string `json:"affinityId,omitempty"`
	// VMSize - The size of the virtual machine hosting the compute node.
	VMSize *string `json:"vmSize,omitempty"`
	// TotalTasksRun - The total number of job tasks completed on the compute node. This includes Job Preparation, Job Release and Job Manager tasks, but not the pool start task.
	TotalTasksRun *int32 `json:"totalTasksRun,omitempty"`
	// RunningTasksCount - The total number of currently running job tasks on the compute node. This includes Job Preparation, Job Release, and Job Manager tasks, but not the pool start task.
	RunningTasksCount *int32 `json:"runningTasksCount,omitempty"`
	// TotalTasksSucceeded - The total number of job tasks which completed successfully (with exitCode 0) on the compute node. This includes Job Preparation, Job Release, and Job Manager tasks, but not the pool start task.
	TotalTasksSucceeded *int32 `json:"totalTasksSucceeded,omitempty"`
	// RecentTasks - The list of tasks that are currently running on the compute node.
	RecentTasks *[]TaskInformation `json:"recentTasks,omitempty"`
	// StartTask - The task specified to run on the compute node as it joins the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// StartTaskInfo - Runtime information about the execution of the start task on the compute node.
	StartTaskInfo *StartTaskInformation `json:"startTaskInfo,omitempty"`
	// CertificateReferences - The list of certificates installed on the compute node.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// Errors - The list of errors that are currently being encountered by the compute node.
	Errors *[]ComputeNodeError `json:"errors,omitempty"`
}

// ComputeNodeError an error encountered by a compute node.
type ComputeNodeError struct {
	// Code - An identifier for the compute node error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the compute node error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// ErrorDetails - The list of additional error details related to the compute node error.
	ErrorDetails *[]NameValuePair `json:"errorDetails,omitempty"`
}

// ComputeNodeGetRemoteLoginSettingsResult response to a ComputeNodeOperation.GetRemoteLoginSettings request.
type ComputeNodeGetRemoteLoginSettingsResult struct {
	autorest.Response `json:"-"`
	// RemoteLoginIPAddress - The IP address used for remote login to the compute node.
	RemoteLoginIPAddress *string `json:"remoteLoginIPAddress,omitempty"`
	// RemoteLoginPort - The port used for remote login to the compute node.
	RemoteLoginPort *int32 `json:"remoteLoginPort,omitempty"`
}

// ComputeNodeInformation information about the compute node on which a task ran.
type ComputeNodeInformation struct {
	// AffinityID - An identifier for the compute node on which the task ran, which can be passed when adding a task to request that the task be scheduled close to this compute node.
	AffinityID *string `json:"affinityId,omitempty"`
	// NodeURL - The URL of the node on which the task ran.
	NodeURL *string `json:"nodeUrl,omitempty"`
	// PoolID - The id of the pool on which the task ran.
	PoolID *string `json:"poolId,omitempty"`
	// NodeID - The id of the node on which the task ran.
	NodeID *string `json:"nodeId,omitempty"`
	// TaskRootDirectory - The root directory of the task on the compute node.
	TaskRootDirectory *string `json:"taskRootDirectory,omitempty"`
	// TaskRootDirectoryURL - The URL to the root directory of the task on the compute node.
	TaskRootDirectoryURL *string `json:"taskRootDirectoryUrl,omitempty"`
}

// ComputeNodeListResult response to a ComputeNodeOperation.List request.
type ComputeNodeListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of compute nodes.
	Value *[]ComputeNode `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// ComputeNodeListResultIterator provides access to a complete listing of ComputeNode values.
type ComputeNodeListResultIterator struct {
	i    int
	page ComputeNodeListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComputeNodeListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComputeNodeListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComputeNodeListResultIterator) Response() ComputeNodeListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComputeNodeListResultIterator) Value() ComputeNode {
	if !iter.page.NotDone() {
		return ComputeNode{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cnlr ComputeNodeListResult) IsEmpty() bool {
	return cnlr.Value == nil || len(*cnlr.Value) == 0
}

// computeNodeListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cnlr ComputeNodeListResult) computeNodeListResultPreparer() (*http.Request, error) {
	if cnlr.OdataNextLink == nil || len(to.String(cnlr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cnlr.OdataNextLink)))
}

// ComputeNodeListResultPage contains a page of ComputeNode values.
type ComputeNodeListResultPage struct {
	fn   func(ComputeNodeListResult) (ComputeNodeListResult, error)
	cnlr ComputeNodeListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComputeNodeListResultPage) Next() error {
	next, err := page.fn(page.cnlr)
	if err != nil {
		return err
	}
	page.cnlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComputeNodeListResultPage) NotDone() bool {
	return !page.cnlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComputeNodeListResultPage) Response() ComputeNodeListResult {
	return page.cnlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComputeNodeListResultPage) Values() []ComputeNode {
	if page.cnlr.IsEmpty() {
		return nil
	}
	return *page.cnlr.Value
}

// ComputeNodeUser an user account on a compute node.
type ComputeNodeUser struct {
	// Name - The user name of the account.
	Name *string `json:"name,omitempty"`
	// IsAdmin - Whether the account should be an administrator on the compute node.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// ExpiryTime - The time at which the account should expire. If omitted, the default is 1 day from the current time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Password - The password of the account.
	Password *string `json:"password,omitempty"`
	// SSHPublicKey - The SSH public key that can be used for remote login to the compute node.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// DeleteCertificateError an error encountered by the Batch service when deleting a certificate.
type DeleteCertificateError struct {
	// Code - An identifier for the certificate deletion error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the certificate deletion error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Values - A list of additional error details related to the certificate deletion error.
	Values *[]NameValuePair `json:"values,omitempty"`
}

// EnvironmentSetting an environment variable to be set on a task process.
type EnvironmentSetting struct {
	// Name - The name of the environment variable.
	Name *string `json:"name,omitempty"`
	// Value - The value of the environment variable.
	Value *string `json:"value,omitempty"`
}

// Error an error response received from the Azure Batch service.
type Error struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *ErrorMessage `json:"message,omitempty"`
	// Values - A collection of key-value pairs containing additional details about the error.
	Values *[]ErrorDetail `json:"values,omitempty"`
}

// ErrorDetail an item of additional information included in an Azure Batch error response.
type ErrorDetail struct {
	// Key - An identifier specifying the meaning of the Value property.
	Key *string `json:"key,omitempty"`
	// Value - The additional information included with the error response.
	Value *string `json:"value,omitempty"`
}

// ErrorMessage an error message received in an Azure Batch error response.
type ErrorMessage struct {
	// Lang - The language code of the error message
	Lang *string `json:"lang,omitempty"`
	// Value - The text of the message.
	Value *string `json:"value,omitempty"`
}

// FileProperties the properties of a file on a compute node.
type FileProperties struct {
	// CreationTime - The file creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// LastModified - The time at which the file was last modified.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// ContentLength - The length of the file.
	ContentLength *int64 `json:"contentLength,omitempty"`
	// ContentType - The content type of the file.
	ContentType *string `json:"contentType,omitempty"`
	// FileMode - The file mode attribute in octal format. This property will be returned only from a Linux compute node.
	FileMode *string `json:"fileMode,omitempty"`
}

// ImageReference a reference to an Azure Virtual Machines Marketplace image.
type ImageReference struct {
	// Publisher - The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or MicrosoftWindowsServer.
	Publisher *string `json:"publisher,omitempty"`
	// Offer - The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or WindowsServer.
	Offer *string `json:"offer,omitempty"`
	// Sku - The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or 2012-R2-Datacenter.
	Sku *string `json:"sku,omitempty"`
	// Version - The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
	Version *string `json:"version,omitempty"`
}

// JobAddParameter an Azure Batch job to add.
type JobAddParameter struct {
	// ID - A string that uniquely identifies the job within the account. The id can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. It is common to use a GUID for the id.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the job.
	DisplayName *string `json:"displayName,omitempty"`
	// Priority - The priority of the job. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - The execution constraints for the job.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// JobManagerTask - Details of a Job Manager task to be launched when the job is started.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - The Job Preparation task.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The Job Release task.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - The list of common environment variable settings. These environment variables are set for all tasks in the job (including the Job Manager, Job Preparation and Job Release tasks).
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	// PoolInfo - The pool on which the Batch service runs the job's tasks.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - A list of name-value pairs associated with the job as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
	// UsesTaskDependencies - The flag that determines if this job will use tasks with dependencies.
	UsesTaskDependencies *bool `json:"usesTaskDependencies,omitempty"`
}

// JobConstraints specifies the execution constraints for jobs created on a schedule.
type JobConstraints struct {
	// MaxWallClockTime - The maximum elapsed time that the job may run, measured from the time the job starts. If the job does not complete within the time limit, the Batch service terminates it and any tasks that are still running.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// MaxTaskRetryCount - The maximum number of times each task may be retried. The Batch service retries a task if its exit code is nonzero.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
}

// JobDisableParameter parameters for a CloudJobOperations.Disable request.
type JobDisableParameter struct {
	// DisableTasks - What to do with active tasks associated with the job. Possible values include: 'DisableJobOptionRequeue', 'DisableJobOptionTerminate', 'DisableJobOptionWait'
	DisableTasks DisableJobOption `json:"disableTasks,omitempty"`
}

// JobExecutionInformation contains information about the execution of a job in the Azure Batch service.
type JobExecutionInformation struct {
	// StartTime - The start time of the job.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The completion time of the job. This property is set only if the job is in the completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// PoolID - The id of the pool to which this job is assigned.
	PoolID *string `json:"poolId,omitempty"`
	// SchedulingError - Details of any error encountered by the service in starting the job.
	SchedulingError *JobSchedulingError `json:"schedulingError,omitempty"`
	// TerminateReason - A string describing the reason the job ended.
	TerminateReason *string `json:"terminateReason,omitempty"`
}

// JobManagerTask specifies details of a Job Manager task.
type JobManagerTask struct {
	// ID - A string that uniquely identifies the Job Manager task. A GUID is recommended.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name of the Job Manager task.
	DisplayName *string `json:"displayName,omitempty"`
	// CommandLine - The command line of the Job Manager task.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - A list of files that the Batch service will download to the compute node before running the command line.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// EnvironmentSettings - A list of environment variable settings for the Job Manager task.
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// Constraints - Constraints that apply to the Job Manager task.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
	// KillJobOnCompletion - Whether completion of the Job Manager task signifies completion of the entire job.
	KillJobOnCompletion *bool `json:"killJobOnCompletion,omitempty"`
	// RunElevated - Whether to run the Job Manager task in elevated mode. The default value is false.
	RunElevated *bool `json:"runElevated,omitempty"`
	// RunExclusive - Whether the Job Manager task requires exclusive use of the compute node where it runs. If true, no other tasks will run on the same compute node for as long as the Job Manager is running. If false, other tasks can run simultaneously with the Job Manager on a compute node. (The Job Manager task counts normally against the node's concurrent task limit, so this is only relevant if the node allows multiple concurrent tasks.)
	RunExclusive *bool `json:"runExclusive,omitempty"`
}

// JobPatchParameter parameters for a CloudJobOperations.Patch request.
type JobPatchParameter struct {
	// Priority - The priority of the job. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. If omitted, the priority of the job is left unchanged.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - The execution constraints for the job. If omitted, the existing execution constraints are left unchanged.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// PoolInfo - The pool on which the Batch service runs the job's tasks. If omitted, the job continues to run on its current pool.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - A list of name-value pairs associated with the job as metadata. If omitted, the existing job metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobPreparationAndReleaseTaskExecutionInformation the status of the Job Preparation and Job Release tasks on a
// compute node.
type JobPreparationAndReleaseTaskExecutionInformation struct {
	// PoolID - The id of the pool containing the compute node to which this entry refers.
	PoolID *string `json:"poolId,omitempty"`
	// NodeID - The id of the compute node to which this entry refers.
	NodeID *string `json:"nodeId,omitempty"`
	// NodeURL - The URL of the compute node to which this entry refers.
	NodeURL *string `json:"nodeUrl,omitempty"`
	// JobPreparationTaskExecutionInfo - Information about the execution status of the Job Preparation task on this compute node.
	JobPreparationTaskExecutionInfo *JobPreparationTaskExecutionInformation `json:"jobPreparationTaskExecutionInfo,omitempty"`
	// JobReleaseTaskExecutionInfo - Information about the execution status of the Job Release task on this compute node. This property is set only if the Job Release task has run on the node.
	JobReleaseTaskExecutionInfo *JobReleaseTaskExecutionInformation `json:"jobReleaseTaskExecutionInfo,omitempty"`
}

// JobPreparationTask a Job Preparation task to run before any tasks of the job on any given compute node.
type JobPreparationTask struct {
	// ID - A string that uniquely identifies the job preparation task within the job. The id can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// CommandLine - The command line of the Job Preparation task.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - A list of files that the Batch service will download to the compute node before running the command line.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// EnvironmentSettings - A list of environment variable settings for the Job Preparation task.
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// Constraints - Constraints that apply to the Job Preparation task.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
	// WaitForSuccess - Whether the Batch service should wait for the Job Preparation task to complete successfully before scheduling any other tasks of the job on the compute node.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
	// RunElevated - Whether to run the Job Preparation task in elevated mode. The default value is false.
	RunElevated *bool `json:"runElevated,omitempty"`
	// RerunOnNodeRebootAfterSuccess - Whether the Batch service should rerun the Job Preparation task after a compute node reboots. Note that the Job Preparation task should still be written to be idempotent because it can be rerun if the compute node is rebooted while Job Preparation task is still running. The default value is true.
	RerunOnNodeRebootAfterSuccess *bool `json:"rerunOnNodeRebootAfterSuccess,omitempty"`
}

// JobPreparationTaskExecutionInformation contains information about the execution of a Job Preparation task on a
// compute node.
type JobPreparationTaskExecutionInformation struct {
	// StartTime - The time at which the task started running. Note that every time the task is restarted, this value is updated.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time at which the Job Preparation task completed. This property is set only if the task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - The current state of the Job Preparation task. Possible values include: 'JobPreparationTaskStateRunning', 'JobPreparationTaskStateCompleted'
	State JobPreparationTaskState `json:"state,omitempty"`
	// TaskRootDirectory - The root directory of the Job Preparation task on the compute node. You can use this path to retrieve files created by the task, such as log files.
	TaskRootDirectory *string `json:"taskRootDirectory,omitempty"`
	// TaskRootDirectoryURL - The URL to the root directory of the Job Preparation task on the compute node.
	TaskRootDirectoryURL *string `json:"taskRootDirectoryUrl,omitempty"`
	// ExitCode - The exit code of the Job Preparation task. This property is set only if the task is in the Completed state.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// SchedulingError - The error encountered by the Batch service when starting the task.
	SchedulingError *TaskSchedulingError `json:"schedulingError,omitempty"`
	// RetryCount - The number of times the task has been retried by the Batch service. Every time the task exits with a non-zero exit code, it is deemed a task failure. The Batch service will retry the task up to the limit specified by the constraints.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - The most recent time at which a retry of the Job Preparation task started running. This property is set only if the task was retried (i.e. retryCount is nonzero).
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
}

// JobReleaseTask a Job Release task to run on job completion on any compute node where the job has run.
type JobReleaseTask struct {
	// ID - A string that uniquely identifies the Job Release task within the job. The id can contain any combination of alphanumeric characters including hyphens and underscores and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// CommandLine - The command line of the Job Release task.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - A list of files that the Batch service will download to the compute node before running the command line.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// EnvironmentSettings - A list of environment variable settings for the Job Release task.
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// MaxWallClockTime - The maximum elapsed time that the Job Release task may run on a given compute node, measured from the time the task starts. If the task does not complete within the time limit, the Batch service terminates it. The default value is 15 minutes.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// RetentionTime - The minimum time to retain the working directory for the Job Release task on the compute node. After this time, the Batch service may delete the working directory and all its contents. The default is infinite.
	RetentionTime *string `json:"retentionTime,omitempty"`
	// RunElevated - Whether to run the Job Release task in elevated mode. The default value is false.
	RunElevated *bool `json:"runElevated,omitempty"`
}

// JobReleaseTaskExecutionInformation contains information about the execution of a Job Release task on a compute
// node.
type JobReleaseTaskExecutionInformation struct {
	// StartTime - The time at which the task started running. Note that every time the task is restarted, this value is updated.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time at which the Job Release task completed. This property is set only if the task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// State - The current state of the Job Release task. Possible values include: 'JobReleaseTaskStateRunning', 'JobReleaseTaskStateCompleted'
	State JobReleaseTaskState `json:"state,omitempty"`
	// TaskRootDirectory - The root directory of the Job Release task on the compute node. You can use this path to retrieve files created by the task, such as log files.
	TaskRootDirectory *string `json:"taskRootDirectory,omitempty"`
	// TaskRootDirectoryURL - The URL to the root directory of the Job Release task on the compute node.
	TaskRootDirectoryURL *string `json:"taskRootDirectoryUrl,omitempty"`
	// ExitCode - The exit code of the Job Release task. This property is set only if the task is in the Completed state.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// SchedulingError - The scheduling error encountered by the Batch service when starting the task.
	SchedulingError *TaskSchedulingError `json:"schedulingError,omitempty"`
}

// JobScheduleAddParameter a job schedule that allows recurring jobs by specifying when to run jobs and a
// specification used to create each job.
type JobScheduleAddParameter struct {
	// ID - A string that uniquely identifies the schedule within the account. A GUID is recommended.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the schedule.
	DisplayName *string `json:"displayName,omitempty"`
	// Schedule - The schedule according to which jobs will be created.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - The details of the jobs to be created on this schedule.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - A list of name-value pairs associated with the schedule as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobScheduleExecutionInformation specifies how tasks should be run in a job associated with a job schedule.
type JobScheduleExecutionInformation struct {
	// NextRunTime - The next time at which a job will be created under this schedule.
	NextRunTime *date.Time `json:"nextRunTime,omitempty"`
	// RecentJob - Information about the most recent job under the job schedule.
	RecentJob *RecentJob `json:"recentJob,omitempty"`
	// EndTime - The time at which the schedule ended. This property is set only if the job schedule is in the completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// JobSchedulePatchParameter parameters for a CloudJobScheduleOperations.Patch request.
type JobSchedulePatchParameter struct {
	// Schedule - The schedule according to which jobs will be created. If you do not specify this element, the existing schedule is not modified.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - The details of the jobs to be created on this schedule.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - A list of name-value pairs associated with the job schedule as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobScheduleStatistics resource usage statistics for a job schedule.
type JobScheduleStatistics struct {
	// URL - The URL of the statistics.
	URL *string `json:"url,omitempty"`
	// StartTime - The start time of the time range covered by the statistics.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdateTime - The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// UserCPUTime - The total user mode CPU time (summed across all cores and all compute nodes) consumed by all tasks in all jobs created under the schedule.
	UserCPUTime *string `json:"userCPUTime,omitempty"`
	// KernelCPUTime - The total kernel mode CPU time (summed across all cores and all compute nodes) consumed by all tasks in all jobs created under the schedule.
	KernelCPUTime *string `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The total wall clock time of all the tasks in all the jobs created under the schedule.
	WallClockTime *string `json:"wallClockTime,omitempty"`
	// ReadIOps - The total number of disk read operations made by all tasks in all jobs created under the schedule.
	ReadIOps *int64 `json:"readIOps,omitempty"`
	// WriteIOps - The total number of disk write operations made by all tasks in all jobs created under the schedule.
	WriteIOps *int64 `json:"writeIOps,omitempty"`
	// ReadIOGiB - The total gibibytes read from disk by all tasks in all jobs created under the schedule.
	ReadIOGiB *float64 `json:"readIOGiB,omitempty"`
	// WriteIOGiB - The total gibibytes written to disk by all tasks in all jobs created under the schedule.
	WriteIOGiB *float64 `json:"writeIOGiB,omitempty"`
	// NumSucceededTasks - The total number of tasks successfully completed during the given time range in jobs created under the schedule. A task completes successfully if it returns exit code 0.
	NumSucceededTasks *int64 `json:"numSucceededTasks,omitempty"`
	// NumFailedTasks - The total number of tasks that failed during the given time range in jobs created under the schedule. A task fails if it exhausts its maximum retry count without returning exit code 0.
	NumFailedTasks *int64 `json:"numFailedTasks,omitempty"`
	// NumTaskRetries - The total number of retries during the given time range on all tasks in all jobs created under the schedule.
	NumTaskRetries *int64 `json:"numTaskRetries,omitempty"`
	// WaitTime - The total wait time of all tasks in all jobs created under the schedule. The wait time for a task is defined as the elapsed time between the creation of the task and the start of task execution. (If the task is retried due to failures, the wait time is the time to the most recent task execution.)
	WaitTime *string `json:"waitTime,omitempty"`
}

// JobScheduleUpdateParameter parameters for a CloudJobScheduleOperations.Update request.
type JobScheduleUpdateParameter struct {
	// Schedule - The schedule according to which jobs will be created. If you do not specify this element, it is equivalent to passing the default schedule: that is, a single job scheduled to run immediately.
	Schedule *Schedule `json:"schedule,omitempty"`
	// JobSpecification - Details of the jobs to be created on this schedule.
	JobSpecification *JobSpecification `json:"jobSpecification,omitempty"`
	// Metadata - A list of name-value pairs associated with the job schedule as metadata. If you do not specify this element, it takes the default value of an empty list; in effect, any existing metadata is deleted.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobSchedulingError an error encountered by the Batch service when scheduling a job.
type JobSchedulingError struct {
	// Category - The category of the job scheduling error. Possible values include: 'SchedulingErrorCategoryUsererror', 'SchedulingErrorCategoryServererror', 'SchedulingErrorCategoryUnmapped'
	Category SchedulingErrorCategory `json:"category,omitempty"`
	// Code - An identifier for the job scheduling error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the job scheduling error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - A list of additional error details related to the scheduling error.
	Details *[]NameValuePair `json:"details,omitempty"`
}

// JobSpecification specifies details of the jobs to be created on a schedule.
type JobSpecification struct {
	// Priority - The priority of jobs created under this schedule. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
	Priority *int32 `json:"priority,omitempty"`
	// DisplayName - The display name for jobs created under this schedule. It need not be unique and can contain any Unicode characters up to a maximum length of 1024.
	DisplayName *string `json:"displayName,omitempty"`
	// UsesTaskDependencies - The flag that determines if this job will use tasks with dependencies.
	UsesTaskDependencies *bool `json:"usesTaskDependencies,omitempty"`
	// Constraints - The execution constraints for jobs created under this schedule.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// JobManagerTask - The details of a Job Manager task to be launched when a job is started under this schedule.
	JobManagerTask *JobManagerTask `json:"jobManagerTask,omitempty"`
	// JobPreparationTask - The Job Preparation task for jobs created under this schedule.
	JobPreparationTask *JobPreparationTask `json:"jobPreparationTask,omitempty"`
	// JobReleaseTask - The Job Release task for jobs created under this schedule.
	JobReleaseTask *JobReleaseTask `json:"jobReleaseTask,omitempty"`
	// CommonEnvironmentSettings - A list of common environment variable settings. These environment variables are set for all tasks in jobs created under this schedule (including the Job Manager, Job Preparation and Job Release tasks).
	CommonEnvironmentSettings *[]EnvironmentSetting `json:"commonEnvironmentSettings,omitempty"`
	// PoolInfo - The pool on which the Batch service runs the tasks of jobs created under this schedule.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - A list of name-value pairs associated with each job created under this schedule as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// JobStatistics resource usage statistics for a job.
type JobStatistics struct {
	autorest.Response `json:"-"`
	// URL - The URL of the statistics.
	URL *string `json:"url,omitempty"`
	// StartTime - The start time of the time range covered by the statistics.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdateTime - The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// UserCPUTime - The total user mode CPU time (summed across all cores and all compute nodes) consumed by all tasks in the job.
	UserCPUTime *string `json:"userCPUTime,omitempty"`
	// KernelCPUTime - The total kernel mode CPU time (summed across all cores and all compute nodes) consumed by all tasks in the job.
	KernelCPUTime *string `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The total wall clock time of all tasks in the job.
	WallClockTime *string `json:"wallClockTime,omitempty"`
	// ReadIOps - The total number of disk read operations made by all tasks in the job.
	ReadIOps *int64 `json:"readIOps,omitempty"`
	// WriteIOps - The total number of disk write operations made by all tasks in the job.
	WriteIOps *int64 `json:"writeIOps,omitempty"`
	// ReadIOGiB - The total gibibytes read from disk by all tasks in the job.
	ReadIOGiB *float64 `json:"readIOGiB,omitempty"`
	// WriteIOGiB - The total gibibytes written to disk by all tasks in the job.
	WriteIOGiB *float64 `json:"writeIOGiB,omitempty"`
	// NumSucceededTasks - The total number of tasks successfully completed in the job during the given time range.
	NumSucceededTasks *int64 `json:"numSucceededTasks,omitempty"`
	// NumFailedTasks - The total number of tasks in the job that failed during the given time range.
	NumFailedTasks *int64 `json:"numFailedTasks,omitempty"`
	// NumTaskRetries - The total number of retries on all the tasks in the job during the given time range.
	NumTaskRetries *int64 `json:"numTaskRetries,omitempty"`
	// WaitTime - The total wait time of all tasks in the job. The wait time for a task is defined as the elapsed time between the creation of the task and the start of task execution. (If the task is retried due to failures, the wait time is the time to the most recent task execution.)
	WaitTime *string `json:"waitTime,omitempty"`
}

// JobTerminateParameter parameters for a CloudJobOperations.Terminate request.
type JobTerminateParameter struct {
	// TerminateReason - The text you want to appear as the job's TerminateReason. The default is 'UserTerminate'.
	TerminateReason *string `json:"terminateReason,omitempty"`
}

// JobUpdateParameter parameters for a CloudJobOperations.Update request.
type JobUpdateParameter struct {
	// Priority - The priority of the job. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. If omitted, the priority of the job is left unchanged.
	Priority *int32 `json:"priority,omitempty"`
	// Constraints - The execution constraints for the job. If omitted, the existing execution constraints are left unchanged.
	Constraints *JobConstraints `json:"constraints,omitempty"`
	// PoolInfo - The pool on which the Batch service runs the job's tasks. If omitted, the job continues to run on its current pool.
	PoolInfo *PoolInformation `json:"poolInfo,omitempty"`
	// Metadata - A list of name-value pairs associated with the job as metadata. If omitted, the existing job metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// MetadataItem a name-value pair associated with a Batch service resource. The Batch service does not assign any
// meaning to this metadata; it is solely for the use of user code.
type MetadataItem struct {
	// Name - The name of the metadata item.
	Name *string `json:"name,omitempty"`
	// Value - The value of the metadata item.
	Value *string `json:"value,omitempty"`
}

// MultiInstanceSettings settings which specify how to run a multi-instance task. Multi-instance tasks are commonly
// used to support MPI tasks.
type MultiInstanceSettings struct {
	// NumberOfInstances - The number of compute nodes required by the multi-instance task.
	NumberOfInstances *int32 `json:"numberOfInstances,omitempty"`
	// CoordinationCommandLine - The command to run on the compute node instances for coordinating among the subtasks.
	CoordinationCommandLine *string `json:"coordinationCommandLine,omitempty"`
	// CommonResourceFiles - A list of files that the Batch service will download before running the coordination command line. The difference between common resource files and task resource files is that common resource files are downloaded for all subtasks including the primary, whereas task resource files are downloaded only for the primary.
	CommonResourceFiles *[]ResourceFile `json:"commonResourceFiles,omitempty"`
}

// NameValuePair represents a name-value pair.
type NameValuePair struct {
	// Name - The name in the name-value pair.
	Name *string `json:"name,omitempty"`
	// Value - The value in the name-value pair.
	Value *string `json:"value,omitempty"`
}

// NodeAgentSku a node agent SKU supported by the Batch service. The Batch node agent is a program that runs on
// each node in the pool, and provides the command-and-control interface between the node and the Batch service.
// There are different implementations of the node agent, known as SKUs, for different operating systems.
type NodeAgentSku struct {
	// ID - The node agent SKU id.
	ID *string `json:"id,omitempty"`
	// VerifiedImageReferences - The list of images verified to be compatible with this node agent SKU. This collection is not exhaustive (the node agent may be compatible with other images).
	VerifiedImageReferences *[]ImageReference `json:"verifiedImageReferences,omitempty"`
	// OsType - The type of operating system compatible with the node agent SKU. Possible values include: 'OSTypeLinux', 'OSTypeWindows', 'OSTypeUnmapped'
	OsType OSType `json:"osType,omitempty"`
}

// NodeDisableSchedulingParameter parameters for a ComputeNodeOperations.DisableScheduling request.
type NodeDisableSchedulingParameter struct {
	// NodeDisableSchedulingOption - What to do with currently running tasks when disable task scheduling on the compute node. The default value is requeue. Possible values include: 'DisableComputeNodeSchedulingOptionRequeue', 'DisableComputeNodeSchedulingOptionTerminate', 'DisableComputeNodeSchedulingOptionTaskcompletion'
	NodeDisableSchedulingOption DisableComputeNodeSchedulingOption `json:"nodeDisableSchedulingOption,omitempty"`
}

// NodeFile information about a file or directory on a compute node.
type NodeFile struct {
	// Name - The file path.
	Name *string `json:"name,omitempty"`
	// URL - The URL of the file.
	URL *string `json:"url,omitempty"`
	// IsDirectory - Whether the object represents a directory.
	IsDirectory *bool `json:"isDirectory,omitempty"`
	// Properties - The file properties.
	Properties *FileProperties `json:"properties,omitempty"`
}

// NodeFileListResult response to a FileOperation.ListFromComputeNode or FileOperation.ListFromTask request.
type NodeFileListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of files.
	Value *[]NodeFile `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// NodeFileListResultIterator provides access to a complete listing of NodeFile values.
type NodeFileListResultIterator struct {
	i    int
	page NodeFileListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NodeFileListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NodeFileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NodeFileListResultIterator) Response() NodeFileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NodeFileListResultIterator) Value() NodeFile {
	if !iter.page.NotDone() {
		return NodeFile{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nflr NodeFileListResult) IsEmpty() bool {
	return nflr.Value == nil || len(*nflr.Value) == 0
}

// nodeFileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nflr NodeFileListResult) nodeFileListResultPreparer() (*http.Request, error) {
	if nflr.OdataNextLink == nil || len(to.String(nflr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nflr.OdataNextLink)))
}

// NodeFileListResultPage contains a page of NodeFile values.
type NodeFileListResultPage struct {
	fn   func(NodeFileListResult) (NodeFileListResult, error)
	nflr NodeFileListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NodeFileListResultPage) Next() error {
	next, err := page.fn(page.nflr)
	if err != nil {
		return err
	}
	page.nflr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NodeFileListResultPage) NotDone() bool {
	return !page.nflr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NodeFileListResultPage) Response() NodeFileListResult {
	return page.nflr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NodeFileListResultPage) Values() []NodeFile {
	if page.nflr.IsEmpty() {
		return nil
	}
	return *page.nflr.Value
}

// NodeRebootParameter parameters for a ComputeNodeOperations.Reboot request.
type NodeRebootParameter struct {
	// NodeRebootOption - When to reboot the compute node and what to do with currently running tasks. The default value is requeue. Possible values include: 'ComputeNodeRebootOptionRequeue', 'ComputeNodeRebootOptionTerminate', 'ComputeNodeRebootOptionTaskcompletion', 'ComputeNodeRebootOptionRetaineddata'
	NodeRebootOption ComputeNodeRebootOption `json:"nodeRebootOption,omitempty"`
}

// NodeReimageParameter parameters for a ComputeNodeOperations.Reimage request.
type NodeReimageParameter struct {
	// NodeReimageOption - When to reimage the compute node and what to do with currently running tasks. The default value is requeue. Possible values include: 'ComputeNodeReimageOptionRequeue', 'ComputeNodeReimageOptionTerminate', 'ComputeNodeReimageOptionTaskcompletion', 'ComputeNodeReimageOptionRetaineddata'
	NodeReimageOption ComputeNodeReimageOption `json:"nodeReimageOption,omitempty"`
}

// NodeRemoveParameter parameters for a ComputeNodeOperations.Remove request.
type NodeRemoveParameter struct {
	// NodeList - A list containing the id of the compute nodes to be removed from the specified pool.
	NodeList *[]string `json:"nodeList,omitempty"`
	// ResizeTimeout - The timeout for removal of compute nodes to the pool. The default value is 10 minutes.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - When compute nodes may be removed from the pool. Possible values include: 'Requeue', 'Terminate', 'Taskcompletion', 'Retaineddata'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// NodeUpdateUserParameter parameters for a ComputeNodeOperations.UpdateUser request.
type NodeUpdateUserParameter struct {
	// Password - The password of the account.
	Password *string `json:"password,omitempty"`
	// ExpiryTime - The time at which the account should expire. If omitted, the default is 1 day from the current time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// SSHPublicKey - The SSH public key that can be used for remote login to the compute node.
	SSHPublicKey *string `json:"sshPublicKey,omitempty"`
}

// PoolAddParameter a pool in the Azure Batch service to add.
type PoolAddParameter struct {
	// ID - A string that uniquely identifies the pool within the account. The id can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name for the pool.
	DisplayName *string `json:"displayName,omitempty"`
	// VMSize - The size of virtual machines in the pool. All virtual machines in a pool are the same size.
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - The cloud service configuration for the pool. This property and VirtualMachineConfiguration are mutually exclusive and one of the properties must be specified.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - The virtual machine configuration for the pool. This property and CloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// ResizeTimeout - The timeout for allocation of compute nodes to the pool. In a Get Pool operation, this is the timeout for the most recent resize operation. The default value is 10 minutes.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicated - The desired number of compute nodes in the pool. This property must have the default value if EnableAutoScale is true. It is required if EnableAutoScale is false.
	TargetDedicated *int32 `json:"targetDedicated,omitempty"`
	// EnableAutoScale - Whether the pool size should automatically adjust over time. If true, the AutoScaleFormula property must be set. If false, the TargetDedicated property must be set.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - A formula for the desired number of compute nodes in the pool.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - A time interval for the desired autoscale evaluation period in the pool.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// EnableInterNodeCommunication - Whether the pool permits direct communication between nodes.
	EnableInterNodeCommunication *bool `json:"enableInterNodeCommunication,omitempty"`
	// StartTask - A task specified to run on each compute node as it joins the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - The list of certificates to be installed on each compute node in the pool.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - The list of application packages to be installed on each compute node in the pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// MaxTasksPerNode - The maximum number of tasks that can run concurrently on a single compute node in the pool.
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - How the Batch service distributes tasks between compute nodes in the pool.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	// Metadata - A list of name-value pairs associated with the pool as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolEnableAutoScaleParameter parameters for a CloudPoolOperations.EnableAutoScale request.
type PoolEnableAutoScaleParameter struct {
	// AutoScaleFormula - The formula for the desired number of compute nodes in the pool.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - A time interval for the desired autoscale evaluation period in the pool.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
}

// PoolEvaluateAutoScaleParameter parameters for a CloudJobOperations.EvaluateAutoScale request.
type PoolEvaluateAutoScaleParameter struct {
	// AutoScaleFormula - A formula for the desired number of compute nodes in the pool.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
}

// PoolInformation specifies how a job should be assigned to a pool.
type PoolInformation struct {
	// PoolID - The id of an existing pool. All the tasks of the job will run on the specified pool. You must specify either PoolId or AutoPoolSpecification, but not both.
	PoolID *string `json:"poolId,omitempty"`
	// AutoPoolSpecification - Characteristics for a temporary 'auto pool'. The Batch service will create this auto pool and run all of the tasks of the job on it, and will delete the pool once the job has completed. You must specify either PoolId or AutoPoolSpecification, but not both.
	AutoPoolSpecification *AutoPoolSpecification `json:"autoPoolSpecification,omitempty"`
}

// PoolListPoolUsageMetricsResult response to an AccountOperation.ListPoolUsageMetrics request.
type PoolListPoolUsageMetricsResult struct {
	autorest.Response `json:"-"`
	// Value - The pool usage metrics data.
	Value *[]PoolUsageMetrics `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// PoolListPoolUsageMetricsResultIterator provides access to a complete listing of PoolUsageMetrics values.
type PoolListPoolUsageMetricsResultIterator struct {
	i    int
	page PoolListPoolUsageMetricsResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PoolListPoolUsageMetricsResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PoolListPoolUsageMetricsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PoolListPoolUsageMetricsResultIterator) Response() PoolListPoolUsageMetricsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PoolListPoolUsageMetricsResultIterator) Value() PoolUsageMetrics {
	if !iter.page.NotDone() {
		return PoolUsageMetrics{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (plpumr PoolListPoolUsageMetricsResult) IsEmpty() bool {
	return plpumr.Value == nil || len(*plpumr.Value) == 0
}

// poolListPoolUsageMetricsResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plpumr PoolListPoolUsageMetricsResult) poolListPoolUsageMetricsResultPreparer() (*http.Request, error) {
	if plpumr.OdataNextLink == nil || len(to.String(plpumr.OdataNextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plpumr.OdataNextLink)))
}

// PoolListPoolUsageMetricsResultPage contains a page of PoolUsageMetrics values.
type PoolListPoolUsageMetricsResultPage struct {
	fn     func(PoolListPoolUsageMetricsResult) (PoolListPoolUsageMetricsResult, error)
	plpumr PoolListPoolUsageMetricsResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PoolListPoolUsageMetricsResultPage) Next() error {
	next, err := page.fn(page.plpumr)
	if err != nil {
		return err
	}
	page.plpumr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PoolListPoolUsageMetricsResultPage) NotDone() bool {
	return !page.plpumr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PoolListPoolUsageMetricsResultPage) Response() PoolListPoolUsageMetricsResult {
	return page.plpumr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PoolListPoolUsageMetricsResultPage) Values() []PoolUsageMetrics {
	if page.plpumr.IsEmpty() {
		return nil
	}
	return *page.plpumr.Value
}

// PoolPatchParameter parameters for a CloudPoolOperations.Patch request.
type PoolPatchParameter struct {
	// StartTask - A task to run on each compute node as it joins the pool. If omitted, any existing start task is left unchanged.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - A list of certificates to be installed on each compute node in the pool. If omitted, any existing certificate references are left unchanged.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - A list of application packages to be installed on each compute node in the pool. If omitted, any existing application package references are left unchanged.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - A list of name-value pairs associated with the pool as metadata. If omitted, any existing metadata is left unchanged.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolResizeParameter parameters for a CloudPoolOperations.Resize request.
type PoolResizeParameter struct {
	// TargetDedicated - The desired number of compute nodes in the pool.
	TargetDedicated *int32 `json:"targetDedicated,omitempty"`
	// ResizeTimeout - The timeout for allocation of compute nodes to the pool or removal of compute nodes from the pool. The default value is 10 minutes.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// NodeDeallocationOption - When nodes may be removed from the pool, if the pool size is decreasing. Possible values include: 'Requeue', 'Terminate', 'Taskcompletion', 'Retaineddata'
	NodeDeallocationOption ComputeNodeDeallocationOption `json:"nodeDeallocationOption,omitempty"`
}

// PoolSpecification specification for creating a new pool.
type PoolSpecification struct {
	// DisplayName - The display name for the pool.
	DisplayName *string `json:"displayName,omitempty"`
	// VMSize - The size of the virtual machines in the pool. All virtual machines in a pool are the same size.
	VMSize *string `json:"vmSize,omitempty"`
	// CloudServiceConfiguration - The cloud service configuration for the pool. This property and VirtualMachineConfiguration are mutually exclusive and one of the properties must be specified.
	CloudServiceConfiguration *CloudServiceConfiguration `json:"cloudServiceConfiguration,omitempty"`
	// VirtualMachineConfiguration - The virtual machine configuration for the pool. This property and CloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
	VirtualMachineConfiguration *VirtualMachineConfiguration `json:"virtualMachineConfiguration,omitempty"`
	// MaxTasksPerNode - The maximum number of tasks that can run concurrently on a single compute node in the pool.
	MaxTasksPerNode *int32 `json:"maxTasksPerNode,omitempty"`
	// TaskSchedulingPolicy - How tasks are distributed among compute nodes in the pool.
	TaskSchedulingPolicy *TaskSchedulingPolicy `json:"taskSchedulingPolicy,omitempty"`
	// ResizeTimeout - The timeout for allocation of compute nodes to the pool.
	ResizeTimeout *string `json:"resizeTimeout,omitempty"`
	// TargetDedicated - The desired number of compute nodes in the pool.
	TargetDedicated *int32 `json:"targetDedicated,omitempty"`
	// EnableAutoScale - Whether the pool size should automatically adjust over time.
	EnableAutoScale *bool `json:"enableAutoScale,omitempty"`
	// AutoScaleFormula - The formula for the desired number of compute nodes in the pool.
	AutoScaleFormula *string `json:"autoScaleFormula,omitempty"`
	// AutoScaleEvaluationInterval - A time interval for the desired AutoScale evaluation period in the pool.
	AutoScaleEvaluationInterval *string `json:"autoScaleEvaluationInterval,omitempty"`
	// EnableInterNodeCommunication - Whether the pool permits direct communication between nodes.
	EnableInterNodeCommunication *bool `json:"enableInterNodeCommunication,omitempty"`
	// StartTask - A task to run on each compute node as it joins the pool. The task runs when the node is added to the pool or when the node is restarted.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - A list of certificates to be installed on each compute node in the pool.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - The list of application packages to be installed on each compute node in the pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - A list of name-value pairs associated with the pool as metadata.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolStatistics contains utilization and resource usage statistics for the lifetime of a pool.
type PoolStatistics struct {
	autorest.Response `json:"-"`
	// URL - The URL for the statistics.
	URL *string `json:"url,omitempty"`
	// StartTime - The start time of the time range covered by the statistics.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdateTime - The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// UsageStats - Statistics related to pool usage, such as the amount of core-time used.
	UsageStats *UsageStatistics `json:"usageStats,omitempty"`
	// ResourceStats - Statistics related to resource consumption by compute nodes in the pool.
	ResourceStats *ResourceStatistics `json:"resourceStats,omitempty"`
}

// PoolUpdatePropertiesParameter parameters for a CloudPoolOperations.UpdateProperties request.
type PoolUpdatePropertiesParameter struct {
	// StartTask - A task to run on each compute node as it joins the pool. If omitted, any existing start task is removed from the pool.
	StartTask *StartTask `json:"startTask,omitempty"`
	// CertificateReferences - A list of certificates to be installed on each compute node in the pool. If you specify an empty collection, any existing certificate references are removed from the pool.
	CertificateReferences *[]CertificateReference `json:"certificateReferences,omitempty"`
	// ApplicationPackageReferences - A list of application packages to be installed on each compute node in the pool. If you specify an empty collection, any existing application packages references are removed from the pool.
	ApplicationPackageReferences *[]ApplicationPackageReference `json:"applicationPackageReferences,omitempty"`
	// Metadata - A list of name-value pairs associated with the pool as metadata. If you specify an empty collection, any existing metadata is removed from the pool.
	Metadata *[]MetadataItem `json:"metadata,omitempty"`
}

// PoolUpgradeOSParameter parameters for a CloudPoolOperations.UpgradeOS request.
type PoolUpgradeOSParameter struct {
	// TargetOSVersion - The Azure Guest OS version to be installed on the virtual machines in the pool.
	TargetOSVersion *string `json:"targetOSVersion,omitempty"`
}

// PoolUsageMetrics usage metrics for a pool across an aggregation interval.
type PoolUsageMetrics struct {
	// PoolID - The id of the pool whose metrics are being aggregated.
	PoolID *string `json:"poolId,omitempty"`
	// StartTime - The start time of the aggregation interval.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the aggregation interval.
	EndTime *date.Time `json:"endTime,omitempty"`
	// VMSize - The size of virtual machines in the pool. All VMs in a pool are the same size.
	VMSize *string `json:"vmSize,omitempty"`
	// TotalCoreHours - The total core hours used in the pool during this aggregation interval.
	TotalCoreHours *float64 `json:"totalCoreHours,omitempty"`
	// DataIngressGiB - The cross data center network ingress in GiB to the pool during this interval.
	DataIngressGiB *float64 `json:"dataIngressGiB,omitempty"`
	// DataEgressGiB - The cross data center network egress in GiB from the pool during this interval.
	DataEgressGiB *float64 `json:"dataEgressGiB,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RecentJob information about the most recent job to run under the job schedule.
type RecentJob struct {
	// ID - The id of the job.
	ID *string `json:"id,omitempty"`
	// URL - The URL of the job.
	URL *string `json:"url,omitempty"`
}

// ResizeError an error that occurred when resizing a pool.
type ResizeError struct {
	// Code - An identifier for the pool resize error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the pool resize error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Values - A list of additional error details related to the pool resize error.
	Values *[]NameValuePair `json:"values,omitempty"`
}

// ResourceFile a file to be downloaded from Azure blob storage to a compute node.
type ResourceFile struct {
	// BlobSource - The URL of the file within Azure Blob Storage. This URL should include a shared access signature if the blob is not publicly readable.
	BlobSource *string `json:"blobSource,omitempty"`
	// FilePath - The location to which to download the file, relative to the task's working directory.
	FilePath *string `json:"filePath,omitempty"`
	// FileMode - The file mode attribute in octal format. This property will be ignored if it is specified for a resourceFile which will be downloaded to a Windows compute node.
	FileMode *string `json:"fileMode,omitempty"`
}

// ResourceStatistics statistics related to resource consumption by compute nodes in a pool.
type ResourceStatistics struct {
	// StartTime - The start time of the time range covered by the statistics.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdateTime - The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// AvgCPUPercentage - The average CPU usage across all nodes in the pool (percentage per node).
	AvgCPUPercentage *float64 `json:"avgCPUPercentage,omitempty"`
	// AvgMemoryGiB - The average memory usage in GiB across all nodes in the pool.
	AvgMemoryGiB *float64 `json:"avgMemoryGiB,omitempty"`
	// PeakMemoryGiB - The peak memory usage in GiB across all nodes in the pool.
	PeakMemoryGiB *float64 `json:"peakMemoryGiB,omitempty"`
	// AvgDiskGiB - The average used disk space in GiB across all nodes in the pool.
	AvgDiskGiB *float64 `json:"avgDiskGiB,omitempty"`
	// PeakDiskGiB - The peak used disk space in GiB across all nodes in the pool.
	PeakDiskGiB *float64 `json:"peakDiskGiB,omitempty"`
	// DiskReadIOps - The total number of disk read operations across all nodes in the pool.
	DiskReadIOps *int64 `json:"diskReadIOps,omitempty"`
	// DiskWriteIOps - The total number of disk write operations across all nodes in the pool.
	DiskWriteIOps *int64 `json:"diskWriteIOps,omitempty"`
	// DiskReadGiB - The total amount of data in GiB of disk reads across all nodes in the pool.
	DiskReadGiB *float64 `json:"diskReadGiB,omitempty"`
	// DiskWriteGiB - The total amount of data in GiB of disk writes across all nodes in the pool.
	DiskWriteGiB *float64 `json:"diskWriteGiB,omitempty"`
	// NetworkReadGiB - The total amount of data in GiB of network reads across all nodes in the pool.
	NetworkReadGiB *float64 `json:"networkReadGiB,omitempty"`
	// NetworkWriteGiB - The total amount of data in GiB of network writes across all nodes in the pool.
	NetworkWriteGiB *float64 `json:"networkWriteGiB,omitempty"`
}

// Schedule the schedule according to which jobs will be created
type Schedule struct {
	// DoNotRunUntil - The earliest time at which any job may be created under this job schedule. If you do not specify a doNotRunUntil time, the schedule becomes ready to create jobs immediately.
	DoNotRunUntil *date.Time `json:"doNotRunUntil,omitempty"`
	// DoNotRunAfter - A time after which no job will be created under this job schedule. The schedule will move to the completed state as soon as this deadline is past and there is no active job under this job schedule.
	DoNotRunAfter *date.Time `json:"doNotRunAfter,omitempty"`
	// StartWindow - The time interval, starting from the time at which the schedule indicates a job should be created, within which a job must be created. If a job is not created within the startWindow interval, then the 'opportunity' is lost; no job will be created until the next recurrence of the schedule.
	StartWindow *string `json:"startWindow,omitempty"`
	// RecurrenceInterval - The time interval between the start times of two successive jobs under the job schedule. A job schedule can have at most one active job under it at any given time.
	RecurrenceInterval *string `json:"recurrenceInterval,omitempty"`
}

// StartTask a task which is run when a compute node joins a pool in the Azure Batch service, or when the compute
// node is rebooted or reimaged.
type StartTask struct {
	// CommandLine - The command line of the start task.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - A list of files that the Batch service will download to the compute node before running the command line.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// EnvironmentSettings - A list of environment variable settings for the start task.
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// RunElevated - Whether to run the start task in elevated mode. The default value is false.
	RunElevated *bool `json:"runElevated,omitempty"`
	// MaxTaskRetryCount - The maximum number of times the task may be retried.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
	// WaitForSuccess - Whether the Batch service should wait for the start task to complete successfully (that is, to exit with exit code 0) before scheduling any tasks on the compute node.
	WaitForSuccess *bool `json:"waitForSuccess,omitempty"`
}

// StartTaskInformation information about a start task running on a compute node.
type StartTaskInformation struct {
	// State - The state of the start task on the compute node. Possible values include: 'StartTaskStateRunning', 'StartTaskStateCompleted'
	State StartTaskState `json:"state,omitempty"`
	// StartTime - The time at which the start task started running.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time at which the start task stopped running.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - The exit code of the start task.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// SchedulingError - Any error encountered scheduling the start task.
	SchedulingError *TaskSchedulingError `json:"schedulingError,omitempty"`
	// RetryCount - The number of times the task has been retried by the Batch service.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - The most recent time at which a retry of the task started running.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
}

// SubtaskInformation information about an Azure Batch subtask.
type SubtaskInformation struct {
	// ID - The id of the subtask.
	ID *int32 `json:"id,omitempty"`
	// NodeInfo - Information about the compute node on which the subtask ran.
	NodeInfo *ComputeNodeInformation `json:"nodeInfo,omitempty"`
	// StartTime - The time at which the subtask started running. If the subtask has been restarted or retried, this is the most recent time at which the subtask started running.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time at which the subtask completed. This property is set only if the subtask is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - The exit code of the subtask. This property is set only if the subtask is in the Completed state.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// SchedulingError - Details of any error encountered scheduling the subtask.
	SchedulingError *TaskSchedulingError `json:"schedulingError,omitempty"`
	// State - The current state of the subtask. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	State TaskState `json:"state,omitempty"`
	// StateTransitionTime - The time at which the subtask entered its current state.
	StateTransitionTime *date.Time `json:"stateTransitionTime,omitempty"`
	// PreviousState - The previous state of the subtask. This property is not set if the subtask is in its initial Active state. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	PreviousState TaskState `json:"previousState,omitempty"`
	// PreviousStateTransitionTime - The time at which the subtask entered its previous state. This property is not set if the subtask is in its initial Active state.
	PreviousStateTransitionTime *date.Time `json:"previousStateTransitionTime,omitempty"`
}

// TaskAddCollectionParameter a collection of Azure Batch tasks to add.
type TaskAddCollectionParameter struct {
	// Value - The collection of tasks to add.
	Value *[]TaskAddParameter `json:"value,omitempty"`
}

// TaskAddCollectionResult response to a TaskOperations.AddCollection request.
type TaskAddCollectionResult struct {
	autorest.Response `json:"-"`
	// Value - The results of the add task collection operation.
	Value *[]TaskAddResult `json:"value,omitempty"`
}

// TaskAddParameter an Azure Batch task to add.
type TaskAddParameter struct {
	// ID - A string that uniquely identifies the task within the job. The id can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters.
	ID *string `json:"id,omitempty"`
	// DisplayName - A display name for the task.
	DisplayName *string `json:"displayName,omitempty"`
	// CommandLine - The command line of the task. For multi-instance tasks, the command line is executed on the primary subtask after all the subtasks have finished executing the coordianation command line.
	CommandLine *string `json:"commandLine,omitempty"`
	// ResourceFiles - A list of files that the Batch service will download to the compute node before running the command line. For multi-instance tasks, the resource files will only be downloaded to the compute node on which the primary subtask is executed.
	ResourceFiles *[]ResourceFile `json:"resourceFiles,omitempty"`
	// EnvironmentSettings - A list of environment variable settings for the task.
	EnvironmentSettings *[]EnvironmentSetting `json:"environmentSettings,omitempty"`
	// AffinityInfo - A locality hint that can be used by the Batch service to select a compute node on which to start the new task.
	AffinityInfo *AffinityInformation `json:"affinityInfo,omitempty"`
	// Constraints - The execution constraints that apply to this task.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
	// RunElevated - Whether to run the task in elevated mode.
	RunElevated *bool `json:"runElevated,omitempty"`
	// MultiInstanceSettings - Information about how to run the multi-instance task.
	MultiInstanceSettings *MultiInstanceSettings `json:"multiInstanceSettings,omitempty"`
	// DependsOn - Any other tasks that this task depends on.
	DependsOn *TaskDependencies `json:"dependsOn,omitempty"`
}

// TaskAddResult result for a single task added as part of an add task collection operation.
type TaskAddResult struct {
	// Status - The status of the add task request. Possible values include: 'TaskAddStatusSuccess', 'TaskAddStatusClienterror', 'TaskAddStatusServererror', 'TaskAddStatusUnmapped'
	Status TaskAddStatus `json:"status,omitempty"`
	// TaskID - The id of the task for which this is the result.
	TaskID *string `json:"taskId,omitempty"`
	// ETag - The ETag of the task, if the task was successfully added.
	ETag *string `json:"eTag,omitempty"`
	// LastModified - The last modified time of the task.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// Location - The URL of the task, if the task was successfully added.
	Location *string `json:"location,omitempty"`
	// Error - The error encountered while attempting to add the task.
	Error *Error `json:"error,omitempty"`
}

// TaskConstraints constraints to apply to the Job Manager task.
type TaskConstraints struct {
	// MaxWallClockTime - The maximum elapsed time that the task may run, measured from the time the task starts. If the task does not complete within the time limit, the Batch service terminates it.
	MaxWallClockTime *string `json:"maxWallClockTime,omitempty"`
	// RetentionTime - The minimum time to retain the working directory for the task on the compute node where it ran, from the time it completes execution. After this time, the Batch service may delete the working directory and all its contents. The default is infinite.
	RetentionTime *string `json:"retentionTime,omitempty"`
	// MaxTaskRetryCount - The maximum number of times the task may be retried. The Batch service retries a task if its exit code is nonzero.
	MaxTaskRetryCount *int32 `json:"maxTaskRetryCount,omitempty"`
}

// TaskDependencies specifies any dependencies of a task. Any task that is explicitly specified or within a
// dependency range must complete before the dependant task will be scheduled.
type TaskDependencies struct {
	// TaskIds - The list of task ids that must complete before this task can be scheduled.
	TaskIds *[]string `json:"taskIds,omitempty"`
	// TaskIDRanges - The list of task ranges that must complete before this task can be scheduled.
	TaskIDRanges *[]TaskIDRange `json:"taskIdRanges,omitempty"`
}

// TaskExecutionInformation information about the execution of a task.
type TaskExecutionInformation struct {
	// StartTime - The time at which the task started running. If the task has been restarted or retried, this is the most recent time at which the task started running.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time at which the task completed. This property is set only if the task is in the Completed state.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExitCode - The exit code of the task. This property is set only if the task is in completed state.
	ExitCode *int32 `json:"exitCode,omitempty"`
	// SchedulingError - Details of any error encountered scheduling the task.
	SchedulingError *TaskSchedulingError `json:"schedulingError,omitempty"`
	// RetryCount - The number of times the task has been retried by the Batch service.
	RetryCount *int32 `json:"retryCount,omitempty"`
	// LastRetryTime - The most recent time at which a retry of the task started running.
	LastRetryTime *date.Time `json:"lastRetryTime,omitempty"`
	// RequeueCount - The number of times the task has been requeued by the Batch service as the result of a user request.
	RequeueCount *int32 `json:"requeueCount,omitempty"`
	// LastRequeueTime - The most recent time at which the task has been requeued by the Batch service as the result of a user request.
	LastRequeueTime *date.Time `json:"lastRequeueTime,omitempty"`
}

// TaskIDRange a range of task ids that a task can depend on. All tasks with ids in the range must complete
// successfully before the dependent task can be scheduled.
type TaskIDRange struct {
	// Start - The first task id in the range.
	Start *int32 `json:"start,omitempty"`
	// End - The last task id in the range.
	End *int32 `json:"end,omitempty"`
}

// TaskInformation information about a task running on a compute node.
type TaskInformation struct {
	// TaskURL - The URL of the task.
	TaskURL *string `json:"taskUrl,omitempty"`
	// JobID - The id of the job to which the task belongs.
	JobID *string `json:"jobId,omitempty"`
	// TaskID - The id of the task.
	TaskID *string `json:"taskId,omitempty"`
	// SubtaskID - The id of the subtask if the task is a multi-instance task.
	SubtaskID *int32 `json:"subtaskId,omitempty"`
	// TaskState - The current state of the task. Possible values include: 'TaskStateActive', 'TaskStatePreparing', 'TaskStateRunning', 'TaskStateCompleted'
	TaskState TaskState `json:"taskState,omitempty"`
	// ExecutionInfo - Information about the execution of the task.
	ExecutionInfo *TaskExecutionInformation `json:"executionInfo,omitempty"`
}

// TaskSchedulingError information about an error when scheduling a task.
type TaskSchedulingError struct {
	// Category - The category of the task scheduling error. Possible values include: 'SchedulingErrorCategoryUsererror', 'SchedulingErrorCategoryServererror', 'SchedulingErrorCategoryUnmapped'
	Category SchedulingErrorCategory `json:"category,omitempty"`
	// Code - An identifier for the task scheduling error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the task scheduling error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Details - The list of additional error details related to the scheduling error.
	Details *[]NameValuePair `json:"details,omitempty"`
}

// TaskSchedulingPolicy specifies how tasks should be distributed across compute nodes.
type TaskSchedulingPolicy struct {
	// NodeFillType - How tasks should be distributed across compute nodes. Possible values include: 'ComputeNodeFillTypeSpread', 'ComputeNodeFillTypePack', 'ComputeNodeFillTypeUnmapped'
	NodeFillType ComputeNodeFillType `json:"nodeFillType,omitempty"`
}

// TaskStatistics resource usage statistics for a task.
type TaskStatistics struct {
	// URL - The URL of the statistics.
	URL *string `json:"url,omitempty"`
	// StartTime - The start time of the time range covered by the statistics.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdateTime - The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// UserCPUTime - The total user mode CPU time (summed across all cores and all compute nodes) consumed by the task.
	UserCPUTime *string `json:"userCPUTime,omitempty"`
	// KernelCPUTime - The total kernel mode CPU time (summed across all cores and all compute nodes) consumed by the task.
	KernelCPUTime *string `json:"kernelCPUTime,omitempty"`
	// WallClockTime - The total wall clock time of the task.
	WallClockTime *string `json:"wallClockTime,omitempty"`
	// ReadIOps - The total number of disk read operations made by the task.
	ReadIOps *int64 `json:"readIOps,omitempty"`
	// WriteIOps - The total number of disk write operations made by the task.
	WriteIOps *int64 `json:"writeIOps,omitempty"`
	// ReadIOGiB - The total gibibytes read from disk by the task.
	ReadIOGiB *float64 `json:"readIOGiB,omitempty"`
	// WriteIOGiB - The total gibibytes written to disk by the task.
	WriteIOGiB *float64 `json:"writeIOGiB,omitempty"`
	// WaitTime - The total wait time of the task. The wait time for a task is defined as the elapsed time between the creation of the task and the start of task execution. (If the task is retried due to failures, the wait time is the time to the most recent task execution.)
	WaitTime *string `json:"waitTime,omitempty"`
}

// TaskUpdateParameter parameters for a CloudTaskOperations.Update request.
type TaskUpdateParameter struct {
	// Constraints - Constraints that apply to this task. If omitted, the task is given the default constraints.
	Constraints *TaskConstraints `json:"constraints,omitempty"`
}

// UsageStatistics statistics related to pool usage information.
type UsageStatistics struct {
	// StartTime - The start time of the time range covered by the statistics.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastUpdateTime - The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// DedicatedCoreTime - The aggregated wall-clock time of the dedicated compute node cores being part of the pool.
	DedicatedCoreTime *string `json:"dedicatedCoreTime,omitempty"`
}

// VirtualMachineConfiguration the configuration for compute nodes in a pool based on the Azure Virtual Machines
// infrastructure.
type VirtualMachineConfiguration struct {
	// ImageReference - A reference to the Azure Virtual Machines Marketplace image to use.
	ImageReference *ImageReference `json:"imageReference,omitempty"`
	// NodeAgentSKUID - The SKU of Batch Node Agent to be provisioned on the compute node. The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems.
	NodeAgentSKUID *string `json:"nodeAgentSKUId,omitempty"`
	// WindowsConfiguration - Windows operating system settings on the virtual machine. This property must not be specified if the ImageReference property specifies a Linux OS image.
	WindowsConfiguration *WindowsConfiguration `json:"windowsConfiguration,omitempty"`
}

// WindowsConfiguration windows operating system settings to apply to the virtual machine.
type WindowsConfiguration struct {
	// EnableAutomaticUpdates - Whether automatic updates are enabled on the virtual machine. If omitted, the default value is true.
	EnableAutomaticUpdates *bool `json:"enableAutomaticUpdates,omitempty"`
}
