// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteComponentInput"}

	if s.ComponentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentName"))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Ungroups a custom component. When you ungroup custom components, all applicable
// monitors that are set up for the component are removed and the instances
// revert to their standalone status.
//
//    // Example sending a request using DeleteComponentRequest.
//    req := client.DeleteComponentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DeleteComponent
func (c *Client) DeleteComponentRequest(input *DeleteComponentInput) DeleteComponentRequest {
	op := &aws.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	req := c.newRequest(op, input, &DeleteComponentOutput{})
	return DeleteComponentRequest{Request: req, Input: input, Copy: c.DeleteComponentRequest}
}

// DeleteComponentRequest is the request type for the
// DeleteComponent API operation.
type DeleteComponentRequest struct {
	*aws.Request
	Input *DeleteComponentInput
	Copy  func(*DeleteComponentInput) DeleteComponentRequest
}

// Send marshals and sends the DeleteComponent API request.
func (r DeleteComponentRequest) Send(ctx context.Context) (*DeleteComponentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteComponentResponse{
		DeleteComponentOutput: r.Request.Data.(*DeleteComponentOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteComponentResponse is the response type for the
// DeleteComponent API operation.
type DeleteComponentResponse struct {
	*DeleteComponentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteComponent request.
func (r *DeleteComponentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
