// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Represents the input of a CreateApiCache operation.
type CreateApiCacheInput struct {
	_ struct{} `type:"structure"`

	// Caching behavior.
	//
	//    * FULL_REQUEST_CACHING: All requests are fully cached.
	//
	//    * PER_RESOLVER_CACHING: Individual resovlers that you specify are cached.
	//
	// ApiCachingBehavior is a required field
	ApiCachingBehavior ApiCachingBehavior `locationName:"apiCachingBehavior" type:"string" required:"true" enum:"true"`

	// The GraphQL API Id.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// At rest encryption flag for cache. This setting cannot be updated after creation.
	AtRestEncryptionEnabled *bool `locationName:"atRestEncryptionEnabled" type:"boolean"`

	// Transit encryption flag when connecting to cache. This setting cannot be
	// updated after creation.
	TransitEncryptionEnabled *bool `locationName:"transitEncryptionEnabled" type:"boolean"`

	// TTL in seconds for cache entries.
	//
	// Valid values are between 1 and 3600 seconds.
	//
	// Ttl is a required field
	Ttl *int64 `locationName:"ttl" type:"long" required:"true"`

	// The cache instance type.
	//
	//    * T2_SMALL: A t2.small instance type.
	//
	//    * T2_MEDIUM: A t2.medium instance type.
	//
	//    * R4_LARGE: A r4.large instance type.
	//
	//    * R4_XLARGE: A r4.xlarge instance type.
	//
	//    * R4_2XLARGE: A r4.2xlarge instance type.
	//
	//    * R4_4XLARGE: A r4.4xlarge instance type.
	//
	//    * R4_8XLARGE: A r4.8xlarge instance type.
	//
	// Type is a required field
	Type ApiCacheType `locationName:"type" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateApiCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApiCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApiCacheInput"}
	if len(s.ApiCachingBehavior) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ApiCachingBehavior"))
	}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.Ttl == nil {
		invalidParams.Add(aws.NewErrParamRequired("Ttl"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApiCacheInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.ApiCachingBehavior) > 0 {
		v := s.ApiCachingBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiCachingBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AtRestEncryptionEnabled != nil {
		v := *s.AtRestEncryptionEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "atRestEncryptionEnabled", protocol.BoolValue(v), metadata)
	}
	if s.TransitEncryptionEnabled != nil {
		v := *s.TransitEncryptionEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "transitEncryptionEnabled", protocol.BoolValue(v), metadata)
	}
	if s.Ttl != nil {
		v := *s.Ttl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ttl", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a CreateApiCache operation.
type CreateApiCacheOutput struct {
	_ struct{} `type:"structure"`

	// The ApiCache object.
	ApiCache *ApiCache `locationName:"apiCache" type:"structure"`
}

// String returns the string representation
func (s CreateApiCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApiCacheOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiCache != nil {
		v := s.ApiCache

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "apiCache", v, metadata)
	}
	return nil
}

const opCreateApiCache = "CreateApiCache"

// CreateApiCacheRequest returns a request value for making API operation for
// AWS AppSync.
//
// Creates a cache for the GraphQL API.
//
//    // Example sending a request using CreateApiCacheRequest.
//    req := client.CreateApiCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache
func (c *Client) CreateApiCacheRequest(input *CreateApiCacheInput) CreateApiCacheRequest {
	op := &aws.Operation{
		Name:       opCreateApiCache,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apis/{apiId}/ApiCaches",
	}

	if input == nil {
		input = &CreateApiCacheInput{}
	}

	req := c.newRequest(op, input, &CreateApiCacheOutput{})
	return CreateApiCacheRequest{Request: req, Input: input, Copy: c.CreateApiCacheRequest}
}

// CreateApiCacheRequest is the request type for the
// CreateApiCache API operation.
type CreateApiCacheRequest struct {
	*aws.Request
	Input *CreateApiCacheInput
	Copy  func(*CreateApiCacheInput) CreateApiCacheRequest
}

// Send marshals and sends the CreateApiCache API request.
func (r CreateApiCacheRequest) Send(ctx context.Context) (*CreateApiCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateApiCacheResponse{
		CreateApiCacheOutput: r.Request.Data.(*CreateApiCacheOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateApiCacheResponse is the response type for the
// CreateApiCache API operation.
type CreateApiCacheResponse struct {
	*CreateApiCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApiCache request.
func (r *CreateApiCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
