// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type PutNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The type of event that causes the notification to be sent. For more information
	// about notification types supported by Amazon EC2 Auto Scaling, see DescribeAutoScalingNotificationTypes.
	//
	// NotificationTypes is a required field
	NotificationTypes []string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (Amazon SNS) topic.
	//
	// TopicARN is a required field
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutNotificationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutNotificationConfigurationInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.NotificationTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotificationTypes"))
	}

	if s.TopicARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicARN"))
	}
	if s.TopicARN != nil && len(*s.TopicARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TopicARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutNotificationConfiguration = "PutNotificationConfiguration"

// PutNotificationConfigurationRequest returns a request value for making API operation for
// Auto Scaling.
//
// Configures an Auto Scaling group to send notifications when specified events
// take place. Subscribers to the specified topic can have messages delivered
// to an endpoint such as a web server or an email address.
//
// This configuration overwrites any existing configuration.
//
// For more information, see Getting Amazon SNS Notifications When Your Auto
// Scaling Group Scales (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using PutNotificationConfigurationRequest.
//    req := client.PutNotificationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration
func (c *Client) PutNotificationConfigurationRequest(input *PutNotificationConfigurationInput) PutNotificationConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutNotificationConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutNotificationConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutNotificationConfigurationRequest{Request: req, Input: input, Copy: c.PutNotificationConfigurationRequest}
}

// PutNotificationConfigurationRequest is the request type for the
// PutNotificationConfiguration API operation.
type PutNotificationConfigurationRequest struct {
	*aws.Request
	Input *PutNotificationConfigurationInput
	Copy  func(*PutNotificationConfigurationInput) PutNotificationConfigurationRequest
}

// Send marshals and sends the PutNotificationConfiguration API request.
func (r PutNotificationConfigurationRequest) Send(ctx context.Context) (*PutNotificationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutNotificationConfigurationResponse{
		PutNotificationConfigurationOutput: r.Request.Data.(*PutNotificationConfigurationOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutNotificationConfigurationResponse is the response type for the
// PutNotificationConfiguration API operation.
type PutNotificationConfigurationResponse struct {
	*PutNotificationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutNotificationConfiguration request.
func (r *PutNotificationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
