// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecoveryPointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeRecoveryPointInput"}

	if s.BackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupVaultName"))
	}

	if s.RecoveryPointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecoveryPointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRecoveryPointInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "backupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "recoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	BackupVaultName *string `type:"string"`

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle `type:"structure"`

	// The date and time that a job to create a recovery point is completed, in
	// Unix format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId
	// of the backup plan used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time that a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// The server-side encryption key used to protect your backups; for example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// A Boolean value that is returned as TRUE if the specified recovery point
	// is encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted *bool `type:"boolean"`

	// The date and time that a recovery point was last restored, in Unix format
	// and Coordinated Universal Time (UTC). The value of LastRestoreTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	LastRestoreTime *time.Time `type:"timestamp"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. AWS Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups that are transitioned to cold storage must be stored in cold storage
	// for a minimum of 90 days. Therefore, the “expire after days” setting
	// must be 90 days greater than the “transition to cold after days” setting.
	// The “transition to cold after days” setting cannot be changed after a
	// backup has been transitioned to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a saved resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// The type of AWS resource to save as a recovery point; for example, an Amazon
	// Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `type:"string"`

	// A status code specifying the state of the recovery point.
	//
	// A partial status indicates that the recovery point was not successfully re-created
	// and must be retried.
	Status RecoveryPointStatus `type:"string" enum:"true"`

	// Specifies the storage class of the recovery point. Valid values are WARM
	// or COLD.
	StorageClass StorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeRecoveryPointOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupSizeInBytes != nil {
		v := *s.BackupSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.BackupVaultArn != nil {
		v := *s.BackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BackupVaultName != nil {
		v := *s.BackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CalculatedLifecycle != nil {
		v := s.CalculatedLifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CalculatedLifecycle", v, metadata)
	}
	if s.CompletionDate != nil {
		v := *s.CompletionDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletionDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreatedBy != nil {
		v := s.CreatedBy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CreatedBy", v, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EncryptionKeyArn != nil {
		v := *s.EncryptionKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsEncrypted != nil {
		v := *s.IsEncrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsEncrypted", protocol.BoolValue(v), metadata)
	}
	if s.LastRestoreTime != nil {
		v := *s.LastRestoreTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastRestoreTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opDescribeRecoveryPoint = "DescribeRecoveryPoint"

// DescribeRecoveryPointRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns metadata associated with a recovery point, including ID, status,
// encryption, and lifecycle.
//
//    // Example sending a request using DescribeRecoveryPointRequest.
//    req := client.DescribeRecoveryPointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint
func (c *Client) DescribeRecoveryPointRequest(input *DescribeRecoveryPointInput) DescribeRecoveryPointRequest {
	op := &aws.Operation{
		Name:       opDescribeRecoveryPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
	}

	if input == nil {
		input = &DescribeRecoveryPointInput{}
	}

	req := c.newRequest(op, input, &DescribeRecoveryPointOutput{})
	return DescribeRecoveryPointRequest{Request: req, Input: input, Copy: c.DescribeRecoveryPointRequest}
}

// DescribeRecoveryPointRequest is the request type for the
// DescribeRecoveryPoint API operation.
type DescribeRecoveryPointRequest struct {
	*aws.Request
	Input *DescribeRecoveryPointInput
	Copy  func(*DescribeRecoveryPointInput) DescribeRecoveryPointRequest
}

// Send marshals and sends the DescribeRecoveryPoint API request.
func (r DescribeRecoveryPointRequest) Send(ctx context.Context) (*DescribeRecoveryPointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeRecoveryPointResponse{
		DescribeRecoveryPointOutput: r.Request.Data.(*DescribeRecoveryPointOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeRecoveryPointResponse is the response type for the
// DescribeRecoveryPoint API operation.
type DescribeRecoveryPointResponse struct {
	*DescribeRecoveryPointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeRecoveryPoint request.
func (r *DescribeRecoveryPointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
