// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRoomMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRoomMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoomMembershipsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRoomMembershipsInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.RoomId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoomId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRoomMembershipsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "roomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRoomMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The room membership details.
	RoomMemberships []RoomMembership `type:"list"`
}

// String returns the string representation
func (s ListRoomMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRoomMembershipsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomMemberships != nil {
		v := s.RoomMemberships

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RoomMemberships", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRoomMemberships = "ListRoomMemberships"

// ListRoomMembershipsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the membership details for the specified room, such as member IDs,
// member email addresses, and member names.
//
//    // Example sending a request using ListRoomMembershipsRequest.
//    req := client.ListRoomMembershipsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships
func (c *Client) ListRoomMembershipsRequest(input *ListRoomMembershipsInput) ListRoomMembershipsRequest {
	op := &aws.Operation{
		Name:       opListRoomMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomMembershipsInput{}
	}

	req := c.newRequest(op, input, &ListRoomMembershipsOutput{})
	return ListRoomMembershipsRequest{Request: req, Input: input, Copy: c.ListRoomMembershipsRequest}
}

// ListRoomMembershipsRequest is the request type for the
// ListRoomMemberships API operation.
type ListRoomMembershipsRequest struct {
	*aws.Request
	Input *ListRoomMembershipsInput
	Copy  func(*ListRoomMembershipsInput) ListRoomMembershipsRequest
}

// Send marshals and sends the ListRoomMemberships API request.
func (r ListRoomMembershipsRequest) Send(ctx context.Context) (*ListRoomMembershipsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRoomMembershipsResponse{
		ListRoomMembershipsOutput: r.Request.Data.(*ListRoomMembershipsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRoomMembershipsRequestPaginator returns a paginator for ListRoomMemberships.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRoomMembershipsRequest(input)
//   p := chime.NewListRoomMembershipsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRoomMembershipsPaginator(req ListRoomMembershipsRequest) ListRoomMembershipsPaginator {
	return ListRoomMembershipsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRoomMembershipsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRoomMembershipsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRoomMembershipsPaginator struct {
	aws.Pager
}

func (p *ListRoomMembershipsPaginator) CurrentPage() *ListRoomMembershipsOutput {
	return p.Pager.CurrentPage().(*ListRoomMembershipsOutput)
}

// ListRoomMembershipsResponse is the response type for the
// ListRoomMemberships API operation.
type ListRoomMembershipsResponse struct {
	*ListRoomMembershipsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRoomMemberships request.
func (r *ListRoomMembershipsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
