// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListApprovalRuleTemplatesInput struct {
	_ struct{} `type:"structure"`

	// A non-zero, non-negative integer used to limit the number of returned results.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that, when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApprovalRuleTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

type ListApprovalRuleTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The names of all the approval rule templates found in the AWS Region for
	// your AWS account.
	ApprovalRuleTemplateNames []string `locationName:"approvalRuleTemplateNames" type:"list"`

	// An enumeration token that allows the operation to batch the next results
	// of the operation.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApprovalRuleTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListApprovalRuleTemplates = "ListApprovalRuleTemplates"

// ListApprovalRuleTemplatesRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Lists all approval rule templates in the specified AWS Region in your AWS
// account. If an AWS Region is not specified, the AWS Region where you are
// signed in is used.
//
//    // Example sending a request using ListApprovalRuleTemplatesRequest.
//    req := client.ListApprovalRuleTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates
func (c *Client) ListApprovalRuleTemplatesRequest(input *ListApprovalRuleTemplatesInput) ListApprovalRuleTemplatesRequest {
	op := &aws.Operation{
		Name:       opListApprovalRuleTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApprovalRuleTemplatesInput{}
	}

	req := c.newRequest(op, input, &ListApprovalRuleTemplatesOutput{})
	return ListApprovalRuleTemplatesRequest{Request: req, Input: input, Copy: c.ListApprovalRuleTemplatesRequest}
}

// ListApprovalRuleTemplatesRequest is the request type for the
// ListApprovalRuleTemplates API operation.
type ListApprovalRuleTemplatesRequest struct {
	*aws.Request
	Input *ListApprovalRuleTemplatesInput
	Copy  func(*ListApprovalRuleTemplatesInput) ListApprovalRuleTemplatesRequest
}

// Send marshals and sends the ListApprovalRuleTemplates API request.
func (r ListApprovalRuleTemplatesRequest) Send(ctx context.Context) (*ListApprovalRuleTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListApprovalRuleTemplatesResponse{
		ListApprovalRuleTemplatesOutput: r.Request.Data.(*ListApprovalRuleTemplatesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListApprovalRuleTemplatesRequestPaginator returns a paginator for ListApprovalRuleTemplates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListApprovalRuleTemplatesRequest(input)
//   p := codecommit.NewListApprovalRuleTemplatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListApprovalRuleTemplatesPaginator(req ListApprovalRuleTemplatesRequest) ListApprovalRuleTemplatesPaginator {
	return ListApprovalRuleTemplatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListApprovalRuleTemplatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListApprovalRuleTemplatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListApprovalRuleTemplatesPaginator struct {
	aws.Pager
}

func (p *ListApprovalRuleTemplatesPaginator) CurrentPage() *ListApprovalRuleTemplatesOutput {
	return p.Pager.CurrentPage().(*ListApprovalRuleTemplatesOutput)
}

// ListApprovalRuleTemplatesResponse is the response type for the
// ListApprovalRuleTemplates API operation.
type ListApprovalRuleTemplatesResponse struct {
	*ListApprovalRuleTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListApprovalRuleTemplates request.
func (r *ListApprovalRuleTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
