// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeKeyPhrasesDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a key phrases detection
	// job.
	KeyPhrasesDetectionJobProperties *KeyPhrasesDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeKeyPhrasesDetectionJob = "DescribeKeyPhrasesDetectionJob"

// DescribeKeyPhrasesDetectionJobRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets the properties associated with a key phrases detection job. Use this
// operation to get the status of a detection job.
//
//    // Example sending a request using DescribeKeyPhrasesDetectionJobRequest.
//    req := client.DescribeKeyPhrasesDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Client) DescribeKeyPhrasesDetectionJobRequest(input *DescribeKeyPhrasesDetectionJobInput) DescribeKeyPhrasesDetectionJobRequest {
	op := &aws.Operation{
		Name:       opDescribeKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPhrasesDetectionJobInput{}
	}

	req := c.newRequest(op, input, &DescribeKeyPhrasesDetectionJobOutput{})
	return DescribeKeyPhrasesDetectionJobRequest{Request: req, Input: input, Copy: c.DescribeKeyPhrasesDetectionJobRequest}
}

// DescribeKeyPhrasesDetectionJobRequest is the request type for the
// DescribeKeyPhrasesDetectionJob API operation.
type DescribeKeyPhrasesDetectionJobRequest struct {
	*aws.Request
	Input *DescribeKeyPhrasesDetectionJobInput
	Copy  func(*DescribeKeyPhrasesDetectionJobInput) DescribeKeyPhrasesDetectionJobRequest
}

// Send marshals and sends the DescribeKeyPhrasesDetectionJob API request.
func (r DescribeKeyPhrasesDetectionJobRequest) Send(ctx context.Context) (*DescribeKeyPhrasesDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeKeyPhrasesDetectionJobResponse{
		DescribeKeyPhrasesDetectionJobOutput: r.Request.Data.(*DescribeKeyPhrasesDetectionJobOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeKeyPhrasesDetectionJobResponse is the response type for the
// DescribeKeyPhrasesDetectionJob API operation.
type DescribeKeyPhrasesDetectionJobResponse struct {
	*DescribeKeyPhrasesDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeKeyPhrasesDetectionJob request.
func (r *DescribeKeyPhrasesDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
