// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request to update a revision.
type UpdateRevisionInput struct {
	_ struct{} `type:"structure"`

	// An optional comment about the revision.
	Comment *string `type:"string"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// Finalizing a revision tells AWS Data Exchange that your changes to the assets
	// in the revision are complete. After it's in this read-only state, you can
	// publish the revision to your products.
	Finalized *bool `type:"boolean"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRevisionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRevisionInput"}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRevisionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Finalized != nil {
		v := *s.Finalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Finalized", protocol.BoolValue(v), metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRevisionOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies an AWS resource.
	Arn *string `type:"string"`

	Comment *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A unique identifier.
	DataSetId *string `type:"string"`

	Finalized *bool `type:"boolean"`

	// A unique identifier.
	Id *string `type:"string"`

	// A unique identifier.
	SourceId *string `type:"string"`

	// Dates and times in AWS Data Exchange are recorded in ISO 8601 format.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s UpdateRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRevisionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Finalized != nil {
		v := *s.Finalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Finalized", protocol.BoolValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceId != nil {
		v := *s.SourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opUpdateRevision = "UpdateRevision"

// UpdateRevisionRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation updates a revision.
//
//    // Example sending a request using UpdateRevisionRequest.
//    req := client.UpdateRevisionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/UpdateRevision
func (c *Client) UpdateRevisionRequest(input *UpdateRevisionInput) UpdateRevisionRequest {
	op := &aws.Operation{
		Name:       opUpdateRevision,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}",
	}

	if input == nil {
		input = &UpdateRevisionInput{}
	}

	req := c.newRequest(op, input, &UpdateRevisionOutput{})
	return UpdateRevisionRequest{Request: req, Input: input, Copy: c.UpdateRevisionRequest}
}

// UpdateRevisionRequest is the request type for the
// UpdateRevision API operation.
type UpdateRevisionRequest struct {
	*aws.Request
	Input *UpdateRevisionInput
	Copy  func(*UpdateRevisionInput) UpdateRevisionRequest
}

// Send marshals and sends the UpdateRevision API request.
func (r UpdateRevisionRequest) Send(ctx context.Context) (*UpdateRevisionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRevisionResponse{
		UpdateRevisionOutput: r.Request.Data.(*UpdateRevisionOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRevisionResponse is the response type for the
// UpdateRevision API operation.
type UpdateRevisionResponse struct {
	*UpdateRevisionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRevision request.
func (r *UpdateRevisionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
