// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetNetworkProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the network profile you want to return
	// information about.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetNetworkProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNetworkProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetNetworkProfileInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetNetworkProfileOutput struct {
	_ struct{} `type:"structure"`

	// The network profile.
	NetworkProfile *NetworkProfile `locationName:"networkProfile" type:"structure"`
}

// String returns the string representation
func (s GetNetworkProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetNetworkProfile = "GetNetworkProfile"

// GetNetworkProfileRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Returns information about a network profile.
//
//    // Example sending a request using GetNetworkProfileRequest.
//    req := client.GetNetworkProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetNetworkProfile
func (c *Client) GetNetworkProfileRequest(input *GetNetworkProfileInput) GetNetworkProfileRequest {
	op := &aws.Operation{
		Name:       opGetNetworkProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNetworkProfileInput{}
	}

	req := c.newRequest(op, input, &GetNetworkProfileOutput{})
	return GetNetworkProfileRequest{Request: req, Input: input, Copy: c.GetNetworkProfileRequest}
}

// GetNetworkProfileRequest is the request type for the
// GetNetworkProfile API operation.
type GetNetworkProfileRequest struct {
	*aws.Request
	Input *GetNetworkProfileInput
	Copy  func(*GetNetworkProfileInput) GetNetworkProfileRequest
}

// Send marshals and sends the GetNetworkProfile API request.
func (r GetNetworkProfileRequest) Send(ctx context.Context) (*GetNetworkProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetNetworkProfileResponse{
		GetNetworkProfileOutput: r.Request.Data.(*GetNetworkProfileOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetNetworkProfileResponse is the response type for the
// GetNetworkProfile API operation.
type GetNetworkProfileResponse struct {
	*GetNetworkProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetNetworkProfile request.
func (r *GetNetworkProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
