// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeConnectionLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of the connection.
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// The standard media type for the LOA-CFA document. The only supported value
	// is application/pdf.
	LoaContentType LoaContentType `locationName:"loaContentType" type:"string" enum:"true"`

	// The name of the APN partner or service provider who establishes connectivity
	// on your behalf. If you specify this parameter, the LOA-CFA lists the provider
	// name alongside your company name as the requester of the cross connect.
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionLoaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionLoaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConnectionLoaInput"}

	if s.ConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeConnectionLoaOutput struct {
	_ struct{} `type:"structure"`

	// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA).
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeConnectionLoaOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConnectionLoa = "DescribeConnectionLoa"

// DescribeConnectionLoaRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Deprecated. Use DescribeLoa instead.
//
// Gets the LOA-CFA for a connection.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that your APN partner or service provider uses when establishing
// your cross connect to AWS at the colocation facility. For more information,
// see Requesting Cross Connects at AWS Direct Connect Locations (https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect User Guide.
//
//    // Example sending a request using DescribeConnectionLoaRequest.
//    req := client.DescribeConnectionLoaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
func (c *Client) DescribeConnectionLoaRequest(input *DescribeConnectionLoaInput) DescribeConnectionLoaRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeConnectionLoa, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opDescribeConnectionLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionLoaInput{}
	}

	req := c.newRequest(op, input, &DescribeConnectionLoaOutput{})
	return DescribeConnectionLoaRequest{Request: req, Input: input, Copy: c.DescribeConnectionLoaRequest}
}

// DescribeConnectionLoaRequest is the request type for the
// DescribeConnectionLoa API operation.
type DescribeConnectionLoaRequest struct {
	*aws.Request
	Input *DescribeConnectionLoaInput
	Copy  func(*DescribeConnectionLoaInput) DescribeConnectionLoaRequest
}

// Send marshals and sends the DescribeConnectionLoa API request.
func (r DescribeConnectionLoaRequest) Send(ctx context.Context) (*DescribeConnectionLoaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConnectionLoaResponse{
		DescribeConnectionLoaOutput: r.Request.Data.(*DescribeConnectionLoaOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConnectionLoaResponse is the response type for the
// DescribeConnectionLoa API operation.
type DescribeConnectionLoaResponse struct {
	*DescribeConnectionLoaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConnectionLoa request.
func (r *DescribeConnectionLoaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
