// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateCoreDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// CoreDefinitionId is a required field
	CoreDefinitionId *string `location:"uri" locationName:"CoreDefinitionId" type:"string" required:"true"`

	Cores []Core `type:"list"`
}

// String returns the string representation
func (s CreateCoreDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCoreDefinitionVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCoreDefinitionVersionInput"}

	if s.CoreDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CoreDefinitionId"))
	}
	if s.Cores != nil {
		for i, v := range s.Cores {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Cores", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCoreDefinitionVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Cores != nil {
		v := s.Cores

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Cores", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AmznClientToken != nil {
		v := *s.AmznClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amzn-Client-Token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CoreDefinitionId != nil {
		v := *s.CoreDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "CoreDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateCoreDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateCoreDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCoreDefinitionVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateCoreDefinitionVersion = "CreateCoreDefinitionVersion"

// CreateCoreDefinitionVersionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Creates a version of a core definition that has already been defined. Greengrass
// groups must each contain exactly one Greengrass core.
//
//    // Example sending a request using CreateCoreDefinitionVersionRequest.
//    req := client.CreateCoreDefinitionVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion
func (c *Client) CreateCoreDefinitionVersionRequest(input *CreateCoreDefinitionVersionInput) CreateCoreDefinitionVersionRequest {
	op := &aws.Operation{
		Name:       opCreateCoreDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/cores/{CoreDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateCoreDefinitionVersionInput{}
	}

	req := c.newRequest(op, input, &CreateCoreDefinitionVersionOutput{})
	return CreateCoreDefinitionVersionRequest{Request: req, Input: input, Copy: c.CreateCoreDefinitionVersionRequest}
}

// CreateCoreDefinitionVersionRequest is the request type for the
// CreateCoreDefinitionVersion API operation.
type CreateCoreDefinitionVersionRequest struct {
	*aws.Request
	Input *CreateCoreDefinitionVersionInput
	Copy  func(*CreateCoreDefinitionVersionInput) CreateCoreDefinitionVersionRequest
}

// Send marshals and sends the CreateCoreDefinitionVersion API request.
func (r CreateCoreDefinitionVersionRequest) Send(ctx context.Context) (*CreateCoreDefinitionVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCoreDefinitionVersionResponse{
		CreateCoreDefinitionVersionOutput: r.Request.Data.(*CreateCoreDefinitionVersionOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCoreDefinitionVersionResponse is the response type for the
// CreateCoreDefinitionVersion API operation.
type CreateCoreDefinitionVersionResponse struct {
	*CreateCoreDefinitionVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCoreDefinitionVersion request.
func (r *CreateCoreDefinitionVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
