// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteConnectorDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectorDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectorDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteConnectorDefinitionInput"}

	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectorDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteConnectorDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConnectorDefinitionId != nil {
		v := *s.ConnectorDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectorDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteConnectorDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectorDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteConnectorDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteConnectorDefinition = "DeleteConnectorDefinition"

// DeleteConnectorDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Deletes a connector definition.
//
//    // Example sending a request using DeleteConnectorDefinitionRequest.
//    req := client.DeleteConnectorDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition
func (c *Client) DeleteConnectorDefinitionRequest(input *DeleteConnectorDefinitionInput) DeleteConnectorDefinitionRequest {
	op := &aws.Operation{
		Name:       opDeleteConnectorDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}",
	}

	if input == nil {
		input = &DeleteConnectorDefinitionInput{}
	}

	req := c.newRequest(op, input, &DeleteConnectorDefinitionOutput{})
	return DeleteConnectorDefinitionRequest{Request: req, Input: input, Copy: c.DeleteConnectorDefinitionRequest}
}

// DeleteConnectorDefinitionRequest is the request type for the
// DeleteConnectorDefinition API operation.
type DeleteConnectorDefinitionRequest struct {
	*aws.Request
	Input *DeleteConnectorDefinitionInput
	Copy  func(*DeleteConnectorDefinitionInput) DeleteConnectorDefinitionRequest
}

// Send marshals and sends the DeleteConnectorDefinition API request.
func (r DeleteConnectorDefinitionRequest) Send(ctx context.Context) (*DeleteConnectorDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteConnectorDefinitionResponse{
		DeleteConnectorDefinitionOutput: r.Request.Data.(*DeleteConnectorDefinitionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteConnectorDefinitionResponse is the response type for the
// DeleteConnectorDefinition API operation.
type DeleteConnectorDefinitionResponse struct {
	*DeleteConnectorDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteConnectorDefinition request.
func (r *DeleteConnectorDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
