// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type PutGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to associate the policy with.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The policy document.
	//
	// You must provide policies in JSON format in IAM. However, for AWS CloudFormation
	// templates formatted in YAML, you can provide the policy in JSON or YAML format.
	// AWS CloudFormation always converts a YAML policy to JSON format before submitting
	// it to IAM.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of the following:
	//
	//    * Any printable ASCII character ranging from the space character (\u0020)
	//    through the end of the ASCII character range
	//
	//    * The printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF)
	//
	//    * The special characters tab (\u0009), line feed (\u000A), and carriage
	//    return (\u000D)
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutGroupPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutGroupPolicyInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.PolicyDocument == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyDocument", 1))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutGroupPolicy = "PutGroupPolicy"

// PutGroupPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Adds or updates an inline policy document that is embedded in the specified
// IAM group.
//
// A user can also have managed policies attached to it. To attach a managed
// policy to a group, use AttachGroupPolicy. To create a new managed policy,
// use CreatePolicy. For information about policies, see Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed in a group, see Limitations on IAM Entities (https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutGroupPolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the IAM User Guide.
//
//    // Example sending a request using PutGroupPolicyRequest.
//    req := client.PutGroupPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy
func (c *Client) PutGroupPolicyRequest(input *PutGroupPolicyInput) PutGroupPolicyRequest {
	op := &aws.Operation{
		Name:       opPutGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutGroupPolicyInput{}
	}

	req := c.newRequest(op, input, &PutGroupPolicyOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutGroupPolicyRequest{Request: req, Input: input, Copy: c.PutGroupPolicyRequest}
}

// PutGroupPolicyRequest is the request type for the
// PutGroupPolicy API operation.
type PutGroupPolicyRequest struct {
	*aws.Request
	Input *PutGroupPolicyInput
	Copy  func(*PutGroupPolicyInput) PutGroupPolicyRequest
}

// Send marshals and sends the PutGroupPolicy API request.
func (r PutGroupPolicyRequest) Send(ctx context.Context) (*PutGroupPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutGroupPolicyResponse{
		PutGroupPolicyOutput: r.Request.Data.(*PutGroupPolicyOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutGroupPolicyResponse is the response type for the
// PutGroupPolicy API operation.
type PutGroupPolicyResponse struct {
	*PutGroupPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutGroupPolicy request.
func (r *PutGroupPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
