// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListImageBuildVersionsInput struct {
	_ struct{} `type:"structure"`

	Filters []Filter `locationName:"filters" min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the image whose build versions you wish
	// to retrieve.
	//
	// ImageVersionArn is a required field
	ImageVersionArn *string `locationName:"imageVersionArn" type:"string" required:"true"`

	// The maximum items to return in a request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListImageBuildVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImageBuildVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListImageBuildVersionsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}

	if s.ImageVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageVersionArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListImageBuildVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ImageVersionArn != nil {
		v := *s.ImageVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListImageBuildVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of image build versions.
	ImageSummaryList []ImageSummary `locationName:"imageSummaryList" type:"list"`

	// The next token used for paginated responses. When this is not empty then
	// there are additional elements that the service that not include in this request.
	// Use this token with the next request to retrieve additional object.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s ListImageBuildVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListImageBuildVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageSummaryList != nil {
		v := s.ImageSummaryList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "imageSummaryList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListImageBuildVersions = "ListImageBuildVersions"

// ListImageBuildVersionsRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Returns a list of distribution configurations.
//
//    // Example sending a request using ListImageBuildVersionsRequest.
//    req := client.ListImageBuildVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/ListImageBuildVersions
func (c *Client) ListImageBuildVersionsRequest(input *ListImageBuildVersionsInput) ListImageBuildVersionsRequest {
	op := &aws.Operation{
		Name:       opListImageBuildVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/ListImageBuildVersions",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImageBuildVersionsInput{}
	}

	req := c.newRequest(op, input, &ListImageBuildVersionsOutput{})
	return ListImageBuildVersionsRequest{Request: req, Input: input, Copy: c.ListImageBuildVersionsRequest}
}

// ListImageBuildVersionsRequest is the request type for the
// ListImageBuildVersions API operation.
type ListImageBuildVersionsRequest struct {
	*aws.Request
	Input *ListImageBuildVersionsInput
	Copy  func(*ListImageBuildVersionsInput) ListImageBuildVersionsRequest
}

// Send marshals and sends the ListImageBuildVersions API request.
func (r ListImageBuildVersionsRequest) Send(ctx context.Context) (*ListImageBuildVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListImageBuildVersionsResponse{
		ListImageBuildVersionsOutput: r.Request.Data.(*ListImageBuildVersionsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListImageBuildVersionsRequestPaginator returns a paginator for ListImageBuildVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListImageBuildVersionsRequest(input)
//   p := imagebuilder.NewListImageBuildVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListImageBuildVersionsPaginator(req ListImageBuildVersionsRequest) ListImageBuildVersionsPaginator {
	return ListImageBuildVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListImageBuildVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListImageBuildVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListImageBuildVersionsPaginator struct {
	aws.Pager
}

func (p *ListImageBuildVersionsPaginator) CurrentPage() *ListImageBuildVersionsOutput {
	return p.Pager.CurrentPage().(*ListImageBuildVersionsOutput)
}

// ListImageBuildVersionsResponse is the response type for the
// ListImageBuildVersions API operation.
type ListImageBuildVersionsResponse struct {
	*ListImageBuildVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListImageBuildVersions request.
func (r *ListImageBuildVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
