// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetStaticIpsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetStaticIpsInput) String() string {
	return awsutil.Prettify(s)
}

type GetStaticIpsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about your get static
	// IPs request.
	StaticIps []StaticIp `locationName:"staticIps" type:"list"`
}

// String returns the string representation
func (s GetStaticIpsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetStaticIps = "GetStaticIps"

// GetStaticIpsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about all static IPs in the user's account.
//
//    // Example sending a request using GetStaticIpsRequest.
//    req := client.GetStaticIpsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Client) GetStaticIpsRequest(input *GetStaticIpsInput) GetStaticIpsRequest {
	op := &aws.Operation{
		Name:       opGetStaticIps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpsInput{}
	}

	req := c.newRequest(op, input, &GetStaticIpsOutput{})
	return GetStaticIpsRequest{Request: req, Input: input, Copy: c.GetStaticIpsRequest}
}

// GetStaticIpsRequest is the request type for the
// GetStaticIps API operation.
type GetStaticIpsRequest struct {
	*aws.Request
	Input *GetStaticIpsInput
	Copy  func(*GetStaticIpsInput) GetStaticIpsRequest
}

// Send marshals and sends the GetStaticIps API request.
func (r GetStaticIpsRequest) Send(ctx context.Context) (*GetStaticIpsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetStaticIpsResponse{
		GetStaticIpsOutput: r.Request.Data.(*GetStaticIpsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetStaticIpsResponse is the response type for the
// GetStaticIps API operation.
type GetStaticIpsResponse struct {
	*GetStaticIpsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetStaticIps request.
func (r *GetStaticIpsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
