// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListMultiplexesInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMultiplexesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultiplexesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMultiplexesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMultiplexesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListMultiplexesOutput struct {
	_ struct{} `type:"structure"`

	Multiplexes []MultiplexSummary `locationName:"multiplexes" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMultiplexesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListMultiplexesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Multiplexes != nil {
		v := s.Multiplexes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "multiplexes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListMultiplexes = "ListMultiplexes"

// ListMultiplexesRequest returns a request value for making API operation for
// AWS Elemental MediaLive.
//
// Retrieve a list of the existing multiplexes.
//
//    // Example sending a request using ListMultiplexesRequest.
//    req := client.ListMultiplexesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes
func (c *Client) ListMultiplexesRequest(input *ListMultiplexesInput) ListMultiplexesRequest {
	op := &aws.Operation{
		Name:       opListMultiplexes,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultiplexesInput{}
	}

	req := c.newRequest(op, input, &ListMultiplexesOutput{})
	return ListMultiplexesRequest{Request: req, Input: input, Copy: c.ListMultiplexesRequest}
}

// ListMultiplexesRequest is the request type for the
// ListMultiplexes API operation.
type ListMultiplexesRequest struct {
	*aws.Request
	Input *ListMultiplexesInput
	Copy  func(*ListMultiplexesInput) ListMultiplexesRequest
}

// Send marshals and sends the ListMultiplexes API request.
func (r ListMultiplexesRequest) Send(ctx context.Context) (*ListMultiplexesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMultiplexesResponse{
		ListMultiplexesOutput: r.Request.Data.(*ListMultiplexesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMultiplexesRequestPaginator returns a paginator for ListMultiplexes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMultiplexesRequest(input)
//   p := medialive.NewListMultiplexesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMultiplexesPaginator(req ListMultiplexesRequest) ListMultiplexesPaginator {
	return ListMultiplexesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMultiplexesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMultiplexesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMultiplexesPaginator struct {
	aws.Pager
}

func (p *ListMultiplexesPaginator) CurrentPage() *ListMultiplexesOutput {
	return p.Pager.CurrentPage().(*ListMultiplexesOutput)
}

// ListMultiplexesResponse is the response type for the
// ListMultiplexes API operation.
type ListMultiplexesResponse struct {
	*ListMultiplexesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMultiplexes request.
func (r *ListMultiplexesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
