// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateSiteInput struct {
	_ struct{} `type:"structure"`

	// A description of your site.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The site location. This information is used for visualization in the Network
	// Manager console. If you specify the address, the latitude and longitude are
	// automatically calculated.
	//
	//    * Address: The physical address of the site.
	//
	//    * Latitude: The latitude of the site.
	//
	//    * Longitude: The longitude of the site.
	Location *Location `type:"structure"`

	// The tags to apply to the resource during creation.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateSiteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSiteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSiteInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSiteInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateSiteOutput struct {
	_ struct{} `type:"structure"`

	// Information about the site.
	Site *Site `type:"structure"`
}

// String returns the string representation
func (s CreateSiteOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSiteOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Site != nil {
		v := s.Site

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Site", v, metadata)
	}
	return nil
}

const opCreateSite = "CreateSite"

// CreateSiteRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Creates a new site in a global network.
//
//    // Example sending a request using CreateSiteRequest.
//    req := client.CreateSiteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateSite
func (c *Client) CreateSiteRequest(input *CreateSiteInput) CreateSiteRequest {
	op := &aws.Operation{
		Name:       opCreateSite,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks/{globalNetworkId}/sites",
	}

	if input == nil {
		input = &CreateSiteInput{}
	}

	req := c.newRequest(op, input, &CreateSiteOutput{})
	return CreateSiteRequest{Request: req, Input: input, Copy: c.CreateSiteRequest}
}

// CreateSiteRequest is the request type for the
// CreateSite API operation.
type CreateSiteRequest struct {
	*aws.Request
	Input *CreateSiteInput
	Copy  func(*CreateSiteInput) CreateSiteRequest
}

// Send marshals and sends the CreateSite API request.
func (r CreateSiteRequest) Send(ctx context.Context) (*CreateSiteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSiteResponse{
		CreateSiteOutput: r.Request.Data.(*CreateSiteOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSiteResponse is the response type for the
// CreateSite API operation.
type CreateSiteResponse struct {
	*CreateSiteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSite request.
func (r *CreateSiteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
