// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGcmChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGcmChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGcmChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Provides information about the status and settings of the GCM channel for
	// an application. The GCM channel enables Amazon Pinpoint to send push notifications
	// through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging
	// (GCM), service.
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGcmChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GCMChannelResponse != nil {
		v := s.GCMChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "GCMChannelResponse", v, metadata)
	}
	return nil
}

const opGetGcmChannel = "GetGcmChannel"

// GetGcmChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Retrieves information about the status and settings of the GCM channel for
// an application.
//
//    // Example sending a request using GetGcmChannelRequest.
//    req := client.GetGcmChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Client) GetGcmChannelRequest(input *GetGcmChannelInput) GetGcmChannelRequest {
	op := &aws.Operation{
		Name:       opGetGcmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &GetGcmChannelInput{}
	}

	req := c.newRequest(op, input, &GetGcmChannelOutput{})
	return GetGcmChannelRequest{Request: req, Input: input, Copy: c.GetGcmChannelRequest}
}

// GetGcmChannelRequest is the request type for the
// GetGcmChannel API operation.
type GetGcmChannelRequest struct {
	*aws.Request
	Input *GetGcmChannelInput
	Copy  func(*GetGcmChannelInput) GetGcmChannelRequest
}

// Send marshals and sends the GetGcmChannel API request.
func (r GetGcmChannelRequest) Send(ctx context.Context) (*GetGcmChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGcmChannelResponse{
		GetGcmChannelOutput: r.Request.Data.(*GetGcmChannelOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGcmChannelResponse is the response type for the
// GetGcmChannel API operation.
type GetGcmChannelResponse struct {
	*GetGcmChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGcmChannel request.
func (r *GetGcmChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
