// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type LockServiceLinkedRoleInput struct {
	_ struct{} `type:"structure"`

	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// Timeout is a required field
	Timeout *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s LockServiceLinkedRoleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LockServiceLinkedRoleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LockServiceLinkedRoleInput"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if s.Timeout == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timeout"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LockServiceLinkedRoleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	return nil
}

type LockServiceLinkedRoleOutput struct {
	_ struct{} `type:"structure"`

	CanBeDeleted *bool `type:"boolean"`

	ReasonOfFailure *string `min:"1" type:"string"`

	RelatedResources []DiscovererSummary `type:"list"`
}

// String returns the string representation
func (s LockServiceLinkedRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LockServiceLinkedRoleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CanBeDeleted != nil {
		v := *s.CanBeDeleted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CanBeDeleted", protocol.BoolValue(v), metadata)
	}
	if s.ReasonOfFailure != nil {
		v := *s.ReasonOfFailure

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReasonOfFailure", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelatedResources != nil {
		v := s.RelatedResources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedResources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opLockServiceLinkedRole = "LockServiceLinkedRole"

// LockServiceLinkedRoleRequest returns a request value for making API operation for
// Schemas.
//
//    // Example sending a request using LockServiceLinkedRoleRequest.
//    req := client.LockServiceLinkedRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/LockServiceLinkedRole
func (c *Client) LockServiceLinkedRoleRequest(input *LockServiceLinkedRoleInput) LockServiceLinkedRoleRequest {
	op := &aws.Operation{
		Name:       opLockServiceLinkedRole,
		HTTPMethod: "POST",
		HTTPPath:   "/slr-deletion/lock",
	}

	if input == nil {
		input = &LockServiceLinkedRoleInput{}
	}

	req := c.newRequest(op, input, &LockServiceLinkedRoleOutput{})
	return LockServiceLinkedRoleRequest{Request: req, Input: input, Copy: c.LockServiceLinkedRoleRequest}
}

// LockServiceLinkedRoleRequest is the request type for the
// LockServiceLinkedRole API operation.
type LockServiceLinkedRoleRequest struct {
	*aws.Request
	Input *LockServiceLinkedRoleInput
	Copy  func(*LockServiceLinkedRoleInput) LockServiceLinkedRoleRequest
}

// Send marshals and sends the LockServiceLinkedRole API request.
func (r LockServiceLinkedRoleRequest) Send(ctx context.Context) (*LockServiceLinkedRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &LockServiceLinkedRoleResponse{
		LockServiceLinkedRoleOutput: r.Request.Data.(*LockServiceLinkedRoleOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// LockServiceLinkedRoleResponse is the response type for the
// LockServiceLinkedRole API operation.
type LockServiceLinkedRoleResponse struct {
	*LockServiceLinkedRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// LockServiceLinkedRole request.
func (r *LockServiceLinkedRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
