// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to send an email message.
type SendEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to use when sending the email.
	ConfigurationSetName *string `type:"string"`

	// An object that contains the body of the message. You can send either a Simple
	// message or a Raw message.
	//
	// Content is a required field
	Content *EmailContent `type:"structure" required:"true"`

	// An object that contains the recipients of the email message.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using the SendEmail operation. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	EmailTags []MessageTag `type:"list"`

	// The address that you want bounce and complaint notifications to be sent to.
	FeedbackForwardingEmailAddress *string `type:"string"`

	// The email address that you want to use as the "From" address for the email.
	// The address that you specify has to be verified.
	FromEmailAddress *string `type:"string"`

	// The "Reply-to" email addresses for the message. When the recipient replies
	// to the message, each Reply-to address receives the reply.
	ReplyToAddresses []string `type:"list"`
}

// String returns the string representation
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEmailInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendEmailInput"}

	if s.Content == nil {
		invalidParams.Add(aws.NewErrParamRequired("Content"))
	}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(aws.ErrInvalidParams))
		}
	}
	if s.EmailTags != nil {
		for i, v := range s.EmailTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EmailTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendEmailInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConfigurationSetName != nil {
		v := *s.ConfigurationSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Content != nil {
		v := s.Content

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Content", v, metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.EmailTags != nil {
		v := s.EmailTags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EmailTags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FeedbackForwardingEmailAddress != nil {
		v := *s.FeedbackForwardingEmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FeedbackForwardingEmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FromEmailAddress != nil {
		v := *s.FromEmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromEmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReplyToAddresses != nil {
		v := s.ReplyToAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ReplyToAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// A unique message ID that you receive when an email is accepted for sending.
type SendEmailOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the message that is generated when the message is
	// accepted.
	//
	// It is possible for the Amazon SES API v2 to accept a message without sending
	// it. This can happen when the message that you're trying to send has an attachment
	// contains a virus, or when you send a templated email that contains invalid
	// personalization content, for example.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SendEmailOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MessageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opSendEmail = "SendEmail"

// SendEmailRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Sends an email message. You can use the Amazon SES API v2 to send two types
// of messages:
//
//    * Simple – A standard email message. When you create this type of message,
//    you specify the sender, the recipient, and the message body, and the Amazon
//    SES API v2 assembles the message for you.
//
//    * Raw – A raw, MIME-formatted email message. When you send this type
//    of email, you have to specify all of the message headers, as well as the
//    message body. You can use this message type to send messages that contain
//    attachments. The message that you specify has to be a valid MIME message.
//
//    // Example sending a request using SendEmailRequest.
//    req := client.SendEmailRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail
func (c *Client) SendEmailRequest(input *SendEmailInput) SendEmailRequest {
	op := &aws.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/outbound-emails",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	req := c.newRequest(op, input, &SendEmailOutput{})
	return SendEmailRequest{Request: req, Input: input, Copy: c.SendEmailRequest}
}

// SendEmailRequest is the request type for the
// SendEmail API operation.
type SendEmailRequest struct {
	*aws.Request
	Input *SendEmailInput
	Copy  func(*SendEmailInput) SendEmailRequest
}

// Send marshals and sends the SendEmail API request.
func (r SendEmailRequest) Send(ctx context.Context) (*SendEmailResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendEmailResponse{
		SendEmailOutput: r.Request.Data.(*SendEmailOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendEmailResponse is the response type for the
// SendEmail API operation.
type SendEmailResponse struct {
	*SendEmailOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendEmail request.
func (r *SendEmailResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
