// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAssociationExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The association ID for which you want to view execution history details.
	//
	// AssociationId is a required field
	AssociationId *string `type:"string" required:"true"`

	// Filters for the request. You can specify the following filters and values.
	//
	// ExecutionId (EQUAL)
	//
	// Status (EQUAL)
	//
	// CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)
	Filters []AssociationExecutionFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssociationExecutionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAssociationExecutionsInput"}

	if s.AssociationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociationId"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAssociationExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the executions for the specified association ID.
	AssociationExecutions []AssociationExecution `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAssociationExecutions = "DescribeAssociationExecutions"

// DescribeAssociationExecutionsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Use this API action to view all executions for a specific association ID.
//
//    // Example sending a request using DescribeAssociationExecutionsRequest.
//    req := client.DescribeAssociationExecutionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions
func (c *Client) DescribeAssociationExecutionsRequest(input *DescribeAssociationExecutionsInput) DescribeAssociationExecutionsRequest {
	op := &aws.Operation{
		Name:       opDescribeAssociationExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationExecutionsInput{}
	}

	req := c.newRequest(op, input, &DescribeAssociationExecutionsOutput{})
	return DescribeAssociationExecutionsRequest{Request: req, Input: input, Copy: c.DescribeAssociationExecutionsRequest}
}

// DescribeAssociationExecutionsRequest is the request type for the
// DescribeAssociationExecutions API operation.
type DescribeAssociationExecutionsRequest struct {
	*aws.Request
	Input *DescribeAssociationExecutionsInput
	Copy  func(*DescribeAssociationExecutionsInput) DescribeAssociationExecutionsRequest
}

// Send marshals and sends the DescribeAssociationExecutions API request.
func (r DescribeAssociationExecutionsRequest) Send(ctx context.Context) (*DescribeAssociationExecutionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAssociationExecutionsResponse{
		DescribeAssociationExecutionsOutput: r.Request.Data.(*DescribeAssociationExecutionsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAssociationExecutionsResponse is the response type for the
// DescribeAssociationExecutions API operation.
type DescribeAssociationExecutionsResponse struct {
	*DescribeAssociationExecutionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAssociationExecutions request.
func (r *DescribeAssociationExecutionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
