// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetWorkflowExecutionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Specifies the workflow execution for which to return the history.
	//
	// Execution is a required field
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the events in reverse order. By default the results
	// are returned in ascending order of the eventTimeStamp of the events.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s GetWorkflowExecutionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowExecutionHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetWorkflowExecutionHistoryInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}

	if s.Execution == nil {
		invalidParams.Add(aws.NewErrParamRequired("Execution"))
	}
	if s.Execution != nil {
		if err := s.Execution.Validate(); err != nil {
			invalidParams.AddNested("Execution", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Paginated representation of a workflow history for a workflow execution.
// This is the up to date, complete and authoritative record of the events related
// to all tasks and events in the life of the workflow execution.
type GetWorkflowExecutionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of history events.
	//
	// Events is a required field
	Events []HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetWorkflowExecutionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetWorkflowExecutionHistory = "GetWorkflowExecutionHistory"

// GetWorkflowExecutionHistoryRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Returns the history of the specified workflow execution. The results may
// be split into multiple pages. To retrieve subsequent pages, make the call
// again using the nextPageToken returned by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using GetWorkflowExecutionHistoryRequest.
//    req := client.GetWorkflowExecutionHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetWorkflowExecutionHistoryRequest(input *GetWorkflowExecutionHistoryInput) GetWorkflowExecutionHistoryRequest {
	op := &aws.Operation{
		Name:       opGetWorkflowExecutionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetWorkflowExecutionHistoryInput{}
	}

	req := c.newRequest(op, input, &GetWorkflowExecutionHistoryOutput{})
	return GetWorkflowExecutionHistoryRequest{Request: req, Input: input, Copy: c.GetWorkflowExecutionHistoryRequest}
}

// GetWorkflowExecutionHistoryRequest is the request type for the
// GetWorkflowExecutionHistory API operation.
type GetWorkflowExecutionHistoryRequest struct {
	*aws.Request
	Input *GetWorkflowExecutionHistoryInput
	Copy  func(*GetWorkflowExecutionHistoryInput) GetWorkflowExecutionHistoryRequest
}

// Send marshals and sends the GetWorkflowExecutionHistory API request.
func (r GetWorkflowExecutionHistoryRequest) Send(ctx context.Context) (*GetWorkflowExecutionHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetWorkflowExecutionHistoryResponse{
		GetWorkflowExecutionHistoryOutput: r.Request.Data.(*GetWorkflowExecutionHistoryOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetWorkflowExecutionHistoryRequestPaginator returns a paginator for GetWorkflowExecutionHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetWorkflowExecutionHistoryRequest(input)
//   p := swf.NewGetWorkflowExecutionHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetWorkflowExecutionHistoryPaginator(req GetWorkflowExecutionHistoryRequest) GetWorkflowExecutionHistoryPaginator {
	return GetWorkflowExecutionHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetWorkflowExecutionHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetWorkflowExecutionHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetWorkflowExecutionHistoryPaginator struct {
	aws.Pager
}

func (p *GetWorkflowExecutionHistoryPaginator) CurrentPage() *GetWorkflowExecutionHistoryOutput {
	return p.Pager.CurrentPage().(*GetWorkflowExecutionHistoryOutput)
}

// GetWorkflowExecutionHistoryResponse is the response type for the
// GetWorkflowExecutionHistory API operation.
type GetWorkflowExecutionHistoryResponse struct {
	*GetWorkflowExecutionHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetWorkflowExecutionHistory request.
func (r *GetWorkflowExecutionHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
