// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ImportSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// The public key portion of an SSH key pair.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// The name of the user account that is assigned to one or more servers.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSshPublicKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportSshPublicKeyInput"}

	if s.ServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerId"))
	}
	if s.ServerId != nil && len(*s.ServerId) < 19 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerId", 19))
	}

	if s.SshPublicKeyBody == nil {
		invalidParams.Add(aws.NewErrParamRequired("SshPublicKeyBody"))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This response identifies the user, the server they belong to, and the identifier
// of the SSH public key associated with that user. A user can have more than
// one key on each server that they are associated with.
type ImportSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`

	// This identifier is the name given to a public key by the system that was
	// imported.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `min:"21" type:"string" required:"true"`

	// A user name assigned to the ServerID value that you specified.
	//
	// UserName is a required field
	UserName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opImportSshPublicKey = "ImportSshPublicKey"

// ImportSshPublicKeyRequest returns a request value for making API operation for
// AWS Transfer for SFTP.
//
// Adds a Secure Shell (SSH) public key to a user account identified by a UserName
// value assigned to a specific server, identified by ServerId.
//
// The response returns the UserName value, the ServerId value, and the name
// of the SshPublicKeyId.
//
//    // Example sending a request using ImportSshPublicKeyRequest.
//    req := client.ImportSshPublicKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Client) ImportSshPublicKeyRequest(input *ImportSshPublicKeyInput) ImportSshPublicKeyRequest {
	op := &aws.Operation{
		Name:       opImportSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSshPublicKeyInput{}
	}

	req := c.newRequest(op, input, &ImportSshPublicKeyOutput{})
	return ImportSshPublicKeyRequest{Request: req, Input: input, Copy: c.ImportSshPublicKeyRequest}
}

// ImportSshPublicKeyRequest is the request type for the
// ImportSshPublicKey API operation.
type ImportSshPublicKeyRequest struct {
	*aws.Request
	Input *ImportSshPublicKeyInput
	Copy  func(*ImportSshPublicKeyInput) ImportSshPublicKeyRequest
}

// Send marshals and sends the ImportSshPublicKey API request.
func (r ImportSshPublicKeyRequest) Send(ctx context.Context) (*ImportSshPublicKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ImportSshPublicKeyResponse{
		ImportSshPublicKeyOutput: r.Request.Data.(*ImportSshPublicKeyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ImportSshPublicKeyResponse is the response type for the
// ImportSshPublicKey API operation.
type ImportSshPublicKeyResponse struct {
	*ImportSshPublicKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ImportSshPublicKey request.
func (r *ImportSshPublicKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
