// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifySelfservicePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The permissions to enable or disable self-service capabilities.
	//
	// SelfservicePermissions is a required field
	SelfservicePermissions *SelfservicePermissions `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifySelfservicePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySelfservicePermissionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifySelfservicePermissionsInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 10))
	}

	if s.SelfservicePermissions == nil {
		invalidParams.Add(aws.NewErrParamRequired("SelfservicePermissions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifySelfservicePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifySelfservicePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifySelfservicePermissions = "ModifySelfservicePermissions"

// ModifySelfservicePermissionsRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Modifies the self-service WorkSpace management capabilities for your users.
// For more information, see Enable Self-Service WorkSpace Management Capabilities
// for Your Users (https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
//
//    // Example sending a request using ModifySelfservicePermissionsRequest.
//    req := client.ModifySelfservicePermissionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions
func (c *Client) ModifySelfservicePermissionsRequest(input *ModifySelfservicePermissionsInput) ModifySelfservicePermissionsRequest {
	op := &aws.Operation{
		Name:       opModifySelfservicePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySelfservicePermissionsInput{}
	}

	req := c.newRequest(op, input, &ModifySelfservicePermissionsOutput{})
	return ModifySelfservicePermissionsRequest{Request: req, Input: input, Copy: c.ModifySelfservicePermissionsRequest}
}

// ModifySelfservicePermissionsRequest is the request type for the
// ModifySelfservicePermissions API operation.
type ModifySelfservicePermissionsRequest struct {
	*aws.Request
	Input *ModifySelfservicePermissionsInput
	Copy  func(*ModifySelfservicePermissionsInput) ModifySelfservicePermissionsRequest
}

// Send marshals and sends the ModifySelfservicePermissions API request.
func (r ModifySelfservicePermissionsRequest) Send(ctx context.Context) (*ModifySelfservicePermissionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifySelfservicePermissionsResponse{
		ModifySelfservicePermissionsOutput: r.Request.Data.(*ModifySelfservicePermissionsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifySelfservicePermissionsResponse is the response type for the
// ModifySelfservicePermissions API operation.
type ModifySelfservicePermissionsResponse struct {
	*ModifySelfservicePermissionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifySelfservicePermissions request.
func (r *ModifySelfservicePermissionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
