// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
	//
	// StopWorkspaceRequests is a required field
	StopWorkspaceRequests []StopRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StopWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopWorkspacesInput"}

	if s.StopWorkspaceRequests == nil {
		invalidParams.Add(aws.NewErrParamRequired("StopWorkspaceRequests"))
	}
	if s.StopWorkspaceRequests != nil && len(s.StopWorkspaceRequests) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StopWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be stopped.
	FailedRequests []FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StopWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopWorkspaces = "StopWorkspaces"

// StopWorkspacesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Stops the specified WorkSpaces.
//
// You cannot stop a WorkSpace unless it has a running mode of AutoStop and
// a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.
//
//    // Example sending a request using StopWorkspacesRequest.
//    req := client.StopWorkspacesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *Client) StopWorkspacesRequest(input *StopWorkspacesInput) StopWorkspacesRequest {
	op := &aws.Operation{
		Name:       opStopWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesInput{}
	}

	req := c.newRequest(op, input, &StopWorkspacesOutput{})
	return StopWorkspacesRequest{Request: req, Input: input, Copy: c.StopWorkspacesRequest}
}

// StopWorkspacesRequest is the request type for the
// StopWorkspaces API operation.
type StopWorkspacesRequest struct {
	*aws.Request
	Input *StopWorkspacesInput
	Copy  func(*StopWorkspacesInput) StopWorkspacesRequest
}

// Send marshals and sends the StopWorkspaces API request.
func (r StopWorkspacesRequest) Send(ctx context.Context) (*StopWorkspacesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopWorkspacesResponse{
		StopWorkspacesOutput: r.Request.Data.(*StopWorkspacesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopWorkspacesResponse is the response type for the
// StopWorkspaces API operation.
type StopWorkspacesResponse struct {
	*StopWorkspacesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopWorkspaces request.
func (r *StopWorkspacesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
