// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/iam"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To add a client ID (audience) to an Open-ID Connect (OIDC) provider
//
// The following add-client-id-to-open-id-connect-provider command adds the client ID
// my-application-ID to the OIDC provider named server.example.com:
func ExampleIAM_AddClientIDToOpenIDConnectProvider_shared00() {
	svc := iam.New(session.New())
	input := &iam.AddClientIDToOpenIDConnectProviderInput{
		ClientID:                 aws.String("my-application-ID"),
		OpenIDConnectProviderArn: aws.String("arn:aws:iam::123456789012:oidc-provider/server.example.com"),
	}

	result, err := svc.AddClientIDToOpenIDConnectProvider(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a role to an instance profile
//
// The following command adds the role named S3Access to the instance profile named
// Webserver:
func ExampleIAM_AddRoleToInstanceProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.AddRoleToInstanceProfileInput{
		InstanceProfileName: aws.String("Webserver"),
		RoleName:            aws.String("S3Access"),
	}

	result, err := svc.AddRoleToInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a user to an IAM group
//
// The following command adds an IAM user named Bob to the IAM group named Admins:
func ExampleIAM_AddUserToGroup_shared00() {
	svc := iam.New(session.New())
	input := &iam.AddUserToGroupInput{
		GroupName: aws.String("Admins"),
		UserName:  aws.String("Bob"),
	}

	result, err := svc.AddUserToGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a managed policy to an IAM group
//
// The following command attaches the AWS managed policy named ReadOnlyAccess to the
// IAM group named Finance.
func ExampleIAM_AttachGroupPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.AttachGroupPolicyInput{
		GroupName: aws.String("Finance"),
		PolicyArn: aws.String("arn:aws:iam::aws:policy/ReadOnlyAccess"),
	}

	result, err := svc.AttachGroupPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodePolicyNotAttachableException:
				fmt.Println(iam.ErrCodePolicyNotAttachableException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a managed policy to an IAM role
//
// The following command attaches the AWS managed policy named ReadOnlyAccess to the
// IAM role named ReadOnlyRole.
func ExampleIAM_AttachRolePolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.AttachRolePolicyInput{
		PolicyArn: aws.String("arn:aws:iam::aws:policy/ReadOnlyAccess"),
		RoleName:  aws.String("ReadOnlyRole"),
	}

	result, err := svc.AttachRolePolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodePolicyNotAttachableException:
				fmt.Println(iam.ErrCodePolicyNotAttachableException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a managed policy to an IAM user
//
// The following command attaches the AWS managed policy named AdministratorAccess to
// the IAM user named Alice.
func ExampleIAM_AttachUserPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.AttachUserPolicyInput{
		PolicyArn: aws.String("arn:aws:iam::aws:policy/AdministratorAccess"),
		UserName:  aws.String("Alice"),
	}

	result, err := svc.AttachUserPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodePolicyNotAttachableException:
				fmt.Println(iam.ErrCodePolicyNotAttachableException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the password for your IAM user
//
// The following command changes the password for the current IAM user.
func ExampleIAM_ChangePassword_shared00() {
	svc := iam.New(session.New())
	input := &iam.ChangePasswordInput{
		NewPassword: aws.String("]35d/{pB9Fo9wJ"),
		OldPassword: aws.String("3s0K_;xh4~8XXI"),
	}

	result, err := svc.ChangePassword(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeInvalidUserTypeException:
				fmt.Println(iam.ErrCodeInvalidUserTypeException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeEntityTemporarilyUnmodifiableException:
				fmt.Println(iam.ErrCodeEntityTemporarilyUnmodifiableException, aerr.Error())
			case iam.ErrCodePasswordPolicyViolationException:
				fmt.Println(iam.ErrCodePasswordPolicyViolationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an access key for an IAM user
//
// The following command creates an access key (access key ID and secret access key)
// for the IAM user named Bob.
func ExampleIAM_CreateAccessKey_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateAccessKeyInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.CreateAccessKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an account alias
//
// The following command associates the alias examplecorp to your AWS account.
func ExampleIAM_CreateAccountAlias_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateAccountAliasInput{
		AccountAlias: aws.String("examplecorp"),
	}

	result, err := svc.CreateAccountAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an IAM group
//
// The following command creates an IAM group named Admins.
func ExampleIAM_CreateGroup_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateGroupInput{
		GroupName: aws.String("Admins"),
	}

	result, err := svc.CreateGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an instance profile
//
// The following command creates an instance profile named Webserver that is ready to
// have a role attached and then be associated with an EC2 instance.
func ExampleIAM_CreateInstanceProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateInstanceProfileInput{
		InstanceProfileName: aws.String("Webserver"),
	}

	result, err := svc.CreateInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an instance profile
//
// The following command changes IAM user Bob's password and sets the flag that required
// Bob to change the password the next time he signs in.
func ExampleIAM_CreateLoginProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateLoginProfileInput{
		Password:              aws.String("h]6EszR}vJ*m"),
		PasswordResetRequired: aws.Bool(true),
		UserName:              aws.String("Bob"),
	}

	result, err := svc.CreateLoginProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodePasswordPolicyViolationException:
				fmt.Println(iam.ErrCodePasswordPolicyViolationException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an instance profile
//
// The following example defines a new OIDC provider in IAM with a client ID of my-application-id
// and pointing at the server with a URL of https://server.example.com.
func ExampleIAM_CreateOpenIDConnectProvider_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateOpenIDConnectProviderInput{
		ClientIDList: []*string{
			aws.String("my-application-id"),
		},
		ThumbprintList: []*string{
			aws.String("3768084dfb3d2b68b7897bf5f565da8efEXAMPLE"),
		},
		Url: aws.String("https://server.example.com"),
	}

	result, err := svc.CreateOpenIDConnectProvider(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an IAM role
//
// The following command creates a role named Test-Role and attaches a trust policy
// that you must convert from JSON to a string. Upon success, the response includes
// the same policy as a URL-encoded JSON string.
func ExampleIAM_CreateRole_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateRoleInput{
		AssumeRolePolicyDocument: aws.String("<Stringified-JSON>"),
		Path:                     aws.String("/"),
		RoleName:                 aws.String("Test-Role"),
	}

	result, err := svc.CreateRole(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(iam.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an IAM user
//
// The following create-user command creates an IAM user named Bob in the current account.
func ExampleIAM_CreateUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.CreateUserInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.CreateUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an access key for an IAM user
//
// The following command deletes one access key (access key ID and secret access key)
// assigned to the IAM user named Bob.
func ExampleIAM_DeleteAccessKey_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteAccessKeyInput{
		AccessKeyId: aws.String("AKIDPMS9RO4H3FEXAMPLE"),
		UserName:    aws.String("Bob"),
	}

	result, err := svc.DeleteAccessKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an account alias
//
// The following command removes the alias mycompany from the current AWS account:
func ExampleIAM_DeleteAccountAlias_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteAccountAliasInput{
		AccountAlias: aws.String("mycompany"),
	}

	result, err := svc.DeleteAccountAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete the current account password policy
//
// The following command removes the password policy from the current AWS account:
func ExampleIAM_DeleteAccountPasswordPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteAccountPasswordPolicyInput{}

	result, err := svc.DeleteAccountPasswordPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a policy from an IAM group
//
// The following command deletes the policy named ExamplePolicy from the group named
// Admins:
func ExampleIAM_DeleteGroupPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteGroupPolicyInput{
		GroupName:  aws.String("Admins"),
		PolicyName: aws.String("ExamplePolicy"),
	}

	result, err := svc.DeleteGroupPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an instance profile
//
// The following command deletes the instance profile named ExampleInstanceProfile
func ExampleIAM_DeleteInstanceProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteInstanceProfileInput{
		InstanceProfileName: aws.String("ExampleInstanceProfile"),
	}

	result, err := svc.DeleteInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeDeleteConflictException:
				fmt.Println(iam.ErrCodeDeleteConflictException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a password for an IAM user
//
// The following command deletes the password for the IAM user named Bob.
func ExampleIAM_DeleteLoginProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteLoginProfileInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.DeleteLoginProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeEntityTemporarilyUnmodifiableException:
				fmt.Println(iam.ErrCodeEntityTemporarilyUnmodifiableException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an IAM role
//
// The following command removes the role named Test-Role.
func ExampleIAM_DeleteRole_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteRoleInput{
		RoleName: aws.String("Test-Role"),
	}

	result, err := svc.DeleteRole(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeDeleteConflictException:
				fmt.Println(iam.ErrCodeDeleteConflictException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a policy from an IAM role
//
// The following command removes the policy named ExamplePolicy from the role named
// Test-Role.
func ExampleIAM_DeleteRolePolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteRolePolicyInput{
		PolicyName: aws.String("ExamplePolicy"),
		RoleName:   aws.String("Test-Role"),
	}

	result, err := svc.DeleteRolePolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a signing certificate for an IAM user
//
// The following command deletes the specified signing certificate for the IAM user
// named Anika.
func ExampleIAM_DeleteSigningCertificate_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteSigningCertificateInput{
		CertificateId: aws.String("TA7SMP42TDN5Z26OBPJE7EXAMPLE"),
		UserName:      aws.String("Anika"),
	}

	result, err := svc.DeleteSigningCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an IAM user
//
// The following command removes the IAM user named Bob from the current account.
func ExampleIAM_DeleteUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteUserInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.DeleteUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeDeleteConflictException:
				fmt.Println(iam.ErrCodeDeleteConflictException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a policy from an IAM user
//
// The following delete-user-policy command removes the specified policy from the IAM
// user named Juan:
func ExampleIAM_DeleteUserPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteUserPolicyInput{
		PolicyName: aws.String("ExamplePolicy"),
		UserName:   aws.String("Juan"),
	}

	result, err := svc.DeleteUserPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a virtual MFA device
//
// The following delete-virtual-mfa-device command removes the specified MFA device
// from the current AWS account.
func ExampleIAM_DeleteVirtualMFADevice_shared00() {
	svc := iam.New(session.New())
	input := &iam.DeleteVirtualMFADeviceInput{
		SerialNumber: aws.String("arn:aws:iam::123456789012:mfa/ExampleName"),
	}

	result, err := svc.DeleteVirtualMFADevice(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeDeleteConflictException:
				fmt.Println(iam.ErrCodeDeleteConflictException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a service last accessed data report for an organizational unit
//
// The following operation generates a report for the organizational unit ou-rge0-awexample
func ExampleIAM_GenerateOrganizationsAccessReport_shared00() {
	svc := iam.New(session.New())
	input := &iam.GenerateOrganizationsAccessReportInput{
		EntityPath: aws.String("o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-1a2b3c-k9l8m7n6o5example"),
	}

	result, err := svc.GenerateOrganizationsAccessReport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeReportGenerationLimitExceededException:
				fmt.Println(iam.ErrCodeReportGenerationLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a service last accessed data report for a policy
//
// The following operation generates a report for the policy: ExamplePolicy1
func ExampleIAM_GenerateServiceLastAccessedDetails_shared00() {
	svc := iam.New(session.New())
	input := &iam.GenerateServiceLastAccessedDetailsInput{
		Arn: aws.String("arn:aws:iam::123456789012:policy/ExamplePolicy1"),
	}

	result, err := svc.GenerateServiceLastAccessedDetails(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To see the current account password policy
//
// The following command displays details about the password policy for the current
// AWS account.
func ExampleIAM_GetAccountPasswordPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetAccountPasswordPolicyInput{}

	result, err := svc.GetAccountPasswordPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about IAM entity quotas and usage in the current account
//
// The following command returns information about the IAM entity quotas and usage in
// the current AWS account.
func ExampleIAM_GetAccountSummary_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetAccountSummaryInput{}

	result, err := svc.GetAccountSummary(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about an instance profile
//
// The following command gets information about the instance profile named ExampleInstanceProfile.
func ExampleIAM_GetInstanceProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetInstanceProfileInput{
		InstanceProfileName: aws.String("ExampleInstanceProfile"),
	}

	result, err := svc.GetInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get password information for an IAM user
//
// The following command gets information about the password for the IAM user named
// Anika.
func ExampleIAM_GetLoginProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetLoginProfileInput{
		UserName: aws.String("Anika"),
	}

	result, err := svc.GetLoginProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details from a previously generated organizational unit report
//
// The following operation gets details about the report with the job ID: examplea-1234-b567-cde8-90fg123abcd4
func ExampleIAM_GetOrganizationsAccessReport_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetOrganizationsAccessReportInput{
		JobId: aws.String("examplea-1234-b567-cde8-90fg123abcd4"),
	}

	result, err := svc.GetOrganizationsAccessReport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about an IAM role
//
// The following command gets information about the role named Test-Role.
func ExampleIAM_GetRole_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetRoleInput{
		RoleName: aws.String("Test-Role"),
	}

	result, err := svc.GetRole(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details from a previously-generated report
//
// The following operation gets details about the report with the job ID: examplef-1305-c245-eba4-71fe298bcda7
func ExampleIAM_GetServiceLastAccessedDetails_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetServiceLastAccessedDetailsInput{
		JobId: aws.String("examplef-1305-c245-eba4-71fe298bcda7"),
	}

	result, err := svc.GetServiceLastAccessedDetails(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get sntity details from a previously-generated report
//
// The following operation returns details about the entities that attempted to access
// the IAM service.
func ExampleIAM_GetServiceLastAccessedDetailsWithEntities_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetServiceLastAccessedDetailsWithEntitiesInput{
		JobId:            aws.String("examplef-1305-c245-eba4-71fe298bcda7"),
		ServiceNamespace: aws.String("iam"),
	}

	result, err := svc.GetServiceLastAccessedDetailsWithEntities(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about an IAM user
//
// The following command gets information about the IAM user named Bob.
func ExampleIAM_GetUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.GetUserInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.GetUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the access key IDs for an IAM user
//
// The following command lists the access keys IDs for the IAM user named Alice.
func ExampleIAM_ListAccessKeys_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListAccessKeysInput{
		UserName: aws.String("Alice"),
	}

	result, err := svc.ListAccessKeys(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list account aliases
//
// The following command lists the aliases for the current account.
func ExampleIAM_ListAccountAliases_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListAccountAliasesInput{}

	result, err := svc.ListAccountAliases(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the in-line policies for an IAM group
//
// The following command lists the names of in-line policies that are embedded in the
// IAM group named Admins.
func ExampleIAM_ListGroupPolicies_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListGroupPoliciesInput{
		GroupName: aws.String("Admins"),
	}

	result, err := svc.ListGroupPolicies(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the IAM groups for the current account
//
// The following command lists the IAM groups in the current account:
func ExampleIAM_ListGroups_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListGroupsInput{}

	result, err := svc.ListGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the groups that an IAM user belongs to
//
// The following command displays the groups that the IAM user named Bob belongs to.
func ExampleIAM_ListGroupsForUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListGroupsForUserInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.ListGroupsForUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list policies that allow access to a service
//
// The following operation lists policies that allow ExampleUser01 to access IAM or
// EC2.
func ExampleIAM_ListPoliciesGrantingServiceAccess_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListPoliciesGrantingServiceAccessInput{
		Arn: aws.String("arn:aws:iam::123456789012:user/ExampleUser01"),
		ServiceNamespaces: []*string{
			aws.String("iam"),
			aws.String("ec2"),
		},
	}

	result, err := svc.ListPoliciesGrantingServiceAccess(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the tags attached to an IAM role
//
// The following example shows how to list the tags attached to a role.
func ExampleIAM_ListRoleTags_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListRoleTagsInput{
		RoleName: aws.String("taggedrole1"),
	}

	result, err := svc.ListRoleTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the signing certificates for an IAM user
//
// The following command lists the signing certificates for the IAM user named Bob.
func ExampleIAM_ListSigningCertificates_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListSigningCertificatesInput{
		UserName: aws.String("Bob"),
	}

	result, err := svc.ListSigningCertificates(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the tags attached to an IAM user
//
// The following example shows how to list the tags attached to a user.
func ExampleIAM_ListUserTags_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListUserTagsInput{
		UserName: aws.String("anika"),
	}

	result, err := svc.ListUserTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list IAM users
//
// The following command lists the IAM users in the current account.
func ExampleIAM_ListUsers_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListUsersInput{}

	result, err := svc.ListUsers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list virtual MFA devices
//
// The following command lists the virtual MFA devices that have been configured for
// the current account.
func ExampleIAM_ListVirtualMFADevices_shared00() {
	svc := iam.New(session.New())
	input := &iam.ListVirtualMFADevicesInput{}

	result, err := svc.ListVirtualMFADevices(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a policy to a group
//
// The following command adds a policy named AllPerms to the IAM group named Admins.
func ExampleIAM_PutGroupPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.PutGroupPolicyInput{
		GroupName:      aws.String("Admins"),
		PolicyDocument: aws.String("{\"Version\":\"2012-10-17\",\"Statement\":{\"Effect\":\"Allow\",\"Action\":\"*\",\"Resource\":\"*\"}}"),
		PolicyName:     aws.String("AllPerms"),
	}

	result, err := svc.PutGroupPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(iam.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a permissions policy to an IAM role
//
// The following command adds a permissions policy to the role named Test-Role.
func ExampleIAM_PutRolePolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.PutRolePolicyInput{
		PolicyDocument: aws.String("{\"Version\":\"2012-10-17\",\"Statement\":{\"Effect\":\"Allow\",\"Action\":\"s3:*\",\"Resource\":\"*\"}}"),
		PolicyName:     aws.String("S3AccessPolicy"),
		RoleName:       aws.String("S3Access"),
	}

	result, err := svc.PutRolePolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(iam.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a policy to an IAM user
//
// The following command attaches a policy to the IAM user named Bob.
func ExampleIAM_PutUserPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.PutUserPolicyInput{
		PolicyDocument: aws.String("{\"Version\":\"2012-10-17\",\"Statement\":{\"Effect\":\"Allow\",\"Action\":\"*\",\"Resource\":\"*\"}}"),
		PolicyName:     aws.String("AllAccessPolicy"),
		UserName:       aws.String("Bob"),
	}

	result, err := svc.PutUserPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(iam.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a role from an instance profile
//
// The following command removes the role named Test-Role from the instance profile
// named ExampleInstanceProfile.
func ExampleIAM_RemoveRoleFromInstanceProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.RemoveRoleFromInstanceProfileInput{
		InstanceProfileName: aws.String("ExampleInstanceProfile"),
		RoleName:            aws.String("Test-Role"),
	}

	result, err := svc.RemoveRoleFromInstanceProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a user from an IAM group
//
// The following command removes the user named Bob from the IAM group named Admins.
func ExampleIAM_RemoveUserFromGroup_shared00() {
	svc := iam.New(session.New())
	input := &iam.RemoveUserFromGroupInput{
		GroupName: aws.String("Admins"),
		UserName:  aws.String("Bob"),
	}

	result, err := svc.RemoveUserFromGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an access key for an IAM user
//
// The following command sets the STS global endpoint token to version 2. Version 2
// tokens are valid in all Regions.
func ExampleIAM_SetSecurityTokenServicePreferences_shared00() {
	svc := iam.New(session.New())
	input := &iam.SetSecurityTokenServicePreferencesInput{
		GlobalEndpointTokenVersion: aws.String("v2Token"),
	}

	result, err := svc.SetSecurityTokenServicePreferences(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a tag key and value to an IAM role
//
// The following example shows how to add tags to an existing role.
func ExampleIAM_TagRole_shared00() {
	svc := iam.New(session.New())
	input := &iam.TagRoleInput{
		RoleName: aws.String("taggedrole"),
		Tags: []*iam.Tag{
			{
				Key:   aws.String("Dept"),
				Value: aws.String("Accounting"),
			},
			{
				Key:   aws.String("CostCenter"),
				Value: aws.String("12345"),
			},
		},
	}

	result, err := svc.TagRole(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a tag key and value to an IAM user
//
// The following example shows how to add tags to an existing user.
func ExampleIAM_TagUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.TagUserInput{
		Tags: []*iam.Tag{
			{
				Key:   aws.String("Dept"),
				Value: aws.String("Accounting"),
			},
			{
				Key:   aws.String("CostCenter"),
				Value: aws.String("12345"),
			},
		},
		UserName: aws.String("anika"),
	}

	result, err := svc.TagUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeInvalidInputException:
				fmt.Println(iam.ErrCodeInvalidInputException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a tag from an IAM role
//
// The following example shows how to remove a tag with the key 'Dept' from a role named
// 'taggedrole'.
func ExampleIAM_UntagRole_shared00() {
	svc := iam.New(session.New())
	input := &iam.UntagRoleInput{
		RoleName: aws.String("taggedrole"),
		TagKeys: []*string{
			aws.String("Dept"),
		},
	}

	result, err := svc.UntagRole(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a tag from an IAM user
//
// The following example shows how to remove tags that are attached to a user named
// 'anika'.
func ExampleIAM_UntagUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.UntagUserInput{
		TagKeys: []*string{
			aws.String("Dept"),
		},
		UserName: aws.String("anika"),
	}

	result, err := svc.UntagUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To activate or deactivate an access key for an IAM user
//
// The following command deactivates the specified access key (access key ID and secret
// access key) for the IAM user named Bob.
func ExampleIAM_UpdateAccessKey_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateAccessKeyInput{
		AccessKeyId: aws.String("AKIAIOSFODNN7EXAMPLE"),
		Status:      aws.String("Inactive"),
		UserName:    aws.String("Bob"),
	}

	result, err := svc.UpdateAccessKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set or change the current account password policy
//
// The following command sets the password policy to require a minimum length of eight
// characters and to require one or more numbers in the password:
func ExampleIAM_UpdateAccountPasswordPolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateAccountPasswordPolicyInput{
		MinimumPasswordLength: aws.Int64(8),
		RequireNumbers:        aws.Bool(true),
	}

	result, err := svc.UpdateAccountPasswordPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(iam.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the trust policy for an IAM role
//
// The following command updates the role trust policy for the role named Test-Role:
func ExampleIAM_UpdateAssumeRolePolicy_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateAssumeRolePolicyInput{
		PolicyDocument: aws.String("{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"ec2.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}"),
		RoleName:       aws.String("S3AccessForEC2Instances"),
	}

	result, err := svc.UpdateAssumeRolePolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(iam.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeUnmodifiableEntityException:
				fmt.Println(iam.ErrCodeUnmodifiableEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To rename an IAM group
//
// The following command changes the name of the IAM group Test to Test-1.
func ExampleIAM_UpdateGroup_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateGroupInput{
		GroupName:    aws.String("Test"),
		NewGroupName: aws.String("Test-1"),
	}

	result, err := svc.UpdateGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the password for an IAM user
//
// The following command creates or changes the password for the IAM user named Bob.
func ExampleIAM_UpdateLoginProfile_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateLoginProfileInput{
		Password: aws.String("SomeKindOfPassword123!@#"),
		UserName: aws.String("Bob"),
	}

	result, err := svc.UpdateLoginProfile(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeEntityTemporarilyUnmodifiableException:
				fmt.Println(iam.ErrCodeEntityTemporarilyUnmodifiableException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodePasswordPolicyViolationException:
				fmt.Println(iam.ErrCodePasswordPolicyViolationException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the active status of a signing certificate for an IAM user
//
// The following command changes the status of a signing certificate for a user named
// Bob to Inactive.
func ExampleIAM_UpdateSigningCertificate_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateSigningCertificateInput{
		CertificateId: aws.String("TA7SMP42TDN5Z26OBPJE7EXAMPLE"),
		Status:        aws.String("Inactive"),
		UserName:      aws.String("Bob"),
	}

	result, err := svc.UpdateSigningCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change an IAM user's name
//
// The following command changes the name of the IAM user Bob to Robert. It does not
// change the user's path.
func ExampleIAM_UpdateUser_shared00() {
	svc := iam.New(session.New())
	input := &iam.UpdateUserInput{
		NewUserName: aws.String("Robert"),
		UserName:    aws.String("Bob"),
	}

	result, err := svc.UpdateUser(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeEntityTemporarilyUnmodifiableException:
				fmt.Println(iam.ErrCodeEntityTemporarilyUnmodifiableException, aerr.Error())
			case iam.ErrCodeConcurrentModificationException:
				fmt.Println(iam.ErrCodeConcurrentModificationException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To upload a server certificate to your AWS account
//
// The following upload-server-certificate command uploads a server certificate to your
// AWS account:
func ExampleIAM_UploadServerCertificate_shared00() {
	svc := iam.New(session.New())
	input := &iam.UploadServerCertificateInput{
		CertificateBody:       aws.String("-----BEGIN CERTIFICATE-----<a very long certificate text string>-----END CERTIFICATE-----"),
		Path:                  aws.String("/company/servercerts/"),
		PrivateKey:            aws.String("-----BEGIN DSA PRIVATE KEY-----<a very long private key string>-----END DSA PRIVATE KEY-----"),
		ServerCertificateName: aws.String("ProdServerCert"),
	}

	result, err := svc.UploadServerCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeMalformedCertificateException:
				fmt.Println(iam.ErrCodeMalformedCertificateException, aerr.Error())
			case iam.ErrCodeKeyPairMismatchException:
				fmt.Println(iam.ErrCodeKeyPairMismatchException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To upload a signing certificate for an IAM user
//
// The following command uploads a signing certificate for the IAM user named Bob.
func ExampleIAM_UploadSigningCertificate_shared00() {
	svc := iam.New(session.New())
	input := &iam.UploadSigningCertificateInput{
		CertificateBody: aws.String("-----BEGIN CERTIFICATE-----<certificate-body>-----END CERTIFICATE-----"),
		UserName:        aws.String("Bob"),
	}

	result, err := svc.UploadSigningCertificate(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case iam.ErrCodeLimitExceededException:
				fmt.Println(iam.ErrCodeLimitExceededException, aerr.Error())
			case iam.ErrCodeEntityAlreadyExistsException:
				fmt.Println(iam.ErrCodeEntityAlreadyExistsException, aerr.Error())
			case iam.ErrCodeMalformedCertificateException:
				fmt.Println(iam.ErrCodeMalformedCertificateException, aerr.Error())
			case iam.ErrCodeInvalidCertificateException:
				fmt.Println(iam.ErrCodeInvalidCertificateException, aerr.Error())
			case iam.ErrCodeDuplicateCertificateException:
				fmt.Println(iam.ErrCodeDuplicateCertificateException, aerr.Error())
			case iam.ErrCodeNoSuchEntityException:
				fmt.Println(iam.ErrCodeNoSuchEntityException, aerr.Error())
			case iam.ErrCodeServiceFailureException:
				fmt.Println(iam.ErrCodeServiceFailureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
