package docs

import (
	"fmt"

	"github.com/quay/claircore"
)

func Example_vulnerabilityreport() {
	var report claircore.VulnerabilityReport

	// ANCHOR: example
	for pkgID, vulnIDS := range report.PackageVulnerabilities {
		// get package data structure
		pkg := report.Packages[pkgID]

		for _, vulnID := range vulnIDS {
			vuln := report.Vulnerabilities[vulnID]
			fmt.Printf("package %+v affected by vuln %+v", pkg, vuln)
		}
	}
	// ANCHOR_END: example
}
