// Copyright 2014-2019 Ulrich Kunitz. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package randtxt

// englm3 contains a trigram language model for the English language. It
// supports only uppercase letters and no spaces as used in classic
// cryptography.
//
// The Reader type is using this model to create a random stream of text
// that is distributed like English text.
var englm3 = ngrams{
	{"AAA", -2.012237880410764e+01, -8.489658213678448e+00},
	{"AAB", -1.802964169811005e+01, -6.396921107680856e+00},
	{"AAC", -1.580583041493504e+01, -4.173109824505844e+00},
	{"AAD", -1.760917990879446e+01, -5.976459318365271e+00},
	{"AAE", -2.110831115351291e+01, -9.475590563083715e+00},
	{"AAF", -1.775749389092628e+01, -6.124773300497093e+00},
	{"AAG", -1.848804346667572e+01, -6.855322876246528e+00},
	{"AAH", -1.970311882880374e+01, -8.070398238374549e+00},
	{"AAI", -2.071458432170699e+01, -9.081863731277798e+00},
	{"AAJ", -2.212112026529395e+01, -1.048839967486476e+01},
	{"AAK", -2.198300009979558e+01, -1.035027950936639e+01},
	{"AAL", -1.555772977279527e+01, -3.925009182366080e+00},
	{"AAM", -1.649124316615008e+01, -4.858522575720886e+00},
	{"AAN", -1.254893567683721e+01, -9.162150864080184e-01},
	{"AAO", -2.858687967865855e+01, -1.695415908822936e+01},
	{"AAP", -1.780007669315399e+01, -6.167356102724798e+00},
	{"AAQ", -2.269855733475370e+01, -1.106583674432451e+01},
	{"AAR", -1.476306917732097e+01, -3.130348586891776e+00},
	{"AAS", -1.542316815050416e+01, -3.790447560074965e+00},
	{"AAT", -1.645819249713522e+01, -4.825471906706028e+00},
	{"AAU", -1.988157353209296e+01, -8.248852941663772e+00},
	{"AAV", -1.950057997416772e+01, -7.867859383738525e+00},
	{"AAW", -2.050374050350343e+01, -8.871019913074239e+00},
	{"AAX", -2.874298984980463e+01, -1.711026925937544e+01},
	{"AAY", -2.231937268903564e+01, -1.068665209860644e+01},
	{"AAZ", -1.901633835660918e+01, -7.383617766179984e+00},
	{"ABA", -1.314633889295676e+01, -4.161726191836495e+00},
	{"ABB", -1.445168009195338e+01, -5.467067390833121e+00},
	{"ABC", -1.810121043038702e+01, -9.116597729266752e+00},
	{"ABD", -1.703178147749725e+01, -8.047168776376987e+00},
	{"ABE", -1.307055636581573e+01, -4.085943664695464e+00},
	{"ABF", -1.954784575200859e+01, -1.056323305088833e+01},
	{"ABG", -2.139562887665967e+01, -1.241101617553941e+01},
	{"ABH", -1.668509378611008e+01, -7.700481084989818e+00},
	{"ABI", -1.208447578921732e+01, -3.099863088097052e+00},
	{"ABJ", -1.885280131448764e+01, -9.868188613367369e+00},
	{"ABK", -2.013343262122210e+01, -1.114881992010183e+01},
	{"ABL", -1.072317613103646e+01, -1.738563429916191e+00},
	{"ABM", -1.980738785117913e+01, -1.082277515005886e+01},
	{"ABN", -1.707458968717686e+01, -8.089976986056595e+00},
	{"ABO", -1.085416869170707e+01, -1.869555990586800e+00},
	{"ABP", -2.001652577837510e+01, -1.103191307725484e+01},
	{"ABQ", -3.566308495789999e+01, -2.667847225677973e+01},
	{"ABR", -1.335603339396331e+01, -4.371420692843040e+00},
	{"ABS", -1.371261120601057e+01, -4.727998504890308e+00},
	{"ABT", -1.678488947100056e+01, -7.800276769880299e+00},
	{"ABU", -1.372181372055372e+01, -4.737201019433459e+00},
	{"ABV", -2.957363940103378e+01, -2.058902669991352e+01},
	{"ABW", -1.846993126645747e+01, -9.485318565337201e+00},
	{"ABX", -3.895029279714059e+01, -2.996568009602032e+01},
	{"ABY", -1.426719372809627e+01, -5.282581026976008e+00},
	{"ABZ", -2.213329834226610e+01, -1.314868564114584e+01},
	{"ACA", -1.353864349959014e+01, -5.279534856820441e+00},
	{"ACB", -2.090714772468358e+01, -1.264803908191388e+01},
	{"ACC", -1.150342525644610e+01, -3.244316613676392e+00},
	{"ACD", -1.750854168986748e+01, -9.249433047097774e+00},
	{"ACE", -1.049222608981343e+01, -2.233117447043730e+00},
	{"ACF", -2.270220617970027e+01, -1.444309753693057e+01},
	{"ACG", -2.370165652371349e+01, -1.544254788094379e+01},
	{"ACH", -1.091730239788060e+01, -2.658193755110891e+00},
	{"ACI", -1.313721925116186e+01, -4.878110608392163e+00},
	{"ACJ", -3.205059249927422e+01, -2.379148385650452e+01},
	{"ACK", -1.147180466511520e+01, -3.212696022345502e+00},
	{"ACL", -1.349494259719372e+01, -5.235833954424018e+00},
	{"ACM", -1.939511989466688e+01, -1.113601125189718e+01},
	{"ACN", -2.013223551133785e+01, -1.187312686856814e+01},
	{"ACO", -1.207545967692442e+01, -3.816351034154714e+00},
	{"ACP", -2.039106761280538e+01, -1.213195897003567e+01},
	{"ACQ", -1.480582679407955e+01, -6.546718151309845e+00},
	{"ACR", -1.280971986512096e+01, -4.550611222351262e+00},
	{"ACS", -1.760806164014277e+01, -9.348952997373063e+00},
	{"ACT", -1.079992629029491e+01, -2.540817647525205e+00},
	{"ACU", -1.455176298318722e+01, -6.292654340417513e+00},
	{"ACV", -3.170478285220826e+01, -2.344567420943856e+01},
	{"ACW", -1.932127343153430e+01, -1.106216478876459e+01},
	{"ACX", -3.306553265118617e+01, -2.480642400841647e+01},
	{"ACY", -1.427546855832889e+01, -6.016359915559182e+00},
	{"ACZ", -3.165972638557412e+01, -2.340061774280442e+01},
	{"ADA", -1.152194696104840e+01, -3.366117051843320e+00},
	{"ADB", -1.221294765088493e+01, -4.057117741679851e+00},
	{"ADC", -1.384307201834495e+01, -5.687242109139871e+00},
	{"ADD", -1.248483711208531e+01, -4.329007202880224e+00},
	{"ADE", -1.040243244269832e+01, -2.246602533493234e+00},
	{"ADF", -1.365044946827561e+01, -5.494619559070532e+00},
	{"ADG", -1.468424644533858e+01, -6.528416536133497e+00},
	{"ADH", -1.393243147807106e+01, -5.776601568865980e+00},
	{"ADI", -1.179877782594466e+01, -3.642947916739582e+00},
	{"ADJ", -1.481752410619852e+01, -6.661694196993437e+00},
	{"ADK", -1.745091128971314e+01, -9.295081380508059e+00},
	{"ADL", -1.379478054126274e+01, -5.638950632057655e+00},
	{"ADM", -1.291576790220352e+01, -4.759937992998443e+00},
	{"ADN", -1.315605178928402e+01, -5.000221880078934e+00},
	{"ADO", -1.213475319452181e+01, -3.978923285316726e+00},
	{"ADP", -1.428750846423566e+01, -6.131678555030577e+00},
	{"ADQ", -1.674126260728527e+01, -8.585432698080190e+00},
	{"ADR", -1.340837409091643e+01, -5.252544181711350e+00},
	{"ADS", -1.236138884506654e+01, -4.205558935861458e+00},
	{"ADT", -1.231615972632306e+01, -4.160329817117973e+00},
	{"ADU", -1.412859005077685e+01, -5.972760141571770e+00},
	{"ADV", -1.264520769557629e+01, -4.489377786371212e+00},
	{"ADW", -1.410408484518041e+01, -5.948254935975331e+00},
	{"ADX", -3.407379817787854e+01, -2.591796826867346e+01},
	{"ADY", -1.284735541053219e+01, -4.691525501327111e+00},
	{"ADZ", -2.171487220433081e+01, -1.355904229512572e+01},
	{"AEA", -1.582875034401255e+01, -4.378130423848088e+00},
	{"AEB", -1.916660224482752e+01, -7.715982324663057e+00},
	{"AEC", -1.758649945043452e+01, -6.135879530270056e+00},
	{"AED", -1.692051815829923e+01, -5.469898238134763e+00},
	{"AEE", -2.141204922882748e+01, -9.961429308663016e+00},
	{"AEF", -1.811209209660664e+01, -6.661472176442174e+00},
	{"AEG", -1.742554900587222e+01, -5.974929085707750e+00},
	{"AEH", -2.007110606147811e+01, -8.620486141313643e+00},
	{"AEI", -1.843695719983527e+01, -6.986337279670801e+00},
	{"AEJ", -2.170051957980438e+01, -1.024989965963991e+01},
	{"AEK", -2.666472486870786e+01, -1.521410494854340e+01},
	{"AEL", -1.227421331002372e+01, -8.235933898592583e-01},
	{"AEM", -1.694985695098509e+01, -5.499237030820628e+00},
	{"AEN", -1.667960924093199e+01, -5.228989320767525e+00},
	{"AEO", -1.808083312093773e+01, -6.630213200773262e+00},
	{"AEP", -1.983965529547526e+01, -8.389035375310794e+00},
	{"AEQ", -1.919028083196285e+01, -7.739660911798384e+00},
	{"AER", -1.645594323721441e+01, -5.005323317049945e+00},
	{"AES", -1.464216940939704e+01, -3.191549489232572e+00},
	{"AET", -1.577722154461589e+01, -4.326601624451422e+00},
	{"AEU", -1.741094078070974e+01, -5.960320860545274e+00},
	{"AEV", -1.711128071218090e+01, -5.660660792016435e+00},
	{"AEW", -1.914617911941513e+01, -7.695559199250671e+00},
	{"AEX", -1.821946361591793e+01, -6.768843695753465e+00},
	{"AEY", -2.489241619854445e+01, -1.344179627837999e+01},
	{"AEZ", -2.270738789125254e+01, -1.125676797108808e+01},
	{"AFA", -1.397217404300284e+01, -3.996580780628493e+00},
	{"AFB", -2.051166783514233e+01, -1.053607457276798e+01},
	{"AFC", -2.248408215343812e+01, -1.250848889106376e+01},
	{"AFD", -2.087249616632260e+01, -1.089690290394825e+01},
	{"AFE", -1.285251455349733e+01, -2.876921291122981e+00},
	{"AFF", -1.280361362355416e+01, -2.828020361179811e+00},
	{"AFG", -1.900495174037445e+01, -9.029358478000102e+00},
	{"AFH", -2.100524578343236e+01, -1.102965252105802e+01},
	{"AFI", -1.426530827765918e+01, -4.289715015284827e+00},
	{"AFJ", -2.654436496303232e+01, -1.656877170065796e+01},
	{"AFK", -2.844054572798184e+01, -1.846495246560750e+01},
	{"AFL", -1.527717799224749e+01, -5.301584729873140e+00},
	{"AFM", -1.910739339566187e+01, -9.131800133287522e+00},
	{"AFN", -2.011660804478172e+01, -1.014101478240737e+01},
	{"AFO", -1.361824304771063e+01, -3.642649785336282e+00},
	{"AFP", -2.199304841048391e+01, -1.201745514810956e+01},
	{"AFQ", -3.067887537296241e+01, -2.070328211058806e+01},
	{"AFR", -1.339717158144383e+01, -3.421578319069476e+00},
	{"AFS", -1.904697532896148e+01, -9.071382066587130e+00},
	{"AFT", -1.136075531290755e+01, -1.385162050533197e+00},
	{"AFU", -1.574318054306883e+01, -5.767587280694480e+00},
	{"AFV", -2.772028092040842e+01, -1.774468765803407e+01},
	{"AFW", -2.106433330228308e+01, -1.108874003990873e+01},
	{"AFX", -3.299876280258793e+01, -2.302316954021358e+01},
	{"AFY", -2.165194871786908e+01, -1.167635545549473e+01},
	{"AFZ", -2.912735626211446e+01, -1.915176299974011e+01},
	{"AGA", -1.107196014567933e+01, -1.980194722560890e+00},
	{"AGB", -2.010355221829592e+01, -1.101178679517748e+01},
	{"AGC", -1.988957923658522e+01, -1.079781381346678e+01},
	{"AGD", -1.900546381823915e+01, -9.913698395120718e+00},
	{"AGE", -1.051118913047970e+01, -1.419423707361263e+00},
	{"AGF", -2.009923294651402e+01, -1.100746752339559e+01},
	{"AGG", -1.463865347243232e+01, -5.546888049313886e+00},
	{"AGH", -1.729350042818468e+01, -8.201735005066244e+00},
	{"AGI", -1.319461907713744e+01, -4.102853654019003e+00},
	{"AGJ", -2.368608019364261e+01, -1.459431477052417e+01},
	{"AGK", -2.270485996197106e+01, -1.361309453885262e+01},
	{"AGL", -1.548141266562203e+01, -6.389647242503599e+00},
	{"AGM", -1.727090720555839e+01, -8.179141782439959e+00},
	{"AGN", -1.442064831082297e+01, -5.328882887704536e+00},
	{"AGO", -1.294451153640577e+01, -3.852746113287338e+00},
	{"AGP", -1.999469705684514e+01, -1.090293163372671e+01},
	{"AGQ", -3.069734792049546e+01, -2.160558249737702e+01},
	{"AGR", -1.196653566720716e+01, -2.874770244088727e+00},
	{"AGS", -1.637044771983545e+01, -7.278682296717021e+00},
	{"AGT", -1.765749576920588e+01, -8.565730346087447e+00},
	{"AGU", -1.416443223949491e+01, -5.072666816376477e+00},
	{"AGV", -2.853778970241595e+01, -1.944602427929751e+01},
	{"AGW", -1.821489185345656e+01, -9.123126430338120e+00},
	{"AGX", -3.391616838694281e+01, -2.482440296382438e+01},
	{"AGY", -2.256701037862135e+01, -1.347524495550291e+01},
	{"AGZ", -3.250442190097504e+01, -2.341265647785660e+01},
	{"AHA", -1.234965174527163e+01, -1.596528993808381e+00},
	{"AHB", -1.652786011486494e+01, -5.774737363401688e+00},
	{"AHC", -1.765032334234894e+01, -6.897200590885694e+00},
	{"AHD", -1.729116813092907e+01, -6.538045379465818e+00},
	{"AHE", -1.425525400502708e+01, -3.502131253563830e+00},
	{"AHF", -1.722516791120045e+01, -6.472045159737197e+00},
	{"AHG", -1.901530112453357e+01, -8.262178373070318e+00},
	{"AHH", -1.579257945620002e+01, -5.039456704736774e+00},
	{"AHI", -1.413887670494981e+01, -3.385753953486559e+00},
	{"AHJ", -1.881114931050962e+01, -8.058026559046375e+00},
	{"AHK", -1.758920824369946e+01, -6.836085492236207e+00},
	{"AHL", -1.743195574096355e+01, -6.678832989500298e+00},
	{"AHM", -1.649812654491919e+01, -5.745003793455941e+00},
	{"AHN", -1.835840829431067e+01, -7.605285542847422e+00},
	{"AHO", -1.423287413496331e+01, -3.479751383500056e+00},
	{"AHP", -1.825659446389913e+01, -7.503471712435885e+00},
	{"AHQ", -2.213171581210634e+01, -1.137859306064309e+01},
	{"AHR", -1.777997192544760e+01, -7.026849173984356e+00},
	{"AHS", -1.521801697608954e+01, -4.464894224626292e+00},
	{"AHT", -1.397522137505666e+01, -3.222098623593407e+00},
	{"AHU", -1.489430718915209e+01, -4.141184437688838e+00},
	{"AHV", -2.139330767080735e+01, -1.064018491934410e+01},
	{"AHW", -1.557306420365143e+01, -4.819941452188177e+00},
	{"AHX", -3.560483660677274e+01, -2.485171385530949e+01},
	{"AHY", -1.815523889604455e+01, -7.402116144581299e+00},
	{"AHZ", -1.925915451214836e+01, -8.506031760685110e+00},
	{"AIA", -1.501249956431925e+01, -6.832342030039904e+00},
	{"AIB", -1.978880252555182e+01, -1.160864499127248e+01},
	{"AIC", -1.768662157629209e+01, -9.506464042012738e+00},
	{"AID", -1.037576630986907e+01, -2.195608775589728e+00},
	{"AIE", -1.982014397137486e+01, -1.163998643709552e+01},
	{"AIF", -1.814829627561892e+01, -9.968138741339573e+00},
	{"AIG", -1.440195295361101e+01, -6.221795419331661e+00},
	{"AIH", -1.862733292316707e+01, -1.044717538888773e+01},
	{"AII", -1.741416484302588e+01, -9.234007308746538e+00},
	{"AIJ", -2.001747374908301e+01, -1.183731621480366e+01},
	{"AIK", -1.989785521083131e+01, -1.171769767655196e+01},
	{"AIL", -1.178904426848904e+01, -3.608886734209694e+00},
	{"AIM", -1.330412478690965e+01, -5.123967252630304e+00},
	{"AIN", -9.344844328462280e+00, -1.164686794182934e+00},
	{"AIO", -1.809065221772028e+01, -9.910494683440934e+00},
	{"AIP", -2.108149771317855e+01, -1.290134017889920e+01},
	{"AIQ", -2.935237639442312e+01, -2.117221886014378e+01},
	{"AIR", -1.178915601708207e+01, -3.608998482802727e+00},
	{"AIS", -1.266689628329232e+01, -4.486738749012969e+00},
	{"AIT", -1.209352904752297e+01, -3.913371513243624e+00},
	{"AIU", -1.842936933279969e+01, -1.024921179852034e+01},
	{"AIV", -2.045176985169310e+01, -1.227161231741375e+01},
	{"AIW", -1.796042764669964e+01, -9.780270112420292e+00},
	{"AIX", -1.954435446772859e+01, -1.136419693344924e+01},
	{"AIY", -3.294915147500214e+01, -2.476899394072279e+01},
	{"AIZ", -2.024638879368298e+01, -1.206623125940363e+01},
	{"AJA", -1.676388493220310e+01, -3.283746984338505e+00},
	{"AJB", -2.939554916171182e+01, -1.591541121384722e+01},
	{"AJC", -3.024493880920835e+01, -1.676480086134375e+01},
	{"AJD", -2.371546062010344e+01, -1.023532267223884e+01},
	{"AJE", -1.510112458207241e+01, -1.620986634207812e+00},
	{"AJF", -3.126278228787608e+01, -1.778264434001148e+01},
	{"AJG", -2.071843889999008e+01, -7.238300952125483e+00},
	{"AJH", -3.002805140818683e+01, -1.654791346032223e+01},
	{"AJI", -2.023540068120844e+01, -6.755262733343844e+00},
	{"AJJ", -3.003925890700701e+01, -1.655912095914241e+01},
	{"AJK", -3.272783041487831e+01, -1.924769246701370e+01},
	{"AJL", -3.123666328411491e+01, -1.775652533625031e+01},
	{"AJM", -3.159258865784236e+01, -1.811245070997776e+01},
	{"AJN", -3.454265838649498e+01, -2.106252043863038e+01},
	{"AJO", -1.465651367686229e+01, -1.176375728997686e+00},
	{"AJP", -2.113322135922549e+01, -7.653083411360892e+00},
	{"AJQ", -3.399069266158727e+01, -2.051055471372268e+01},
	{"AJR", -3.021486739840772e+01, -1.673472945054312e+01},
	{"AJS", -3.065365621493633e+01, -1.717351826707173e+01},
	{"AJT", -3.074779353715537e+01, -1.726765558929077e+01},
	{"AJU", -1.669141956445108e+01, -3.211281616586476e+00},
	{"AJV", -3.760974588118813e+01, -2.412960793332353e+01},
	{"AJW", -2.998400192475910e+01, -1.650386397689450e+01},
	{"AJX", -4.028905128825696e+01, -2.680891334039235e+01},
	{"AJY", -3.675892203910157e+01, -2.327878409123697e+01},
	{"AJZ", -3.486392313256000e+01, -2.138378518469540e+01},
	{"AKA", -1.528229976878597e+01, -5.471339548989272e+00},
	{"AKB", -1.714454117183367e+01, -7.333580952036968e+00},
	{"AKC", -1.938121727462974e+01, -9.570257054833046e+00},
	{"AKD", -1.825482132831772e+01, -8.443861108521022e+00},
	{"AKE", -1.029733386869578e+01, -4.863736488990824e-01},
	{"AKF", -1.618502488584782e+01, -6.374064666051121e+00},
	{"AKG", -2.012602750725570e+01, -1.031506728745900e+01},
	{"AKH", -1.790127163663718e+01, -8.090311416840478e+00},
	{"AKI", -1.260664368442755e+01, -2.795683464630857e+00},
	{"AKJ", -2.139059842042201e+01, -1.157963820062531e+01},
	{"AKK", -1.846962557349734e+01, -8.658665353700647e+00},
	{"AKL", -1.831183810815150e+01, -8.500877888354802e+00},
	{"AKM", -1.846265163747309e+01, -8.651691417676389e+00},
	{"AKN", -1.582374733478935e+01, -6.012787114992653e+00},
	{"AKO", -1.591709423409717e+01, -6.106134014300472e+00},
	{"AKP", -1.880374471229717e+01, -8.992784492500476e+00},
	{"AKQ", -2.371386106045328e+01, -1.390290084065659e+01},
	{"AKR", -2.000439697516482e+01, -1.019343675536812e+01},
	{"AKS", -1.609775318117671e+01, -6.286792961380009e+00},
	{"AKT", -1.559940812666656e+01, -5.788447906869867e+00},
	{"AKU", -1.626514869947266e+01, -6.454188479675960e+00},
	{"AKV", -2.138985699680434e+01, -1.157889677700764e+01},
	{"AKW", -1.703954835256100e+01, -7.228588132764298e+00},
	{"AKX", -3.287423390444248e+01, -2.306327368464579e+01},
	{"AKY", -1.845931897542844e+01, -8.648358755631742e+00},
	{"AKZ", -3.097609679031222e+01, -2.116513657051552e+01},
	{"ALA", -1.135226011417387e+01, -4.267357803323650e+00},
	{"ALB", -1.343642636608213e+01, -6.351524055231911e+00},
	{"ALC", -1.262061553012550e+01, -5.535713219275277e+00},
	{"ALD", -1.325969575315235e+01, -6.174793442302125e+00},
	{"ALE", -1.146400397952583e+01, -4.379101668675613e+00},
	{"ALF", -1.255361432759618e+01, -5.468712016745958e+00},
	{"ALG", -1.442615800315616e+01, -7.341255692305936e+00},
	{"ALH", -1.401108245301742e+01, -6.926180142167198e+00},
	{"ALI", -1.085424314956383e+01, -3.769340838713606e+00},
	{"ALJ", -1.665249063236330e+01, -9.567588321513078e+00},
	{"ALK", -1.287164707296710e+01, -5.786744762116875e+00},
	{"ALL", -8.381478119985228e+00, -1.296575809135006e+00},
	{"ALM", -1.244544390395895e+01, -5.360541593108730e+00},
	{"ALN", -1.525868660014352e+01, -8.173784289293293e+00},
	{"ALO", -1.132745330496618e+01, -4.242550994115955e+00},
	{"ALP", -1.263515258337102e+01, -5.550250272520803e+00},
	{"ALQ", -1.686070819518052e+01, -9.775805884330303e+00},
	{"ALR", -1.275722857743686e+01, -5.672326266586643e+00},
	{"ALS", -1.080127615847977e+01, -3.716373847629551e+00},
	{"ALT", -1.092271552666384e+01, -3.837813215813618e+00},
	{"ALU", -1.360039091623398e+01, -6.515488605383761e+00},
	{"ALV", -1.446561131289719e+01, -7.380709002046969e+00},
	{"ALW", -1.260294170505518e+01, -5.518039394204963e+00},
	{"ALX", -2.371722200677031e+01, -1.663231969592008e+01},
	{"ALY", -1.407363658007976e+01, -6.988734269229542e+00},
	{"ALZ", -1.963112538398330e+01, -1.254622307313308e+01},
	{"AMA", -1.152397250471307e+01, -3.061535097388639e+00},
	{"AMB", -1.326982685054569e+01, -4.807389443221258e+00},
	{"AMC", -1.606677409044162e+01, -7.604336683117188e+00},
	{"AMD", -1.707317781320408e+01, -8.610740405879650e+00},
	{"AME", -9.738465432317316e+00, -1.276028024992886e+00},
	{"AMF", -1.654693731402987e+01, -8.084499906705442e+00},
	{"AMG", -1.727485005474164e+01, -8.812412647417208e+00},
	{"AMH", -1.581040469492534e+01, -7.347967287600909e+00},
	{"AMI", -1.178457338241819e+01, -3.322135975093758e+00},
	{"AMJ", -1.829178507872169e+01, -9.829347671397265e+00},
	{"AMK", -1.907388965206011e+01, -1.061145224473568e+01},
	{"AML", -1.670643223699851e+01, -8.243994829674074e+00},
	{"AMM", -1.392795306649711e+01, -5.465515659172676e+00},
	{"AMN", -1.494993259974004e+01, -6.487495192415607e+00},
	{"AMO", -1.149427492212914e+01, -3.031837514804707e+00},
	{"AMP", -1.240396116790438e+01, -3.941523760579949e+00},
	{"AMQ", -2.113311724289902e+01, -1.267067983557459e+01},
	{"AMR", -1.636862683585529e+01, -7.906189428530861e+00},
	{"AMS", -1.345447831329693e+01, -4.992040905972496e+00},
	{"AMT", -1.420287651773968e+01, -5.740439110415251e+00},
	{"AMU", -1.427424420270462e+01, -5.811806795380192e+00},
	{"AMV", -1.819433957114159e+01, -9.731902163817161e+00},
	{"AMW", -1.529952867455539e+01, -6.837091267230961e+00},
	{"AMX", -2.371733905226375e+01, -1.525490164493932e+01},
	{"AMY", -1.669588969766740e+01, -8.233452290342969e+00},
	{"AMZ", -2.113324287324153e+01, -1.267080546591710e+01},
	{"ANA", -1.066937116035314e+01, -4.907979986491697e+00},
	{"ANB", -1.293638379988752e+01, -7.174992626026079e+00},
	{"ANC", -1.015631441890107e+01, -4.394923245039635e+00},
	{"AND", -6.541073874525768e+00, -7.796827006643302e-01},
	{"ANE", -1.138169412906837e+01, -5.620302955206935e+00},
	{"ANF", -1.372677488362657e+01, -7.965383709765130e+00},
	{"ANG", -1.101993842602149e+01, -5.258547252160049e+00},
	{"ANH", -1.244359570056396e+01, -6.682204526702522e+00},
	{"ANI", -1.064780899759766e+01, -4.886417823736221e+00},
	{"ANJ", -1.665198239866321e+01, -1.089059122480177e+01},
	{"ANK", -1.238724131712715e+01, -6.625850143265708e+00},
	{"ANL", -1.406549669999846e+01, -8.304105526137020e+00},
	{"ANM", -1.398364266316320e+01, -8.222251489301765e+00},
	{"ANN", -1.177473260855650e+01, -6.013341434695067e+00},
	{"ANO", -1.116325829314277e+01, -5.401867119281329e+00},
	{"ANP", -1.362712286280477e+01, -7.865731688943332e+00},
	{"ANQ", -1.608192478190220e+01, -1.032053360804076e+01},
	{"ANR", -1.426527440895451e+01, -8.503883235093067e+00},
	{"ANS", -1.025584868567029e+01, -4.494457511808852e+00},
	{"ANT", -9.661645283623480e+00, -3.900254109762042e+00},
	{"ANU", -1.288255208564542e+01, -7.121160911783980e+00},
	{"ANV", -1.606687332355934e+01, -1.030548214969790e+01},
	{"ANW", -1.255933022234396e+01, -6.797939048482522e+00},
	{"ANX", -1.554884681963285e+01, -9.787455645771413e+00},
	{"ANY", -1.033587053345126e+01, -4.574479359589826e+00},
	{"ANZ", -1.791130013266348e+01, -1.214990895880204e+01},
	{"AOA", -2.542993000078391e+01, -1.235025663541554e+01},
	{"AOB", -1.944885998130492e+01, -6.369186615936554e+00},
	{"AOC", -1.978277046104172e+01, -6.703097095673353e+00},
	{"AOD", -2.032649508054524e+01, -7.246821715176866e+00},
	{"AOE", -2.657934821288869e+01, -1.349967484752033e+01},
	{"AOF", -1.480342491743525e+01, -1.723751552066886e+00},
	{"AOG", -2.260661476815812e+01, -9.526941402789753e+00},
	{"AOH", -1.551735152076742e+01, -2.437678155399050e+00},
	{"AOI", -2.562956544803986e+01, -1.254989208267149e+01},
	{"AOJ", -2.766746843732587e+01, -1.458779507195750e+01},
	{"AOK", -2.616324441558599e+01, -1.308357105021762e+01},
	{"AOL", -1.934824209445443e+01, -6.268568729086065e+00},
	{"AOM", -1.849987015545536e+01, -5.420196790086994e+00},
	{"AON", -1.593707784587695e+01, -2.857404480508585e+00},
	{"AOO", -2.453928743657744e+01, -1.145961407120907e+01},
	{"AOP", -1.916539250281926e+01, -6.085719137450886e+00},
	{"AOQ", -3.098258689634071e+01, -1.790291353097234e+01},
	{"AOR", -1.550122447715238e+01, -2.421551111784014e+00},
	{"AOS", -1.784355168725375e+01, -4.763878321885381e+00},
	{"AOT", -1.894381209999937e+01, -5.864138734630996e+00},
	{"AOU", -1.806903609969363e+01, -4.989362734325260e+00},
	{"AOV", -1.937054756083508e+01, -6.290874195466714e+00},
	{"AOW", -2.003637334652238e+01, -6.956699981154014e+00},
	{"AOX", -2.953431785593008e+01, -1.645464449056171e+01},
	{"AOY", -2.667818186778655e+01, -1.359850850241818e+01},
	{"AOZ", -3.076320765933722e+01, -1.768353429396885e+01},
	{"APA", -1.294313682416682e+01, -3.680579651479231e+00},
	{"APB", -1.798901771786888e+01, -8.726460545181293e+00},
	{"APC", -1.867280426085274e+01, -9.410247088165159e+00},
	{"APD", -1.858849188474891e+01, -9.325934712061324e+00},
	{"APE", -1.224612530439711e+01, -2.983568131709530e+00},
	{"APF", -1.825707818564337e+01, -8.994521012955788e+00},
	{"APG", -2.001388884530457e+01, -1.075133167261698e+01},
	{"APH", -1.286633215441488e+01, -3.603774981727297e+00},
	{"API", -1.296362576065014e+01, -3.701068587962555e+00},
	{"APJ", -2.271467047782451e+01, -1.345211330513692e+01},
	{"APK", -2.039601285572308e+01, -1.113345568303550e+01},
	{"APL", -1.440968880338320e+01, -5.147131630695614e+00},
	{"APM", -1.895742733190949e+01, -9.694870159221907e+00},
	{"APN", -1.854780093789311e+01, -9.285243765205532e+00},
	{"APO", -1.307011355766475e+01, -3.807556384977168e+00},
	{"APP", -1.106863062234781e+01, -1.806073449660220e+00},
	{"APQ", -3.241694508546121e+01, -2.315438791277362e+01},
	{"APR", -1.309056369236988e+01, -3.828006519682292e+00},
	{"APS", -1.365341239574239e+01, -4.390855223054801e+00},
	{"APT", -1.254002172519064e+01, -3.277464552503055e+00},
	{"APU", -1.541939758736978e+01, -6.156840414682192e+00},
	{"APV", -2.171572036340612e+01, -1.245316319071853e+01},
	{"APW", -1.778527155190832e+01, -8.522714379220734e+00},
	{"APX", -2.371847248029346e+01, -1.445591530760588e+01},
	{"APY", -1.875591829436514e+01, -9.493361121677557e+00},
	{"APZ", -3.422323941632010e+01, -2.496068224363252e+01},
	{"AQA", -1.724031913918868e+01, -3.861587997378495e+00},
	{"AQB", -1.932487531567788e+01, -5.946144173867688e+00},
	{"AQC", -1.925519149636614e+01, -5.876460354555953e+00},
	{"AQD", -2.001643860536627e+01, -6.637707463556084e+00},
	{"AQE", -2.212542260398572e+01, -8.746691462175530e+00},
	{"AQF", -2.070882987853150e+01, -7.330098736721308e+00},
	{"AQG", -3.448527422011479e+01, -2.110654307830460e+01},
	{"AQH", -1.971597718549482e+01, -6.337246043684630e+00},
	{"AQI", -1.501333207165385e+01, -1.634600929843666e+00},
	{"AQJ", -2.113218381577287e+01, -7.753452673962685e+00},
	{"AQK", -3.611745941505354e+01, -2.273872827324335e+01},
	{"AQL", -2.090609003431972e+01, -7.527358892509527e+00},
	{"AQM", -2.054118706151359e+01, -7.162455919703397e+00},
	{"AQN", -2.213108332527192e+01, -8.752352183461728e+00},
	{"AQO", -2.025680438607815e+01, -6.878073244267961e+00},
	{"AQP", -2.139018078643744e+01, -8.011449644627252e+00},
	{"AQQ", -2.271451799256782e+01, -9.335786850757632e+00},
	{"AQR", -1.971705380786183e+01, -6.338322666051647e+00},
	{"AQS", -1.672848186401934e+01, -3.349750722209156e+00},
	{"AQT", -1.741303964596122e+01, -4.034308504151036e+00},
	{"AQU", -1.502908779685819e+01, -1.650356655048004e+00},
	{"AQV", -3.166362308546403e+01, -1.828489194365385e+01},
	{"AQW", -1.896212941471590e+01, -5.583398272905712e+00},
	{"AQX", -3.814059137293646e+01, -2.476186023112628e+01},
	{"AQY", -2.371594744465309e+01, -1.033721630284290e+01},
	{"AQZ", -3.928015880968699e+01, -2.590142766787681e+01},
	{"ARA", -1.087772605702655e+01, -3.949234625897740e+00},
	{"ARB", -1.305233616505839e+01, -6.123844733929583e+00},
	{"ARC", -1.179341713448937e+01, -4.864925703360565e+00},
	{"ARD", -1.026617237112146e+01, -3.337680939992648e+00},
	{"ARE", -9.415021119306102e+00, -2.486529688177294e+00},
	{"ARF", -1.386656210032342e+01, -6.938070669194618e+00},
	{"ARG", -1.202383911204772e+01, -5.095347680918914e+00},
	{"ARH", -1.438036982835448e+01, -7.451878397225668e+00},
	{"ARI", -1.079946471889327e+01, -3.870973287764468e+00},
	{"ARJ", -1.774066853103074e+01, -1.081217709990193e+01},
	{"ARK", -1.194883972200538e+01, -5.020348290876574e+00},
	{"ARL", -1.183870932844440e+01, -4.910217897315597e+00},
	{"ARM", -1.131640921636356e+01, -4.387917785234755e+00},
	{"ARN", -1.254782825746952e+01, -5.619336826340710e+00},
	{"ARO", -1.181953922256699e+01, -4.891047791438184e+00},
	{"ARP", -1.379355350074475e+01, -6.865062069615942e+00},
	{"ARQ", -1.597724974827716e+01, -9.048758317148350e+00},
	{"ARR", -1.121759890867061e+01, -4.289107477541800e+00},
	{"ARS", -1.109889208256707e+01, -4.170400651438267e+00},
	{"ART", -9.706706465589990e+00, -2.778215034461182e+00},
	{"ARU", -1.458309240230224e+01, -7.654600971173435e+00},
	{"ARV", -1.457608817798367e+01, -7.647596746854857e+00},
	{"ARW", -1.357877830147390e+01, -6.650286870345092e+00},
	{"ARX", -2.139424566166241e+01, -1.446575423053360e+01},
	{"ARY", -1.130522196276718e+01, -4.376730531638374e+00},
	{"ARZ", -1.843323371451971e+01, -1.150474228339090e+01},
	{"ASA", -1.055599120887866e+01, -3.455836245689725e+00},
	{"ASB", -1.230494391901274e+01, -5.204788955823806e+00},
	{"ASC", -1.216483488035696e+01, -5.064679917168023e+00},
	{"ASD", -1.293312601537119e+01, -5.832971052182256e+00},
	{"ASE", -1.085596700997712e+01, -3.755812046788184e+00},
	{"ASF", -1.267819545881081e+01, -5.578040495621874e+00},
	{"ASG", -1.350549897933327e+01, -6.405344016144331e+00},
	{"ASH", -1.128499056327603e+01, -4.184835600087096e+00},
	{"ASI", -1.091812646184828e+01, -3.817971498659344e+00},
	{"ASJ", -1.523886443083821e+01, -8.138709467649278e+00},
	{"ASK", -1.282692633717457e+01, -5.726771373985631e+00},
	{"ASL", -1.311205449763601e+01, -6.011899534447068e+00},
	{"ASM", -1.238428539749311e+01, -5.284130434304176e+00},
	{"ASN", -1.237711042424936e+01, -5.276955461060427e+00},
	{"ASO", -1.172042926706445e+01, -4.620274303875516e+00},
	{"ASP", -1.221506620190746e+01, -5.114911238718522e+00},
	{"ASQ", -1.582979979905783e+01, -8.729644835868896e+00},
	{"ASR", -1.349447251951650e+01, -6.394317556327566e+00},
	{"ASS", -1.000265923914580e+01, -2.902504275956861e+00},
	{"AST", -9.268151902618254e+00, -2.167996939429316e+00},
	{"ASU", -1.221354626745382e+01, -5.113391304264880e+00},
	{"ASV", -1.521468871909003e+01, -8.114533755901089e+00},
	{"ASW", -1.225024375470170e+01, -5.150088791512766e+00},
	{"ASX", -3.028044575240843e+01, -2.318029078921949e+01},
	{"ASY", -1.355244892631588e+01, -6.452293963126944e+00},
	{"ASZ", -1.939660440668189e+01, -1.229644944349295e+01},
	{"ATA", -1.101261983613846e+01, -4.529245245858760e+00},
	{"ATB", -1.294792965517585e+01, -6.464555064896156e+00},
	{"ATC", -1.196465309602054e+01, -5.481278505740843e+00},
	{"ATD", -1.255380278554481e+01, -6.070428195265113e+00},
	{"ATE", -8.969605652273428e+00, -2.486231061993732e+00},
	{"ATF", -1.302338720383692e+01, -6.540012613557223e+00},
	{"ATG", -1.410388603404855e+01, -7.620511443768850e+00},
	{"ATH", -9.432979512595724e+00, -2.949604922316026e+00},
	{"ATI", -8.663508943281887e+00, -2.180134353002188e+00},
	{"ATJ", -1.511508622845060e+01, -8.631711638170904e+00},
	{"ATK", -1.557910793472864e+01, -9.095733344448940e+00},
	{"ATL", -1.245533422399218e+01, -5.971959633712484e+00},
	{"ATM", -1.236939173152238e+01, -5.886017141242681e+00},
	{"ATN", -1.316119824791681e+01, -6.677823657637110e+00},
	{"ATO", -1.124207433566091e+01, -4.758699745381214e+00},
	{"ATP", -1.297469321659423e+01, -6.491318626314530e+00},
	{"ATQ", -1.769629263773828e+01, -1.121291804745859e+01},
	{"ATR", -1.221006018485915e+01, -5.726685594579454e+00},
	{"ATS", -1.130123741802590e+01, -4.817862827746202e+00},
	{"ATT", -9.309988516618922e+00, -2.826613926339225e+00},
	{"ATU", -1.172710546530129e+01, -5.243730875021590e+00},
	{"ATV", -1.544255981616325e+01, -8.959185225883553e+00},
	{"ATW", -1.139474223951483e+01, -4.911367649235136e+00},
	{"ATX", -2.271803940794739e+01, -1.623466481766770e+01},
	{"ATY", -1.297694929358477e+01, -6.493574703305075e+00},
	{"ATZ", -1.858928193924512e+01, -1.210590734896543e+01},
	{"AUA", -1.761549332006179e+01, -7.618922916421130e+00},
	{"AUB", -1.787147619640156e+01, -7.874905792760889e+00},
	{"AUC", -1.657918004118256e+01, -6.582609637541891e+00},
	{"AUD", -1.486209085856269e+01, -4.865520454922025e+00},
	{"AUE", -1.740159152514583e+01, -7.405021121505161e+00},
	{"AUF", -1.895375212743375e+01, -8.957181723793088e+00},
	{"AUG", -1.243746907360376e+01, -2.440898669963091e+00},
	{"AUH", -1.842899278442448e+01, -8.432422380783812e+00},
	{"AUI", -1.903389237768960e+01, -9.037321974048933e+00},
	{"AUJ", -2.113238880666963e+01, -1.113581840302896e+01},
	{"AUK", -2.137241390920862e+01, -1.137584350556795e+01},
	{"AUL", -1.332300354559495e+01, -3.326433141954281e+00},
	{"AUM", -1.721345735955104e+01, -7.216886955910369e+00},
	{"AUN", -1.421815190678798e+01, -4.221581503147317e+00},
	{"AUO", -1.871534585309173e+01, -8.718775449451066e+00},
	{"AUP", -1.651573347643947e+01, -6.519163072798800e+00},
	{"AUQ", -2.371555041181656e+01, -1.371898000817590e+01},
	{"AUR", -1.562860047873724e+01, -5.632030075096573e+00},
	{"AUS", -1.140204334356381e+01, -1.405472939923142e+00},
	{"AUT", -1.260018171428676e+01, -2.603611310646094e+00},
	{"AUU", -2.369855305815612e+01, -1.370198265451545e+01},
	{"AUV", -1.913254085136744e+01, -9.135970447726775e+00},
	{"AUW", -1.773901915022421e+01, -7.742448746583540e+00},
	{"AUX", -1.750903134569048e+01, -7.512460942049813e+00},
	{"AUY", -2.863405893623823e+01, -1.863748853259757e+01},
	{"AUZ", -2.054508667456061e+01, -1.054851627091994e+01},
	{"AVA", -1.330682675460555e+01, -4.380410436915397e+00},
	{"AVB", -2.213249572081213e+01, -1.320607940312197e+01},
	{"AVC", -3.233606960512856e+01, -2.340965328743841e+01},
	{"AVD", -2.171732382155574e+01, -1.279090750386558e+01},
	{"AVE", -9.396327118043066e+00, -4.699108003529110e-01},
	{"AVF", -3.180388235557611e+01, -2.287746603788596e+01},
	{"AVG", -3.313091335815928e+01, -2.420449704046912e+01},
	{"AVH", -3.084575433358773e+01, -2.191933801589757e+01},
	{"AVI", -1.167859225670188e+01, -2.752175939011726e+00},
	{"AVJ", -3.305377105879990e+01, -2.412735474110974e+01},
	{"AVK", -3.493337168157822e+01, -2.600695536388806e+01},
	{"AVL", -2.054847141659035e+01, -1.162205509890019e+01},
	{"AVM", -3.121607753489188e+01, -2.228966121720172e+01},
	{"AVN", -2.071697879961834e+01, -1.179056248192818e+01},
	{"AVO", -1.294906192427466e+01, -4.022645606584509e+00},
	{"AVP", -3.128872453997369e+01, -2.236230822228353e+01},
	{"AVQ", -3.888556645491370e+01, -2.995915013722355e+01},
	{"AVR", -1.876364255561209e+01, -9.837226237921934e+00},
	{"AVS", -1.981093923622986e+01, -1.088452291853970e+01},
	{"AVT", -2.369448530617208e+01, -1.476806898848193e+01},
	{"AVU", -2.025644787589960e+01, -1.133003155820944e+01},
	{"AVV", -2.371743205767581e+01, -1.479101573998565e+01},
	{"AVW", -3.091188940025264e+01, -2.198547308256249e+01},
	{"AVX", -3.551138727201036e+01, -2.658497095432020e+01},
	{"AVY", -1.479676700230266e+01, -5.870350684612500e+00},
	{"AVZ", -3.892126615456808e+01, -2.999484983687792e+01},
	{"AWA", -1.168062786337221e+01, -1.654271986996884e+00},
	{"AWB", -1.638713620577095e+01, -6.360780329395627e+00},
	{"AWC", -1.778607384164361e+01, -7.759717965268294e+00},
	{"AWD", -1.732445835393321e+01, -7.298102477557887e+00},
	{"AWE", -1.409315067001315e+01, -4.066794793637830e+00},
	{"AWF", -1.520671442784178e+01, -5.180358551466460e+00},
	{"AWG", -1.783509902448212e+01, -7.808743148106798e+00},
	{"AWH", -1.342341547655174e+01, -3.397059600176416e+00},
	{"AWI", -1.342030179622633e+01, -3.393945919851007e+00},
	{"AWJ", -1.932531398945863e+01, -9.298958113083309e+00},
	{"AWK", -1.745177415686981e+01, -7.425418280494484e+00},
	{"AWL", -1.630785363901652e+01, -6.281497762641204e+00},
	{"AWM", -1.646036828851773e+01, -6.434012412142410e+00},
	{"AWN", -1.435686588465571e+01, -4.330510008280393e+00},
	{"AWO", -1.349922548290074e+01, -3.472869606525418e+00},
	{"AWP", -1.804487523571659e+01, -8.018519359341269e+00},
	{"AWQ", -2.213248638232953e+01, -1.210613050595421e+01},
	{"AWR", -1.601615919662711e+01, -5.989803320251785e+00},
	{"AWS", -1.373383514702615e+01, -3.707479270650830e+00},
	{"AWT", -1.391882341528652e+01, -3.892467538911202e+00},
	{"AWU", -1.801724777159460e+01, -7.990891895219280e+00},
	{"AWV", -2.013235129182880e+01, -1.010599541545348e+01},
	{"AWW", -1.574043228911268e+01, -5.714076412737361e+00},
	{"AWX", -3.934563052362056e+01, -2.931927464724524e+01},
	{"AWY", -1.580535048508601e+01, -5.778994608710692e+00},
	{"AWZ", -3.286861417425973e+01, -2.284225829788440e+01},
	{"AXA", -1.647102537134041e+01, -3.235241834825966e+00},
	{"AXB", -2.070394528750926e+01, -7.468161750994818e+00},
	{"AXC", -1.926885744205116e+01, -6.033073905536719e+00},
	{"AXD", -1.890541447340766e+01, -5.669630936893221e+00},
	{"AXE", -1.488444081672661e+01, -1.648657280212164e+00},
	{"AXF", -2.024446117998432e+01, -7.008677643469878e+00},
	{"AXG", -2.170204734608255e+01, -8.466263809568103e+00},
	{"AXH", -1.935428353276712e+01, -6.118499996252676e+00},
	{"AXI", -1.544473956893622e+01, -2.208956032421774e+00},
	{"AXJ", -2.212450248268500e+01, -8.888718946170554e+00},
	{"AXK", -3.018425320420087e+01, -1.694846966768643e+01},
	{"AXL", -1.858521318442231e+01, -5.349429647907866e+00},
	{"AXM", -2.051736890079981e+01, -7.281585364285363e+00},
	{"AXN", -2.366879474867052e+01, -1.043301121215608e+01},
	{"AXO", -1.659647609821641e+01, -3.360692561701965e+00},
	{"AXP", -1.885144468414093e+01, -5.615661147626483e+00},
	{"AXQ", -2.818646256346764e+01, -1.495067902695319e+01},
	{"AXR", -1.885576534355593e+01, -5.619981807041490e+00},
	{"AXS", -1.832068242020372e+01, -5.084898883689278e+00},
	{"AXT", -1.749398838550226e+01, -4.258204848987820e+00},
	{"AXU", -2.066089594868414e+01, -7.425112412169692e+00},
	{"AXV", -2.243764288224674e+01, -9.201859345732299e+00},
	{"AXW", -1.839085530298758e+01, -5.155071766473136e+00},
	{"AXX", -2.571693603938228e+01, -1.248115250286784e+01},
	{"AXY", -2.133552367776189e+01, -8.099740141247452e+00},
	{"AXZ", -3.972348231636724e+01, -2.648769877985280e+01},
	{"AYA", -1.241647774875567e+01, -3.555471518541599e+00},
	{"AYB", -1.261097789482882e+01, -3.749971664614745e+00},
	{"AYC", -1.463961186908984e+01, -5.778605638875769e+00},
	{"AYD", -1.478895934304660e+01, -5.927953112832524e+00},
	{"AYE", -1.285920172766125e+01, -3.998195497447178e+00},
	{"AYF", -1.383791891197966e+01, -4.976912681765580e+00},
	{"AYG", -1.623176841921239e+01, -7.370762188998319e+00},
	{"AYH", -1.371464838426447e+01, -4.853642154050392e+00},
	{"AYI", -1.185249270814288e+01, -2.991486477928810e+00},
	{"AYJ", -1.756713325734273e+01, -8.706127027128652e+00},
	{"AYK", -1.716254715000559e+01, -8.301540919791510e+00},
	{"AYL", -1.509096432834447e+01, -6.229958098130394e+00},
	{"AYM", -1.433745533864746e+01, -5.476449108433386e+00},
	{"AYN", -1.463824179035666e+01, -5.777235560142584e+00},
	{"AYO", -1.267175553410349e+01, -3.810749303889413e+00},
	{"AYP", -1.543413211570356e+01, -6.573125885489490e+00},
	{"AYQ", -2.025605371041865e+01, -1.139504748020457e+01},
	{"AYR", -1.548692669532309e+01, -6.625920465109012e+00},
	{"AYS", -1.112299891731532e+01, -2.261992687101250e+00},
	{"AYT", -1.200511635849539e+01, -3.144110128281313e+00},
	{"AYU", -1.440310215846370e+01, -5.542095928249631e+00},
	{"AYV", -1.842902293319082e+01, -9.568016702976740e+00},
	{"AYW", -1.353348103898083e+01, -4.672474808766757e+00},
	{"AYX", -3.107981885665673e+01, -2.221881262644266e+01},
	{"AYY", -1.553301167694293e+01, -6.672005446728853e+00},
	{"AYZ", -2.370502376951794e+01, -1.484401753930386e+01},
	{"AZA", -1.525817457076996e+01, -2.056245631764992e+00},
	{"AZB", -2.069991345733067e+01, -7.497984518325707e+00},
	{"AZC", -2.169828315733530e+01, -8.496354218330332e+00},
	{"AZD", -2.138433623846779e+01, -8.182407299462827e+00},
	{"AZE", -1.508861397616066e+01, -1.886685037155696e+00},
	{"AZF", -2.363309566355609e+01, -1.043116672455112e+01},
	{"AZG", -2.170416550776334e+01, -8.502236568758372e+00},
	{"AZH", -2.038158172958637e+01, -7.179652790581404e+00},
	{"AZI", -1.538839713272445e+01, -2.186468193719481e+00},
	{"AZJ", -3.078380685372079e+01, -1.758187791471583e+01},
	{"AZK", -2.369203688290256e+01, -1.049010794389759e+01},
	{"AZL", -2.325323018925790e+01, -1.005130125025293e+01},
	{"AZM", -2.001001879595383e+01, -6.808089856948865e+00},
	{"AZN", -2.170578123513876e+01, -8.503852296133795e+00},
	{"AZO", -1.741179557578618e+01, -4.209866636781213e+00},
	{"AZP", -2.623580013115029e+01, -1.303387119214533e+01},
	{"AZQ", -3.470002074304413e+01, -2.149809180403917e+01},
	{"AZR", -2.035479685245491e+01, -7.152867913449945e+00},
	{"AZS", -2.053401009513198e+01, -7.332081156127015e+00},
	{"AZT", -1.815650719168709e+01, -4.954578252682129e+00},
	{"AZU", -1.899601815253322e+01, -5.794089213528260e+00},
	{"AZV", -2.786750154718843e+01, -1.466557260818347e+01},
	{"AZW", -2.069412555998398e+01, -7.492196620979011e+00},
	{"AZX", -3.750815730448898e+01, -2.430622836548401e+01},
	{"AZY", -1.795900241729516e+01, -4.757073478290200e+00},
	{"AZZ", -1.696292482882847e+01, -3.760995889823508e+00},
	{"BAA", -1.576975873991376e+01, -5.987219833623256e+00},
	{"BAB", -1.362248402374299e+01, -3.839945117452479e+00},
	{"BAC", -1.258041415333335e+01, -2.797875247042842e+00},
	{"BAD", -1.443533695008544e+01, -4.652798043794935e+00},
	{"BAE", -1.862639230291914e+01, -8.843853396628635e+00},
	{"BAF", -1.809464645662830e+01, -8.312107550337794e+00},
	{"BAG", -1.562285288086335e+01, -5.840313974572842e+00},
	{"BAH", -1.690896678678402e+01, -7.126427880493511e+00},
	{"BAI", -1.678671422587945e+01, -7.004175319588938e+00},
	{"BAJ", -2.170860068948155e+01, -1.192606178319105e+01},
	{"BAK", -1.594816843590720e+01, -6.165629529616695e+00},
	{"BAL", -1.324261341685450e+01, -3.460074510563992e+00},
	{"BAM", -1.767628442889679e+01, -7.893745522606280e+00},
	{"BAN", -1.225319151516221e+01, -2.470652608871708e+00},
	{"BAO", -2.054285110351505e+01, -1.076031219722455e+01},
	{"BAP", -1.654356329016266e+01, -6.761024383872148e+00},
	{"BAQ", -2.367580304251452e+01, -1.389326413622401e+01},
	{"BAR", -1.268623291125548e+01, -2.903694004964978e+00},
	{"BAS", -1.330578676978303e+01, -3.523247863492526e+00},
	{"BAT", -1.254280006580898e+01, -2.760261159518475e+00},
	{"BAU", -1.812433688979416e+01, -8.341797983503653e+00},
	{"BAV", -1.827047733557222e+01, -8.487938429281714e+00},
	{"BAW", -1.849730642435667e+01, -8.714767518066166e+00},
	{"BAX", -2.862565691570678e+01, -1.884311800941627e+01},
	{"BAY", -1.572611491655060e+01, -5.943576010260094e+00},
	{"BAZ", -1.990784977400816e+01, -1.012531086771765e+01},
	{"BBA", -1.542342476074585e+01, -2.169695172027941e+00},
	{"BBB", -2.356255476482324e+01, -1.030882517610534e+01},
	{"BBC", -2.362104854871422e+01, -1.036731895999631e+01},
	{"BBD", -2.885010911856360e+01, -1.559637952984569e+01},
	{"BBE", -1.476622537164312e+01, -1.512495782925211e+00},
	{"BBF", -3.043412392483840e+01, -1.718039433612049e+01},
	{"BBG", -3.203782858782710e+01, -1.878409899910919e+01},
	{"BBH", -2.927972512166718e+01, -1.602599553294927e+01},
	{"BBI", -1.597292612792554e+01, -2.719196539207624e+00},
	{"BBJ", -2.683771842066208e+01, -1.358398883194417e+01},
	{"BBK", -3.229364353848815e+01, -1.903991394977023e+01},
	{"BBL", -1.638180878499676e+01, -3.128079196278846e+00},
	{"BBM", -2.861015923059614e+01, -1.535642964187823e+01},
	{"BBN", -2.939123167389273e+01, -1.613750208517482e+01},
	{"BBO", -1.675584098495508e+01, -3.502111396237170e+00},
	{"BBP", -3.010287419215176e+01, -1.684914460343385e+01},
	{"BBQ", -3.616103460993522e+01, -2.290730502121730e+01},
	{"BBR", -2.022489391421014e+01, -6.971164325492232e+00},
	{"BBS", -2.084980233288132e+01, -7.596072744163406e+00},
	{"BBT", -2.204435768735949e+01, -8.790628098641578e+00},
	{"BBU", -1.876272095842307e+01, -5.508991369705157e+00},
	{"BBV", -3.007554123938598e+01, -1.682181165066807e+01},
	{"BBW", -2.948410428044235e+01, -1.623037469172444e+01},
	{"BBX", -3.944824244917582e+01, -2.619451286045791e+01},
	{"BBY", -1.814736669521977e+01, -4.893637106501863e+00},
	{"BBZ", -3.395634632494322e+01, -2.070261673622531e+01},
	{"BCA", -1.639645927988233e+01, -2.438785470581989e+00},
	{"BCB", -1.867394890414431e+01, -4.716275094843967e+00},
	{"BCC", -1.888385168091613e+01, -4.926177871615791e+00},
	{"BCD", -2.071184127574127e+01, -6.754167466440922e+00},
	{"BCE", -1.990235719405821e+01, -5.944683384757865e+00},
	{"BCF", -1.954751769845124e+01, -5.589843889150896e+00},
	{"BCG", -1.991068587445936e+01, -5.953012065159014e+00},
	{"BCH", -1.722843477564943e+01, -3.270760966349088e+00},
	{"BCI", -1.821534914369082e+01, -4.257675334390472e+00},
	{"BCJ", -2.271707594051407e+01, -8.759402131213733e+00},
	{"BCK", -2.278129159403323e+01, -8.823617784732892e+00},
	{"BCL", -1.982510572037517e+01, -5.867431911074831e+00},
	{"BCM", -2.090699152621355e+01, -6.949317716913209e+00},
	{"BCN", -2.139354272299684e+01, -7.435868913696494e+00},
	{"BCO", -1.755487683030624e+01, -3.597203021005896e+00},
	{"BCP", -1.913192651491312e+01, -5.174252705612778e+00},
	{"BCQ", -2.366817866383240e+01, -9.710504854532058e+00},
	{"BCR", -1.933269985258205e+01, -5.375026043281706e+00},
	{"BCS", -1.885612729541902e+01, -4.898453486118679e+00},
	{"BCT", -1.603889799706186e+01, -2.081224187761520e+00},
	{"BCU", -2.117695134892357e+01, -7.219277539623228e+00},
	{"BCV", -2.371376960698231e+01, -9.756095797681963e+00},
	{"BCW", -1.767322902706390e+01, -3.715555217763556e+00},
	{"BCX", -3.312482296897225e+01, -1.916714915967191e+01},
	{"BCY", -2.346480112520938e+01, -9.507127315909038e+00},
	{"BCZ", -3.173587281349768e+01, -1.777819900419733e+01},
	{"BDA", -2.072545357380809e+01, -5.462343427181011e+00},
	{"BDB", -2.516822815227797e+01, -9.905118005650900e+00},
	{"BDC", -2.631363421707540e+01, -1.105052407044833e+01},
	{"BDD", -2.610498280121851e+01, -1.084187265459144e+01},
	{"BDE", -1.889983622296904e+01, -3.636726076341968e+00},
	{"BDF", -2.582140369915584e+01, -1.055829355252877e+01},
	{"BDG", -2.654834026984444e+01, -1.128523012321736e+01},
	{"BDH", -2.517444345339702e+01, -9.911333306769944e+00},
	{"BDI", -1.720960011572079e+01, -1.946489969093709e+00},
	{"BDJ", -2.817623826042851e+01, -1.291312811380144e+01},
	{"BDK", -2.935308408080432e+01, -1.408997393417724e+01},
	{"BDL", -2.637690431210759e+01, -1.111379416548052e+01},
	{"BDM", -2.593074819241537e+01, -1.066763804578829e+01},
	{"BDN", -2.619945245971535e+01, -1.093634231308827e+01},
	{"BDO", -1.802631944586822e+01, -2.763209299241143e+00},
	{"BDP", -2.658726412256810e+01, -1.132415397594103e+01},
	{"BDQ", -3.079697561131784e+01, -1.553386546469077e+01},
	{"BDR", -2.066784488425475e+01, -5.404734737627675e+00},
	{"BDS", -2.446512209562982e+01, -9.202011949002740e+00},
	{"BDT", -2.353555625456641e+01, -8.272446107939334e+00},
	{"BDU", -1.640306882478847e+01, -1.139958678161395e+00},
	{"BDV", -2.788224540506482e+01, -1.261913525843774e+01},
	{"BDW", -2.525425100385107e+01, -9.991140857223987e+00},
	{"BDX", -3.569616591259204e+01, -2.043305576596497e+01},
	{"BDY", -2.662296851158185e+01, -1.135985836495478e+01},
	{"BDZ", -3.177860771291054e+01, -1.651549756628346e+01},
	{"BEA", -1.124299405800260e+01, -3.601883902501430e+00},
	{"BEB", -1.400030852400361e+01, -6.359198368502432e+00},
	{"BEC", -1.109713855009968e+01, -3.456028394598500e+00},
	{"BED", -1.220935251252766e+01, -4.568242357026486e+00},
	{"BEE", -1.104237443868622e+01, -3.401264283185042e+00},
	{"BEF", -1.128812189189428e+01, -3.647011736393108e+00},
	{"BEG", -1.211634106663272e+01, -4.475230911131549e+00},
	{"BEH", -1.213684015242035e+01, -4.495729996919176e+00},
	{"BEI", -1.198961129064807e+01, -4.348501135146890e+00},
	{"BEJ", -1.693675084766102e+01, -9.295640692159839e+00},
	{"BEK", -1.569567293339092e+01, -8.054562777889750e+00},
	{"BEL", -1.169529125550430e+01, -4.054181100003127e+00},
	{"BEM", -1.386854484612745e+01, -6.227434690626276e+00},
	{"BEN", -1.272336225278915e+01, -5.082252097287975e+00},
	{"BEO", -1.367330307597418e+01, -6.032192920473006e+00},
	{"BEP", -1.372058039073368e+01, -6.079470235232508e+00},
	{"BEQ", -1.711779314496284e+01, -9.476682989461663e+00},
	{"BER", -1.048296660839622e+01, -2.841856452895041e+00},
	{"BES", -1.171850054205223e+01, -4.077390386551059e+00},
	{"BET", -1.125913601011228e+01, -3.618025854611105e+00},
	{"BEU", -1.438293386261125e+01, -6.741823707110070e+00},
	{"BEV", -1.598081727062983e+01, -8.339707115128656e+00},
	{"BEW", -1.395258423773979e+01, -6.311474082238616e+00},
	{"BEX", -1.999434358358070e+01, -1.235323342807952e+01},
	{"BEY", -1.386788106646233e+01, -6.226770910961153e+00},
	{"BEZ", -1.807446676775566e+01, -1.043335661225449e+01},
	{"BFA", -2.080165947210930e+01, -3.949744408099741e+00},
	{"BFB", -2.768355486395217e+01, -1.083163979994261e+01},
	{"BFC", -2.709742701327694e+01, -1.024551194926739e+01},
	{"BFD", -2.797939990406641e+01, -1.112748484005685e+01},
	{"BFE", -2.081824359331256e+01, -3.966328529302998e+00},
	{"BFF", -2.540912954584071e+01, -8.557214481831151e+00},
	{"BFG", -2.763396942389980e+01, -1.078205435989024e+01},
	{"BFH", -2.643444698411528e+01, -9.582531920105719e+00},
	{"BFI", -2.062106700550752e+01, -3.769151941497968e+00},
	{"BFJ", -2.842226399784187e+01, -1.157034893383232e+01},
	{"BFK", -3.031844476279140e+01, -1.346652969878185e+01},
	{"BFL", -2.134678330564494e+01, -4.494868241635384e+00},
	{"BFM", -2.676563097486551e+01, -9.913715910855954e+00},
	{"BFN", -2.838718588243280e+01, -1.153527081842325e+01},
	{"BFO", -1.761209572678051e+01, -7.601806627709491e-01},
	{"BFP", -2.729766382938076e+01, -1.044574876537121e+01},
	{"BFQ", -3.256529033306398e+01, -1.571337526905443e+01},
	{"BFR", -1.967919365550869e+01, -2.827278591499137e+00},
	{"BFS", -2.662525064647880e+01, -9.773335582469249e+00},
	{"BFT", -2.360618588947989e+01, -6.754270825470329e+00},
	{"BFU", -2.607312422082857e+01, -9.221209156819015e+00},
	{"BFV", -2.959927262636843e+01, -1.274735756235887e+01},
	{"BFW", -2.735158755096710e+01, -1.049967248695754e+01},
	{"BFX", -3.487666183739749e+01, -1.802474677338793e+01},
	{"BFY", -2.799411989517346e+01, -1.114220483116390e+01},
	{"BFZ", -3.100525529692402e+01, -1.415334023291446e+01},
	{"BGA", -2.144458941003425e+01, -2.996151252398661e+00},
	{"BGB", -2.716533248738655e+01, -8.716894329750970e+00},
	{"BGC", -2.741635904739598e+01, -8.967920889760391e+00},
	{"BGD", -2.728746410085506e+01, -8.839025943219470e+00},
	{"BGE", -2.025335890030150e+01, -1.804920742665909e+00},
	{"BGF", -2.697104287609774e+01, -8.522604718462155e+00},
	{"BGG", -2.711253301613594e+01, -8.664094858500350e+00},
	{"BGH", -2.363499746790160e+01, -5.186559310266011e+00},
	{"BGI", -2.235010820416676e+01, -3.901670046531172e+00},
	{"BGJ", -2.214485231328235e+01, -3.696414155646757e+00},
	{"BGK", -3.087869755737669e+01, -1.243025939974111e+01},
	{"BGL", -2.336698421122491e+01, -4.918546053589324e+00},
	{"BGM", -2.692282789169991e+01, -8.474389734064324e+00},
	{"BGN", -2.603565964908325e+01, -7.587221491447663e+00},
	{"BGO", -2.144403625790969e+01, -2.995598100274106e+00},
	{"BGP", -2.740862004860170e+01, -8.960181890966116e+00},
	{"BGQ", -3.217177665199476e+01, -1.372333849435917e+01},
	{"BGR", -2.079578401281555e+01, -2.347345855179964e+00},
	{"BGS", -2.524859681855185e+01, -6.800158660916262e+00},
	{"BGT", -2.436130903403174e+01, -5.912870876396156e+00},
	{"BGU", -2.533346711510553e+01, -6.885028957469940e+00},
	{"BGV", -3.001221843391525e+01, -1.156378027627967e+01},
	{"BGW", -2.659336206188724e+01, -8.144923904251657e+00},
	{"BGX", -3.539059711844212e+01, -1.694215896080653e+01},
	{"BGY", -2.736520727325469e+01, -8.916769115619100e+00},
	{"BGZ", -3.397885063247435e+01, -1.553041247483876e+01},
	{"BHA", -1.785868666228482e+01, -2.165130048495420e+00},
	{"BHB", -2.902029483925794e+01, -1.332673822546853e+01},
	{"BHC", -2.899227095233078e+01, -1.329871433854138e+01},
	{"BHD", -2.947172397915713e+01, -1.377816736536773e+01},
	{"BHE", -1.799143880935532e+01, -2.297882195565915e+00},
	{"BHF", -2.900695605836673e+01, -1.331339944457733e+01},
	{"BHG", -2.999056308470884e+01, -1.429700647091944e+01},
	{"BHH", -2.792764614930257e+01, -1.223408953551317e+01},
	{"BHI", -1.851476061175121e+01, -2.821203997961811e+00},
	{"BHJ", -3.190899311383880e+01, -1.621543650004940e+01},
	{"BHK", -3.223259650255621e+01, -1.653903988876680e+01},
	{"BHL", -2.953136765050547e+01, -1.383781103671607e+01},
	{"BHM", -2.853229425918195e+01, -1.283873764539254e+01},
	{"BHN", -2.944329618601749e+01, -1.374973957222809e+01},
	{"BHO", -1.700880265547988e+01, -1.315246041690481e+00},
	{"BHP", -2.937613123788369e+01, -1.368257462409430e+01},
	{"BHQ", -3.366499100572778e+01, -1.797143439193838e+01},
	{"BHR", -2.733168255594271e+01, -1.163812594215331e+01},
	{"BHS", -2.798059489084738e+01, -1.228703827705798e+01},
	{"BHT", -2.549931890054648e+01, -9.805762286757082e+00},
	{"BHU", -2.089230508194085e+01, -5.198748468151451e+00},
	{"BHV", -3.214772770296800e+01, -1.645417108917860e+01},
	{"BHW", -2.811844826368225e+01, -1.242489164989285e+01},
	{"BHX", -3.766092803467094e+01, -2.196737142088153e+01},
	{"BHY", -2.755692915969139e+01, -1.186337254590200e+01},
	{"BHZ", -3.467281028054465e+01, -1.897925366675524e+01},
	{"BIA", -1.534498987467612e+01, -4.757988372185345e+00},
	{"BIB", -1.645902795242366e+01, -5.872026449932879e+00},
	{"BIC", -1.671370683806882e+01, -6.126705335578042e+00},
	{"BID", -1.475316311294143e+01, -4.166161610450652e+00},
	{"BIE", -1.689960899048544e+01, -6.312607487994669e+00},
	{"BIF", -1.916279677236202e+01, -8.575795269871243e+00},
	{"BIG", -1.520793173783278e+01, -4.620930235342003e+00},
	{"BIH", -1.906939689134712e+01, -8.482395388856343e+00},
	{"BII", -1.913092082942666e+01, -8.543919326935884e+00},
	{"BIJ", -1.886031872395383e+01, -8.273317221463056e+00},
	{"BIK", -2.135903276667161e+01, -1.077203126418083e+01},
	{"BIL", -1.296435482871975e+01, -2.377353326228977e+00},
	{"BIM", -1.628413928371680e+01, -5.697137781226020e+00},
	{"BIN", -1.343785536803972e+01, -2.850853865548945e+00},
	{"BIO", -1.725176752197002e+01, -6.664766019479242e+00},
	{"BIP", -1.828501458624807e+01, -7.698013083757298e+00},
	{"BIQ", -2.139095567126134e+01, -1.080395416877056e+01},
	{"BIR", -1.408925797417151e+01, -3.502256471680731e+00},
	{"BIS", -1.525916816799217e+01, -4.672166665501395e+00},
	{"BIT", -1.230557567823443e+01, -1.718574175743654e+00},
	{"BIU", -1.720917472465799e+01, -6.622173222167215e+00},
	{"BIV", -1.995034047482973e+01, -9.363338972338957e+00},
	{"BIW", -2.052798179047593e+01, -9.940980287985148e+00},
	{"BIX", -2.786540120473691e+01, -1.727839970224614e+01},
	{"BIY", -3.294904802276640e+01, -2.236204652027562e+01},
	{"BIZ", -2.024628534144724e+01, -9.659283838956462e+00},
	{"BJA", -2.185775898958738e+01, -8.608838616780837e+00},
	{"BJB", -3.024338883802015e+01, -1.699446846521360e+01},
	{"BJC", -3.109277848551667e+01, -1.784385811271013e+01},
	{"BJD", -3.298693606778011e+01, -1.973801569497357e+01},
	{"BJE", -1.331050557727930e+01, -6.158520447275686e-02},
	{"BJF", -3.211062196418440e+01, -1.886170159137786e+01},
	{"BJG", -3.169516286032368e+01, -1.844624248751713e+01},
	{"BJH", -3.087157384359598e+01, -1.762265347078943e+01},
	{"BJI", -2.695226545483525e+01, -1.370334508202870e+01},
	{"BJJ", -3.088709858331533e+01, -1.763817821050879e+01},
	{"BJK", -3.357567009118662e+01, -2.032674971838008e+01},
	{"BJL", -3.208450296042323e+01, -1.883558258761669e+01},
	{"BJM", -3.244042833415068e+01, -1.919150796134414e+01},
	{"BJN", -3.539049806280331e+01, -2.214157768999676e+01},
	{"BJO", -1.990445051636341e+01, -6.655530143556862e+00},
	{"BJP", -3.185228059696972e+01, -1.860336022416317e+01},
	{"BJQ", -3.483853233789559e+01, -2.158961196508905e+01},
	{"BJR", -3.106270707471604e+01, -1.781378670190950e+01},
	{"BJS", -3.150149589124465e+01, -1.825257551843811e+01},
	{"BJT", -3.159563321346370e+01, -1.834671284065715e+01},
	{"BJU", -1.834768718540890e+01, -5.098766812602356e+00},
	{"BJV", -3.845758555749645e+01, -2.520866518468991e+01},
	{"BJW", -3.083184160106743e+01, -1.758292122826088e+01},
	{"BJX", -4.113689096456527e+01, -2.788797059175873e+01},
	{"BJY", -3.760676171540989e+01, -2.435784134260335e+01},
	{"BJZ", -3.571176280886832e+01, -2.246284243606178e+01},
	{"BKA", -2.545656519197694e+01, -6.752312083680307e+00},
	{"BKB", -2.776866165495504e+01, -9.064408546658409e+00},
	{"BKC", -2.820053503727883e+01, -9.496281928982198e+00},
	{"BKD", -2.883374324966433e+01, -1.012949014136770e+01},
	{"BKE", -2.299684478932209e+01, -4.292591681025459e+00},
	{"BKF", -2.766506999307718e+01, -8.960816884780545e+00},
	{"BKG", -2.993767077039433e+01, -1.123341766209769e+01},
	{"BKH", -2.733537014726432e+01, -8.631117038967684e+00},
	{"BKI", -1.929066528961368e+01, -5.864121813170533e-01},
	{"BKJ", -3.151584525179477e+01, -1.281159214349814e+01},
	{"BKK", -3.084757534424707e+01, -1.214332223595043e+01},
	{"BKL", -2.722620390437449e+01, -8.521950796077853e+00},
	{"BKM", -2.820057254631920e+01, -9.496319438022571e+00},
	{"BKN", -2.323500223700307e+01, -4.530749128706431e+00},
	{"BKO", -2.344177442435716e+01, -4.737521316060523e+00},
	{"BKP", -2.855151219178538e+01, -9.847259083488749e+00},
	{"BKQ", -3.419498504636785e+01, -1.549073193807121e+01},
	{"BKR", -2.898711648729017e+01, -1.028286337899354e+01},
	{"BKS", -2.131822779270298e+01, -2.613974684406347e+00},
	{"BKT", -2.587031027668180e+01, -7.166057168385168e+00},
	{"BKU", -2.771837587943696e+01, -9.014122771140324e+00},
	{"BKV", -3.135600031763946e+01, -1.265174720934283e+01},
	{"BKW", -2.704181854063171e+01, -8.337565432335072e+00},
	{"BKX", -3.516703191226111e+01, -1.646277880396447e+01},
	{"BKY", -2.771203967732239e+01, -9.007786569025761e+00},
	{"BKZ", -3.326889479813084e+01, -1.456464168983421e+01},
	{"BLA", -1.347245771934961e+01, -4.137364803041463e+00},
	{"BLB", -2.715615069276974e+01, -1.782105777646158e+01},
	{"BLC", -2.776802809722352e+01, -1.843293518091537e+01},
	{"BLD", -2.506881304417744e+01, -1.573372012786928e+01},
	{"BLE", -1.009046700276968e+01, -7.553740864615266e-01},
	{"BLF", -2.690737401883347e+01, -1.757228110252532e+01},
	{"BLG", -2.859204042320195e+01, -1.925694750689380e+01},
	{"BLH", -2.802390364964472e+01, -1.868881073333657e+01},
	{"BLI", -1.167279982655449e+01, -2.337706910246336e+00},
	{"BLJ", -3.132406804049018e+01, -2.198897512418203e+01},
	{"BLK", -2.859636494380045e+01, -1.926127202749229e+01},
	{"BLL", -2.384844491160489e+01, -1.451335199529674e+01},
	{"BLM", -2.767112615647099e+01, -1.833603324016284e+01},
	{"BLN", -2.838053993828293e+01, -1.904544702197478e+01},
	{"BLO", -1.313894645835132e+01, -3.803853542043163e+00},
	{"BLP", -2.765672078946411e+01, -1.832162787315596e+01},
	{"BLQ", -3.241277229532002e+01, -2.307767937901187e+01},
	{"BLR", -2.818740688018990e+01, -1.885231396388175e+01},
	{"BLS", -2.595374382228179e+01, -1.661865090597364e+01},
	{"BLT", -2.543454659010877e+01, -1.609945367380061e+01},
	{"BLU", -1.491744536808365e+01, -5.582352451775502e+00},
	{"BLV", -2.795673284233764e+01, -1.862163992602948e+01},
	{"BLW", -2.765354919119719e+01, -1.831845627488903e+01},
	{"BLX", -3.571474047944752e+01, -2.637964756313937e+01},
	{"BLY", -1.338519378492045e+01, -4.050100868612302e+00},
	{"BLZ", -3.437623095256329e+01, -2.504113803625514e+01},
	{"BMA", -1.731957733970872e+01, -2.296783770166888e+00},
	{"BMB", -2.505390185827036e+01, -1.003110828872853e+01},
	{"BMC", -2.137929914958719e+01, -6.356505580045355e+00},
	{"BMD", -2.784047392864382e+01, -1.281768035910199e+01},
	{"BME", -1.919547760141110e+01, -4.172684031869263e+00},
	{"BMF", -2.718168129553445e+01, -1.215888772599262e+01},
	{"BMG", -2.883520827888787e+01, -1.381241470934603e+01},
	{"BMH", -2.680405405499213e+01, -1.178126048545029e+01},
	{"BMI", -1.567443547713350e+01, -6.516419075916662e-01},
	{"BMJ", -3.026346974528994e+01, -1.524067617574810e+01},
	{"BMK", -3.057191200939906e+01, -1.554911843985723e+01},
	{"BML", -2.809099753084067e+01, -1.306820396129883e+01},
	{"BMM", -2.511346497553390e+01, -1.009067140599207e+01},
	{"BMN", -2.704862386475115e+01, -1.202583029520932e+01},
	{"BMO", -1.952525562740584e+01, -4.502462057864004e+00},
	{"BMP", -2.295880119898185e+01, -7.936007629440021e+00},
	{"BMQ", -3.318022873981652e+01, -1.815743517027468e+01},
	{"BMR", -2.361274064463791e+01, -8.589947075096079e+00},
	{"BMS", -2.495100729251007e+01, -9.928213722968241e+00},
	{"BMT", -2.466036791387942e+01, -9.637574344337583e+00},
	{"BMU", -2.159344946045986e+01, -6.570655890918029e+00},
	{"BMV", -2.991450991062169e+01, -1.489171634107985e+01},
	{"BMW", -2.637571088143771e+01, -1.135291731189588e+01},
	{"BMX", -3.481991819676998e+01, -1.979712462722815e+01},
	{"BMY", -2.032945185388934e+01, -5.306658284347510e+00},
	{"BMZ", -3.344899231579686e+01, -1.842619874625503e+01},
	{"BNA", -1.899357401179305e+01, -3.191732768091839e+00},
	{"BNB", -2.752347183884270e+01, -1.172163059514149e+01},
	{"BNC", -2.559646965879376e+01, -9.794628415092546e+00},
	{"BND", -2.345672325133996e+01, -7.654882007638745e+00},
	{"BNE", -1.664316659297808e+01, -8.413253492768633e-01},
	{"BNF", -2.727765172270129e+01, -1.147581047900008e+01},
	{"BNG", -2.434563328669244e+01, -8.543792042991223e+00},
	{"BNH", -2.699229075318014e+01, -1.119044950947892e+01},
	{"BNI", -1.952121943583050e+01, -3.719378192129279e+00},
	{"BNJ", -2.968444665642313e+01, -1.388260541272192e+01},
	{"BNK", -2.834169134400756e+01, -1.253985010030634e+01},
	{"BNL", -2.774693596425776e+01, -1.194509472055654e+01},
	{"BNM", -2.769768269286845e+01, -1.189584144916723e+01},
	{"BNN", -2.764880550336747e+01, -1.184696425966626e+01},
	{"BNO", -1.789528023608597e+01, -2.093438992384755e+00},
	{"BNP", -2.818757405593358e+01, -1.238573281223237e+01},
	{"BNQ", -3.059526159561419e+01, -1.479342035191298e+01},
	{"BNR", -2.875390689514797e+01, -1.295206565144675e+01},
	{"BNS", -2.325118099069970e+01, -7.449339746998482e+00},
	{"BNT", -2.372567945875934e+01, -7.923838215058126e+00},
	{"BNU", -2.771273688707558e+01, -1.191089564337437e+01},
	{"BNV", -2.883978097169640e+01, -1.303793972799518e+01},
	{"BNW", -2.719194857996159e+01, -1.139010733626037e+01},
	{"BNX", -3.265183573779690e+01, -1.684999449409568e+01},
	{"BNY", -2.721735767040302e+01, -1.141551642670180e+01},
	{"BNZ", -3.316054078157649e+01, -1.735869953787527e+01},
	{"BOA", -1.355208012686515e+01, -4.268807611812899e+00},
	{"BOB", -1.694564508344486e+01, -7.662372568392609e+00},
	{"BOC", -1.827935587842984e+01, -8.996083363377586e+00},
	{"BOD", -1.245627016280272e+01, -3.172997647750459e+00},
	{"BOE", -1.804120746705589e+01, -8.757934952003639e+00},
	{"BOF", -1.663743817961402e+01, -7.354165664561761e+00},
	{"BOG", -1.850107375551788e+01, -9.217801240465628e+00},
	{"BOH", -1.790391159870432e+01, -8.620639083652058e+00},
	{"BOI", -1.520956700084919e+01, -5.926294485796935e+00},
	{"BOJ", -2.727137746763661e+01, -1.798810495258435e+01},
	{"BOK", -2.086243856054793e+01, -1.157916604549567e+01},
	{"BOL", -1.449260234154186e+01, -5.209329826489610e+00},
	{"BOM", -1.524864519604676e+01, -5.965372680994501e+00},
	{"BON", -1.368411148294506e+01, -4.400838967892810e+00},
	{"BOO", -1.295325854066414e+01, -3.669986025611879e+00},
	{"BOP", -2.151154740312426e+01, -1.222827488807201e+01},
	{"BOQ", -3.058729639271737e+01, -2.130402387766512e+01},
	{"BOR", -1.213128533812744e+01, -2.848012823075179e+00},
	{"BOS", -1.507531723721212e+01, -5.792044722159864e+00},
	{"BOT", -1.261559279294683e+01, -3.332320277894572e+00},
	{"BOU", -1.123094009556745e+01, -1.947667580515194e+00},
	{"BOV", -1.402967243810587e+01, -4.746399923053611e+00},
	{"BOW", -1.434567471738276e+01, -5.062402202330508e+00},
	{"BOX", -1.612611550976592e+01, -6.842842994713667e+00},
	{"BOY", -1.393383597510436e+01, -4.650563460052109e+00},
	{"BOZ", -1.991036131925528e+01, -1.062708880420302e+01},
	{"BPA", -1.793370836359356e+01, -1.420224601633310e+00},
	{"BPB", -2.881962274128494e+01, -1.230613897932469e+01},
	{"BPC", -2.971549455098397e+01, -1.320201078902372e+01},
	{"BPD", -3.025233716907578e+01, -1.373885340711553e+01},
	{"BPE", -2.121391082394965e+01, -4.700427061989400e+00},
	{"BPF", -2.879584641110889e+01, -1.228236264914864e+01},
	{"BPG", -2.960354124341490e+01, -1.309005748145465e+01},
	{"BPH", -2.322818122700476e+01, -6.714697465044512e+00},
	{"BPI", -2.235362430689185e+01, -5.840140544931602e+00},
	{"BPJ", -3.242779854368030e+01, -1.591431478172006e+01},
	{"BPK", -3.231071915169921e+01, -1.579723538973896e+01},
	{"BPL", -2.140578557465851e+01, -4.892301812698257e+00},
	{"BPM", -2.365105986074338e+01, -7.137576098783136e+00},
	{"BPN", -3.014708325238387e+01, -1.363359949042362e+01},
	{"BPO", -1.977578836969998e+01, -3.262304607739737e+00},
	{"BPP", -2.463122801301702e+01, -8.117744251056774e+00},
	{"BPQ", -3.368406920934144e+01, -1.717058544738120e+01},
	{"BPR", -1.795230059059995e+01, -1.438816828639705e+00},
	{"BPS", -2.164767721193059e+01, -5.134193449970344e+00},
	{"BPT", -2.465440330378446e+01, -8.140919541824209e+00},
	{"BPU", -2.319817703102009e+01, -6.684693269059845e+00},
	{"BPV", -3.184203684458508e+01, -1.532855308262483e+01},
	{"BPW", -2.804379420419038e+01, -1.153031044223014e+01},
	{"BPX", -3.718524791474925e+01, -2.067176415278900e+01},
	{"BPY", -2.739587457170959e+01, -1.088239080974934e+01},
	{"BPZ", -3.549036354020035e+01, -1.897687977824010e+01},
	{"BQA", -2.976886988814050e+01, -7.197225708396799e+00},
	{"BQB", -3.239629183528278e+01, -9.824647655539076e+00},
	{"BQC", -3.130729105317966e+01, -8.735646873435954e+00},
	{"BQD", -3.291799569537270e+01, -1.034635151562900e+01},
	{"BQE", -3.330589023951696e+01, -1.073424605977324e+01},
	{"BQF", -3.166479463877356e+01, -9.093150459029857e+00},
	{"BQG", -3.838161861315506e+01, -1.580997443341136e+01},
	{"BQH", -3.221635329563269e+01, -9.644709115888979e+00},
	{"BQI", -2.810791390352474e+01, -5.536269723781035e+00},
	{"BQJ", -3.418166507077449e+01, -1.161002089103077e+01},
	{"BQK", -4.001380380809380e+01, -1.744215962835010e+01},
	{"BQL", -3.265874086907569e+01, -1.008709668933198e+01},
	{"BQM", -3.182243809419275e+01, -9.250793914449046e+00},
	{"BQN", -3.466567140390374e+01, -1.209402722416004e+01},
	{"BQO", -3.286211723462918e+01, -1.029047305488548e+01},
	{"BQP", -3.286430262105504e+01, -1.029265844131134e+01},
	{"BQQ", -3.474570556979214e+01, -1.217406139004843e+01},
	{"BQR", -3.271100607250690e+01, -1.013936189276319e+01},
	{"BQS", -2.978331822779565e+01, -7.211674048051945e+00},
	{"BQT", -3.028298923172996e+01, -7.711345051986252e+00},
	{"BQU", -2.265373911420328e+01, -8.209493445957013e-02},
	{"BQV", -3.557685925014542e+01, -1.300521507040171e+01},
	{"BQW", -3.193511207429169e+01, -9.363467894547982e+00},
	{"BQX", -4.203693576597674e+01, -1.946529158623303e+01},
	{"BQY", -3.622965596742352e+01, -1.365801178767981e+01},
	{"BQZ", -4.317650320272727e+01, -2.060485902298356e+01},
	{"BRA", -1.223283205368952e+01, -2.447581202892256e+00},
	{"BRB", -2.663805228182579e+01, -1.685280143102852e+01},
	{"BRC", -2.562916571879368e+01, -1.584391486799641e+01},
	{"BRD", -2.467773723791298e+01, -1.489248638711572e+01},
	{"BRE", -1.204551393321818e+01, -2.260263082420911e+00},
	{"BRF", -2.351858452785139e+01, -1.373333367705412e+01},
	{"BRG", -2.609043960765171e+01, -1.630518875685444e+01},
	{"BRH", -2.627202696260585e+01, -1.648677611180858e+01},
	{"BRI", -1.165461877537008e+01, -1.869367924572810e+00},
	{"BRJ", -2.956041005435248e+01, -1.977515920355521e+01},
	{"BRK", -2.642783646591337e+01, -1.664258561511610e+01},
	{"BRL", -2.629513051662518e+01, -1.650987966582791e+01},
	{"BRM", -2.330349558934744e+01, -1.351824473855017e+01},
	{"BRN", -2.535822459689280e+01, -1.557297374609553e+01},
	{"BRO", -1.157592095421995e+01, -1.790670103422678e+00},
	{"BRP", -2.656090219474315e+01, -1.677565134394588e+01},
	{"BRQ", -3.094694618459325e+01, -2.116169533379598e+01},
	{"BRR", -2.583017297212974e+01, -1.604492212133247e+01},
	{"BRS", -2.406695777154699e+01, -1.428170692074972e+01},
	{"BRT", -2.377527527826600e+01, -1.399002442746873e+01},
	{"BRU", -1.448457891908082e+01, -4.699328068283552e+00},
	{"BRV", -2.687808952451034e+01, -1.709283867371307e+01},
	{"BRW", -2.623326959867234e+01, -1.644801874787506e+01},
	{"BRX", -3.161207235735271e+01, -2.182682150655544e+01},
	{"BRY", -1.709817451759088e+01, -7.312923666793615e+00},
	{"BRZ", -3.251260469225053e+01, -2.272735384145326e+01},
	{"BSA", -1.517744471177259e+01, -3.348723968586152e+00},
	{"BSB", -1.894148126245526e+01, -7.112760519268816e+00},
	{"BSC", -1.609898243867067e+01, -4.270261695484229e+00},
	{"BSD", -1.988431204648297e+01, -8.055591303296533e+00},
	{"BSE", -1.366355233863565e+01, -1.834831595449208e+00},
	{"BSF", -1.849208978829190e+01, -6.663369045105465e+00},
	{"BSG", -2.109596881095815e+01, -9.267248067771716e+00},
	{"BSH", -1.715246318190026e+01, -5.323742438713824e+00},
	{"BSI", -1.593208254319766e+01, -4.103361800011224e+00},
	{"BSJ", -2.366438427185329e+01, -1.183566352866686e+01},
	{"BSK", -2.207491984466267e+01, -1.024619910147623e+01},
	{"BSL", -2.021383560654847e+01, -8.385114863362038e+00},
	{"BSM", -1.968134491524319e+01, -7.852624172056752e+00},
	{"BSN", -2.084993256137427e+01, -9.021211818187833e+00},
	{"BSO", -1.454063629853712e+01, -2.711915555350680e+00},
	{"BSP", -1.872884700759028e+01, -6.900126264403836e+00},
	{"BSQ", -2.833589561746139e+01, -1.650717487427495e+01},
	{"BSR", -2.085896204530505e+01, -9.030241302118609e+00},
	{"BSS", -1.898282470952591e+01, -7.154103966339476e+00},
	{"BST", -1.386201848476137e+01, -2.033297741574930e+00},
	{"BSU", -1.734652911396715e+01, -5.517808370780718e+00},
	{"BSV", -2.210079188343533e+01, -1.027207114024889e+01},
	{"BSW", -1.789025806749053e+01, -6.061537324304094e+00},
	{"BSX", -3.040053200436332e+01, -1.857181126117689e+01},
	{"BSY", -2.088122557698475e+01, -9.052504833798315e+00},
	{"BSZ", -3.186350647647345e+01, -2.003478573328702e+01},
	{"BTA", -1.402216676898303e+01, -1.519006663583409e+00},
	{"BTB", -1.842416198457754e+01, -5.921001879177924e+00},
	{"BTC", -2.051335577606682e+01, -8.010195670667198e+00},
	{"BTD", -2.052587506653811e+01, -8.022714961138496e+00},
	{"BTE", -1.637803263413509e+01, -3.874872528735466e+00},
	{"BTF", -1.750479790811776e+01, -5.001637802718144e+00},
	{"BTG", -2.357721067291512e+01, -1.107405056751550e+01},
	{"BTH", -1.506784816277909e+01, -2.564688057379471e+00},
	{"BTI", -1.780778967027691e+01, -5.304629564877292e+00},
	{"BTJ", -2.915655968330980e+01, -1.665339957791018e+01},
	{"BTK", -2.898977894427308e+01, -1.648661883887346e+01},
	{"BTL", -1.657536445672751e+01, -4.072204351327888e+00},
	{"BTM", -2.051363153442542e+01, -8.010471429025809e+00},
	{"BTN", -2.037665528820378e+01, -7.873495182804156e+00},
	{"BTO", -1.608426055333879e+01, -3.581100447939171e+00},
	{"BTP", -2.069491772795059e+01, -8.191757622550968e+00},
	{"BTQ", -2.370954876774673e+01, -1.120638866234711e+01},
	{"BTR", -1.807943085400091e+01, -5.576270748601294e+00},
	{"BTS", -1.649092784347787e+01, -3.987767738078254e+00},
	{"BTT", -1.649660190638339e+01, -3.993441800983769e+00},
	{"BTU", -1.996809724214683e+01, -7.464937136747215e+00},
	{"BTV", -2.911295386754844e+01, -1.660979376214882e+01},
	{"BTW", -1.797587625953333e+01, -5.472716154133714e+00},
	{"BTX", -3.383188716586549e+01, -2.132872706046587e+01},
	{"BTY", -2.103718727927585e+01, -8.534027173876234e+00},
	{"BTZ", -3.130512062282635e+01, -1.880196051742674e+01},
	{"BUA", -2.437969952153093e+01, -1.528619733589698e+01},
	{"BUB", -1.742450461157196e+01, -8.331002425938001e+00},
	{"BUC", -1.565893020215565e+01, -6.565428016521697e+00},
	{"BUD", -1.656390722878517e+01, -7.470405043151214e+00},
	{"BUE", -1.921911955703080e+01, -1.012561737139685e+01},
	{"BUF", -1.714651297312079e+01, -8.053010787486832e+00},
	{"BUG", -1.788906814537940e+01, -8.795565959745444e+00},
	{"BUH", -2.110971945855532e+01, -1.201621727292137e+01},
	{"BUI", -1.330983772352584e+01, -4.216335537891882e+00},
	{"BUJ", -3.131200941755073e+01, -2.221850723191677e+01},
	{"BUK", -1.692346079985186e+01, -7.829958614217902e+00},
	{"BUL", -1.377348397669487e+01, -4.679981791060909e+00},
	{"BUM", -1.909163987981831e+01, -9.998137694184354e+00},
	{"BUN", -1.440620768964220e+01, -5.312705504008245e+00},
	{"BUO", -2.070708885563933e+01, -1.161358667000537e+01},
	{"BUP", -1.906720540326948e+01, -9.973703217635528e+00},
	{"BUQ", -2.371603323511878e+01, -1.462253104948482e+01},
	{"BUR", -1.231635318262383e+01, -3.222850996989871e+00},
	{"BUS", -1.315922152992492e+01, -4.065719344290968e+00},
	{"BUT", -9.671176368603406e+00, -5.776741829694508e-01},
	{"BUU", -3.011678140191047e+01, -2.102327921627651e+01},
	{"BUV", -2.945907905204725e+01, -2.036557686641329e+01},
	{"BUW", -2.713917025970954e+01, -1.804566807407559e+01},
	{"BUX", -2.139241723357854e+01, -1.229891504794459e+01},
	{"BUY", -1.566881113542093e+01, -6.575308949786978e+00},
	{"BUZ", -1.871790477692518e+01, -9.624402591291222e+00},
	{"BVA", -2.329233174335699e+01, -6.806180934162519e+00},
	{"BVB", -3.426691288042011e+01, -1.778076207122564e+01},
	{"BVC", -3.445626920776031e+01, -1.797011839856584e+01},
	{"BVD", -3.371134134150434e+01, -1.722519053230988e+01},
	{"BVE", -1.904110643974416e+01, -2.554955630549693e+00},
	{"BVF", -3.391568858679187e+01, -1.742953777759741e+01},
	{"BVG", -3.522408097411336e+01, -1.873793016491889e+01},
	{"BVH", -3.293892194954181e+01, -1.645277114034734e+01},
	{"BVI", -1.680945916254911e+01, -3.233083533546435e-01},
	{"BVJ", -3.514693867475398e+01, -1.866078786555951e+01},
	{"BVK", -3.702653929753230e+01, -2.054038848833783e+01},
	{"BVL", -3.429878236921780e+01, -1.781263156002333e+01},
	{"BVM", -3.330924515084596e+01, -1.682309434165149e+01},
	{"BVN", -3.240765303631435e+01, -1.592150222711989e+01},
	{"BVO", -2.203687719214086e+01, -5.550726382946388e+00},
	{"BVP", -3.338189215592777e+01, -1.689574134673330e+01},
	{"BVQ", -4.097873407086778e+01, -2.449258326167332e+01},
	{"BVR", -3.133792770301855e+01, -1.485177689382409e+01},
	{"BVS", -3.237570389255390e+01, -1.588955308335943e+01},
	{"BVT", -3.169161279575179e+01, -1.520546198655733e+01},
	{"BVU", -3.127757767906713e+01, -1.479142686987267e+01},
	{"BVV", -3.587231123647866e+01, -1.938616042728420e+01},
	{"BVW", -3.301507086432103e+01, -1.652892005512655e+01},
	{"BVX", -3.760455488796444e+01, -2.111840407876997e+01},
	{"BVY", -2.942739732393501e+01, -1.294124651474054e+01},
	{"BVZ", -4.101443377052216e+01, -2.452828296132769e+01},
	{"BWA", -1.793333199954193e+01, -2.038618149291099e+00},
	{"BWB", -2.919045511409862e+01, -1.329574126384778e+01},
	{"BWC", -2.924834673302590e+01, -1.335363288277507e+01},
	{"BWD", -2.876183673314963e+01, -1.286712288289879e+01},
	{"BWE", -1.876704592702509e+01, -2.872332076774253e+00},
	{"BWF", -2.904342451928535e+01, -1.314871066903451e+01},
	{"BWG", -3.017016794927101e+01, -1.427545409902018e+01},
	{"BWH", -1.734309921676870e+01, -1.448385366517868e+00},
	{"BWI", -1.816334036227340e+01, -2.268626512022561e+00},
	{"BWJ", -3.152686241208842e+01, -1.563214856183759e+01},
	{"BWK", -3.168187487561444e+01, -1.578716102536360e+01},
	{"BWL", -2.811047733769963e+01, -1.221576348744880e+01},
	{"BWM", -2.881273937222340e+01, -1.291802552197257e+01},
	{"BWN", -2.568702933362016e+01, -9.792315483369331e+00},
	{"BWO", -2.045870830246241e+01, -4.563994452211572e+00},
	{"BWP", -2.990060303925331e+01, -1.400588918900248e+01},
	{"BWQ", -3.415422418596444e+01, -1.825951033571361e+01},
	{"BWR", -2.733589853747074e+01, -1.144118468721990e+01},
	{"BWS", -2.694720168239495e+01, -1.105248783214411e+01},
	{"BWT", -2.681722394753719e+01, -1.092251009728636e+01},
	{"BWU", -3.028383472101356e+01, -1.438912087076272e+01},
	{"BWV", -3.200439754860962e+01, -1.610968369835879e+01},
	{"BWW", -2.803641698769991e+01, -1.214170313744907e+01},
	{"BWX", -4.134803045208985e+01, -2.545331660183902e+01},
	{"BWY", -2.898691898975648e+01, -1.309220513950565e+01},
	{"BWZ", -3.487101410272901e+01, -1.897630025247818e+01},
	{"BXA", -2.933412568086754e+01, -3.475273661883234e+00},
	{"BXB", -3.390145028990199e+01, -8.042598270917683e+00},
	{"BXC", -2.886244994745214e+01, -3.003597928467834e+00},
	{"BXD", -3.329483844282193e+01, -7.435986423837630e+00},
	{"BXE", -2.894011922178236e+01, -3.081267202798049e+00},
	{"BXF", -3.343694790887744e+01, -7.578095889893132e+00},
	{"BXG", -3.473601244899320e+01, -8.877160430008891e+00},
	{"BXH", -3.109418627485651e+01, -5.235334255872204e+00},
	{"BXI", -2.893439735679125e+01, -3.075545337806950e+00},
	{"BXJ", -3.594898157501711e+01, -1.009012955603280e+01},
	{"BXK", -3.684706786546349e+01, -1.098821584647919e+01},
	{"BXL", -3.339430188228697e+01, -7.535449863302660e+00},
	{"BXM", -3.267748750028147e+01, -6.818635481297159e+00},
	{"BXN", -3.518650555683814e+01, -9.327653537853829e+00},
	{"BXO", -3.169185866335675e+01, -5.833006644372449e+00},
	{"BXP", -2.831024695403998e+01, -2.451394935055676e+00},
	{"BXQ", -3.484927722473025e+01, -8.990425205745950e+00},
	{"BXR", -3.346746462268352e+01, -7.608612603699212e+00},
	{"BXS", -3.275935007669460e+01, -6.900498057710297e+00},
	{"BXT", -2.810905731986293e+01, -2.250205300878624e+00},
	{"BXU", -3.197234741020341e+01, -6.113495391219105e+00},
	{"BXV", -3.159452066268150e+01, -5.735668643697198e+00},
	{"BXW", -3.278307977728164e+01, -6.924227758297334e+00},
	{"BXX", -3.238002301686096e+01, -6.521170997876658e+00},
	{"BXY", -3.256653570826681e+01, -6.707683689282498e+00},
	{"BXZ", -4.638629697762986e+01, -2.052744495864555e+01},
	{"BYA", -1.258150824591037e+01, -3.100783090316072e+00},
	{"BYB", -1.539695380492619e+01, -5.916228649331900e+00},
	{"BYC", -1.422316747118518e+01, -4.742442315590883e+00},
	{"BYD", -1.478304507137532e+01, -5.302319915781023e+00},
	{"BYE", -1.498366395623226e+01, -5.502938800637970e+00},
	{"BYF", -1.450968282319901e+01, -5.028957667604718e+00},
	{"BYG", -1.550254815300174e+01, -6.021822997407440e+00},
	{"BYH", -1.368131109285240e+01, -4.200585937258109e+00},
	{"BYI", -1.480716214423676e+01, -5.326436988642469e+00},
	{"BYJ", -1.616350150184080e+01, -6.682776346246505e+00},
	{"BYK", -1.760798393970915e+01, -8.127258784114858e+00},
	{"BYL", -1.411967325203051e+01, -4.638948096436211e+00},
	{"BYM", -1.386563481458447e+01, -4.384909658990177e+00},
	{"BYN", -1.513605613305425e+01, -5.655330977459953e+00},
	{"BYO", -1.501858474473783e+01, -5.537859589143539e+00},
	{"BYP", -1.440175746723649e+01, -4.921032311642191e+00},
	{"BYQ", -1.971652310660105e+01, -1.023579795100676e+01},
	{"BYR", -1.493208954428885e+01, -5.451364388694554e+00},
	{"BYS", -1.361356441562089e+01, -4.132839260026600e+00},
	{"BYT", -1.101865425565930e+01, -1.537929100065009e+00},
	{"BYU", -1.643102244098288e+01, -6.950297285388585e+00},
	{"BYV", -1.698928439379230e+01, -7.508559238198001e+00},
	{"BYW", -1.432782094387259e+01, -4.847095788278295e+00},
	{"BYX", -2.113240685672342e+01, -1.165168170112913e+01},
	{"BYY", -1.661877262429083e+01, -7.138047468696540e+00},
	{"BYZ", -2.113155663198522e+01, -1.165083147639093e+01},
	{"BZA", -2.162105077709383e+01, -1.254094882342128e+00},
	{"BZB", -2.988715905658377e+01, -9.520203161832068e+00},
	{"BZC", -3.077207387482535e+01, -1.040511798007364e+01},
	{"BZD", -3.113123971622818e+01, -1.076428382147648e+01},
	{"BZE", -2.142359063423004e+01, -1.056634739478335e+00},
	{"BZF", -3.071837128260277e+01, -1.035141538785107e+01},
	{"BZG", -3.124134045573000e+01, -1.087438456097829e+01},
	{"BZH", -2.985807758587988e+01, -9.491121691128173e+00},
	{"BZI", -2.508571510267454e+01, -4.718759207922837e+00},
	{"BZJ", -3.376506515788716e+01, -1.339810926313545e+01},
	{"BZK", -3.240056521827351e+01, -1.203360932352180e+01},
	{"BZL", -2.809080035491997e+01, -7.723844460168259e+00},
	{"BZM", -3.029905628460998e+01, -9.932100389858276e+00},
	{"BZN", -3.140188391322963e+01, -1.103492801847792e+01},
	{"BZO", -2.641338506577830e+01, -6.046429171026595e+00},
	{"BZP", -2.921744863345982e+01, -8.850492738708116e+00},
	{"BZQ", -3.768127904721050e+01, -1.731432315245879e+01},
	{"BZR", -2.843020528346220e+01, -8.063249388710489e+00},
	{"BZS", -3.004902802651809e+01, -9.682072131766386e+00},
	{"BZT", -2.854896030764143e+01, -8.182004412889725e+00},
	{"BZU", -2.795000940449800e+01, -7.583053509746292e+00},
	{"BZV", -3.084875985135480e+01, -1.048180395660309e+01},
	{"BZW", -2.951224702649067e+01, -9.145291131738960e+00},
	{"BZX", -4.048941560865534e+01, -2.012245971390364e+01},
	{"BZY", -2.892489485698102e+01, -8.557938962229308e+00},
	{"BZZ", -2.651977316213745e+01, -6.152817267385738e+00},
	{"CAA", -1.594335454424912e+01, -7.733326496523576e+00},
	{"CAB", -1.439098375476517e+01, -6.180955707039626e+00},
	{"CAC", -1.595054649864419e+01, -7.740518450918644e+00},
	{"CAD", -1.536086717557059e+01, -7.150839127845038e+00},
	{"CAE", -1.477887883760071e+01, -6.568850789875164e+00},
	{"CAF", -1.667104009091526e+01, -8.461012043189715e+00},
	{"CAG", -1.695635531436371e+01, -8.746327266638165e+00},
	{"CAH", -1.664005577185262e+01, -8.430027724127074e+00},
	{"CAI", -1.529224720816547e+01, -7.082219160439924e+00},
	{"CAJ", -2.039295472649799e+01, -1.218292667877244e+01},
	{"CAK", -1.737282258993848e+01, -9.162794542212932e+00},
	{"CAL", -1.079447557941534e+01, -2.584447531689795e+00},
	{"CAM", -1.129097831311432e+01, -3.080950265388773e+00},
	{"CAN", -1.054374869836917e+01, -2.333720650643621e+00},
	{"CAO", -1.832523874897229e+01, -1.011521070124674e+01},
	{"CAP", -1.214442398485625e+01, -3.934395937130702e+00},
	{"CAQ", -2.071355604256341e+01, -1.250352799483786e+01},
	{"CAR", -1.134985719421021e+01, -3.139829146484663e+00},
	{"CAS", -1.205111617677172e+01, -3.841088129046172e+00},
	{"CAT", -1.159032045873948e+01, -3.380292411013929e+00},
	{"CAU", -1.156323595051298e+01, -3.353207902787434e+00},
	{"CAV", -1.499893283880576e+01, -6.788904791080208e+00},
	{"CAW", -1.637629787130839e+01, -8.166269823582839e+00},
	{"CAX", -2.367326660553977e+01, -1.546323855781421e+01},
	{"CAY", -1.689015037100557e+01, -8.680122323280022e+00},
	{"CAZ", -2.865049885880788e+01, -2.044047081108233e+01},
	{"CBA", -1.840287673808914e+01, -2.929679502769831e+00},
	{"CBB", -2.734744911467419e+01, -1.187425187935488e+01},
	{"CBC", -2.211242948535720e+01, -6.639232250037891e+00},
	{"CBD", -2.935682967258336e+01, -1.388363243726405e+01},
	{"CBE", -1.727880773344481e+01, -1.805610498125503e+00},
	{"CBF", -3.094563458996584e+01, -1.547243735464653e+01},
	{"CBG", -3.251163883706467e+01, -1.703844160174537e+01},
	{"CBH", -2.978271387055246e+01, -1.430951663523315e+01},
	{"CBI", -2.032685097666222e+01, -4.853653741342913e+00},
	{"CBJ", -2.734263989876282e+01, -1.186944266344352e+01},
	{"CBK", -3.279797263425291e+01, -1.732477539893360e+01},
	{"CBL", -1.989080362746946e+01, -4.417606392150146e+00},
	{"CBM", -2.911651309549811e+01, -1.364331586017880e+01},
	{"CBN", -2.989556076965749e+01, -1.442236353433819e+01},
	{"CBO", -1.924413170334840e+01, -3.770934468029087e+00},
	{"CBP", -3.059915915720850e+01, -1.512596192188920e+01},
	{"CBQ", -3.666536370569999e+01, -2.119216647038068e+01},
	{"CBR", -1.920407525012784e+01, -3.730878014808535e+00},
	{"CBS", -2.592244026914272e+01, -1.044924303382341e+01},
	{"CBT", -2.659687963135590e+01, -1.112368239603659e+01},
	{"CBU", -1.748371613515373e+01, -2.010518899834417e+00},
	{"CBV", -3.057987033515074e+01, -1.510667309983144e+01},
	{"CBW", -2.998843337620711e+01, -1.451523614088780e+01},
	{"CBX", -3.995257154494058e+01, -2.447937430962127e+01},
	{"CBY", -1.890826377304332e+01, -3.435066537724015e+00},
	{"CBZ", -3.446067542070799e+01, -1.898747818538868e+01},
	{"CCA", -1.444491449076200e+01, -3.740952223882601e+00},
	{"CCB", -2.993803536361221e+01, -1.923407309673281e+01},
	{"CCC", -2.196778400477316e+01, -1.126382173789377e+01},
	{"CCD", -2.212078381733792e+01, -1.141682155045852e+01},
	{"CCE", -1.245750679918564e+01, -1.753544532306239e+00},
	{"CCF", -2.979684549735512e+01, -1.909288323047572e+01},
	{"CCG", -3.075239694878527e+01, -2.004843468190587e+01},
	{"CCH", -1.637347146873505e+01, -5.669509201855656e+00},
	{"CCI", -1.577682254156212e+01, -5.072860274682720e+00},
	{"CCJ", -3.268216773479362e+01, -2.197820546791422e+01},
	{"CCK", -2.443081527603333e+01, -1.372685300915393e+01},
	{"CCL", -1.709565266290834e+01, -6.391690396028944e+00},
	{"CCM", -2.171315875725268e+01, -1.100919649037329e+01},
	{"CCN", -3.056343238572643e+01, -1.985947011884704e+01},
	{"CCO", -1.218545266243538e+01, -1.481490395555986e+00},
	{"CCP", -2.898993517242992e+01, -1.828597290555053e+01},
	{"CCQ", -2.909808606495233e+01, -1.839412379807294e+01},
	{"CCR", -1.811565586081043e+01, -7.411693593931035e+00},
	{"CCS", -2.758326149866798e+01, -1.687929923178858e+01},
	{"CCT", -1.968203437455671e+01, -8.978072107677313e+00},
	{"CCU", -1.302837625081077e+01, -2.324413983931376e+00},
	{"CCV", -3.236605922023723e+01, -2.166209695335783e+01},
	{"CCW", -2.807432304957286e+01, -1.737036078269346e+01},
	{"CCX", -3.370941493690241e+01, -2.300545267002301e+01},
	{"CCY", -2.207334252881994e+01, -1.136938026194054e+01},
	{"CCZ", -3.232046478142784e+01, -2.161650251454844e+01},
	{"CDA", -1.916431319598039e+01, -4.717171610772929e+00},
	{"CDB", -2.453084572075877e+01, -1.008370413555131e+01},
	{"CDC", -2.567637154264031e+01, -1.122922995743285e+01},
	{"CDD", -2.546749089439311e+01, -1.102034930918565e+01},
	{"CDE", -1.712023368808133e+01, -2.673092102873869e+00},
	{"CDF", -2.518395269610081e+01, -1.073681111089335e+01},
	{"CDG", -2.591107759540934e+01, -1.146393601020188e+01},
	{"CDH", -2.453706050485872e+01, -1.008991891965126e+01},
	{"CDI", -1.765990138583470e+01, -3.212759800627246e+00},
	{"CDJ", -2.753897558599342e+01, -1.309183400078596e+01},
	{"CDK", -2.871582140636922e+01, -1.426867982116176e+01},
	{"CDL", -2.573964163767250e+01, -1.129250005246504e+01},
	{"CDM", -2.529348551798027e+01, -1.084634393277281e+01},
	{"CDN", -2.556257058053485e+01, -1.111542899532739e+01},
	{"CDO", -1.549416736545577e+01, -1.047025780248317e+00},
	{"CDP", -2.344002540582151e+01, -8.992883820614054e+00},
	{"CDQ", -3.015971293688275e+01, -1.571257135167529e+01},
	{"CDR", -1.699826980269515e+01, -2.551128217487691e+00},
	{"CDS", -2.382797385806607e+01, -9.380832272858608e+00},
	{"CDT", -2.289825495853581e+01, -8.451113373328353e+00},
	{"CDU", -2.020429723638355e+01, -5.757155651176097e+00},
	{"CDV", -2.724498273062972e+01, -1.279784114542226e+01},
	{"CDW", -2.124964049268155e+01, -6.802498907474097e+00},
	{"CDX", -3.505890323815694e+01, -2.061176165294949e+01},
	{"CDY", -2.257599894182712e+01, -8.128857356619660e+00},
	{"CDZ", -3.114134503847545e+01, -1.669420345326798e+01},
	{"CEA", -1.124047007740233e+01, -3.434498908512292e+00},
	{"CEB", -1.318305155559411e+01, -5.377080386704077e+00},
	{"CEC", -1.413733756279887e+01, -6.331366393908835e+00},
	{"CED", -1.159456224963217e+01, -3.788591080742136e+00},
	{"CEE", -1.322797032213937e+01, -5.421999153249334e+00},
	{"CEF", -1.311819282733116e+01, -5.312221658441128e+00},
	{"CEG", -1.555186334414614e+01, -7.745892175256102e+00},
	{"CEH", -1.338949890829220e+01, -5.583527739402169e+00},
	{"CEI", -1.134294284900048e+01, -3.536971680110442e+00},
	{"CEJ", -1.722611965740809e+01, -9.420148488518061e+00},
	{"CEK", -1.796041773820471e+01, -1.015444656931468e+01},
	{"CEL", -1.285289692828118e+01, -5.046925759391143e+00},
	{"CEM", -1.334153650448537e+01, -5.535565335595335e+00},
	{"CEN", -1.152294024864706e+01, -3.716969079757024e+00},
	{"CEO", -1.125581014857444e+01, -3.449838979684402e+00},
	{"CEP", -1.253531207610598e+01, -4.729340907215945e+00},
	{"CEQ", -1.858656359793498e+01, -1.078059242904494e+01},
	{"CER", -1.167453467561403e+01, -3.868563506723996e+00},
	{"CES", -1.034675381446981e+01, -2.540782645579772e+00},
	{"CET", -1.147775131632458e+01, -3.671780147434541e+00},
	{"CEU", -1.520229733560297e+01, -7.396326166712938e+00},
	{"CEV", -1.641976110056452e+01, -8.613789931674486e+00},
	{"CEW", -1.222501804012150e+01, -4.419046871231465e+00},
	{"CEX", -1.835356923453356e+01, -1.054759806564352e+01},
	{"CEY", -1.583341742821184e+01, -8.027446259321806e+00},
	{"CEZ", -2.369705551790608e+01, -1.589108434901604e+01},
	{"CFA", -1.872215290961180e+01, -3.390145540549576e+00},
	{"CFB", -2.694433414060036e+01, -1.161232677153814e+01},
	{"CFC", -2.635778178555908e+01, -1.102577441649686e+01},
	{"CFD", -2.724017918071460e+01, -1.190817181165238e+01},
	{"CFE", -1.789198734390787e+01, -2.559979974845655e+00},
	{"CFF", -2.190538347009491e+01, -6.573376101032690e+00},
	{"CFG", -2.689474870054798e+01, -1.156274133148576e+01},
	{"CFH", -2.569522626076347e+01, -1.036321889170124e+01},
	{"CFI", -1.802044620603173e+01, -2.688438836969510e+00},
	{"CFJ", -2.768304327449006e+01, -1.235103590542784e+01},
	{"CFK", -2.957922403943959e+01, -1.424721667037737e+01},
	{"CFL", -1.988054793428621e+01, -4.548540565223990e+00},
	{"CFM", -2.602641025151370e+01, -1.069440288245148e+01},
	{"CFN", -2.764796515908099e+01, -1.231595779001877e+01},
	{"CFO", -1.682764575804133e+01, -1.495638388979107e+00},
	{"CFP", -2.655844310602895e+01, -1.122643573696673e+01},
	{"CFQ", -3.182606960971217e+01, -1.649406224064995e+01},
	{"CFR", -1.868403216646498e+01, -3.352024797402762e+00},
	{"CFS", -2.588602992312699e+01, -1.055402255406477e+01},
	{"CFT", -2.223131697027381e+01, -6.899309601211585e+00},
	{"CFU", -1.937471585814876e+01, -4.042708489086543e+00},
	{"CFV", -2.886005190301662e+01, -1.352804453395439e+01},
	{"CFW", -2.661236682761528e+01, -1.128035945855306e+01},
	{"CFX", -3.413744111404568e+01, -1.880543374498345e+01},
	{"CFY", -2.725489917182164e+01, -1.192289180275942e+01},
	{"CFZ", -3.026603457357221e+01, -1.493402720450999e+01},
	{"CGA", -1.876287979420129e+01, -2.475320973708918e+00},
	{"CGB", -2.683175106413045e+01, -1.054419224363808e+01},
	{"CGC", -2.265358296911680e+01, -6.366024148624430e+00},
	{"CGD", -2.695388267759895e+01, -1.066632385710659e+01},
	{"CGE", -1.905247537181955e+01, -2.764916551327186e+00},
	{"CGF", -2.663746145284163e+01, -1.034990263234927e+01},
	{"CGG", -2.677895159287983e+01, -1.049139277238746e+01},
	{"CGH", -2.330141604464549e+01, -7.013857224153124e+00},
	{"CGI", -2.076580137143056e+01, -4.478242550938188e+00},
	{"CGJ", -3.030680220082334e+01, -1.401924338033098e+01},
	{"CGK", -3.054511613412059e+01, -1.425755731362822e+01},
	{"CGL", -2.084210639043879e+01, -4.554547569946419e+00},
	{"CGM", -2.658924646844381e+01, -1.030168764795144e+01},
	{"CGN", -2.570207822582715e+01, -9.414519405334778e+00},
	{"CGO", -1.896130827576201e+01, -2.673749455269648e+00},
	{"CGP", -2.707434203364647e+01, -1.078678321315410e+01},
	{"CGQ", -3.183819522873865e+01, -1.555063640824629e+01},
	{"CGR", -1.797185617633455e+01, -1.684297355842184e+00},
	{"CGS", -2.491501539529574e+01, -8.627456574803375e+00},
	{"CGT", -2.402772761077564e+01, -7.740168790283271e+00},
	{"CGU", -1.987294424104751e+01, -3.585385420555145e+00},
	{"CGV", -2.967863701065915e+01, -1.339107819016678e+01},
	{"CGW", -2.625978063863113e+01, -9.972221818138770e+00},
	{"CGX", -3.505701569518601e+01, -1.876945687469365e+01},
	{"CGY", -2.703094990267175e+01, -1.074339108217938e+01},
	{"CGZ", -3.364526920921823e+01, -1.735771038872587e+01},
	{"CHA", -1.006033979432434e+01, -2.197238439805187e+00},
	{"CHB", -1.412613513985205e+01, -6.263033785332897e+00},
	{"CHC", -1.341033088706010e+01, -5.547229532540945e+00},
	{"CHD", -1.424899209062833e+01, -6.385890736109173e+00},
	{"CHE", -1.085007999811265e+01, -2.986978643593489e+00},
	{"CHF", -1.397882974847959e+01, -6.115728393960433e+00},
	{"CHG", -1.493397908551827e+01, -7.070877730999114e+00},
	{"CHH", -1.223940395340418e+01, -4.376302598885020e+00},
	{"CHI", -1.026830571995948e+01, -2.405204365440323e+00},
	{"CHJ", -1.729228326166684e+01, -9.429181907147679e+00},
	{"CHK", -1.703213027670983e+01, -9.169028922190675e+00},
	{"CHL", -1.405510211462848e+01, -6.192000760109327e+00},
	{"CHM", -1.306044835800219e+01, -5.197347003483031e+00},
	{"CHN", -1.441254897981317e+01, -6.549447625294015e+00},
	{"CHO", -1.173577081324979e+01, -3.872669458730630e+00},
	{"CHP", -1.401994367338953e+01, -6.156842318870372e+00},
	{"CHQ", -2.013330204965340e+01, -1.227020069513425e+01},
	{"CHR", -1.292247073933662e+01, -5.059369384817463e+00},
	{"CHS", -1.283445455134689e+01, -4.971353196827736e+00},
	{"CHT", -1.169322201232534e+01, -3.830120657806185e+00},
	{"CHU", -1.347640457756688e+01, -5.613303223047721e+00},
	{"CHV", -1.693727227601035e+01, -9.074170921491195e+00},
	{"CHW", -1.220842615269547e+01, -4.345324798176315e+00},
	{"CHX", -3.531929564068324e+01, -2.745619428616408e+01},
	{"CHY", -1.456068631124042e+01, -6.697584956721267e+00},
	{"CHZ", -2.139622655329373e+01, -1.353312519877457e+01},
	{"CIA", -1.187734494618460e+01, -2.499402502382623e+00},
	{"CIB", -1.783070448991577e+01, -8.452762046113802e+00},
	{"CIC", -1.665998126715902e+01, -7.282038823357044e+00},
	{"CID", -1.393767310931571e+01, -4.559730665513741e+00},
	{"CIE", -1.237900609243474e+01, -3.001063648632770e+00},
	{"CIF", -1.476608914995396e+01, -5.388146706151989e+00},
	{"CIG", -1.789379658234605e+01, -8.515854138544070e+00},
	{"CIH", -2.168784624410767e+01, -1.230990380030570e+01},
	{"CII", -1.708878358638852e+01, -7.710841142586543e+00},
	{"CIJ", -3.081835038750193e+01, -2.144040794369996e+01},
	{"CIK", -2.676006060471646e+01, -1.738211816091449e+01},
	{"CIL", -1.377737295869451e+01, -4.399430514892535e+00},
	{"CIM", -1.668634568526698e+01, -7.308403241465010e+00},
	{"CIN", -1.311740708118765e+01, -3.739464637385673e+00},
	{"CIO", -1.397673124583564e+01, -4.598788802033668e+00},
	{"CIP", -1.292743783673849e+01, -3.549495392936522e+00},
	{"CIQ", -2.947787225799367e+01, -2.009992981419170e+01},
	{"CIR", -1.386708190713394e+01, -4.489139463331967e+00},
	{"CIS", -1.331493189656225e+01, -3.936989452760276e+00},
	{"CIT", -1.166932939343199e+01, -2.291386949630017e+00},
	{"CIU", -1.554834032096749e+01, -6.170397877165517e+00},
	{"CIV", -1.440912060847544e+01, -5.031178164673461e+00},
	{"CIW", -2.037966342117091e+01, -1.100172097736894e+01},
	{"CIX", -2.799100052054320e+01, -1.861305807674123e+01},
	{"CIY", -3.307464733857269e+01, -2.369670489477071e+01},
	{"CIZ", -1.990204984095085e+01, -1.052410739714888e+01},
	{"CJA", -2.173807817412093e+01, -3.486299684302118e+00},
	{"CJB", -2.958936927218890e+01, -1.133759078237008e+01},
	{"CJC", -3.043170960426653e+01, -1.217993111444772e+01},
	{"CJD", -3.233291650194887e+01, -1.408113801213006e+01},
	{"CJE", -2.122723946163456e+01, -2.975460971815750e+00},
	{"CJF", -3.144236387515507e+01, -1.319058538533626e+01},
	{"CJG", -3.104114329449244e+01, -1.278936480467362e+01},
	{"CJH", -3.022728630118453e+01, -1.197550781136572e+01},
	{"CJI", -2.629784527190375e+01, -8.046066782084933e+00},
	{"CJJ", -3.023307901748409e+01, -1.198130052766527e+01},
	{"CJK", -3.292165052535538e+01, -1.466987203553657e+01},
	{"CJL", -3.143048339459199e+01, -1.317870490477318e+01},
	{"CJM", -3.178640876831944e+01, -1.353463027850063e+01},
	{"CJN", -3.473647849697206e+01, -1.648470000715324e+01},
	{"CJO", -1.986382806649208e+01, -1.612049576673268e+00},
	{"CJP", -3.119826103113848e+01, -1.294648254131966e+01},
	{"CJQ", -3.409270059711314e+01, -1.584092210729433e+01},
	{"CJR", -3.040868750888480e+01, -1.215690901906598e+01},
	{"CJS", -3.084747632541340e+01, -1.259569783559459e+01},
	{"CJT", -3.094161364763245e+01, -1.268983515781363e+01},
	{"CJU", -1.940340603851514e+01, -1.151627548696329e+00},
	{"CJV", -3.780356599166521e+01, -1.955178750184639e+01},
	{"CJW", -3.017782203523618e+01, -1.192604354541737e+01},
	{"CJX", -4.048287139873403e+01, -2.223109290891522e+01},
	{"CJY", -3.695274214957865e+01, -1.870096365975983e+01},
	{"CJZ", -3.505774324303708e+01, -1.680596475321827e+01},
	{"CKA", -1.330992259118286e+01, -3.343945443442438e+00},
	{"CKB", -1.512522572931792e+01, -5.159248581577494e+00},
	{"CKC", -1.586564790906388e+01, -5.899670761323458e+00},
	{"CKD", -1.635121895636575e+01, -6.385241808625323e+00},
	{"CKE", -1.231973279475060e+01, -2.353755647010171e+00},
	{"CKF", -1.564022558775863e+01, -5.674248440018199e+00},
	{"CKG", -1.713284651460217e+01, -7.166869366861746e+00},
	{"CKH", -1.482882031250249e+01, -4.862843164762067e+00},
	{"CKI", -1.373291768207644e+01, -3.766940534336018e+00},
	{"CKJ", -1.954703976160340e+01, -9.581062613862976e+00},
	{"CKK", -2.025447615559827e+01, -1.028849900785784e+01},
	{"CKL", -1.421214267326830e+01, -4.246165525527873e+00},
	{"CKM", -1.626571150277021e+01, -6.299734355029780e+00},
	{"CKN", -1.502113579810435e+01, -5.055158650363927e+00},
	{"CKO", -1.347424029037868e+01, -3.508263142638249e+00},
	{"CKP", -1.659800659147771e+01, -6.632029443737287e+00},
	{"CKQ", -2.213210408472581e+01, -1.216612693698539e+01},
	{"CKR", -1.668394074427276e+01, -6.717963596532336e+00},
	{"CKS", -1.292200496052230e+01, -2.956027812781872e+00},
	{"CKT", -1.335781950650264e+01, -3.391842358762214e+00},
	{"CKU", -1.632371529160380e+01, -6.357738143863373e+00},
	{"CKV", -1.854788527024787e+01, -8.581908122507450e+00},
	{"CKW", -1.448638629679095e+01, -4.520409149050522e+00},
	{"CKX", -3.272329668048037e+01, -2.275731953273994e+01},
	{"CKY", -1.519010049151975e+01, -5.224123343779326e+00},
	{"CKZ", -2.171631155455936e+01, -1.175033440681893e+01},
	{"CLA", -1.206880792466478e+01, -2.025185630282408e+00},
	{"CLB", -2.133176906079393e+01, -1.128814676641157e+01},
	{"CLC", -1.839144150632373e+01, -8.347819211941360e+00},
	{"CLD", -2.374689524884563e+01, -1.370327295446326e+01},
	{"CLE", -1.171021466008300e+01, -1.666592365700635e+00},
	{"CLF", -2.558545622350166e+01, -1.554183392911929e+01},
	{"CLG", -2.727012262787014e+01, -1.722650033348777e+01},
	{"CLH", -2.670198585431291e+01, -1.665836355993054e+01},
	{"CLI", -1.364635095401267e+01, -3.602728659630302e+00},
	{"CLJ", -2.999684811245969e+01, -1.995322581807732e+01},
	{"CLK", -2.727444714846863e+01, -1.723082485408626e+01},
	{"CLL", -2.161945040742961e+01, -1.157582811304725e+01},
	{"CLM", -2.634920836113918e+01, -1.630558606675681e+01},
	{"CLN", -2.705793181616192e+01, -1.701430952177955e+01},
	{"CLO", -1.221229257155518e+01, -2.168670277172813e+00},
	{"CLP", -2.166112602475476e+01, -1.161750373037239e+01},
	{"CLQ", -3.109085449998821e+01, -2.104723220560584e+01},
	{"CLR", -2.686548908485808e+01, -1.682186679047572e+01},
	{"CLS", -2.463169761634747e+01, -1.458807532196510e+01},
	{"CLT", -2.411262879477695e+01, -1.406900650039458e+01},
	{"CLU", -1.302066781645854e+01, -2.977045522076168e+00},
	{"CLV", -2.663481504700582e+01, -1.659119275262345e+01},
	{"CLW", -2.633121428660514e+01, -1.628759199222277e+01},
	{"CLX", -3.428549341290979e+01, -2.424187111852743e+01},
	{"CLY", -1.832643141323714e+01, -8.282809118854775e+00},
	{"CLZ", -3.305431315723148e+01, -2.301069086284911e+01},
	{"CMA", -1.649236925213739e+01, -1.252220802218645e+00},
	{"CMB", -2.483152968083560e+01, -9.591381230916859e+00},
	{"CMC", -2.053796516868516e+01, -5.297816718766417e+00},
	{"CMD", -2.761824912547910e+01, -1.237810067556036e+01},
	{"CME", -1.751999306315536e+01, -2.279844613236618e+00},
	{"CMF", -2.357474699770900e+01, -8.334598547790256e+00},
	{"CMG", -2.861298347572314e+01, -1.337283502580440e+01},
	{"CMH", -2.353393016864251e+01, -8.293781718723761e+00},
	{"CMI", -1.787781505073001e+01, -2.637666600811267e+00},
	{"CMJ", -3.004124494212521e+01, -1.480109649220647e+01},
	{"CMK", -3.034968720623434e+01, -1.510953875631559e+01},
	{"CML", -2.786877272767594e+01, -1.262862427775720e+01},
	{"CMM", -2.489124017236917e+01, -9.651091722450429e+00},
	{"CMN", -2.682581180673602e+01, -1.158566335681727e+01},
	{"CMO", -1.827607280407848e+01, -3.035924354159732e+00},
	{"CMP", -2.402334326729422e+01, -8.783194817375476e+00},
	{"CMQ", -3.295800393665180e+01, -1.771785548673305e+01},
	{"CMR", -2.719662977839715e+01, -1.195648132847841e+01},
	{"CMS", -2.239977158478478e+01, -7.159623134866031e+00},
	{"CMT", -2.443814311071469e+01, -9.197994660795946e+00},
	{"CMU", -1.986923024964108e+01, -4.629081799722337e+00},
	{"CMV", -2.968800958707358e+01, -1.444786113715483e+01},
	{"CMW", -2.615391597041522e+01, -1.091376752049648e+01},
	{"CMX", -3.459769339360526e+01, -1.935754494368651e+01},
	{"CMY", -2.307258127814859e+01, -7.832432828229848e+00},
	{"CMZ", -3.322676751263214e+01, -1.798661906271339e+01},
	{"CNA", -1.912489616745888e+01, -3.018442681915061e+00},
	{"CNB", -2.601968745274882e+01, -9.913233967205006e+00},
	{"CNC", -2.146013015813134e+01, -5.353676672587528e+00},
	{"CND", -2.128397488875144e+01, -5.177521403207628e+00},
	{"CNE", -1.817638134480159e+01, -2.069927859257777e+00},
	{"CNF", -2.201788199987288e+01, -5.911428514329060e+00},
	{"CNG", -2.284214889276070e+01, -6.735695407216886e+00},
	{"CNH", -2.548884363201320e+01, -9.382390146469387e+00},
	{"CNI", -1.902221902065930e+01, -2.915765535115481e+00},
	{"CNJ", -2.818099953525620e+01, -1.207454604971238e+01},
	{"CNK", -2.683824422284063e+01, -1.073179073729681e+01},
	{"CNL", -2.624309508265137e+01, -1.013664159710755e+01},
	{"CNM", -2.204510388626268e+01, -5.938650400718863e+00},
	{"CNN", -2.204230458753017e+01, -5.935851101986354e+00},
	{"CNO", -1.814892546445375e+01, -2.042471978909940e+00},
	{"CNP", -1.989333486768776e+01, -3.786881382143948e+00},
	{"CNQ", -2.909181447444726e+01, -1.298536098890345e+01},
	{"CNR", -2.725045977398103e+01, -1.114400628843722e+01},
	{"CNS", -2.168749741994795e+01, -5.581043934404136e+00},
	{"CNT", -2.094571398332555e+01, -4.839260497781739e+00},
	{"CNU", -2.204600902250824e+01, -5.939555536964425e+00},
	{"CNV", -2.733633385052946e+01, -1.122988036498565e+01},
	{"CNW", -2.568850145879465e+01, -9.582047973250836e+00},
	{"CNX", -3.114838861662996e+01, -1.504193513108615e+01},
	{"CNY", -2.571363775741953e+01, -9.607184271875713e+00},
	{"CNZ", -3.165709366040956e+01, -1.555064017486574e+01},
	{"COA", -1.349428839591190e+01, -5.894759907097630e+00},
	{"COB", -1.479877725691584e+01, -7.199248768101572e+00},
	{"COC", -1.578564172301535e+01, -8.186113234201077e+00},
	{"COD", -1.570937284285751e+01, -8.109844354043243e+00},
	{"COE", -1.866618803457325e+01, -1.106665954575899e+01},
	{"COF", -1.545407920382694e+01, -7.854550715012676e+00},
	{"COG", -1.517491185057306e+01, -7.575383361758790e+00},
	{"COH", -1.683245371406631e+01, -9.232925225252039e+00},
	{"COI", -1.529940748877198e+01, -7.699878999957708e+00},
	{"COJ", -2.359628149115613e+01, -1.599675300234186e+01},
	{"COK", -2.201779307383986e+01, -1.441826458502559e+01},
	{"COL", -1.167510874574920e+01, -4.075580256934928e+00},
	{"COM", -9.474082362961962e+00, -1.874553874147692e+00},
	{"CON", -9.288338919095422e+00, -1.688810430281154e+00},
	{"COO", -1.427217684610586e+01, -6.672648357291589e+00},
	{"COP", -1.296587598110183e+01, -5.366347492287558e+00},
	{"COQ", -2.090959608391607e+01, -1.331006759510180e+01},
	{"COR", -1.145304398351732e+01, -3.853515494703053e+00},
	{"COS", -1.460006769716754e+01, -7.000539208353270e+00},
	{"COT", -1.429910995219262e+01, -6.699581463378355e+00},
	{"COU", -1.028638446490002e+01, -2.686855976085747e+00},
	{"COV", -1.262241432673625e+01, -5.022885837921985e+00},
	{"COW", -1.583529975526966e+01, -8.235771266455393e+00},
	{"COX", -2.039335940771014e+01, -1.279383091889587e+01},
	{"COY", -1.945757148653961e+01, -1.185804299772534e+01},
	{"COZ", -2.271130480964840e+01, -1.511177632083413e+01},
	{"CPA", -1.741221868146965e+01, -2.887121637332627e+00},
	{"CPB", -2.364983744682974e+01, -9.124740402692719e+00},
	{"CPC", -2.894432457545167e+01, -1.441922753131465e+01},
	{"CPD", -2.948371919368287e+01, -1.495862214954585e+01},
	{"CPE", -1.749340365421492e+01, -2.968306610077894e+00},
	{"CPF", -2.802587878922076e+01, -1.350078174508373e+01},
	{"CPG", -2.883256165869757e+01, -1.430746461456055e+01},
	{"CPH", -1.868883782751502e+01, -4.163740783378002e+00},
	{"CPI", -1.955058033294453e+01, -5.025483288807512e+00},
	{"CPJ", -3.165918056828739e+01, -1.713408352415038e+01},
	{"CPK", -3.154210117630630e+01, -1.701700413216928e+01},
	{"CPL", -1.757678969448473e+01, -3.051692650347712e+00},
	{"CPM", -2.265855544969717e+01, -8.133458405560152e+00},
	{"CPN", -2.937502440905372e+01, -1.484992736491670e+01},
	{"CPO", -1.639412965016171e+01, -1.869032606024686e+00},
	{"CPP", -2.386261003762411e+01, -9.337512993487096e+00},
	{"CPQ", -3.291545123394854e+01, -1.839035418981152e+01},
	{"CPR", -1.685309941758226e+01, -2.328002373445239e+00},
	{"CPS", -2.517739760815102e+01, -1.065230056401400e+01},
	{"CPT", -2.280039929624574e+01, -8.275302252108723e+00},
	{"CPU", -1.897861629154588e+01, -4.453519247408862e+00},
	{"CPV", -3.107341886919217e+01, -1.654832182505515e+01},
	{"CPW", -2.727517622879748e+01, -1.275007918466046e+01},
	{"CPX", -3.641662993935634e+01, -2.189153289521932e+01},
	{"CPY", -2.662674501736245e+01, -1.210164797322543e+01},
	{"CPZ", -3.472174556480743e+01, -2.019664852067042e+01},
	{"CQA", -2.874819829736225e+01, -1.411210909475885e+01},
	{"CQB", -3.137562024450453e+01, -1.673953104190112e+01},
	{"CQC", -3.028017357205718e+01, -1.564408436945377e+01},
	{"CQD", -3.189732410459445e+01, -1.726123490199105e+01},
	{"CQE", -3.228521864873871e+01, -1.764912944613529e+01},
	{"CQF", -3.064412304799531e+01, -1.600803384539191e+01},
	{"CQG", -3.736094702237681e+01, -2.272485781977341e+01},
	{"CQH", -3.119568170485444e+01, -1.655959250225103e+01},
	{"CQI", -2.708724231274649e+01, -1.245115311014309e+01},
	{"CQJ", -3.316099347999624e+01, -1.852490427739282e+01},
	{"CQK", -3.899313221731556e+01, -2.435704301471215e+01},
	{"CQL", -3.163806927829744e+01, -1.700198007569403e+01},
	{"CQM", -2.213239857836179e+01, -7.496309375758378e+00},
	{"CQN", -3.364499981312549e+01, -1.900891061052209e+01},
	{"CQO", -3.184144564385094e+01, -1.720535644124752e+01},
	{"CQP", -3.184363103027679e+01, -1.720754182767338e+01},
	{"CQQ", -3.372503397901389e+01, -1.908894477641048e+01},
	{"CQR", -3.169033448172865e+01, -1.705424527912524e+01},
	{"CQS", -2.876264663701740e+01, -1.412655743441399e+01},
	{"CQT", -2.926231764095171e+01, -1.462622843834830e+01},
	{"CQU", -1.464474723365472e+01, -8.658031051313827e-03},
	{"CQV", -3.455618765936717e+01, -1.992009845676376e+01},
	{"CQW", -3.091444048351344e+01, -1.627835128091003e+01},
	{"CQX", -4.101626417519849e+01, -2.638017497259508e+01},
	{"CQY", -3.520898437664527e+01, -2.057289517404186e+01},
	{"CQZ", -4.215583161194902e+01, -2.751974240934561e+01},
	{"CRA", -1.304635168769657e+01, -3.080492203037433e+00},
	{"CRB", -2.343144771085214e+01, -1.346558822619300e+01},
	{"CRC", -2.193492509422322e+01, -1.196906560956408e+01},
	{"CRD", -2.394069775367278e+01, -1.397483826901364e+01},
	{"CRE", -1.149906442299442e+01, -1.533204938335284e+00},
	{"CRF", -2.255010268318884e+01, -1.258424319852970e+01},
	{"CRG", -2.535347966519336e+01, -1.538762018053422e+01},
	{"CRH", -2.252725321790901e+01, -1.256139373324987e+01},
	{"CRI", -1.196512429772784e+01, -1.999264813068703e+00},
	{"CRJ", -2.882345011189413e+01, -1.885759062723499e+01},
	{"CRK", -2.254568228433005e+01, -1.257982279967092e+01},
	{"CRL", -2.555817057416683e+01, -1.559231108950770e+01},
	{"CRM", -2.456594560971955e+01, -1.460008612506041e+01},
	{"CRN", -2.237681872431684e+01, -1.241095923965770e+01},
	{"CRO", -1.236553797363925e+01, -2.399678488980107e+00},
	{"CRP", -2.341721070524611e+01, -1.345135122058698e+01},
	{"CRQ", -3.020998624213490e+01, -2.024412675747577e+01},
	{"CRR", -2.246432174427106e+01, -1.249846225961192e+01},
	{"CRS", -2.066403244892241e+01, -1.069817296426327e+01},
	{"CRT", -2.099571015794670e+01, -1.102985067328756e+01},
	{"CRU", -1.413307071027298e+01, -4.167211225613843e+00},
	{"CRV", -2.165298465579718e+01, -1.168712517113804e+01},
	{"CRW", -2.199995294069750e+01, -1.203409345603837e+01},
	{"CRX", -3.087511241489435e+01, -2.090925293023522e+01},
	{"CRY", -1.468625907310088e+01, -4.720399588441741e+00},
	{"CRZ", -3.180623494874061e+01, -2.184037546408147e+01},
	{"CSA", -1.612785969450406e+01, -3.009436324128982e+00},
	{"CSB", -1.910622935934954e+01, -5.987805988974464e+00},
	{"CSC", -1.738336250401714e+01, -4.264939133642064e+00},
	{"CSD", -1.969270461449865e+01, -6.574281244123573e+00},
	{"CSE", -1.672878146034208e+01, -3.610358089967005e+00},
	{"CSF", -1.893810786841504e+01, -5.819684498039960e+00},
	{"CSG", -2.087585141114099e+01, -7.757428040765908e+00},
	{"CSH", -1.767594511027493e+01, -4.557521739899857e+00},
	{"CSI", -1.657935581944221e+01, -3.460932449067128e+00},
	{"CSJ", -2.268861887216039e+01, -9.570195501785310e+00},
	{"CSK", -2.110116409227282e+01, -7.982740721897742e+00},
	{"CSL", -1.944171269102313e+01, -6.323289320648050e+00},
	{"CSM", -1.874311849676087e+01, -5.624695126385791e+00},
	{"CSN", -2.009419420735543e+01, -6.975770836980358e+00},
	{"CSO", -1.615294102563091e+01, -3.034517655255834e+00},
	{"CSP", -1.738132281598736e+01, -4.262899445612288e+00},
	{"CSQ", -2.211220977801579e+01, -8.993786407640709e+00},
	{"CSR", -2.022253644537611e+01, -7.104113075001036e+00},
	{"CSS", -1.817027621941401e+01, -5.051852849038933e+00},
	{"CST", -1.559700886110758e+01, -2.478585490732499e+00},
	{"CSU", -1.753045338288647e+01, -4.412030012511389e+00},
	{"CSV", -2.137490038422131e+01, -8.256477013846228e+00},
	{"CSW", -1.741652630803488e+01, -4.298102937659807e+00},
	{"CSX", -2.370307594209798e+01, -1.058465257172291e+01},
	{"CSY", -1.880377158258533e+01, -5.685348212210259e+00},
	{"CSZ", -3.174294354182868e+01, -1.862452017145361e+01},
	{"CTA", -1.314272717593517e+01, -4.388040433621272e+00},
	{"CTB", -1.623291828418941e+01, -7.478231541875507e+00},
	{"CTC", -1.605884027812676e+01, -7.304153535812861e+00},
	{"CTD", -1.705837167579665e+01, -8.303684933482748e+00},
	{"CTE", -1.179387055139514e+01, -3.039183809081239e+00},
	{"CTF", -1.571755077614591e+01, -6.962864033832012e+00},
	{"CTG", -1.274426227800431e+01, -3.989575535690414e+00},
	{"CTH", -1.416697883269554e+01, -5.412292090381645e+00},
	{"CTI", -1.042279735500966e+01, -1.668110612695759e+00},
	{"CTJ", -2.001553859150505e+01, -1.126085184919115e+01},
	{"CTK", -1.990850044846230e+01, -1.115381370614840e+01},
	{"CTL", -1.400909194276088e+01, -5.254405200446985e+00},
	{"CTM", -1.617776121025906e+01, -7.423074467945162e+00},
	{"CTN", -1.670587607027725e+01, -7.951189327963353e+00},
	{"CTO", -1.203232560160173e+01, -3.277638859287832e+00},
	{"CTP", -1.641369127670215e+01, -7.659004534388250e+00},
	{"CTQ", -2.054779867702158e+01, -1.179311193470768e+01},
	{"CTR", -1.271391038256285e+01, -3.959223640248953e+00},
	{"CTS", -1.258889461991210e+01, -3.834207877598206e+00},
	{"CTT", -1.320173004538378e+01, -4.447043303069885e+00},
	{"CTU", -1.281751750168567e+01, -4.062830759371771e+00},
	{"CTV", -1.807415551209730e+01, -9.319468769783404e+00},
	{"CTW", -1.478043151303334e+01, -6.025744770719445e+00},
	{"CTX", -2.271801528132129e+01, -1.396332853900739e+01},
	{"CTY", -1.670252321922286e+01, -7.947836476908967e+00},
	{"CTZ", -3.118549690436279e+01, -2.243081016204890e+01},
	{"CUA", -1.864834284807079e+01, -8.531857776195622e+00},
	{"CUB", -1.500989030699104e+01, -4.893405235115867e+00},
	{"CUC", -1.933971153191537e+01, -9.223226460040200e+00},
	{"CUD", -1.976610194440069e+01, -9.649616872525517e+00},
	{"CUE", -1.787101588505842e+01, -7.754530813183250e+00},
	{"CUF", -1.924938397490044e+01, -9.132898903025268e+00},
	{"CUG", -2.398060905548881e+01, -1.386412398361364e+01},
	{"CUH", -2.709467783393765e+01, -1.697819276206247e+01},
	{"CUI", -1.736872935508050e+01, -7.252244283205327e+00},
	{"CUJ", -3.136866156803993e+01, -2.125217649616475e+01},
	{"CUK", -2.758706993245832e+01, -1.747058486058315e+01},
	{"CUL", -1.222506604529172e+01, -2.108580973416545e+00},
	{"CUM", -1.365722363815884e+01, -3.540738566283672e+00},
	{"CUN", -1.654151656289458e+01, -6.425031491019405e+00},
	{"CUO", -1.691068054221170e+01, -6.794195470336525e+00},
	{"CUP", -1.412622827332687e+01, -4.009743201451699e+00},
	{"CUQ", -3.284402718165224e+01, -2.272754210977707e+01},
	{"CUR", -1.197702358463777e+01, -1.860538512762604e+00},
	{"CUS", -1.299170750996582e+01, -2.875222438090652e+00},
	{"CUT", -1.303948203804011e+01, -2.922996966164938e+00},
	{"CUU", -1.963041102697206e+01, -9.513925955096893e+00},
	{"CUV", -2.039433301101418e+01, -1.027784793913901e+01},
	{"CUW", -2.720958407277567e+01, -1.709309900090050e+01},
	{"CUX", -2.980035788321884e+01, -1.968387281134367e+01},
	{"CUY", -2.895597871418737e+01, -1.883949364231220e+01},
	{"CUZ", -1.954737595009363e+01, -9.430890878218463e+00},
	{"CVA", -2.126841238085758e+01, -3.367191288913256e+00},
	{"CVB", -3.369150593728847e+01, -1.579028484534414e+01},
	{"CVC", -3.388086226462868e+01, -1.597964117268435e+01},
	{"CVD", -3.313593439837270e+01, -1.523471330642838e+01},
	{"CVE", -2.002886660552847e+01, -2.127645513584151e+00},
	{"CVF", -3.334028164366024e+01, -1.543906055171592e+01},
	{"CVG", -3.464867403098172e+01, -1.674745293903740e+01},
	{"CVH", -3.236351500641018e+01, -1.446229391446585e+01},
	{"CVI", -1.892538106546946e+01, -1.024159973525137e+00},
	{"CVJ", -3.457153173162234e+01, -1.667031063967802e+01},
	{"CVK", -3.645113235440066e+01, -1.854991126245633e+01},
	{"CVL", -3.372337542608616e+01, -1.582215433414184e+01},
	{"CVM", -2.373122749464696e+01, -5.830006402702632e+00},
	{"CVN", -3.183224609318272e+01, -1.393102500123839e+01},
	{"CVO", -2.067544052718491e+01, -2.774219435240588e+00},
	{"CVP", -3.280648521279613e+01, -1.490526412085181e+01},
	{"CVQ", -4.040332712773615e+01, -2.250210603579182e+01},
	{"CVR", -3.076252075988692e+01, -1.286129966794260e+01},
	{"CVS", -3.180029694942226e+01, -1.389907585747794e+01},
	{"CVT", -2.372542059943502e+01, -5.824199507490696e+00},
	{"CVU", -3.070217073593550e+01, -1.280094964399117e+01},
	{"CVV", -3.529690429334703e+01, -1.739568320140270e+01},
	{"CVW", -3.243966392118939e+01, -1.453844282924506e+01},
	{"CVX", -3.702914794483280e+01, -1.912792685288848e+01},
	{"CVY", -2.885199038080338e+01, -1.095076928885905e+01},
	{"CVZ", -4.043902682739052e+01, -2.253780573544620e+01},
	{"CWA", -1.619345358982081e+01, -2.583968668540847e+00},
	{"CWB", -2.831239230100799e+01, -1.470290737972803e+01},
	{"CWC", -2.366300236449932e+01, -1.005351744321936e+01},
	{"CWD", -2.788542085325049e+01, -1.427593593197053e+01},
	{"CWE", -1.786546745379506e+01, -4.255982532515106e+00},
	{"CWF", -2.816552119967015e+01, -1.455603627839019e+01},
	{"CWG", -2.929375206937187e+01, -1.568426714809192e+01},
	{"CWH", -1.690986101825175e+01, -3.300376096971789e+00},
	{"CWI", -1.748986995236914e+01, -3.880385031089181e+00},
	{"CWJ", -3.064214796880016e+01, -1.703266304752020e+01},
	{"CWK", -3.080545899571529e+01, -1.719597407443534e+01},
	{"CWL", -2.723549125621678e+01, -1.362600633493682e+01},
	{"CWM", -2.793632349232427e+01, -1.432683857104431e+01},
	{"CWN", -2.481061345372103e+01, -1.120112853244107e+01},
	{"CWO", -1.436155663524256e+01, -7.520717139626070e-01},
	{"CWP", -2.902418715935417e+01, -1.541470223807422e+01},
	{"CWQ", -3.327780830606530e+01, -1.966832338478535e+01},
	{"CWR", -1.970587879537833e+01, -6.096393874098377e+00},
	{"CWS", -2.607078580249581e+01, -1.246130088121585e+01},
	{"CWT", -2.343899264840418e+01, -9.829507727124227e+00},
	{"CWU", -2.940741884111442e+01, -1.579793391983446e+01},
	{"CWV", -3.112798166871048e+01, -1.751849674743053e+01},
	{"CWW", -2.716000110780077e+01, -1.355051618652081e+01},
	{"CWX", -4.047161457219072e+01, -2.686212965091076e+01},
	{"CWY", -2.811050310985734e+01, -1.450101818857739e+01},
	{"CWZ", -3.399459822282987e+01, -2.038511330154991e+01},
	{"CXA", -2.624341242654976e+01, -6.998835617940247e+00},
	{"CXB", -3.081073703558421e+01, -1.156616022697470e+01},
	{"CXC", -2.577173669313436e+01, -6.527159884524847e+00},
	{"CXD", -3.020412518850415e+01, -1.095954837989464e+01},
	{"CXE", -2.584940596746457e+01, -6.604829158855063e+00},
	{"CXF", -3.034623465455966e+01, -1.110165784595014e+01},
	{"CXG", -3.164529919467542e+01, -1.240072238606590e+01},
	{"CXH", -2.800347302053873e+01, -8.758896211929216e+00},
	{"CXI", -2.584368410247347e+01, -6.599107293863963e+00},
	{"CXJ", -3.285826832069933e+01, -1.361369151208982e+01},
	{"CXK", -3.375635461114572e+01, -1.451177780253620e+01},
	{"CXL", -3.030358862796918e+01, -1.105901181935967e+01},
	{"CXM", -2.958677424596369e+01, -1.034219743735417e+01},
	{"CXN", -3.209579230252036e+01, -1.285121549391084e+01},
	{"CXO", -2.860114540903897e+01, -9.356568600429462e+00},
	{"CXP", -1.942006820705747e+01, -1.754913984479562e-01},
	{"CXQ", -3.175856397041248e+01, -1.251398716180296e+01},
	{"CXR", -3.037675136836573e+01, -1.113217455975622e+01},
	{"CXS", -2.966863682237683e+01, -1.042406001376731e+01},
	{"CXT", -2.501866855634106e+01, -5.774091747731545e+00},
	{"CXU", -2.888163415588563e+01, -9.637057347276118e+00},
	{"CXV", -2.371491480039081e+01, -4.470337991781296e+00},
	{"CXW", -2.969236652296386e+01, -1.044778971435435e+01},
	{"CXX", -2.928930976254319e+01, -1.004473295393367e+01},
	{"CXY", -2.947582245394902e+01, -1.023124564533951e+01},
	{"CXZ", -4.329558372331208e+01, -2.405100691470257e+01},
	{"CYA", -1.505540422508826e+01, -2.841692503233634e+00},
	{"CYB", -1.749042432215911e+01, -5.276712600304487e+00},
	{"CYC", -1.627687713883051e+01, -4.063165416975882e+00},
	{"CYD", -1.759571666891272e+01, -5.382004947058094e+00},
	{"CYE", -1.746853581500933e+01, -5.254824093154701e+00},
	{"CYF", -1.755161091285931e+01, -5.337899191004682e+00},
	{"CYG", -2.008622404859162e+01, -7.872512326736997e+00},
	{"CYH", -1.713435750253358e+01, -4.920645780678950e+00},
	{"CYI", -1.566053463232182e+01, -3.446822910467196e+00},
	{"CYJ", -2.111102742316333e+01, -8.897315701308704e+00},
	{"CYK", -2.356692542393910e+01, -1.135321370208448e+01},
	{"CYL", -1.736863393407872e+01, -5.154922212224091e+00},
	{"CYM", -1.743496640692076e+01, -5.221254685066132e+00},
	{"CYN", -1.815165687060964e+01, -5.937945148755015e+00},
	{"CYO", -1.486121926842818e+01, -2.647507546573558e+00},
	{"CYP", -1.745505004193037e+01, -5.241338320075752e+00},
	{"CYQ", -2.112791760099057e+01, -8.914205879135949e+00},
	{"CYR", -1.636460573568715e+01, -4.150894013832529e+00},
	{"CYS", -1.662616424726406e+01, -4.412452525409440e+00},
	{"CYT", -1.526046375761216e+01, -3.046752035757532e+00},
	{"CYU", -1.825108090526992e+01, -6.037369183415295e+00},
	{"CYV", -2.263525673587096e+01, -1.042154501401634e+01},
	{"CYW", -1.615379970502607e+01, -3.940087983171441e+00},
	{"CYX", -2.371027760376819e+01, -1.149656588191357e+01},
	{"CYY", -2.087251727935842e+01, -8.658805557503792e+00},
	{"CYZ", -2.212944395632510e+01, -9.915732234470482e+00},
	{"CZA", -1.838002567591056e+01, -5.243990227756182e-01},
	{"CZB", -2.906207565152534e+01, -1.120644899839040e+01},
	{"CZC", -2.994699046976692e+01, -1.209136381663198e+01},
	{"CZD", -3.030615631116975e+01, -1.245052965803481e+01},
	{"CZE", -2.025967427441536e+01, -2.404047621280422e+00},
	{"CZF", -2.989328787754434e+01, -1.203766122440941e+01},
	{"CZG", -3.041625705067156e+01, -1.256063039753662e+01},
	{"CZH", -2.903299418082145e+01, -1.117736752768651e+01},
	{"CZI", -2.122825007088407e+01, -3.372623417749135e+00},
	{"CZJ", -3.293998175282873e+01, -1.508435509969379e+01},
	{"CZK", -3.157548181321508e+01, -1.371985516008014e+01},
	{"CZL", -2.726571694986153e+01, -9.410090296726597e+00},
	{"CZM", -2.947397287955155e+01, -1.161834622641661e+01},
	{"CZN", -3.057680050817120e+01, -1.272117385503626e+01},
	{"CZO", -2.558805582082579e+01, -7.732429167690854e+00},
	{"CZP", -2.839236522840139e+01, -1.053673857526645e+01},
	{"CZQ", -3.685619564215207e+01, -1.900056898901713e+01},
	{"CZR", -2.760512187840376e+01, -9.749495225268827e+00},
	{"CZS", -2.922394462145966e+01, -1.136831796832472e+01},
	{"CZT", -2.772387690258300e+01, -9.868250249448064e+00},
	{"CZU", -2.712540159709481e+01, -9.269774943959876e+00},
	{"CZV", -3.002367644629637e+01, -1.216804979316143e+01},
	{"CZW", -2.868716362143223e+01, -1.083153696829730e+01},
	{"CZX", -3.966433220359691e+01, -2.180870555046198e+01},
	{"CZY", -2.809981145192259e+01, -1.024418479878765e+01},
	{"CZZ", -2.569468975707901e+01, -7.839063103944076e+00},
	{"DAA", -1.567931906239910e+01, -7.901367390038448e+00},
	{"DAB", -1.260138750550580e+01, -4.823435833145151e+00},
	{"DAC", -1.298743304096604e+01, -5.209481368605394e+00},
	{"DAD", -1.374706848056909e+01, -5.969116808208442e+00},
	{"DAE", -1.633409747113375e+01, -8.556145798773102e+00},
	{"DAF", -1.323869041292333e+01, -5.460738740562678e+00},
	{"DAG", -1.277365011103093e+01, -4.995698438670282e+00},
	{"DAH", -1.347539740409541e+01, -5.697445731734760e+00},
	{"DAI", -1.420880606607107e+01, -6.430854393710417e+00},
	{"DAJ", -1.850824245888737e+01, -1.073029078652672e+01},
	{"DAK", -1.717409881031168e+01, -9.396147137951033e+00},
	{"DAL", -1.138302148197734e+01, -3.605069809616685e+00},
	{"DAM", -1.236679895106164e+01, -4.588847278700989e+00},
	{"DAN", -9.495853163639723e+00, -1.717901491279071e+00},
	{"DAO", -1.867277615935950e+01, -1.089482448699885e+01},
	{"DAP", -1.356457878333700e+01, -5.786627110976353e+00},
	{"DAQ", -1.850816273926377e+01, -1.073021106690313e+01},
	{"DAR", -1.184356727324199e+01, -4.065615600881339e+00},
	{"DAS", -1.158201310318939e+01, -3.804061430828734e+00},
	{"DAT", -1.125154686100863e+01, -3.473595188647975e+00},
	{"DAU", -1.342266319881757e+01, -5.644711526456920e+00},
	{"DAV", -1.321530502409436e+01, -5.437353351733705e+00},
	{"DAW", -1.387282003106521e+01, -6.094868358704555e+00},
	{"DAX", -1.990800716669226e+01, -1.213005549433162e+01},
	{"DAY", -1.109681186974585e+01, -3.318860197385199e+00},
	{"DAZ", -1.721045736662947e+01, -9.432505694268819e+00},
	{"DBA", -1.366193747084459e+01, -4.491374914368050e+00},
	{"DBB", -2.357086121564271e+01, -1.440029865916617e+01},
	{"DBC", -1.890807412701056e+01, -9.737511570534023e+00},
	{"DBD", -2.893951005478996e+01, -1.976894749831342e+01},
	{"DBE", -1.049948002524428e+01, -1.328917468767738e+00},
	{"DBF", -2.370596972031874e+01, -1.453540716384220e+01},
	{"DBG", -3.212483806579847e+01, -2.295427550932193e+01},
	{"DBH", -2.369034856934876e+01, -1.451978601287222e+01},
	{"DBI", -1.576647616372727e+01, -6.595913607250735e+00},
	{"DBJ", -2.692532028096943e+01, -1.775475772449289e+01},
	{"DBK", -3.238065301645952e+01, -2.321009045998298e+01},
	{"DBL", -1.466727245104637e+01, -5.496709894569836e+00},
	{"DBM", -2.869704225479974e+01, -1.952647969832320e+01},
	{"DBN", -2.270555334215104e+01, -1.353499078567451e+01},
	{"DBO", -1.373059456091629e+01, -4.560032004439758e+00},
	{"DBP", -3.018384637110780e+01, -2.101328381463126e+01},
	{"DBQ", -3.624804408790659e+01, -2.707748153143005e+01},
	{"DBR", -1.329973020850997e+01, -4.129167652033427e+00},
	{"DBS", -2.550512065134932e+01, -1.633455809487278e+01},
	{"DBT", -2.259338759187791e+01, -1.342282503540138e+01},
	{"DBU", -1.244742016309924e+01, -3.276857606622702e+00},
	{"DBV", -3.016255071735735e+01, -2.099198816088081e+01},
	{"DBW", -2.957111375841372e+01, -2.040055120193718e+01},
	{"DBX", -3.953525192714719e+01, -3.036468937067065e+01},
	{"DBY", -1.081092371593221e+01, -1.640361159455673e+00},
	{"DBZ", -3.404335580291459e+01, -2.487279324643805e+01},
	{"DCA", -1.242023262921170e+01, -2.104264007937731e+00},
	{"DCB", -2.270496188932562e+01, -1.238899326805165e+01},
	{"DCC", -2.062694069464568e+01, -1.031097207337172e+01},
	{"DCD", -2.170472756697008e+01, -1.138875894569611e+01},
	{"DCE", -1.538380510324664e+01, -5.067836481972673e+00},
	{"DCF", -2.171117607297999e+01, -1.139520745170602e+01},
	{"DCG", -2.271092027512610e+01, -1.239495165385214e+01},
	{"DCH", -1.348071763938192e+01, -3.164749018107953e+00},
	{"DCI", -1.556241431485475e+01, -5.246445693580787e+00},
	{"DCJ", -2.271678641245197e+01, -1.240081779117800e+01},
	{"DCK", -2.390724626148084e+01, -1.359127764020687e+01},
	{"DCL", -1.455688006936231e+01, -4.240911448088344e+00},
	{"DCM", -2.139037711763732e+01, -1.107440849636335e+01},
	{"DCN", -2.212789232731028e+01, -1.181192370603631e+01},
	{"DCO", -1.153040527338150e+01, -1.214436652107528e+00},
	{"DCP", -1.962822483876793e+01, -9.312256217493966e+00},
	{"DCQ", -2.857735831634382e+01, -1.826138969506985e+01},
	{"DCR", -1.421129519938710e+01, -3.895326578113131e+00},
	{"DCS", -2.208716359436694e+01, -1.177119497309297e+01},
	{"DCT", -2.025522043404095e+01, -9.939251812766981e+00},
	{"DCU", -1.501566821735208e+01, -4.699699596078109e+00},
	{"DCV", -3.182359345879902e+01, -2.150762483752505e+01},
	{"DCW", -2.169372275278249e+01, -1.137775413150852e+01},
	{"DCX", -3.318584592234993e+01, -2.286987730107596e+01},
	{"DCY", -1.825336836939005e+01, -7.937399748116083e+00},
	{"DCZ", -3.177858317296064e+01, -2.146261455168667e+01},
	{"DDA", -1.369303196176553e+01, -3.585714756348453e+00},
	{"DDB", -2.114941632249108e+01, -1.104209911707401e+01},
	{"DDC", -2.064447542119879e+01, -1.053715821578172e+01},
	{"DDD", -2.081407414442018e+01, -1.070675693900310e+01},
	{"DDE", -1.177881430168623e+01, -1.671497096269155e+00},
	{"DDF", -2.234310903455816e+01, -1.223579182914109e+01},
	{"DDG", -2.197057158733592e+01, -1.186325438191885e+01},
	{"DDH", -1.793924007040608e+01, -7.831922864989011e+00},
	{"DDI", -1.224422331830486e+01, -2.136906112887789e+00},
	{"DDJ", -2.263723154741286e+01, -1.252991434199579e+01},
	{"DDK", -2.799981290791598e+01, -1.789249570249891e+01},
	{"DDL", -1.446754605731488e+01, -4.360228851897802e+00},
	{"DDM", -2.100697646044158e+01, -1.089965925502451e+01},
	{"DDN", -2.007984040826762e+01, -9.972523202850549e+00},
	{"DDO", -1.271052079607165e+01, -2.603203590654579e+00},
	{"DDP", -2.248620519125209e+01, -1.237888798583502e+01},
	{"DDQ", -2.944010198044332e+01, -1.933278477502625e+01},
	{"DDR", -1.358858063497184e+01, -3.481263429554763e+00},
	{"DDS", -1.777575002581206e+01, -7.668432820394989e+00},
	{"DDT", -1.726099576335607e+01, -7.153678557938994e+00},
	{"DDU", -1.496826165083396e+01, -4.860944445416886e+00},
	{"DDV", -2.352645010349337e+01, -1.341913289807630e+01},
	{"DDW", -1.669775324361322e+01, -6.590436038196144e+00},
	{"DDX", -3.434289473970370e+01, -2.423557753428663e+01},
	{"DDY", -1.720560700867945e+01, -7.098289803262373e+00},
	{"DDZ", -3.042533654002220e+01, -2.031801933460513e+01},
	{"DEA", -1.090357101888859e+01, -3.468584607956972e+00},
	{"DEB", -1.344795609934023e+01, -6.012969688408609e+00},
	{"DEC", -1.201958881964515e+01, -4.584602408713531e+00},
	{"DED", -1.074862787119905e+01, -3.313641460267435e+00},
	{"DEE", -1.277483986310849e+01, -5.339853452176871e+00},
	{"DEF", -1.231752112888586e+01, -4.882534717954242e+00},
	{"DEG", -1.421416476752299e+01, -6.779178356591372e+00},
	{"DEH", -1.427888941656704e+01, -6.843903005635423e+00},
	{"DEI", -1.351801639808668e+01, -6.083029987155065e+00},
	{"DEJ", -1.737804772876572e+01, -9.943061317834102e+00},
	{"DEK", -1.689694588828601e+01, -9.461959477354386e+00},
	{"DEL", -1.204760317525460e+01, -4.612616764322982e+00},
	{"DEM", -1.218690243524914e+01, -4.751916024317518e+00},
	{"DEN", -1.084909422046742e+01, -3.414107809535802e+00},
	{"DEO", -1.305630892190528e+01, -5.621322510973658e+00},
	{"DEP", -1.226103556792313e+01, -4.826049156991514e+00},
	{"DEQ", -1.621042345759383e+01, -8.775437046662210e+00},
	{"DER", -9.800799671407503e+00, -2.365813260475885e+00},
	{"DES", -1.063917240736564e+01, -3.204185996434020e+00},
	{"DET", -1.183852602973769e+01, -4.403539618806072e+00},
	{"DEU", -1.452600568681527e+01, -7.091019275883649e+00},
	{"DEV", -1.197500690605734e+01, -4.540020495125722e+00},
	{"DEW", -1.397767210104609e+01, -6.542685690114469e+00},
	{"DEX", -1.361783159849107e+01, -6.182845187559454e+00},
	{"DEY", -1.566652105939761e+01, -8.231534648465994e+00},
	{"DEZ", -1.774115304901568e+01, -1.030616663808406e+01},
	{"DFA", -1.337206182091940e+01, -3.548323717564990e+00},
	{"DFB", -2.656463784586753e+01, -1.674089974251312e+01},
	{"DFC", -2.597850999519230e+01, -1.615477189183789e+01},
	{"DFD", -2.685988114107148e+01, -1.703614303771707e+01},
	{"DFE", -1.394396867145951e+01, -4.120230568105103e+00},
	{"DFF", -2.060230496397146e+01, -1.077856686061705e+01},
	{"DFG", -2.651505240581515e+01, -1.669131430246074e+01},
	{"DFH", -2.531552996603063e+01, -1.549179186267623e+01},
	{"DFI", -1.300351315711476e+01, -3.179775053760349e+00},
	{"DFJ", -2.730252908906479e+01, -1.747879098571038e+01},
	{"DFK", -2.919952774470676e+01, -1.937578964135236e+01},
	{"DFL", -1.479875587162954e+01, -4.975017768275128e+00},
	{"DFM", -2.564671395678087e+01, -1.582297585342646e+01},
	{"DFN", -2.726826886434816e+01, -1.744453076099375e+01},
	{"DFO", -1.104192675673225e+01, -1.218188653377843e+00},
	{"DFP", -2.617874681129613e+01, -1.635500870794172e+01},
	{"DFQ", -3.144637331497934e+01, -2.162263521162494e+01},
	{"DFR", -1.186473097458109e+01, -2.040992871226677e+00},
	{"DFS", -2.335177971754672e+01, -1.352804161419231e+01},
	{"DFT", -2.197542281081948e+01, -1.215168470746507e+01},
	{"DFU", -1.443245599823177e+01, -4.608717894877365e+00},
	{"DFV", -2.848035560828379e+01, -1.865661750492938e+01},
	{"DFW", -2.348601056291899e+01, -1.366227245956458e+01},
	{"DFX", -3.375774481931285e+01, -2.393400671595844e+01},
	{"DFY", -2.687520287708882e+01, -1.705146477373441e+01},
	{"DFZ", -2.988633827883938e+01, -2.006260017548497e+01},
	{"DGA", -1.418015229824467e+01, -3.629477624201675e+00},
	{"DGB", -2.347347728687581e+01, -1.292280261283281e+01},
	{"DGC", -2.350996442286397e+01, -1.295928974882097e+01},
	{"DGD", -2.627210006247506e+01, -1.572142538843207e+01},
	{"DGE", -1.203048503758496e+01, -1.479810363541963e+00},
	{"DGF", -2.595607917988017e+01, -1.540540450583717e+01},
	{"DGG", -2.609756931991837e+01, -1.554689464587537e+01},
	{"DGH", -2.088257365800164e+01, -1.033189898395864e+01},
	{"DGI", -1.403024379540337e+01, -3.479569121360367e+00},
	{"DGJ", -2.962541992786189e+01, -1.907474525381889e+01},
	{"DGK", -2.986373386115913e+01, -1.931305918711612e+01},
	{"DGL", -1.566045718155206e+01, -5.109782507509060e+00},
	{"DGM", -1.452357989474611e+01, -3.972905220703112e+00},
	{"DGN", -1.968275480494168e+01, -9.132080130898681e+00},
	{"DGO", -1.266781749166801e+01, -2.117142817625006e+00},
	{"DGP", -2.639365635238414e+01, -1.584298167834114e+01},
	{"DGQ", -3.115681295577719e+01, -2.060613828173419e+01},
	{"DGR", -1.350902429525015e+01, -2.958349621207151e+00},
	{"DGS", -2.423363312233428e+01, -1.368295844829128e+01},
	{"DGT", -2.334629266054974e+01, -1.279561798650673e+01},
	{"DGU", -1.654235565641408e+01, -5.991680982371079e+00},
	{"DGV", -2.899725473769769e+01, -1.844658006365469e+01},
	{"DGW", -2.336768382845446e+01, -1.281700915441145e+01},
	{"DGX", -3.437563342222455e+01, -2.382495874818155e+01},
	{"DGY", -2.260688496549842e+01, -1.205621029145543e+01},
	{"DGZ", -3.296388693625678e+01, -2.241321226221378e+01},
	{"DHA", -1.146944662775917e+01, -2.292668770163584e+00},
	{"DHB", -2.752065199537815e+01, -1.834387413778256e+01},
	{"DHC", -2.266695443042758e+01, -1.349017657283200e+01},
	{"DHD", -2.797208113527734e+01, -1.879530327768176e+01},
	{"DHE", -1.059044231002761e+01, -1.413664452432024e+00},
	{"DHF", -2.750731321448694e+01, -1.833053535689136e+01},
	{"DHG", -2.849092024082905e+01, -1.931414238323347e+01},
	{"DHH", -2.351343969871665e+01, -1.433666184112107e+01},
	{"DHI", -1.084663947391646e+01, -1.669861616320874e+00},
	{"DHJ", -3.040232314148431e+01, -2.122554528388873e+01},
	{"DHK", -3.073295365867642e+01, -2.155617580108083e+01},
	{"DHL", -2.803036994330648e+01, -1.885359208571089e+01},
	{"DHM", -1.990109651739386e+01, -1.072431865979828e+01},
	{"DHN", -2.794365334213770e+01, -1.876687548454212e+01},
	{"DHO", -1.276795787290637e+01, -3.591180015310787e+00},
	{"DHP", -2.787527168851750e+01, -1.869849383092192e+01},
	{"DHQ", -3.216534816184799e+01, -2.298857030425241e+01},
	{"DHR", -2.202672446836229e+01, -1.284994661076671e+01},
	{"DHS", -2.261615774351085e+01, -1.343937988591526e+01},
	{"DHT", -2.285247204923898e+01, -1.367569419164339e+01},
	{"DHU", -1.483545200828886e+01, -5.658674150693279e+00},
	{"DHV", -3.064808485908821e+01, -2.147130700149263e+01},
	{"DHW", -2.661829645036855e+01, -1.744151859277296e+01},
	{"DHX", -3.582428479624780e+01, -2.664750693865221e+01},
	{"DHY", -1.785589014194142e+01, -8.679112284345832e+00},
	{"DHZ", -3.317316743666485e+01, -2.399638957906928e+01},
	{"DIA", -1.215429279212363e+01, -4.525377405563710e+00},
	{"DIB", -1.567297309001545e+01, -8.044057703455529e+00},
	{"DIC", -1.274828893847068e+01, -5.119373551910765e+00},
	{"DID", -1.152343129173206e+01, -3.894515905172143e+00},
	{"DIE", -1.199813242120535e+01, -4.369217034645433e+00},
	{"DIF", -1.203292809951001e+01, -4.404012712950091e+00},
	{"DIG", -1.390692312681243e+01, -6.278007740252510e+00},
	{"DIH", -1.483279162964596e+01, -7.203876243086039e+00},
	{"DII", -1.750835754265438e+01, -9.879442156094463e+00},
	{"DIJ", -1.913331705507375e+01, -1.150440166851383e+01},
	{"DIK", -1.660877590372527e+01, -8.979860517165354e+00},
	{"DIL", -1.377707753972100e+01, -6.148162153161082e+00},
	{"DIM", -1.366206198627834e+01, -6.033146599718416e+00},
	{"DIN", -9.263822050371026e+00, -1.634906663811107e+00},
	{"DIO", -1.507645927960637e+01, -7.447543893046455e+00},
	{"DIP", -1.530415672349234e+01, -7.675241336932420e+00},
	{"DIQ", -2.368759019289863e+01, -1.605867480633871e+01},
	{"DIR", -1.288976517124002e+01, -5.260849784680100e+00},
	{"DIS", -1.012362723173601e+01, -2.494711845176096e+00},
	{"DIT", -1.069205258142917e+01, -3.063137194869251e+00},
	{"DIU", -1.490784901714284e+01, -7.278933630582921e+00},
	{"DIV", -1.298690528207017e+01, -5.357989895510248e+00},
	{"DIW", -1.324698130763375e+01, -5.618065921073827e+00},
	{"DIX", -1.793583591529529e+01, -1.030692052873537e+01},
	{"DIY", -2.001815518785073e+01, -1.238923980129082e+01},
	{"DIZ", -1.793461826116720e+01, -1.030570287460728e+01},
	{"DJA", -1.517125227742435e+01, -2.992679612797273e+00},
	{"DJB", -2.071526219223587e+01, -8.536689527608791e+00},
	{"DJC", -3.009238431152619e+01, -1.791381164689911e+01},
	{"DJD", -3.198654189378962e+01, -1.980796922916255e+01},
	{"DJE", -1.428789253867745e+01, -2.109319874050379e+00},
	{"DJF", -3.111022779019391e+01, -1.893165512556684e+01},
	{"DJG", -3.069476868633318e+01, -1.851619602170611e+01},
	{"DJH", -2.988091169302529e+01, -1.770233902839821e+01},
	{"DJI", -1.711611055151189e+01, -4.937537886884820e+00},
	{"DJJ", -2.988670440932484e+01, -1.770813174469777e+01},
	{"DJK", -3.257527591719614e+01, -2.039670325256906e+01},
	{"DJL", -2.171698168517222e+01, -9.538409020545146e+00},
	{"DJM", -3.144003416016020e+01, -1.926146149553312e+01},
	{"DJN", -3.439010388881281e+01, -2.221153122418574e+01},
	{"DJO", -1.409502707459779e+01, -1.916454409970721e+00},
	{"DJP", -3.085188642297923e+01, -1.867331375835215e+01},
	{"DJQ", -3.383813816390511e+01, -2.165956549927803e+01},
	{"DJR", -3.005678686133774e+01, -1.787821419671067e+01},
	{"DJS", -3.050110171725416e+01, -1.832252905262708e+01},
	{"DJT", -3.058725045576788e+01, -1.840867779114080e+01},
	{"DJU", -1.373360057023660e+01, -1.555027905609525e+00},
	{"DJV", -3.745719138350596e+01, -2.527861871887888e+01},
	{"DJW", -2.270876145960300e+01, -1.053018879497593e+01},
	{"DJX", -4.013649679057479e+01, -2.795792412594771e+01},
	{"DJY", -3.660636754141940e+01, -2.442779487679232e+01},
	{"DJZ", -3.471136863487783e+01, -2.253279597025076e+01},
	{"DKA", -1.908752280379189e+01, -5.732104318789007e+00},
	{"DKB", -2.636105594405716e+01, -1.300563745905428e+01},
	{"DKC", -2.679235538666091e+01, -1.343693690165803e+01},
	{"DKD", -2.742524744992253e+01, -1.406982896491965e+01},
	{"DKE", -1.502474935864867e+01, -1.669330873645790e+00},
	{"DKF", -2.625746428217930e+01, -1.290204579717641e+01},
	{"DKG", -2.853006505949645e+01, -1.517464657449356e+01},
	{"DKH", -2.343687645425184e+01, -1.008145796924895e+01},
	{"DKI", -1.483220311048607e+01, -1.476784625483186e+00},
	{"DKJ", -3.010823954089688e+01, -1.675282105589400e+01},
	{"DKK", -2.943637834275694e+01, -1.608095985775405e+01},
	{"DKL", -2.256027274334754e+01, -9.204854258344655e+00},
	{"DKM", -2.679296683542132e+01, -1.343754835041844e+01},
	{"DKN", -1.520341259338878e+01, -1.847994108385898e+00},
	{"DKO", -1.975458297436335e+01, -6.399164489360465e+00},
	{"DKP", -2.714390648088750e+01, -1.378848799588462e+01},
	{"DKQ", -3.278737933546996e+01, -1.943196085046708e+01},
	{"DKR", -2.089806365918538e+01, -7.542645174182494e+00},
	{"DKS", -2.369781705860474e+01, -1.034239857360186e+01},
	{"DKT", -2.446270456578392e+01, -1.110728608078104e+01},
	{"DKU", -2.037387390960363e+01, -7.018455424600753e+00},
	{"DKV", -2.994839460674158e+01, -1.659297612173870e+01},
	{"DKW", -2.563421282973382e+01, -1.227879434473094e+01},
	{"DKX", -3.375942620136323e+01, -2.040400771636034e+01},
	{"DKY", -2.630402485713941e+01, -1.294860637213653e+01},
	{"DKZ", -3.186128908723296e+01, -1.850587060223008e+01},
	{"DLA", -1.328234254534312e+01, -2.903103829036960e+00},
	{"DLB", -2.132753484720970e+01, -1.094829613090355e+01},
	{"DLC", -2.069004279589765e+01, -1.031080407959150e+01},
	{"DLD", -2.365372353930822e+01, -1.327448482300207e+01},
	{"DLE", -1.192779666165406e+01, -1.548557945347903e+00},
	{"DLF", -2.549211655961323e+01, -1.511287784330707e+01},
	{"DLG", -2.717701610983175e+01, -1.679777739352560e+01},
	{"DLH", -2.660837386601410e+01, -1.622913514970795e+01},
	{"DLI", -1.282031642858756e+01, -2.441077712281405e+00},
	{"DLJ", -2.990904372711999e+01, -1.952980501081383e+01},
	{"DLK", -2.718134063043025e+01, -1.680210191412409e+01},
	{"DLL", -1.831154173692238e+01, -7.932303020616222e+00},
	{"DLM", -2.205327522067809e+01, -1.167403650437194e+01},
	{"DLN", -2.696551562491273e+01, -1.658627690860658e+01},
	{"DLO", -1.309995446518026e+01, -2.720715748874102e+00},
	{"DLP", -2.259843070959549e+01, -1.221919199328933e+01},
	{"DLQ", -3.099774798194983e+01, -2.061850926564367e+01},
	{"DLR", -2.677238256681970e+01, -1.639314385051355e+01},
	{"DLS", -2.062010031601257e+01, -1.024086159970641e+01},
	{"DLT", -2.095075335676214e+01, -1.057151464045599e+01},
	{"DLU", -1.645791388890847e+01, -6.078675172602314e+00},
	{"DLV", -2.654170852896744e+01, -1.616246981266129e+01},
	{"DLW", -2.623852487782699e+01, -1.585928616152083e+01},
	{"DLX", -3.429971616607732e+01, -2.392047744977117e+01},
	{"DLY", -1.296804606561464e+01, -2.588807349308482e+00},
	{"DLZ", -3.296120663919309e+01, -2.258196792288694e+01},
	{"DMA", -1.170764278943110e+01, -1.774560192817169e+00},
	{"DMB", -2.405289634616436e+01, -1.411981374955043e+01},
	{"DMC", -2.024255730291792e+01, -1.030947470630399e+01},
	{"DMD", -1.783338886929124e+01, -7.900306272677307e+00},
	{"DME", -1.204994639426638e+01, -2.116863797652453e+00},
	{"DMF", -2.618151342702544e+01, -1.624843083041150e+01},
	{"DMG", -2.138034845604234e+01, -1.144726585942841e+01},
	{"DMH", -2.255801237923316e+01, -1.262492978261924e+01},
	{"DMI", -1.266740081143916e+01, -2.734318214825228e+00},
	{"DMJ", -2.925937246263913e+01, -1.932628986602520e+01},
	{"DMK", -2.369401345176993e+01, -1.376093085515600e+01},
	{"DML", -2.053350030463530e+01, -1.060041770802137e+01},
	{"DMM", -1.914830453597065e+01, -9.215221939356718e+00},
	{"DMN", -1.999647518494741e+01, -1.006339258833348e+01},
	{"DMO", -1.265435571440112e+01, -2.721273117787190e+00},
	{"DMP", -2.104320890512245e+01, -1.111012630850852e+01},
	{"DMQ", -3.217930919786424e+01, -2.224622660125031e+01},
	{"DMR", -1.608110122621708e+01, -6.148018629603154e+00},
	{"DMS", -2.074580867817562e+01, -1.081272608156169e+01},
	{"DMT", -2.054218772566655e+01, -1.060910512905263e+01},
	{"DMU", -1.453215295184196e+01, -4.599070355228030e+00},
	{"DMV", -2.212078551383908e+01, -1.218770291722515e+01},
	{"DMW", -2.332127788050630e+01, -1.338819528389237e+01},
	{"DMX", -2.371745962734957e+01, -1.378437703073563e+01},
	{"DMY", -1.313109146508573e+01, -3.198008868471805e+00},
	{"DMZ", -3.241941685082847e+01, -2.248633425421453e+01},
	{"DNA", -1.458092873051305e+01, -4.378761071344544e+00},
	{"DNB", -2.339702400413060e+01, -1.319485634496209e+01},
	{"DNC", -2.215811494514244e+01, -1.195594728597393e+01},
	{"DND", -2.051938101778185e+01, -1.031721335861335e+01},
	{"DNE", -1.243924483705114e+01, -2.237077177882639e+00},
	{"DNF", -2.251947855599874e+01, -1.231731089683023e+01},
	{"DNG", -2.132359812447394e+01, -1.112143046530544e+01},
	{"DNH", -2.196984831386338e+01, -1.176768065469488e+01},
	{"DNI", -1.517942211588382e+01, -4.977254456715314e+00},
	{"DNJ", -2.788109066081410e+01, -1.767892300164560e+01},
	{"DNK", -2.135648506547919e+01, -1.115431740631069e+01},
	{"DNL", -2.343899887573183e+01, -1.323683121656333e+01},
	{"DNM", -2.164100881983109e+01, -1.143884116066259e+01},
	{"DNN", -2.342121509271815e+01, -1.321904743354964e+01},
	{"DNO", -1.099450344603504e+01, -7.923357868665336e-01},
	{"DNP", -2.638421806032455e+01, -1.618205040115605e+01},
	{"DNQ", -2.879190560000517e+01, -1.858973794083666e+01},
	{"DNR", -2.694991034956934e+01, -1.674774269040084e+01},
	{"DNS", -2.250079278665527e+01, -1.229862512748677e+01},
	{"DNT", -1.335955803397164e+01, -3.157390374803132e+00},
	{"DNU", -1.649744270645005e+01, -6.295275047281547e+00},
	{"DNV", -2.703574515007872e+01, -1.683357749091021e+01},
	{"DNW", -2.160959282733173e+01, -1.140742516816323e+01},
	{"DNX", -3.084847974218787e+01, -2.064631208301936e+01},
	{"DNY", -1.905715981750201e+01, -8.854992158333507e+00},
	{"DNZ", -3.135718478596746e+01, -2.115501712679896e+01},
	{"DOA", -1.479868071980786e+01, -6.565123985233856e+00},
	{"DOB", -1.503794701964217e+01, -6.804390285068173e+00},
	{"DOC", -1.369169984224289e+01, -5.458143107668882e+00},
	{"DOD", -1.643637479477296e+01, -8.202818060198961e+00},
	{"DOE", -1.358283773960307e+01, -5.349281005029067e+00},
	{"DOF", -1.029035537454802e+01, -2.056798639974021e+00},
	{"DOG", -1.512550995651578e+01, -6.891953221941785e+00},
	{"DOH", -1.586514977796690e+01, -7.631593043392895e+00},
	{"DOI", -1.378899194121606e+01, -5.555435206642059e+00},
	{"DOJ", -1.890687426566863e+01, -1.067331753109463e+01},
	{"DOK", -1.737447021407291e+01, -9.140913479498911e+00},
	{"DOL", -1.432878156130495e+01, -6.095224826730947e+00},
	{"DOM", -1.230586011411842e+01, -4.072303379544422e+00},
	{"DON", -1.044527898103570e+01, -2.211722246461701e+00},
	{"DOO", -1.346638984621648e+01, -5.232833111642476e+00},
	{"DOP", -1.427451390759712e+01, -6.040957173023118e+00},
	{"DOQ", -2.271234881099015e+01, -1.447879207641615e+01},
	{"DOR", -1.266862684968571e+01, -4.435070115111712e+00},
	{"DOS", -1.490527290111615e+01, -6.671716166542149e+00},
	{"DOT", -1.297743211212287e+01, -4.743875377548869e+00},
	{"DOU", -1.191184240462081e+01, -3.678285670046813e+00},
	{"DOV", -1.382929889304094e+01, -5.595742158466933e+00},
	{"DOW", -1.136670671426566e+01, -3.133149979691663e+00},
	{"DOX", -1.765217549885029e+01, -9.418618764276287e+00},
	{"DOY", -1.476990772466370e+01, -6.536350990089700e+00},
	{"DOZ", -1.704621600876322e+01, -8.812659274189215e+00},
	{"DPA", -1.331828848350102e+01, -2.728689956734351e+00},
	{"DPB", -2.267524419573915e+01, -1.208564566897248e+01},
	{"DPC", -2.269525040707039e+01, -1.210565188030372e+01},
	{"DPD", -2.139039512025100e+01, -1.080079659348433e+01},
	{"DPE", -1.343168412619305e+01, -2.842085599426384e+00},
	{"DPF", -2.772030883104314e+01, -1.713071030427647e+01},
	{"DPG", -2.852909633164593e+01, -1.793949780487927e+01},
	{"DPH", -1.550039570111577e+01, -4.910797174349105e+00},
	{"DPI", -1.500729975751068e+01, -4.417701230744010e+00},
	{"DPJ", -3.135335363191134e+01, -2.076375510514467e+01},
	{"DPK", -3.122383307595429e+01, -2.063423454918762e+01},
	{"DPL", -1.414890209368388e+01, -3.559303566917215e+00},
	{"DPM", -1.925243561530927e+01, -8.662837088542606e+00},
	{"DPN", -1.925784406595172e+01, -8.668245539185046e+00},
	{"DPO", -1.355398551359623e+01, -2.964386986829566e+00},
	{"DPP", -1.895765155774124e+01, -8.368053030974570e+00},
	{"DPQ", -3.260962429757248e+01, -2.202002577080582e+01},
	{"DPR", -1.239113544039103e+01, -1.801536913624366e+00},
	{"DPS", -1.943719998722475e+01, -8.847601460458089e+00},
	{"DPT", -2.089083288135520e+01, -1.030123435458854e+01},
	{"DPU", -1.370218298568185e+01, -3.112584458915185e+00},
	{"DPV", -2.370795794701759e+01, -1.311835942025093e+01},
	{"DPW", -2.264497547112899e+01, -1.205537694436233e+01},
	{"DPX", -3.611080300298029e+01, -2.552120447621362e+01},
	{"DPY", -1.961750925181724e+01, -9.027910725050571e+00},
	{"DPZ", -3.441591862843138e+01, -2.382632010166472e+01},
	{"DQA", -2.752510639300963e+01, -1.272579637749322e+01},
	{"DQB", -3.015348118535121e+01, -1.535417116983480e+01},
	{"DQC", -2.270345764868508e+01, -7.904147633168676e+00},
	{"DQD", -3.067518504544113e+01, -1.587587502992473e+01},
	{"DQE", -3.106307958958538e+01, -1.626376957406897e+01},
	{"DQF", -2.113156175018332e+01, -6.332251734666916e+00},
	{"DQG", -3.613880796322349e+01, -2.133949794770709e+01},
	{"DQH", -2.370228249940645e+01, -8.902972483890045e+00},
	{"DQI", -2.586510325359317e+01, -1.106579323807676e+01},
	{"DQJ", -3.193885442084291e+01, -1.713954440532650e+01},
	{"DQK", -3.777099315816223e+01, -2.297168314264583e+01},
	{"DQL", -3.041593021914412e+01, -1.561662020362771e+01},
	{"DQM", -2.369666491216019e+01, -8.897354896643789e+00},
	{"DQN", -3.242286075397217e+01, -1.762355073845577e+01},
	{"DQO", -3.061930658469761e+01, -1.581999656918121e+01},
	{"DQP", -3.062149197112347e+01, -1.582218195560707e+01},
	{"DQQ", -3.250289491986057e+01, -1.770358490434416e+01},
	{"DQR", -3.046819542257533e+01, -1.566888540705892e+01},
	{"DQS", -2.754050757786408e+01, -1.274119756234767e+01},
	{"DQT", -2.803881799480639e+01, -1.323950797928999e+01},
	{"DQU", -1.483113275127355e+01, -3.182273575714659e-02},
	{"DQV", -3.333404860021385e+01, -1.853473858469744e+01},
	{"DQW", -2.969230142436012e+01, -1.489299140884371e+01},
	{"DQX", -3.979412511604517e+01, -2.499481510052876e+01},
	{"DQY", -3.398684531749195e+01, -1.918753530197554e+01},
	{"DQZ", -4.093369255279570e+01, -2.613438253727929e+01},
	{"DRA", -1.234521653264599e+01, -2.815876524904075e+00},
	{"DRB", -1.853873352737650e+01, -9.009393519634582e+00},
	{"DRC", -1.883565073055475e+01, -9.306310722812828e+00},
	{"DRD", -1.871940894523105e+01, -9.190068937489134e+00},
	{"DRE", -1.042739713289957e+01, -8.980571251576538e-01},
	{"DRF", -1.960731102322801e+01, -1.007797101548610e+01},
	{"DRG", -1.809320450317965e+01, -8.563864495437732e+00},
	{"DRH", -1.792887986339384e+01, -8.399539855651925e+00},
	{"DRI", -1.254178852168800e+01, -3.012448513946087e+00},
	{"DRJ", -2.001462925909730e+01, -1.048528925135538e+01},
	{"DRK", -2.334787941708329e+01, -1.381853940934138e+01},
	{"DRL", -2.049823199117420e+01, -1.096889198343228e+01},
	{"DRM", -1.966226067760475e+01, -1.013292066986283e+01},
	{"DRN", -1.995163663606854e+01, -1.042229662832662e+01},
	{"DRO", -1.276861447834207e+01, -3.239274470600155e+00},
	{"DRP", -1.825060797002080e+01, -8.721267962278885e+00},
	{"DRQ", -3.000836814877217e+01, -2.047902814103025e+01},
	{"DRR", -1.888874625753214e+01, -9.359406249790229e+00},
	{"DRS", -1.766337220996168e+01, -8.134032202219764e+00},
	{"DRT", -1.881945401176857e+01, -9.290114004026655e+00},
	{"DRU", -1.396648699390945e+01, -4.437146986167534e+00},
	{"DRV", -2.203414844059356e+01, -1.250480843285164e+01},
	{"DRW", -1.884420837881857e+01, -9.314868371076651e+00},
	{"DRX", -3.067349432153162e+01, -2.114415431378971e+01},
	{"DRY", -1.517665157655364e+01, -5.647311568811721e+00},
	{"DRZ", -3.160461685537788e+01, -2.207527684763596e+01},
	{"DSA", -1.109223318215829e+01, -2.624662245458568e+00},
	{"DSB", -1.475169548296722e+01, -6.284124546267492e+00},
	{"DSC", -1.386591122392765e+01, -5.398340287227925e+00},
	{"DSD", -1.596199259714667e+01, -7.494421660446945e+00},
	{"DSE", -1.198999101597905e+01, -3.522420079279321e+00},
	{"DSF", -1.456023916374787e+01, -6.092668227048139e+00},
	{"DSG", -1.698852751328705e+01, -8.520956576587324e+00},
	{"DSH", -1.156463820658881e+01, -3.097067269889084e+00},
	{"DSI", -1.262607414557009e+01, -4.158503208870364e+00},
	{"DSJ", -1.907253819808438e+01, -1.060496726138465e+01},
	{"DSK", -1.682233532366807e+01, -8.354764386968348e+00},
	{"DSL", -1.437809486027274e+01, -5.910523923573013e+00},
	{"DSM", -1.436244149354011e+01, -5.894870556840382e+00},
	{"DSN", -1.559814000195784e+01, -7.130569065258118e+00},
	{"DSO", -1.109207845569235e+01, -2.624507518992624e+00},
	{"DSP", -1.330005537979454e+01, -4.832484443094812e+00},
	{"DSQ", -1.754798137344266e+01, -9.080410436742934e+00},
	{"DSR", -1.614680811046187e+01, -7.679237173762140e+00},
	{"DSS", -1.454190376990908e+01, -6.074332833209357e+00},
	{"DST", -1.108251870024940e+01, -2.614947763549672e+00},
	{"DSU", -1.283164860767526e+01, -4.364077670975535e+00},
	{"DSV", -1.793546616641921e+01, -9.467895229719485e+00},
	{"DSW", -1.326152421880156e+01, -4.793953282101832e+00},
	{"DSX", -3.028042728908670e+01, -2.181285635238697e+01},
	{"DSY", -1.581094234671194e+01, -7.343371410012216e+00},
	{"DSZ", -3.172575104410153e+01, -2.325818010740181e+01},
	{"DTA", -1.342027273052408e+01, -5.882382071759102e+00},
	{"DTB", -2.583246850926996e+01, -1.829457785050499e+01},
	{"DTC", -2.590473434379960e+01, -1.836684368503462e+01},
	{"DTD", -2.000288524572320e+01, -1.246499458695823e+01},
	{"DTE", -1.385147641858888e+01, -6.313585759823910e+00},
	{"DTF", -2.606273589214842e+01, -1.852484523338345e+01},
	{"DTG", -2.700405204981683e+01, -1.946616139105185e+01},
	{"DTH", -8.063825216932036e+00, -5.259345581670632e-01},
	{"DTI", -1.431122142126101e+01, -6.773330762496036e+00},
	{"DTJ", -2.915726387401473e+01, -2.161937321524975e+01},
	{"DTK", -2.899048313497801e+01, -2.145259247621304e+01},
	{"DTL", -2.332899897210916e+01, -1.579110831334418e+01},
	{"DTM", -2.203262331856254e+01, -1.449473265979756e+01},
	{"DTN", -2.659603309047757e+01, -1.905814243171260e+01},
	{"DTO", -9.655512179233293e+00, -2.117621520468319e+00},
	{"DTP", -2.354309223270769e+01, -1.600520157394272e+01},
	{"DTQ", -3.112678856980681e+01, -2.358889791104184e+01},
	{"DTR", -1.352671954080840e+01, -5.988828882043426e+00},
	{"DTS", -1.948402242912618e+01, -1.194613177036120e+01},
	{"DTT", -2.086292587487674e+01, -1.332503521611177e+01},
	{"DTU", -1.449369335532948e+01, -6.955802696564509e+00},
	{"DTV", -2.911653031633150e+01, -2.157863965756653e+01},
	{"DTW", -1.402264437744953e+01, -6.484753718684559e+00},
	{"DTX", -1.932640781432635e+01, -1.178851715556137e+01},
	{"DTY", -1.841820715663016e+01, -1.088031649786519e+01},
	{"DTZ", -3.129277113520715e+01, -2.375488047644218e+01},
	{"DUA", -1.428680529705707e+01, -4.698946551473937e+00},
	{"DUB", -1.694305787707172e+01, -7.355199131488592e+00},
	{"DUC", -1.210687940294501e+01, -2.519020657361878e+00},
	{"DUD", -1.975486168253024e+01, -1.016700293694711e+01},
	{"DUE", -1.463205518796501e+01, -5.044196442381878e+00},
	{"DUF", -2.068467610930759e+01, -1.109681736372445e+01},
	{"DUG", -1.683566733202884e+01, -7.247808586445711e+00},
	{"DUH", -2.355473744435697e+01, -1.396687869877383e+01},
	{"DUI", -1.844373591654066e+01, -8.855877170957530e+00},
	{"DUJ", -2.271435709503785e+01, -1.312649834945471e+01},
	{"DUK", -1.435450929536279e+01, -4.766650549779651e+00},
	{"DUL", -1.452091124164334e+01, -4.933052496060202e+00},
	{"DUM", -1.617310813291406e+01, -6.585249387330922e+00},
	{"DUN", -1.162000156750030e+01, -2.032142821917162e+00},
	{"DUO", -1.925431396956843e+01, -9.666455223985295e+00},
	{"DUP", -1.203743892918978e+01, -2.449580183606643e+00},
	{"DUQ", -2.113331942715401e+01, -1.154546068157088e+01},
	{"DUR", -1.306015148789632e+01, -3.472292742313183e+00},
	{"DUS", -1.299275251823305e+01, -3.404893772649914e+00},
	{"DUT", -1.406855022694697e+01, -4.480691481363833e+00},
	{"DUU", -2.139282219302802e+01, -1.180496344744489e+01},
	{"DUV", -2.039368716434225e+01, -1.080582841875912e+01},
	{"DUW", -2.356665642666459e+01, -1.397879768108146e+01},
	{"DUX", -2.947934922380786e+01, -1.989149047822472e+01},
	{"DUY", -2.863404607210783e+01, -1.904618732652469e+01},
	{"DUZ", -1.932487021024190e+01, -9.737011464658766e+00},
	{"DVA", -1.332696328496056e+01, -1.442383475697183e+00},
	{"DVB", -3.309148318970585e+01, -2.120690338044247e+01},
	{"DVC", -3.328083951704605e+01, -2.139625970778268e+01},
	{"DVD", -3.253591165079008e+01, -2.065133184152671e+01},
	{"DVE", -1.365826708814548e+01, -1.773687278882106e+00},
	{"DVF", -3.274025889607762e+01, -2.085567908681424e+01},
	{"DVG", -3.404865128339910e+01, -2.216407147413572e+01},
	{"DVH", -3.176349225882755e+01, -1.987891244956417e+01},
	{"DVI", -1.398851274436551e+01, -2.103932935102129e+00},
	{"DVJ", -2.371780049597470e+01, -1.183322068671132e+01},
	{"DVK", -3.585110960681804e+01, -2.396652979755466e+01},
	{"DVL", -3.312335267850354e+01, -2.123877286924017e+01},
	{"DVM", -3.211072720889455e+01, -2.022614739963117e+01},
	{"DVN", -2.213143559869404e+01, -1.024685578943066e+01},
	{"DVO", -1.515490882703593e+01, -3.270329017772552e+00},
	{"DVP", -3.220646246521351e+01, -2.032188265595013e+01},
	{"DVQ", -3.980330438015353e+01, -2.791872457089015e+01},
	{"DVR", -3.016249801230430e+01, -1.827791820304092e+01},
	{"DVS", -2.213137676068465e+01, -1.024679695142127e+01},
	{"DVT", -3.051618310503753e+01, -1.863160329577416e+01},
	{"DVU", -2.139365628104582e+01, -9.509076471782445e+00},
	{"DVV", -3.469688154576441e+01, -2.281230173650102e+01},
	{"DVW", -3.183964117360676e+01, -1.995506136434339e+01},
	{"DVX", -3.642912519725018e+01, -2.454454538798680e+01},
	{"DVY", -2.825196763322075e+01, -1.636738782395737e+01},
	{"DVZ", -3.983900407980790e+01, -2.795442427054452e+01},
	{"DWA", -1.197151816501220e+01, -2.714735000817218e+00},
	{"DWB", -2.796563839516398e+01, -1.870885523096899e+01},
	{"DWC", -2.802353001409126e+01, -1.876674684989628e+01},
	{"DWD", -2.753605836473004e+01, -1.827927520053505e+01},
	{"DWE", -1.189215677755801e+01, -2.635373613363023e+00},
	{"DWF", -2.781860780035071e+01, -1.856182463615572e+01},
	{"DWG", -2.894535123033637e+01, -1.968856806614139e+01},
	{"DWH", -1.112410451720321e+01, -1.867321353008224e+00},
	{"DWI", -1.084240034189724e+01, -1.585617177702253e+00},
	{"DWJ", -3.030204569315378e+01, -2.104526252895879e+01},
	{"DWK", -3.045705815667980e+01, -2.120027499248481e+01},
	{"DWL", -2.688647747291096e+01, -1.762969430871598e+01},
	{"DWM", -2.758692648014865e+01, -1.833014331595367e+01},
	{"DWN", -2.446221261468552e+01, -1.520542945049054e+01},
	{"DWO", -1.323362006470140e+01, -3.976836900506411e+00},
	{"DWP", -2.867578632031867e+01, -1.941900315612368e+01},
	{"DWQ", -3.288955821177839e+01, -2.363277504758340e+01},
	{"DWR", -1.531714557456551e+01, -6.060362410370518e+00},
	{"DWS", -2.572211152423483e+01, -1.646532836003984e+01},
	{"DWT", -2.559240722860255e+01, -1.633562406440757e+01},
	{"DWU", -2.368359000751269e+01, -1.442680684331770e+01},
	{"DWV", -3.077050465582962e+01, -2.151372149163463e+01},
	{"DWW", -2.681160026876527e+01, -1.755481710457028e+01},
	{"DWX", -4.012321373315521e+01, -3.086643056896023e+01},
	{"DWY", -1.946630878040616e+01, -1.020952561621117e+01},
	{"DWZ", -3.364619738379437e+01, -2.438941421959938e+01},
	{"DXA", -2.467614791381392e+01, -4.977647597023316e+00},
	{"DXB", -2.924359892823747e+01, -9.545098611446868e+00},
	{"DXC", -2.420459858578762e+01, -4.506098268997016e+00},
	{"DXD", -2.863698708115742e+01, -8.938486764366813e+00},
	{"DXE", -2.103987239297753e+01, -1.341372076186928e+00},
	{"DXF", -2.877909654721292e+01, -9.080596230422314e+00},
	{"DXG", -3.007816108732868e+01, -1.037966077053807e+01},
	{"DXH", -2.643633491319199e+01, -6.737834596401387e+00},
	{"DXI", -2.234672047671228e+01, -2.648220159921675e+00},
	{"DXJ", -3.129113021335259e+01, -1.159262989656199e+01},
	{"DXK", -3.218921650379897e+01, -1.249071618700837e+01},
	{"DXL", -2.873645052062245e+01, -9.037950203831842e+00},
	{"DXM", -2.801835367880059e+01, -8.319853362009987e+00},
	{"DXN", -3.052865419517362e+01, -1.083015387838301e+01},
	{"DXO", -2.703400730169224e+01, -7.335506984901632e+00},
	{"DXP", -2.365239559237546e+01, -3.953895275584860e+00},
	{"DXQ", -3.019142586306574e+01, -1.049292554627513e+01},
	{"DXR", -2.880961326101900e+01, -9.111112944228395e+00},
	{"DXS", -2.810149871503009e+01, -8.402998398239479e+00},
	{"DXT", -2.345153044899432e+01, -3.753030132203715e+00},
	{"DXU", -2.731449604853889e+01, -7.615995731748288e+00},
	{"DXV", -2.693606376474611e+01, -7.237563447955499e+00},
	{"DXW", -2.812522841561712e+01, -8.426728098826517e+00},
	{"DXX", -2.216990060079929e+01, -2.471400284008681e+00},
	{"DXY", -2.790868434660229e+01, -8.210184029811680e+00},
	{"DXZ", -4.172844561596534e+01, -2.202994529917473e+01},
	{"DYA", -1.430034875948418e+01, -3.675045843703764e+00},
	{"DYB", -1.570814642603505e+01, -5.082843510254635e+00},
	{"DYC", -1.594518744561536e+01, -5.319884529834942e+00},
	{"DYD", -1.652259194948789e+01, -5.897289033707469e+00},
	{"DYE", -1.308500851802333e+01, -2.459705602242912e+00},
	{"DYF", -1.598547964136929e+01, -5.360176725588877e+00},
	{"DYG", -1.685626704536966e+01, -6.230964129589242e+00},
	{"DYH", -1.627672919067788e+01, -5.651426274897466e+00},
	{"DYI", -1.470355408372695e+01, -4.078251167946540e+00},
	{"DYJ", -1.980344567288634e+01, -9.178142757105929e+00},
	{"DYK", -1.828918128136086e+01, -7.663878365580448e+00},
	{"DYL", -1.731717973880261e+01, -6.691876823022193e+00},
	{"DYM", -1.637143106223031e+01, -5.746128146449898e+00},
	{"DYN", -1.653514029120007e+01, -5.909837375419650e+00},
	{"DYO", -1.236924995647799e+01, -1.743947040697574e+00},
	{"DYP", -1.700759989274658e+01, -6.382296976966167e+00},
	{"DYQ", -2.212259341799461e+01, -1.149729050221420e+01},
	{"DYR", -1.694284828166267e+01, -6.317545365882250e+00},
	{"DYS", -1.490408864118574e+01, -4.278785725405321e+00},
	{"DYT", -1.444375336117346e+01, -3.818450445393046e+00},
	{"DYU", -1.783037562729537e+01, -7.205072711514957e+00},
	{"DYV", -1.925223400079245e+01, -8.626931085012032e+00},
	{"DYW", -1.520996406803384e+01, -4.584661152253426e+00},
	{"DYX", -3.120659505510873e+01, -2.058129213932832e+01},
	{"DYY", -1.880347115681150e+01, -8.178168241031083e+00},
	{"DYZ", -3.054065720140565e+01, -1.991535428562523e+01},
	{"DZA", -1.775934635172826e+01, -1.978404234619157e+00},
	{"DZB", -2.855988599848677e+01, -1.277894388137766e+01},
	{"DZC", -2.944675056254824e+01, -1.366580844543913e+01},
	{"DZD", -2.980591640395108e+01, -1.402497428684197e+01},
	{"DZE", -1.724762740597475e+01, -1.466685288865652e+00},
	{"DZF", -2.938958084651052e+01, -1.360863872940142e+01},
	{"DZG", -2.991601714345288e+01, -1.413507502634378e+01},
	{"DZH", -2.853275427360277e+01, -1.275181215649367e+01},
	{"DZI", -1.765791079072708e+01, -1.876968673617979e+00},
	{"DZJ", -3.243974184561004e+01, -1.665879972850095e+01},
	{"DZK", -3.107524190599640e+01, -1.529429978888730e+01},
	{"DZL", -2.676547704264286e+01, -1.098453492553375e+01},
	{"DZM", -2.897373297233287e+01, -1.319279085522377e+01},
	{"DZN", -3.007656060095252e+01, -1.429561848384342e+01},
	{"DZO", -1.987662356004290e+01, -4.095681442933795e+00},
	{"DZP", -2.789212532118271e+01, -1.211118320407361e+01},
	{"DZQ", -3.635595573493340e+01, -2.057501361782429e+01},
	{"DZR", -2.710488197118509e+01, -1.132393985407598e+01},
	{"DZS", -2.872370471424098e+01, -1.294276259713188e+01},
	{"DZT", -2.722363699536432e+01, -1.144269487825522e+01},
	{"DZU", -2.012249774084117e+01, -4.341555623732066e+00},
	{"DZV", -2.952343653907769e+01, -1.374249442196859e+01},
	{"DZW", -2.818692371421356e+01, -1.240598159710445e+01},
	{"DZX", -3.916409229637824e+01, -2.338315017926913e+01},
	{"DZY", -2.759957154470391e+01, -1.181862942759480e+01},
	{"DZZ", -2.519444984986034e+01, -9.413507732751233e+00},
	{"EAA", -1.462578855292138e+01, -8.027426104819817e+00},
	{"EAB", -1.247645228984162e+01, -5.878089841740048e+00},
	{"EAC", -1.081812574114895e+01, -4.219763293047377e+00},
	{"EAD", -1.022331693187284e+01, -3.624954483771268e+00},
	{"EAE", -1.619435144403646e+01, -9.595988995934889e+00},
	{"EAF", -1.270247896169482e+01, -6.104116513593255e+00},
	{"EAG", -1.243886090003230e+01, -5.840498451930731e+00},
	{"EAH", -1.480536676107490e+01, -8.207004312973330e+00},
	{"EAI", -1.378349019999005e+01, -7.185127751888484e+00},
	{"EAJ", -1.793671514914329e+01, -1.133835270104172e+01},
	{"EAK", -1.237542874456553e+01, -5.777066296463961e+00},
	{"EAL", -1.053744868498684e+01, -3.939086236885270e+00},
	{"EAM", -1.188793720988375e+01, -5.289574761782180e+00},
	{"EAN", -8.968424238903529e+00, -2.370061790801961e+00},
	{"EAO", -1.536550231448701e+01, -8.767139866385438e+00},
	{"EAP", -1.236592933259501e+01, -5.767566884493446e+00},
	{"EAQ", -1.793666150574881e+01, -1.133829905764724e+01},
	{"EAR", -9.002924105885734e+00, -2.404561657784166e+00},
	{"EAS", -9.833560811372312e+00, -3.235198363270744e+00},
	{"EAT", -9.511143617871680e+00, -2.912781169770112e+00},
	{"EAU", -1.293147001366130e+01, -6.333107565559729e+00},
	{"EAV", -1.173915199957864e+01, -5.140789551477069e+00},
	{"EAW", -1.378466814935507e+01, -7.186305701253499e+00},
	{"EAX", -1.881032032602079e+01, -1.221195787791922e+01},
	{"EAY", -1.715366390758624e+01, -1.055530145948467e+01},
	{"EAZ", -1.707446458183672e+01, -1.047610213373515e+01},
	{"EBA", -1.196160252232817e+01, -3.128930193959267e+00},
	{"EBB", -1.819063312715663e+01, -9.357960798787724e+00},
	{"EBC", -1.793509559644791e+01, -9.102423268079008e+00},
	{"EBD", -2.269245468224713e+01, -1.385978235387823e+01},
	{"EBE", -1.059856454071111e+01, -1.765892212342211e+00},
	{"EBF", -2.212797684428519e+01, -1.329530451591628e+01},
	{"EBG", -2.271589004164030e+01, -1.388321771327139e+01},
	{"EBH", -2.212076147388542e+01, -1.328808914551651e+01},
	{"EBI", -1.401677167347102e+01, -5.184099345102120e+00},
	{"EBJ", -2.646589123247227e+01, -1.763321890410337e+01},
	{"EBK", -2.171760420241391e+01, -1.288493187404500e+01},
	{"EBL", -1.318041844220295e+01, -4.347746113834047e+00},
	{"EBM", -2.211306394486169e+01, -1.328039161649279e+01},
	{"EBN", -2.090625851822927e+01, -1.207358618986037e+01},
	{"EBO", -1.166616601134369e+01, -2.833493682974781e+00},
	{"EBP", -1.765242127803260e+01, -8.819748949663692e+00},
	{"EBQ", -3.578861503940944e+01, -2.695594271104053e+01},
	{"EBR", -1.189561993635505e+01, -3.062947607986145e+00},
	{"EBS", -1.630607480053315e+01, -7.473402472164242e+00},
	{"EBT", -1.524209970690411e+01, -6.409427378535207e+00},
	{"EBU", -1.146214869028111e+01, -2.629476361912207e+00},
	{"EBV", -2.270746156409907e+01, -1.387478923573017e+01},
	{"EBW", -2.054510240469030e+01, -1.171243007632140e+01},
	{"EBX", -3.907582287865004e+01, -3.024315055028113e+01},
	{"EBY", -1.268265126506116e+01, -3.849978936692255e+00},
	{"EBZ", -3.358392675441744e+01, -2.475125442604854e+01},
	{"ECA", -1.027908033488321e+01, -2.755298756577349e+00},
	{"ECB", -1.990922116751454e+01, -1.238543958920868e+01},
	{"ECC", -1.694279065864547e+01, -9.419009080339615e+00},
	{"ECD", -1.822554894202182e+01, -1.070176736371597e+01},
	{"ECE", -1.121787709167840e+01, -3.694095513372538e+00},
	{"ECF", -2.090651317050347e+01, -1.338273159219761e+01},
	{"ECG", -2.212788922112576e+01, -1.460410764281990e+01},
	{"ECH", -1.101833050866087e+01, -3.494548930355009e+00},
	{"ECI", -1.157528703566049e+01, -4.051505457354634e+00},
	{"ECJ", -3.199485282485086e+01, -2.447107124654499e+01},
	{"ECK", -1.315850163221057e+01, -5.634720053904711e+00},
	{"ECL", -1.229311789433310e+01, -4.769336316027243e+00},
	{"ECM", -2.054479078044145e+01, -1.302100920213560e+01},
	{"ECN", -2.025754591772862e+01, -1.273376433942276e+01},
	{"ECO", -9.413255624848675e+00, -1.889474046542815e+00},
	{"ECP", -2.112376977783428e+01, -1.359998819952842e+01},
	{"ECQ", -2.366361255821238e+01, -1.613983097990652e+01},
	{"ECR", -1.226093708840255e+01, -4.737155510096688e+00},
	{"ECS", -1.835735265900800e+01, -1.083357108070214e+01},
	{"ECT", -9.749233798261686e+00, -2.225452219955827e+00},
	{"ECU", -1.210140820427313e+01, -4.577626625967273e+00},
	{"ECV", -3.164886296260572e+01, -2.412508138429985e+01},
	{"ECW", -2.024901513993283e+01, -1.272523356162697e+01},
	{"ECX", -2.213307374131304e+01, -1.460929216300718e+01},
	{"ECY", -1.672777080578179e+01, -9.203989227475930e+00},
	{"ECZ", -1.843326820665179e+01, -1.090948662834593e+01},
	{"EDA", -9.372184370056141e+00, -2.858096745173635e+00},
	{"EDB", -1.052236384371656e+01, -4.008276218834057e+00},
	{"EDC", -1.280407864811661e+01, -6.289991023234104e+00},
	{"EDD", -1.295100703458187e+01, -6.436919409699362e+00},
	{"EDE", -1.045547537280726e+01, -3.941387747924758e+00},
	{"EDF", -1.123685209522147e+01, -4.722764470338962e+00},
	{"EDG", -1.276651207725470e+01, -6.252424452372190e+00},
	{"EDH", -1.100800328971716e+01, -4.493915664834659e+00},
	{"EDI", -9.398649661278677e+00, -2.884562036396171e+00},
	{"EDJ", -1.513336464206190e+01, -8.619277017179391e+00},
	{"EDK", -1.636075728849247e+01, -9.846669663609960e+00},
	{"EDL", -1.294695403384634e+01, -6.432866408963834e+00},
	{"EDM", -1.185788028053122e+01, -5.343792655648714e+00},
	{"EDN", -1.270234894175350e+01, -6.188261316870991e+00},
	{"EDO", -1.023954297918823e+01, -3.725455354305723e+00},
	{"EDP", -1.287302099714157e+01, -6.358933372259062e+00},
	{"EDQ", -1.700428132963178e+01, -1.049019370474928e+01},
	{"EDR", -1.234768445869927e+01, -5.833596833816761e+00},
	{"EDS", -1.121456782160115e+01, -4.700480196718646e+00},
	{"EDT", -8.936166892874651e+00, -2.422079267992143e+00},
	{"EDU", -1.119041782981150e+01, -4.676330204928994e+00},
	{"EDV", -1.492388150422598e+01, -8.409793879343470e+00},
	{"EDW", -1.096748708898886e+01, -4.453399464106351e+00},
	{"EDX", -2.171854577737338e+01, -1.520445815249087e+01},
	{"EDY", -1.362555430619498e+01, -7.111466681312474e+00},
	{"EDZ", -1.891090619873687e+01, -1.239681857385436e+01},
	{"EEA", -1.135351583650253e+01, -3.584060796799824e+00},
	{"EEB", -1.417874384047919e+01, -6.409288800776480e+00},
	{"EEC", -1.354370291042858e+01, -5.774247870725874e+00},
	{"EED", -1.133365712689770e+01, -3.564202087194988e+00},
	{"EEE", -1.645250051691259e+01, -8.683045477209886e+00},
	{"EEF", -1.336374681382364e+01, -5.594291774120932e+00},
	{"EEG", -1.497597402377134e+01, -7.206518984068635e+00},
	{"EEH", -1.414413216954914e+01, -6.374677129846435e+00},
	{"EEI", -1.315568884305672e+01, -5.386233803354016e+00},
	{"EEJ", -1.801696618047015e+01, -1.024751114076744e+01},
	{"EEK", -1.293158798203786e+01, -5.162132942335149e+00},
	{"EEL", -1.202391007870122e+01, -4.254455038998506e+00},
	{"EEM", -1.175877163507853e+01, -3.989316595375826e+00},
	{"EEN", -9.845194058642058e+00, -2.075739018939349e+00},
	{"EEO", -1.393123916940268e+01, -6.161784129699971e+00},
	{"EEP", -1.174267832830017e+01, -3.973223288597465e+00},
	{"EEQ", -1.550411664361702e+01, -7.734661603914318e+00},
	{"EER", -1.323846842373191e+01, -5.469013384029203e+00},
	{"EES", -1.227649093221676e+01, -4.507035892514048e+00},
	{"EET", -1.115397513809722e+01, -3.384520098394510e+00},
	{"EEU", -1.538251762470451e+01, -7.613062585001802e+00},
	{"EEV", -1.275048931726158e+01, -4.981034277558873e+00},
	{"EEW", -1.411926331071788e+01, -6.349808271015174e+00},
	{"EEX", -1.229292554933580e+01, -4.523470509633096e+00},
	{"EEY", -1.382329104793431e+01, -6.053836008231604e+00},
	{"EEZ", -1.633494494262015e+01, -8.565489902917438e+00},
	{"EFA", -1.166480736305773e+01, -3.484620481447597e+00},
	{"EFB", -1.766883284382470e+01, -9.488645962214569e+00},
	{"EFC", -1.744483803165591e+01, -9.264651150045776e+00},
	{"EFD", -1.885047778694226e+01, -1.067029090533213e+01},
	{"EFE", -1.178479304558935e+01, -3.604606163979220e+00},
	{"EFF", -1.273994673555943e+01, -4.559759853949294e+00},
	{"EFG", -1.905971495014121e+01, -1.087952806853108e+01},
	{"EFH", -1.817624899610769e+01, -9.996062114497560e+00},
	{"EFI", -1.102179228908297e+01, -2.841605407472839e+00},
	{"EFJ", -1.918564459452076e+01, -1.100545771291063e+01},
	{"EFK", -2.138500848823618e+01, -1.320482160662605e+01},
	{"EFL", -1.273245057167413e+01, -4.552263690064002e+00},
	{"EFM", -1.764233029599584e+01, -9.462143414385704e+00},
	{"EFN", -2.000099184884140e+01, -1.182080496723127e+01},
	{"EFO", -9.582935501582213e+00, -1.402748619972081e+00},
	{"EFP", -1.683209016459370e+01, -8.651903282983572e+00},
	{"EFQ", -3.056184107512610e+01, -2.238165419351597e+01},
	{"EFR", -1.146795773581388e+01, -3.287770854203751e+00},
	{"EFS", -1.600778424841027e+01, -7.827597366800145e+00},
	{"EFT", -1.291120574079046e+01, -4.731018859180332e+00},
	{"EFU", -1.205137114069305e+01, -3.871184259082914e+00},
	{"EFV", -2.089750604891876e+01, -1.271731916730863e+01},
	{"EFW", -1.720591958740503e+01, -9.025732705794907e+00},
	{"EFX", -3.287321257945960e+01, -2.469302569784948e+01},
	{"EFY", -1.846306118603897e+01, -1.028287430442884e+01},
	{"EFZ", -2.090618209056096e+01, -1.272599520895083e+01},
	{"EGA", -1.150989907355985e+01, -2.489542783802747e+00},
	{"EGB", -1.930990453112317e+01, -1.028954824136607e+01},
	{"EGC", -1.835411412951102e+01, -9.333757839753916e+00},
	{"EGD", -2.086612571568639e+01, -1.184576942592929e+01},
	{"EGE", -1.204154301227328e+01, -3.021186722516178e+00},
	{"EGF", -1.866232868463283e+01, -9.641972394875729e+00},
	{"EGG", -1.525428829682865e+01, -6.233932007071546e+00},
	{"EGH", -1.648224419220792e+01, -7.461887902450817e+00},
	{"EGI", -1.186374199656811e+01, -2.843385706811005e+00},
	{"EGJ", -2.922995622415526e+01, -2.020959993439816e+01},
	{"EGK", -2.947138368641489e+01, -2.045102739665779e+01},
	{"EGL", -1.378403264785714e+01, -4.763676358100034e+00},
	{"EGM", -1.889673149526280e+01, -9.876375205505699e+00},
	{"EGN", -1.594714043979798e+01, -6.926784150040874e+00},
	{"EGO", -1.164225012821705e+01, -2.621893838459946e+00},
	{"EGP", -2.086972657916815e+01, -1.184937028941104e+01},
	{"EGQ", -3.076446278103296e+01, -2.174410649127585e+01},
	{"EGR", -1.123484118991192e+01, -2.214484900154820e+00},
	{"EGS", -1.631865885520682e+01, -7.298302565449719e+00},
	{"EGT", -1.814294957979709e+01, -9.122593290039985e+00},
	{"EGU", -1.294994333577629e+01, -3.929587046019193e+00},
	{"EGV", -2.860490456295345e+01, -1.958454827319635e+01},
	{"EGW", -1.899847079447552e+01, -9.978114504718411e+00},
	{"EGX", -3.398328324748032e+01, -2.496292695772321e+01},
	{"EGY", -1.375564167462875e+01, -4.735285384871649e+00},
	{"EGZ", -3.257153676151254e+01, -2.355118047175544e+01},
	{"EHA", -1.022748400095733e+01, -1.619044128076180e+00},
	{"EHB", -1.990147903457279e+01, -1.129303916169165e+01},
	{"EHC", -2.168354405658598e+01, -1.307510418370483e+01},
	{"EHD", -2.012532872657903e+01, -1.151688885369789e+01},
	{"EHE", -1.056239904337657e+01, -1.953959170495426e+00},
	{"EHF", -2.038280957172164e+01, -1.177436969884049e+01},
	{"EHG", -2.268348618380836e+01, -1.407504631092722e+01},
	{"EHH", -1.838942859198691e+01, -9.780988719105762e+00},
	{"EHI", -1.121174442963714e+01, -2.603304556755997e+00},
	{"EHJ", -2.996807280213382e+01, -2.135963292925267e+01},
	{"EHK", -2.271123659064250e+01, -1.410279671776135e+01},
	{"EHL", -2.169443967584801e+01, -1.308599980296687e+01},
	{"EHM", -2.110147901882546e+01, -1.249303914594431e+01},
	{"EHN", -2.209943391883209e+01, -1.349099404595094e+01},
	{"EHO", -1.088061117891006e+01, -2.272171306028916e+00},
	{"EHP", -2.169169989161269e+01, -1.308326001873154e+01},
	{"EHQ", -3.172926795584598e+01, -2.312082808296483e+01},
	{"EHR", -2.035244432281747e+01, -1.174400444993632e+01},
	{"EHS", -1.895329399778885e+01, -1.034485412490771e+01},
	{"EHT", -1.798779560583144e+01, -9.379355732950298e+00},
	{"EHU", -1.339991452016877e+01, -4.791474647287629e+00},
	{"EHV", -3.020587409092135e+01, -2.159743421804020e+01},
	{"EHW", -1.880321778292741e+01, -1.019477791004627e+01},
	{"EHX", -3.572520498478914e+01, -2.711676511190799e+01},
	{"EHY", -1.733911846045434e+01, -8.730678587573195e+00},
	{"EHZ", -3.273708723066285e+01, -2.412864735778170e+01},
	{"EIA", -1.459274373729001e+01, -6.735387409409013e+00},
	{"EIB", -1.660754199283904e+01, -8.750185664958043e+00},
	{"EIC", -1.538536574412322e+01, -7.528009416242224e+00},
	{"EID", -1.430308697620593e+01, -6.445730648324930e+00},
	{"EIE", -1.749016399223299e+01, -9.632807664351986e+00},
	{"EIF", -1.353199323843018e+01, -5.674636910549180e+00},
	{"EIG", -1.183394446002618e+01, -3.976588132145181e+00},
	{"EIH", -1.507819162599933e+01, -7.220835298118332e+00},
	{"EII", -1.624266193733528e+01, -8.385305609454281e+00},
	{"EIJ", -1.981108307578626e+01, -1.195372674790527e+01},
	{"EIK", -1.732402598570352e+01, -9.466669657822520e+00},
	{"EIL", -1.391393340033200e+01, -6.056577072451003e+00},
	{"EIM", -1.300621592146353e+01, -5.148859593582529e+00},
	{"EIN", -9.483722460219653e+00, -1.626366132338655e+00},
	{"EIO", -1.744119155438983e+01, -9.583835226508830e+00},
	{"EIP", -1.580448056735833e+01, -7.947124239477327e+00},
	{"EIQ", -2.368759666428493e+01, -1.583024033640393e+01},
	{"EIR", -1.004835711913885e+01, -2.191000791257851e+00},
	{"EIS", -1.099167850909875e+01, -3.134322181217752e+00},
	{"EIT", -1.094787508655046e+01, -3.090518758669461e+00},
	{"EIU", -1.769381850747895e+01, -9.836462179597952e+00},
	{"EIV", -1.266035575325714e+01, -4.802999425376142e+00},
	{"EIW", -1.453358065644120e+01, -6.676224328560201e+00},
	{"EIX", -1.783466778566725e+01, -9.977311457786254e+00},
	{"EIY", -2.171813934976361e+01, -1.386078302188261e+01},
	{"EIZ", -1.545620589082569e+01, -7.598849562944692e+00},
	{"EJA", -1.537973432597421e+01, -3.354500529236466e+00},
	{"EJB", -2.138783791077038e+01, -9.362604114032640e+00},
	{"EJC", -2.369321660855437e+01, -1.166798281181663e+01},
	{"EJD", -3.140155060501062e+01, -1.937631680827288e+01},
	{"EJE", -1.407151301553915e+01, -2.046279218801408e+00},
	{"EJF", -3.052523650141491e+01, -1.850000270467716e+01},
	{"EJG", -3.010406677995235e+01, -1.807883298321461e+01},
	{"EJH", -2.368917436368878e+01, -1.166394056695104e+01},
	{"EJI", -1.739148345943361e+01, -5.366249662695869e+00},
	{"EJJ", -2.930171312054583e+01, -1.727647932380809e+01},
	{"EJK", -3.196936856281847e+01, -1.994413476608073e+01},
	{"EJL", -3.049164234034810e+01, -1.846640854361036e+01},
	{"EJM", -3.084548303485740e+01, -1.882024923811965e+01},
	{"EJN", -3.380511260003381e+01, -2.177987880329606e+01},
	{"EJO", -1.389861537135669e+01, -1.873381574618949e+00},
	{"EJP", -2.370374977766342e+01, -1.167851598092568e+01},
	{"EJQ", -3.325314687512610e+01, -2.122791307838836e+01},
	{"EJR", -2.270585571349454e+01, -1.068062191675680e+01},
	{"EJS", -2.991611042847515e+01, -1.789087663173741e+01},
	{"EJT", -3.000491711626332e+01, -1.797968331952558e+01},
	{"EJU", -1.349971112084246e+01, -1.474477324104723e+00},
	{"EJV", -3.687220009472696e+01, -2.484696629798921e+01},
	{"EJW", -2.924645613829793e+01, -1.722122234156019e+01},
	{"EJX", -3.955150550179578e+01, -2.752627170505804e+01},
	{"EJY", -3.602137625264039e+01, -2.399614245590265e+01},
	{"EJZ", -3.412637734609883e+01, -2.210114354936109e+01},
	{"EKA", -1.530755329646433e+01, -4.671433284974854e+00},
	{"EKB", -1.818612138115537e+01, -7.550001369665892e+00},
	{"EKC", -1.785550695338532e+01, -7.219386941895839e+00},
	{"EKD", -1.895650816270665e+01, -8.320388151217180e+00},
	{"EKE", -1.384998447590609e+01, -3.213864464416608e+00},
	{"EKF", -1.831573685634700e+01, -7.679616844857521e+00},
	{"EKG", -1.971301009057466e+01, -9.076890079085183e+00},
	{"EKH", -1.752123484981086e+01, -6.885114838321381e+00},
	{"EKI", -1.153663505214710e+01, -9.005150406576208e-01},
	{"EKJ", -2.171099232847130e+01, -1.107487231698182e+01},
	{"EKK", -2.054339984579464e+01, -9.907279834305156e+00},
	{"EKL", -1.803436908656894e+01, -7.398249075079459e+00},
	{"EKM", -1.804031682412297e+01, -7.404196812633490e+00},
	{"EKN", -1.342885494604650e+01, -2.792734934557026e+00},
	{"EKO", -1.665136518822188e+01, -6.015245176732404e+00},
	{"EKP", -1.842718308914706e+01, -7.791063077657580e+00},
	{"EKQ", -3.190223776204071e+01, -2.126611775055124e+01},
	{"EKR", -1.842883460652864e+01, -7.792714595039159e+00},
	{"EKS", -1.463712013064172e+01, -4.001000119152245e+00},
	{"EKT", -1.587279836446075e+01, -5.236678352971275e+00},
	{"EKU", -1.803786721459021e+01, -7.401747203100737e+00},
	{"EKV", -2.368378587867904e+01, -1.304766586718956e+01},
	{"EKW", -1.770793725101934e+01, -7.071817239529864e+00},
	{"EKX", -3.287428462793397e+01, -2.223816461644450e+01},
	{"EKY", -1.937497535217212e+01, -8.738855340682646e+00},
	{"EKZ", -3.096575196377905e+01, -2.032963195228957e+01},
	{"ELA", -1.046353343870622e+01, -3.009319372654421e+00},
	{"ELB", -1.491022843439714e+01, -7.456014368345341e+00},
	{"ELC", -1.523399174881877e+01, -7.779777682766976e+00},
	{"ELD", -1.213873521377226e+01, -4.684521147720464e+00},
	{"ELE", -1.054668869177967e+01, -3.092474625727874e+00},
	{"ELF", -1.138945772412213e+01, -3.935243658070330e+00},
	{"ELG", -1.461778559142479e+01, -7.163571525372995e+00},
	{"ELH", -1.546044012910884e+01, -8.006226063057044e+00},
	{"ELI", -1.037467789174940e+01, -2.920463825697598e+00},
	{"ELJ", -1.816357461985306e+01, -1.070936055380126e+01},
	{"ELK", -1.780852574548044e+01, -1.035431167942864e+01},
	{"ELL", -1.029061735056955e+01, -2.836403284517756e+00},
	{"ELM", -1.529562493962188e+01, -7.841410873570086e+00},
	{"ELN", -1.672826761455753e+01, -9.274053548505734e+00},
	{"ELO", -1.010890836262937e+01, -2.654694296577572e+00},
	{"ELP", -1.331551987893066e+01, -5.861305812878858e+00},
	{"ELQ", -2.139397981565064e+01, -1.393976574959884e+01},
	{"ELR", -1.666149870389931e+01, -9.207284637847508e+00},
	{"ELS", -1.228321114690964e+01, -4.828997080857843e+00},
	{"ELT", -1.238607531332851e+01, -4.931861247276712e+00},
	{"ELU", -1.471437052865727e+01, -7.260156462605472e+00},
	{"ELV", -1.257084027706855e+01, -5.116626211016752e+00},
	{"ELW", -1.440986258896561e+01, -6.955648522913815e+00},
	{"ELX", -3.365587118073039e+01, -2.620165711467860e+01},
	{"ELY", -1.141256919197018e+01, -3.958355125918381e+00},
	{"ELZ", -1.901823611817239e+01, -1.156402205212058e+01},
	{"EMA", -9.845736721126075e+00, -2.182784407657883e+00},
	{"EMB", -1.172806459774372e+01, -4.065112284275526e+00},
	{"EMC", -1.572934810089308e+01, -8.066395787424891e+00},
	{"EMD", -1.538735283488029e+01, -7.724400521412095e+00},
	{"EME", -1.012642629822665e+01, -2.463473984758461e+00},
	{"EMF", -1.424269615283238e+01, -6.579743839364190e+00},
	{"EMG", -1.640537745894753e+01, -8.742425145479336e+00},
	{"EMH", -1.477263648400625e+01, -7.109684170538062e+00},
	{"EMI", -1.096132614286645e+01, -3.298373829398254e+00},
	{"EMJ", -1.801774262174512e+01, -1.035479030827693e+01},
	{"EMK", -1.825877989431163e+01, -1.059582758084344e+01},
	{"EML", -1.615578612088606e+01, -8.492833807417870e+00},
	{"EMM", -1.539769050838674e+01, -7.734738194918547e+00},
	{"EMN", -1.383891431738856e+01, -6.175962003920364e+00},
	{"EMO", -1.042710504147888e+01, -2.764152728010685e+00},
	{"EMP", -1.161832812587370e+01, -3.955375812405510e+00},
	{"EMQ", -1.963110001627930e+01, -1.196814770281111e+01},
	{"EMR", -1.550856181459070e+01, -7.845609501122508e+00},
	{"EMS", -1.226971901158882e+01, -4.606766698120627e+00},
	{"EMT", -1.213521431231384e+01, -4.472261998845650e+00},
	{"EMU", -1.265692142986581e+01, -4.993969116397619e+00},
	{"EMV", -1.724261424211334e+01, -9.579661928645153e+00},
	{"EMW", -1.341579634951177e+01, -5.752844036043580e+00},
	{"EMX", -3.363601391202808e+01, -2.597306159855989e+01},
	{"EMY", -1.261944607846025e+01, -4.956493764992059e+00},
	{"EMZ", -2.171789039957713e+01, -1.405493808610894e+01},
	{"ENA", -1.019910248786050e+01, -3.818970592382976e+00},
	{"ENB", -1.171062932490672e+01, -5.330497429429192e+00},
	{"ENC", -9.993750647465584e+00, -3.613618751988055e+00},
	{"END", -1.023711979088720e+01, -3.856987895409673e+00},
	{"ENE", -9.971020886664666e+00, -3.590888991187137e+00},
	{"ENF", -1.271153173625698e+01, -6.331399840779453e+00},
	{"ENG", -1.123807674044166e+01, -4.857944844964129e+00},
	{"ENH", -1.192178405771419e+01, -5.541652162236659e+00},
	{"ENI", -1.084109375037515e+01, -4.460961854897620e+00},
	{"ENJ", -1.395714982489045e+01, -7.577017929412920e+00},
	{"ENK", -1.589751770011851e+01, -9.517385804640980e+00},
	{"ENL", -1.301209134724184e+01, -6.631959451764307e+00},
	{"ENM", -1.292174299419862e+01, -6.541611098721093e+00},
	{"ENN", -1.327869069736651e+01, -6.898558801888983e+00},
	{"ENO", -1.008490777907426e+01, -3.704775883596732e+00},
	{"ENP", -1.338432465711734e+01, -7.004192761639818e+00},
	{"ENQ", -1.652862766531723e+01, -1.014849576983970e+01},
	{"ENR", -1.337993280877359e+01, -6.999800913296057e+00},
	{"ENS", -1.053523620726954e+01, -4.155104311792016e+00},
	{"ENT", -7.995040456162442e+00, -1.614908560684913e+00},
	{"ENU", -1.240804932865451e+01, -6.027917433176981e+00},
	{"ENV", -1.451149853182824e+01, -8.131366636350716e+00},
	{"ENW", -1.209979324735660e+01, -5.719661351879067e+00},
	{"ENX", -3.053275038301341e+01, -2.415261848753588e+01},
	{"ENY", -1.356098615557813e+01, -7.180854260100597e+00},
	{"ENZ", -1.745191221274389e+01, -1.107178031726636e+01},
	{"EOA", -1.722026647283739e+01, -9.169824980296514e+00},
	{"EOB", -1.411075410562881e+01, -6.060312613087932e+00},
	{"EOC", -1.490370915640182e+01, -6.853267663860946e+00},
	{"EOD", -1.681579580402630e+01, -8.765354311485423e+00},
	{"EOE", -1.945664001160078e+01, -1.140619851905991e+01},
	{"EOF", -8.966233597145376e+00, -9.157921046045008e-01},
	{"EOG", -1.690861576016852e+01, -8.858174267627644e+00},
	{"EOH", -1.632388502230885e+01, -8.273443529767981e+00},
	{"EOI", -1.655526317466629e+01, -8.504821682125414e+00},
	{"EOJ", -1.980341039420369e+01, -1.175296890166282e+01},
	{"EOK", -1.978794328335817e+01, -1.173750179081730e+01},
	{"EOL", -1.348646961439732e+01, -5.436028121856446e+00},
	{"EOM", -1.671118217361310e+01, -8.660740681072228e+00},
	{"EON", -1.147799792715021e+01, -3.427556434609338e+00},
	{"EOO", -2.146345632077296e+01, -1.341301482823209e+01},
	{"EOP", -1.132926499685557e+01, -3.278823504314695e+00},
	{"EOQ", -3.052312323293318e+01, -2.247268174039230e+01},
	{"EOR", -1.164986738319095e+01, -3.599425890650072e+00},
	{"EOS", -1.783818357548987e+01, -9.787742082948997e+00},
	{"EOT", -1.287262908632114e+01, -4.822187593780263e+00},
	{"EOU", -1.211610844948349e+01, -4.065666956942619e+00},
	{"EOV", -1.357224349315822e+01, -5.521802000617349e+00},
	{"EOW", -1.489498952928444e+01, -6.844548036743570e+00},
	{"EOX", -1.700422038863764e+01, -8.953778896096765e+00},
	{"EOY", -1.961648642204187e+01, -1.156604492950100e+01},
	{"EOZ", -2.271131115130551e+01, -1.466086965876464e+01},
	{"EPA", -1.085056753972515e+01, -2.665214495312930e+00},
	{"EPB", -1.693655494060898e+01, -8.751201896196759e+00},
	{"EPC", -1.754815383417266e+01, -9.362800789760438e+00},
	{"EPD", -1.816344727118294e+01, -9.978094226770715e+00},
	{"EPE", -1.101297323105468e+01, -2.827620186642463e+00},
	{"EPF", -1.657855365019314e+01, -8.393200605780924e+00},
	{"EPG", -1.867265891383364e+01, -1.048730586942142e+01},
	{"EPH", -1.249122992217018e+01, -4.305876877757958e+00},
	{"EPI", -1.266192607125101e+01, -4.476573026838793e+00},
	{"EPJ", -2.091028530907845e+01, -1.272493226466623e+01},
	{"EPK", -2.139509443113284e+01, -1.320974138672062e+01},
	{"EPL", -1.182881375205837e+01, -3.643460707646152e+00},
	{"EPM", -1.655772784721970e+01, -8.372374802807480e+00},
	{"EPN", -1.799015257183641e+01, -9.804799527424192e+00},
	{"EPO", -1.136584836070245e+01, -3.180495316290227e+00},
	{"EPP", -1.621676842499637e+01, -8.031415380584152e+00},
	{"EPQ", -2.091097406280988e+01, -1.272562101839766e+01},
	{"EPR", -1.029810847528726e+01, -2.112755430875037e+00},
	{"EPS", -1.425835026453912e+01, -6.072997220126899e+00},
	{"EPT", -1.181297466067188e+01, -3.627621616259661e+00},
	{"EPU", -1.212962718390028e+01, -3.944274139488062e+00},
	{"EPV", -2.054751923813780e+01, -1.236216619372558e+01},
	{"EPW", -1.625841881830389e+01, -8.073065773891669e+00},
	{"EPX", -3.591811125603196e+01, -2.773275821161974e+01},
	{"EPY", -1.656717678233301e+01, -8.381823737920790e+00},
	{"EPZ", -3.422322688148305e+01, -2.603787383707084e+01},
	{"EQA", -2.716139910280475e+01, -1.565361815371534e+01},
	{"EQB", -2.978882104994704e+01, -1.828104010085762e+01},
	{"EQC", -2.367401383855635e+01, -1.216623288946693e+01},
	{"EQD", -3.031052491003696e+01, -1.880274396094754e+01},
	{"EQE", -3.068983962789877e+01, -1.918205867880935e+01},
	{"EQF", -2.368376665372700e+01, -1.217598570463758e+01},
	{"EQG", -3.577414782781931e+01, -2.426636687872989e+01},
	{"EQH", -2.960888251029694e+01, -1.810110156120752e+01},
	{"EQI", -2.550044311818899e+01, -1.399266216909957e+01},
	{"EQJ", -3.157419428543874e+01, -2.006641333634932e+01},
	{"EQK", -3.740633302275806e+01, -2.589855207366864e+01},
	{"EQL", -2.271010185696259e+01, -1.120232090787317e+01},
	{"EQM", -2.922577919124642e+01, -1.771799824215701e+01},
	{"EQN", -3.205820061856800e+01, -2.055041966947858e+01},
	{"EQO", -3.025464644929344e+01, -1.874686550020402e+01},
	{"EQP", -3.025683183571929e+01, -1.874905088662987e+01},
	{"EQQ", -3.211507642520671e+01, -2.060729547611729e+01},
	{"EQR", -3.010353528717116e+01, -1.859575433808173e+01},
	{"EQS", -2.717584744245990e+01, -1.566806649337049e+01},
	{"EQT", -2.767446010119680e+01, -1.616667915210737e+01},
	{"EQU", -1.150922586419592e+01, -1.444915106499418e-03},
	{"EQV", -3.292844141687660e+01, -2.142066046778718e+01},
	{"EQW", -2.932764128895594e+01, -1.781986033986652e+01},
	{"EQX", -3.942946498064099e+01, -2.792168403155157e+01},
	{"EQY", -3.362218518208778e+01, -2.211440423299835e+01},
	{"EQZ", -4.056903241739152e+01, -2.906125146830210e+01},
	{"ERA", -9.362602566444700e+00, -3.491550307011708e+00},
	{"ERB", -1.189932408474474e+01, -6.028271825311747e+00},
	{"ERC", -1.112809735823384e+01, -5.257045098800843e+00},
	{"ERD", -1.244962554320978e+01, -6.578573283776782e+00},
	{"ERE", -8.023531747675122e+00, -2.152479488242130e+00},
	{"ERF", -1.133017697391961e+01, -5.459124714486622e+00},
	{"ERG", -1.162262502094584e+01, -5.751572761512850e+00},
	{"ERH", -1.128409481930652e+01, -5.413042559873529e+00},
	{"ERI", -9.427532534251595e+00, -3.556480274818602e+00},
	{"ERJ", -1.508568656585707e+01, -9.214634306424079e+00},
	{"ERK", -1.492008372856753e+01, -9.049031469134540e+00},
	{"ERL", -1.222628335813520e+01, -6.355231098702204e+00},
	{"ERM", -1.090709882971279e+01, -5.036046570279792e+00},
	{"ERN", -1.067806796594137e+01, -4.807015706508381e+00},
	{"ERO", -1.010597563221103e+01, -4.234923372778036e+00},
	{"ERP", -1.192103523984225e+01, -6.049982980409258e+00},
	{"ERQ", -1.664184870225198e+01, -1.077079644281899e+01},
	{"ERR", -1.184019293800957e+01, -5.969140678576582e+00},
	{"ERS", -8.907409303424991e+00, -3.036357043991999e+00},
	{"ERT", -9.395547438917099e+00, -3.524495179484107e+00},
	{"ERU", -1.210249783879320e+01, -6.231445579360205e+00},
	{"ERV", -1.111908241770478e+01, -5.248030158271787e+00},
	{"ERW", -1.107668196528661e+01, -5.205629705853623e+00},
	{"ERX", -1.559983061567618e+01, -9.728778356243186e+00},
	{"ERY", -1.048162927932931e+01, -4.610577019896318e+00},
	{"ERZ", -1.881169653611971e+01, -1.294064427668672e+01},
	{"ESA", -9.350663173602300e+00, -3.114527137865421e+00},
	{"ESB", -1.242277700637485e+01, -6.186640970637971e+00},
	{"ESC", -1.147007330991693e+01, -5.233937274180052e+00},
	{"ESD", -1.344351022398997e+01, -7.207374188253090e+00},
	{"ESE", -9.594438155277686e+00, -3.358302119540806e+00},
	{"ESF", -1.237869103914644e+01, -6.142555003409562e+00},
	{"ESG", -1.436307168347257e+01, -8.126935647735692e+00},
	{"ESH", -1.023399698832212e+01, -3.997860952585243e+00},
	{"ESI", -1.015848250666869e+01, -3.922346470931815e+00},
	{"ESJ", -1.629219017291981e+01, -1.005605413718293e+01},
	{"ESK", -1.422668261094254e+01, -7.990546575205664e+00},
	{"ESL", -1.293140756445649e+01, -6.695271528719611e+00},
	{"ESM", -1.266457100526670e+01, -6.428434969529818e+00},
	{"ESN", -1.298551145252626e+01, -6.749375416789377e+00},
	{"ESO", -9.559694809506581e+00, -3.323558773769702e+00},
	{"ESP", -1.098011882679877e+01, -4.743982791061889e+00},
	{"ESQ", -1.558929741279672e+01, -9.353161377059847e+00},
	{"ESR", -1.381901991906604e+01, -7.582883883329163e+00},
	{"ESS", -9.099007261647030e+00, -2.862871225910151e+00},
	{"EST", -8.598473209967313e+00, -2.362337174230434e+00},
	{"ESU", -1.084097061468555e+01, -4.604834578948672e+00},
	{"ESV", -1.574109098693593e+01, -9.504954951199053e+00},
	{"ESW", -1.109381058934219e+01, -4.857674553605308e+00},
	{"ESX", -2.001715167748584e+01, -1.378101564174896e+01},
	{"ESY", -1.380269009338376e+01, -7.566554057646884e+00},
	{"ESZ", -2.039630698551251e+01, -1.416017094977563e+01},
	{"ETA", -1.120913654483024e+01, -4.329446664050659e+00},
	{"ETB", -1.475226981393877e+01, -7.872579933159191e+00},
	{"ETC", -1.328392036591797e+01, -6.404230485138393e+00},
	{"ETD", -1.533441930297900e+01, -8.454729422199422e+00},
	{"ETE", -1.115984000196119e+01, -4.280150121181611e+00},
	{"ETF", -1.413718765823120e+01, -7.257497777451621e+00},
	{"ETG", -1.674020063024758e+01, -9.860510749468000e+00},
	{"ETH", -8.030040413932142e+00, -1.150350533152562e+00},
	{"ETI", -1.112905781232188e+01, -4.249367931542295e+00},
	{"ETJ", -1.799017784274155e+01, -1.111048796196197e+01},
	{"ETK", -1.876324784462802e+01, -1.188355796384844e+01},
	{"ETL", -1.495277343590203e+01, -8.073083555122452e+00},
	{"ETM", -1.439182436527505e+01, -7.512134484495467e+00},
	{"ETN", -1.506720381960987e+01, -8.187513938830293e+00},
	{"ETO", -9.633919831698865e+00, -2.754229950919285e+00},
	{"ETP", -1.569562761489616e+01, -8.815937734116575e+00},
	{"ETQ", -2.091007172518207e+01, -1.403038184440249e+01},
	{"ETR", -1.128654568094479e+01, -4.406855800165207e+00},
	{"ETS", -1.240993646193170e+01, -5.530246581152124e+00},
	{"ETT", -1.104364415213458e+01, -4.163954271355001e+00},
	{"ETU", -1.196245408548924e+01, -5.082764204709656e+00},
	{"ETV", -1.839591094333274e+01, -1.151622106255316e+01},
	{"ETW", -1.158836684253335e+01, -4.708676961753770e+00},
	{"ETX", -2.271803771658902e+01, -1.583834783580944e+01},
	{"ETY", -1.319969581859418e+01, -6.320005937814598e+00},
	{"ETZ", -1.971827324915217e+01, -1.283858336837259e+01},
	{"EUA", -1.941484628348365e+01, -9.369418884276449e+00},
	{"EUB", -1.692996677428963e+01, -6.884539375082428e+00},
	{"EUC", -1.867397044857995e+01, -8.628543049372750e+00},
	{"EUD", -1.759772039941387e+01, -7.552293000206663e+00},
	{"EUE", -1.941571170930364e+01, -9.370284310096434e+00},
	{"EUF", -1.999729300777546e+01, -9.951865608568259e+00},
	{"EUG", -1.880990793099363e+01, -8.764480531786431e+00},
	{"EUH", -2.037964362846181e+01, -1.033421622925460e+01},
	{"EUI", -1.941708555818739e+01, -9.371658158980184e+00},
	{"EUJ", -3.104948624934631e+01, -2.100405885013911e+01},
	{"EUK", -2.360029622546744e+01, -1.355486882626023e+01},
	{"EUL", -1.707086608579895e+01, -7.025438686591746e+00},
	{"EUM", -1.622021101753125e+01, -6.174783618324046e+00},
	{"EUN", -1.126392435940908e+01, -1.218496960201874e+00},
	{"EUO", -1.796188522653628e+01, -7.916457827329074e+00},
	{"EUP", -1.238605463621967e+01, -2.340627237012467e+00},
	{"EUQ", -2.371555302016843e+01, -1.367012562096122e+01},
	{"EUR", -1.366149841999723e+01, -3.616071020790026e+00},
	{"EUS", -1.261501064352482e+01, -2.569583244317615e+00},
	{"EUT", -1.405249731690183e+01, -4.007069917694626e+00},
	{"EUU", -2.369855566650798e+01, -1.365312826730077e+01},
	{"EUV", -1.750895850078347e+01, -7.463531101576265e+00},
	{"EUW", -2.053119893440756e+01, -1.048577153520036e+01},
	{"EUX", -1.867364656956534e+01, -8.628219170358131e+00},
	{"EUY", -2.863406154459009e+01, -1.858863414538289e+01},
	{"EUZ", -2.013100898429465e+01, -1.008558158508745e+01},
	{"EVA", -1.261168370496407e+01, -3.857265712407909e+00},
	{"EVB", -3.178340061367501e+01, -2.302898262111885e+01},
	{"EVC", -2.371412240314496e+01, -1.495970441058880e+01},
	{"EVD", -2.139534421344272e+01, -1.264092622088656e+01},
	{"EVE", -9.279159395579718e+00, -5.247414030235628e-01},
	{"EVF", -3.143612687475709e+01, -2.268170888220094e+01},
	{"EVG", -3.272348076760130e+01, -2.396906277504515e+01},
	{"EVH", -2.271215166214891e+01, -1.395773366959275e+01},
	{"EVI", -1.145770489325839e+01, -2.703286900702233e+00},
	{"EVJ", -2.271737024465472e+01, -1.396295225209856e+01},
	{"EVK", -3.444131121866494e+01, -2.568689322610878e+01},
	{"EVL", -2.371358604440169e+01, -1.495916805184554e+01},
	{"EVM", -2.171625096878693e+01, -1.296183297623077e+01},
	{"EVN", -1.881131289978426e+01, -1.005689490722810e+01},
	{"EVO", -1.242697775094095e+01, -3.672559758384792e+00},
	{"EVP", -3.090677579922420e+01, -2.215235780666805e+01},
	{"EVQ", -3.851359601993498e+01, -2.975917802737882e+01},
	{"EVR", -1.971631449761579e+01, -1.096189650505963e+01},
	{"EVS", -2.369917858632543e+01, -1.494476059376928e+01},
	{"EVT", -2.090696139435663e+01, -1.215254340180047e+01},
	{"EVU", -1.876328827192209e+01, -1.000887027936593e+01},
	{"EVV", -3.340717318554586e+01, -2.465275519298970e+01},
	{"EVW", -3.054218874416050e+01, -2.178777075160435e+01},
	{"EVX", -3.513941683703163e+01, -2.638499884447548e+01},
	{"EVY", -1.901255946329719e+01, -1.025814147074104e+01},
	{"EVZ", -3.854929571958935e+01, -2.979487772703320e+01},
	{"EWA", -9.994380438953524e+00, -1.959693757338284e+00},
	{"EWB", -1.557878063992961e+01, -7.544093958314366e+00},
	{"EWC", -1.526723398167437e+01, -7.232547300059130e+00},
	{"EWD", -1.528365529226521e+01, -7.248968610649967e+00},
	{"EWE", -1.106882762788626e+01, -3.034140946271020e+00},
	{"EWF", -1.579337687911305e+01, -7.758690197497808e+00},
	{"EWG", -1.700390504340621e+01, -8.969218361790970e+00},
	{"EWH", -1.056462953770418e+01, -2.529942856088941e+00},
	{"EWI", -1.050515052020171e+01, -2.470463838586471e+00},
	{"EWJ", -1.689840576239132e+01, -8.863719080776082e+00},
	{"EWK", -1.813334592199249e+01, -1.009865924037725e+01},
	{"EWL", -1.591659648403370e+01, -7.881909802418454e+00},
	{"EWM", -1.492400365413897e+01, -6.889316972523731e+00},
	{"EWN", -1.560452078420226e+01, -7.569834102587019e+00},
	{"EWO", -1.094042974443547e+01, -2.905743062820232e+00},
	{"EWP", -1.599732430424741e+01, -7.962637622632172e+00},
	{"EWQ", -2.013348759843280e+01, -1.209880091681756e+01},
	{"EWR", -1.378462011430778e+01, -5.749933432692536e+00},
	{"EWS", -1.326097650986994e+01, -5.226289828254697e+00},
	{"EWT", -1.389625083682599e+01, -5.861564155210749e+00},
	{"EWU", -1.677577990781181e+01, -8.741093226196572e+00},
	{"EWV", -1.847037525152304e+01, -1.043568856990780e+01},
	{"EWW", -1.490115263356730e+01, -6.866465951952062e+00},
	{"EWX", -3.754853057300435e+01, -2.951384389138910e+01},
	{"EWY", -1.481461137807631e+01, -6.779924696461066e+00},
	{"EWZ", -2.054859431292161e+01, -1.251390763130637e+01},
	{"EXA", -1.313754912444060e+01, -3.249561879768513e+00},
	{"EXB", -2.053444848201088e+01, -1.064646123733879e+01},
	{"EXC", -1.242485647723446e+01, -2.536869232562375e+00},
	{"EXD", -2.011736303622011e+01, -1.022937579154802e+01},
	{"EXE", -1.341873391753467e+01, -3.530746672862580e+00},
	{"EXF", -2.011890910111464e+01, -1.023092185644256e+01},
	{"EXG", -2.138230425342158e+01, -1.149431700874949e+01},
	{"EXH", -1.517340437645059e+01, -5.285417131778501e+00},
	{"EXI", -1.348906189413709e+01, -3.601074649465007e+00},
	{"EXJ", -2.112864015842221e+01, -1.124065291375012e+01},
	{"EXK", -3.012215187017290e+01, -2.023416462550081e+01},
	{"EXL", -2.136010516001454e+01, -1.147211791534246e+01},
	{"EXM", -1.875483893301197e+01, -8.866851688339883e+00},
	{"EXN", -2.071216986692291e+01, -1.082418262225082e+01},
	{"EXO", -1.766532955542281e+01, -7.777342310750720e+00},
	{"EXP", -1.185340183336690e+01, -1.965414588694816e+00},
	{"EXQ", -1.843175005923346e+01, -8.543762814561374e+00},
	{"EXR", -1.906796082640863e+01, -9.179973581736544e+00},
	{"EXS", -1.961448340494922e+01, -9.726496160277131e+00},
	{"EXT", -1.194862960027731e+01, -2.060642355605227e+00},
	{"EXU", -1.620835842607764e+01, -6.320371181405555e+00},
	{"EXV", -1.976932138563762e+01, -9.881334140965532e+00},
	{"EXW", -1.953321762197621e+01, -9.645230377304120e+00},
	{"EXX", -2.132346562765897e+01, -1.143547838298688e+01},
	{"EXY", -2.022965609389503e+01, -1.034166884922294e+01},
	{"EXZ", -3.966138098233927e+01, -2.977339373766717e+01},
	{"EYA", -1.240680090029065e+01, -3.543361455946416e+00},
	{"EYB", -1.403586840295979e+01, -5.172428958615550e+00},
	{"EYC", -1.326773077809032e+01, -4.404291333746080e+00},
	{"EYD", -1.385046702297822e+01, -4.987027578633987e+00},
	{"EYE", -1.154637352957791e+01, -2.682934085233676e+00},
	{"EYF", -1.432036699541101e+01, -5.456927551066769e+00},
	{"EYG", -1.512861331412069e+01, -6.265173869776449e+00},
	{"EYH", -1.273017243679164e+01, -3.866732992447401e+00},
	{"EYI", -1.447663973056977e+01, -5.613200286225529e+00},
	{"EYJ", -1.771666785808654e+01, -8.853228413742302e+00},
	{"EYK", -1.605983791784635e+01, -7.196398473502111e+00},
	{"EYL", -1.479226823283678e+01, -5.928828788492543e+00},
	{"EYM", -1.371332048358622e+01, -4.849881039241985e+00},
	{"EYN", -1.552202853946428e+01, -6.658589095120038e+00},
	{"EYO", -1.164941221411147e+01, -2.785972769767227e+00},
	{"EYP", -1.452199481926543e+01, -5.658555374921193e+00},
	{"EYQ", -2.001556324696784e+01, -1.115212380262360e+01},
	{"EYR", -1.432514286092195e+01, -5.461703416577707e+00},
	{"EYS", -1.204222061506509e+01, -3.178781170720851e+00},
	{"EYT", -1.326476179136241e+01, -4.401322347018172e+00},
	{"EYU", -1.664995272677640e+01, -7.786513282432162e+00},
	{"EYV", -1.722507479105771e+01, -8.361635346713472e+00},
	{"EYW", -1.214453764162611e+01, -3.281098197281869e+00},
	{"EYX", -3.107982067099189e+01, -2.221638122664766e+01},
	{"EYY", -1.862323181390553e+01, -9.759792369561294e+00},
	{"EYZ", -2.370502558385310e+01, -1.484158613950886e+01},
	{"EZA", -1.750499947383499e+01, -3.768043726050267e+00},
	{"EZB", -2.024682343745547e+01, -6.509867689670745e+00},
	{"EZC", -2.090092848278703e+01, -7.163972735002309e+00},
	{"EZD", -2.365738799017987e+01, -9.920432242395151e+00},
	{"EZE", -1.501944845375265e+01, -1.282492705967924e+00},
	{"EZF", -2.054059967422624e+01, -6.803643926441520e+00},
	{"EZG", -2.832754734276242e+01, -1.459059159497770e+01},
	{"EZH", -2.357323422062701e+01, -9.836278472842285e+00},
	{"EZI", -1.672080372338697e+01, -2.983847975602242e+00},
	{"EZJ", -3.085127204491958e+01, -1.711431629713486e+01},
	{"EZK", -2.948677210530593e+01, -1.574981635752121e+01},
	{"EZL", -2.196965049954302e+01, -8.232694751758300e+00},
	{"EZM", -2.209755014450428e+01, -8.360594396719552e+00},
	{"EZN", -2.269368352447817e+01, -8.956727776693448e+00},
	{"EZO", -1.885377971998128e+01, -5.116823972196555e+00},
	{"EZP", -2.037414717375937e+01, -6.637191425974646e+00},
	{"EZQ", -3.476748593424293e+01, -2.103053018645820e+01},
	{"EZR", -1.725580506178208e+01, -3.518849313997356e+00},
	{"EZS", -2.359062521646949e+01, -9.853669468684766e+00},
	{"EZT", -1.969623451354201e+01, -5.959278765757285e+00},
	{"EZU", -1.821528796791396e+01, -4.478332220129236e+00},
	{"EZV", -1.919301081934300e+01, -5.456055071558275e+00},
	{"EZW", -1.953916254433167e+01, -5.802206796546943e+00},
	{"EZX", -3.757562249568777e+01, -2.383866674790304e+01},
	{"EZY", -2.087107914509598e+01, -7.134123397311257e+00},
	{"EZZ", -1.684857077089482e+01, -3.111615023110094e+00},
	{"FAA", -1.727414992700913e+01, -8.559863763541056e+00},
	{"FAB", -1.392332465666373e+01, -5.209038493195653e+00},
	{"FAC", -1.157377785897210e+01, -2.859491695504021e+00},
	{"FAD", -1.455103610279277e+01, -5.836749939324689e+00},
	{"FAE", -1.790846144764078e+01, -9.194175284172703e+00},
	{"FAF", -1.466533563226712e+01, -5.951049468799037e+00},
	{"FAG", -1.453988480744053e+01, -5.825598643972453e+00},
	{"FAH", -1.570650255699537e+01, -6.992216393527287e+00},
	{"FAI", -1.232746892125053e+01, -3.613182757782452e+00},
	{"FAJ", -1.901676934314687e+01, -1.030248317967879e+01},
	{"FAK", -1.780330878685650e+01, -9.089022623388420e+00},
	{"FAL", -1.188454976996808e+01, -3.170263606500000e+00},
	{"FAM", -1.222146186351359e+01, -3.507175700045514e+00},
	{"FAN", -1.166860869891996e+01, -2.954322535451884e+00},
	{"FAO", -2.054290437408354e+01, -1.182861821061546e+01},
	{"FAP", -1.440696989406316e+01, -5.692683730595082e+00},
	{"FAQ", -2.054401328610863e+01, -1.182972712264055e+01},
	{"FAR", -1.210101055185580e+01, -3.386724388387722e+00},
	{"FAS", -1.266257920834830e+01, -3.948293044880224e+00},
	{"FAT", -1.175097144300760e+01, -3.036685279539523e+00},
	{"FAU", -1.474345407931662e+01, -6.029167915848540e+00},
	{"FAV", -1.383054430394616e+01, -5.116258140478084e+00},
	{"FAW", -1.578621313299160e+01, -7.071926969523521e+00},
	{"FAX", -1.758880017197445e+01, -8.874514008506372e+00},
	{"FAY", -1.731464032998291e+01, -8.600354166514835e+00},
	{"FAZ", -1.890965799228555e+01, -1.019537182881747e+01},
	{"FBA", -1.434521656591278e+01, -2.476403883565369e+00},
	{"FBB", -2.668182706592834e+01, -1.481301438358092e+01},
	{"FBC", -1.862819868531950e+01, -6.759386002972087e+00},
	{"FBD", -2.868959951868769e+01, -1.682078683634028e+01},
	{"FBE", -1.369763986243521e+01, -1.828827180087795e+00},
	{"FBF", -3.027411705251257e+01, -1.840530437016515e+01},
	{"FBG", -2.371388968361748e+01, -1.184507700127006e+01},
	{"FBH", -2.911930278701406e+01, -1.725049010466665e+01},
	{"FBI", -1.636308292292993e+01, -4.494270240582512e+00},
	{"FBJ", -2.667701961951694e+01, -1.480820693716953e+01},
	{"FBK", -3.213288239276078e+01, -2.026406971041337e+01},
	{"FBL", -1.611212058455126e+01, -4.243307902203849e+00},
	{"FBM", -2.211603649560830e+01, -1.024722381326089e+01},
	{"FBN", -2.923047052816536e+01, -1.736165784581794e+01},
	{"FBO", -1.497749912599797e+01, -3.108686443650553e+00},
	{"FBP", -2.993702732711606e+01, -1.806821464476864e+01},
	{"FBQ", -3.600027346420784e+01, -2.413146078186044e+01},
	{"FBR", -1.475489178956732e+01, -2.886079107219901e+00},
	{"FBS", -2.329211634617739e+01, -1.142330366382999e+01},
	{"FBT", -2.257119527507972e+01, -1.070238259273231e+01},
	{"FBU", -1.476395278806599e+01, -2.895140105718575e+00},
	{"FBV", -2.991478009365861e+01, -1.804596741131120e+01},
	{"FBW", -2.932334313471498e+01, -1.745453045236756e+01},
	{"FBX", -3.928748130344845e+01, -2.741866862110103e+01},
	{"FBY", -1.635484010551696e+01, -4.486027423169552e+00},
	{"FBZ", -3.379558517921586e+01, -2.192677249686844e+01},
	{"FCA", -1.385110333893023e+01, -2.568418507258045e+00},
	{"FCB", -2.976813168036967e+01, -1.848544684869749e+01},
	{"FCC", -2.103813811773416e+01, -9.755453286061973e+00},
	{"FCD", -2.170781007152040e+01, -1.042512523984821e+01},
	{"FCE", -1.608174761205240e+01, -4.799062780380213e+00},
	{"FCF", -2.962694181411259e+01, -1.834425698244040e+01},
	{"FCG", -2.139445853502923e+01, -1.011177370335704e+01},
	{"FCH", -1.412091584295442e+01, -2.838231011282234e+00},
	{"FCI", -1.571306915595828e+01, -4.430384324286092e+00},
	{"FCJ", -2.371563636317725e+01, -1.243295153150506e+01},
	{"FCK", -2.426091159279079e+01, -1.297822676111861e+01},
	{"FCL", -1.591377131773892e+01, -4.631086486066733e+00},
	{"FCM", -2.369342856109812e+01, -1.241074372942593e+01},
	{"FCN", -2.171535170428220e+01, -1.043266687261001e+01},
	{"FCO", -1.235882893333011e+01, -1.076144101657918e+00},
	{"FCP", -2.367737881049779e+01, -1.239469397882560e+01},
	{"FCQ", -2.893102364765377e+01, -1.764833881598159e+01},
	{"FCR", -1.571500994283260e+01, -4.432325111160412e+00},
	{"FCS", -2.741335781542544e+01, -1.613067298375325e+01},
	{"FCT", -2.304957830269404e+01, -1.176689347102185e+01},
	{"FCU", -1.619830578705479e+01, -4.915620955382601e+00},
	{"FCV", -3.219615553699469e+01, -2.091347070532250e+01},
	{"FCW", -2.790441936633032e+01, -1.662173453465814e+01},
	{"FCX", -2.113363608721471e+01, -9.850951255542521e+00},
	{"FCY", -1.798702309598762e+01, -6.704338264315440e+00},
	{"FCZ", -3.215056109818531e+01, -2.086787626651311e+01},
	{"FDA", -1.448447257569652e+01, -2.319814853234872e+00},
	{"FDB", -2.475338044547146e+01, -1.258872272300981e+01},
	{"FDC", -2.256775324497005e+01, -1.040309552250840e+01},
	{"FDD", -2.569027481004369e+01, -1.352561708758203e+01},
	{"FDE", -1.366263659164273e+01, -1.497978869181072e+00},
	{"FDF", -2.540669570798102e+01, -1.324203798551937e+01},
	{"FDG", -2.613363227866961e+01, -1.396897455620796e+01},
	{"FDH", -2.475973546222220e+01, -1.259507773976054e+01},
	{"FDI", -1.441630836270988e+01, -2.251650640248229e+00},
	{"FDJ", -2.776153026925369e+01, -1.559687254679204e+01},
	{"FDK", -2.893837608962949e+01, -1.677371836716784e+01},
	{"FDL", -2.596219632093277e+01, -1.379753859847112e+01},
	{"FDM", -2.551604020124054e+01, -1.335138247877889e+01},
	{"FDN", -2.578512526379512e+01, -1.362046754133346e+01},
	{"FDO", -1.529697747461804e+01, -3.132319752156388e+00},
	{"FDP", -2.617255613139328e+01, -1.400789840893163e+01},
	{"FDQ", -3.038226762014302e+01, -1.821760989768137e+01},
	{"FDR", -1.615362153053531e+01, -3.988963808073653e+00},
	{"FDS", -2.405044271282184e+01, -1.188578499036019e+01},
	{"FDT", -2.312080320496401e+01, -1.095614548250236e+01},
	{"FDU", -1.648643662248240e+01, -4.321778900020751e+00},
	{"FDV", -2.746753741388999e+01, -1.530287969142834e+01},
	{"FDW", -2.102727053903173e+01, -8.862612816570078e+00},
	{"FDX", -3.528145792141721e+01, -2.311680019895557e+01},
	{"FDY", -2.011254781600591e+01, -7.947890093544263e+00},
	{"FDZ", -3.136389972173571e+01, -1.919924199927406e+01},
	{"FEA", -1.204005698866704e+01, -3.088958156382948e+00},
	{"FEB", -1.558710065193161e+01, -6.636001819647520e+00},
	{"FEC", -1.239615433958332e+01, -3.445055507299224e+00},
	{"FED", -1.384487332350517e+01, -4.893774491221070e+00},
	{"FEE", -1.231839739702999e+01, -3.367298564745894e+00},
	{"FEF", -1.614346581647029e+01, -7.192366984186197e+00},
	{"FEG", -1.461963617973520e+01, -5.668537347451105e+00},
	{"FEH", -1.608550969201740e+01, -7.134410859733310e+00},
	{"FEI", -1.449497805554595e+01, -5.543879223261854e+00},
	{"FEJ", -1.990626135980251e+01, -1.095516252751841e+01},
	{"FEK", -1.953842896242284e+01, -1.058733013013875e+01},
	{"FEL", -1.248259432145654e+01, -3.531495489172448e+00},
	{"FEM", -1.482081329248691e+01, -5.869714460202818e+00},
	{"FEN", -1.280247820974342e+01, -3.851379377459323e+00},
	{"FEO", -1.505772540999846e+01, -6.106626577714364e+00},
	{"FEP", -1.631179489168927e+01, -7.360696059405175e+00},
	{"FEQ", -1.752748885686964e+01, -8.576390024585548e+00},
	{"FER", -1.120856181828128e+01, -2.257462985997181e+00},
	{"FES", -1.335705796631307e+01, -4.405959134028977e+00},
	{"FET", -1.378538865400198e+01, -4.834289821717882e+00},
	{"FEU", -1.560395511656893e+01, -6.652856284284833e+00},
	{"FEV", -1.426035296431992e+01, -5.309254132035820e+00},
	{"FEW", -1.319046821604354e+01, -4.239369383759446e+00},
	{"FEX", -1.496309944086300e+01, -6.012000608578904e+00},
	{"FEY", -1.803380723099940e+01, -9.082708398715310e+00},
	{"FEZ", -1.896301683829098e+01, -1.001191800600688e+01},
	{"FFA", -1.324991588916332e+01, -3.655528524927369e+00},
	{"FFB", -1.659722735331121e+01, -7.002839989075260e+00},
	{"FFC", -1.768793165483248e+01, -8.093544290596526e+00},
	{"FFD", -1.806895094479945e+01, -8.474563580563501e+00},
	{"FFE", -1.108040935951661e+01, -1.486021995280664e+00},
	{"FFF", -1.567311330180562e+01, -6.078725937569675e+00},
	{"FFG", -1.900371664506673e+01, -9.409329280830779e+00},
	{"FFH", -1.634718192677622e+01, -6.752794562540275e+00},
	{"FFI", -1.171414594537378e+01, -2.119758581137832e+00},
	{"FFJ", -2.000140851449155e+01, -1.040702115025560e+01},
	{"FFK", -2.268927882731883e+01, -1.309489146308288e+01},
	{"FFL", -1.457990364389128e+01, -4.985516279655331e+00},
	{"FFM", -1.757958241794388e+01, -7.985195053707930e+00},
	{"FFN", -1.754574978138228e+01, -7.951362417146330e+00},
	{"FFO", -1.287780413569873e+01, -3.283416771462778e+00},
	{"FFP", -1.689437452171189e+01, -7.299987157475939e+00},
	{"FFQ", -2.054750362185089e+01, -1.095311625761494e+01},
	{"FFR", -1.359867166049394e+01, -4.004284296257992e+00},
	{"FFS", -1.515836587988232e+01, -5.563978515646368e+00},
	{"FFT", -1.428976987829944e+01, -4.695382514063485e+00},
	{"FFU", -1.615061595579589e+01, -6.556228591559941e+00},
	{"FFV", -2.169447316207869e+01, -1.210008579784274e+01},
	{"FFW", -1.647734158107897e+01, -6.882954216843015e+00},
	{"FFX", -3.287321387804906e+01, -2.327882651381311e+01},
	{"FFY", -1.828563489665323e+01, -8.691247532417279e+00},
	{"FFZ", -2.900180733757560e+01, -1.940741997333964e+01},
	{"FGA", -1.553685049919387e+01, -3.717623256898829e+00},
	{"FGB", -2.088088470297687e+01, -9.061657460681831e+00},
	{"FGC", -2.670104073740960e+01, -1.488181349511456e+01},
	{"FGD", -2.657165307782782e+01, -1.475242583553279e+01},
	{"FGE", -1.473343946624079e+01, -2.914212223945750e+00},
	{"FGF", -2.625572456611136e+01, -1.443649732381632e+01},
	{"FGG", -2.639721470614955e+01, -1.457798746385452e+01},
	{"FGH", -1.860042418909310e+01, -6.781196946798062e+00},
	{"FGI", -1.604660513659339e+01, -4.227377894298354e+00},
	{"FGJ", -2.992506531409308e+01, -1.810583807179803e+01},
	{"FGK", -3.016337924739032e+01, -1.834415200509527e+01},
	{"FGL", -1.680642601268743e+01, -4.987198770392395e+00},
	{"FGM", -2.620750958171353e+01, -1.438828233941850e+01},
	{"FGN", -2.330795977497812e+01, -1.148873253268308e+01},
	{"FGO", -1.279604588015216e+01, -9.768186378571203e-01},
	{"FGP", -2.669330173861533e+01, -1.487407449632029e+01},
	{"FGQ", -3.145645834200838e+01, -1.963723109971334e+01},
	{"FGR", -1.439011048051829e+01, -2.570883238223254e+00},
	{"FGS", -2.453327850856547e+01, -1.271405126627043e+01},
	{"FGT", -2.364592589076227e+01, -1.182669864846723e+01},
	{"FGU", -1.766289509959807e+01, -5.843667857303035e+00},
	{"FGV", -2.929690012392888e+01, -1.747767288163383e+01},
	{"FGW", -2.587804375190087e+01, -1.405881650960583e+01},
	{"FGX", -3.467527880845574e+01, -2.285605156616070e+01},
	{"FGY", -2.262731099029531e+01, -1.080808374800027e+01},
	{"FGZ", -3.326353232248796e+01, -2.144430508019293e+01},
	{"FHA", -1.410905826243233e+01, -3.489353459921816e+00},
	{"FHB", -2.780070178463338e+01, -1.718099698212286e+01},
	{"FHC", -2.777267789770622e+01, -1.715297309519570e+01},
	{"FHD", -2.825055248416470e+01, -1.763084768165418e+01},
	{"FHE", -1.245621437641322e+01, -1.836509573902703e+00},
	{"FHF", -2.778621911309093e+01, -1.716651431058041e+01},
	{"FHG", -2.269711201200059e+01, -1.207740720949007e+01},
	{"FHH", -2.670805309467802e+01, -1.608834829216750e+01},
	{"FHI", -1.164229609585060e+01, -1.022591293340076e+00},
	{"FHJ", -3.068087156031851e+01, -2.006116675780800e+01},
	{"FHK", -3.101300344793165e+01, -2.039329864542113e+01},
	{"FHL", -2.831177459588092e+01, -1.769206979337039e+01},
	{"FHM", -2.360387505316574e+01, -1.298417025065522e+01},
	{"FHN", -2.822370313139294e+01, -1.760399832888242e+01},
	{"FHO", -1.394867693120285e+01, -3.328972128692336e+00},
	{"FHP", -2.815506088861468e+01, -1.753535608610417e+01},
	{"FHQ", -3.244539795110322e+01, -2.182569314859271e+01},
	{"FHR", -2.611208950131815e+01, -1.549238469880764e+01},
	{"FHS", -2.676044013334437e+01, -1.614073533083385e+01},
	{"FHT", -2.427996062793353e+01, -1.366025582542301e+01},
	{"FHU", -1.550350574615923e+01, -4.883800943648706e+00},
	{"FHV", -3.092813464834345e+01, -2.030842984583293e+01},
	{"FHW", -2.356767667779623e+01, -1.294797187528571e+01},
	{"FHX", -3.644133498004638e+01, -2.582163017753587e+01},
	{"FHY", -1.835545206970825e+01, -7.735747267197732e+00},
	{"FHZ", -3.345321722592009e+01, -2.283351242340957e+01},
	{"FIA", -1.676781654495467e+01, -8.077760847109758e+00},
	{"FIB", -1.710036293167240e+01, -8.410307233827494e+00},
	{"FIC", -1.139755742896511e+01, -2.707501731120200e+00},
	{"FID", -1.440374216045623e+01, -5.713686462611316e+00},
	{"FIE", -1.231313375485801e+01, -3.623078057013101e+00},
	{"FIF", -1.387244049173686e+01, -5.182384793891951e+00},
	{"FIG", -1.316440249845521e+01, -4.474346800610302e+00},
	{"FIH", -1.732477442377229e+01, -8.634718725927373e+00},
	{"FII", -2.365002119016199e+01, -1.495996549231708e+01},
	{"FIJ", -2.212981769879716e+01, -1.343976200095225e+01},
	{"FIK", -1.961965250960292e+01, -1.092959681175800e+01},
	{"FIL", -1.291998295616693e+01, -4.229927258322018e+00},
	{"FIM", -1.549945393816660e+01, -6.809398240321691e+00},
	{"FIN", -1.116507724513569e+01, -2.475021547290780e+00},
	{"FIO", -1.967269660678749e+01, -1.098264090894258e+01},
	{"FIP", -1.988782580216828e+01, -1.119777010432336e+01},
	{"FIQ", -2.929346348648632e+01, -2.060340778864141e+01},
	{"FIR", -1.100451729083156e+01, -2.314461592986651e+00},
	{"FIS", -1.242006070913439e+01, -3.730005011289475e+00},
	{"FIT", -1.210952452699121e+01, -3.419468829146292e+00},
	{"FIU", -2.356351544473324e+01, -1.487345974688832e+01},
	{"FIV", -1.354054943278694e+01, -4.850493734942031e+00},
	{"FIW", -1.690967521377743e+01, -8.219619515932516e+00},
	{"FIX", -1.493722927653534e+01, -6.247173578690429e+00},
	{"FIY", -2.371621402652764e+01, -1.502615832868273e+01},
	{"FIZ", -2.053235104646703e+01, -1.184229534862212e+01},
	{"FJA", -1.527939860254201e+01, -2.671876786304897e+00},
	{"FJB", -2.923998488485329e+01, -1.663246306861617e+01},
	{"FJC", -3.009250879068771e+01, -1.748498697445059e+01},
	{"FJD", -3.198666637295115e+01, -1.937914455671403e+01},
	{"FJE", -1.453840122761496e+01, -1.930879411377840e+00},
	{"FJF", -3.111035226935544e+01, -1.850283045311832e+01},
	{"FJG", -3.069489316549471e+01, -1.808737134925759e+01},
	{"FJH", -2.369923011532953e+01, -1.109170829909242e+01},
	{"FJI", -1.961389886380493e+01, -7.006377047567811e+00},
	{"FJJ", -2.369930975209205e+01, -1.109178793585494e+01},
	{"FJK", -3.257540039635766e+01, -1.996787858012054e+01},
	{"FJL", -3.108423326559426e+01, -1.847671144935715e+01},
	{"FJM", -3.144015863932172e+01, -1.883263682308460e+01},
	{"FJN", -3.439022836797434e+01, -2.178270655173722e+01},
	{"FJO", -1.514130966968114e+01, -2.533787853444028e+00},
	{"FJP", -3.085201090214075e+01, -1.824448908590363e+01},
	{"FJQ", -3.383826264306663e+01, -2.123074082682951e+01},
	{"FJR", -3.006243737988707e+01, -1.745491556364996e+01},
	{"FJS", -3.050122619641569e+01, -1.789370438017857e+01},
	{"FJT", -3.058737493492940e+01, -1.797985311869228e+01},
	{"FJU", -1.393170228887935e+01, -1.324180472642229e+00},
	{"FJV", -3.745731586266748e+01, -2.484979404643037e+01},
	{"FJW", -2.982686170554415e+01, -1.721933988930703e+01},
	{"FJX", -4.013662126973631e+01, -2.752909945349919e+01},
	{"FJY", -3.660649202058092e+01, -2.399897020434381e+01},
	{"FJZ", -3.471149311403936e+01, -2.210397129780224e+01},
	{"FKA", -1.852619389656623e+01, -4.022491315379583e+00},
	{"FKB", -2.674046286668191e+01, -1.223676028549526e+01},
	{"FKC", -2.717233624900570e+01, -1.266863366781905e+01},
	{"FKD", -2.780438745294343e+01, -1.330068487175678e+01},
	{"FKE", -1.723876614997279e+01, -2.735063568786138e+00},
	{"FKF", -2.663687120480405e+01, -1.213316862361740e+01},
	{"FKG", -2.890947198212119e+01, -1.440576940093455e+01},
	{"FKH", -2.087917758469168e+01, -6.375475003505032e+00},
	{"FKI", -1.561739273003143e+01, -1.113690148844781e+00},
	{"FKJ", -3.048764646352164e+01, -1.598394388233499e+01},
	{"FKK", -2.981470961914862e+01, -1.531100703796197e+01},
	{"FKL", -2.619800511610136e+01, -1.169430253491470e+01},
	{"FKM", -2.717237375804607e+01, -1.266867117685942e+01},
	{"FKN", -1.709320264138023e+01, -2.589500060193584e+00},
	{"FKO", -1.812130922151321e+01, -3.617606640326568e+00},
	{"FKP", -2.752331340351225e+01, -1.301961082232560e+01},
	{"FKQ", -3.316678625809472e+01, -1.866308367690806e+01},
	{"FKR", -2.795891769901704e+01, -1.345521511783039e+01},
	{"FKS", -2.407722398122949e+01, -9.573521400042839e+00},
	{"FKT", -2.484211148840867e+01, -1.033840890722202e+01},
	{"FKU", -1.858591131646694e+01, -4.082208735280290e+00},
	{"FKV", -3.032780152936633e+01, -1.582409894817968e+01},
	{"FKW", -2.258027590531941e+01, -8.076573324132761e+00},
	{"FKX", -3.413883312398797e+01, -1.963513054280132e+01},
	{"FKY", -2.668384088904926e+01, -1.218013830786261e+01},
	{"FKZ", -3.224069600985771e+01, -1.773699342867106e+01},
	{"FLA", -1.266022173468303e+01, -2.349877872345273e+00},
	{"FLB", -2.565339871298143e+01, -1.534305485064367e+01},
	{"FLC", -2.109325764985544e+01, -1.078291378751768e+01},
	{"FLD", -2.356632179008819e+01, -1.325597792775042e+01},
	{"FLE", -1.231164572016317e+01, -2.001301857825403e+00},
	{"FLF", -2.540466333231302e+01, -1.509431946997525e+01},
	{"FLG", -2.708954916911270e+01, -1.677920530677494e+01},
	{"FLH", -2.652141239555547e+01, -1.621106853321771e+01},
	{"FLI", -1.275159878937399e+01, -2.441254927036229e+00},
	{"FLJ", -2.981689742357352e+01, -1.950655356123576e+01},
	{"FLK", -2.709316629094902e+01, -1.678282242861125e+01},
	{"FLL", -2.152035340462242e+01, -1.121000954228465e+01},
	{"FLM", -2.616863490238175e+01, -1.585829104004398e+01},
	{"FLN", -2.687804868419368e+01, -1.656770482185592e+01},
	{"FLO", -1.245459406770805e+01, -2.144250205370291e+00},
	{"FLP", -2.615386068164526e+01, -1.584351681930750e+01},
	{"FLQ", -3.091028104123077e+01, -2.059993717889301e+01},
	{"FLR", -2.668491562610065e+01, -1.637457176376289e+01},
	{"FLS", -2.445113926412653e+01, -1.414079540178876e+01},
	{"FLT", -2.176921918302287e+01, -1.145887532068510e+01},
	{"FLU", -1.371122416232458e+01, -3.400880299986823e+00},
	{"FLV", -2.645378748566329e+01, -1.614344362332552e+01},
	{"FLW", -2.259095954663163e+01, -1.228061568429387e+01},
	{"FLX", -3.421224922535827e+01, -2.390190536302051e+01},
	{"FLY", -1.471561093383970e+01, -4.405267071501942e+00},
	{"FLZ", -3.287373969847404e+01, -2.256339583613628e+01},
	{"FMA", -1.257311653834371e+01, -1.622227745082951e+00},
	{"FMB", -2.180803718977347e+01, -1.085714839651271e+01},
	{"FMC", -2.000474554678621e+01, -9.053856753525451e+00},
	{"FMD", -1.737705442789900e+01, -6.426165634638241e+00},
	{"FME", -1.344068169227985e+01, -2.489792899019090e+00},
	{"FMF", -2.165747067648616e+01, -1.070658188322541e+01},
	{"FMG", -2.267949141376748e+01, -1.172860262050672e+01},
	{"FMH", -2.342486794445628e+01, -1.247397915119552e+01},
	{"FMI", -1.401281336553047e+01, -3.061924572269721e+00},
	{"FMJ", -2.368946048478724e+01, -1.273857169152648e+01},
	{"FMK", -2.962831275835522e+01, -1.867742396509447e+01},
	{"FML", -2.000817990280105e+01, -9.057291109540293e+00},
	{"FMM", -1.934525255812249e+01, -8.394363764861735e+00},
	{"FMN", -1.924697685542282e+01, -8.296088062162060e+00},
	{"FMO", -1.381421742498839e+01, -2.863328631727640e+00},
	{"FMP", -2.084479580000599e+01, -9.893907006745238e+00},
	{"FMQ", -3.224073448356921e+01, -2.128984569030845e+01},
	{"FMR", -1.730697329703079e+01, -6.356084503770035e+00},
	{"FMS", -2.042367819592359e+01, -9.472789402662833e+00},
	{"FMT", -1.963151744449900e+01, -8.680628651238250e+00},
	{"FMU", -1.597941338250227e+01, -5.028524589241516e+00},
	{"FMV", -2.212135251403972e+01, -1.117046372077897e+01},
	{"FMW", -2.251468587817592e+01, -1.156379708491516e+01},
	{"FMX", -3.388042394052267e+01, -2.292953514726192e+01},
	{"FMY", -1.352296472942113e+01, -2.572075936160374e+00},
	{"FMZ", -3.250949805954955e+01, -2.155860926628879e+01},
	{"FNA", -1.452916394374907e+01, -1.956720242921022e+00},
	{"FNB", -2.166778109399117e+01, -9.095337393163128e+00},
	{"FNC", -2.460011492551115e+01, -1.202767122468310e+01},
	{"FND", -2.246036851805734e+01, -9.887924817229299e+00},
	{"FNE", -1.430682481554011e+01, -1.734381114712062e+00},
	{"FNF", -2.628129698941867e+01, -1.370885328859063e+01},
	{"FNG", -2.334927855340982e+01, -1.077683485258177e+01},
	{"FNH", -2.599560539282276e+01, -1.342316169199472e+01},
	{"FNI", -1.656261303480801e+01, -3.990169333979960e+00},
	{"FNJ", -2.868809192314052e+01, -1.611564822231247e+01},
	{"FNK", -2.734533661072494e+01, -1.477289290989690e+01},
	{"FNL", -2.675058123097514e+01, -1.417813753014710e+01},
	{"FNM", -2.354648611729693e+01, -1.097404241646888e+01},
	{"FNN", -2.665192964692673e+01, -1.407948594609868e+01},
	{"FNO", -1.421864375039170e+01, -1.646200049563652e+00},
	{"FNP", -2.719121932265097e+01, -1.461877562182292e+01},
	{"FNQ", -2.959890686233158e+01, -1.702646316150353e+01},
	{"FNR", -2.775755216186535e+01, -1.518510846103731e+01},
	{"FNS", -2.411855122861502e+01, -1.154610752778697e+01},
	{"FNT", -2.172382278525787e+01, -9.151379084429827e+00},
	{"FNU", -1.683420379369568e+01, -4.261760092867633e+00},
	{"FNV", -2.784342623841378e+01, -1.527098253758574e+01},
	{"FNW", -2.348003206718918e+01, -1.090758836636113e+01},
	{"FNX", -3.165548100451428e+01, -1.908303730368624e+01},
	{"FNY", -2.622061649726869e+01, -1.364817279644065e+01},
	{"FNZ", -3.216418604829388e+01, -1.959174234746583e+01},
	{"FOA", -1.831274186936731e+01, -1.051539690127444e+01},
	{"FOB", -1.668127449833570e+01, -8.883929530242828e+00},
	{"FOC", -1.600184765127131e+01, -8.204502683178429e+00},
	{"FOD", -1.942224915765469e+01, -1.162490418956181e+01},
	{"FOE", -1.629100758526766e+01, -8.493662617174792e+00},
	{"FOF", -1.400382212301269e+01, -6.206477154919818e+00},
	{"FOG", -1.762684930652548e+01, -9.829504338432601e+00},
	{"FOH", -1.875110866139940e+01, -1.095376369330653e+01},
	{"FOI", -1.723739793273845e+01, -9.440052964645577e+00},
	{"FOJ", -2.265858978614110e+01, -1.486124481804823e+01},
	{"FOK", -2.340658797702563e+01, -1.560924300893276e+01},
	{"FOL", -1.241165310383830e+01, -4.614308135745422e+00},
	{"FOM", -1.852450049653497e+01, -1.072715552844210e+01},
	{"FON", -1.392132137175367e+01, -6.123976403660791e+00},
	{"FOO", -1.262554179943755e+01, -4.828196831344677e+00},
	{"FOP", -1.614425188481605e+01, -8.346906916723173e+00},
	{"FOQ", -3.058733972380802e+01, -2.278999475571515e+01},
	{"FOR", -8.178864800209118e+00, -3.815198321162415e-01},
	{"FOS", -1.726129642843940e+01, -9.463951460346525e+00},
	{"FOT", -1.594534185501416e+01, -8.147996886921286e+00},
	{"FOU", -1.109060275043838e+01, -3.293257782345506e+00},
	{"FOV", -1.764257933530330e+01, -9.845234367210423e+00},
	{"FOW", -1.638701889043493e+01, -8.589673922342060e+00},
	{"FOX", -1.699055188527320e+01, -9.193206917180325e+00},
	{"FOY", -2.165904219888783e+01, -1.386169723079496e+01},
	{"FOZ", -2.370442047936614e+01, -1.590707551127327e+01},
	{"FPA", -1.405414895879527e+01, -2.571227311019265e+00},
	{"FPB", -2.843710983011810e+01, -1.695418818234210e+01},
	{"FPC", -2.933298163981713e+01, -1.785005999204113e+01},
	{"FPD", -2.986498645913626e+01, -1.838206481136025e+01},
	{"FPE", -1.410754202025290e+01, -2.624620372476890e+00},
	{"FPF", -2.841333349994205e+01, -1.693041185216605e+01},
	{"FPG", -2.922102833224806e+01, -1.773810668447206e+01},
	{"FPH", -1.582695902361528e+01, -4.344037375839270e+00},
	{"FPI", -1.632011945415129e+01, -4.837197806375277e+00},
	{"FPJ", -3.204528563251347e+01, -2.056236398473746e+01},
	{"FPK", -3.192820624053237e+01, -2.044528459275636e+01},
	{"FPL", -1.562470768386443e+01, -4.141786036088418e+00},
	{"FPM", -2.763173150667729e+01, -1.614880985890128e+01},
	{"FPN", -2.976457034121703e+01, -1.828164869344102e+01},
	{"FPO", -1.408076822805308e+01, -2.597846580277073e+00},
	{"FPP", -2.424871510185019e+01, -1.276579345407418e+01},
	{"FPQ", -3.330155629817461e+01, -2.181863465039860e+01},
	{"FPR", -1.334273390482829e+01, -1.859812257052281e+00},
	{"FPS", -2.085530456624333e+01, -9.372382918467322e+00},
	{"FPT", -2.060096324669055e+01, -9.118041598914544e+00},
	{"FPU", -1.513558867715896e+01, -3.652667029382949e+00},
	{"FPV", -3.145952393341825e+01, -1.997660228564224e+01},
	{"FPW", -2.766128129302355e+01, -1.617835964524754e+01},
	{"FPX", -3.680273500358241e+01, -2.531981335580641e+01},
	{"FPY", -1.912785656137208e+01, -7.644934913596078e+00},
	{"FPZ", -3.510785062903351e+01, -2.362492898125750e+01},
	{"FQA", -2.364189267982787e+01, -6.891344528368646e+00},
	{"FQB", -3.038255072905590e+01, -1.363200257759668e+01},
	{"FQC", -2.172021622179961e+01, -4.969668070340381e+00},
	{"FQD", -3.090425458914583e+01, -1.415370643768660e+01},
	{"FQE", -3.129214913329008e+01, -1.454160098183085e+01},
	{"FQF", -2.271595585687044e+01, -5.965407705411209e+00},
	{"FQG", -3.636787750692819e+01, -1.961732935546896e+01},
	{"FQH", -3.020261218940581e+01, -1.345206403794658e+01},
	{"FQI", -2.609417279729787e+01, -9.343624645838640e+00},
	{"FQJ", -3.216792396454760e+01, -1.541737581308838e+01},
	{"FQK", -3.800006270186692e+01, -2.124951455040770e+01},
	{"FQL", -3.064499976284881e+01, -1.389445161138958e+01},
	{"FQM", -2.981795934605268e+01, -1.306741119459345e+01},
	{"FQN", -3.265193029767687e+01, -1.590138214621764e+01},
	{"FQO", -3.084837612840231e+01, -1.409782797694308e+01},
	{"FQP", -3.084108815563206e+01, -1.409054000417284e+01},
	{"FQQ", -3.273196446356526e+01, -1.598141631210603e+01},
	{"FQR", -3.069726496628003e+01, -1.394671681482080e+01},
	{"FQS", -2.776957712156877e+01, -1.101902897010955e+01},
	{"FQT", -2.826924812550308e+01, -1.151869997404386e+01},
	{"FQU", -1.683905963286985e+01, -8.851148141062382e-02},
	{"FQV", -3.356311814391854e+01, -1.681256999245931e+01},
	{"FQW", -2.992137096806481e+01, -1.317082281660559e+01},
	{"FQX", -4.002319465974986e+01, -2.327264650829064e+01},
	{"FQY", -3.421591486119664e+01, -1.746536670973742e+01},
	{"FQZ", -4.116276209650039e+01, -2.441221394504117e+01},
	{"FRA", -1.219107032730613e+01, -3.239589690322342e+00},
	{"FRB", -2.631574018003501e+01, -1.736425954305123e+01},
	{"FRC", -2.530726628191167e+01, -1.635578564492788e+01},
	{"FRD", -2.435573174629636e+01, -1.540425110931257e+01},
	{"FRE", -1.131722262145693e+01, -2.365741984473146e+00},
	{"FRF", -2.614515612506450e+01, -1.719367548808071e+01},
	{"FRG", -2.576854017076970e+01, -1.681705953378592e+01},
	{"FRH", -1.858075161925332e+01, -9.629270982269535e+00},
	{"FRI", -1.260406288213131e+01, -3.652582245147522e+00},
	{"FRJ", -2.923851061747048e+01, -2.028702998048669e+01},
	{"FRK", -2.610593702903137e+01, -1.715445639204758e+01},
	{"FRL", -2.597323107974318e+01, -1.702175044275939e+01},
	{"FRM", -2.498112880840443e+01, -1.602964817142065e+01},
	{"FRN", -2.503636765517739e+01, -1.608488701819360e+01},
	{"FRO", -9.718820450167421e+00, -7.673398131836351e-01},
	{"FRP", -2.623900275786114e+01, -1.728752212087736e+01},
	{"FRQ", -3.062504674771125e+01, -2.167356611072746e+01},
	{"FRR", -2.550827353524773e+01, -1.655679289826395e+01},
	{"FRS", -2.273182783264788e+01, -1.378034719566410e+01},
	{"FRT", -2.203980127949242e+01, -1.308832064250863e+01},
	{"FRU", -1.398527658589732e+01, -5.033795948913539e+00},
	{"FRV", -2.655570273343453e+01, -1.760422209645075e+01},
	{"FRW", -2.591144810165799e+01, -1.695996746467421e+01},
	{"FRX", -3.129017292047070e+01, -2.233869228348691e+01},
	{"FRY", -1.893744378486201e+01, -9.985963147878223e+00},
	{"FRZ", -3.222129545431696e+01, -2.326981481733317e+01},
	{"FSA", -1.428509372354133e+01, -3.474585258667284e+00},
	{"FSB", -1.977204126593692e+01, -8.961532801062873e+00},
	{"FSC", -1.541644668606562e+01, -4.605938221191574e+00},
	{"FSD", -2.253992663346148e+01, -1.172941816858743e+01},
	{"FSE", -1.378970585398616e+01, -2.979197389112114e+00},
	{"FSF", -2.020267668619999e+01, -9.392168221325939e+00},
	{"FSG", -2.052356369189791e+01, -9.713055227023858e+00},
	{"FSH", -1.403966309537670e+01, -3.229154630502649e+00},
	{"FSI", -1.422128332447724e+01, -3.410774859603189e+00},
	{"FSJ", -2.842708039582790e+01, -1.761657193095386e+01},
	{"FSK", -1.839229725732548e+01, -7.581788792451432e+00},
	{"FSL", -1.631483926051695e+01, -5.504330795642900e+00},
	{"FSM", -1.674810580448779e+01, -5.937597339613741e+00},
	{"FSN", -1.870507576617336e+01, -7.894567301299309e+00},
	{"FSO", -1.347171113454403e+01, -2.661202669669979e+00},
	{"FSP", -1.473922069104550e+01, -3.928712226171457e+00},
	{"FSQ", -1.788479134389580e+01, -7.074282879021757e+00},
	{"FSR", -1.857882010551189e+01, -7.768311640637847e+00},
	{"FSS", -2.005824509775400e+01, -9.247736632879951e+00},
	{"FST", -1.385746613090592e+01, -3.046957666031869e+00},
	{"FSU", -1.408239753521608e+01, -3.271889070342032e+00},
	{"FSV", -2.362232414553847e+01, -1.281181568066442e+01},
	{"FSW", -1.706306414247916e+01, -6.252555677605114e+00},
	{"FSX", -3.040064050887400e+01, -1.959013204399995e+01},
	{"FSY", -1.701623309446080e+01, -6.205724629586756e+00},
	{"FSZ", -3.186361498098413e+01, -2.105310651611008e+01},
	{"FTA", -1.427488924273666e+01, -6.483445534861533e+00},
	{"FTB", -1.646856777866226e+01, -8.677124070787132e+00},
	{"FTC", -1.780638776736462e+01, -1.001494405948949e+01},
	{"FTD", -1.801429171428579e+01, -1.022284800641066e+01},
	{"FTE", -1.101204610906556e+01, -3.220602401190429e+00},
	{"FTF", -1.679747012315633e+01, -9.006026415281198e+00},
	{"FTG", -1.810092415150681e+01, -1.030948044363168e+01},
	{"FTH", -8.131761673610720e+00, -3.403179657355921e-01},
	{"FTI", -1.428783817326220e+01, -6.496394465387068e+00},
	{"FTJ", -2.071444940564394e+01, -1.292300569776881e+01},
	{"FTK", -2.112732778014916e+01, -1.333588407227402e+01},
	{"FTL", -1.671513815704140e+01, -8.923694449166270e+00},
	{"FTM", -1.746654253869654e+01, -9.675098830821414e+00},
	{"FTN", -1.730698250463058e+01, -9.515538796755454e+00},
	{"FTO", -1.354045567419684e+01, -5.749011966321711e+00},
	{"FTP", -1.807103162963156e+01, -1.027958792175643e+01},
	{"FTQ", -3.105432195789115e+01, -2.326287825001603e+01},
	{"FTR", -1.414540784738222e+01, -6.353964139507091e+00},
	{"FTS", -1.499814956081865e+01, -7.206705852943517e+00},
	{"FTT", -1.479606886858581e+01, -7.004625160710684e+00},
	{"FTU", -1.579115803207020e+01, -7.999714324195069e+00},
	{"FTV", -2.170986520958245e+01, -1.391842150170732e+01},
	{"FTW", -1.446717993648816e+01, -6.675736228613029e+00},
	{"FTX", -3.377118219763564e+01, -2.597973848976051e+01},
	{"FTY", -1.461698870980456e+01, -6.825545001929427e+00},
	{"FTZ", -3.124441565459651e+01, -2.345297194672137e+01},
	{"FUA", -2.235577953276904e+01, -1.209739749354523e+01},
	{"FUB", -2.491350195445759e+01, -1.465511991523378e+01},
	{"FUC", -1.666606995647986e+01, -6.407687917256050e+00},
	{"FUD", -2.126991450835042e+01, -1.101153246912660e+01},
	{"FUE", -1.768402144808295e+01, -7.425639408859141e+00},
	{"FUF", -2.135547879516221e+01, -1.109709675593840e+01},
	{"FUG", -1.562717826057699e+01, -5.368796221353175e+00},
	{"FUH", -2.359244303698608e+01, -1.333406099776226e+01},
	{"FUI", -2.458391811625156e+01, -1.432553607702775e+01},
	{"FUJ", -3.145642576946958e+01, -2.119804373024577e+01},
	{"FUK", -2.111830637353192e+01, -1.085992433430810e+01},
	{"FUL", -1.107526634446027e+01, -8.168843052364546e-01},
	{"FUM", -1.774971768523907e+01, -7.491335646015258e+00},
	{"FUN", -1.344550509919832e+01, -3.187123059974507e+00},
	{"FUO", -2.363605724475200e+01, -1.337767520552819e+01},
	{"FUP", -1.667415313338357e+01, -6.415771094159759e+00},
	{"FUQ", -3.287848924508740e+01, -2.262010720586359e+01},
	{"FUR", -1.342343761340130e+01, -3.165055574177486e+00},
	{"FUS", -1.352049633512094e+01, -3.262114295897129e+00},
	{"FUT", -1.477423196640717e+01, -4.515849927183356e+00},
	{"FUU", -3.026119775382932e+01, -2.000281571460551e+01},
	{"FUV", -2.960349540396610e+01, -1.934511336474229e+01},
	{"FUW", -2.728358661162840e+01, -1.702520457240459e+01},
	{"FUX", -2.987898626451128e+01, -1.962060422528747e+01},
	{"FUY", -2.902998125304010e+01, -1.877159921381628e+01},
	{"FUZ", -1.919413441671772e+01, -8.935752377493911e+00},
	{"FVA", -1.588705528532844e+01, -2.102524840564771e+00},
	{"FVB", -3.280262120763063e+01, -1.901809076286696e+01},
	{"FVC", -3.295041156207215e+01, -1.916588111730849e+01},
	{"FVD", -3.222210352261645e+01, -1.843757307785278e+01},
	{"FVE", -1.607286464140879e+01, -2.288334196645120e+00},
	{"FVF", -3.242269236925237e+01, -1.863816192448870e+01},
	{"FVG", -3.375978930132388e+01, -1.997525885656021e+01},
	{"FVH", -3.147463027675234e+01, -1.769009983198866e+01},
	{"FVI", -1.502661894048451e+01, -1.242088495720841e+00},
	{"FVJ", -3.368264700196450e+01, -1.989811655720083e+01},
	{"FVK", -3.556224762474282e+01, -2.177771717997915e+01},
	{"FVL", -3.283449069642833e+01, -1.904996025166465e+01},
	{"FVM", -3.184495347805648e+01, -1.806042303329281e+01},
	{"FVN", -3.094336136352488e+01, -1.715883091876121e+01},
	{"FVO", -1.663638946869961e+01, -2.851859023935939e+00},
	{"FVP", -3.191760048313829e+01, -1.813307003837462e+01},
	{"FVQ", -3.951444239807830e+01, -2.572991195331463e+01},
	{"FVR", -2.369950851857958e+01, -9.914978073815909e+00},
	{"FVS", -3.090147647631948e+01, -1.711694603155581e+01},
	{"FVT", -3.022732112296232e+01, -1.644279067819865e+01},
	{"FVU", -2.980863627628687e+01, -1.602410583152319e+01},
	{"FVV", -3.440801956368919e+01, -2.062348911892551e+01},
	{"FVW", -3.153533239969332e+01, -1.775080195492965e+01},
	{"FVX", -3.614026321517496e+01, -2.235573277041129e+01},
	{"FVY", -2.796310565114553e+01, -1.417857520638186e+01},
	{"FVZ", -3.955014209773268e+01, -2.576561165296901e+01},
	{"FWA", -1.338945742623911e+01, -1.852612056876769e+00},
	{"FWB", -2.807264485800999e+01, -1.653579948864766e+01},
	{"FWC", -2.813053647693729e+01, -1.659369110757494e+01},
	{"FWD", -2.764299088108231e+01, -1.610614551171997e+01},
	{"FWE", -1.452622334753314e+01, -2.989377978170800e+00},
	{"FWF", -2.792561426319673e+01, -1.638876889383439e+01},
	{"FWG", -2.905235769318239e+01, -1.751551232382005e+01},
	{"FWH", -1.319482211863566e+01, -1.657976749273320e+00},
	{"FWI", -1.432574876366261e+01, -2.788903394300267e+00},
	{"FWJ", -3.040905215599980e+01, -1.887220678663746e+01},
	{"FWK", -3.056406461952582e+01, -1.902721925016348e+01},
	{"FWL", -2.699409688002730e+01, -1.545725151066495e+01},
	{"FWM", -2.769385634277494e+01, -1.615701097341260e+01},
	{"FWN", -2.456909613037934e+01, -1.303225076101699e+01},
	{"FWO", -1.466285246013580e+01, -3.126007090773465e+00},
	{"FWP", -2.878051345983287e+01, -1.724366809047054e+01},
	{"FWQ", -3.303641392987583e+01, -2.149956856051348e+01},
	{"FWR", -1.732357636017256e+01, -5.786730990810224e+00},
	{"FWS", -2.582939142630632e+01, -1.429254605694398e+01},
	{"FWT", -2.569914458819147e+01, -1.416229921882914e+01},
	{"FWU", -2.270245457468553e+01, -1.116560920532319e+01},
	{"FWV", -3.088658729252100e+01, -1.934974192315866e+01},
	{"FWW", -2.691860673161128e+01, -1.538176136224895e+01},
	{"FWX", -4.023022019600123e+01, -2.869337482663889e+01},
	{"FWY", -2.038889179429216e+01, -8.852046424929824e+00},
	{"FWZ", -3.375320384664039e+01, -2.221635847727805e+01},
	{"FXA", -2.305796427757295e+01, -3.996044621780221e+00},
	{"FXB", -2.899760272279390e+01, -9.935683067001172e+00},
	{"FXC", -2.395860238034405e+01, -4.896682724551322e+00},
	{"FXD", -2.838930479885725e+01, -9.327385143064516e+00},
	{"FXE", -2.062041641198266e+01, -1.558496756189932e+00},
	{"FXF", -2.853310034176935e+01, -9.471180685976620e+00},
	{"FXG", -2.983216488188511e+01, -1.077024522609238e+01},
	{"FXH", -2.619033870774842e+01, -7.128419051955691e+00},
	{"FXI", -2.403054978968317e+01, -4.968630133890438e+00},
	{"FXJ", -3.104513400790902e+01, -1.198321435211629e+01},
	{"FXK", -3.194322029835541e+01, -1.288130064256268e+01},
	{"FXL", -2.849045431517888e+01, -9.428534659386148e+00},
	{"FXM", -2.777363993317338e+01, -8.711720277380648e+00},
	{"FXN", -3.028265798973005e+01, -1.122073833393732e+01},
	{"FXO", -2.678801109624867e+01, -7.726091440455938e+00},
	{"FXP", -2.340639938693189e+01, -4.344479731139164e+00},
	{"FXQ", -2.994542965762217e+01, -1.088351000182944e+01},
	{"FXR", -2.058668902323266e+01, -1.524769367439926e+00},
	{"FXS", -2.785550250958651e+01, -8.793582853793783e+00},
	{"FXT", -2.320553424355075e+01, -4.143614587758020e+00},
	{"FXU", -2.706849984309532e+01, -8.006580187302593e+00},
	{"FXV", -2.669015404892488e+01, -7.628234393132148e+00},
	{"FXW", -2.787804944527604e+01, -8.816129789483309e+00},
	{"FXX", -2.365633215454025e+01, -4.594412498747523e+00},
	{"FXY", -2.766268814115871e+01, -8.600768485365986e+00},
	{"FXZ", -4.148244941052177e+01, -2.242052975472904e+01},
	{"FYA", -1.688570175933700e+01, -4.706324045768302e+00},
	{"FYB", -2.015847313171316e+01, -7.979095418144458e+00},
	{"FYC", -2.226989872791873e+01, -1.009052101435002e+01},
	{"FYD", -1.883275779337044e+01, -6.653380079801743e+00},
	{"FYE", -1.532788688585989e+01, -3.148509172291186e+00},
	{"FYF", -2.228250746224109e+01, -1.010312974867239e+01},
	{"FYG", -2.021735286006462e+01, -8.037975146495921e+00},
	{"FYH", -1.774651328940188e+01, -5.567135575833182e+00},
	{"FYI", -1.626545204803178e+01, -4.086074334463081e+00},
	{"FYJ", -2.740001349047806e+01, -1.522063577690936e+01},
	{"FYK", -2.719669671048303e+01, -1.501731899691432e+01},
	{"FYL", -2.477830922255472e+01, -1.259893150898602e+01},
	{"FYM", -1.868563585863211e+01, -6.506258145063406e+00},
	{"FYN", -2.130277104234044e+01, -9.123393328771737e+00},
	{"FYO", -1.284312922402076e+01, -6.637515104520568e-01},
	{"FYP", -1.994431785881792e+01, -7.764940145249219e+00},
	{"FYQ", -2.931644464857090e+01, -1.713706693500220e+01},
	{"FYR", -2.238527107378071e+01, -1.020589336021201e+01},
	{"FYS", -2.025601131708910e+01, -8.076633603520403e+00},
	{"FYT", -1.586569903426065e+01, -3.686321320691952e+00},
	{"FYU", -1.970017596846130e+01, -7.520798254892601e+00},
	{"FYV", -2.089189661318289e+01, -8.712518899614196e+00},
	{"FYW", -2.088635992568869e+01, -8.706982212119994e+00},
	{"FYX", -3.139937581404954e+01, -1.921999810048084e+01},
	{"FYY", -1.912473805074686e+01, -6.945360337178164e+00},
	{"FYZ", -3.073343796034645e+01, -1.855406024677776e+01},
	{"FZA", -1.814805214201539e+01, -2.957539026696131e+00},
	{"FZB", -2.836762861975150e+01, -1.317711550443224e+01},
	{"FZC", -2.925254343799308e+01, -1.406203032267381e+01},
	{"FZD", -2.961170927939591e+01, -1.442119616407665e+01},
	{"FZE", -1.655763808363925e+01, -1.367124968319992e+00},
	{"FZF", -2.919884084577050e+01, -1.400832773045124e+01},
	{"FZG", -2.972181001889772e+01, -1.453129690357846e+01},
	{"FZH", -2.833854714904761e+01, -1.314803403372834e+01},
	{"FZI", -1.678980957587917e+01, -1.599296460559907e+00},
	{"FZJ", -3.224553472105488e+01, -1.705502160573562e+01},
	{"FZK", -3.088103478144124e+01, -1.569052166612197e+01},
	{"FZL", -2.657126991808769e+01, -1.138075680276843e+01},
	{"FZM", -2.877952584777771e+01, -1.358901273245845e+01},
	{"FZN", -2.988235347639736e+01, -1.469184036107809e+01},
	{"FZO", -1.861571943247354e+01, -3.425206317154274e+00},
	{"FZP", -2.769791819662755e+01, -1.250740508130829e+01},
	{"FZQ", -3.616174861037823e+01, -2.097123549505897e+01},
	{"FZR", -2.691067484662992e+01, -1.172016173131066e+01},
	{"FZS", -2.090718924452732e+01, -5.716676129208062e+00},
	{"FZT", -2.702942987080916e+01, -1.183891675548990e+01},
	{"FZU", -1.989886865138229e+01, -4.708355536063030e+00},
	{"FZV", -2.932922941452253e+01, -1.413871629920327e+01},
	{"FZW", -2.799140069323659e+01, -1.280088757791733e+01},
	{"FZX", -3.896988517182307e+01, -2.377937205650381e+01},
	{"FZY", -2.740536442014874e+01, -1.221485130482948e+01},
	{"FZZ", -2.500007731198025e+01, -9.809564196660988e+00},
	{"GAA", -1.901271816466383e+01, -1.013355531283597e+01},
	{"GAB", -1.430590709139348e+01, -5.426744239565621e+00},
	{"GAC", -1.467970947248676e+01, -5.800546620658904e+00},
	{"GAD", -1.503883743358287e+01, -6.159674581755008e+00},
	{"GAE", -1.962159065173571e+01, -1.074242779990785e+01},
	{"GAF", -1.526212273508668e+01, -6.382959883258822e+00},
	{"GAG", -1.390724352551849e+01, -5.028080673690632e+00},
	{"GAH", -1.692192788977727e+01, -8.042765037949408e+00},
	{"GAI", -1.109006258793292e+01, -2.210899736105064e+00},
	{"GAJ", -2.013041793345870e+01, -1.125125508163084e+01},
	{"GAK", -1.937127163947810e+01, -1.049210878765024e+01},
	{"GAL", -1.289908805260627e+01, -4.019925200778411e+00},
	{"GAM", -1.432878422623797e+01, -5.449621374410115e+00},
	{"GAN", -1.102442002268637e+01, -2.145257170858514e+00},
	{"GAO", -2.112489604635194e+01, -1.224573319452408e+01},
	{"GAP", -1.511319631767175e+01, -6.234033465843895e+00},
	{"GAQ", -2.001497386263548e+01, -1.113581101080762e+01},
	{"GAR", -1.234446201584907e+01, -3.465299164021210e+00},
	{"GAS", -1.292406809052535e+01, -4.044905238697493e+00},
	{"GAT", -1.184816880641836e+01, -2.969005954590503e+00},
	{"GAU", -1.535106449958799e+01, -6.471901647760133e+00},
	{"GAV", -1.333866732318237e+01, -4.459504471354511e+00},
	{"GAW", -1.580402883445520e+01, -6.924865982627344e+00},
	{"GAX", -2.138724651954561e+01, -1.250808366771775e+01},
	{"GAY", -1.710861272951144e+01, -8.229449877683578e+00},
	{"GAZ", -1.584203392113132e+01, -6.962871069303465e+00},
	{"GBA", -1.550934766809869e+01, -3.370101146891420e+00},
	{"GBB", -2.712296579530910e+01, -1.498371927410184e+01},
	{"GBC", -2.053983424890703e+01, -8.400587727699767e+00},
	{"GBD", -2.913234635321827e+01, -1.699309983201100e+01},
	{"GBE", -1.381421471938642e+01, -1.674968198179159e+00},
	{"GBF", -3.071243543353806e+01, -1.857318891233079e+01},
	{"GBG", -3.231767436422678e+01, -2.017842784301952e+01},
	{"GBH", -2.956279282038059e+01, -1.742354629917333e+01},
	{"GBI", -1.742257739435944e+01, -5.283330873152172e+00},
	{"GBJ", -2.711815657939774e+01, -1.497891005819048e+01},
	{"GBK", -3.257348931488783e+01, -2.043424279368056e+01},
	{"GBL", -1.706900534322527e+01, -4.929758822018005e+00},
	{"GBM", -2.889202977613303e+01, -1.675278325492576e+01},
	{"GBN", -1.932560389415829e+01, -7.186357372951024e+00},
	{"GBO", -1.567201357897736e+01, -3.532767057770095e+00},
	{"GBP", -3.037582225696407e+01, -1.823657573575681e+01},
	{"GBQ", -3.644088038633490e+01, -2.430163386512763e+01},
	{"GBR", -1.594394508435265e+01, -3.804698563145380e+00},
	{"GBS", -2.036095744369132e+01, -8.221710922484052e+00},
	{"GBT", -2.637196731784131e+01, -1.423272079663405e+01},
	{"GBU", -1.416888505181878e+01, -2.029638530611519e+00},
	{"GBV", -3.035538701578566e+01, -1.821614049457839e+01},
	{"GBW", -2.976395005684203e+01, -1.762470353563476e+01},
	{"GBX", -3.972808822557550e+01, -2.758884170436824e+01},
	{"GBY", -1.525431833790373e+01, -3.115071816696469e+00},
	{"GBZ", -3.423619210134290e+01, -2.209694558013564e+01},
	{"GCA", -1.502300179478034e+01, -2.632728713563647e+00},
	{"GCB", -2.212551555697170e+01, -9.735242475755008e+00},
	{"GCC", -2.240833542451582e+01, -1.001806234329913e+01},
	{"GCD", -2.851785613223673e+01, -1.612758305102005e+01},
	{"GCE", -1.701047039232614e+01, -4.620197311109451e+00},
	{"GCF", -2.940111563209589e+01, -1.701084255087920e+01},
	{"GCG", -3.035338162138326e+01, -1.796310854016657e+01},
	{"GCH", -1.529502528769121e+01, -2.904752206474520e+00},
	{"GCI", -1.722382032574499e+01, -4.833547244528301e+00},
	{"GCJ", -3.232439269492376e+01, -1.993411961370708e+01},
	{"GCK", -2.403859135284538e+01, -1.164831827162869e+01},
	{"GCL", -1.626149053306107e+01, -3.871217451844386e+00},
	{"GCM", -2.930947273777957e+01, -1.691919965656288e+01},
	{"GCN", -3.017906769064876e+01, -1.778879460943208e+01},
	{"GCO", -1.359336412773647e+01, -1.203091046519780e+00},
	{"GCP", -2.367066039285857e+01, -1.128038731164188e+01},
	{"GCQ", -2.870870340770836e+01, -1.631843032649167e+01},
	{"GCR", -1.588099606156423e+01, -3.490722980347545e+00},
	{"GCS", -2.719028098046716e+01, -1.480000789925047e+01},
	{"GCT", -2.057240026066951e+01, -8.182127179452825e+00},
	{"GCU", -1.772522981021699e+01, -5.334956729000301e+00},
	{"GCV", -3.197383529704927e+01, -1.958356221583259e+01},
	{"GCW", -2.210345440428913e+01, -9.713181323072439e+00},
	{"GCX", -3.326527565855086e+01, -2.087500257733417e+01},
	{"GCY", -2.011383800763615e+01, -7.723564926419469e+00},
	{"GCZ", -2.271647876763377e+01, -1.032620568641709e+01},
	{"GDA", -1.574498496124615e+01, -3.483606826570378e+00},
	{"GDB", -2.463790611364010e+01, -1.237652797896433e+01},
	{"GDC", -2.578344114719329e+01, -1.352206301251752e+01},
	{"GDD", -2.557478973133640e+01, -1.331341159666063e+01},
	{"GDE", -1.484913145449376e+01, -2.587753319817994e+00},
	{"GDF", -2.529121062927373e+01, -1.302983249459796e+01},
	{"GDG", -2.601814719996232e+01, -1.375676906528656e+01},
	{"GDH", -2.464425038351490e+01, -1.238287224883914e+01},
	{"GDI", -1.472005731767303e+01, -2.458679182997264e+00},
	{"GDJ", -2.764604519054640e+01, -1.538466705587063e+01},
	{"GDK", -2.882289101092221e+01, -1.656151287624644e+01},
	{"GDL", -2.584671124222548e+01, -1.358533310754971e+01},
	{"GDM", -2.161048828696374e+01, -9.349110152287974e+00},
	{"GDN", -2.566964018508783e+01, -1.340826205041206e+01},
	{"GDO", -1.339007016164875e+01, -1.128692026972985e+00},
	{"GDP", -1.924641494557895e+01, -6.985036810903181e+00},
	{"GDQ", -3.026678254143573e+01, -1.800540440675996e+01},
	{"GDR", -1.624779598576707e+01, -3.986417851091299e+00},
	{"GDS", -2.393496423612593e+01, -1.167358610145016e+01},
	{"GDT", -2.185493697657100e+01, -9.593558841895232e+00},
	{"GDU", -1.760197825322543e+01, -5.340600118549665e+00},
	{"GDV", -2.735205233518271e+01, -1.509067420050694e+01},
	{"GDW", -2.154942855942563e+01, -9.288050424749862e+00},
	{"GDX", -3.516597284270993e+01, -2.290459470803416e+01},
	{"GDY", -2.036925854690662e+01, -8.107880412230855e+00},
	{"GDZ", -3.124841464302843e+01, -1.898703650835266e+01},
	{"GEA", -1.262325251352736e+01, -4.131644332151204e+00},
	{"GEB", -1.448882842505088e+01, -5.997220243674724e+00},
	{"GEC", -1.489498107760745e+01, -6.403372896231291e+00},
	{"GED", -1.190164840691966e+01, -3.410040225543502e+00},
	{"GEE", -1.549017668560787e+01, -6.998568504231717e+00},
	{"GEF", -1.440197499274699e+01, -5.910366811370833e+00},
	{"GEG", -1.663767810073474e+01, -8.146069919358583e+00},
	{"GEH", -1.471162715014873e+01, -6.220018968772574e+00},
	{"GEI", -1.352534539264089e+01, -5.033737211264736e+00},
	{"GEJ", -1.843150086427338e+01, -9.939892682897224e+00},
	{"GEK", -1.912599548624188e+01, -1.063438730486572e+01},
	{"GEL", -1.358536576169962e+01, -5.093757580323462e+00},
	{"GEM", -1.383301082689520e+01, -5.341402645519045e+00},
	{"GEN", -1.111013899459077e+01, -2.618530813214618e+00},
	{"GEO", -1.233029890736833e+01, -3.838690725992169e+00},
	{"GEP", -1.535368567919448e+01, -6.862077497818324e+00},
	{"GEQ", -1.741365991804378e+01, -8.922051736667630e+00},
	{"GER", -1.117872195075367e+01, -2.687113769377516e+00},
	{"GES", -1.169923558646243e+01, -3.207627405086273e+00},
	{"GET", -1.131792178451669e+01, -2.826313603140532e+00},
	{"GEU", -1.657718653515663e+01, -8.085578353780472e+00},
	{"GEV", -1.509859630572811e+01, -6.606988124351953e+00},
	{"GEW", -1.396922263453494e+01, -5.477614453158785e+00},
	{"GEX", -1.583476097817234e+01, -7.343152796796190e+00},
	{"GEY", -1.681855490946141e+01, -8.326946728085256e+00},
	{"GEZ", -2.001661374304398e+01, -1.152500556166783e+01},
	{"GFA", -1.550297993011180e+01, -3.558023020193347e+00},
	{"GFB", -2.351747701268211e+01, -1.157252010276366e+01},
	{"GFC", -2.587137185655006e+01, -1.392641494663160e+01},
	{"GFD", -2.675364797748901e+01, -1.480869106757056e+01},
	{"GFE", -1.668404414985355e+01, -4.739087239935099e+00},
	{"GFF", -2.418337761926331e+01, -1.223842070934485e+01},
	{"GFG", -2.640777768521464e+01, -1.446282077529619e+01},
	{"GFH", -2.520850353833769e+01, -1.326354662841924e+01},
	{"GFI", -1.515150970397340e+01, -3.206552794054945e+00},
	{"GFJ", -2.719651207126448e+01, -1.525155516134602e+01},
	{"GFK", -2.909269283621400e+01, -1.714773592629556e+01},
	{"GFL", -1.662678397668651e+01, -4.681827066768060e+00},
	{"GFM", -2.553963811256515e+01, -1.359468120264671e+01},
	{"GFN", -2.716143395585540e+01, -1.521647704593695e+01},
	{"GFO", -1.312317926012589e+01, -1.178222350207440e+00},
	{"GFP", -2.607156353109907e+01, -1.412660662118063e+01},
	{"GFQ", -3.133953840648658e+01, -1.939458149656813e+01},
	{"GFR", -1.395715014154904e+01, -2.012193231630587e+00},
	{"GFS", -2.539949871990140e+01, -1.345454180998295e+01},
	{"GFT", -2.238040699509358e+01, -1.043545008517513e+01},
	{"GFU", -1.663722430882282e+01, -4.692267398904369e+00},
	{"GFV", -2.837352069979103e+01, -1.642856378987258e+01},
	{"GFW", -2.612583562438969e+01, -1.418087871447124e+01},
	{"GFX", -3.365090991082008e+01, -2.170595300090164e+01},
	{"GFY", -2.676836796859606e+01, -1.482341105867761e+01},
	{"GFZ", -2.977950337034662e+01, -1.783454646042817e+01},
	{"GGA", -1.589528329166202e+01, -3.808836241705374e+00},
	{"GGB", -2.035911233067076e+01, -8.272665280714111e+00},
	{"GGC", -1.918144550347717e+01, -7.094998453520525e+00},
	{"GGD", -2.067548735461398e+01, -8.589040304657340e+00},
	{"GGE", -1.351522427754335e+01, -1.428777227586703e+00},
	{"GGF", -2.251426060748556e+01, -1.042781355752892e+01},
	{"GGG", -2.336684536611336e+01, -1.128039831615671e+01},
	{"GGH", -2.111517156032353e+01, -9.028724510366889e+00},
	{"GGI", -1.539817831104481e+01, -3.311731261088164e+00},
	{"GGJ", -2.909912616412897e+01, -1.701267911417233e+01},
	{"GGK", -2.933693004027585e+01, -1.725048299031920e+01},
	{"GGL", -1.474505430198758e+01, -2.658607252030935e+00},
	{"GGM", -2.332359754763877e+01, -1.123715049768212e+01},
	{"GGN", -2.100021687931489e+01, -8.913769829358248e+00},
	{"GGO", -1.556640714326581e+01, -3.479960093309166e+00},
	{"GGP", -1.945406349192838e+01, -7.367616441971739e+00},
	{"GGQ", -3.063336224594345e+01, -1.854691519598680e+01},
	{"GGR", -1.530152236658032e+01, -3.215075316623675e+00},
	{"GGS", -1.650947442267213e+01, -4.423027372715487e+00},
	{"GGT", -2.027789399869014e+01, -8.191446948733500e+00},
	{"GGU", -1.801997626516084e+01, -5.933529215204188e+00},
	{"GGV", -2.847196393589278e+01, -1.638551688593613e+01},
	{"GGW", -2.128705059402622e+01, -9.200603544069571e+00},
	{"GGX", -3.385218271239080e+01, -2.176573566243416e+01},
	{"GGY", -1.906180257870561e+01, -6.975355528748963e+00},
	{"GGZ", -3.244043622642303e+01, -2.035398917646638e+01},
	{"GHA", -1.313581270208113e+01, -4.526901200358826e+00},
	{"GHB", -1.420091425765849e+01, -5.592002755936182e+00},
	{"GHC", -1.636914117276455e+01, -7.760229671042242e+00},
	{"GHD", -1.665189647088991e+01, -8.042984969167604e+00},
	{"GHE", -1.276786572376750e+01, -4.158954222045196e+00},
	{"GHF", -1.584778819982784e+01, -7.238876698105537e+00},
	{"GHG", -1.729165094302569e+01, -8.682739441303385e+00},
	{"GHH", -1.501759460437097e+01, -6.408683102648663e+00},
	{"GHI", -1.264253392357697e+01, -4.033622421854663e+00},
	{"GHJ", -1.858893471358758e+01, -9.980023211865269e+00},
	{"GHK", -2.039527325446313e+01, -1.178636175274082e+01},
	{"GHL", -1.486058098232362e+01, -6.251669480601312e+00},
	{"GHM", -1.602430656135224e+01, -7.415395059629936e+00},
	{"GHN", -1.621833502698202e+01, -7.609423525259713e+00},
	{"GHO", -1.328840244432476e+01, -4.679490942602458e+00},
	{"GHP", -1.526313046390867e+01, -6.654218962186365e+00},
	{"GHQ", -1.963097273041451e+01, -1.102206122869220e+01},
	{"GHR", -1.663848408462989e+01, -8.029572582907585e+00},
	{"GHS", -1.476398135083511e+01, -6.155069849112801e+00},
	{"GHT", -9.171577408709291e+00, -5.626659069869852e-01},
	{"GHU", -1.622438889854972e+01, -7.615477396827417e+00},
	{"GHV", -1.858902060562482e+01, -9.980109103902514e+00},
	{"GHW", -1.501422502212101e+01, -6.405313520398705e+00},
	{"GHX", -3.566378656347639e+01, -2.705487506175408e+01},
	{"GHY", -1.756337423000230e+01, -8.954462728279990e+00},
	{"GHZ", -3.267566880935009e+01, -2.406675730762779e+01},
	{"GIA", -1.461627494474081e+01, -5.193930222056383e+00},
	{"GIB", -1.585927281565974e+01, -6.436928092975312e+00},
	{"GIC", -1.515101756338586e+01, -5.728672840701439e+00},
	{"GID", -1.610468626863545e+01, -6.682341545951028e+00},
	{"GIE", -1.617252335188219e+01, -6.750178629197770e+00},
	{"GIF", -1.491940824576173e+01, -5.497063523077308e+00},
	{"GIG", -1.704986760037833e+01, -7.627522877693902e+00},
	{"GIH", -1.758752921746953e+01, -8.165184494785104e+00},
	{"GII", -2.211143368697523e+01, -1.268908896429081e+01},
	{"GIJ", -2.370726125388016e+01, -1.428491653119574e+01},
	{"GIK", -1.938730385658848e+01, -9.964959133904058e+00},
	{"GIL", -1.441646789563046e+01, -4.994123172946036e+00},
	{"GIM", -1.549479781293827e+01, -6.072453090253846e+00},
	{"GIN", -1.092819440249255e+01, -1.505849679808120e+00},
	{"GIO", -1.374799375570747e+01, -4.325649033023046e+00},
	{"GIP", -1.953117528561480e+01, -1.010883056293037e+01},
	{"GIQ", -2.934895258577368e+01, -1.992660786308926e+01},
	{"GIR", -1.404448625388006e+01, -4.622141531195632e+00},
	{"GIS", -1.317280628044340e+01, -3.750461557758970e+00},
	{"GIT", -1.299847757126113e+01, -3.576132848576711e+00},
	{"GIU", -1.569025026970523e+01, -6.267905547020808e+00},
	{"GIV", -1.157167294103038e+01, -2.149328218345954e+00},
	{"GIW", -1.735891048073735e+01, -7.936565758052931e+00},
	{"GIX", -2.786546258876870e+01, -1.844311786608428e+01},
	{"GIY", -3.294910940679819e+01, -2.352676468411377e+01},
	{"GIZ", -1.938967714487000e+01, -9.967332422185573e+00},
	{"GJA", -1.826288475613021e+01, -2.648587098230053e+00},
	{"GJB", -2.956464304057681e+01, -1.395034538267665e+01},
	{"GJC", -3.041794944821527e+01, -1.480365179031511e+01},
	{"GJD", -3.231210703047871e+01, -1.669780937257855e+01},
	{"GJE", -1.797539457051516e+01, -2.361096912614995e+00},
	{"GJF", -3.143579292688300e+01, -1.582149526898284e+01},
	{"GJG", -2.371361262835833e+01, -8.099314970458172e+00},
	{"GJH", -3.020647682971437e+01, -1.459217917181421e+01},
	{"GJI", -2.000361051784831e+01, -4.389312859948151e+00},
	{"GJJ", -3.021226954601392e+01, -1.459797188811377e+01},
	{"GJK", -3.290084105388522e+01, -1.728654339598506e+01},
	{"GJL", -3.140967392312183e+01, -1.579537626522167e+01},
	{"GJM", -3.176559929684928e+01, -1.615130163894912e+01},
	{"GJN", -3.471566902550190e+01, -1.910137136760174e+01},
	{"GJO", -1.757875539765962e+01, -1.964457739759458e+00},
	{"GJP", -3.117745155966831e+01, -1.556315390176815e+01},
	{"GJQ", -3.416370330059419e+01, -1.854940564269403e+01},
	{"GJR", -3.038787803741463e+01, -1.477358037951448e+01},
	{"GJS", -3.082666685394324e+01, -1.521236919604309e+01},
	{"GJT", -3.092080417616229e+01, -1.530650651826213e+01},
	{"GJU", -1.717970873350030e+01, -1.565411075600142e+00},
	{"GJV", -3.778275652019504e+01, -2.216845886229488e+01},
	{"GJW", -3.015701256376602e+01, -1.454271490586586e+01},
	{"GJX", -4.046206192726387e+01, -2.484776426936372e+01},
	{"GJY", -3.693193267810849e+01, -2.131763502020833e+01},
	{"GJZ", -3.487296977878243e+01, -1.925867212088227e+01},
	{"GKA", -2.233768318342281e+01, -6.485071592225405e+00},
	{"GKB", -2.674299073808076e+01, -1.089037914688336e+01},
	{"GKC", -2.209470058685437e+01, -6.242088995656966e+00},
	{"GKD", -2.780807233279005e+01, -1.195546074159265e+01},
	{"GKE", -1.842403420043107e+01, -2.571422609233668e+00},
	{"GKF", -2.663939907620290e+01, -1.078678748500550e+01},
	{"GKG", -2.891199985352005e+01, -1.305938826232265e+01},
	{"GKH", -2.630969923039004e+01, -1.045708763919264e+01},
	{"GKI", -1.674620300088750e+01, -8.935914096900982e-01},
	{"GKJ", -3.049017433492049e+01, -1.463756274372309e+01},
	{"GKK", -2.982190442737278e+01, -1.396929283617538e+01},
	{"GKL", -2.620053298750020e+01, -1.034792139630280e+01},
	{"GKM", -2.717490162944492e+01, -1.132229003824752e+01},
	{"GKN", -1.791935511937572e+01, -2.066743528178316e+00},
	{"GKO", -2.316324022745339e+01, -7.310628636255984e+00},
	{"GKP", -2.752488977784807e+01, -1.167227818665066e+01},
	{"GKQ", -3.316931412949356e+01, -1.731670253829616e+01},
	{"GKR", -2.364843657532186e+01, -7.795824984124455e+00},
	{"GKS", -2.407975185262834e+01, -8.227140261430938e+00},
	{"GKT", -2.484463935980752e+01, -8.992027768610120e+00},
	{"GKU", -2.263368305749558e+01, -6.781071466298179e+00},
	{"GKV", -3.033032940076519e+01, -1.447771780956778e+01},
	{"GKW", -2.601581340001748e+01, -1.016320180882008e+01},
	{"GKX", -3.414136099538683e+01, -1.828874940418942e+01},
	{"GKY", -2.668636876044811e+01, -1.083375716925071e+01},
	{"GKZ", -3.224322388125656e+01, -1.639061229005916e+01},
	{"GLA", -1.222828879068881e+01, -1.732131796042327e+00},
	{"GLB", -2.165368736799719e+01, -1.115753037335071e+01},
	{"GLC", -2.207686025298626e+01, -1.158070325833978e+01},
	{"GLD", -2.406881681549341e+01, -1.357265982084693e+01},
	{"GLE", -1.279178217002793e+01, -2.295625175381444e+00},
	{"GLF", -2.590737779014945e+01, -1.541122079550296e+01},
	{"GLG", -2.759204419451792e+01, -1.709588719987144e+01},
	{"GLH", -2.702390742096070e+01, -1.652775042631422e+01},
	{"GLI", -1.251337828005875e+01, -2.017221285412274e+00},
	{"GLJ", -3.032407181180616e+01, -1.982791481715968e+01},
	{"GLK", -2.759636871511642e+01, -1.710021172046994e+01},
	{"GLL", -2.178215115835679e+01, -1.128599416371031e+01},
	{"GLM", -2.667060217032396e+01, -1.617444517567748e+01},
	{"GLN", -2.738054370959890e+01, -1.688438671495242e+01},
	{"GLO", -1.306493974245077e+01, -2.568782747804285e+00},
	{"GLP", -2.665672456078008e+01, -1.616056756613361e+01},
	{"GLQ", -3.141277606663600e+01, -2.091661907198952e+01},
	{"GLR", -2.718741065150587e+01, -1.669125365685939e+01},
	{"GLS", -2.495374759359777e+01, -1.445759059895129e+01},
	{"GLT", -2.443443836106278e+01, -1.393828136641630e+01},
	{"GLU", -1.835144998451020e+01, -7.855292989863718e+00},
	{"GLV", -2.695673661365361e+01, -1.646057961900713e+01},
	{"GLW", -2.665303159477794e+01, -1.615687460013146e+01},
	{"GLX", -3.471474425076349e+01, -2.421858725611702e+01},
	{"GLY", -1.425363994190556e+01, -3.757482947259074e+00},
	{"GLZ", -3.337623472387926e+01, -2.288007772923278e+01},
	{"GMA", -1.374811257975628e+01, -1.851370654235661e+00},
	{"GMB", -2.455043344082204e+01, -1.265369151530142e+01},
	{"GMC", -1.832345515155437e+01, -6.426713226033748e+00},
	{"GMD", -1.990318711703159e+01, -8.006445191510963e+00},
	{"GME", -1.317369284101050e+01, -1.276950915489881e+00},
	{"GMF", -2.667855528599897e+01, -1.478181336047835e+01},
	{"GMG", -2.833186122957936e+01, -1.643511930405874e+01},
	{"GMH", -2.630070700568362e+01, -1.440396508016300e+01},
	{"GMI", -1.602781155922225e+01, -4.131069633701629e+00},
	{"GMJ", -2.975563850553366e+01, -1.785889658001303e+01},
	{"GMK", -3.006856496009055e+01, -1.817182303456993e+01},
	{"GML", -1.771737106535234e+01, -5.820629139831718e+00},
	{"GMM", -2.153647270314418e+01, -9.639730777623555e+00},
	{"GMN", -2.166892312438580e+01, -9.772181198865178e+00},
	{"GMO", -1.499489572162380e+01, -3.098153796103174e+00},
	{"GMP", -2.374222102115044e+01, -1.184547909562982e+01},
	{"GMQ", -3.267688169050801e+01, -2.078013976498739e+01},
	{"GMR", -1.885551774428423e+01, -6.958775818763606e+00},
	{"GMS", -2.303777231157966e+01, -1.114103038605904e+01},
	{"GMT", -2.226571290681637e+01, -1.036897098129575e+01},
	{"GMU", -1.720292322970635e+01, -5.306181304185730e+00},
	{"GMV", -2.941116286131318e+01, -1.751442093579256e+01},
	{"GMW", -2.587279372427144e+01, -1.397605179875082e+01},
	{"GMX", -3.431657114746148e+01, -2.241982922194086e+01},
	{"GMY", -1.582599141944658e+01, -3.929249493925957e+00},
	{"GMZ", -3.294564526648836e+01, -2.104890334096773e+01},
	{"GNA", -1.352205038465758e+01, -2.512476701753622e+00},
	{"GNB", -1.782905041888600e+01, -6.819476735982040e+00},
	{"GNC", -1.746910837560668e+01, -6.459534692702720e+00},
	{"GND", -1.877457912351208e+01, -7.765005440608124e+00},
	{"GNE", -1.312709984714065e+01, -2.117526164236694e+00},
	{"GNF", -1.845793504372886e+01, -7.448361360824901e+00},
	{"GNG", -1.942711757490950e+01, -8.417543892005542e+00},
	{"GNH", -1.792651690745471e+01, -6.916943224550749e+00},
	{"GNI", -1.344231596114329e+01, -2.432742278239331e+00},
	{"GNJ", -2.768730545922569e+01, -1.667773177632173e+01},
	{"GNK", -2.634519704355219e+01, -1.533562336064823e+01},
	{"GNL", -1.880005523871793e+01, -7.790481555813965e+00},
	{"GNM", -1.733922681160352e+01, -6.329653128699563e+00},
	{"GNN", -1.960915181697175e+01, -8.599578134067785e+00},
	{"GNO", -1.340250524857301e+01, -2.392931565669049e+00},
	{"GNP", -1.727272916796728e+01, -6.263155485063320e+00},
	{"GNQ", -2.367042795347907e+01, -1.266085427057511e+01},
	{"GNR", -1.890504566348705e+01, -7.895471980583094e+00},
	{"GNS", -1.485907432108274e+01, -3.849500638178779e+00},
	{"GNT", -1.573014432104360e+01, -4.720570638139638e+00},
	{"GNU", -1.739222434263531e+01, -6.382650659731350e+00},
	{"GNV", -2.167788119564700e+01, -1.066830751274304e+01},
	{"GNW", -1.718947328583094e+01, -6.179899602926977e+00},
	{"GNX", -3.065576265332002e+01, -1.964618897041606e+01},
	{"GNY", -1.831426668633796e+01, -7.304693003433997e+00},
	{"GNZ", -3.116446769709962e+01, -2.015489401419565e+01},
	{"GOA", -1.408682871187254e+01, -5.210708160788944e+00},
	{"GOB", -1.549289731359305e+01, -6.616776762509455e+00},
	{"GOC", -1.744434071042666e+01, -8.568220159343065e+00},
	{"GOD", -1.119161180281737e+01, -2.315491251733774e+00},
	{"GOE", -1.475821800205978e+01, -5.882097450976183e+00},
	{"GOF", -1.166668729502351e+01, -2.790566743939918e+00},
	{"GOG", -1.663960208033114e+01, -7.763481529247539e+00},
	{"GOH", -1.667106597332975e+01, -7.794945422246154e+00},
	{"GOI", -1.337295691257177e+01, -4.496836361488178e+00},
	{"GOJ", -2.168714837117263e+01, -1.281102782008903e+01},
	{"GOK", -2.132610074876182e+01, -1.244998019767822e+01},
	{"GOL", -1.361951677846763e+01, -4.743396227384035e+00},
	{"GOM", -1.676832415994665e+01, -7.892203608863054e+00},
	{"GON", -1.241211323957399e+01, -3.535992688490389e+00},
	{"GOO", -1.191150139323843e+01, -3.035380842154833e+00},
	{"GOP", -1.684050010094513e+01, -7.964379549861536e+00},
	{"GOQ", -2.370591463319481e+01, -1.482979408211121e+01},
	{"GOR", -1.341560097766674e+01, -4.539480426583142e+00},
	{"GOS", -1.556436669256983e+01, -6.688246141486231e+00},
	{"GOT", -1.238121674622515e+01, -3.505096195141556e+00},
	{"GOU", -1.356776841644550e+01, -4.691647865361901e+00},
	{"GOV", -1.220085476065255e+01, -3.324734209568959e+00},
	{"GOW", -1.582917480620370e+01, -6.953054255120104e+00},
	{"GOX", -2.090640411617574e+01, -1.203028356509215e+01},
	{"GOY", -1.743011351437312e+01, -8.553992963289524e+00},
	{"GOZ", -2.271127647017186e+01, -1.383515591908826e+01},
	{"GPA", -1.514130491105856e+01, -2.758770828636151e+00},
	{"GPB", -2.813619657721517e+01, -1.575366249479275e+01},
	{"GPC", -2.903352616051480e+01, -1.665099207809239e+01},
	{"GPD", -2.369419853601937e+01, -1.131166445359695e+01},
	{"GPE", -1.521637690515170e+01, -2.833842822729286e+00},
	{"GPF", -2.811387802063972e+01, -1.573134393821731e+01},
	{"GPG", -2.212105461395225e+01, -9.738520531529838e+00},
	{"GPH", -1.759689591733807e+01, -5.214361834915655e+00},
	{"GPI", -1.704755574397662e+01, -4.665021661554207e+00},
	{"GPJ", -3.174583015321113e+01, -1.936329607078872e+01},
	{"GPK", -3.162875076123004e+01, -1.924621667880763e+01},
	{"GPL", -1.539903654246654e+01, -3.016502460044122e+00},
	{"GPM", -2.137372795328582e+01, -8.991193870863405e+00},
	{"GPN", -2.946511486191470e+01, -1.708258077949228e+01},
	{"GPO", -1.481431836493110e+01, -2.431784282508692e+00},
	{"GPP", -1.920475721611429e+01, -6.822223133691877e+00},
	{"GPQ", -3.300210081887228e+01, -2.061956673644987e+01},
	{"GPR", -1.423210847506878e+01, -1.849574392646369e+00},
	{"GPS", -2.130147246223753e+01, -8.918938379815113e+00},
	{"GPT", -2.397235362253511e+01, -1.158981954011270e+01},
	{"GPU", -1.688992831145328e+01, -4.507394229030860e+00},
	{"GPV", -3.116006845411591e+01, -1.877753437169350e+01},
	{"GPW", -2.736182581372121e+01, -1.497929173129880e+01},
	{"GPX", -3.650327952428008e+01, -2.412074544185767e+01},
	{"GPY", -2.354848364637854e+01, -1.116594956395613e+01},
	{"GPZ", -3.480839514973118e+01, -2.242586106730877e+01},
	{"GQA", -2.875795389349111e+01, -1.161226320767564e+01},
	{"GQB", -3.138537584063338e+01, -1.423968515481792e+01},
	{"GQC", -3.029637505853027e+01, -1.315068437271480e+01},
	{"GQD", -3.190707970072331e+01, -1.476138901490784e+01},
	{"GQE", -3.229497424486755e+01, -1.514928355905209e+01},
	{"GQF", -3.065387864412417e+01, -1.350818795830870e+01},
	{"GQG", -3.737070261850567e+01, -2.022501193269020e+01},
	{"GQH", -3.120543730098329e+01, -1.405974661516782e+01},
	{"GQI", -2.709699790887534e+01, -9.951307223059878e+00},
	{"GQJ", -3.317074907612508e+01, -1.602505839030962e+01},
	{"GQK", -3.900288781344441e+01, -2.185719712762894e+01},
	{"GQL", -3.163143366680650e+01, -1.448574298099104e+01},
	{"GQM", -3.081614584535177e+01, -1.367045515953631e+01},
	{"GQN", -3.365475540925435e+01, -1.650906472343888e+01},
	{"GQO", -3.185120123997979e+01, -1.470551055416432e+01},
	{"GQP", -3.185338662640565e+01, -1.470769594059018e+01},
	{"GQQ", -3.373478957514274e+01, -1.658909888932727e+01},
	{"GQR", -3.170009007785751e+01, -1.455439939204204e+01},
	{"GQS", -2.877240223314625e+01, -1.162671154733079e+01},
	{"GQT", -2.927207323708056e+01, -1.212638255126510e+01},
	{"GQU", -1.714943665891590e+01, -3.745973100434968e-03},
	{"GQV", -3.456594325549602e+01, -1.742025256968055e+01},
	{"GQW", -3.092419607964229e+01, -1.377850539382682e+01},
	{"GQX", -4.102601977132734e+01, -2.388032908551187e+01},
	{"GQY", -3.521873997277412e+01, -1.807304928695866e+01},
	{"GQZ", -4.216558720807787e+01, -2.501989652226240e+01},
	{"GRA", -1.120369365720020e+01, -1.904616068761974e+00},
	{"GRB", -2.631614156325593e+01, -1.701706397481770e+01},
	{"GRC", -2.249685486739762e+01, -1.319777727895938e+01},
	{"GRD", -2.300237805842265e+01, -1.370330046998442e+01},
	{"GRE", -1.027796194293517e+01, -9.788843544969397e-01},
	{"GRF", -2.614551148325105e+01, -1.684643389481282e+01},
	{"GRG", -2.576824655109356e+01, -1.646916896265533e+01},
	{"GRH", -2.133667480012276e+01, -1.203759721168453e+01},
	{"GRI", -1.341784209820558e+01, -4.118764509767352e+00},
	{"GRJ", -2.923849933578262e+01, -1.993942174734439e+01},
	{"GRK", -2.610592574734351e+01, -1.680684815890528e+01},
	{"GRL", -2.597289442548221e+01, -1.667381683704398e+01},
	{"GRM", -2.498095393822382e+01, -1.568187634978559e+01},
	{"GRN", -2.503652636667409e+01, -1.573744877823586e+01},
	{"GRO", -1.205717181635422e+01, -2.758094227915985e+00},
	{"GRP", -2.623860029649646e+01, -1.693952270805823e+01},
	{"GRQ", -3.062503546602339e+01, -2.132595787758515e+01},
	{"GRR", -2.200098423036115e+01, -1.270190664192292e+01},
	{"GRS", -2.374504705297713e+01, -1.444596946453890e+01},
	{"GRT", -2.345336455969613e+01, -1.415428697125791e+01},
	{"GRU", -1.629006795809046e+01, -6.990990369652231e+00},
	{"GRV", -2.655617880594047e+01, -1.725710121750224e+01},
	{"GRW", -2.591174862155369e+01, -1.661267103311546e+01},
	{"GRX", -3.127724814460447e+01, -2.197817055616624e+01},
	{"GRY", -1.573863683116873e+01, -6.439559242730501e+00},
	{"GRZ", -3.222128417262910e+01, -2.292220658419086e+01},
	{"GSA", -1.295814973529167e+01, -2.735638882919114e+00},
	{"GSB", -1.550212039779814e+01, -5.279609545425582e+00},
	{"GSC", -1.525213071043420e+01, -5.029619858061648e+00},
	{"GSD", -1.668203635099464e+01, -6.459525498622080e+00},
	{"GSE", -1.433892964657062e+01, -4.116418794198061e+00},
	{"GSF", -1.573291233509494e+01, -5.510401482722388e+00},
	{"GSG", -1.734058536759079e+01, -7.118074515218235e+00},
	{"GSH", -1.397729918174418e+01, -3.754788329371626e+00},
	{"GSI", -1.415836566611026e+01, -3.935854813737699e+00},
	{"GSJ", -1.946752985619407e+01, -9.245019003821509e+00},
	{"GSK", -1.862531218566659e+01, -8.402801333294038e+00},
	{"GSL", -1.623979318659832e+01, -6.017282334225762e+00},
	{"GSM", -1.625543516335756e+01, -6.032924310984999e+00},
	{"GSN", -1.718980099005741e+01, -6.967290137684857e+00},
	{"GSO", -1.293205427783264e+01, -2.709543425460084e+00},
	{"GSP", -1.494436676959709e+01, -4.721855917224530e+00},
	{"GSQ", -1.858755828384537e+01, -8.365047431472815e+00},
	{"GSR", -1.758345089262838e+01, -7.360940040255828e+00},
	{"GSS", -1.527638043772104e+01, -5.053869585348481e+00},
	{"GST", -1.287903388718047e+01, -2.656523034807911e+00},
	{"GSU", -1.477640813578908e+01, -4.553897283416519e+00},
	{"GSV", -1.912909080909354e+01, -8.906579956720980e+00},
	{"GSW", -1.411896181671906e+01, -3.896450964346506e+00},
	{"GSX", -2.271078636561709e+01, -1.248827551324453e+01},
	{"GSY", -1.659807336513756e+01, -6.375562512765000e+00},
	{"GSZ", -3.166978847112981e+01, -2.144727761875725e+01},
	{"GTA", -1.554802717449313e+01, -6.212804106640673e+00},
	{"GTB", -2.610797520269776e+01, -1.677275213484531e+01},
	{"GTC", -2.347803678562386e+01, -1.414281371777141e+01},
	{"GTD", -2.356071146876314e+01, -1.422548840091069e+01},
	{"GTE", -1.584422865346485e+01, -6.509005585612396e+00},
	{"GTF", -2.633865100026798e+01, -1.700342793241552e+01},
	{"GTG", -2.728028590338504e+01, -1.794506283553258e+01},
	{"GTH", -1.001338973923118e+01, -6.781666713787319e-01},
	{"GTI", -1.538436514913850e+01, -6.049142081286049e+00},
	{"GTJ", -2.369148919083452e+01, -1.435626612298207e+01},
	{"GTK", -2.926286625358511e+01, -1.992764318573265e+01},
	{"GTL", -2.338958549701946e+01, -1.405436242916701e+01},
	{"GTM", -1.341931065416400e+01, -4.084087586311545e+00},
	{"GTN", -2.687210309221026e+01, -1.753688002435781e+01},
	{"GTO", -1.131673618944123e+01, -1.981513121588782e+00},
	{"GTP", -2.694310252169244e+01, -1.760787945383999e+01},
	{"GTQ", -3.140235740044835e+01, -2.206713433259590e+01},
	{"GTR", -1.539825163082750e+01, -6.063028562975048e+00},
	{"GTS", -2.097810397536445e+01, -1.164288090751200e+01},
	{"GTT", -2.368473811615712e+01, -1.434951504830467e+01},
	{"GTU", -1.775582307505081e+01, -8.420600007198358e+00},
	{"GTV", -2.939209914697303e+01, -2.005687607912058e+01},
	{"GTW", -1.708303112423374e+01, -7.747808056381285e+00},
	{"GTX", -3.410816018721196e+01, -2.477293711935951e+01},
	{"GTY", -2.197852542728521e+01, -1.264330235943275e+01},
	{"GTZ", -3.158139364417282e+01, -2.224617057632037e+01},
	{"GUA", -1.370536836671435e+01, -3.397780517542734e+00},
	{"GUB", -2.102731556583668e+01, -1.071972771666507e+01},
	{"GUC", -2.402491269471079e+01, -1.371732484553918e+01},
	{"GUD", -2.240599600569642e+01, -1.209840815652481e+01},
	{"GUE", -1.307084236064245e+01, -2.763254511470838e+00},
	{"GUF", -2.642407397203658e+01, -1.611648612286496e+01},
	{"GUG", -2.221593850339805e+01, -1.190835065422644e+01},
	{"GUH", -2.709396807831149e+01, -1.678638022913987e+01},
	{"GUI", -1.331733802014625e+01, -3.009750170974635e+00},
	{"GUJ", -3.138242125350441e+01, -2.107483340433280e+01},
	{"GUK", -2.758706795534588e+01, -1.727948010617426e+01},
	{"GUL", -1.375618513308510e+01, -3.448597283913490e+00},
	{"GUM", -1.627027481125154e+01, -5.962686962079920e+00},
	{"GUN", -1.337704839588866e+01, -3.069460546717051e+00},
	{"GUO", -1.871603414367108e+01, -8.408446294499466e+00},
	{"GUP", -1.381784552305037e+01, -3.510257673878752e+00},
	{"GUQ", -3.284402520453980e+01, -2.253643735536818e+01},
	{"GUR", -1.461078041743048e+01, -4.303192568258867e+00},
	{"GUS", -1.427989827272999e+01, -3.972310423558372e+00},
	{"GUT", -1.264211419066152e+01, -2.334526341489910e+00},
	{"GUU", -3.018719323786415e+01, -1.987960538869254e+01},
	{"GUV", -2.270600535073403e+01, -1.239841750156242e+01},
	{"GUW", -2.720958209566323e+01, -1.690199424649161e+01},
	{"GUX", -2.980498174854611e+01, -1.949739389937449e+01},
	{"GUY", -1.913227576933480e+01, -8.824687920163180e+00},
	{"GUZ", -2.942442843075827e+01, -1.911684058158665e+01},
	{"GVA", -1.777776599986867e+01, -2.791633532132710e+00},
	{"GVB", -3.367823691914121e+01, -1.869210445140524e+01},
	{"GVC", -3.386759324648141e+01, -1.888146077874545e+01},
	{"GVD", -3.312266538022544e+01, -1.813653291248948e+01},
	{"GVE", -1.639852300668533e+01, -1.412390538949371e+00},
	{"GVF", -3.332701262551297e+01, -1.834088015777701e+01},
	{"GVG", -3.463540501283446e+01, -1.964927254509850e+01},
	{"GVH", -3.235024598826291e+01, -1.736411352052695e+01},
	{"GVI", -1.682570064940229e+01, -1.839568181666333e+00},
	{"GVJ", -3.455826271347507e+01, -1.957213024573911e+01},
	{"GVK", -3.643786333625339e+01, -2.145173086851743e+01},
	{"GVL", -3.371010640793889e+01, -1.872397394020294e+01},
	{"GVM", -3.272056918956706e+01, -1.773443672183109e+01},
	{"GVN", -3.181897707503545e+01, -1.683284460729949e+01},
	{"GVO", -1.732283305890791e+01, -2.336700591171952e+00},
	{"GVP", -3.279321619464886e+01, -1.780708372691290e+01},
	{"GVQ", -4.039005810958888e+01, -2.540392564185292e+01},
	{"GVR", -3.074925174173965e+01, -1.576311927400369e+01},
	{"GVS", -3.178702793127500e+01, -1.680089546353903e+01},
	{"GVT", -3.110293683447289e+01, -1.611680436673693e+01},
	{"GVU", -2.370929683688616e+01, -8.723164369150197e+00},
	{"GVV", -3.528363527519976e+01, -2.029750280746380e+01},
	{"GVW", -3.242639490304212e+01, -1.744026243530616e+01},
	{"GVX", -3.701587892668553e+01, -2.202974645894957e+01},
	{"GVY", -2.883872136265611e+01, -1.385258889492015e+01},
	{"GVZ", -3.782885305456460e+01, -2.284272058682864e+01},
	{"GWA", -1.385738466898346e+01, -2.290108573275511e+00},
	{"GWB", -2.831200365113061e+01, -1.674472755542266e+01},
	{"GWC", -2.837154220324939e+01, -1.680426610754144e+01},
	{"GWD", -2.788503220337311e+01, -1.631775610766516e+01},
	{"GWE", -1.509748275610463e+01, -3.530206660396680e+00},
	{"GWF", -2.816661998950883e+01, -1.659934389380088e+01},
	{"GWG", -2.929011734733184e+01, -1.772284125162389e+01},
	{"GWH", -1.334262447401968e+01, -1.775348378311724e+00},
	{"GWI", -1.324518810318512e+01, -1.677912007477171e+00},
	{"GWJ", -3.065005788231191e+01, -1.908278178660395e+01},
	{"GWK", -3.079583347343602e+01, -1.922855737772807e+01},
	{"GWL", -2.723510260633940e+01, -1.566782651063144e+01},
	{"GWM", -2.793593484244688e+01, -1.636865874673893e+01},
	{"GWN", -2.481022480384365e+01, -1.324294870813570e+01},
	{"GWO", -1.516397705653358e+01, -3.596700960825625e+00},
	{"GWP", -2.902379850947680e+01, -1.745652241376884e+01},
	{"GWQ", -3.327741965618793e+01, -2.171014356047997e+01},
	{"GWR", -1.835611639999534e+01, -6.788840304287386e+00},
	{"GWS", -2.607039715261843e+01, -1.450312105691048e+01},
	{"GWT", -2.594041941776068e+01, -1.437314332205272e+01},
	{"GWU", -2.090757033135969e+01, -9.340294235651736e+00},
	{"GWV", -3.112759301883311e+01, -1.956031692312515e+01},
	{"GWW", -2.715961245792339e+01, -1.559233636221544e+01},
	{"GWX", -4.047122592231334e+01, -2.890394982660538e+01},
	{"GWY", -1.810281323852989e+01, -6.535537142821938e+00},
	{"GWZ", -3.399420957295249e+01, -2.242693347724454e+01},
	{"GXA", -2.471425393206220e+01, -4.349742779799375e+00},
	{"GXB", -2.928157854109665e+01, -8.917067388833825e+00},
	{"GXC", -2.424257819864680e+01, -3.878067046383975e+00},
	{"GXD", -2.867496669401660e+01, -8.310455541753770e+00},
	{"GXE", -2.432015127578970e+01, -3.955640123526875e+00},
	{"GXF", -2.881707616007210e+01, -8.452565007809273e+00},
	{"GXG", -3.011614070018786e+01, -9.751629547925031e+00},
	{"GXH", -2.647431452605117e+01, -6.109803373788345e+00},
	{"GXI", -2.431452560798592e+01, -3.950014455723091e+00},
	{"GXJ", -3.132910982621177e+01, -1.096459867394895e+01},
	{"GXK", -3.222719611665816e+01, -1.186268496439533e+01},
	{"GXL", -2.877443013348163e+01, -8.409918981218802e+00},
	{"GXM", -2.805761575147613e+01, -7.693104599213299e+00},
	{"GXN", -3.055934880827898e+01, -1.019483765601615e+01},
	{"GXO", -2.707198691455142e+01, -6.707475762288589e+00},
	{"GXP", -2.369037520523464e+01, -3.325864052971817e+00},
	{"GXQ", -3.022940547592492e+01, -9.864894323662092e+00},
	{"GXR", -2.378019349141007e+01, -3.415682339147248e+00},
	{"GXS", -2.813947832788926e+01, -7.774967175626437e+00},
	{"GXT", -2.348951006185350e+01, -3.124998909590674e+00},
	{"GXU", -2.735247566139807e+01, -6.987964509135247e+00},
	{"GXV", -2.697404337760528e+01, -6.609532225342457e+00},
	{"GXW", -2.375430932853616e+01, -3.389798176273331e+00},
	{"GXX", -2.220788021365847e+01, -1.843369061395639e+00},
	{"GXY", -2.794666395946146e+01, -7.582152807198638e+00},
	{"GXZ", -4.176642522882452e+01, -2.140191407656169e+01},
	{"GYA", -1.652792473292827e+01, -4.188803425852874e+00},
	{"GYB", -1.863852572326993e+01, -6.299404416194529e+00},
	{"GYC", -1.914826255549866e+01, -6.809141248423261e+00},
	{"GYD", -2.006352227984044e+01, -7.724400972765041e+00},
	{"GYE", -1.544848090441730e+01, -3.109359597341903e+00},
	{"GYF", -1.855956094687985e+01, -6.220439639804456e+00},
	{"GYG", -2.034854772955342e+01, -8.009426422478025e+00},
	{"GYH", -1.859679623952573e+01, -6.257674932450333e+00},
	{"GYI", -1.722162807802842e+01, -4.882506770953018e+00},
	{"GYJ", -2.733291919953472e+01, -1.499379789245932e+01},
	{"GYK", -2.712887740557347e+01, -1.478975609849807e+01},
	{"GYL", -1.986078977686345e+01, -7.521668469788048e+00},
	{"GYM", -1.791724051644355e+01, -5.578119209368155e+00},
	{"GYN", -1.987566999759057e+01, -7.536548690515173e+00},
	{"GYO", -1.428162715337766e+01, -1.942505846302267e+00},
	{"GYP", -1.379761758256103e+01, -1.458496275485633e+00},
	{"GYQ", -2.924935035762757e+01, -1.691022905055217e+01},
	{"GYR", -1.916167043097299e+01, -6.822549123897587e+00},
	{"GYS", -1.832247560711969e+01, -5.983354300044295e+00},
	{"GYT", -1.722144054996211e+01, -4.882319242886712e+00},
	{"GYU", -2.036566320878045e+01, -8.026541901705057e+00},
	{"GYV", -2.702404068314852e+01, -1.468491937607312e+01},
	{"GYW", -1.804160657204749e+01, -5.702485264972092e+00},
	{"GYX", -3.133228152310620e+01, -1.899316021603081e+01},
	{"GYY", -2.205776516596841e+01, -9.718643858893010e+00},
	{"GYZ", -3.066634366940312e+01, -1.832722236232772e+01},
	{"GZA", -2.043535631047661e+01, -1.482591644181562e+00},
	{"GZB", -2.908392553738122e+01, -1.013116087108617e+01},
	{"GZC", -2.996884035562280e+01, -1.101607568932774e+01},
	{"GZD", -3.032800619702563e+01, -1.137524153073058e+01},
	{"GZE", -2.041712522979352e+01, -1.464360563498468e+00},
	{"GZF", -2.991513776340022e+01, -1.096237309710517e+01},
	{"GZG", -3.043810693652744e+01, -1.148534227023239e+01},
	{"GZH", -2.905484406667733e+01, -1.010207940038227e+01},
	{"GZI", -2.187404620632551e+01, -2.921281540030458e+00},
	{"GZJ", -3.296183163868461e+01, -1.400906697238955e+01},
	{"GZK", -3.159733169907096e+01, -1.264456703277590e+01},
	{"GZL", -2.728756683571741e+01, -8.334802169422360e+00},
	{"GZM", -2.949582276540742e+01, -1.054305809911238e+01},
	{"GZN", -3.059865039402707e+01, -1.164588572773202e+01},
	{"GZO", -2.204755308252360e+01, -3.094788416228547e+00},
	{"GZP", -2.841421511425727e+01, -9.461450447962216e+00},
	{"GZQ", -3.637191912535934e+01, -1.741915445906428e+01},
	{"GZR", -2.762697176425964e+01, -8.674207097964588e+00},
	{"GZS", -2.924579450731554e+01, -1.029302984102049e+01},
	{"GZT", -2.774572678843888e+01, -8.792962122143827e+00},
	{"GZU", -2.714796517353495e+01, -8.195200507239903e+00},
	{"GZV", -3.004552633215225e+01, -1.109276166585719e+01},
	{"GZW", -2.870901350728811e+01, -9.756248840993061e+00},
	{"GZX", -3.968618208945279e+01, -2.073341742315774e+01},
	{"GZY", -2.812166133777846e+01, -9.168896671483409e+00},
	{"GZZ", -2.571653964293489e+01, -6.763774976639839e+00},
	{"HAA", -1.710261303409465e+01, -1.049081435964600e+01},
	{"HAB", -1.283110798873794e+01, -6.219309314289298e+00},
	{"HAC", -1.427991956107537e+01, -7.668120886626720e+00},
	{"HAD", -9.819725835627265e+00, -3.207927161178620e+00},
	{"HAE", -1.588519533717380e+01, -9.273396662725155e+00},
	{"HAF", -1.463847627299760e+01, -8.026677598548956e+00},
	{"HAG", -1.415735440576876e+01, -7.545555731320118e+00},
	{"HAH", -1.521822405205098e+01, -8.606425377602335e+00},
	{"HAI", -1.327575694069641e+01, -6.663958266247762e+00},
	{"HAJ", -1.919348499428655e+01, -1.258168631983791e+01},
	{"HAK", -1.513250634422796e+01, -8.520707669779313e+00},
	{"HAL", -9.653448655902652e+00, -3.041649981454006e+00},
	{"HAM", -1.235746501214936e+01, -5.745666337700716e+00},
	{"HAN", -9.476313113992935e+00, -2.864514439544290e+00},
	{"HAO", -1.713329089014165e+01, -1.052149221569300e+01},
	{"HAP", -1.206125941667757e+01, -5.449460742228928e+00},
	{"HAQ", -1.971609153588593e+01, -1.310429286143729e+01},
	{"HAR", -1.081311675477008e+01, -4.201318080321438e+00},
	{"HAS", -1.074379811933576e+01, -4.131999444887119e+00},
	{"HAT", -8.219663435295104e+00, -1.607864760846458e+00},
	{"HAU", -1.451836794905138e+01, -7.906569274602730e+00},
	{"HAV", -9.997534844036943e+00, -3.385736169588298e+00},
	{"HAW", -1.476081574651302e+01, -8.149017072064369e+00},
	{"HAX", -1.890974002898482e+01, -1.229794135453618e+01},
	{"HAY", -1.700882348726922e+01, -1.039702481282057e+01},
	{"HAZ", -1.574707169514232e+01, -9.135273020693672e+00},
	{"HBA", -1.588439950537609e+01, -4.012053791475152e+00},
	{"HBB", -2.684224106125598e+01, -1.496989534735504e+01},
	{"HBC", -2.001077202882524e+01, -8.138426314924306e+00},
	{"HBD", -2.885221597909195e+01, -1.697987026519102e+01},
	{"HBE", -1.381119966586546e+01, -1.938853951964521e+00},
	{"HBF", -3.044102089647444e+01, -1.856867518257350e+01},
	{"HBG", -3.203754399010046e+01, -2.016519827619953e+01},
	{"HBH", -2.927944052394054e+01, -1.740709481003961e+01},
	{"HBI", -1.681538861527291e+01, -4.943042901371975e+00},
	{"HBJ", -2.683802620527142e+01, -1.496568049137048e+01},
	{"HBK", -3.226759416901868e+01, -2.039524845511774e+01},
	{"HBL", -1.632039680979008e+01, -4.448051095889142e+00},
	{"HBM", -2.860987463286951e+01, -1.673752891896857e+01},
	{"HBN", -2.938747432058852e+01, -1.751512860668759e+01},
	{"HBO", -1.390876376692180e+01, -2.036418053020858e+00},
	{"HBP", -3.010258959442513e+01, -1.823024388052419e+01},
	{"HBQ", -3.616075001220858e+01, -2.428840429830764e+01},
	{"HBR", -1.539136941158687e+01, -3.519023697685931e+00},
	{"HBS", -2.333155372681965e+01, -1.145920801291872e+01},
	{"HBT", -2.258606808728943e+01, -1.071372237338850e+01},
	{"HBU", -1.449971905298196e+01, -2.627373339081022e+00},
	{"HBV", -3.007525664165934e+01, -1.820291092775841e+01},
	{"HBW", -2.212520880581918e+01, -1.025286309191825e+01},
	{"HBX", -3.944795785144918e+01, -2.757561213754825e+01},
	{"HBY", -1.518541563917386e+01, -3.313069925272925e+00},
	{"HBZ", -3.395606172721658e+01, -2.208371601331565e+01},
	{"HCA", -1.389206734816396e+01, -2.047745521190183e+00},
	{"HCB", -1.932561891366874e+01, -7.481297086694958e+00},
	{"HCC", -2.508140206434355e+01, -1.323708023736977e+01},
	{"HCD", -2.212003441403244e+01, -1.027571258705866e+01},
	{"HCE", -1.511196255165978e+01, -3.267640724686004e+00},
	{"HCF", -2.970511753362299e+01, -1.786079570664922e+01},
	{"HCG", -3.065661387176283e+01, -1.881229204478905e+01},
	{"HCH", -1.511608507643168e+01, -3.271763249457903e+00},
	{"HCI", -1.741559325544791e+01, -5.571271428474135e+00},
	{"HCJ", -3.262921828728296e+01, -2.078489646030918e+01},
	{"HCK", -2.434341694520458e+01, -1.249909511823079e+01},
	{"HCL", -1.632991409955793e+01, -4.485592272584150e+00},
	{"HCM", -2.961758824738289e+01, -1.777326642040912e+01},
	{"HCN", -2.271226766773666e+01, -1.086794584076289e+01},
	{"HCO", -1.314022091513065e+01, -1.295899088156873e+00},
	{"HCP", -2.890253684160117e+01, -1.705821501462739e+01},
	{"HCQ", -2.901352900006756e+01, -1.716920717309378e+01},
	{"HCR", -1.637330313327002e+01, -4.528981306296246e+00},
	{"HCS", -2.266720065880630e+01, -1.082287883183252e+01},
	{"HCT", -2.239586540029086e+01, -1.055154357331708e+01},
	{"HCU", -1.735112105314570e+01, -5.506799226171921e+00},
	{"HCV", -3.227866088940847e+01, -2.043433906243469e+01},
	{"HCW", -2.798692471874411e+01, -1.614260289177033e+01},
	{"HCX", -3.362201660607366e+01, -2.177769477909988e+01},
	{"HCY", -1.979894760021307e+01, -7.954625773239291e+00},
	{"HCZ", -3.220834568841712e+01, -2.036402386144334e+01},
	{"HDA", -1.448457215399013e+01, -2.160797300189993e+00},
	{"HDB", -2.177233402518252e+01, -9.448559171382389e+00},
	{"HDC", -2.509140119211518e+01, -1.276762633831505e+01},
	{"HDD", -2.242818770079065e+01, -1.010441284699052e+01},
	{"HDE", -1.435279098680289e+01, -2.029016133002762e+00},
	{"HDF", -2.189372103940345e+01, -9.569946185603319e+00},
	{"HDG", -2.532607604686224e+01, -1.300230119306211e+01},
	{"HDH", -2.177370915474826e+01, -9.449934300948128e+00},
	{"HDI", -1.473439257834324e+01, -2.410617724543106e+00},
	{"HDJ", -2.695353969621928e+01, -1.462976484241915e+01},
	{"HDK", -2.813102766083804e+01, -1.580725280703791e+01},
	{"HDL", -2.515466337021279e+01, -1.283088851641266e+01},
	{"HDM", -2.470869177244909e+01, -1.238491691864895e+01},
	{"HDN", -2.497777683500366e+01, -1.265400198120353e+01},
	{"HDO", -1.522838211631925e+01, -2.904607262519115e+00},
	{"HDP", -2.160791708299266e+01, -9.284142229192526e+00},
	{"HDQ", -2.369401315049916e+01, -1.137023829669903e+01},
	{"HDR", -1.516546603958302e+01, -2.841691185782884e+00},
	{"HDS", -2.128834432491024e+01, -8.964569471110110e+00},
	{"HDT", -2.030616426790917e+01, -7.982389414109042e+00},
	{"HDU", -1.723270784767087e+01, -4.908932993870738e+00},
	{"HDV", -2.354215992583451e+01, -1.121838507203438e+01},
	{"HDW", -1.794254648991318e+01, -5.618771636113053e+00},
	{"HDX", -3.447410949262576e+01, -2.215033463882563e+01},
	{"HDY", -2.106075213852413e+01, -8.736977284723993e+00},
	{"HDZ", -3.055655129294426e+01, -1.823277643914412e+01},
	{"HEA", -9.230275408843140e+00, -4.185318954550802e+00},
	{"HEB", -1.024886042830085e+01, -5.203903974008513e+00},
	{"HEC", -9.229711200786232e+00, -4.184754746493892e+00},
	{"HED", -9.645822566084364e+00, -4.600866111792024e+00},
	{"HEE", -9.722257156713720e+00, -4.677300702421381e+00},
	{"HEF", -9.867581261357108e+00, -4.822624807064769e+00},
	{"HEG", -1.045387350129192e+01, -5.408917046999583e+00},
	{"HEH", -9.985424966673998e+00, -4.940468512381657e+00},
	{"HEI", -9.430244332098447e+00, -4.385287877806107e+00},
	{"HEJ", -1.334698353416678e+01, -8.302027079874442e+00},
	{"HEK", -1.150293848580761e+01, -6.457982031515275e+00},
	{"HEL", -9.321060842624677e+00, -4.276104388332337e+00},
	{"HEM", -8.915438835592388e+00, -3.870482381300049e+00},
	{"HEN", -9.156841423263669e+00, -4.111884968971331e+00},
	{"HEO", -1.091593865589630e+01, -5.870982201603964e+00},
	{"HEP", -9.407512193386124e+00, -4.362555739093784e+00},
	{"HEQ", -1.407844099302340e+01, -9.033484538731058e+00},
	{"HER", -7.837090111256896e+00, -2.792133656964557e+00},
	{"HES", -8.440592012734173e+00, -3.395635558441834e+00},
	{"HET", -9.774124713217104e+00, -4.729168258924765e+00},
	{"HEU", -1.199848635625397e+01, -6.953529901961633e+00},
	{"HEV", -1.189128170832913e+01, -6.846325254036792e+00},
	{"HEW", -9.539154816488658e+00, -4.494198362196319e+00},
	{"HEX", -1.559356671850135e+01, -1.054861026420901e+01},
	{"HEY", -9.553087199127988e+00, -4.508130744835649e+00},
	{"HEZ", -1.595716210053530e+01, -1.091220564624296e+01},
	{"HFA", -1.535552251251314e+01, -3.496515579503409e+00},
	{"HFB", -2.645781256489425e+01, -1.459880563188452e+01},
	{"HFC", -2.587138148406954e+01, -1.401237455105981e+01},
	{"HFD", -2.675365760500848e+01, -1.489465067199876e+01},
	{"HFE", -1.596316093447170e+01, -4.104154001461969e+00},
	{"HFF", -2.076943402335272e+01, -8.910427090342989e+00},
	{"HFG", -2.640778731273412e+01, -1.454878037972438e+01},
	{"HFH", -2.248251970190575e+01, -1.062351276889602e+01},
	{"HFI", -1.524580649179663e+01, -3.386799558786901e+00},
	{"HFJ", -2.719652169878395e+01, -1.533751476577422e+01},
	{"HFK", -2.909270246373348e+01, -1.723369553072375e+01},
	{"HFL", -1.602934228978789e+01, -4.170335356778161e+00},
	{"HFM", -2.553964774008464e+01, -1.368064080707491e+01},
	{"HFN", -2.716144358337488e+01, -1.530243665036515e+01},
	{"HFO", -1.327648544623402e+01, -1.417478513224290e+00},
	{"HFP", -2.607192153032284e+01, -1.421291459731311e+01},
	{"HFQ", -3.133954803400606e+01, -1.948054110099633e+01},
	{"HFR", -1.447782451963139e+01, -2.618817586621664e+00},
	{"HFS", -2.539950834742088e+01, -1.354050141441115e+01},
	{"HFT", -1.811815748031785e+01, -6.259150547308119e+00},
	{"HFU", -1.466511951643889e+01, -2.806112583429164e+00},
	{"HFV", -2.837353032731051e+01, -1.651452339430078e+01},
	{"HFW", -2.612584525190918e+01, -1.426683831889945e+01},
	{"HFX", -3.365091953833956e+01, -2.179191260532984e+01},
	{"HFY", -1.931833490179071e+01, -7.459327968780979e+00},
	{"HFZ", -2.977951299786610e+01, -1.792050606485637e+01},
	{"HGA", -1.621575825929152e+01, -3.373144299939677e+00},
	{"HGB", -2.644973057333121e+01, -1.360711661397936e+01},
	{"HGC", -2.354714311279961e+01, -1.070452915344777e+01},
	{"HGD", -2.657231491213298e+01, -1.372970095278113e+01},
	{"HGE", -1.617310316984075e+01, -3.330489210488905e+00},
	{"HGF", -2.625589368737566e+01, -1.341327972802381e+01},
	{"HGG", -2.639738382741385e+01, -1.355476986806201e+01},
	{"HGH", -2.226480608634082e+01, -9.422192126988973e+00},
	{"HGI", -1.574764318262601e+01, -2.905029223274165e+00},
	{"HGJ", -2.992523443535737e+01, -1.708262047600552e+01},
	{"HGK", -3.016354836865461e+01, -1.732093440930277e+01},
	{"HGL", -1.737092553686991e+01, -4.528311577518067e+00},
	{"HGM", -2.620767870297783e+01, -1.336506474362598e+01},
	{"HGN", -2.532030353849525e+01, -1.247768957914341e+01},
	{"HGO", -1.443038926337035e+01, -1.587775304018507e+00},
	{"HGP", -2.669347085987962e+01, -1.385085690052778e+01},
	{"HGQ", -3.145662746327267e+01, -1.861401350392083e+01},
	{"HGR", -1.479408505241991e+01, -1.951471093068070e+00},
	{"HGS", -2.453344762982977e+01, -1.169083367047792e+01},
	{"HGT", -2.364615984530966e+01, -1.080354588595782e+01},
	{"HGU", -1.787273389189225e+01, -5.030119932540408e+00},
	{"HGV", -2.929706924519317e+01, -1.645445528584132e+01},
	{"HGW", -2.203030334090490e+01, -9.187689381553055e+00},
	{"HGX", -3.467544792972004e+01, -2.183283397036819e+01},
	{"HGY", -2.664953809694313e+01, -1.380692413759128e+01},
	{"HGZ", -3.326370144375226e+01, -2.042108748440041e+01},
	{"HHA", -1.286624234970560e+01, -2.086545325760023e+00},
	{"HHB", -2.268263725050949e+01, -1.190294022656391e+01},
	{"HHC", -2.364606750727937e+01, -1.286637048333379e+01},
	{"HHD", -2.847452475804810e+01, -1.769482773410253e+01},
	{"HHE", -1.232546996941586e+01, -1.545772945470279e+00},
	{"HHF", -2.800975683725770e+01, -1.723005981331213e+01},
	{"HHG", -2.899336386359982e+01, -1.821366683965424e+01},
	{"HHH", -2.168029410430536e+01, -1.090059708035978e+01},
	{"HHI", -1.229373176900562e+01, -1.514034745060042e+00},
	{"HHJ", -3.091179389272978e+01, -2.013209686878420e+01},
	{"HHK", -3.123539728144718e+01, -2.045570025750160e+01},
	{"HHL", -2.853416842939644e+01, -1.775447140545086e+01},
	{"HHM", -2.753509503807292e+01, -1.675539801412734e+01},
	{"HHN", -2.844609696490847e+01, -1.766639994096289e+01},
	{"HHO", -1.495728843059937e+01, -4.177591406653793e+00},
	{"HHP", -2.837893201677467e+01, -1.759923499282910e+01},
	{"HHQ", -3.266779178461875e+01, -2.188809476067318e+01},
	{"HHR", -2.633448333483368e+01, -1.555478631088811e+01},
	{"HHS", -2.357585974786385e+01, -1.279616272391828e+01},
	{"HHT", -2.061758767669671e+01, -9.837890652751131e+00},
	{"HHU", -1.708705809259068e+01, -6.307361068645107e+00},
	{"HHV", -3.113880103142766e+01, -2.035910400748208e+01},
	{"HHW", -2.712124904257322e+01, -1.634155201862765e+01},
	{"HHX", -3.666372881356191e+01, -2.588403178961634e+01},
	{"HHY", -1.989705468737905e+01, -9.117357663433479e+00},
	{"HHZ", -3.367561105943562e+01, -2.289591403549004e+01},
	{"HIA", -1.450031564380430e+01, -7.588543488740049e+00},
	{"HIB", -1.497649543263476e+01, -8.064723277570504e+00},
	{"HIC", -9.682767446098749e+00, -2.770995291034497e+00},
	{"HID", -1.415857233373348e+01, -7.246800178669230e+00},
	{"HIE", -1.298838254775747e+01, -6.076610392693222e+00},
	{"HIF", -1.554616951459791e+01, -8.634397359533656e+00},
	{"HIG", -1.256034063049996e+01, -5.648568475435708e+00},
	{"HIH", -1.525488582761522e+01, -8.343113672550963e+00},
	{"HII", -1.832481930809443e+01, -1.141304715303018e+01},
	{"HIJ", -1.886041707486007e+01, -1.194864491979582e+01},
	{"HIK", -1.739439740488496e+01, -1.048262524982071e+01},
	{"HIL", -1.080978130638721e+01, -3.898009151322954e+00},
	{"HIM", -9.818414313038772e+00, -2.906642157974519e+00},
	{"HIN", -9.629667144740756e+00, -2.717894989676502e+00},
	{"HIO", -1.495885996854814e+01, -8.047087813483889e+00},
	{"HIP", -1.256574768731785e+01, -5.653975532253594e+00},
	{"HIQ", -2.139082933078229e+01, -1.447905717571804e+01},
	{"HIR", -1.261481066033525e+01, -5.703038505270999e+00},
	{"HIS", -8.370079223772553e+00, -1.458307068708300e+00},
	{"HIT", -1.193574458921971e+01, -5.023972434155460e+00},
	{"HIU", -1.890561485782515e+01, -1.199384270276089e+01},
	{"HIV", -1.483417574899101e+01, -7.922403593926754e+00},
	{"HIW", -1.629140684166342e+01, -9.379634686599166e+00},
	{"HIX", -2.780662234987421e+01, -2.089485019480996e+01},
	{"HIY", -2.371624462736600e+01, -1.680447247230175e+01},
	{"HIZ", -1.796116092528894e+01, -1.104938877022469e+01},
	{"HJA", -1.793264021774673e+01, -3.171596229264929e+00},
	{"HJB", -2.924172125336505e+01, -1.448067726488324e+01},
	{"HJC", -3.008860295400038e+01, -1.532755896551858e+01},
	{"HJD", -3.198840274146290e+01, -1.722735875298110e+01},
	{"HJE", -1.654710043817225e+01, -1.786056449690441e+00},
	{"HJF", -2.371240856817527e+01, -8.951364579693466e+00},
	{"HJG", -3.069662953400647e+01, -1.593558554552466e+01},
	{"HJH", -2.987789832281051e+01, -1.511685433432871e+01},
	{"HJI", -2.087048460464621e+01, -6.109440616164405e+00},
	{"HJJ", -2.988856525699812e+01, -1.512752126851632e+01},
	{"HJK", -3.257713676486942e+01, -1.781609277638761e+01},
	{"HJL", -3.108596963410602e+01, -1.632492564562422e+01},
	{"HJM", -3.144189500783348e+01, -1.668085101935167e+01},
	{"HJN", -3.439196473648609e+01, -1.963092074800429e+01},
	{"HJO", -1.639775480767631e+01, -1.636710819194500e+00},
	{"HJP", -3.085374727065251e+01, -1.609270328217070e+01},
	{"HJQ", -3.383999901157839e+01, -1.907895502309658e+01},
	{"HJR", -3.006417374839883e+01, -1.530312975991703e+01},
	{"HJS", -2.139648452119955e+01, -6.635440532717740e+00},
	{"HJT", -3.059709988714648e+01, -1.583605589866468e+01},
	{"HJU", -1.675735126974289e+01, -1.996307281261088e+00},
	{"HJV", -3.745905223117924e+01, -2.269800824269743e+01},
	{"HJW", -2.983330827475021e+01, -1.507226428626841e+01},
	{"HJX", -4.013835763824807e+01, -2.537731364976626e+01},
	{"HJY", -3.660822838909268e+01, -2.184718440061087e+01},
	{"HJZ", -3.471322948255111e+01, -1.995218549406931e+01},
	{"HKA", -2.007859240991205e+01, -4.993945032712849e+00},
	{"HKB", -2.706321451993017e+01, -1.197856714273097e+01},
	{"HKC", -2.749508790225396e+01, -1.241044052505475e+01},
	{"HKD", -2.812829611463946e+01, -1.304364873744026e+01},
	{"HKE", -1.747916106515111e+01, -2.394513687951909e+00},
	{"HKF", -2.695962285805231e+01, -1.187497548085310e+01},
	{"HKG", -2.923222363536946e+01, -1.414757625817025e+01},
	{"HKH", -2.662992301223945e+01, -1.154527563504024e+01},
	{"HKI", -1.594935593018771e+01, -8.647085529885019e-01},
	{"HKJ", -3.081039811676990e+01, -1.572575073957069e+01},
	{"HKK", -3.014212820922220e+01, -1.505748083202299e+01},
	{"HKL", -2.652028205573636e+01, -1.143563467853715e+01},
	{"HKM", -2.749512541129434e+01, -1.241047803409513e+01},
	{"HKN", -1.730031443740264e+01, -2.215667060203430e+00},
	{"HKO", -2.196458637550228e+01, -6.879938998303066e+00},
	{"HKP", -2.784606505676051e+01, -1.276141767956131e+01},
	{"HKQ", -3.348953791134298e+01, -1.840489053414377e+01},
	{"HKR", -2.828006112077632e+01, -1.319541374357711e+01},
	{"HKS", -2.439997563447775e+01, -9.315328257278544e+00},
	{"HKT", -2.516486314165693e+01, -1.008021576445772e+01},
	{"HKU", -2.701226107547869e+01, -1.192761369827949e+01},
	{"HKV", -3.065055318261459e+01, -1.556590580541539e+01},
	{"HKW", -2.633637140560684e+01, -1.125172402840763e+01},
	{"HKX", -3.446158477723624e+01, -1.937693740003703e+01},
	{"HKY", -2.700659254229753e+01, -1.192194516509832e+01},
	{"HKZ", -3.256344766310598e+01, -1.747880028590677e+01},
	{"HLA", -1.509761449706866e+01, -2.714195971920191e+00},
	{"HLB", -2.574084784506022e+01, -1.335742931991175e+01},
	{"HLC", -2.260702802349283e+01, -1.022360949834436e+01},
	{"HLD", -2.365378721595878e+01, -1.127036869081031e+01},
	{"HLE", -1.435766864265277e+01, -1.974250117504303e+00},
	{"HLF", -2.549234819061481e+01, -1.310892966546635e+01},
	{"HLG", -2.717626524429782e+01, -1.479284671914935e+01},
	{"HLH", -2.660837235116565e+01, -1.422495382601718e+01},
	{"HLI", -1.462907276544987e+01, -2.245654240301398e+00},
	{"HLJ", -2.990904221227153e+01, -1.752562368712306e+01},
	{"HLK", -2.718058751591169e+01, -1.479716899076322e+01},
	{"HLL", -2.082398601820050e+01, -8.440567493052033e+00},
	{"HLM", -2.625570449205673e+01, -1.387228596690827e+01},
	{"HLN", -2.696551411006427e+01, -1.458209558491581e+01},
	{"HLO", -1.486858242258671e+01, -2.485163897438246e+00},
	{"HLP", -2.624169496124546e+01, -1.385827643609699e+01},
	{"HLQ", -3.099774646710137e+01, -1.861432794195290e+01},
	{"HLR", -2.677238105197125e+01, -1.438896252682278e+01},
	{"HLS", -2.453859760878844e+01, -1.215517908363998e+01},
	{"HLT", -2.286130636592866e+01, -1.047788784078019e+01},
	{"HLU", -1.884241217226185e+01, -6.458993647113378e+00},
	{"HLV", -2.654170701411898e+01, -1.415828848897051e+01},
	{"HLW", -2.623813231951434e+01, -1.385471379436587e+01},
	{"HLX", -3.429971465122887e+01, -2.191629612608040e+01},
	{"HLY", -1.480571457125217e+01, -2.422296046103695e+00},
	{"HLZ", -3.296120512434464e+01, -2.057778659919617e+01},
	{"HMA", -1.324691405759410e+01, -1.862568923769156e+00},
	{"HMB", -2.183365662484138e+01, -1.044931149101643e+01},
	{"HMC", -1.946240801736398e+01, -8.078062883539031e+00},
	{"HMD", -1.925288132325957e+01, -7.868536189434624e+00},
	{"HME", -1.296545527024926e+01, -1.581110136424312e+00},
	{"HMF", -2.260868069376991e+01, -1.122433555994496e+01},
	{"HMG", -2.802563971085010e+01, -1.664129457702516e+01},
	{"HMH", -2.344821037910936e+01, -1.206386524528441e+01},
	{"HMI", -1.515647078711322e+01, -3.772125653288279e+00},
	{"HMJ", -2.945525149503358e+01, -1.807090636120864e+01},
	{"HMK", -2.975919842094563e+01, -1.837485328712068e+01},
	{"HML", -2.728197299643190e+01, -1.589762786260695e+01},
	{"HMM", -2.430524672527755e+01, -1.292090159145259e+01},
	{"HMN", -2.134755968660477e+01, -9.963214552779821e+00},
	{"HMO", -1.403539209012348e+01, -2.651046956298528e+00},
	{"HMP", -2.133607957726729e+01, -9.951734443442339e+00},
	{"HMQ", -3.237201048956016e+01, -2.098766535573521e+01},
	{"HMR", -1.819111685257155e+01, -6.806771718746602e+00},
	{"HMS", -1.892472232292451e+01, -7.540377189099561e+00},
	{"HMT", -2.115529512454258e+01, -9.770949990717630e+00},
	{"HMU", -1.588828456572037e+01, -4.503939431895416e+00},
	{"HMV", -2.910343990604233e+01, -1.771909477221738e+01},
	{"HMW", -2.253136612960899e+01, -1.114702099578404e+01},
	{"HMX", -3.401169994651362e+01, -2.262735481268868e+01},
	{"HMY", -1.490881009525480e+01, -3.524464961429859e+00},
	{"HMZ", -3.264077406554050e+01, -2.125642893171556e+01},
	{"HNA", -1.572126059746798e+01, -3.425913536807480e+00},
	{"HNB", -1.866164159353671e+01, -6.366294532876218e+00},
	{"HNC", -1.813093376766590e+01, -5.835586707005405e+00},
	{"HND", -1.948708042799955e+01, -7.191733367339054e+00},
	{"HNE", -1.486036458550836e+01, -2.565017524847859e+00},
	{"HNF", -1.937232071867624e+01, -7.076973658015741e+00},
	{"HNG", -2.045796510287312e+01, -8.162618042212625e+00},
	{"HNH", -1.849301296816630e+01, -6.197665907505803e+00},
	{"HNI", -1.624121763420564e+01, -3.945870573545147e+00},
	{"HNJ", -2.038734924163902e+01, -8.092002180978520e+00},
	{"HNK", -2.166120956012611e+01, -9.365862499465617e+00},
	{"HNL", -2.067502601098600e+01, -8.379678950325498e+00},
	{"HNM", -1.924253380251940e+01, -6.947186741858904e+00},
	{"HNN", -1.998926520776292e+01, -7.693918147102421e+00},
	{"HNO", -1.334137637868773e+01, -1.046029318027226e+00},
	{"HNP", -2.087444235000589e+01, -8.579095289345394e+00},
	{"HNQ", -2.054309881744269e+01, -8.247751756782192e+00},
	{"HNR", -1.925107271133355e+01, -6.955725650673056e+00},
	{"HNS", -1.693035701762955e+01, -4.635009956969053e+00},
	{"HNT", -1.826002172726286e+01, -5.964674666602362e+00},
	{"HNU", -1.803897713136170e+01, -5.743630070701208e+00},
	{"HNV", -2.263803126329886e+01, -1.034268420263836e+01},
	{"HNW", -1.818367833279043e+01, -5.888331272129932e+00},
	{"HNX", -3.065556812867332e+01, -1.836022106801282e+01},
	{"HNY", -2.522089682841463e+01, -1.292554976775413e+01},
	{"HNZ", -3.116427317245291e+01, -1.886892611179241e+01},
	{"HOA", -1.428122341366399e+01, -6.662629696645249e+00},
	{"HOB", -1.518981467263876e+01, -7.571220955620021e+00},
	{"HOC", -1.436255318967353e+01, -6.743959472654796e+00},
	{"HOD", -1.393633483049756e+01, -6.317741113478816e+00},
	{"HOE", -1.506349411003126e+01, -7.444900393012520e+00},
	{"HOF", -1.174418969221287e+01, -4.125595975194132e+00},
	{"HOG", -1.644063479592844e+01, -8.822041078909699e+00},
	{"HOH", -1.333153788621498e+01, -5.712944169196243e+00},
	{"HOI", -1.387902765418247e+01, -6.260433937163727e+00},
	{"HOJ", -2.012322559195951e+01, -1.250463187494077e+01},
	{"HOK", -1.659725770684978e+01, -8.978663989831039e+00},
	{"HOL", -1.094053727976035e+01, -3.321943562741605e+00},
	{"HOM", -1.200813662007681e+01, -4.389542903058071e+00},
	{"HON", -1.238786686195309e+01, -4.769273144934354e+00},
	{"HOO", -1.282037337686302e+01, -5.201779659844283e+00},
	{"HOP", -1.298270475285555e+01, -5.364111035836814e+00},
	{"HOQ", -2.139429687321658e+01, -1.377570315619783e+01},
	{"HOR", -1.147311488551514e+01, -3.854521168496404e+00},
	{"HOS", -1.113738782586256e+01, -3.518794108843818e+00},
	{"HOT", -1.270069537965105e+01, -5.082101662632311e+00},
	{"HOU", -9.177043112930201e+00, -1.558449395911461e+00},
	{"HOV", -1.535033886316073e+01, -7.731745146141986e+00},
	{"HOW", -1.098851691905167e+01, -3.369923202032930e+00},
	{"HOX", -1.962927787849390e+01, -1.201068416147516e+01},
	{"HOY", -1.906483287377257e+01, -1.144623915675384e+01},
	{"HOZ", -2.025800816078609e+01, -1.263941444376735e+01},
	{"HPA", -1.457416760676629e+01, -2.345985494239588e+00},
	{"HPB", -2.813764669785010e+01, -1.590946458532340e+01},
	{"HPC", -2.903351850754913e+01, -1.680533639502244e+01},
	{"HPD", -2.957036112564094e+01, -1.734217901311424e+01},
	{"HPE", -1.507984517335075e+01, -2.851663060824055e+00},
	{"HPF", -2.811243641018041e+01, -1.588425429765371e+01},
	{"HPG", -2.892156519998006e+01, -1.669338308745336e+01},
	{"HPH", -1.763891892544866e+01, -5.410736812921967e+00},
	{"HPI", -1.674251433007579e+01, -4.514332217549094e+00},
	{"HPJ", -3.174582250024546e+01, -1.951764038771877e+01},
	{"HPK", -3.162874310826437e+01, -1.940056099573767e+01},
	{"HPL", -1.527785858937998e+01, -3.049676476853282e+00},
	{"HPM", -2.733246098198973e+01, -1.510427886946303e+01},
	{"HPN", -2.946145155900582e+01, -1.723326944647912e+01},
	{"HPO", -1.520223334079403e+01, -2.974051228267336e+00},
	{"HPP", -2.003504996049792e+01, -7.806867847971223e+00},
	{"HPQ", -3.300209316590661e+01, -2.077391105337991e+01},
	{"HPR", -1.409049938572110e+01, -1.862317273194400e+00},
	{"HPS", -2.009344723113737e+01, -7.865265118610671e+00},
	{"HPT", -2.397234596956944e+01, -1.174416385704274e+01},
	{"HPU", -1.619781038842227e+01, -3.969628275895574e+00},
	{"HPV", -3.116006080115024e+01, -1.893187868862355e+01},
	{"HPW", -2.266237546679589e+01, -1.043419335426919e+01},
	{"HPX", -3.650327187131441e+01, -2.427508975878771e+01},
	{"HPY", -2.263123552825301e+01, -1.040305341572632e+01},
	{"HPZ", -3.480838749676550e+01, -2.258020538423881e+01},
	{"HQA", -2.833875845367537e+01, -1.182171657330459e+01},
	{"HQB", -3.096618040081765e+01, -1.444913852044687e+01},
	{"HQC", -2.987717961871452e+01, -1.336013773834375e+01},
	{"HQD", -3.148788426090757e+01, -1.497084238053679e+01},
	{"HQE", -3.187577880505182e+01, -1.535873692468104e+01},
	{"HQF", -3.023468320430843e+01, -1.371764132393765e+01},
	{"HQG", -3.695150717868993e+01, -2.043446529831915e+01},
	{"HQH", -3.078624186116755e+01, -1.426919998079677e+01},
	{"HQI", -2.667780246905961e+01, -1.016076058868883e+01},
	{"HQJ", -3.275155363630935e+01, -1.623451175593857e+01},
	{"HQK", -3.858369237362867e+01, -2.206665049325789e+01},
	{"HQL", -3.121631860300814e+01, -1.469927672263736e+01},
	{"HQM", -3.039926784739397e+01, -1.388222596702319e+01},
	{"HQN", -3.323555996943861e+01, -1.671851808906783e+01},
	{"HQO", -3.143200580016405e+01, -1.491496391979327e+01},
	{"HQP", -3.142000437345056e+01, -1.490296249307977e+01},
	{"HQQ", -3.331559413532700e+01, -1.679855225495622e+01},
	{"HQR", -3.128089463804177e+01, -1.476385275767099e+01},
	{"HQS", -2.835320679333052e+01, -1.183616491295974e+01},
	{"HQT", -2.885287779726482e+01, -1.233583591689405e+01},
	{"HQU", -1.652028122609299e+01, -3.239345722205765e-03},
	{"HQV", -3.414674781568029e+01, -1.762970593530950e+01},
	{"HQW", -3.050500063982655e+01, -1.398795875945578e+01},
	{"HQX", -4.060682433151160e+01, -2.408978245114082e+01},
	{"HQY", -3.479954453295839e+01, -1.828250265258761e+01},
	{"HQZ", -4.174639176826214e+01, -2.522934988789135e+01},
	{"HRA", -1.409710674934404e+01, -3.913373318758332e+00},
	{"HRB", -2.605275453017239e+01, -1.586902109958667e+01},
	{"HRC", -2.323429444598110e+01, -1.305056101539539e+01},
	{"HRD", -2.289364938552808e+01, -1.270991595494237e+01},
	{"HRE", -1.156734444092992e+01, -1.383611010344207e+00},
	{"HRF", -2.588216280608915e+01, -1.569842937550344e+01},
	{"HRG", -2.550525046612500e+01, -1.532151703553929e+01},
	{"HRH", -2.132492974510802e+01, -1.114119631452231e+01},
	{"HRI", -1.315289418050382e+01, -2.969160749918105e+00},
	{"HRJ", -2.897545619831959e+01, -1.879172276773388e+01},
	{"HRK", -2.584288260988048e+01, -1.565914917929477e+01},
	{"HRL", -2.571017666059230e+01, -1.552644323000658e+01},
	{"HRM", -2.313352729799880e+01, -1.294979386741309e+01},
	{"HRN", -2.477334156683297e+01, -1.458960813624726e+01},
	{"HRO", -1.153515293361477e+01, -1.351419503029058e+00},
	{"HRP", -2.597562234828096e+01, -1.579188891769525e+01},
	{"HRQ", -3.036199232856036e+01, -2.017825889797465e+01},
	{"HRR", -2.328882638370120e+01, -1.310509295311549e+01},
	{"HRS", -2.087510500977099e+01, -1.069137157918528e+01},
	{"HRT", -2.319027414091862e+01, -1.300654071033291e+01},
	{"HRU", -1.547392805735465e+01, -5.290194626768936e+00},
	{"HRV", -2.629313566847745e+01, -1.610940223789174e+01},
	{"HRW", -2.564870548409067e+01, -1.546497205350496e+01},
	{"HRX", -3.102711850131982e+01, -2.084338507073410e+01},
	{"HRY", -1.841135234764307e+01, -8.227618917057359e+00},
	{"HRZ", -3.195824103516607e+01, -2.177450760458036e+01},
	{"HSA", -1.374899834547882e+01, -2.916352579988443e+00},
	{"HSB", -1.766439936519441e+01, -6.831753599704030e+00},
	{"HSC", -1.617393905904166e+01, -5.341293293551277e+00},
	{"HSD", -1.845994803013317e+01, -7.627302264642791e+00},
	{"HSE", -1.412239079555202e+01, -3.289745030061640e+00},
	{"HSF", -1.789909494363513e+01, -7.066449178144754e+00},
	{"HSG", -1.900874112337678e+01, -8.176095357886396e+00},
	{"HSH", -1.344503446543309e+01, -2.612388699942704e+00},
	{"HSI", -1.468270305896641e+01, -3.850057293476029e+00},
	{"HSJ", -2.138483476370692e+01, -1.055218899821654e+01},
	{"HSK", -1.890440557205598e+01, -8.071759806565597e+00},
	{"HSL", -1.655500621611234e+01, -5.722360450621959e+00},
	{"HSM", -1.711205896605266e+01, -6.279413200562283e+00},
	{"HSN", -1.842115218085578e+01, -7.588506415365400e+00},
	{"HSO", -1.376102130912308e+01, -2.928375543632699e+00},
	{"HSP", -1.516474510495493e+01, -4.332099339464548e+00},
	{"HSQ", -1.791022674104834e+01, -7.077580975557960e+00},
	{"HSR", -1.911697823576213e+01, -8.284332470271746e+00},
	{"HSS", -1.692706834984685e+01, -6.094422584356467e+00},
	{"HST", -1.374078491207231e+01, -2.908139146581923e+00},
	{"HSU", -1.468007368447123e+01, -3.847427918980852e+00},
	{"HSV", -2.137528752202257e+01, -1.054264175653219e+01},
	{"HSW", -1.618040128911665e+01, -5.347755523626270e+00},
	{"HSX", -3.028035620751982e+01, -1.944771044202944e+01},
	{"HSY", -1.790725226264836e+01, -7.074606497157980e+00},
	{"HSZ", -3.172567996253467e+01, -2.089303419704428e+01},
	{"HTA", -1.243941383098175e+01, -4.087809273780663e+00},
	{"HTB", -1.362964616925485e+01, -5.278041612053764e+00},
	{"HTC", -1.545083066096285e+01, -7.099226103761759e+00},
	{"HTD", -1.542803172576628e+01, -7.076427168565192e+00},
	{"HTE", -1.215497078163037e+01, -3.803366224429286e+00},
	{"HTF", -1.390785108401609e+01, -5.556246526815001e+00},
	{"HTG", -1.621801061644480e+01, -7.866406059243715e+00},
	{"HTH", -9.555844867699294e+00, -1.204240310498209e+00},
	{"HTI", -1.279365534656454e+01, -4.442050789363450e+00},
	{"HTJ", -1.843241441862989e+01, -1.008080986142880e+01},
	{"HTK", -1.839579556091461e+01, -1.004419100371352e+01},
	{"HTL", -1.449634611985758e+01, -6.144741562656490e+00},
	{"HTM", -1.494318183918432e+01, -6.591577281983232e+00},
	{"HTN", -1.466308080150415e+01, -6.311476244303060e+00},
	{"HTO", -1.180142498053601e+01, -3.449820423334920e+00},
	{"HTP", -1.554312406926219e+01, -7.191519512061102e+00},
	{"HTQ", -2.091004457805995e+01, -1.255844002085886e+01},
	{"HTR", -1.449254392668206e+01, -6.140939369480976e+00},
	{"HTS", -1.282476951044204e+01, -4.473164953240949e+00},
	{"HTT", -1.223930272461046e+01, -3.887698167409376e+00},
	{"HTU", -1.498911382038857e+01, -6.637509263187480e+00},
	{"HTV", -1.825846829065115e+01, -9.906863733450065e+00},
	{"HTW", -1.370392806992817e+01, -5.352323512727085e+00},
	{"HTX", -2.171839542672031e+01, -1.336679086951923e+01},
	{"HTY", -1.375376618880005e+01, -5.402161631598965e+00},
	{"HTZ", -3.111738345549730e+01, -2.276577889829622e+01},
	{"HUA", -1.552545690766926e+01, -5.301213853284412e+00},
	{"HUB", -1.837715084939531e+01, -8.152907795010465e+00},
	{"HUC", -1.490516175332184e+01, -4.680918698936989e+00},
	{"HUD", -1.611462054161170e+01, -5.890377487226850e+00},
	{"HUE", -1.772536632106941e+01, -7.501123266684559e+00},
	{"HUF", -1.970235300235947e+01, -9.478109947974621e+00},
	{"HUG", -1.588595282222583e+01, -5.661709767840986e+00},
	{"HUH", -2.012004929117214e+01, -9.895806236787292e+00},
	{"HUI", -2.044183378136689e+01, -1.021759072698204e+01},
	{"HUJ", -2.371026745330909e+01, -1.348602439892424e+01},
	{"HUK", -2.209487890987332e+01, -1.187063585548847e+01},
	{"HUL", -1.756514756590472e+01, -7.340904511519867e+00},
	{"HUM", -1.350111589882450e+01, -3.276872844439655e+00},
	{"HUN", -1.207983003211225e+01, -1.855586977727404e+00},
	{"HUO", -2.361506732724756e+01, -1.339082427286271e+01},
	{"HUP", -1.522580686619898e+01, -5.001563811814132e+00},
	{"HUQ", -3.258100546775001e+01, -2.235676241336516e+01},
	{"HUR", -1.334447878197639e+01, -3.120235727591542e+00},
	{"HUS", -1.190319197366651e+01, -1.678948919281658e+00},
	{"HUT", -1.488144811003777e+01, -4.657205055652922e+00},
	{"HUU", -2.992417350107437e+01, -1.969993044668952e+01},
	{"HUV", -2.926328478756450e+01, -1.903904173317966e+01},
	{"HUW", -2.264379827153232e+01, -1.241955521714748e+01},
	{"HUX", -2.039436776099529e+01, -1.017012470661044e+01},
	{"HUY", -2.090494167209986e+01, -1.068069861771501e+01},
	{"HUZ", -2.054524385665652e+01, -1.032100080227167e+01},
	{"HVA", -1.703860539325244e+01, -2.038826815641438e+00},
	{"HVB", -3.326323509821875e+01, -1.826345652060774e+01},
	{"HVC", -3.339574185855124e+01, -1.839596328094024e+01},
	{"HVD", -3.270766355930299e+01, -1.770788498169198e+01},
	{"HVE", -1.659788270167175e+01, -1.598104124060745e+00},
	{"HVF", -3.291201080459052e+01, -1.791223222697952e+01},
	{"HVG", -3.422040319191201e+01, -1.922062461430100e+01},
	{"HVH", -3.193524416734046e+01, -1.693546558972945e+01},
	{"HVI", -1.670553052454127e+01, -1.705751946930269e+00},
	{"HVJ", -3.414326089255262e+01, -1.914348231494162e+01},
	{"HVK", -3.602286151533094e+01, -2.102308293771994e+01},
	{"HVL", -3.329510458701644e+01, -1.829532600940544e+01},
	{"HVM", -3.230556736864460e+01, -1.730578879103360e+01},
	{"HVN", -2.271733805653011e+01, -7.717559478919111e+00},
	{"HVO", -1.824700286379144e+01, -3.247224286180442e+00},
	{"HVP", -3.237821437372641e+01, -1.737843579611541e+01},
	{"HVQ", -3.997505628866642e+01, -2.497527771105542e+01},
	{"HVR", -3.033424992081720e+01, -1.533447134320619e+01},
	{"HVS", -2.271725965459815e+01, -7.717481076987146e+00},
	{"HVT", -3.068793501355044e+01, -1.568815643593943e+01},
	{"HVU", -2.271318198157377e+01, -7.713403403962769e+00},
	{"HVV", -3.486863345427731e+01, -1.986885487666630e+01},
	{"HVW", -3.201139308211967e+01, -1.701161450450866e+01},
	{"HVX", -3.660087710576308e+01, -2.160109852815208e+01},
	{"HVY", -2.842371954173365e+01, -1.342394096412265e+01},
	{"HVZ", -4.001075598832080e+01, -2.501097741070980e+01},
	{"HWA", -1.266939199959573e+01, -1.698892861270481e+00},
	{"HWB", -2.365512910608209e+01, -1.268462996775683e+01},
	{"HWC", -2.824598606220759e+01, -1.727548692388234e+01},
	{"HWD", -2.775947606233131e+01, -1.678897692400606e+01},
	{"HWE", -1.318362549628997e+01, -2.213126357964717e+00},
	{"HWF", -2.804106384846704e+01, -1.707056471014178e+01},
	{"HWG", -2.368617877097004e+01, -1.271567963264479e+01},
	{"HWH", -1.304350933415781e+01, -2.073010195832560e+00},
	{"HWI", -1.362717885932641e+01, -2.656679721001162e+00},
	{"HWJ", -3.052450174127011e+01, -1.955400260294486e+01},
	{"HWK", -3.067951420479612e+01, -1.970901506647087e+01},
	{"HWL", -2.710883138896233e+01, -1.613833225063708e+01},
	{"HWM", -2.780921656626229e+01, -1.683871742793704e+01},
	{"HWN", -2.468466866280185e+01, -1.371416952447660e+01},
	{"HWO", -1.483261503523376e+01, -3.862115896908508e+00},
	{"HWP", -2.889824236843500e+01, -1.792774323010975e+01},
	{"HWQ", -3.315186351514613e+01, -2.218136437682088e+01},
	{"HWR", -1.764930000527826e+01, -6.678800866953005e+00},
	{"HWS", -2.594484101157663e+01, -1.497434187325138e+01},
	{"HWT", -2.581486327671888e+01, -1.484436413839363e+01},
	{"HWU", -2.112884908187810e+01, -1.015834994355285e+01},
	{"HWV", -3.100203687779130e+01, -2.003153773946606e+01},
	{"HWW", -2.358071908877357e+01, -1.261021995044832e+01},
	{"HWX", -4.034566978127154e+01, -2.937517064294629e+01},
	{"HWY", -2.798455831893817e+01, -1.701405918061291e+01},
	{"HWZ", -3.386865343191069e+01, -2.289815429358545e+01},
	{"HXA", -2.450271739587249e+01, -3.989738486558553e+00},
	{"HXB", -2.907015035306138e+01, -8.557171443747441e+00},
	{"HXC", -2.403115001061153e+01, -3.518171101297592e+00},
	{"HXD", -2.846353850598133e+01, -7.950559596667389e+00},
	{"HXE", -2.189864751728577e+01, -1.385668607971831e+00},
	{"HXF", -2.860564797203683e+01, -8.092669062722891e+00},
	{"HXG", -2.990471251215259e+01, -9.391733602838649e+00},
	{"HXH", -2.626288633801590e+01, -5.749907428701961e+00},
	{"HXI", -2.410301529119384e+01, -3.590036381879901e+00},
	{"HXJ", -3.111768163817650e+01, -1.060470272886256e+01},
	{"HXK", -3.201576792862289e+01, -1.150278901930895e+01},
	{"HXL", -2.856300194544636e+01, -8.050023036132419e+00},
	{"HXM", -2.784618756344086e+01, -7.333208654126917e+00},
	{"HXN", -3.035520561999753e+01, -9.842226710683587e+00},
	{"HXO", -2.686055872651615e+01, -6.347579817202207e+00},
	{"HXP", -2.347894701719937e+01, -2.965968107885435e+00},
	{"HXQ", -3.001797728788965e+01, -9.504998378575708e+00},
	{"HXR", -2.863426443566254e+01, -8.121285526348602e+00},
	{"HXS", -2.792805013985399e+01, -7.415071230540054e+00},
	{"HXT", -2.327808187381823e+01, -2.765102964504291e+00},
	{"HXU", -2.714104747336280e+01, -6.628068564048863e+00},
	{"HXV", -2.676270167919236e+01, -6.249722769878417e+00},
	{"HXW", -2.795059707554352e+01, -7.437618166229580e+00},
	{"HXX", -2.754782851968777e+01, -7.034849610373825e+00},
	{"HXY", -2.773523577142619e+01, -7.222256862112256e+00},
	{"HXZ", -4.155499704078925e+01, -2.104201813147531e+01},
	{"HYA", -1.567712386137063e+01, -5.268143827036234e+00},
	{"HYB", -1.511529793866416e+01, -4.706317904329762e+00},
	{"HYC", -1.512304963629613e+01, -4.714069601961733e+00},
	{"HYD", -1.467527893687662e+01, -4.266298902542218e+00},
	{"HYE", -1.453615267961498e+01, -4.127172645280580e+00},
	{"HYF", -1.468856064314305e+01, -4.279580608808649e+00},
	{"HYG", -1.452313004905778e+01, -4.114150014723378e+00},
	{"HYH", -1.519932301843311e+01, -4.790342984098713e+00},
	{"HYI", -1.583873278136747e+01, -5.429752747033069e+00},
	{"HYJ", -1.767237898021513e+01, -7.263398945880724e+00},
	{"HYK", -1.785813863412611e+01, -7.449158599791715e+00},
	{"HYL", -1.529852610679106e+01, -4.889546072456663e+00},
	{"HYM", -1.494104379443346e+01, -4.532063760099060e+00},
	{"HYN", -1.538162541866867e+01, -4.972645384334275e+00},
	{"HYO", -1.360261108443820e+01, -3.193631050103797e+00},
	{"HYP", -1.466400651836500e+01, -4.255026484030604e+00},
	{"HYQ", -2.212165227994464e+01, -1.171267224561024e+01},
	{"HYR", -1.600708145273058e+01, -5.598101418396178e+00},
	{"HYS", -1.277672740039095e+01, -2.367747366056552e+00},
	{"HYT", -1.482167790376380e+01, -4.412697869429400e+00},
	{"HYU", -2.022569023850479e+01, -9.816710204170386e+00},
	{"HYV", -1.744985758608669e+01, -7.040877551752293e+00},
	{"HYW", -1.449634988020939e+01, -4.087369845874994e+00},
	{"HYX", -2.213099776156636e+01, -1.172201772723196e+01},
	{"HYY", -1.742992280746796e+01, -7.020942773133564e+00},
	{"HYZ", -3.041807314130695e+01, -2.000909310697255e+01},
	{"HZA", -2.056123965971040e+01, -3.036378504522750e+00},
	{"HZB", -2.905812046984516e+01, -1.153325931465751e+01},
	{"HZC", -2.994303528808674e+01, -1.241817413289909e+01},
	{"HZD", -3.030220112948957e+01, -1.277733997430192e+01},
	{"HZE", -1.914053699704777e+01, -1.615675841860122e+00},
	{"HZF", -2.988933269586417e+01, -1.236447154067652e+01},
	{"HZG", -3.041230186899138e+01, -1.288744071380373e+01},
	{"HZH", -2.902903899914127e+01, -1.150417784395362e+01},
	{"HZI", -1.894269429971880e+01, -1.417833144531156e+00},
	{"HZJ", -3.293602657114855e+01, -1.541116541596090e+01},
	{"HZK", -3.157152663153490e+01, -1.404666547634725e+01},
	{"HZL", -2.726176176818135e+01, -9.736900612993704e+00},
	{"HZM", -2.947001769787137e+01, -1.194515654268372e+01},
	{"HZN", -3.057284532649102e+01, -1.304798417130337e+01},
	{"HZO", -2.163756909680508e+01, -4.112707941617435e+00},
	{"HZP", -2.838841004672121e+01, -1.086354889153356e+01},
	{"HZQ", -3.685224046047189e+01, -1.932737930528424e+01},
	{"HZR", -2.760116669672358e+01, -1.007630554153593e+01},
	{"HZS", -2.921998943977948e+01, -1.169512828459183e+01},
	{"HZT", -2.771992172090282e+01, -1.019506056571517e+01},
	{"HZU", -2.071717989276840e+01, -3.192318737580751e+00},
	{"HZV", -3.001972126461619e+01, -1.249486010942854e+01},
	{"HZW", -2.868320843975205e+01, -1.115834728456440e+01},
	{"HZX", -3.966037702191673e+01, -2.213551586672908e+01},
	{"HZY", -2.809585627024240e+01, -1.057099511505475e+01},
	{"HZZ", -2.569073457539883e+01, -8.165873420211184e+00},
	{"IAA", -1.367560668675563e+01, -4.694240187282300e+00},
	{"IAB", -1.423973199489138e+01, -5.258365495418047e+00},
	{"IAC", -1.556371081562337e+01, -6.582344316150041e+00},
	{"IAD", -1.522241438059897e+01, -6.241047881125640e+00},
	{"IAE", -1.618649613148827e+01, -7.205129632014939e+00},
	{"IAF", -1.603704930237997e+01, -7.055682802906643e+00},
	{"IAG", -1.419797977581064e+01, -5.216613276337307e+00},
	{"IAH", -1.309106872780544e+01, -4.109702228332114e+00},
	{"IAI", -1.496352739537318e+01, -5.982160895899848e+00},
	{"IAJ", -1.980917715274561e+01, -1.082781065327228e+01},
	{"IAK", -1.787686199313852e+01, -8.895495493665196e+00},
	{"IAL", -1.137188045539467e+01, -2.390513955921337e+00},
	{"IAM", -1.233781870929057e+01, -3.356452209817246e+00},
	{"IAN", -1.079416032445368e+01, -1.812793824980350e+00},
	{"IAO", -1.600427168387698e+01, -7.022905184403654e+00},
	{"IAP", -1.600780877252425e+01, -7.026442273050926e+00},
	{"IAQ", -2.211936294185643e+01, -1.313799644238310e+01},
	{"IAR", -1.373344840071095e+01, -4.752081901237624e+00},
	{"IAS", -1.391409228657447e+01, -4.932725787101139e+00},
	{"IAT", -1.209599352932479e+01, -3.114627029851464e+00},
	{"IAU", -1.790334161791471e+01, -8.921975118441383e+00},
	{"IAV", -1.878048769483465e+01, -9.799121195361320e+00},
	{"IAW", -1.493313044946037e+01, -5.951763949987040e+00},
	{"IAX", -2.367146818697085e+01, -1.469010168749752e+01},
	{"IAY", -2.044218871955713e+01, -1.146082222008380e+01},
	{"IAZ", -1.990790534719957e+01, -1.092653884772625e+01},
	{"IBA", -1.531100297859846e+01, -4.811278467524934e+00},
	{"IBB", -1.687154113473595e+01, -6.371816623662417e+00},
	{"IBC", -2.053442459197935e+01, -1.003470008090581e+01},
	{"IBD", -2.170563742969350e+01, -1.120591291861997e+01},
	{"IBE", -1.215509422996754e+01, -1.655369718894007e+00},
	{"IBF", -2.271004328992805e+01, -1.221031877885452e+01},
	{"IBG", -2.371298875489641e+01, -1.321326424382288e+01},
	{"IBH", -2.071395857652977e+01, -1.021423406545624e+01},
	{"IBI", -1.408237217872973e+01, -3.582647667656203e+00},
	{"IBJ", -2.261522564181239e+01, -1.211550113073885e+01},
	{"IBK", -2.113310308023178e+01, -1.063337856915825e+01},
	{"IBL", -1.240190721225400e+01, -1.902182701180472e+00},
	{"IBM", -1.939382290681787e+01, -8.894098395744335e+00},
	{"IBN", -1.863035151116248e+01, -8.130627000088952e+00},
	{"IBO", -1.732096589311054e+01, -6.821241382037011e+00},
	{"IBP", -2.973050245277318e+01, -1.923077794169965e+01},
	{"IBQ", -3.578866287055664e+01, -2.528893835948311e+01},
	{"IBR", -1.412710259352282e+01, -3.627378082449289e+00},
	{"IBS", -1.853307856889569e+01, -8.033354057822155e+00},
	{"IBT", -2.010420384875729e+01, -9.604479337683756e+00},
	{"IBU", -1.303971696613961e+01, -2.539992455066081e+00},
	{"IBV", -2.970316950000741e+01, -1.920344498893387e+01},
	{"IBW", -2.071459872258276e+01, -1.021487421150923e+01},
	{"IBX", -3.907587070979724e+01, -2.857614619872371e+01},
	{"IBY", -1.774093583646671e+01, -7.241211325393177e+00},
	{"IBZ", -2.139664193400508e+01, -1.089691742293155e+01},
	{"ICA", -1.040633677667672e+01, -2.482256813163059e+00},
	{"ICB", -1.624292200989156e+01, -8.318842046377897e+00},
	{"ICC", -1.485286995056892e+01, -6.928789987055259e+00},
	{"ICD", -1.516024147244232e+01, -7.236161508928660e+00},
	{"ICE", -1.054964250881137e+01, -2.625562545297704e+00},
	{"ICF", -1.568527518353167e+01, -7.761195220018004e+00},
	{"ICG", -1.697719737927915e+01, -9.053117415765492e+00},
	{"ICH", -9.636335953982595e+00, -1.712255990468933e+00},
	{"ICI", -1.184367778699009e+01, -3.919597823476422e+00},
	{"ICJ", -1.939667383352278e+01, -1.147259387000912e+01},
	{"ICK", -1.206959031237958e+01, -4.145510348865918e+00},
	{"ICL", -1.384245626684003e+01, -5.918376303326365e+00},
	{"ICM", -1.579386667697036e+01, -7.869786713456699e+00},
	{"ICN", -1.713365939886097e+01, -9.209579435347313e+00},
	{"ICO", -1.293507534630827e+01, -5.010995382794607e+00},
	{"ICP", -1.488580762290251e+01, -6.961727659388848e+00},
	{"ICQ", -1.980833155142566e+01, -1.188425158791200e+01},
	{"ICR", -1.467455733366380e+01, -6.750477370150145e+00},
	{"ICS", -1.342523077835684e+01, -5.501150814843181e+00},
	{"ICT", -1.206230765245945e+01, -4.138227688945786e+00},
	{"ICU", -1.291480819926783e+01, -4.990728235754164e+00},
	{"ICV", -1.813374474920705e+01, -1.020966478569338e+01},
	{"ICW", -1.387635543088922e+01, -5.952275467375562e+00},
	{"ICX", -3.306553003866693e+01, -2.514145007515327e+01},
	{"ICY", -1.490440069173324e+01, -6.980320728219575e+00},
	{"ICZ", -2.139572394542580e+01, -1.347164398191214e+01},
	{"IDA", -1.245632747208617e+01, -3.872018246611506e+00},
	{"IDB", -1.445198959496118e+01, -5.867680369486523e+00},
	{"IDC", -1.547345445910811e+01, -6.889145233633449e+00},
	{"IDD", -1.362008452708168e+01, -5.035775301607019e+00},
	{"IDE", -1.025090632743704e+01, -1.666597101962381e+00},
	{"IDF", -1.495843959031294e+01, -6.374130364838286e+00},
	{"IDG", -1.437365290453954e+01, -5.789343679064880e+00},
	{"IDH", -1.333617817609842e+01, -4.751868950623765e+00},
	{"IDI", -1.228995291484495e+01, -3.705643689370291e+00},
	{"IDJ", -1.631685724856162e+01, -7.732548023086960e+00},
	{"IDK", -1.801682435809498e+01, -9.432515132620317e+00},
	{"IDL", -1.431486637180654e+01, -5.730557146331882e+00},
	{"IDM", -1.492245338032134e+01, -6.338144154846684e+00},
	{"IDN", -1.280555422887234e+01, -4.221245003397679e+00},
	{"IDO", -1.278664021587460e+01, -4.202330990399942e+00},
	{"IDP", -1.603666163231054e+01, -7.452352406835882e+00},
	{"IDQ", -1.946932500054760e+01, -1.088501577507294e+01},
	{"IDR", -1.490249436265325e+01, -6.318185137178592e+00},
	{"IDS", -1.265902829234688e+01, -4.074719066872222e+00},
	{"IDT", -1.197939239771423e+01, -3.395083172239568e+00},
	{"IDU", -1.257941693309863e+01, -3.995107707623970e+00},
	{"IDV", -1.815947618376572e+01, -9.575166958291058e+00},
	{"IDW", -1.392935070339728e+01, -5.345041477922617e+00},
	{"IDX", -3.422261312182540e+01, -2.563830389635073e+01},
	{"IDY", -1.535087241813731e+01, -6.766563192662648e+00},
	{"IDZ", -1.954805306302244e+01, -1.096374383754778e+01},
	{"IEA", -1.564123610102901e+01, -7.058760401300882e+00},
	{"IEB", -1.698467717228538e+01, -8.402201472557252e+00},
	{"IEC", -1.414676295639103e+01, -5.564287256662901e+00},
	{"IED", -1.116817754462079e+01, -2.585701844892658e+00},
	{"IEE", -1.896675165987370e+01, -1.038427596014558e+01},
	{"IEF", -1.288450278282389e+01, -4.302027083095762e+00},
	{"IEG", -1.533332574193516e+01, -6.750850042207036e+00},
	{"IEH", -1.762010702891031e+01, -9.037631329182179e+00},
	{"IEI", -1.632737344983850e+01, -7.744897750110370e+00},
	{"IEJ", -1.932302780778167e+01, -1.074055210805354e+01},
	{"IEK", -1.819112105048125e+01, -9.608645350753124e+00},
	{"IEL", -1.275211293247175e+01, -4.169637232743622e+00},
	{"IEM", -1.836054750258234e+01, -9.778071802854216e+00},
	{"IEN", -1.154992409811186e+01, -2.967448398383728e+00},
	{"IEO", -1.755326571951327e+01, -8.970790019785138e+00},
	{"IEP", -1.903454324806440e+01, -1.045206754833627e+01},
	{"IEQ", -2.210007503119676e+01, -1.351759933146863e+01},
	{"IER", -1.242900007726379e+01, -3.846524377535662e+00},
	{"IES", -1.017768103840524e+01, -1.595205338677111e+00},
	{"IET", -1.280978849116412e+01, -4.227312791435994e+00},
	{"IEU", -1.502806574373844e+01, -6.445590044010308e+00},
	{"IEV", -1.294603717337235e+01, -4.363561473644221e+00},
	{"IEW", -1.377068965894511e+01, -5.188213959216977e+00},
	{"IEX", -1.733992462419311e+01, -8.757448924464978e+00},
	{"IEY", -1.936520029077156e+01, -1.078272459104343e+01},
	{"IEZ", -1.843278290110847e+01, -9.850307201380339e+00},
	{"IFA", -1.367268815071860e+01, -4.279295052381382e+00},
	{"IFB", -1.790488227092708e+01, -8.511489172589869e+00},
	{"IFC", -1.787622323910239e+01, -8.482830140765182e+00},
	{"IFD", -1.806895822588810e+01, -8.675565127550881e+00},
	{"IFE", -1.168922728738420e+01, -2.295834189046987e+00},
	{"IFF", -1.263786008955676e+01, -3.244466991219548e+00},
	{"IFG", -1.778182839006030e+01, -8.388435291723084e+00},
	{"IFH", -1.432306839631846e+01, -4.929675297981247e+00},
	{"IFI", -1.181860419877647e+01, -2.425211100439257e+00},
	{"IFJ", -2.088010068205543e+01, -1.148670758371821e+01},
	{"IFK", -2.170398693561508e+01, -1.231059383727786e+01},
	{"IFL", -1.484306999753083e+01, -5.449676899193621e+00},
	{"IFM", -1.737037214004985e+01, -7.976979041712634e+00},
	{"IFN", -1.597630916541959e+01, -6.582916067082375e+00},
	{"IFO", -1.415789963235911e+01, -4.764506534021899e+00},
	{"IFP", -1.688170822524498e+01, -7.488315126907769e+00},
	{"IFQ", -2.370625916001102e+01, -1.431286606167380e+01},
	{"IFR", -1.765404143156338e+01, -8.260648333226163e+00},
	{"IFS", -1.549708364749194e+01, -6.103690549154727e+00},
	{"IFT", -1.181219828542318e+01, -2.418805187085967e+00},
	{"IFU", -1.455699128835566e+01, -5.163598190018448e+00},
	{"IFV", -2.362377897824616e+01, -1.423038587990895e+01},
	{"IFW", -1.526218369415567e+01, -5.868790595818458e+00},
	{"IFX", -3.287322115913771e+01, -2.347982806080049e+01},
	{"IFY", -1.305065693000863e+01, -3.657263831671418e+00},
	{"IFZ", -2.900181461866423e+01, -1.960842152032702e+01},
	{"IGA", -1.367490406780311e+01, -4.806984360706568e+00},
	{"IGB", -1.793020271358736e+01, -9.062283006490807e+00},
	{"IGC", -1.850030191829768e+01, -9.632382211201136e+00},
	{"IGD", -1.870736409551267e+01, -9.839444388416121e+00},
	{"IGE", -1.371393752417837e+01, -4.846017817081821e+00},
	{"IGF", -1.849703181003192e+01, -9.629112102935373e+00},
	{"IGG", -1.494639753064433e+01, -6.078477823547783e+00},
	{"IGH", -9.545067225216613e+00, -6.771475181200672e-01},
	{"IGI", -1.310244808946618e+01, -4.234528382369630e+00},
	{"IGJ", -2.212187848030712e+01, -1.325395877321058e+01},
	{"IGK", -2.270359428988842e+01, -1.383567458279187e+01},
	{"IGL", -1.802205161363159e+01, -9.154131906535039e+00},
	{"IGM", -1.764568279465507e+01, -8.777763087558524e+00},
	{"IGN", -1.167321298301555e+01, -2.805293275919006e+00},
	{"IGO", -1.418226232958274e+01, -5.314342622486190e+00},
	{"IGP", -1.875374936614706e+01, -9.885829659050513e+00},
	{"IGQ", -3.057181281316570e+01, -2.170389310606915e+01},
	{"IGR", -1.490829552230600e+01, -6.040375815209456e+00},
	{"IGS", -1.618706838426636e+01, -7.319148677169812e+00},
	{"IGT", -1.599813660548829e+01, -7.130216898391748e+00},
	{"IGU", -1.426558941217768e+01, -5.397669705081129e+00},
	{"IGV", -1.980823141605597e+01, -1.094031170895943e+01},
	{"IGW", -1.694519342794353e+01, -8.077273720846984e+00},
	{"IGX", -3.379063327961305e+01, -2.492271357251651e+01},
	{"IGY", -2.010505588447758e+01, -1.123713617738104e+01},
	{"IGZ", -2.054851023975119e+01, -1.168059053265464e+01},
	{"IHA", -1.217925327300186e+01, -3.217219588951656e-01},
	{"IHB", -2.770106053765481e+01, -1.584352922354811e+01},
	{"IHC", -2.767303665072765e+01, -1.581550533662095e+01},
	{"IHD", -2.815101641283337e+01, -1.629348509872668e+01},
	{"IHE", -1.534712538662812e+01, -3.489594072521427e+00},
	{"IHF", -2.768772175676360e+01, -1.583019044265690e+01},
	{"IHG", -2.367270201414527e+01, -1.181517070003857e+01},
	{"IHH", -2.167074132282401e+01, -9.813210008717313e+00},
	{"IHI", -1.689882284403182e+01, -5.041291529925126e+00},
	{"IHJ", -3.058975881223568e+01, -1.873222749812898e+01},
	{"IHK", -2.370873610854237e+01, -1.185120479443567e+01},
	{"IHL", -2.821213334890234e+01, -1.635460203479564e+01},
	{"IHM", -2.721305995757882e+01, -1.535552864347212e+01},
	{"IHN", -2.812406188441437e+01, -1.626653057030767e+01},
	{"IHO", -1.586557726349864e+01, -4.008045949391939e+00},
	{"IHP", -2.805551808089714e+01, -1.619798676679044e+01},
	{"IHQ", -3.234575670412465e+01, -2.048822539001795e+01},
	{"IHR", -2.601211387797900e+01, -1.415458256387230e+01},
	{"IHS", -2.666136058924425e+01, -1.480382927513756e+01},
	{"IHT", -2.293103797799733e+01, -1.107350666389063e+01},
	{"IHU", -1.788071699747781e+01, -6.023185683371116e+00},
	{"IHV", -3.081910382696287e+01, -1.896157251285618e+01},
	{"IHW", -2.263574149974961e+01, -1.077821018564292e+01},
	{"IHX", -3.634169373306781e+01, -2.448416241896111e+01},
	{"IHY", -2.623730398745082e+01, -1.437977267334412e+01},
	{"IHZ", -3.335357597894152e+01, -2.149604466483482e+01},
	{"IIA", -1.639916438827087e+01, -3.528676661181766e+00},
	{"IIB", -1.857909625675573e+01, -5.708608529666621e+00},
	{"IIC", -1.782487916324233e+01, -4.954391436153225e+00},
	{"IID", -1.839952399164569e+01, -5.529036264556581e+00},
	{"IIE", -1.955526097133023e+01, -6.684773244241123e+00},
	{"IIF", -1.800349509565033e+01, -5.133007368561218e+00},
	{"IIG", -1.956854355701493e+01, -6.698055829925820e+00},
	{"IIH", -1.801526818201257e+01, -5.144780454923467e+00},
	{"III", -1.504573703597815e+01, -2.175249308889044e+00},
	{"IIJ", -2.139409307413480e+01, -8.523605347045695e+00},
	{"IIK", -2.037740817274003e+01, -7.506920445650919e+00},
	{"IIL", -1.874803495361859e+01, -5.877547226529479e+00},
	{"IIM", -1.717929908991314e+01, -4.308811362824032e+00},
	{"IIN", -1.589138732462306e+01, -3.020899597533951e+00},
	{"IIO", -1.757962455571671e+01, -4.709136828627597e+00},
	{"IIP", -1.762616977173047e+01, -4.755682044641367e+00},
	{"IIQ", -2.935190329881865e+01, -1.648141557172954e+01},
	{"IIR", -1.885807844768750e+01, -5.987590720598396e+00},
	{"IIS", -1.668464193068109e+01, -3.814154203591979e+00},
	{"IIT", -1.579325678283367e+01, -2.922769055744558e+00},
	{"IIU", -2.208183843080052e+01, -9.211350703711412e+00},
	{"IIV", -2.060953046171394e+01, -7.739042734624838e+00},
	{"IIW", -1.739404599426477e+01, -4.523558267175663e+00},
	{"IIX", -2.786382409615747e+01, -1.499333636906836e+01},
	{"IIY", -3.294867837939767e+01, -2.007819065230856e+01},
	{"IIZ", -2.704864825703898e+01, -1.417816052994987e+01},
	{"IJA", -1.632881111701878e+01, -9.010814218696529e-01},
	{"IJB", -2.939816312863886e+01, -1.397043343348973e+01},
	{"IJC", -3.024755277613539e+01, -1.481982308098626e+01},
	{"IJD", -3.211854903667523e+01, -1.669081934152609e+01},
	{"IJE", -2.039155174171356e+01, -4.963822046564429e+00},
	{"IJF", -3.126539625480311e+01, -1.583766655965399e+01},
	{"IJG", -3.084993715094239e+01, -1.542220745579326e+01},
	{"IJH", -3.003066537511387e+01, -1.460293567996474e+01},
	{"IJI", -2.087605105394031e+01, -5.448321358791172e+00},
	{"IJJ", -3.004187287393405e+01, -1.461414317878491e+01},
	{"IJK", -3.269575086142788e+01, -1.726802116627874e+01},
	{"IJL", -3.123927725104195e+01, -1.581154755589281e+01},
	{"IJM", -3.159520262476940e+01, -1.616747292962027e+01},
	{"IJN", -3.454527235342201e+01, -1.911754265827289e+01},
	{"IJO", -1.926711423112780e+01, -3.839384535978660e+00},
	{"IJP", -3.100705488758843e+01, -1.557932519243930e+01},
	{"IJQ", -3.399330662851431e+01, -1.856557693336518e+01},
	{"IJR", -3.021748136533476e+01, -1.478975167018562e+01},
	{"IJS", -3.064795560772081e+01, -1.522022591257168e+01},
	{"IJT", -3.075040750408241e+01, -1.532267780893327e+01},
	{"IJU", -1.698713732306966e+01, -1.559407627920529e+00},
	{"IJV", -3.761235984811516e+01, -2.218463015296603e+01},
	{"IJW", -2.998661589168614e+01, -1.455888619653701e+01},
	{"IJX", -4.029166525518399e+01, -2.486393556003486e+01},
	{"IJY", -3.676153600602861e+01, -2.133380631087947e+01},
	{"IJZ", -3.486653709948703e+01, -1.943880740433790e+01},
	{"IKA", -1.790902554504735e+01, -6.539024094074905e+00},
	{"IKB", -2.589071638418313e+01, -1.452071493321068e+01},
	{"IKC", -2.632289707206898e+01, -1.495289562109654e+01},
	{"IKD", -2.357351981718250e+01, -1.220351836621006e+01},
	{"IKE", -1.169523036939671e+01, -3.252289184242643e-01},
	{"IKF", -2.578743202786733e+01, -1.441743057689489e+01},
	{"IKG", -2.805865132223272e+01, -1.668864987126028e+01},
	{"IKH", -1.930624622153059e+01, -7.936244770558145e+00},
	{"IKI", -1.574447494315000e+01, -4.374473492177558e+00},
	{"IKJ", -2.963820728658492e+01, -1.826820583561248e+01},
	{"IKK", -2.112773168051527e+01, -9.757730229542828e+00},
	{"IKL", -1.923853202109170e+01, -7.868530570119255e+00},
	{"IKM", -2.632252003541126e+01, -1.495251858443882e+01},
	{"IKN", -1.443930406953358e+01, -3.069302618561135e+00},
	{"IKO", -1.776823073956593e+01, -6.398229288593484e+00},
	{"IKP", -2.667387422657553e+01, -1.530387277560309e+01},
	{"IKQ", -3.231734708115799e+01, -2.094734563018555e+01},
	{"IKR", -2.358753884133074e+01, -1.221753739035829e+01},
	{"IKS", -2.322773628722080e+01, -1.185773483624836e+01},
	{"IKT", -2.399267231147195e+01, -1.262267086049951e+01},
	{"IKU", -2.163841050806806e+01, -1.026840905709562e+01},
	{"IKV", -2.369254812231739e+01, -1.232254667134495e+01},
	{"IKW", -2.326768159203655e+01, -1.189768014106410e+01},
	{"IKX", -3.328939394705125e+01, -2.191939249607881e+01},
	{"IKY", -2.583410623265897e+01, -1.446410478168653e+01},
	{"IKZ", -3.139125683292099e+01, -2.002125538194855e+01},
	{"ILA", -1.265686060793897e+01, -4.633759544842141e+00},
	{"ILB", -1.575072761912767e+01, -7.727626556030838e+00},
	{"ILC", -1.592270255750535e+01, -7.899601494408524e+00},
	{"ILD", -1.129893754060867e+01, -3.275836477511844e+00},
	{"ILE", -1.098426159680633e+01, -2.961160533709500e+00},
	{"ILF", -1.560260295483394e+01, -7.579501891737111e+00},
	{"ILG", -1.590408951430803e+01, -7.880988451211199e+00},
	{"ILH", -1.530426347619303e+01, -7.281162413096197e+00},
	{"ILI", -1.122270920244718e+01, -3.199608139350355e+00},
	{"ILJ", -1.962946454377252e+01, -1.160636348067569e+01},
	{"ILK", -1.502481800441472e+01, -7.001716941317895e+00},
	{"ILL", -9.370784915088683e+00, -1.347683851991852e+00},
	{"ILM", -1.554749188987694e+01, -7.524390826780109e+00},
	{"ILN", -1.667255419764341e+01, -8.649453134546583e+00},
	{"ILO", -1.326713565663017e+01, -5.244034593533339e+00},
	{"ILP", -1.717527971743437e+01, -9.152178654337545e+00},
	{"ILQ", -2.370373410054738e+01, -1.568063303745054e+01},
	{"ILR", -1.620947308858345e+01, -8.186372025486618e+00},
	{"ILS", -1.321706057002677e+01, -5.193959506929935e+00},
	{"ILT", -1.242573837893590e+01, -4.402637315839069e+00},
	{"ILU", -1.550641783195290e+01, -7.483316768856069e+00},
	{"ILV", -1.446088949720433e+01, -6.437788434107499e+00},
	{"ILW", -1.418883499659071e+01, -6.165733933493876e+00},
	{"ILX", -2.271801955524563e+01, -1.469491849214880e+01},
	{"ILY", -1.240155521793668e+01, -4.378454154839853e+00},
	{"ILZ", -2.171783433788010e+01, -1.369473327478327e+01},
	{"IMA", -1.099365001645851e+01, -2.527781536987979e+00},
	{"IMB", -1.338251671635280e+01, -4.916648236882271e+00},
	{"IMC", -1.581715024843811e+01, -7.351281768967577e+00},
	{"IMD", -1.567925348646034e+01, -7.213385006989808e+00},
	{"IME", -1.061173115694373e+01, -2.145862677473205e+00},
	{"IMF", -1.439873070856939e+01, -5.932862229098860e+00},
	{"IMG", -1.597695711714820e+01, -7.511088637677675e+00},
	{"IMH", -1.423855291186012e+01, -5.772684432389593e+00},
	{"IMI", -1.210621967978587e+01, -3.640351200315336e+00},
	{"IMJ", -1.822625915623461e+01, -9.760390676764080e+00},
	{"IMK", -1.745170426703031e+01, -8.985835787559781e+00},
	{"IML", -1.582947331943536e+01, -7.363604839964827e+00},
	{"IMM", -1.301164906148169e+01, -4.545780582011165e+00},
	{"IMN", -1.496324961412105e+01, -6.497381134650525e+00},
	{"IMO", -1.330972749067944e+01, -4.843859011208909e+00},
	{"IMP", -1.155598283152083e+01, -3.090114352050307e+00},
	{"IMQ", -2.113314478384576e+01, -1.266727630437524e+01},
	{"IMR", -1.612517420234159e+01, -7.659305722871055e+00},
	{"IMS", -1.199393741276499e+01, -3.528068933294461e+00},
	{"IMT", -1.225424012162486e+01, -3.788371642154333e+00},
	{"IMU", -1.408990568601761e+01, -5.624037206547079e+00},
	{"IMV", -1.846982081004703e+01, -1.000395233057650e+01},
	{"IMW", -1.354598888603093e+01, -5.080120406560399e+00},
	{"IMX", -3.376009292780451e+01, -2.529422444833397e+01},
	{"IMY", -1.650926710020578e+01, -8.043398620735246e+00},
	{"IMZ", -2.054850353275628e+01, -1.208263505328575e+01},
	{"INA", -9.936264360098361e+00, -4.082306355732976e+00},
	{"INB", -1.275858927248663e+01, -6.904631268121250e+00},
	{"INC", -1.042287754707648e+01, -4.568919542711098e+00},
	{"IND", -1.008829981608735e+01, -4.234341811721967e+00},
	{"INE", -9.601155229746617e+00, -3.747197225381231e+00},
	{"INF", -1.150438472593065e+01, -5.650426721565259e+00},
	{"ING", -7.439153847296383e+00, -1.585195842930998e+00},
	{"INH", -1.125978145223674e+01, -5.405823447871354e+00},
	{"INI", -1.067710717450124e+01, -4.823149170135854e+00},
	{"INJ", -1.390973972118631e+01, -8.055781716820928e+00},
	{"INK", -1.224502044240873e+01, -6.391062438043345e+00},
	{"INL", -1.285597258568968e+01, -7.002014581324294e+00},
	{"INM", -1.233172727582618e+01, -6.477769271460792e+00},
	{"INN", -1.230821355153982e+01, -6.454255547174438e+00},
	{"INO", -1.180254646877302e+01, -5.948588464407636e+00},
	{"INP", -1.244025235532318e+01, -6.586294350957792e+00},
	{"INQ", -1.513747589119947e+01, -9.283517886834087e+00},
	{"INR", -1.350433596458025e+01, -7.650377960214869e+00},
	{"INS", -9.946950033207909e+00, -4.092992028842523e+00},
	{"INT", -8.350025666934975e+00, -2.496067662569590e+00},
	{"INU", -1.235343810076022e+01, -6.499480096394835e+00},
	{"INV", -1.270959943599486e+01, -6.855641431629475e+00},
	{"INW", -1.219702378432341e+01, -6.343065779958020e+00},
	{"INX", -2.054746614584855e+01, -1.469350814148317e+01},
	{"INY", -1.408149770975911e+01, -8.227539705393724e+00},
	{"INZ", -1.771867404852942e+01, -1.186471604416404e+01},
	{"IOA", -1.670326633152271e+01, -8.794109317011634e+00},
	{"IOB", -1.806466993091309e+01, -1.015551291640202e+01},
	{"IOC", -1.632324558369211e+01, -8.414088569181041e+00},
	{"IOD", -1.405590851230552e+01, -6.146751497794451e+00},
	{"IOE", -1.999919082401325e+01, -1.209003380950218e+01},
	{"IOF", -1.682053911605278e+01, -8.911382101541710e+00},
	{"IOG", -1.662918521350895e+01, -8.720028198997873e+00},
	{"IOH", -1.930740773145306e+01, -1.139825071694199e+01},
	{"IOI", -1.870373803717348e+01, -1.079458102266241e+01},
	{"IOJ", -2.733112372565921e+01, -1.942196671114814e+01},
	{"IOK", -2.163748044071873e+01, -1.372832342620766e+01},
	{"IOL", -1.399283085503530e+01, -6.083673840524231e+00},
	{"IOM", -1.852705401368732e+01, -1.061789699917625e+01},
	{"ION", -8.134490975436538e+00, -2.253339609254646e-01},
	{"IOO", -1.897922635168374e+01, -1.107006933717267e+01},
	{"IOP", -1.718596719924245e+01, -9.276810184731378e+00},
	{"IOQ", -3.063796474924056e+01, -2.272880773472948e+01},
	{"IOR", -1.391920372275327e+01, -6.010046708242199e+00},
	{"IOS", -1.654041717107239e+01, -8.631260156561316e+00},
	{"IOT", -1.460317038555911e+01, -6.694013371048042e+00},
	{"IOU", -1.173518060179806e+01, -3.826023587286985e+00},
	{"IOV", -1.883846315692086e+01, -1.092930614240979e+01},
	{"IOW", -1.719442820478975e+01, -9.285271190278676e+00},
	{"IOX", -1.793685066909537e+01, -1.002769365458430e+01},
	{"IOY", -2.634141708384386e+01, -1.843226006933278e+01},
	{"IOZ", -3.042686294767056e+01, -2.251770593315949e+01},
	{"IPA", -1.366038070045111e+01, -3.032926719113687e+00},
	{"IPB", -1.696298658472118e+01, -6.335532603383752e+00},
	{"IPC", -1.804530800229710e+01, -7.417854020959677e+00},
	{"IPD", -1.913223305503208e+01, -8.504779073694660e+00},
	{"IPE", -1.460931971673638e+01, -3.981865735398961e+00},
	{"IPF", -1.778632514648532e+01, -7.158871165147896e+00},
	{"IPG", -1.913127370369323e+01, -8.503819722355813e+00},
	{"IPH", -1.590470082710758e+01, -5.277246845770155e+00},
	{"IPI", -1.471743343453575e+01, -4.089979453198329e+00},
	{"IPJ", -2.171662678052567e+01, -1.108917279918825e+01},
	{"IPK", -2.139499913284421e+01, -1.076754515150678e+01},
	{"IPL", -1.322848274242586e+01, -2.601028761088434e+00},
	{"IPM", -1.553832006526254e+01, -4.910866083925121e+00},
	{"IPN", -1.881054121995604e+01, -8.183087238618615e+00},
	{"IPO", -1.493195478543326e+01, -4.304500804095844e+00},
	{"IPP", -1.354223577177889e+01, -2.914781790441472e+00},
	{"IPQ", -2.271697497799266e+01, -1.208952099665523e+01},
	{"IPR", -1.488555338004705e+01, -4.258099398709624e+00},
	{"IPS", -1.369159588235855e+01, -3.064141901021125e+00},
	{"IPT", -1.399035097852741e+01, -3.362896997189990e+00},
	{"IPU", -1.643218810971031e+01, -5.804734128372885e+00},
	{"IPV", -1.858921898712182e+01, -7.961765005784397e+00},
	{"IPW", -1.621006345966437e+01, -5.582609478326951e+00},
	{"IPX", -3.553341122202080e+01, -2.490595724068338e+01},
	{"IPY", -1.999599754119307e+01, -9.368543559855642e+00},
	{"IPZ", -3.401914247406373e+01, -2.339168849272630e+01},
	{"IQA", -2.369098461308592e+01, -9.603733047445049e+00},
	{"IQB", -3.195993191760175e+01, -1.787268035196088e+01},
	{"IQC", -3.087093113549863e+01, -1.678367956985776e+01},
	{"IQD", -3.248163577769168e+01, -1.839438421205080e+01},
	{"IQE", -3.286953032183592e+01, -1.878227875619505e+01},
	{"IQF", -3.122843472109253e+01, -1.714118315545166e+01},
	{"IQG", -3.794525869547404e+01, -2.385800712983316e+01},
	{"IQH", -3.177999337795166e+01, -1.769274181231078e+01},
	{"IQI", -2.767155398584371e+01, -1.358430242020284e+01},
	{"IQJ", -3.374530515309345e+01, -1.965805358745258e+01},
	{"IQK", -3.957744389041277e+01, -2.549019232477190e+01},
	{"IQL", -3.222238095139465e+01, -1.813512938575378e+01},
	{"IQM", -3.139999410925397e+01, -1.731274254361310e+01},
	{"IQN", -3.422931148622271e+01, -2.014205992058184e+01},
	{"IQO", -3.242575731694815e+01, -1.833850575130728e+01},
	{"IQP", -3.242794270337401e+01, -1.834069113773313e+01},
	{"IQQ", -3.430934565211111e+01, -2.022209408647024e+01},
	{"IQR", -3.227464615482587e+01, -1.818739458918499e+01},
	{"IQS", -2.934695831011462e+01, -1.525970674447375e+01},
	{"IQT", -2.984662931404893e+01, -1.575937774840805e+01},
	{"IQU", -1.408937164102851e+01, -2.120075387636185e-03},
	{"IQV", -3.514049933246439e+01, -2.105324776682351e+01},
	{"IQW", -3.149875215661066e+01, -1.741150059096978e+01},
	{"IQX", -4.160057584829570e+01, -2.751332428265483e+01},
	{"IQY", -3.579329604974249e+01, -2.170604448410161e+01},
	{"IQZ", -4.274014328504624e+01, -2.865289171940536e+01},
	{"IRA", -1.212239019791098e+01, -3.733032671875413e+00},
	{"IRB", -1.433450445808990e+01, -5.945146932054330e+00},
	{"IRC", -1.266111345881274e+01, -4.271755932777172e+00},
	{"IRD", -1.278284899098086e+01, -4.393491464945285e+00},
	{"IRE", -1.051546482714521e+01, -2.126107301109641e+00},
	{"IRF", -1.349201802600770e+01, -5.102660499972131e+00},
	{"IRG", -1.376984853719047e+01, -5.380491011154897e+00},
	{"IRH", -1.383256603155267e+01, -5.443208505517101e+00},
	{"IRI", -1.220976515623662e+01, -3.820407630201045e+00},
	{"IRJ", -1.537879155106332e+01, -6.989434025027753e+00},
	{"IRK", -1.634969787067623e+01, -7.960340344640660e+00},
	{"IRL", -1.329112470968465e+01, -4.901767183649083e+00},
	{"IRM", -1.329285876510759e+01, -4.903501239072016e+00},
	{"IRN", -1.511640659537229e+01, -6.727049069336720e+00},
	{"IRO", -1.290207848196590e+01, -4.512720955930325e+00},
	{"IRP", -1.371980335915482e+01, -5.330445833119244e+00},
	{"IRQ", -1.946981774039950e+01, -1.108046021436392e+01},
	{"IRR", -1.359147697173783e+01, -5.202119445702261e+00},
	{"IRS", -1.117344402975086e+01, -2.784086503715291e+00},
	{"IRT", -1.239181046464411e+01, -4.002452938608540e+00},
	{"IRU", -1.568821603098820e+01, -7.298858504952625e+00},
	{"IRV", -1.565145932630098e+01, -7.262101800265405e+00},
	{"IRW", -1.383866206241284e+01, -5.449304536377267e+00},
	{"IRX", -3.055322508485266e+01, -2.216386755881709e+01},
	{"IRY", -1.604756154115985e+01, -7.658204015124277e+00},
	{"IRZ", -1.932616716813283e+01, -1.093680964209726e+01},
	{"ISA", -1.070813734983476e+01, -3.850847372330725e+00},
	{"ISB", -1.228863550429292e+01, -5.431345526788883e+00},
	{"ISC", -1.095731263093548e+01, -4.100022653431445e+00},
	{"ISD", -1.205423326916654e+01, -5.196943291662505e+00},
	{"ISE", -1.043757857854876e+01, -3.580288601044723e+00},
	{"ISF", -1.170636400954830e+01, -4.849074032044264e+00},
	{"ISG", -1.285062375573261e+01, -5.993333778228576e+00},
	{"ISH", -1.003329944325411e+01, -3.176009465750078e+00},
	{"ISI", -1.102010368073227e+01, -4.162813703228243e+00},
	{"ISJ", -1.533924722296750e+01, -8.481957245463470e+00},
	{"ISK", -1.410200538415065e+01, -7.244715406646615e+00},
	{"ISL", -1.198690144177529e+01, -5.129611464271254e+00},
	{"ISM", -1.164183949817917e+01, -4.784549520675133e+00},
	{"ISN", -1.195587322577666e+01, -5.098583248272628e+00},
	{"ISO", -1.156604977428452e+01, -4.708759796780489e+00},
	{"ISP", -1.131051667552337e+01, -4.453226698019337e+00},
	{"ISQ", -1.599739872305251e+01, -9.140108745548480e+00},
	{"ISR", -1.159169188084003e+01, -4.734401903335993e+00},
	{"ISS", -1.058072385796033e+01, -3.723433880456303e+00},
	{"IST", -9.456451123302983e+00, -2.599161145798951e+00},
	{"ISU", -1.374448760677190e+01, -6.887197629267863e+00},
	{"ISV", -1.378943914802201e+01, -6.932149170517980e+00},
	{"ISW", -1.183849192364196e+01, -4.981201946137924e+00},
	{"ISX", -1.538337337501900e+01, -8.526083397514967e+00},
	{"ISY", -1.529604862183346e+01, -8.438758644329424e+00},
	{"ISZ", -1.925911652089359e+01, -1.240182654338956e+01},
	{"ITA", -1.064374076227189e+01, -3.795818023907818e+00},
	{"ITB", -1.322770251456246e+01, -6.379779776198392e+00},
	{"ITC", -1.283674383297077e+01, -5.988821094606704e+00},
	{"ITD", -1.423266946170710e+01, -7.384746723343026e+00},
	{"ITE", -1.050339368834745e+01, -3.655470949983377e+00},
	{"ITF", -1.366187745131321e+01, -6.813954712949138e+00},
	{"ITG", -1.525891666602815e+01, -8.410993927664077e+00},
	{"ITH", -8.616725446907070e+00, -1.768802708543001e+00},
	{"ITI", -9.731867384051668e+00, -2.883944645687599e+00},
	{"ITJ", -1.714856901909086e+01, -1.030064628072680e+01},
	{"ITK", -1.786012328255580e+01, -1.101220054419173e+01},
	{"ITL", -1.409430727424603e+01, -7.246384535881965e+00},
	{"ITM", -1.341019654861369e+01, -6.562273810249619e+00},
	{"ITN", -1.369207710844123e+01, -6.844154370077159e+00},
	{"ITO", -1.205265145780002e+01, -5.204728719435954e+00},
	{"ITP", -1.485418327301246e+01, -8.006260534648389e+00},
	{"ITQ", -1.971822393251204e+01, -1.287030119414797e+01},
	{"ITR", -1.402725112629973e+01, -7.179328387935658e+00},
	{"ITS", -1.051976176420316e+01, -3.671839025839090e+00},
	{"ITT", -1.071329514260464e+01, -3.865372404240570e+00},
	{"ITU", -1.190803523358974e+01, -5.060112495225669e+00},
	{"ITV", -1.739641132755864e+01, -1.054848858919457e+01},
	{"ITW", -1.118679669335954e+01, -4.338873954995472e+00},
	{"ITX", -3.371231179804899e+01, -2.686438905968492e+01},
	{"ITY", -1.047913974373343e+01, -3.631217005369356e+00},
	{"ITZ", -1.664192864563490e+01, -9.794005907270831e+00},
	{"IUA", -2.244287109280247e+01, -1.079208244217443e+01},
	{"IUB", -2.535413173679694e+01, -1.370334308616890e+01},
	{"IUC", -2.235926137788984e+01, -1.070847272726180e+01},
	{"IUD", -2.130231950126833e+01, -9.651530850640293e+00},
	{"IUE", -2.498762260263453e+01, -1.333683395200649e+01},
	{"IUF", -2.693915310598614e+01, -1.528836445535810e+01},
	{"IUG", -2.305542222733087e+01, -1.140463357670282e+01},
	{"IUH", -2.760931015512971e+01, -1.595852150450168e+01},
	{"IUI", -2.502467212331233e+01, -1.337388347268429e+01},
	{"IUJ", -3.187743598282420e+01, -2.022664733219616e+01},
	{"IUK", -2.810170225365039e+01, -1.645091360302235e+01},
	{"IUL", -2.252963831211238e+01, -1.087884966148433e+01},
	{"IUM", -1.333252060081378e+01, -1.681731950185744e+00},
	{"IUN", -1.722835736575250e+01, -5.577568715124456e+00},
	{"IUO", -2.824079537743741e+01, -1.659000672680937e+01},
	{"IUP", -2.043253828074397e+01, -8.781749630115934e+00},
	{"IUQ", -3.335865950284431e+01, -2.170787085221627e+01},
	{"IUR", -1.991423026444624e+01, -8.263441613818195e+00},
	{"IUS", -1.226143808005587e+01, -6.106494294278330e-01},
	{"IUT", -2.113402174842143e+01, -9.483233097793386e+00},
	{"IUU", -3.070182753616867e+01, -1.905103888554063e+01},
	{"IUV", -3.004412518630545e+01, -1.839333653567741e+01},
	{"IUW", -2.772421639396774e+01, -1.607342774333970e+01},
	{"IUX", -3.031961604685063e+01, -1.866882739622259e+01},
	{"IUY", -2.947061103537944e+01, -1.781982238475140e+01},
	{"IUZ", -2.071647564545293e+01, -9.065686994824887e+00},
	{"IVA", -1.342058225329061e+01, -4.292490267407823e+00},
	{"IVB", -2.113287322820941e+01, -1.200478124232662e+01},
	{"IVC", -2.139585260017664e+01, -1.226776061429385e+01},
	{"IVD", -2.139513651918876e+01, -1.226704453330597e+01},
	{"IVE", -9.508651356973751e+00, -3.805593710909659e-01},
	{"IVF", -2.113259568182397e+01, -1.200450369594118e+01},
	{"IVG", -2.171805905911349e+01, -1.258996707323070e+01},
	{"IVH", -1.919462970836803e+01, -1.006653772248524e+01},
	{"IVI", -1.175658098636089e+01, -2.628489000478108e+00},
	{"IVJ", -2.371550484639660e+01, -1.458741286051381e+01},
	{"IVK", -3.427078599747936e+01, -2.514269401159658e+01},
	{"IVL", -2.139573037387429e+01, -1.226763838799150e+01},
	{"IVM", -2.071737881731105e+01, -1.158928683142826e+01},
	{"IVN", -2.171336355584318e+01, -1.258527156996040e+01},
	{"IVO", -1.599513637997988e+01, -6.867044394097090e+00},
	{"IVP", -1.907454895318541e+01, -9.946456967302623e+00},
	{"IVQ", -3.720329622189934e+01, -2.807520423601656e+01},
	{"IVR", -1.854764903979923e+01, -9.419557053916440e+00},
	{"IVS", -1.925840061843157e+01, -1.013030863254879e+01},
	{"IVT", -1.854792691473994e+01, -9.419834928857156e+00},
	{"IVU", -1.990806916327257e+01, -1.077997717738979e+01},
	{"IVV", -3.317407010881627e+01, -2.404597812293349e+01},
	{"IVW", -1.981099970030517e+01, -1.068290771442239e+01},
	{"IVX", -2.371818832669948e+01, -1.459009634081669e+01},
	{"IVY", -1.825549226848706e+01, -9.127400282604281e+00},
	{"IVZ", -3.836487648234180e+01, -2.923678449645901e+01},
	{"IWA", -1.303955642764013e+01, -1.649022921472699e+00},
	{"IWB", -2.860315822035560e+01, -1.721262471418817e+01},
	{"IWC", -2.866104983928289e+01, -1.727051633311546e+01},
	{"IWD", -2.817453983940661e+01, -1.678400633323918e+01},
	{"IWE", -1.541742889513971e+01, -4.026895388972285e+00},
	{"IWF", -2.845612762554233e+01, -1.706559411937490e+01},
	{"IWG", -2.958287105552799e+01, -1.819233754936056e+01},
	{"IWH", -1.599940336343657e+01, -4.608869857269140e+00},
	{"IWI", -1.248191937509860e+01, -1.091385868931178e+00},
	{"IWJ", -3.092942929429892e+01, -1.953889578813149e+01},
	{"IWK", -3.109457798187142e+01, -1.970404447570399e+01},
	{"IWL", -2.752461024237289e+01, -1.613407673620547e+01},
	{"IWM", -2.822544247848038e+01, -1.683490897231296e+01},
	{"IWN", -2.509973243987714e+01, -1.370919893370972e+01},
	{"IWO", -1.477379087460949e+01, -3.383257368442068e+00},
	{"IWP", -2.931330614551029e+01, -1.792277263934286e+01},
	{"IWQ", -3.356692729222142e+01, -2.217639378605400e+01},
	{"IWR", -1.769384370964693e+01, -6.303310203479503e+00},
	{"IWS", -2.635990478865192e+01, -1.496937128248450e+01},
	{"IWT", -2.622992705379417e+01, -1.483939354762675e+01},
	{"IWU", -2.171319861523549e+01, -1.032266510906806e+01},
	{"IWV", -3.141710065486660e+01, -2.002656714869917e+01},
	{"IWW", -2.744821532479643e+01, -1.605768181862900e+01},
	{"IWX", -4.076073355834683e+01, -2.937020005217941e+01},
	{"IWY", -2.839962209601346e+01, -1.700908858984603e+01},
	{"IWZ", -3.428371720898599e+01, -2.289318370281856e+01},
	{"IXA", -1.744789607367256e+01, -4.847516245482147e+00},
	{"IXB", -1.804421457675155e+01, -5.443834748561144e+00},
	{"IXC", -1.776239852960734e+01, -5.162018701416934e+00},
	{"IXD", -1.771606903789493e+01, -5.115689209704528e+00},
	{"IXE", -1.495460227131063e+01, -2.354222443120223e+00},
	{"IXF", -1.850477342226360e+01, -5.904393594073193e+00},
	{"IXG", -1.925640381074453e+01, -6.656023982554124e+00},
	{"IXH", -1.664610359535448e+01, -4.045723767164072e+00},
	{"IXI", -1.667530258476026e+01, -4.074922756569856e+00},
	{"IXJ", -2.368653904221658e+01, -1.108615921402617e+01},
	{"IXK", -2.271043648296556e+01, -1.011005665477515e+01},
	{"IXL", -1.890503700269859e+01, -6.304657174508183e+00},
	{"IXM", -1.679781883730259e+01, -4.197439009112187e+00},
	{"IXN", -2.071231291606209e+01, -8.111933087871684e+00},
	{"IXO", -1.750134172278204e+01, -4.900961894591628e+00},
	{"IXP", -1.844988024302080e+01, -5.849500414830397e+00},
	{"IXQ", -2.806450311905864e+01, -1.546412329086823e+01},
	{"IXR", -1.962102443938383e+01, -7.020644611193419e+00},
	{"IXS", -1.769231494536280e+01, -5.091935117172390e+00},
	{"IXT", -1.424713022800837e+01, -1.646750399817961e+00},
	{"IXU", -2.009158335557330e+01, -7.491203527382891e+00},
	{"IXV", -2.047607548240013e+01, -7.875695654209721e+00},
	{"IXW", -1.767043319041724e+01, -5.070053362226831e+00},
	{"IXX", -2.253520750229096e+01, -9.934827674100552e+00},
	{"IXY", -1.801225923191950e+01, -5.411879403729089e+00},
	{"IXZ", -3.960290966978474e+01, -2.700252984159433e+01},
	{"IYA", -1.997521126009496e+01, -2.291184613875061e+00},
	{"IYB", -2.612328682301133e+01, -8.439260176791436e+00},
	{"IYC", -2.625210676878304e+01, -8.568080122563144e+00},
	{"IYD", -2.659949998857152e+01, -8.915473342351627e+00},
	{"IYE", -1.969186037488169e+01, -2.007833728661797e+00},
	{"IYF", -2.629981812814695e+01, -8.615791481927054e+00},
	{"IYG", -2.741254132222813e+01, -9.728514676008233e+00},
	{"IYH", -2.613539753644626e+01, -8.451370890226361e+00},
	{"IYI", -2.051021456147498e+01, -2.826187915255085e+00},
	{"IYJ", -2.947980236414107e+01, -1.179577571792117e+01},
	{"IYK", -2.927648558414604e+01, -1.159245893792614e+01},
	{"IYL", -2.685824022207775e+01, -9.174213575857852e+00},
	{"IYM", -2.621558317524411e+01, -8.531556529024215e+00},
	{"IYN", -2.736469290425218e+01, -9.680666258032279e+00},
	{"IYO", -1.915804539130621e+01, -1.474018745086318e+00},
	{"IYP", -2.634114506863004e+01, -8.657118422410139e+00},
	{"IYQ", -3.139623352223391e+01, -1.371220687601402e+01},
	{"IYR", -2.674077642176342e+01, -9.056749775543530e+00},
	{"IYS", -2.477913081801595e+01, -7.095104171796055e+00},
	{"IYT", -2.462761785550151e+01, -6.943591209281614e+00},
	{"IYU", -2.804812295397683e+01, -1.036409630775693e+01},
	{"IYV", -2.917159803374706e+01, -1.148757138752716e+01},
	{"IYW", -2.563039494810967e+01, -7.946368301889779e+00},
	{"IYX", -3.347916468771255e+01, -1.579513804149265e+01},
	{"IYY", -2.848374048315131e+01, -1.079971383693141e+01},
	{"IYZ", -3.281322683400946e+01, -1.512920018778957e+01},
	{"IZA", -1.387349747701586e+01, -2.088814827296994e+00},
	{"IZB", -2.358171577508685e+01, -1.179703312536798e+01},
	{"IZC", -2.792657097833783e+01, -1.614188832861896e+01},
	{"IZD", -2.828538070193102e+01, -1.650069805221215e+01},
	{"IZE", -1.248993844808849e+01, -7.052557983696232e-01},
	{"IZF", -2.267914423924680e+01, -1.089446158952794e+01},
	{"IZG", -2.839709803852045e+01, -1.661241538880159e+01},
	{"IZH", -2.012194297416414e+01, -8.337260324445275e+00},
	{"IZI", -1.587497005614827e+01, -4.090287406429401e+00},
	{"IZJ", -2.271418481694276e+01, -1.092950216722390e+01},
	{"IZK", -2.270651437808786e+01, -1.092183172836900e+01},
	{"IZL", -2.328942735749912e+01, -1.150474470778025e+01},
	{"IZM", -2.745481386740044e+01, -1.567013121768158e+01},
	{"IZN", -2.855764149602009e+01, -1.677295884630122e+01},
	{"IZO", -1.652820360569739e+01, -4.743520955978524e+00},
	{"IZP", -1.807067643376616e+01, -6.285993784047294e+00},
	{"IZQ", -3.483703663000097e+01, -2.305235398028210e+01},
	{"IZR", -2.050588501078531e+01, -8.721202361066444e+00},
	{"IZS", -2.359568600072762e+01, -1.181100335100875e+01},
	{"IZT", -1.961037266058613e+01, -7.825690010867267e+00},
	{"IZU", -1.818361189449687e+01, -6.398929244778002e+00},
	{"IZV", -2.800451743414526e+01, -1.621983478442639e+01},
	{"IZW", -2.207315332565338e+01, -1.028847067593452e+01},
	{"IZX", -3.764517319144581e+01, -2.586049054172694e+01},
	{"IZY", -2.608030199756540e+01, -1.429561934784654e+01},
	{"IZZ", -1.760994415851895e+01, -5.825261508800088e+00},
	{"JAA", -1.906904308328659e+01, -6.959019651959728e+00},
	{"JAB", -1.755669027698369e+01, -5.446666845656829e+00},
	{"JAC", -1.413149950554397e+01, -2.021476074217107e+00},
	{"JAD", -1.971474272272161e+01, -7.604719291394743e+00},
	{"JAE", -2.053147002893985e+01, -8.421446597612981e+00},
	{"JAF", -2.334597029613167e+01, -1.123594686480481e+01},
	{"JAG", -1.958543440829421e+01, -7.475410976967342e+00},
	{"JAH", -1.613202560508219e+01, -4.022002173755329e+00},
	{"JAI", -1.793634468508933e+01, -5.826321253762465e+00},
	{"JAJ", -2.898709754375228e+01, -1.687707411242542e+01},
	{"JAK", -2.049640021084040e+01, -8.386376779513537e+00},
	{"JAL", -1.900770845636736e+01, -6.897685025040498e+00},
	{"JAM", -1.420684126440104e+01, -2.096817833074170e+00},
	{"JAN", -1.433141572888161e+01, -2.221392297554748e+00},
	{"JAO", -2.858464230904757e+01, -1.647461887772070e+01},
	{"JAP", -1.652369275003422e+01, -4.413669318707352e+00},
	{"JAQ", -2.888569073769787e+01, -1.677566730637101e+01},
	{"JAR", -1.705389211852324e+01, -4.943868687196379e+00},
	{"JAS", -1.822129683007133e+01, -6.111273398744460e+00},
	{"JAT", -1.812395061878643e+01, -6.013927187459560e+00},
	{"JAU", -2.050257284989269e+01, -8.392549418565824e+00},
	{"JAV", -1.844740507988738e+01, -6.337381648560516e+00},
	{"JAW", -1.723794455019969e+01, -5.127921118872827e+00},
	{"JAX", -1.980843106686098e+01, -7.698407635534116e+00},
	{"JAY", -1.915527479931179e+01, -7.045251367984930e+00},
	{"JAZ", -2.001434685593123e+01, -7.904323424604367e+00},
	{"JBA", -2.051974329409450e+01, -2.541962813456470e+00},
	{"JBB", -2.357592675409743e+01, -5.598146273459406e+00},
	{"JBC", -2.268270809132265e+01, -4.704927610684624e+00},
	{"JBD", -2.271222541979650e+01, -4.734444939158480e+00},
	{"JBE", -2.124386042513267e+01, -3.266079944494650e+00},
	{"JBF", -2.371899853927432e+01, -5.741218058636295e+00},
	{"JBG", -2.372808801641101e+01, -5.750307535772985e+00},
	{"JBH", -2.370241576535115e+01, -5.724635284713131e+00},
	{"JBI", -2.183407326621654e+01, -3.856292785578517e+00},
	{"JBJ", -2.685168279227224e+01, -8.873902311634215e+00},
	{"JBK", -3.230701552776232e+01, -1.432923504712431e+01},
	{"JBL", -2.293785533577385e+01, -4.960074855135823e+00},
	{"JBM", -2.862353121987032e+01, -1.064575073923230e+01},
	{"JBN", -2.940460366316691e+01, -1.142682318252889e+01},
	{"JBO", -2.288599701117618e+01, -4.908216530538156e+00},
	{"JBP", -2.371542395700922e+01, -5.737643476371198e+00},
	{"JBQ", -3.617440659920941e+01, -1.819662611857138e+01},
	{"JBR", -2.108422686128065e+01, -3.106446380642629e+00},
	{"JBS", -2.200667113339088e+01, -4.028890652752859e+00},
	{"JBT", -2.347800501359215e+01, -5.500224532954122e+00},
	{"JBU", -2.171433464224387e+01, -3.736554161605842e+00},
	{"JBV", -3.008891322866016e+01, -1.211113274802214e+01},
	{"JBW", -2.114327866652374e+01, -3.165498185885714e+00},
	{"JBX", -3.946161443845000e+01, -2.148383395781198e+01},
	{"JBY", -2.308348757505999e+01, -5.105707094421964e+00},
	{"JBZ", -3.396971831421740e+01, -1.599193783357938e+01},
	{"JCA", -2.207419220755047e+01, -3.247022079415911e+00},
	{"JCB", -2.372314121516409e+01, -4.895971087029541e+00},
	{"JCC", -1.990563812404773e+01, -1.078467995913169e+00},
	{"JCD", -2.975726092684729e+01, -1.093009079871274e+01},
	{"JCE", -2.311609051052987e+01, -4.288920382395315e+00},
	{"JCF", -2.372203015847492e+01, -4.894860030340364e+00},
	{"JCG", -3.159767816213220e+01, -1.277050803399765e+01},
	{"JCH", -2.317322069615899e+01, -4.346050568024436e+00},
	{"JCI", -2.468806178544181e+01, -5.860891657307254e+00},
	{"JCJ", -3.356189783145865e+01, -1.473472770332410e+01},
	{"JCK", -2.527589790577976e+01, -6.448727777645209e+00},
	{"JCL", -2.200050910564328e+01, -3.173338977508721e+00},
	{"JCM", -3.055026779155859e+01, -1.172309766342402e+01},
	{"JCN", -3.141657282718365e+01, -1.258940269904910e+01},
	{"JCO", -2.290960931850983e+01, -4.082439190375271e+00},
	{"JCP", -2.983054224922603e+01, -1.100337212109148e+01},
	{"JCQ", -2.994620854424324e+01, -1.111903841610869e+01},
	{"JCR", -2.527597882629897e+01, -6.448808698164418e+00},
	{"JCS", -2.842677794047330e+01, -9.599607812338743e+00},
	{"JCT", -2.406480608395373e+01, -5.237635955819178e+00},
	{"JCU", -2.542660441351500e+01, -6.599434285380450e+00},
	{"JCV", -3.321134043358416e+01, -1.438417030544960e+01},
	{"JCW", -2.891960426291979e+01, -1.009243413478524e+01},
	{"JCX", -3.455469615024935e+01, -1.572752602211479e+01},
	{"JCY", -2.752383106349446e+01, -8.696660935359905e+00},
	{"JCZ", -3.316574599477477e+01, -1.433857586664022e+01},
	{"JDA", -2.300692129355231e+01, -2.285593583154312e+00},
	{"JDB", -2.575608099646549e+01, -5.034753286067495e+00},
	{"JDC", -2.690148706126292e+01, -6.180159350864924e+00},
	{"JDD", -2.669230082647586e+01, -5.970973116077863e+00},
	{"JDE", -2.286313732793555e+01, -2.141809617537554e+00},
	{"JDF", -2.640881714813300e+01, -5.687489437735011e+00},
	{"JDG", -2.713619311403195e+01, -6.414865403633958e+00},
	{"JDH", -2.576229629758453e+01, -5.040968587186539e+00},
	{"JDI", -2.421433784239612e+01, -3.493010131998120e+00},
	{"JDJ", -2.876409110461602e+01, -8.042763394218031e+00},
	{"JDK", -2.994093692499183e+01, -9.219609214593840e+00},
	{"JDL", -2.696475715629511e+01, -6.243429445897112e+00},
	{"JDM", -2.651860103660288e+01, -5.797273326204888e+00},
	{"JDN", -2.678768609915745e+01, -6.066358388759461e+00},
	{"JDO", -2.481907517456295e+01, -4.097747464164958e+00},
	{"JDP", -2.717511696675562e+01, -6.453789256357624e+00},
	{"JDQ", -3.138482845550536e+01, -1.066350074510736e+01},
	{"JDR", -2.611485844773087e+01, -5.393530737332875e+00},
	{"JDS", -2.505308937668868e+01, -4.331761666290682e+00},
	{"JDT", -2.412340909875393e+01, -3.402081388355931e+00},
	{"JDU", -2.617337718557208e+01, -5.452049475174091e+00},
	{"JDV", -2.847009824925233e+01, -7.748770538854337e+00},
	{"JDW", -2.584200498013019e+01, -5.120677269732193e+00},
	{"JDX", -3.628401875677956e+01, -1.556269104638156e+01},
	{"JDY", -2.721082135576937e+01, -6.489493645371373e+00},
	{"JDZ", -3.236646055709806e+01, -1.164513284670006e+01},
	{"JEA", -1.559999570960992e+01, -4.912327154421251e+00},
	{"JEB", -1.818226810924679e+01, -7.494599554058116e+00},
	{"JEC", -1.175797454117653e+01, -1.070305985987855e+00},
	{"JED", -1.850897834792581e+01, -7.821309792737134e+00},
	{"JEE", -2.003612539528222e+01, -9.348456840093545e+00},
	{"JEF", -1.588779218696989e+01, -5.200123631781216e+00},
	{"JEG", -2.522622197794126e+01, -1.453855342275259e+01},
	{"JEH", -1.566594259011264e+01, -4.978274034923961e+00},
	{"JEI", -2.028707225575825e+01, -9.599403700569578e+00},
	{"JEJ", -2.822973721282976e+01, -1.754206865764109e+01},
	{"JEK", -2.136366783027217e+01, -1.067599927508350e+01},
	{"JEL", -1.867214528565462e+01, -7.984476730465941e+00},
	{"JEM", -1.886529440605961e+01, -8.177625850870932e+00},
	{"JEN", -1.875523663434415e+01, -8.067568079155476e+00},
	{"JEO", -1.957358011831227e+01, -8.885911563123596e+00},
	{"JEP", -1.814462141004996e+01, -7.456952854861290e+00},
	{"JEQ", -2.771384060186119e+01, -1.702617204667252e+01},
	{"JER", -1.345845198898833e+01, -2.770783433799662e+00},
	{"JES", -1.316238349611707e+01, -2.474714940928402e+00},
	{"JET", -1.797551054423610e+01, -7.287841989047422e+00},
	{"JEU", -2.011274557169491e+01, -9.425077016506238e+00},
	{"JEV", -2.103513515648615e+01, -1.034746660129748e+01},
	{"JEW", -1.482443883473107e+01, -4.136770279542393e+00},
	{"JEX", -2.609404689744386e+01, -1.540637834225519e+01},
	{"JEY", -2.506949909711601e+01, -1.438183054192734e+01},
	{"JEZ", -1.778728102159574e+01, -7.099612466407060e+00},
	{"JFA", -2.455865276389068e+01, -4.713639157088393e+00},
	{"JFB", -2.771317928277001e+01, -7.868165675967727e+00},
	{"JFC", -2.712705143209478e+01, -7.282037825292502e+00},
	{"JFD", -2.800902432288425e+01, -8.164010716081965e+00},
	{"JFE", -2.479546543270669e+01, -4.950451825904410e+00},
	{"JFF", -2.543853441458774e+01, -5.593520807785457e+00},
	{"JFG", -2.766359384271764e+01, -7.818580235915353e+00},
	{"JFH", -2.646407140293311e+01, -6.619057796130833e+00},
	{"JFI", -2.309070325759555e+01, -3.245689650793259e+00},
	{"JFJ", -2.845188841665971e+01, -8.606874809857432e+00},
	{"JFK", -3.034806918160925e+01, -1.050305557480696e+01},
	{"JFL", -2.615471046276036e+01, -6.309696855958076e+00},
	{"JFM", -2.679525539368336e+01, -6.950241786881070e+00},
	{"JFN", -2.841508131854277e+01, -8.570067711740483e+00},
	{"JFO", -2.140724053985677e+01, -1.562226933054485e+00},
	{"JFP", -2.732728824819861e+01, -7.482274641396322e+00},
	{"JFQ", -3.259491475188182e+01, -1.274990114507954e+01},
	{"JFR", -2.158678097765504e+01, -1.741767370852753e+00},
	{"JFS", -2.665436505518024e+01, -6.809351448377954e+00},
	{"JFT", -2.363581030829773e+01, -3.790796701495443e+00},
	{"JFU", -2.610274863964641e+01, -6.257735032844129e+00},
	{"JFV", -2.962889704518627e+01, -9.783883438383985e+00},
	{"JFW", -2.738121196978494e+01, -7.536198362982653e+00},
	{"JFX", -3.490628625621533e+01, -1.506127264941304e+01},
	{"JFY", -2.802374431399129e+01, -8.178730707189015e+00},
	{"JFZ", -3.103487971574186e+01, -1.118986610893958e+01},
	{"JGA", -2.275219001086261e+01, -3.322635507921051e+00},
	{"JGB", -2.701239581627578e+01, -7.582841313334217e+00},
	{"JGC", -2.726329813545222e+01, -7.833743632510662e+00},
	{"JGD", -2.713518132074383e+01, -7.705626817802272e+00},
	{"JGE", -2.053318545001212e+01, -1.103630947070561e+00},
	{"JGF", -2.681818857687486e+01, -7.388634073933307e+00},
	{"JGG", -2.696025023602471e+01, -7.530695733083151e+00},
	{"JGH", -2.261081795203562e+01, -3.181263449094065e+00},
	{"JGI", -2.429614790875249e+01, -4.866593405810930e+00},
	{"JGJ", -3.048810084396822e+01, -1.105854634102666e+01},
	{"JGK", -3.072641477726546e+01, -1.129686027432391e+01},
	{"JGL", -2.536996018071454e+01, -5.940405677772987e+00},
	{"JGM", -2.677054511158868e+01, -7.340990608647127e+00},
	{"JGN", -2.345493078913319e+01, -4.025376286191636e+00},
	{"JGO", -2.374985561399977e+01, -4.320301111058215e+00},
	{"JGP", -2.725633726849048e+01, -7.826782765548918e+00},
	{"JGQ", -3.201949387188353e+01, -1.258993936894197e+01},
	{"JGR", -2.417288077450629e+01, -4.743326271564737e+00},
	{"JGS", -2.509631403844062e+01, -5.666759535499063e+00},
	{"JGT", -2.420902625392052e+01, -4.779471750978958e+00},
	{"JGU", -2.518139103523968e+01, -5.751836532298120e+00},
	{"JGV", -2.985993565380402e+01, -1.043038115086247e+01},
	{"JGW", -2.644107928177601e+01, -7.011524778834458e+00},
	{"JGX", -3.523831433833089e+01, -1.580875983538933e+01},
	{"JGY", -2.721292449314346e+01, -7.783369990201903e+00},
	{"JGZ", -3.375481607817311e+01, -1.432526157523155e+01},
	{"JHA", -2.144659392858960e+01, -2.830896418955940e+00},
	{"JHB", -2.813306164540794e+01, -9.517364135774278e+00},
	{"JHC", -2.810503775848078e+01, -9.489340248847119e+00},
	{"JHD", -2.858449078530713e+01, -9.968793275673473e+00},
	{"JHE", -2.130567238579934e+01, -2.689974876165681e+00},
	{"JHF", -2.363707426382678e+01, -5.021376754193118e+00},
	{"JHG", -2.910332989085884e+01, -1.048763238122519e+01},
	{"JHH", -2.356698120059367e+01, -4.951283690960010e+00},
	{"JHI", -2.241353273801258e+01, -3.797835228378924e+00},
	{"JHJ", -3.101091419021078e+01, -1.239521668057712e+01},
	{"JHK", -3.134536330870621e+01, -1.272966579907255e+01},
	{"JHL", -2.864204111292145e+01, -1.002634360328779e+01},
	{"JHM", -1.999551236641987e+01, -1.379814856786215e+00},
	{"JHN", -2.855606299216750e+01, -9.940365482533839e+00},
	{"JHO", -2.174520511208351e+01, -3.129507602449849e+00},
	{"JHP", -2.848889804403370e+01, -9.873200534400040e+00},
	{"JHQ", -3.277775781187778e+01, -1.416206030224412e+01},
	{"JHR", -2.644444936209271e+01, -7.828751852459053e+00},
	{"JHS", -2.357166942885417e+01, -4.955971919220512e+00},
	{"JHT", -2.461219242105615e+01, -5.996494911422494e+00},
	{"JHU", -2.648449005537235e+01, -7.868792545738692e+00},
	{"JHV", -3.126049450911800e+01, -1.264479699948435e+01},
	{"JHW", -2.723121506983225e+01, -8.615517560198590e+00},
	{"JHX", -3.677369484082094e+01, -1.815799733118728e+01},
	{"JHY", -2.666969596584140e+01, -8.053998456207740e+00},
	{"JHZ", -3.378557708669464e+01, -1.516987957706099e+01},
	{"JIA", -2.314066383369327e+01, -8.454006736240144e+00},
	{"JIB", -2.087503571147782e+01, -6.188378614024693e+00},
	{"JIC", -2.368522750714250e+01, -8.998570409689373e+00},
	{"JID", -2.231293297925643e+01, -7.626275881803304e+00},
	{"JIE", -2.434351797612707e+01, -9.656860878673939e+00},
	{"JIF", -2.326385786770150e+01, -8.577200770248366e+00},
	{"JIG", -2.462906725072539e+01, -9.942410153272258e+00},
	{"JIH", -2.266980661246064e+01, -7.983149515007511e+00},
	{"JII", -2.863163527071795e+01, -1.394497817326482e+01},
	{"JIJ", -3.118887723877797e+01, -1.650222014132484e+01},
	{"JIK", -2.358787488080602e+01, -8.901217783352889e+00},
	{"JIL", -2.275036350079483e+01, -8.063706403341699e+00},
	{"JIM", -1.497013014267062e+01, -2.834730452174906e-01},
	{"JIN", -1.917545389304072e+01, -4.488796795587592e+00},
	{"JIO", -2.269358930566015e+01, -8.006932208207026e+00},
	{"JIP", -2.260827471965218e+01, -7.921617622199049e+00},
	{"JIQ", -2.984839910926972e+01, -1.516174201181659e+01},
	{"JIR", -2.415041299061721e+01, -9.463755893164086e+00},
	{"JIS", -1.846401788679671e+01, -3.777360789343579e+00},
	{"JIT", -2.109535607530417e+01, -6.408698977851039e+00},
	{"JIU", -2.741193619425688e+01, -1.272527909680375e+01},
	{"JIV", -2.488923952951162e+01, -1.020258243205850e+01},
	{"JIW", -2.715094398151252e+01, -1.246428688405939e+01},
	{"JIX", -2.836152737181925e+01, -1.367487027436612e+01},
	{"JIY", -3.344517418984874e+01, -1.875851709239561e+01},
	{"JIZ", -2.754486163989566e+01, -1.285820454244253e+01},
	{"JJA", -2.283352899523708e+01, -4.212038769303866e+00},
	{"JJB", -2.978915600686099e+01, -1.116766578092777e+01},
	{"JJC", -3.063854565435752e+01, -1.201705542842430e+01},
	{"JJD", -3.253270323662096e+01, -1.391121301068774e+01},
	{"JJE", -2.249901544214346e+01, -3.877525216210245e+00},
	{"JJF", -3.165638913302525e+01, -1.303489890709203e+01},
	{"JJG", -3.124093002916452e+01, -1.261943980323131e+01},
	{"JJH", -3.042707303585662e+01, -1.180558280992341e+01},
	{"JJI", -2.649803262367609e+01, -7.876542397742877e+00},
	{"JJJ", -3.043286575215618e+01, -1.181137552622296e+01},
	{"JJK", -3.312143726002746e+01, -1.449994703409425e+01},
	{"JJL", -3.163027012926407e+01, -1.300877990333086e+01},
	{"JJM", -3.198619550299152e+01, -1.336470527705831e+01},
	{"JJN", -3.493626523164414e+01, -1.631477500571093e+01},
	{"JJO", -2.316016772199035e+01, -4.538677496057138e+00},
	{"JJP", -3.139804776581056e+01, -1.277655753987734e+01},
	{"JJQ", -3.438429950673644e+01, -1.576280928080323e+01},
	{"JJR", -2.373831951125592e+01, -5.116829285322709e+00},
	{"JJS", -3.104726306008549e+01, -1.242577283415228e+01},
	{"JJT", -2.116436717528452e+01, -2.542876949351310e+00},
	{"JJU", -2.277011261078776e+01, -4.148622384854545e+00},
	{"JJV", -3.800335272633729e+01, -1.938186250040408e+01},
	{"JJW", -1.942811201612752e+01, -8.066217901943091e-01},
	{"JJX", -4.068265813340612e+01, -2.206116790747290e+01},
	{"JJY", -3.715252888425074e+01, -1.853103865831752e+01},
	{"JJZ", -3.525752997770917e+01, -1.663603975177595e+01},
	{"JKA", -2.633990779301372e+01, -5.029846059209216e+00},
	{"JKB", -2.865200425599182e+01, -7.341942522187317e+00},
	{"JKC", -2.908387763831561e+01, -7.773815904511106e+00},
	{"JKD", -2.971323275889608e+01, -8.403171025091579e+00},
	{"JKE", -2.388022789131371e+01, -2.570166157509205e+00},
	{"JKF", -2.854669735159709e+01, -7.236635617792592e+00},
	{"JKG", -3.082101337143110e+01, -9.510951637626603e+00},
	{"JKH", -2.228622147345589e+01, -9.761597396513888e-01},
	{"JKI", -2.466429396689437e+01, -3.354232233089869e+00},
	{"JKJ", -3.239918785283155e+01, -1.108912611902704e+01},
	{"JKK", -3.173091794528385e+01, -1.042085621147934e+01},
	{"JKL", -2.810954650541127e+01, -6.799484771606761e+00},
	{"JKM", -2.908391514735598e+01, -7.773853413551480e+00},
	{"JKN", -2.585763799606596e+01, -4.547576262261459e+00},
	{"JKO", -2.670917612197844e+01, -5.399114388173938e+00},
	{"JKP", -2.943485479282216e+01, -8.124793059017659e+00},
	{"JKQ", -3.507832764740462e+01, -1.376826591360012e+01},
	{"JKR", -2.987045908832695e+01, -8.560397354522449e+00},
	{"JKS", -2.598876537053940e+01, -4.678703636734895e+00},
	{"JKT", -2.675365287771858e+01, -5.443591143914078e+00},
	{"JKU", -2.860171848047374e+01, -7.291656746669233e+00},
	{"JKV", -3.223934291867624e+01, -1.092928118487174e+01},
	{"JKW", -2.792516114166848e+01, -6.615099407863981e+00},
	{"JKX", -3.605037451329789e+01, -1.474031277949338e+01},
	{"JKY", -2.859538227835917e+01, -7.285320544554669e+00},
	{"JKZ", -3.415223739916762e+01, -1.284217566536312e+01},
	{"JLA", -2.390533997152748e+01, -4.086445368486363e+00},
	{"JLB", -2.674810118335832e+01, -6.929206580317205e+00},
	{"JLC", -2.735997858781210e+01, -7.541083984770993e+00},
	{"JLD", -2.466076353476602e+01, -4.841868931724908e+00},
	{"JLE", -2.332871408982346e+01, -3.509819486782349e+00},
	{"JLF", -2.649932450942205e+01, -6.680429906380939e+00},
	{"JLG", -2.818399091379053e+01, -8.365096310749422e+00},
	{"JLH", -2.761585414023331e+01, -7.796959537192194e+00},
	{"JLI", -2.277796542381168e+01, -2.959070820770562e+00},
	{"JLJ", -3.090609296336684e+01, -1.108719836032572e+01},
	{"JLK", -2.818831543438903e+01, -8.369420831347913e+00},
	{"JLL", -2.257601416557729e+01, -2.757119562536179e+00},
	{"JLM", -2.726228508324524e+01, -7.443390480204124e+00},
	{"JLN", -2.138872397649670e+01, -1.569829373455580e+00},
	{"JLO", -2.412863902281294e+01, -4.309744419771827e+00},
	{"JLP", -2.724867128005270e+01, -7.429776677011583e+00},
	{"JLQ", -3.200472278590861e+01, -1.218582818286750e+01},
	{"JLR", -2.777935737077848e+01, -7.960462767737370e+00},
	{"JLS", -2.554569431287038e+01, -5.726799709829265e+00},
	{"JLT", -2.502649708069735e+01, -5.207602477656236e+00},
	{"JLU", -2.615045497222146e+01, -6.331560369180345e+00},
	{"JLV", -2.754868333292622e+01, -7.729788729885106e+00},
	{"JLW", -2.724549968178577e+01, -7.426605078744653e+00},
	{"JLX", -3.530669097003611e+01, -1.548779636699499e+01},
	{"JLY", -2.463028169260453e+01, -4.811387089563416e+00},
	{"JLZ", -3.396818144315187e+01, -1.414928684011076e+01},
	{"JMA", -2.197964463633470e+01, -1.804824659566140e+00},
	{"JMB", -2.260182444424191e+01, -2.427004467473342e+00},
	{"JMC", -2.848789165630715e+01, -8.313071679538586e+00},
	{"JMD", -2.865810288902098e+01, -8.483282912252411e+00},
	{"JME", -2.294692760798159e+01, -2.772107631213027e+00},
	{"JMF", -2.800006192935486e+01, -7.825241952586298e+00},
	{"JMG", -2.965283723926502e+01, -9.478017262496452e+00},
	{"JMH", -2.762168301536928e+01, -7.446863038600717e+00},
	{"JMI", -2.431021008085705e+01, -4.135390104088485e+00},
	{"JMJ", -3.108109870566709e+01, -1.090627872889852e+01},
	{"JMK", -3.138954096977621e+01, -1.121472099300765e+01},
	{"JML", -2.890862649121782e+01, -8.733806514449252e+00},
	{"JMM", -2.593109393591105e+01, -5.756273959142487e+00},
	{"JMN", -2.786625282512831e+01, -7.691432848359742e+00},
	{"JMO", -2.414854682678775e+01, -3.973726850019184e+00},
	{"JMP", -2.506302871855944e+01, -4.888208741790877e+00},
	{"JMQ", -3.399785770019367e+01, -1.382303772342511e+01},
	{"JMR", -2.823724295813625e+01, -8.062422981367678e+00},
	{"JMS", -2.343959803571403e+01, -3.264778058945469e+00},
	{"JMT", -2.547799687425657e+01, -5.303176897488004e+00},
	{"JMU", -2.598766675477810e+01, -5.812846778009535e+00},
	{"JMV", -3.073213887099884e+01, -1.055731889423028e+01},
	{"JMW", -2.719376973395710e+01, -7.018949757188532e+00},
	{"JMX", -3.563754715714713e+01, -1.546272718037857e+01},
	{"JMY", -2.558030079101257e+01, -5.405480814244005e+00},
	{"JMZ", -3.426662127617401e+01, -1.409180129940545e+01},
	{"JNA", -2.712104093931341e+01, -3.996151233892228e+00},
	{"JNB", -2.951859346505386e+01, -6.393703759632681e+00},
	{"JNC", -2.759159128500493e+01, -4.466701579583741e+00},
	{"JND", -2.545184487755112e+01, -2.326955172129940e+00},
	{"JNE", -2.668290393683735e+01, -3.558014231416163e+00},
	{"JNF", -2.927277334891246e+01, -6.147883643491270e+00},
	{"JNG", -2.634075491290360e+01, -3.215865207482417e+00},
	{"JNH", -2.898741237939130e+01, -5.862522673970116e+00},
	{"JNI", -2.746303101263251e+01, -4.338141307211325e+00},
	{"JNJ", -3.167956828263430e+01, -8.554678577213110e+00},
	{"JNK", -3.033681297021872e+01, -7.211923264797539e+00},
	{"JNL", -2.974205759046892e+01, -6.617167885047737e+00},
	{"JNM", -2.969280431907961e+01, -6.567914613658423e+00},
	{"JNN", -2.964392712957864e+01, -6.519037424157451e+00},
	{"JNO", -2.679388376331256e+01, -3.668994057891378e+00},
	{"JNP", -3.018269568214474e+01, -7.057805976723559e+00},
	{"JNQ", -3.259038322182536e+01, -9.465493516404173e+00},
	{"JNR", -3.074902852135913e+01, -7.624138815937948e+00},
	{"JNS", -2.711002758810880e+01, -3.985137882687614e+00},
	{"JNT", -2.572080108497051e+01, -2.595911379549322e+00},
	{"JNU", -2.970894859269329e+01, -6.584058887272104e+00},
	{"JNV", -3.083490259790756e+01, -7.710012892486376e+00},
	{"JNW", -2.918707020617275e+01, -6.062180500751565e+00},
	{"JNX", -3.464695736400806e+01, -1.152206765858688e+01},
	{"JNY", -2.921247929661418e+01, -6.087589591193000e+00},
	{"JNZ", -3.515566240778765e+01, -1.203077270236647e+01},
	{"JOA", -1.600874853025745e+01, -4.659911045661210e+00},
	{"JOB", -1.645810179129203e+01, -5.109264306695790e+00},
	{"JOC", -2.066009122087252e+01, -9.311253736276278e+00},
	{"JOD", -2.458902290499096e+01, -1.324018542039472e+01},
	{"JOE", -1.602388782293898e+01, -4.675050338342748e+00},
	{"JOF", -2.056888700331357e+01, -9.220049518717330e+00},
	{"JOG", -2.052031731180822e+01, -9.171479827211982e+00},
	{"JOH", -1.451326579718409e+01, -3.164428312587853e+00},
	{"JOI", -1.372225251930356e+01, -2.373415034707324e+00},
	{"JOJ", -2.752340407950677e+01, -1.617456659491053e+01},
	{"JOK", -1.762667252521560e+01, -6.277835040619368e+00},
	{"JOL", -1.868514982702490e+01, -7.336312342428665e+00},
	{"JOM", -2.328012867591397e+01, -1.193129119131773e+01},
	{"JON", -1.581599663661563e+01, -4.467159152019392e+00},
	{"JOO", -2.439523455463669e+01, -1.304639707004046e+01},
	{"JOP", -1.904493808349048e+01, -7.696100598894247e+00},
	{"JOQ", -3.083852253852161e+01, -1.948968505392537e+01},
	{"JOR", -1.436794902672299e+01, -3.019111542126754e+00},
	{"JOS", -1.446638252334649e+01, -3.117545038750248e+00},
	{"JOT", -1.878725010428027e+01, -7.438412619684036e+00},
	{"JOU", -1.452266715771668e+01, -3.173829673120438e+00},
	{"JOV", -1.894252732608809e+01, -7.593689841491858e+00},
	{"JOW", -2.277719219535124e+01, -1.142835471075500e+01},
	{"JOX", -2.939025349811098e+01, -1.804141601351474e+01},
	{"JOY", -1.408518149406011e+01, -2.736344009463871e+00},
	{"JOZ", -2.001706139300468e+01, -8.668223908408448e+00},
	{"JPA", -2.411420258277986e+01, -4.527530343192262e+00},
	{"JPB", -2.959024844889186e+01, -1.000357620930426e+01},
	{"JPC", -3.048612025859089e+01, -1.089944801900329e+01},
	{"JPD", -3.101250140684916e+01, -1.142582916726157e+01},
	{"JPE", -2.094606498984822e+01, -1.359392750260624e+00},
	{"JPF", -2.956647211871581e+01, -9.979799879128208e+00},
	{"JPG", -3.037416695102182e+01, -1.078749471143422e+01},
	{"JPH", -2.343990893625006e+01, -3.853236696662463e+00},
	{"JPI", -2.527093742865489e+01, -5.684265189067292e+00},
	{"JPJ", -3.319842425128723e+01, -1.361175201169962e+01},
	{"JPK", -3.308134485930613e+01, -1.349467261971853e+01},
	{"JPL", -2.451767462353998e+01, -4.931002383952383e+00},
	{"JPM", -2.878589766314929e+01, -9.199225423561689e+00},
	{"JPN", -3.091770895999079e+01, -1.133103672040319e+01},
	{"JPO", -2.398310843880824e+01, -4.396436199220640e+00},
	{"JPP", -2.540185372062394e+01, -5.815181481036342e+00},
	{"JPQ", -3.445469491694837e+01, -1.486802267736077e+01},
	{"JPR", -2.382204631771241e+01, -4.235374078124813e+00},
	{"JPS", -2.671682860367682e+01, -7.130156364089222e+00},
	{"JPT", -2.542502901139138e+01, -5.838356771803778e+00},
	{"JPU", -2.136064729182638e+01, -1.773975052238781e+00},
	{"JPV", -3.261266255219200e+01, -1.302599031260440e+01},
	{"JPW", -2.881441991179730e+01, -9.227747672209704e+00},
	{"JPX", -3.795587362235617e+01, -1.836920138276857e+01},
	{"JPY", -2.816650027931651e+01, -8.579828039728913e+00},
	{"JPZ", -3.626098924780727e+01, -1.667431700821967e+01},
	{"JQA", -2.412862433153672e+01, -1.555700351023247e+00},
	{"JQB", -3.239757163605255e+01, -9.824647655539076e+00},
	{"JQC", -3.130857085394943e+01, -8.735646873435954e+00},
	{"JQD", -3.291927549614248e+01, -1.034635151562900e+01},
	{"JQE", -3.330717004028672e+01, -1.073424605977324e+01},
	{"JQF", -3.166607443954334e+01, -9.093150459029857e+00},
	{"JQG", -3.838289841392483e+01, -1.580997443341136e+01},
	{"JQH", -3.221763309640245e+01, -9.644709115888979e+00},
	{"JQI", -2.810919370429451e+01, -5.536269723781035e+00},
	{"JQJ", -3.418294487154425e+01, -1.161002089103077e+01},
	{"JQK", -4.001508360886358e+01, -1.744215962835010e+01},
	{"JQL", -3.266002066984546e+01, -1.008709668933198e+01},
	{"JQM", -3.183763382770477e+01, -9.264709847191297e+00},
	{"JQN", -3.466695120467352e+01, -1.209402722416004e+01},
	{"JQO", -3.286339703539895e+01, -1.029047305488548e+01},
	{"JQP", -3.286558242182481e+01, -1.029265844131134e+01},
	{"JQQ", -3.474698537056191e+01, -1.217406139004843e+01},
	{"JQR", -3.271228587327667e+01, -1.013936189276319e+01},
	{"JQS", -2.978459802856542e+01, -7.211674048051945e+00},
	{"JQT", -3.028426903249973e+01, -7.711345051986252e+00},
	{"JQU", -2.328288705701484e+01, -7.099630765013570e-01},
	{"JQV", -3.557813905091518e+01, -1.300521507040171e+01},
	{"JQW", -3.192149505500973e+01, -9.348571074496256e+00},
	{"JQX", -4.203821556674651e+01, -1.946529158623303e+01},
	{"JQY", -3.623093576819329e+01, -1.365801178767981e+01},
	{"JQZ", -4.317778300349703e+01, -2.060485902298356e+01},
	{"JRA", -2.323024545855066e+01, -4.433146741216738e+00},
	{"JRB", -2.640089207300507e+01, -7.603793355671149e+00},
	{"JRC", -2.249584625342561e+01, -3.698747536091688e+00},
	{"JRD", -2.444046339931777e+01, -5.643364681983851e+00},
	{"JRE", -2.129095744180229e+01, -2.493858724468368e+00},
	{"JRF", -2.623026199300019e+01, -7.433163275666268e+00},
	{"JRG", -2.585327939883099e+01, -7.056180681497068e+00},
	{"JRH", -2.344245209669728e+01, -4.645353379363360e+00},
	{"JRI", -2.243708868062364e+01, -3.639989963289721e+00},
	{"JRJ", -2.932324984553176e+01, -1.052615112819784e+01},
	{"JRK", -2.619067625709265e+01, -7.393577539758730e+00},
	{"JRL", -2.605762169714101e+01, -7.260522979807082e+00},
	{"JRM", -2.322981541614017e+01, -4.432716698806251e+00},
	{"JRN", -2.324512138115507e+01, -4.448022663821149e+00},
	{"JRO", -2.153439716309755e+01, -2.737298445763626e+00},
	{"JRP", -2.259112714535831e+01, -3.794028428024392e+00},
	{"JRQ", -3.070978597577253e+01, -1.191268725843861e+01},
	{"JRR", -2.559301276330902e+01, -6.795914045975098e+00},
	{"JRS", -2.276548692045878e+01, -3.968388203124860e+00},
	{"JRT", -2.353805427946840e+01, -4.740955562134474e+00},
	{"JRU", -2.252006701287927e+01, -3.722968295545349e+00},
	{"JRV", -2.664092931568961e+01, -7.843830598355694e+00},
	{"JRW", -2.599649913130284e+01, -7.199400413968918e+00},
	{"JRX", -3.137491214853198e+01, -1.257781343119806e+01},
	{"JRY", -2.480463750366001e+01, -6.007538786326086e+00},
	{"JRZ", -3.230603468237824e+01, -1.350893596504432e+01},
	{"JSA", -2.211772638158135e+01, -2.881838847718815e+00},
	{"JSB", -2.258153127759813e+01, -3.345643743735597e+00},
	{"JSC", -2.336002326686794e+01, -4.124135733005410e+00},
	{"JSD", -2.697135250790102e+01, -7.735464974038490e+00},
	{"JSE", -2.354792873173709e+01, -4.312041197874562e+00},
	{"JSF", -2.623257858686924e+01, -6.996691053006711e+00},
	{"JSG", -2.770461408491287e+01, -8.468726551050340e+00},
	{"JSH", -2.095394599005086e+01, -1.718058456188326e+00},
	{"JSI", -2.421000463116910e+01, -4.974117097306563e+00},
	{"JSJ", -2.975732308494250e+01, -1.052143555107996e+01},
	{"JSK", -2.805378754537025e+01, -8.817900011507724e+00},
	{"JSL", -2.655890222555244e+01, -7.323014691689909e+00},
	{"JSM", -2.630544389461591e+01, -7.069556360753381e+00},
	{"JSN", -2.676738362262631e+01, -7.531496088763776e+00},
	{"JSO", -2.389808599342499e+01, -4.662198459562459e+00},
	{"JSP", -2.541933314096398e+01, -6.183445607101450e+00},
	{"JSQ", -2.966624681108665e+01, -1.043035927722412e+01},
	{"JSR", -2.700178640613780e+01, -7.765898872275266e+00},
	{"JSS", -2.433111609970285e+01, -5.095228565840322e+00},
	{"JST", -2.184503826788125e+01, -2.609150734018716e+00},
	{"JSU", -2.531821235344343e+01, -6.082324819580898e+00},
	{"JSV", -2.890523048979355e+01, -9.669342955931025e+00},
	{"JSW", -2.533396375289249e+01, -6.098076219029962e+00},
	{"JSX", -3.173088319798859e+01, -1.249499566412606e+01},
	{"JSY", -2.781351275582364e+01, -8.577625221961110e+00},
	{"JSZ", -3.319385767009872e+01, -1.395797013623619e+01},
	{"JTA", -2.237379254719472e+01, -3.043767691113147e+00},
	{"JTB", -2.748213319850985e+01, -8.152108342428273e+00},
	{"JTC", -2.755441419749629e+01, -8.224389341414721e+00},
	{"JTD", -2.820403464014126e+01, -8.874009784059682e+00},
	{"JTE", -2.435178998368181e+01, -5.021765127600238e+00},
	{"JTF", -2.771245167054780e+01, -8.382426814466225e+00},
	{"JTG", -2.865408657366486e+01, -9.324061717583284e+00},
	{"JTH", -2.037840890588486e+01, -1.048384049803284e+00},
	{"JTI", -2.224493138666933e+01, -2.914906530587748e+00},
	{"JTJ", -3.080959386353982e+01, -1.147956900745824e+01},
	{"JTK", -3.063985263589938e+01, -1.130982777981780e+01},
	{"JTL", -2.705709043026281e+01, -7.727065574181231e+00},
	{"JTM", -2.260484552390130e+01, -3.274820667819727e+00},
	{"JTN", -2.824590376249008e+01, -8.915878906408508e+00},
	{"JTO", -2.398167176137735e+01, -4.651646905295771e+00},
	{"JTP", -2.831754072780001e+01, -8.987515871718436e+00},
	{"JTQ", -3.277615807072818e+01, -1.344613321464660e+01},
	{"JTR", -2.565413297910904e+01, -6.324108123027465e+00},
	{"JTS", -2.564144497720955e+01, -6.311420121127975e+00},
	{"JTT", -2.505860539855514e+01, -5.728580542473565e+00},
	{"JTU", -2.650628848810093e+01, -7.176263632019358e+00},
	{"JTV", -3.076589981725286e+01, -1.143587496117129e+01},
	{"JTW", -2.629087724581664e+01, -6.960852389735062e+00},
	{"JTX", -3.548196085749179e+01, -1.615193600141021e+01},
	{"JTY", -2.664567129279826e+01, -7.315646436716677e+00},
	{"JTZ", -3.295519431445265e+01, -1.362516945837108e+01},
	{"JUA", -2.190634148860527e+01, -1.094756984424316e+01},
	{"JUB", -1.841886762326382e+01, -7.460095978901703e+00},
	{"JUC", -2.296375630874061e+01, -1.200498466437850e+01},
	{"JUD", -1.249019484509145e+01, -1.531423200729338e+00},
	{"JUE", -2.470714406577435e+01, -1.374837242141223e+01},
	{"JUF", -2.665880988789054e+01, -1.570003824352843e+01},
	{"JUG", -1.645460199582147e+01, -5.495830351459353e+00},
	{"JUH", -2.732896693703412e+01, -1.637019529267200e+01},
	{"JUI", -1.780000574324867e+01, -6.841234098886555e+00},
	{"JUJ", -3.161671233371333e+01, -2.065794068935121e+01},
	{"JUK", -2.169780107878618e+01, -1.073902943442407e+01},
	{"JUL", -1.448131910137467e+01, -3.522547457012552e+00},
	{"JUM", -1.647475439643663e+01, -5.515982752074517e+00},
	{"JUN", -1.514755580855520e+01, -4.188784164193081e+00},
	{"JUO", -2.796201976849684e+01, -1.700324812413473e+01},
	{"JUP", -1.788783305703010e+01, -6.929061412667981e+00},
	{"JUQ", -3.307831628474871e+01, -2.211954464038659e+01},
	{"JUR", -1.493272716492706e+01, -3.973955520564946e+00},
	{"JUS", -1.239245011032636e+01, -1.433678465964244e+00},
	{"JUT", -1.806250354190543e+01, -7.103731897543318e+00},
	{"JUU", -3.042148431807307e+01, -1.946271267371095e+01},
	{"JUV", -1.932529915417619e+01, -8.366527509814071e+00},
	{"JUW", -2.744387317587214e+01, -1.648510153151003e+01},
	{"JUX", -3.003927282875502e+01, -1.908050118439291e+01},
	{"JUY", -2.918724482321628e+01, -1.822847317885416e+01},
	{"JUZ", -2.966228291898864e+01, -1.870351127462653e+01},
	{"JVA", -2.970951681411159e+01, -3.517539613997257e+00},
	{"JVB", -3.873426633199270e+01, -1.254228913187837e+01},
	{"JVC", -3.892362265933290e+01, -1.273164545921857e+01},
	{"JVD", -3.817869479307694e+01, -1.198671759296261e+01},
	{"JVE", -2.676133097702714e+01, -5.693537769128129e-01},
	{"JVF", -3.838304203836447e+01, -1.219106483825014e+01},
	{"JVG", -3.969143442568596e+01, -1.349945722557162e+01},
	{"JVH", -3.740627540111440e+01, -1.121429820100007e+01},
	{"JVI", -2.873892156319527e+01, -2.546944363080937e+00},
	{"JVJ", -3.961429212632657e+01, -1.342231492621224e+01},
	{"JVK", -4.149389274910489e+01, -1.530191554899056e+01},
	{"JVL", -3.876613582079040e+01, -1.257415862067606e+01},
	{"JVM", -3.777659860241855e+01, -1.158462140230422e+01},
	{"JVN", -3.687500648788695e+01, -1.068302928777262e+01},
	{"JVO", -3.036762753592889e+01, -4.175650335814563e+00},
	{"JVP", -3.784924560750036e+01, -1.165726840738603e+01},
	{"JVQ", -4.544608752244037e+01, -1.925411032232605e+01},
	{"JVR", -3.580528115459115e+01, -9.613303954476818e+00},
	{"JVS", -3.684305734412649e+01, -1.065108014401216e+01},
	{"JVT", -3.615896624732439e+01, -9.966989047210056e+00},
	{"JVU", -3.574493113063973e+01, -9.552953930525398e+00},
	{"JVV", -4.033966468805126e+01, -1.414768748793692e+01},
	{"JVW", -3.748242431589362e+01, -1.129044711577928e+01},
	{"JVX", -4.207190833953703e+01, -1.587993113942270e+01},
	{"JVY", -3.389475077550760e+01, -7.702773575393272e+00},
	{"JVZ", -4.548178722209475e+01, -1.928981002198042e+01},
	{"JWA", -1.906602229044409e+01, -4.997890467587838e-01},
	{"JWB", -2.271725091818816e+01, -4.151017674502851e+00},
	{"JWC", -2.904085021927533e+01, -1.047461697559002e+01},
	{"JWD", -2.855434021939905e+01, -9.988106975713745e+00},
	{"JWE", -2.351315258840726e+01, -4.946919344721951e+00},
	{"JWF", -2.883359128830259e+01, -1.026735804461728e+01},
	{"JWG", -2.996267143552043e+01, -1.139643819183513e+01},
	{"JWH", -2.327515372237385e+01, -4.708920478688546e+00},
	{"JWI", -2.163400769170629e+01, -3.067774448020982e+00},
	{"JWJ", -3.131936589833785e+01, -1.275313265465254e+01},
	{"JWK", -3.147437836186386e+01, -1.290814511817855e+01},
	{"JWL", -2.790441062236534e+01, -9.338177378680031e+00},
	{"JWM", -2.860524285847282e+01, -1.003900961478752e+01},
	{"JWN", -2.547953281986959e+01, -6.913299576184281e+00},
	{"JWO", -2.425855088730143e+01, -5.692317643616126e+00},
	{"JWP", -2.969310652550273e+01, -1.112687328181743e+01},
	{"JWQ", -3.394672767221387e+01, -1.538049442852856e+01},
	{"JWR", -2.712768615460276e+01, -8.561452910917456e+00},
	{"JWS", -2.673970516864437e+01, -8.173471924959060e+00},
	{"JWT", -2.660922771053951e+01, -8.042994466854207e+00},
	{"JWU", -3.007633820726298e+01, -1.151010496357767e+01},
	{"JWV", -3.179690103485904e+01, -1.323066779117373e+01},
	{"JWW", -2.782892047394933e+01, -9.262687230264023e+00},
	{"JWX", -4.114053393833927e+01, -2.257430069465397e+01},
	{"JWY", -2.877942247600591e+01, -1.021318923232060e+01},
	{"JWZ", -3.466351758897843e+01, -1.609728434529313e+01},
	{"JXA", -3.234648806904420e+01, -3.475205461861043e+00},
	{"JXB", -3.691381267807865e+01, -8.042530070895491e+00},
	{"JXC", -3.187481233562880e+01, -3.003529728445642e+00},
	{"JXD", -3.630720083099860e+01, -7.435918223815437e+00},
	{"JXE", -3.195248160995902e+01, -3.081199002775858e+00},
	{"JXF", -3.644931029705410e+01, -7.578027689870940e+00},
	{"JXG", -3.774837483716986e+01, -8.877092229986699e+00},
	{"JXH", -3.410654866303317e+01, -5.235266055850012e+00},
	{"JXI", -3.194675974496792e+01, -3.075477137784759e+00},
	{"JXJ", -3.896134396319377e+01, -1.009006135601061e+01},
	{"JXK", -3.985943025364016e+01, -1.098814764645700e+01},
	{"JXL", -3.640666427046362e+01, -7.535381663280468e+00},
	{"JXM", -3.568984988845813e+01, -6.818567281274968e+00},
	{"JXN", -3.819886794501480e+01, -9.327585337831637e+00},
	{"JXO", -3.470422105153342e+01, -5.832938444350257e+00},
	{"JXP", -3.132260934221664e+01, -2.451326735033485e+00},
	{"JXQ", -3.786163961290691e+01, -8.990357005723759e+00},
	{"JXR", -3.647982701086018e+01, -7.608544403677021e+00},
	{"JXS", -3.577171246487126e+01, -6.900429857688104e+00},
	{"JXT", -3.112174419883550e+01, -2.250461591652341e+00},
	{"JXU", -3.498470979838007e+01, -6.113427191196913e+00},
	{"JXV", -3.460688305085817e+01, -5.735600443675006e+00},
	{"JXW", -3.579544216545830e+01, -6.924159558275142e+00},
	{"JXX", -3.539238540503762e+01, -6.521102797854468e+00},
	{"JXY", -3.557889809644347e+01, -6.707615489260307e+00},
	{"JXZ", -4.939865936580652e+01, -2.052737675862336e+01},
	{"JYA", -2.870915943450559e+01, -3.368006076477821e+00},
	{"JYB", -3.005787931032593e+01, -4.716725952298154e+00},
	{"JYC", -3.018669925609763e+01, -4.845545898069861e+00},
	{"JYD", -3.053409247588612e+01, -5.192939117858344e+00},
	{"JYE", -2.894720161280723e+01, -3.606048254779453e+00},
	{"JYF", -3.023441061546154e+01, -4.893257257433770e+00},
	{"JYG", -3.134713380954272e+01, -6.005980451514949e+00},
	{"JYH", -3.006999002376085e+01, -4.728836665733078e+00},
	{"JYI", -2.937026395253936e+01, -4.029110594511587e+00},
	{"JYJ", -3.341439485145566e+01, -8.073241493427892e+00},
	{"JYK", -3.321107807146063e+01, -7.869924713432860e+00},
	{"JYL", -3.079283270939234e+01, -5.451679351364568e+00},
	{"JYM", -3.015017566255870e+01, -4.809022304530933e+00},
	{"JYN", -3.129928539156677e+01, -5.958132033538996e+00},
	{"JYO", -2.806177165485672e+01, -2.720618296828949e+00},
	{"JYP", -3.027573755594463e+01, -4.934584197916856e+00},
	{"JYQ", -3.533082600954850e+01, -9.989672651520735e+00},
	{"JYR", -3.067536890907802e+01, -5.334215551050248e+00},
	{"JYS", -2.871386458860718e+01, -3.372711230579409e+00},
	{"JYT", -2.856221034281610e+01, -3.221056984788331e+00},
	{"JYU", -3.198271544129142e+01, -6.641562083263650e+00},
	{"JYV", -3.310619052106165e+01, -7.765037163033876e+00},
	{"JYW", -2.956498743542427e+01, -4.223834077396496e+00},
	{"JYX", -3.741375717502714e+01, -1.207260381699937e+01},
	{"JYY", -3.241833297046590e+01, -7.077179612438131e+00},
	{"JYZ", -3.674781932132406e+01, -1.140666596329629e+01},
	{"JZA", -2.674004524963917e+01, -3.293890798152969e+00},
	{"JZB", -3.209188849540213e+01, -8.645734043915926e+00},
	{"JZC", -3.297680331364371e+01, -9.530648862157500e+00},
	{"JZD", -3.333596915504654e+01, -9.889814703560335e+00},
	{"JZE", -2.566573062512925e+01, -2.219576173643044e+00},
	{"JZF", -3.292310072142114e+01, -9.476946269934928e+00},
	{"JZG", -3.344606989454835e+01, -9.999915443062147e+00},
	{"JZH", -3.206280702469824e+01, -8.616652573212031e+00},
	{"JZI", -2.425801502575347e+01, -8.118605742672692e-01},
	{"JZJ", -3.596979459670551e+01, -1.252364014521931e+01},
	{"JZK", -3.460529465709187e+01, -1.115914020560566e+01},
	{"JZL", -3.029552979373832e+01, -6.849375342252117e+00},
	{"JZM", -3.250378572342834e+01, -9.057631271942135e+00},
	{"JZN", -3.360661335204799e+01, -1.016045890056178e+01},
	{"JZO", -2.861811450459666e+01, -5.171960053110454e+00},
	{"JZP", -3.142217807227818e+01, -7.976023620791974e+00},
	{"JZQ", -3.988600848602886e+01, -1.643985403454266e+01},
	{"JZR", -3.063493472228055e+01, -7.188780270794346e+00},
	{"JZS", -3.225375746533645e+01, -8.807603013850244e+00},
	{"JZT", -3.075368974645979e+01, -7.307535294973584e+00},
	{"JZU", -3.015592813155586e+01, -6.709773680069662e+00},
	{"JZV", -3.305348929017315e+01, -9.607334838686951e+00},
	{"JZW", -3.171697646530902e+01, -8.270822013822819e+00},
	{"JZX", -4.269414504747370e+01, -1.924799059598750e+01},
	{"JZY", -3.112962429579937e+01, -7.683469844313167e+00},
	{"JZZ", -2.872450260095580e+01, -5.278348149469597e+00},
	{"KAA", -1.931926322729166e+01, -7.949477562825161e+00},
	{"KAB", -1.521217099043041e+01, -3.842385325963912e+00},
	{"KAC", -1.729144268003652e+01, -5.921657015570017e+00},
	{"KAD", -1.642273699436567e+01, -5.052951329899172e+00},
	{"KAE", -2.136384551058375e+01, -9.994059846117251e+00},
	{"KAF", -1.652554097052243e+01, -5.155755306055929e+00},
	{"KAG", -1.602789759064705e+01, -4.658111926180546e+00},
	{"KAH", -1.730596792278083e+01, -5.936182258314329e+00},
	{"KAI", -1.773878489752008e+01, -6.368999233053576e+00},
	{"KAJ", -2.886943084709295e+01, -1.749964518262644e+01},
	{"KAK", -1.968663320649419e+01, -8.316847542027691e+00},
	{"KAL", -1.570524623100675e+01, -4.335460566540251e+00},
	{"KAM", -1.665339056409966e+01, -5.283604899633159e+00},
	{"KAN", -1.249456084380808e+01, -1.124775179341585e+00},
	{"KAO", -1.990733711710686e+01, -8.537551452640360e+00},
	{"KAP", -1.753815082258607e+01, -6.168365158119566e+00},
	{"KAQ", -2.269689742026736e+01, -1.132711175580086e+01},
	{"KAR", -1.602060128317666e+01, -4.650815618710158e+00},
	{"KAS", -1.492624324194381e+01, -3.556457577477315e+00},
	{"KAT", -1.508701424782930e+01, -3.717228583362798e+00},
	{"KAU", -1.978170161435516e+01, -8.411915949888659e+00},
	{"KAV", -1.974950383057400e+01, -8.379718166107503e+00},
	{"KAW", -1.723779748452692e+01, -5.868011820060418e+00},
	{"KAX", -2.269466788970047e+01, -1.132488222523397e+01},
	{"KAY", -1.941907983769671e+01, -8.049294173230205e+00},
	{"KAZ", -2.211723448670075e+01, -1.074744882223425e+01},
	{"KBA", -1.700864438723628e+01, -3.326762259791681e+00},
	{"KBB", -2.760878785315187e+01, -1.392690572570727e+01},
	{"KBC", -2.831273207373430e+01, -1.463084994628970e+01},
	{"KBD", -2.961816841106103e+01, -1.593628628361643e+01},
	{"KBE", -1.574042201860013e+01, -2.058539891155530e+00},
	{"KBF", -3.120697332844352e+01, -1.752509120099892e+01},
	{"KBG", -3.280349642206955e+01, -1.912161429462494e+01},
	{"KBH", -3.004861487822336e+01, -1.636673275077876e+01},
	{"KBI", -1.870023656174500e+01, -5.018354434300398e+00},
	{"KBJ", -2.760397863724051e+01, -1.392209650979590e+01},
	{"KBK", -3.305931137273059e+01, -1.937742924528599e+01},
	{"KBL", -1.919457877902564e+01, -5.512696651581043e+00},
	{"KBM", -2.937785183397579e+01, -1.569596970653119e+01},
	{"KBN", -3.015689950813518e+01, -1.647501738069057e+01},
	{"KBO", -1.693731057464715e+01, -3.255428447202542e+00},
	{"KBP", -3.085889443783710e+01, -1.717701231039250e+01},
	{"KBQ", -3.692670244417767e+01, -2.324482031673307e+01},
	{"KBR", -1.789295645235146e+01, -4.211074324906857e+00},
	{"KBS", -2.618377900762039e+01, -1.250189688017579e+01},
	{"KBT", -2.356422076026373e+01, -9.882338632819122e+00},
	{"KBU", -1.554846961117819e+01, -1.866587483733593e+00},
	{"KBV", -3.084120907362843e+01, -1.715932694618382e+01},
	{"KBW", -3.024977211468480e+01, -1.656788998724019e+01},
	{"KBX", -4.021391028341827e+01, -2.653202815597366e+01},
	{"KBY", -1.621224840560853e+01, -2.530366278163929e+00},
	{"KBZ", -3.472201415918567e+01, -2.104013203174107e+01},
	{"KCA", -1.646369438282074e+01, -2.349938873052350e+00},
	{"KCB", -3.012526595754247e+01, -1.601151044777408e+01},
	{"KCC", -2.536161307449297e+01, -1.124785756472458e+01},
	{"KCD", -2.910500531031899e+01, -1.499124980055060e+01},
	{"KCE", -2.034247501191136e+01, -6.228719502142977e+00},
	{"KCF", -2.998987109417375e+01, -1.587611558440536e+01},
	{"KCG", -3.094542254560390e+01, -1.683166703583550e+01},
	{"KCH", -1.746572426978610e+01, -3.351968760017708e+00},
	{"KCI", -1.770124581078885e+01, -3.587490301020457e+00},
	{"KCJ", -3.290964221493034e+01, -1.879588670516195e+01},
	{"KCK", -2.462384087285195e+01, -1.051008536308357e+01},
	{"KCL", -1.714171198803065e+01, -3.027956478262259e+00},
	{"KCM", -2.989801217503028e+01, -1.578425666526189e+01},
	{"KCN", -3.076431721065535e+01, -1.665056170088695e+01},
	{"KCO", -1.533659091291697e+01, -1.222835403148577e+00},
	{"KCP", -2.918296076924855e+01, -1.506920525948016e+01},
	{"KCQ", -2.929395292771494e+01, -1.518019741794655e+01},
	{"KCR", -1.910250861871271e+01, -4.988753108944321e+00},
	{"KCS", -2.267650391329852e+01, -8.562748403530126e+00},
	{"KCT", -2.341249533022642e+01, -9.298739820458028e+00},
	{"KCU", -1.986311516105652e+01, -5.749359651288129e+00},
	{"KCV", -3.255908481705585e+01, -1.844532930728746e+01},
	{"KCW", -2.365878376916217e+01, -9.545028259393778e+00},
	{"KCX", -3.390244053372104e+01, -1.978868502395265e+01},
	{"KCY", -2.356540249766468e+01, -9.451646987896286e+00},
	{"KCZ", -3.251349037824647e+01, -1.839973486847808e+01},
	{"KDA", -1.777610641737751e+01, -3.029142695223618e+00},
	{"KDB", -2.188278668685889e+01, -7.135822964704994e+00},
	{"KDC", -2.567600930624861e+01, -1.092904558409472e+01},
	{"KDD", -2.546762278977625e+01, -1.072065906762236e+01},
	{"KDE", -1.697843803262209e+01, -2.231474310468204e+00},
	{"KDF", -2.518404368771358e+01, -1.043707996555969e+01},
	{"KDG", -2.591098025840217e+01, -1.116401653624828e+01},
	{"KDH", -2.152724515707716e+01, -6.780281434923262e+00},
	{"KDI", -1.736698731493933e+01, -2.620023592785437e+00},
	{"KDJ", -2.753887824898625e+01, -1.279191452683236e+01},
	{"KDK", -2.871572406936206e+01, -1.396876034720816e+01},
	{"KDL", -2.573954430066533e+01, -1.099258057851143e+01},
	{"KDM", -2.198050990112640e+01, -7.233546178972510e+00},
	{"KDN", -2.556247324352768e+01, -1.081550952137379e+01},
	{"KDO", -1.619423757994417e+01, -1.447273857790275e+00},
	{"KDP", -2.594958389482796e+01, -1.120262017267406e+01},
	{"KDQ", -3.015961559987558e+01, -1.541265187772169e+01},
	{"KDR", -1.929599719605367e+01, -4.549033473899780e+00},
	{"KDS", -2.216906455262858e+01, -7.422100830474689e+00},
	{"KDT", -2.004429139817021e+01, -5.297327676016319e+00},
	{"KDU", -1.986786124294350e+01, -5.120897520789606e+00},
	{"KDV", -2.724488539362255e+01, -1.249792167146866e+01},
	{"KDW", -2.237569020033655e+01, -7.628726478182663e+00},
	{"KDX", -3.505880590114978e+01, -2.031184217899589e+01},
	{"KDY", -2.598560850013959e+01, -1.123864477798570e+01},
	{"KDZ", -3.114124770146828e+01, -1.639428397931438e+01},
	{"KEA", -1.252260057946184e+01, -3.612494816695351e+00},
	{"KEB", -1.567180188950138e+01, -6.761696126734895e+00},
	{"KEC", -1.546542774922703e+01, -6.555321986460536e+00},
	{"KED", -1.144014339075029e+01, -2.530037627983799e+00},
	{"KEE", -1.290092790657064e+01, -3.990822143804147e+00},
	{"KEF", -1.539804068138476e+01, -6.487934918618268e+00},
	{"KEG", -1.688075627898452e+01, -7.970650516218031e+00},
	{"KEH", -1.414780868748659e+01, -5.237702924720095e+00},
	{"KEI", -1.404466978398179e+01, -5.134564021215304e+00},
	{"KEJ", -1.760910749319360e+01, -8.699001730427110e+00},
	{"KEK", -1.744945267836251e+01, -8.539346915596020e+00},
	{"KEL", -1.431741086183106e+01, -5.407305099064574e+00},
	{"KEM", -1.466333552902013e+01, -5.753229766253638e+00},
	{"KEN", -1.179330704217666e+01, -2.883201279410174e+00},
	{"KEO", -1.365018706203430e+01, -4.740081299267811e+00},
	{"KEP", -1.366649508451233e+01, -4.756389321745835e+00},
	{"KEQ", -2.038654422611144e+01, -1.147643846334495e+01},
	{"KER", -1.328766522321800e+01, -4.377559460451516e+00},
	{"KES", -1.288756814042632e+01, -3.977462377659830e+00},
	{"KET", -1.167299255011118e+01, -2.762886787344684e+00},
	{"KEU", -1.434320399725152e+01, -5.433098234485027e+00},
	{"KEV", -1.686719442095459e+01, -7.957088658188101e+00},
	{"KEW", -1.447124563256971e+01, -5.561139869803222e+00},
	{"KEX", -1.880133815796572e+01, -9.891232395199228e+00},
	{"KEY", -1.416514764021232e+01, -5.255041877445833e+00},
	{"KEZ", -2.090819115886934e+01, -1.199808539610285e+01},
	{"KFA", -1.645456248477065e+01, -2.876272019203916e+00},
	{"KFB", -2.726535781742011e+01, -1.368706735185337e+01},
	{"KFC", -2.667922996674488e+01, -1.310093950117814e+01},
	{"KFD", -2.756120285753434e+01, -1.398291239196761e+01},
	{"KFE", -1.942289153156409e+01, -5.844601065997346e+00},
	{"KFF", -2.499093249930864e+01, -1.141264203374190e+01},
	{"KFG", -2.721577237736773e+01, -1.363748191180099e+01},
	{"KFH", -2.601624993758321e+01, -1.243795947201647e+01},
	{"KFI", -1.692762934659034e+01, -3.349338881023598e+00},
	{"KFJ", -2.800406695130981e+01, -1.442577648574307e+01},
	{"KFK", -2.990024771625934e+01, -1.632195725069260e+01},
	{"KFL", -1.884864820426957e+01, -5.270357738702825e+00},
	{"KFM", -2.634743392833344e+01, -1.276914346276671e+01},
	{"KFN", -2.796898883590074e+01, -1.439069837033400e+01},
	{"KFO", -1.462784563046909e+01, -1.049555164902351e+00},
	{"KFP", -2.356609509419231e+01, -9.987804628625573e+00},
	{"KFQ", -3.214709328653192e+01, -1.856880282096518e+01},
	{"KFR", -1.597329995912380e+01, -2.395009493557063e+00},
	{"KFS", -2.620705359994674e+01, -1.262876313438000e+01},
	{"KFT", -2.318798884294782e+01, -9.609698377381083e+00},
	{"KFU", -1.803931863403522e+01, -4.461028168468479e+00},
	{"KFV", -2.918107557983636e+01, -1.560278511426962e+01},
	{"KFW", -2.693339050443503e+01, -1.335510003886829e+01},
	{"KFX", -3.445846479086542e+01, -2.088017432529868e+01},
	{"KFY", -2.757592284864139e+01, -1.399763238307465e+01},
	{"KFZ", -3.058705825039195e+01, -1.700876778482521e+01},
	{"KGA", -1.912969523060592e+01, -3.278803987722037e+00},
	{"KGB", -2.683081997846865e+01, -1.097992873558476e+01},
	{"KGC", -2.708184653847807e+01, -1.123095529559419e+01},
	{"KGD", -2.695295159193715e+01, -1.110206034905326e+01},
	{"KGE", -1.884095832483169e+01, -2.990067081947803e+00},
	{"KGF", -2.663653036717984e+01, -1.078563912429595e+01},
	{"KGG", -2.677802050721803e+01, -1.092712926433414e+01},
	{"KGH", -2.198197380474942e+01, -6.131082561865528e+00},
	{"KGI", -2.119474389951836e+01, -5.343852656634476e+00},
	{"KGJ", -3.030587111516154e+01, -1.445497987227766e+01},
	{"KGK", -3.054418504845879e+01, -1.469329380557490e+01},
	{"KGL", -1.977997000389844e+01, -3.929078761014556e+00},
	{"KGM", -2.658831538278200e+01, -1.073742413989812e+01},
	{"KGN", -2.570087814752647e+01, -9.849986904642583e+00},
	{"KGO", -1.783586805726893e+01, -1.984976814385044e+00},
	{"KGP", -2.707410753968380e+01, -1.122321629679991e+01},
	{"KGQ", -3.183726414307685e+01, -1.598637290019296e+01},
	{"KGR", -1.738444211351989e+01, -1.533550870636007e+00},
	{"KGS", -2.491408430963395e+01, -9.063193066750054e+00},
	{"KGT", -2.402679652511384e+01, -8.175905282229952e+00},
	{"KGU", -1.997575603184822e+01, -4.124864788964328e+00},
	{"KGV", -2.967770592499734e+01, -1.382681468211346e+01},
	{"KGW", -2.625884955296933e+01, -1.040795831008545e+01},
	{"KGX", -3.505608460952421e+01, -1.920519336664032e+01},
	{"KGY", -2.703001881700995e+01, -1.117912757412606e+01},
	{"KGZ", -3.364433812355644e+01, -1.779344688067255e+01},
	{"KHA", -1.561086611102052e+01, -2.362275491266644e+00},
	{"KHB", -2.814813373151733e+01, -1.489954311176345e+01},
	{"KHC", -2.812010984459017e+01, -1.487151922483630e+01},
	{"KHD", -2.859956287141652e+01, -1.535097225166265e+01},
	{"KHE", -1.502033042791211e+01, -1.771739808158226e+00},
	{"KHF", -2.813479495062613e+01, -1.488620433087225e+01},
	{"KHG", -2.368440060863379e+01, -1.043580998887991e+01},
	{"KHH", -2.705548504156197e+01, -1.380689442180810e+01},
	{"KHI", -1.486821864102466e+01, -1.619628021270778e+00},
	{"KHJ", -3.103683200609820e+01, -1.778824138634432e+01},
	{"KHK", -3.136043539481560e+01, -1.811184477506173e+01},
	{"KHL", -2.865920654276487e+01, -1.541061592301099e+01},
	{"KHM", -2.765908542742730e+01, -1.441049480767342e+01},
	{"KHN", -2.269345064101222e+01, -9.444860021258345e+00},
	{"KHO", -1.590518810965806e+01, -2.656597489904180e+00},
	{"KHP", -2.850397013014310e+01, -1.525537951038922e+01},
	{"KHQ", -3.279282989798718e+01, -1.954423927823330e+01},
	{"KHR", -2.645952144820211e+01, -1.321093082844823e+01},
	{"KHS", -2.710771892648190e+01, -1.385912830672802e+01},
	{"KHT", -2.237764609182527e+01, -9.129055472071393e+00},
	{"KHU", -1.871168945533772e+01, -5.463098835583843e+00},
	{"KHV", -3.127556659522740e+01, -1.802697597547352e+01},
	{"KHW", -2.724628715594164e+01, -1.399769653618777e+01},
	{"KHX", -3.678876692693034e+01, -2.354017630717646e+01},
	{"KHY", -2.262874741912292e+01, -9.380156799369036e+00},
	{"KHZ", -3.380064917280404e+01, -2.055205855305017e+01},
	{"KIA", -1.583182796730258e+01, -6.137656128955428e+00},
	{"KIB", -1.952949820763899e+01, -9.835326369291838e+00},
	{"KIC", -1.787463196357108e+01, -8.180460125223924e+00},
	{"KID", -1.642488006902657e+01, -6.730708230679414e+00},
	{"KIE", -1.796610037631795e+01, -8.271928537970798e+00},
	{"KIF", -1.672411017034794e+01, -7.029938332000786e+00},
	{"KIG", -2.096371967080691e+01, -1.126954783245976e+01},
	{"KIH", -1.890648834127611e+01, -9.212316502928957e+00},
	{"KII", -1.867226403824356e+01, -8.978092199896402e+00},
	{"KIJ", -2.212990022526315e+01, -1.243572838691600e+01},
	{"KIK", -2.037778562536497e+01, -1.068361378701782e+01},
	{"KIL", -1.381129233069815e+01, -4.117120492350994e+00},
	{"KIM", -1.693745557652989e+01, -7.243283738182737e+00},
	{"KIN", -1.003844912623052e+01, -3.442772878833659e-01},
	{"KIO", -2.047708168187281e+01, -1.078290984352566e+01},
	{"KIP", -1.793154274317432e+01, -8.237370904827165e+00},
	{"KIQ", -2.935228075144359e+01, -1.965810891309644e+01},
	{"KIR", -1.582361115018748e+01, -6.129439311840326e+00},
	{"KIS", -1.413369814487953e+01, -4.439526306532382e+00},
	{"KIT", -1.447304921973387e+01, -4.778877381386716e+00},
	{"KIU", -2.356933674008738e+01, -1.387516490174023e+01},
	{"KIV", -2.030909285017665e+01, -1.061492101182949e+01},
	{"KIW", -1.825499678119994e+01, -8.560824942852788e+00},
	{"KIX", -2.786420154878241e+01, -1.817002971043526e+01},
	{"KIY", -2.271747099429407e+01, -1.302329915594692e+01},
	{"KIZ", -2.704971183552158e+01, -1.735553999717443e+01},
	{"KJA", -1.983671952690449e+01, -2.407653802620159e+00},
	{"KJB", -2.977122923644423e+01, -1.234216351215991e+01},
	{"KJC", -3.062061888394077e+01, -1.319155315965644e+01},
	{"KJD", -3.251477646620421e+01, -1.508571074191988e+01},
	{"KJE", -1.945625200086046e+01, -2.027186276576126e+00},
	{"KJF", -3.163846236260850e+01, -1.420939663832417e+01},
	{"KJG", -3.122300325874777e+01, -1.379393753446344e+01},
	{"KJH", -3.040914626543987e+01, -1.298008054115554e+01},
	{"KJI", -2.207796150481317e+01, -4.648895780528845e+00},
	{"KJJ", -3.041493898173943e+01, -1.298587325745510e+01},
	{"KJK", -3.305905586670362e+01, -1.562999014241929e+01},
	{"KJL", -3.161234335884733e+01, -1.418327763456300e+01},
	{"KJM", -2.372799940373262e+01, -6.298933679448287e+00},
	{"KJN", -3.491833846122740e+01, -1.748927273694307e+01},
	{"KJO", -2.048402648711004e+01, -3.054960762825712e+00},
	{"KJP", -3.138012099539381e+01, -1.395105527110948e+01},
	{"KJQ", -3.436637273631969e+01, -1.693730701203536e+01},
	{"KJR", -3.059054747314014e+01, -1.316148174885580e+01},
	{"KJS", -3.102933628966874e+01, -1.360027056538442e+01},
	{"KJT", -3.112347361188779e+01, -1.369440788760346e+01},
	{"KJU", -1.877989007039816e+01, -1.350824346113833e+00},
	{"KJV", -3.798542595592055e+01, -2.055636023163622e+01},
	{"KJW", -3.035968199949152e+01, -1.293061627520719e+01},
	{"KJX", -4.066473136298937e+01, -2.323566563870504e+01},
	{"KJY", -3.713460211383399e+01, -1.970553638954966e+01},
	{"KJZ", -3.523960320729241e+01, -1.781053748300809e+01},
	{"KKA", -1.948954177444476e+01, -2.728745957708138e+00},
	{"KKB", -2.626116770152843e+01, -9.500371884791800e+00},
	{"KKC", -2.355282934456651e+01, -6.792033527829890e+00},
	{"KKD", -2.732624929623772e+01, -1.056545347950109e+01},
	{"KKE", -1.883346927976200e+01, -2.072673463025375e+00},
	{"KKF", -2.615757603965056e+01, -9.396780222913938e+00},
	{"KKG", -2.843017681696771e+01, -1.166938100023109e+01},
	{"KKH", -2.203366372947362e+01, -5.272867912736992e+00},
	{"KKI", -1.848863221528757e+01, -1.727836398550950e+00},
	{"KKJ", -3.000835129836815e+01, -1.324755548163153e+01},
	{"KKK", -2.139875694117482e+01, -4.637961124438192e+00},
	{"KKL", -2.571870995094787e+01, -8.957914134211245e+00},
	{"KKM", -2.669254562744164e+01, -9.931749810705012e+00},
	{"KKN", -2.024149566233449e+01, -3.480699845597867e+00},
	{"KKO", -2.185332580055690e+01, -5.092529983820275e+00},
	{"KKP", -2.704333853357095e+01, -1.028254271683432e+01},
	{"KKQ", -3.268749109294123e+01, -1.592669527620460e+01},
	{"KKR", -2.267401386601113e+01, -5.913218049274503e+00},
	{"KKS", -2.359786643728316e+01, -6.837070620546531e+00},
	{"KKT", -2.436271032847365e+01, -7.601914511737021e+00},
	{"KKU", -2.052828114863824e+01, -3.767485331901607e+00},
	{"KKV", -2.984850636421285e+01, -1.308771054747622e+01},
	{"KKW", -2.553432458720509e+01, -8.773528770468463e+00},
	{"KKX", -3.365953795883449e+01, -1.689874214209786e+01},
	{"KKY", -2.620454572389578e+01, -9.443749907159152e+00},
	{"KKZ", -3.176140084470422e+01, -1.500060502796760e+01},
	{"KLA", -1.668782372744282e+01, -3.548399350578772e+00},
	{"KLB", -2.693370137709514e+01, -1.379427700023110e+01},
	{"KLC", -2.754557878154893e+01, -1.440615440468488e+01},
	{"KLD", -2.484636372850284e+01, -1.170693935163880e+01},
	{"KLE", -1.469872647494737e+01, -1.559302098083324e+00},
	{"KLF", -2.668492470315888e+01, -1.354550032629483e+01},
	{"KLG", -2.366235959704359e+01, -1.052293522017955e+01},
	{"KLH", -2.780145433397013e+01, -1.466202995710609e+01},
	{"KLI", -1.502939627354482e+01, -1.889971896680770e+00},
	{"KLJ", -3.110161872481559e+01, -1.796219434795155e+01},
	{"KLK", -2.837391562812585e+01, -1.523449125126180e+01},
	{"KLL", -2.362599559593030e+01, -1.048657121906625e+01},
	{"KLM", -2.744867684079640e+01, -1.430925246393236e+01},
	{"KLN", -2.815809062260834e+01, -1.501866624574429e+01},
	{"KLO", -1.797291619426672e+01, -4.833491817402673e+00},
	{"KLP", -2.743427147378952e+01, -1.429484709692547e+01},
	{"KLQ", -3.219032297964543e+01, -1.905089860278139e+01},
	{"KLR", -2.796495756451531e+01, -1.482553318765126e+01},
	{"KLS", -2.573129450660720e+01, -1.259187012974316e+01},
	{"KLT", -2.521209727443417e+01, -1.207267289757013e+01},
	{"KLU", -1.961750895267910e+01, -6.478084575815058e+00},
	{"KLV", -2.773428352666305e+01, -1.459485914979900e+01},
	{"KLW", -2.743109987552259e+01, -1.429167549865855e+01},
	{"KLX", -3.549229116377293e+01, -2.235286678690888e+01},
	{"KLY", -1.510231097487894e+01, -1.962886598014900e+00},
	{"KLZ", -3.415378163688870e+01, -2.101435726002465e+01},
	{"KMA", -1.571222099520802e+01, -1.598427976399255e+00},
	{"KMB", -2.517894418144853e+01, -1.106515116263977e+01},
	{"KMC", -2.779596243952975e+01, -1.368216942072099e+01},
	{"KMD", -2.268172140908449e+01, -8.567928390275723e+00},
	{"KME", -1.581382204244387e+01, -1.700029023635101e+00},
	{"KMF", -2.730747529215589e+01, -1.319368227334712e+01},
	{"KMG", -2.896025060206603e+01, -1.484645758325727e+01},
	{"KMH", -2.692909637817030e+01, -1.281530335936154e+01},
	{"KMI", -1.788453674407628e+01, -3.770743725267507e+00},
	{"KMJ", -3.038851206846811e+01, -1.627471904965935e+01},
	{"KMK", -3.069695433257723e+01, -1.658316131376847e+01},
	{"KML", -2.821450097509416e+01, -1.410070795628539e+01},
	{"KMM", -2.523831182873448e+01, -1.112451880992572e+01},
	{"KMN", -2.717366618792933e+01, -1.305987316912056e+01},
	{"KMO", -1.767050877493709e+01, -3.556715756128324e+00},
	{"KMP", -2.437061039363712e+01, -1.025681737482835e+01},
	{"KMQ", -3.330527106299469e+01, -1.919147804418592e+01},
	{"KMR", -2.038719640872097e+01, -6.273403389912204e+00},
	{"KMS", -2.507620973377353e+01, -1.096241671496476e+01},
	{"KMT", -2.478541023705759e+01, -1.067161721824882e+01},
	{"KMU", -1.828179500618608e+01, -4.168001987377320e+00},
	{"KMV", -3.003955223379986e+01, -1.592575921499110e+01},
	{"KMW", -2.650118309675812e+01, -1.238739007794935e+01},
	{"KMX", -3.494496051994815e+01, -2.083116750113939e+01},
	{"KMY", -1.706901132992552e+01, -2.955218311116750e+00},
	{"KMZ", -3.357403463897503e+01, -1.946024162016627e+01},
	{"KNA", -1.783591561872541e+01, -6.948399751206659e+00},
	{"KNB", -2.346725080594159e+01, -1.257973493842285e+01},
	{"KNC", -2.418532672245951e+01, -1.329781085494076e+01},
	{"KND", -2.068495260765658e+01, -9.797436740137837e+00},
	{"KNE", -1.308621284671696e+01, -2.198696979198212e+00},
	{"KNF", -2.586650878636704e+01, -1.497899291884829e+01},
	{"KNG", -2.293445074807755e+01, -1.204693488055881e+01},
	{"KNH", -2.336808005807290e+01, -1.248056419055416e+01},
	{"KNI", -1.569187427824023e+01, -4.804358410721484e+00},
	{"KNJ", -2.365844239911101e+01, -1.277092653159227e+01},
	{"KNK", -2.693054840767331e+01, -1.604303254015456e+01},
	{"KNL", -2.633579302792350e+01, -1.544827716040476e+01},
	{"KNM", -2.349372658520553e+01, -1.260621071768678e+01},
	{"KNN", -2.623766256703322e+01, -1.535014669951447e+01},
	{"KNO", -1.133701265928353e+01, -4.494967917647900e-01},
	{"KNP", -2.677643111959932e+01, -1.588891525208058e+01},
	{"KNQ", -2.918411865927994e+01, -1.829660279176120e+01},
	{"KNR", -2.266124548002686e+01, -1.177372961250812e+01},
	{"KNS", -2.171487822993024e+01, -1.082736236241149e+01},
	{"KNT", -2.150246436813178e+01, -1.061494850061303e+01},
	{"KNU", -1.979577857394343e+01, -8.908262706424688e+00},
	{"KNV", -2.742863803536214e+01, -1.654112216784340e+01},
	{"KNW", -2.578052086356961e+01, -1.489300499605087e+01},
	{"KNX", -3.124069280146264e+01, -2.035317693394390e+01},
	{"KNY", -2.341373949523068e+01, -1.252622362771194e+01},
	{"KNZ", -3.174939784524223e+01, -2.086188197772349e+01},
	{"KOA", -1.959865844142798e+01, -7.859604447996754e+00},
	{"KOB", -2.009118510483512e+01, -8.352131111403894e+00},
	{"KOC", -2.065199126196514e+01, -8.912937268533916e+00},
	{"KOD", -2.099053627851061e+01, -9.251482285079387e+00},
	{"KOE", -2.037168069373009e+01, -8.632626700298864e+00},
	{"KOF", -1.275321126021955e+01, -1.014157266788330e+00},
	{"KOG", -2.601914813991008e+01, -1.428009414647886e+01},
	{"KOH", -1.773481306958334e+01, -5.995759076152116e+00},
	{"KOI", -2.021566169134532e+01, -8.476607697914103e+00},
	{"KOJ", -2.266063730124518e+01, -1.092158330781396e+01},
	{"KOK", -2.163716007451167e+01, -9.898106081080449e+00},
	{"KOL", -1.872509664992518e+01, -6.986042656493961e+00},
	{"KOM", -2.153304615762709e+01, -9.793992164195865e+00},
	{"KON", -1.391317668035917e+01, -2.174122686927949e+00},
	{"KOO", -2.016820533368739e+01, -8.429151340256171e+00},
	{"KOP", -2.018328811391451e+01, -8.444234120483292e+00},
	{"KOQ", -3.064592181846700e+01, -1.890686782503577e+01},
	{"KOR", -1.479309068448220e+01, -3.054036691050976e+00},
	{"KOS", -1.982641486923569e+01, -8.087360875804466e+00},
	{"KOT", -1.743817071061932e+01, -5.699116717188101e+00},
	{"KOU", -1.580705661134698e+01, -4.068002617915760e+00},
	{"KOV", -1.792528892113731e+01, -6.186234927706082e+00},
	{"KOW", -1.781034770776776e+01, -6.071293714336540e+00},
	{"KOX", -2.919765277805636e+01, -1.745859878462514e+01},
	{"KOY", -2.260586387489259e+01, -1.086680988146137e+01},
	{"KOZ", -2.025778747014866e+01, -8.518733476717438e+00},
	{"KPA", -1.694245933694207e+01, -2.477726672667125e+00},
	{"KPB", -2.843793522453568e+01, -1.397320256026074e+01},
	{"KPC", -2.933047071061387e+01, -1.486573804633892e+01},
	{"KPD", -2.987064965232652e+01, -1.540591698805158e+01},
	{"KPE", -1.798640551760813e+01, -3.521672853333185e+00},
	{"KPF", -2.841415889435963e+01, -1.394942623008469e+01},
	{"KPG", -2.922185372666564e+01, -1.475712106239070e+01},
	{"KPH", -1.935997352999304e+01, -4.895240865718093e+00},
	{"KPI", -1.974170264128885e+01, -5.276969977013903e+00},
	{"KPJ", -3.204611102693104e+01, -1.758137836265610e+01},
	{"KPK", -3.192903163494995e+01, -1.746429897067501e+01},
	{"KPL", -1.649789864090628e+01, -2.033165976631340e+00},
	{"KPM", -2.210321798809188e+01, -7.638485323816937e+00},
	{"KPN", -2.976539573563461e+01, -1.530066307135967e+01},
	{"KPO", -1.706366830713069e+01, -2.598935642855752e+00},
	{"KPP", -1.974773880996068e+01, -5.283006145685741e+00},
	{"KPQ", -3.330238169259219e+01, -1.883764902831725e+01},
	{"KPR", -1.681202312277612e+01, -2.347290458501176e+00},
	{"KPS", -2.336536536548585e+01, -8.900632701210910e+00},
	{"KPT", -2.427261573749467e+01, -9.807883073219729e+00},
	{"KPU", -1.935727111569645e+01, -4.892538451421503e+00},
	{"KPV", -3.146034932783583e+01, -1.699561666356088e+01},
	{"KPW", -2.766210668744113e+01, -1.319737402316619e+01},
	{"KPX", -3.680356039799999e+01, -2.233882773372505e+01},
	{"KPY", -2.701418705496033e+01, -1.254945439068539e+01},
	{"KPZ", -3.510867602345109e+01, -2.064394335917614e+01},
	{"KQA", -3.042090844467414e+01, -1.031270292581674e+01},
	{"KQB", -3.304833039181642e+01, -1.294012487295901e+01},
	{"KQC", -3.195932960971329e+01, -1.185112409085589e+01},
	{"KQD", -3.357003425190634e+01, -1.346182873304894e+01},
	{"KQE", -3.395792879605059e+01, -1.384972327719318e+01},
	{"KQF", -3.231683319530720e+01, -1.220862767644979e+01},
	{"KQG", -3.903365716968870e+01, -1.892545165083130e+01},
	{"KQH", -3.286839185216632e+01, -1.276018633330891e+01},
	{"KQI", -2.875995246005838e+01, -8.651746941200971e+00},
	{"KQJ", -3.483370362730812e+01, -1.472549810845071e+01},
	{"KQK", -4.066584236462744e+01, -2.055763684577003e+01},
	{"KQL", -3.331077942560932e+01, -1.320257390675192e+01},
	{"KQM", -3.248839258346864e+01, -1.238018706461123e+01},
	{"KQN", -3.531770996043738e+01, -1.520950444157998e+01},
	{"KQO", -3.351415579116281e+01, -1.340595027230541e+01},
	{"KQP", -3.351634117758868e+01, -1.340813565873127e+01},
	{"KQQ", -3.539774412632577e+01, -1.528953860746837e+01},
	{"KQR", -3.336304462904054e+01, -1.325483911018313e+01},
	{"KQS", -3.043535678432929e+01, -1.032715126547188e+01},
	{"KQT", -3.093502778826359e+01, -1.082682226940619e+01},
	{"KQU", -2.011744041164833e+01, -9.234892790924036e-03},
	{"KQV", -3.622889780667905e+01, -1.612069228782164e+01},
	{"KQW", -3.258715063082532e+01, -1.247894511196792e+01},
	{"KQX", -4.268897432251037e+01, -2.258076880365297e+01},
	{"KQY", -3.688169452395715e+01, -1.677348900509975e+01},
	{"KQZ", -4.382854175926090e+01, -2.372033624040350e+01},
	{"KRA", -1.743206729891757e+01, -2.531730339137841e+00},
	{"KRB", -2.689965017026799e+01, -1.199931321048825e+01},
	{"KRC", -2.589076360723587e+01, -1.099042664745614e+01},
	{"KRD", -2.493933512635518e+01, -1.003899816657545e+01},
	{"KRE", -1.625481280073316e+01, -1.354475840953428e+00},
	{"KRF", -2.672902009026311e+01, -1.182868313048337e+01},
	{"KRG", -2.635203749609390e+01, -1.145170053631417e+01},
	{"KRH", -2.352578118882034e+01, -8.625444229040600e+00},
	{"KRI", -1.822531957893528e+01, -3.324982619155548e+00},
	{"KRJ", -2.982200794279468e+01, -1.492167098301494e+01},
	{"KRK", -2.668943435435557e+01, -1.178909739457584e+01},
	{"KRL", -2.655624037372169e+01, -1.165590341394195e+01},
	{"KRM", -2.556462613372863e+01, -1.066428917394890e+01},
	{"KRN", -2.562003497368615e+01, -1.071969801390642e+01},
	{"KRO", -1.717706542114317e+01, -2.276728461363438e+00},
	{"KRP", -2.682250008318535e+01, -1.192216312340561e+01},
	{"KRQ", -3.120854407303545e+01, -1.630820711325571e+01},
	{"KRR", -2.346285098968582e+01, -8.562514029906081e+00},
	{"KRS", -2.432855565998918e+01, -9.428218700209454e+00},
	{"KRT", -2.403687316670819e+01, -9.136536206928463e+00},
	{"KRU", -1.838840322704742e+01, -3.488066267267686e+00},
	{"KRV", -2.713968741295253e+01, -1.223935045317280e+01},
	{"KRW", -2.649525722856576e+01, -1.159492026878602e+01},
	{"KRX", -3.185434309297829e+01, -1.695400613319856e+01},
	{"KRY", -2.009285424517619e+01, -5.192517285396455e+00},
	{"KRZ", -3.280479277964115e+01, -1.790445581986142e+01},
	{"KSA", -1.352654816069772e+01, -2.507904918705539e+00},
	{"KSB", -1.572161635083053e+01, -4.702973108838350e+00},
	{"KSC", -1.668791882986391e+01, -5.669275587871726e+00},
	{"KSD", -1.773455513732106e+01, -6.715911895328881e+00},
	{"KSE", -1.600303274801330e+01, -4.984389506021123e+00},
	{"KSF", -1.614502054306938e+01, -5.126377301077203e+00},
	{"KSG", -1.724001010443416e+01, -6.221366862441982e+00},
	{"KSH", -1.489533067200678e+01, -3.876687430014602e+00},
	{"KSI", -1.457648622343885e+01, -3.557842981446669e+00},
	{"KSJ", -2.054180209725160e+01, -9.523158855259428e+00},
	{"KSK", -1.989684947672557e+01, -8.878206234733391e+00},
	{"KSL", -1.698533613128317e+01, -5.966692889290993e+00},
	{"KSM", -1.669103966036420e+01, -5.672396418372018e+00},
	{"KSN", -1.708429479984682e+01, -6.065651557854641e+00},
	{"KSO", -1.351590108831213e+01, -2.497257846319945e+00},
	{"KSP", -1.601215662556539e+01, -4.993513383573212e+00},
	{"KSQ", -2.138347916657699e+01, -1.036483592458481e+01},
	{"KSR", -1.697325003928752e+01, -5.954606797295339e+00},
	{"KSS", -1.611978330513534e+01, -5.101140063143162e+00},
	{"KST", -1.405040506036872e+01, -3.031761818376541e+00},
	{"KSU", -1.582420819907841e+01, -4.805564957086229e+00},
	{"KSV", -1.962457377110135e+01, -8.605930529109170e+00},
	{"KSW", -1.524320843225332e+01, -4.224565190261145e+00},
	{"KSX", -2.212837927172263e+01, -1.110973602973045e+01},
	{"KSY", -1.818987804757016e+01, -7.171234805577980e+00},
	{"KSZ", -3.166969737227731e+01, -2.065105413028513e+01},
	{"KTA", -1.814705115917842e+01, -6.363520410007057e+00},
	{"KTB", -2.718593750950597e+01, -1.540240676033461e+01},
	{"KTC", -2.725821850849242e+01, -1.547468775932105e+01},
	{"KTD", -2.790783895113738e+01, -1.612430820196602e+01},
	{"KTE", -1.829907207316402e+01, -6.515541323992662e+00},
	{"KTF", -2.741625598154392e+01, -1.563272523237256e+01},
	{"KTG", -2.835789088466097e+01, -1.657436013548962e+01},
	{"KTH", -1.242345788323493e+01, -6.399271340635746e-01},
	{"KTI", -1.710600238339271e+01, -5.322471634221349e+00},
	{"KTJ", -3.051339817453593e+01, -1.872986742536457e+01},
	{"KTK", -3.034365694689549e+01, -1.856012619772413e+01},
	{"KTL", -2.676089474125892e+01, -1.497736399208756e+01},
	{"KTM", -2.726983520394114e+01, -1.548630445476977e+01},
	{"KTN", -2.794970807348620e+01, -1.616617732431484e+01},
	{"KTO", -1.371267048837052e+01, -1.929139739199161e+00},
	{"KTP", -2.802134503879613e+01, -1.623781428962477e+01},
	{"KTQ", -3.247996238172430e+01, -2.069643163255293e+01},
	{"KTR", -1.806524066881810e+01, -6.281709919646738e+00},
	{"KTS", -2.534524928820567e+01, -1.356171853903431e+01},
	{"KTT", -2.476240970955126e+01, -1.297887896037990e+01},
	{"KTU", -1.725598417157350e+01, -5.472453422402137e+00},
	{"KTV", -3.046970412824898e+01, -1.868617337907762e+01},
	{"KTW", -1.821987010655919e+01, -6.436339357387826e+00},
	{"KTX", -3.518576516848790e+01, -2.340223441931654e+01},
	{"KTY", -2.350238433037870e+01, -1.171885358120734e+01},
	{"KTZ", -3.265899862544877e+01, -2.087546787627741e+01},
	{"KUA", -2.468480180328644e+01, -1.105320545135993e+01},
	{"KUB", -2.020924337789580e+01, -6.577647025969280e+00},
	{"KUC", -2.425958826118821e+01, -1.062799190926169e+01},
	{"KUD", -2.499969957849397e+01, -1.136810322656745e+01},
	{"KUE", -2.470767875013184e+01, -1.107608239820532e+01},
	{"KUF", -2.665920925348345e+01, -1.302761290155693e+01},
	{"KUG", -2.421520133141617e+01, -1.058360497948965e+01},
	{"KUH", -2.732853365805957e+01, -1.369693730613305e+01},
	{"KUI", -2.474458943211831e+01, -1.111299308019180e+01},
	{"KUJ", -3.161711169930624e+01, -1.798551534737972e+01},
	{"KUK", -1.919184789692799e+01, -5.560251545001465e+00},
	{"KUL", -1.761987544551003e+01, -3.988279093583514e+00},
	{"KUM", -1.985345407420657e+01, -6.221857722280050e+00},
	{"KUN", -1.543213661742809e+01, -1.800540265501571e+00},
	{"KUO", -2.796241913408975e+01, -1.433082278216324e+01},
	{"KUP", -1.480043878797128e+01, -1.168842436044762e+00},
	{"KUQ", -3.307871565034161e+01, -1.944711929841510e+01},
	{"KUR", -1.752141211508629e+01, -3.889815763159770e+00},
	{"KUS", -1.731632271010445e+01, -3.684726358177927e+00},
	{"KUT", -2.082606377318236e+01, -7.194467421255841e+00},
	{"KUU", -3.041479675026098e+01, -1.678320039833446e+01},
	{"KUV", -2.976418133380276e+01, -1.613258498187624e+01},
	{"KUW", -2.169202523459791e+01, -8.060428882671397e+00},
	{"KUX", -3.003967219434793e+01, -1.640807584242141e+01},
	{"KUY", -2.918764418880918e+01, -1.555604783688266e+01},
	{"KUZ", -2.369574003802727e+01, -1.006414368610076e+01},
	{"KVA", -2.009212894246293e+01, -2.822908152333905e+00},
	{"KVB", -3.394908164577952e+01, -1.667986085565049e+01},
	{"KVC", -3.413843797311973e+01, -1.686921718299070e+01},
	{"KVD", -3.339351010686376e+01, -1.612428931673473e+01},
	{"KVE", -1.858421926741472e+01, -1.314998477285698e+00},
	{"KVF", -3.359785735215129e+01, -1.632863656202226e+01},
	{"KVG", -3.490624973947277e+01, -1.763702894934375e+01},
	{"KVH", -3.262109071490123e+01, -1.535186992477220e+01},
	{"KVI", -1.882872312811379e+01, -1.559502337984760e+00},
	{"KVJ", -3.482910744011339e+01, -1.755988664998437e+01},
	{"KVK", -3.670870806289171e+01, -1.943948727276269e+01},
	{"KVL", -3.398095113457721e+01, -1.671173034444819e+01},
	{"KVM", -3.299141391620537e+01, -1.572219312607635e+01},
	{"KVN", -2.372420363098355e+01, -6.454982840854531e+00},
	{"KVO", -2.051503888782434e+01, -3.245818097695311e+00},
	{"KVP", -3.306406092128718e+01, -1.579484013115816e+01},
	{"KVQ", -4.066090283622719e+01, -2.339168204609817e+01},
	{"KVR", -3.102009646837797e+01, -1.375087567824894e+01},
	{"KVS", -3.205787265791331e+01, -1.478865186778429e+01},
	{"KVT", -3.137378156111121e+01, -1.410456077098218e+01},
	{"KVU", -3.095974644442655e+01, -1.369052565429752e+01},
	{"KVV", -3.555448000183807e+01, -1.828525921170905e+01},
	{"KVW", -3.269723962968043e+01, -1.542801883955141e+01},
	{"KVX", -3.728672365332385e+01, -2.001750286319483e+01},
	{"KVY", -2.910956608929442e+01, -1.184034529916540e+01},
	{"KVZ", -4.069660253588157e+01, -2.342738174575255e+01},
	{"KWA", -1.511746059933153e+01, -2.162421586210263e+00},
	{"KWB", -2.896588158564828e+01, -1.601084257252701e+01},
	{"KWC", -2.902377320457556e+01, -1.606873419145430e+01},
	{"KWD", -2.853726320469929e+01, -1.558222419157802e+01},
	{"KWE", -1.608850712033963e+01, -3.133468107218366e+00},
	{"KWF", -2.881885099083501e+01, -1.586381197771374e+01},
	{"KWG", -2.994559442082067e+01, -1.699055540769940e+01},
	{"KWH", -1.491696381129942e+01, -1.961924798178152e+00},
	{"KWI", -1.453595829102298e+01, -1.580919277901711e+00},
	{"KWJ", -3.130228888363808e+01, -1.834724987051681e+01},
	{"KWK", -3.145730134716409e+01, -1.850226233404283e+01},
	{"KWL", -2.788733360766557e+01, -1.493229459454430e+01},
	{"KWM", -2.858816584377306e+01, -1.563312683065179e+01},
	{"KWN", -2.546245580516982e+01, -1.250741679204855e+01},
	{"KWO", -1.707961370036795e+01, -4.124574687246691e+00},
	{"KWP", -2.967602951080297e+01, -1.672099049768170e+01},
	{"KWQ", -3.392965065751410e+01, -2.097461164439283e+01},
	{"KWR", -1.912840195705570e+01, -6.173362943934441e+00},
	{"KWS", -2.672262815394460e+01, -1.376758914082334e+01},
	{"KWT", -2.659265041908685e+01, -1.363761140596558e+01},
	{"KWU", -3.005926119256322e+01, -1.710422217944195e+01},
	{"KWV", -3.177982402015927e+01, -1.882478500703801e+01},
	{"KWW", -2.781184345924956e+01, -1.485680444612830e+01},
	{"KWX", -4.112345692363951e+01, -2.816841791051824e+01},
	{"KWY", -2.876009842647677e+01, -1.580505941335550e+01},
	{"KWZ", -3.464644057427866e+01, -2.169140156115740e+01},
	{"KXA", -2.504080118866620e+01, -3.960548803915540e+00},
	{"KXB", -2.960827748283859e+01, -8.528025098087925e+00},
	{"KXC", -2.456927714038874e+01, -3.489024755638076e+00},
	{"KXD", -2.900166563575853e+01, -7.921413251007872e+00},
	{"KXE", -2.464683097886387e+01, -3.566578594113206e+00},
	{"KXF", -2.914377510181404e+01, -8.063522717063373e+00},
	{"KXG", -3.044283964192980e+01, -9.362587257179133e+00},
	{"KXH", -2.680101346779311e+01, -5.720761083042445e+00},
	{"KXI", -2.251289504887012e+01, -1.432642664119457e+00},
	{"KXJ", -3.165580876795371e+01, -1.057555638320305e+01},
	{"KXK", -3.255389505840009e+01, -1.147364267364943e+01},
	{"KXL", -2.910112907522356e+01, -8.020876690472901e+00},
	{"KXM", -2.838277587818427e+01, -7.302523493433610e+00},
	{"KXN", -3.089333274977474e+01, -9.813080365024071e+00},
	{"KXO", -2.739868585629335e+01, -6.318433471542691e+00},
	{"KXP", -2.401707414697658e+01, -2.936821762225918e+00},
	{"KXQ", -3.055610441766686e+01, -9.475852032916192e+00},
	{"KXR", -2.917429181562012e+01, -8.094039430869454e+00},
	{"KXS", -2.846617726963120e+01, -7.385924884880538e+00},
	{"KXT", -2.381614409959724e+01, -2.735891714846576e+00},
	{"KXU", -2.767917460314001e+01, -6.598922218389347e+00},
	{"KXV", -2.730134785561810e+01, -6.221095470867439e+00},
	{"KXW", -2.848990697021824e+01, -7.409654585467575e+00},
	{"KXX", -2.808685020979757e+01, -7.006597825046900e+00},
	{"KXY", -2.827336290120340e+01, -7.193110516452740e+00},
	{"KXZ", -4.209312417056645e+01, -2.101287178581579e+01},
	{"KYA", -1.680855127270765e+01, -3.183291122895693e+00},
	{"KYB", -1.891648706216830e+01, -5.291226912356346e+00},
	{"KYC", -1.956271809200584e+01, -5.937457942193885e+00},
	{"KYD", -2.005757312971143e+01, -6.432312979899468e+00},
	{"KYE", -1.682487247692697e+01, -3.199612327115013e+00},
	{"KYF", -2.015769339333880e+01, -6.532433243526850e+00},
	{"KYG", -2.083699248430961e+01, -7.211732334497651e+00},
	{"KYH", -1.799400321286219e+01, -4.368743063050234e+00},
	{"KYI", -1.845367537810266e+01, -4.828415228290702e+00},
	{"KYJ", -2.168753599181765e+01, -8.062275842005691e+00},
	{"KYK", -2.357837885742179e+01, -9.953118707609843e+00},
	{"KYL", -1.865116514315008e+01, -5.025904993338124e+00},
	{"KYM", -1.948237386624146e+01, -5.857113716429507e+00},
	{"KYN", -2.083453066126898e+01, -7.209270511457027e+00},
	{"KYO", -1.522491862860486e+01, -1.599658478792904e+00},
	{"KYP", -1.973887375650291e+01, -6.113613606690953e+00},
	{"KYQ", -2.912122989506177e+01, -1.549596974524982e+01},
	{"KYR", -1.950250037395846e+01, -5.877240224146502e+00},
	{"KYS", -1.803797496397055e+01, -4.412714814158597e+00},
	{"KYT", -1.742336259035616e+01, -3.798102440544201e+00},
	{"KYU", -2.067662034115638e+01, -7.051360191344424e+00},
	{"KYV", -2.208224966879256e+01, -8.456989518980606e+00},
	{"KYW", -1.741037240768226e+01, -3.785112257870302e+00},
	{"KYX", -3.120704735178427e+01, -1.758178720197231e+01},
	{"KYY", -2.165660414544014e+01, -8.031343995628186e+00},
	{"KYZ", -3.054110949808118e+01, -1.691584934826923e+01},
	{"KZA", -2.447600606877337e+01, -5.293890798152970e+00},
	{"KZB", -2.982784931453633e+01, -1.064573404391593e+01},
	{"KZC", -3.071276413277790e+01, -1.153064886215750e+01},
	{"KZD", -3.107192997418074e+01, -1.188981470356033e+01},
	{"KZE", -2.090150060958914e+01, -1.719385338968735e+00},
	{"KZF", -3.065906154055533e+01, -1.147694626993493e+01},
	{"KZG", -3.118203071368255e+01, -1.199991544306215e+01},
	{"KZH", -2.979876784383243e+01, -1.061665257321203e+01},
	{"KZI", -2.108500211312266e+01, -1.902886842502260e+00},
	{"KZJ", -3.370575541583971e+01, -1.452364014521931e+01},
	{"KZK", -3.234125547622607e+01, -1.315914020560566e+01},
	{"KZL", -2.803149061287252e+01, -8.849375342252117e+00},
	{"KZM", -3.023974654256254e+01, -1.105763127194213e+01},
	{"KZN", -3.134257417118218e+01, -1.216045890056178e+01},
	{"KZO", -2.057071009386892e+01, -1.388594823248513e+00},
	{"KZP", -2.915813889141238e+01, -9.976023620791974e+00},
	{"KZQ", -3.762196930516306e+01, -1.843985403454266e+01},
	{"KZR", -2.837089554141475e+01, -9.188780270794346e+00},
	{"KZS", -2.998971828447065e+01, -1.080760301385024e+01},
	{"KZT", -2.848965056559399e+01, -9.307535294973585e+00},
	{"KZU", -2.789188895069006e+01, -8.709773680069663e+00},
	{"KZV", -3.078945010930736e+01, -1.160733483868695e+01},
	{"KZW", -2.945293728444322e+01, -1.027082201382282e+01},
	{"KZX", -4.043010586660790e+01, -2.124799059598750e+01},
	{"KZY", -2.886558511493357e+01, -9.683469844313167e+00},
	{"KZZ", -2.646046342009000e+01, -7.278348149469598e+00},
	{"LAA", -1.593677065526413e+01, -8.093462439965858e+00},
	{"LAB", -1.263157352679801e+01, -4.788265311499738e+00},
	{"LAC", -1.128076902287410e+01, -3.437460807575833e+00},
	{"LAD", -1.298821660568670e+01, -5.144908390388431e+00},
	{"LAE", -1.655776488811085e+01, -8.714456672812586e+00},
	{"LAF", -1.472920339772050e+01, -6.885895182422233e+00},
	{"LAG", -1.333769574411677e+01, -5.494387528818498e+00},
	{"LAH", -1.528338968200917e+01, -7.440081466710906e+00},
	{"LAI", -1.200064306421133e+01, -4.157334848913062e+00},
	{"LAJ", -2.090564941282319e+01, -1.306234119752492e+01},
	{"LAK", -1.544566239794128e+01, -7.602354182643017e+00},
	{"LAL", -1.420237431041537e+01, -6.359066095117106e+00},
	{"LAM", -1.282252909594036e+01, -4.979220880642090e+00},
	{"LAN", -9.899121510961688e+00, -2.055813295663421e+00},
	{"LAO", -1.739619597397610e+01, -9.552887758677835e+00},
	{"LAP", -1.446017384253276e+01, -6.616865627234488e+00},
	{"LAQ", -2.025540757133118e+01, -1.241209935603291e+01},
	{"LAR", -1.108747193805090e+01, -3.244163722752635e+00},
	{"LAS", -1.144024534544643e+01, -3.596937130148160e+00},
	{"LAT", -1.078057607848240e+01, -2.937267863184133e+00},
	{"LAU", -1.379351460846299e+01, -5.950206393164721e+00},
	{"LAV", -1.378855897695020e+01, -5.945250761651929e+00},
	{"LAW", -1.219410110834125e+01, -4.350792893042982e+00},
	{"LAX", -1.684801794038731e+01, -9.004709725089040e+00},
	{"LAY", -1.254406101860469e+01, -4.700752803306423e+00},
	{"LAZ", -1.630065324025436e+01, -8.457345024956085e+00},
	{"LBA", -1.481698476059575e+01, -4.130992572574515e+00},
	{"LBB", -2.207665273333360e+01, -1.139066054531237e+01},
	{"LBC", -1.925458249885041e+01, -8.568590310829176e+00},
	{"LBD", -2.367595026079960e+01, -1.298995807277837e+01},
	{"LBE", -1.130158869723533e+01, -6.155965092141011e-01},
	{"LBF", -2.212909838534719e+01, -1.144310619732596e+01},
	{"LBG", -3.195496929975730e+01, -2.126897711173607e+01},
	{"LBH", -2.212318785482702e+01, -1.143719566680579e+01},
	{"LBI", -1.734783930982363e+01, -6.661847121802403e+00},
	{"LBJ", -2.675545151492825e+01, -1.606945932690703e+01},
	{"LBK", -3.221078425041835e+01, -2.152479206239711e+01},
	{"LBL", -1.633660383734171e+01, -5.650611649320482e+00},
	{"LBM", -2.269338409127138e+01, -1.200739190325015e+01},
	{"LBN", -2.930837238582293e+01, -1.862238019780170e+01},
	{"LBO", -1.472481665622449e+01, -4.038824468203256e+00},
	{"LBP", -3.001464716979119e+01, -1.932865498176996e+01},
	{"LBQ", -3.607817532186542e+01, -2.539218313384419e+01},
	{"LBR", -1.468452743548919e+01, -3.998535247467957e+00},
	{"LBS", -2.105755828742014e+01, -1.037156609939891e+01},
	{"LBT", -2.257850595404998e+01, -1.189251376602875e+01},
	{"LBU", -1.404970940815717e+01, -3.363717220135940e+00},
	{"LBV", -2.999268195131618e+01, -1.930668976329495e+01},
	{"LBW", -2.270488590152151e+01, -1.201889371350028e+01},
	{"LBX", -3.936538316110602e+01, -2.867939097308479e+01},
	{"LBY", -1.554067933531376e+01, -4.854687147292526e+00},
	{"LBZ", -3.387348703687342e+01, -2.318749484885219e+01},
	{"LCA", -1.386603101388959e+01, -2.568161421414577e+00},
	{"LCB", -2.171252532782625e+01, -1.041465573535123e+01},
	{"LCC", -2.063473849544449e+01, -9.336868902969469e+00},
	{"LCD", -2.071241852814537e+01, -9.414548935670355e+00},
	{"LCE", -1.674640750647531e+01, -5.448537914000289e+00},
	{"LCF", -2.171187505472454e+01, -1.041400546224952e+01},
	{"LCG", -3.036010746530692e+01, -1.906223787283191e+01},
	{"LCH", -1.444872260755064e+01, -3.150853015075624e+00},
	{"LCI", -1.613238405964098e+01, -4.834514467165964e+00},
	{"LCJ", -3.229800606773760e+01, -2.100013647526259e+01},
	{"LCK", -2.223277812056046e+01, -1.093490852808544e+01},
	{"LCL", -1.604109705877513e+01, -4.743227466300110e+00},
	{"LCM", -2.054563455536766e+01, -9.247764962892644e+00},
	{"LCN", -2.071682708265956e+01, -9.418957490184544e+00},
	{"LCO", -1.231739919803079e+01, -1.019529605555770e+00},
	{"LCP", -2.039205221022134e+01, -9.094182617746325e+00},
	{"LCQ", -2.870863784741796e+01, -1.741076825494295e+01},
	{"LCR", -1.586837440484057e+01, -4.570504812365555e+00},
	{"LCS", -1.880766246837930e+01, -7.509792875904276e+00},
	{"LCT", -2.003458655322360e+01, -8.736716960748584e+00},
	{"LCU", -1.516920582315673e+01, -3.871336230681708e+00},
	{"LCV", -3.197376973675888e+01, -2.067590014428387e+01},
	{"LCW", -2.070735743533898e+01, -9.409487842863962e+00},
	{"LCX", -3.331712545342407e+01, -2.201925586094905e+01},
	{"LCY", -2.205496504595199e+01, -1.075709545347697e+01},
	{"LCZ", -3.192817529794950e+01, -2.063030570547448e+01},
	{"LDA", -1.229528749715528e+01, -3.696632957726343e+00},
	{"LDB", -1.195973148784757e+01, -3.361076948418634e+00},
	{"LDC", -1.417872575163579e+01, -5.580071212206856e+00},
	{"LDD", -1.439789237795383e+01, -5.799237838524900e+00},
	{"LDE", -1.184132716906341e+01, -3.242672629634477e+00},
	{"LDF", -1.421961822095983e+01, -5.620963681530893e+00},
	{"LDG", -1.462762372492072e+01, -6.028969185491788e+00},
	{"LDH", -1.271314962700795e+01, -4.114495087579014e+00},
	{"LDI", -1.183232265725441e+01, -3.233668117825474e+00},
	{"LDJ", -1.681034061024376e+01, -8.211686070814823e+00},
	{"LDK", -1.684772927211887e+01, -8.249074732689939e+00},
	{"LDL", -1.455024554695738e+01, -5.951591007528451e+00},
	{"LDM", -1.377538313190339e+01, -5.176728592474451e+00},
	{"LDN", -1.237422844511208e+01, -3.775573905683148e+00},
	{"LDO", -1.287487090088741e+01, -4.276216361458473e+00},
	{"LDP", -1.451816892335101e+01, -5.919514383922074e+00},
	{"LDQ", -1.962953183056536e+01, -1.103087729113642e+01},
	{"LDR", -1.199054020359923e+01, -3.391885664170300e+00},
	{"LDS", -1.260981552736751e+01, -4.011160987938582e+00},
	{"LDT", -1.233819916605107e+01, -3.739544626622137e+00},
	{"LDU", -1.498819872338751e+01, -6.389544183958578e+00},
	{"LDV", -1.783223142839704e+01, -9.233576888968113e+00},
	{"LDW", -1.345907255620563e+01, -4.860418016776698e+00},
	{"LDX", -3.407382179996304e+01, -2.547516726053410e+01},
	{"LDY", -1.539514472084984e+01, -6.796490181420908e+00},
	{"LDZ", -2.171489582641530e+01, -1.311624128698637e+01},
	{"LEA", -1.011421721022502e+01, -2.847560325044483e+00},
	{"LEB", -1.272269853715871e+01, -5.456041651978175e+00},
	{"LEC", -1.133342955058647e+01, -4.066772665405939e+00},
	{"LED", -1.040898827851964e+01, -3.142331393339106e+00},
	{"LEE", -1.275665157789207e+01, -5.489994692711536e+00},
	{"LEF", -1.204604567117794e+01, -4.779388785997407e+00},
	{"LEG", -1.241934993180080e+01, -5.152693046620264e+00},
	{"LEH", -1.341212130274736e+01, -6.145464417566831e+00},
	{"LEI", -1.244098086067014e+01, -5.174323975489612e+00},
	{"LEJ", -1.729168959430545e+01, -1.002503270912491e+01},
	{"LEK", -1.636890958708458e+01, -9.102252701904050e+00},
	{"LEL", -1.403899418158549e+01, -6.772337296404960e+00},
	{"LEM", -1.176968163103541e+01, -4.503024745854879e+00},
	{"LEN", -1.147457694071194e+01, -4.207920055531404e+00},
	{"LEO", -1.186478262739817e+01, -4.598125742217639e+00},
	{"LEP", -1.339944188668553e+01, -6.132785001504994e+00},
	{"LEQ", -1.697636259882727e+01, -9.709705713646731e+00},
	{"LER", -1.226833394375485e+01, -5.001677058574313e+00},
	{"LES", -1.004043427484546e+01, -2.773777389664931e+00},
	{"LET", -1.035208726782281e+01, -3.085430382642279e+00},
	{"LEU", -1.476111652026368e+01, -7.494459635083143e+00},
	{"LEV", -1.295434682988301e+01, -5.687689944702473e+00},
	{"LEW", -1.241683948747800e+01, -5.150182602297464e+00},
	{"LEX", -1.393706865482548e+01, -6.670411769644944e+00},
	{"LEY", -1.370554217803664e+01, -6.438885292856104e+00},
	{"LEZ", -1.963003642096768e+01, -1.236337953578715e+01},
	{"LFA", -1.298044092648101e+01, -2.543225412396044e+00},
	{"LFB", -1.551297681810188e+01, -5.075761304016919e+00},
	{"LFC", -1.618434574567897e+01, -5.747130231594006e+00},
	{"LFD", -1.650727942235076e+01, -6.070063908265791e+00},
	{"LFE", -1.506414312105279e+01, -4.626927606967823e+00},
	{"LFF", -1.557779997158333e+01, -5.140584457498365e+00},
	{"LFG", -1.739194276686330e+01, -6.954727252778333e+00},
	{"LFH", -1.581415567006227e+01, -5.376940155977302e+00},
	{"LFI", -1.333253809406124e+01, -2.895322579976277e+00},
	{"LFJ", -2.000072939111154e+01, -9.563513877026573e+00},
	{"LFK", -1.925659965162501e+01, -8.819384137540050e+00},
	{"LFL", -1.537550152134633e+01, -4.938286007261362e+00},
	{"LFM", -1.664733485457778e+01, -6.210119340492818e+00},
	{"LFN", -1.764923312569274e+01, -7.212017611607772e+00},
	{"LFO", -1.295855382478898e+01, -2.521338310704016e+00},
	{"LFP", -1.646761407821554e+01, -6.030398564130574e+00},
	{"LFQ", -2.370575689339051e+01, -1.326854137930554e+01},
	{"LFR", -1.441959997913268e+01, -3.982384465047716e+00},
	{"LFS", -1.526124053445401e+01, -4.824025020369048e+00},
	{"LFT", -1.375810684926440e+01, -3.320891335179430e+00},
	{"LFU", -1.516496989444063e+01, -4.727754380355666e+00},
	{"LFV", -1.971247287695394e+01, -9.275257362868974e+00},
	{"LFW", -1.498639408154640e+01, -4.549178567461437e+00},
	{"LFX", -2.271750369820570e+01, -1.228028818412073e+01},
	{"LFY", -1.880162741490770e+01, -8.364411900822738e+00},
	{"LFZ", -2.894293763842850e+01, -1.850572212434354e+01},
	{"LGA", -1.468711469318266e+01, -2.565232774729214e+00},
	{"LGB", -2.645005573999064e+01, -1.432817382153720e+01},
	{"LGC", -2.354701555412579e+01, -1.142513363567234e+01},
	{"LGD", -2.657218735345915e+01, -1.445030543500570e+01},
	{"LGE", -1.519196551012531e+01, -3.070083591671861e+00},
	{"LGF", -2.625576612870183e+01, -1.413388421024838e+01},
	{"LGG", -2.639725626874003e+01, -1.427537435028658e+01},
	{"LGH", -2.291968153185533e+01, -1.079779961340189e+01},
	{"LGI", -1.399280173254464e+01, -1.870919814091190e+00},
	{"LGJ", -2.992510687668354e+01, -1.780322495823009e+01},
	{"LGK", -3.016342080998078e+01, -1.804153889152733e+01},
	{"LGL", -1.762159328556427e+01, -5.499711367110820e+00},
	{"LGM", -2.620755114430400e+01, -1.408566922585055e+01},
	{"LGN", -2.160476661708875e+01, -9.482884698635299e+00},
	{"LGO", -1.414640532873790e+01, -2.024523410284452e+00},
	{"LGP", -2.669334330120579e+01, -1.457146138275234e+01},
	{"LGQ", -3.145649990459884e+01, -1.933461798614540e+01},
	{"LGR", -1.489220506391536e+01, -2.770323145461915e+00},
	{"LGS", -2.453320015161400e+01, -1.241131823316055e+01},
	{"LGT", -2.268202327281054e+01, -1.056014135435710e+01},
	{"LGU", -1.775238463556855e+01, -5.630502717115104e+00},
	{"LGV", -2.929694168651934e+01, -1.717505976806589e+01},
	{"LGW", -2.342746347686970e+01, -1.130558155841625e+01},
	{"LGX", -3.467532037104620e+01, -2.255343845259276e+01},
	{"LGY", -2.664993052585877e+01, -1.452804860740533e+01},
	{"LGZ", -3.326357388507843e+01, -2.114169196662499e+01},
	{"LHA", -1.347317042204435e+01, -1.919425277148135e+00},
	{"LHB", -2.802302248401199e+01, -1.646927733911577e+01},
	{"LHC", -2.799367765435165e+01, -1.643993250945543e+01},
	{"LHD", -2.847261027796576e+01, -1.691886513306954e+01},
	{"LHE", -1.315665022815657e+01, -1.602905083260353e+00},
	{"LHF", -2.800968370312078e+01, -1.645593855822456e+01},
	{"LHG", -2.899329072946290e+01, -1.743954558456668e+01},
	{"LHH", -2.692974210443041e+01, -1.537599695953419e+01},
	{"LHI", -1.349878660616665e+01, -1.945041461270434e+00},
	{"LHJ", -3.091172075859285e+01, -1.935797561369663e+01},
	{"LHK", -3.123532414731025e+01, -1.968157900241404e+01},
	{"LHL", -2.853409529525952e+01, -1.698035015036330e+01},
	{"LHM", -2.753502190393599e+01, -1.598127675903978e+01},
	{"LHN", -2.844602383077155e+01, -1.689227868587533e+01},
	{"LHO", -1.463659467983197e+01, -3.082849534935746e+00},
	{"LHP", -2.837885888263775e+01, -1.682511373774153e+01},
	{"LHQ", -3.266771865048182e+01, -2.111397350558561e+01},
	{"LHR", -2.633399224235387e+01, -1.478024709745765e+01},
	{"LHS", -2.698266723683489e+01, -1.542892209193867e+01},
	{"LHT", -2.305785951012595e+01, -1.150411436522974e+01},
	{"LHU", -1.688375536528563e+01, -5.330010220389405e+00},
	{"LHV", -3.115045534772205e+01, -1.959671020282584e+01},
	{"LHW", -2.712117590843630e+01, -1.556743076354008e+01},
	{"LHX", -3.666365567942499e+01, -2.510991053452877e+01},
	{"LHY", -1.979839584605688e+01, -8.244650701160666e+00},
	{"LHZ", -3.367553792529869e+01, -2.212179278040248e+01},
	{"LIA", -1.194041483322429e+01, -4.170346427484366e+00},
	{"LIB", -1.341016312606464e+01, -5.640094720324726e+00},
	{"LIC", -1.124926976486131e+01, -3.479201359121387e+00},
	{"LID", -1.419525908113068e+01, -6.425190675390760e+00},
	{"LIE", -1.144967663914631e+01, -3.679608233406391e+00},
	{"LIF", -1.201162927144478e+01, -4.241560865704854e+00},
	{"LIG", -1.155269626552284e+01, -3.782627859782916e+00},
	{"LIH", -1.638696646873732e+01, -8.616898062997405e+00},
	{"LII", -1.739595734063242e+01, -9.625888934892499e+00},
	{"LIJ", -1.788569134814444e+01, -1.011562294240452e+01},
	{"LIK", -1.177074609863547e+01, -4.000677692895549e+00},
	{"LIL", -1.543127233139278e+01, -7.661203925652861e+00},
	{"LIM", -1.302437810058476e+01, -5.254309694844835e+00},
	{"LIN", -1.028879680128139e+01, -2.518728395541471e+00},
	{"LIO", -1.347493627855789e+01, -5.704867872817972e+00},
	{"LIP", -1.385889297150022e+01, -6.088824565760302e+00},
	{"LIQ", -1.599073137725193e+01, -8.220662971512015e+00},
	{"LIR", -1.653757113877244e+01, -8.767502733032520e+00},
	{"LIS", -1.126726087260092e+01, -3.497192466860998e+00},
	{"LIT", -1.065451305097244e+01, -2.884444645232519e+00},
	{"LIU", -1.422871559190243e+01, -6.458647186162512e+00},
	{"LIV", -1.199271924694094e+01, -4.222650841201022e+00},
	{"LIW", -1.644135959209199e+01, -8.671291186352070e+00},
	{"LIX", -1.710319000143469e+01, -9.333121595694768e+00},
	{"LIY", -2.091106430242323e+01, -1.314099589668331e+01},
	{"LIZ", -1.391127231899414e+01, -6.141203913254217e+00},
	{"LJA", -1.771228474819384e+01, -2.858375212452165e+00},
	{"LJB", -2.212475102709292e+01, -7.270841491351237e+00},
	{"LJC", -2.995688399035098e+01, -1.510297445460931e+01},
	{"LJD", -3.183206383714741e+01, -1.697815430140572e+01},
	{"LJE", -1.837274204347073e+01, -3.518832507729055e+00},
	{"LJF", -3.097472746901871e+01, -1.612081793327703e+01},
	{"LJG", -3.055926836515799e+01, -1.570535882941631e+01},
	{"LJH", -2.974541137185009e+01, -1.489150183610841e+01},
	{"LJI", -2.051421915422837e+01, -5.660309618486693e+00},
	{"LJJ", -2.974675449828073e+01, -1.489284496253905e+01},
	{"LJK", -3.243977559602093e+01, -1.758586606027925e+01},
	{"LJL", -3.094860846525754e+01, -1.609469892951586e+01},
	{"LJM", -3.130453383898499e+01, -1.645062430324332e+01},
	{"LJN", -3.425460356763762e+01, -1.940069403189593e+01},
	{"LJO", -1.717635743845381e+01, -2.322447902712130e+00},
	{"LJP", -3.071638610180403e+01, -1.586247656606235e+01},
	{"LJQ", -3.370263784272991e+01, -1.884872830698823e+01},
	{"LJR", -2.370170454438022e+01, -8.847795008638544e+00},
	{"LJS", -3.035879500284122e+01, -1.550488546709955e+01},
	{"LJT", -2.271441489340157e+01, -7.860505357659894e+00},
	{"LJU", -1.573761898552147e+01, -8.837094497797970e-01},
	{"LJV", -3.732169106233076e+01, -2.246778152658908e+01},
	{"LJW", -2.969594710590173e+01, -1.484203757016006e+01},
	{"LJX", -4.000099646939959e+01, -2.514708693365791e+01},
	{"LJY", -3.647086722024420e+01, -2.161695768450252e+01},
	{"LJZ", -3.457586831370264e+01, -1.972195877796095e+01},
	{"LKA", -1.496601637749241e+01, -2.839809938440476e+00},
	{"LKB", -1.780514225674770e+01, -5.678935817695763e+00},
	{"LKC", -1.885027728196819e+01, -6.724070842916253e+00},
	{"LKD", -1.906713432420522e+01, -6.940927885153284e+00},
	{"LKE", -1.435044404148938e+01, -2.224237602437441e+00},
	{"LKF", -1.849733315248708e+01, -6.371126713435142e+00},
	{"LKG", -2.053869033821447e+01, -8.412483899162533e+00},
	{"LKH", -1.899668864388270e+01, -6.870482204830760e+00},
	{"LKI", -1.426855077458262e+01, -2.142344335530680e+00},
	{"LKJ", -2.212358841913332e+01, -9.997381980081379e+00},
	{"LKK", -2.855307791339907e+01, -1.642687147434713e+01},
	{"LKL", -1.929750581951238e+01, -7.171299380460439e+00},
	{"LKM", -1.895256897034804e+01, -6.826362531296100e+00},
	{"LKN", -1.522706690835431e+01, -3.100860469302369e+00},
	{"LKO", -1.659876276150691e+01, -4.472556322454971e+00},
	{"LKP", -1.999972696618870e+01, -7.873520527136763e+00},
	{"LKQ", -3.190243400755854e+01, -1.977622756850660e+01},
	{"LKR", -2.024311268542364e+01, -8.116906246371702e+00},
	{"LKS", -1.586816727765904e+01, -3.741960838607099e+00},
	{"LKT", -1.682306464855741e+01, -4.696858209505472e+00},
	{"LKU", -1.923974425064161e+01, -7.113537811589676e+00},
	{"LKV", -2.270144932153436e+01, -1.057524288248242e+01},
	{"LKW", -1.695771617941854e+01, -4.831509740366602e+00},
	{"LKX", -3.287448087345180e+01, -2.074827443439986e+01},
	{"LKY", -1.803802554261802e+01, -5.911819103566085e+00},
	{"LKZ", -3.096594820929688e+01, -1.883974177024494e+01},
	{"LLA", -1.101818641613143e+01, -3.639900009275042e+00},
	{"LLB", -1.117810532324810e+01, -3.799818916391715e+00},
	{"LLC", -1.271722217935181e+01, -5.338935772495422e+00},
	{"LLD", -1.299797187155999e+01, -5.619685464703602e+00},
	{"LLE", -1.046330212503493e+01, -3.085015718178544e+00},
	{"LLF", -1.319282861814489e+01, -5.814542211288507e+00},
	{"LLG", -1.354370434989249e+01, -6.165417943036107e+00},
	{"LLH", -1.231036848576195e+01, -4.932082078905561e+00},
	{"LLI", -1.077666319770440e+01, -3.398376790848016e+00},
	{"LLJ", -1.591777043061731e+01, -8.539484023760920e+00},
	{"LLK", -1.463893664260718e+01, -7.260650235750796e+00},
	{"LLL", -1.391313367563142e+01, -6.534847268775033e+00},
	{"LLM", -1.286450721776135e+01, -5.486220810904964e+00},
	{"LLN", -1.250075318960318e+01, -5.122466782746790e+00},
	{"LLO", -1.089535618692788e+01, -3.517069780071495e+00},
	{"LLP", -1.287231910009539e+01, -5.494032693239009e+00},
	{"LLQ", -1.758931497497924e+01, -1.021102856812285e+01},
	{"LLR", -1.307028105863564e+01, -5.691994651779250e+00},
	{"LLS", -1.151426773398986e+01, -4.135981327133473e+00},
	{"LLT", -1.040149819262413e+01, -3.023211785767747e+00},
	{"LLU", -1.198639047833319e+01, -4.608104071476808e+00},
	{"LLV", -1.645926243033893e+01, -9.080976023482547e+00},
	{"LLW", -1.297795160762166e+01, -5.599665200765269e+00},
	{"LLX", -2.071861476656832e+01, -1.334032835971193e+01},
	{"LLY", -1.099371759316099e+01, -3.615431186304609e+00},
	{"LLZ", -2.371488107070340e+01, -1.633659466384701e+01},
	{"LMA", -1.326796715445918e+01, -2.066999502736691e+00},
	{"LMB", -2.004529820098230e+01, -8.844330549259809e+00},
	{"LMC", -1.931808112665304e+01, -8.117113474930546e+00},
	{"LMD", -2.024506709340136e+01, -9.044099441678870e+00},
	{"LME", -1.314734652803649e+01, -1.946378876313994e+00},
	{"LMF", -1.961673735490385e+01, -8.415769703181356e+00},
	{"LMG", -2.025221196135815e+01, -9.051244309635655e+00},
	{"LMH", -1.953095432873845e+01, -8.329986677015958e+00},
	{"LMI", -1.465483165708052e+01, -3.453864005358027e+00},
	{"LMJ", -2.112897776419995e+01, -9.928010112477459e+00},
	{"LMK", -2.369507816567235e+01, -1.249411051394985e+01},
	{"LML", -1.880754328552107e+01, -7.606575633798578e+00},
	{"LMM", -1.993967537544269e+01, -8.738707723720202e+00},
	{"LMN", -2.011116275519428e+01, -8.910195103471789e+00},
	{"LMO", -1.319972895038481e+01, -1.998761298662323e+00},
	{"LMP", -1.952264526784113e+01, -8.321677616118638e+00},
	{"LMQ", -3.224075123334291e+01, -2.103978358162041e+01},
	{"LMR", -1.890394594712448e+01, -7.702978295401994e+00},
	{"LMS", -1.697989423314072e+01, -5.778926581418226e+00},
	{"LMT", -1.708954599811057e+01, -5.888578346388077e+00},
	{"LMU", -1.631202793066649e+01, -5.111060278943999e+00},
	{"LMV", -2.270009683640628e+01, -1.149912918468379e+01},
	{"LMW", -1.889594576492029e+01, -7.694978113197798e+00},
	{"LMX", -3.388044069029637e+01, -2.267947303857387e+01},
	{"LMY", -1.533547986542458e+01, -4.134512213702092e+00},
	{"LMZ", -3.250951480932324e+01, -2.130854715760075e+01},
	{"LNA", -1.563404430803827e+01, -3.723662874503850e+00},
	{"LNB", -2.035767217205412e+01, -8.447290738519701e+00},
	{"LNC", -2.054217903738999e+01, -8.631797603855560e+00},
	{"LND", -1.985222205055958e+01, -7.941840617025153e+00},
	{"LNE", -1.417947382309098e+01, -2.269092389556560e+00},
	{"LNF", -2.130591963809101e+01, -9.395538204556589e+00},
	{"LNG", -2.081636968887843e+01, -8.905988255344004e+00},
	{"LNH", -2.020816754658327e+01, -8.297786113048849e+00},
	{"LNI", -1.646931209845605e+01, -4.558930664921625e+00},
	{"LNJ", -2.774854329308848e+01, -1.583816185955406e+01},
	{"LNK", -2.640690251514332e+01, -1.449652108160890e+01},
	{"LNL", -2.255869142145836e+01, -1.064830998792393e+01},
	{"LNM", -2.086205771344289e+01, -8.951676279908462e+00},
	{"LNN", -2.571374476067478e+01, -1.380336332714035e+01},
	{"LNO", -1.263253294685345e+01, -7.221515133190262e-01},
	{"LNP", -2.165756782809179e+01, -9.747186394557358e+00},
	{"LNQ", -2.865837803430117e+01, -1.674799660076674e+01},
	{"LNR", -2.207855442121067e+01, -1.016817298767624e+01},
	{"LNS", -1.841649886024299e+01, -6.506117426708566e+00},
	{"LNT", -1.941079220213658e+01, -7.500410768602154e+00},
	{"LNU", -1.737442676610116e+01, -5.464045332566740e+00},
	{"LNV", -2.356812076655138e+01, -1.165773933301695e+01},
	{"LNW", -1.899912433703481e+01, -7.088742903500388e+00},
	{"LNX", -3.071704690893266e+01, -1.880666547539824e+01},
	{"LNY", -2.329819048042176e+01, -1.138780904688734e+01},
	{"LNZ", -3.122575195271225e+01, -1.931537051917783e+01},
	{"LOA", -1.416916665698744e+01, -6.102546460168112e+00},
	{"LOB", -1.544552374588390e+01, -7.378903549064566e+00},
	{"LOC", -1.282821800740275e+01, -4.761597810583418e+00},
	{"LOD", -1.547239820737558e+01, -7.405778010556244e+00},
	{"LOE", -1.866618711291224e+01, -1.059956691609291e+01},
	{"LOF", -1.190278611798873e+01, -3.836165921169401e+00},
	{"LOG", -1.381458001680931e+01, -5.747959819989981e+00},
	{"LOH", -1.712928741972812e+01, -9.062667222908784e+00},
	{"LOI", -1.590909679535589e+01, -7.842476598536565e+00},
	{"LOJ", -2.137151593715450e+01, -1.330489574033517e+01},
	{"LOK", -2.132612816657734e+01, -1.325950796975801e+01},
	{"LOL", -1.786268663981719e+01, -9.796066442997857e+00},
	{"LOM", -1.413631657737318e+01, -6.069696380553851e+00},
	{"LON", -1.073027924758862e+01, -2.663659050769288e+00},
	{"LOO", -1.165648553136218e+01, -3.589865334542852e+00},
	{"LOP", -1.372211823085844e+01, -5.655498034039110e+00},
	{"LOQ", -1.700442450166481e+01, -8.937804304845475e+00},
	{"LOR", -1.024540932634412e+01, -2.178789129524794e+00},
	{"LOS", -1.215373030298102e+01, -4.087110106161688e+00},
	{"LOT", -1.271677343357507e+01, -4.650153236755735e+00},
	{"LOU", -1.226862059582437e+01, -4.202000399005036e+00},
	{"LOV", -1.257127597963925e+01, -4.504655782819918e+00},
	{"LOW", -1.104899122862303e+01, -2.982371031803697e+00},
	{"LOX", -2.907968398266656e+01, -2.101306378584723e+01},
	{"LOY", -1.390472981993368e+01, -5.838109623114350e+00},
	{"LOZ", -1.981090156406066e+01, -1.174428136724133e+01},
	{"LPA", -1.397746503278666e+01, -2.790902748071050e+00},
	{"LPB", -2.001103309296313e+01, -8.824470808247524e+00},
	{"LPC", -2.025475044570567e+01, -9.068188160990058e+00},
	{"LPD", -2.090643101087882e+01, -9.719868726163208e+00},
	{"LPE", -1.455428184897228e+01, -3.367719564256669e+00},
	{"LPF", -1.790980272400149e+01, -6.723240439285879e+00},
	{"LPG", -2.138575628754295e+01, -1.019919400282734e+01},
	{"LPH", -1.455667587203088e+01, -3.370113587315269e+00},
	{"LPI", -1.539544937058338e+01, -4.208887085867775e+00},
	{"LPJ", -3.120982563959305e+01, -2.002326335487744e+01},
	{"LPK", -3.109370280038024e+01, -1.990714051566463e+01},
	{"LPL", -1.521405185441111e+01, -4.027489569695504e+00},
	{"LPM", -1.750717724685428e+01, -6.320614962138668e+00},
	{"LPN", -2.212111019796451e+01, -1.093454791324890e+01},
	{"LPO", -1.404777309705808e+01, -2.861210812342471e+00},
	{"LPP", -1.801223505523803e+01, -6.825672770522416e+00},
	{"LPQ", -3.247841643058705e+01, -2.129185414587145e+01},
	{"LPR", -1.324860181827166e+01, -2.062039533556049e+00},
	{"LPS", -1.633096461007264e+01, -5.144402325357028e+00},
	{"LPT", -1.649775651441908e+01, -5.311194229703467e+00},
	{"LPU", -1.500464199937073e+01, -3.818079714655117e+00},
	{"LPV", -2.139459153969258e+01, -1.020802925497697e+01},
	{"LPW", -1.970857404893779e+01, -8.522011764222178e+00},
	{"LPX", -3.597959513599486e+01, -2.479303285127925e+01},
	{"LPY", -1.912315347209542e+01, -7.936591187379810e+00},
	{"LPZ", -3.428471076144595e+01, -2.309814847673034e+01},
	{"LQA", -1.901900094829401e+01, -3.076387157722487e+00},
	{"LQB", -2.996365865891410e+01, -1.402104486834258e+01},
	{"LQC", -2.368385540516416e+01, -7.741241614592639e+00},
	{"LQD", -3.048536251900402e+01, -1.454274872843250e+01},
	{"LQE", -3.086360833740052e+01, -1.492099454682900e+01},
	{"LQF", -2.369255105988709e+01, -7.749937269315566e+00},
	{"LQG", -3.594898543678638e+01, -2.000637164621486e+01},
	{"LQH", -2.978372011926400e+01, -1.384110632869248e+01},
	{"LQI", -2.567528072715606e+01, -9.732666936584540e+00},
	{"LQJ", -3.174903189440580e+01, -1.580641810383428e+01},
	{"LQK", -3.758117063172512e+01, -2.163855684115360e+01},
	{"LQL", -3.022610769270700e+01, -1.428349390213548e+01},
	{"LQM", -2.369603269396670e+01, -7.753418903395180e+00},
	{"LQN", -3.223303822753506e+01, -1.629042443696354e+01},
	{"LQO", -3.042948405826050e+01, -1.448687026768898e+01},
	{"LQP", -3.042455859984574e+01, -1.448194480927422e+01},
	{"LQQ", -3.231307239342345e+01, -1.637045860285193e+01},
	{"LQR", -3.027837289613822e+01, -1.433575910556670e+01},
	{"LQS", -2.361160211807427e+01, -7.668988327502753e+00},
	{"LQT", -2.785035605536128e+01, -1.190774226478976e+01},
	{"LQU", -1.615916798145282e+01, -2.165541908812998e-01},
	{"LQV", -3.314422607377673e+01, -1.720161228320521e+01},
	{"LQW", -2.950247889792301e+01, -1.355986510735148e+01},
	{"LQX", -3.960430258960805e+01, -2.366168879903654e+01},
	{"LQY", -3.379702279105484e+01, -1.785440900048332e+01},
	{"LQZ", -4.074387002635859e+01, -2.480125623578706e+01},
	{"LRA", -1.614510103126198e+01, -4.427852655820581e+00},
	{"LRB", -2.631561099143714e+01, -1.459836261599575e+01},
	{"LRC", -2.530713709331381e+01, -1.358988871787241e+01},
	{"LRD", -2.435570861243312e+01, -1.263846023699172e+01},
	{"LRE", -1.228790950492556e+01, -5.706611294841633e-01},
	{"LRF", -2.614539357634104e+01, -1.442814520089964e+01},
	{"LRG", -2.576812864418356e+01, -1.405088026874216e+01},
	{"LRH", -2.203475860111146e+01, -1.031751022567006e+01},
	{"LRI", -1.484981273139358e+01, -3.132564355952185e+00},
	{"LRJ", -2.923838142887261e+01, -1.752113305343122e+01},
	{"LRK", -2.610545112270403e+01, -1.438820274726263e+01},
	{"LRL", -2.597277651857221e+01, -1.425552814313081e+01},
	{"LRM", -2.498099961980657e+01, -1.326375124436517e+01},
	{"LRN", -2.503623846657952e+01, -1.331899009113812e+01},
	{"LRO", -1.537167297474987e+01, -3.654424599308474e+00},
	{"LRP", -2.623887356926328e+01, -1.452162519382188e+01},
	{"LRQ", -3.062491755911338e+01, -1.890766918367198e+01},
	{"LRR", -2.550814434664987e+01, -1.379089597120847e+01},
	{"LRS", -2.273169864405002e+01, -1.101445026860862e+01},
	{"LRT", -2.345318991539468e+01, -1.173594153995329e+01},
	{"LRU", -1.628995005118045e+01, -4.572701675739059e+00},
	{"LRV", -2.655606089903047e+01, -1.483881252358907e+01},
	{"LRW", -2.591163071464369e+01, -1.419438233920229e+01},
	{"LRX", -3.129004373187284e+01, -1.957279535643144e+01},
	{"LRY", -1.627986752904976e+01, -4.562619153608366e+00},
	{"LRZ", -3.219664243695873e+01, -2.047939406151733e+01},
	{"LSA", -1.248351934748619e+01, -2.999934029952895e+00},
	{"LSB", -1.537245887056879e+01, -5.888873553035497e+00},
	{"LSC", -1.484925491890493e+01, -5.365669601371638e+00},
	{"LSD", -1.642152301880068e+01, -6.937937701267393e+00},
	{"LSE", -1.273359194094433e+01, -3.250006623411038e+00},
	{"LSF", -1.515470952307001e+01, -5.671124205536724e+00},
	{"LSG", -1.762765793871856e+01, -8.144072621185268e+00},
	{"LSH", -1.343695293035579e+01, -3.953367612822499e+00},
	{"LSI", -1.362609341219025e+01, -4.142508094656962e+00},
	{"LSJ", -1.990713892500282e+01, -1.042355360746953e+01},
	{"LSK", -1.796027477640435e+01, -8.476689458871057e+00},
	{"LSL", -1.577402552510478e+01, -6.290440207571494e+00},
	{"LSM", -1.556672018447296e+01, -6.083134866939672e+00},
	{"LSN", -1.690717286057015e+01, -7.423587543036858e+00},
	{"LSO", -1.134471181004501e+01, -1.861126492511715e+00},
	{"LSP", -1.463971640883122e+01, -5.156131091297929e+00},
	{"LSQ", -1.919243670320980e+01, -9.708851385676510e+00},
	{"LSR", -1.673828514336785e+01, -7.254699825834564e+00},
	{"LSS", -1.526021526813924e+01, -5.776629950605948e+00},
	{"LST", -1.258341371429970e+01, -3.099828396766408e+00},
	{"LSU", -1.403771097616454e+01, -4.554125658631248e+00},
	{"LSV", -1.925442887170480e+01, -9.770843554171508e+00},
	{"LSW", -1.403772795693476e+01, -4.554142639401472e+00},
	{"LSX", -3.028040970020576e+01, -2.079682438267247e+01},
	{"LSY", -1.661906082047406e+01, -7.135475502940769e+00},
	{"LSZ", -2.371317929748124e+01, -1.422959397994795e+01},
	{"LTA", -1.280922147751263e+01, -3.844833392152367e+00},
	{"LTB", -1.537778582620108e+01, -6.413397740840816e+00},
	{"LTC", -1.645911515933632e+01, -7.494727073976064e+00},
	{"LTD", -1.638647283001664e+01, -7.422084744656373e+00},
	{"LTE", -1.292093106631432e+01, -3.956542980954062e+00},
	{"LTF", -1.639489642186053e+01, -7.430508336500273e+00},
	{"LTG", -1.724121413431622e+01, -8.276826048955959e+00},
	{"LTH", -1.004031460744976e+01, -1.075926522089502e+00},
	{"LTI", -1.253801897473450e+01, -3.573630889374234e+00},
	{"LTJ", -2.138961259331498e+01, -1.242522450795472e+01},
	{"LTK", -1.813294432860777e+01, -9.168556243247512e+00},
	{"LTL", -1.642103791730423e+01, -7.456649831943963e+00},
	{"LTM", -1.631585282532581e+01, -7.351464739965551e+00},
	{"LTN", -1.535178488366516e+01, -6.387396798304893e+00},
	{"LTO", -1.232437586433511e+01, -3.359987778974850e+00},
	{"LTP", -1.670595297599563e+01, -7.741564890635372e+00},
	{"LTQ", -2.013301626736071e+01, -1.116862818200045e+01},
	{"LTR", -1.442438247176434e+01, -5.459994386404079e+00},
	{"LTS", -1.404121120921428e+01, -5.076823123854017e+00},
	{"LTT", -1.370983891508033e+01, -4.745450829720073e+00},
	{"LTU", -1.456521752279294e+01, -5.600829437432678e+00},
	{"LTV", -1.932466283086284e+01, -1.036027474550258e+01},
	{"LTW", -1.548717999866315e+01, -6.522791913302888e+00},
	{"LTX", -3.371226032383819e+01, -2.474787223847792e+01},
	{"LTY", -1.431905188329524e+01, -5.354663797934980e+00},
	{"LTZ", -1.891110508183660e+01, -9.946716996476342e+00},
	{"LUA", -1.606239424963182e+01, -5.974048272747447e+00},
	{"LUB", -1.712526426280480e+01, -7.036918285920428e+00},
	{"LUC", -1.445202825420609e+01, -4.363682277321721e+00},
	{"LUD", -1.357979411273338e+01, -3.491448135849016e+00},
	{"LUE", -1.335170859508373e+01, -3.263362618199364e+00},
	{"LUF", -1.846365502591779e+01, -8.375309049033421e+00},
	{"LUG", -1.732579131855321e+01, -7.237445341668843e+00},
	{"LUH", -2.052973369936547e+01, -1.044138772248110e+01},
	{"LUI", -1.734863494713994e+01, -7.260288970255573e+00},
	{"LUJ", -2.370990580029454e+01, -1.362155982341017e+01},
	{"LUK", -2.024822000129312e+01, -1.015987402440875e+01},
	{"LUL", -1.775799751873017e+01, -7.669651541845795e+00},
	{"LUM", -1.345809953336424e+01, -3.369753556479864e+00},
	{"LUN", -1.342718075888497e+01, -3.338834782000597e+00},
	{"LUO", -1.925432317702606e+01, -9.165977200141691e+00},
	{"LUP", -1.504871280272089e+01, -4.960366825836520e+00},
	{"LUQ", -3.252210374703032e+01, -2.243375777014595e+01},
	{"LUR", -1.571027296585259e+01, -5.621926988968215e+00},
	{"LUS", -1.182522189145256e+01, -1.736875914568191e+00},
	{"LUT", -1.282890269243312e+01, -2.740556715548753e+00},
	{"LUU", -2.986044888021371e+01, -1.977210290332934e+01},
	{"LUV", -2.171081361258332e+01, -1.162246763569895e+01},
	{"LUW", -2.688704745272680e+01, -1.679870147584244e+01},
	{"LUX", -1.668521450219700e+01, -6.596868525312629e+00},
	{"LUY", -2.269509642672452e+01, -1.260675044984015e+01},
	{"LUZ", -1.913243971209923e+01, -9.044093735214854e+00},
	{"LVA", -1.472425954426506e+01, -3.237685206675926e+00},
	{"LVB", -3.256091287852468e+01, -2.107433854093555e+01},
	{"LVC", -3.275026920586488e+01, -2.126369486827575e+01},
	{"LVD", -3.200534133960891e+01, -2.051876700201978e+01},
	{"LVE", -1.181935112502943e+01, -3.327767874403013e-01},
	{"LVF", -3.220968858489645e+01, -2.072311424730731e+01},
	{"LVG", -3.351808097221793e+01, -2.203150663462880e+01},
	{"LVH", -3.122051050911511e+01, -1.973393617152598e+01},
	{"LVI", -1.515208703825052e+01, -3.665512700661386e+00},
	{"LVJ", -3.344093867285855e+01, -2.195436433526942e+01},
	{"LVK", -3.532053929563687e+01, -2.383396495804774e+01},
	{"LVL", -2.371585510865846e+01, -1.222928077106933e+01},
	{"LVM", -3.158722170158993e+01, -2.010064736400080e+01},
	{"LVN", -3.069305362342582e+01, -1.920647928583669e+01},
	{"LVO", -1.716871983629887e+01, -5.682145498709738e+00},
	{"LVP", -2.213207587918661e+01, -1.064550154159748e+01},
	{"LVQ", -3.927273406897235e+01, -2.778615973138322e+01},
	{"LVR", -2.270703863395253e+01, -1.122046429636340e+01},
	{"LVS", -3.066970389065847e+01, -1.918312955306934e+01},
	{"LVT", -2.998037166314552e+01, -1.849379732555639e+01},
	{"LVU", -2.956764231557236e+01, -1.808106797798323e+01},
	{"LVV", -3.416631123458323e+01, -2.267973689699410e+01},
	{"LVW", -3.130907086242559e+01, -1.982249652483646e+01},
	{"LVX", -3.589855488606901e+01, -2.441198054847988e+01},
	{"LVY", -2.267464080910751e+01, -1.118806647151838e+01},
	{"LVZ", -3.930843376862673e+01, -2.782185943103760e+01},
	{"LWA", -1.239963574766483e+01, -1.216245061216147e+00},
	{"LWB", -2.831363274285808e+01, -1.713024205640940e+01},
	{"LWC", -2.837152436178536e+01, -1.718813367533668e+01},
	{"LWD", -2.788501436190909e+01, -1.670162367546041e+01},
	{"LWE", -1.423744446572134e+01, -3.054053779272658e+00},
	{"LWF", -2.816511470832874e+01, -1.698172402188007e+01},
	{"LWG", -2.929334557803047e+01, -1.810995489158179e+01},
	{"LWH", -1.352026377551574e+01, -2.336873089067056e+00},
	{"LWI", -1.382404192031620e+01, -2.640651233867521e+00},
	{"LWJ", -3.065004004084788e+01, -1.946664935439920e+01},
	{"LWK", -3.080505250437389e+01, -1.962166181792522e+01},
	{"LWL", -2.723430469917214e+01, -1.605091401272346e+01},
	{"LWM", -2.793591700098286e+01, -1.675252631453418e+01},
	{"LWN", -2.481020696237962e+01, -1.362681627593094e+01},
	{"LWO", -1.485133966810913e+01, -3.667948981660450e+00},
	{"LWP", -2.902378066801277e+01, -1.784038998156409e+01},
	{"LWQ", -3.327740181472390e+01, -2.209401112827522e+01},
	{"LWR", -1.760725768868707e+01, -6.423867002238395e+00},
	{"LWS", -2.346069952503908e+01, -1.227730883859040e+01},
	{"LWT", -2.594040157629665e+01, -1.475701088984797e+01},
	{"LWU", -2.369112770619919e+01, -1.250773701975051e+01},
	{"LWV", -3.112757517736908e+01, -1.994418449092040e+01},
	{"LWW", -2.715959461645937e+01, -1.597620393001069e+01},
	{"LWX", -4.047120808084931e+01, -2.928781739440063e+01},
	{"LWY", -2.810866628238099e+01, -1.692527559593232e+01},
	{"LWZ", -3.399419173148846e+01, -2.281080104503979e+01},
	{"LXA", -2.443606267058166e+01, -5.191480695882643e+00},
	{"LXB", -2.900338727961611e+01, -9.758805304917093e+00},
	{"LXC", -2.396438693716626e+01, -4.719804962467243e+00},
	{"LXD", -2.839677543253606e+01, -9.152193457837038e+00},
	{"LXE", -2.062620096880487e+01, -1.381618994105853e+00},
	{"LXF", -2.853888489859156e+01, -9.294302923892539e+00},
	{"LXG", -2.983794943870732e+01, -1.059336746400830e+01},
	{"LXH", -2.619612326457063e+01, -6.951541289871613e+00},
	{"LXI", -2.289597891055782e+01, -3.651396935858801e+00},
	{"LXJ", -3.105091856473123e+01, -1.180633659003221e+01},
	{"LXK", -3.194900485517761e+01, -1.270442288047860e+01},
	{"LXL", -2.371464529913484e+01, -4.470063324435820e+00},
	{"LXM", -2.777942448999559e+01, -8.534842515296567e+00},
	{"LXN", -3.028844254655225e+01, -1.104386057185324e+01},
	{"LXO", -2.679379565307088e+01, -7.549213678371857e+00},
	{"LXP", -2.341218394375410e+01, -4.167601969055085e+00},
	{"LXQ", -2.995121421444438e+01, -1.070663223974536e+01},
	{"LXR", -2.274246814904571e+01, -3.497886174346688e+00},
	{"LXS", -2.786128706640872e+01, -8.616705091709704e+00},
	{"LXT", -2.246300472171248e+01, -3.218422747013458e+00},
	{"LXU", -2.707428439991753e+01, -7.829702425218514e+00},
	{"LXV", -2.359001532550257e+01, -4.345433350803554e+00},
	{"LXW", -2.788501676699576e+01, -8.640434792296743e+00},
	{"LXX", -2.271415651492640e+01, -3.469574540227389e+00},
	{"LXY", -2.766847269798092e+01, -8.423890723281906e+00},
	{"LXZ", -4.148823396734397e+01, -2.224365199264496e+01},
	{"LYA", -1.144459448752646e+01, -2.876421790259021e+00},
	{"LYB", -1.283009761704494e+01, -4.261924919777496e+00},
	{"LYC", -1.298251131073330e+01, -4.414338613465863e+00},
	{"LYD", -1.302996064850075e+01, -4.461787951233308e+00},
	{"LYE", -1.308935259246537e+01, -4.521179895197927e+00},
	{"LYF", -1.323212307826438e+01, -4.663950380996934e+00},
	{"LYG", -1.432136176352346e+01, -5.753189066256014e+00},
	{"LYH", -1.344389454696020e+01, -4.875721849692763e+00},
	{"LYI", -1.199961785657339e+01, -3.431445159305951e+00},
	{"LYJ", -1.655798696446264e+01, -7.989814267195198e+00},
	{"LYK", -1.603155332342988e+01, -7.463380626162441e+00},
	{"LYL", -1.428922867871702e+01, -5.721055981449577e+00},
	{"LYM", -1.365149544369382e+01, -5.083322746426376e+00},
	{"LYN", -1.439146327985121e+01, -5.823290582583771e+00},
	{"LYO", -1.234219448265696e+01, -3.774021785389520e+00},
	{"LYP", -1.343013901989036e+01, -4.861966322622918e+00},
	{"LYQ", -1.816345729290387e+01, -9.595284595636432e+00},
	{"LYR", -1.348085221086844e+01, -4.912679513600995e+00},
	{"LYS", -1.242105053119552e+01, -3.852877833928083e+00},
	{"LYT", -1.160125798049424e+01, -3.033085283226793e+00},
	{"LYU", -1.438733210490453e+01, -5.819159407637089e+00},
	{"LYV", -1.589789028836656e+01, -7.329717591099118e+00},
	{"LYW", -1.286755844591800e+01, -4.299385748650558e+00},
	{"LYX", -2.371008285061514e+01, -1.514191015334770e+01},
	{"LYY", -1.597606761690697e+01, -7.407894919639532e+00},
	{"LYZ", -1.801812562977137e+01, -9.449952932503932e+00},
	{"LZA", -2.001391979978073e+01, -2.107847351965941e+00},
	{"LZB", -2.879973400517430e+01, -1.089366155735951e+01},
	{"LZC", -2.968464882341587e+01, -1.177857637560109e+01},
	{"LZD", -3.004381466481870e+01, -1.213774221700392e+01},
	{"LZE", -1.924221249912802e+01, -1.336140051313238e+00},
	{"LZF", -2.963094623119330e+01, -1.172487378337851e+01},
	{"LZG", -3.015391540432051e+01, -1.224784295650573e+01},
	{"LZH", -2.877065253447040e+01, -1.086458008665562e+01},
	{"LZI", -2.119410013025110e+01, -3.288027682436322e+00},
	{"LZJ", -3.267764010647768e+01, -1.477156765866289e+01},
	{"LZK", -3.131314016686403e+01, -1.340706771904925e+01},
	{"LZL", -2.700337530351049e+01, -9.097302855695704e+00},
	{"LZM", -2.921163123320051e+01, -1.130555878538572e+01},
	{"LZN", -3.031445886182015e+01, -1.240838641400537e+01},
	{"LZO", -2.051663536432909e+01, -2.610562916514308e+00},
	{"LZP", -2.813002358205035e+01, -1.022395113423556e+01},
	{"LZQ", -3.659385399580103e+01, -1.868778154798624e+01},
	{"LZR", -2.734278023205272e+01, -9.436707784237932e+00},
	{"LZS", -2.896160297510861e+01, -1.105553052729383e+01},
	{"LZT", -2.746153525623196e+01, -9.555462808417170e+00},
	{"LZU", -2.138431628686916e+01, -3.478243839054372e+00},
	{"LZV", -2.976133479994532e+01, -1.185526235213054e+01},
	{"LZW", -2.842306771310418e+01, -1.051699526528939e+01},
	{"LZX", -3.940199055724587e+01, -2.149591810943108e+01},
	{"LZY", -2.783746980557154e+01, -9.931397357756754e+00},
	{"LZZ", -2.543234811072797e+01, -7.526275662913183e+00},
	{"MAA", -1.610333695142844e+01, -8.508283200021619e+00},
	{"MAB", -1.530671308905821e+01, -7.711659337651388e+00},
	{"MAC", -1.313190634048680e+01, -5.536852589079987e+00},
	{"MAD", -1.136671307380237e+01, -3.771659322395555e+00},
	{"MAE", -1.671749827360409e+01, -9.122444522197267e+00},
	{"MAF", -1.540446198136110e+01, -7.809408229954277e+00},
	{"MAG", -1.233368999692855e+01, -4.738636245521734e+00},
	{"MAH", -1.548907793426641e+01, -7.894024182859590e+00},
	{"MAI", -1.208483923256629e+01, -4.489785481159466e+00},
	{"MAJ", -1.417764011124328e+01, -6.582586359836464e+00},
	{"MAK", -1.170185848714764e+01, -4.106804735740824e+00},
	{"MAL", -1.164989033735438e+01, -4.054836585947562e+00},
	{"MAM", -1.444987427847543e+01, -6.854820527068614e+00},
	{"MAN", -9.008850197033562e+00, -1.413796445626743e+00},
	{"MAO", -1.843201592588965e+01, -1.083696217448284e+01},
	{"MAP", -1.453262048866424e+01, -6.937566737257421e+00},
	{"MAQ", -2.013020342990390e+01, -1.253514967849709e+01},
	{"MAR", -1.103763278370006e+01, -3.442579032293244e+00},
	{"MAS", -1.217946747801730e+01, -4.584413726610486e+00},
	{"MAT", -1.131296139402999e+01, -3.717907642623171e+00},
	{"MAU", -1.636728348106378e+01, -8.772229729656964e+00},
	{"MAV", -1.782009976698845e+01, -1.022504601558163e+01},
	{"MAW", -1.577447198018633e+01, -8.179418228779516e+00},
	{"MAX", -1.607469462008855e+01, -8.479640868681731e+00},
	{"MAY", -1.159444675027704e+01, -3.999392998870219e+00},
	{"MAZ", -1.637863738112022e+01, -8.783583629713402e+00},
	{"MBA", -1.380939518896730e+01, -3.582002271778839e+00},
	{"MBB", -1.961829157202000e+01, -9.390898654831538e+00},
	{"MBC", -1.867031459125179e+01, -8.442921674063330e+00},
	{"MBD", -2.012927480413980e+01, -9.901881886951339e+00},
	{"MBE", -1.138498976888102e+01, -1.157596851692560e+00},
	{"MBF", -1.907427195289274e+01, -8.846879035704276e+00},
	{"MBG", -2.271578246897959e+01, -1.248838955179113e+01},
	{"MBH", -1.954665055689757e+01, -9.319257639709114e+00},
	{"MBI", -1.425129405841237e+01, -4.023901141223905e+00},
	{"MBJ", -2.640178595742064e+01, -1.617439304023218e+01},
	{"MBK", -3.185711869291073e+01, -2.162972577572227e+01},
	{"MBL", -1.317550275514082e+01, -2.948109837952362e+00},
	{"MBM", -1.954529624218740e+01, -9.317903324998939e+00},
	{"MBN", -2.025595617993347e+01, -1.002856326274501e+01},
	{"MBO", -1.483185367963219e+01, -4.604460762443725e+00},
	{"MBP", -1.954764328963164e+01, -9.320250372443184e+00},
	{"MBQ", -3.546824474772387e+01, -2.524085183053541e+01},
	{"MBR", -1.432286906617206e+01, -4.095476148983599e+00},
	{"MBS", -1.548325421445205e+01, -5.255861297263585e+00},
	{"MBT", -1.727160221677765e+01, -7.044209299589186e+00},
	{"MBU", -1.368163209286904e+01, -3.454239175680577e+00},
	{"MBV", -2.270697285380191e+01, -1.247957993661345e+01},
	{"MBW", -1.881078128349863e+01, -8.583388366310166e+00},
	{"MBX", -3.747685739233571e+01, -2.724946447514725e+01},
	{"MBY", -1.500764439353051e+01, -4.780251476342043e+00},
	{"MBZ", -3.351982147936580e+01, -2.329242856217734e+01},
	{"MCA", -1.528090003441860e+01, -2.435337652055291e+00},
	{"MCB", -2.947875573089977e+01, -1.663319334853646e+01},
	{"MCC", -1.780006347979268e+01, -4.954501097429366e+00},
	{"MCD", -2.039165937994925e+01, -7.546096997585935e+00},
	{"MCE", -1.772461749727187e+01, -4.879055114908558e+00},
	{"MCF", -2.270436479642112e+01, -9.858802414057806e+00},
	{"MCG", -2.001739727117589e+01, -7.171834888812582e+00},
	{"MCH", -1.627933419831779e+01, -3.433771815954482e+00},
	{"MCI", -1.620913755595426e+01, -3.363575173590953e+00},
	{"MCJ", -3.225733698539928e+01, -1.941177460303597e+01},
	{"MCK", -1.826484801595222e+01, -5.419285633588907e+00},
	{"MCL", -1.721445779967587e+01, -4.368895417312563e+00},
	{"MCM", -2.039394550607332e+01, -7.548383123710006e+00},
	{"MCN", -3.011201198112428e+01, -1.726644959876097e+01},
	{"MCO", -1.427953148977013e+01, -1.433969107406825e+00},
	{"MCP", -2.366846243044954e+01, -1.082290004808623e+01},
	{"MCQ", -1.890995129412661e+01, -6.064388911763301e+00},
	{"MCR", -1.734675886991407e+01, -4.501196487550758e+00},
	{"MCS", -2.358879594053800e+01, -1.074323355817469e+01},
	{"MCT", -2.040522552579178e+01, -7.559663143428466e+00},
	{"MCU", -1.786709978147197e+01, -5.021537399108658e+00},
	{"MCV", -3.190677958752478e+01, -1.906121720516148e+01},
	{"MCW", -2.761402846497615e+01, -1.476846608261284e+01},
	{"MCX", -3.320053964807229e+01, -2.035497726570898e+01},
	{"MCY", -2.165661131341190e+01, -8.811048931048587e+00},
	{"MCZ", -3.184204566180362e+01, -1.899648327944031e+01},
	{"MDA", -1.661102099132670e+01, -3.597056003764776e+00},
	{"MDB", -2.416843086701303e+01, -1.115446587945110e+01},
	{"MDC", -2.249776916087653e+01, -9.483804173314599e+00},
	{"MDD", -2.510527866121140e+01, -1.209131367364947e+01},
	{"MDE", -1.421403697845705e+01, -1.200071990895121e+00},
	{"MDF", -2.126835188295561e+01, -8.254386895393687e+00},
	{"MDG", -2.554863612983733e+01, -1.253467114227540e+01},
	{"MDH", -2.227033498910537e+01, -9.256370001543443e+00},
	{"MDI", -1.583528635243271e+01, -2.821321364870788e+00},
	{"MDJ", -2.717653412042140e+01, -1.416256913285948e+01},
	{"MDK", -2.835337994079721e+01, -1.533941495323528e+01},
	{"MDL", -1.911485038793588e+01, -6.100885400373958e+00},
	{"MDM", -2.320108053327209e+01, -1.018711554571016e+01},
	{"MDN", -2.519993870477181e+01, -1.218597371720988e+01},
	{"MDO", -1.535941507435584e+01, -2.345450086793916e+00},
	{"MDP", -2.067017559856207e+01, -7.656210611000142e+00},
	{"MDQ", -2.979727147131073e+01, -1.678330648374881e+01},
	{"MDR", -1.721775601764330e+01, -4.203791030081373e+00},
	{"MDS", -2.134247181193057e+01, -8.328506824368640e+00},
	{"MDT", -2.067078582185423e+01, -7.656820834292307e+00},
	{"MDU", -1.761968424420176e+01, -4.605719256639837e+00},
	{"MDV", -2.688193020570730e+01, -1.386796521814537e+01},
	{"MDW", -1.934789085171489e+01, -6.333925864152969e+00},
	{"MDX", -3.469646177258493e+01, -2.168249678502301e+01},
	{"MDY", -2.562326437157474e+01, -1.260929938401282e+01},
	{"MDZ", -3.077890357290343e+01, -1.776493858534150e+01},
	{"MEA", -1.067983772124185e+01, -3.377048014719304e+00},
	{"MEB", -1.314944293660684e+01, -5.846653230084298e+00},
	{"MEC", -1.378786205962938e+01, -6.485072353106834e+00},
	{"MED", -1.093388693362862e+01, -3.631097227106076e+00},
	{"MEE", -1.328420714784790e+01, -5.981417441325363e+00},
	{"MEF", -1.300220680075792e+01, -5.699417094235381e+00},
	{"MEG", -1.469808377213611e+01, -7.395294065613566e+00},
	{"MEH", -1.345606300333022e+01, -6.153273296807678e+00},
	{"MEI", -1.218209951498883e+01, -4.879309808466294e+00},
	{"MEJ", -1.696322961135505e+01, -9.660439904832511e+00},
	{"MEK", -1.649835492211954e+01, -9.195565215596998e+00},
	{"MEL", -1.267494722952179e+01, -5.372157522999252e+00},
	{"MEM", -1.221345451257870e+01, -4.910664806056157e+00},
	{"MEN", -9.241369942902271e+00, -1.938580236379729e+00},
	{"MEO", -1.194038208663232e+01, -4.637592380109773e+00},
	{"MEP", -1.412873652348196e+01, -6.825946816959421e+00},
	{"MEQ", -1.776293336526170e+01, -1.046014365873916e+01},
	{"MER", -1.086536684552484e+01, -3.562577139002295e+00},
	{"MES", -1.095023530611130e+01, -3.647445599588754e+00},
	{"MET", -1.039900067126663e+01, -3.096210964744088e+00},
	{"MEU", -1.361654690715202e+01, -6.313757200629480e+00},
	{"MEV", -1.503410773706839e+01, -7.731318030545846e+00},
	{"MEW", -1.254836123448888e+01, -5.245571527966336e+00},
	{"MEX", -1.542775631460562e+01, -8.124966608083083e+00},
	{"MEY", -1.475171660765872e+01, -7.448926901136181e+00},
	{"MEZ", -1.932542024364136e+01, -1.202263053711882e+01},
	{"MFA", -1.638505748659401e+01, -4.029133458698198e+00},
	{"MFB", -2.645784631717509e+01, -1.410192228927928e+01},
	{"MFC", -2.587171846649986e+01, -1.351579443860405e+01},
	{"MFD", -2.675369135728933e+01, -1.439776732939351e+01},
	{"MFE", -1.646978369159294e+01, -4.113859663697127e+00},
	{"MFF", -2.076946777563356e+01, -8.413543747737746e+00},
	{"MFG", -2.640826087712271e+01, -1.405233684922690e+01},
	{"MFH", -2.520854691813802e+01, -1.285262289024220e+01},
	{"MFI", -1.634082894113728e+01, -3.984904913241469e+00},
	{"MFJ", -2.719579596576153e+01, -1.483987193786572e+01},
	{"MFK", -2.909273621601433e+01, -1.673681218811851e+01},
	{"MFL", -1.792607520054543e+01, -5.570151172649619e+00},
	{"MFM", -2.553992242808843e+01, -1.318399840019262e+01},
	{"MFN", -2.137072310912098e+01, -9.014799081225165e+00},
	{"MFO", -1.316579653957353e+01, -8.098725116777141e-01},
	{"MFP", -2.607195528260369e+01, -1.371603125470787e+01},
	{"MFQ", -3.133958178628690e+01, -1.898365775839109e+01},
	{"MFR", -1.477021181508801e+01, -2.414287787192196e+00},
	{"MFS", -2.539932350186027e+01, -1.304339947396446e+01},
	{"MFT", -2.238045037489390e+01, -1.002452634699809e+01},
	{"MFU", -1.731881081419801e+01, -4.962886786302194e+00},
	{"MFV", -2.837356407959135e+01, -1.601764005169553e+01},
	{"MFW", -2.612551736662694e+01, -1.376959333873113e+01},
	{"MFX", -3.365095329062041e+01, -2.129502926272459e+01},
	{"MFY", -2.676841134839637e+01, -1.441248732050056e+01},
	{"MFZ", -2.977954675014694e+01, -1.742362272225112e+01},
	{"MGA", -1.751225722308497e+01, -3.503557885279001e+00},
	{"MGB", -2.606353504114370e+01, -1.205483570333773e+01},
	{"MGC", -2.260477096918291e+01, -8.596071631376946e+00},
	{"MGD", -2.205001661888297e+01, -8.041317281077001e+00},
	{"MGE", -1.683114603202725e+01, -2.822446694221282e+00},
	{"MGF", -2.586894283271088e+01, -1.186024349490492e+01},
	{"MGG", -2.601073556989308e+01, -1.200203623208711e+01},
	{"MGH", -2.253317005377153e+01, -8.524470715965561e+00},
	{"MGI", -1.748502407410673e+01, -3.476324736300765e+00},
	{"MGJ", -2.953858617783659e+01, -1.552988684003063e+01},
	{"MGK", -2.977236540735361e+01, -1.576366606954765e+01},
	{"MGL", -1.811616966699516e+01, -4.107470329189190e+00},
	{"MGM", -2.582103044545706e+01, -1.181233110765109e+01},
	{"MGN", -2.493386220284039e+01, -1.092516286503443e+01},
	{"MGO", -1.512745626625942e+01, -1.118756928453453e+00},
	{"MGP", -2.630641280180344e+01, -1.229771346399748e+01},
	{"MGQ", -3.106997920575190e+01, -1.706127986794593e+01},
	{"MGR", -1.705544280503466e+01, -3.046743467228689e+00},
	{"MGS", -2.226338155690426e+01, -8.254682219098298e+00},
	{"MGT", -2.325946200913382e+01, -9.250762671327850e+00},
	{"MGU", -1.941930026353816e+01, -5.410600925732195e+00},
	{"MGV", -2.891042098767240e+01, -1.490172164986643e+01},
	{"MGW", -2.334896440318386e+01, -9.340265065377892e+00},
	{"MGX", -3.428879967219926e+01, -2.028010033439329e+01},
	{"MGY", -2.626301217258334e+01, -1.225431283477737e+01},
	{"MGZ", -3.287705318623149e+01, -1.886835384842552e+01},
	{"MHA", -1.462292496490476e+01, -2.645379850994527e+00},
	{"MHB", -2.790624060405716e+01, -1.592869549014693e+01},
	{"MHC", -2.787824062433084e+01, -1.590069551042061e+01},
	{"MHD", -2.835891302583941e+01, -1.638136791192918e+01},
	{"MHE", -1.317437303216688e+01, -1.196827918256646e+00},
	{"MHF", -2.789414510504901e+01, -1.591659999113878e+01},
	{"MHG", -2.887775213139112e+01, -1.690020701748089e+01},
	{"MHH", -2.681425208804987e+01, -1.483670697413964e+01},
	{"MHI", -1.382725155143280e+01, -1.849706437522572e+00},
	{"MHJ", -3.079618216052108e+01, -1.881863704661085e+01},
	{"MHK", -3.111978554923848e+01, -1.914224043532825e+01},
	{"MHL", -2.841855669718775e+01, -1.644101158327751e+01},
	{"MHM", -2.741859672064324e+01, -1.544105160673301e+01},
	{"MHN", -2.833048523269977e+01, -1.635294011878954e+01},
	{"MHO", -1.519484829230407e+01, -3.217303178393840e+00},
	{"MHP", -2.826332028456597e+01, -1.628577517065574e+01},
	{"MHQ", -3.255218005241005e+01, -2.057463493849982e+01},
	{"MHR", -2.621848579062532e+01, -1.424094067671509e+01},
	{"MHS", -2.356443967561892e+01, -1.158689456170868e+01},
	{"MHT", -2.185887570951574e+01, -9.881330595605506e+00},
	{"MHU", -1.790681410118716e+01, -5.929268987276925e+00},
	{"MHV", -3.103491674965028e+01, -1.905737163574005e+01},
	{"MHW", -2.700563731036453e+01, -1.502809219645429e+01},
	{"MHX", -3.654811708135321e+01, -2.457057196744298e+01},
	{"MHY", -2.206267048871343e+01, -1.008512537480320e+01},
	{"MHZ", -3.355999932722692e+01, -2.158245421331669e+01},
	{"MIA", -1.478878001319610e+01, -6.122607952425136e+00},
	{"MIB", -1.870700192861914e+01, -1.004082986784818e+01},
	{"MIC", -1.362528066285969e+01, -4.959108602088731e+00},
	{"MID", -1.302356332361726e+01, -4.357391262846298e+00},
	{"MIE", -1.397564656305299e+01, -5.309474502282026e+00},
	{"MIF", -1.564965600042898e+01, -6.983483939658021e+00},
	{"MIG", -1.219923820412583e+01, -3.533066143354868e+00},
	{"MIH", -1.641406710482734e+01, -7.747895044056376e+00},
	{"MII", -1.858740848999097e+01, -9.921236429220007e+00},
	{"MIJ", -2.139435661282145e+01, -1.272818455205049e+01},
	{"MIK", -1.762827735604701e+01, -8.962105295276055e+00},
	{"MIL", -1.150979835303035e+01, -2.843626292259385e+00},
	{"MIM", -1.663053214058839e+01, -7.964360079817430e+00},
	{"MIN", -1.022548162876248e+01, -1.559309567991515e+00},
	{"MIO", -1.856578284377190e+01, -9.899610783000934e+00},
	{"MIP", -1.924368821018084e+01, -1.057751614940988e+01},
	{"MIQ", -2.171091651107961e+01, -1.304474445030865e+01},
	{"MIR", -1.424683758794381e+01, -5.580665527172852e+00},
	{"MIS", -1.158555174772847e+01, -2.919379686957507e+00},
	{"MIT", -1.170850021078464e+01, -3.042328150013678e+00},
	{"MIU", -1.776183912744465e+01, -9.095667066673689e+00},
	{"MIV", -2.017295640342136e+01, -1.150678434265040e+01},
	{"MIW", -1.676294063017315e+01, -8.096768569402190e+00},
	{"MIX", -1.552372435463728e+01, -6.857552293866316e+00},
	{"MIY", -2.171811514240938e+01, -1.305194308163842e+01},
	{"MIZ", -1.707337341172120e+01, -8.407201350950240e+00},
	{"MJA", -1.838168978384769e+01, -2.944728979639653e+00},
	{"MJB", -2.139291510787140e+01, -5.955954303663355e+00},
	{"MJC", -2.370156066004724e+01, -8.264599855839197e+00},
	{"MJD", -3.172668543814951e+01, -1.628972463394147e+01},
	{"MJE", -1.729471966686359e+01, -1.857758862655551e+00},
	{"MJF", -3.085037133455380e+01, -1.541341053034576e+01},
	{"MJG", -3.043491223069308e+01, -1.499795142648503e+01},
	{"MJH", -2.962105523738518e+01, -1.418409443317714e+01},
	{"MJI", -2.051207361755864e+01, -5.075112813350600e+00},
	{"MJJ", -2.962684795368473e+01, -1.418988714947669e+01},
	{"MJK", -3.231541946155602e+01, -1.687845865734798e+01},
	{"MJL", -3.081491442034320e+01, -1.537795361613516e+01},
	{"MJM", -3.118017770452008e+01, -1.574321690031204e+01},
	{"MJN", -3.413024743317271e+01, -1.869328662896466e+01},
	{"MJO", -1.787483024554664e+01, -2.437869441338598e+00},
	{"MJP", -2.271617387248426e+01, -7.279213068276220e+00},
	{"MJQ", -3.357828170826500e+01, -1.814132090405695e+01},
	{"MJR", -2.979784994360255e+01, -1.436088913939451e+01},
	{"MJS", -2.213214324116833e+01, -6.695182436960285e+00},
	{"MJT", -3.032872236265595e+01, -1.489176155844791e+01},
	{"MJU", -1.697574277280704e+01, -1.538781968599002e+00},
	{"MJV", -3.719733492786585e+01, -2.176037412365781e+01},
	{"MJW", -2.957159097143682e+01, -1.413463016722879e+01},
	{"MJX", -3.987664033493468e+01, -2.443967953072664e+01},
	{"MJY", -3.634651108577929e+01, -2.090955028157125e+01},
	{"MJZ", -3.445151217923772e+01, -1.901455137502968e+01},
	{"MKA", -1.974680606088844e+01, -4.001402992571278e+00},
	{"MKB", -2.647920207948361e+01, -1.073379901116645e+01},
	{"MKC", -2.691091463788184e+01, -1.116551156956468e+01},
	{"MKD", -2.754474460799253e+01, -1.179934153967537e+01},
	{"MKE", -1.836367908107146e+01, -2.618276012754295e+00},
	{"MKF", -2.637607135140538e+01, -1.063066828308821e+01},
	{"MKG", -2.864867212872253e+01, -1.290326906040536e+01},
	{"MKH", -2.345988499755509e+01, -7.714481929237925e+00},
	{"MKI", -1.687284751043675e+01, -1.127444442119581e+00},
	{"MKJ", -3.022684661012297e+01, -1.448144354180580e+01},
	{"MKK", -2.955468654090815e+01, -1.380928347259099e+01},
	{"MKL", -2.593720526270268e+01, -1.019180219438552e+01},
	{"MKM", -2.691157390464740e+01, -1.116617083633024e+01},
	{"MKN", -1.772209025320597e+01, -1.976687184888810e+00},
	{"MKO", -2.453671497342809e+01, -8.791311905110931e+00},
	{"MKP", -2.726172059232171e+01, -1.151631752400455e+01},
	{"MKQ", -3.290598640469604e+01, -1.716058333637888e+01},
	{"MKR", -2.039160546021640e+01, -4.646202391899235e+00},
	{"MKS", -2.381642412783082e+01, -8.071021059513656e+00},
	{"MKT", -2.458131163501000e+01, -8.835908566692837e+00},
	{"MKU", -2.351700534820017e+01, -7.771602279883008e+00},
	{"MKV", -3.006700167596766e+01, -1.432159860765050e+01},
	{"MKW", -2.575281989895990e+01, -1.000741683064274e+01},
	{"MKX", -3.387803327058931e+01, -1.813263020227214e+01},
	{"MKY", -2.642304103565059e+01, -1.067763796733343e+01},
	{"MKZ", -3.197989615645904e+01, -1.623449308814188e+01},
	{"MLA", -1.630763820575401e+01, -3.043149615995246e+00},
	{"MLB", -2.541895415335211e+01, -1.215446556359334e+01},
	{"MLC", -2.133989030312122e+01, -8.075401713362455e+00},
	{"MLD", -2.084937578880124e+01, -7.584887199042479e+00},
	{"MLE", -1.535118962925062e+01, -2.086701039491858e+00},
	{"MLF", -2.247654505351736e+01, -9.212056463758589e+00},
	{"MLG", -2.685506550363220e+01, -1.359057691387344e+01},
	{"MLH", -2.109382873512737e+01, -7.829340145368599e+00},
	{"MLI", -1.495616560635302e+01, -1.691677016594251e+00},
	{"MLJ", -2.270645827858160e+01, -9.441969688822834e+00},
	{"MLK", -2.685939002423070e+01, -1.359490143447193e+01},
	{"MLL", -1.901574832922206e+01, -5.751259739463290e+00},
	{"MLM", -2.164312533966355e+01, -8.378636749904780e+00},
	{"MLN", -2.664356501871319e+01, -1.337907642895442e+01},
	{"MLO", -1.618047608459226e+01, -2.915987494833498e+00},
	{"MLP", -2.256982746683676e+01, -9.305338877077991e+00},
	{"MLQ", -3.067579737575028e+01, -1.741130878599152e+01},
	{"MLR", -2.644997904960424e+01, -1.318549045984547e+01},
	{"MLS", -2.228148326675169e+01, -9.016994676992926e+00},
	{"MLT", -2.013203972309458e+01, -6.867551133335811e+00},
	{"MLU", -1.967739786596434e+01, -6.412909276205576e+00},
	{"MLV", -2.109195042026892e+01, -7.827461830510157e+00},
	{"MLW", -2.164222225444187e+01, -8.377733664683099e+00},
	{"MLX", -3.397776555987777e+01, -2.071327697011901e+01},
	{"MLY", -1.619259701243285e+01, -2.928108422674081e+00},
	{"MLZ", -3.263925603299354e+01, -1.937476744323478e+01},
	{"MMA", -1.217992476137301e+01, -1.892968726921005e+00},
	{"MMB", -2.227142535741336e+01, -1.198446932296135e+01},
	{"MMC", -2.053005173424504e+01, -1.024309569979304e+01},
	{"MMD", -1.925251622623311e+01, -8.965560191781110e+00},
	{"MME", -1.221824190909523e+01, -1.931285874643230e+00},
	{"MMF", -2.630663804138781e+01, -1.601968200693581e+01},
	{"MMG", -2.268115880277223e+01, -1.239420276832023e+01},
	{"MMH", -2.203348463885589e+01, -1.174652860440389e+01},
	{"MMI", -1.312345180305119e+01, -2.836495768599189e+00},
	{"MMJ", -2.938461859050707e+01, -1.909766255605507e+01},
	{"MMK", -2.969223582582444e+01, -1.940527979137244e+01},
	{"MML", -2.721484301084963e+01, -1.692788697639763e+01},
	{"MMM", -2.295518807648602e+01, -1.266823204203402e+01},
	{"MMN", -2.259286270487436e+01, -1.230590667042236e+01},
	{"MMO", -1.290714925659799e+01, -2.620193222145994e+00},
	{"MMP", -2.162345202698610e+01, -1.133649599253410e+01},
	{"MMQ", -3.230484386447223e+01, -2.201788783002023e+01},
	{"MMR", -1.846556964589208e+01, -8.178613611440079e+00},
	{"MMS", -2.095737543015382e+01, -1.067041939570182e+01},
	{"MMT", -1.981626627381188e+01, -9.529310239359880e+00},
	{"MMU", -1.399489271430923e+01, -3.707936679857232e+00},
	{"MMV", -2.903640278393337e+01, -1.874944674948137e+01},
	{"MMW", -2.550075589823566e+01, -1.521379986378366e+01},
	{"MMX", -3.394453332142569e+01, -2.365757728697370e+01},
	{"MMY", -1.393766621795376e+01, -3.650710183501760e+00},
	{"MMZ", -3.257360744045258e+01, -2.228665140600058e+01},
	{"MNA", -1.507685575717058e+01, -2.854740833501317e+00},
	{"MNB", -1.969506318989277e+01, -7.472948266223513e+00},
	{"MNC", -2.039725984385021e+01, -8.175144920180957e+00},
	{"MND", -1.968418834976782e+01, -7.462073426098561e+00},
	{"MNE", -1.437003348315774e+01, -2.147918559488486e+00},
	{"MNF", -1.911497320977556e+01, -6.892858286106304e+00},
	{"MNG", -2.159153660118706e+01, -9.369421677517797e+00},
	{"MNH", -1.857368208077488e+01, -6.351567157105618e+00},
	{"MNI", -1.504927339759555e+01, -2.827158473926293e+00},
	{"MNJ", -2.781255119613386e+01, -1.559043627246460e+01},
	{"MNK", -2.647096105839412e+01, -1.424884613472486e+01},
	{"MNL", -1.831847276863565e+01, -6.096357844966393e+00},
	{"MNM", -1.945303716761289e+01, -7.230922243943637e+00},
	{"MNN", -2.107693983634410e+01, -8.854824912674836e+00},
	{"MNO", -1.378075926295200e+01, -1.558644339282739e+00},
	{"MNP", -1.931484912362933e+01, -7.092734199960071e+00},
	{"MNQ", -2.872453131000075e+01, -1.650241638633149e+01},
	{"MNR", -1.880622381884180e+01, -6.584108895172539e+00},
	{"MNS", -1.690610872143495e+01, -4.683993797765694e+00},
	{"MNT", -1.792044502764965e+01, -5.698330103980392e+00},
	{"MNU", -1.906143784968918e+01, -6.839322926019926e+00},
	{"MNV", -2.357427031897230e+01, -1.135215539530305e+01},
	{"MNW", -1.960332824539048e+01, -7.381213321721219e+00},
	{"MNX", -3.078110545218345e+01, -1.855899052851419e+01},
	{"MNY", -2.009512361320463e+01, -7.873008689535373e+00},
	{"MNZ", -3.128981049596304e+01, -1.906769557229379e+01},
	{"MOA", -1.552689242729612e+01, -7.022394208966014e+00},
	{"MOB", -1.624802215366327e+01, -7.743523935333172e+00},
	{"MOC", -1.459618753928411e+01, -6.091689320954005e+00},
	{"MOD", -1.368717853938284e+01, -5.182680321052737e+00},
	{"MOE", -1.822089979991042e+01, -9.716401581580319e+00},
	{"MOF", -1.263160962836058e+01, -4.127111410030479e+00},
	{"MOG", -1.900619026046895e+01, -1.050169204213885e+01},
	{"MOH", -1.785328663418075e+01, -9.348788415850647e+00},
	{"MOI", -1.612360541970359e+01, -7.619107201373486e+00},
	{"MOJ", -2.359626700811765e+01, -1.509176878978755e+01},
	{"MOK", -1.568397347171169e+01, -7.179475253381588e+00},
	{"MOL", -1.514541742937248e+01, -6.640919211042379e+00},
	{"MOM", -1.399652226676879e+01, -5.492024048438691e+00},
	{"MON", -1.058162224355011e+01, -2.077124025220006e+00},
	{"MOO", -1.470259933698030e+01, -6.198101118650194e+00},
	{"MOP", -1.720083461477418e+01, -8.696336396444076e+00},
	{"MOQ", -2.090958160087759e+01, -1.240508338254748e+01},
	{"MOR", -1.060871044122909e+01, -2.104212222898985e+00},
	{"MOS", -1.144763236842385e+01, -2.943134150093747e+00},
	{"MOT", -1.244040610772106e+01, -3.935907889390956e+00},
	{"MOU", -1.172407780502499e+01, -3.219579586694885e+00},
	{"MOV", -1.280178734853426e+01, -4.297289130204155e+00},
	{"MOW", -1.931692635127563e+01, -1.081242813294553e+01},
	{"MOX", -2.212216197993925e+01, -1.361766376160915e+01},
	{"MOY", -2.165669222510152e+01, -1.315219400677141e+01},
	{"MOZ", -1.963043346109196e+01, -1.112593524276186e+01},
	{"MPA", -1.187447825020256e+01, -2.455419120825511e+00},
	{"MPB", -1.773995325648740e+01, -8.320894127110355e+00},
	{"MPC", -1.946804912019077e+01, -1.004898999081372e+01},
	{"MPD", -1.939503507152250e+01, -9.975975942145451e+00},
	{"MPE", -1.224256843682845e+01, -2.823509307451405e+00},
	{"MPF", -1.785908483470206e+01, -8.440025705325008e+00},
	{"MPG", -1.901613862179109e+01, -9.597079492414043e+00},
	{"MPH", -1.415854160709017e+01, -4.739482477713121e+00},
	{"MPI", -1.413124900021395e+01, -4.712189870836906e+00},
	{"MPJ", -2.371049772706758e+01, -1.429143859769053e+01},
	{"MPK", -2.071770654753237e+01, -1.129864741815532e+01},
	{"MPL", -1.154536217950995e+01, -2.126303050132901e+00},
	{"MPM", -1.722502355551866e+01, -7.805964426141618e+00},
	{"MPN", -2.071379976727795e+01, -1.129474063790090e+01},
	{"MPO", -1.235228855131818e+01, -2.933229421941130e+00},
	{"MPP", -1.917789440604400e+01, -9.758835276666950e+00},
	{"MPQ", -2.371530202297785e+01, -1.429624289360080e+01},
	{"MPR", -1.308328242113160e+01, -3.664223291754556e+00},
	{"MPS", -1.502356243791383e+01, -5.604503308536787e+00},
	{"MPT", -1.294055009914396e+01, -3.521490969766914e+00},
	{"MPU", -1.430509991460818e+01, -4.886040785231133e+00},
	{"MPV", -2.212970914105016e+01, -1.271065001167311e+01},
	{"MPW", -1.783326183958109e+01, -8.414202710204044e+00},
	{"MPX", -3.591811591356184e+01, -2.649905678418480e+01},
	{"MPY", -1.862341230500616e+01, -9.204353175629111e+00},
	{"MPZ", -3.422323153901294e+01, -2.480417240963589e+01},
	{"MQA", -2.935830042918902e+01, -1.100458063045440e+01},
	{"MQB", -3.198572237633130e+01, -1.363200257759668e+01},
	{"MQC", -3.089672159422818e+01, -1.254300179549356e+01},
	{"MQD", -3.250742623642122e+01, -1.415370643768660e+01},
	{"MQE", -3.289532078056547e+01, -1.454160098183085e+01},
	{"MQF", -3.124186280270941e+01, -1.288814300397478e+01},
	{"MQG", -3.797104915420358e+01, -1.961732935546896e+01},
	{"MQH", -3.180578383668120e+01, -1.345206403794658e+01},
	{"MQI", -2.769734444457326e+01, -9.343624645838640e+00},
	{"MQJ", -3.377109561182300e+01, -1.541737581308838e+01},
	{"MQK", -3.960323434914232e+01, -2.124951455040770e+01},
	{"MQL", -3.224817141012421e+01, -1.389445161138958e+01},
	{"MQM", -3.142578456798352e+01, -1.307206476924890e+01},
	{"MQN", -3.425510194495227e+01, -1.590138214621764e+01},
	{"MQO", -3.245154777567770e+01, -1.409782797694308e+01},
	{"MQP", -3.245373316210356e+01, -1.410001336336894e+01},
	{"MQQ", -3.433513611084066e+01, -1.598141631210603e+01},
	{"MQR", -3.230043661355542e+01, -1.394671681482080e+01},
	{"MQS", -2.937274876884417e+01, -1.101902897010955e+01},
	{"MQT", -2.987241977277848e+01, -1.151869997404386e+01},
	{"MQU", -1.835943129347013e+01, -5.711494735507398e-03},
	{"MQV", -3.516628979119393e+01, -1.681256999245931e+01},
	{"MQW", -3.152454261534021e+01, -1.317082281660559e+01},
	{"MQX", -4.162636630702526e+01, -2.327264650829064e+01},
	{"MQY", -3.581908650847204e+01, -1.746536670973742e+01},
	{"MQZ", -4.276593374377579e+01, -2.441221394504117e+01},
	{"MRA", -1.591451790593649e+01, -3.321412849259292e+00},
	{"MRB", -1.638513552279072e+01, -3.792030466113525e+00},
	{"MRC", -1.699667767275670e+01, -4.403572616079510e+00},
	{"MRD", -1.939142355733789e+01, -6.798318500660702e+00},
	{"MRE", -1.494064150557445e+01, -2.347536448897257e+00},
	{"MRF", -1.952395680473648e+01, -6.930851748059288e+00},
	{"MRG", -1.977341753597613e+01, -7.180312479298935e+00},
	{"MRH", -1.623184531311094e+01, -3.638740256433748e+00},
	{"MRI", -1.658397450227851e+01, -3.990869445601315e+00},
	{"MRJ", -1.804506455260477e+01, -5.451959495927579e+00},
	{"MRK", -1.952327752670367e+01, -6.930172470026470e+00},
	{"MRL", -1.930239876927156e+01, -6.709293712594365e+00},
	{"MRM", -1.826912802195039e+01, -5.676022965273193e+00},
	{"MRN", -2.044520457660378e+01, -7.852099519926586e+00},
	{"MRO", -1.622925915754794e+01, -3.636154100870745e+00},
	{"MRP", -1.870547729351159e+01, -6.112372236834398e+00},
	{"MRQ", -2.988781392227348e+01, -1.729470886559628e+01},
	{"MRR", -1.861073978817857e+01, -6.017634731501373e+00},
	{"MRS", -1.525647996542577e+01, -2.663374908748581e+00},
	{"MRT", -1.919474688484453e+01, -6.601641828167338e+00},
	{"MRU", -1.775306752845991e+01, -5.159962471782715e+00},
	{"MRV", -2.086387758400733e+01, -8.270772527330138e+00},
	{"MRW", -1.718925122808097e+01, -4.596146171403771e+00},
	{"MRX", -3.054517813627547e+01, -1.795207307959828e+01},
	{"MRY", -2.221632123323170e+01, -9.623216176554507e+00},
	{"MRZ", -3.146929836428368e+01, -1.887619330760649e+01},
	{"MSA", -1.303589151854483e+01, -2.911233049031372e+00},
	{"MSB", -1.628851411275134e+01, -6.163855643237876e+00},
	{"MSC", -1.612811968465491e+01, -6.003461215141453e+00},
	{"MSD", -1.712931172503421e+01, -7.004653255520750e+00},
	{"MSE", -1.182689024971015e+01, -1.702231780196693e+00},
	{"MSF", -1.602179906885371e+01, -5.897140599340247e+00},
	{"MSG", -1.767043850930008e+01, -7.545780039786624e+00},
	{"MSH", -1.417768264649517e+01, -4.053024176981708e+00},
	{"MSI", -1.462593455413963e+01, -4.501276084626171e+00},
	{"MSJ", -2.025365197792366e+01, -1.012899350841020e+01},
	{"MSK", -1.918637798673759e+01, -9.061719517224125e+00},
	{"MSL", -1.667002345990625e+01, -6.545364990392793e+00},
	{"MSM", -1.650469098899665e+01, -6.380032519483193e+00},
	{"MSN", -1.746431513548669e+01, -7.339656665973235e+00},
	{"MSO", -1.292961554721268e+01, -2.804957077699218e+00},
	{"MSP", -1.581261359422207e+01, -5.687955124708608e+00},
	{"MSQ", -2.039018540596432e+01, -1.026552693645086e+01},
	{"MSR", -1.762510405021515e+01, -7.500445580701692e+00},
	{"MSS", -1.580072559584046e+01, -5.676067126326999e+00},
	{"MST", -1.329286396091475e+01, -3.168205491401291e+00},
	{"MSU", -1.531813547166628e+01, -5.193477002152816e+00},
	{"MSV", -1.954257856039901e+01, -9.417920090885552e+00},
	{"MSW", -1.503952360673823e+01, -4.914865137224776e+00},
	{"MSX", -3.021761809121708e+01, -2.009295962170362e+01},
	{"MSY", -1.875683012493685e+01, -8.632171655423397e+00},
	{"MSZ", -2.271583768702544e+01, -1.259117921751198e+01},
	{"MTA", -1.665290909149643e+01, -6.819050118698914e+00},
	{"MTB", -2.635623242131314e+01, -1.652237344851563e+01},
	{"MTC", -1.945920654764570e+01, -9.625347574848181e+00},
	{"MTD", -2.707813386294456e+01, -1.724427489014704e+01},
	{"MTE", -1.668079642481068e+01, -6.846937452013166e+00},
	{"MTF", -2.658655089335110e+01, -1.675269192055358e+01},
	{"MTG", -2.752818579646815e+01, -1.769432682367064e+01},
	{"MTH", -1.020928058741103e+01, -3.754216146135082e-01},
	{"MTI", -1.645669662016469e+01, -6.622837647367175e+00},
	{"MTJ", -2.968369308634311e+01, -1.984983411354559e+01},
	{"MTK", -2.951395185870267e+01, -1.968009288590515e+01},
	{"MTL", -2.593087360491209e+01, -1.609701463211458e+01},
	{"MTM", -2.643968039856366e+01, -1.660582142576614e+01},
	{"MTN", -2.712000298529338e+01, -1.728614401249586e+01},
	{"MTO", -1.243571388417892e+01, -2.601854911381400e+00},
	{"MTP", -2.719163995060331e+01, -1.735778097780579e+01},
	{"MTQ", -3.165025729353147e+01, -2.181639832073395e+01},
	{"MTR", -1.577284082860872e+01, -5.938981855811197e+00},
	{"MTS", -2.306274732928246e+01, -1.322888835648494e+01},
	{"MTT", -2.143709204545922e+01, -1.160323307266171e+01},
	{"MTU", -1.659648002472372e+01, -6.762621051926201e+00},
	{"MTV", -2.963587196499405e+01, -1.980201299219654e+01},
	{"MTW", -1.667029741721020e+01, -6.836438444412678e+00},
	{"MTX", -3.435606008029508e+01, -2.452220110749757e+01},
	{"MTY", -2.035594568241262e+01, -1.052208670961511e+01},
	{"MTZ", -3.181056580628753e+01, -2.197670683349001e+01},
	{"MUA", -2.044642025179726e+01, -1.010289139847821e+01},
	{"MUB", -2.470186495685806e+01, -1.435833610353901e+01},
	{"MUC", -1.251617131266691e+01, -2.172642459347857e+00},
	{"MUD", -1.659438016469835e+01, -6.250851311379295e+00},
	{"MUE", -1.594634559547971e+01, -5.602816742160664e+00},
	{"MUF", -1.832074044489526e+01, -7.977211591576211e+00},
	{"MUG", -1.920046109296032e+01, -8.856932239641271e+00},
	{"MUH", -2.110860932815633e+01, -1.076508047483728e+01},
	{"MUI", -2.098859224184670e+01, -1.064506338852765e+01},
	{"MUJ", -3.124492357953454e+01, -2.090139472621549e+01},
	{"MUK", -2.361400388420576e+01, -1.327047503088671e+01},
	{"MUL", -1.342190993334538e+01, -3.078381080026331e+00},
	{"MUM", -1.660253257220348e+01, -6.259003718884431e+00},
	{"MUN", -1.341276226961639e+01, -3.069233416297339e+00},
	{"MUO", -2.362342212105119e+01, -1.327989326773214e+01},
	{"MUP", -1.527097684615367e+01, -4.927447992834618e+00},
	{"MUQ", -3.270652753056992e+01, -2.236299867725087e+01},
	{"MUR", -1.408747751803064e+01, -3.743948664711592e+00},
	{"MUS", -1.189253919678018e+01, -1.549010343461134e+00},
	{"MUT", -1.527116872132585e+01, -4.927639868006795e+00},
	{"MUU", -3.004969556389429e+01, -1.970616671057523e+01},
	{"MUV", -2.938851752962371e+01, -1.904498867630467e+01},
	{"MUW", -2.168395508270767e+01, -1.134042622938861e+01},
	{"MUX", -2.966748407457624e+01, -1.932395522125719e+01},
	{"MUY", -2.269792036378649e+01, -1.235439151046744e+01},
	{"MUZ", -1.885981086116504e+01, -8.516282007845991e+00},
	{"MVA", -1.797418423023430e+01, -2.886183260694506e+00},
	{"MVB", -3.326335349858331e+01, -1.817535252904352e+01},
	{"MVC", -3.345270982592351e+01, -1.836470885638372e+01},
	{"MVD", -3.270778195966754e+01, -1.761978099012775e+01},
	{"MVE", -1.650773501062596e+01, -1.419734041086168e+00},
	{"MVF", -3.291212920495508e+01, -1.782412823541529e+01},
	{"MVG", -3.422052159227656e+01, -1.913252062273677e+01},
	{"MVH", -3.193536256770502e+01, -1.684736159816522e+01},
	{"MVI", -1.627499707075864e+01, -1.186996101218848e+00},
	{"MVJ", -3.414337929291718e+01, -1.905537832337739e+01},
	{"MVK", -3.602297991569549e+01, -2.093497894615571e+01},
	{"MVL", -3.329522298738100e+01, -1.820722201784121e+01},
	{"MVM", -3.230568576900916e+01, -1.721768479946937e+01},
	{"MVN", -3.140409365447756e+01, -1.631609268493777e+01},
	{"MVO", -1.936748157531730e+01, -4.279480605777507e+00},
	{"MVP", -3.235105679554199e+01, -1.726305582600220e+01},
	{"MVQ", -3.997517468903099e+01, -2.488717371949119e+01},
	{"MVR", -3.033436832118176e+01, -1.524636735164197e+01},
	{"MVS", -3.135850043417594e+01, -1.627049946463615e+01},
	{"MVT", -3.067954621917976e+01, -1.559154524963997e+01},
	{"MVU", -3.027401829723034e+01, -1.518601732769054e+01},
	{"MVV", -3.486875185464186e+01, -1.978075088510207e+01},
	{"MVW", -3.199031451795652e+01, -1.690231354841672e+01},
	{"MVX", -3.660099550612765e+01, -2.151299453658785e+01},
	{"MVY", -2.842383794209821e+01, -1.333583697255842e+01},
	{"MVZ", -4.001087438868536e+01, -2.492287341914557e+01},
	{"MWA", -1.433594329228233e+01, -2.786311459784285e+00},
	{"MWB", -2.877308580556892e+01, -1.722345397307087e+01},
	{"MWC", -2.883097742449620e+01, -1.728134559199816e+01},
	{"MWD", -2.834446742461993e+01, -1.679483559212188e+01},
	{"MWE", -1.437833734274569e+01, -2.828705510247646e+00},
	{"MWF", -2.862605521075565e+01, -1.707642337825760e+01},
	{"MWG", -2.975279864074131e+01, -1.820316680824326e+01},
	{"MWH", -1.294284859707289e+01, -1.393216764574848e+00},
	{"MWI", -1.362158538093355e+01, -2.071953548435507e+00},
	{"MWJ", -3.110949310355872e+01, -1.955986127106068e+01},
	{"MWK", -3.126450556708474e+01, -1.971487373458669e+01},
	{"MWL", -2.769346534595060e+01, -1.614383351345255e+01},
	{"MWM", -2.839537006369370e+01, -1.684573823119565e+01},
	{"MWN", -2.526966002509046e+01, -1.372002819259242e+01},
	{"MWO", -1.502615560507948e+01, -3.476523772581427e+00},
	{"MWP", -2.948323373072361e+01, -1.793360189822556e+01},
	{"MWQ", -3.373685487743474e+01, -2.218722304493670e+01},
	{"MWR", -1.906880381552766e+01, -7.519171983029612e+00},
	{"MWS", -2.652983237386524e+01, -1.498020054136720e+01},
	{"MWT", -2.639985463900750e+01, -1.485022280650945e+01},
	{"MWU", -2.986646541248386e+01, -1.831683357998581e+01},
	{"MWV", -3.158702824007992e+01, -2.003739640758187e+01},
	{"MWW", -2.761904767917021e+01, -1.606941584667216e+01},
	{"MWX", -4.093066114356015e+01, -2.938102931106211e+01},
	{"MWY", -2.366970901448950e+01, -1.212007718199145e+01},
	{"MWZ", -3.445364479419931e+01, -2.290401296170127e+01},
	{"MXA", -2.495410974474156e+01, -4.960700489053476e+00},
	{"MXB", -2.952143435377601e+01, -9.528025098087925e+00},
	{"MXC", -2.448243401132616e+01, -4.489024755638076e+00},
	{"MXD", -2.891482250669596e+01, -8.921413251007872e+00},
	{"MXE", -2.313099886167072e+01, -3.137589605982639e+00},
	{"MXF", -2.905693197275146e+01, -9.063522717063373e+00},
	{"MXG", -3.035599651286721e+01, -1.036258725717913e+01},
	{"MXH", -2.671417033873053e+01, -6.720761083042445e+00},
	{"MXI", -2.455426644171480e+01, -4.560857186026721e+00},
	{"MXJ", -3.156896563889113e+01, -1.157555638320305e+01},
	{"MXK", -3.246705192933752e+01, -1.247364267364943e+01},
	{"MXL", -2.901428594616099e+01, -9.020876690472901e+00},
	{"MXM", -2.829747156415548e+01, -8.304062308467401e+00},
	{"MXN", -3.080648962071216e+01, -1.081308036502407e+01},
	{"MXO", -2.731184272723078e+01, -7.318433471542691e+00},
	{"MXP", -2.393023101791400e+01, -3.936821762225918e+00},
	{"MXQ", -3.046926128860428e+01, -1.047585203291619e+01},
	{"MXR", -2.908744868655754e+01, -9.094039430869454e+00},
	{"MXS", -2.837933414056862e+01, -8.385924884880538e+00},
	{"MXT", -2.146425744221069e+01, -1.470848186522611e+00},
	{"MXU", -2.759233147407743e+01, -7.598922218389347e+00},
	{"MXV", -2.721450472655552e+01, -7.221095470867439e+00},
	{"MXW", -2.277133516834219e+01, -2.777925912654105e+00},
	{"MXX", -2.276198721039437e+01, -2.768577954706285e+00},
	{"MXY", -2.818651977214083e+01, -8.193110516452739e+00},
	{"MXZ", -4.200628104150388e+01, -2.201287178581579e+01},
	{"MYA", -1.431048564160657e+01, -4.374322752053047e+00},
	{"MYB", -1.433517397237635e+01, -4.399011082822834e+00},
	{"MYC", -1.415870403529687e+01, -4.222541145743355e+00},
	{"MYD", -1.458517027452944e+01, -4.649007384975924e+00},
	{"MYE", -1.468505889663513e+01, -4.748896007081611e+00},
	{"MYF", -1.360137337762032e+01, -3.665210488066799e+00},
	{"MYG", -1.511372791486999e+01, -5.177565025316466e+00},
	{"MYH", -1.389074847129817e+01, -3.954585581744653e+00},
	{"MYI", -1.538081961107855e+01, -5.444656721525031e+00},
	{"MYJ", -1.671776589834751e+01, -6.781603008793994e+00},
	{"MYK", -1.752683375207473e+01, -7.590670862521210e+00},
	{"MYL", -1.419217069322490e+01, -4.256007803671384e+00},
	{"MYM", -1.453663970093771e+01, -4.600476811384192e+00},
	{"MYN", -1.535070450331851e+01, -5.414541613764988e+00},
	{"MYO", -1.392615432078543e+01, -3.989991431231914e+00},
	{"MYP", -1.412294351973205e+01, -4.186780630178526e+00},
	{"MYQ", -2.112774454529932e+01, -1.119158165574580e+01},
	{"MYR", -1.487447934142031e+01, -4.938316451866791e+00},
	{"MYS", -1.245881071855991e+01, -2.522647829006386e+00},
	{"MYT", -1.435299483542375e+01, -4.416831945870232e+00},
	{"MYU", -1.700103438229268e+01, -7.064871492739163e+00},
	{"MYV", -1.638686611108234e+01, -6.450703221528816e+00},
	{"MYW", -1.417893635255878e+01, -4.242773463005257e+00},
	{"MYX", -2.371010454807694e+01, -1.377394165852342e+01},
	{"MYY", -1.764862395409916e+01, -7.712461064545642e+00},
	{"MYZ", -2.171538716994552e+01, -1.177922428039200e+01},
	{"MZA", -2.071199697914700e+01, -2.089513604432036e+00},
	{"MZB", -2.881253793485470e+01, -1.019005456013974e+01},
	{"MZC", -2.969745275309628e+01, -1.107496937838131e+01},
	{"MZD", -3.005661859449911e+01, -1.143413521978414e+01},
	{"MZE", -2.009910777430592e+01, -1.476624399590956e+00},
	{"MZF", -2.964375016087370e+01, -1.102126678615874e+01},
	{"MZG", -3.016671933400092e+01, -1.154423595928596e+01},
	{"MZH", -2.878345646415081e+01, -1.016097308943584e+01},
	{"MZI", -2.097871434962324e+01, -2.356230974908272e+00},
	{"MZJ", -3.269044403615808e+01, -1.406796066144312e+01},
	{"MZK", -3.132594409654444e+01, -1.270346072182947e+01},
	{"MZL", -2.701617923319089e+01, -8.393695858475928e+00},
	{"MZM", -2.922443516288090e+01, -1.060195178816594e+01},
	{"MZN", -3.032726279150055e+01, -1.170477941678559e+01},
	{"MZO", -2.108889764645454e+01, -2.466414271739578e+00},
	{"MZP", -2.814282751173075e+01, -9.520344137015785e+00},
	{"MZQ", -3.660665792548143e+01, -1.798417455076646e+01},
	{"MZR", -2.735558416173312e+01, -8.733100787018158e+00},
	{"MZS", -2.897186263772892e+01, -1.034937926301396e+01},
	{"MZT", -2.747433918591236e+01, -8.851855811197394e+00},
	{"MZU", -2.687598280433970e+01, -8.253499429624734e+00},
	{"MZV", -2.977413872962573e+01, -1.115165535491076e+01},
	{"MZW", -2.843762590476159e+01, -9.815142530046629e+00},
	{"MZX", -3.941479448692627e+01, -2.079231111221130e+01},
	{"MZY", -2.785027373525194e+01, -9.227790360536977e+00},
	{"MZZ", -2.544515204040837e+01, -6.822668665693407e+00},
	{"NAA", -1.483890551798896e+01, -7.026363376942474e+00},
	{"NAB", -1.271062640590574e+01, -4.898084264859264e+00},
	{"NAC", -1.237447601263914e+01, -4.561933871592660e+00},
	{"NAD", -1.310950362079145e+01, -5.296961479744967e+00},
	{"NAE", -1.659866684874433e+01, -8.786124707697848e+00},
	{"NAF", -1.347405546472860e+01, -5.661513323682118e+00},
	{"NAG", -1.297852155864129e+01, -5.165979417594808e+00},
	{"NAH", -1.449193828859574e+01, -6.679396147549256e+00},
	{"NAI", -1.438093805069939e+01, -6.568395909652907e+00},
	{"NAJ", -1.825844440516806e+01, -1.044590226412158e+01},
	{"NAK", -1.527023828679097e+01, -7.457696145744491e+00},
	{"NAL", -1.076835841256714e+01, -2.955816271520658e+00},
	{"NAM", -1.159470627460800e+01, -3.782164133561518e+00},
	{"NAN", -9.751039243114812e+00, -1.938497102068332e+00},
	{"NAO", -1.708890091170860e+01, -9.276358770662124e+00},
	{"NAP", -1.335957305778682e+01, -5.547030916740337e+00},
	{"NAQ", -1.836018458910738e+01, -1.054764244806090e+01},
	{"NAR", -1.196448062299676e+01, -4.151938481950284e+00},
	{"NAS", -1.177176799137062e+01, -3.959225850324136e+00},
	{"NAT", -1.037220333743269e+01, -2.559661196386214e+00},
	{"NAU", -1.487232299318837e+01, -7.059780852141891e+00},
	{"NAV", -1.418613103444810e+01, -6.373588893401622e+00},
	{"NAW", -1.398187595992662e+01, -6.169333818880142e+00},
	{"NAX", -1.846960616324613e+01, -1.065706402219965e+01},
	{"NAY", -1.626190553900548e+01, -8.449363397958997e+00},
	{"NAZ", -1.748932368117703e+01, -9.676781540130547e+00},
	{"NBA", -1.425843049408319e+01, -4.048335827296257e+00},
	{"NBB", -2.262463647838192e+01, -1.241454181159499e+01},
	{"NBC", -1.589817176104130e+01, -5.688077094254368e+00},
	{"NBD", -2.861558616637156e+01, -1.840549149958462e+01},
	{"NBE", -1.133258520105150e+01, -1.122490534264573e+00},
	{"NBF", -3.020031746557565e+01, -1.999022279878872e+01},
	{"NBG", -3.178455850044690e+01, -2.157446383365997e+01},
	{"NBH", -2.368336596089283e+01, -1.347327129410589e+01},
	{"NBI", -1.626884768605825e+01, -6.058753019271321e+00},
	{"NBJ", -2.660342938468517e+01, -1.639333471789824e+01},
	{"NBK", -3.205876212017526e+01, -2.184866745338833e+01},
	{"NBL", -1.584826204513054e+01, -5.638167378343608e+00},
	{"NBM", -2.837730258142046e+01, -1.816720791463353e+01},
	{"NBN", -2.915635025557984e+01, -1.894625558879290e+01},
	{"NBO", -1.379093051121583e+01, -3.580835844428903e+00},
	{"NBP", -2.171378962398972e+01, -1.150369495720279e+01},
	{"NBQ", -3.563509197773497e+01, -2.542499731094803e+01},
	{"NBR", -1.420220672652808e+01, -3.992112059741149e+00},
	{"NBS", -2.129598859555135e+01, -1.108589392876442e+01},
	{"NBT", -2.036455214796868e+01, -1.015445748118175e+01},
	{"NBU", -1.300170628174448e+01, -2.791611614957543e+00},
	{"NBV", -2.984065982107309e+01, -1.963056515428616e+01},
	{"NBW", -2.212352681341958e+01, -1.191343214663265e+01},
	{"NBX", -3.921336103086293e+01, -2.900326636407600e+01},
	{"NBY", -1.312376683019829e+01, -2.913672163411359e+00},
	{"NBZ", -3.365314786099587e+01, -2.344305319420894e+01},
	{"NCA", -1.260763157247751e+01, -4.324539085739518e+00},
	{"NCB", -2.171156727510631e+01, -1.342847478836831e+01},
	{"NCC", -2.062305530015905e+01, -1.233996281342106e+01},
	{"NCD", -1.880996455189614e+01, -1.052687206515814e+01},
	{"NCE", -9.248163090372726e+00, -9.650706036347323e-01},
	{"NCF", -2.171082459488127e+01, -1.342773210814328e+01},
	{"NCG", -3.016146356388456e+01, -2.187837107714657e+01},
	{"NCH", -1.172662105566403e+01, -3.443528568926036e+00},
	{"NCI", -1.199628644029050e+01, -3.713193953552506e+00},
	{"NCJ", -2.271667874854172e+01, -1.443358626180373e+01},
	{"NCK", -1.963852987685812e+01, -1.135543739012012e+01},
	{"NCL", -1.250519635861325e+01, -4.222103871875255e+00},
	{"NCM", -2.139007433393255e+01, -1.310698184719456e+01},
	{"NCN", -2.370015366794298e+01, -1.541706118120499e+01},
	{"NCO", -1.131429236637282e+01, -3.031199879634827e+00},
	{"NCP", -2.112454385432365e+01, -1.284145136758566e+01},
	{"NCQ", -2.851593817099380e+01, -2.023284568425581e+01},
	{"NCR", -1.336026910656738e+01, -5.077176619829382e+00},
	{"NCS", -1.839318830216171e+01, -1.011009581542372e+01},
	{"NCT", -1.337218073203963e+01, -5.089088245301633e+00},
	{"NCU", -1.495453656081190e+01, -6.671444074073910e+00},
	{"NCV", -3.178107006033471e+01, -2.349797757359672e+01},
	{"NCW", -2.089643955422276e+01, -1.261334706748476e+01},
	{"NCX", -2.371663412442190e+01, -1.543354163768391e+01},
	{"NCY", -1.378337862264916e+01, -5.500286135911169e+00},
	{"NCZ", -2.371319977254731e+01, -1.543010728580931e+01},
	{"NDA", -9.637270779075452e+00, -3.493924699791260e+00},
	{"NDB", -1.116541572228900e+01, -5.022069643004809e+00},
	{"NDC", -1.120892557443056e+01, -5.065579495146372e+00},
	{"NDD", -1.145011530376416e+01, -5.306769224479964e+00},
	{"NDE", -9.536539205216116e+00, -3.393193125931924e+00},
	{"NDF", -1.120369252838627e+01, -5.060346449102082e+00},
	{"NDG", -1.220094953316071e+01, -6.057603453876521e+00},
	{"NDH", -1.030016861167336e+01, -4.156822532389169e+00},
	{"NDI", -9.557287064577412e+00, -3.413940985293221e+00},
	{"NDJ", -1.309390324302651e+01, -6.950557163742321e+00},
	{"NDK", -1.409300373573384e+01, -7.949657656449646e+00},
	{"NDL", -1.157497088164105e+01, -5.431624802356857e+00},
	{"NDM", -1.110741972145812e+01, -4.964073642173931e+00},
	{"NDN", -1.222320494381947e+01, -6.079858864535281e+00},
	{"NDO", -1.032274597683843e+01, -4.179399897554237e+00},
	{"NDP", -1.143416952342787e+01, -5.290823444143678e+00},
	{"NDQ", -1.619508894852190e+01, -1.005174286923771e+01},
	{"NDR", -1.129496109665174e+01, -5.151615017367545e+00},
	{"NDS", -9.571715578828556e+00, -3.428369499544365e+00},
	{"NDT", -8.741884284571057e+00, -2.598538205286867e+00},
	{"NDU", -1.174519610740306e+01, -5.601850028118865e+00},
	{"NDV", -1.406747789020620e+01, -7.924131810922014e+00},
	{"NDW", -1.045819384647753e+01, -4.314847767193339e+00},
	{"NDX", -2.091130657213804e+01, -1.476796049285385e+01},
	{"NDY", -1.286754933274504e+01, -6.724203253460846e+00},
	{"NDZ", -1.623491545815989e+01, -1.009156937887570e+01},
	{"NEA", -1.115270278853394e+01, -3.778297649963522e+00},
	{"NEB", -1.344446468879947e+01, -6.070059550229057e+00},
	{"NEC", -1.223995670662806e+01, -4.865551568057648e+00},
	{"NED", -1.025701952092862e+01, -2.882614382358202e+00},
	{"NEE", -1.254264832036488e+01, -5.168243181794472e+00},
	{"NEF", -1.332356257071337e+01, -5.949157432142949e+00},
	{"NEG", -1.350520049823995e+01, -6.130795359669532e+00},
	{"NEH", -1.299894648959563e+01, -5.624541351025215e+00},
	{"NEI", -1.193256304919242e+01, -4.558157910622008e+00},
	{"NEJ", -1.745107294626882e+01, -1.007666780769840e+01},
	{"NEK", -1.679837857812207e+01, -9.423973439551650e+00},
	{"NEL", -1.296375255308844e+01, -5.589347414518027e+00},
	{"NEM", -1.232753428556525e+01, -4.953129146994832e+00},
	{"NEN", -1.223573896416458e+01, -4.861333825594168e+00},
	{"NEO", -1.178887157352317e+01, -4.414466434952751e+00},
	{"NEP", -1.404687695034536e+01, -6.672471811774941e+00},
	{"NEQ", -1.589815612802971e+01, -8.523750989459295e+00},
	{"NER", -1.085779271297028e+01, -3.483387574399863e+00},
	{"NES", -1.019672882508775e+01, -2.822323686517338e+00},
	{"NET", -1.140003238508254e+01, -4.025627246512121e+00},
	{"NEU", -1.392567976319626e+01, -6.551274624625842e+00},
	{"NEV", -1.184900965021122e+01, -4.474604511640803e+00},
	{"NEW", -1.118697084459381e+01, -3.812565706023391e+00},
	{"NEX", -1.259387945989195e+01, -5.219474321321536e+00},
	{"NEY", -1.270725076880673e+01, -5.332845630236311e+00},
	{"NEZ", -1.681171486320084e+01, -9.437309724630424e+00},
	{"NFA", -1.328670401147933e+01, -3.322429460833807e+00},
	{"NFB", -2.617724880199783e+01, -1.621297425135231e+01},
	{"NFC", -2.337048139019218e+01, -1.340620683954666e+01},
	{"NFD", -2.647346871391515e+01, -1.650919416326963e+01},
	{"NFE", -1.340101287000885e+01, -3.436738319363326e+00},
	{"NFF", -1.863648299949498e+01, -8.672208448849457e+00},
	{"NFG", -2.612803823374854e+01, -1.616376368310302e+01},
	{"NFH", -2.492835807042236e+01, -1.496408351977684e+01},
	{"NFI", -1.260990165633944e+01, -2.645627105693912e+00},
	{"NFJ", -2.691633280769062e+01, -1.695205825704510e+01},
	{"NFK", -2.367713932652849e+01, -1.371286477588297e+01},
	{"NFL", -1.334648899216407e+01, -3.382214441518545e+00},
	{"NFM", -2.525969978471425e+01, -1.529542523406874e+01},
	{"NFN", -2.688125469228155e+01, -1.691698014163602e+01},
	{"NFO", -1.161063217095131e+01, -1.646357620305792e+00},
	{"NFP", -2.341115089116190e+01, -1.344687634051638e+01},
	{"NFQ", -3.105935914291273e+01, -2.109508459226721e+01},
	{"NFR", -1.253808554002365e+01, -2.573810989378132e+00},
	{"NFS", -2.325538043324744e+01, -1.329110588260192e+01},
	{"NFT", -2.137663441580445e+01, -1.141235986515893e+01},
	{"NFU", -1.399850980617348e+01, -4.034235255527953e+00},
	{"NFV", -2.809334143621717e+01, -1.812906688557165e+01},
	{"NFW", -2.584535853505951e+01, -1.588108398441399e+01},
	{"NFX", -3.337073064724623e+01, -2.340645609660071e+01},
	{"NFY", -2.206500069734415e+01, -1.210072614669863e+01},
	{"NFZ", -2.949932410677276e+01, -1.953504955612724e+01},
	{"NGA", -1.023931176664275e+01, -3.207055652006081e+00},
	{"NGB", -1.224040865906834e+01, -5.208152544431675e+00},
	{"NGC", -1.251226655629867e+01, -5.480010441661999e+00},
	{"NGD", -1.234689768717055e+01, -5.314641572533886e+00},
	{"NGE", -1.057070196453804e+01, -3.538445849901369e+00},
	{"NGF", -1.201563748972306e+01, -4.983381375086394e+00},
	{"NGG", -1.384797871188534e+01, -6.815722597248672e+00},
	{"NGH", -1.189965163162230e+01, -4.867395516985628e+00},
	{"NGI", -1.101514191802117e+01, -3.982885803384501e+00},
	{"NGJ", -1.571867210860629e+01, -8.686415993969620e+00},
	{"NGK", -1.600442142954376e+01, -8.972165314907087e+00},
	{"NGL", -1.129126576275838e+01, -4.259009648121713e+00},
	{"NGM", -1.233654879769391e+01, -5.304292683057246e+00},
	{"NGN", -1.374633459592065e+01, -6.714078481283983e+00},
	{"NGO", -1.069059224530427e+01, -3.658336130667602e+00},
	{"NGP", -1.244721346276778e+01, -5.414957348131112e+00},
	{"NGQ", -1.716409162970894e+01, -1.013183551507227e+01},
	{"NGR", -1.198828816167317e+01, -4.956032047036505e+00},
	{"NGS", -1.037548142296812e+01, -3.343225308331453e+00},
	{"NGT", -9.460545813670223e+00, -2.428289699033554e+00},
	{"NGU", -1.208035641333618e+01, -5.048100298699511e+00},
	{"NGV", -1.514881029118233e+01, -8.116554176545657e+00},
	{"NGW", -1.168903817956248e+01, -4.656782064925814e+00},
	{"NGX", -2.054873110854339e+01, -1.351647499390672e+01},
	{"NGY", -1.402488110607285e+01, -6.992624991436178e+00},
	{"NGZ", -2.013353491146373e+01, -1.310127879682706e+01},
	{"NHA", -1.195754232715111e+01, -2.278628746026739e+00},
	{"NHB", -2.360187677592521e+01, -1.392296319480084e+01},
	{"NHC", -2.725736330894834e+01, -1.757844972782398e+01},
	{"NHD", -2.363234911262370e+01, -1.395343553149933e+01},
	{"NHE", -1.125765897647424e+01, -1.578745395349877e+00},
	{"NHF", -2.360083473982428e+01, -1.392192115869992e+01},
	{"NHG", -2.825644815209330e+01, -1.857753457096893e+01},
	{"NHH", -2.619315216972173e+01, -1.651423858859737e+01},
	{"NHI", -1.131586253407797e+01, -1.636948952953599e+00},
	{"NHJ", -3.017487818122326e+01, -2.049596460009889e+01},
	{"NHK", -3.049100772896650e+01, -2.081209414784214e+01},
	{"NHL", -2.779610100297222e+01, -1.811718742184785e+01},
	{"NHM", -2.263583185070776e+01, -1.295691826958340e+01},
	{"NHN", -2.770809771800629e+01, -1.802918413688192e+01},
	{"NHO", -1.296588498759937e+01, -3.286971406475000e+00},
	{"NHP", -2.210243496899157e+01, -1.242352138786720e+01},
	{"NHQ", -3.193087607311223e+01, -2.225196249198786e+01},
	{"NHR", -2.337172352352484e+01, -1.369280994240047e+01},
	{"NHS", -2.624647995823183e+01, -1.656756637710747e+01},
	{"NHT", -1.896558669269837e+01, -9.286673111574002e+00},
	{"NHU", -1.469844949648380e+01, -5.019535915359436e+00},
	{"NHV", -2.271179488354988e+01, -1.303288130242551e+01},
	{"NHW", -2.166300384245029e+01, -1.198409026132592e+01},
	{"NHX", -3.592681310205540e+01, -2.624789952093102e+01},
	{"NHY", -1.884926620853881e+01, -9.170352627414447e+00},
	{"NHZ", -3.293869534792910e+01, -2.325978176680473e+01},
	{"NIA", -1.217299094286723e+01, -4.018458728501658e+00},
	{"NIB", -1.572862664405975e+01, -7.574094429694174e+00},
	{"NIC", -1.231708723029844e+01, -4.162555015932868e+00},
	{"NID", -1.546146201662600e+01, -7.306929802260423e+00},
	{"NIE", -1.312822231793259e+01, -4.973690103567012e+00},
	{"NIF", -1.306903733092601e+01, -4.914505116560437e+00},
	{"NIG", -1.253404136395491e+01, -4.379509149589333e+00},
	{"NIH", -1.563610673718826e+01, -7.481574522822680e+00},
	{"NII", -1.743245992410757e+01, -9.277927709741991e+00},
	{"NIJ", -1.836094395952184e+01, -1.020641174515626e+01},
	{"NIK", -1.796008322896155e+01, -9.805551014595981e+00},
	{"NIL", -1.469238766500956e+01, -6.537855450643980e+00},
	{"NIM", -1.291945906840786e+01, -4.764926854042284e+00},
	{"NIN", -9.839163302769052e+00, -1.684631088403476e+00},
	{"NIO", -1.287599468845294e+01, -4.721462474087360e+00},
	{"NIP", -1.582252807945430e+01, -7.667995865088727e+00},
	{"NIQ", -1.503572946632832e+01, -6.881197251962745e+00},
	{"NIR", -1.471280364960516e+01, -6.558271435239581e+00},
	{"NIS", -1.122888365725463e+01, -3.074351442889057e+00},
	{"NIT", -1.078671578632004e+01, -2.632183571954466e+00},
	{"NIU", -1.479660840457497e+01, -6.642076190209394e+00},
	{"NIV", -1.460329190951387e+01, -6.448759695148296e+00},
	{"NIW", -1.524655057555181e+01, -7.092018361186234e+00},
	{"NIX", -1.946623308668367e+01, -1.131170087231809e+01},
	{"NIY", -2.271746627946954e+01, -1.456293406510397e+01},
	{"NIZ", -1.387942740559842e+01, -5.724895191232840e+00},
	{"NJA", -1.480849774614966e+01, -2.437428261782299e+00},
	{"NJB", -2.839505703650102e+01, -1.602398755213365e+01},
	{"NJC", -2.368818559103737e+01, -1.131711610667001e+01},
	{"NJD", -3.112697712632288e+01, -1.875590764195551e+01},
	{"NJE", -1.474734647793683e+01, -2.376276993569470e+00},
	{"NJF", -3.025594457502329e+01, -1.788487509065593e+01},
	{"NJG", -2.270893012216912e+01, -1.033786063780176e+01},
	{"NJH", -2.270118726929655e+01, -1.033011778492918e+01},
	{"NJI", -1.879405101573753e+01, -6.422981531370167e+00},
	{"NJJ", -2.903876678179621e+01, -1.666769729742884e+01},
	{"NJK", -3.170988724450162e+01, -1.933881776013425e+01},
	{"NJL", -2.370350852844643e+01, -1.133243904407908e+01},
	{"NJM", -3.059209653263156e+01, -1.822102704826420e+01},
	{"NJN", -3.354216626128417e+01, -2.117109677691682e+01},
	{"NJO", -1.441804041774471e+01, -2.046970933377353e+00},
	{"NJP", -2.370078965472430e+01, -1.132972017035694e+01},
	{"NJQ", -3.294867220131415e+01, -2.057760271694679e+01},
	{"NJR", -2.171125269471717e+01, -9.340183210349812e+00},
	{"NJS", -2.369576955319528e+01, -1.132470006882792e+01},
	{"NJT", -2.974285784991409e+01, -1.737178836554673e+01},
	{"NJU", -1.382886712232059e+01, -1.457797637953230e+00},
	{"NJV", -3.660925375597732e+01, -2.423818427160996e+01},
	{"NJW", -2.368211979750126e+01, -1.131105031313390e+01},
	{"NJX", -3.928855916304615e+01, -2.691748967867879e+01},
	{"NJY", -3.575842991389077e+01, -2.338736042952340e+01},
	{"NJZ", -3.386343100734919e+01, -2.149236152298183e+01},
	{"NKA", -1.480168639623992e+01, -3.773372224288129e+00},
	{"NKB", -1.709990742724652e+01, -6.071593255294731e+00},
	{"NKC", -1.801245374270315e+01, -6.984139570751359e+00},
	{"NKD", -1.793390152650402e+01, -6.905587354552225e+00},
	{"NKE", -1.417771056878317e+01, -3.149396396831381e+00},
	{"NKF", -1.631537594066952e+01, -5.287061768717732e+00},
	{"NKG", -1.850694877819206e+01, -7.478634606240266e+00},
	{"NKH", -1.680728066800650e+01, -5.778966496054709e+00},
	{"NKI", -1.337501095537751e+01, -2.346696783425718e+00},
	{"NKJ", -2.139068176605202e+01, -1.036236759410023e+01},
	{"NKK", -2.366924976425033e+01, -1.264093559229854e+01},
	{"NKL", -1.501012116956250e+01, -3.981806997610704e+00},
	{"NKM", -1.737521508875805e+01, -6.346900916806265e+00},
	{"NKN", -1.484228871900469e+01, -3.813974547052897e+00},
	{"NKO", -1.454869753563079e+01, -3.520383363679003e+00},
	{"NKP", -1.812884374827640e+01, -7.100529576324611e+00},
	{"NKQ", -3.188258122555985e+01, -2.085426705360806e+01},
	{"NKR", -1.765014154126575e+01, -6.621827369313960e+00},
	{"NKS", -1.387838693796058e+01, -2.850072766008785e+00},
	{"NKT", -1.461540900995235e+01, -3.587094838000561e+00},
	{"NKU", -1.803789983672873e+01, -7.009585664776945e+00},
	{"NKV", -2.054509402866957e+01, -9.516779856717783e+00},
	{"NKW", -1.600823139356778e+01, -4.979917221615987e+00},
	{"NKX", -3.287431725007250e+01, -2.184600307812071e+01},
	{"NKY", -1.652610452068094e+01, -5.497790348729147e+00},
	{"NKZ", -3.097618013594223e+01, -1.994786596399044e+01},
	{"NLA", -1.342191562275997e+01, -2.988356830557977e+00},
	{"NLB", -2.557096124421423e+01, -1.513740245201224e+01},
	{"NLC", -2.087458012682407e+01, -1.044102133462208e+01},
	{"NLD", -2.348381188965140e+01, -1.305025309744941e+01},
	{"NLE", -1.314047890060870e+01, -2.706920108406707e+00},
	{"NLF", -2.249904462632835e+01, -1.206548583412635e+01},
	{"NLG", -2.700709721682052e+01, -1.657353842461853e+01},
	{"NLH", -2.643896044326329e+01, -1.600540165106129e+01},
	{"NLI", -1.296803408465355e+01, -2.534475292451560e+00},
	{"NLJ", -2.270771174409519e+01, -1.227415295189320e+01},
	{"NLK", -2.701142173741901e+01, -1.657786294521702e+01},
	{"NLL", -2.059081827763719e+01, -1.015725948543520e+01},
	{"NLM", -2.011073513685827e+01, -9.677176344656285e+00},
	{"NLN", -2.679559673190149e+01, -1.636203793969950e+01},
	{"NLO", -1.401542894573396e+01, -3.581870153531974e+00},
	{"NLP", -2.258407567808997e+01, -1.215051688588798e+01},
	{"NLQ", -3.082782908893859e+01, -2.039427029673660e+01},
	{"NLR", -2.660246367380847e+01, -1.616890488160647e+01},
	{"NLS", -2.122380330217115e+01, -1.079024450996916e+01},
	{"NLT", -2.217612240084821e+01, -1.174256360864622e+01},
	{"NLU", -1.762248896587923e+01, -7.188930173677246e+00},
	{"NLV", -2.350588694542238e+01, -1.307232815322039e+01},
	{"NLW", -2.606825838539152e+01, -1.563469959318953e+01},
	{"NLX", -3.412979727306608e+01, -2.369623848086409e+01},
	{"NLY", -1.157536886030693e+01, -1.141810068104940e+00},
	{"NLZ", -3.279128774618185e+01, -2.235772895397986e+01},
	{"NMA", -1.244756231597126e+01, -2.063256795158582e+00},
	{"NMB", -2.411430975385319e+01, -1.373000423304052e+01},
	{"NMC", -1.938802264669680e+01, -9.003717125884130e+00},
	{"NMD", -1.890583512847206e+01, -8.521529607659390e+00},
	{"NME", -1.187228178319682e+01, -1.487976262384147e+00},
	{"NMF", -2.624253834612044e+01, -1.585823282530777e+01},
	{"NMG", -2.789570588234098e+01, -1.751140036152831e+01},
	{"NMH", -2.586455165844525e+01, -1.548024613763257e+01},
	{"NMI", -1.374696483850110e+01, -3.362659317688423e+00},
	{"NMJ", -2.932065160405596e+01, -1.893634608324328e+01},
	{"NMK", -2.212591697147564e+01, -1.174161145066296e+01},
	{"NML", -2.168581913811504e+01, -1.130151361730237e+01},
	{"NMM", -1.974345682191949e+01, -9.359151301106818e+00},
	{"NMN", -2.108873350118656e+01, -1.070442798037388e+01},
	{"NMO", -1.341906691717768e+01, -3.034761396365011e+00},
	{"NMP", -2.249771891961682e+01, -1.211341339880414e+01},
	{"NMQ", -3.221587406632391e+01, -2.183156854551124e+01},
	{"NMR", -1.700258682395214e+01, -6.618281303139464e+00},
	{"NMS", -2.145091504545152e+01, -1.106660952463885e+01},
	{"NMT", -2.113421865141247e+01, -1.074991313059980e+01},
	{"NMU", -1.519646708419461e+01, -4.812161563381934e+00},
	{"NMV", -2.270007194633301e+01, -1.231576642552034e+01},
	{"NMW", -2.333584414111256e+01, -1.295153862029988e+01},
	{"NMX", -3.380434673788861e+01, -2.342004121707594e+01},
	{"NMY", -1.332768944521504e+01, -2.943383924402367e+00},
	{"NMZ", -3.250948991924998e+01, -2.212518439843731e+01},
	{"NNA", -1.373056928778544e+01, -3.395140956473741e+00},
	{"NNB", -2.035285681437782e+01, -1.001742848306612e+01},
	{"NNC", -1.999889526814784e+01, -9.663466936836141e+00},
	{"NND", -1.970241321796901e+01, -9.366984886657304e+00},
	{"NNE", -1.183485957617216e+01, -1.499431244860452e+00},
	{"NNF", -2.021198380005897e+01, -9.876555468747265e+00},
	{"NNG", -2.118307435724378e+01, -1.084764602593208e+01},
	{"NNH", -1.827754581157371e+01, -7.942117480262004e+00},
	{"NNI", -1.294535304989516e+01, -2.609924718583451e+00},
	{"NNJ", -2.070630341744545e+01, -1.037087508613375e+01},
	{"NNK", -2.165680544964878e+01, -1.132137711833708e+01},
	{"NNL", -2.085778433088182e+01, -1.052235599957012e+01},
	{"NNM", -1.988339974499435e+01, -9.547971413682642e+00},
	{"NNN", -2.161992282348560e+01, -1.128449449217389e+01},
	{"NNO", -1.213374497610003e+01, -1.798316644788332e+00},
	{"NNP", -2.087169396337276e+01, -1.053626563206106e+01},
	{"NNQ", -2.848192822940627e+01, -1.814649989809456e+01},
	{"NNR", -2.207171886699015e+01, -1.173629053567845e+01},
	{"NNS", -1.615922147398848e+01, -5.823793142676783e+00},
	{"NNT", -1.849759996682862e+01, -8.162171635516918e+00},
	{"NNU", -1.479014691729128e+01, -4.454718585979572e+00},
	{"NNV", -2.167460612814420e+01, -1.133917779683250e+01},
	{"NNW", -1.865741973528212e+01, -8.321991403970411e+00},
	{"NNX", -2.370596167192807e+01, -1.337053334061637e+01},
	{"NNY", -1.633172387805899e+01, -5.996295546747284e+00},
	{"NNZ", -3.103812664026965e+01, -2.070269830895795e+01},
	{"NOA", -1.465428368440302e+01, -7.168030994346943e+00},
	{"NOB", -1.338409898063267e+01, -5.897846290576592e+00},
	{"NOC", -1.360974626584025e+01, -6.123493575784173e+00},
	{"NOD", -1.458007939843285e+01, -7.093826708376775e+00},
	{"NOE", -1.519450453529824e+01, -7.708251845242165e+00},
	{"NOF", -9.754503806567488e+00, -2.268251116511414e+00},
	{"NOG", -1.571194644430257e+01, -8.225693754246498e+00},
	{"NOH", -1.556752038628551e+01, -8.081267696229430e+00},
	{"NOI", -1.396164180722866e+01, -6.475389117172585e+00},
	{"NOJ", -1.880765831263294e+01, -1.132140562257686e+01},
	{"NOK", -1.742876262407317e+01, -9.942509934017094e+00},
	{"NOL", -1.360385911330620e+01, -6.117606423250122e+00},
	{"NOM", -1.275976084661584e+01, -5.273508156559759e+00},
	{"NON", -1.171176463091598e+01, -4.225511940859908e+00},
	{"NOO", -1.423544348008722e+01, -6.749190790031141e+00},
	{"NOP", -1.372637269060360e+01, -6.240120000547519e+00},
	{"NOQ", -1.901786867299738e+01, -1.153161598294131e+01},
	{"NOR", -1.087263661595845e+01, -3.386383925902368e+00},
	{"NOS", -1.384548804345852e+01, -6.359235353402440e+00},
	{"NOT", -9.152282794717769e+00, -1.666030104661693e+00},
	{"NOU", -1.210548277334644e+01, -4.619230083290360e+00},
	{"NOV", -1.397819657470872e+01, -6.491943884652646e+00},
	{"NOW", -1.044557167522491e+01, -2.959318985168831e+00},
	{"NOX", -1.747041541397781e+01, -9.984162723921733e+00},
	{"NOY", -1.680980098133791e+01, -9.323548291281835e+00},
	{"NOZ", -2.025800861787650e+01, -1.277175592782043e+01},
	{"NPA", -1.321038322244986e+01, -2.336186338572044e+00},
	{"NPB", -2.774408811586326e+01, -1.686989123198545e+01},
	{"NPC", -2.863900449100700e+01, -1.776480760712919e+01},
	{"NPD", -2.917491662171151e+01, -1.830071973783370e+01},
	{"NPE", -1.372659603792006e+01, -2.852399154042246e+00},
	{"NPF", -2.363152372604138e+01, -1.275732684216356e+01},
	{"NPG", -1.925713242681900e+01, -8.382935542941192e+00},
	{"NPH", -1.550526850447972e+01, -4.631071620601904e+00},
	{"NPI", -1.555286390084525e+01, -4.678667016967436e+00},
	{"NPJ", -3.133988673447267e+01, -2.046568985059486e+01},
	{"NPK", -3.123629534450836e+01, -2.036209846063055e+01},
	{"NPL", -1.435462517223395e+01, -3.480428288356135e+00},
	{"NPM", -2.208327671260306e+01, -1.120907982872525e+01},
	{"NPN", -2.906987334827798e+01, -1.819567646440017e+01},
	{"NPO", -1.369100863376576e+01, -2.816811749887949e+00},
	{"NPP", -1.866931715196748e+01, -7.795120268089668e+00},
	{"NPQ", -3.260964540215060e+01, -2.173544851827279e+01},
	{"NPR", -1.271725192619456e+01, -1.843055042316749e+00},
	{"NPS", -2.127270599557048e+01, -1.039850911169267e+01},
	{"NPT", -2.136808571942791e+01, -1.049388883555010e+01},
	{"NPU", -1.484262758498236e+01, -3.968430701104551e+00},
	{"NPV", -3.076761303739423e+01, -1.989341615351642e+01},
	{"NPW", -2.696872151627512e+01, -1.609452463239731e+01},
	{"NPX", -3.611082410755840e+01, -2.523662722368059e+01},
	{"NPY", -2.205683631962306e+01, -1.118263943574525e+01},
	{"NPZ", -3.441593973300949e+01, -2.354174284913169e+01},
	{"NQA", -2.752359193630076e+01, -1.424170751274234e+01},
	{"NQB", -3.015196672864234e+01, -1.687008230508392e+01},
	{"NQC", -2.906296594653922e+01, -1.578108152298080e+01},
	{"NQD", -3.067367058873227e+01, -1.739178616517384e+01},
	{"NQE", -3.106156513287651e+01, -1.777968070931809e+01},
	{"NQF", -2.369209626912365e+01, -1.041021184556522e+01},
	{"NQG", -3.613729350651462e+01, -2.285540908295620e+01},
	{"NQH", -2.997202818899225e+01, -1.669014376543382e+01},
	{"NQI", -2.586358879688430e+01, -1.258170437332588e+01},
	{"NQJ", -3.193733996413404e+01, -1.865545554057562e+01},
	{"NQK", -3.776947870145337e+01, -2.448759427789494e+01},
	{"NQL", -3.041441576243525e+01, -1.713253133887682e+01},
	{"NQM", -2.959202892029456e+01, -1.631014449673614e+01},
	{"NQN", -3.242134629726331e+01, -1.913946187370488e+01},
	{"NQO", -3.060968056533502e+01, -1.732779614177659e+01},
	{"NQP", -2.370754197278779e+01, -1.042565754922937e+01},
	{"NQQ", -3.247167313942903e+01, -1.918978871587061e+01},
	{"NQR", -3.046668096586646e+01, -1.718479654230804e+01},
	{"NQS", -2.753803068863183e+01, -1.425614626507340e+01},
	{"NQT", -2.803866412508952e+01, -1.475677970153109e+01},
	{"NQU", -1.328457148859233e+01, -2.687065033909276e-03},
	{"NQV", -3.333253414350498e+01, -2.005064971994655e+01},
	{"NQW", -2.969078696765125e+01, -1.640890254409283e+01},
	{"NQX", -3.979261065933630e+01, -2.651072623577787e+01},
	{"NQY", -3.398533086078308e+01, -2.070344643722466e+01},
	{"NQZ", -4.093217809608683e+01, -2.765029367252840e+01},
	{"NRA", -1.469774242249389e+01, -3.257212699401688e+00},
	{"NRB", -2.631605584104116e+01, -1.487552611794895e+01},
	{"NRC", -2.530696419783942e+01, -1.386643447474722e+01},
	{"NRD", -2.435563474239372e+01, -1.291510501930153e+01},
	{"NRE", -1.233846392615359e+01, -8.979342030613936e-01},
	{"NRF", -2.347254473332610e+01, -1.203201501023390e+01},
	{"NRG", -2.576816082887879e+01, -1.432763110578659e+01},
	{"NRH", -1.890040319876809e+01, -7.459873475675888e+00},
	{"NRI", -1.460102774112359e+01, -3.160498018031392e+00},
	{"NRJ", -2.923841361356784e+01, -1.779788389047565e+01},
	{"NRK", -2.610584002512874e+01, -1.466531030203654e+01},
	{"NRL", -2.203628417843524e+01, -1.059575445534304e+01},
	{"NRM", -2.498103180450180e+01, -1.354050208140960e+01},
	{"NRN", -2.503627065127475e+01, -1.359574092818255e+01},
	{"NRO", -1.438641488672411e+01, -2.945885163631915e+00},
	{"NRP", -2.623890575395851e+01, -1.479837603086631e+01},
	{"NRQ", -3.062494974380861e+01, -1.918442002071642e+01},
	{"NRR", -2.550794079406625e+01, -1.406741107097405e+01},
	{"NRS", -2.374489188070143e+01, -1.230436215760923e+01},
	{"NRT", -2.345327883748136e+01, -1.201274911438917e+01},
	{"NRU", -1.559306163737244e+01, -4.152531914280242e+00},
	{"NRV", -2.655609308372570e+01, -1.511556336063350e+01},
	{"NRW", -2.591166289933892e+01, -1.447113317624672e+01},
	{"NRX", -3.129007591656806e+01, -1.984954619347587e+01},
	{"NRY", -1.567156668682397e+01, -4.231036963731771e+00},
	{"NRZ", -3.222119845041432e+01, -2.078066872732212e+01},
	{"NSA", -1.093236550078727e+01, -3.130836710945405e+00},
	{"NSB", -1.369578232845565e+01, -5.894253538613782e+00},
	{"NSC", -1.302031499155170e+01, -5.218786201709831e+00},
	{"NSD", -1.485060772254261e+01, -7.049078932700747e+00},
	{"NSE", -1.116010000488544e+01, -3.358571215043577e+00},
	{"NSF", -1.324257016674465e+01, -5.441041376902781e+00},
	{"NSG", -1.493685965912163e+01, -7.135330869279763e+00},
	{"NSH", -1.178549141978405e+01, -3.983962629942182e+00},
	{"NSI", -1.114965882718333e+01, -3.348130037341460e+00},
	{"NSJ", -1.758863273167292e+01, -9.787103941831052e+00},
	{"NSK", -1.661929275466184e+01, -8.817763964819976e+00},
	{"NSL", -1.445813038984151e+01, -6.656601599999639e+00},
	{"NSM", -1.386009115685058e+01, -6.058562367008713e+00},
	{"NSN", -1.517831701222552e+01, -7.376788222383652e+00},
	{"NSO", -1.091740035664464e+01, -3.115871566802773e+00},
	{"NSP", -1.262613336495225e+01, -4.824604575110387e+00},
	{"NSQ", -1.747000516933410e+01, -9.668476379492231e+00},
	{"NSR", -1.487553962317885e+01, -7.074010833336986e+00},
	{"NSS", -1.357432871479296e+01, -5.772799924951094e+00},
	{"NST", -1.008676227457657e+01, -2.285233484734701e+00},
	{"NSU", -1.197273932516689e+01, -4.171210535325027e+00},
	{"NSV", -1.685985561366447e+01, -9.058326823822600e+00},
	{"NSW", -1.174119574484212e+01, -3.939666955000249e+00},
	{"NSX", -2.271085349465178e+01, -1.490932470480991e+01},
	{"NSY", -1.520245201605448e+01, -7.400923226212611e+00},
	{"NSZ", -2.139571399132017e+01, -1.359418520147831e+01},
	{"NTA", -1.048270820215327e+01, -4.070405915449701e+00},
	{"NTB", -1.309103699739082e+01, -6.678734710687251e+00},
	{"NTC", -1.344705608101224e+01, -7.034753794308667e+00},
	{"NTD", -1.373701578409996e+01, -7.324713497396391e+00},
	{"NTE", -1.000142321922115e+01, -3.589120932517571e+00},
	{"NTF", -1.297462889936469e+01, -6.562326612661117e+00},
	{"NTG", -1.443313878670504e+01, -8.020836500001471e+00},
	{"NTH", -8.008623662751710e+00, -1.596321376048136e+00},
	{"NTI", -1.011351229191299e+01, -3.701210005209415e+00},
	{"NTJ", -1.654862297140356e+01, -1.013632068469999e+01},
	{"NTK", -1.520299368614679e+01, -8.790691399443217e+00},
	{"NTL", -1.198522140259327e+01, -5.572919115889694e+00},
	{"NTM", -1.319206879439881e+01, -6.779766507695234e+00},
	{"NTN", -1.428594597777122e+01, -7.873643691067645e+00},
	{"NTO", -8.889683172072296e+00, -2.477380885368723e+00},
	{"NTP", -1.376876880078792e+01, -7.356466514084343e+00},
	{"NTQ", -1.796374247126842e+01, -1.155144018456485e+01},
	{"NTR", -1.095291652676741e+01, -4.540614240063837e+00},
	{"NTS", -1.038860145747192e+01, -3.976299170768344e+00},
	{"NTT", -1.128877446570562e+01, -4.876472179002043e+00},
	{"NTU", -1.244996679919636e+01, -6.037664512492785e+00},
	{"NTV", -1.581175699513041e+01, -9.399454708426836e+00},
	{"NTW", -1.220183048829123e+01, -5.789528201587657e+00},
	{"NTX", -2.054871294439037e+01, -1.413641065768679e+01},
	{"NTY", -1.272412584200158e+01, -6.311823555298002e+00},
	{"NTZ", -1.850912461990787e+01, -1.209682233320430e+01},
	{"NUA", -1.452231590672721e+01, -4.121866112300856e+00},
	{"NUB", -1.792308687079066e+01, -7.522637076364300e+00},
	{"NUC", -1.713433084221599e+01, -6.733881047789633e+00},
	{"NUD", -1.950308367254941e+01, -9.102633878123052e+00},
	{"NUE", -1.388010201615143e+01, -3.479652221725072e+00},
	{"NUF", -1.508518770775539e+01, -4.684737913329036e+00},
	{"NUG", -1.858953035936187e+01, -8.189080564935511e+00},
	{"NUH", -2.683106898848747e+01, -1.643061919406112e+01},
	{"NUI", -1.642705002545398e+01, -6.026600231027628e+00},
	{"NUJ", -3.111940422470551e+01, -2.071895443027915e+01},
	{"NUK", -2.360485779963020e+01, -1.320440800520384e+01},
	{"NUL", -1.679766672050635e+01, -6.397216926079995e+00},
	{"NUM", -1.244749671454299e+01, -2.047046920116632e+00},
	{"NUN", -1.265661095773390e+01, -2.256161163307543e+00},
	{"NUO", -1.666276010708741e+01, -6.262310312661055e+00},
	{"NUP", -1.394852322707181e+01, -3.548073432645455e+00},
	{"NUQ", -3.258100817574088e+01, -2.218055838131453e+01},
	{"NUR", -1.553703407512923e+01, -5.136584280702880e+00},
	{"NUS", -1.367489034072614e+01, -3.274440546299783e+00},
	{"NUT", -1.399531346078757e+01, -3.594863666361215e+00},
	{"NUU", -2.212736367335702e+01, -1.172691387893066e+01},
	{"NUV", -2.270347737756677e+01, -1.230302758314041e+01},
	{"NUW", -2.208342401834917e+01, -1.168297422392282e+01},
	{"NUX", -2.139182216397835e+01, -1.099137236955199e+01},
	{"NUY", -2.869081776667544e+01, -1.829036797224908e+01},
	{"NUZ", -2.039361103031898e+01, -9.993161235892620e+00},
	{"NVA", -1.391493753275022e+01, -2.388533733109596e+00},
	{"NVB", -3.280193056261584e+01, -2.127552676297522e+01},
	{"NVC", -3.299128688995605e+01, -2.146488309031542e+01},
	{"NVD", -3.222141287760167e+01, -2.069500907796104e+01},
	{"NVE", -1.278500975495050e+01, -1.258605955309867e+00},
	{"NVF", -3.242200172423759e+01, -2.089559792459696e+01},
	{"NVG", -3.375909865630910e+01, -2.223269485666847e+01},
	{"NVH", -3.147393963173755e+01, -1.994753583209692e+01},
	{"NVI", -1.352439295352046e+01, -1.997989153879831e+00},
	{"NVJ", -3.368195635694972e+01, -2.215555255730909e+01},
	{"NVK", -3.556155697972803e+01, -2.403515318008741e+01},
	{"NVL", -3.283380005141354e+01, -2.130739625177291e+01},
	{"NVM", -2.171769667365912e+01, -1.019129287401849e+01},
	{"NVN", -3.093251327043521e+01, -1.940610947079458e+01},
	{"NVO", -1.465127818968404e+01, -3.124874390043409e+00},
	{"NVP", -3.191690983812351e+01, -2.039050603848288e+01},
	{"NVQ", -3.951375175306352e+01, -2.798734795342289e+01},
	{"NVR", -2.987294538521430e+01, -1.834654158557366e+01},
	{"NVS", -3.091072157474963e+01, -1.938431777510901e+01},
	{"NVT", -2.212874414007459e+01, -1.060234034043396e+01},
	{"NVU", -1.832618288670686e+01, -6.799779087066232e+00},
	{"NVV", -3.440732891867439e+01, -2.288092511903377e+01},
	{"NVW", -3.155008854651676e+01, -2.002368474687613e+01},
	{"NVX", -3.613957257016018e+01, -2.461316877051955e+01},
	{"NVY", -1.752813631699187e+01, -6.001732517351236e+00},
	{"NVZ", -3.954945145271790e+01, -2.802304765307727e+01},
	{"NWA", -1.214834789290668e+01, -2.269776485000868e+00},
	{"NWB", -2.737983253937016e+01, -1.750126113146435e+01},
	{"NWC", -2.361324832779423e+01, -1.373467691988841e+01},
	{"NWD", -2.695143590131163e+01, -1.707286449340582e+01},
	{"NWE", -1.273621947144824e+01, -2.857648063542422e+00},
	{"NWF", -2.723288553197305e+01, -1.735431412406723e+01},
	{"NWG", -2.835870705393579e+01, -1.848013564602998e+01},
	{"NWH", -1.130097092902811e+01, -1.422399521122291e+00},
	{"NWI", -1.222256285008131e+01, -2.343991442175489e+00},
	{"NWJ", -2.971274993187128e+01, -1.983417852396547e+01},
	{"NWK", -2.986726947804238e+01, -1.998869807013656e+01},
	{"NWL", -2.349616766731392e+01, -1.361759625940810e+01},
	{"NWM", -2.700231551941027e+01, -1.712374411150445e+01},
	{"NWN", -2.387726967265592e+01, -1.399869826475011e+01},
	{"NWO", -1.379243009778452e+01, -3.913858689878706e+00},
	{"NWP", -2.808943194403914e+01, -1.821086053613332e+01},
	{"NWQ", -3.234446452500021e+01, -2.246589311709439e+01},
	{"NWR", -1.575720084161236e+01, -5.878629433706545e+00},
	{"NWS", -2.513725972285540e+01, -1.525868831494958e+01},
	{"NWT", -2.322378318997190e+01, -1.334521178206609e+01},
	{"NWU", -2.366633619990956e+01, -1.378776479200374e+01},
	{"NWV", -3.019463788764537e+01, -2.031606647973956e+01},
	{"NWW", -2.037177724149689e+01, -1.049320583359107e+01},
	{"NWX", -3.953827079112561e+01, -2.965969938321979e+01},
	{"NWY", -2.265464550207297e+01, -1.277607409416716e+01},
	{"NWZ", -3.306125444176477e+01, -2.318268303385895e+01},
	{"NXA", -2.084465581115634e+01, -5.506197245415207e+00},
	{"NXB", -2.785787053352434e+01, -1.251941196778322e+01},
	{"NXC", -2.281887019107450e+01, -7.480411625333367e+00},
	{"NXD", -2.725125868644429e+01, -1.191280012070316e+01},
	{"NXE", -2.029290202671703e+01, -4.954443460975907e+00},
	{"NXF", -2.739249961928638e+01, -1.205404105354525e+01},
	{"NXG", -2.869029643816962e+01, -1.335183787242849e+01},
	{"NXH", -2.505060651847886e+01, -9.712147952737737e+00},
	{"NXI", -1.561479202003381e+01, -2.763334542926874e-01},
	{"NXJ", -2.990540181863947e+01, -1.456694325289834e+01},
	{"NXK", -3.080348810908585e+01, -1.546502954334472e+01},
	{"NXL", -2.735072212590932e+01, -1.201226356016819e+01},
	{"NXM", -2.262932439454178e+01, -7.290865828800648e+00},
	{"NXN", -2.914292580046049e+01, -1.380446723471936e+01},
	{"NXO", -2.163023157074755e+01, -6.291773005006426e+00},
	{"NXP", -2.226664233070463e+01, -6.928183764963507e+00},
	{"NXQ", -2.880569746835261e+01, -1.346723890261148e+01},
	{"NXR", -2.361527587892660e+01, -8.276817313185475e+00},
	{"NXS", -2.263429111558273e+01, -7.295832549841601e+00},
	{"NXT", -2.110104848221523e+01, -5.762589916474108e+00},
	{"NXU", -2.592876765382577e+01, -1.059030908808464e+01},
	{"NXV", -2.253214844673716e+01, -7.193689880996034e+00},
	{"NXW", -2.088956564252050e+01, -5.551107076779373e+00},
	{"NXX", -2.069299956823454e+01, -5.354541002493416e+00},
	{"NXY", -2.352863627931438e+01, -8.190177713573258e+00},
	{"NXZ", -4.034271722125221e+01, -2.500425865551108e+01},
	{"NYA", -1.359149031223914e+01, -3.687509813891884e+00},
	{"NYB", -1.480003354912452e+01, -4.896053050777271e+00},
	{"NYC", -1.436592758921447e+01, -4.461947090867220e+00},
	{"NYD", -1.509421112029644e+01, -5.190230621949191e+00},
	{"NYE", -1.372431870906769e+01, -3.820338210720439e+00},
	{"NYF", -1.523958869622979e+01, -5.335608197882537e+00},
	{"NYG", -1.641139292847483e+01, -6.507412430127575e+00},
	{"NYH", -1.527600063274542e+01, -5.372020134398166e+00},
	{"NYI", -1.478933116887002e+01, -4.885350670522769e+00},
	{"NYJ", -1.901307459922276e+01, -9.109094100875511e+00},
	{"NYK", -1.704486620520548e+01, -7.140885706858225e+00},
	{"NYL", -1.580840580124603e+01, -5.904425302898781e+00},
	{"NYM", -1.392456524990920e+01, -4.020584751561946e+00},
	{"NYN", -1.642040442371181e+01, -6.516423925364556e+00},
	{"NYO", -1.195983057188005e+01, -2.055850073532796e+00},
	{"NYP", -1.415119202511660e+01, -4.247211526769351e+00},
	{"NYQ", -1.919369528575461e+01, -9.289714787407361e+00},
	{"NYR", -1.546315251132792e+01, -5.559172012980666e+00},
	{"NYS", -1.417098554683639e+01, -4.267005048489138e+00},
	{"NYT", -1.323626890797491e+01, -3.332288409627661e+00},
	{"NYU", -1.720694548510506e+01, -7.302964986757809e+00},
	{"NYV", -1.719342758505164e+01, -7.289447086704386e+00},
	{"NYW", -1.391571469413980e+01, -4.011734195792546e+00},
	{"NYX", -1.981138777993995e+01, -9.907407281592697e+00},
	{"NYY", -1.652713702712957e+01, -6.623156528782321e+00},
	{"NYZ", -2.171539647521103e+01, -1.181141597686378e+01},
	{"NZA", -1.869462220013171e+01, -2.847458590610990e+00},
	{"NZB", -2.766792469131147e+01, -1.182076108179075e+01},
	{"NZC", -2.855388970010213e+01, -1.270672609058141e+01},
	{"NZD", -2.891056921879027e+01, -1.306340560926955e+01},
	{"NZE", -1.744602375601226e+01, -1.598860146491543e+00},
	{"NZF", -2.269756505274522e+01, -6.850401443224503e+00},
	{"NZG", -2.902047296720911e+01, -1.317330935768839e+01},
	{"NZH", -2.763989341115666e+01, -1.179272980163594e+01},
	{"NZI", -1.782135976317997e+01, -1.974196153659244e+00},
	{"NZJ", -3.154688098316394e+01, -1.569971737364322e+01},
	{"NZK", -3.018238104355029e+01, -1.433521743402957e+01},
	{"NZL", -2.587231375162973e+01, -1.002515014210901e+01},
	{"NZM", -2.807947506836918e+01, -1.223231145884846e+01},
	{"NZN", -2.918369973850641e+01, -1.333653612898569e+01},
	{"NZO", -1.827341776471417e+01, -2.426254155193451e+00},
	{"NZP", -2.699926445873660e+01, -1.115210084921588e+01},
	{"NZQ", -3.546309487248728e+01, -1.961593126296656e+01},
	{"NZR", -2.621202110873898e+01, -1.036485749921825e+01},
	{"NZS", -2.783084385179487e+01, -1.198368024227415e+01},
	{"NZT", -2.350437070756085e+01, -7.657207098040131e+00},
	{"NZU", -2.573273997985219e+01, -9.885576370331469e+00},
	{"NZV", -2.863057567663158e+01, -1.278341206711086e+01},
	{"NZW", -2.729406285176745e+01, -1.144689924224673e+01},
	{"NZX", -3.827123143393212e+01, -2.242406782441140e+01},
	{"NZY", -1.971231675163114e+01, -3.865153142110418e+00},
	{"NZZ", -2.430158898741423e+01, -8.454425377893505e+00},
	{"OAA", -1.727412366455253e+01, -7.596440113258740e+00},
	{"OAB", -1.407374487321118e+01, -4.396061321917387e+00},
	{"OAC", -1.317953830807246e+01, -3.501854756778668e+00},
	{"OAD", -1.281251012346660e+01, -3.134826572172802e+00},
	{"OAE", -2.038035266254539e+01, -1.070266911125160e+01},
	{"OAF", -1.515147608768018e+01, -5.473792536386384e+00},
	{"OAG", -1.575533600936316e+01, -6.077652458069362e+00},
	{"OAH", -1.575188599169585e+01, -6.074202440402057e+00},
	{"OAI", -1.696242714766801e+01, -7.284743596374222e+00},
	{"OAJ", -2.039276071045002e+01, -1.071507715915623e+01},
	{"OAK", -1.647692735582791e+01, -6.799243804534120e+00},
	{"OAL", -1.305130825948128e+01, -3.373624708187490e+00},
	{"OAM", -1.437021405051547e+01, -4.692530499221680e+00},
	{"OAN", -1.221694672049126e+01, -2.539263169197473e+00},
	{"OAO", -2.138614006898242e+01, -1.170845651768863e+01},
	{"OAP", -1.448866849237393e+01, -4.810984941080144e+00},
	{"OAQ", -1.971602390819960e+01, -1.003834035690580e+01},
	{"OAR", -1.318771718082697e+01, -3.510033629533173e+00},
	{"OAS", -1.293301316854408e+01, -3.255329617250287e+00},
	{"OAT", -1.288459772687373e+01, -3.206914175579935e+00},
	{"OAU", -1.764590155805211e+01, -7.968218006758313e+00},
	{"OAV", -1.583207181665372e+01, -6.154388265359930e+00},
	{"OAW", -1.629829563365450e+01, -6.620612082360710e+00},
	{"OAX", -2.001460966210993e+01, -1.033692611081614e+01},
	{"OAY", -2.017146866528249e+01, -1.049378511398869e+01},
	{"OAZ", -1.867285862002452e+01, -8.995175068730727e+00},
	{"OBA", -1.326897206587516e+01, -3.481398722993838e+00},
	{"OBB", -1.565733030121424e+01, -5.869756958332922e+00},
	{"OBC", -1.842994057512194e+01, -8.642367232240616e+00},
	{"OBD", -1.919288388054466e+01, -9.405310537663334e+00},
	{"OBE", -1.103486273800178e+01, -1.247289395120454e+00},
	{"OBF", -1.907426657829866e+01, -9.286693235417335e+00},
	{"OBG", -2.054825313896882e+01, -1.076067979608750e+01},
	{"OBH", -1.791077198442493e+01, -8.123198641543604e+00},
	{"OBI", -1.507867202448830e+01, -5.291098681606980e+00},
	{"OBJ", -1.440336256883938e+01, -4.615789225958061e+00},
	{"OBK", -2.139589941420153e+01, -1.160832607132021e+01},
	{"OBL", -1.311770027034284e+01, -3.330126927461519e+00},
	{"OBM", -1.907238047462898e+01, -9.284807131747659e+00},
	{"OBN", -1.891014085247915e+01, -9.122567509597822e+00},
	{"OBO", -1.426676155936777e+01, -4.479188216486443e+00},
	{"OBP", -2.090816440989518e+01, -1.112059106701386e+01},
	{"OBQ", -3.572450438976372e+01, -2.593693104688240e+01},
	{"OBR", -1.421162905250428e+01, -4.424055709622952e+00},
	{"OBS", -1.351990817253085e+01, -3.732334829649532e+00},
	{"OBT", -1.396187302408471e+01, -4.174299681203387e+00},
	{"OBU", -1.424764678467903e+01, -4.460073441797705e+00},
	{"OBV", -1.679980419992097e+01, -7.012230857039650e+00},
	{"OBW", -1.763087322553091e+01, -7.843299882649584e+00},
	{"OBX", -3.901171222900432e+01, -2.922413888612300e+01},
	{"OBY", -1.606693898909049e+01, -6.279365646209167e+00},
	{"OBZ", -3.351981610477172e+01, -2.373224276189040e+01},
	{"OCA", -1.266485337029531e+01, -2.955839677180667e+00},
	{"OCB", -2.369001671008702e+01, -1.398100301697238e+01},
	{"OCC", -1.329409958381999e+01, -3.585085890705345e+00},
	{"OCD", -2.138511826155962e+01, -1.167610456844497e+01},
	{"OCE", -1.309670570861049e+01, -3.387692015495845e+00},
	{"OCF", -2.920880263320101e+01, -1.949978894008637e+01},
	{"OCG", -2.271057293555982e+01, -1.300155924244518e+01},
	{"OCH", -1.402372936677712e+01, -4.314715673662478e+00},
	{"OCI", -1.302677036032296e+01, -3.317756667208317e+00},
	{"OCJ", -2.371454730465459e+01, -1.400553361153995e+01},
	{"OCK", -1.231747434958676e+01, -2.608460656472122e+00},
	{"OCL", -1.405196537996700e+01, -4.342951686852354e+00},
	{"OCM", -2.270183892483189e+01, -1.299282523171725e+01},
	{"OCN", -2.139315999173476e+01, -1.168414629862012e+01},
	{"OCO", -1.222863210719921e+01, -2.519618414084563e+00},
	{"OCP", -2.840320589691559e+01, -1.869419220380095e+01},
	{"OCQ", -2.112524566423830e+01, -1.141623197112365e+01},
	{"OCR", -1.381810248827267e+01, -4.109088795158028e+00},
	{"OCS", -2.089040655445132e+01, -1.118139286133668e+01},
	{"OCT", -1.407657326880281e+01, -4.367559575688170e+00},
	{"OCU", -1.422333688344468e+01, -4.514323190330039e+00},
	{"OCV", -3.178108452104499e+01, -2.207207082793035e+01},
	{"OCW", -2.038637442849135e+01, -1.067736073537670e+01},
	{"OCX", -3.307891305152425e+01, -2.336989935840960e+01},
	{"OCY", -1.906389934195229e+01, -9.354885648837646e+00},
	{"OCZ", -3.173549008223560e+01, -2.202647638912097e+01},
	{"ODA", -1.211395168698218e+01, -3.133334291200645e+00},
	{"ODB", -1.426345324080304e+01, -5.282835845021500e+00},
	{"ODC", -1.522112408854440e+01, -6.240506692762865e+00},
	{"ODD", -1.472013661368111e+01, -5.739519217899573e+00},
	{"ODE", -1.196627303125716e+01, -2.985655635475624e+00},
	{"ODF", -1.430382002556111e+01, -5.323202629779571e+00},
	{"ODG", -1.514368930926972e+01, -6.163071913488182e+00},
	{"ODH", -1.424711452085610e+01, -5.266497125074563e+00},
	{"ODI", -1.217435282114002e+01, -3.193735425358484e+00},
	{"ODJ", -1.819129279246818e+01, -9.210675396686641e+00},
	{"ODK", -1.813217181415601e+01, -9.151554418374472e+00},
	{"ODL", -1.513595815006990e+01, -6.155340754288362e+00},
	{"ODM", -1.544922351044461e+01, -6.468606114663073e+00},
	{"ODN", -1.519330434339634e+01, -6.212686947614804e+00},
	{"ODO", -1.199517694095889e+01, -3.014559545177348e+00},
	{"ODP", -1.601574001694265e+01, -7.035122621161114e+00},
	{"ODQ", -2.001609133722323e+01, -1.103547394144169e+01},
	{"ODR", -1.426597061745796e+01, -5.285353221676419e+00},
	{"ODS", -1.259621020097783e+01, -3.615592805196292e+00},
	{"ODT", -1.320395007805031e+01, -4.223332682268769e+00},
	{"ODU", -1.279047340700510e+01, -3.809856011223562e+00},
	{"ODV", -1.875742231377138e+01, -9.776804917989843e+00},
	{"ODW", -1.364875075254800e+01, -4.668133356766456e+00},
	{"ODX", -3.422261259252011e+01, -2.524199519673856e+01},
	{"ODY", -1.260223017956000e+01, -3.621612783778464e+00},
	{"ODZ", -2.271129338825522e+01, -1.373067599247368e+01},
	{"OEA", -1.450626778256725e+01, -3.679389436707072e+00},
	{"OEB", -1.792528636614442e+01, -7.098408020284245e+00},
	{"OEC", -1.875863239311841e+01, -7.931754047258239e+00},
	{"OED", -1.656610542471827e+01, -5.739227078858095e+00},
	{"OEE", -1.963560722279990e+01, -8.808728876939725e+00},
	{"OEF", -1.661296632084115e+01, -5.786087974980975e+00},
	{"OEG", -1.704043574952116e+01, -6.213557403660989e+00},
	{"OEH", -1.824180480035868e+01, -7.414926454498506e+00},
	{"OEI", -1.718102085071328e+01, -6.354142504853102e+00},
	{"OEJ", -2.138231475413181e+01, -1.055543640827164e+01},
	{"OEK", -2.135958993428240e+01, -1.053271158842222e+01},
	{"OEL", -1.593595287118754e+01, -5.109074525327364e+00},
	{"OEM", -1.569600244093867e+01, -4.869124095078500e+00},
	{"OEN", -1.386597737035369e+01, -3.039099024493519e+00},
	{"OEO", -1.799659330773367e+01, -7.169714961873496e+00},
	{"OEP", -1.629465019666035e+01, -5.467771850800175e+00},
	{"OEQ", -1.890746776961796e+01, -8.080589423757786e+00},
	{"OER", -1.576703468604861e+01, -4.940156340188437e+00},
	{"OES", -1.278129126407925e+01, -1.954412918219071e+00},
	{"OET", -1.449748305367539e+01, -3.670604707815219e+00},
	{"OEU", -1.630742446372008e+01, -5.480546117859903e+00},
	{"OEV", -1.386130306258745e+01, -3.034424716727273e+00},
	{"OEW", -1.774607675026079e+01, -6.919198404400615e+00},
	{"OEX", -1.425042279015371e+01, -3.423544444293539e+00},
	{"OEY", -1.894009800586380e+01, -8.113219660003626e+00},
	{"OEZ", -1.990955558599062e+01, -9.082677240130449e+00},
	{"OFA", -1.013098926628751e+01, -3.543882874914740e+00},
	{"OFB", -1.211645869442593e+01, -5.529352303053154e+00},
	{"OFC", -1.139199504972905e+01, -4.804888658356278e+00},
	{"OFD", -1.232960726216092e+01, -5.742500870788150e+00},
	{"OFE", -1.160993818744195e+01, -5.022831796069173e+00},
	{"OFF", -1.055669167963115e+01, -3.969585288258378e+00},
	{"OFG", -1.190893885624172e+01, -5.321832464868942e+00},
	{"OFH", -1.082406910280983e+01, -4.236962711437058e+00},
	{"OFI", -1.099868123887653e+01, -4.411574847503756e+00},
	{"OFJ", -1.264993242638417e+01, -6.062826035011395e+00},
	{"OFK", -1.460236219994240e+01, -8.015255808569625e+00},
	{"OFL", -1.213817809228211e+01, -5.551071700909338e+00},
	{"OFM", -1.103352076341760e+01, -4.446414372044827e+00},
	{"OFN", -1.284986833409528e+01, -6.262761942722505e+00},
	{"OFO", -1.174130044953580e+01, -5.154194058163027e+00},
	{"OFP", -1.164623332373382e+01, -5.059126932361051e+00},
	{"OFQ", -1.693733861644442e+01, -1.035023222507165e+01},
	{"OFR", -1.215034319736065e+01, -5.563236805987876e+00},
	{"OFS", -1.108274658876848e+01, -4.495640197395706e+00},
	{"OFT", -8.118570133003944e+00, -1.531463741631171e+00},
	{"OFU", -1.373319489198092e+01, -7.146088500608142e+00},
	{"OFV", -1.383759587307697e+01, -7.250489481704200e+00},
	{"OFW", -1.190369954214858e+01, -5.316593150775807e+00},
	{"OFX", -1.932637143476627e+01, -1.273926504339349e+01},
	{"OFY", -1.357642922336084e+01, -6.989322831988066e+00},
	{"OFZ", -1.522285629899060e+01, -8.635749907617825e+00},
	{"OGA", -1.482508669720451e+01, -4.221407303185644e+00},
	{"OGB", -1.900309616167758e+01, -8.399416767658716e+00},
	{"OGC", -1.806830198250449e+01, -7.464622588485623e+00},
	{"OGD", -2.036055447678873e+01, -9.756875082769865e+00},
	{"OGE", -1.232041720139187e+01, -1.716737807373009e+00},
	{"OGF", -1.987910811309361e+01, -9.275428719074744e+00},
	{"OGG", -1.714465585548116e+01, -6.540976461462294e+00},
	{"OGH", -1.875482023676698e+01, -8.151140842748111e+00},
	{"OGI", -1.371631225156097e+01, -3.112632857542102e+00},
	{"OGJ", -2.270092577268364e+01, -1.209724637866478e+01},
	{"OGK", -2.039389568822145e+01, -9.790216294202581e+00},
	{"OGL", -1.650099070251780e+01, -5.897311308498933e+00},
	{"OGM", -1.889467761133886e+01, -8.290998217319993e+00},
	{"OGN", -1.508731397337913e+01, -4.483634579360268e+00},
	{"OGO", -1.334638011220031e+01, -2.742700718181442e+00},
	{"OGP", -2.163653807858213e+01, -1.103285868456326e+01},
	{"OGQ", -3.056399727768307e+01, -1.996031788366420e+01},
	{"OGR", -1.307864862146899e+01, -2.474969227450118e+00},
	{"OGS", -1.575281334914084e+01, -5.149133955121977e+00},
	{"OGT", -1.781339079258221e+01, -7.209711398563342e+00},
	{"OGU", -1.548052967145073e+01, -4.876850277431861e+00},
	{"OGV", -2.211543304616639e+01, -1.151175365214752e+01},
	{"OGW", -1.818241620677615e+01, -7.578736812757289e+00},
	{"OGX", -3.379067988839524e+01, -2.318700049437637e+01},
	{"OGY", -1.563544815753409e+01, -5.031768763515227e+00},
	{"OGZ", -3.237893340242746e+01, -2.177525400840860e+01},
	{"OHA", -1.211248360779181e+01, -1.970445480146958e+00},
	{"OHB", -1.946348045712095e+01, -9.321442329476106e+00},
	{"OHC", -1.885586312583998e+01, -8.713824998195133e+00},
	{"OHD", -1.819297195613585e+01, -8.050933828491008e+00},
	{"OHE", -1.263926271369231e+01, -2.497224586047459e+00},
	{"OHF", -2.012206734806479e+01, -9.980029220419945e+00},
	{"OHG", -2.001282932792557e+01, -9.870791200280728e+00},
	{"OHH", -1.806894407692636e+01, -7.926905949281513e+00},
	{"OHI", -1.155730532423400e+01, -1.415267196589156e+00},
	{"OHJ", -1.954778041652554e+01, -9.405742288880699e+00},
	{"OHK", -1.939607234646304e+01, -9.254034218818191e+00},
	{"OHL", -1.896023603056499e+01, -8.818197902920142e+00},
	{"OHM", -1.804248844491261e+01, -7.900450317267760e+00},
	{"OHN", -1.451890867637696e+01, -4.376870548732116e+00},
	{"OHO", -1.434621865600584e+01, -4.204180528360997e+00},
	{"OHP", -1.954276707163541e+01, -9.400728943990559e+00},
	{"OHQ", -3.172922577629916e+01, -2.158718764865431e+01},
	{"OHR", -2.106049114356927e+01, -1.091845301592443e+01},
	{"OHS", -1.658742152870322e+01, -6.445383401058371e+00},
	{"OHT", -1.670626321203190e+01, -6.564225084387057e+00},
	{"OHU", -1.511030389321109e+01, -4.968265765566244e+00},
	{"OHV", -2.271073941047623e+01, -1.256870128283138e+01},
	{"OHW", -1.812835723400779e+01, -7.986319106362947e+00},
	{"OHX", -3.572516280524232e+01, -2.558312467759747e+01},
	{"OHY", -1.732185347478622e+01, -7.179815347141376e+00},
	{"OHZ", -3.273704505111603e+01, -2.259500692347118e+01},
	{"OIA", -1.655132483014288e+01, -6.674229249131539e+00},
	{"OIB", -2.022531931946852e+01, -1.034822373845718e+01},
	{"OIC", -1.292469666249236e+01, -3.047601081481019e+00},
	{"OID", -1.429461375886951e+01, -4.417518177858174e+00},
	{"OIE", -2.039814997166247e+01, -1.052105439065113e+01},
	{"OIF", -1.705250114274486e+01, -7.175405561733522e+00},
	{"OIG", -1.794231215001435e+01, -8.065216569003002e+00},
	{"OIH", -1.783361338956079e+01, -7.956517808549451e+00},
	{"OII", -1.946698109026254e+01, -9.589885509251202e+00},
	{"OIJ", -2.001735725798541e+01, -1.014026167697407e+01},
	{"OIK", -1.885365347268904e+01, -8.976557891677695e+00},
	{"OIL", -1.299555792465293e+01, -3.118462343641590e+00},
	{"OIM", -1.556863387686432e+01, -5.691538295852984e+00},
	{"OIN", -1.111175926714713e+01, -1.234663686135785e+00},
	{"OIO", -2.045871355290157e+01, -1.058161797189023e+01},
	{"OIP", -1.906110985200210e+01, -9.184014270990762e+00},
	{"OIQ", -2.368754809541931e+01, -1.381045251440797e+01},
	{"OIR", -1.590412593671014e+01, -6.027030355698801e+00},
	{"OIS", -1.299400913309012e+01, -3.116913552078782e+00},
	{"OIT", -1.317931124569814e+01, -3.302215664686805e+00},
	{"OIU", -2.263593946158353e+01, -1.275884388057218e+01},
	{"OIV", -2.030207398530627e+01, -1.042497840429493e+01},
	{"OIW", -1.710196645606979e+01, -7.224870875058447e+00},
	{"OIX", -2.053905464055783e+01, -1.066195905954649e+01},
	{"OIY", -2.371609036929965e+01, -1.383899478828831e+01},
	{"OIZ", -2.357118962158114e+01, -1.369409404056981e+01},
	{"OJA", -1.620920203817399e+01, -4.294203467876639e+00},
	{"OJB", -2.924293918263372e+01, -1.732794061233636e+01},
	{"OJC", -2.001734647965010e+01, -8.102347909352753e+00},
	{"OJD", -3.198648641239369e+01, -2.007148784209634e+01},
	{"OJE", -1.231324257922283e+01, -3.982440089254738e-01},
	{"OJF", -3.111017230879798e+01, -1.919517373850063e+01},
	{"OJG", -3.069471320493725e+01, -1.877971463463990e+01},
	{"OJH", -2.988085621162935e+01, -1.796585764133200e+01},
	{"OJI", -1.862266491689613e+01, -6.707666346598773e+00},
	{"OJJ", -1.954808618646386e+01, -7.633087616166502e+00},
	{"OJK", -3.257522043580020e+01, -2.066022186550284e+01},
	{"OJL", -3.108405330503681e+01, -1.916905473473945e+01},
	{"OJM", -2.271568031758314e+01, -1.080068174728578e+01},
	{"OJN", -3.439004840741688e+01, -2.247504983711952e+01},
	{"OJO", -1.510018901553512e+01, -3.185190445237765e+00},
	{"OJP", -3.085183094158329e+01, -1.893683237128594e+01},
	{"OJQ", -3.383808268250917e+01, -2.192308411221182e+01},
	{"OJR", -2.370140015138522e+01, -1.178640158108787e+01},
	{"OJS", -3.050104623585823e+01, -1.858604766556087e+01},
	{"OJT", -3.059518355807727e+01, -1.868018498777991e+01},
	{"OJU", -1.595214308104502e+01, -4.037144510747670e+00},
	{"OJV", -3.745713590211002e+01, -2.554213733181267e+01},
	{"OJW", -2.369835713665239e+01, -1.178335856635504e+01},
	{"OJX", -4.013644130917885e+01, -2.822144273888150e+01},
	{"OJY", -3.660631206002347e+01, -2.469131348972611e+01},
	{"OJZ", -3.471131315348190e+01, -2.279631458318455e+01},
	{"OKA", -1.416511055213813e+01, -3.753964563148025e+00},
	{"OKB", -1.714420035199409e+01, -6.733054363003983e+00},
	{"OKC", -1.690850312238807e+01, -6.497357133397959e+00},
	{"OKD", -1.793354229741950e+01, -7.522396308429398e+00},
	{"OKE", -1.188651803972517e+01, -1.475372050735068e+00},
	{"OKF", -1.634958537652479e+01, -5.938439387534682e+00},
	{"OKG", -1.925481503080573e+01, -8.843669041815627e+00},
	{"OKH", -1.507710683607826e+01, -4.665960847088153e+00},
	{"OKI", -1.342304964153327e+01, -3.011903652543167e+00},
	{"OKJ", -1.901714981113048e+01, -8.606003822140377e+00},
	{"OKK", -1.971549548983696e+01, -9.304349500846858e+00},
	{"OKL", -1.737077439863857e+01, -6.959628409648461e+00},
	{"OKM", -1.685798246562295e+01, -6.446836476632842e+00},
	{"OKN", -1.478161990635520e+01, -4.370473917365095e+00},
	{"OKO", -1.472108077604741e+01, -4.309934787057302e+00},
	{"OKP", -1.601027118232193e+01, -5.599125193331825e+00},
	{"OKQ", -3.176855810510945e+01, -2.135741211611935e+01},
	{"OKR", -1.783290760882825e+01, -7.421761619838145e+00},
	{"OKS", -1.388914507836448e+01, -3.477999089374376e+00},
	{"OKT", -1.417937930214946e+01, -3.768233313159357e+00},
	{"OKU", -1.560344605876096e+01, -5.192300069770854e+00},
	{"OKV", -2.112754453367621e+01, -1.071639854468610e+01},
	{"OKW", -1.680566137279039e+01, -6.394515383800283e+00},
	{"OKX", -2.271751212845811e+01, -1.230636613946801e+01},
	{"OKY", -1.782814348236764e+01, -7.416997493377536e+00},
	{"OKZ", -2.113224043825486e+01, -1.072109444926476e+01},
	{"OLA", -1.266974000980351e+01, -4.138543644009109e+00},
	{"OLB", -1.634900311164146e+01, -7.817806745847060e+00},
	{"OLC", -1.725510189836885e+01, -8.723905532574456e+00},
	{"OLD", -1.054175776823503e+01, -2.010561402440630e+00},
	{"OLE", -1.158269960839201e+01, -3.051503242597617e+00},
	{"OLF", -1.662632255016135e+01, -8.095126184366954e+00},
	{"OLG", -1.938626149406949e+01, -1.085506512827510e+01},
	{"OLH", -1.701534103640930e+01, -8.484144670614899e+00},
	{"OLI", -1.161061514286140e+01, -3.079418777067008e+00},
	{"OLJ", -2.013117790390593e+01, -1.159998153811153e+01},
	{"OLK", -1.666193800275676e+01, -8.130741636962364e+00},
	{"OLL", -1.153643684078093e+01, -3.005240474986528e+00},
	{"OLM", -1.458624228422747e+01, -6.055045918433074e+00},
	{"OLN", -1.586600092993703e+01, -7.334804564142636e+00},
	{"OLO", -1.151197012794031e+01, -2.980773762145915e+00},
	{"OLP", -1.782927767159947e+01, -9.298081305805068e+00},
	{"OLQ", -2.370373444781450e+01, -1.517253808202010e+01},
	{"OLR", -1.880254461765357e+01, -1.027134825185918e+01},
	{"OLS", -1.413588571191816e+01, -5.604689346123765e+00},
	{"OLT", -1.416553670885403e+01, -5.634340343059631e+00},
	{"OLU", -1.241812025808105e+01, -3.886923892286656e+00},
	{"OLV", -1.394530118438250e+01, -5.414104818588100e+00},
	{"OLW", -1.667133073580863e+01, -8.140134370014231e+00},
	{"OLX", -2.371722117388360e+01, -1.518602480808920e+01},
	{"OLY", -1.367615249599409e+01, -5.144956130199694e+00},
	{"OLZ", -3.223557788073364e+01, -2.370438151493924e+01},
	{"OMA", -1.072370728261434e+01, -3.051984115909784e+00},
	{"OMB", -1.299102491633301e+01, -5.319301749628452e+00},
	{"OMC", -1.496347075548493e+01, -7.291747588780375e+00},
	{"OMD", -1.509998295880104e+01, -7.428259792096490e+00},
	{"OME", -9.515055295748756e+00, -1.843332129044202e+00},
	{"OMF", -1.398717313529447e+01, -6.315449968589914e+00},
	{"OMG", -1.554858747671728e+01, -7.876864310012723e+00},
	{"OMH", -1.300866033550269e+01, -5.336937168798139e+00},
	{"OMI", -1.157590948419807e+01, -3.904186317493514e+00},
	{"OMJ", -1.670733828036555e+01, -9.035615113660997e+00},
	{"OMK", -1.748964547109152e+01, -9.817922304386965e+00},
	{"OML", -1.577569713479304e+01, -8.103973968088484e+00},
	{"OMM", -1.092546130954276e+01, -3.253738142838206e+00},
	{"OMN", -1.535156097752148e+01, -7.679837810816923e+00},
	{"OMO", -1.206068714848045e+01, -4.388963981775892e+00},
	{"OMP", -1.097199553933548e+01, -3.300272372630923e+00},
	{"OMQ", -2.139599693395722e+01, -1.372427376725267e+01},
	{"OMR", -1.505645368525180e+01, -7.384730518547249e+00},
	{"OMS", -1.295401816311542e+01, -5.282294996410872e+00},
	{"OMT", -1.088058129559107e+01, -3.208858128886519e+00},
	{"OMU", -1.386116671194562e+01, -6.189443545241063e+00},
	{"OMV", -1.710367985116029e+01, -9.431956684455734e+00},
	{"OMW", -1.365766560840848e+01, -5.985942441703923e+00},
	{"OMX", -2.271807990462983e+01, -1.504635673792528e+01},
	{"OMY", -1.342414571677336e+01, -5.752422550068804e+00},
	{"OMZ", -2.039652262797756e+01, -1.272479946127301e+01},
	{"ONA", -9.918659205177322e+00, -3.513684970355694e+00},
	{"ONB", -1.244192799863270e+01, -6.036953763811072e+00},
	{"ONC", -1.133344323340924e+01, -4.928468998587612e+00},
	{"OND", -1.106951680803997e+01, -4.664542573218339e+00},
	{"ONE", -9.347295309392093e+00, -2.942321074570464e+00},
	{"ONF", -1.155034018807937e+01, -5.145365953257740e+00},
	{"ONG", -1.035566489903225e+01, -3.950690664210622e+00},
	{"ONH", -1.178939012676442e+01, -5.384415891942790e+00},
	{"ONI", -1.062271056677747e+01, -4.217736331955842e+00},
	{"ONJ", -1.487310680846246e+01, -8.468132573640833e+00},
	{"ONK", -1.567346140771061e+01, -9.268487172888982e+00},
	{"ONL", -1.158976757549305e+01, -5.184793340671424e+00},
	{"ONM", -1.256255749559632e+01, -6.157583260774689e+00},
	{"ONN", -1.309741803421717e+01, -6.692443799395544e+00},
	{"ONO", -9.791772707935188e+00, -3.386798473113557e+00},
	{"ONP", -1.305419306560836e+01, -6.649218830786729e+00},
	{"ONQ", -1.454879661784157e+01, -8.143822383019945e+00},
	{"ONR", -1.353006203122110e+01, -7.125087796399471e+00},
	{"ONS", -9.227484208390360e+00, -2.822509973568729e+00},
	{"ONT", -9.066736317476764e+00, -2.661762082655135e+00},
	{"ONU", -1.410360531208441e+01, -7.698631077262779e+00},
	{"ONV", -1.297135576964543e+01, -6.566381534823799e+00},
	{"ONW", -1.151076573624472e+01, -5.105791501423094e+00},
	{"ONX", -1.954817665721856e+01, -1.314320242239693e+01},
	{"ONY", -1.332715956737725e+01, -6.922185332555620e+00},
	{"ONZ", -1.867414603871689e+01, -1.226917180389527e+01},
	{"OOA", -1.688061683528343e+01, -8.093678764458687e+00},
	{"OOB", -1.522138243769574e+01, -6.434444366870996e+00},
	{"OOC", -1.616106142300823e+01, -7.374123352183483e+00},
	{"OOD", -1.088754027021179e+01, -2.100602199387045e+00},
	{"OOE", -1.604502672987725e+01, -7.258088659052506e+00},
	{"OOF", -1.354066906230301e+01, -4.753730991478265e+00},
	{"OOG", -1.498671837653703e+01, -6.199780305712280e+00},
	{"OOH", -1.689474416983803e+01, -8.107806099013285e+00},
	{"OOI", -1.709872794939700e+01, -8.311789878572252e+00},
	{"OOJ", -2.070288841944145e+01, -1.191595034861670e+01},
	{"OOK", -1.105672696101418e+01, -2.269788890189437e+00},
	{"OOL", -1.289706966404030e+01, -4.110131593215552e+00},
	{"OOM", -1.315398850054064e+01, -4.367050429715889e+00},
	{"OON", -1.195472614962404e+01, -3.167788078799290e+00},
	{"OOO", -1.767932755812795e+01, -8.892389487303204e+00},
	{"OOP", -1.344540469230528e+01, -4.658466621480527e+00},
	{"OOQ", -2.271234385261934e+01, -1.392540578179459e+01},
	{"OOR", -1.238202030955095e+01, -3.595082238726205e+00},
	{"OOS", -1.397914274406663e+01, -5.192204673241879e+00},
	{"OOT", -1.252965781451069e+01, -3.742719743685948e+00},
	{"OOU", -1.465812903497445e+01, -5.871190964149701e+00},
	{"OOV", -1.610046707335901e+01, -7.313529002534263e+00},
	{"OOW", -1.650797337587713e+01, -7.721035305052383e+00},
	{"OOX", -1.925775713157973e+01, -1.047081906075499e+01},
	{"OOY", -1.945756122555797e+01, -1.067062315473323e+01},
	{"OOZ", -2.025798744989276e+01, -1.147104937906801e+01},
	{"OPA", -1.299582085848800e+01, -3.939311981363689e+00},
	{"OPB", -1.858655008216801e+01, -9.530041205043698e+00},
	{"OPC", -1.822573058449681e+01, -9.169221707372500e+00},
	{"OPD", -1.901690016140417e+01, -9.960391284279856e+00},
	{"OPE", -1.118497091812742e+01, -2.128462041003103e+00},
	{"OPF", -1.858650014413615e+01, -9.529991267011834e+00},
	{"OPG", -2.112370265093640e+01, -1.206719377381209e+01},
	{"OPH", -1.317966270618645e+01, -4.123153829062134e+00},
	{"OPI", -1.319875656976771e+01, -4.142247692643394e+00},
	{"OPJ", -2.213097997786290e+01, -1.307447110073858e+01},
	{"OPK", -2.039597143625421e+01, -1.133946255912990e+01},
	{"OPL", -1.151321556118607e+01, -2.456706684061751e+00},
	{"OPM", -1.525888880712690e+01, -6.202379930002592e+00},
	{"OPN", -2.013037949458260e+01, -1.107387061745828e+01},
	{"OPO", -1.293293243174656e+01, -3.876423554622249e+00},
	{"OPP", -1.269832731103285e+01, -3.641818433908534e+00},
	{"OPQ", -3.233110898520734e+01, -2.327460010808303e+01},
	{"OPR", -1.261556764451591e+01, -3.559058767391595e+00},
	{"OPS", -1.367645160090978e+01, -4.619942723785460e+00},
	{"OPT", -1.450619908213570e+01, -5.449690205011390e+00},
	{"OPU", -1.331572844594394e+01, -4.259219568819625e+00},
	{"OPV", -2.271233782901680e+01, -1.365582895189249e+01},
	{"OPW", -1.773870068324280e+01, -8.682191806118491e+00},
	{"OPX", -3.585922615513766e+01, -2.680271727801335e+01},
	{"OPY", -1.376290874036613e+01, -4.706399863241820e+00},
	{"OPZ", -2.271829217644538e+01, -1.366178329932107e+01},
	{"OQA", -2.701163818071806e+01, -1.178152115140587e+01},
	{"OQB", -2.963972718557242e+01, -1.440961015626023e+01},
	{"OQC", -2.854878961057423e+01, -1.331867258126204e+01},
	{"OQD", -3.015552419799094e+01, -1.492540716867875e+01},
	{"OQE", -3.054932558980659e+01, -1.531920856049440e+01},
	{"OQF", -2.890574902451077e+01, -1.367563199519858e+01},
	{"OQG", -3.562505396344470e+01, -2.039493693413251e+01},
	{"OQH", -2.369511881737086e+01, -8.465001788058668e+00},
	{"OQI", -2.535134925381438e+01, -1.012123222450219e+01},
	{"OQJ", -3.142510042106412e+01, -1.619498339175193e+01},
	{"OQK", -3.725723915838345e+01, -2.202712212907126e+01},
	{"OQL", -2.990217621936533e+01, -1.467205919005314e+01},
	{"OQM", -2.907699543154417e+01, -1.384687840223198e+01},
	{"OQN", -3.190910675419338e+01, -1.667898972488119e+01},
	{"OQO", -3.010555258491882e+01, -1.487543555560663e+01},
	{"OQP", -3.010204649436606e+01, -1.487192946505388e+01},
	{"OQQ", -3.198914092008178e+01, -1.675902389076959e+01},
	{"OQR", -2.995444142279654e+01, -1.472432439348435e+01},
	{"OQS", -2.702675357808529e+01, -1.179663654877310e+01},
	{"OQT", -2.089992945682300e+01, -5.669812427510812e+00},
	{"OQU", -1.526594398803244e+01, -3.582695872025282e-02},
	{"OQV", -3.282029460043506e+01, -1.759017757112287e+01},
	{"OQW", -2.917555572955973e+01, -1.394543870024754e+01},
	{"OQX", -3.928037111626637e+01, -2.405025408695419e+01},
	{"OQY", -3.347309131771316e+01, -1.824297428840097e+01},
	{"OQZ", -4.041993855301691e+01, -2.518982152370472e+01},
	{"ORA", -1.056501321480745e+01, -3.937716021363383e+00},
	{"ORB", -1.283061501937963e+01, -6.203317825935557e+00},
	{"ORC", -1.184246081406726e+01, -5.215163620623194e+00},
	{"ORD", -9.548881251673201e+00, -2.921584058229131e+00},
	{"ORE", -9.322800761367072e+00, -2.695503567923003e+00},
	{"ORF", -1.315912991209984e+01, -6.531832718655768e+00},
	{"ORG", -1.216594506173944e+01, -5.538647868295365e+00},
	{"ORH", -1.210900437179229e+01, -5.481707178348220e+00},
	{"ORI", -1.075508609417875e+01, -4.127788900734681e+00},
	{"ORJ", -1.563646481238103e+01, -9.009167618936958e+00},
	{"ORK", -1.118345930888806e+01, -4.556162115443990e+00},
	{"ORL", -1.229761122488110e+01, -5.670314031437030e+00},
	{"ORM", -1.074319603324470e+01, -4.115898839800630e+00},
	{"ORN", -1.161891010842797e+01, -4.991612914983903e+00},
	{"ORO", -1.179631119248905e+01, -5.169013999044979e+00},
	{"ORP", -1.272071692111289e+01, -6.093419727668822e+00},
	{"ORQ", -1.786047365031757e+01, -1.123317645687350e+01},
	{"ORR", -1.220484023251229e+01, -5.577543039068217e+00},
	{"ORS", -1.087436403333175e+01, -4.247066839887680e+00},
	{"ORT", -9.219711582931145e+00, -2.592414389487075e+00},
	{"ORU", -1.372374771224938e+01, -7.096450518805311e+00},
	{"ORV", -1.581648496228579e+01, -9.189187768841720e+00},
	{"ORW", -1.225050728216166e+01, -5.623210088717589e+00},
	{"ORX", -2.271222248036107e+01, -1.608492528691700e+01},
	{"ORY", -1.164171043460935e+01, -5.014413241165282e+00},
	{"ORZ", -1.847070447607425e+01, -1.184340728263018e+01},
	{"OSA", -1.316361097280212e+01, -4.620672340578979e+00},
	{"OSB", -1.815084077582663e+01, -9.607902143603496e+00},
	{"OSC", -1.507603485252369e+01, -6.533096220300549e+00},
	{"OSD", -1.978566804636355e+01, -1.124272941414041e+01},
	{"OSE", -1.010812653166659e+01, -1.565187899443456e+00},
	{"OSF", -1.878998880329983e+01, -1.024705017107670e+01},
	{"OSG", -1.890293548273921e+01, -1.035999685051608e+01},
	{"OSH", -1.310240547069155e+01, -4.559466838468416e+00},
	{"OSI", -1.209818316346516e+01, -3.555244531242022e+00},
	{"OSJ", -2.071161148919175e+01, -1.216867285696861e+01},
	{"OSK", -1.912604125675636e+01, -1.058310262453323e+01},
	{"OSL", -1.558763016854507e+01, -7.044691536321932e+00},
	{"OSM", -1.601533376418283e+01, -7.472395131959695e+00},
	{"OSN", -1.853622135907946e+01, -9.993282726856318e+00},
	{"OSO", -1.306209187803617e+01, -4.519153245813033e+00},
	{"OSP", -1.321516579386283e+01, -4.672227161639690e+00},
	{"OSQ", -1.843182419064374e+01, -9.888885558420601e+00},
	{"OSR", -1.998874844336807e+01, -1.144580981114494e+01},
	{"OSS", -1.173377061512402e+01, -3.190831982900879e+00},
	{"OST", -1.065064620156237e+01, -2.107707569339234e+00},
	{"OSU", -1.353037715214342e+01, -4.987438519920286e+00},
	{"OSV", -2.169302827631634e+01, -1.315008964409320e+01},
	{"OSW", -1.634500854457770e+01, -7.802069912354562e+00},
	{"OSX", -3.033932656199835e+01, -2.179638792977521e+01},
	{"OSY", -1.696186208464803e+01, -8.418923452424893e+00},
	{"OSZ", -3.180230103410848e+01, -2.325936240188534e+01},
	{"OTA", -1.174670836526653e+01, -4.230666114783647e+00},
	{"OTB", -1.260164061679893e+01, -5.085598366316043e+00},
	{"OTC", -1.372693708533017e+01, -6.210894834847285e+00},
	{"OTD", -1.409281049865683e+01, -6.576768248173945e+00},
	{"OTE", -1.140245966304626e+01, -3.886417412563375e+00},
	{"OTF", -1.374694625742943e+01, -6.230904006946544e+00},
	{"OTG", -1.476137178370461e+01, -7.245329533221726e+00},
	{"OTH", -8.443526368550271e+00, -9.274841180673854e-01},
	{"OTI", -1.211362904178202e+01, -4.597586791299132e+00},
	{"OTJ", -1.765216870063424e+01, -1.013612645015136e+01},
	{"OTK", -1.547073616084961e+01, -7.954693910366725e+00},
	{"OTL", -1.407975129827344e+01, -6.563709047790552e+00},
	{"OTM", -1.401102942382057e+01, -6.494987173337687e+00},
	{"OTN", -1.407107290780314e+01, -6.555030657320258e+00},
	{"OTO", -1.198246245349619e+01, -4.466420203013302e+00},
	{"OTP", -1.437418910694270e+01, -6.858146856459819e+00},
	{"OTQ", -1.781175180910352e+01, -1.029570955862063e+01},
	{"OTR", -1.339024434589381e+01, -5.874202095410924e+00},
	{"OTS", -1.241108462532353e+01, -4.895042374840639e+00},
	{"OTT", -1.155064333140580e+01, -4.034601080922909e+00},
	{"OTU", -1.412915800447992e+01, -6.613115753997033e+00},
	{"OTV", -1.653863135456385e+01, -9.022589104080966e+00},
	{"OTW", -1.335951628310647e+01, -5.843474032623586e+00},
	{"OTX", -3.371230406021004e+01, -2.619626180972715e+01},
	{"OTY", -1.501334326926843e+01, -7.497301018785542e+00},
	{"OTZ", -2.113246491989224e+01, -1.361642266940935e+01},
	{"OUA", -1.243065834323668e+01, -5.590066332522171e+00},
	{"OUB", -1.253048230420158e+01, -5.689890293487065e+00},
	{"OUC", -1.295142311926712e+01, -6.110831108552607e+00},
	{"OUD", -1.272756323834502e+01, -5.886971227630509e+00},
	{"OUE", -1.562727712693117e+01, -8.786685116216661e+00},
	{"OUF", -1.447042218176825e+01, -7.629830171053739e+00},
	{"OUG", -1.024599413531739e+01, -3.405402124602874e+00},
	{"OUH", -1.297893627709644e+01, -6.138344266381929e+00},
	{"OUI", -1.348669997395022e+01, -6.646107963235710e+00},
	{"OUJ", -1.750924329477235e+01, -1.066865128405784e+01},
	{"OUK", -1.490155406685250e+01, -8.060962056137990e+00},
	{"OUL", -9.905805240205771e+00, -3.065213229491258e+00},
	{"OUM", -1.343702908002603e+01, -6.596437069311516e+00},
	{"OUN", -9.552615398867349e+00, -2.712023388152836e+00},
	{"OUO", -1.490799135296605e+01, -8.067399342251539e+00},
	{"OUP", -1.340434718395005e+01, -6.563755173235534e+00},
	{"OUQ", -1.939672315245797e+01, -1.255613114174345e+01},
	{"OUR", -9.396988472322681e+00, -2.556396461608168e+00},
	{"OUS", -9.609482428806608e+00, -2.768890418092094e+00},
	{"OUT", -9.422643851325208e+00, -2.582051840610695e+00},
	{"OUU", -1.629243428675682e+01, -9.451842276042305e+00},
	{"OUV", -1.634358145771225e+01, -9.502989446997734e+00},
	{"OUW", -1.308118725516746e+01, -6.240595244452943e+00},
	{"OUX", -2.001625563805552e+01, -1.317566362734101e+01},
	{"OUY", -1.630913876673717e+01, -9.468546756022654e+00},
	{"OUZ", -2.001562255805215e+01, -1.317503054733764e+01},
	{"OVA", -1.506778214799456e+01, -5.622131265527448e+00},
	{"OVB", -2.271605104451373e+01, -1.327040016204662e+01},
	{"OVC", -2.271639252612045e+01, -1.327074164365334e+01},
	{"OVD", -2.171680421027059e+01, -1.227115332780348e+01},
	{"OVE", -9.708466763476975e+00, -2.628158810098604e-01},
	{"OVF", -2.271528609765309e+01, -1.326963521518598e+01},
	{"OVG", -2.171813055319022e+01, -1.227247967072311e+01},
	{"OVH", -3.040263986151822e+01, -2.095698897905111e+01},
	{"OVI", -1.241340863555697e+01, -2.967757753089858e+00},
	{"OVJ", -2.271731918362791e+01, -1.327166830116080e+01},
	{"OVK", -3.449728548527719e+01, -2.505163460281007e+01},
	{"OVL", -2.371336493369020e+01, -1.426771405122309e+01},
	{"OVM", -2.025844407847266e+01, -1.081279319600554e+01},
	{"OVN", -2.212716678445729e+01, -1.268151590199018e+01},
	{"OVO", -1.567844955099962e+01, -6.232798668532509e+00},
	{"OVP", -3.084309244521986e+01, -2.139744156275275e+01},
	{"OVQ", -3.844948025861267e+01, -2.900382937614555e+01},
	{"OVR", -1.946870467285073e+01, -1.002305379038362e+01},
	{"OVS", -2.212701685019470e+01, -1.268136596772759e+01},
	{"OVT", -2.039361732454831e+01, -1.094796644208120e+01},
	{"OVU", -1.890992959471738e+01, -9.464278712250266e+00},
	{"OVV", -3.329021683253970e+01, -2.384456595007258e+01},
	{"OVW", -2.113168369154788e+01, -1.168603280908077e+01},
	{"OVX", -3.490673000403631e+01, -2.546107912156919e+01},
	{"OVY", -2.167957077351106e+01, -1.223391989104395e+01},
	{"OVZ", -3.848517995826705e+01, -2.903952907579994e+01},
	{"OWA", -1.157921269407743e+01, -3.349099511556266e+00},
	{"OWB", -1.454117802591813e+01, -6.311064843396964e+00},
	{"OWC", -1.455369789212279e+01, -6.323584709601627e+00},
	{"OWD", -1.381626600715983e+01, -5.586152824638670e+00},
	{"OWE", -1.066182719780408e+01, -2.431714015282910e+00},
	{"OWF", -1.467962727901959e+01, -6.449514096498420e+00},
	{"OWG", -1.597031885207472e+01, -7.740205669553556e+00},
	{"OWH", -1.248406481181022e+01, -4.253951629289057e+00},
	{"OWI", -1.169624939346793e+01, -3.466136210946768e+00},
	{"OWJ", -1.781149255725989e+01, -9.581379374738729e+00},
	{"OWK", -1.796349645728721e+01, -9.733383274766050e+00},
	{"OWL", -1.291696309031704e+01, -4.686849907795875e+00},
	{"OWM", -1.419503044820794e+01, -5.964917265686774e+00},
	{"OWN", -1.031781031323274e+01, -2.087697130711578e+00},
	{"OWO", -1.336294521444005e+01, -5.132832031918882e+00},
	{"OWP", -1.536543135835981e+01, -7.135318175838647e+00},
	{"OWQ", -1.981164702309990e+01, -1.158153384057874e+01},
	{"OWR", -1.493308467319702e+01, -6.702971490675849e+00},
	{"OWS", -1.244477694216039e+01, -4.214663759639222e+00},
	{"OWT", -1.192137826363855e+01, -3.691265081117386e+00},
	{"OWU", -1.595698744051375e+01, -7.726874257992582e+00},
	{"OWV", -1.716403717777257e+01, -8.933923995251400e+00},
	{"OWW", -1.343318780703273e+01, -5.203074624511568e+00},
	{"OWX", -3.928670645362124e+01, -3.105659327110008e+01},
	{"OWY", -1.517151964386985e+01, -6.941406461348687e+00},
	{"OWZ", -2.071849282082580e+01, -1.248837963830463e+01},
	{"OXA", -1.752878709328078e+01, -3.746939104379226e+00},
	{"OXB", -2.111416029868000e+01, -7.332312309778444e+00},
	{"OXC", -1.956066024412702e+01, -5.778812255225469e+00},
	{"OXD", -2.052888899435800e+01, -6.747041005456437e+00},
	{"OXE", -1.607813983090994e+01, -2.296291842008381e+00},
	{"OXF", -1.825658300778154e+01, -4.474735018879983e+00},
	{"OXG", -2.071115463906981e+01, -6.929306650168259e+00},
	{"OXH", -1.950190334301636e+01, -5.720055354114804e+00},
	{"OXI", -1.563925502458537e+01, -1.857407035683812e+00},
	{"OXJ", -2.171234990114848e+01, -7.930501912246921e+00},
	{"OXK", -2.370364664182208e+01, -9.921798652920524e+00},
	{"OXL", -2.136268078742668e+01, -7.580832798525120e+00},
	{"OXM", -2.204017098798271e+01, -8.258322999081152e+00},
	{"OXN", -2.112640217051529e+01, -7.344554181613737e+00},
	{"OXO", -1.800836540358577e+01, -4.226517414684217e+00},
	{"OXP", -1.961518240144963e+01, -5.833334412548073e+00},
	{"OXQ", -2.818531323884354e+01, -1.440346524994199e+01},
	{"OXR", -2.069885231042197e+01, -6.917004321520411e+00},
	{"OXS", -1.895481697212437e+01, -5.172968983222812e+00},
	{"OXT", -1.774649696564743e+01, -3.964648976745872e+00},
	{"OXU", -2.160484612760234e+01, -7.822998138700783e+00},
	{"OXV", -2.493206400276098e+01, -1.115021601385942e+01},
	{"OXW", -1.979496201762097e+01, -6.013114028719410e+00},
	{"OXX", -2.571756635694044e+01, -1.193571836803888e+01},
	{"OXY", -1.674015952863079e+01, -2.958311539729234e+00},
	{"OXZ", -3.972384031770933e+01, -2.594199232880777e+01},
	{"OYA", -1.353115534343057e+01, -2.605443342672540e+00},
	{"OYB", -1.781411845045903e+01, -6.888406449701007e+00},
	{"OYC", -1.855562114894207e+01, -7.629909148184040e+00},
	{"OYD", -1.837350778200393e+01, -7.447795781245902e+00},
	{"OYE", -1.312274619116655e+01, -2.197034190408520e+00},
	{"OYF", -1.710703412120708e+01, -6.181322120449059e+00},
	{"OYG", -1.951935599190944e+01, -8.593643991151408e+00},
	{"OYH", -1.665384186980712e+01, -5.728129869049094e+00},
	{"OYI", -1.536810218160719e+01, -4.442390180849166e+00},
	{"OYJ", -2.209169779805633e+01, -1.116598579729831e+01},
	{"OYK", -2.136766561831739e+01, -1.044195361755936e+01},
	{"OYL", -1.808814186396382e+01, -7.162429863205795e+00},
	{"OYM", -1.588692929884581e+01, -4.961217298087789e+00},
	{"OYN", -1.849447989378555e+01, -7.568767893027519e+00},
	{"OYO", -1.265037179062703e+01, -1.724659789869003e+00},
	{"OYP", -1.908752514601820e+01, -8.161813145260179e+00},
	{"OYQ", -2.912368721064074e+01, -1.819797520988271e+01},
	{"OYR", -1.985151341024389e+01, -8.925801409485866e+00},
	{"OYS", -1.453572775227416e+01, -3.610015751516132e+00},
	{"OYT", -1.511686428044543e+01, -4.191152279687404e+00},
	{"OYU", -1.911956619718094e+01, -8.193854196422913e+00},
	{"OYV", -2.088898336864166e+01, -9.963271367883641e+00},
	{"OYW", -1.668235698986117e+01, -5.756644989103139e+00},
	{"OYX", -3.119442950417463e+01, -2.026871750341660e+01},
	{"OYY", -1.890242323222135e+01, -7.976711231463326e+00},
	{"OYZ", -3.054068052241630e+01, -1.961496852165827e+01},
	{"OZA", -1.787688819309242e+01, -2.866150400783716e+00},
	{"OZB", -2.209630333672806e+01, -7.085565544419355e+00},
	{"OZC", -2.365663854155726e+01, -8.645900749248559e+00},
	{"OZD", -2.852199439733741e+01, -1.351125660502871e+01},
	{"OZE", -1.611940215237111e+01, -1.108664360062410e+00},
	{"OZF", -2.811102765469264e+01, -1.310028986238394e+01},
	{"OZG", -2.863399682781986e+01, -1.362325903551116e+01},
	{"OZH", -2.725073395796974e+01, -1.223999616566105e+01},
	{"OZI", -1.795687873318349e+01, -2.946140940874789e+00},
	{"OZJ", -3.115772152997702e+01, -1.614698373766832e+01},
	{"OZK", -2.978864184050222e+01, -1.477790404819352e+01},
	{"OZL", -2.334869874436448e+01, -8.337960952055781e+00},
	{"OZM", -2.090108888914312e+01, -5.890351096834418e+00},
	{"OZN", -2.139105596916443e+01, -6.380318176855729e+00},
	{"OZO", -1.765667946789977e+01, -2.645941675591074e+00},
	{"OZP", -2.660960006332838e+01, -1.159886227101968e+01},
	{"OZQ", -3.507393541930037e+01, -2.006319762699167e+01},
	{"OZR", -2.068010977138155e+01, -5.669371979072849e+00},
	{"OZS", -2.210052292429532e+01, -7.089785131986616e+00},
	{"OZT", -2.133896609628406e+01, -6.328228303975356e+00},
	{"OZU", -2.534385506482738e+01, -1.033311727251867e+01},
	{"OZV", -2.824141622344466e+01, -1.323067843113596e+01},
	{"OZW", -2.168236071467141e+01, -6.671622922362709e+00},
	{"OZX", -3.788207198074521e+01, -2.287133418843651e+01},
	{"OZY", -2.631755122907088e+01, -1.130681343676218e+01},
	{"OZZ", -2.093995050434895e+01, -5.929212712040249e+00},
	{"PAA", -1.819203254274349e+01, -9.469918786993372e+00},
	{"PAB", -1.528984303251345e+01, -6.567729276763332e+00},
	{"PAC", -1.348149634356329e+01, -4.759382587813173e+00},
	{"PAD", -1.588507759195507e+01, -7.162963836204950e+00},
	{"PAE", -1.822323596928126e+01, -9.501122213531145e+00},
	{"PAF", -1.768933401057668e+01, -8.967220254826559e+00},
	{"PAG", -1.398475109550857e+01, -5.262637339758449e+00},
	{"PAH", -1.769227163168152e+01, -8.970157875931401e+00},
	{"PAI", -1.256831387199272e+01, -3.846200116242607e+00},
	{"PAJ", -2.090561957621394e+01, -1.218350582046383e+01},
	{"PAK", -1.437145798961956e+01, -5.649344233869444e+00},
	{"PAL", -1.329631511075668e+01, -4.574201355006563e+00},
	{"PAM", -1.668632883749360e+01, -7.964215081743488e+00},
	{"PAN", -1.154761223481973e+01, -2.825498479069616e+00},
	{"PAO", -2.054289814957379e+01, -1.182078439382368e+01},
	{"PAP", -1.376963332330445e+01, -5.047519567554331e+00},
	{"PAQ", -1.980897221080187e+01, -1.108685845505176e+01},
	{"PAR", -1.030942111109012e+01, -1.587307355339998e+00},
	{"PAS", -1.152420996395943e+01, -2.802096208209314e+00},
	{"PAT", -1.234721109361762e+01, -3.625097337867506e+00},
	{"PAU", -1.501377305532099e+01, -6.291659299570867e+00},
	{"PAV", -1.715408114166896e+01, -8.431967385918846e+00},
	{"PAW", -1.695976874480336e+01, -8.237654989053242e+00},
	{"PAX", -2.012979948101684e+01, -1.140768572526672e+01},
	{"PAY", -1.386593688751123e+01, -5.143823131761117e+00},
	{"PAZ", -2.112561979083992e+01, -1.240350603508980e+01},
	{"PBA", -1.840151205091209e+01, -4.203352429049972e+00},
	{"PBB", -2.734608442749714e+01, -1.314792480563502e+01},
	{"PBC", -2.138354551160940e+01, -7.185385889747288e+00},
	{"PBD", -2.935546498540630e+01, -1.515730536354419e+01},
	{"PBE", -1.597182068530350e+01, -1.773661063441383e+00},
	{"PBF", -3.094426990278878e+01, -1.674611028092667e+01},
	{"PBG", -3.254079299641482e+01, -1.834263337455270e+01},
	{"PBH", -2.978591145256863e+01, -1.558775183070651e+01},
	{"PBI", -1.986036213478866e+01, -5.662202512926541e+00},
	{"PBJ", -2.734127521158577e+01, -1.314311558972365e+01},
	{"PBK", -3.279660794707586e+01, -1.859844832521375e+01},
	{"PBL", -1.931209128946083e+01, -5.113931667598713e+00},
	{"PBM", -2.911514840832106e+01, -1.491698878645894e+01},
	{"PBN", -2.989419608248044e+01, -1.569603646061833e+01},
	{"PBO", -1.766948834914550e+01, -3.471328727283386e+00},
	{"PBP", -2.370754655816259e+01, -9.509386936300478e+00},
	{"PBQ", -3.666399901852294e+01, -2.246583939666082e+01},
	{"PBR", -1.816835448421290e+01, -3.970194862350780e+00},
	{"PBS", -2.343585422703592e+01, -9.237694605173807e+00},
	{"PBT", -2.659551494417884e+01, -1.239735532231673e+01},
	{"PBU", -1.628974341074323e+01, -2.091583788881115e+00},
	{"PBV", -3.057850564797370e+01, -1.638034602611158e+01},
	{"PBW", -2.998182505160210e+01, -1.578366542973998e+01},
	{"PBX", -3.995120685776354e+01, -2.575304723590142e+01},
	{"PBY", -1.648033274387569e+01, -2.282173122013572e+00},
	{"PBZ", -3.445931073353093e+01, -2.026115111166882e+01},
	{"PCA", -1.738108237257823e+01, -2.287050941017085e+00},
	{"PCB", -3.003203053367548e+01, -1.493799910211433e+01},
	{"PCC", -2.249125695761540e+01, -7.397225526054254e+00},
	{"PCD", -2.900331606208582e+01, -1.390928463052466e+01},
	{"PCE", -1.958569149744508e+01, -4.491660065883931e+00},
	{"PCF", -2.989084066741839e+01, -1.479680923585724e+01},
	{"PCG", -3.084639211884854e+01, -1.575236068728739e+01},
	{"PCH", -1.782592683745794e+01, -2.731895405896789e+00},
	{"PCI", -2.057237190417989e+01, -5.478340472618736e+00},
	{"PCJ", -3.281061178817499e+01, -1.771658035661384e+01},
	{"PCK", -2.452481044609659e+01, -9.430779014535448e+00},
	{"PCL", -1.869549183714792e+01, -3.601460405586767e+00},
	{"PCM", -2.979898174827492e+01, -1.470495031671376e+01},
	{"PCN", -3.066528678389999e+01, -1.557125535233884e+01},
	{"PCO", -1.640729832183862e+01, -1.313266890277478e+00},
	{"PCP", -2.368506597078128e+01, -8.591034539220139e+00},
	{"PCQ", -2.919492250095957e+01, -1.410089106939843e+01},
	{"PCR", -1.975881825974946e+01, -4.664786828188315e+00},
	{"PCS", -2.169669252213324e+01, -6.602661090572089e+00},
	{"PCT", -2.198627461329100e+01, -6.892243181729850e+00},
	{"PCU", -2.046943318414557e+01, -5.375401752584421e+00},
	{"PCV", -3.243117967934455e+01, -1.733714824778340e+01},
	{"PCW", -2.816831821963613e+01, -1.307428678807498e+01},
	{"PCX", -3.373124064480686e+01, -1.863720921324571e+01},
	{"PCY", -2.677254502021079e+01, -1.167851358864965e+01},
	{"PCZ", -3.241445995149110e+01, -1.732042851992996e+01},
	{"PDA", -1.810477022181919e+01, -2.473896172166235e+00},
	{"PDB", -2.516812767624963e+01, -9.537253626596678e+00},
	{"PDC", -2.631353374104706e+01, -1.068265969139411e+01},
	{"PDD", -2.610488232519017e+01, -1.047400827553721e+01},
	{"PDE", -1.733949374629674e+01, -1.708619696643777e+00},
	{"PDF", -2.582130322312750e+01, -1.019042917347455e+01},
	{"PDG", -2.654823979381610e+01, -1.091736574416314e+01},
	{"PDH", -2.517415588865164e+01, -9.543281838998686e+00},
	{"PDI", -1.825674979478758e+01, -2.625875745134622e+00},
	{"PDJ", -2.365407038546884e+01, -8.023196335815880e+00},
	{"PDK", -2.935298360477598e+01, -1.372210955512302e+01},
	{"PDL", -2.637680383607925e+01, -1.074592978642630e+01},
	{"PDM", -2.593064771638703e+01, -1.029977366673407e+01},
	{"PDN", -2.619973277894160e+01, -1.056885872928864e+01},
	{"PDO", -1.794484381839089e+01, -2.313969768737933e+00},
	{"PDP", -2.658716364653976e+01, -1.095628959688681e+01},
	{"PDQ", -3.079687513528950e+01, -1.516600108563655e+01},
	{"PDR", -1.960684467676887e+01, -3.975970627115911e+00},
	{"PDS", -2.446513605647282e+01, -8.834262006819866e+00},
	{"PDT", -2.353539570094737e+01, -7.904521651294409e+00},
	{"PDU", -1.952660262700867e+01, -3.895728577355716e+00},
	{"PDV", -2.788214492903648e+01, -1.225127087938352e+01},
	{"PDW", -2.525434828396808e+01, -9.623474234315127e+00},
	{"PDX", -3.569606543656370e+01, -2.006519138691074e+01},
	{"PDY", -2.662286803555351e+01, -1.099199398590056e+01},
	{"PDZ", -3.177850723688220e+01, -1.614763318722924e+01},
	{"PEA", -1.123642501874657e+01, -2.893945182892806e+00},
	{"PEB", -1.664797280053583e+01, -8.305492964682074e+00},
	{"PEC", -1.196841982555637e+01, -3.625939989702608e+00},
	{"PED", -1.240746303567327e+01, -4.064983199819507e+00},
	{"PEE", -1.411157794589458e+01, -5.769098110040821e+00},
	{"PEF", -1.619765721328050e+01, -7.855177377426746e+00},
	{"PEG", -1.824683169711392e+01, -9.904351861260162e+00},
	{"PEH", -1.675864071169344e+01, -8.416160875839683e+00},
	{"PEI", -1.559536560374358e+01, -7.252885767889822e+00},
	{"PEJ", -2.038995399906980e+01, -1.204747416321604e+01},
	{"PEK", -1.970753691135089e+01, -1.136505707549713e+01},
	{"PEL", -1.395199397441914e+01, -5.609514138565383e+00},
	{"PEM", -1.745234398491353e+01, -9.109864149059771e+00},
	{"PEN", -1.111155337594263e+01, -2.769073540088868e+00},
	{"PEO", -1.157416277974886e+01, -3.231682943895103e+00},
	{"PEP", -1.777196909200429e+01, -9.429489256150536e+00},
	{"PEQ", -2.070649512898338e+01, -1.236401529312962e+01},
	{"PER", -9.946592291558693e+00, -1.604112455704934e+00},
	{"PES", -1.371363213670076e+01, -5.371152300847004e+00},
	{"PET", -1.289562433357089e+01, -4.553144497717128e+00},
	{"PEU", -1.895385176491689e+01, -1.061137192906313e+01},
	{"PEV", -1.766433624497362e+01, -9.321856409119864e+00},
	{"PEW", -1.588739062845287e+01, -7.544910792599111e+00},
	{"PEX", -1.858084875296333e+01, -1.023836891710957e+01},
	{"PEY", -1.558726405067219e+01, -7.244784214818436e+00},
	{"PEZ", -2.982312638781662e+01, -2.148064655196286e+01},
	{"PFA", -1.745166012326888e+01, -3.277276831582812e+00},
	{"PFB", -2.680615368691837e+01, -1.263177039523231e+01},
	{"PFC", -2.621963991802203e+01, -1.204525662633596e+01},
	{"PFD", -2.710199872703260e+01, -1.292761543534654e+01},
	{"PFE", -1.955831063843733e+01, -5.383927346751266e+00},
	{"PFF", -2.453172836880691e+01, -1.035734507712084e+01},
	{"PFG", -2.355345044075592e+01, -9.379067149069854e+00},
	{"PFH", -2.555680205978434e+01, -1.138241876809828e+01},
	{"PFI", -1.771786391347537e+01, -3.543480621789302e+00},
	{"PFJ", -2.754486282080808e+01, -1.337047952912201e+01},
	{"PFK", -2.944104358575760e+01, -1.526666029407154e+01},
	{"PFL", -1.987669828804458e+01, -5.702314996358514e+00},
	{"PFM", -2.588822979783171e+01, -1.171384650614565e+01},
	{"PFN", -2.750978470539901e+01, -1.333540141371294e+01},
	{"PFO", -1.548104380259080e+01, -1.306660510904739e+00},
	{"PFP", -2.642026265234697e+01, -1.224587936066090e+01},
	{"PFQ", -3.168788915603018e+01, -1.751350586434412e+01},
	{"PFR", -1.591270650670985e+01, -1.738323215023791e+00},
	{"PFS", -2.574784946944500e+01, -1.157346617775894e+01},
	{"PFT", -2.272875038986770e+01, -8.554367098181631e+00},
	{"PFU", -1.831473618447911e+01, -4.140352892793043e+00},
	{"PFV", -2.872187144933463e+01, -1.454748815764856e+01},
	{"PFW", -2.647418637393330e+01, -1.229980308224723e+01},
	{"PFX", -3.399926066036369e+01, -1.982487736867762e+01},
	{"PFY", -2.711671871813966e+01, -1.294233542645359e+01},
	{"PFZ", -3.012785411989022e+01, -1.595347082820415e+01},
	{"PGA", -1.937448942056932e+01, -4.392411296577245e+00},
	{"PGB", -2.656669999378013e+01, -1.158462186978805e+01},
	{"PGC", -2.681772655378955e+01, -1.183564842979748e+01},
	{"PGD", -1.946257192088214e+01, -4.480493796890064e+00},
	{"PGE", -1.941693855046502e+01, -4.434860426472942e+00},
	{"PGF", -2.637198172193347e+01, -1.138990359794139e+01},
	{"PGG", -2.651390052252951e+01, -1.153182239853744e+01},
	{"PGH", -2.303636497429517e+01, -8.054286850303097e+00},
	{"PGI", -2.041068646222229e+01, -5.428608338230218e+00},
	{"PGJ", -3.004175113047303e+01, -1.505967300648095e+01},
	{"PGK", -3.028006506377027e+01, -1.529798693977819e+01},
	{"PGL", -1.629865852472478e+01, -1.316580400732704e+00},
	{"PGM", -2.632419539809349e+01, -1.134211727410141e+01},
	{"PGN", -2.543702715547683e+01, -1.045494903148475e+01},
	{"PGO", -1.824980200296991e+01, -3.267723878977835e+00},
	{"PGP", -2.680998755499528e+01, -1.182790943100320e+01},
	{"PGQ", -3.157314415838833e+01, -1.659106603439626e+01},
	{"PGR", -1.872036659938723e+01, -3.738288475395152e+00},
	{"PGS", -1.744358102921365e+01, -2.461502905221576e+00},
	{"PGT", -2.214921495481697e+01, -7.167136830824894e+00},
	{"PGU", -1.904803248519647e+01, -4.065954361204386e+00},
	{"PGV", -2.941358594030883e+01, -1.443150781631675e+01},
	{"PGW", -2.344907584681177e+01, -8.466997722819695e+00},
	{"PGX", -3.479196462483569e+01, -1.980988650084362e+01},
	{"PGY", -2.676657477964826e+01, -1.178449665565619e+01},
	{"PGZ", -3.338021813886792e+01, -1.839814001487584e+01},
	{"PHA", -1.313858443764608e+01, -2.747406811022337e+00},
	{"PHB", -1.813072713899952e+01, -7.739549512375778e+00},
	{"PHC", -1.796108672436902e+01, -7.569909097745279e+00},
	{"PHD", -1.932133289922059e+01, -8.930155272596849e+00},
	{"PHE", -1.260661940293208e+01, -2.215441776308339e+00},
	{"PHF", -1.626667677245492e+01, -5.875499145831178e+00},
	{"PHG", -2.054053937186007e+01, -1.014936174523633e+01},
	{"PHH", -1.828523917477214e+01, -7.894061548148405e+00},
	{"PHI", -1.239109235486487e+01, -1.999914728241122e+00},
	{"PHJ", -2.139285024267341e+01, -1.100167261604967e+01},
	{"PHK", -2.212850247805964e+01, -1.173732485143590e+01},
	{"PHL", -1.701730491120951e+01, -6.626127284585771e+00},
	{"PHM", -1.901043185476047e+01, -8.619254228136727e+00},
	{"PHN", -1.919043728636872e+01, -8.799259659744974e+00},
	{"PHO", -1.331366212301877e+01, -2.922484496395028e+00},
	{"PHP", -1.939110428566823e+01, -8.999926659044489e+00},
	{"PHQ", -3.166779684961491e+01, -2.127661922299116e+01},
	{"PHR", -1.472911908991628e+01, -4.337941463292536e+00},
	{"PHS", -1.562487358914091e+01, -5.233695962517167e+00},
	{"PHT", -1.561459359671689e+01, -5.223415970093150e+00},
	{"PHU", -1.672644554435002e+01, -6.335267917726275e+00},
	{"PHV", -2.271036484887306e+01, -1.231918722224932e+01},
	{"PHW", -1.716124082584297e+01, -6.770063199219233e+00},
	{"PHX", -3.566373387855806e+01, -2.527255625193432e+01},
	{"PHY", -1.408341268832654e+01, -3.692235061702801e+00},
	{"PHZ", -2.271724531501853e+01, -1.232606768839479e+01},
	{"PIA", -1.567602192778386e+01, -5.797173326158708e+00},
	{"PIB", -1.918006694524053e+01, -9.301218343615378e+00},
	{"PIC", -1.348219656087987e+01, -3.603347959254728e+00},
	{"PID", -1.445215739680468e+01, -4.573308795179532e+00},
	{"PIE", -1.312169936107191e+01, -3.242850759446761e+00},
	{"PIF", -1.800390829828192e+01, -8.125059696656775e+00},
	{"PIG", -1.656138969872699e+01, -6.682541097101844e+00},
	{"PIH", -1.854503310149812e+01, -8.666184499872971e+00},
	{"PII", -1.907218317012292e+01, -9.193334568497772e+00},
	{"PIJ", -3.069279463095850e+01, -2.081394602933335e+01},
	{"PIK", -1.866856562348892e+01, -8.789717021863769e+00},
	{"PIL", -1.374526228660360e+01, -3.866413684978454e+00},
	{"PIM", -1.778820187216549e+01, -7.909353270540337e+00},
	{"PIN", -1.195757997813645e+01, -2.078731376511307e+00},
	{"PIO", -1.507323205948675e+01, -5.194383457861602e+00},
	{"PIP", -1.582864924900910e+01, -5.949800647383957e+00},
	{"PIQ", -2.054558341402414e+01, -1.066673481239899e+01},
	{"PIR", -1.241550528111670e+01, -2.536656679491557e+00},
	{"PIS", -1.428614949311992e+01, -4.407300891494770e+00},
	{"PIT", -1.266886306963183e+01, -2.790014468006683e+00},
	{"PIU", -1.716247920093187e+01, -7.283630599306723e+00},
	{"PIV", -1.852392009749593e+01, -8.645071495870779e+00},
	{"PIW", -1.880558188889040e+01, -8.926733287265256e+00},
	{"PIX", -2.169850427441068e+01, -1.181965567278553e+01},
	{"PIY", -3.294909158202926e+01, -2.307024298040412e+01},
	{"PIZ", -1.890627283868302e+01, -9.027424237057874e+00},
	{"PJA", -2.073429338369248e+01, -2.927957959435006e+00},
	{"PJB", -2.957889368771885e+01, -1.177255826346137e+01},
	{"PJC", -3.043220009535731e+01, -1.262586467109983e+01},
	{"PJD", -3.232635767762075e+01, -1.452002225336327e+01},
	{"PJE", -1.995870700789815e+01, -2.152371583640669e+00},
	{"PJF", -3.145004357402503e+01, -1.364370814976756e+01},
	{"PJG", -3.102389553775522e+01, -1.321756011349774e+01},
	{"PJH", -3.022072747685641e+01, -1.241439205259893e+01},
	{"PJI", -2.167693645457810e+01, -3.870601030320616e+00},
	{"PJJ", -3.022652019315596e+01, -1.242018476889849e+01},
	{"PJK", -3.291509170102726e+01, -1.510875627676977e+01},
	{"PJL", -3.142392457026387e+01, -1.361758914600638e+01},
	{"PJM", -3.177984994399132e+01, -1.397351451973384e+01},
	{"PJN", -3.472991967264394e+01, -1.692358424838645e+01},
	{"PJO", -1.985726924216396e+01, -2.050933817906480e+00},
	{"PJP", -3.119170220681035e+01, -1.338536678255287e+01},
	{"PJQ", -3.417795394773623e+01, -1.637161852347875e+01},
	{"PJR", -3.040212868455668e+01, -1.259579326029919e+01},
	{"PJS", -3.084091750108528e+01, -1.303458207682780e+01},
	{"PJT", -3.092507598629033e+01, -1.311874056203284e+01},
	{"PJU", -1.939684721418702e+01, -1.590511789929540e+00},
	{"PJV", -3.779700716733709e+01, -1.999067174307960e+01},
	{"PJW", -3.017126321090806e+01, -1.236492778665058e+01},
	{"PJX", -4.047631257440591e+01, -2.266997715014843e+01},
	{"PJY", -3.694618332525052e+01, -1.913984790099304e+01},
	{"PJZ", -3.505118441870896e+01, -1.724484899445148e+01},
	{"PKA", -2.476349621084405e+01, -7.074240178567670e+00},
	{"PKB", -2.707559267382216e+01, -9.386336641545771e+00},
	{"PKC", -2.750746605614594e+01, -9.818210023869559e+00},
	{"PKD", -2.814067426853144e+01, -1.045141823625506e+01},
	{"PKE", -1.943395094086838e+01, -1.744694908591998e+00},
	{"PKF", -2.697200101194429e+01, -9.282744979667907e+00},
	{"PKG", -2.924460178926144e+01, -1.155534575698506e+01},
	{"PKH", -2.664178914441170e+01, -8.952533112135319e+00},
	{"PKI", -1.889749277149296e+01, -1.208236739216574e+00},
	{"PKJ", -3.082277627066188e+01, -1.313352023838550e+01},
	{"PKK", -2.214306305267779e+01, -4.453807020401409e+00},
	{"PKL", -2.653313492324160e+01, -8.843878890965215e+00},
	{"PKM", -2.750750356518632e+01, -9.818247532909933e+00},
	{"PKN", -2.018716114226635e+01, -2.497905109989972e+00},
	{"PKO", -2.513258468478304e+01, -7.443328652506654e+00},
	{"PKP", -2.785725393734426e+01, -1.016799790506788e+01},
	{"PKQ", -3.350191606523495e+01, -1.581266003295857e+01},
	{"PKR", -2.829243927466830e+01, -1.060318324239192e+01},
	{"PKS", -2.441235378836973e+01, -6.723097756093349e+00},
	{"PKT", -2.517724129554891e+01, -7.487985263272531e+00},
	{"PKU", -2.702530689830407e+01, -9.336050866027687e+00},
	{"PKV", -3.066293133650658e+01, -1.297367530423019e+01},
	{"PKW", -2.634874955949882e+01, -8.659493527222434e+00},
	{"PKX", -3.447396293112822e+01, -1.678470689885183e+01},
	{"PKY", -2.701897069618951e+01, -9.329714663913123e+00},
	{"PKZ", -3.257582581699796e+01, -1.488656978472157e+01},
	{"PLA", -1.062465240075234e+01, -1.499066604242102e+00},
	{"PLB", -2.604067809089504e+01, -1.691509229438480e+01},
	{"PLC", -2.167233838880151e+01, -1.254675259229127e+01},
	{"PLD", -1.908362764263007e+01, -9.958041846119835e+00},
	{"PLE", -1.040490698086387e+01, -1.279321184353631e+00},
	{"PLF", -2.579161447357047e+01, -1.666602867706023e+01},
	{"PLG", -2.747656782132725e+01, -1.835098202481701e+01},
	{"PLH", -2.690780895567232e+01, -1.778222315916208e+01},
	{"PLI", -1.250356641995005e+01, -3.377980623439807e+00},
	{"PLJ", -3.020859543861549e+01, -2.108300964210525e+01},
	{"PLK", -2.748089234192575e+01, -1.835530654541551e+01},
	{"PLL", -2.273293787435547e+01, -1.360735207784523e+01},
	{"PLM", -2.655565355459630e+01, -1.743006775808606e+01},
	{"PLN", -2.726506733640823e+01, -1.813948153989799e+01},
	{"PLO", -1.318427612789496e+01, -4.058690331384722e+00},
	{"PLP", -2.352797481572922e+01, -1.440238901921898e+01},
	{"PLQ", -3.129729969344533e+01, -2.217171389693509e+01},
	{"PLR", -2.707193427831520e+01, -1.794634848180496e+01},
	{"PLS", -2.317252682191373e+01, -1.404694102540350e+01},
	{"PLT", -2.431907398823407e+01, -1.519348819172383e+01},
	{"PLU", -1.476955082647133e+01, -5.643965029961096e+00},
	{"PLV", -2.684126024046294e+01, -1.771567444395270e+01},
	{"PLW", -2.653807658932248e+01, -1.741249079281225e+01},
	{"PLX", -3.459926787757283e+01, -2.547368208106259e+01},
	{"PLY", -1.326875754820881e+01, -4.143171751698574e+00},
	{"PLZ", -3.326075835068859e+01, -2.413517255417835e+01},
	{"PMA", -1.675219083751468e+01, -3.358382001395134e+00},
	{"PMB", -2.149844558839712e+01, -8.104636752277575e+00},
	{"PMC", -2.110848158981004e+01, -7.714672753690494e+00},
	{"PMD", -2.265157689501757e+01, -9.257768058898021e+00},
	{"PME", -1.428862171050397e+01, -8.948128743844198e-01},
	{"PMF", -2.109824112824211e+01, -7.704432292122569e+00},
	{"PMG", -2.268481038573287e+01, -9.291001549613325e+00},
	{"PMH", -2.036910410676247e+01, -6.975295270642929e+00},
	{"PMI", -1.753026200210475e+01, -4.136453165985205e+00},
	{"PMJ", -2.952585734655684e+01, -1.613204851043729e+01},
	{"PMK", -2.983429961066596e+01, -1.644049077454642e+01},
	{"PML", -2.089524663357657e+01, -7.501437797457028e+00},
	{"PMM", -2.122486305015522e+01, -7.831054214035681e+00},
	{"PMN", -2.205649188988511e+01, -8.662683053765562e+00},
	{"PMO", -1.760678633069440e+01, -4.212977494574856e+00},
	{"PMP", -1.767127788536101e+01, -4.277469049241468e+00},
	{"PMQ", -3.244261634108342e+01, -1.904880750496388e+01},
	{"PMR", -2.088555531369124e+01, -7.491746477571692e+00},
	{"PMS", -2.043966021979717e+01, -7.045851383677627e+00},
	{"PMT", -1.902599518174344e+01, -5.632186345623897e+00},
	{"PMU", -1.888066841371410e+01, -5.486859577594560e+00},
	{"PMV", -2.917689751188859e+01, -1.578308867576905e+01},
	{"PMW", -2.253997964925445e+01, -9.146170813134907e+00},
	{"PMX", -3.408230579803688e+01, -2.068849696191734e+01},
	{"PMY", -1.660215741223582e+01, -3.208348576116276e+00},
	{"PMZ", -3.271137991706377e+01, -1.931757108094422e+01},
	{"PNA", -1.959122277955578e+01, -4.065602646594738e+00},
	{"PNB", -2.730179352941614e+01, -1.177617339645509e+01},
	{"PNC", -2.537479134936720e+01, -9.849171216406155e+00},
	{"PND", -2.323499605955412e+01, -7.709375926593076e+00},
	{"PNE", -1.702064277491577e+01, -1.495022641954734e+00},
	{"PNF", -2.705597341327473e+01, -1.153035328031368e+01},
	{"PNG", -2.412395497726587e+01, -8.598334844304830e+00},
	{"PNH", -2.677061244375357e+01, -1.124499231079253e+01},
	{"PNI", -2.104956626621018e+01, -5.523946133249141e+00},
	{"PNJ", -2.946276834699657e+01, -1.393714821403552e+01},
	{"PNK", -2.812001303458099e+01, -1.259439290161995e+01},
	{"PNL", -2.752525765483119e+01, -1.199963752187015e+01},
	{"PNM", -2.747600438344188e+01, -1.195038425048084e+01},
	{"PNN", -2.742712719394090e+01, -1.190150706097986e+01},
	{"PNO", -1.641577835109460e+01, -8.901582181335569e-01},
	{"PNP", -2.796589574650702e+01, -1.244027561354597e+01},
	{"PNQ", -3.037358328618763e+01, -1.484796315322659e+01},
	{"PNR", -2.853222858572140e+01, -1.300660845276036e+01},
	{"PNS", -2.489322765247107e+01, -9.367607519510027e+00},
	{"PNT", -2.350400114933278e+01, -7.978381016371735e+00},
	{"PNU", -2.361378167736788e+01, -8.088161544406836e+00},
	{"PNV", -2.861810266226983e+01, -1.309248252930879e+01},
	{"PNW", -2.697027027053502e+01, -1.144465013757398e+01},
	{"PNX", -3.243015742837033e+01, -1.690453729540929e+01},
	{"PNY", -2.357403883971179e+01, -8.048418706750747e+00},
	{"PNZ", -3.293886247214992e+01, -1.741324233918888e+01},
	{"POA", -2.008444219095147e+01, -1.149334278467881e+01},
	{"POB", -1.818311982110114e+01, -9.592020414828482e+00},
	{"POC", -1.545945766831726e+01, -6.868358262044602e+00},
	{"POD", -1.892814574375015e+01, -1.033704633747749e+01},
	{"POE", -1.515962999290854e+01, -6.568530586635874e+00},
	{"POF", -1.348089461033774e+01, -4.889795204065082e+00},
	{"POG", -1.858045332139611e+01, -9.989353915123443e+00},
	{"POH", -2.022016570312732e+01, -1.162906629685466e+01},
	{"POI", -1.243200351413789e+01, -3.840904107865234e+00},
	{"POJ", -2.721484863946053e+01, -1.862374923318788e+01},
	{"POK", -1.432377014976734e+01, -5.732670743494674e+00},
	{"POL", -1.241446301831968e+01, -3.823363612047014e+00},
	{"POM", -1.487115747739516e+01, -6.280058071122494e+00},
	{"PON", -1.080400566839510e+01, -2.212906262122437e+00},
	{"POO", -1.355038195468759e+01, -4.959282548414926e+00},
	{"POP", -1.387070795132975e+01, -5.279608545057090e+00},
	{"POQ", -3.052309439259765e+01, -2.193199498632498e+01},
	{"POR", -1.138129992392065e+01, -2.790200517647984e+00},
	{"POS", -1.080085536706774e+01, -2.209755960795074e+00},
	{"POT", -1.390039875551003e+01, -5.309299349237369e+00},
	{"POU", -1.364732953469514e+01, -5.056230128422481e+00},
	{"POV", -1.651429210467810e+01, -7.923192698405440e+00},
	{"POW", -1.229348241326168e+01, -3.702383006989014e+00},
	{"POX", -1.913234684954601e+01, -1.054124744327335e+01},
	{"POY", -2.134696162931109e+01, -1.275586222303843e+01},
	{"POZ", -3.030479078069103e+01, -2.171369137441836e+01},
	{"PPA", -1.474121993572642e+01, -4.731455042132223e+00},
	{"PPB", -1.990427924231149e+01, -9.894514348717289e+00},
	{"PPC", -1.858801083935649e+01, -8.578245945762289e+00},
	{"PPD", -2.090613920019064e+01, -1.089637430659644e+01},
	{"PPE", -1.147416925144939e+01, -1.464404357855196e+00},
	{"PPF", -2.053753124839871e+01, -1.052776635480452e+01},
	{"PPG", -1.736057935432897e+01, -7.350814460734770e+00},
	{"PPH", -1.810467684041901e+01, -8.094911946824809e+00},
	{"PPI", -1.381285966573600e+01, -3.803094772141804e+00},
	{"PPJ", -2.371050690097654e+01, -1.370074200738234e+01},
	{"PPK", -2.271432209613744e+01, -1.270455720254324e+01},
	{"PPL", -1.315245185988132e+01, -3.142686966287118e+00},
	{"PPM", -2.037935009543783e+01, -1.036958520184363e+01},
	{"PPN", -2.170878672036538e+01, -1.169902182677118e+01},
	{"PPO", -1.209203605064969e+01, -2.082271157055485e+00},
	{"PPP", -1.988304531641930e+01, -9.873280422825101e+00},
	{"PPQ", -2.171796351530806e+01, -1.170819862171386e+01},
	{"PPR", -1.310062615926319e+01, -3.090861265668987e+00},
	{"PPS", -1.950830228909690e+01, -9.498537395502696e+00},
	{"PPT", -1.769075638112519e+01, -7.680991487530989e+00},
	{"PPU", -1.760922069218295e+01, -7.599455798588752e+00},
	{"PPV", -3.056703505324007e+01, -2.055727015964587e+01},
	{"PPW", -2.167615661022507e+01, -1.166639171663087e+01},
	{"PPX", -3.591812508747081e+01, -2.590836019387660e+01},
	{"PPY", -1.495004172230282e+01, -4.940276828708620e+00},
	{"PPZ", -3.422324071292190e+01, -2.421347581932769e+01},
	{"PQA", -3.037530901573536e+01, -1.131270292581674e+01},
	{"PQB", -3.300273096287764e+01, -1.394012487295901e+01},
	{"PQC", -3.191373018077452e+01, -1.285112409085589e+01},
	{"PQD", -3.352443482296756e+01, -1.446182873304894e+01},
	{"PQE", -3.391232936711180e+01, -1.484972327719318e+01},
	{"PQF", -3.227123376636842e+01, -1.320862767644979e+01},
	{"PQG", -3.898805774074992e+01, -1.992545165083130e+01},
	{"PQH", -3.282279242322754e+01, -1.376018633330891e+01},
	{"PQI", -2.871435303111960e+01, -9.651746941200971e+00},
	{"PQJ", -3.478810419836934e+01, -1.572549810845071e+01},
	{"PQK", -4.062024293568866e+01, -2.155763684577003e+01},
	{"PQL", -3.326517999667054e+01, -1.420257390675192e+01},
	{"PQM", -3.244279315452986e+01, -1.338018706461123e+01},
	{"PQN", -3.527211053149860e+01, -1.620950444157997e+01},
	{"PQO", -3.346855636222404e+01, -1.440595027230541e+01},
	{"PQP", -3.347074174864989e+01, -1.440813565873127e+01},
	{"PQQ", -3.535214469738699e+01, -1.628953860746837e+01},
	{"PQR", -3.331744520010175e+01, -1.425483911018313e+01},
	{"PQS", -3.038975735539050e+01, -1.132715126547188e+01},
	{"PQT", -3.088942835932481e+01, -1.182682226940619e+01},
	{"PQU", -1.906721614709661e+01, -4.610057177986977e-03},
	{"PQV", -3.618329837774027e+01, -1.712069228782164e+01},
	{"PQW", -3.254155120188654e+01, -1.347894511196792e+01},
	{"PQX", -4.264337489357159e+01, -2.358076880365297e+01},
	{"PQY", -3.683609509501837e+01, -1.777348900509975e+01},
	{"PQZ", -4.378294233032212e+01, -2.472033624040349e+01},
	{"PRA", -1.243443096628315e+01, -4.004402110295239e+00},
	{"PRB", -2.663808199186595e+01, -1.820805313587804e+01},
	{"PRC", -2.562919542883384e+01, -1.719916657284593e+01},
	{"PRD", -2.467776694795315e+01, -1.624773809196524e+01},
	{"PRE", -1.016926072488454e+01, -1.739231868896634e+00},
	{"PRF", -2.646745191186107e+01, -1.803742305587316e+01},
	{"PRG", -2.609046931769187e+01, -1.766044046170396e+01},
	{"PRH", -2.087673955566172e+01, -1.244671069967381e+01},
	{"PRI", -1.087973944218163e+01, -2.449710586193721e+00},
	{"PRJ", -2.212544026247882e+01, -1.369541140649091e+01},
	{"PRK", -2.642786617595353e+01, -1.799783731996562e+01},
	{"PRL", -2.629516022666534e+01, -1.786513137067744e+01},
	{"PRM", -2.330352529938760e+01, -1.487349644339969e+01},
	{"PRN", -2.535825430693296e+01, -1.692822545094506e+01},
	{"PRO", -9.601364088223587e+00, -1.171335232235680e+00},
	{"PRP", -2.656093190478331e+01, -1.813090304879540e+01},
	{"PRQ", -3.094697589463341e+01, -2.251694703864550e+01},
	{"PRR", -2.582990801658953e+01, -1.739987916060162e+01},
	{"PRS", -2.406698748158715e+01, -1.563695862559925e+01},
	{"PRT", -2.377530498830616e+01, -1.534527613231825e+01},
	{"PRU", -1.505617861858896e+01, -6.626149762601054e+00},
	{"PRV", -2.687811923455049e+01, -1.844809037856259e+01},
	{"PRW", -2.623368905016372e+01, -1.780366019417581e+01},
	{"PRX", -3.161210206739286e+01, -2.318207321140495e+01},
	{"PRY", -1.917036628145547e+01, -1.074033742546757e+01},
	{"PRZ", -3.251263440229069e+01, -2.408260554630278e+01},
	{"PSA", -1.396756559115038e+01, -2.642825814503298e+00},
	{"PSB", -1.630541227126087e+01, -4.980672494613791e+00},
	{"PSC", -1.685167587256450e+01, -5.526936095917417e+00},
	{"PSD", -1.758348450729500e+01, -6.258744730647926e+00},
	{"PSE", -1.481455387001735e+01, -3.489814093370270e+00},
	{"PSF", -1.664743533846183e+01, -5.322695561814757e+00},
	{"PSG", -1.862390072661855e+01, -7.299160949971474e+00},
	{"PSH", -1.530542598701191e+01, -3.980686210364829e+00},
	{"PSI", -1.470759519237146e+01, -3.382855415724384e+00},
	{"PSJ", -2.071117953302147e+01, -9.386439756374394e+00},
	{"PSK", -1.938699974080486e+01, -8.062259964157780e+00},
	{"PSL", -1.723675880593227e+01, -5.912019029285192e+00},
	{"PSM", -1.688002970257655e+01, -5.555289925929468e+00},
	{"PSN", -1.792866727224134e+01, -6.603927495594267e+00},
	{"PSO", -1.426660341530393e+01, -2.941863638656855e+00},
	{"PSP", -1.707710748427647e+01, -5.752367707629392e+00},
	{"PSQ", -2.112308317637597e+01, -9.798343399728889e+00},
	{"PSR", -1.838664537985838e+01, -7.061905603211303e+00},
	{"PSS", -1.626920590531572e+01, -4.944466128668641e+00},
	{"PST", -1.420205988476132e+01, -2.877320108114248e+00},
	{"PSU", -1.661116881653410e+01, -5.286429039887027e+00},
	{"PSV", -2.089591621514741e+01, -9.571176438500331e+00},
	{"PSW", -1.509335156262468e+01, -3.768611785977603e+00},
	{"PSX", -2.271101613999419e+01, -1.138627636334711e+01},
	{"PSY", -1.748677324791298e+01, -6.162033471265906e+00},
	{"PSZ", -3.174327378155398e+01, -2.041853400490690e+01},
	{"PTA", -1.307530708359065e+01, -3.042366899229020e+00},
	{"PTB", -1.669363352238958e+01, -6.660693338027944e+00},
	{"PTC", -1.719152093416762e+01, -7.158580749805988e+00},
	{"PTD", -1.758638151520123e+01, -7.553441330839595e+00},
	{"PTE", -1.304261975953317e+01, -3.009679575171532e+00},
	{"PTF", -1.582261140111025e+01, -5.789671216748610e+00},
	{"PTG", -1.925224108506654e+01, -9.219300900704903e+00},
	{"PTH", -1.233165086748533e+01, -2.298710683123698e+00},
	{"PTI", -1.244765805505456e+01, -2.414717870692923e+00},
	{"PTJ", -2.001556712482437e+01, -9.982626940462735e+00},
	{"PTK", -2.138896001033894e+01, -1.135601982597730e+01},
	{"PTL", -1.689436885139979e+01, -6.861428667038159e+00},
	{"PTM", -1.690839231089376e+01, -6.875452126532127e+00},
	{"PTN", -1.832148704805303e+01, -8.288546863691392e+00},
	{"PTO", -1.325440653683575e+01, -3.221466352474113e+00},
	{"PTP", -1.822249534322052e+01, -8.189555158858886e+00},
	{"PTQ", -2.271421532801786e+01, -1.268127514365623e+01},
	{"PTR", -1.620411245823051e+01, -6.171172273868877e+00},
	{"PTS", -1.507892337509349e+01, -5.045983190731859e+00},
	{"PTT", -1.402641950283179e+01, -3.993479318470160e+00},
	{"PTU", -1.437332695842962e+01, -4.340386774067989e+00},
	{"PTV", -2.013073366578190e+01, -1.009779348142027e+01},
	{"PTW", -1.591421756962007e+01, -5.881277385258434e+00},
	{"PTX", -3.377107484195158e+01, -2.373813465758995e+01},
	{"PTY", -1.608618461166740e+01, -6.053244427305766e+00},
	{"PTZ", -3.124430829891244e+01, -2.121136811455081e+01},
	{"PUA", -1.817743237172193e+01, -7.887090836206538e+00},
	{"PUB", -1.259184620935135e+01, -2.301504673835965e+00},
	{"PUC", -1.859912789264215e+01, -8.308786357126765e+00},
	{"PUD", -1.770849838374584e+01, -7.418156848230455e+00},
	{"PUE", -2.006768942135542e+01, -9.777347885840030e+00},
	{"PUF", -1.812949839975052e+01, -7.839156864235136e+00},
	{"PUG", -1.868354270197848e+01, -8.393201166463095e+00},
	{"PUH", -2.716792998770701e+01, -1.687758845219162e+01},
	{"PUI", -2.031979605825812e+01, -1.002945452274273e+01},
	{"PUJ", -3.145642040478376e+01, -2.116607886926838e+01},
	{"PUK", -2.362784294427197e+01, -1.333750140875659e+01},
	{"PUL", -1.308789422152677e+01, -2.797552686011380e+00},
	{"PUM", -1.659321569687611e+01, -6.302874161360724e+00},
	{"PUN", -1.432307790443321e+01, -4.032736368917826e+00},
	{"PUO", -2.780172783956728e+01, -1.751138630405190e+01},
	{"PUP", -1.591776060049747e+01, -5.627419064982082e+00},
	{"PUQ", -3.291802435581915e+01, -2.262768282030376e+01},
	{"PUR", -1.255161586797394e+01, -2.261274332458557e+00},
	{"PUS", -1.518000051411792e+01, -4.889658978602538e+00},
	{"PUT", -1.208596740117311e+01, -1.795625865657725e+00},
	{"PUU", -3.025484981145029e+01, -1.996450827593490e+01},
	{"PUV", -2.960349003928028e+01, -1.931314850376490e+01},
	{"PUW", -2.728358124694258e+01, -1.699323971142719e+01},
	{"PUX", -2.987898089982546e+01, -1.958863936431008e+01},
	{"PUY", -2.902997588835428e+01, -1.873963435283889e+01},
	{"PUZ", -1.763098351168104e+01, -7.340641976165650e+00},
	{"PVA", -1.963685123053355e+01, -2.416277505371289e+00},
	{"PVB", -2.372540100283863e+01, -6.504827277676375e+00},
	{"PVC", -2.372575729508983e+01, -6.505183569927576e+00},
	{"PVD", -3.213019165762460e+01, -1.490961793246234e+01},
	{"PVE", -1.947387348552711e+01, -2.253299760364855e+00},
	{"PVF", -3.230820471014570e+01, -1.508763098498344e+01},
	{"PVG", -3.364293129023362e+01, -1.642235756507135e+01},
	{"PVH", -2.214095651228675e+01, -4.920382787124492e+00},
	{"PVI", -1.933239010768552e+01, -2.111816382523257e+00},
	{"PVJ", -3.356578899087423e+01, -1.634521526571197e+01},
	{"PVK", -3.523233697208866e+01, -1.801176324692640e+01},
	{"PVL", -3.271763268533805e+01, -1.549705896017580e+01},
	{"PVM", -3.172809546696621e+01, -1.450752174180396e+01},
	{"PVN", -2.371780903453365e+01, -6.497235309371396e+00},
	{"PVO", -2.079026287454306e+01, -3.569689149380803e+00},
	{"PVP", -3.180074247204802e+01, -1.458016874688576e+01},
	{"PVQ", -3.939758438698804e+01, -2.217701066182578e+01},
	{"PVR", -2.975677801913881e+01, -1.253620429397655e+01},
	{"PVS", -3.079455420867415e+01, -1.357398048351189e+01},
	{"PVT", -1.972728344401872e+01, -2.506709718856460e+00},
	{"PVU", -2.969642799518739e+01, -1.247585427002513e+01},
	{"PVV", -3.429116155259891e+01, -1.707058782743665e+01},
	{"PVW", -2.172662449635004e+01, -4.506050771187785e+00},
	{"PVX", -3.602340520408469e+01, -1.880283147892243e+01},
	{"PVY", -2.784624764005526e+01, -1.062567391489300e+01},
	{"PVZ", -3.943328408664241e+01, -2.221271036148015e+01},
	{"PWA", -1.522788891570016e+01, -1.805557830932598e+00},
	{"PWB", -2.860347756748256e+01, -1.518114648271500e+01},
	{"PWC", -2.866136918640985e+01, -1.523903810164229e+01},
	{"PWD", -2.817485918653357e+01, -1.475252810176601e+01},
	{"PWE", -1.757968316535651e+01, -4.157352080588947e+00},
	{"PWF", -2.845644697266929e+01, -1.503411588790173e+01},
	{"PWG", -2.958319040265495e+01, -1.616085931788739e+01},
	{"PWH", -1.587520170690367e+01, -2.452870622136107e+00},
	{"PWI", -1.502693502662470e+01, -1.604603941857140e+00},
	{"PWJ", -3.092974864142588e+01, -1.750741755665832e+01},
	{"PWK", -3.109489732899838e+01, -1.767256624423082e+01},
	{"PWL", -2.752492958949986e+01, -1.410259850473230e+01},
	{"PWM", -2.822421252002069e+01, -1.480188143525313e+01},
	{"PWN", -2.510005178700411e+01, -1.167772070223655e+01},
	{"PWO", -1.799418286578257e+01, -4.571851781015017e+00},
	{"PWP", -2.931362549263725e+01, -1.589129440786970e+01},
	{"PWQ", -3.356724663934838e+01, -2.014491555458083e+01},
	{"PWR", -1.938850946206826e+01, -5.966178377300699e+00},
	{"PWS", -2.636022413577889e+01, -1.293789305101133e+01},
	{"PWT", -2.623024640092114e+01, -1.280791531615358e+01},
	{"PWU", -2.969685717439750e+01, -1.627452608962994e+01},
	{"PWV", -3.141742000199356e+01, -1.799508891722601e+01},
	{"PWW", -1.693689901208170e+01, -3.514567927314138e+00},
	{"PWX", -4.076105290547380e+01, -2.733872182070624e+01},
	{"PWY", -2.839994144314043e+01, -1.497761035837287e+01},
	{"PWZ", -3.428403655611295e+01, -2.086170547134540e+01},
	{"PXA", -2.603905845720966e+01, -3.475273661883234e+00},
	{"PXB", -3.060638306624411e+01, -8.042598270917683e+00},
	{"PXC", -2.556738272379426e+01, -3.003597928467833e+00},
	{"PXD", -2.999977121916406e+01, -7.435986423837630e+00},
	{"PXE", -2.564485961016373e+01, -3.081074814837305e+00},
	{"PXF", -3.014188068521956e+01, -7.578095889893132e+00},
	{"PXG", -3.144094522533532e+01, -8.877160430008891e+00},
	{"PXH", -2.779911905119863e+01, -5.235334255872204e+00},
	{"PXI", -2.563913850663979e+01, -3.075353711313358e+00},
	{"PXJ", -3.265391435135923e+01, -1.009012955603280e+01},
	{"PXK", -3.355200064180562e+01, -1.098821584647919e+01},
	{"PXL", -3.009923465862909e+01, -7.535449863302660e+00},
	{"PXM", -2.938242027662359e+01, -6.818635481297159e+00},
	{"PXN", -3.189143833318025e+01, -9.327653537853829e+00},
	{"PXO", -2.839679143969888e+01, -5.833006644372449e+00},
	{"PXP", -2.501517973038210e+01, -2.451394935055676e+00},
	{"PXQ", -3.155421000107238e+01, -8.990425205745950e+00},
	{"PXR", -3.017239739902564e+01, -7.608612603699212e+00},
	{"PXS", -2.946156953040795e+01, -6.897784735081517e+00},
	{"PXT", -2.481431458700096e+01, -2.250529791674532e+00},
	{"PXU", -2.867728018654553e+01, -6.113495391219105e+00},
	{"PXV", -2.829945343902363e+01, -5.735668643697197e+00},
	{"PXW", -2.948801255362376e+01, -6.924227758297334e+00},
	{"PXX", -2.908495579320309e+01, -6.521170997876658e+00},
	{"PXY", -2.927146848460892e+01, -6.707683689282498e+00},
	{"PXZ", -4.309122975397197e+01, -2.052744495864555e+01},
	{"PYA", -1.660721066275910e+01, -3.832799210472336e+00},
	{"PYB", -1.933281475255328e+01, -6.558403300266511e+00},
	{"PYC", -1.877263788979407e+01, -5.998226437507296e+00},
	{"PYD", -1.860408475383025e+01, -5.829673301543487e+00},
	{"PYE", -1.786186564843542e+01, -5.087454196148649e+00},
	{"PYF", -1.872782367882143e+01, -5.953412226534657e+00},
	{"PYG", -1.997782067066859e+01, -7.203409218381817e+00},
	{"PYH", -1.891666712474307e+01, -6.142255672456308e+00},
	{"PYI", -1.544081338664324e+01, -2.666401934356473e+00},
	{"PYJ", -2.168732166966404e+01, -8.912910217377274e+00},
	{"PYK", -2.168257171782442e+01, -8.908160265537648e+00},
	{"PYL", -1.775222209750816e+01, -4.977810645221389e+00},
	{"PYM", -1.826441593515167e+01, -5.490004482864903e+00},
	{"PYN", -2.048860210562654e+01, -7.714190653339768e+00},
	{"PYO", -1.546342971444126e+01, -2.689018262154495e+00},
	{"PYP", -1.903067456137768e+01, -6.256263109090910e+00},
	{"PYQ", -2.212283139251654e+01, -9.348419940229771e+00},
	{"PYR", -1.453773534816767e+01, -1.763323895880900e+00},
	{"PYS", -1.800991762010237e+01, -5.235506167815603e+00},
	{"PYT", -1.656355908588343e+01, -3.789147633596658e+00},
	{"PYU", -1.900540472503046e+01, -6.230993272743691e+00},
	{"PYV", -2.088919802215295e+01, -8.114786569866181e+00},
	{"PYW", -1.879861979444935e+01, -6.024208342162585e+00},
	{"PYX", -3.120683302963066e+01, -1.843242157734389e+01},
	{"PYY", -2.087558745706223e+01, -8.101176004775464e+00},
	{"PYZ", -3.054089517592758e+01, -1.776648372364081e+01},
	{"PZA", -2.457782871820934e+01, -3.708928297431813e+00},
	{"PZB", -2.992967196397229e+01, -9.060771543194770e+00},
	{"PZC", -3.081458678221387e+01, -9.945686361436344e+00},
	{"PZD", -3.117375262361670e+01, -1.030485220283918e+01},
	{"PZE", -2.267464072337095e+01, -1.805740302593428e+00},
	{"PZF", -3.076088418999129e+01, -9.891983769213773e+00},
	{"PZG", -3.128385336311851e+01, -1.041495294234099e+01},
	{"PZH", -2.990059049326840e+01, -9.031690072490877e+00},
	{"PZI", -2.209583840171940e+01, -1.226937980941877e+00},
	{"PZJ", -3.380757806527567e+01, -1.293867764449815e+01},
	{"PZK", -3.244307812566203e+01, -1.157417770488451e+01},
	{"PZL", -2.813331326230848e+01, -7.264412841530961e+00},
	{"PZM", -3.034156919199850e+01, -9.472668771220979e+00},
	{"PZN", -3.144439682061815e+01, -1.057549639984063e+01},
	{"PZO", -2.364674007904533e+01, -2.777839658267813e+00},
	{"PZP", -2.925996154084834e+01, -8.391061120070820e+00},
	{"PZQ", -3.772379195459902e+01, -1.685489153382150e+01},
	{"PZR", -2.847271819085071e+01, -7.603817770073191e+00},
	{"PZS", -3.009154093390661e+01, -9.222640513129088e+00},
	{"PZT", -2.859147321502995e+01, -7.722572794252428e+00},
	{"PZU", -2.799371160012603e+01, -7.124811179348506e+00},
	{"PZV", -3.089127275874332e+01, -1.002237233796580e+01},
	{"PZW", -2.955475993387918e+01, -8.685859513101661e+00},
	{"PZX", -4.053192851604386e+01, -1.966302809526634e+01},
	{"PZY", -2.896740776436953e+01, -8.098507343592011e+00},
	{"PZZ", -2.656228606952596e+01, -5.693385648748441e+00},
	{"QAA", -2.781101235320342e+01, -1.114386795748319e+01},
	{"QAB", -2.516271797590512e+01, -8.495573580184887e+00},
	{"QAC", -2.150843667830953e+01, -4.841292282589301e+00},
	{"QAD", -2.184381826424683e+01, -5.176673868526593e+00},
	{"QAE", -1.906386531668772e+01, -2.396720920967484e+00},
	{"QAF", -2.346783113225197e+01, -6.800686736531739e+00},
	{"QAG", -2.526985632060733e+01, -8.602711924887103e+00},
	{"QAH", -2.693141451423748e+01, -1.026427011851725e+01},
	{"QAI", -2.435844929705357e+01, -7.691304901333345e+00},
	{"QAJ", -2.965842971063883e+01, -1.299128531491860e+01},
	{"QAK", -2.598925198257093e+01, -9.322107586850695e+00},
	{"QAL", -2.083094685449009e+01, -4.163802458769861e+00},
	{"QAM", -2.310253994745993e+01, -6.435395551739703e+00},
	{"QAN", -1.797236612498943e+01, -1.305221729269202e+00},
	{"QAO", -2.925796512814260e+01, -1.259082073242237e+01},
	{"QAP", -2.333120430950245e+01, -6.664059913782220e+00},
	{"QAQ", -2.955702290458442e+01, -1.288987850886419e+01},
	{"QAR", -2.046046054696351e+01, -3.793316151243280e+00},
	{"QAS", -2.020689636758866e+01, -3.539751971868431e+00},
	{"QAT", -2.037949034009214e+01, -3.712345944371908e+00},
	{"QAU", -2.617486216641490e+01, -9.507717770694665e+00},
	{"QAV", -2.510452896498520e+01, -8.437384569264966e+00},
	{"QAW", -2.620464763914955e+01, -9.537503243429319e+00},
	{"QAX", -2.941407529928868e+01, -1.274693090356844e+01},
	{"QAY", -2.503929799298830e+01, -8.372153597268072e+00},
	{"QAZ", -2.937675575957567e+01, -1.270961136385544e+01},
	{"QBA", -2.314622094336351e+01, -3.851654600501004e+00},
	{"QBB", -2.815792990607465e+01, -8.863363563212143e+00},
	{"QBC", -2.886187412665709e+01, -9.567307783794577e+00},
	{"QBD", -3.016731046398382e+01, -1.087274412112131e+01},
	{"QBE", -2.164586832328615e+01, -2.351301980423638e+00},
	{"QBF", -3.175611538136630e+01, -1.246154903850379e+01},
	{"QBG", -3.335263847499233e+01, -1.405807213212982e+01},
	{"QBH", -3.059775693114614e+01, -1.130319058828363e+01},
	{"QBI", -2.337548885743449e+01, -4.080922514571983e+00},
	{"QBJ", -2.815312069016328e+01, -8.858554347300780e+00},
	{"QBK", -3.360845342565338e+01, -1.431388708279087e+01},
	{"QBL", -2.423929323366490e+01, -4.944726890802388e+00},
	{"QBM", -2.992699388689858e+01, -1.063242754403607e+01},
	{"QBN", -3.070604156105796e+01, -1.141147521819545e+01},
	{"QBO", -2.418747283240900e+01, -4.892906489546490e+00},
	{"QBP", -3.141768407931699e+01, -1.212311773645448e+01},
	{"QBQ", -3.747584449710045e+01, -1.818127815423794e+01},
	{"QBR", -2.468932074518128e+01, -5.394754402318768e+00},
	{"QBS", -2.673292106054318e+01, -7.438354717680672e+00},
	{"QBT", -2.740650256198347e+01, -8.111936219120956e+00},
	{"QBU", -2.097902728013145e+01, -1.684460937268939e+00},
	{"QBV", -3.139035112655121e+01, -1.209578478368870e+01},
	{"QBW", -3.079891416760758e+01, -1.150434782474507e+01},
	{"QBX", -4.076305233634105e+01, -2.146848599347854e+01},
	{"QBY", -2.125681779413336e+01, -1.962251451270850e+00},
	{"QBZ", -3.527115621210845e+01, -1.597658986924594e+01},
	{"QCA", -1.941427605437656e+01, -1.208710493617173e+00},
	{"QCB", -3.114095344941718e+01, -1.293538788865779e+01},
	{"QCC", -2.637171848097727e+01, -8.166152920217879e+00},
	{"QCD", -3.011489779930533e+01, -1.190933223854594e+01},
	{"QCE", -2.347372738298790e+01, -5.268161822228517e+00},
	{"QCF", -3.099976358316009e+01, -1.279419802240071e+01},
	{"QCG", -3.195531503459024e+01, -1.374974947383085e+01},
	{"QCH", -2.353079812843885e+01, -5.325232567679464e+00},
	{"QCI", -2.246517050475686e+01, -4.259604943997472e+00},
	{"QCJ", -3.391953470391668e+01, -1.571396914315730e+01},
	{"QCK", -2.563373336183830e+01, -7.428167801078910e+00},
	{"QCL", -2.571137850848024e+01, -7.505812947720852e+00},
	{"QCM", -3.090790466401662e+01, -1.270233910325723e+01},
	{"QCN", -3.177420969964168e+01, -1.356864413888230e+01},
	{"QCO", -1.969549772924575e+01, -1.489932168486369e+00},
	{"QCP", -3.019285325823489e+01, -1.198728769747550e+01},
	{"QCQ", -3.030384541670128e+01, -1.209827985594189e+01},
	{"QCR", -2.563336040282561e+01, -7.427794842066215e+00},
	{"QCS", -2.878391098874216e+01, -1.057834542798277e+01},
	{"QCT", -2.442244295641177e+01, -6.216877395652380e+00},
	{"QCU", -2.203283232511067e+01, -3.827266764351282e+00},
	{"QCV", -3.356897730604219e+01, -1.536341174528281e+01},
	{"QCW", -2.927724113537783e+01, -1.107167557461844e+01},
	{"QCX", -3.491233302270738e+01, -1.670676746194799e+01},
	{"QCY", -2.788146793595250e+01, -9.675902375193107e+00},
	{"QCZ", -3.352338286723280e+01, -1.531781730647342e+01},
	{"QDA", -2.462820989179023e+01, -4.811939688837797e+00},
	{"QDB", -2.602094849046224e+01, -6.204678287509807e+00},
	{"QDC", -2.716635455525967e+01, -7.350084352307237e+00},
	{"QDD", -2.695770313940277e+01, -7.141432936450343e+00},
	{"QDE", -2.060591285385672e+01, -7.896426509042870e-01},
	{"QDF", -2.667412403734011e+01, -6.857853834387678e+00},
	{"QDG", -2.740106060802870e+01, -7.584790405076269e+00},
	{"QDH", -2.602682704935706e+01, -6.210556846404623e+00},
	{"QDI", -2.447930132054562e+01, -4.663031117593188e+00},
	{"QDJ", -2.902895859861277e+01, -9.212688395660345e+00},
	{"QDK", -3.020580441898858e+01, -1.038953421603615e+01},
	{"QDL", -2.722962465029186e+01, -7.413354447339423e+00},
	{"QDM", -2.678346853059963e+01, -6.967198327647199e+00},
	{"QDN", -2.705255359315421e+01, -7.236283390201774e+00},
	{"QDO", -2.246650124823762e+01, -2.650231045285188e+00},
	{"QDP", -2.743998446075237e+01, -7.623714257799936e+00},
	{"QDQ", -3.164969594950211e+01, -1.183342574654968e+01},
	{"QDR", -2.637972594172762e+01, -6.563455738775186e+00},
	{"QDS", -2.531795687068543e+01, -5.501686667732995e+00},
	{"QDT", -2.438827659275068e+01, -4.572006389798243e+00},
	{"QDU", -2.643779693683560e+01, -6.621526733883170e+00},
	{"QDV", -2.873496574324908e+01, -8.918695540296650e+00},
	{"QDW", -2.610716909818069e+01, -6.290898895228257e+00},
	{"QDX", -3.654888625077631e+01, -1.673261604782387e+01},
	{"QDY", -2.747568884976612e+01, -7.659418646813686e+00},
	{"QDZ", -3.263132805109480e+01, -1.281505784814237e+01},
	{"QEA", -2.432826736108315e+01, -4.124102613986474e+00},
	{"QEB", -2.656269616568852e+01, -6.358531418591837e+00},
	{"QEC", -2.525380541562547e+01, -5.049640668528791e+00},
	{"QED", -2.424411146220212e+01, -4.039946715105438e+00},
	{"QEE", -2.549947887702232e+01, -5.295314129925640e+00},
	{"QEF", -2.591021071892974e+01, -5.706045971833063e+00},
	{"QEG", -2.675038012707672e+01, -6.546215379980036e+00},
	{"QEH", -2.633846371020075e+01, -6.134298963104076e+00},
	{"QEI", -2.558738016520061e+01, -5.383215418103930e+00},
	{"QEJ", -2.975525763405735e+01, -9.551092886960673e+00},
	{"QEK", -2.836614384880909e+01, -8.161979101712410e+00},
	{"QEL", -2.518423790337141e+01, -4.980073156274731e+00},
	{"QEM", -2.539272742278228e+01, -5.188562675685596e+00},
	{"QEN", -2.211080481744267e+01, -1.906640070345993e+00},
	{"QEO", -2.578046532986048e+01, -5.576300582763807e+00},
	{"QEP", -2.591537688173183e+01, -5.711212134635153e+00},
	{"QEQ", -2.923423507204808e+01, -9.030070324951398e+00},
	{"QER", -2.360107609675260e+01, -3.396911349655924e+00},
	{"QES", -2.396606735346603e+01, -3.761902606369353e+00},
	{"QET", -2.460971371809919e+01, -4.405548971002512e+00},
	{"QEU", -2.345209898065380e+01, -3.247934233557118e+00},
	{"QEV", -2.648391186600441e+01, -6.279747118907731e+00},
	{"QEW", -2.576471051893485e+01, -5.560545771838172e+00},
	{"QEX", -2.761801108199170e+01, -7.413846334895020e+00},
	{"QEY", -2.659346328166385e+01, -6.389298534567170e+00},
	{"QEZ", -3.146697958510433e+01, -1.126281483800765e+01},
	{"QFA", -1.906190247618227e+01, -4.988333298289772e-01},
	{"QFB", -2.795730363398861e+01, -9.394234487635316e+00},
	{"QFC", -2.737117578331338e+01, -8.808106636960089e+00},
	{"QFD", -2.825314867410284e+01, -9.690079527749553e+00},
	{"QFE", -2.503958978392529e+01, -6.476520637571997e+00},
	{"QFF", -2.568287831587714e+01, -7.119809169523852e+00},
	{"QFG", -2.790771819393623e+01, -9.344649047582941e+00},
	{"QFH", -2.670819575415171e+01, -8.145126607798423e+00},
	{"QFI", -2.316301062722185e+01, -4.599941480868562e+00},
	{"QFJ", -2.869601276787831e+01, -1.013294362152502e+01},
	{"QFK", -3.059219353282784e+01, -1.202912438647455e+01},
	{"QFL", -2.639883481397895e+01, -7.835765667625664e+00},
	{"QFM", -2.703937974490195e+01, -8.476310598548656e+00},
	{"QFN", -2.866093465246924e+01, -1.009786550611595e+01},
	{"QFO", -2.144035248554846e+01, -2.877283339195169e+00},
	{"QFP", -2.757141259941720e+01, -9.008343453063910e+00},
	{"QFQ", -3.283903910310042e+01, -1.427596995674713e+01},
	{"QFR", -2.503980286019406e+01, -6.476733713840773e+00},
	{"QFS", -2.689899941651524e+01, -8.335930270161951e+00},
	{"QFT", -2.387993465951632e+01, -5.316865513163031e+00},
	{"QFU", -2.351463869636849e+01, -4.951569550015197e+00},
	{"QFV", -2.987302139640486e+01, -1.130995225005157e+01},
	{"QFW", -2.762533632100353e+01, -9.062267174650241e+00},
	{"QFX", -3.515041060743393e+01, -1.658734146108063e+01},
	{"QFY", -2.826786866520989e+01, -9.704799518856602e+00},
	{"QFZ", -3.127900406696045e+01, -1.271593492060716e+01},
	{"QGA", -2.845123336222191e+01, -3.171340241487121e+00},
	{"QGB", -3.171131703160132e+01, -6.431423910866529e+00},
	{"QGC", -3.196234359161074e+01, -6.682450470875951e+00},
	{"QGD", -3.183344864506982e+01, -6.553555524335032e+00},
	{"QGE", -2.806367869177021e+01, -2.783785571035419e+00},
	{"QGF", -3.151702742031251e+01, -6.237134299577714e+00},
	{"QGG", -3.165851756035070e+01, -6.378624439615909e+00},
	{"QGH", -2.818098201211636e+01, -2.901088891381571e+00},
	{"QGI", -2.899441523307848e+01, -3.714522112343689e+00},
	{"QGJ", -3.518636816829422e+01, -9.906475047559423e+00},
	{"QGK", -3.542468210159146e+01, -1.014478898085667e+01},
	{"QGL", -3.006822750504054e+01, -4.788334384305744e+00},
	{"QGM", -3.146881243591467e+01, -6.188919315179884e+00},
	{"QGN", -3.058164419329801e+01, -5.301751072563223e+00},
	{"QGO", -2.844819106147765e+01, -3.168297940742860e+00},
	{"QGP", -3.195460459281647e+01, -6.674711472081677e+00},
	{"QGQ", -3.671776119620952e+01, -1.143786807547473e+01},
	{"QGR", -2.887114809883228e+01, -3.591254978097495e+00},
	{"QGS", -2.979458136276661e+01, -4.514688242031822e+00},
	{"QGT", -2.890729357824651e+01, -3.627400457511717e+00},
	{"QGU", -2.987965835956567e+01, -4.599765238830879e+00},
	{"QGV", -3.455820297813002e+01, -9.278309857395223e+00},
	{"QGW", -3.113934660610201e+01, -5.859453485367216e+00},
	{"QGX", -3.993658166265688e+01, -1.465668854192209e+01},
	{"QGY", -3.191119181746945e+01, -6.631298696734661e+00},
	{"QGZ", -3.852483517668911e+01, -1.324494205595431e+01},
	{"QHA", -1.992910292460162e+01, -8.144751213892035e-01},
	{"QHB", -2.958892321709480e+01, -1.047429541388239e+01},
	{"QHC", -2.956089933016764e+01, -1.044627152695523e+01},
	{"QHD", -3.004035235699400e+01, -1.092572455378159e+01},
	{"QHE", -2.215560327689575e+01, -3.040975473683340e+00},
	{"QHF", -2.957558443620360e+01, -1.046095663299119e+01},
	{"QHG", -3.055919146254571e+01, -1.144456365933330e+01},
	{"QHH", -2.849627452713944e+01, -9.381646723927032e+00},
	{"QHI", -2.462821983899627e+01, -5.513592035783862e+00},
	{"QHJ", -3.247762149167567e+01, -1.336299368846326e+01},
	{"QHK", -3.280122488039307e+01, -1.368659707718066e+01},
	{"QHL", -3.009999602834233e+01, -1.098536822512992e+01},
	{"QHM", -2.910092263701882e+01, -9.986294833806403e+00},
	{"QHN", -3.001192456385436e+01, -1.089729676064195e+01},
	{"QHO", -2.103923481382703e+01, -1.924607010614624e+00},
	{"QHP", -2.994475961572056e+01, -1.083013181250815e+01},
	{"QHQ", -3.423361938356464e+01, -1.511899158035224e+01},
	{"QHR", -2.790031093377958e+01, -8.785683130567167e+00},
	{"QHS", -2.854922326868424e+01, -9.434595465471837e+00},
	{"QHT", -2.606818206039495e+01, -6.953554257182541e+00},
	{"QHU", -2.794082055757872e+01, -8.826192754366303e+00},
	{"QHV", -3.271635608080487e+01, -1.360172827759246e+01},
	{"QHW", -2.868707664151912e+01, -9.572448838306704e+00},
	{"QHX", -3.822955641250780e+01, -1.911492860929539e+01},
	{"QHY", -2.812555753752827e+01, -9.010929734315853e+00},
	{"QHZ", -3.524143865838151e+01, -1.612681085516910e+01},
	{"QIA", -1.856407724275071e+01, -3.557888831646242e+00},
	{"QIB", -2.164597499390894e+01, -6.639786582804475e+00},
	{"QIC", -1.931079936418769e+01, -4.304610953083218e+00},
	{"QID", -2.095970709503515e+01, -5.953518683930681e+00},
	{"QIE", -2.410873912318863e+01, -9.102550712084163e+00},
	{"QIF", -1.986554628560442e+01, -4.859357874499950e+00},
	{"QIG", -1.740183819090254e+01, -2.395649779798069e+00},
	{"QIH", -2.738388421520226e+01, -1.237769580409780e+01},
	{"QII", -2.054082181198359e+01, -5.534633400879117e+00},
	{"QIJ", -2.171458905283993e+01, -6.708400641735468e+00},
	{"QIK", -2.356587101311922e+01, -8.559682602014753e+00},
	{"QIL", -2.069494851036809e+01, -5.688760099263625e+00},
	{"QIM", -1.964434296251598e+01, -4.638154551411509e+00},
	{"QIN", -1.867035320380083e+01, -3.664164792696360e+00},
	{"QIO", -1.999283655493934e+01, -4.986648143834876e+00},
	{"QIP", -1.846207060273085e+01, -3.455882191626384e+00},
	{"QIQ", -2.961360446673644e+01, -1.460741605563197e+01},
	{"QIR", -1.982252887789326e+01, -4.816340466788794e+00},
	{"QIS", -1.698201537892788e+01, -1.975826967823410e+00},
	{"QIT", -2.100851261408676e+01, -6.002324202982290e+00},
	{"QIU", -2.168457258330229e+01, -6.678384172197821e+00},
	{"QIV", -2.465444488697835e+01, -9.648256475873882e+00},
	{"QIW", -2.691688640726299e+01, -1.191069799615853e+01},
	{"QIX", -2.812673272928597e+01, -1.312054431818150e+01},
	{"QIY", -3.316204338385116e+01, -1.815585497274669e+01},
	{"QIZ", -2.731103555081443e+01, -1.230484713970996e+01},
	{"QJA", -2.179851102543671e+01, -7.185714470824964e-01},
	{"QJB", -3.173303218645222e+01, -1.065309260809801e+01},
	{"QJC", -3.258242183394876e+01, -1.150248225559455e+01},
	{"QJD", -3.447657941621219e+01, -1.339663983785798e+01},
	{"QJE", -2.444292026100288e+01, -3.362980682648663e+00},
	{"QJF", -3.360026531261648e+01, -1.252032573426227e+01},
	{"QJG", -3.318480620875575e+01, -1.210486663040155e+01},
	{"QJH", -3.237094921544786e+01, -1.129100963709365e+01},
	{"QJI", -2.844190880326733e+01, -7.361969224913119e+00},
	{"QJJ", -3.237674193174741e+01, -1.129680235339320e+01},
	{"QJK", -3.506531343961870e+01, -1.398537386126450e+01},
	{"QJL", -3.357414630885531e+01, -1.249420673050111e+01},
	{"QJM", -3.393007168258276e+01, -1.285013210422856e+01},
	{"QJN", -3.688014141123539e+01, -1.580020183288118e+01},
	{"QJO", -2.337099204396823e+01, -2.291052465614016e+00},
	{"QJP", -3.334192394540180e+01, -1.226198436704759e+01},
	{"QJQ", -3.632817568632768e+01, -1.524823610797347e+01},
	{"QJR", -3.255235042314812e+01, -1.147241084479391e+01},
	{"QJS", -3.299113923967673e+01, -1.191119966132252e+01},
	{"QJT", -3.308527656189577e+01, -1.200533698354156e+01},
	{"QJU", -2.471402335017631e+01, -3.634083771822106e+00},
	{"QJV", -3.994722890592853e+01, -1.886728932757432e+01},
	{"QJW", -3.232148494949951e+01, -1.124154537114530e+01},
	{"QJX", -4.262653431299736e+01, -2.154659473464315e+01},
	{"QJY", -3.909640506384197e+01, -1.801646548548776e+01},
	{"QJZ", -3.720140615730040e+01, -1.612146657894619e+01},
	{"QKA", -3.094185617486056e+01, -4.029777859187025e+00},
	{"QKB", -3.325395263783866e+01, -6.341874322165125e+00},
	{"QKC", -3.368582602016244e+01, -6.773747704488915e+00},
	{"QKD", -3.431903423254794e+01, -7.406955916874416e+00},
	{"QKE", -2.848217627316054e+01, -1.570097957487013e+00},
	{"QKF", -3.315036097596079e+01, -6.238282660287263e+00},
	{"QKG", -3.542296175327794e+01, -8.510883437604411e+00},
	{"QKH", -3.282066113014793e+01, -5.908582814474403e+00},
	{"QKI", -2.926624234874121e+01, -2.354164033067678e+00},
	{"QKJ", -3.700113623467838e+01, -1.008905791900485e+01},
	{"QKK", -3.633286632713068e+01, -9.420788011457150e+00},
	{"QKL", -3.271149488725811e+01, -5.799416571584570e+00},
	{"QKM", -3.368586352920282e+01, -6.773785213529288e+00},
	{"QKN", -3.045958637791280e+01, -3.547508062239268e+00},
	{"QKO", -3.131112450382528e+01, -4.399046188151746e+00},
	{"QKP", -3.403680317466900e+01, -7.124724858995467e+00},
	{"QKQ", -3.968027602925146e+01, -1.276819771357793e+01},
	{"QKR", -3.447240747017378e+01, -7.560329154500256e+00},
	{"QKS", -3.059071375238623e+01, -3.678635436712704e+00},
	{"QKT", -3.135560125956542e+01, -4.443522943891885e+00},
	{"QKU", -3.320366686232057e+01, -6.291588546647041e+00},
	{"QKV", -3.684129130052308e+01, -9.929212984849547e+00},
	{"QKW", -3.252710952351532e+01, -5.615031207841788e+00},
	{"QKX", -4.065232289514472e+01, -1.374024457947119e+01},
	{"QKY", -3.319733066020601e+01, -6.285252344532478e+00},
	{"QKZ", -3.875418578101446e+01, -1.184210746534093e+01},
	{"QLA", -2.432150690480404e+01, -4.764491528148621e+00},
	{"QLB", -2.716429386208526e+01, -7.607278485429843e+00},
	{"QLC", -2.777617126653904e+01, -8.219155889883629e+00},
	{"QLD", -2.507695621349296e+01, -5.519940836837545e+00},
	{"QLE", -2.273588702792346e+01, -3.178871651268051e+00},
	{"QLF", -2.691551718814899e+01, -7.358501811493578e+00},
	{"QLG", -2.860018359251747e+01, -9.043168215862059e+00},
	{"QLH", -2.803204681896025e+01, -8.475031442304832e+00},
	{"QLI", -2.296418476838354e+01, -3.407169391728128e+00},
	{"QLJ", -3.133221120980570e+01, -1.177519583315029e+01},
	{"QLK", -2.860450811311596e+01, -9.047492736460551e+00},
	{"QLL", -2.385658808092041e+01, -4.299572704264998e+00},
	{"QLM", -2.767926932578651e+01, -8.122253949131103e+00},
	{"QLN", -2.838868310759845e+01, -8.831667730943035e+00},
	{"QLO", -2.236669843909097e+01, -2.809683062435559e+00},
	{"QLP", -2.766486395877963e+01, -8.107848582124221e+00},
	{"QLQ", -3.242091546463554e+01, -1.286390008798013e+01},
	{"QLR", -2.819555004950542e+01, -8.638534672850009e+00},
	{"QLS", -2.596188699159731e+01, -6.404871614941903e+00},
	{"QLT", -2.162109750639251e+01, -2.064082129737096e+00},
	{"QLU", -2.167740143550867e+01, -2.120386058853259e+00},
	{"QLV", -2.796487601165316e+01, -8.407860634997743e+00},
	{"QLW", -2.766169236051271e+01, -8.104676983857290e+00},
	{"QLX", -3.572288364876304e+01, -1.616586827210763e+01},
	{"QLY", -2.504647437133147e+01, -5.489458994676053e+00},
	{"QLZ", -3.438437412187881e+01, -1.482735874522340e+01},
	{"QMA", -2.179184786464408e+01, -3.057219330129348e+00},
	{"QMB", -2.548380679628781e+01, -6.749178261773083e+00},
	{"QMC", -2.072590901956060e+01, -1.991280485045869e+00},
	{"QMD", -2.827037886666128e+01, -9.535750332146549e+00},
	{"QME", -2.037586077903600e+01, -1.641232244521266e+00},
	{"QMF", -2.761233790699517e+01, -8.877709372480433e+00},
	{"QMG", -2.926511321690532e+01, -1.053048468239059e+01},
	{"QMH", -2.723395899300958e+01, -8.499330458494853e+00},
	{"QMI", -2.392250825376042e+01, -5.187879719245690e+00},
	{"QMJ", -3.069337468330739e+01, -1.195874614879266e+01},
	{"QMK", -3.100181694741651e+01, -1.226718841290178e+01},
	{"QML", -2.852090246885811e+01, -9.786273934343388e+00},
	{"QMM", -2.554313100939735e+01, -6.808502474882616e+00},
	{"QMN", -2.747852880276861e+01, -8.743900268253878e+00},
	{"QMO", -2.215835125449340e+01, -3.423722719978666e+00},
	{"QMP", -2.467547300847640e+01, -5.940844473961667e+00},
	{"QMQ", -3.361013367783397e+01, -1.487550514331924e+01},
	{"QMR", -2.784833779435820e+01, -9.113709259843471e+00},
	{"QMS", -2.538085886178125e+01, -6.646230327266521e+00},
	{"QMT", -2.509027285189687e+01, -6.355644317382139e+00},
	{"QMU", -2.202334919170448e+01, -3.288720657189754e+00},
	{"QMV", -3.034441484863914e+01, -1.160978631412441e+01},
	{"QMW", -2.680604571159740e+01, -8.071417177082669e+00},
	{"QMX", -3.524982313478743e+01, -1.651519460027270e+01},
	{"QMY", -2.519257676865287e+01, -6.457948234138141e+00},
	{"QMZ", -3.387889725381432e+01, -1.514426871929958e+01},
	{"QNA", -2.656009714537570e+01, -4.996151233892228e+00},
	{"QNB", -2.895764967111615e+01, -7.393703759632681e+00},
	{"QNC", -2.703064749106721e+01, -5.466701579583741e+00},
	{"QND", -2.489090108361341e+01, -3.326955172129940e+00},
	{"QNE", -2.333761448395294e+01, -1.773668572469470e+00},
	{"QNF", -2.871182955497474e+01, -7.147883643491270e+00},
	{"QNG", -2.577981111896589e+01, -4.215865207482417e+00},
	{"QNH", -2.842646858545359e+01, -6.862522673970116e+00},
	{"QNI", -2.690208721869480e+01, -5.338141307211325e+00},
	{"QNJ", -3.111862448869658e+01, -9.554678577213110e+00},
	{"QNK", -2.977586917628101e+01, -8.211923264797539e+00},
	{"QNL", -2.918111379653121e+01, -7.617167885047737e+00},
	{"QNM", -2.913186052514189e+01, -7.567914613658423e+00},
	{"QNN", -2.908298333564092e+01, -7.519037424157451e+00},
	{"QNO", -2.335332140004143e+01, -1.789375488557964e+00},
	{"QNP", -2.962175188820703e+01, -8.057805976723559e+00},
	{"QNQ", -3.202943942788765e+01, -1.046549351640417e+01},
	{"QNR", -3.018808472742142e+01, -8.624138815937947e+00},
	{"QNS", -2.654908379417109e+01, -4.985137882687614e+00},
	{"QNT", -2.515985729103279e+01, -3.595911379549322e+00},
	{"QNU", -2.914800479875558e+01, -7.584058887272104e+00},
	{"QNV", -3.027395880396985e+01, -8.710012892486377e+00},
	{"QNW", -2.862612641223504e+01, -7.062180500751565e+00},
	{"QNX", -3.408601357007035e+01, -1.252206765858688e+01},
	{"QNY", -2.865153550267647e+01, -7.087589591193000e+00},
	{"QNZ", -3.459471861384994e+01, -1.303077270236647e+01},
	{"QOA", -2.704229148950333e+01, -7.281899747294419e+00},
	{"QOB", -2.715218128109086e+01, -7.391789538881951e+00},
	{"QOC", -2.707362163132418e+01, -7.313229889115269e+00},
	{"QOD", -2.634522533399108e+01, -6.584833591782167e+00},
	{"QOE", -2.819148628406971e+01, -8.431094541860801e+00},
	{"QOF", -2.280246262169516e+01, -3.042070879486252e+00},
	{"QOG", -2.796828733222840e+01, -8.207895590019493e+00},
	{"QOH", -2.750664606585438e+01, -7.746254323645474e+00},
	{"QOI", -2.724170351922088e+01, -7.481311777011968e+00},
	{"QOJ", -2.927960650850689e+01, -9.519214766297980e+00},
	{"QOK", -2.777575392719964e+01, -8.015362184990732e+00},
	{"QOL", -2.589580430400393e+01, -6.135412561795024e+00},
	{"QOM", -2.503633110491409e+01, -5.275939362705182e+00},
	{"QON", -2.169216796139260e+01, -1.931776219183684e+00},
	{"QOO", -2.615154600903428e+01, -6.391154266825374e+00},
	{"QOP", -2.642065688526487e+01, -6.660265143055958e+00},
	{"QOQ", -3.259472496752173e+01, -1.283433322531282e+01},
	{"QOR", -2.218260054181342e+01, -2.422208799604514e+00},
	{"QOS", -2.590754657043267e+01, -6.147154828223765e+00},
	{"QOT", -2.488065018869242e+01, -5.120258446483514e+00},
	{"QOU", -2.224031365135871e+01, -2.479921909149797e+00},
	{"QOV", -2.351250036555677e+01, -3.752108623347862e+00},
	{"QOW", -2.559472112073070e+01, -5.834329378521794e+00},
	{"QOX", -3.114645592711110e+01, -1.138606418490219e+01},
	{"QOY", -2.829031993896756e+01, -8.529928196758654e+00},
	{"QOZ", -3.237534573051824e+01, -1.261495398830933e+01},
	{"QPA", -2.412009509058733e+01, -4.357517961952567e+00},
	{"QPB", -2.959622833649671e+01, -9.833651207861948e+00},
	{"QPC", -3.049210014619575e+01, -1.072952301756098e+01},
	{"QPD", -3.102894276428756e+01, -1.126636563565279e+01},
	{"QPE", -2.374048138705654e+01, -3.977904258421774e+00},
	{"QPF", -2.957245200632066e+01, -9.809874877685896e+00},
	{"QPG", -3.038014683862668e+01, -1.061756970999191e+01},
	{"QPH", -2.578924634125834e+01, -6.026669212623574e+00},
	{"QPI", -2.527691731625974e+01, -5.514340187624979e+00},
	{"QPJ", -3.320440413889208e+01, -1.344182701025731e+01},
	{"QPK", -3.308732474691099e+01, -1.332474761827622e+01},
	{"QPL", -2.452353893612514e+01, -4.760961807490367e+00},
	{"QPM", -2.879187755075414e+01, -9.029300422119377e+00},
	{"QPN", -3.092368884759564e+01, -1.116111171896087e+01},
	{"QPO", -2.078902108724116e+01, -1.026443958606388e+00},
	{"QPP", -2.540783360822880e+01, -5.645256479594030e+00},
	{"QPQ", -3.446067480455322e+01, -1.469809767591846e+01},
	{"QPR", -2.219910276248410e+01, -2.436525633849336e+00},
	{"QPS", -2.672280849128168e+01, -6.960231362646909e+00},
	{"QPT", -2.543100889899624e+01, -5.668431770361466e+00},
	{"QPU", -2.342545350645819e+01, -3.662876377823427e+00},
	{"QPV", -3.261864243979686e+01, -1.285606531116209e+01},
	{"QPW", -2.882039979940216e+01, -9.057822670767392e+00},
	{"QPX", -3.796185350996102e+01, -1.819927638132626e+01},
	{"QPY", -2.817248016692137e+01, -8.409903038286599e+00},
	{"QPZ", -3.626696913541213e+01, -1.650439200677735e+01},
	{"QQA", -2.393664602256132e+01, -2.292665945189453e+00},
	{"QQB", -3.220559332707715e+01, -1.056161324970528e+01},
	{"QQC", -3.111659254497403e+01, -9.472612467602159e+00},
	{"QQD", -3.272729718716707e+01, -1.108331710979521e+01},
	{"QQE", -3.311519173131131e+01, -1.147121165393945e+01},
	{"QQF", -3.147409613056793e+01, -9.830116053196063e+00},
	{"QQG", -3.819092010494943e+01, -1.654694002757756e+01},
	{"QQH", -3.202565478742705e+01, -1.038167471005518e+01},
	{"QQI", -2.791721539531910e+01, -6.273235317947242e+00},
	{"QQJ", -3.399096656256884e+01, -1.234698648519698e+01},
	{"QQK", -3.982310529988817e+01, -1.817912522251630e+01},
	{"QQL", -3.246804236087005e+01, -1.082406228349819e+01},
	{"QQM", -3.164565551872937e+01, -1.000167544135750e+01},
	{"QQN", -3.447497289569811e+01, -1.283099281832625e+01},
	{"QQO", -3.267141872642355e+01, -1.102743864905168e+01},
	{"QQP", -3.267360411284940e+01, -1.102962403547754e+01},
	{"QQQ", -3.455500706158650e+01, -1.291102698421464e+01},
	{"QQR", -3.252030756430126e+01, -1.087632748692940e+01},
	{"QQS", -2.959261971959002e+01, -7.948639642218151e+00},
	{"QQT", -3.009229072352433e+01, -8.448310646152459e+00},
	{"QQU", -2.202703728019679e+01, -3.830572028249285e-01},
	{"QQV", -3.538616074193978e+01, -1.374218066456791e+01},
	{"QQW", -3.174441356608605e+01, -1.010043348871419e+01},
	{"QQX", -4.184623725777110e+01, -2.020225718039924e+01},
	{"QQY", -3.603895745921788e+01, -1.439497738184602e+01},
	{"QQZ", -4.298580469452163e+01, -2.134182461714977e+01},
	{"QRA", -2.703040359907042e+01, -7.421123018983795e+00},
	{"QRB", -3.020100110345720e+01, -1.059172052337057e+01},
	{"QRC", -2.919211454042508e+01, -9.582833960338460e+00},
	{"QRD", -2.824068605954439e+01, -8.631405479457769e+00},
	{"QRE", -1.967547603599526e+01, -6.619545590862799e-02},
	{"QRF", -3.003037102345232e+01, -1.042109044336569e+01},
	{"QRG", -2.965338842928312e+01, -1.004410784919649e+01},
	{"QRH", -2.983537613929970e+01, -1.022609555921307e+01},
	{"QRI", -2.701209852000884e+01, -7.402817939922217e+00},
	{"QRJ", -3.312335887598389e+01, -1.351407829589727e+01},
	{"QRK", -2.999078528754479e+01, -1.038150470745816e+01},
	{"QRL", -2.985807933825659e+01, -1.024879875816997e+01},
	{"QRM", -2.886597706691785e+01, -9.256696486831224e+00},
	{"QRN", -2.892138590687536e+01, -9.312105326788739e+00},
	{"QRO", -2.692018012574722e+01, -7.310899545660591e+00},
	{"QRP", -3.012385101637456e+01, -1.051457043628793e+01},
	{"QRQ", -3.450989500622466e+01, -1.490061442613803e+01},
	{"QRR", -2.939312179376115e+01, -9.783841213674524e+00},
	{"QRS", -2.762990659317840e+01, -8.020626013091775e+00},
	{"QRT", -2.733822409989741e+01, -7.728943519810785e+00},
	{"QRU", -2.938300921652008e+01, -9.773728636433448e+00},
	{"QRV", -3.044103834614175e+01, -1.083175776605512e+01},
	{"QRW", -2.979660816175497e+01, -1.018732758166834e+01},
	{"QRX", -3.517502117898411e+01, -1.556574059889749e+01},
	{"QRY", -2.860474653411214e+01, -8.995465954025512e+00},
	{"QRZ", -3.610614371283037e+01, -1.649686313274374e+01},
	{"QSA", -2.209265298901055e+01, -5.411060253635174e+00},
	{"QSB", -2.159517938634598e+01, -4.913586650970602e+00},
	{"QSC", -2.152842313562002e+01, -4.846830400244637e+00},
	{"QSD", -2.591304658031275e+01, -9.231453844937370e+00},
	{"QSE", -1.987321984572041e+01, -3.191627110345031e+00},
	{"QSF", -2.247401281852366e+01, -5.792420083148287e+00},
	{"QSG", -2.166847426091906e+01, -4.986881525543687e+00},
	{"QSH", -2.047463755730920e+01, -3.793044821933828e+00},
	{"QSI", -2.155228679067826e+01, -4.870694055302883e+00},
	{"QSJ", -2.869686048820742e+01, -1.201526775283204e+01},
	{"QSK", -2.699548161778198e+01, -1.031388888240660e+01},
	{"QSL", -2.161400227357700e+01, -4.932409538201620e+00},
	{"QSM", -2.129660565431712e+01, -4.615012918941743e+00},
	{"QSN", -1.988201655016656e+01, -3.200423814791187e+00},
	{"QSO", -2.144172210773597e+01, -4.760129372360588e+00},
	{"QSP", -2.078161459513131e+01, -4.100021859755933e+00},
	{"QSQ", -2.860794088349838e+01, -1.192634814812300e+01},
	{"QSR", -2.256873006525026e+01, -5.887137329874882e+00},
	{"QSS", -1.987115977837291e+01, -3.189567042997537e+00},
	{"QST", -1.899310905135205e+01, -2.311516315976669e+00},
	{"QSU", -2.228988367436767e+01, -5.608290938992293e+00},
	{"QSV", -2.784692456220528e+01, -1.116533182682990e+01},
	{"QSW", -2.427565782530422e+01, -7.594065089928842e+00},
	{"QSX", -3.067257727040031e+01, -1.399098453502494e+01},
	{"QSY", -2.354944071331082e+01, -6.867847977935441e+00},
	{"QSZ", -3.213555174251044e+01, -1.545395900713507e+01},
	{"QTA", -2.083617925535943e+01, -3.654915516049746e+00},
	{"QTB", -2.802043277007785e+01, -1.083916903076816e+01},
	{"QTC", -2.809271376906430e+01, -1.091145002975461e+01},
	{"QTD", -2.874233421170926e+01, -1.156107047239957e+01},
	{"QTE", -2.488993447700262e+01, -7.708670737692929e+00},
	{"QTF", -2.825075124211580e+01, -1.106948750280612e+01},
	{"QTG", -2.919238614523286e+01, -1.201112240592317e+01},
	{"QTH", -1.789986115571075e+01, -7.185974164010598e-01},
	{"QTI", -2.480765412862393e+01, -7.626390389314248e+00},
	{"QTJ", -3.134789343510782e+01, -1.416662969579814e+01},
	{"QTK", -3.117815220746738e+01, -1.399688846815769e+01},
	{"QTL", -2.759539000183081e+01, -1.041412626252112e+01},
	{"QTM", -2.810433046451302e+01, -1.092306672520333e+01},
	{"QTN", -2.878420333405809e+01, -1.160293959474840e+01},
	{"QTO", -1.897318817330103e+01, -1.791924433991343e+00},
	{"QTP", -2.885584029936801e+01, -1.167457656005833e+01},
	{"QTQ", -3.331445764229618e+01, -1.613319390298649e+01},
	{"QTR", -2.619232327234961e+01, -9.011059533039923e+00},
	{"QTS", -2.617974454877755e+01, -8.998480809467868e+00},
	{"QTT", -2.559690497012314e+01, -8.415641230813458e+00},
	{"QTU", -2.704508133467254e+01, -9.863817595362853e+00},
	{"QTV", -3.130419938882086e+01, -1.412293564951118e+01},
	{"QTW", -2.682917681738464e+01, -9.647913078074955e+00},
	{"QTX", -3.602026042905979e+01, -1.883899668975010e+01},
	{"QTY", -2.718397086436626e+01, -1.000270712505657e+01},
	{"QTZ", -3.349349388602065e+01, -1.631223014671097e+01},
	{"QUA", -1.211842362549906e+01, -1.938541861674266e+00},
	{"QUB", -2.635367108724601e+01, -1.617378932342122e+01},
	{"QUC", -2.553917066253479e+01, -1.535928889871000e+01},
	{"QUD", -2.627918278144574e+01, -1.609930101762095e+01},
	{"QUE", -1.182999274928439e+01, -1.650110985459603e+00},
	{"QUF", -2.793869245643522e+01, -1.775881069261042e+01},
	{"QUG", -2.549478072712996e+01, -1.531489896330516e+01},
	{"QUH", -2.860884950557878e+01, -1.842896774175399e+01},
	{"QUI", -1.146659637788193e+01, -1.286714614057139e+00},
	{"QUJ", -3.289659490225800e+01, -2.271671313843321e+01},
	{"QUK", -2.910124160409946e+01, -1.892135984027467e+01},
	{"QUL", -2.436194675610468e+01, -1.418206499227989e+01},
	{"QUM", -2.579244225123595e+01, -1.561256048741116e+01},
	{"QUN", -2.215331752515825e+01, -1.197343576133346e+01},
	{"QUO", -1.703162880552339e+01, -6.851747041698594e+00},
	{"QUP", -2.512120098555411e+01, -1.494131922172932e+01},
	{"QUQ", -3.435819885329338e+01, -2.417831708946859e+01},
	{"QUR", -2.373740564012628e+01, -1.355752387630149e+01},
	{"QUS", -2.111572685204276e+01, -1.093584508821797e+01},
	{"QUT", -2.371873596735024e+01, -1.353885420352546e+01},
	{"QUU", -3.170136688661774e+01, -2.152148512279295e+01},
	{"QUV", -3.104366453675452e+01, -2.086378277292973e+01},
	{"QUW", -2.872375574441681e+01, -1.854387398059202e+01},
	{"QUX", -3.131915539729970e+01, -2.113927363347491e+01},
	{"QUY", -2.039516142069431e+01, -1.021527965686952e+01},
	{"QUZ", -3.094216548753332e+01, -2.076228372370853e+01},
	{"QVA", -2.382782900693996e+01, -1.352695249214821e+00},
	{"QVB", -3.560245359034686e+01, -1.312731983262172e+01},
	{"QVC", -3.579180991768706e+01, -1.331667615996192e+01},
	{"QVD", -3.504688205143110e+01, -1.257174829370595e+01},
	{"QVE", -2.362951823538130e+01, -1.154384477656161e+00},
	{"QVF", -3.525122929671863e+01, -1.277609553899349e+01},
	{"QVG", -3.655962168404012e+01, -1.408448792631497e+01},
	{"QVH", -3.427446265946857e+01, -1.179932890174342e+01},
	{"QVI", -2.560690955176884e+01, -3.131775794043695e+00},
	{"QVJ", -3.648247938468073e+01, -1.400734562695559e+01},
	{"QVK", -3.836208000745905e+01, -1.588694624973391e+01},
	{"QVL", -3.563432307914455e+01, -1.315918932141941e+01},
	{"QVM", -3.464478586077271e+01, -1.216965210304757e+01},
	{"QVN", -3.374319374624110e+01, -1.126805998851597e+01},
	{"QVO", -2.723581479428305e+01, -4.760681036557910e+00},
	{"QVP", -3.471743286585452e+01, -1.224229910812938e+01},
	{"QVQ", -4.231427478079453e+01, -1.983914102306939e+01},
	{"QVR", -3.267346841294530e+01, -1.019833465522017e+01},
	{"QVS", -3.371124460248065e+01, -1.123611084475551e+01},
	{"QVT", -3.302715350567854e+01, -1.055201974795340e+01},
	{"QVU", -3.261311838899389e+01, -1.013798463126875e+01},
	{"QVV", -3.720785194640541e+01, -1.473271818868027e+01},
	{"QVW", -3.435061157424777e+01, -1.187547781652263e+01},
	{"QVX", -3.894009559789119e+01, -1.646496184016605e+01},
	{"QVY", -3.076293803386176e+01, -8.287804276136621e+00},
	{"QVZ", -4.234997448044891e+01, -1.987484072272377e+01},
	{"QWA", -2.256967021151747e+01, -3.736283629646058e+00},
	{"QWB", -2.920946995403681e+01, -1.037608337216539e+01},
	{"QWC", -2.926736157296409e+01, -1.043397499109268e+01},
	{"QWD", -2.877860872059148e+01, -9.945222138720066e+00},
	{"QWE", -2.115521082910242e+01, -2.321824247231008e+00},
	{"QWF", -2.906243935922354e+01, -1.022905277735212e+01},
	{"QWG", -3.018918278920919e+01, -1.135579620733778e+01},
	{"QWH", -2.111269267022552e+01, -2.279306088354109e+00},
	{"QWI", -2.026665756095062e+01, -1.433270979079207e+00},
	{"QWJ", -3.154587725202661e+01, -1.271249067015519e+01},
	{"QWK", -3.170088971555262e+01, -1.286750313368121e+01},
	{"QWL", -2.813092197605410e+01, -9.297535394182685e+00},
	{"QWM", -2.883175421216159e+01, -9.998367630290172e+00},
	{"QWN", -2.570604417355835e+01, -6.872657591686934e+00},
	{"QWO", -2.189356161521437e+01, -3.060175033342952e+00},
	{"QWP", -2.991961787919150e+01, -1.108623129732008e+01},
	{"QWQ", -3.417323902590263e+01, -1.533985244403121e+01},
	{"QWR", -2.735491337740892e+01, -8.521526795537506e+00},
	{"QWS", -2.696621652233313e+01, -8.132829940461713e+00},
	{"QWT", -2.683623878747538e+01, -8.002852205603965e+00},
	{"QWU", -3.030284956095174e+01, -1.146946297908033e+01},
	{"QWV", -3.202341238854780e+01, -1.319002580667639e+01},
	{"QWW", -2.805543182763809e+01, -9.222045245766676e+00},
	{"QWX", -4.136704529202804e+01, -2.253365871015662e+01},
	{"QWY", -2.900593382969467e+01, -1.017254724782325e+01},
	{"QWZ", -3.489002894266719e+01, -1.605664236079578e+01},
	{"QXA", -3.241041573541750e+01, -3.475205461861043e+00},
	{"QXB", -3.697774034445195e+01, -8.042530070895491e+00},
	{"QXC", -3.193874000200211e+01, -3.003529728445642e+00},
	{"QXD", -3.637112849737190e+01, -7.435918223815437e+00},
	{"QXE", -3.201640927633232e+01, -3.081199002775858e+00},
	{"QXF", -3.651323796342740e+01, -7.578027689870940e+00},
	{"QXG", -3.781230250354316e+01, -8.877092229986699e+00},
	{"QXH", -3.417047632940648e+01, -5.235266055850012e+00},
	{"QXI", -3.201068741134122e+01, -3.075477137784759e+00},
	{"QXJ", -3.902527162956707e+01, -1.009006135601061e+01},
	{"QXK", -3.992335792001346e+01, -1.098814764645700e+01},
	{"QXL", -3.647059193683693e+01, -7.535381663280468e+00},
	{"QXM", -3.575377755483143e+01, -6.818567281274968e+00},
	{"QXN", -3.826279561138810e+01, -9.327585337831637e+00},
	{"QXO", -3.476814871790672e+01, -5.832938444350257e+00},
	{"QXP", -3.138653700858995e+01, -2.451326735033485e+00},
	{"QXQ", -3.792556727928022e+01, -8.990357005723759e+00},
	{"QXR", -3.654375467723348e+01, -7.608544403677021e+00},
	{"QXS", -3.583564013124457e+01, -6.900429857688104e+00},
	{"QXT", -3.118567186520880e+01, -2.250461591652341e+00},
	{"QXU", -3.504863746475338e+01, -6.113427191196913e+00},
	{"QXV", -3.467081071723147e+01, -5.735600443675006e+00},
	{"QXW", -3.585936983183160e+01, -6.924159558275142e+00},
	{"QXX", -3.545631307141093e+01, -6.521102797854468e+00},
	{"QXY", -3.564282576281677e+01, -6.707615489260307e+00},
	{"QXZ", -4.946258703217982e+01, -2.052737675862336e+01},
	{"QYA", -2.749600475150326e+01, -4.368074276500013e+00},
	{"QYB", -2.884472462732359e+01, -5.716794152320345e+00},
	{"QYC", -2.897354457309530e+01, -5.845614098092052e+00},
	{"QYD", -2.932093779288379e+01, -6.193007317880535e+00},
	{"QYE", -2.401400649650668e+01, -8.860760215034410e-01},
	{"QYF", -2.902125593245921e+01, -5.893325457455962e+00},
	{"QYG", -3.013397912654039e+01, -7.006048651537141e+00},
	{"QYH", -2.885683534075851e+01, -5.728904865755269e+00},
	{"QYI", -2.815710926953702e+01, -5.029178794533778e+00},
	{"QYJ", -3.220124016845333e+01, -9.073309693450083e+00},
	{"QYK", -3.199792338845830e+01, -8.869992913455050e+00},
	{"QYL", -2.957967802639001e+01, -6.451747551386760e+00},
	{"QYM", -2.893702097955637e+01, -5.809090504553124e+00},
	{"QYN", -3.008613070856444e+01, -6.958200233561188e+00},
	{"QYO", -2.684861697185439e+01, -3.720686496851140e+00},
	{"QYP", -2.906258287294230e+01, -5.934652397939049e+00},
	{"QYQ", -3.411767132654617e+01, -1.098974085154293e+01},
	{"QYR", -2.946221422607569e+01, -6.334283751072440e+00},
	{"QYS", -2.750070990560485e+01, -4.372779430601601e+00},
	{"QYT", -2.734905565981377e+01, -4.221125184810523e+00},
	{"QYU", -3.076956075828909e+01, -7.641630283285841e+00},
	{"QYV", -3.189303583805932e+01, -8.765105363056067e+00},
	{"QYW", -2.835183275242194e+01, -5.223902277418687e+00},
	{"QYX", -3.620060249202481e+01, -1.307267201702156e+01},
	{"QYY", -3.120517828746357e+01, -8.077247812460323e+00},
	{"QYZ", -3.553466463832173e+01, -1.240673416331848e+01},
	{"QZA", -3.236860030843777e+01, -2.293822598130778e+00},
	{"QZB", -3.772044355420073e+01, -7.645665843893735e+00},
	{"QZC", -3.860535837244230e+01, -8.530580662135309e+00},
	{"QZD", -3.896452421384513e+01, -8.889746503538143e+00},
	{"QZE", -3.129428568392785e+01, -1.219507973620853e+00},
	{"QZF", -3.855165578021973e+01, -8.476878069912736e+00},
	{"QZG", -3.907462495334695e+01, -8.999847243039955e+00},
	{"QZH", -3.769136208349683e+01, -7.616584373189839e+00},
	{"QZI", -3.291899960029150e+01, -2.844221889984504e+00},
	{"QZJ", -4.159834965550411e+01, -1.152357194519712e+01},
	{"QZK", -4.023384971589046e+01, -1.015907200558347e+01},
	{"QZL", -3.592408485253692e+01, -5.849307142229925e+00},
	{"QZM", -3.813234078222694e+01, -8.057563071919942e+00},
	{"QZN", -3.923516841084658e+01, -9.160390700539589e+00},
	{"QZO", -3.424666956339526e+01, -4.171891853088263e+00},
	{"QZP", -3.705073313107678e+01, -6.975955420769782e+00},
	{"QZQ", -4.551456354482746e+01, -1.543978583452046e+01},
	{"QZR", -3.626348978107915e+01, -6.188712070772155e+00},
	{"QZS", -3.788231252413505e+01, -7.807534813828052e+00},
	{"QZT", -3.638224480525839e+01, -6.307467094951393e+00},
	{"QZU", -3.578448319035446e+01, -5.709705480047471e+00},
	{"QZV", -3.868204434897175e+01, -8.607266638664759e+00},
	{"QZW", -3.734553152410762e+01, -7.270753813800627e+00},
	{"QZX", -4.832270010627230e+01, -1.824792239596530e+01},
	{"QZY", -3.675817935459797e+01, -6.683401644290976e+00},
	{"QZZ", -3.435305765975440e+01, -4.278279949447406e+00},
	{"RAA", -1.632561693682957e+01, -8.932453350343856e+00},
	{"RAB", -1.229325441908837e+01, -4.900090832602651e+00},
	{"RAC", -1.120555685027965e+01, -3.812393263793939e+00},
	{"RAD", -1.210035957552777e+01, -4.707195989042053e+00},
	{"RAE", -1.228515753011189e+01, -4.891993943626177e+00},
	{"RAF", -1.346103909499311e+01, -6.067875508507400e+00},
	{"RAG", -1.216969755655354e+01, -4.776533970067829e+00},
	{"RAH", -1.399909558035503e+01, -6.605931993869318e+00},
	{"RAI", -1.139571793377224e+01, -4.002554347286526e+00},
	{"RAJ", -1.737845160116569e+01, -9.985288014679979e+00},
	{"RAK", -1.617687373675059e+01, -8.783710150264877e+00},
	{"RAL", -1.078338633739648e+01, -3.390222750910762e+00},
	{"RAM", -1.258893363618955e+01, -5.195770049703840e+00},
	{"RAN", -9.547475947822733e+00, -2.154312361337020e+00},
	{"RAO", -1.482690633993566e+01, -7.433742753449952e+00},
	{"RAP", -1.225501139189642e+01, -4.861847805410709e+00},
	{"RAQ", -1.387326543384455e+01, -6.480101847358839e+00},
	{"RAR", -1.247882490432650e+01, -5.085661317840787e+00},
	{"RAS", -1.194676038029218e+01, -4.553596793806469e+00},
	{"RAT", -1.007274048065079e+01, -2.679576894165077e+00},
	{"RAU", -1.521372829159466e+01, -7.820564705108948e+00},
	{"RAV", -1.302387043895046e+01, -5.630706852464739e+00},
	{"RAW", -1.300086262752591e+01, -5.607699041040193e+00},
	{"RAX", -1.913183804514511e+01, -1.173867445865940e+01},
	{"RAY", -1.306892642353659e+01, -5.675762837050877e+00},
	{"RAZ", -1.618715529480465e+01, -8.793991708318934e+00},
	{"RBA", -1.366534795212566e+01, -3.101586861253169e+00},
	{"RBB", -2.135285167086720e+01, -1.078909057999471e+01},
	{"RBC", -1.654801579442830e+01, -5.984254703555811e+00},
	{"RBD", -2.090360749545205e+01, -1.033984640457955e+01},
	{"RBE", -1.246528780376247e+01, -1.901526712889977e+00},
	{"RBF", -2.071657768682602e+01, -1.015281659595353e+01},
	{"RBG", -2.371272655285553e+01, -1.314896546198304e+01},
	{"RBH", -2.001527951550229e+01, -9.451518424629793e+00},
	{"RBI", -1.440151549749242e+01, -3.837754406619927e+00},
	{"RBJ", -2.640181124039432e+01, -1.583805014952183e+01},
	{"RBK", -3.183805621531710e+01, -2.127429512444460e+01},
	{"RBL", -1.550775092918542e+01, -4.943989838312929e+00},
	{"RBM", -2.112301355992325e+01, -1.055925246905076e+01},
	{"RBN", -2.269984518966956e+01, -1.213608409879707e+01},
	{"RBO", -1.347997372603673e+01, -2.916212635164237e+00},
	{"RBP", -2.171304590387688e+01, -1.114928481300439e+01},
	{"RBQ", -3.546827003069755e+01, -2.490450893982505e+01},
	{"RBR", -1.382602176589994e+01, -3.262260675027450e+00},
	{"RBS", -1.602250656310569e+01, -5.458745472233196e+00},
	{"RBT", -1.798388311113015e+01, -7.420122020257656e+00},
	{"RBU", -1.341880034168941e+01, -2.855039250816922e+00},
	{"RBV", -2.963491790163259e+01, -1.907115681076010e+01},
	{"RBW", -1.990897387651385e+01, -9.345212785641358e+00},
	{"RBX", -3.901174288657208e+01, -2.844798179569959e+01},
	{"RBY", -1.407843036437149e+01, -3.514669273498996e+00},
	{"RBZ", -3.351984676233948e+01, -2.295608567146699e+01},
	{"RCA", -1.294964393689158e+01, -3.394769409051206e+00},
	{"RCB", -2.368882714445075e+01, -1.413395261661037e+01},
	{"RCC", -1.995627961298809e+01, -1.040140508514772e+01},
	{"RCD", -2.211345918188693e+01, -1.255858465404656e+01},
	{"RCE", -1.180398145812703e+01, -2.249106930286653e+00},
	{"RCF", -2.212277337746293e+01, -1.256789884962255e+01},
	{"RCG", -2.212812941538373e+01, -1.257325488754335e+01},
	{"RCH", -1.134160161491700e+01, -1.786727087076623e+00},
	{"RCI", -1.351863403154380e+01, -3.963759503703421e+00},
	{"RCJ", -3.205060270551456e+01, -2.249572817767418e+01},
	{"RCK", -1.963529013574205e+01, -1.008041560790167e+01},
	{"RCL", -1.450718400477429e+01, -4.952309476933913e+00},
	{"RCM", -2.368364104147805e+01, -1.412876651363767e+01},
	{"RCN", -2.212736554082553e+01, -1.257249101298515e+01},
	{"RCO", -1.189033754917910e+01, -2.335463021338724e+00},
	{"RCP", -2.170430083373022e+01, -1.214942630588984e+01},
	{"RCQ", -2.366570674817290e+01, -1.411083222033252e+01},
	{"RCR", -1.492457217876299e+01, -5.369697650922605e+00},
	{"RCS", -2.069961228810304e+01, -1.114473776026266e+01},
	{"RCT", -1.831936912219125e+01, -8.764494594350873e+00},
	{"RCU", -1.362494647791210e+01, -4.070071950071716e+00},
	{"RCV", -3.170479305844860e+01, -2.214991853060822e+01},
	{"RCW", -2.070513037448149e+01, -1.115025584664111e+01},
	{"RCX", -3.302180943918142e+01, -2.346693491134103e+01},
	{"RCY", -1.515582965910654e+01, -5.600955131266159e+00},
	{"RCZ", -3.167659270195194e+01, -2.212171817411156e+01},
	{"RDA", -1.170072952667173e+01, -3.097283479712047e+00},
	{"RDB", -1.413946703683185e+01, -5.536020989872166e+00},
	{"RDC", -1.438463158881640e+01, -5.781185541856718e+00},
	{"RDD", -1.515073994346569e+01, -6.547293896506002e+00},
	{"RDE", -1.121290749426064e+01, -2.609461447300949e+00},
	{"RDF", -1.434237112602422e+01, -5.738925079064530e+00},
	{"RDG", -1.421819063287573e+01, -5.614744585916038e+00},
	{"RDH", -1.367577044003604e+01, -5.072324393076353e+00},
	{"RDI", -1.141761582242035e+01, -2.814169775460667e+00},
	{"RDJ", -1.625017900959364e+01, -7.646732962633956e+00},
	{"RDK", -1.816250936979492e+01, -9.559063322835231e+00},
	{"RDL", -1.424624585563904e+01, -5.642799808679356e+00},
	{"RDM", -1.458285052843879e+01, -5.979404481479099e+00},
	{"RDN", -1.562871587623202e+01, -7.025269829272334e+00},
	{"RDO", -1.231051332761984e+01, -3.707067280660159e+00},
	{"RDP", -1.534212373353757e+01, -6.738677686577885e+00},
	{"RDQ", -2.054559167216456e+01, -1.194214562520487e+01},
	{"RDR", -1.447137856238090e+01, -5.867932515421217e+00},
	{"RDS", -1.133574369410770e+01, -2.732297647148010e+00},
	{"RDT", -1.204367235886200e+01, -3.440226311902312e+00},
	{"RDU", -1.468055016775586e+01, -6.077104120796173e+00},
	{"RDV", -1.858315591203713e+01, -9.979709865077442e+00},
	{"RDW", -1.344856870512268e+01, -4.845122658162991e+00},
	{"RDX", -3.422261224210791e+01, -2.561916619514822e+01},
	{"RDY", -1.506643227962517e+01, -6.462986232665481e+00},
	{"RDZ", -2.171504905919116e+01, -1.311160301223147e+01},
	{"REA", -8.924788780191687e+00, -2.791665193570105e+00},
	{"REB", -1.217217448787458e+01, -6.039050901253000e+00},
	{"REC", -1.039517016352799e+01, -4.262046576906409e+00},
	{"RED", -9.520647163690207e+00, -3.387523577068624e+00},
	{"REE", -1.037896254902680e+01, -4.245838962405222e+00},
	{"REF", -1.086769792995290e+01, -4.734574343331319e+00},
	{"REG", -1.161801212530703e+01, -5.484888538685448e+00},
	{"REH", -1.205367841240309e+01, -5.920554825781508e+00},
	{"REI", -1.074226059142187e+01, -4.609137004800285e+00},
	{"REJ", -1.400447439217812e+01, -7.871350805556534e+00},
	{"REK", -1.563065426814027e+01, -9.497530681518684e+00},
	{"REL", -1.125651316376371e+01, -5.123389577142127e+00},
	{"REM", -1.080105658570210e+01, -4.667932999080520e+00},
	{"REN", -9.983092705332901e+00, -3.849969118711318e+00},
	{"REO", -1.131159608608557e+01, -5.178472499463989e+00},
	{"REP", -1.095295766100331e+01, -4.819834074381729e+00},
	{"REQ", -1.294560735325054e+01, -6.812483766628956e+00},
	{"RER", -1.248008609414581e+01, -6.346962507524226e+00},
	{"RES", -9.073611702047044e+00, -2.940488115425461e+00},
	{"RET", -9.660326795476005e+00, -3.527203208854422e+00},
	{"REU", -1.325201953546647e+01, -7.118895948844891e+00},
	{"REV", -1.153254282934190e+01, -5.399419242720319e+00},
	{"REW", -1.097738289922424e+01, -4.844259312602653e+00},
	{"REX", -1.394201364828368e+01, -7.808890061662102e+00},
	{"REY", -1.315709402413120e+01, -7.023970437509614e+00},
	{"REZ", -1.699067821119075e+01, -1.085755462456917e+01},
	{"RFA", -1.277261252306223e+01, -2.379481512194614e+00},
	{"RFB", -2.255829374115686e+01, -1.216516273028925e+01},
	{"RFC", -2.197321864868582e+01, -1.158008763781821e+01},
	{"RFD", -1.906397554852366e+01, -8.670844537656050e+00},
	{"RFE", -1.320140634161552e+01, -2.808275330747906e+00},
	{"RFF", -1.906700673367327e+01, -8.673875722805656e+00},
	{"RFG", -2.340424282829984e+01, -1.301111181743223e+01},
	{"RFH", -2.100525399733660e+01, -1.061212298646899e+01},
	{"RFI", -1.388259990975540e+01, -3.489468898887790e+00},
	{"RFJ", -2.654388982184928e+01, -1.615075881098167e+01},
	{"RFK", -2.844055394188608e+01, -1.804742293101847e+01},
	{"RFL", -1.492219089571164e+01, -4.529059884844032e+00},
	{"RFM", -2.488758682657192e+01, -1.449445581570431e+01},
	{"RFN", -2.650882331525600e+01, -1.611569230438839e+01},
	{"RFO", -1.221753949056900e+01, -1.824408479701386e+00},
	{"RFP", -2.541955130765794e+01, -1.502642029679033e+01},
	{"RFQ", -3.068739951215866e+01, -2.029426850129105e+01},
	{"RFR", -1.323224588366661e+01, -2.839114872799003e+00},
	{"RFS", -1.865318813992577e+01, -8.260057129058156e+00},
	{"RFT", -2.013702869313942e+01, -9.743897682271809e+00},
	{"RFU", -1.372915303590308e+01, -3.336022025035465e+00},
	{"RFV", -2.363147937970054e+01, -1.323834836883293e+01},
	{"RFW", -2.106434151618731e+01, -1.067121050531970e+01},
	{"RFX", -3.299877101649216e+01, -2.260564000562455e+01},
	{"RFY", -2.346806937872522e+01, -1.307493836785761e+01},
	{"RFZ", -2.912736447601869e+01, -1.873423346515108e+01},
	{"RGA", -1.329715084587931e+01, -3.281002429180903e+00},
	{"RGB", -1.828329671268160e+01, -8.267148295983192e+00},
	{"RGC", -2.010607321420531e+01, -1.008992479750690e+01},
	{"RGD", -1.866333955337118e+01, -8.647191136672767e+00},
	{"RGE", -1.150804329625205e+01, -1.491894879553636e+00},
	{"RGF", -1.812436762866907e+01, -8.108219211970658e+00},
	{"RGG", -2.085324571442110e+01, -1.083709729772269e+01},
	{"RGH", -1.798516108821496e+01, -7.969012671516551e+00},
	{"RGI", -1.338701799732119e+01, -3.370869580622778e+00},
	{"RGJ", -2.270090235321136e+01, -1.268475393651295e+01},
	{"RGK", -2.927554335428347e+01, -1.925939493758506e+01},
	{"RGL", -1.470800261419522e+01, -4.691854197496808e+00},
	{"RGM", -1.842134043807931e+01, -8.405192021380898e+00},
	{"RGN", -1.670084604832966e+01, -6.684697631631249e+00},
	{"RGO", -1.286581035527507e+01, -2.849661938576663e+00},
	{"RGP", -1.953022727768813e+01, -9.514078860989725e+00},
	{"RGQ", -3.057183600247560e+01, -2.055568758577719e+01},
	{"RGR", -1.423708045370026e+01, -4.220932037001848e+00},
	{"RGS", -1.736043231305420e+01, -7.344283896355793e+00},
	{"RGT", -1.333738202448004e+01, -3.321233607781625e+00},
	{"RGU", -1.486091297076498e+01, -4.844764554066566e+00},
	{"RGV", -1.919287503785601e+01, -9.176726621157595e+00},
	{"RGW", -1.785063480417786e+01, -7.834486387479447e+00},
	{"RGX", -3.379065646892295e+01, -2.377450805222455e+01},
	{"RGY", -1.474375332099924e+01, -4.727604904300827e+00},
	{"RGZ", -3.235158318138132e+01, -2.233543476468290e+01},
	{"RHA", -1.207434254342218e+01, -1.876206416707193e+00},
	{"RHB", -2.360185649482796e+01, -1.340372036811297e+01},
	{"RHC", -2.725734302785110e+01, -1.705920690113611e+01},
	{"RHD", -2.773648367588267e+01, -1.753834754916768e+01},
	{"RHE", -1.187029626301647e+01, -1.672160136301484e+00},
	{"RHF", -2.209339803862800e+01, -1.189526191191300e+01},
	{"RHG", -2.825484475896388e+01, -1.805670863224889e+01},
	{"RHH", -2.068666377444835e+01, -1.048852764773336e+01},
	{"RHI", -1.234228935726096e+01, -2.144153230545970e+00},
	{"RHJ", -3.017485790012601e+01, -1.997672177341102e+01},
	{"RHK", -3.049846128884342e+01, -2.030032516212842e+01},
	{"RHL", -2.779723243679268e+01, -1.759909631007769e+01},
	{"RHM", -2.679758270310414e+01, -1.659944657638915e+01},
	{"RHN", -2.363066169315235e+01, -1.343252556643736e+01},
	{"RHO", -1.313886449795925e+01, -2.940728371244255e+00},
	{"RHP", -2.137791836836782e+01, -1.117978224165283e+01},
	{"RHQ", -3.193085579201499e+01, -2.173271966530000e+01},
	{"RHR", -2.559729655269422e+01, -1.539916042597923e+01},
	{"RHS", -2.348798415751500e+01, -1.328984803080001e+01},
	{"RHT", -2.040141890036583e+01, -1.020328277365083e+01},
	{"RHU", -1.456073991566477e+01, -4.362603788949782e+00},
	{"RHV", -3.041359248925521e+01, -2.021545636254022e+01},
	{"RHW", -2.638388041450464e+01, -1.618574428778965e+01},
	{"RHX", -3.592679282095815e+01, -2.572865669424316e+01},
	{"RHY", -1.758468477145447e+01, -7.386548644739476e+00},
	{"RHZ", -2.271751155976423e+01, -1.251937543304924e+01},
	{"RIA", -1.143174411335679e+01, -4.056885605932652e+00},
	{"RIB", -1.191497416854608e+01, -4.540115661121950e+00},
	{"RIC", -1.110006330670713e+01, -3.725204799282997e+00},
	{"RID", -1.298664896944447e+01, -5.611790462020335e+00},
	{"RIE", -1.057001470314531e+01, -3.195156195721175e+00},
	{"RIF", -1.253792572018383e+01, -5.163067212759694e+00},
	{"RIG", -1.125712017807432e+01, -3.882261670650187e+00},
	{"RIH", -1.558385561066411e+01, -8.208997103239977e+00},
	{"RII", -1.699019633910326e+01, -9.615337831679122e+00},
	{"RIJ", -2.025824002833749e+01, -1.288338152091336e+01},
	{"RIK", -1.499380420575641e+01, -7.618945698332274e+00},
	{"RIL", -1.328787406368954e+01, -5.913015556265408e+00},
	{"RIM", -1.280212622385937e+01, -5.427267716435233e+00},
	{"RIN", -9.615227412146254e+00, -2.240368904722119e+00},
	{"RIO", -1.188925126129615e+01, -4.514392753872010e+00},
	{"RIP", -1.358921525118635e+01, -6.214356743762219e+00},
	{"RIQ", -2.171094151990235e+01, -1.433608301247821e+01},
	{"RIR", -1.666208564375314e+01, -9.287227136329010e+00},
	{"RIS", -1.083668501745622e+01, -3.461826510032081e+00},
	{"RIT", -1.041327342544037e+01, -3.038414918016237e+00},
	{"RIU", -1.379233637298337e+01, -6.417477865559229e+00},
	{"RIV", -1.196280222699542e+01, -4.587943719571285e+00},
	{"RIW", -1.536945325417307e+01, -7.994594746748935e+00},
	{"RIX", -1.858700373099883e+01, -1.121214522357469e+01},
	{"RIY", -2.171814015123211e+01, -1.434328164380798e+01},
	{"RIZ", -1.485428803283159e+01, -7.479429525407459e+00},
	{"RJA", -1.526532835229584e+01, -1.779209488896652e+00},
	{"RJB", -2.138904338298183e+01, -7.902924519582647e+00},
	{"RJC", -2.171364296741570e+01, -8.227524104016513e+00},
	{"RJD", -3.150166853390166e+01, -1.801554967050248e+01},
	{"RJE", -1.664546239100683e+01, -3.159343527607652e+00},
	{"RJF", -2.370768772641244e+01, -1.022156886301325e+01},
	{"RJG", -3.020377767124504e+01, -1.671765880784585e+01},
	{"RJH", -2.939255506935616e+01, -1.590643620595697e+01},
	{"RJI", -1.828351291267773e+01, -4.797394049278545e+00},
	{"RJJ", -2.071622190240134e+01, -7.230103039002154e+00},
	{"RJK", -3.209040255730817e+01, -1.860428369390899e+01},
	{"RJL", -3.059923542654478e+01, -1.711311656314560e+01},
	{"RJM", -3.095516080027223e+01, -1.746904193687305e+01},
	{"RJN", -3.390523052892485e+01, -2.041911166552567e+01},
	{"RJO", -1.520005625531481e+01, -1.713937391915632e+00},
	{"RJP", -3.036701306309127e+01, -1.688089419969208e+01},
	{"RJQ", -3.335326480401714e+01, -1.986714594061796e+01},
	{"RJR", -2.369500469907653e+01, -1.020888583567735e+01},
	{"RJS", -3.001622835736620e+01, -1.653010949396701e+01},
	{"RJT", -3.010465503817507e+01, -1.661853617477589e+01},
	{"RJU", -1.554507900500723e+01, -2.058960141608041e+00},
	{"RJV", -3.697231802361800e+01, -2.348619916021881e+01},
	{"RJW", -2.934320806965414e+01, -1.585708920625495e+01},
	{"RJX", -3.965162343068683e+01, -2.616550456728764e+01},
	{"RJY", -3.612149418153144e+01, -2.263537531813226e+01},
	{"RJZ", -3.422649527498987e+01, -2.074037641159069e+01},
	{"RKA", -1.370406492809249e+01, -3.350519653132412e+00},
	{"RKB", -1.588399381070662e+01, -5.530448535746545e+00},
	{"RKC", -1.587821063801984e+01, -5.524665363059766e+00},
	{"RKD", -1.717737680306130e+01, -6.823831528101226e+00},
	{"RKE", -1.290372286019073e+01, -2.550177585230653e+00},
	{"RKF", -1.614644228954933e+01, -5.792897014589260e+00},
	{"RKG", -1.901451913248449e+01, -8.660973857524416e+00},
	{"RKH", -1.663747691220120e+01, -6.283931637241124e+00},
	{"RKI", -1.316904445844192e+01, -2.815499183481845e+00},
	{"RKJ", -2.090663508520226e+01, -1.055308981024218e+01},
	{"RKK", -2.071207786873799e+01, -1.035853259377791e+01},
	{"RKL", -1.678266309793011e+01, -6.429117822970037e+00},
	{"RKM", -1.587193091667047e+01, -5.518385641710394e+00},
	{"RKN", -1.441461977151756e+01, -4.061074496557490e+00},
	{"RKO", -1.382374104888001e+01, -3.470195773919940e+00},
	{"RKP", -1.692207509067759e+01, -6.568529815717520e+00},
	{"RKQ", -2.271619094995493e+01, -1.236264567499485e+01},
	{"RKR", -1.773847899455482e+01, -7.384933719594743e+00},
	{"RKS", -1.280749607498072e+01, -2.453950800020648e+00},
	{"RKT", -1.459170341367350e+01, -4.238158138713423e+00},
	{"RKU", -1.643970014992097e+01, -6.086154874960895e+00},
	{"RKV", -1.954684634487481e+01, -9.193301069914735e+00},
	{"RKW", -1.505880611214919e+01, -4.705260837189117e+00},
	{"RKX", -2.371610442011974e+01, -1.336255914515967e+01},
	{"RKY", -1.689448156276735e+01, -6.540936287807281e+00},
	{"RKZ", -2.054784355812799e+01, -1.019429828316792e+01},
	{"RLA", -1.337602022314912e+01, -3.155180897477230e+00},
	{"RLB", -1.960034888563329e+01, -9.379509559961404e+00},
	{"RLC", -1.900502878464690e+01, -8.784189458975012e+00},
	{"RLD", -1.311837401585756e+01, -2.897534690185672e+00},
	{"RLE", -1.294406965516368e+01, -2.723230329491798e+00},
	{"RLF", -1.910771534925775e+01, -8.886876023585868e+00},
	{"RLG", -2.135802269097594e+01, -1.113718336530405e+01},
	{"RLH", -1.862279051297584e+01, -8.401951187303959e+00},
	{"RLI", -1.256160362877336e+01, -2.340764303101473e+00},
	{"RLJ", -2.368941331502837e+01, -1.346857398935649e+01},
	{"RLK", -2.262382429716681e+01, -1.240298497149492e+01},
	{"RLL", -1.928210327754497e+01, -9.061263951873080e+00},
	{"RLM", -1.978727973561934e+01, -9.566440409947450e+00},
	{"RLN", -2.069058695313528e+01, -1.046974762746339e+01},
	{"RLO", -1.347056925957322e+01, -3.249729933901334e+00},
	{"RLP", -2.010280652936808e+01, -9.881967203696194e+00},
	{"RLQ", -3.041279095807225e+01, -2.019195163240036e+01},
	{"RLR", -2.204946592202721e+01, -1.182862659635532e+01},
	{"RLS", -1.549071984582229e+01, -5.269880520150408e+00},
	{"RLT", -1.771391397761039e+01, -7.493074651938506e+00},
	{"RLU", -1.735146570200481e+01, -7.130626376332923e+00},
	{"RLV", -2.010858394393073e+01, -9.887744618258839e+00},
	{"RLW", -1.708565187122573e+01, -6.864812545553844e+00},
	{"RLX", -3.364674860713767e+01, -2.342590928146579e+01},
	{"RLY", -1.230064558500818e+01, -2.079806259336296e+00},
	{"RLZ", -3.237624961531551e+01, -2.215541028964362e+01},
	{"RMA", -1.116805934940536e+01, -1.939322295072220e+00},
	{"RMB", -1.685061383601760e+01, -7.621876781684461e+00},
	{"RMC", -1.641382626491376e+01, -7.185089210580611e+00},
	{"RMD", -1.684699457277013e+01, -7.618257518436982e+00},
	{"RME", -1.163260869877405e+01, -2.403871644440911e+00},
	{"RMF", -1.748638578734617e+01, -8.257648733013024e+00},
	{"RMG", -1.919150615002214e+01, -9.962769095688992e+00},
	{"RMH", -1.636793476630720e+01, -7.139197711974055e+00},
	{"RMI", -1.202951982382623e+01, -2.800782769493091e+00},
	{"RMJ", -2.090687611892846e+01, -1.167813906459532e+01},
	{"RMK", -2.212520487339636e+01, -1.289646781906322e+01},
	{"RML", -1.590440898724850e+01, -6.675671932915361e+00},
	{"RMM", -1.719852458461661e+01, -7.969787530283468e+00},
	{"RMN", -1.734019619404554e+01, -8.111459139712402e+00},
	{"RMO", -1.233473867521619e+01, -3.106001620883050e+00},
	{"RMP", -1.775427385189550e+01, -8.525536797562358e+00},
	{"RMQ", -3.209752999064937e+01, -2.286879293631623e+01},
	{"RMR", -1.635111207360837e+01, -7.122375019275228e+00},
	{"RMS", -1.254522903363384e+01, -3.316491979300694e+00},
	{"RMT", -1.471016771276631e+01, -5.481430658433164e+00},
	{"RMU", -1.457478320312971e+01, -5.346046148796564e+00},
	{"RMV", -1.980920776506250e+01, -1.058047071072936e+01},
	{"RMW", -1.609436566184671e+01, -6.865628607513571e+00},
	{"RMX", -2.371739916995929e+01, -1.448866211562614e+01},
	{"RMY", -1.291066703469591e+01, -3.681929980362770e+00},
	{"RMZ", -3.238917334018455e+01, -2.316043628585141e+01},
	{"RNA", -1.204568413785235e+01, -2.761538243561695e+00},
	{"RNB", -1.560354582311265e+01, -6.319399928821995e+00},
	{"RNC", -1.590444498422307e+01, -6.620299089932410e+00},
	{"RND", -1.688862846007844e+01, -7.604482565787779e+00},
	{"RNE", -1.129328603225173e+01, -2.009140137961072e+00},
	{"RNF", -1.542719583033719e+01, -6.143049936046529e+00},
	{"RNG", -1.834084745786475e+01, -9.056701563574094e+00},
	{"RNH", -1.587697368035638e+01, -6.592827786065724e+00},
	{"RNI", -1.193774780907509e+01, -2.653601914784437e+00},
	{"RNJ", -1.962590088611105e+01, -1.034175499182039e+01},
	{"RNK", -1.938521213304605e+01, -1.010106623875539e+01},
	{"RNL", -1.701494627178659e+01, -7.730800377495930e+00},
	{"RNM", -1.265049763782275e+01, -3.366351743532094e+00},
	{"RNN", -1.674997215078047e+01, -7.465826256489807e+00},
	{"RNO", -1.245557198202993e+01, -3.171426087739273e+00},
	{"RNP", -1.612497082610902e+01, -6.840824931818365e+00},
	{"RNQ", -2.367054457995215e+01, -1.438639868566149e+01},
	{"RNR", -1.694897992568746e+01, -7.664834031396801e+00},
	{"RNS", -1.390096609555032e+01, -4.616820201259666e+00},
	{"RNT", -1.293907954603568e+01, -3.654933651745021e+00},
	{"RNU", -1.524608245461297e+01, -5.961936560322309e+00},
	{"RNV", -1.912693503292419e+01, -9.842789138633533e+00},
	{"RNW", -1.524970531271913e+01, -5.965559418428469e+00},
	{"RNX", -3.065587927979310e+01, -2.137173338550244e+01},
	{"RNY", -1.725356760007977e+01, -7.969421705789113e+00},
	{"RNZ", -3.116458432357270e+01, -2.188043842928204e+01},
	{"ROA", -1.259506077210093e+01, -5.312120658938419e+00},
	{"ROB", -1.284275914052119e+01, -5.559819027358684e+00},
	{"ROC", -1.261984669555067e+01, -5.336906582388157e+00},
	{"ROD", -1.258394481704986e+01, -5.301004703887346e+00},
	{"ROE", -1.568985882688892e+01, -8.406918713726412e+00},
	{"ROF", -1.056944626579073e+01, -3.286506152628216e+00},
	{"ROG", -1.372697224962870e+01, -6.444032136466194e+00},
	{"ROH", -1.553739109742667e+01, -8.254450984264158e+00},
	{"ROI", -1.525788373791645e+01, -7.974943624753939e+00},
	{"ROJ", -1.247915426297493e+01, -5.196214149812414e+00},
	{"ROK", -1.397354940452736e+01, -6.690609291364850e+00},
	{"ROL", -1.291796668163045e+01, -5.635026568467936e+00},
	{"ROM", -9.553138821848146e+00, -2.270198708685635e+00},
	{"RON", -1.086198397172602e+01, -3.579043858563505e+00},
	{"ROO", -1.216480472235074e+01, -4.881864609188233e+00},
	{"ROP", -1.158642081868241e+01, -4.303480705519898e+00},
	{"ROQ", -1.901786956558546e+01, -1.173492945242295e+01},
	{"ROR", -1.269473243278613e+01, -5.411792319623625e+00},
	{"ROS", -1.217774914884637e+01, -4.894809035683862e+00},
	{"ROT", -1.199605412334524e+01, -4.713114010182735e+00},
	{"ROU", -1.014741034636346e+01, -2.864470233200950e+00},
	{"ROV", -1.196998781456261e+01, -4.687047701400099e+00},
	{"ROW", -1.147440042914979e+01, -4.191460315987283e+00},
	{"ROX", -1.635227070733477e+01, -9.069330594172261e+00},
	{"ROY", -1.310301430368018e+01, -5.820074190517665e+00},
	{"ROZ", -1.758930814104217e+01, -1.030636802787966e+01},
	{"RPA", -1.324823147340789e+01, -2.761620469618040e+00},
	{"RPB", -1.990461223807340e+01, -9.418001234283553e+00},
	{"RPC", -1.990780452977329e+01, -9.421193525983442e+00},
	{"RPD", -2.212197248126849e+01, -1.163536147747864e+01},
	{"RPE", -1.316823876228500e+01, -2.681627758495152e+00},
	{"RPF", -1.939202974730611e+01, -8.905418743516258e+00},
	{"RPG", -1.854739152120843e+01, -8.060780517418575e+00},
	{"RPH", -1.584272838153783e+01, -5.356117377747977e+00},
	{"RPI", -1.522166115058917e+01, -4.735050146799318e+00},
	{"RPJ", -3.122210957213020e+01, -2.073549856834035e+01},
	{"RPK", -2.171671053491382e+01, -1.123009953112397e+01},
	{"RPL", -1.414095866601381e+01, -3.654347662223964e+00},
	{"RPM", -1.931851961472734e+01, -8.831908610937493e+00},
	{"RPN", -1.971646475556999e+01, -9.229853751780139e+00},
	{"RPO", -1.277616504054364e+01, -2.289554036753788e+00},
	{"RPP", -1.862188129672293e+01, -8.135270292933074e+00},
	{"RPQ", -2.371548889619265e+01, -1.322887789240280e+01},
	{"RPR", -1.244644865819212e+01, -1.959837654402267e+00},
	{"RPS", -1.574450984182904e+01, -5.257898838039186e+00},
	{"RPT", -1.812774134034014e+01, -7.641130336550289e+00},
	{"RPU", -1.501841131097853e+01, -4.531800307188681e+00},
	{"RPV", -3.063634787303499e+01, -2.014973686924514e+01},
	{"RPW", -2.024442875307479e+01, -9.757817749284941e+00},
	{"RPX", -3.597955894319915e+01, -2.549294793940930e+01},
	{"RPY", -2.023598529145147e+01, -9.749374287661619e+00},
	{"RPZ", -3.418483987981722e+01, -2.369822887602736e+01},
	{"RQA", -2.752618621968733e+01, -1.265353122604738e+01},
	{"RQB", -3.015360816682961e+01, -1.528095317318965e+01},
	{"RQC", -2.368610569172663e+01, -8.813450698086678e+00},
	{"RQD", -3.067531202691953e+01, -1.580265703327958e+01},
	{"RQE", -3.105218470866351e+01, -1.617952971502355e+01},
	{"RQF", -2.941856803991249e+01, -1.454591304627254e+01},
	{"RQG", -3.613893494470189e+01, -2.126627995106194e+01},
	{"RQH", -2.996847983079930e+01, -1.509582483715935e+01},
	{"RQI", -2.586523023507157e+01, -1.099257524143161e+01},
	{"RQJ", -3.193898140232130e+01, -1.706632640868135e+01},
	{"RQK", -3.777112013964063e+01, -2.289846514600068e+01},
	{"RQL", -3.041605720062251e+01, -1.554340220698256e+01},
	{"RQM", -2.369679189363859e+01, -8.824136899998637e+00},
	{"RQN", -3.242298773545057e+01, -1.755033274181062e+01},
	{"RQO", -3.061943356617601e+01, -1.574677857253605e+01},
	{"RQP", -3.061349512784347e+01, -1.574084013420351e+01},
	{"RQQ", -3.250302190133896e+01, -1.763036690769901e+01},
	{"RQR", -3.046832240405372e+01, -1.559566741041377e+01},
	{"RQS", -2.754063455934248e+01, -1.266797956570252e+01},
	{"RQT", -2.804030556327679e+01, -1.316765056963683e+01},
	{"RQU", -1.488075467409246e+01, -8.099680452504025e-03},
	{"RQV", -3.333417558169224e+01, -1.846152058805229e+01},
	{"RQW", -2.969242840583851e+01, -1.481977341219856e+01},
	{"RQX", -3.979425209752356e+01, -2.492159710388361e+01},
	{"RQY", -3.398697229897034e+01, -1.911431730533039e+01},
	{"RQZ", -4.093381953427409e+01, -2.606116454063414e+01},
	{"RRA", -1.303395638528283e+01, -3.278074604106385e+00},
	{"RRB", -2.202662604906550e+01, -1.227074426788906e+01},
	{"RRC", -2.482168499401295e+01, -1.506580321283651e+01},
	{"RRD", -2.175519896552557e+01, -1.199931718434913e+01},
	{"RRE", -1.144936211137960e+01, -1.693480330203161e+00},
	{"RRF", -2.162777970735928e+01, -1.187189792618284e+01},
	{"RRG", -2.528290369605145e+01, -1.552702191487501e+01},
	{"RRH", -1.609454446559210e+01, -6.338662684415657e+00},
	{"RRI", -1.159559089744266e+01, -1.839709116266223e+00},
	{"RRJ", -2.875307581838187e+01, -1.899719403720542e+01},
	{"RRK", -2.562024742256474e+01, -1.586436564138831e+01},
	{"RRL", -2.161663852921108e+01, -1.186075674803464e+01},
	{"RRM", -2.449557715849966e+01, -1.473969537732322e+01},
	{"RRN", -2.188622366442652e+01, -1.213034188325008e+01},
	{"RRO", -1.243728328788942e+01, -2.681401506712978e+00},
	{"RRP", -2.575356795877254e+01, -1.599768617759609e+01},
	{"RRQ", -3.013961194862264e+01, -2.038373016744620e+01},
	{"RRR", -2.048534494964060e+01, -1.072946316846415e+01},
	{"RRS", -2.065272598705009e+01, -1.089684420587365e+01},
	{"RRT", -2.077714262138013e+01, -1.102126084020369e+01},
	{"RRU", -1.444636289253428e+01, -4.690481111357841e+00},
	{"RRV", -2.011045055274445e+01, -1.035456877156801e+01},
	{"RRW", -2.021973206920950e+01, -1.046385028803306e+01},
	{"RRX", -3.080473812138209e+01, -2.104885634020565e+01},
	{"RRY", -1.312193625496786e+01, -3.366054473791416e+00},
	{"RRZ", -3.173586065522835e+01, -2.197997887405191e+01},
	{"RSA", -1.093073003892973e+01, -2.938063458336041e+00},
	{"RSB", -1.360314466453904e+01, -5.610478083945344e+00},
	{"RSC", -1.372621241095387e+01, -5.733545830360171e+00},
	{"RSD", -1.468456090933684e+01, -6.691894328743146e+00},
	{"RSE", -1.094933899510500e+01, -2.956672414511310e+00},
	{"RSF", -1.364132477172338e+01, -5.648658191129688e+00},
	{"RSG", -1.572910134835478e+01, -7.736434767761084e+00},
	{"RSH", -1.164902461310001e+01, -3.656358032506311e+00},
	{"RSI", -1.160700999662836e+01, -3.614343416034669e+00},
	{"RSJ", -1.729181415664582e+01, -9.299147576052119e+00},
	{"RSK", -1.669487450041816e+01, -8.702207919824458e+00},
	{"RSL", -1.440049490061970e+01, -6.407828320026008e+00},
	{"RSM", -1.429574529892443e+01, -6.303078718330736e+00},
	{"RSN", -1.499311975114155e+01, -7.000453170547854e+00},
	{"RSO", -1.082407995263430e+01, -2.831413372040604e+00},
	{"RSP", -1.355531304495800e+01, -5.562646464364307e+00},
	{"RSQ", -1.724232429342406e+01, -9.249657712830370e+00},
	{"RSR", -1.500699323395991e+01, -7.014326653366218e+00},
	{"RSS", -1.346985825337495e+01, -5.477191672781253e+00},
	{"RST", -1.045514857151744e+01, -2.462481990923747e+00},
	{"RSU", -1.277340650198363e+01, -4.780739921389936e+00},
	{"RSV", -1.583568448743051e+01, -7.843017906836819e+00},
	{"RSW", -1.234543517778586e+01, -4.352768597192164e+00},
	{"RSX", -3.021767322697546e+01, -2.222500664638177e+01},
	{"RSY", -1.554804657554394e+01, -7.555379994950245e+00},
	{"RSZ", -2.271589282278382e+01, -1.472322624219013e+01},
	{"RTA", -1.136355760322724e+01, -3.662573515914542e+00},
	{"RTB", -1.531679908652191e+01, -7.615814999209212e+00},
	{"RTC", -1.600284173089051e+01, -8.301857643577808e+00},
	{"RTD", -1.656743762820723e+01, -8.866453540894524e+00},
	{"RTE", -1.184331743629999e+01, -4.142333348987287e+00},
	{"RTF", -1.485701538405857e+01, -7.156031296745868e+00},
	{"RTG", -1.659864893401484e+01, -8.897664846702133e+00},
	{"RTH", -8.793242307223695e+00, -1.092258219910993e+00},
	{"RTI", -1.137521267284921e+01, -3.674228585536508e+00},
	{"RTJ", -1.907343357505137e+01, -1.137244948773867e+01},
	{"RTK", -1.907324634463124e+01, -1.137226225731854e+01},
	{"RTL", -1.447240703289762e+01, -6.771422945584914e+00},
	{"RTM", -1.455578126296630e+01, -6.854797175653597e+00},
	{"RTN", -1.553315505671355e+01, -7.832170969400844e+00},
	{"RTO", -1.087920424784393e+01, -3.178220160531232e+00},
	{"RTP", -1.652752247533113e+01, -8.826538388018429e+00},
	{"RTQ", -2.054779379394075e+01, -1.284680970662805e+01},
	{"RTR", -1.357040909117986e+01, -5.869425003867160e+00},
	{"RTS", -1.241049064900952e+01, -4.709506561696816e+00},
	{"RTT", -1.315712214303471e+01, -5.456138055722008e+00},
	{"RTU", -1.287055067970414e+01, -5.169566592391440e+00},
	{"RTV", -1.799014147767078e+01, -1.028915739035807e+01},
	{"RTW", -1.350983147316281e+01, -5.808847385850104e+00},
	{"RTX", -3.359037085400495e+01, -2.588938676669225e+01},
	{"RTY", -1.245173336007631e+01, -4.750749272763605e+00},
	{"RTZ", -2.091021707898689e+01, -1.320923299167419e+01},
	{"RUA", -1.651179499429445e+01, -6.766025790359084e+00},
	{"RUB", -1.494875332896392e+01, -5.202984125028554e+00},
	{"RUC", -1.289307610299429e+01, -3.147306899058928e+00},
	{"RUD", -1.501976825615573e+01, -5.273999052220361e+00},
	{"RUE", -1.384733205230400e+01, -4.101562848368633e+00},
	{"RUF", -1.758561104902244e+01, -7.839841845087074e+00},
	{"RUG", -1.462069441139409e+01, -4.874925207458722e+00},
	{"RUH", -2.069727686099884e+01, -1.095150765706348e+01},
	{"RUI", -1.352688826574106e+01, -3.781119061805693e+00},
	{"RUJ", -2.370990386895743e+01, -1.396413466502206e+01},
	{"RUK", -2.209326723136973e+01, -1.234749802743436e+01},
	{"RUL", -1.361780023042138e+01, -3.872031026486011e+00},
	{"RUM", -1.370782359745915e+01, -3.962054393523779e+00},
	{"RUN", -1.249337521651843e+01, -2.747606012583062e+00},
	{"RUO", -2.111531512131176e+01, -1.136954591737640e+01},
	{"RUP", -1.379054127128897e+01, -4.044772067353599e+00},
	{"RUQ", -3.252210181569320e+01, -2.277633261175784e+01},
	{"RUR", -1.653371728739488e+01, -6.787948083459511e+00},
	{"RUS", -1.176034525726448e+01, -2.014576053329118e+00},
	{"RUT", -1.394640745265218e+01, -4.200638248716810e+00},
	{"RUU", -2.369854747014622e+01, -1.395277826621085e+01},
	{"RUV", -2.171081168124621e+01, -1.196504247731084e+01},
	{"RUW", -2.264074571311770e+01, -1.289497650918233e+01},
	{"RUX", -2.947935649992837e+01, -1.973358729599301e+01},
	{"RUY", -2.071286591739253e+01, -1.096709671345717e+01},
	{"RUZ", -2.054508108655072e+01, -1.079931188261535e+01},
	{"RVA", -1.260097319121033e+01, -1.797174857653289e+00},
	{"RVB", -3.215009111356542e+01, -2.134629278000838e+01},
	{"RVC", -3.236318160049812e+01, -2.155938326694108e+01},
	{"RVD", -2.371283264636804e+01, -1.290903431281101e+01},
	{"RVE", -1.221388536925121e+01, -1.410087035694175e+00},
	{"RVF", -3.180396236426800e+01, -2.100016403071096e+01},
	{"RVG", -3.313099336685116e+01, -2.232719503329412e+01},
	{"RVH", -2.370857784529393e+01, -1.290477951173690e+01},
	{"RVI", -1.267118731271507e+01, -1.867388979158035e+00},
	{"RVJ", -3.305385106749178e+01, -2.225005273393474e+01},
	{"RVK", -3.493345169027010e+01, -2.412965335671306e+01},
	{"RVL", -3.220569476195561e+01, -2.140189642839857e+01},
	{"RVM", -2.371089980416878e+01, -1.290710147061174e+01},
	{"RVN", -2.139400869370980e+01, -1.059021036015276e+01},
	{"RVO", -1.493448992329220e+01, -4.130691589735158e+00},
	{"RVP", -3.128880454866557e+01, -2.048500621510853e+01},
	{"RVQ", -3.888564646360558e+01, -2.808184813004855e+01},
	{"RVR", -2.924170127740849e+01, -1.843790294385145e+01},
	{"RVS", -2.212887078142671e+01, -1.132507244786968e+01},
	{"RVT", -2.090806978371543e+01, -1.010427145015839e+01},
	{"RVU", -2.013124437551886e+01, -9.327446041961826e+00},
	{"RVV", -3.370818606339683e+01, -2.290438772983979e+01},
	{"RVW", -2.213068552506001e+01, -1.132688719150298e+01},
	{"RVX", -3.551146728070224e+01, -2.470766894714520e+01},
	{"RVY", -2.168978110693990e+01, -1.088598277338286e+01},
	{"RVZ", -3.892134616325996e+01, -2.811754782970293e+01},
	{"RWA", -1.191936268773862e+01, -1.759994538568358e+00},
	{"RWB", -2.768449130100637e+01, -1.752512315183611e+01},
	{"RWC", -2.363277223424632e+01, -1.347340408507606e+01},
	{"RWD", -2.725614680416169e+01, -1.709677865499143e+01},
	{"RWE", -1.335272345509228e+01, -3.193355305922021e+00},
	{"RWF", -2.753756394741454e+01, -1.737819579824427e+01},
	{"RWG", -2.866527001348901e+01, -1.850590186431874e+01},
	{"RWH", -1.203923379418955e+01, -1.879865645019285e+00},
	{"RWI", -1.236013593499697e+01, -2.200767785826709e+00},
	{"RWJ", -3.002196447630642e+01, -1.986259632713615e+01},
	{"RWK", -3.017697693983243e+01, -2.001760879066217e+01},
	{"RWL", -2.660650440377832e+01, -1.644713625460805e+01},
	{"RWM", -2.360363294828785e+01, -1.344426479911758e+01},
	{"RWN", -2.418213139783816e+01, -1.402276324866790e+01},
	{"RWO", -1.361467112957659e+01, -3.455302980406331e+00},
	{"RWP", -2.839570510347131e+01, -1.823633695430104e+01},
	{"RWQ", -3.264932625018244e+01, -2.248995810101218e+01},
	{"RWR", -1.630751178913338e+01, -6.148143639963121e+00},
	{"RWS", -2.544207855760268e+01, -1.528271040843242e+01},
	{"RWT", -2.249765411770425e+01, -1.233828596853399e+01},
	{"RWU", -2.269736882668047e+01, -1.253800067751021e+01},
	{"RWV", -3.049949961282762e+01, -2.034013146365735e+01},
	{"RWW", -2.206700680218454e+01, -1.190763865301428e+01},
	{"RWX", -3.984313251630785e+01, -2.968376436713759e+01},
	{"RWY", -2.748109538044705e+01, -1.732172723127679e+01},
	{"RWZ", -3.336611616694700e+01, -2.320674801777674e+01},
	{"RXA", -2.273052150010222e+01, -7.192740333702811e+00},
	{"RXB", -2.830418936135491e+01, -1.276640819495550e+01},
	{"RXC", -2.326682281913823e+01, -7.729041652738820e+00},
	{"RXD", -2.769921131450802e+01, -1.216143014810862e+01},
	{"RXE", -1.801392479333800e+01, -2.476143626938590e+00},
	{"RXF", -2.784132078056353e+01, -1.230353961416412e+01},
	{"RXG", -2.914038532067928e+01, -1.360260415427988e+01},
	{"RXH", -2.549855914654260e+01, -9.960777980143190e+00},
	{"RXI", -1.804163181184685e+01, -2.503850645447447e+00},
	{"RXJ", -3.035335444670320e+01, -1.481557328030379e+01},
	{"RXK", -3.125144073714958e+01, -1.571365957075017e+01},
	{"RXL", -1.963016664229344e+01, -4.092385475894035e+00},
	{"RXM", -2.708116070711020e+01, -1.154337954071080e+01},
	{"RXN", -2.959087842852422e+01, -1.405309726212482e+01},
	{"RXO", -2.609587815799281e+01, -1.055809699159340e+01},
	{"RXP", -2.171861556936164e+01, -6.180834402962231e+00},
	{"RXQ", -2.925365009641634e+01, -1.371586893001694e+01},
	{"RXR", -2.787183749436961e+01, -1.233405632797020e+01},
	{"RXS", -2.716372294838069e+01, -1.162594178198128e+01},
	{"RXT", -2.050361760443849e+01, -4.965836438039081e+00},
	{"RXU", -2.637672028188950e+01, -1.083893911549009e+01},
	{"RXV", -1.846691096293388e+01, -2.929129796534475e+00},
	{"RXW", -2.718745264896773e+01, -1.164967148256832e+01},
	{"RXX", -1.688825105926441e+01, -1.350469892865005e+00},
	{"RXY", -2.697090857995289e+01, -1.143312741355349e+01},
	{"RXZ", -4.079066984931595e+01, -2.525288868291653e+01},
	{"RYA", -1.215444499220396e+01, -3.186938470676532e+00},
	{"RYB", -1.355269236924870e+01, -4.585185847721264e+00},
	{"RYC", -1.370495439562427e+01, -4.737447874096842e+00},
	{"RYD", -1.409366073602666e+01, -5.126154214499225e+00},
	{"RYE", -1.353627918451543e+01, -4.568772662988001e+00},
	{"RYF", -1.374460618210465e+01, -4.777099660577225e+00},
	{"RYG", -1.470369229447109e+01, -5.736185772943664e+00},
	{"RYH", -1.394903572310182e+01, -4.981529201574386e+00},
	{"RYI", -1.263297557301524e+01, -3.665469051487810e+00},
	{"RYJ", -1.679882707248797e+01, -7.831320550960540e+00},
	{"RYK", -1.714729822152211e+01, -8.179791699994679e+00},
	{"RYL", -1.401218284154879e+01, -5.044676320021359e+00},
	{"RYM", -1.325641321345182e+01, -4.288906691924391e+00},
	{"RYN", -1.485336096006816e+01, -5.885854438540730e+00},
	{"RYO", -1.164404952305432e+01, -2.676543001526888e+00},
	{"RYP", -1.385488712177453e+01, -4.887380600247095e+00},
	{"RYQ", -1.767388733902261e+01, -8.706380817495177e+00},
	{"RYR", -1.483728531108045e+01, -5.869778789553020e+00},
	{"RYS", -1.297526075421039e+01, -4.007754232682958e+00},
	{"RYT", -1.213397832321095e+01, -3.166471801683525e+00},
	{"RYU", -1.565673881595563e+01, -6.689232294428199e+00},
	{"RYV", -1.616333524284479e+01, -7.195828721317355e+00},
	{"RYW", -1.297536051524102e+01, -4.007853993713592e+00},
	{"RYX", -1.981136581030361e+01, -1.084385928877618e+01},
	{"RYY", -1.643165922885249e+01, -7.464152707325061e+00},
	{"RYZ", -2.090950435737993e+01, -1.194199783585251e+01},
	{"RZA", -1.825227269640126e+01, -1.783368996155594e+00},
	{"RZB", -2.778592541420256e+01, -1.131702171395690e+01},
	{"RZC", -2.867197790437466e+01, -1.220307420412899e+01},
	{"RZD", -2.903114374577750e+01, -1.256224004553183e+01},
	{"RZE", -1.819794047509312e+01, -1.729036774847459e+00},
	{"RZF", -2.861827531215209e+01, -1.214937161190642e+01},
	{"RZG", -2.913833778711390e+01, -1.266943408686824e+01},
	{"RZH", -2.775686663802985e+01, -1.128796293778419e+01},
	{"RZI", -1.818183701501864e+01, -1.712933314772978e+00},
	{"RZJ", -3.166496918743647e+01, -1.519606548719080e+01},
	{"RZK", -3.030046924782282e+01, -1.383156554757716e+01},
	{"RZL", -2.599070438446928e+01, -9.521800684223612e+00},
	{"RZM", -2.819896031415929e+01, -1.173005661391363e+01},
	{"RZN", -2.930178794277894e+01, -1.283288424253328e+01},
	{"RZO", -2.006342818218727e+01, -3.594524481941608e+00},
	{"RZP", -2.711663738034418e+01, -1.064773368009852e+01},
	{"RZQ", -3.558118307675981e+01, -1.911227937651415e+01},
	{"RZR", -2.633010931301150e+01, -9.861205612765842e+00},
	{"RZS", -2.794765936166917e+01, -1.147875566142350e+01},
	{"RZT", -2.644841426458183e+01, -9.979510564336172e+00},
	{"RZU", -2.585080530830258e+01, -9.381901608056912e+00},
	{"RZV", -2.874866388090411e+01, -1.227976018065845e+01},
	{"RZW", -2.361826671523853e+01, -7.149363014992864e+00},
	{"RZX", -3.838931963820465e+01, -2.192041593795899e+01},
	{"RZY", -2.682479888653033e+01, -1.035589518628466e+01},
	{"RZZ", -2.441967719168676e+01, -7.950773491441093e+00},
	{"SAA", -1.593678227696745e+01, -8.751763021900716e+00},
	{"SAB", -1.257948802826728e+01, -5.394468773200549e+00},
	{"SAC", -1.201791124063836e+01, -4.832891985571626e+00},
	{"SAD", -1.292509963091769e+01, -5.740080375850950e+00},
	{"SAE", -1.771622047669412e+01, -1.053120122162739e+01},
	{"SAF", -1.256758635491571e+01, -5.382567099848974e+00},
	{"SAG", -1.222615661325481e+01, -5.041137358188071e+00},
	{"SAH", -1.507427803698073e+01, -7.889258781913990e+00},
	{"SAI", -1.036660906945737e+01, -3.181589814390634e+00},
	{"SAJ", -1.791072537986070e+01, -1.072570612479397e+01},
	{"SAK", -1.452809778102154e+01, -7.343078525954805e+00},
	{"SAL", -1.107283948756182e+01, -3.887820232495081e+00},
	{"SAM", -1.161915815967448e+01, -4.434138904607744e+00},
	{"SAN", -8.804470593605997e+00, -1.619451338539261e+00},
	{"SAO", -1.954590686211025e+01, -1.236088760704352e+01},
	{"SAP", -1.282814361321094e+01, -5.643124358144202e+00},
	{"SAQ", -1.804552605953707e+01, -1.086050680447033e+01},
	{"SAR", -1.105177444278649e+01, -3.866755187719753e+00},
	{"SAS", -1.146220134346091e+01, -4.277182088394172e+00},
	{"SAT", -1.139221040530342e+01, -4.207191150236681e+00},
	{"SAU", -1.366445278185168e+01, -6.479433526784948e+00},
	{"SAV", -1.311549418789405e+01, -5.930474932827313e+00},
	{"SAW", -1.254556039109466e+01, -5.360541136027926e+00},
	{"SAX", -1.668501519303821e+01, -9.499995937971477e+00},
	{"SAY", -1.133896916909493e+01, -4.153949914028194e+00},
	{"SAZ", -2.001458367971816e+01, -1.282956442465142e+01},
	{"SBA", -1.328067232814997e+01, -3.510450088653929e+00},
	{"SBB", -2.262918706474168e+01, -1.285896482524564e+01},
	{"SBC", -1.713271764571824e+01, -7.362495406222211e+00},
	{"SBD", -2.211864422404209e+01, -1.234842198454605e+01},
	{"SBE", -1.126295209360851e+01, -1.492729854112478e+00},
	{"SBF", -2.212879571254913e+01, -1.235857347305310e+01},
	{"SBG", -2.371375339953853e+01, -1.394353116004249e+01},
	{"SBH", -2.912204961417459e+01, -1.935182737467856e+01},
	{"SBI", -1.547181775151412e+01, -5.701595512018084e+00},
	{"SBJ", -2.667688333543799e+01, -1.690666109594196e+01},
	{"SBK", -3.213274610868183e+01, -2.236252386918580e+01},
	{"SBL", -1.507522707542266e+01, -5.305004835926624e+00},
	{"SBM", -2.845128656992703e+01, -1.868106433043100e+01},
	{"SBN", -2.922722664832196e+01, -1.945700440882592e+01},
	{"SBO", -1.332117800358622e+01, -3.550955764090182e+00},
	{"SBP", -2.113067428707902e+01, -1.136045204758298e+01},
	{"SBQ", -3.600013718012890e+01, -2.622991494063286e+01},
	{"SBR", -1.304518378241599e+01, -3.274961542919958e+00},
	{"SBS", -2.159973082536063e+01, -1.182950858586459e+01},
	{"SBT", -2.086771107662591e+01, -1.109748883712988e+01},
	{"SBU", -1.203135962199689e+01, -2.261137382500860e+00},
	{"SBV", -2.991464380957966e+01, -2.014442157008363e+01},
	{"SBW", -2.212402684385457e+01, -1.235380460435853e+01},
	{"SBX", -3.928734501936950e+01, -2.951712277987347e+01},
	{"SBY", -1.299200407352799e+01, -3.221781834031952e+00},
	{"SBZ", -3.379544889513690e+01, -2.402522665564087e+01},
	{"SCA", -1.137347388844290e+01, -2.276120015947436e+00},
	{"SCB", -2.369238252044680e+01, -1.459502864795133e+01},
	{"SCC", -2.047039794696106e+01, -1.137304407446560e+01},
	{"SCD", -2.039148632877369e+01, -1.129413245627823e+01},
	{"SCE", -1.300824087235463e+01, -3.910886999859169e+00},
	{"SCF", -2.090727999437365e+01, -1.180992612187818e+01},
	{"SCG", -2.171503601178283e+01, -1.261768213928737e+01},
	{"SCH", -1.223572008563036e+01, -3.138366213134899e+00},
	{"SCI", -1.283217518763522e+01, -3.734821315139760e+00},
	{"SCJ", -3.223202891903353e+01, -2.313467504653807e+01},
	{"SCK", -2.397136259214534e+01, -1.487400871964988e+01},
	{"SCL", -1.364229106599628e+01, -4.544937193500814e+00},
	{"SCM", -2.139064634949719e+01, -1.229329247700173e+01},
	{"SCN", -2.013243541157939e+01, -1.103508153908393e+01},
	{"SCO", -1.070737402246957e+01, -1.610020149974108e+00},
	{"SCP", -1.980851759159611e+01, -1.071116371910066e+01},
	{"SCQ", -2.864147464700832e+01, -1.954412077451286e+01},
	{"SCR", -1.217153422804184e+01, -3.074180355546383e+00},
	{"SCS", -1.939010801298716e+01, -1.029275414049170e+01},
	{"SCT", -1.955342894206791e+01, -1.045607506957245e+01},
	{"SCU", -1.362904359927786e+01, -4.531689726782393e+00},
	{"SCV", -3.190660653634923e+01, -2.280925266385377e+01},
	{"SCW", -2.137763972413295e+01, -1.228028585163748e+01},
	{"SCX", -3.324996225301442e+01, -2.415260838051897e+01},
	{"SCY", -1.835507392397823e+01, -9.257720051482766e+00},
	{"SCZ", -2.271624834610571e+01, -1.361889447361025e+01},
	{"SDA", -1.333029754426500e+01, -2.891537293205124e+00},
	{"SDB", -2.114941918619335e+01, -1.071065893513347e+01},
	{"SDC", -2.194356056367926e+01, -1.150480031261938e+01},
	{"SDD", -2.191608704410356e+01, -1.147732679304369e+01},
	{"SDE", -1.212023448765914e+01, -1.681474236599264e+00},
	{"SDF", -2.234311189826042e+01, -1.190435164720055e+01},
	{"SDG", -2.519488222628175e+01, -1.475612197522188e+01},
	{"SDH", -2.174370805468989e+01, -1.130494780363002e+01},
	{"SDI", -1.261307843676111e+01, -2.174318185701234e+00},
	{"SDJ", -2.682238363428439e+01, -1.638362338322452e+01},
	{"SDK", -2.799981577161824e+01, -1.756105552055837e+01},
	{"SDL", -2.502346752544123e+01, -1.458470727438136e+01},
	{"SDM", -2.124592668698045e+01, -1.080716643592058e+01},
	{"SDN", -2.484641592697490e+01, -1.440765567591503e+01},
	{"SDO", -1.295162203139330e+01, -2.512861780333423e+00},
	{"SDP", -2.197468896980312e+01, -1.153592871874325e+01},
	{"SDQ", -2.944010484414558e+01, -1.900134459308571e+01},
	{"SDR", -1.401710172955952e+01, -3.578341478499650e+00},
	{"SDS", -2.190201596423871e+01, -1.146325571317884e+01},
	{"SDT", -1.823013090493526e+01, -7.791370653875386e+00},
	{"SDU", -1.466162493719774e+01, -4.222864686137872e+00},
	{"SDV", -2.352645296719564e+01, -1.308769271613576e+01},
	{"SDW", -1.767700892313752e+01, -7.238248672077653e+00},
	{"SDX", -3.434289760340596e+01, -2.390413735234609e+01},
	{"SDY", -1.812362028191133e+01, -7.684860030851453e+00},
	{"SDZ", -3.042533940372446e+01, -1.998657915266459e+01},
	{"SEA", -1.073916696613780e+01, -3.723830491241860e+00},
	{"SEB", -1.345499348386918e+01, -6.439657008973237e+00},
	{"SEC", -1.149626427112915e+01, -4.480927796233202e+00},
	{"SED", -1.031069542987808e+01, -3.295358954982140e+00},
	{"SEE", -1.074062949943643e+01, -3.725293024540491e+00},
	{"SEF", -1.321426143485414e+01, -6.198924959958197e+00},
	{"SEG", -1.481070921709603e+01, -7.795372742200086e+00},
	{"SEH", -1.291827519097198e+01, -5.902938716076033e+00},
	{"SEI", -1.210689776410392e+01, -5.091561289207975e+00},
	{"SEJ", -1.714818597120911e+01, -1.013284949631316e+01},
	{"SEK", -1.698910898913587e+01, -9.973772514239927e+00},
	{"SEL", -1.048275335761567e+01, -3.467416882719731e+00},
	{"SEM", -1.239010876831755e+01, -5.374772293421603e+00},
	{"SEN", -1.038767023023141e+01, -3.372333755335468e+00},
	{"SEO", -1.142826289473574e+01, -4.412926419839798e+00},
	{"SEP", -1.265290062574680e+01, -5.637564150850850e+00},
	{"SEQ", -1.418338074042236e+01, -7.168044265526417e+00},
	{"SER", -1.078150732478083e+01, -3.766170849884884e+00},
	{"SES", -1.061981811716387e+01, -3.604481642267926e+00},
	{"SET", -1.052146170670860e+01, -3.506125231812662e+00},
	{"SEU", -1.389352457952985e+01, -6.878188104633904e+00},
	{"SEV", -1.178087663194587e+01, -4.765540157049922e+00},
	{"SEW", -1.233304640490130e+01, -5.317709930005353e+00},
	{"SEX", -1.297461788362870e+01, -5.959281408732762e+00},
	{"SEY", -1.378888001877719e+01, -6.773543543881247e+00},
	{"SEZ", -1.954765419914370e+01, -1.253231772424776e+01},
	{"SFA", -1.232770156314797e+01, -2.627319297075101e+00},
	{"SFB", -2.203926257159033e+01, -1.233888030551746e+01},
	{"SFC", -2.543080205307938e+01, -1.573041978700651e+01},
	{"SFD", -2.109458902931252e+01, -1.139420676323965e+01},
	{"SFE", -1.373793786185331e+01, -4.037555595780438e+00},
	{"SFF", -1.847153747248141e+01, -8.771155206408535e+00},
	{"SFG", -2.596756790262294e+01, -1.626718563655007e+01},
	{"SFH", -2.102211881688059e+01, -1.132173655080772e+01},
	{"SFI", -1.294583515938346e+01, -3.245452893310588e+00},
	{"SFJ", -2.675586247656502e+01, -1.705548021049215e+01},
	{"SFK", -2.865204324151455e+01, -1.895166097544168e+01},
	{"SFL", -1.462186766181806e+01, -4.921485395745185e+00},
	{"SFM", -2.324982918592998e+01, -1.354944691985711e+01},
	{"SFN", -2.263146244750728e+01, -1.293108018143441e+01},
	{"SFO", -1.104853710787234e+01, -1.348154841799472e+00},
	{"SFP", -2.337891459631030e+01, -1.367853233023743e+01},
	{"SFQ", -3.089888881178712e+01, -2.119850654571425e+01},
	{"SFR", -1.210204823800859e+01, -2.401665971935723e+00},
	{"SFS", -2.033708671373648e+01, -1.063670444766361e+01},
	{"SFT", -2.103356027447731e+01, -1.133317800840443e+01},
	{"SFU", -1.408290606868246e+01, -4.382523802609592e+00},
	{"SFV", -2.793287110509158e+01, -1.823248883901870e+01},
	{"SFW", -2.568491955111839e+01, -1.598453728504552e+01},
	{"SFX", -3.321026031612063e+01, -2.350987805004776e+01},
	{"SFY", -1.758618471319253e+01, -7.885802447119656e+00},
	{"SFZ", -2.933885377564716e+01, -1.963847150957429e+01},
	{"SGA", -1.454816251946226e+01, -3.376140691390537e+00},
	{"SGB", -2.255326146705969e+01, -1.138123963898796e+01},
	{"SGC", -2.600878399961534e+01, -1.483676217154362e+01},
	{"SGD", -2.342778306295967e+01, -1.225576123488795e+01},
	{"SGE", -1.434159877052391e+01, -3.169576942452188e+00},
	{"SGF", -2.556355640029473e+01, -1.439153457222300e+01},
	{"SGG", -2.254744077380071e+01, -1.137541894572899e+01},
	{"SGH", -1.920724603590081e+01, -8.035224207829083e+00},
	{"SGI", -1.431675763551817e+01, -3.144735807446443e+00},
	{"SGJ", -2.923314211276221e+01, -1.806112028469049e+01},
	{"SGK", -2.369233440132106e+01, -1.252031257324934e+01},
	{"SGL", -1.564338384482547e+01, -4.471362016753750e+00},
	{"SGM", -1.775803659626007e+01, -6.586014768188349e+00},
	{"SGN", -2.153863595660617e+01, -1.036661412853445e+01},
	{"SGO", -1.297044171828910e+01, -1.798419890217377e+00},
	{"SGP", -2.344917224209182e+01, -1.227715041402010e+01},
	{"SGQ", -3.076453514067752e+01, -1.959251331260580e+01},
	{"SGR", -1.309527037626946e+01, -1.923248548197737e+00},
	{"SGS", -2.384128107015235e+01, -1.266925924208063e+01},
	{"SGT", -2.044104470925132e+01, -9.269022881179600e+00},
	{"SGU", -1.517253853534998e+01, -4.000516707278260e+00},
	{"SGV", -2.860497692259801e+01, -1.743295509452629e+01},
	{"SGW", -2.009110755891381e+01, -8.919085730842081e+00},
	{"SGX", -3.398335560712488e+01, -2.281133377905316e+01},
	{"SGY", -2.203550138714976e+01, -1.086347955907804e+01},
	{"SGZ", -3.257160912115711e+01, -2.139958729308539e+01},
	{"SHA", -9.243514678580693e+00, -1.539207227396077e+00},
	{"SHB", -1.537404335527693e+01, -7.669735904092311e+00},
	{"SHC", -1.520662973901300e+01, -7.502322287828384e+00},
	{"SHD", -1.611090640437653e+01, -8.406598953191915e+00},
	{"SHE", -9.597680754303298e+00, -1.893373303118681e+00},
	{"SHF", -1.546091773837393e+01, -7.756610287189316e+00},
	{"SHG", -1.577597708646259e+01, -8.071669635277974e+00},
	{"SHH", -1.540490446082653e+01, -7.700597009641910e+00},
	{"SHI", -1.092189924426672e+01, -3.217591793082107e+00},
	{"SHJ", -1.939584931604746e+01, -1.169154186486284e+01},
	{"SHK", -1.819488726136908e+01, -1.049057981018446e+01},
	{"SHL", -1.593696232269132e+01, -8.232654871506700e+00},
	{"SHM", -1.375714372281806e+01, -6.052836271633447e+00},
	{"SHN", -1.594350208935404e+01, -8.239194638169421e+00},
	{"SHO", -1.027469696960262e+01, -2.570389518418003e+00},
	{"SHP", -1.572398767644038e+01, -8.019680225255762e+00},
	{"SHQ", -1.963098293054098e+01, -1.192667547935636e+01},
	{"SHR", -1.505938256712872e+01, -7.355075115944098e+00},
	{"SHS", -1.510329988300652e+01, -7.398992431821901e+00},
	{"SHT", -1.367686053402626e+01, -5.972553082841647e+00},
	{"SHU", -1.341693346532540e+01, -5.712626014140780e+00},
	{"SHV", -1.765245746224189e+01, -9.948150011057274e+00},
	{"SHW", -1.493680175755411e+01, -7.232494306369490e+00},
	{"SHX", -3.560491737995476e+01, -2.790060992877015e+01},
	{"SHY", -1.619296718117099e+01, -8.488659729986370e+00},
	{"SHZ", -2.113332965101453e+01, -1.342902219982991e+01},
	{"SIA", -1.290682742306329e+01, -5.229317611560341e+00},
	{"SIB", -1.272426635915761e+01, -5.046756547654666e+00},
	{"SIC", -1.304942075215239e+01, -5.371910940649438e+00},
	{"SID", -1.129700620964767e+01, -3.619496398144717e+00},
	{"SIE", -1.426555352071632e+01, -6.588043709213367e+00},
	{"SIF", -1.350501478042788e+01, -5.827504968924933e+00},
	{"SIG", -1.226203357683787e+01, -4.584523765334914e+00},
	{"SIH", -1.502148187172589e+01, -7.343972060222940e+00},
	{"SII", -1.669587424698668e+01, -9.018364435483736e+00},
	{"SIJ", -2.013280153545652e+01, -1.245529172395356e+01},
	{"SIK", -1.750655604287429e+01, -9.829046231371345e+00},
	{"SIL", -1.258665257985681e+01, -4.909142768353863e+00},
	{"SIM", -1.256964616737691e+01, -4.892136355873957e+00},
	{"SIN", -9.372460115041880e+00, -1.694950303538931e+00},
	{"SIO", -1.102846242286132e+01, -3.350952611358367e+00},
	{"SIP", -1.538681290307426e+01, -7.709303091571313e+00},
	{"SIQ", -2.013121604857306e+01, -1.245370623707011e+01},
	{"SIR", -1.275220415999404e+01, -5.074694348491090e+00},
	{"SIS", -1.140612771618285e+01, -3.728617904679902e+00},
	{"SIT", -1.065434931523615e+01, -2.976839503733200e+00},
	{"SIU", -1.597654191401742e+01, -8.299032102514470e+00},
	{"SIV", -1.349398502034614e+01, -5.816475208843195e+00},
	{"SIW", -1.528358713073356e+01, -7.606077319230614e+00},
	{"SIX", -1.361020089304908e+01, -5.932691081546126e+00},
	{"SIY", -2.139634327873188e+01, -1.371883346722893e+01},
	{"SIZ", -1.528790247735254e+01, -7.610392665849592e+00},
	{"SJA", -1.624759833722729e+01, -3.022867509125948e+00},
	{"SJB", -2.090329021177816e+01, -7.678559383676808e+00},
	{"SJC", -2.909278565124212e+01, -1.586805482314078e+01},
	{"SJD", -2.271487778209179e+01, -9.490146953990440e+00},
	{"SJE", -1.585661644488303e+01, -2.631885616781689e+00},
	{"SJF", -2.139421077597512e+01, -8.169479947873771e+00},
	{"SJG", -2.369677268588941e+01, -1.047204185778806e+01},
	{"SJH", -2.170952869236337e+01, -8.484797864262026e+00},
	{"SJI", -1.834713671069888e+01, -5.122405882597530e+00},
	{"SJJ", -2.212128247696994e+01, -8.896551648868597e+00},
	{"SJK", -2.371330524180394e+01, -1.048857441370259e+01},
	{"SJL", -2.271082687353641e+01, -9.486096045435065e+00},
	{"SJM", -3.043325969025885e+01, -1.720852886215751e+01},
	{"SJN", -3.339050522852875e+01, -2.016577440042741e+01},
	{"SJO", -1.540080672366751e+01, -2.176075895566161e+00},
	{"SJP", -2.212776379723299e+01, -8.903032969131644e+00},
	{"SJQ", -3.280111062012012e+01, -1.957637979201878e+01},
	{"SJR", -2.090715337306111e+01, -7.682422544959765e+00},
	{"SJS", -2.171302911390589e+01, -8.488298285804545e+00},
	{"SJT", -2.959164055798115e+01, -1.636690972987980e+01},
	{"SJU", -1.442350048991197e+01, -1.198769661810630e+00},
	{"SJV", -3.645759272322190e+01, -2.323286189512055e+01},
	{"SJW", -2.170917972627969e+01, -8.484448898178341e+00},
	{"SJX", -3.913689813029072e+01, -2.591216730218938e+01},
	{"SJY", -3.560676888113534e+01, -2.238203805303399e+01},
	{"SJZ", -3.371176997459377e+01, -2.048703914649242e+01},
	{"SKA", -1.584000604786089e+01, -4.318810759331787e+00},
	{"SKB", -1.875169227950946e+01, -7.230496990980356e+00},
	{"SKC", -1.875507900039447e+01, -7.233883711865370e+00},
	{"SKD", -1.918698595161779e+01, -7.665790663088686e+00},
	{"SKE", -1.346193815455943e+01, -1.940742866030322e+00},
	{"SKF", -1.780482787876847e+01, -6.283632590239367e+00},
	{"SKG", -2.210403571941121e+01, -1.058284043088210e+01},
	{"SKH", -1.744508315055587e+01, -5.923887862026763e+00},
	{"SKI", -1.305769514535687e+01, -1.536499856827763e+00},
	{"SKJ", -2.212392244470074e+01, -1.060272715617163e+01},
	{"SKK", -2.170695716645455e+01, -1.018576187792544e+01},
	{"SKL", -1.944007449944069e+01, -7.918879210911582e+00},
	{"SKM", -1.822044896928940e+01, -6.699253680760298e+00},
	{"SKN", -1.488624058073891e+01, -3.365045292209807e+00},
	{"SKO", -1.669565850522670e+01, -5.174463216697593e+00},
	{"SKP", -2.037350996513613e+01, -8.852314676607026e+00},
	{"SKQ", -2.371420981401213e+01, -1.219301452548303e+01},
	{"SKR", -1.931835883944707e+01, -7.797163550917964e+00},
	{"SKS", -1.654114699705439e+01, -5.019951708525281e+00},
	{"SKT", -1.691093675698085e+01, -5.389741468451739e+00},
	{"SKU", -1.720658377885727e+01, -5.685388490328162e+00},
	{"SKV", -2.912474551535603e+01, -1.760355022682693e+01},
	{"SKW", -1.755977436617431e+01, -6.038579077645203e+00},
	{"SKX", -3.293577710997767e+01, -2.141458182144856e+01},
	{"SKY", -1.557286528473948e+01, -4.051669996210371e+00},
	{"SKZ", -3.103763999584741e+01, -1.951644470731830e+01},
	{"SLA", -1.174003191923876e+01, -1.713721950527473e+00},
	{"SLB", -2.161188176376102e+01, -1.158557179504973e+01},
	{"SLC", -1.999619842094308e+01, -9.969888452231784e+00},
	{"SLD", -2.161190773648320e+01, -1.158559776777191e+01},
	{"SLE", -1.234905995021788e+01, -2.322749981506585e+00},
	{"SLF", -2.326921799629799e+01, -1.324290802758670e+01},
	{"SLG", -2.685509412166198e+01, -1.682878415295068e+01},
	{"SLH", -2.260200687668329e+01, -1.257569690797200e+01},
	{"SLI", -1.217901680411766e+01, -2.152706835406369e+00},
	{"SLJ", -2.270648689661137e+01, -1.268017692790008e+01},
	{"SLK", -2.685941864226047e+01, -1.683310867354918e+01},
	{"SLL", -1.980742249659910e+01, -9.781112527887808e+00},
	{"SLM", -2.133604424653179e+01, -1.130973427782050e+01},
	{"SLN", -2.664359363674295e+01, -1.661728366803166e+01},
	{"SLO", -1.259024803330492e+01, -2.563938064593625e+00},
	{"SLP", -2.591946095624240e+01, -1.589315098753111e+01},
	{"SLQ", -3.067582599378005e+01, -2.064951602506876e+01},
	{"SLR", -2.645046057864992e+01, -1.642415060993863e+01},
	{"SLS", -2.077243292037576e+01, -1.074612295166447e+01},
	{"SLT", -2.025743700006173e+01, -1.023112703135044e+01},
	{"SLU", -1.596082201664105e+01, -5.934512047929760e+00},
	{"SLV", -2.348406364083634e+01, -1.345775367212505e+01},
	{"SLW", -2.591629004640691e+01, -1.588998007769562e+01},
	{"SLX", -3.389655797496016e+01, -2.387024800624887e+01},
	{"SLY", -1.367533037009677e+01, -3.649020401385474e+00},
	{"SLZ", -3.263928465102331e+01, -2.261297468231202e+01},
	{"SMA", -1.119143705578170e+01, -1.418585418006941e+00},
	{"SMB", -1.848004759884232e+01, -8.707195961067551e+00},
	{"SMC", -1.822302532449483e+01, -8.450173686720071e+00},
	{"SMD", -1.790865230447063e+01, -8.135800666695864e+00},
	{"SME", -1.274818305676806e+01, -2.975331418993302e+00},
	{"SMF", -1.880361484709514e+01, -9.030763209320375e+00},
	{"SMG", -2.070889913669766e+01, -1.093604749892290e+01},
	{"SMH", -1.961232542875021e+01, -9.839473790975450e+00},
	{"SMI", -1.258105658965296e+01, -2.808204951878200e+00},
	{"SMJ", -2.270406623773944e+01, -1.293121459996467e+01},
	{"SMK", -2.212590287908208e+01, -1.235305124130731e+01},
	{"SML", -1.962353898993785e+01, -9.850687352163089e+00},
	{"SMM", -1.830168337514010e+01, -8.528831737365335e+00},
	{"SMN", -1.900785612309010e+01, -9.235004485315335e+00},
	{"SMO", -1.215445185664109e+01, -2.381600218866324e+00},
	{"SMP", -1.894636149511362e+01, -9.173509857338855e+00},
	{"SMQ", -3.224071225087608e+01, -2.246786061310132e+01},
	{"SMR", -1.665116723983890e+01, -6.878315602064139e+00},
	{"SMS", -1.656082662304856e+01, -6.787974985273797e+00},
	{"SMT", -1.701842297654004e+01, -7.245571338765276e+00},
	{"SMU", -1.358608543693838e+01, -3.813233799163621e+00},
	{"SMV", -2.112759227210576e+01, -1.135474063433099e+01},
	{"SMW", -1.722212506132646e+01, -7.449273423551697e+00},
	{"SMX", -3.388040170782954e+01, -2.410755007005478e+01},
	{"SMY", -1.431598058588080e+01, -4.543128948106033e+00},
	{"SMZ", -3.250947582685642e+01, -2.273662418908166e+01},
	{"SNA", -1.336558324708426e+01, -3.130791881299101e+00},
	{"SNB", -2.611207848939426e+01, -1.587728712360910e+01},
	{"SNC", -2.418534040724865e+01, -1.395054904146349e+01},
	{"SND", -2.068506053590964e+01, -1.045026917012449e+01},
	{"SNE", -1.245349397118252e+01, -2.218702605397362e+00},
	{"SNF", -2.586661671462010e+01, -1.563182534883494e+01},
	{"SNG", -2.293459827861124e+01, -1.269980691282609e+01},
	{"SNH", -2.558100776768962e+01, -1.534621640190447e+01},
	{"SNI", -1.548611496710054e+01, -5.251323601315377e+00},
	{"SNJ", -2.827341164834194e+01, -1.803862028255678e+01},
	{"SNK", -2.693065633592636e+01, -1.669586497014121e+01},
	{"SNL", -2.350083899721648e+01, -1.326604763143132e+01},
	{"SNM", -2.349383451345858e+01, -1.325904314767343e+01},
	{"SNN", -2.623737963527148e+01, -1.600258826948632e+01},
	{"SNO", -1.096337451972385e+01, -7.285831539386902e-01},
	{"SNP", -2.677653904785239e+01, -1.654174768206723e+01},
	{"SNQ", -2.918422658753300e+01, -1.894943522174784e+01},
	{"SNR", -2.734287188706677e+01, -1.710808052128162e+01},
	{"SNS", -2.171498615818330e+01, -1.148019479239814e+01},
	{"SNT", -1.580796112465869e+01, -5.573169758873528e+00},
	{"SNU", -1.601713675893180e+01, -5.782345393146642e+00},
	{"SNV", -2.742874596361520e+01, -1.719395459783005e+01},
	{"SNW", -2.340897350158430e+01, -1.317418213579915e+01},
	{"SNX", -3.124080072971570e+01, -2.100600936393055e+01},
	{"SNY", -2.163626184991706e+01, -1.140147048413190e+01},
	{"SNZ", -3.174950577349530e+01, -2.151471440771014e+01},
	{"SOA", -1.359156180444926e+01, -6.225989575942940e+00},
	{"SOB", -1.369451450492168e+01, -6.328942276415353e+00},
	{"SOC", -1.264639874309107e+01, -5.280826514584747e+00},
	{"SOD", -1.421165044136824e+01, -6.846078212861912e+00},
	{"SOE", -1.417734387464415e+01, -6.811771646137829e+00},
	{"SOF", -8.881001988214765e+00, -1.515429759708439e+00},
	{"SOG", -1.552789470680474e+01, -8.162322478298414e+00},
	{"SOH", -1.414837496681709e+01, -6.782802738310766e+00},
	{"SOI", -1.338860112285348e+01, -6.023028894347153e+00},
	{"SOJ", -1.613317691291821e+01, -8.767604684411879e+00},
	{"SOK", -1.780588561405131e+01, -1.044031338554498e+01},
	{"SOL", -1.139380208891201e+01, -4.028229860405680e+00},
	{"SOM", -1.098628211030961e+01, -3.620709881803285e+00},
	{"SON", -9.888385410110528e+00, -2.522813181604203e+00},
	{"SOO", -1.287899166073218e+01, -5.513419432225850e+00},
	{"SOP", -1.365859230705362e+01, -6.293020078547293e+00},
	{"SOQ", -1.858915344305723e+01, -1.122358121455090e+01},
	{"SOR", -1.147519675567537e+01, -4.109624527169042e+00},
	{"SOS", -1.381957340809306e+01, -6.454001179586730e+00},
	{"SOT", -1.254896234862081e+01, -5.183390120114481e+00},
	{"SOU", -1.134404156557704e+01, -3.978469337070713e+00},
	{"SOV", -1.365609712508114e+01, -6.290524896574814e+00},
	{"SOW", -1.277106656004582e+01, -5.405494331539496e+00},
	{"SOX", -1.858851951491281e+01, -1.122294728640648e+01},
	{"SOY", -1.702984300883434e+01, -9.664270780328016e+00},
	{"SOZ", -1.991037805037024e+01, -1.254480582186391e+01},
	{"SPA", -1.154895801958486e+01, -2.662217135462027e+00},
	{"SPB", -2.053863762165815e+01, -1.165189673753532e+01},
	{"SPC", -1.980862514408682e+01, -1.092188425996399e+01},
	{"SPD", -2.212244659789909e+01, -1.323570571377626e+01},
	{"SPE", -1.081557486445835e+01, -1.928833980335522e+00},
	{"SPF", -2.267241209646506e+01, -1.378567121234223e+01},
	{"SPG", -1.804535713472897e+01, -9.158616250606133e+00},
	{"SPH", -1.448306499195471e+01, -5.596324107831884e+00},
	{"SPI", -1.191944331780426e+01, -3.032702433681431e+00},
	{"SPJ", -3.128619762250314e+01, -2.239945673838031e+01},
	{"SPK", -2.371054611364832e+01, -1.482380522952549e+01},
	{"SPL", -1.290492743262907e+01, -4.018186548506241e+00},
	{"SPM", -1.839286597486659e+01, -9.506125090743755e+00},
	{"SPN", -2.368227835735146e+01, -1.479553747322863e+01},
	{"SPO", -1.152342637384421e+01, -2.636685489721384e+00},
	{"SPP", -1.758601117167213e+01, -8.699270287549293e+00},
	{"SPQ", -3.254246828816428e+01, -2.365572740404145e+01},
	{"SPR", -1.148267484195774e+01, -2.595933957834910e+00},
	{"SPS", -1.827685202800452e+01, -9.390111143881684e+00},
	{"SPT", -1.906614887818844e+01, -1.017940799406560e+01},
	{"SPU", -1.363673717683467e+01, -4.749996292711841e+00},
	{"SPV", -2.025836449325201e+01, -1.137162360912918e+01},
	{"SPW", -2.110763689967618e+01, -1.222089601555335e+01},
	{"SPX", -3.604364699357208e+01, -2.715690610944925e+01},
	{"SPY", -1.793296136469501e+01, -9.046220480572176e+00},
	{"SPZ", -3.434876261902318e+01, -2.546202173490035e+01},
	{"SQA", -2.263365273652894e+01, -9.499998182283431e+00},
	{"SQB", -2.937427865803304e+01, -1.624062410378754e+01},
	{"SQC", -2.138548167233134e+01, -8.251827118085837e+00},
	{"SQD", -2.989598251812296e+01, -1.676232796387746e+01},
	{"SQE", -2.271191983257594e+01, -9.578265278330429e+00},
	{"SQF", -2.138813588170896e+01, -8.254481327463457e+00},
	{"SQG", -3.535960543590532e+01, -2.222595088165982e+01},
	{"SQH", -2.368740722685224e+01, -1.055375267260674e+01},
	{"SQI", -2.508572491021900e+01, -1.195207035597349e+01},
	{"SQJ", -3.115965189352474e+01, -1.802599733927924e+01},
	{"SQK", -3.699179063084406e+01, -2.385813607659856e+01},
	{"SQL", -2.270763421144239e+01, -9.573979657196888e+00},
	{"SQM", -2.212056671405326e+01, -8.986912159807757e+00},
	{"SQN", -3.164365822665400e+01, -1.851000367240850e+01},
	{"SQO", -2.369890127525147e+01, -1.056524672100596e+01},
	{"SQP", -2.369893221506980e+01, -1.056527766082429e+01},
	{"SQQ", -3.172369239254240e+01, -1.859003783829689e+01},
	{"SQR", -2.968899289525716e+01, -1.655533834101166e+01},
	{"SQS", -2.676130505054591e+01, -1.362765049630040e+01},
	{"SQT", -2.726018222280446e+01, -1.412652766855895e+01},
	{"SQU", -1.315540261525040e+01, -2.174806100489290e-02},
	{"SQV", -3.255484607289567e+01, -1.942119151865017e+01},
	{"SQW", -2.891309889704195e+01, -1.577944434279644e+01},
	{"SQX", -3.901492258872700e+01, -2.588126803448149e+01},
	{"SQY", -3.320764279017378e+01, -2.007398823592827e+01},
	{"SQZ", -4.015449002547753e+01, -2.702083547123202e+01},
	{"SRA", -1.208122884001721e+01, -1.612034690720561e+00},
	{"SRB", -2.164138362727510e+01, -1.117218947797846e+01},
	{"SRC", -2.489204128936193e+01, -1.442284714006529e+01},
	{"SRD", -2.282545614708639e+01, -1.235626199778974e+01},
	{"SRE", -1.160248892949915e+01, -1.133294780202498e+00},
	{"SRF", -2.339910166076774e+01, -1.292990751147109e+01},
	{"SRG", -2.331594165891143e+01, -1.284674750961478e+01},
	{"SRH", -1.930706037437061e+01, -8.837866225073958e+00},
	{"SRI", -1.401137710370294e+01, -3.542182954406288e+00},
	{"SRJ", -2.882343943778092e+01, -1.835424528848427e+01},
	{"SRK", -2.569086584934181e+01, -1.522167170004516e+01},
	{"SRL", -2.336319027388150e+01, -1.289399612458486e+01},
	{"SRM", -2.456593493560633e+01, -1.409674078630969e+01},
	{"SRN", -2.462146646867239e+01, -1.415227231937574e+01},
	{"SRO", -1.401460400425275e+01, -3.545409854956101e+00},
	{"SRP", -2.051203547295216e+01, -1.004284132365551e+01},
	{"SRQ", -3.020997556802169e+01, -1.974078141872504e+01},
	{"SRR", -2.195927794182121e+01, -1.149008379252456e+01},
	{"SRS", -2.066402177480919e+01, -1.019482762551255e+01},
	{"SRT", -2.151627669119075e+01, -1.104708254189410e+01},
	{"SRU", -1.517035992178221e+01, -4.701165772485566e+00},
	{"SRV", -2.614075337686002e+01, -1.567155922756337e+01},
	{"SRW", -2.161722052189947e+01, -1.114802637260282e+01},
	{"SRX", -3.087510174078114e+01, -2.040590759148449e+01},
	{"SRY", -2.121637054129068e+01, -1.074717639199403e+01},
	{"SRZ", -3.180622427462740e+01, -2.133703012533075e+01},
	{"SSA", -1.076227744128419e+01, -2.963753598422489e+00},
	{"SSB", -1.437124296565525e+01, -6.572719122793543e+00},
	{"SSC", -1.397102386018308e+01, -6.172500017321376e+00},
	{"SSD", -1.531239662597308e+01, -7.513872783111382e+00},
	{"SSE", -1.023207246549959e+01, -2.433548622637883e+00},
	{"SSF", -1.404373625955408e+01, -6.245212416692372e+00},
	{"SSG", -1.659800457515366e+01, -8.799480732291959e+00},
	{"SSH", -1.174296439528690e+01, -3.944440552425194e+00},
	{"SSI", -1.027172084174485e+01, -2.473196998883143e+00},
	{"SSJ", -1.829109054884523e+01, -1.049256670598352e+01},
	{"SSK", -1.635125342585390e+01, -8.552729582992194e+00},
	{"SSL", -1.424632528783846e+01, -6.447801444976758e+00},
	{"SSM", -1.419627793730673e+01, -6.397754094445032e+00},
	{"SSN", -1.519389868398187e+01, -7.395374841120162e+00},
	{"SSO", -1.071889320055414e+01, -2.920369357692433e+00},
	{"SSP", -1.329162552533194e+01, -5.493101682470235e+00},
	{"SSQ", -1.729176892380438e+01, -9.493245080942673e+00},
	{"SSR", -1.549822519529592e+01, -7.699701352434214e+00},
	{"SSS", -1.413598882679883e+01, -6.337464983937129e+00},
	{"SST", -1.121432589227785e+01, -3.415802049416146e+00},
	{"SSU", -1.181344326269830e+01, -4.014919419836594e+00},
	{"SSV", -1.734241057996080e+01, -9.543886737099097e+00},
	{"SSW", -1.325331413106422e+01, -5.454790288202520e+00},
	{"SSX", -3.021767523821763e+01, -2.241915139535593e+01},
	{"SSY", -1.428174899198247e+01, -6.483225149120770e+00},
	{"SSZ", -2.213190237125594e+01, -1.433337852839423e+01},
	{"STA", -9.369006972406140e+00, -2.889443383877233e+00},
	{"STB", -1.251530616163557e+01, -6.035742573106666e+00},
	{"STC", -1.314872549814596e+01, -6.669161909617048e+00},
	{"STD", -1.364580129795932e+01, -7.166237709430414e+00},
	{"STE", -1.007031554589794e+01, -3.590751957369031e+00},
	{"STF", -1.326326061565631e+01, -6.783697027127398e+00},
	{"STG", -1.456370754825470e+01, -8.084143959725797e+00},
	{"STH", -8.642387331747940e+00, -2.162823743219033e+00},
	{"STI", -9.971629395455412e+00, -3.492065806926505e+00},
	{"STJ", -1.573567134057669e+01, -9.256107752047784e+00},
	{"STK", -1.599069557546671e+01, -9.511131986937805e+00},
	{"STL", -1.301981049415312e+01, -6.540246905624215e+00},
	{"STM", -1.305681870745084e+01, -6.577255118921935e+00},
	{"STN", -1.377314754244167e+01, -7.293583953912766e+00},
	{"STO", -9.243717760110732e+00, -2.764154171581824e+00},
	{"STP", -1.314881860296794e+01, -6.669255014439033e+00},
	{"STQ", -1.799071187056943e+01, -1.151114828204052e+01},
	{"STR", -9.572645579425810e+00, -3.093081990896903e+00},
	{"STS", -1.124893724155388e+01, -4.769373653024971e+00},
	{"STT", -1.107464798295495e+01, -4.595084394426044e+00},
	{"STU", -1.226219993057124e+01, -5.782636342042326e+00},
	{"STV", -1.573566695498062e+01, -9.256103366451708e+00},
	{"STW", -1.257187425837111e+01, -6.092310669842196e+00},
	{"STX", -3.371231445328822e+01, -2.723275086475931e+01},
	{"STY", -1.357103250944095e+01, -7.091468920912041e+00},
	{"STZ", -2.025862876141395e+01, -1.377906517288504e+01},
	{"SUA", -1.383665572628238e+01, -5.050825568693423e+00},
	{"SUB", -1.249450852764824e+01, -3.708678370059285e+00},
	{"SUC", -1.160869494436379e+01, -2.822864786774840e+00},
	{"SUD", -1.455252311890967e+01, -5.766692961320713e+00},
	{"SUE", -1.383361803476172e+01, -5.047787877172770e+00},
	{"SUF", -1.325512464754877e+01, -4.469294489959813e+00},
	{"SUG", -1.503247145379179e+01, -6.246641296202835e+00},
	{"SUH", -2.000614216457965e+01, -1.122031200699070e+01},
	{"SUI", -1.465633885353594e+01, -5.870508695946984e+00},
	{"SUJ", -3.116880847224649e+01, -2.238297831465753e+01},
	{"SUK", -2.111504357411158e+01, -1.232921341652263e+01},
	{"SUL", -1.274505762313692e+01, -3.959227465547963e+00},
	{"SUM", -1.303690524613947e+01, -4.251075088550516e+00},
	{"SUN", -1.187524138275712e+01, -3.089411225168168e+00},
	{"SUO", -2.752513559740080e+01, -1.873930543981184e+01},
	{"SUP", -1.167879885872733e+01, -2.892968701138378e+00},
	{"SUQ", -3.264238651336875e+01, -2.385655635577979e+01},
	{"SUR", -1.138504687727477e+01, -2.599216719685815e+00},
	{"SUS", -1.228914543090409e+01, -3.503315273315137e+00},
	{"SUT", -1.658661145327584e+01, -7.800781295686888e+00},
	{"SUU", -2.998031302488533e+01, -2.119448286729637e+01},
	{"SUV", -2.071513051110841e+01, -1.192930035351945e+01},
	{"SUW", -2.136766792256015e+01, -1.258183776497119e+01},
	{"SUX", -2.960334305737507e+01, -2.081751289978611e+01},
	{"SUY", -2.875433804590389e+01, -1.996850788831493e+01},
	{"SUZ", -2.025651119336131e+01, -1.147068103577235e+01},
	{"SVA", -1.476430870191149e+01, -2.391670468959088e+00},
	{"SVB", -3.245415437596100e+01, -2.008151614300859e+01},
	{"SVC", -3.264351070330120e+01, -2.027087247034880e+01},
	{"SVD", -3.189858283704524e+01, -1.952594460409283e+01},
	{"SVE", -1.381612204158514e+01, -1.443483808632733e+00},
	{"SVF", -3.210293008233277e+01, -1.973029184938036e+01},
	{"SVG", -3.341132246965425e+01, -2.103868423670185e+01},
	{"SVH", -2.371060866365986e+01, -1.133797043070746e+01},
	{"SVI", -1.430892202204197e+01, -1.936283789089558e+00},
	{"SVJ", -3.328166819727357e+01, -2.090902996432116e+01},
	{"SVK", -3.502930471043700e+01, -2.265666647748460e+01},
	{"SVL", -3.248602386475869e+01, -2.011338563180628e+01},
	{"SVM", -3.149648664638686e+01, -1.912384841343444e+01},
	{"SVN", -3.058690766750905e+01, -1.821426943455664e+01},
	{"SVO", -1.488065802019082e+01, -2.508019787238414e+00},
	{"SVP", -3.155348429040180e+01, -1.918084605744939e+01},
	{"SVQ", -3.916597556640867e+01, -2.679333733345627e+01},
	{"SVR", -2.952516919855945e+01, -1.715253096560704e+01},
	{"SVS", -3.055513297966866e+01, -1.818249474671625e+01},
	{"SVT", -2.270906326571402e+01, -1.033642503276162e+01},
	{"SVU", -2.071578638657934e+01, -8.343148153626927e+00},
	{"SVV", -3.397373746843564e+01, -2.160109923548323e+01},
	{"SVW", -2.371104318744556e+01, -1.133840495449316e+01},
	{"SVX", -3.579179638350533e+01, -2.341915815055293e+01},
	{"SVY", -2.761463881947590e+01, -1.524200058652349e+01},
	{"SVZ", -3.920167526606305e+01, -2.682903703311065e+01},
	{"SWA", -1.169905687201878e+01, -2.897685375967434e+00},
	{"SWB", -2.768446337677537e+01, -1.888309188072403e+01},
	{"SWC", -2.774342087301290e+01, -1.894204937696155e+01},
	{"SWD", -2.725691087313662e+01, -1.845553937708528e+01},
	{"SWE", -1.058443705599183e+01, -1.783065559940491e+00},
	{"SWF", -2.266860044583110e+01, -1.386722894977976e+01},
	{"SWG", -2.866314085582310e+01, -1.986176935977176e+01},
	{"SWH", -1.064597685554155e+01, -1.844605359490202e+00},
	{"SWI", -1.121820870436401e+01, -2.416837208312672e+00},
	{"SWJ", -2.370061361272549e+01, -1.489924211667415e+01},
	{"SWK", -3.017096546714173e+01, -2.136959397109039e+01},
	{"SWL", -2.660698127610291e+01, -1.780560978005156e+01},
	{"SWM", -2.730699308435541e+01, -1.850562158830407e+01},
	{"SWN", -2.418210347360716e+01, -1.538073197755581e+01},
	{"SWO", -1.224579531855287e+01, -3.444423822501522e+00},
	{"SWP", -2.839567717924031e+01, -1.959430568318896e+01},
	{"SWQ", -3.264929832595143e+01, -2.384792682990009e+01},
	{"SWR", -1.474950397145125e+01, -5.948132475399908e+00},
	{"SWS", -2.251540179536270e+01, -1.371403029931136e+01},
	{"SWT", -2.531229808752419e+01, -1.651092659147285e+01},
	{"SWU", -1.843232441842042e+01, -9.630952922369083e+00},
	{"SWV", -3.049947168859661e+01, -2.169810019254527e+01},
	{"SWW", -2.653101206156839e+01, -1.772964056551704e+01},
	{"SWX", -3.984310459207684e+01, -3.104173309602550e+01},
	{"SWY", -2.748106745621605e+01, -1.867969596016470e+01},
	{"SWZ", -3.331241199159967e+01, -2.451104049554833e+01},
	{"SXA", -2.266593346332361e+01, -7.467642522176168e+00},
	{"SXB", -2.817948866740097e+01, -1.298119772625354e+01},
	{"SXC", -2.314048832495113e+01, -7.942197383803689e+00},
	{"SXD", -2.757287682032092e+01, -1.237458587917349e+01},
	{"SXE", -2.244810558444101e+01, -7.249814643293573e+00},
	{"SXF", -2.771498628637643e+01, -1.251669534522899e+01},
	{"SXG", -2.901405082649218e+01, -1.381575988534475e+01},
	{"SXH", -2.537222465235550e+01, -1.017393371120806e+01},
	{"SXI", -1.714557986216872e+01, -1.947288921021277e+00},
	{"SXJ", -3.022701995251610e+01, -1.502872901136866e+01},
	{"SXK", -3.111360767604019e+01, -1.591531673489275e+01},
	{"SXL", -2.363136597812304e+01, -8.433075036975598e+00},
	{"SXM", -2.695488450536961e+01, -1.175659356422217e+01},
	{"SXN", -2.946454393433713e+01, -1.426625299318969e+01},
	{"SXO", -2.257744324353248e+01, -7.379152302385040e+00},
	{"SXP", -2.204646445753848e+01, -6.848173516391044e+00},
	{"SXQ", -2.912731560222925e+01, -1.392902466108181e+01},
	{"SXR", -2.267813669877227e+01, -7.479845757624831e+00},
	{"SXS", -2.703738845419359e+01, -1.183909751304615e+01},
	{"SXT", -2.238742018815783e+01, -7.189129247010389e+00},
	{"SXU", -2.625038578770240e+01, -1.105209484655496e+01},
	{"SXV", -1.580761578189592e+01, -6.093248407484804e-01},
	{"SXW", -2.706042809075439e+01, -1.186213714960695e+01},
	{"SXX", -2.000698114937611e+01, -4.808690208228668e+00},
	{"SXY", -2.684457408576580e+01, -1.164628314461836e+01},
	{"SXZ", -4.066433535512885e+01, -2.546604441398140e+01},
	{"SYA", -1.573464149290166e+01, -4.453720993919171e+00},
	{"SYB", -1.802197364694251e+01, -6.741053147960015e+00},
	{"SYC", -1.736490402798077e+01, -6.083983528998282e+00},
	{"SYD", -1.909665841113377e+01, -7.815737912151275e+00},
	{"SYE", -1.394268246847751e+01, -2.661761969495013e+00},
	{"SYF", -1.840518040641245e+01, -7.124259907429964e+00},
	{"SYG", -1.889325283998261e+01, -7.612332341000119e+00},
	{"SYH", -1.833117786016897e+01, -7.050257361186482e+00},
	{"SYI", -1.669203555149880e+01, -5.411115052516309e+00},
	{"SYJ", -2.168844122203580e+01, -1.040752072305331e+01},
	{"SYK", -2.264966817205119e+01, -1.136874767306869e+01},
	{"SYL", -1.569365144163133e+01, -4.412730942648835e+00},
	{"SYM", -1.506493933332407e+01, -3.784018834341582e+00},
	{"SYN", -1.634937897427513e+01, -5.068458475292638e+00},
	{"SYO", -1.324169119616890e+01, -1.960770697186410e+00},
	{"SYP", -1.763673878516711e+01, -6.355818286184621e+00},
	{"SYQ", -2.918511148211954e+01, -1.790419098313705e+01},
	{"SYR", -1.476890124698988e+01, -3.487980748007385e+00},
	{"SYS", -1.395038367963577e+01, -2.669463180653281e+00},
	{"SYT", -1.617615994472289e+01, -4.895239445740395e+00},
	{"SYU", -1.953065808474969e+01, -8.249737585767200e+00},
	{"SYV", -2.136680198402034e+01, -1.008588148503785e+01},
	{"SYW", -1.723946107943154e+01, -5.958540580449051e+00},
	{"SYX", -3.126804264759817e+01, -1.998712214861568e+01},
	{"SYY", -1.900907035717567e+01, -7.728149858193178e+00},
	{"SYZ", -3.060210479389509e+01, -1.932118429491259e+01},
	{"SZA", -2.058406396236428e+01, -3.922798549106712e+00},
	{"SZB", -2.820316364618896e+01, -1.154189823293139e+01},
	{"SZC", -2.908807846443053e+01, -1.242681305117296e+01},
	{"SZD", -2.944724430583336e+01, -1.278597889257579e+01},
	{"SZE", -1.720591548930056e+01, -5.446500760429887e-01},
	{"SZF", -2.903437587220796e+01, -1.237311045895039e+01},
	{"SZG", -2.955734504533518e+01, -1.289607963207760e+01},
	{"SZH", -2.817408217548506e+01, -1.151281676222749e+01},
	{"SZI", -1.906895669036376e+01, -2.407691277106188e+00},
	{"SZJ", -3.208106974749234e+01, -1.541980433423477e+01},
	{"SZK", -3.071656980787869e+01, -1.405530439462112e+01},
	{"SZL", -2.640680494452515e+01, -9.745539531267578e+00},
	{"SZM", -2.861506087421517e+01, -1.195379546095760e+01},
	{"SZN", -2.971355885269520e+01, -1.305229343943764e+01},
	{"SZO", -2.155764041992101e+01, -4.896375006663437e+00},
	{"SZP", -2.753345322306501e+01, -1.087218780980744e+01},
	{"SZQ", -3.599728363681569e+01, -1.933601822355811e+01},
	{"SZR", -2.264096198301964e+01, -5.979696569762073e+00},
	{"SZS", -2.836503261612327e+01, -1.170376720286570e+01},
	{"SZT", -2.686496489724662e+01, -1.020369948398904e+01},
	{"SZU", -2.626680674398712e+01, -9.605541330729544e+00},
	{"SZV", -2.916476444095998e+01, -1.250349902770241e+01},
	{"SZW", -2.782825161609585e+01, -1.116698620283828e+01},
	{"SZX", -3.880542019826053e+01, -2.214415478500296e+01},
	{"SZY", -2.724012080169819e+01, -1.057885538844062e+01},
	{"SZZ", -2.483563071673949e+01, -8.174365303481915e+00},
	{"TAA", -1.650836557559279e+01, -9.064757815275248e+00},
	{"TAB", -1.168241339785577e+01, -4.238805637538235e+00},
	{"TAC", -1.215701652206567e+01, -4.713408761748134e+00},
	{"TAD", -1.407472158973166e+01, -6.631113829414123e+00},
	{"TAE", -1.727395935626073e+01, -9.830351595943188e+00},
	{"TAF", -1.340103154289137e+01, -5.957423782573828e+00},
	{"TAG", -1.252861675829169e+01, -5.085008997974153e+00},
	{"TAH", -1.525452003536385e+01, -7.810912275046313e+00},
	{"TAI", -1.094255533151979e+01, -3.498947571202250e+00},
	{"TAJ", -1.891000031177193e+01, -1.146639255145440e+01},
	{"TAK", -1.143445558459602e+01, -3.990847824278480e+00},
	{"TAL", -1.074128059925229e+01, -3.297672838934752e+00},
	{"TAM", -1.326049008518289e+01, -5.816882324865349e+00},
	{"TAN", -9.348190929317763e+00, -1.904583169000225e+00},
	{"TAO", -1.760950402296077e+01, -1.016589626264323e+01},
	{"TAP", -1.364664155411748e+01, -6.203033793799940e+00},
	{"TAQ", -1.839578809060598e+01, -1.095218033028845e+01},
	{"TAR", -1.119337300234023e+01, -3.749765242022689e+00},
	{"TAS", -1.173961526724406e+01, -4.296007506926518e+00},
	{"TAT", -1.035760268910554e+01, -2.913994928788002e+00},
	{"TAU", -1.471510595087725e+01, -7.271498190559711e+00},
	{"TAV", -1.486499624729837e+01, -7.421388486980835e+00},
	{"TAW", -1.407079249063556e+01, -6.627184730318022e+00},
	{"TAX", -1.450440465732232e+01, -7.060796897004779e+00},
	{"TAY", -1.518473307399695e+01, -7.741125313679416e+00},
	{"TAZ", -2.001458317886614e+01, -1.257097541854860e+01},
	{"TBA", -1.411289084693949e+01, -4.072726468905454e+00},
	{"TBB", -2.356213331283680e+01, -1.352196893480276e+01},
	{"TBC", -1.876140227539940e+01, -8.721237897365375e+00},
	{"TBD", -2.269843197853587e+01, -1.265826760050184e+01},
	{"TBE", -1.105451323055360e+01, -1.014348852519565e+00},
	{"TBF", -2.370520509801369e+01, -1.366504071997965e+01},
	{"TBG", -3.203740713584065e+01, -2.199724275780661e+01},
	{"TBH", -2.368862232409052e+01, -1.364845794605649e+01},
	{"TBI", -1.602728106777032e+01, -5.987116689736284e+00},
	{"TBJ", -2.683788935101161e+01, -1.679772497297757e+01},
	{"TBK", -3.229322208650169e+01, -2.225305770846766e+01},
	{"TBL", -1.534498755654387e+01, -5.304823178509840e+00},
	{"TBM", -2.861176254774689e+01, -1.857159816971286e+01},
	{"TBN", -2.938733746632871e+01, -1.934717308829467e+01},
	{"TBO", -1.406639101082361e+01, -4.026226632789577e+00},
	{"TBP", -2.171454417365018e+01, -1.167437979561615e+01},
	{"TBQ", -3.616061315794877e+01, -2.612044877991473e+01},
	{"TBR", -1.375703435318799e+01, -3.716869975153954e+00},
	{"TBS", -2.541768972139150e+01, -1.537752534335747e+01},
	{"TBT", -2.068447269002585e+01, -1.064430831199182e+01},
	{"TBU", -1.281044352310352e+01, -2.770279145069483e+00},
	{"TBV", -3.007511978739952e+01, -2.003495540936549e+01},
	{"TBW", -2.139163589566197e+01, -1.135147151762794e+01},
	{"TBX", -3.944782099718936e+01, -2.940765661915534e+01},
	{"TBY", -1.314374346280864e+01, -3.103579084774605e+00},
	{"TBZ", -3.395592487295677e+01, -2.391576049492274e+01},
	{"TCA", -1.238222029749568e+01, -2.269774920475198e+00},
	{"TCB", -1.954724180426597e+01, -9.434796427245494e+00},
	{"TCC", -1.975797035751685e+01, -9.645524980496369e+00},
	{"TCD", -2.025382199914324e+01, -1.014137662212277e+01},
	{"TCE", -1.541843788432331e+01, -5.305992507302829e+00},
	{"TCF", -2.212278534792855e+01, -1.201033997090807e+01},
	{"TCG", -2.271023909635333e+01, -1.259779371933285e+01},
	{"TCH", -1.185192035364804e+01, -1.739474976627561e+00},
	{"TCI", -1.549275667721293e+01, -5.380311300192455e+00},
	{"TCJ", -3.207275650910143e+01, -2.196031113208095e+01},
	{"TCK", -2.378688367377788e+01, -1.367443829675740e+01},
	{"TCL", -1.455670109808501e+01, -4.444255721064527e+00},
	{"TCM", -1.971662540349843e+01, -9.604180026477948e+00},
	{"TCN", -2.039496623467384e+01, -1.028252085765337e+01},
	{"TCO", -1.171958375531435e+01, -1.607138378293874e+00},
	{"TCP", -2.012902586511973e+01, -1.001658048809925e+01},
	{"TCQ", -2.845524816718351e+01, -1.834280279016303e+01},
	{"TCR", -1.494421500301459e+01, -4.831769625994106e+00},
	{"TCS", -1.990047783858755e+01, -9.788032461567068e+00},
	{"TCT", -1.822032112256154e+01, -8.107875745541065e+00},
	{"TCU", -1.591886033486894e+01, -5.806414957848462e+00},
	{"TCV", -3.170480502891421e+01, -2.159235965189373e+01},
	{"TCW", -1.919050576077697e+01, -9.078060383756487e+00},
	{"TCX", -2.271770902787460e+01, -1.260526365085412e+01},
	{"TCY", -1.858131045959803e+01, -8.468865082577544e+00},
	{"TCZ", -3.165974856228007e+01, -2.154730318525959e+01},
	{"TDA", -1.348742066029877e+01, -2.725354840633328e+00},
	{"TDB", -2.401650882562314e+01, -1.325444300595770e+01},
	{"TDC", -2.159189831117620e+01, -1.082983249151076e+01},
	{"TDD", -2.495318683906878e+01, -1.419112101940334e+01},
	{"TDE", -1.281966778630695e+01, -2.057601966641510e+00},
	{"TDF", -2.466963637088842e+01, -1.390757055122297e+01},
	{"TDG", -2.539648658181122e+01, -1.463442076214578e+01},
	{"TDH", -2.402280795774486e+01, -1.326074213807941e+01},
	{"TDI", -1.293386888595598e+01, -2.171803066290535e+00},
	{"TDJ", -2.702460276477635e+01, -1.626253694511091e+01},
	{"TDK", -2.820144858515215e+01, -1.743938276548672e+01},
	{"TDL", -2.522507506904997e+01, -1.446300924938453e+01},
	{"TDM", -2.315362015164907e+01, -1.239155433198363e+01},
	{"TDN", -2.323545818639467e+01, -1.247339236672923e+01},
	{"TDO", -1.265773251437079e+01, -1.895666694705343e+00},
	{"TDP", -1.866116992490750e+01, -7.899104105242063e+00},
	{"TDQ", -2.964534011566568e+01, -1.888327429600023e+01},
	{"TDR", -1.492557742553984e+01, -4.163511605874398e+00},
	{"TDS", -2.066147195716459e+01, -9.899406137499149e+00},
	{"TDT", -1.996150434461924e+01, -9.199438524953797e+00},
	{"TDU", -1.588838979451106e+01, -5.126323974845621e+00},
	{"TDV", -2.673060990941265e+01, -1.596854408974721e+01},
	{"TDW", -1.625310508848962e+01, -5.491039268824176e+00},
	{"TDX", -3.442577714395425e+01, -2.366371132428881e+01},
	{"TDY", -1.917674329948190e+01, -8.414677479816461e+00},
	{"TDZ", -3.062697221725837e+01, -1.986490639759294e+01},
	{"TEA", -1.134155213159962e+01, -4.431730968393624e+00},
	{"TEB", -1.446034328151601e+01, -7.550522118310017e+00},
	{"TEC", -1.282388807823327e+01, -5.914066915027275e+00},
	{"TED", -9.284478647784166e+00, -2.374657484578168e+00},
	{"TEE", -1.243747874231552e+01, -5.527657579109521e+00},
	{"TEF", -1.367343198261787e+01, -6.763610819411875e+00},
	{"TEG", -1.475475316036961e+01, -7.844931997163612e+00},
	{"TEH", -1.412162279520807e+01, -7.211801632002076e+00},
	{"TEI", -1.316143951365605e+01, -6.251618350450053e+00},
	{"TEJ", -1.721021777576258e+01, -1.030039661255659e+01},
	{"TEK", -1.750681759453989e+01, -1.059699643133389e+01},
	{"TEL", -1.164526653486975e+01, -4.735445371663756e+00},
	{"TEM", -1.161550407016308e+01, -4.705682906957082e+00},
	{"TEN", -1.004797816739176e+01, -3.138157004185762e+00},
	{"TEO", -1.230581609695261e+01, -5.395994933746618e+00},
	{"TEP", -1.317895182402554e+01, -6.269130660819538e+00},
	{"TEQ", -1.707391891798989e+01, -1.016409775478390e+01},
	{"TER", -8.667141749718700e+00, -1.757320586512704e+00},
	{"TES", -1.047269005518647e+01, -3.562868891980469e+00},
	{"TET", -1.204294995525166e+01, -5.133128792045660e+00},
	{"TEU", -1.519055736163393e+01, -8.280736198427928e+00},
	{"TEV", -1.289186977949352e+01, -5.982048616287525e+00},
	{"TEW", -1.357696273095006e+01, -6.667141567744069e+00},
	{"TEX", -1.294054179463574e+01, -6.030720631429745e+00},
	{"TEY", -1.585806380033027e+01, -8.948242637124272e+00},
	{"TEZ", -1.891066191985361e+01, -1.200084075664762e+01},
	{"TFA", -1.400420194801792e+01, -3.733719097945940e+00},
	{"TFB", -2.656465517267405e+01, -1.629417232260207e+01},
	{"TFC", -2.597820076909288e+01, -1.570771791902089e+01},
	{"TFD", -2.686050021278829e+01, -1.659001736271631e+01},
	{"TFE", -1.427580777354314e+01, -4.005324923471153e+00},
	{"TFF", -2.149450101672931e+01, -1.122401816665733e+01},
	{"TFG", -2.651506973262168e+01, -1.624458688254969e+01},
	{"TFH", -2.531534104244383e+01, -1.504485819237185e+01},
	{"TFI", -1.340794961051080e+01, -3.137466760438818e+00},
	{"TFJ", -2.730336430656376e+01, -1.703288145649177e+01},
	{"TFK", -2.919954507151328e+01, -1.892906222144130e+01},
	{"TFL", -1.510264020956657e+01, -4.832157359494590e+00},
	{"TFM", -2.564647181601381e+01, -1.537598896594183e+01},
	{"TFN", -2.726828619115469e+01, -1.699780334108270e+01},
	{"TFO", -1.141013754955046e+01, -1.139654699478472e+00},
	{"TFP", -2.617876413810265e+01, -1.590828128803066e+01},
	{"TFQ", -3.144639064178586e+01, -2.117590779171388e+01},
	{"TFR", -1.271600652189831e+01, -2.445523671826331e+00},
	{"TFS", -2.335179704435324e+01, -1.308131419428126e+01},
	{"TFT", -2.197544013762600e+01, -1.170495728755402e+01},
	{"TFU", -1.400045324314920e+01, -3.729970393077215e+00},
	{"TFV", -2.848037293509031e+01, -1.820989008501833e+01},
	{"TFW", -2.623268785968898e+01, -1.596220500961699e+01},
	{"TFX", -3.375776214611937e+01, -2.348727929604738e+01},
	{"TFY", -2.687522020389534e+01, -1.660473735382335e+01},
	{"TFZ", -2.988635560564590e+01, -1.961587275557392e+01},
	{"TGA", -1.528337171149498e+01, -4.071253958305935e+00},
	{"TGB", -2.669098168323611e+01, -1.547886393004707e+01},
	{"TGC", -2.694200824324553e+01, -1.572989049005649e+01},
	{"TGD", -2.207869506448626e+01, -1.086657731129722e+01},
	{"TGE", -1.447670626691528e+01, -3.264588513726238e+00},
	{"TGF", -2.649669207194730e+01, -1.528457431875825e+01},
	{"TGG", -2.663818221198549e+01, -1.542606445879645e+01},
	{"TGH", -2.155782219095164e+01, -1.034570443776260e+01},
	{"TGI", -1.446427532320564e+01, -3.252157570016595e+00},
	{"TGJ", -3.016603281992900e+01, -1.895391506673997e+01},
	{"TGK", -3.040434675322625e+01, -1.919222900003721e+01},
	{"TGL", -1.645778439386959e+01, -5.245666640680553e+00},
	{"TGM", -2.644847708754947e+01, -1.523635933436042e+01},
	{"TGN", -2.556130884493280e+01, -1.434919109174376e+01},
	{"TGO", -1.336552777081314e+01, -2.153410017624100e+00},
	{"TGP", -2.693426924445126e+01, -1.572215149126222e+01},
	{"TGQ", -3.169742584784431e+01, -2.048530809465527e+01},
	{"TGR", -1.433756711899260e+01, -3.125449365803558e+00},
	{"TGS", -2.477424601440141e+01, -1.356212826121236e+01},
	{"TGT", -2.388695822988130e+01, -1.267484047669226e+01},
	{"TGU", -1.267285194948670e+01, -1.460734196297658e+00},
	{"TGV", -2.953786762976480e+01, -1.832574987657577e+01},
	{"TGW", -2.258831973161518e+01, -1.137620197842614e+01},
	{"TGX", -3.491624631429168e+01, -2.370412856110263e+01},
	{"TGY", -2.689085646910424e+01, -1.567873871591520e+01},
	{"TGZ", -2.271807002343956e+01, -1.150595227025052e+01},
	{"THA", -8.004249332801125e+00, -3.211181371705799e+00},
	{"THB", -1.306856961013171e+01, -8.275501649036380e+00},
	{"THC", -1.291864081723633e+01, -8.125572856141003e+00},
	{"THD", -1.319322296450686e+01, -8.400155003411529e+00},
	{"THE", -5.376923693393554e+00, -5.838557322982270e-01},
	{"THF", -1.274146315160599e+01, -7.948395190510660e+00},
	{"THG", -1.369915372498392e+01, -8.906085763888596e+00},
	{"THH", -1.180809192943925e+01, -7.015023968343923e+00},
	{"THI", -8.700039043343498e+00, -3.906971082248169e+00},
	{"THJ", -1.552892436340443e+01, -1.073585640230910e+01},
	{"THK", -1.666341102547898e+01, -1.187034306438365e+01},
	{"THL", -1.398059998531269e+01, -9.187532024217360e+00},
	{"THM", -1.271098640427928e+01, -7.917918443183951e+00},
	{"THN", -1.369218567103841e+01, -8.899117709943086e+00},
	{"THO", -9.236323643314380e+00, -4.443255682219053e+00},
	{"THP", -1.333935108423458e+01, -8.546283123139251e+00},
	{"THQ", -1.716416545275076e+01, -1.237109749165543e+01},
	{"THR", -1.059319033242343e+01, -5.800122371328102e+00},
	{"THS", -1.176672704129367e+01, -6.973659080198346e+00},
	{"THT", -1.020518616007923e+01, -5.412118198983905e+00},
	{"THU", -1.176450102634188e+01, -6.971433065246551e+00},
	{"THV", -1.617183067737334e+01, -1.137876271627801e+01},
	{"THW", -1.235786280942470e+01, -7.564794848329375e+00},
	{"THX", -2.091140101916378e+01, -1.611833305806845e+01},
	{"THY", -1.096930848293374e+01, -6.176240521838418e+00},
	{"THZ", -1.876452234672405e+01, -1.397145438562872e+01},
	{"TIA", -1.246394864823244e+01, -5.636562911652330e+00},
	{"TIB", -1.459662665555840e+01, -7.769240918978284e+00},
	{"TIC", -1.091841833271373e+01, -4.091032596133620e+00},
	{"TID", -1.441971643235575e+01, -7.592330695775640e+00},
	{"TIE", -1.157321473783000e+01, -4.745829001249882e+00},
	{"TIF", -1.216204729896161e+01, -5.334661562381489e+00},
	{"TIG", -1.441097121208924e+01, -7.583585475509121e+00},
	{"TIH", -1.458157006400605e+01, -7.754184327425936e+00},
	{"TII", -1.769536258867449e+01, -1.086797685209437e+01},
	{"TIJ", -2.001744928092469e+01, -1.319006354434458e+01},
	{"TIK", -1.684674773061339e+01, -1.001936199403328e+01},
	{"TIL", -1.125161450344889e+01, -4.424228766868772e+00},
	{"TIM", -1.059178111141634e+01, -3.764395374836224e+00},
	{"TIN", -9.312853386525163e+00, -2.485467649945048e+00},
	{"TIO", -8.471793880511298e+00, -1.644408143931184e+00},
	{"TIP", -1.481423631000967e+01, -7.986850573429560e+00},
	{"TIQ", -1.687305962103308e+01, -1.004567388445296e+01},
	{"TIR", -1.322586954078054e+01, -6.398483804200428e+00},
	{"TIS", -1.039236292883986e+01, -3.564977192259740e+00},
	{"TIT", -1.073258558174291e+01, -3.905199845162798e+00},
	{"TIU", -1.535637151393038e+01, -8.528985777350266e+00},
	{"TIV", -1.156410522894146e+01, -4.736719492361346e+00},
	{"TIW", -1.412797180560736e+01, -7.300586069027248e+00},
	{"TIX", -2.780662325742755e+01, -2.097923752084743e+01},
	{"TIY", -2.213299448150604e+01, -1.530560874492592e+01},
	{"TIZ", -1.453616198372155e+01, -7.708776247141437e+00},
	{"TJA", -1.646678436061496e+01, -3.099159317550962e+00},
	{"TJB", -2.212219462187048e+01, -8.754569578806484e+00},
	{"TJC", -2.982512993298104e+01, -1.645750488991704e+01},
	{"TJD", -3.172399088393866e+01, -1.835636584087466e+01},
	{"TJE", -1.497455816276162e+01, -1.606933119697624e+00},
	{"TJF", -2.370932337625466e+01, -1.034169833319065e+01},
	{"TJG", -3.043221767648222e+01, -1.706459263341822e+01},
	{"TJH", -2.961836068317432e+01, -1.625073564011032e+01},
	{"TJI", -1.793162590521919e+01, -4.564000862155188e+00},
	{"TJJ", -2.962415339947388e+01, -1.625652835640987e+01},
	{"TJK", -3.231272490734517e+01, -1.894509986428117e+01},
	{"TJL", -3.082155777658178e+01, -1.745393273351777e+01},
	{"TJM", -3.117748315030923e+01, -1.780985810724523e+01},
	{"TJN", -3.403775348857330e+01, -2.067012844550930e+01},
	{"TJO", -1.572202902222549e+01, -2.354403979161491e+00},
	{"TJP", -3.058933541312826e+01, -1.722171037006426e+01},
	{"TJQ", -3.357558715405414e+01, -2.020796211099014e+01},
	{"TJR", -2.270901145051259e+01, -9.341386407448585e+00},
	{"TJS", -3.023231028873010e+01, -1.686468524566610e+01},
	{"TJT", -3.033268802962224e+01, -1.696506298655824e+01},
	{"TJU", -1.504588987647358e+01, -1.678264833409578e+00},
	{"TJV", -3.719464037365499e+01, -2.382701533059099e+01},
	{"TJW", -2.956889641722597e+01, -1.620127137416197e+01},
	{"TJX", -3.987394578072382e+01, -2.650632073765982e+01},
	{"TJY", -3.634381653156844e+01, -2.297619148850443e+01},
	{"TJZ", -3.433746463504910e+01, -2.096983959198510e+01},
	{"TKA", -1.852764409956231e+01, -5.329760284138743e+00},
	{"TKB", -2.689150177589229e+01, -1.369361796046873e+01},
	{"TKC", -2.732337515821608e+01, -1.412549134279252e+01},
	{"TKD", -2.795658337060158e+01, -1.475869955517802e+01},
	{"TKE", -1.589273892826260e+01, -2.694855112839042e+00},
	{"TKF", -2.678791011401443e+01, -1.359002629859087e+01},
	{"TKG", -2.906051089133158e+01, -1.586262707590802e+01},
	{"TKH", -2.261523862303207e+01, -9.417354807608509e+00},
	{"TKI", -1.508010667756248e+01, -1.882222862138917e+00},
	{"TKJ", -3.063868537273202e+01, -1.744080155730846e+01},
	{"TKK", -2.997041546518431e+01, -1.677253164976075e+01},
	{"TKL", -2.634904402531174e+01, -1.315116020988818e+01},
	{"TKM", -2.732341266725646e+01, -1.412552885183289e+01},
	{"TKN", -1.410152146037102e+01, -9.036376449474547e-01},
	{"TKO", -2.244054537116742e+01, -9.242661555743862e+00},
	{"TKP", -2.767435231272263e+01, -1.447646849729907e+01},
	{"TKQ", -3.331782516730510e+01, -2.011994135188153e+01},
	{"TKR", -2.268546068299078e+01, -9.487576867567219e+00},
	{"TKS", -2.422826289043987e+01, -1.103037907501631e+01},
	{"TKT", -2.499315039761905e+01, -1.179526658219549e+01},
	{"TKU", -2.012076976482684e+01, -6.922885949403283e+00},
	{"TKV", -3.047884043857671e+01, -1.728095662315316e+01},
	{"TKW", -2.616465866156895e+01, -1.296677484614539e+01},
	{"TKX", -3.428987203319836e+01, -2.109198821777479e+01},
	{"TKY", -2.356187338713153e+01, -1.036398957170797e+01},
	{"TKZ", -3.239173491906809e+01, -1.919385110364453e+01},
	{"TLA", -1.301252532495188e+01, -3.397403715164889e+00},
	{"TLB", -2.163264350709970e+01, -1.201752189731272e+01},
	{"TLC", -1.953603774580792e+01, -9.920916136020926e+00},
	{"TLD", -2.365373236115486e+01, -1.403861075136787e+01},
	{"TLE", -1.069894469982981e+01, -1.083823090042819e+00},
	{"TLF", -2.549235852730991e+01, -1.587723691752291e+01},
	{"TLG", -2.265460294224250e+01, -1.303948133245551e+01},
	{"TLH", -2.660888815812116e+01, -1.699376654833417e+01},
	{"TLI", -1.281504439962961e+01, -3.199922789842620e+00},
	{"TLJ", -2.990408122928904e+01, -2.028895961950205e+01},
	{"TLK", -2.718134945227688e+01, -1.756622784248989e+01},
	{"TLL", -1.750086100926724e+01, -7.885739399480246e+00},
	{"TLM", -2.134800960363910e+01, -1.173288799385210e+01},
	{"TLN", -2.696552444675936e+01, -1.735040283697237e+01},
	{"TLO", -1.354076110467653e+01, -3.925639494889536e+00},
	{"TLP", -2.624170529794055e+01, -1.662658368815356e+01},
	{"TLQ", -3.099775680379646e+01, -2.138263519400947e+01},
	{"TLR", -2.677182527210923e+01, -1.715670366232224e+01},
	{"TLS", -2.453872833075823e+01, -1.492360672097124e+01},
	{"TLT", -2.401944709749860e+01, -1.440432548771161e+01},
	{"TLU", -1.752165065878563e+01, -7.906529048998641e+00},
	{"TLV", -2.352804815446440e+01, -1.391292654467741e+01},
	{"TLW", -2.623853369967362e+01, -1.662341208988663e+01},
	{"TLX", -3.429972498792396e+01, -2.468460337813697e+01},
	{"TLY", -1.162471893184398e+01, -2.009597322056986e+00},
	{"TLZ", -3.296121546103973e+01, -2.334609385125273e+01},
	{"TMA", -1.198359179627868e+01, -1.859529723809481e+00},
	{"TMB", -2.295829441971305e+01, -1.283423234724385e+01},
	{"TMC", -1.696245568069331e+01, -6.838393608224108e+00},
	{"TMD", -1.854490055886010e+01, -8.420838486390895e+00},
	{"TME", -1.190696874659363e+01, -1.782906674124434e+00},
	{"TMF", -2.637417014170245e+01, -1.625010806923325e+01},
	{"TMG", -2.802694545161260e+01, -1.790288337914340e+01},
	{"TMH", -2.599579122771687e+01, -1.587172915524767e+01},
	{"TMI", -1.372584639014651e+01, -3.601784317677305e+00},
	{"TMJ", -2.945157578520194e+01, -1.932751371273274e+01},
	{"TMK", -2.369709693749028e+01, -1.357303486502108e+01},
	{"TML", -1.616361521668017e+01, -6.039553144210972e+00},
	{"TMM", -1.789443985514296e+01, -7.770377782673758e+00},
	{"TMN", -1.839065550907810e+01, -8.266593436608904e+00},
	{"TMO", -1.303209771411599e+01, -2.908035641646785e+00},
	{"TMP", -1.900650252226058e+01, -8.882440449791380e+00},
	{"TMQ", -3.237196591254126e+01, -2.224790384007206e+01},
	{"TMR", -1.669499110428518e+01, -6.570929031815978e+00},
	{"TMS", -1.921135181736138e+01, -9.087289744892182e+00},
	{"TMT", -1.718106293243396e+01, -7.057000859964761e+00},
	{"TMU", -1.437980387864746e+01, -4.255741806178265e+00},
	{"TMV", -2.368472456132641e+01, -1.356066248885721e+01},
	{"TMW", -1.579239335041076e+01, -5.668331277941563e+00},
	{"TMX", -3.392854652027563e+01, -2.380448444780643e+01},
	{"TMY", -1.361052554311212e+01, -3.486463470642918e+00},
	{"TMZ", -3.264072948852160e+01, -2.251666741605240e+01},
	{"TNA", -1.502149896801936e+01, -4.217564026005094e+00},
	{"TNB", -2.602459743441152e+01, -1.522066249239725e+01},
	{"TNC", -2.409793251928953e+01, -1.329399757727526e+01},
	{"TND", -2.065032898244268e+01, -9.846394040428409e+00},
	{"TNE", -1.276854368549764e+01, -1.964608743483375e+00},
	{"TNF", -2.340859409557688e+01, -1.260465915356262e+01},
	{"TNG", -2.284709614718820e+01, -1.204316120517394e+01},
	{"TNH", -2.334883150368046e+01, -1.254489656166619e+01},
	{"TNI", -1.451451258794479e+01, -3.710577645930527e+00},
	{"TNJ", -2.818590951691889e+01, -1.738197457490463e+01},
	{"TNK", -2.684315420450333e+01, -1.603921926248906e+01},
	{"TNL", -2.205274561714196e+01, -1.124881067512769e+01},
	{"TNM", -2.259487163297846e+01, -1.179093669096420e+01},
	{"TNN", -2.615026836386324e+01, -1.534633342184897e+01},
	{"TNO", -1.160647071032263e+01, -8.025357683083559e-01},
	{"TNP", -2.668850252904576e+01, -1.588456758703149e+01},
	{"TNQ", -2.909672445610996e+01, -1.829278951409569e+01},
	{"TNR", -2.265780458999777e+01, -1.185386964798350e+01},
	{"TNS", -2.361630529488721e+01, -1.281237035287294e+01},
	{"TNT", -1.882087449073268e+01, -8.016939548718414e+00},
	{"TNU", -1.572333792572303e+01, -4.919402983708762e+00},
	{"TNV", -2.734124383219217e+01, -1.653730889017789e+01},
	{"TNW", -2.254590740089217e+01, -1.174197245887790e+01},
	{"TNX", -3.115329859829266e+01, -2.034936365627840e+01},
	{"TNY", -2.339673647651127e+01, -1.259280153449700e+01},
	{"TNZ", -3.166200364207225e+01, -2.085806870005799e+01},
	{"TOA", -1.100555184847813e+01, -4.465763195423684e+00},
	{"TOB", -1.090175226435738e+01, -4.361963611302933e+00},
	{"TOC", -1.163287324480215e+01, -5.093084591747697e+00},
	{"TOD", -1.165721351575939e+01, -5.117424862704937e+00},
	{"TOE", -1.231783334166389e+01, -5.778044688609437e+00},
	{"TOF", -9.423937121880451e+00, -2.884148468826000e+00},
	{"TOG", -1.164996116064719e+01, -5.110172507592742e+00},
	{"TOH", -1.091805434220798e+01, -4.378265689153528e+00},
	{"TOI", -1.258607977497923e+01, -6.046291121924781e+00},
	{"TOJ", -1.401995475022576e+01, -7.480166097171313e+00},
	{"TOK", -1.383273376483701e+01, -7.292945111782560e+00},
	{"TOL", -1.194529296823911e+01, -5.405504315184655e+00},
	{"TOM", -1.070293174486911e+01, -4.163143091814659e+00},
	{"TON", -1.058117579577528e+01, -4.041387142720833e+00},
	{"TOO", -1.099925878665495e+01, -4.459470133600496e+00},
	{"TOP", -1.128245503785903e+01, -4.742666384804585e+00},
	{"TOQ", -1.689852008649646e+01, -1.035873143344201e+01},
	{"TOR", -1.009510776407714e+01, -3.555319111022686e+00},
	{"TOS", -1.108560977946768e+01, -4.545821126413233e+00},
	{"TOT", -9.172770796295193e+00, -2.632982143240743e+00},
	{"TOU", -1.190704336472698e+01, -5.367254711672530e+00},
	{"TOV", -1.389785156663444e+01, -7.358062913579990e+00},
	{"TOW", -1.134972329124965e+01, -4.809934638195205e+00},
	{"TOX", -1.778750054062794e+01, -1.124771188757349e+01},
	{"TOY", -1.313462502387670e+01, -6.594836370822246e+00},
	{"TOZ", -1.710395020580988e+01, -1.056416155275543e+01},
	{"TPA", -1.324370624977124e+01, -2.368134342447043e+00},
	{"TPB", -2.788959033868129e+01, -1.701401843135709e+01},
	{"TPC", -2.878317856735046e+01, -1.790760666002627e+01},
	{"TPD", -2.932230476647214e+01, -1.844673285914794e+01},
	{"TPE", -1.378194908651731e+01, -2.906377179193108e+00},
	{"TPF", -2.267871573396659e+01, -1.180314382664240e+01},
	{"TPG", -1.932436968340910e+01, -8.448797776084904e+00},
	{"TPH", -1.608389556569278e+01, -5.208323658368582e+00},
	{"TPI", -1.592378296130876e+01, -5.048211053984564e+00},
	{"TPJ", -3.149776614107666e+01, -2.062219423375246e+01},
	{"TPK", -3.138068674909556e+01, -2.050511484177137e+01},
	{"TPL", -1.428454997805551e+01, -3.408978070731309e+00},
	{"TPM", -2.089169156809752e+01, -1.001611966077332e+01},
	{"TPN", -2.921397179225164e+01, -1.833839988492744e+01},
	{"TPO", -1.354559372911540e+01, -2.670021821791200e+00},
	{"TPP", -1.719514778905717e+01, -6.319575881732970e+00},
	{"TPQ", -3.275403680673780e+01, -2.187846489941360e+01},
	{"TPR", -1.283395057142114e+01, -1.958378664096941e+00},
	{"TPS", -2.064732272572996e+01, -9.771750818405760e+00},
	{"TPT", -2.071957782765919e+01, -9.844005920334993e+00},
	{"TPU", -1.468593969270649e+01, -3.810367785382291e+00},
	{"TPV", -3.090205919817487e+01, -2.002648729085067e+01},
	{"TPW", -1.689751130246149e+01, -6.021939395137293e+00},
	{"TPX", -3.625521551214560e+01, -2.537964360482141e+01},
	{"TPY", -2.024005992336194e+01, -9.364488016037747e+00},
	{"TPZ", -3.456033113759670e+01, -2.368475923027250e+01},
	{"TQA", -2.833446974327314e+01, -1.300028049302078e+01},
	{"TQB", -3.096189169041541e+01, -1.562770244016306e+01},
	{"TQC", -2.987289090831230e+01, -1.453870165805993e+01},
	{"TQD", -3.148359555050534e+01, -1.614940630025298e+01},
	{"TQE", -3.187149009464959e+01, -1.653730084439722e+01},
	{"TQF", -3.022420006382134e+01, -1.489001081356897e+01},
	{"TQG", -3.694721846828769e+01, -2.161302921803534e+01},
	{"TQH", -3.078195315076532e+01, -1.544776390051296e+01},
	{"TQI", -2.667351375865737e+01, -1.133932450840501e+01},
	{"TQJ", -3.274726492590712e+01, -1.741307567565475e+01},
	{"TQK", -3.857940366322644e+01, -2.324521441297408e+01},
	{"TQL", -3.121202989260590e+01, -1.587784064235354e+01},
	{"TQM", -3.040195388206764e+01, -1.506776463181527e+01},
	{"TQN", -3.323127125903638e+01, -1.789708200878402e+01},
	{"TQO", -3.142771708976182e+01, -1.609352783950946e+01},
	{"TQP", -3.141571566304832e+01, -1.608152641279596e+01},
	{"TQQ", -3.331130542492478e+01, -1.797711617467241e+01},
	{"TQR", -3.127660592763954e+01, -1.594241667738717e+01},
	{"TQS", -2.834891808292828e+01, -1.301472883267592e+01},
	{"TQT", -2.884858908686259e+01, -1.351439983661023e+01},
	{"TQU", -1.533561946740351e+01, -1.430217151147433e-03},
	{"TQV", -3.414245910527805e+01, -1.880826985502569e+01},
	{"TQW", -3.050071192942432e+01, -1.516652267917196e+01},
	{"TQX", -4.060253562110937e+01, -2.526834637085701e+01},
	{"TQY", -3.479525582255616e+01, -1.946106657230379e+01},
	{"TQZ", -4.174210305785990e+01, -2.640791380760754e+01},
	{"TRA", -1.014734024609501e+01, -1.934902855424115e+00},
	{"TRB", -2.622306464529937e+01, -1.801062725462847e+01},
	{"TRC", -2.521417808226725e+01, -1.700174069159636e+01},
	{"TRD", -2.296525275392242e+01, -1.475281536325153e+01},
	{"TRE", -1.039986864582721e+01, -2.187431255156322e+00},
	{"TRF", -2.605209083768266e+01, -1.783965344701177e+01},
	{"TRG", -2.567545197112528e+01, -1.746301458045439e+01},
	{"TRH", -1.961219547613286e+01, -1.139975808546196e+01},
	{"TRI", -1.071395319976334e+01, -2.501515809092452e+00},
	{"TRJ", -2.914249215109773e+01, -2.093005476042684e+01},
	{"TRK", -2.601284882938695e+01, -1.780041143871605e+01},
	{"TRL", -2.203013581819504e+01, -1.381769842752415e+01},
	{"TRM", -2.488804060876002e+01, -1.667560321808912e+01},
	{"TRN", -2.494329007952020e+01, -1.673085268884930e+01},
	{"TRO", -1.080242118187597e+01, -2.589983791205078e+00},
	{"TRP", -2.614554782416253e+01, -1.793311043349164e+01},
	{"TRQ", -3.053195854806682e+01, -2.231952115739593e+01},
	{"TRR", -2.251178437067554e+01, -1.429934698000465e+01},
	{"TRS", -2.365190502549050e+01, -1.543946763481961e+01},
	{"TRT", -2.131767988165791e+01, -1.310524249098702e+01},
	{"TRU", -1.144492082620286e+01, -3.232483435531974e+00},
	{"TRV", -2.646310188798391e+01, -1.825066449731302e+01},
	{"TRW", -2.581867170359713e+01, -1.760623431292624e+01},
	{"TRX", -3.119708472082628e+01, -2.298464733015539e+01},
	{"TRY", -1.206706774695510e+01, -3.854630356284203e+00},
	{"TRZ", -3.212820725467253e+01, -2.391576986400164e+01},
	{"TSA", -1.098370525411860e+01, -2.784229097384869e+00},
	{"TSB", -1.347031541387780e+01, -5.270839257144064e+00},
	{"TSC", -1.340619936370273e+01, -5.206723206968999e+00},
	{"TSD", -1.437163067053794e+01, -6.172154513804203e+00},
	{"TSE", -1.182504881804440e+01, -3.625572661310660e+00},
	{"TSF", -1.350024495933799e+01, -5.300768802604256e+00},
	{"TSG", -1.519846378282272e+01, -6.998987626088987e+00},
	{"TSH", -1.154045638208751e+01, -3.340980225353778e+00},
	{"TSI", -1.202313240888625e+01, -3.823656252152511e+00},
	{"TSJ", -1.710345831176600e+01, -8.903982155032265e+00},
	{"TSK", -1.690963678804221e+01, -8.710160631308472e+00},
	{"TSL", -1.427711229206733e+01, -6.077636135333592e+00},
	{"TSM", -1.374371221609130e+01, -5.544236059357568e+00},
	{"TSN", -1.477821691685603e+01, -6.578740760122296e+00},
	{"TSO", -1.084257419549810e+01, -2.643098038764363e+00},
	{"TSP", -1.310789621005774e+01, -4.908420053324002e+00},
	{"TSQ", -1.756812161082307e+01, -9.368645454089336e+00},
	{"TSR", -1.476375973300987e+01, -6.564283576276138e+00},
	{"TSS", -1.330004682104764e+01, -5.100570664313905e+00},
	{"TST", -1.129604702163422e+01, -3.096570864900489e+00},
	{"TSU", -1.291795559547923e+01, -4.718479438745500e+00},
	{"TSV", -1.610352066006583e+01, -7.904044503332096e+00},
	{"TSW", -1.242480041211972e+01, -4.225324255385980e+00},
	{"TSX", -2.090917325571856e+01, -1.270969709898482e+01},
	{"TSY", -1.584741498959535e+01, -7.647938832861615e+00},
	{"TSZ", -1.813372130915447e+01, -9.934245152420740e+00},
	{"TTA", -1.234571566935700e+01, -4.729079091277679e+00},
	{"TTB", -1.969811177325720e+01, -1.208147519517788e+01},
	{"TTC", -1.979092233617231e+01, -1.217428575809299e+01},
	{"TTD", -2.011708747865655e+01, -1.250045090057723e+01},
	{"TTE", -1.045215333654719e+01, -2.835516758467868e+00},
	{"TTF", -2.036872809151776e+01, -1.275209151343844e+01},
	{"TTG", -2.264664019328518e+01, -1.503000361520585e+01},
	{"TTH", -8.533349406703524e+00, -9.167128286241997e-01},
	{"TTI", -1.227889230716967e+01, -4.662255729090342e+00},
	{"TTJ", -2.171050364165331e+01, -1.409386706357398e+01},
	{"TTK", -2.212141673999621e+01, -1.450478016191688e+01},
	{"TTL", -1.153011212610356e+01, -3.913475548024234e+00},
	{"TTM", -1.988914956295146e+01, -1.227251298487214e+01},
	{"TTN", -2.135812306029017e+01, -1.374148648221085e+01},
	{"TTO", -1.042538061475376e+01, -2.808744036674436e+00},
	{"TTP", -1.597645701163895e+01, -8.359820433559623e+00},
	{"TTQ", -3.111525863158999e+01, -2.349862205351066e+01},
	{"TTR", -1.349742713039369e+01, -5.880790552314364e+00},
	{"TTS", -1.547644451951605e+01, -7.859807941436729e+00},
	{"TTT", -1.952981266601028e+01, -1.191317608793095e+01},
	{"TTU", -1.526571456955402e+01, -7.649077991474697e+00},
	{"TTV", -2.911653667277014e+01, -2.149990009469081e+01},
	{"TTW", -1.480732227291781e+01, -7.190685694838481e+00},
	{"TTX", -3.383259771300906e+01, -2.621596113492974e+01},
	{"TTY", -1.491979843030031e+01, -7.303161852220979e+00},
	{"TTZ", -3.130583116996992e+01, -2.368919459189060e+01},
	{"TUA", -1.302471694858002e+01, -3.959904005951299e+00},
	{"TUB", -1.530710265003070e+01, -6.242289707401980e+00},
	{"TUC", -1.628445055442238e+01, -7.219637611793663e+00},
	{"TUD", -1.312210227785865e+01, -4.057289335229934e+00},
	{"TUE", -1.502286923377573e+01, -5.958056291147009e+00},
	{"TUF", -1.690911052153636e+01, -7.844297578907637e+00},
	{"TUG", -1.761028981343781e+01, -8.545476870809090e+00},
	{"TUH", -2.167771478705576e+01, -1.261290184442704e+01},
	{"TUI", -1.840800335212023e+01, -9.343190409491514e+00},
	{"TUJ", -3.111938639324462e+01, -2.205457345061590e+01},
	{"TUK", -2.209486378640331e+01, -1.303005084377459e+01},
	{"TUL", -1.591022417915998e+01, -6.845411236531261e+00},
	{"TUM", -1.478569078039539e+01, -5.720877837766671e+00},
	{"TUN", -1.223840283425264e+01, -3.173589891623917e+00},
	{"TUO", -1.615602189458583e+01, -7.091208951957106e+00},
	{"TUP", -1.228874864465451e+01, -3.223935702025789e+00},
	{"TUQ", -3.258099034428000e+01, -2.351617740165128e+01},
	{"TUR", -1.022630636964414e+01, -1.161493427015424e+00},
	{"TUS", -1.290210341898994e+01, -3.837290476361223e+00},
	{"TUT", -1.311945260820116e+01, -4.054639665572441e+00},
	{"TUU", -2.212734584189614e+01, -1.306253289926741e+01},
	{"TUV", -2.926326966409450e+01, -2.019845672146578e+01},
	{"TUW", -2.357244464348215e+01, -1.450763170085343e+01},
	{"TUX", -2.953809099030274e+01, -2.047327804767402e+01},
	{"TUY", -2.170738686792324e+01, -1.264257392529451e+01},
	{"TUZ", -2.013111030734137e+01, -1.106629736471265e+01},
	{"TVA", -1.554430064623032e+01, -2.220369649453277e+00},
	{"TVB", -3.267685996341875e+01, -1.935292896664171e+01},
	{"TVC", -3.286621629075896e+01, -1.954228529398191e+01},
	{"TVD", -2.371513789294947e+01, -1.039120689617242e+01},
	{"TVE", -1.485191861352489e+01, -1.527987616747843e+00},
	{"TVF", -3.229930147702409e+01, -1.897537048024705e+01},
	{"TVG", -3.356966575367528e+01, -2.024573475689824e+01},
	{"TVH", -3.134886903254046e+01, -1.802493803576341e+01},
	{"TVI", -1.502579225639724e+01, -1.701861259620194e+00},
	{"TVJ", -3.355688575775262e+01, -2.023295476097558e+01},
	{"TVK", -3.543648638053094e+01, -2.211255538375390e+01},
	{"TVL", -3.270872945221645e+01, -1.938479845543940e+01},
	{"TVM", -3.171919223384461e+01, -1.839526123706756e+01},
	{"TVN", -2.171681804517855e+01, -8.392887048401498e+00},
	{"TVO", -1.633866606695561e+01, -3.014735070178564e+00},
	{"TVP", -3.179183923892642e+01, -1.846790824214937e+01},
	{"TVQ", -3.938868115386643e+01, -2.606475015708938e+01},
	{"TVR", -2.974787478601720e+01, -1.642394378924016e+01},
	{"TVS", -2.370867174988724e+01, -1.038474075311020e+01},
	{"TVT", -3.009588284539551e+01, -1.677195184861847e+01},
	{"TVU", -2.171369793927198e+01, -8.389766942494937e+00},
	{"TVV", -3.418262397400245e+01, -2.085869297722540e+01},
	{"TVW", -3.142501794731967e+01, -1.810108695054262e+01},
	{"TVX", -3.601450197096309e+01, -2.269057097418604e+01},
	{"TVY", -2.783734440693366e+01, -1.451341341015661e+01},
	{"TVZ", -3.942438085352081e+01, -2.610044985674376e+01},
	{"TWA", -1.080798559427685e+01, -1.959077168936031e+00},
	{"TWB", -2.786489632453055e+01, -1.901598789918973e+01},
	{"TWC", -2.364260536079123e+01, -1.479369693545040e+01},
	{"TWD", -2.743748587838652e+01, -1.858857745304569e+01},
	{"TWE", -1.108891359503400e+01, -2.240005169693177e+00},
	{"TWF", -2.267441948561112e+01, -1.382551106027030e+01},
	{"TWG", -2.884581709450790e+01, -1.999690866916708e+01},
	{"TWH", -1.145236055292061e+01, -2.603452127579787e+00},
	{"TWI", -1.150428618716490e+01, -2.655377761824081e+00},
	{"TWJ", -3.020251155732531e+01, -2.135360313198449e+01},
	{"TWK", -3.035752402085133e+01, -2.150861559551051e+01},
	{"TWL", -2.678755628135280e+01, -1.793864785601198e+01},
	{"TWM", -2.748745873446728e+01, -1.863855030912646e+01},
	{"TWN", -2.436267847885705e+01, -1.551377005351623e+01},
	{"TWO", -1.117593058046677e+01, -2.327022155125946e+00},
	{"TWP", -2.366984510454225e+01, -1.482093667920143e+01},
	{"TWQ", -3.282987333120133e+01, -2.398096490586051e+01},
	{"TWR", -1.609529355363624e+01, -7.246385128295418e+00},
	{"TWS", -2.562259561607578e+01, -1.677368719073496e+01},
	{"TWT", -2.549287309277408e+01, -1.664396466743326e+01},
	{"TWU", -2.090603410679094e+01, -1.205712568145011e+01},
	{"TWV", -3.068004669384651e+01, -2.183113826850569e+01},
	{"TWW", -1.825529442562784e+01, -9.406386000287016e+00},
	{"TWX", -4.002367959732674e+01, -3.117477117198592e+01},
	{"TWY", -2.267267459280155e+01, -1.382376616746072e+01},
	{"TWZ", -3.354666324796590e+01, -2.469775482262508e+01},
	{"TXA", -2.375627379840300e+01, -5.716281761387029e+00},
	{"TXB", -2.832359840743745e+01, -1.028360637042148e+01},
	{"TXC", -2.198698876540638e+01, -3.946996728390410e+00},
	{"TXD", -2.771591337438826e+01, -9.675921337372294e+00},
	{"TXE", -2.253896447617752e+01, -4.498972439161550e+00},
	{"TXF", -2.785909602641290e+01, -9.819103989396925e+00},
	{"TXG", -2.915816056652866e+01, -1.111816852951269e+01},
	{"TXH", -2.551633439239196e+01, -7.476342355375999e+00},
	{"TXI", -2.024155551130510e+01, -2.201563474289128e+00},
	{"TXJ", -3.037112969255257e+01, -1.233113765553660e+01},
	{"TXK", -3.126921598299895e+01, -1.322922394598298e+01},
	{"TXL", -2.781644999982242e+01, -9.776457962806454e+00},
	{"TXM", -2.709893595295958e+01, -9.058943915943608e+00},
	{"TXN", -2.960865367437360e+01, -1.156866163735762e+01},
	{"TXO", -2.611400678089221e+01, -8.074014743876242e+00},
	{"TXP", -2.273236116219393e+01, -4.692369125177962e+00},
	{"TXQ", -2.927142534226572e+01, -1.123143330524974e+01},
	{"TXR", -2.788840320054480e+01, -9.848411163528834e+00},
	{"TXS", -2.718149819423006e+01, -9.141506157214090e+00},
	{"TXT", -1.902280120421144e+01, -9.828091671954708e-01},
	{"TXU", -2.639449552773887e+01, -8.354503490722900e+00},
	{"TXV", -2.205944010070553e+01, -4.019448063689558e+00},
	{"TXW", -2.361528462220098e+01, -5.575292585185014e+00},
	{"TXX", -2.680160180455567e+01, -8.761609767539696e+00},
	{"TXY", -2.698868382580226e+01, -8.948691788786292e+00},
	{"TXZ", -4.080844509516532e+01, -2.276845305814934e+01},
	{"TYA", -1.223577873960135e+01, -3.032076267278907e+00},
	{"TYB", -1.431799240928100e+01, -5.114289936958565e+00},
	{"TYC", -1.459239038077032e+01, -5.388687908447886e+00},
	{"TYD", -1.514251167009859e+01, -5.938809197776151e+00},
	{"TYE", -1.294394952284782e+01, -3.740247050525382e+00},
	{"TYF", -1.382270487853772e+01, -4.619002406215285e+00},
	{"TYG", -1.592180508809273e+01, -6.718102615770294e+00},
	{"TYH", -1.445679884000606e+01, -5.253096367683627e+00},
	{"TYI", -1.325983386132177e+01, -4.056131388999336e+00},
	{"TYJ", -1.850563368979801e+01, -9.301931217475577e+00},
	{"TYK", -1.773902403656632e+01, -8.535321564243878e+00},
	{"TYL", -1.509828306120467e+01, -5.894580588882237e+00},
	{"TYM", -1.457437445059242e+01, -5.370671978269980e+00},
	{"TYN", -1.575642472723091e+01, -6.552722254908470e+00},
	{"TYO", -1.118650552870793e+01, -1.982803056385497e+00},
	{"TYP", -1.407526187711987e+01, -4.871559404797430e+00},
	{"TYQ", -1.891017355202264e+01, -9.706471079700208e+00},
	{"TYR", -1.478031359963731e+01, -5.576611127314870e+00},
	{"TYS", -1.355079008181133e+01, -4.347087609488892e+00},
	{"TYT", -1.256289871511401e+01, -3.359196242791572e+00},
	{"TYU", -1.650685791711667e+01, -7.303155444794232e+00},
	{"TYV", -1.776187199515388e+01, -8.558169522831436e+00},
	{"TYW", -1.339873394355880e+01, -4.195031471236360e+00},
	{"TYX", -2.171665554169841e+01, -1.251295306937597e+01},
	{"TYY", -1.472678029766331e+01, -5.523077825340873e+00},
	{"TYZ", -2.370503018784853e+01, -1.450132771552609e+01},
	{"TZA", -1.832069116789925e+01, -2.807465673922417e+00},
	{"TZB", -1.980573311083377e+01, -4.292507616856933e+00},
	{"TZC", -2.090365801991378e+01, -5.390432525936949e+00},
	{"TZD", -2.821863648305109e+01, -1.270541098907426e+01},
	{"TZE", -1.713745139173264e+01, -1.624225897755802e+00},
	{"TZF", -2.170155932998815e+01, -6.188333836011311e+00},
	{"TZG", -2.138895021686982e+01, -5.875724722892991e+00},
	{"TZH", -2.053569569668799e+01, -5.022470202711160e+00},
	{"TZI", -1.777024703003637e+01, -2.257021536059538e+00},
	{"TZJ", -3.085400158204633e+01, -1.534077608806950e+01},
	{"TZK", -2.369635580745771e+01, -8.183130313480877e+00},
	{"TZL", -2.248127647573694e+01, -6.968050981760107e+00},
	{"TZM", -2.266688194542314e+01, -7.153656451446306e+00},
	{"TZN", -2.848896318175760e+01, -1.297573768778077e+01},
	{"TZO", -2.000403563705426e+01, -4.490810143077430e+00},
	{"TZP", -2.109814296728380e+01, -5.584917473306967e+00},
	{"TZQ", -3.477021547136968e+01, -1.925698997739284e+01},
	{"TZR", -2.252863795853143e+01, -7.015412464554593e+00},
	{"TZS", -2.111534117080969e+01, -5.602115676832858e+00},
	{"TZT", -2.022888050597058e+01, -4.715655011993749e+00},
	{"TZU", -2.504013511689668e+01, -9.526909622919852e+00},
	{"TZV", -2.793643028526431e+01, -1.242320479128748e+01},
	{"TZW", -2.053111147030585e+01, -5.017885976329017e+00},
	{"TZX", -3.757835203281452e+01, -2.206512653883768e+01},
	{"TZY", -2.601349752472808e+01, -1.050027203075125e+01},
	{"TZZ", -2.360870958629662e+01, -8.095484092319786e+00},
	{"UAA", -1.776233141968227e+01, -7.533981838146699e+00},
	{"UAB", -1.607062825825120e+01, -5.842278676715638e+00},
	{"UAC", -1.721142035163351e+01, -6.983070770097944e+00},
	{"UAD", -1.436106074703803e+01, -4.132711165502463e+00},
	{"UAE", -1.767199104302324e+01, -7.443641461487673e+00},
	{"UAF", -1.853702315407393e+01, -8.308673572538362e+00},
	{"UAG", -1.477459249533326e+01, -4.546242913797695e+00},
	{"UAH", -1.804142271194148e+01, -7.813073130405916e+00},
	{"UAI", -1.597708459305991e+01, -5.748735011524345e+00},
	{"UAJ", -2.898489142991641e+01, -1.875654184838084e+01},
	{"UAK", -1.701368874831827e+01, -6.785339166782703e+00},
	{"UAL", -1.165895472781548e+01, -1.430605146279916e+00},
	{"UAM", -1.810869917079130e+01, -7.880349589255731e+00},
	{"UAN", -1.350017952169245e+01, -3.271829940156885e+00},
	{"UAO", -2.170638680691293e+01, -1.147803722537737e+01},
	{"UAP", -1.878878498300454e+01, -8.560435401468972e+00},
	{"UAQ", -2.212039416971652e+01, -1.189204458818095e+01},
	{"UAR", -1.230325666142436e+01, -2.074907079888791e+00},
	{"UAS", -1.559374939194445e+01, -5.365399810408880e+00},
	{"UAT", -1.389483415315522e+01, -3.666484571619653e+00},
	{"UAU", -2.106559947810238e+01, -1.083724989656682e+01},
	{"UAV", -2.006229296911384e+01, -9.833943387578271e+00},
	{"UAW", -1.824997749636766e+01, -8.021627914832093e+00},
	{"UAX", -2.874316396637220e+01, -1.851481438483664e+01},
	{"UAY", -2.098806660658908e+01, -1.075971702505351e+01},
	{"UAZ", -2.870930936886273e+01, -1.848095978732716e+01},
	{"UBA", -1.566010621844846e+01, -5.042370555905086e+00},
	{"UBB", -1.539629316877997e+01, -4.778557506236597e+00},
	{"UBC", -2.012300684038195e+01, -9.505271177838582e+00},
	{"UBD", -1.625915640230302e+01, -5.641420739759647e+00},
	{"UBE", -1.412407331468934e+01, -3.506337652145969e+00},
	{"UBF", -2.113097219068764e+01, -1.051323652814427e+01},
	{"UBG", -2.371298636450462e+01, -1.309525070196124e+01},
	{"UBH", -2.071395618613797e+01, -1.009622052359460e+01},
	{"UBI", -1.455916371045385e+01, -3.941428047910479e+00},
	{"UBJ", -1.418332558247707e+01, -3.565589919933702e+00},
	{"UBK", -3.192126940871777e+01, -2.130353374617440e+01},
	{"UBL", -1.204679898311104e+01, -1.429063320567673e+00},
	{"UBM", -1.544722403835966e+01, -4.829488375816286e+00},
	{"UBN", -2.368266058730144e+01, -1.306492492475807e+01},
	{"UBO", -1.631522021733339e+01, -5.697484554790019e+00},
	{"UBP", -2.270771918631372e+01, -1.208998352377035e+01},
	{"UBQ", -3.578866048016484e+01, -2.517092481762147e+01},
	{"UBR", -1.682840286290107e+01, -6.210667200357697e+00},
	{"UBS", -1.403519649201312e+01, -3.417460829469750e+00},
	{"UBT", -1.403721329412244e+01, -3.419477631579069e+00},
	{"UBU", -1.549173478657665e+01, -4.873999124033277e+00},
	{"UBV", -1.939582013207860e+01, -8.778084469535226e+00},
	{"UBW", -1.932493578356889e+01, -8.707200121025515e+00},
	{"UBX", -3.907586831940544e+01, -2.845813265686207e+01},
	{"UBY", -1.776400613805797e+01, -7.146270475514598e+00},
	{"UBZ", -3.358397219517285e+01, -2.296623653262948e+01},
	{"UCA", -1.362846957863109e+01, -3.825234340798941e+00},
	{"UCB", -2.984577853139914e+01, -2.004254329356699e+01},
	{"UCC", -1.329321060851279e+01, -3.489975370680644e+00},
	{"UCD", -2.367746492833245e+01, -1.387422969050030e+01},
	{"UCE", -1.308684001288980e+01, -3.283604775057648e+00},
	{"UCF", -2.970936271042755e+01, -1.990612747259540e+01},
	{"UCG", -3.066491416185769e+01, -2.086167892402555e+01},
	{"UCH", -1.108452573098648e+01, -1.281290493154333e+00},
	{"UCI", -1.478521740321987e+01, -4.981982165387724e+00},
	{"UCJ", -3.262913383118414e+01, -2.282589859335200e+01},
	{"UCK", -1.325464754772646e+01, -3.451412309894313e+00},
	{"UCL", -1.759751436826051e+01, -7.794279130428364e+00},
	{"UCM", -2.961344086494949e+01, -1.981020562711734e+01},
	{"UCN", -3.048380882690914e+01, -2.068057358907700e+01},
	{"UCO", -1.499314480082103e+01, -5.189909562988877e+00},
	{"UCP", -2.889997595634696e+01, -1.909674071851482e+01},
	{"UCQ", -2.901344454396874e+01, -1.921020930613659e+01},
	{"UCR", -1.729847435060351e+01, -7.495239112771366e+00},
	{"UCS", -2.209918798083476e+01, -1.229595274300261e+01},
	{"UCT", -1.245409761810774e+01, -2.650862380275589e+00},
	{"UCU", -1.729955805163189e+01, -7.496322813799746e+00},
	{"UCV", -3.227857643330965e+01, -2.247534119547750e+01},
	{"UCW", -2.798684026264529e+01, -1.818360502481314e+01},
	{"UCX", -3.362193214997484e+01, -2.381869691214269e+01},
	{"UCY", -2.011753948118070e+01, -1.031430424334855e+01},
	{"UCZ", -3.223298199450027e+01, -2.242974675666812e+01},
	{"UDA", -1.351952960011953e+01, -2.976282243376438e+00},
	{"UDB", -1.771841552495736e+01, -7.175168168214268e+00},
	{"UDC", -1.849152801727370e+01, -7.948280660530608e+00},
	{"UDD", -1.412908721375015e+01, -3.585839857007052e+00},
	{"UDE", -1.256880447238679e+01, -2.025557115643693e+00},
	{"UDF", -1.820635963835398e+01, -7.663112281610888e+00},
	{"UDG", -1.323660334201885e+01, -2.693355985275755e+00},
	{"UDH", -1.769615058092513e+01, -7.152903224182038e+00},
	{"UDI", -1.321699908576625e+01, -2.673751729023150e+00},
	{"UDJ", -2.088561277595367e+01, -1.034236541921057e+01},
	{"UDK", -2.053992954433614e+01, -9.996682187593043e+00},
	{"UDL", -1.695804352153519e+01, -6.414796164792095e+00},
	{"UDM", -1.985095385613760e+01, -9.307706499394508e+00},
	{"UDN", -1.958972273482018e+01, -9.046475378077082e+00},
	{"UDO", -1.455905949691569e+01, -4.015812140172589e+00},
	{"UDP", -1.977578334068438e+01, -9.232535983941290e+00},
	{"UDQ", -2.932008937128427e+01, -1.877684201454118e+01},
	{"UDR", -1.734735947878306e+01, -6.804112122039967e+00},
	{"UDS", -1.516169553381146e+01, -4.618448177068363e+00},
	{"UDT", -1.661915203811091e+01, -6.075904681367816e+00},
	{"UDU", -1.855846118180006e+01, -8.015213825056966e+00},
	{"UDV", -1.776099780411371e+01, -7.217750447370611e+00},
	{"UDW", -1.739762770308456e+01, -6.854380346341467e+00},
	{"UDX", -3.412682249877664e+01, -2.358357514203355e+01},
	{"UDY", -1.499642985348000e+01, -4.453182496736901e+00},
	{"UDZ", -3.030503606502578e+01, -1.976178870828268e+01},
	{"UEA", -1.451124582181016e+01, -4.260019293429198e+00},
	{"UEB", -1.613021723006246e+01, -5.878990701681500e+00},
	{"UEC", -1.678640390657702e+01, -6.535177378196064e+00},
	{"UED", -1.358896192650782e+01, -3.337735398126862e+00},
	{"UEE", -1.456642965844683e+01, -4.315203130065868e+00},
	{"UEF", -1.621307092889646e+01, -5.961844400515496e+00},
	{"UEG", -1.818260267019363e+01, -7.931376141812673e+00},
	{"UEH", -1.663612150438689e+01, -6.384894976005924e+00},
	{"UEI", -1.529697533092671e+01, -5.045748802545747e+00},
	{"UEJ", -1.990612438069634e+01, -9.654897852315377e+00},
	{"UEK", -2.088473034444884e+01, -1.063350381606787e+01},
	{"UEL", -1.412019556448580e+01, -3.868969036104838e+00},
	{"UEM", -1.699040682449152e+01, -6.739180296110555e+00},
	{"UEN", -1.280308797580499e+01, -2.551861447424024e+00},
	{"UEO", -1.465577964289429e+01, -4.404553114513325e+00},
	{"UEP", -1.724756845192504e+01, -6.996341923544078e+00},
	{"UEQ", -2.137632985023179e+01, -1.112510332185083e+01},
	{"UER", -1.453487692106551e+01, -4.283650392684543e+00},
	{"UES", -1.236392141372976e+01, -2.112694885348793e+00},
	{"UET", -1.390519277518442e+01, -3.653966246803454e+00},
	{"UEU", -1.866566842370232e+01, -8.414441895321353e+00},
	{"UEV", -1.677046792219176e+01, -6.519241393810795e+00},
	{"UEW", -1.588703533104610e+01, -5.635808802665133e+00},
	{"UEX", -1.828502157913036e+01, -8.033795050749397e+00},
	{"UEY", -1.899375518125471e+01, -8.742528652873744e+00},
	{"UEZ", -2.071584547584398e+01, -1.046461894746301e+01},
	{"UFA", -1.503862985466281e+01, -2.835872822930231e+00},
	{"UFB", -2.656474737255121e+01, -1.436199034081864e+01},
	{"UFC", -2.597861952187598e+01, -1.377586249014341e+01},
	{"UFD", -2.686059241266545e+01, -1.465783538093288e+01},
	{"UFE", -1.785969654449238e+01, -5.656939512759808e+00},
	{"UFF", -1.284806620393393e+01, -6.453091722013524e-01},
	{"UFG", -2.651516193249884e+01, -1.431240490076627e+01},
	{"UFH", -2.531543324232100e+01, -1.311267621058842e+01},
	{"UFI", -1.775872414373420e+01, -5.555967112001620e+00},
	{"UFJ", -2.730345650644092e+01, -1.510069947470834e+01},
	{"UFK", -2.919963727139045e+01, -1.699688023965788e+01},
	{"UFL", -1.861420374773866e+01, -6.411446716006084e+00},
	{"UFM", -2.564682348346456e+01, -1.344406645173198e+01},
	{"UFN", -2.726758014152739e+01, -1.506482310979482e+01},
	{"UFO", -1.535990857061367e+01, -3.157151538881099e+00},
	{"UFP", -2.617885633797981e+01, -1.397609930624724e+01},
	{"UFQ", -3.144648284166303e+01, -1.924372580993045e+01},
	{"UFR", -1.700400506103966e+01, -4.801248029307085e+00},
	{"UFS", -2.550620774338967e+01, -1.330345071165709e+01},
	{"UFT", -1.930290204754601e+01, -7.100145015813436e+00},
	{"UFU", -1.861357391122592e+01, -6.410816879493345e+00},
	{"UFV", -2.848046513496747e+01, -1.627770810323490e+01},
	{"UFW", -2.623239060748339e+01, -1.402963357575082e+01},
	{"UFX", -3.375785434599653e+01, -2.155509731426396e+01},
	{"UFY", -2.687531240377250e+01, -1.467255537203993e+01},
	{"UFZ", -2.988644780552307e+01, -1.768369077379049e+01},
	{"UGA", -1.513598275169104e+01, -5.377137449263723e+00},
	{"UGB", -1.988545757708415e+01, -1.012661227465683e+01},
	{"UGC", -2.036633871219783e+01, -1.060749340977051e+01},
	{"UGD", -2.107863204727444e+01, -1.131978674484712e+01},
	{"UGE", -1.470987379663529e+01, -4.951028494207977e+00},
	{"UGF", -2.035544050480554e+01, -1.059659520237823e+01},
	{"UGG", -1.408537163598744e+01, -4.326526333560119e+00},
	{"UGH", -1.007680174149692e+01, -3.179564390696009e-01},
	{"UGI", -1.625388629933991e+01, -6.495040996912596e+00},
	{"UGJ", -2.916298671284400e+01, -1.940414141041668e+01},
	{"UGK", -2.940427279673696e+01, -1.964542749430964e+01},
	{"UGL", -1.668767095380569e+01, -6.928825651378372e+00},
	{"UGM", -1.831620717879950e+01, -8.557361876372187e+00},
	{"UGN", -1.844989763460315e+01, -8.691052332175840e+00},
	{"UGO", -1.538146111349471e+01, -5.622615811067391e+00},
	{"UGP", -2.133607434790768e+01, -1.157722904548037e+01},
	{"UGQ", -3.069735189135502e+01, -2.093850658892771e+01},
	{"UGR", -1.868211026461162e+01, -8.923264962184302e+00},
	{"UGS", -1.737966663690051e+01, -7.620821334473194e+00},
	{"UGT", -1.851799165703255e+01, -8.759146354605235e+00},
	{"UGU", -1.472192945648314e+01, -4.963084154055823e+00},
	{"UGV", -2.853779367327552e+01, -1.877894837084820e+01},
	{"UGW", -1.849469298980451e+01, -8.735847687377191e+00},
	{"UGX", -3.383824447491983e+01, -2.407939917249251e+01},
	{"UGY", -2.256701434948091e+01, -1.280816904705360e+01},
	{"UGZ", -3.250442587183461e+01, -2.274558056940729e+01},
	{"UHA", -1.321829566542551e+01, -3.453815845493594e-01},
	{"UHB", -2.779922761136645e+01, -1.492631353049030e+01},
	{"UHC", -2.777235823599699e+01, -1.489944415512085e+01},
	{"UHD", -2.825023282245547e+01, -1.537731874157932e+01},
	{"UHE", -1.604806048964630e+01, -3.175146408770155e+00},
	{"UHF", -2.778704334203294e+01, -1.491412926115680e+01},
	{"UHG", -2.877065036837506e+01, -1.589773628749891e+01},
	{"UHH", -2.670773343296879e+01, -1.383481935209265e+01},
	{"UHI", -1.757193968763549e+01, -4.699025606759340e+00},
	{"UHJ", -3.068908039750502e+01, -1.781616631662888e+01},
	{"UHK", -3.101268378622242e+01, -1.813976970534628e+01},
	{"UHL", -2.054184502671032e+01, -7.668930945834173e+00},
	{"UHM", -2.360355539145651e+01, -1.073064131058037e+01},
	{"UHN", -2.822338346968371e+01, -1.535046938880757e+01},
	{"UHO", -1.762826015783212e+01, -4.755346076955971e+00},
	{"UHP", -2.815621852154992e+01, -1.528330444067377e+01},
	{"UHQ", -3.244507828939400e+01, -1.957216420851785e+01},
	{"UHR", -2.165132129369359e+01, -8.778407212817442e+00},
	{"UHS", -2.676012047163514e+01, -1.388720639075899e+01},
	{"UHT", -2.183957359007006e+01, -8.966659509193908e+00},
	{"UHU", -1.895365910977101e+01, -6.080745028894865e+00},
	{"UHV", -3.091775706098031e+01, -1.804484298010416e+01},
	{"UHW", -2.689853554734847e+01, -1.402562146647232e+01},
	{"UHX", -3.644101531833716e+01, -2.356810123746101e+01},
	{"UHY", -2.205716916784542e+01, -9.184255086969268e+00},
	{"UHZ", -3.345289756421086e+01, -2.057998348333472e+01},
	{"UIA", -1.723225862764145e+01, -6.943982578582691e+00},
	{"UIB", -2.133133730026384e+01, -1.104306125120508e+01},
	{"UIC", -1.426672746763549e+01, -3.978451418576729e+00},
	{"UID", -1.454161951646074e+01, -4.253343467401977e+00},
	{"UIE", -1.500147534501547e+01, -4.713199295956710e+00},
	{"UIF", -1.773005163416260e+01, -7.441775585103842e+00},
	{"UIG", -2.059453398381545e+01, -1.030625793475669e+01},
	{"UIH", -1.925336854705394e+01, -8.965092497995181e+00},
	{"UII", -2.819542129939777e+01, -1.790714525033901e+01},
	{"UIJ", -2.370770517679256e+01, -1.341942912773380e+01},
	{"UIK", -2.110354959247588e+01, -1.081527354341712e+01},
	{"UIL", -1.285974392840479e+01, -2.571467879346028e+00},
	{"UIM", -1.891393591643105e+01, -8.625659867372290e+00},
	{"UIN", -1.343933953633228e+01, -3.151063487273519e+00},
	{"UIO", -2.020804394228048e+01, -9.919767893221723e+00},
	{"UIP", -1.558835139369185e+01, -5.300075344633088e+00},
	{"UIQ", -2.941370436148726e+01, -1.912542831242850e+01},
	{"UIR", -1.328722883178228e+01, -2.998952782723524e+00},
	{"UIS", -1.315467640244233e+01, -2.866400353383570e+00},
	{"UIT", -1.232699267774357e+01, -2.038716628684814e+00},
	{"UIU", -2.697724144647443e+01, -1.668896539741567e+01},
	{"UIV", -1.717028387646652e+01, -6.882007827407764e+00},
	{"UIW", -1.880582976685557e+01, -8.517553717796806e+00},
	{"UIX", -2.268018572706986e+01, -1.239190967801110e+01},
	{"UIY", -3.301047944206628e+01, -2.272220339300752e+01},
	{"UIZ", -1.971016287915453e+01, -9.421886830095771e+00},
	{"UJA", -2.044340010030309e+01, -3.282740622747729e+00},
	{"UJB", -2.999129027120556e+01, -1.283063079365020e+01},
	{"UJC", -3.084067991870209e+01, -1.368002044114673e+01},
	{"UJD", -3.273483750096553e+01, -1.557417802341017e+01},
	{"UJE", -2.002551778220970e+01, -2.864858304654346e+00},
	{"UJF", -3.185852339736982e+01, -1.469786391981446e+01},
	{"UJG", -3.144306429350909e+01, -1.428240481595373e+01},
	{"UJH", -3.062920730020119e+01, -1.346854782264584e+01},
	{"UJI", -2.137220193491838e+01, -4.211542457363024e+00},
	{"UJJ", -3.063500001650075e+01, -1.347434053894539e+01},
	{"UJK", -3.332357152437204e+01, -1.616291204681668e+01},
	{"UJL", -3.183240439360865e+01, -1.467174491605329e+01},
	{"UJM", -3.218832976733611e+01, -1.502767028978074e+01},
	{"UJN", -3.513839949598872e+01, -1.797774001843336e+01},
	{"UJO", -1.938776409619085e+01, -2.227104618635489e+00},
	{"UJP", -3.160018203015514e+01, -1.443952255259978e+01},
	{"UJQ", -3.458643377108101e+01, -1.742577429352565e+01},
	{"UJR", -3.081060850790146e+01, -1.364994903034610e+01},
	{"UJS", -3.123694336397833e+01, -1.407628388642297e+01},
	{"UJT", -3.134353464664911e+01, -1.418287516909375e+01},
	{"UJU", -1.818542811205500e+01, -1.024768634499643e+00},
	{"UJV", -3.820548699068186e+01, -2.104482751312651e+01},
	{"UJW", -3.057974303425284e+01, -1.341908355669748e+01},
	{"UJX", -4.088479239775069e+01, -2.372413292019533e+01},
	{"UJY", -3.735466314859531e+01, -2.019400367103995e+01},
	{"UJZ", -3.545966424205374e+01, -1.829900476449838e+01},
	{"UKA", -2.052369885955998e+01, -7.158392680163160e+00},
	{"UKB", -2.341589146477260e+01, -1.005058528537577e+01},
	{"UKC", -2.624505123214592e+01, -1.287974505274910e+01},
	{"UKD", -2.687865216479508e+01, -1.351334598539826e+01},
	{"UKE", -1.408765339291959e+01, -7.223472135227675e-01},
	{"UKF", -2.570970794483005e+01, -1.234440176543323e+01},
	{"UKG", -2.210973868748972e+01, -8.744432508092894e+00},
	{"UKH", -2.250771614754644e+01, -9.142409968149622e+00},
	{"UKI", -1.814315722966465e+01, -4.777851050267820e+00},
	{"UKJ", -2.956075416692552e+01, -1.619544798752870e+01},
	{"UKK", -2.071455676758299e+01, -7.349250588186173e+00},
	{"UKL", -2.105480220562884e+01, -7.689496026232014e+00},
	{"UKM", -2.165823709682596e+01, -8.292930917429141e+00},
	{"UKN", -1.508429109482077e+01, -1.718984915423949e+00},
	{"UKO", -2.003019415384709e+01, -6.664887974450272e+00},
	{"UKP", -2.659642110691614e+01, -1.323111492751931e+01},
	{"UKQ", -3.223989396149859e+01, -1.887458778210178e+01},
	{"UKR", -2.168368359221279e+01, -8.318377412815966e+00},
	{"UKS", -2.155484250367828e+01, -8.189536324281461e+00},
	{"UKT", -2.093856975428085e+01, -7.573263574884026e+00},
	{"UKU", -2.132927769151667e+01, -7.963971512119844e+00},
	{"UKV", -2.940090923277021e+01, -1.603560305337340e+01},
	{"UKW", -2.324686225646964e+01, -9.881556077072819e+00},
	{"UKX", -3.316363758336125e+01, -1.979833140396443e+01},
	{"UKY", -2.575694859245315e+01, -1.239164241305632e+01},
	{"UKZ", -3.131380371326160e+01, -1.794849753386477e+01},
	{"ULA", -1.164605090519309e+01, -3.020039573791050e+00},
	{"ULB", -1.573924130521380e+01, -7.113229973811755e+00},
	{"ULC", -1.503489651354650e+01, -6.408885182144465e+00},
	{"ULD", -1.004046271084320e+01, -1.414451379441154e+00},
	{"ULE", -1.308828816086246e+01, -4.462276829460413e+00},
	{"ULF", -1.456278903340548e+01, -5.936777702003440e+00},
	{"ULG", -1.474397102586381e+01, -6.117959694461768e+00},
	{"ULH", -1.587822532843781e+01, -7.252213997035766e+00},
	{"ULI", -1.331258455396140e+01, -4.686573222559359e+00},
	{"ULJ", -2.013116858796066e+01, -1.150515725655862e+01},
	{"ULK", -1.730691820940000e+01, -8.680906877997963e+00},
	{"ULL", -1.179475406937602e+01, -3.168742737973973e+00},
	{"ULM", -1.558294669864625e+01, -6.956935367244204e+00},
	{"ULN", -1.533005518566847e+01, -6.704043854266423e+00},
	{"ULO", -1.436025071266744e+01, -5.734239381265400e+00},
	{"ULP", -1.519022754517700e+01, -6.564216213774956e+00},
	{"ULQ", -1.932577043157204e+01, -1.069975910017000e+01},
	{"ULR", -1.657725672116342e+01, -7.951245389761376e+00},
	{"ULS", -1.330950308010003e+01, -4.683491748697989e+00},
	{"ULT", -1.163622181704893e+01, -3.010210485646893e+00},
	{"ULU", -1.523255648655257e+01, -6.606545155150528e+00},
	{"ULV", -1.739274521501173e+01, -8.766733883609692e+00},
	{"ULW", -1.519413715545315e+01, -6.568125824051107e+00},
	{"ULX", -2.213331442702081e+01, -1.350730309561876e+01},
	{"ULY", -1.539356610745905e+01, -6.767554776057008e+00},
	{"ULZ", -2.213253488820345e+01, -1.350652355680141e+01},
	{"UMA", -1.268464536242694e+01, -2.628138535893628e+00},
	{"UMB", -1.226978236740738e+01, -2.213275540874072e+00},
	{"UMC", -1.579322981933776e+01, -5.736722992804450e+00},
	{"UMD", -1.732446782562410e+01, -7.267960999090797e+00},
	{"UME", -1.254125125301160e+01, -2.484744426478287e+00},
	{"UMF", -1.665071863409874e+01, -6.594211807565429e+00},
	{"UMG", -1.939258130648637e+01, -9.336074479953064e+00},
	{"UMH", -1.760518915588658e+01, -7.548682329353269e+00},
	{"UMI", -1.433635028586980e+01, -4.279843459336488e+00},
	{"UMJ", -2.039368843705300e+01, -1.033718161051969e+01},
	{"UMK", -2.212521047645295e+01, -1.206870364991964e+01},
	{"UML", -1.918897588095185e+01, -9.132469054418541e+00},
	{"UMM", -1.416081694786308e+01, -4.104310121329775e+00},
	{"UMN", -1.498342964273444e+01, -4.926922816201130e+00},
	{"UMO", -1.492856565771918e+01, -4.872058831185864e+00},
	{"UMP", -1.355337276185337e+01, -3.496865935320065e+00},
	{"UMQ", -2.371451343792683e+01, -1.365800661139352e+01},
	{"UMR", -1.773789372030434e+01, -7.681386893771030e+00},
	{"UMS", -1.461584914194798e+01, -4.559342315414672e+00},
	{"UMT", -1.564692061125333e+01, -5.590413784720017e+00},
	{"UMU", -1.491547730284915e+01, -4.858970476315835e+00},
	{"UMV", -1.747037320135945e+01, -7.413866374826139e+00},
	{"UMW", -1.608707866787803e+01, -6.030571841344717e+00},
	{"UMX", -2.371740477301587e+01, -1.366089794648256e+01},
	{"UMY", -1.675292801327481e+01, -6.696421186741502e+00},
	{"UMZ", -3.238917894324113e+01, -2.233267211670783e+01},
	{"UNA", -1.358628691863410e+01, -5.543341858004971e+00},
	{"UNB", -1.529973554567133e+01, -7.256790485042198e+00},
	{"UNC", -1.243391833621768e+01, -4.390973275588544e+00},
	{"UND", -9.745203600109260e+00, -1.702258539480127e+00},
	{"UNE", -1.334371141071702e+01, -5.300766350087886e+00},
	{"UNF", -1.487224052441983e+01, -6.829295463790692e+00},
	{"UNG", -1.225241804837050e+01, -4.209472987741369e+00},
	{"UNH", -1.557713152013330e+01, -7.534186459504173e+00},
	{"UNI", -1.147645533488611e+01, -3.433510274256979e+00},
	{"UNJ", -1.637837314482755e+01, -8.335428084198414e+00},
	{"UNK", -1.439875418410544e+01, -6.355809123476309e+00},
	{"UNL", -1.426296219084606e+01, -6.220017130216925e+00},
	{"UNM", -1.634155513064135e+01, -8.298610070012213e+00},
	{"UNN", -1.419471694306372e+01, -6.151771882434592e+00},
	{"UNO", -1.478249034863651e+01, -6.739545288007379e+00},
	{"UNP", -1.565712266327955e+01, -7.614177602650416e+00},
	{"UNQ", -1.829138697905850e+01, -1.024844191842937e+01},
	{"UNR", -1.575808498299317e+01, -7.715139922364040e+00},
	{"UNS", -1.338282590387761e+01, -5.339880843248481e+00},
	{"UNT", -9.648170268329789e+00, -1.605225207700655e+00},
	{"UNU", -1.630727914309604e+01, -8.264334082466901e+00},
	{"UNV", -1.906833351606448e+01, -1.102538845543535e+01},
	{"UNW", -1.517824055746212e+01, -7.135295496832986e+00},
	{"UNX", -3.065589701685845e+01, -2.261295195622931e+01},
	{"UNY", -1.861642945830375e+01, -1.057348439767462e+01},
	{"UNZ", -3.116460206063804e+01, -2.312165700000891e+01},
	{"UOA", -2.521839524065464e+01, -1.171242832831576e+01},
	{"UOB", -1.960285959414810e+01, -6.096892681809226e+00},
	{"UOC", -2.159820818009266e+01, -8.092241267753778e+00},
	{"UOD", -2.152470951381334e+01, -8.018742601474464e+00},
	{"UOE", -2.636716211825544e+01, -1.286119520591656e+01},
	{"UOF", -1.650829833901723e+01, -3.002331426678355e+00},
	{"UOG", -2.051840918495143e+01, -7.012442272612553e+00},
	{"UOH", -1.978653095950175e+01, -6.280564047162870e+00},
	{"UOI", -2.021860327740952e+01, -6.712636365070642e+00},
	{"UOJ", -2.361351714281549e+01, -1.010755023047661e+01},
	{"UOK", -2.133584777560785e+01, -7.829880863268977e+00},
	{"UOL", -1.859756836874043e+01, -5.091601456401551e+00},
	{"UOM", -2.103537535721696e+01, -7.529408444878078e+00},
	{"UON", -1.701166010345861e+01, -3.505693191119732e+00},
	{"UOO", -2.184785067500472e+01, -8.341883762665841e+00},
	{"UOP", -1.995831011293151e+01, -6.452343200592635e+00},
	{"UOQ", -3.077082871867304e+01, -1.726486180633416e+01},
	{"UOR", -1.725960598791913e+01, -3.753639075580256e+00},
	{"UOS", -2.058427716089652e+01, -7.078310248557647e+00},
	{"UOT", -1.789560085725514e+01, -4.389633944916261e+00},
	{"UOU", -1.447105401272986e+01, -9.650871003909838e-01},
	{"UOV", -1.968090038464775e+01, -6.174933472308878e+00},
	{"UOW", -1.991421512401983e+01, -6.408248211680955e+00},
	{"UOX", -2.932255967826240e+01, -1.581659276592353e+01},
	{"UOY", -1.979671924030517e+01, -6.290752327966289e+00},
	{"UOZ", -3.055144948166955e+01, -1.704548256933067e+01},
	{"UPA", -1.277321208266459e+01, -3.387946521813117e+00},
	{"UPB", -1.549448585561091e+01, -6.109220294759441e+00},
	{"UPC", -1.743271108787063e+01, -8.047445527019153e+00},
	{"UPD", -1.748950012811860e+01, -8.104234567267129e+00},
	{"UPE", -1.405665107881449e+01, -4.671385517963016e+00},
	{"UPF", -1.548008049549245e+01, -6.094814934640977e+00},
	{"UPG", -1.880990822765885e+01, -9.424642666807378e+00},
	{"UPH", -1.440137644166386e+01, -5.016110880812387e+00},
	{"UPI", -1.357359762336570e+01, -4.188332062514225e+00},
	{"UPJ", -1.867418215192869e+01, -9.288916591077223e+00},
	{"UPK", -2.054786646195454e+01, -1.116260090110307e+01},
	{"UPL", -1.497919930861043e+01, -5.593933747758958e+00},
	{"UPM", -1.635140244072454e+01, -6.966136879873071e+00},
	{"UPN", -1.725893064611948e+01, -7.873665085268014e+00},
	{"UPO", -1.097388847260750e+01, -1.588622911756026e+00},
	{"UPP", -1.212296175432214e+01, -2.737696193470671e+00},
	{"UPQ", -2.171791888625194e+01, -1.233265332540047e+01},
	{"UPR", -1.432441673892547e+01, -4.939151178074005e+00},
	{"UPS", -1.469221876403267e+01, -5.306953203181194e+00},
	{"UPT", -1.240748309294164e+01, -3.022217532090174e+00},
	{"UPU", -1.621027954895356e+01, -6.825013988102092e+00},
	{"UPV", -2.039560866763533e+01, -1.101034310678386e+01},
	{"UPW", -1.462575247775713e+01, -5.240486916905656e+00},
	{"UPX", -3.585922293058230e+01, -2.647395736973083e+01},
	{"UPY", -1.652707965585133e+01, -7.141814094999859e+00},
	{"UPZ", -2.271828895189002e+01, -1.333302339103855e+01},
	{"UQA", -2.936380965321135e+01, -1.074154622462061e+01},
	{"UQB", -3.199123160035363e+01, -1.336896817176289e+01},
	{"UQC", -3.090223081825050e+01, -1.227996738965976e+01},
	{"UQD", -3.251293546044355e+01, -1.389067203185281e+01},
	{"UQE", -3.290083000458780e+01, -1.427856657599706e+01},
	{"UQF", -3.125973440384440e+01, -1.263747097525367e+01},
	{"UQG", -3.797655837822591e+01, -1.935429494963517e+01},
	{"UQH", -3.181129306070353e+01, -1.318902963211279e+01},
	{"UQI", -2.770285366859559e+01, -9.080590240004845e+00},
	{"UQJ", -3.377660483584533e+01, -1.515434140725459e+01},
	{"UQK", -3.960874357316465e+01, -2.098648014457391e+01},
	{"UQL", -3.222916313373702e+01, -1.360689970514628e+01},
	{"UQM", -3.143129379200585e+01, -1.280903036341511e+01},
	{"UQN", -3.426061116897459e+01, -1.563834774038385e+01},
	{"UQO", -3.245705699970003e+01, -1.383479357110929e+01},
	{"UQP", -3.245924238612589e+01, -1.383697895753515e+01},
	{"UQQ", -3.434064533486298e+01, -1.571838190627224e+01},
	{"UQR", -3.230594583757775e+01, -1.368368240898700e+01},
	{"UQS", -2.937825799286649e+01, -1.075599456427576e+01},
	{"UQT", -2.987792899680080e+01, -1.125566556821006e+01},
	{"UQU", -1.862911994064772e+01, -6.856512056979755e-03},
	{"UQV", -3.517179901521626e+01, -1.654953558662552e+01},
	{"UQW", -3.153005183936253e+01, -1.290778841077179e+01},
	{"UQX", -4.163187553104758e+01, -2.300961210245684e+01},
	{"UQY", -3.582459573249437e+01, -1.720233230390362e+01},
	{"UQZ", -4.277144296779811e+01, -2.414917953920737e+01},
	{"URA", -1.206977605269543e+01, -4.068305837271787e+00},
	{"URB", -1.362040394341635e+01, -5.618933727992705e+00},
	{"URC", -1.258658530862193e+01, -4.585115093198292e+00},
	{"URD", -1.332318757144139e+01, -5.321717356017748e+00},
	{"URE", -1.017807245502421e+01, -2.176602239600571e+00},
	{"URF", -1.347406604149904e+01, -5.472595826075400e+00},
	{"URG", -1.310555921968467e+01, -5.104089004261032e+00},
	{"URH", -1.389645895545074e+01, -5.894988740027099e+00},
	{"URI", -1.163382031817894e+01, -3.632350102755302e+00},
	{"URJ", -1.754814486723275e+01, -9.546674651809113e+00},
	{"URK", -1.480196771442106e+01, -6.800497498997414e+00},
	{"URL", -1.418478883169169e+01, -6.183318616268045e+00},
	{"URM", -1.391677530750305e+01, -5.915305092079405e+00},
	{"URN", -1.103653501942361e+01, -3.035064803999966e+00},
	{"URO", -1.301777227540075e+01, -5.016302059977110e+00},
	{"URP", -1.281168964084092e+01, -4.810219425417281e+00},
	{"URQ", -1.881123764011842e+01, -1.080976742469477e+01},
	{"URR", -1.263699414760394e+01, -4.635523932180297e+00},
	{"URS", -1.133438264140717e+01, -3.332912425983523e+00},
	{"URT", -1.194154186987118e+01, -3.940071654447536e+00},
	{"URU", -1.575021491395129e+01, -7.748744698527650e+00},
	{"URV", -1.504554873128982e+01, -7.044078515866176e+00},
	{"URW", -1.443024493564936e+01, -6.428774720225714e+00},
	{"URX", -3.055322012704725e+01, -2.255174991162361e+01},
	{"URY", -1.334394084688889e+01, -5.342470631465243e+00},
	{"URZ", -1.971837998316655e+01, -1.171690976774291e+01},
	{"USA", -1.114116989161547e+01, -3.261944694469370e+00},
	{"USB", -1.326916029155859e+01, -5.389935094412495e+00},
	{"USC", -1.305723751485412e+01, -5.178012317708018e+00},
	{"USD", -1.444197977708943e+01, -6.562754579943326e+00},
	{"USE", -9.978047594202977e+00, -2.098822397056878e+00},
	{"USF", -1.376678843930860e+01, -5.887563242162501e+00},
	{"USG", -1.530864592461342e+01, -7.429420727467320e+00},
	{"USH", -1.191346339002847e+01, -4.034238192882374e+00},
	{"USI", -1.187173212546049e+01, -3.992506928314389e+00},
	{"USJ", -1.717896791334812e+01, -9.299742716202021e+00},
	{"USK", -1.585994128900145e+01, -7.980716091855349e+00},
	{"USL", -1.332927754390433e+01, -5.450052346758228e+00},
	{"USM", -1.401580607005299e+01, -6.136580872906888e+00},
	{"USN", -1.390286476723931e+01, -6.023639570093209e+00},
	{"USO", -1.348816511765327e+01, -5.608939920507166e+00},
	{"USP", -1.337131563789726e+01, -5.492090440751162e+00},
	{"USQ", -1.737812712966677e+01, -9.498901932520674e+00},
	{"USR", -1.477249985459294e+01, -6.893274657446840e+00},
	{"USS", -1.212968099847832e+01, -4.250455801332227e+00},
	{"UST", -9.961445718330323e+00, -2.082220521184223e+00},
	{"USU", -1.374590746008898e+01, -5.866682262942883e+00},
	{"USV", -1.640520664638251e+01, -8.525981449236406e+00},
	{"USW", -1.297992231500795e+01, -5.100697117861853e+00},
	{"USX", -2.271084395127130e+01, -1.483161875412520e+01},
	{"USY", -1.542341299256798e+01, -7.544187795421878e+00},
	{"USZ", -2.091061053456962e+01, -1.303138533742352e+01},
	{"UTA", -1.167555418447834e+01, -3.692753641830731e+00},
	{"UTB", -1.385573753820110e+01, -5.872936995553493e+00},
	{"UTC", -1.407447545522390e+01, -6.091674912576297e+00},
	{"UTD", -1.433689410868192e+01, -6.354093566034305e+00},
	{"UTE", -1.106945901567064e+01, -3.086658473023027e+00},
	{"UTF", -1.343891059667696e+01, -5.456110054029353e+00},
	{"UTG", -1.530043803797740e+01, -7.317637495329793e+00},
	{"UTH", -1.086685144162510e+01, -2.884050898977488e+00},
	{"UTI", -1.071308114916578e+01, -2.730280606518167e+00},
	{"UTJ", -1.622671761896939e+01, -8.243917076321781e+00},
	{"UTK", -1.786006972440191e+01, -9.877269181754297e+00},
	{"UTL", -1.411265079516523e+01, -6.129850252517618e+00},
	{"UTM", -1.382056149967255e+01, -5.837760957024943e+00},
	{"UTN", -1.402154466429310e+01, -6.038744121645490e+00},
	{"UTO", -1.150022987784428e+01, -3.517429335196672e+00},
	{"UTP", -1.436972752733052e+01, -6.386926984682912e+00},
	{"UTQ", -1.925890844724513e+01, -1.127610790459752e+01},
	{"UTR", -1.393426408125293e+01, -5.951463538605318e+00},
	{"UTS", -1.275015929102400e+01, -4.767358748376388e+00},
	{"UTT", -1.062628652636701e+01, -2.643485983719398e+00},
	{"UTU", -1.345139186848108e+01, -5.468591325833470e+00},
	{"UTV", -1.763074695899887e+01, -9.647946416351264e+00},
	{"UTW", -1.277509529100505e+01, -4.792294748357441e+00},
	{"UTX", -2.171839462231463e+01, -1.373559407966702e+01},
	{"UTY", -1.350875807366913e+01, -5.525957531021522e+00},
	{"UTZ", -2.054790487821764e+01, -1.256510433557003e+01},
	{"UUA", -2.545159632055113e+01, -9.486164858636032e+00},
	{"UUB", -2.584068584132286e+01, -9.875254379407755e+00},
	{"UUC", -2.502631334363468e+01, -9.060881881719574e+00},
	{"UUD", -2.576649409575866e+01, -9.801062633843561e+00},
	{"UUE", -2.547447326739653e+01, -9.509041805481429e+00},
	{"UUF", -2.742600377074814e+01, -1.146057230883304e+01},
	{"UUG", -2.498209204144288e+01, -9.016660579527780e+00},
	{"UUH", -2.809616081989171e+01, -1.213072935797661e+01},
	{"UUI", -2.335409118372407e+01, -7.388659721808972e+00},
	{"UUJ", -3.238390621657092e+01, -1.641847475465582e+01},
	{"UUK", -2.858656243269970e+01, -1.262113097078460e+01},
	{"UUL", -2.384918349811294e+01, -7.883752036197842e+00},
	{"UUM", -1.889558515292035e+01, -2.930153691005247e+00},
	{"UUN", -1.725483416875197e+01, -1.289402706836863e+00},
	{"UUO", -2.872921365135444e+01, -1.276378218943934e+01},
	{"UUP", -1.764264147930826e+01, -1.677210017393160e+00},
	{"UUQ", -3.384551016760631e+01, -1.788007870569120e+01},
	{"UUR", -2.322471695443921e+01, -7.259285492524106e+00},
	{"UUS", -1.929173229012321e+01, -3.326300828208104e+00},
	{"UUT", -2.157355942324099e+01, -5.608127961325883e+00},
	{"UUU", -3.118867820093067e+01, -1.522324673901556e+01},
	{"UUV", -3.053097585106745e+01, -1.456554438915234e+01},
	{"UUW", -2.821106705872974e+01, -1.224563559681464e+01},
	{"UUX", -3.080646671161263e+01, -1.484103524969752e+01},
	{"UUY", -2.995746170014144e+01, -1.399203023822634e+01},
	{"UUZ", -3.042947680184625e+01, -1.446404533993114e+01},
	{"UVA", -2.015171907627065e+01, -4.843989964218770e+00},
	{"UVB", -3.294178627808925e+01, -1.763405716603737e+01},
	{"UVC", -3.308548515007084e+01, -1.777775603801896e+01},
	{"UVD", -3.238621473917348e+01, -1.707848562712161e+01},
	{"UVE", -1.607938541487922e+01, -7.716563028273431e-01},
	{"UVF", -3.259056198446102e+01, -1.728283287240914e+01},
	{"UVG", -3.389895437178250e+01, -1.859122525973063e+01},
	{"UVH", -3.161379534721096e+01, -1.630606623515908e+01},
	{"UVI", -1.789579686154529e+01, -2.588067749493407e+00},
	{"UVJ", -3.382181207242312e+01, -1.851408296037124e+01},
	{"UVK", -3.570141269520144e+01, -2.039368358314956e+01},
	{"UVL", -3.297365576688694e+01, -1.766592665483507e+01},
	{"UVM", -2.271897632658983e+01, -7.411247214537947e+00},
	{"UVN", -3.107135716335362e+01, -1.576362805130174e+01},
	{"UVO", -2.007135350714901e+01, -4.763624395097133e+00},
	{"UVP", -3.205676555359691e+01, -1.674903644154503e+01},
	{"UVQ", -3.965360746853693e+01, -2.434587835648505e+01},
	{"UVR", -1.788814273018454e+01, -2.580413618132656e+00},
	{"UVS", -3.103965172556445e+01, -1.573192261351257e+01},
	{"UVT", -3.036648619342094e+01, -1.505875708136906e+01},
	{"UVU", -2.370221083270566e+01, -8.394481720653783e+00},
	{"UVV", -3.454718463414780e+01, -1.923945552209593e+01},
	{"UVW", -3.168994426199017e+01, -1.638221514993829e+01},
	{"UVX", -3.627942828563359e+01, -2.097169917358170e+01},
	{"UVY", -2.810227072160415e+01, -1.279454160955227e+01},
	{"UVZ", -3.968930716819131e+01, -2.438157805613942e+01},
	{"UWA", -1.555590194266362e+01, -2.568081622949442e+00},
	{"UWB", -2.877329462801726e+01, -1.578547430830309e+01},
	{"UWC", -2.883118624694455e+01, -1.584336592723037e+01},
	{"UWD", -2.834467624706827e+01, -1.535685592735410e+01},
	{"UWE", -1.626517825336358e+01, -3.277357933649405e+00},
	{"UWF", -2.862626403320400e+01, -1.563844371348982e+01},
	{"UWG", -2.975300746318966e+01, -1.676518714347548e+01},
	{"UWH", -1.567161628440155e+01, -2.683795964687377e+00},
	{"UWI", -1.430238769758279e+01, -1.314567377868613e+00},
	{"UWJ", -3.110970192600707e+01, -1.812188160629290e+01},
	{"UWK", -3.126471438953308e+01, -1.827689406981891e+01},
	{"UWL", -2.769474665003456e+01, -1.470692633032039e+01},
	{"UWM", -2.839557888614205e+01, -1.540775856642787e+01},
	{"UWN", -2.526986884753881e+01, -1.228204852782464e+01},
	{"UWO", -1.561692361133152e+01, -2.629103291617350e+00},
	{"UWP", -2.948344255317196e+01, -1.649562223345778e+01},
	{"UWQ", -3.373706369988309e+01, -2.074924338016891e+01},
	{"UWR", -2.024549575934231e+01, -7.257675439628137e+00},
	{"UWS", -2.653004119631359e+01, -1.354222087659942e+01},
	{"UWT", -2.640006346145584e+01, -1.341224314174167e+01},
	{"UWU", -2.212738651216613e+01, -9.139566192451959e+00},
	{"UWV", -3.158723706252827e+01, -1.859941674281409e+01},
	{"UWW", -2.761925650161855e+01, -1.463143618190438e+01},
	{"UWX", -4.093086996600850e+01, -2.794304964629432e+01},
	{"UWY", -2.856779215687782e+01, -1.557997183716364e+01},
	{"UWZ", -3.445385361664766e+01, -2.146603329693348e+01},
	{"UXA", -1.912833992406453e+01, -3.545119951467470e+00},
	{"UXB", -2.717965804040689e+01, -1.159643806780984e+01},
	{"UXC", -2.091694752068752e+01, -5.333727548090466e+00},
	{"UXD", -2.657330327211110e+01, -1.099008329951405e+01},
	{"UXE", -1.948737140698924e+01, -3.904151434392187e+00},
	{"UXF", -2.671536181963804e+01, -1.113214184704098e+01},
	{"UXG", -2.801363372460908e+01, -1.243041375201202e+01},
	{"UXH", -2.122780194087620e+01, -5.644581968279142e+00},
	{"UXI", -1.844304014160370e+01, -2.859820169006646e+00},
	{"UXJ", -2.922484431924903e+01, -1.364162434665197e+01},
	{"UXK", -2.171849929579225e+01, -6.135279323195196e+00},
	{"UXL", -2.000804095877404e+01, -4.424820986176986e+00},
	{"UXM", -2.134075045575269e+01, -5.757530483155636e+00},
	{"UXN", -2.366980079562856e+01, -8.086580823031507e+00},
	{"UXO", -1.944322084927410e+01, -3.860000876677044e+00},
	{"UXP", -2.158918821743158e+01, -6.005968244834521e+00},
	{"UXQ", -2.812823403002064e+01, -1.254501405742359e+01},
	{"UXR", -2.355539431923020e+01, -7.972174346633137e+00},
	{"UXS", -2.165206071319297e+01, -6.068840740595915e+00},
	{"UXT", -1.913519190687252e+01, -3.551971934275465e+00},
	{"UXU", -1.719378318256357e+01, -1.610563209966512e+00},
	{"UXV", -2.064374281542418e+01, -5.060522842827118e+00},
	{"UXW", -2.052150473697466e+01, -4.938284764377601e+00},
	{"UXX", -2.565871885141811e+01, -1.007549887882106e+01},
	{"UXY", -2.584519553007178e+01, -1.026197555747473e+01},
	{"UXZ", -3.966525378292024e+01, -2.408203381032319e+01},
	{"UYA", -1.819543089616632e+01, -3.461215935040443e+00},
	{"UYB", -2.095481172632972e+01, -6.220596765203845e+00},
	{"UYC", -2.059400596155466e+01, -5.859791000428782e+00},
	{"UYD", -2.306550966586583e+01, -8.331294704739951e+00},
	{"UYE", -1.705153246150314e+01, -2.317317500377266e+00},
	{"UYF", -1.957383668757289e+01, -4.839621726447013e+00},
	{"UYG", -2.250171002824110e+01, -7.767495067115221e+00},
	{"UYH", -1.965035820572145e+01, -4.916143244595579e+00},
	{"UYI", -1.754440718755661e+01, -2.810192226430734e+00},
	{"UYJ", -2.740104916880054e+01, -1.266683420767466e+01},
	{"UYK", -2.719773238880551e+01, -1.246351742767963e+01},
	{"UYL", -2.063601495010653e+01, -5.901799988980657e+00},
	{"UYM", -2.076601965532429e+01, -6.031804694198411e+00},
	{"UYN", -2.130380672066292e+01, -6.569591759537042e+00},
	{"UYO", -1.679898013656630e+01, -2.064765175440423e+00},
	{"UYP", -2.229421847302713e+01, -7.560003511901253e+00},
	{"UYQ", -2.931748032689339e+01, -1.458326536576751e+01},
	{"UYR", -2.311544445749331e+01, -8.381229496367441e+00},
	{"UYS", -1.881185323429550e+01, -4.077638273169628e+00},
	{"UYT", -1.828536114066913e+01, -3.551146179543252e+00},
	{"UYU", -2.257576801515867e+01, -7.841553054032798e+00},
	{"UYV", -2.709213855617662e+01, -1.235792359505074e+01},
	{"UYW", -2.069788965303101e+01, -5.963674691905133e+00},
	{"UYX", -3.140041149237202e+01, -1.666619653124614e+01},
	{"UYY", -2.261199669996511e+01, -7.877781738839232e+00},
	{"UYZ", -3.073447363866893e+01, -1.600025867754306e+01},
	{"UZA", -1.795410581708012e+01, -2.747875754249440e+00},
	{"UZB", -2.357149476249892e+01, -8.365264699668241e+00},
	{"UZC", -2.363849602476951e+01, -8.432265961938835e+00},
	{"UZD", -2.090503813906267e+01, -5.698808076231988e+00},
	{"UZE", -1.911034189430903e+01, -3.904111831478351e+00},
	{"UZF", -2.267803033892928e+01, -7.471800276098596e+00},
	{"UZG", -2.138764237192231e+01, -6.181412309091637e+00},
	{"UZH", -2.038391330356231e+01, -5.177683240731634e+00},
	{"UZI", -1.980894825712927e+01, -4.602718194298592e+00},
	{"UZJ", -3.077704049294695e+01, -1.557081043011628e+01},
	{"UZK", -2.941809831460672e+01, -1.421186825177604e+01},
	{"UZL", -2.196421238253089e+01, -6.757982319700206e+00},
	{"UZM", -2.137635767242667e+01, -6.170127609595997e+00},
	{"UZN", -2.842295718303921e+01, -1.321672712020853e+01},
	{"UZO", -2.108488853284735e+01, -5.878658470016668e+00},
	{"UZP", -2.205526302844351e+01, -6.849032965612833e+00},
	{"UZQ", -3.470235231702008e+01, -1.949612225418940e+01},
	{"UZR", -2.334160455390644e+01, -8.135374491075760e+00},
	{"UZS", -2.111353586683739e+01, -5.907305804006714e+00},
	{"UZT", -1.999098519189205e+01, -4.784755129061367e+00},
	{"UZU", -2.064804185192730e+01, -5.441811789096623e+00},
	{"UZV", -2.786983312116437e+01, -1.266360305833370e+01},
	{"UZW", -2.069645713395992e+01, -5.490227071129241e+00},
	{"UZX", -3.751048887846492e+01, -2.230425881563424e+01},
	{"UZY", -2.164670922996517e+01, -6.440479167134490e+00},
	{"UZZ", -1.618173379082005e+01, -9.755037279893682e-01},
	{"VAA", -1.807190209251984e+01, -7.870528122429001e+00},
	{"VAB", -1.692902477301060e+01, -6.727650802919762e+00},
	{"VAC", -1.617140890613782e+01, -5.970034936046978e+00},
	{"VAD", -1.553813919203729e+01, -5.336765221946455e+00},
	{"VAE", -1.962150458926762e+01, -9.420130619176778e+00},
	{"VAF", -1.937392010211129e+01, -9.172546132020452e+00},
	{"VAG", -1.510180012170298e+01, -4.900426151612144e+00},
	{"VAH", -1.842640470557421e+01, -8.225030735483378e+00},
	{"VAI", -1.374841443397085e+01, -3.547040463880010e+00},
	{"VAJ", -2.367862887266735e+01, -1.347725490257651e+01},
	{"VAK", -2.159517268226438e+01, -1.139379871217354e+01},
	{"VAL", -1.241012753710900e+01, -2.208753567018165e+00},
	{"VAM", -1.872272345206656e+01, -8.521349481975728e+00},
	{"VAN", -1.207170195705952e+01, -1.870327986968677e+00},
	{"VAO", -1.990749757079022e+01, -9.706123600699383e+00},
	{"VAP", -1.627140244320243e+01, -6.070028473111598e+00},
	{"VAQ", -2.876834896910187e+01, -1.856697499901103e+01},
	{"VAR", -1.341188804044725e+01, -3.210514070356415e+00},
	{"VAS", -1.451082957480807e+01, -4.309455604717230e+00},
	{"VAT", -1.298685577542563e+01, -2.785481805334790e+00},
	{"VAU", -1.775718175255321e+01, -7.555807782462375e+00},
	{"VAV", -2.121787863659267e+01, -1.101650466650183e+01},
	{"VAW", -1.969117275064244e+01, -9.489798780551606e+00},
	{"VAX", -2.269482834338383e+01, -1.249345437329299e+01},
	{"VAY", -2.425278586965771e+01, -1.405141189956687e+01},
	{"VAZ", -2.859180731595206e+01, -1.839043334586123e+01},
	{"VBA", -2.431975537618371e+01, -5.093631888211761e+00},
	{"VBB", -2.779104730921910e+01, -8.564923821247152e+00},
	{"VBC", -2.849316351987660e+01, -9.267040031904648e+00},
	{"VBD", -2.979591399103873e+01, -1.056979050306678e+01},
	{"VBE", -2.143595095862428e+01, -2.209827470652330e+00},
	{"VBF", -3.138923278451075e+01, -1.216310929653880e+01},
	{"VBG", -3.294520588216085e+01, -1.371908239418890e+01},
	{"VBH", -3.023087433429059e+01, -1.100475084631864e+01},
	{"VBI", -2.512431922299196e+01, -5.898195735020018e+00},
	{"VBJ", -2.778623809330773e+01, -8.560114605335787e+00},
	{"VBK", -3.324157082879783e+01, -1.401544734082588e+01},
	{"VBL", -2.387241063680935e+01, -4.646287148837394e+00},
	{"VBM", -2.956011129004303e+01, -1.033398780207107e+01},
	{"VBN", -3.033915896420240e+01, -1.111303547623046e+01},
	{"VBO", -2.382051860341140e+01, -4.594395115439457e+00},
	{"VBP", -3.105080148246144e+01, -1.182467799448949e+01},
	{"VBQ", -3.710896190024489e+01, -1.788283841227295e+01},
	{"VBR", -2.300783517586805e+01, -3.781711687896098e+00},
	{"VBS", -2.636603846368763e+01, -7.139914975715679e+00},
	{"VBT", -2.704047782590080e+01, -7.814354337928860e+00},
	{"VBU", -2.114420819768920e+01, -1.918084709717245e+00},
	{"VBV", -3.102346852969566e+01, -1.179734504172371e+01},
	{"VBW", -3.043203157075202e+01, -1.120590808278008e+01},
	{"VBX", -4.039616973948549e+01, -2.117004625151355e+01},
	{"VBY", -2.097773405442515e+01, -1.751610566453197e+00},
	{"VBZ", -3.490427361525290e+01, -1.567815012728095e+01},
	{"VCA", -2.172626753118870e+01, -2.310787715876540e+00},
	{"VCB", -3.095658876485790e+01, -1.154110894954575e+01},
	{"VCC", -2.618735379641799e+01, -6.771873981105833e+00},
	{"VCD", -2.993053311474605e+01, -1.051505329943389e+01},
	{"VCE", -2.328931270744543e+01, -3.873832892133274e+00},
	{"VCF", -3.081539889860081e+01, -1.139991908328866e+01},
	{"VCG", -3.177095035003096e+01, -1.235547053471880e+01},
	{"VCH", -2.162929430678134e+01, -2.213814491469190e+00},
	{"VCI", -2.486133397334056e+01, -5.445854158028410e+00},
	{"VCJ", -2.373592940064271e+01, -4.320449585330559e+00},
	{"VCK", -2.544936867727901e+01, -6.033888861966863e+00},
	{"VCL", -2.552701382392096e+01, -6.111534008608805e+00},
	{"VCM", -3.072353997945734e+01, -1.130806016414518e+01},
	{"VCN", -3.158984501508241e+01, -1.217436519977025e+01},
	{"VCO", -2.102061354547804e+01, -1.605133730165888e+00},
	{"VCP", -3.000848857367561e+01, -1.059300875836346e+01},
	{"VCQ", -3.011948073214200e+01, -1.070400091682984e+01},
	{"VCR", -2.544902762778727e+01, -6.033547812475111e+00},
	{"VCS", -2.859982968363917e+01, -9.184349868327011e+00},
	{"VCT", -2.423807827185249e+01, -4.822598456540335e+00},
	{"VCU", -2.559987660141377e+01, -6.184396786101606e+00},
	{"VCV", -3.338461262148292e+01, -1.396913280617076e+01},
	{"VCW", -2.909287645081855e+01, -9.677396635506394e+00},
	{"VCX", -3.459548265931168e+01, -1.518000284399952e+01},
	{"VCY", -2.769710325139322e+01, -8.281623436081061e+00},
	{"VCZ", -3.333901818267353e+01, -1.392353836736137e+01},
	{"VDA", -2.335703525459387e+01, -4.686483305537686e+00},
	{"VDB", -2.314142939871615e+01, -4.470877449659961e+00},
	{"VDC", -2.589510541927956e+01, -7.224553470223377e+00},
	{"VDD", -2.568645400342267e+01, -7.015902054366485e+00},
	{"VDE", -2.078411812572806e+01, -2.113566176671873e+00},
	{"VDF", -2.540287490136000e+01, -6.732322952303818e+00},
	{"VDG", -2.612981147204860e+01, -7.459259522992411e+00},
	{"VDH", -2.475591465560118e+01, -6.085362706544992e+00},
	{"VDI", -2.127637780245783e+01, -2.605825853401643e+00},
	{"VDJ", -2.775770946263267e+01, -9.087157513576486e+00},
	{"VDK", -2.893455528300848e+01, -1.026400333395229e+01},
	{"VDL", -2.595837551431175e+01, -7.287823565255565e+00},
	{"VDM", -2.551198238184296e+01, -6.841430432786769e+00},
	{"VDN", -2.578101885131077e+01, -7.110466902254585e+00},
	{"VDO", -2.114581030291813e+01, -2.475258353861944e+00},
	{"VDP", -2.616873532477226e+01, -7.498183375716078e+00},
	{"VDQ", -3.037844681352200e+01, -1.170789486446582e+01},
	{"VDR", -2.246357271628819e+01, -3.793020767232003e+00},
	{"VDS", -2.287127336300023e+01, -4.200721413944041e+00},
	{"VDT", -2.311698239834300e+01, -4.446430449286814e+00},
	{"VDU", -2.247277096284769e+01, -3.802219013791507e+00},
	{"VDV", -2.746371660726897e+01, -8.793164658212790e+00},
	{"VDW", -2.483577164255032e+01, -6.165219693494131e+00},
	{"VDX", -3.527763711479621e+01, -1.660708516574001e+01},
	{"VDY", -2.620443971378601e+01, -7.533887764729826e+00},
	{"VDZ", -3.136007891511470e+01, -1.268952696605851e+01},
	{"VEA", -1.191416772136651e+01, -4.660979588360118e+00},
	{"VEB", -1.251085393945361e+01, -5.257665806447213e+00},
	{"VEC", -1.358032720807226e+01, -6.327139075065870e+00},
	{"VED", -1.104759872484404e+01, -3.794410591837645e+00},
	{"VEE", -1.428841509076753e+01, -7.035226957761142e+00},
	{"VEF", -1.338592180270670e+01, -6.132733669700301e+00},
	{"VEG", -1.411996229397662e+01, -6.866774160970229e+00},
	{"VEH", -1.280846497892883e+01, -5.555276845922434e+00},
	{"VEI", -1.275304960495991e+01, -5.499861471953512e+00},
	{"VEJ", -1.674090727497395e+01, -9.487719141967560e+00},
	{"VEK", -1.652764864636750e+01, -9.274460513361110e+00},
	{"VEL", -1.205067757165512e+01, -4.797489438648723e+00},
	{"VEM", -1.266889348414507e+01, -5.415705351138677e+00},
	{"VEN", -1.002010653588447e+01, -2.766918402878073e+00},
	{"VEO", -1.309507555431057e+01, -5.841887421304178e+00},
	{"VEP", -1.387215306864218e+01, -6.618964935635784e+00},
	{"VEQ", -1.896008252888651e+01, -1.170689439588012e+01},
	{"VER", -8.760268602220425e+00, -1.507080469214032e+00},
	{"VES", -1.074313261774943e+01, -3.489944484743038e+00},
	{"VET", -1.118767709702584e+01, -3.934488964019443e+00},
	{"VEU", -1.450639107831511e+01, -7.253202945308719e+00},
	{"VEV", -1.644749758807508e+01, -9.194309455068684e+00},
	{"VEW", -1.373179321857189e+01, -6.478605085565498e+00},
	{"VEX", -1.685806654139527e+01, -9.604878408388876e+00},
	{"VEY", -1.366694314885301e+01, -6.413755015846618e+00},
	{"VEZ", -2.139245793529806e+01, -1.413926980229167e+01},
	{"VFA", -2.299563110890445e+01, -4.120731914560731e+00},
	{"VFB", -2.747176284849406e+01, -8.596863654150333e+00},
	{"VFC", -2.688563499781883e+01, -8.010735803475107e+00},
	{"VFD", -2.776760788860829e+01, -8.892708694264572e+00},
	{"VFE", -2.189856114988871e+01, -3.023661955544990e+00},
	{"VFF", -2.519733753038259e+01, -6.322438336038870e+00},
	{"VFG", -2.742217740844168e+01, -8.547278214097958e+00},
	{"VFH", -2.622265496865716e+01, -7.347755774313439e+00},
	{"VFI", -2.150689878653878e+01, -2.631999592195060e+00},
	{"VFJ", -2.821047198238376e+01, -9.335572788040038e+00},
	{"VFK", -3.010665274733329e+01, -1.123175355298957e+01},
	{"VFL", -2.591298492941716e+01, -7.038085735073436e+00},
	{"VFM", -2.655383895940739e+01, -7.678939765063674e+00},
	{"VFN", -2.817539386697469e+01, -9.300494672630967e+00},
	{"VFO", -2.068685805315040e+01, -1.811958858806676e+00},
	{"VFP", -2.708587181392265e+01, -8.210972619578929e+00},
	{"VFQ", -3.235349831760586e+01, -1.347859912326214e+01},
	{"VFR", -2.081337215630956e+01, -1.938472961965843e+00},
	{"VFS", -2.641345863102068e+01, -7.538559436676969e+00},
	{"VFT", -2.339439387402177e+01, -4.519494679678049e+00},
	{"VFU", -2.586103403995147e+01, -6.986134845607753e+00},
	{"VFV", -2.938748061091031e+01, -1.051258141656659e+01},
	{"VFW", -2.713979553550898e+01, -8.264896341165258e+00},
	{"VFX", -3.466486982193938e+01, -1.578997062759565e+01},
	{"VFY", -2.778232787971534e+01, -8.907428685371620e+00},
	{"VFZ", -3.079346328146590e+01, -1.191856408712218e+01},
	{"VGA", -2.493950892778800e+01, -4.756217346122800e+00},
	{"VGB", -2.819974619327508e+01, -8.016454611609877e+00},
	{"VGC", -2.845077275328450e+01, -8.267481171619298e+00},
	{"VGD", -2.832187780674359e+01, -8.138586225078379e+00},
	{"VGE", -2.104997784118024e+01, -8.666862595150322e-01},
	{"VGF", -2.800545658198626e+01, -7.822165000321062e+00},
	{"VGG", -2.814694672202446e+01, -7.963655140359257e+00},
	{"VGH", -2.466941117379012e+01, -4.486119592124919e+00},
	{"VGI", -2.548284439475224e+01, -5.299552813087036e+00},
	{"VGJ", -3.167479732996798e+01, -1.149150574830277e+01},
	{"VGK", -3.191311126326522e+01, -1.172981968160001e+01},
	{"VGL", -2.655665666671429e+01, -6.373365085049093e+00},
	{"VGM", -2.795724159758844e+01, -7.773950015923233e+00},
	{"VGN", -2.707007335497178e+01, -6.886781773306573e+00},
	{"VGO", -2.323721233901069e+01, -3.053920757345489e+00},
	{"VGP", -2.844303375449023e+01, -8.259742172825025e+00},
	{"VGQ", -3.320619035788328e+01, -1.302289877621808e+01},
	{"VGR", -2.335475292109740e+01, -3.171461339432196e+00},
	{"VGS", -2.628301052444037e+01, -6.099718942775169e+00},
	{"VGT", -2.539572273992027e+01, -5.212431158255065e+00},
	{"VGU", -2.636808752123943e+01, -6.184795939574227e+00},
	{"VGV", -3.104663213980378e+01, -1.086334055813857e+01},
	{"VGW", -2.762777576777577e+01, -7.444484186110564e+00},
	{"VGX", -3.642501082433064e+01, -1.624171924266544e+01},
	{"VGY", -2.839962097914321e+01, -8.216329397478008e+00},
	{"VGZ", -3.501326433836287e+01, -1.482997275669766e+01},
	{"VHA", -1.866239989888578e+01, -7.642673417921225e-01},
	{"VHB", -2.900985789159134e+01, -1.111172533449768e+01},
	{"VHC", -2.898183400466418e+01, -1.108370144757053e+01},
	{"VHD", -2.946128703149053e+01, -1.156315447439688e+01},
	{"VHE", -1.991117921650944e+01, -2.013046659415786e+00},
	{"VHF", -2.899651911070013e+01, -1.109838655360648e+01},
	{"VHG", -2.998012613704224e+01, -1.208199357994859e+01},
	{"VHH", -2.791720920163598e+01, -1.001907664454232e+01},
	{"VHI", -2.222625065487205e+01, -4.328118097778399e+00},
	{"VHJ", -3.189855616617220e+01, -1.400042360907855e+01},
	{"VHK", -3.222215955488961e+01, -1.432402699779595e+01},
	{"VHL", -2.952093070283887e+01, -1.162279814574522e+01},
	{"VHM", -2.852185731151535e+01, -1.062372475442169e+01},
	{"VHN", -2.943285923835090e+01, -1.153472668125724e+01},
	{"VHO", -2.154108462319068e+01, -3.642952066097020e+00},
	{"VHP", -2.936569429021710e+01, -1.146756173312345e+01},
	{"VHQ", -3.365455405806118e+01, -1.575642150096753e+01},
	{"VHR", -2.359229290454533e+01, -5.694160347451675e+00},
	{"VHS", -2.797015794318078e+01, -1.007202538608713e+01},
	{"VHT", -2.548911673489149e+01, -7.590984177797832e+00},
	{"VHU", -2.736089564252129e+01, -9.462763085427632e+00},
	{"VHV", -3.213729075530141e+01, -1.423915819820775e+01},
	{"VHW", -2.810801131601565e+01, -1.020987875892200e+01},
	{"VHX", -3.765049108700434e+01, -1.975235852991069e+01},
	{"VHY", -2.754649221202480e+01, -9.648359654931145e+00},
	{"VHZ", -3.466237333287805e+01, -1.676424077578439e+01},
	{"VIA", -1.439069190557952e+01, -5.159913186405003e+00},
	{"VIB", -1.626545490088233e+01, -7.034676181707817e+00},
	{"VIC", -1.253231823025566e+01, -3.301539511081140e+00},
	{"VID", -1.198532578105750e+01, -2.754547061882983e+00},
	{"VIE", -1.366896009442625e+01, -4.438181375251734e+00},
	{"VIF", -1.950593341091324e+01, -1.027515469173872e+01},
	{"VIG", -1.494138469294332e+01, -5.710605973768804e+00},
	{"VIH", -1.931967830337733e+01, -1.008889958420281e+01},
	{"VII", -1.605306153005857e+01, -6.822282810884053e+00},
	{"VIJ", -3.062569652638096e+01, -2.139491780720644e+01},
	{"VIK", -2.135752877502938e+01, -1.212675005585487e+01},
	{"VIL", -1.210338874164647e+01, -2.872610022471949e+00},
	{"VIM", -1.890969276809268e+01, -9.678914048918164e+00},
	{"VIN", -1.142633230177690e+01, -2.195553582602384e+00},
	{"VIO", -1.331731080723206e+01, -4.086532088057543e+00},
	{"VIP", -1.842482538264981e+01, -9.194046663475291e+00},
	{"VIQ", -2.929342585736291e+01, -2.006264713818840e+01},
	{"VIR", -1.358292065302069e+01, -4.352141933846177e+00},
	{"VIS", -1.268728441889253e+01, -3.456505699718014e+00},
	{"VIT", -1.330071211337636e+01, -4.069933394201843e+00},
	{"VIU", -1.645089370436530e+01, -7.220114985190782e+00},
	{"VIV", -1.556568514870457e+01, -6.334906429530055e+00},
	{"VIW", -1.854337618184458e+01, -9.312597462670066e+00},
	{"VIX", -2.780539493391182e+01, -1.857461621473731e+01},
	{"VIY", -2.171810191844911e+01, -1.248732319927459e+01},
	{"VIZ", -1.842951625918871e+01, -9.198737540014189e+00},
	{"VJA", -2.227626624109585e+01, -2.170116958790032e+00},
	{"VJB", -2.984497176442972e+01, -9.738822482123897e+00},
	{"VJC", -3.069436141192625e+01, -1.058821212962043e+01},
	{"VJD", -3.258851899418969e+01, -1.248236971188387e+01},
	{"VJE", -2.255483119971219e+01, -2.448681917406371e+00},
	{"VJF", -3.171220489059398e+01, -1.160605560828816e+01},
	{"VJG", -3.129674578673325e+01, -1.119059650442743e+01},
	{"VJH", -3.048288879342536e+01, -1.037673951111953e+01},
	{"VJI", -2.655384838124482e+01, -6.447699098939002e+00},
	{"VJJ", -3.048868150972491e+01, -1.038253222741909e+01},
	{"VJK", -3.317725301759620e+01, -1.307110373529038e+01},
	{"VJL", -3.168608588683281e+01, -1.157993660452699e+01},
	{"VJM", -2.380174193171810e+01, -3.695592649412277e+00},
	{"VJN", -3.499208098921288e+01, -1.488593170690706e+01},
	{"VJO", -2.248127244546915e+01, -2.375123163163331e+00},
	{"VJP", -3.145386352337929e+01, -1.134771424107347e+01},
	{"VJQ", -3.444011526430517e+01, -1.433396598199935e+01},
	{"VJR", -3.066429000112562e+01, -1.055814071881979e+01},
	{"VJS", -3.110307881765423e+01, -1.099692953534841e+01},
	{"VJT", -3.118581737247658e+01, -1.107966809017076e+01},
	{"VJU", -2.181622627904747e+01, -1.710076996741645e+00},
	{"VJV", -3.805916848390603e+01, -1.795301920160020e+01},
	{"VJW", -3.042670036744625e+01, -1.032055108514043e+01},
	{"VJX", -4.073847389097485e+01, -2.063232460866903e+01},
	{"VJY", -3.720834464181947e+01, -1.710219535951365e+01},
	{"VJZ", -3.531334573527790e+01, -1.520719645297208e+01},
	{"VKA", -2.801559596429336e+01, -6.029846059209216e+00},
	{"VKB", -3.032769242727145e+01, -8.341942522187317e+00},
	{"VKC", -3.075956580959524e+01, -8.773815904511105e+00},
	{"VKD", -3.139277402198075e+01, -9.407024116896608e+00},
	{"VKE", -2.555591606259335e+01, -3.570166157509205e+00},
	{"VKF", -3.022410076539360e+01, -8.238350860309454e+00},
	{"VKG", -3.249670154271075e+01, -1.051095163762660e+01},
	{"VKH", -2.989440091958073e+01, -7.908651014496594e+00},
	{"VKI", -2.230965461348761e+01, -3.239047084034716e-01},
	{"VKJ", -3.407487602411118e+01, -1.208912611902704e+01},
	{"VKK", -3.340660611656348e+01, -1.142085621147934e+01},
	{"VKL", -2.978523467669090e+01, -7.799484771606762e+00},
	{"VKM", -3.075960331863562e+01, -8.773853413551480e+00},
	{"VKN", -2.753332616734560e+01, -5.547576262261459e+00},
	{"VKO", -2.838486429325808e+01, -6.399114388173938e+00},
	{"VKP", -3.111054296410180e+01, -9.124793059017659e+00},
	{"VKQ", -3.675401581868426e+01, -1.476826591360012e+01},
	{"VKR", -3.154614725960659e+01, -9.560397354522449e+00},
	{"VKS", -2.766445354181904e+01, -5.678703636734895e+00},
	{"VKT", -2.842934104899821e+01, -6.443591143914078e+00},
	{"VKU", -3.027740665175337e+01, -8.291656746669233e+00},
	{"VKV", -3.391503108995587e+01, -1.192928118487174e+01},
	{"VKW", -2.960084931294812e+01, -7.615099407863981e+00},
	{"VKX", -3.772606268457752e+01, -1.574031277949338e+01},
	{"VKY", -3.027107044963881e+01, -8.285320544554668e+00},
	{"VKZ", -3.582792557044726e+01, -1.384217566536312e+01},
	{"VLA", -2.318984238969953e+01, -3.931849412929889e+00},
	{"VLB", -2.773974058011563e+01, -8.481747603345983e+00},
	{"VLC", -2.835161798456942e+01, -9.093625007799771e+00},
	{"VLD", -2.565240293152333e+01, -6.394409954753687e+00},
	{"VLE", -2.230684493468572e+01, -3.048851957916083e+00},
	{"VLF", -2.749096390617936e+01, -8.232970929409719e+00},
	{"VLG", -2.917563031054784e+01, -9.917637333778201e+00},
	{"VLH", -2.860749353699061e+01, -9.349500560220973e+00},
	{"VLI", -2.316701509415903e+01, -3.909022117389382e+00},
	{"VLJ", -3.190765792783607e+01, -1.264966495106643e+01},
	{"VLK", -2.917995483114634e+01, -9.921961854376692e+00},
	{"VLL", -2.443203479895078e+01, -5.174041822181139e+00},
	{"VLM", -2.825471604381688e+01, -8.996723067047245e+00},
	{"VLN", -2.896412982562882e+01, -9.706136848859176e+00},
	{"VLO", -1.987161302731306e+01, -6.136200505434233e-01},
	{"VLP", -2.824031067681000e+01, -8.982317700040362e+00},
	{"VLQ", -3.299636218266591e+01, -1.373836920589627e+01},
	{"VLR", -2.877099676753579e+01, -9.513003790766149e+00},
	{"VLS", -2.653733370962768e+01, -7.279340732858043e+00},
	{"VLT", -2.601813647745466e+01, -6.760143500685015e+00},
	{"VLU", -2.714209436897877e+01, -7.884101392209123e+00},
	{"VLV", -2.854032272968353e+01, -9.282329752913885e+00},
	{"VLW", -2.823713907854308e+01, -8.979146101773431e+00},
	{"VLX", -3.629833036679342e+01, -1.704033739002377e+01},
	{"VLY", -2.562192108936184e+01, -6.363928112592195e+00},
	{"VLZ", -3.495982083990918e+01, -1.570182786313954e+01},
	{"VMA", -2.051775906264201e+01, -2.249303304244213e+00},
	{"VMB", -2.160236086665344e+01, -3.333905108255633e+00},
	{"VMC", -2.780457727969442e+01, -9.536121521296614e+00},
	{"VMD", -2.797283741382946e+01, -9.704381655431655e+00},
	{"VME", -1.966088970130065e+01, -1.392433942902843e+00},
	{"VMF", -2.731609013232055e+01, -9.047634373922747e+00},
	{"VMG", -2.896886544223070e+01, -1.070040968383290e+01},
	{"VMH", -2.693771121833497e+01, -8.669255459937164e+00},
	{"VMI", -2.112548459853436e+01, -2.857028840136558e+00},
	{"VMJ", -3.039020265802574e+01, -1.212174689962793e+01},
	{"VMK", -3.070556917274190e+01, -1.243711341434410e+01},
	{"VML", -2.822465469418350e+01, -9.956198935785700e+00},
	{"VMM", -2.524712213887674e+01, -6.978666380478934e+00},
	{"VMN", -2.718228102809399e+01, -8.913825269696190e+00},
	{"VMO", -2.346460749929632e+01, -5.196151740898520e+00},
	{"VMP", -2.437922523380178e+01, -6.110769475403980e+00},
	{"VMQ", -3.331388590315936e+01, -1.504543014476156e+01},
	{"VMR", -2.210937206116066e+01, -3.840916302762854e+00},
	{"VMS", -2.508482457393820e+01, -6.816368815540393e+00},
	{"VMT", -2.479388228906587e+01, -6.525426530668069e+00},
	{"VMU", -2.530369495774379e+01, -7.035239199345983e+00},
	{"VMV", -3.004816707396452e+01, -1.177971131556672e+01},
	{"VMW", -2.650979793692278e+01, -8.241342178524981e+00},
	{"VMX", -3.495357536011282e+01, -1.668511960171502e+01},
	{"VMY", -2.489617571339139e+01, -6.627719954993582e+00},
	{"VMZ", -3.358264947913970e+01, -1.531419372074190e+01},
	{"VNA", -2.107660656169744e+01, -3.709742917831238e+00},
	{"VNB", -2.106840332021055e+01, -3.701539676344349e+00},
	{"VNC", -2.219103016288831e+01, -4.824166519022114e+00},
	{"VND", -2.057137099634716e+01, -3.204507352480963e+00},
	{"VNE", -2.232087743005296e+01, -4.954013786186758e+00},
	{"VNF", -2.252529377934005e+01, -5.158430135473849e+00},
	{"VNG", -2.210027490273613e+01, -4.733411258869933e+00},
	{"VNH", -2.248848806748213e+01, -5.121624423615930e+00},
	{"VNI", -2.172872645297782e+01, -4.361862809111623e+00},
	{"VNJ", -2.801211564688818e+01, -1.064525200302199e+01},
	{"VNK", -2.667070939810477e+01, -9.303845754238578e+00},
	{"VNL", -2.345140051748563e+01, -6.084536873619436e+00},
	{"VNM", -2.107437177851813e+01, -3.707508134651932e+00},
	{"VNN", -2.597782355746469e+01, -8.610959913598492e+00},
	{"VNO", -2.045986572333544e+01, -3.093002079469241e+00},
	{"VNP", -2.351432408475511e+01, -6.147460440888915e+00},
	{"VNQ", -2.892427964971141e+01, -1.155741600584521e+01},
	{"VNR", -2.263883090823776e+01, -5.271967264371566e+00},
	{"VNS", -2.085874806092012e+01, -3.491884417053920e+00},
	{"VNT", -1.999051590584920e+01, -2.623652261982999e+00},
	{"VNU", -2.604284502057934e+01, -8.675981376713144e+00},
	{"VNV", -2.716879902579361e+01, -9.801935381927414e+00},
	{"VNW", -2.334562052444682e+01, -5.978756880580624e+00},
	{"VNX", -3.098085379189411e+01, -1.361399014802791e+01},
	{"VNY", -2.554613164518285e+01, -8.179268001316647e+00},
	{"VNZ", -3.148955883567371e+01, -1.412269519180751e+01},
	{"VOA", -2.196608255877072e+01, -1.110659786686257e+01},
	{"VOB", -2.526473150395224e+01, -1.440524681204410e+01},
	{"VOC", -1.561344763558540e+01, -4.753962943677259e+00},
	{"VOD", -2.445786088114384e+01, -1.359837618923569e+01},
	{"VOE", -2.260317186671089e+01, -1.174368717480275e+01},
	{"VOF", -1.938610495349886e+01, -8.526620261590717e+00},
	{"VOG", -2.165012756229400e+01, -1.079064287038586e+01},
	{"VOH", -2.253730677392973e+01, -1.167782208202159e+01},
	{"VOI", -1.310270565412691e+01, -2.243220962218763e+00},
	{"VOJ", -2.739235590268771e+01, -1.653287121077956e+01},
	{"VOK", -1.604463474601713e+01, -5.185150054108984e+00},
	{"VOL", -1.255007313983583e+01, -1.690588447927688e+00},
	{"VOM", -1.861077141929124e+01, -7.751286727383096e+00},
	{"VON", -1.659377602830981e+01, -5.734291336401666e+00},
	{"VOO", -2.183691833821779e+01, -1.097743364630964e+01},
	{"VOP", -2.306937151969202e+01, -1.220988682778387e+01},
	{"VOQ", -3.070747436170254e+01, -1.984798966979440e+01},
	{"VOR", -1.407466501195547e+01, -3.215180320047331e+00},
	{"VOS", -1.964726640176265e+01, -8.787781709854508e+00},
	{"VOT", -1.431635835971924e+01, -3.456873667811094e+00},
	{"VOU", -1.387999401929499e+01, -3.020509327386842e+00},
	{"VOV", -2.319858217707572e+01, -1.233909748516758e+01},
	{"VOW", -1.630071275493784e+01, -5.441228063029699e+00},
	{"VOX", -2.112850070794926e+01, -1.026901601604112e+01},
	{"VOY", -1.559370545191041e+01, -4.734220760002263e+00},
	{"VOZ", -3.048809512469905e+01, -1.962861043279091e+01},
	{"VPA", -2.219211216922032e+01, -3.851009405740704e+00},
	{"VPB", -2.934467897278387e+01, -1.100357620930426e+01},
	{"VPC", -2.371757819567888e+01, -5.376475432199268e+00},
	{"VPD", -3.077739340057471e+01, -1.243629063709510e+01},
	{"VPE", -2.260600843066351e+01, -4.264905667183898e+00},
	{"VPF", -2.932090264260782e+01, -1.097979987912821e+01},
	{"VPG", -3.012859747491383e+01, -1.178749471143422e+01},
	{"VPH", -2.553769697754550e+01, -7.196594214065887e+00},
	{"VPI", -2.502536795254690e+01, -6.684265189067292e+00},
	{"VPJ", -3.295285477517923e+01, -1.461175201169962e+01},
	{"VPK", -3.283577538319814e+01, -1.449467261971853e+01},
	{"VPL", -2.230664802484664e+01, -3.965545261367031e+00},
	{"VPM", -2.854032818704130e+01, -1.019922542356169e+01},
	{"VPN", -3.067213948388279e+01, -1.233103672040319e+01},
	{"VPO", -2.273548379595815e+01, -4.394381032478541e+00},
	{"VPP", -1.931570142328312e+01, -9.745986598035118e-01},
	{"VPQ", -3.420912544084037e+01, -1.586802267736077e+01},
	{"VPR", -2.071284428195726e+01, -2.371741518477644e+00},
	{"VPS", -2.647125912756883e+01, -8.130156364089222e+00},
	{"VPT", -2.517945953528339e+01, -6.838356771803778e+00},
	{"VPU", -2.543686088643714e+01, -7.095758122957531e+00},
	{"VPV", -3.236709307608402e+01, -1.402599031260440e+01},
	{"VPW", -2.856885043568932e+01, -1.022774767220970e+01},
	{"VPX", -3.771030414624818e+01, -1.936920138276857e+01},
	{"VPY", -2.792093080320852e+01, -9.579828039728913e+00},
	{"VPZ", -3.601541977169928e+01, -1.767431700821967e+01},
	{"VQA", -3.255020788609527e+01, -6.612263207675643e+00},
	{"VQB", -3.517762983323754e+01, -9.239685154817920e+00},
	{"VQC", -3.408862905113443e+01, -8.150684372714800e+00},
	{"VQD", -3.569933369332747e+01, -9.761389014907845e+00},
	{"VQE", -3.608722823747171e+01, -1.014928355905209e+01},
	{"VQF", -3.444613263672832e+01, -8.508187958308699e+00},
	{"VQG", -4.116295661110983e+01, -1.522501193269020e+01},
	{"VQH", -3.499769129358744e+01, -9.059746615167823e+00},
	{"VQI", -3.088925190147950e+01, -4.951307223059880e+00},
	{"VQJ", -3.696300306872924e+01, -1.102505839030962e+01},
	{"VQK", -4.279514180604857e+01, -1.685719712762894e+01},
	{"VQL", -3.544007886703045e+01, -9.502134188610825e+00},
	{"VQM", -3.458999310818879e+01, -8.652048429769165e+00},
	{"VQN", -3.744700940185851e+01, -1.150906472343888e+01},
	{"VQO", -3.564345523258395e+01, -9.705510554164320e+00},
	{"VQP", -3.564564061900980e+01, -9.707695940590177e+00},
	{"VQQ", -3.752704356774690e+01, -1.158909888932728e+01},
	{"VQR", -3.549234407046166e+01, -9.554399392042038e+00},
	{"VQS", -3.256465622575041e+01, -6.626711547330789e+00},
	{"VQT", -3.306432722968472e+01, -7.126382551265096e+00},
	{"VQU", -2.606294525419982e+01, -1.250005757802008e-01},
	{"VQV", -3.835819724810018e+01, -1.242025256968055e+01},
	{"VQW", -3.471645007224645e+01, -8.778505393826824e+00},
	{"VQX", -4.481827376393150e+01, -1.888032908551187e+01},
	{"VQY", -3.901099396537828e+01, -1.307304928695866e+01},
	{"VQZ", -4.595784120068203e+01, -2.001989652226240e+01},
	{"VRA", -1.893384109288601e+01, -2.636702782315609e+00},
	{"VRB", -2.789732041268917e+01, -1.160018210211877e+01},
	{"VRC", -2.688843384965705e+01, -1.059129553908666e+01},
	{"VRD", -2.593700536877636e+01, -9.639867058205965e+00},
	{"VRE", -1.691813535352699e+01, -6.209970429565923e-01},
	{"VRF", -2.772669033268429e+01, -1.142955202211389e+01},
	{"VRG", -2.734970773851509e+01, -1.105256942794469e+01},
	{"VRH", -2.753169544853167e+01, -1.123455713796127e+01},
	{"VRI", -1.904243363873960e+01, -2.745295328169205e+00},
	{"VRJ", -3.081967818521586e+01, -1.452253987464546e+01},
	{"VRK", -2.768710459677675e+01, -1.138996628620635e+01},
	{"VRL", -2.755439864748856e+01, -1.125726033691816e+01},
	{"VRM", -2.656229637614982e+01, -1.026515806557942e+01},
	{"VRN", -2.661770521610734e+01, -1.032056690553694e+01},
	{"VRO", -2.237279228921479e+01, -6.075653978644391e+00},
	{"VRP", -2.782017032560653e+01, -1.152303201503613e+01},
	{"VRQ", -3.220621431545663e+01, -1.590907600488623e+01},
	{"VRR", -2.708944110299312e+01, -1.079230279242272e+01},
	{"VRS", -2.532622590241037e+01, -9.029087591839971e+00},
	{"VRT", -2.503454340912938e+01, -8.737405098558980e+00},
	{"VRU", -2.707932852575204e+01, -1.078219021518164e+01},
	{"VRV", -2.813735765537372e+01, -1.184021934480332e+01},
	{"VRW", -2.749292747098693e+01, -1.119578916041654e+01},
	{"VRX", -3.287134048821608e+01, -1.657420217764568e+01},
	{"VRY", -2.259956767811599e+01, -6.302429367545595e+00},
	{"VRZ", -3.380246302206233e+01, -1.750532471149194e+01},
	{"VSA", -2.127512270394991e+01, -3.940208203844167e+00},
	{"VSB", -2.244623381401810e+01, -5.111319313912362e+00},
	{"VSC", -2.184621893381679e+01, -4.511304433711049e+00},
	{"VSD", -2.569621043707640e+01, -8.361295936970659e+00},
	{"VSE", -2.004235393864773e+01, -2.707439438541985e+00},
	{"VSF", -2.320301149886581e+01, -5.868096998760074e+00},
	{"VSG", -2.260438050411320e+01, -5.269466004007457e+00},
	{"VSH", -2.043503270496544e+01, -3.100118204859701e+00},
	{"VSI", -2.293519036864404e+01, -5.600275868538306e+00},
	{"VSJ", -2.848245124670035e+01, -1.114753674659461e+01},
	{"VSK", -2.677834352053796e+01, -9.443429020432212e+00},
	{"VSL", -2.329213615922287e+01, -5.957221659117131e+00},
	{"VSM", -2.063949407857557e+01, -3.304579578469833e+00},
	{"VSN", -2.549227717665213e+01, -8.157362676546393e+00},
	{"VSO", -2.206662092034353e+01, -4.731706420237789e+00},
	{"VSP", -2.225578138267146e+01, -4.920866882565720e+00},
	{"VSQ", -2.839137497284451e+01, -1.105646047273877e+01},
	{"VSR", -2.066606258259564e+01, -3.331148082489897e+00},
	{"VSS", -2.099334586045557e+01, -3.658431360349826e+00},
	{"VST", -2.114314232426116e+01, -3.808227824155421e+00},
	{"VSU", -2.144884351481388e+01, -4.113929014708140e+00},
	{"VSV", -2.762932641724030e+01, -1.029441191713456e+01},
	{"VSW", -2.287394879209359e+01, -5.539034291987845e+00},
	{"VSX", -3.045601135974644e+01, -1.312109685964070e+01},
	{"VSY", -2.653815649880579e+01, -9.203241998700046e+00},
	{"VSZ", -3.191898583185657e+01, -1.458407133175083e+01},
	{"VTA", -2.474708439068685e+01, -8.096260987383211e+00},
	{"VTB", -2.734364100840334e+01, -1.069281760509971e+01},
	{"VTC", -2.741592200738978e+01, -1.076509860408615e+01},
	{"VTD", -2.806554245003475e+01, -1.141471904673111e+01},
	{"VTE", -2.421329779357530e+01, -7.562474390271669e+00},
	{"VTF", -2.757395948044130e+01, -1.092313607713766e+01},
	{"VTG", -2.851559438355835e+01, -1.186477098025471e+01},
	{"VTH", -1.715072468172190e+01, -4.999012784182672e-01},
	{"VTI", -2.413077082399427e+01, -7.479947420690630e+00},
	{"VTJ", -3.067110167343331e+01, -1.402027827012967e+01},
	{"VTK", -3.050136044579287e+01, -1.385053704248923e+01},
	{"VTL", -2.691796621306913e+01, -1.026714280976549e+01},
	{"VTM", -2.742753870283851e+01, -1.077671529953487e+01},
	{"VTN", -2.810597117449111e+01, -1.145514777118747e+01},
	{"VTO", -2.001576082144949e+01, -3.364937418145855e+00},
	{"VTP", -2.817904853769351e+01, -1.152822513438987e+01},
	{"VTQ", -3.263766588062167e+01, -1.598684247731803e+01},
	{"VTR", -2.105412971305209e+01, -4.403306309748452e+00},
	{"VTS", -1.986938888662970e+01, -3.218565483326060e+00},
	{"VTT", -2.492011320844863e+01, -8.269289805144997e+00},
	{"VTU", -2.259639256401743e+01, -5.945569160713796e+00},
	{"VTV", -3.062740762714635e+01, -1.397658422384272e+01},
	{"VTW", -2.615238505571013e+01, -9.501561652406494e+00},
	{"VTX", -3.534346866738528e+01, -1.869264526408164e+01},
	{"VTY", -2.650717910269175e+01, -9.856355699388109e+00},
	{"VTZ", -3.281670212434614e+01, -1.616587872104250e+01},
	{"VUA", -2.596645459318555e+01, -9.729666306566578e+00},
	{"VUB", -2.635584067419336e+01, -1.011905238757438e+01},
	{"VUC", -2.554134024948214e+01, -9.304551962863160e+00},
	{"VUD", -2.628135236839308e+01, -1.004456408177411e+01},
	{"VUE", -2.257815133999554e+01, -6.341363053376563e+00},
	{"VUF", -2.794086204338256e+01, -1.170407375676358e+01},
	{"VUG", -2.549695031407730e+01, -9.260162027458327e+00},
	{"VUH", -2.861101909252613e+01, -1.237423080590716e+01},
	{"VUI", -2.602604390420460e+01, -9.789255617585626e+00},
	{"VUJ", -3.289876448920535e+01, -1.666197620258637e+01},
	{"VUK", -2.910341119104681e+01, -1.286662290442783e+01},
	{"VUL", -1.663696305895263e+01, -4.001747723336491e-01},
	{"VUM", -1.945475118617044e+01, -3.217962899551467e+00},
	{"VUN", -2.215548711210560e+01, -5.918698825486621e+00},
	{"VUO", -2.924407192398887e+01, -1.300728363736989e+01},
	{"VUP", -2.512337057250146e+01, -8.886582285882481e+00},
	{"VUQ", -3.436036844024073e+01, -1.812358015362175e+01},
	{"VUR", -2.373950612759994e+01, -7.502717840980959e+00},
	{"VUS", -1.980658920550768e+01, -3.569800918888701e+00},
	{"VUT", -2.372090555429760e+01, -7.484117267678620e+00},
	{"VUU", -3.170353647356509e+01, -1.546674818694611e+01},
	{"VUV", -3.104583412370187e+01, -1.480904583708289e+01},
	{"VUW", -2.872592533136416e+01, -1.248913704474518e+01},
	{"VUX", -3.132132498424705e+01, -1.508453669762807e+01},
	{"VUY", -3.047231997277586e+01, -1.423553168615689e+01},
	{"VUZ", -3.094433507448067e+01, -1.470754678786169e+01},
	{"VVA", -2.259928362133296e+01, -1.767761777302457e+00},
	{"VVB", -3.437387917593107e+01, -1.354235733190056e+01},
	{"VVC", -3.456323550327127e+01, -1.373171365924077e+01},
	{"VVD", -3.381830763701530e+01, -1.298678579298480e+01},
	{"VVE", -2.194571549832505e+01, -1.114193654294548e+00},
	{"VVF", -3.402265488230284e+01, -1.319113303827233e+01},
	{"VVG", -3.533104726962432e+01, -1.449952542559381e+01},
	{"VVH", -3.304588824505277e+01, -1.221436640102226e+01},
	{"VVI", -2.307921578869361e+01, -2.247693944663105e+00},
	{"VVJ", -3.525390497026494e+01, -1.442238312623443e+01},
	{"VVK", -3.713350559304325e+01, -1.630198374901275e+01},
	{"VVL", -3.440574866472876e+01, -1.357422682069826e+01},
	{"VVM", -3.341621144635692e+01, -1.258468960232642e+01},
	{"VVN", -3.251461933182532e+01, -1.168309748779481e+01},
	{"VVO", -2.600693228503166e+01, -5.175410441001152e+00},
	{"VVP", -3.348885845143873e+01, -1.265733660740822e+01},
	{"VVQ", -4.108570036637875e+01, -2.025417852234823e+01},
	{"VVR", -3.144489399852951e+01, -1.061337215449901e+01},
	{"VVS", -3.248267018806485e+01, -1.165114834403435e+01},
	{"VVT", -3.179857909126275e+01, -1.096705724723225e+01},
	{"VVU", -3.138454397457809e+01, -1.055302213054759e+01},
	{"VVV", -3.597927753198962e+01, -1.514775568795912e+01},
	{"VVW", -3.312203715983198e+01, -1.229051531580147e+01},
	{"VVX", -3.771152118347540e+01, -1.687999933944489e+01},
	{"VVY", -2.953436361944597e+01, -8.702841775415465e+00},
	{"VVZ", -4.112140006603312e+01, -2.028987822200261e+01},
	{"VWA", -1.981819066523669e+01, -1.843909193363827e+00},
	{"VWB", -2.946139615642700e+01, -1.148711468455413e+01},
	{"VWC", -2.951928777535428e+01, -1.154500630348142e+01},
	{"VWD", -2.903277777547801e+01, -1.105849630360514e+01},
	{"VWE", -1.983836227187244e+01, -1.864080799999576e+00},
	{"VWF", -2.931436556161373e+01, -1.134008408974086e+01},
	{"VWG", -3.044110899159939e+01, -1.246682751972653e+01},
	{"VWH", -1.956058618309971e+01, -1.586304711226847e+00},
	{"VWI", -2.175686807193178e+01, -3.782586600058922e+00},
	{"VWJ", -3.179780345441680e+01, -1.382352198254394e+01},
	{"VWK", -3.195281591794281e+01, -1.397853444606995e+01},
	{"VWL", -2.838284817844429e+01, -1.040856670657143e+01},
	{"VWM", -2.908368041455178e+01, -1.110939894267892e+01},
	{"VWN", -2.595797037594854e+01, -7.983688904075678e+00},
	{"VWO", -2.314676270988529e+01, -5.172481238012424e+00},
	{"VWP", -3.017154408158169e+01, -1.219726260970882e+01},
	{"VWQ", -3.442516522829282e+01, -1.645088375641996e+01},
	{"VWR", -2.760683957979911e+01, -9.632558107926251e+00},
	{"VWS", -2.721814272472332e+01, -9.243861252850458e+00},
	{"VWT", -2.708816498986557e+01, -9.113883517992708e+00},
	{"VWU", -3.055477576334194e+01, -1.258049429146907e+01},
	{"VWV", -3.227533859093800e+01, -1.430105711906513e+01},
	{"VWW", -2.830735803002829e+01, -1.033307655815542e+01},
	{"VWX", -4.161897149441823e+01, -2.364469002254537e+01},
	{"VWY", -2.925786003208486e+01, -1.128357856021199e+01},
	{"VWZ", -3.514195514505739e+01, -1.716767367318453e+01},
	{"VXA", -2.762400165812067e+01, -5.060236162604390e+00},
	{"VXB", -3.219132626715512e+01, -9.627560771638839e+00},
	{"VXC", -2.715232592470527e+01, -4.588560429188990e+00},
	{"VXD", -3.158471442007507e+01, -9.020948924558786e+00},
	{"VXE", -2.722999519903549e+01, -4.666229703519205e+00},
	{"VXF", -3.172682388613057e+01, -9.163058390614287e+00},
	{"VXG", -3.302588842624633e+01, -1.046212293073005e+01},
	{"VXH", -2.938406225210964e+01, -6.820296756593359e+00},
	{"VXI", -2.722427333404439e+01, -4.660507838528106e+00},
	{"VXJ", -3.423885755227024e+01, -1.167509205675396e+01},
	{"VXK", -3.513694384271663e+01, -1.257317834720034e+01},
	{"VXL", -3.168417785954010e+01, -9.120412364023815e+00},
	{"VXM", -3.096736347753460e+01, -8.403597982018315e+00},
	{"VXN", -3.347638153409127e+01, -1.091261603857498e+01},
	{"VXO", -2.998173464060989e+01, -7.417969145093606e+00},
	{"VXP", -2.660012293129311e+01, -4.036357435776832e+00},
	{"VXQ", -3.313915320198339e+01, -1.057538770646711e+01},
	{"VXR", -3.175734059993665e+01, -9.193575104420368e+00},
	{"VXS", -3.104922605394774e+01, -8.485460558431452e+00},
	{"VXT", -2.639925778791197e+01, -3.835492292395689e+00},
	{"VXU", -3.026222338745654e+01, -7.698457891940262e+00},
	{"VXV", -2.988439663993464e+01, -7.320631144418354e+00},
	{"VXW", -3.107295575453477e+01, -8.509190259018490e+00},
	{"VXX", -2.314086164284008e+01, -5.770961473237970e-01},
	{"VXY", -3.085641168551993e+01, -8.292646190003655e+00},
	{"VXZ", -4.467617295488299e+01, -2.211240745936671e+01},
	{"VYA", -1.701482914964082e+01, -2.628221218153973e+00},
	{"VYB", -1.833044706184699e+01, -3.943839130360133e+00},
	{"VYC", -1.847812296551489e+01, -4.091515034028038e+00},
	{"VYD", -1.935126502566053e+01, -4.964657094173679e+00},
	{"VYE", -2.072501420650876e+01, -6.338406275021911e+00},
	{"VYF", -1.903003893243317e+01, -4.643431000946321e+00},
	{"VYG", -2.065393624024533e+01, -6.267328308758477e+00},
	{"VYH", -1.908139456878441e+01, -4.694786637297564e+00},
	{"VYI", -1.795237294339434e+01, -3.565765011907486e+00},
	{"VYJ", -2.168796143813126e+01, -7.301353506644404e+00},
	{"VYK", -2.700412908448148e+01, -1.261752115299462e+01},
	{"VYL", -1.898920946838513e+01, -4.602601536898280e+00},
	{"VYM", -1.973279179834008e+01, -5.346183866853228e+00},
	{"VYN", -2.104483463876622e+01, -6.658226707279367e+00},
	{"VYO", -1.808630594281651e+01, -3.699698011329659e+00},
	{"VYP", -1.934230631891017e+01, -4.955698387423322e+00},
	{"VYQ", -2.912165534137538e+01, -1.473504740988853e+01},
	{"VYR", -1.958267535997824e+01, -5.196067428491383e+00},
	{"VYS", -1.845985332977492e+01, -4.073245398288063e+00},
	{"VYT", -1.744226691122401e+01, -3.055658979737158e+00},
	{"VYU", -2.107812064884554e+01, -6.691512717358684e+00},
	{"VYV", -2.689928812827446e+01, -1.251268019678761e+01},
	{"VYW", -1.818730864662288e+01, -3.800700715136033e+00},
	{"VYX", -3.120747279809787e+01, -1.682086486661102e+01},
	{"VYY", -2.052161934684582e+01, -6.135011415358973e+00},
	{"VYZ", -3.054153494439479e+01, -1.615492701290794e+01},
	{"VZA", -2.826753517622697e+01, -2.293890798152970e+00},
	{"VZB", -3.361937842198993e+01, -7.645734043915925e+00},
	{"VZC", -3.450429324023150e+01, -8.530648862157500e+00},
	{"VZD", -3.486345908163434e+01, -8.889814703560335e+00},
	{"VZE", -2.719322055171705e+01, -1.219576173643045e+00},
	{"VZF", -3.445059064800893e+01, -8.476946269934929e+00},
	{"VZG", -3.497355982113615e+01, -8.999915443062147e+00},
	{"VZH", -3.359029695128604e+01, -7.616652573212031e+00},
	{"VZI", -2.881793446808070e+01, -2.844290090006696e+00},
	{"VZJ", -3.749728452329331e+01, -1.152364014521931e+01},
	{"VZK", -3.613278458367967e+01, -1.015914020560566e+01},
	{"VZL", -3.182301972032612e+01, -5.849375342252118e+00},
	{"VZM", -3.403127565001613e+01, -8.057631271942135e+00},
	{"VZN", -3.513410327863578e+01, -9.160458900561782e+00},
	{"VZO", -3.014560443118446e+01, -4.171960053110454e+00},
	{"VZP", -3.294966799886598e+01, -6.976023620791975e+00},
	{"VZQ", -4.141349841261665e+01, -1.543985403454266e+01},
	{"VZR", -3.216242464886835e+01, -6.188780270794347e+00},
	{"VZS", -3.378124739192425e+01, -7.807603013850243e+00},
	{"VZT", -3.228117967304759e+01, -6.307535294973584e+00},
	{"VZU", -3.168341805814367e+01, -5.709773680069663e+00},
	{"VZV", -3.458097921676095e+01, -8.607334838686953e+00},
	{"VZW", -3.324446639189682e+01, -7.270822013822818e+00},
	{"VZX", -4.422163497406149e+01, -1.824799059598750e+01},
	{"VZY", -3.265711422238716e+01, -6.683469844313167e+00},
	{"VZZ", -3.025066975167661e+01, -4.277025373602608e+00},
	{"WAA", -2.053334837983439e+01, -1.262435899261955e+01},
	{"WAB", -1.646508161562254e+01, -8.556092228407701e+00},
	{"WAC", -1.739671435991444e+01, -9.487724972699601e+00},
	{"WAD", -1.697620292346471e+01, -9.067213536249870e+00},
	{"WAE", -2.167951998972552e+01, -1.377053060251069e+01},
	{"WAF", -1.708496366192078e+01, -9.175974274705947e+00},
	{"WAG", -1.498215787078048e+01, -7.073168483565641e+00},
	{"WAH", -2.023607237380070e+01, -1.232708298658585e+01},
	{"WAI", -1.385914774915664e+01, -5.950158361941801e+00},
	{"WAJ", -2.269938995855346e+01, -1.479040057133862e+01},
	{"WAK", -1.546449210585302e+01, -7.555502718638182e+00},
	{"WAL", -1.262254570840914e+01, -4.713556321194299e+00},
	{"WAM", -1.589302687864641e+01, -7.984037491431571e+00},
	{"WAN", -1.226104697408633e+01, -4.352057586871488e+00},
	{"WAO", -2.170596031761360e+01, -1.379697093039876e+01},
	{"WAP", -1.751905714611788e+01, -9.610067758903041e+00},
	{"WAQ", -2.211992538769639e+01, -1.421093600048155e+01},
	{"WAR", -1.055646454448925e+01, -2.647475157274414e+00},
	{"WAS", -8.897793465959849e+00, -9.888040787450098e-01},
	{"WAT", -1.179677414980329e+01, -3.887784762588453e+00},
	{"WAU", -1.923966454822732e+01, -1.133067516101249e+01},
	{"WAV", -1.473968733520088e+01, -6.830697947986036e+00},
	{"WAW", -1.842246892443992e+01, -1.051347953722508e+01},
	{"WAX", -1.692395023812717e+01, -9.014960850912335e+00},
	{"WAY", -1.087807078295859e+01, -2.969081395743751e+00},
	{"WAZ", -2.865049922479804e+01, -2.074150983758321e+01},
	{"WBA", -1.745320389608715e+01, -3.751920846664753e+00},
	{"WBB", -2.723033037672699e+01, -1.352904732730459e+01},
	{"WBC", -2.793300880531730e+01, -1.423172575589490e+01},
	{"WBD", -2.923971093463615e+01, -1.553842788521375e+01},
	{"WBE", -1.523046857608461e+01, -1.529185526662211e+00},
	{"WBF", -3.081913174188993e+01, -1.711784869246753e+01},
	{"WBG", -3.242503894564467e+01, -1.872375589622226e+01},
	{"WBH", -2.967015740179848e+01, -1.596887435237608e+01},
	{"WBI", -2.080165087306743e+01, -7.100367823645027e+00},
	{"WBJ", -2.722552116081562e+01, -1.352423811139322e+01},
	{"WBK", -3.268085389630571e+01, -1.897957084688331e+01},
	{"WBL", -1.917557297893563e+01, -5.474289929513228e+00},
	{"WBM", -2.899674715379428e+01, -1.529546410437188e+01},
	{"WBN", -2.977844203171029e+01, -1.607715898228789e+01},
	{"WBO", -1.690730313398038e+01, -3.206020084557982e+00},
	{"WBP", -3.048265760866282e+01, -1.678137455924042e+01},
	{"WBQ", -3.654824496775278e+01, -2.284696191833038e+01},
	{"WBR", -1.727701893989330e+01, -3.575735890470900e+00},
	{"WBS", -2.580532153119551e+01, -1.210403848177311e+01},
	{"WBT", -2.647976089340870e+01, -1.277847784398629e+01},
	{"WBU", -1.578538819423308e+01, -2.084105144810685e+00},
	{"WBV", -3.046275159720354e+01, -1.676146854778114e+01},
	{"WBW", -2.986647368161406e+01, -1.616519063219166e+01},
	{"WBX", -3.983545280699338e+01, -2.613416975757098e+01},
	{"WBY", -1.675140033585344e+01, -3.050117286431043e+00},
	{"WBZ", -3.434355668276078e+01, -2.064227363333838e+01},
	{"WCA", -1.570004395321869e+01, -1.940869284869003e+00},
	{"WCB", -3.047892583643885e+01, -1.671975116808916e+01},
	{"WCC", -2.570969086799894e+01, -1.195051619964925e+01},
	{"WCD", -2.945287018632700e+01, -1.569369551797732e+01},
	{"WCE", -1.897094030545396e+01, -5.211765637104276e+00},
	{"WCF", -3.033773597018176e+01, -1.657856130183208e+01},
	{"WCG", -3.129328742161191e+01, -1.753411275326222e+01},
	{"WCH", -1.789128185290336e+01, -4.132107184553674e+00},
	{"WCI", -1.820723559361863e+01, -4.448060925268948e+00},
	{"WCJ", -3.320766748124861e+01, -1.944849281289893e+01},
	{"WCK", -2.497170574885997e+01, -1.121253108051028e+01},
	{"WCL", -1.787625388248773e+01, -4.117079214138043e+00},
	{"WCM", -2.370354599124007e+01, -9.944371322890387e+00},
	{"WCN", -3.111218208666336e+01, -1.735300741831367e+01},
	{"WCO", -1.492422672443892e+01, -1.165052056089231e+00},
	{"WCP", -2.953082564525657e+01, -1.577165097690688e+01},
	{"WCQ", -2.964181780372295e+01, -1.588264313537327e+01},
	{"WCR", -1.775524492611619e+01, -3.996070257766509e+00},
	{"WCS", -2.812415197149462e+01, -1.436497730314493e+01},
	{"WCT", -1.926159101351242e+01, -5.502416345162728e+00},
	{"WCU", -1.944281545963982e+01, -5.683640791290128e+00},
	{"WCV", -3.290694969306387e+01, -1.914777502471418e+01},
	{"WCW", -2.861521352239950e+01, -1.485603885404982e+01},
	{"WCX", -3.425030540972906e+01, -2.049113074137937e+01},
	{"WCY", -2.721944032297417e+01, -1.346026565462448e+01},
	{"WCZ", -3.286135525425448e+01, -1.910218058590479e+01},
	{"WDA", -1.616144565732029e+01, -2.888780988846877e+00},
	{"WDB", -2.142743584785357e+01, -8.154771179380161e+00},
	{"WDC", -2.245293227332115e+01, -9.180267604847744e+00},
	{"WDD", -2.481560701291020e+01, -1.154294234443678e+01},
	{"WDE", -1.504989996822934e+01, -1.777235299755927e+00},
	{"WDF", -2.046033642087169e+01, -7.187671752398274e+00},
	{"WDG", -2.197720900037446e+01, -8.704544331901049e+00},
	{"WDH", -2.279952714277151e+01, -9.526862474298094e+00},
	{"WDI", -1.566557454204222e+01, -2.392909873568808e+00},
	{"WDJ", -2.688639538942380e+01, -1.361373072095039e+01},
	{"WDK", -2.211025999587093e+01, -8.837595327397523e+00},
	{"WDL", -2.008793383221057e+01, -6.815269163737153e+00},
	{"WDM", -2.238098585279406e+01, -9.108321184320646e+00},
	{"WDN", -1.936554772930300e+01, -6.092883060829592e+00},
	{"WDO", -1.557551822928779e+01, -2.302853560814381e+00},
	{"WDP", -2.330221281734895e+01, -1.002954814887554e+01},
	{"WDQ", -2.950774570238118e+01, -1.623508103390777e+01},
	{"WDR", -1.779514002206795e+01, -4.522475353594540e+00},
	{"WDS", -1.865448863032942e+01, -5.381823961856008e+00},
	{"WDT", -1.908790937531697e+01, -5.815244706843559e+00},
	{"WDU", -1.852218044410505e+01, -5.249515775631640e+00},
	{"WDV", -2.659301549612816e+01, -1.332035082765475e+01},
	{"WDW", -1.956142912193736e+01, -6.288764453463950e+00},
	{"WDX", -3.440693600365538e+01, -2.113427133518197e+01},
	{"WDY", -1.978075707567051e+01, -6.508092407197096e+00},
	{"WDZ", -3.048937780397388e+01, -1.721671313550047e+01},
	{"WEA", -1.231092309622836e+01, -4.079387626625334e+00},
	{"WEB", -1.481355515176191e+01, -6.582019682158883e+00},
	{"WEC", -1.410205458608865e+01, -5.870519116485626e+00},
	{"WED", -1.217999046483424e+01, -3.948454995231214e+00},
	{"WEE", -1.216900632230300e+01, -3.937470852699976e+00},
	{"WEF", -1.566517884630092e+01, -7.433643376697888e+00},
	{"WEG", -1.554690915371695e+01, -7.315373684113919e+00},
	{"WEH", -1.333881845330895e+01, -5.107282983705928e+00},
	{"WEI", -1.452434572926082e+01, -6.292810259657787e+00},
	{"WEJ", -1.971445687154525e+01, -1.148292140194222e+01},
	{"WEK", -1.574075357145317e+01, -7.509218101850148e+00},
	{"WEL", -1.130086023111600e+01, -3.069324761512973e+00},
	{"WEM", -1.424914794390237e+01, -6.017612474299343e+00},
	{"WEN", -1.178196875309941e+01, -3.550433283496386e+00},
	{"WEO", -1.660241830250821e+01, -8.370882832905185e+00},
	{"WEP", -1.511259489132592e+01, -6.881059421722896e+00},
	{"WEQ", -2.025039951465547e+01, -1.201886404505245e+01},
	{"WER", -9.658609643873401e+00, -1.427074174270374e+00},
	{"WES", -1.247519704375401e+01, -4.243661574150983e+00},
	{"WET", -1.440657876023256e+01, -6.175043290629527e+00},
	{"WEU", -1.809851792309749e+01, -9.866982453494465e+00},
	{"WEV", -1.334973957035948e+01, -5.118204100756452e+00},
	{"WEW", -1.380024673134676e+01, -5.568711261743735e+00},
	{"WEX", -1.744804129567710e+01, -9.216505826074073e+00},
	{"WEY", -1.849277433180025e+01, -1.026123886219722e+01},
	{"WEZ", -2.982313292821601e+01, -2.159159745861298e+01},
	{"WFA", -1.684585477105860e+01, -3.291602316449470e+00},
	{"WFB", -2.656495724422409e+01, -1.301070478961496e+01},
	{"WFC", -2.597850284064291e+01, -1.242425038603378e+01},
	{"WFD", -2.686020053942805e+01, -1.330594808481891e+01},
	{"WFE", -1.771800661085132e+01, -4.163754156242182e+00},
	{"WFF", -1.928133085528707e+01, -5.727078400677942e+00},
	{"WFG", -2.651537180417172e+01, -1.296111934956259e+01},
	{"WFH", -2.531584936438720e+01, -1.176159690977807e+01},
	{"WFI", -1.739255657333729e+01, -3.838304118728160e+00},
	{"WFJ", -2.730284848742136e+01, -1.374859603281222e+01},
	{"WFK", -2.919984714306333e+01, -1.564559468845420e+01},
	{"WFL", -1.874601854510865e+01, -5.191766090499519e+00},
	{"WFM", -2.564703335513743e+01, -1.209278090052830e+01},
	{"WFN", -2.726858826270472e+01, -1.371433580809559e+01},
	{"WFO", -1.539570514833906e+01, -1.841452693729928e+00},
	{"WFP", -2.617906620965269e+01, -1.262481375504355e+01},
	{"WFQ", -3.144669271333591e+01, -1.789244025872677e+01},
	{"WFR", -1.608216593590626e+01, -2.527913481297131e+00},
	{"WFS", -2.550665302675073e+01, -1.195240057214160e+01},
	{"WFT", -2.248758826975181e+01, -8.933335815142676e+00},
	{"WFU", -1.544571444550892e+01, -1.891461990899792e+00},
	{"WFV", -2.848067500664035e+01, -1.492642255203122e+01},
	{"WFW", -2.623260047915628e+01, -1.267834802454714e+01},
	{"WFX", -3.368804705997781e+01, -2.013379460536868e+01},
	{"WFY", -2.687552227544538e+01, -1.332126982083625e+01},
	{"WFZ", -2.988665767719594e+01, -1.633240522258681e+01},
	{"WGA", -1.862779132708941e+01, -3.946795442494618e+00},
	{"WGB", -2.208026326158227e+01, -7.399267376987481e+00},
	{"WGC", -2.708050544989788e+01, -1.239950956530308e+01},
	{"WGD", -2.695161050335695e+01, -1.227061461876216e+01},
	{"WGE", -1.827856152842386e+01, -3.597565643829064e+00},
	{"WGF", -2.663518927859964e+01, -1.195419339400484e+01},
	{"WGG", -2.677667941863783e+01, -1.209568353404304e+01},
	{"WGH", -2.329909292536562e+01, -8.618097040770820e+00},
	{"WGI", -1.830166520969291e+01, -3.620669325098113e+00},
	{"WGJ", -3.030453002658135e+01, -1.562353414198656e+01},
	{"WGK", -3.054284395987859e+01, -1.586184807528380e+01},
	{"WGL", -1.923694318110200e+01, -4.555947296507208e+00},
	{"WGM", -2.658697429420181e+01, -1.190597840960702e+01},
	{"WGN", -2.569980605158515e+01, -1.101881016699036e+01},
	{"WGO", -1.689830210515948e+01, -2.217306220564683e+00},
	{"WGP", -2.707276645110360e+01, -1.239177056650881e+01},
	{"WGQ", -3.183592305449666e+01, -1.715492716990186e+01},
	{"WGR", -1.690191162089000e+01, -2.220915736295210e+00},
	{"WGS", -2.491258732759289e+01, -1.023159144299810e+01},
	{"WGT", -2.402545543653364e+01, -9.344459551938849e+00},
	{"WGU", -1.648713478216107e+01, -1.806138897566275e+00},
	{"WGV", -2.967636483641715e+01, -1.499536895182236e+01},
	{"WGW", -2.625750846438914e+01, -1.157651257979435e+01},
	{"WGX", -3.505474352094402e+01, -2.037374763634922e+01},
	{"WGY", -2.702935367575659e+01, -1.234835779116179e+01},
	{"WGZ", -3.364299703497624e+01, -1.896200115038145e+01},
	{"WHA", -1.103034189310861e+01, -3.036863721660395e+00},
	{"WHB", -2.361315921145133e+01, -1.561968104000311e+01},
	{"WHC", -2.740929443072942e+01, -1.941581625928121e+01},
	{"WHD", -2.788840039536118e+01, -1.989492222391297e+01},
	{"WHE", -9.887719332232756e+00, -1.894241160784543e+00},
	{"WHF", -2.361221399480835e+01, -1.561873582336014e+01},
	{"WHG", -2.840670841978494e+01, -2.041323024833673e+01},
	{"WHH", -2.634512923341342e+01, -1.835165106196520e+01},
	{"WHI", -9.419342439237548e+00, -1.425864267789336e+00},
	{"WHJ", -3.032025972598777e+01, -2.232678155453956e+01},
	{"WHK", -3.065050074381500e+01, -2.265702257236679e+01},
	{"WHL", -2.794927189176427e+01, -1.995579372031605e+01},
	{"WHM", -2.695019850044074e+01, -1.895672032899253e+01},
	{"WHN", -2.785999654927740e+01, -1.986651837782918e+01},
	{"WHO", -1.021317207831985e+01, -2.219693906871636e+00},
	{"WHP", -2.779288634149235e+01, -1.979940817004414e+01},
	{"WHQ", -3.208289524698657e+01, -2.408941707553836e+01},
	{"WHR", -2.574958679720151e+01, -1.775610862575329e+01},
	{"WHS", -2.206063902692244e+01, -1.406716085547423e+01},
	{"WHT", -2.281467111881051e+01, -1.482119294736230e+01},
	{"WHU", -1.870810121498323e+01, -1.071462304353502e+01},
	{"WHV", -3.056563194422679e+01, -2.257215377277858e+01},
	{"WHW", -2.352735822583869e+01, -1.553388005439048e+01},
	{"WHX", -3.607883227592973e+01, -2.808535410448152e+01},
	{"WHY", -1.353365632182120e+01, -5.540178150372984e+00},
	{"WHZ", -3.309071452180344e+01, -2.509723635035523e+01},
	{"WIA", -1.898035917091370e+01, -1.089709172861601e+01},
	{"WIB", -1.988668771211749e+01, -1.180342026981980e+01},
	{"WIC", -1.392853062996298e+01, -5.845263187665291e+00},
	{"WID", -1.389396607978079e+01, -5.810698637483099e+00},
	{"WIE", -1.807739608664686e+01, -9.994128644349177e+00},
	{"WIF", -1.344788292627269e+01, -5.364615483974999e+00},
	{"WIG", -1.660243844316850e+01, -8.519171000870816e+00},
	{"WIH", -1.825625950256792e+01, -1.017299206027024e+01},
	{"WII", -2.365271223319498e+01, -1.556944479089729e+01},
	{"WIJ", -2.271302680735033e+01, -1.462975936505265e+01},
	{"WIK", -1.962012243811535e+01, -1.153685499581766e+01},
	{"WIL", -1.035844104658786e+01, -2.275173604290175e+00},
	{"WIM", -1.630946727042001e+01, -8.226199828122326e+00},
	{"WIN", -1.139065597538982e+01, -3.307388533092138e+00},
	{"WIO", -2.102756982885372e+01, -1.294430238655604e+01},
	{"WIP", -1.804010461136432e+01, -9.956837169066636e+00},
	{"WIQ", -2.935236240585659e+01, -2.126909496355890e+01},
	{"WIR", -1.527565450426774e+01, -7.192387061970051e+00},
	{"WIS", -1.245433057502207e+01, -4.371063132724381e+00},
	{"WIT", -8.918592858834105e+00, -8.353254165364172e-01},
	{"WIU", -2.208229753783846e+01, -1.399903009554077e+01},
	{"WIV", -1.580813466705320e+01, -7.724867224755509e+00},
	{"WIW", -1.778496343131861e+01, -9.701695989020916e+00},
	{"WIX", -1.832453015602401e+01, -1.024126271372632e+01},
	{"WIY", -3.294913748643561e+01, -2.486587004413792e+01},
	{"WIZ", -2.012192120372681e+01, -1.203865376142912e+01},
	{"WJA", -1.819617131497473e+01, -2.158480967562530e+00},
	{"WJB", -2.369617467631542e+01, -7.658484328903221e+00},
	{"WJC", -3.024939320669005e+01, -1.421170285927785e+01},
	{"WJD", -3.214355078895349e+01, -1.610586044154129e+01},
	{"WJE", -1.728022499000752e+01, -1.242534642595318e+00},
	{"WJF", -3.125457329849194e+01, -1.521688295107974e+01},
	{"WJG", -3.085177758149705e+01, -1.481408723408485e+01},
	{"WJH", -3.003250580566853e+01, -1.399481545825632e+01},
	{"WJI", -2.134803019094739e+01, -5.310339843535191e+00},
	{"WJJ", -3.004371330448871e+01, -1.400602295707650e+01},
	{"WJK", -3.273228481236000e+01, -1.669459446494779e+01},
	{"WJL", -3.122868051732950e+01, -1.519099016991730e+01},
	{"WJM", -3.159704305532406e+01, -1.555935270791186e+01},
	{"WJN", -3.454711278397668e+01, -1.850942243656447e+01},
	{"WJO", -1.882037571638578e+01, -2.782685368973578e+00},
	{"WJP", -3.100889531814309e+01, -1.497120497073089e+01},
	{"WJQ", -3.399514705906897e+01, -1.795745671165677e+01},
	{"WJR", -3.021932179588942e+01, -1.418163144847721e+01},
	{"WJS", -3.065811061241803e+01, -1.462042026500582e+01},
	{"WJT", -3.075224793463707e+01, -1.471455758722487e+01},
	{"WJU", -1.853289768847791e+01, -2.495207341065702e+00},
	{"WJV", -3.761420027866983e+01, -2.157650993125762e+01},
	{"WJW", -2.998845632224080e+01, -1.395076597482860e+01},
	{"WJX", -4.029350568573865e+01, -2.425581533832645e+01},
	{"WJY", -3.676337643658326e+01, -2.072568608917106e+01},
	{"WJZ", -3.486837753004170e+01, -1.883068718262950e+01},
	{"WKA", -2.095941727421394e+01, -4.766714463275718e+00},
	{"WKB", -2.636558707550076e+01, -1.017288426456254e+01},
	{"WKC", -2.679746045782455e+01, -1.060475764688633e+01},
	{"WKD", -2.743066867021005e+01, -1.123796585927183e+01},
	{"WKE", -1.952417231032223e+01, -3.331469499384009e+00},
	{"WKF", -2.626159940738703e+01, -1.006889659644881e+01},
	{"WKG", -2.853459619094004e+01, -1.234189338000182e+01},
	{"WKH", -2.593229556781003e+01, -9.739592756871813e+00},
	{"WKI", -1.778057368234800e+01, -1.587870871409782e+00},
	{"WKJ", -3.011277067234048e+01, -1.392006786140226e+01},
	{"WKK", -2.944090947420053e+01, -1.324820666326231e+01},
	{"WKL", -2.342137337722951e+01, -7.228670566291293e+00},
	{"WKM", -2.679692401222564e+01, -1.060422120128742e+01},
	{"WKN", -1.819701953002406e+01, -2.004316719085840e+00},
	{"WKO", -2.303149171511966e+01, -6.838788904181444e+00},
	{"WKP", -2.714843761233110e+01, -1.095573480139288e+01},
	{"WKQ", -3.279191046691356e+01, -1.659920765597534e+01},
	{"WKR", -2.758404190783589e+01, -1.139133909689767e+01},
	{"WKS", -2.271314145390000e+01, -6.520438642961783e+00},
	{"WKT", -2.446723569722752e+01, -8.274532886289297e+00},
	{"WKU", -2.631530129998267e+01, -1.012259848904445e+01},
	{"WKV", -2.370490844868483e+01, -7.512205637746610e+00},
	{"WKW", -1.828894637834721e+01, -2.096243567408993e+00},
	{"WKX", -3.376395733280682e+01, -1.757125452186860e+01},
	{"WKY", -2.350162172795357e+01, -7.308918917015346e+00},
	{"WKZ", -3.186582021867656e+01, -1.567311740773834e+01},
	{"WLA", -1.655682940277435e+01, -3.934094331334648e+00},
	{"WLB", -2.199294083483426e+01, -9.370205763394559e+00},
	{"WLC", -2.204009227779969e+01, -9.417357206359997e+00},
	{"WLD", -1.944768891139617e+01, -6.824953839956472e+00},
	{"WLE", -1.389655190158897e+01, -1.273816830149269e+00},
	{"WLF", -1.987423892495088e+01, -7.251503853511188e+00},
	{"WLG", -2.685506893087419e+01, -1.423233385943449e+01},
	{"WLH", -2.260198168589550e+01, -9.979246614455802e+00},
	{"WLI", -1.558784851332488e+01, -2.965113441885181e+00},
	{"WLJ", -2.958311812292854e+01, -1.696038305148884e+01},
	{"WLK", -2.356376771433348e+01, -1.094103264289379e+01},
	{"WLL", -2.170197552357329e+01, -9.079240452133593e+00},
	{"WLM", -2.257123740681582e+01, -9.948502335376123e+00},
	{"WLN", -2.262676134931490e+01, -1.000402627787520e+01},
	{"WLO", -1.564791456152533e+01, -3.025179490085631e+00},
	{"WLP", -2.591974929713635e+01, -1.329701422569665e+01},
	{"WLQ", -3.067580080299226e+01, -1.805306573155256e+01},
	{"WLR", -2.261405103288477e+01, -9.991315961445068e+00},
	{"WLS", -1.665584777663476e+01, -4.033112705195064e+00},
	{"WLT", -1.919429743035382e+01, -6.571562358914117e+00},
	{"WLU", -1.943593061682104e+01, -6.813195545381340e+00},
	{"WLV", -2.621976135000987e+01, -1.359702627857017e+01},
	{"WLW", -2.010785281454434e+01, -7.485117743104646e+00},
	{"WLX", -3.397776898711975e+01, -2.135503391568006e+01},
	{"WLY", -1.527445721698569e+01, -2.651722145545993e+00},
	{"WLZ", -3.263925946023552e+01, -2.001652438879582e+01},
	{"WMA", -1.535245545806161e+01, -2.028888150514425e+00},
	{"WMB", -2.473131411061636e+01, -1.140774680306918e+01},
	{"WMC", -2.266196457254357e+01, -9.338397264996390e+00},
	{"WMD", -2.169339880857057e+01, -8.369831501023381e+00},
	{"WME", -1.546282494784976e+01, -2.139257640302572e+00},
	{"WMF", -2.685984522132372e+01, -1.353627791377653e+01},
	{"WMG", -2.851262053123387e+01, -1.518905322368668e+01},
	{"WMH", -2.648100365016994e+01, -1.315743634262275e+01},
	{"WMI", -1.616096296842088e+01, -2.837395660873694e+00},
	{"WMJ", -2.994088199763594e+01, -1.661731469008876e+01},
	{"WMK", -3.024303470295637e+01, -1.691946739540918e+01},
	{"WML", -2.776840978318667e+01, -1.444484247563948e+01},
	{"WMM", -2.241121812403981e+01, -9.087650816492625e+00},
	{"WMN", -2.207550017362957e+01, -8.751932866082385e+00},
	{"WMO", -1.598008625590760e+01, -2.656518948360415e+00},
	{"WMP", -2.392298032280495e+01, -1.059941301525777e+01},
	{"WMQ", -3.285764099216252e+01, -1.953407368461534e+01},
	{"WMR", -1.962349426213122e+01, -6.299926954584033e+00},
	{"WMS", -2.237858197229655e+01, -9.055014664749361e+00},
	{"WMT", -2.299548663197717e+01, -9.671919324429981e+00},
	{"WMU", -1.629739435551776e+01, -2.973827047970568e+00},
	{"WMV", -2.959192216296769e+01, -1.626835485542051e+01},
	{"WMW", -2.605355302592595e+01, -1.272998571837877e+01},
	{"WMX", -3.449733044911599e+01, -2.117376314156880e+01},
	{"WMY", -1.703811987346504e+01, -3.714552565917853e+00},
	{"WMZ", -3.312640456814287e+01, -1.980283726059568e+01},
	{"WNA", -1.320344865031106e+01, -3.005591381367112e+00},
	{"WNB", -1.468999379413865e+01, -4.492136525194708e+00},
	{"WNC", -1.545132283719463e+01, -5.253465568250681e+00},
	{"WND", -1.592441830821338e+01, -5.726561039269434e+00},
	{"WNE", -1.394208665180004e+01, -3.744229382856088e+00},
	{"WNF", -1.477224610613032e+01, -4.574388837186368e+00},
	{"WNG", -1.702257785469590e+01, -6.824720585751954e+00},
	{"WNH", -1.459090834439816e+01, -4.393051075454217e+00},
	{"WNI", -1.379504324818186e+01, -3.597185979237918e+00},
	{"WNJ", -1.854613263056886e+01, -8.348275361624909e+00},
	{"WNK", -1.970359169961459e+01, -9.505734430670643e+00},
	{"WNL", -1.576886722932261e+01, -5.571009960378658e+00},
	{"WNM", -1.579828784682815e+01, -5.600430577884203e+00},
	{"WNN", -1.682060212208012e+01, -6.622744853136179e+00},
	{"WNO", -1.361285965647960e+01, -3.415002387535652e+00},
	{"WNP", -1.575763246949986e+01, -5.559775200555916e+00},
	{"WNQ", -1.962825670937941e+01, -9.430399440435458e+00},
	{"WNR", -1.648868403188395e+01, -6.290826762940005e+00},
	{"WNS", -1.357715234340718e+01, -3.379295074463231e+00},
	{"WNT", -1.281926240188258e+01, -2.621405132938634e+00},
	{"WNU", -1.534689852407617e+01, -5.149041255132221e+00},
	{"WNV", -1.858452332479655e+01, -8.386666055852606e+00},
	{"WNW", -1.449864743098619e+01, -4.300790162042246e+00},
	{"WNX", -3.058893241453111e+01, -2.039107514558716e+01},
	{"WNY", -1.803593294526646e+01, -7.838075676322515e+00},
	{"WNZ", -3.110563796452444e+01, -2.090778069558049e+01},
	{"WOA", -1.607911375927372e+01, -7.102238422897925e+00},
	{"WOB", -1.635781038485086e+01, -7.380935048475066e+00},
	{"WOC", -1.552692091661874e+01, -6.550045580242950e+00},
	{"WOD", -1.612872162209073e+01, -7.151846285714935e+00},
	{"WOE", -1.549385332684648e+01, -6.516977990470690e+00},
	{"WOF", -1.357212112071994e+01, -4.595245784344151e+00},
	{"WOG", -1.704323162914860e+01, -8.066356292772806e+00},
	{"WOH", -1.532086321320518e+01, -6.343987876829392e+00},
	{"WOI", -1.750223489269444e+01, -8.525359556318643e+00},
	{"WOJ", -2.111264620031587e+01, -1.213577086394008e+01},
	{"WOK", -1.705696749797332e+01, -8.080092161597527e+00},
	{"WOL", -1.580034945450778e+01, -6.823474118131990e+00},
	{"WOM", -1.250160701604643e+01, -3.524731679670632e+00},
	{"WON", -1.333501963216582e+01, -4.358144295790028e+00},
	{"WOO", -1.316727212277343e+01, -4.190396786397637e+00},
	{"WOP", -1.558617395923952e+01, -6.609298622863725e+00},
	{"WOQ", -1.971795706555678e+01, -1.074108172918099e+01},
	{"WOR", -1.020831339688562e+01, -1.231438060509827e+00},
	{"WOS", -1.523528159764339e+01, -6.258406261267598e+00},
	{"WOT", -1.489581413075324e+01, -5.918938794377446e+00},
	{"WOU", -1.122566254721056e+01, -2.248787210834766e+00},
	{"WOV", -1.699779287372236e+01, -8.020917537346566e+00},
	{"WOW", -1.624190190511620e+01, -7.265026568740409e+00},
	{"WOX", -2.907965464144856e+01, -2.010277930507277e+01},
	{"WOY", -1.601019077690444e+01, -7.033315440528645e+00},
	{"WOZ", -2.212880408311336e+01, -1.315192874673757e+01},
	{"WPA", -1.683613365780370e+01, -2.424702683226605e+00},
	{"WPB", -2.813838371329960e+01, -1.372695273872251e+01},
	{"WPC", -2.903425552299864e+01, -1.462282454842155e+01},
	{"WPD", -2.212647918226219e+01, -7.715048207685096e+00},
	{"WPE", -1.731534804542778e+01, -2.903917070850688e+00},
	{"WPF", -2.811460738312356e+01, -1.370317640854646e+01},
	{"WPG", -1.854875520765625e+01, -4.137324233079156e+00},
	{"WPH", -1.966192957714522e+01, -5.250498602568122e+00},
	{"WPI", -1.891584393985425e+01, -4.504412965277153e+00},
	{"WPJ", -3.172888224342066e+01, -1.731745126884357e+01},
	{"WPK", -3.162948012371387e+01, -1.721804914913678e+01},
	{"WPL", -1.814768287179890e+01, -3.736251897221808e+00},
	{"WPM", -2.733403292755703e+01, -1.292260195297994e+01},
	{"WPN", -2.946218857445532e+01, -1.505075759987823e+01},
	{"WPO", -1.720755703821594e+01, -2.796126063638845e+00},
	{"WPP", -2.144102610716281e+01, -7.029595132585714e+00},
	{"WPQ", -3.300283018135611e+01, -1.859139920677902e+01},
	{"WPR", -1.631421736528049e+01, -1.902786390703399e+00},
	{"WPS", -2.329463630897402e+01, -8.883205334396932e+00},
	{"WPT", -2.397316427579912e+01, -9.561733301222029e+00},
	{"WPU", -1.873327339539179e+01, -4.321842420814697e+00},
	{"WPV", -3.116079781659975e+01, -1.674936684202265e+01},
	{"WPW", -2.736170358009110e+01, -1.295027260551401e+01},
	{"WPX", -3.650400888676391e+01, -2.209257791218682e+01},
	{"WPY", -2.671409199710781e+01, -1.230266102253072e+01},
	{"WPZ", -3.480912451221501e+01, -2.039769353763792e+01},
	{"WQA", -2.877759334217760e+01, -1.011254122088938e+01},
	{"WQB", -3.140723761663533e+01, -1.274218549534710e+01},
	{"WQC", -3.031179094418798e+01, -1.164673882289975e+01},
	{"WQD", -3.192894147672525e+01, -1.326388935543703e+01},
	{"WQE", -3.231683602086950e+01, -1.365178389958127e+01},
	{"WQF", -3.067574042012611e+01, -1.201068829883788e+01},
	{"WQG", -3.739256439450761e+01, -1.872751227321939e+01},
	{"WQH", -3.122729907698523e+01, -1.256224695569701e+01},
	{"WQI", -2.711885968487729e+01, -8.453807563589063e+00},
	{"WQJ", -3.319261085212703e+01, -1.452755873083880e+01},
	{"WQK", -3.902474958944635e+01, -2.035969746815812e+01},
	{"WQL", -3.166968665042824e+01, -1.300463452914001e+01},
	{"WQM", -3.084729980828755e+01, -1.218224768699932e+01},
	{"WQN", -3.367661718525629e+01, -1.501156506396807e+01},
	{"WQO", -3.187306301598173e+01, -1.320801089469350e+01},
	{"WQP", -3.187524840240759e+01, -1.321019628111936e+01},
	{"WQQ", -3.375665135114469e+01, -1.509159922985646e+01},
	{"WQR", -3.172195185385945e+01, -1.305689973257122e+01},
	{"WQS", -2.879426400914820e+01, -1.012921188785997e+01},
	{"WQT", -2.929393501308251e+01, -1.062888289179428e+01},
	{"WQU", -1.867565412741753e+01, -1.060200612930340e-02},
	{"WQV", -3.458780503149796e+01, -1.592275291020974e+01},
	{"WQW", -3.094605785564424e+01, -1.228100573435601e+01},
	{"WQX", -4.104788154732928e+01, -2.238282942604106e+01},
	{"WQY", -3.524060174877607e+01, -1.657554962748784e+01},
	{"WQZ", -4.218744898407981e+01, -2.352239686279159e+01},
	{"WRA", -1.499380705217984e+01, -3.147080579385323e+00},
	{"WRB", -2.676345777393664e+01, -1.491673130114212e+01},
	{"WRC", -2.575457121090453e+01, -1.390784473811001e+01},
	{"WRD", -2.480314273002384e+01, -1.295641625722932e+01},
	{"WRE", -1.440435836743862e+01, -2.557631894644096e+00},
	{"WRF", -2.659232775356482e+01, -1.474560128077030e+01},
	{"WRG", -2.621546010711271e+01, -1.436873363431819e+01},
	{"WRH", -2.135233047462083e+01, -9.505604001826311e+00},
	{"WRI", -1.304788246771023e+01, -1.201155994915715e+00},
	{"WRJ", -2.968581554646333e+01, -1.783908907366881e+01},
	{"WRK", -2.655324195802422e+01, -1.470651548522971e+01},
	{"WRL", -2.351231691238082e+01, -1.166559043958630e+01},
	{"WRM", -2.542843373739729e+01, -1.358170726460277e+01},
	{"WRN", -2.548384257735481e+01, -1.363711610456029e+01},
	{"WRO", -1.382506052866847e+01, -1.978334055873947e+00},
	{"WRP", -2.668630768685400e+01, -1.483958121405948e+01},
	{"WRQ", -3.107235167670411e+01, -1.922562520390958e+01},
	{"WRR", -2.595557846424060e+01, -1.410885199144607e+01},
	{"WRS", -2.147979994782641e+01, -9.633073475031892e+00},
	{"WRT", -2.390068077037685e+01, -1.205395429758233e+01},
	{"WRU", -1.801227593131727e+01, -6.165549458522747e+00},
	{"WRV", -2.700349501662119e+01, -1.515676854382667e+01},
	{"WRW", -2.635906483223441e+01, -1.451233835943989e+01},
	{"WRX", -3.173747784946356e+01, -1.989075137666904e+01},
	{"WRY", -1.838354756846448e+01, -6.536821095669962e+00},
	{"WRZ", -3.266860038330982e+01, -2.082187391051529e+01},
	{"WSA", -1.415310515235318e+01, -2.695075534634456e+00},
	{"WSB", -1.666928757830741e+01, -5.211257960588682e+00},
	{"WSC", -1.706435307292215e+01, -5.606323455203421e+00},
	{"WSD", -1.821763635934972e+01, -6.759606741630995e+00},
	{"WSE", -1.603161818500523e+01, -4.573588567286502e+00},
	{"WSF", -1.691803422874154e+01, -5.460004611022812e+00},
	{"WSG", -1.875645120611599e+01, -7.298421588397263e+00},
	{"WSH", -1.489239770130223e+01, -3.434368083583507e+00},
	{"WSI", -1.530526330316519e+01, -3.847233685446457e+00},
	{"WSJ", -2.039073443842106e+01, -8.932704820702330e+00},
	{"WSK", -1.989740798260986e+01, -8.439378364891137e+00},
	{"WSL", -1.735440310867816e+01, -5.896373490959433e+00},
	{"WSM", -1.750035823383048e+01, -6.042328616111753e+00},
	{"WSN", -1.694610501874504e+01, -5.488075401026314e+00},
	{"WSO", -1.422998456612106e+01, -2.771954948402333e+00},
	{"WSP", -1.579478758605381e+01, -4.336757968335084e+00},
	{"WSQ", -2.012837251204243e+01, -8.670342894323706e+00},
	{"WSR", -1.725462708298425e+01, -5.796597465265523e+00},
	{"WSS", -1.666567655469574e+01, -5.207646936977008e+00},
	{"WST", -1.420401960858695e+01, -2.745989990868227e+00},
	{"WSU", -1.646219345107236e+01, -5.004163833353631e+00},
	{"WSV", -2.089590493664686e+01, -9.437875318928141e+00},
	{"WSW", -1.541536688417295e+01, -3.957337266454225e+00},
	{"WSX", -3.027386034366935e+01, -1.881583072595062e+01},
	{"WSY", -1.858279191707797e+01, -7.124762299359242e+00},
	{"WSZ", -3.174326250305344e+01, -2.028523288533471e+01},
	{"WTA", -1.840636740470089e+01, -7.078315521839919e+00},
	{"WTB", -2.677106224129887e+01, -1.544301035843790e+01},
	{"WTC", -2.684334324028532e+01, -1.551529135742434e+01},
	{"WTD", -2.749296368293028e+01, -1.616491180006931e+01},
	{"WTE", -1.727462713838392e+01, -5.946575255522937e+00},
	{"WTF", -2.700138071333683e+01, -1.567332883047585e+01},
	{"WTG", -2.794301561645388e+01, -1.661496373359291e+01},
	{"WTH", -1.165287908332288e+01, -3.248272004619071e-01},
	{"WTI", -1.850446217033244e+01, -7.176410287471463e+00},
	{"WTJ", -3.009852290632884e+01, -1.877047102346786e+01},
	{"WTK", -2.992878167868840e+01, -1.860072979582742e+01},
	{"WTL", -2.634559809089706e+01, -1.501754620803609e+01},
	{"WTM", -2.685495993573404e+01, -1.552690805287306e+01},
	{"WTN", -2.753483280527911e+01, -1.620678092241813e+01},
	{"WTO", -1.411604306862374e+01, -2.787991185762764e+00},
	{"WTP", -2.760646977058904e+01, -1.627841788772806e+01},
	{"WTQ", -3.206508711351720e+01, -2.073703523065623e+01},
	{"WTR", -1.737103844887686e+01, -6.042986566015881e+00},
	{"WTS", -2.320070832979601e+01, -1.187265644693503e+01},
	{"WTT", -2.434742897357731e+01, -1.301937709071633e+01},
	{"WTU", -1.911934928926805e+01, -7.791297406407076e+00},
	{"WTV", -3.005482886004188e+01, -1.872677697718091e+01},
	{"WTW", -1.905883484582122e+01, -7.730782962960245e+00},
	{"WTX", -3.477088990028081e+01, -2.344283801741983e+01},
	{"WTY", -2.086743658115546e+01, -9.539384698294484e+00},
	{"WTZ", -3.224412335724168e+01, -2.091607147438070e+01},
	{"WUA", -2.531324899266575e+01, -1.051858633632841e+01},
	{"WUB", -2.570263507367356e+01, -1.090797241733621e+01},
	{"WUC", -2.488813464896233e+01, -1.009347199262499e+01},
	{"WUD", -2.562814676787328e+01, -1.083348411153594e+01},
	{"WUE", -2.130638511240376e+01, -6.511722456066416e+00},
	{"WUF", -2.728765644286276e+01, -1.249299378652542e+01},
	{"WUG", -2.484374471355749e+01, -1.004908205722016e+01},
	{"WUH", -2.795781349200633e+01, -1.316315083566899e+01},
	{"WUI", -2.537317546018894e+01, -1.057851280385160e+01},
	{"WUJ", -3.224555888868554e+01, -1.745089623234820e+01},
	{"WUK", -2.366607226447239e+01, -8.871409608135053e+00},
	{"WUL", -2.371091074253222e+01, -8.916248086194884e+00},
	{"WUM", -1.968620549340606e+01, -4.891542837068718e+00},
	{"WUN", -1.648578841742860e+01, -1.691125761091257e+00},
	{"WUO", -2.859086632346906e+01, -1.379620366713172e+01},
	{"WUP", -1.609307715383753e+01, -1.298414497500185e+00},
	{"WUQ", -3.370716283972092e+01, -1.891250018338358e+01},
	{"WUR", -2.100777165496421e+01, -6.213108998626864e+00},
	{"WUS", -1.774935571454142e+01, -2.954693058204084e+00},
	{"WUT", -2.124150065110758e+01, -6.446837994770235e+00},
	{"WUU", -3.105033087304528e+01, -1.625566821670794e+01},
	{"WUV", -2.370533950609347e+01, -8.910676849756131e+00},
	{"WUW", -2.807271973084436e+01, -1.327805707450702e+01},
	{"WUX", -3.066811938372724e+01, -1.587345672738990e+01},
	{"WUY", -2.270896057356772e+01, -7.914297917230384e+00},
	{"WUZ", -1.863156428415022e+01, -3.836901627812884e+00},
	{"WVA", -1.883235697742280e+01, -2.317131493489399e+00},
	{"WVB", -3.326703618146291e+01, -1.675181069752951e+01},
	{"WVC", -3.345639250880312e+01, -1.694116702486972e+01},
	{"WVD", -3.271146464254715e+01, -1.619623915861375e+01},
	{"WVE", -1.795937906109797e+01, -1.444153577164562e+00},
	{"WVF", -3.291581188783469e+01, -1.640058640390128e+01},
	{"WVG", -3.422420427515617e+01, -1.770897879122277e+01},
	{"WVH", -3.193904525058462e+01, -1.542381976665122e+01},
	{"WVI", -1.870814156158060e+01, -2.192916077647202e+00},
	{"WVJ", -3.414706197579678e+01, -1.763183649186338e+01},
	{"WVK", -3.602666259857510e+01, -1.951143711464170e+01},
	{"WVL", -3.329890567026061e+01, -1.678368018632720e+01},
	{"WVM", -3.228341997708034e+01, -1.576819449314694e+01},
	{"WVN", -3.139382820819853e+01, -1.487860272426513e+01},
	{"WVO", -1.875002516472347e+01, -2.234799680790070e+00},
	{"WVP", -3.238201545697058e+01, -1.586678997303717e+01},
	{"WVQ", -3.997885737191059e+01, -2.346363188797719e+01},
	{"WVR", -3.033805100406136e+01, -1.382282552012796e+01},
	{"WVS", -3.137582719359671e+01, -1.486060170966330e+01},
	{"WVT", -3.068322890205936e+01, -1.416800341812596e+01},
	{"WVU", -3.027131145765805e+01, -1.375608597372464e+01},
	{"WVV", -3.487243453752147e+01, -1.835720905358806e+01},
	{"WVW", -3.201519416536383e+01, -1.549996868143042e+01},
	{"WVX", -3.660467818900725e+01, -2.008945270507384e+01},
	{"WVY", -2.842752062497782e+01, -1.191229514104441e+01},
	{"WVZ", -4.001455707156497e+01, -2.349933158763156e+01},
	{"WWA", -1.563644533702714e+01, -3.089200414003446e+00},
	{"WWB", -2.845127439409734e+01, -1.590402947107365e+01},
	{"WWC", -2.850916601302462e+01, -1.596192109000093e+01},
	{"WWD", -2.802265601314835e+01, -1.547541109012466e+01},
	{"WWE", -1.569852637005159e+01, -3.151281447027898e+00},
	{"WWF", -2.830424379928407e+01, -1.575699887626038e+01},
	{"WWG", -1.661032282636663e+01, -4.063077903342945e+00},
	{"WWH", -1.403085552837863e+01, -1.483610605354942e+00},
	{"WWI", -1.523181885987583e+01, -2.684573936852141e+00},
	{"WWJ", -3.078768169208714e+01, -1.824043676906345e+01},
	{"WWK", -3.094269415561315e+01, -1.839544923258947e+01},
	{"WWL", -2.737272641611463e+01, -1.482548149309094e+01},
	{"WWM", -2.807355865222212e+01, -1.552631372919843e+01},
	{"WWN", -2.494784861361888e+01, -1.240060369059519e+01},
	{"WWO", -1.590530037697977e+01, -3.358055453956079e+00},
	{"WWP", -1.854819898709790e+01, -6.000954064074214e+00},
	{"WWQ", -3.341504346596316e+01, -2.086779854293947e+01},
	{"WWR", -1.970682641458206e+01, -7.159581491558376e+00},
	{"WWS", -2.620802096239366e+01, -1.366077603936997e+01},
	{"WWT", -2.607804322753591e+01, -1.353079830451222e+01},
	{"WWU", -2.954465400101228e+01, -1.699740907798859e+01},
	{"WWV", -3.126521682860834e+01, -1.871797190558465e+01},
	{"WWW", -1.625892906004721e+01, -3.711684137023522e+00},
	{"WWX", -4.060884973208857e+01, -2.806160480906488e+01},
	{"WWY", -2.824616497797042e+01, -1.569892005494673e+01},
	{"WWZ", -3.413183338272773e+01, -2.158458845970404e+01},
	{"WXA", -2.933413204929687e+01, -3.475273661883234e+00},
	{"WXB", -3.390145665833132e+01, -8.042598270917683e+00},
	{"WXC", -2.886245631588147e+01, -3.003597928467834e+00},
	{"WXD", -3.329484481125127e+01, -7.435986423837630e+00},
	{"WXE", -2.894012559021168e+01, -3.081267202798049e+00},
	{"WXF", -3.343695427730677e+01, -7.578095889893132e+00},
	{"WXG", -3.473601881742253e+01, -8.877160430008891e+00},
	{"WXH", -3.109419264328584e+01, -5.235334255872204e+00},
	{"WXI", -2.893440372522058e+01, -3.075545337806950e+00},
	{"WXJ", -3.594898794344644e+01, -1.009012955603280e+01},
	{"WXK", -3.684707423389283e+01, -1.098821584647919e+01},
	{"WXL", -3.339430825071630e+01, -7.535449863302660e+00},
	{"WXM", -3.267749386871079e+01, -6.818635481297159e+00},
	{"WXN", -3.514334371037705e+01, -9.284485322963413e+00},
	{"WXO", -3.169186503178608e+01, -5.833006644372449e+00},
	{"WXP", -2.831025332246931e+01, -2.451394935055676e+00},
	{"WXQ", -3.484928359315958e+01, -8.990425205745950e+00},
	{"WXR", -3.346747099111285e+01, -7.608612603699212e+00},
	{"WXS", -3.275935644512393e+01, -6.900498057710297e+00},
	{"WXT", -2.810938817908816e+01, -2.250529791674533e+00},
	{"WXU", -3.197235377863274e+01, -6.113495391219105e+00},
	{"WXV", -3.159452703111083e+01, -5.735668643697198e+00},
	{"WXW", -3.278308614571097e+01, -6.924227758297334e+00},
	{"WXX", -3.238002938529029e+01, -6.521170997876658e+00},
	{"WXY", -3.256654207669613e+01, -6.707683689282498e+00},
	{"WXZ", -4.638630334605919e+01, -2.052744495864555e+01},
	{"WYA", -2.117330753486759e+01, -7.675560609787332e+00},
	{"WYB", -2.182303148077975e+01, -8.325284555699488e+00},
	{"WYC", -1.903783642874698e+01, -5.540089503666719e+00},
	{"WYD", -2.311578665742910e+01, -9.618039732348834e+00},
	{"WYE", -1.506986108963586e+01, -1.572114164555595e+00},
	{"WYF", -2.300619809454243e+01, -9.508451169462163e+00},
	{"WYG", -2.334562437343621e+01, -9.847877448355941e+00},
	{"WYH", -2.420021621803554e+01, -1.070246929295527e+01},
	{"WYI", -2.166144328759726e+01, -8.163696362516998e+00},
	{"WYJ", -2.754471622635156e+01, -1.404696930127130e+01},
	{"WYK", -2.734139944635653e+01, -1.384365252127627e+01},
	{"WYL", -2.193937194349754e+01, -8.441625018417279e+00},
	{"WYM", -2.044465449500934e+01, -6.946907569929077e+00},
	{"WYN", -1.806668552075030e+01, -4.568938595670033e+00},
	{"WYO", -1.436865473182254e+01, -8.709078067422794e-01},
	{"WYP", -2.122842770107875e+01, -7.730680775998486e+00},
	{"WYQ", -2.946114738444441e+01, -1.596340045936415e+01},
	{"WYR", -2.102534612605248e+01, -7.527599200972212e+00},
	{"WYS", -2.074954005486563e+01, -7.251793129785372e+00},
	{"WYT", -2.090426068146769e+01, -7.406513756387427e+00},
	{"WYU", -2.611303681618732e+01, -1.261528989110706e+01},
	{"WYV", -2.723573128833959e+01, -1.373798436325932e+01},
	{"WYW", -2.171327314641336e+01, -8.215526221333095e+00},
	{"WYX", -3.154407854992305e+01, -1.804633162484278e+01},
	{"WYY", -2.654865434536180e+01, -1.305090742028154e+01},
	{"WYZ", -3.087814069621996e+01, -1.738039377113970e+01},
	{"WZA", -2.374612216409716e+01, -4.364280126044368e+00},
	{"WZB", -2.909796540986012e+01, -9.716123371807324e+00},
	{"WZC", -2.998288022810169e+01, -1.060103819004890e+01},
	{"WZD", -3.034204606950453e+01, -1.096020403145173e+01},
	{"WZE", -1.967426747826267e+01, -2.924254402098804e-01},
	{"WZF", -2.992917763587912e+01, -1.054733559782633e+01},
	{"WZG", -3.045214680900634e+01, -1.107030477095354e+01},
	{"WZH", -2.906888393915623e+01, -9.687041901103429e+00},
	{"WZI", -2.429642350556824e+01, -4.914581467515446e+00},
	{"WZJ", -3.297587151116350e+01, -1.359402947311071e+01},
	{"WZK", -3.161137157154985e+01, -1.222952953349706e+01},
	{"WZL", -2.730160670819631e+01, -7.919764670143516e+00},
	{"WZM", -2.950986263788633e+01, -1.012802059983353e+01},
	{"WZN", -3.061269026650598e+01, -1.123084822845318e+01},
	{"WZO", -2.562394557916057e+01, -6.242103541107774e+00},
	{"WZP", -2.842825498673616e+01, -9.046412948683372e+00},
	{"WZQ", -3.689208540048685e+01, -1.751024336243405e+01},
	{"WZR", -2.367845101428297e+01, -4.296608976230175e+00},
	{"WZS", -2.925983437979443e+01, -9.877992341741642e+00},
	{"WZT", -2.775976666091778e+01, -8.377924622864983e+00},
	{"WZU", -2.716200504601386e+01, -7.780163007961060e+00},
	{"WZV", -3.005956620463114e+01, -1.067772416657835e+01},
	{"WZW", -2.872305337976701e+01, -9.341211341714216e+00},
	{"WZX", -3.970022196193169e+01, -2.031837992387889e+01},
	{"WZY", -2.813429995189512e+01, -8.752457913842330e+00},
	{"WZZ", -2.573057951541379e+01, -6.348737477360996e+00},
	{"XAA", -2.266555478553344e+01, -9.827209560509990e+00},
	{"XAB", -2.047559492302997e+01, -7.637249698006523e+00},
	{"XAC", -1.560540598371280e+01, -2.767060758689349e+00},
	{"XAD", -2.003729399864553e+01, -7.198948773622083e+00},
	{"XAE", -2.729345145172319e+01, -1.445510622669974e+01},
	{"XAF", -2.051111431929247e+01, -7.672769094269023e+00},
	{"XAG", -1.831091298220920e+01, -5.472567757185749e+00},
	{"XAH", -2.659626600429803e+01, -1.375792077927458e+01},
	{"XAI", -2.402380233877605e+01, -1.118545711375261e+01},
	{"XAJ", -2.932378275236131e+01, -1.648543752733786e+01},
	{"XAK", -2.565460502429341e+01, -1.281625979926996e+01},
	{"XAL", -1.618866675536017e+01, -3.350321530336718e+00},
	{"XAM", -1.429446534883550e+01, -1.456120123812048e+00},
	{"XAN", -1.549718438491385e+01, -2.658839159890397e+00},
	{"XAO", -2.892331816986508e+01, -1.608497294484163e+01},
	{"XAP", -2.048802236781304e+01, -7.649677142789591e+00},
	{"XAQ", -2.922237594630690e+01, -1.638403072128345e+01},
	{"XAR", -1.881458676693762e+01, -5.976241541914171e+00},
	{"XAS", -1.645385934206126e+01, -3.615514117037813e+00},
	{"XAT", -1.635491087581842e+01, -3.516565650794968e+00},
	{"XAU", -2.583991831406330e+01, -1.300157308903984e+01},
	{"XAV", -2.476991971338164e+01, -1.193157448835819e+01},
	{"XAW", -2.342510374775894e+01, -1.058675852273549e+01},
	{"XAX", -2.907942834101116e+01, -1.624108311598770e+01},
	{"XAY", -2.470451589375132e+01, -1.186617066872787e+01},
	{"XAZ", -2.904557374350167e+01, -1.620722851847823e+01},
	{"XBA", -1.929972970302300e+01, -1.894059868965102e+00},
	{"XBB", -2.813152987352011e+01, -1.072586003946221e+01},
	{"XBC", -2.883547409410254e+01, -1.142980426004464e+01},
	{"XBD", -3.014091043142927e+01, -1.273524059737138e+01},
	{"XBE", -1.931404988117536e+01, -1.908380047117462e+00},
	{"XBF", -3.172971534881176e+01, -1.432404551475386e+01},
	{"XBG", -3.332623844243778e+01, -1.592056860837989e+01},
	{"XBH", -3.057135689859160e+01, -1.316568706453370e+01},
	{"XBI", -2.200513289688120e+01, -4.599463062823304e+00},
	{"XBJ", -2.812672065760875e+01, -1.072105082355085e+01},
	{"XBK", -3.358205339309883e+01, -1.617638355904094e+01},
	{"XBL", -2.421289320111035e+01, -6.807223367052452e+00},
	{"XBM", -2.990059385434403e+01, -1.249492402028613e+01},
	{"XBN", -3.067964152850342e+01, -1.327397169444551e+01},
	{"XBO", -2.097473730855060e+01, -3.569067474492700e+00},
	{"XBP", -3.139128404676245e+01, -1.398561421270455e+01},
	{"XBQ", -3.744944446454591e+01, -2.004377463048801e+01},
	{"XBR", -2.033213399265818e+01, -2.926464158600278e+00},
	{"XBS", -2.670652102798864e+01, -9.300851193930736e+00},
	{"XBT", -2.738096039020181e+01, -9.975290556143918e+00},
	{"XBU", -1.983572956352434e+01, -2.430059729466441e+00},
	{"XBV", -3.136395109399667e+01, -1.395828125993877e+01},
	{"XBW", -3.077251413505303e+01, -1.336684430099513e+01},
	{"XBX", -4.073665230378650e+01, -2.333098246972861e+01},
	{"XBY", -2.435841983491485e+01, -6.952750000856952e+00},
	{"XBZ", -3.524475617955391e+01, -1.783908634549601e+01},
	{"XCA", -1.805917398780206e+01, -5.692504496194012e+00},
	{"XCB", -3.035293127134071e+01, -1.798626177973266e+01},
	{"XCC", -2.558369630290080e+01, -1.321702681129275e+01},
	{"XCD", -2.932687562122886e+01, -1.696020612962081e+01},
	{"XCE", -1.319412582317229e+01, -8.274563315642371e-01},
	{"XCF", -3.021174140508363e+01, -1.784507191347557e+01},
	{"XCG", -3.116729285651376e+01, -1.880062336490572e+01},
	{"XCH", -1.649986507451456e+01, -4.133195582906510e+00},
	{"XCI", -1.535813656984905e+01, -2.991467078241001e+00},
	{"XCJ", -3.308576108249483e+01, -2.071909159088678e+01},
	{"XCK", -2.484571118376183e+01, -1.247904169215378e+01},
	{"XCL", -1.501330887804188e+01, -2.646639386433826e+00},
	{"XCM", -3.011413004482124e+01, -1.774746055321319e+01},
	{"XCN", -3.098618752156521e+01, -1.861951802995717e+01},
	{"XCO", -1.809340931462421e+01, -5.726739823016164e+00},
	{"XCP", -2.940483108015842e+01, -1.703816158855037e+01},
	{"XCQ", -2.951582323862481e+01, -1.714915374701676e+01},
	{"XCR", -1.967800000134204e+01, -7.311330509733987e+00},
	{"XCS", -2.799815740639648e+01, -1.563148791478843e+01},
	{"XCT", -2.363435645180799e+01, -1.126768696019994e+01},
	{"XCU", -1.672534928005506e+01, -4.358679788447011e+00},
	{"XCV", -3.278095512796573e+01, -2.041428563635768e+01},
	{"XCW", -2.848921895730136e+01, -1.612254946569331e+01},
	{"XCX", -3.412431084463091e+01, -2.175764135302287e+01},
	{"XCY", -2.709273852309699e+01, -1.472606903148894e+01},
	{"XCZ", -3.273536068915634e+01, -2.036869119754829e+01},
	{"XDA", -1.835049533526901e+01, -1.551437348291159e+00},
	{"XDB", -2.475267451031993e+01, -7.953616523342089e+00},
	{"XDC", -2.589777153056385e+01, -9.098713543586003e+00},
	{"XDD", -2.568942915926047e+01, -8.890371172282626e+00},
	{"XDE", -1.864643831505365e+01, -1.847380328075801e+00},
	{"XDF", -2.540585005719780e+01, -8.606792070219960e+00},
	{"XDG", -2.613278662788640e+01, -9.333728640908552e+00},
	{"XDH", -2.475888981143898e+01, -7.959831824461133e+00},
	{"XDI", -1.977109355228780e+01, -2.972035565309956e+00},
	{"XDJ", -2.776068461847047e+01, -1.096162663149263e+01},
	{"XDK", -2.893753043884628e+01, -1.213847245186843e+01},
	{"XDL", -2.596135067014955e+01, -9.162292683171707e+00},
	{"XDM", -2.551495753768075e+01, -8.715899550702909e+00},
	{"XDN", -2.578427961301190e+01, -8.985221626034056e+00},
	{"XDO", -1.972383592215841e+01, -2.924777935180568e+00},
	{"XDP", -2.617133690183851e+01, -9.372278914860669e+00},
	{"XDQ", -3.038142196935980e+01, -1.358236398238196e+01},
	{"XDR", -2.083416759932008e+01, -4.035109612342231e+00},
	{"XDS", -2.404959706203863e+01, -7.250539075060780e+00},
	{"XDT", -2.312000261260837e+01, -6.320944625630526e+00},
	{"XDU", -2.326844003633702e+01, -6.469382049359175e+00},
	{"XDV", -2.746669176310678e+01, -1.066763377612893e+01},
	{"XDW", -2.483874679838812e+01, -8.039688811410272e+00},
	{"XDX", -3.528061227063400e+01, -1.848155428365616e+01},
	{"XDY", -2.620703193126390e+01, -9.407973944286052e+00},
	{"XDZ", -3.136305407095250e+01, -1.456399608397465e+01},
	{"XEA", -1.983781073617879e+01, -7.393471970240526e+00},
	{"XEB", -2.129379791375813e+01, -8.849459147819863e+00},
	{"XEC", -1.484132369398110e+01, -2.396984928042834e+00},
	{"XED", -1.450609191375934e+01, -2.061753147821070e+00},
	{"XEE", -2.410597511010972e+01, -1.166163634417146e+01},
	{"XEF", -2.235312885572412e+01, -9.908790089785851e+00},
	{"XEG", -2.198591041660592e+01, -9.541571650667656e+00},
	{"XEH", -2.082474650530274e+01, -8.380407739364479e+00},
	{"XEI", -2.029547285474673e+01, -7.851134088808467e+00},
	{"XEJ", -2.836004950496240e+01, -1.591571073902413e+01},
	{"XEK", -2.697264008189649e+01, -1.452830131595822e+01},
	{"XEL", -1.972201404607038e+01, -7.277675280132116e+00},
	{"XEM", -1.660045352924191e+01, -4.156114763303641e+00},
	{"XEN", -1.636881196161130e+01, -3.924473195673033e+00},
	{"XEO", -2.438696156294789e+01, -1.194262279700962e+01},
	{"XEP", -2.306432772760909e+01, -1.061998896167082e+01},
	{"XEQ", -2.363717965895390e+01, -1.119284089301563e+01},
	{"XER", -1.437137449591698e+01, -1.927035729978711e+00},
	{"XES", -1.540371009868246e+01, -2.959371332744195e+00},
	{"XET", -1.959524524334243e+01, -7.150906477404160e+00},
	{"XEU", -2.638194746961422e+01, -1.393760870367595e+01},
	{"XEV", -2.195795621445639e+01, -9.513617448518124e+00},
	{"XEW", -2.150475969270613e+01, -9.060420926767859e+00},
	{"XEX", -1.804015683350757e+01, -5.595818067569305e+00},
	{"XEY", -2.519976897094939e+01, -1.275543020501113e+01},
	{"XEZ", -3.007347581819174e+01, -1.762913705225347e+01},
	{"XFA", -2.030744536885697e+01, -3.366277915823627e+00},
	{"XFB", -2.746140982558077e+01, -1.052024237254742e+01},
	{"XFC", -2.687528197490554e+01, -9.934114521872194e+00},
	{"XFD", -2.775725486569501e+01, -1.081608741266166e+01},
	{"XFE", -1.996060043089584e+01, -3.019432977862491e+00},
	{"XFF", -2.518698450746931e+01, -8.245817054435957e+00},
	{"XFG", -2.741182438552839e+01, -1.047065693249504e+01},
	{"XFH", -2.621230194574387e+01, -9.271134492710527e+00},
	{"XFI", -2.098304834811597e+01, -4.041880895082622e+00},
	{"XFJ", -2.820011895947047e+01, -1.125895150643712e+01},
	{"XFK", -3.009629972442000e+01, -1.315513227138666e+01},
	{"XFL", -2.590263190650387e+01, -8.961464453470525e+00},
	{"XFM", -2.654348593649411e+01, -9.602318483460763e+00},
	{"XFN", -2.816504084406140e+01, -1.122387339102805e+01},
	{"XFO", -1.778566983654771e+01, -8.445023835143585e-01},
	{"XFP", -2.707551879100937e+01, -1.013435133797602e+01},
	{"XFQ", -3.234314529469258e+01, -1.540197784165923e+01},
	{"XFR", -1.996061635800546e+01, -3.019448904972111e+00},
	{"XFS", -2.640310560810740e+01, -9.461938155074057e+00},
	{"XFT", -2.338404085110848e+01, -6.442873398075137e+00},
	{"XFU", -2.342533528439170e+01, -6.484167831358351e+00},
	{"XFV", -2.937712758799703e+01, -1.243596013496368e+01},
	{"XFW", -2.712944251259569e+01, -1.018827505956235e+01},
	{"XFX", -3.465451679902609e+01, -1.771334934599274e+01},
	{"XFY", -2.777197485680206e+01, -1.083080740376871e+01},
	{"XFZ", -3.078311025855262e+01, -1.384194280551927e+01},
	{"XGA", -2.181483448290722e+01, -3.574602489758117e+00},
	{"XGB", -2.735622227830990e+01, -9.115990285160791e+00},
	{"XGC", -2.760724883831932e+01, -9.367016845170214e+00},
	{"XGD", -2.747835389177840e+01, -9.238121898629293e+00},
	{"XGE", -2.040778276857789e+01, -2.167550775428782e+00},
	{"XGF", -2.716193266702108e+01, -8.921700673871976e+00},
	{"XGG", -2.730342280705927e+01, -9.063190813910172e+00},
	{"XGH", -2.382588725882494e+01, -5.585655265675833e+00},
	{"XGI", -2.239109383162563e+01, -4.150861838476525e+00},
	{"XGJ", -3.083127341500279e+01, -1.259104142185369e+01},
	{"XGK", -3.106958734830004e+01, -1.282935535515093e+01},
	{"XGL", -2.203015766447591e+01, -3.789925671326806e+00},
	{"XGM", -2.711371768262325e+01, -8.873485689474148e+00},
	{"XGN", -2.622654944000659e+01, -7.986317446857486e+00},
	{"XGO", -2.120134862620923e+01, -2.961116633060123e+00},
	{"XGP", -2.759950983952505e+01, -9.359277846375939e+00},
	{"XGQ", -3.236266644291810e+01, -1.412243444976899e+01},
	{"XGR", -1.996858699668428e+01, -1.728355003535175e+00},
	{"XGS", -2.543948660947519e+01, -7.199254616326083e+00},
	{"XGT", -2.455219882495509e+01, -6.311966831805979e+00},
	{"XGU", -2.201455761095603e+01, -3.774325617806928e+00},
	{"XGV", -3.020310822483859e+01, -1.196287623168948e+01},
	{"XGW", -2.678425185281058e+01, -8.544019859661478e+00},
	{"XGX", -3.558148690936546e+01, -1.734125491621635e+01},
	{"XGY", -2.755609706417803e+01, -9.315865071028924e+00},
	{"XGZ", -3.416974042339768e+01, -1.592950843024858e+01},
	{"XHA", -1.609669855354518e+01, -1.498292734532761e+00},
	{"XHB", -2.928475171000980e+01, -1.468634589099738e+01},
	{"XHC", -2.925672782308265e+01, -1.465832200407022e+01},
	{"XHD", -2.973618084990899e+01, -1.513777503089658e+01},
	{"XHE", -1.910883456421894e+01, -4.510428745206519e+00},
	{"XHF", -2.927141292911859e+01, -1.467300711010617e+01},
	{"XHG", -3.025501995546071e+01, -1.565661413644829e+01},
	{"XHH", -2.819210302005444e+01, -1.359369720104202e+01},
	{"XHI", -1.643512316770150e+01, -1.836717348689081e+00},
	{"XHJ", -3.217344998459067e+01, -1.757504416557825e+01},
	{"XHK", -3.249705337330807e+01, -1.789864755429565e+01},
	{"XHL", -2.979582452125733e+01, -1.519741870224491e+01},
	{"XHM", -2.879675112993381e+01, -1.419834531092139e+01},
	{"XHN", -2.970775305676936e+01, -1.510934723775694e+01},
	{"XHO", -1.744304146086700e+01, -2.844635641854577e+00},
	{"XHP", -2.964058810863556e+01, -1.504218228962314e+01},
	{"XHQ", -3.392944787647964e+01, -1.933104205746722e+01},
	{"XHR", -2.759613942669458e+01, -1.299773360768216e+01},
	{"XHS", -2.824505176159924e+01, -1.364664594258683e+01},
	{"XHT", -2.576401055330995e+01, -1.116560473429753e+01},
	{"XHU", -1.705819092633731e+01, -2.459785107324889e+00},
	{"XHV", -3.241218457371987e+01, -1.781377875470745e+01},
	{"XHW", -2.838290513443411e+01, -1.378449931542169e+01},
	{"XHX", -3.792538490542280e+01, -2.332697908641038e+01},
	{"XHY", -2.782138603044326e+01, -1.322298021143084e+01},
	{"XHZ", -3.493726715129651e+01, -2.033886133228409e+01},
	{"XIA", -2.005547406350838e+01, -7.616857162561216e+00},
	{"XIB", -1.838795218848403e+01, -5.949335287536864e+00},
	{"XIC", -1.589560295494178e+01, -3.456986053994615e+00},
	{"XID", -1.703347299513010e+01, -4.594856094182930e+00},
	{"XIE", -1.709067125081993e+01, -4.652054349872770e+00},
	{"XIF", -2.125888499921655e+01, -8.820268098269386e+00},
	{"XIG", -2.016742615728243e+01, -7.728809256335270e+00},
	{"XIH", -2.265431724697325e+01, -1.021570034602609e+01},
	{"XII", -1.710285659417195e+01, -4.664239693224784e+00},
	{"XIJ", -2.212958113999482e+01, -9.690964239047654e+00},
	{"XIK", -2.669541599966319e+01, -1.425679909871603e+01},
	{"XIL", -1.681987809558911e+01, -4.381261194641944e+00},
	{"XIM", -1.565240577524481e+01, -3.213788874297642e+00},
	{"XIN", -1.591856274776404e+01, -3.479945846816873e+00},
	{"XIO", -1.579699463171472e+01, -3.358377730767560e+00},
	{"XIP", -2.133626797672292e+01, -8.897651075775752e+00},
	{"XIQ", -2.941320324276262e+01, -1.697458634181546e+01},
	{"XIR", -2.071785385153714e+01, -8.279236950589969e+00},
	{"XIS", -1.418704508207095e+01, -1.748428181123781e+00},
	{"XIT", -1.673048847084083e+01, -4.291871569893668e+00},
	{"XIU", -2.697608781929598e+01, -1.453747091834882e+01},
	{"XIV", -1.690315773195300e+01, -4.464540831005830e+00},
	{"XIW", -2.011829104270162e+01, -7.679674141754459e+00},
	{"XIX", -1.896044937073188e+01, -6.521832469784712e+00},
	{"XIY", -3.300997832334164e+01, -2.057136142239448e+01},
	{"XIZ", -2.711063432684061e+01, -1.467201742589345e+01},
	{"XJA", -2.191330895678067e+01, -2.460107837607648e+00},
	{"XJB", -3.029893880521343e+01, -1.084573768604041e+01},
	{"XJC", -3.114832845270996e+01, -1.169512733353694e+01},
	{"XJD", -3.304248603497340e+01, -1.358928491580038e+01},
	{"XJE", -2.188723278968805e+01, -2.434031670515025e+00},
	{"XJF", -3.216617193137769e+01, -1.271297081220467e+01},
	{"XJG", -3.175071282751696e+01, -1.229751170834394e+01},
	{"XJH", -3.093685583420906e+01, -1.148365471503604e+01},
	{"XJI", -2.700781542202853e+01, -7.554614302855515e+00},
	{"XJJ", -3.094264855050862e+01, -1.148944743133560e+01},
	{"XJK", -3.363122005837991e+01, -1.417801893920689e+01},
	{"XJL", -3.214005292761652e+01, -1.268685180844350e+01},
	{"XJM", -3.246748675951234e+01, -1.301428564033932e+01},
	{"XJN", -3.544604802999659e+01, -1.599284691082357e+01},
	{"XJO", -2.174810219443139e+01, -2.294901075258371e+00},
	{"XJP", -3.190783056416301e+01, -1.245462944498999e+01},
	{"XJQ", -3.489408230508889e+01, -1.544088118591586e+01},
	{"XJR", -3.111825704190932e+01, -1.166505592273631e+01},
	{"XJS", -3.155704585843793e+01, -1.210384473926492e+01},
	{"XJT", -3.165118318065698e+01, -1.219798206148396e+01},
	{"XJU", -2.070309843635103e+01, -1.249897317178010e+00},
	{"XJV", -3.851313552468974e+01, -1.905993440551672e+01},
	{"XJW", -3.088739156826071e+01, -1.143419044908769e+01},
	{"XJX", -4.119244093175857e+01, -2.173923981258555e+01},
	{"XJY", -3.766231168260318e+01, -1.820911056343016e+01},
	{"XJZ", -3.576731277606161e+01, -1.631411165688859e+01},
	{"XKA", -2.625560258674476e+01, -5.904315177125357e+00},
	{"XKB", -2.856769904972286e+01, -8.216411640103457e+00},
	{"XKC", -2.899957243204665e+01, -8.648285022427245e+00},
	{"XKD", -2.963278064443215e+01, -9.281493234812748e+00},
	{"XKE", -2.379592268504475e+01, -3.444635275425346e+00},
	{"XKF", -2.846410738784500e+01, -8.112819978225595e+00},
	{"XKG", -3.073670816516215e+01, -1.038542075554274e+01},
	{"XKH", -2.813440754203214e+01, -7.783120132412734e+00},
	{"XKI", -2.161324308637066e+01, -1.261955676751255e+00},
	{"XKJ", -3.231488264656259e+01, -1.196359523694319e+01},
	{"XKK", -3.164661273901489e+01, -1.129532532939548e+01},
	{"XKL", -2.179140434881597e+01, -1.440116939196566e+00},
	{"XKM", -2.899960994108702e+01, -8.648322531467620e+00},
	{"XKN", -2.577306699905051e+01, -5.421779589431106e+00},
	{"XKO", -2.662487091570948e+01, -6.273583506090080e+00},
	{"XKP", -2.935054958655321e+01, -8.999262176933799e+00},
	{"XKQ", -3.499402244113566e+01, -1.464273503151626e+01},
	{"XKR", -2.978615388205800e+01, -9.434866472438589e+00},
	{"XKS", -2.590446016427044e+01, -5.553172754651036e+00},
	{"XKT", -2.666934767144962e+01, -6.318060261830218e+00},
	{"XKU", -2.851741327420478e+01, -8.166125864585373e+00},
	{"XKV", -3.215503771240729e+01, -1.180375030278788e+01},
	{"XKW", -2.784085593539953e+01, -7.489568525780121e+00},
	{"XKX", -3.596606930702892e+01, -1.561478189740952e+01},
	{"XKY", -2.851107707209022e+01, -8.159789662470811e+00},
	{"XKZ", -3.406793219289866e+01, -1.371664478327926e+01},
	{"XLA", -1.991203178923763e+01, -3.013510362794753e+00},
	{"XLB", -2.657109137212444e+01, -9.672569945681561e+00},
	{"XLC", -2.718221627107505e+01, -1.028369484463217e+01},
	{"XLD", -2.448375372353214e+01, -7.585232297089265e+00},
	{"XLE", -1.814940891182987e+01, -1.250887485386992e+00},
	{"XLF", -2.349889923133307e+01, -6.600377804890196e+00},
	{"XLG", -2.800698110255665e+01, -1.110845967611378e+01},
	{"XLH", -2.743884432899943e+01, -1.054032290255655e+01},
	{"XLI", -1.896140672116529e+01, -2.062885294722415e+00},
	{"XLJ", -3.073900871984489e+01, -1.384048729340201e+01},
	{"XLK", -2.801130562315515e+01, -1.111278419671227e+01},
	{"XLL", -2.326338559095959e+01, -6.364864164516717e+00},
	{"XLM", -2.708606683582570e+01, -1.018754540938282e+01},
	{"XLN", -2.779548061763763e+01, -1.089695919119475e+01},
	{"XLO", -1.982622194895097e+01, -2.927700522508090e+00},
	{"XLP", -2.707166146881881e+01, -1.017314004237594e+01},
	{"XLQ", -3.182771297467473e+01, -1.492919154823185e+01},
	{"XLR", -2.760234755954460e+01, -1.070382613310173e+01},
	{"XLS", -2.536868450163650e+01, -8.470163075193621e+00},
	{"XLT", -2.484948726946347e+01, -7.950965843020592e+00},
	{"XLU", -2.597344516098757e+01, -9.074923734544701e+00},
	{"XLV", -2.209598396852024e+01, -5.197462542077359e+00},
	{"XLW", -2.706779475543303e+01, -1.016927332899015e+01},
	{"XLX", -3.512968115880223e+01, -1.823115973235935e+01},
	{"XLY", -2.303968763313640e+01, -6.141166206693527e+00},
	{"XLZ", -3.379117163191799e+01, -1.689265020547512e+01},
	{"XMA", -1.813441952897244e+01, -1.952712484535069e+00},
	{"XMB", -2.531804102387344e+01, -9.136333979436063e+00},
	{"XMC", -2.793621048904829e+01, -1.175450344461091e+01},
	{"XMD", -2.810319011205404e+01, -1.192148306761666e+01},
	{"XME", -1.916568800456428e+01, -2.983980960126910e+00},
	{"XMF", -2.744657213458079e+01, -1.126486509014342e+01},
	{"XMG", -2.909934744449095e+01, -1.291764040005357e+01},
	{"XMH", -2.706819322059521e+01, -1.088648617615783e+01},
	{"XMI", -1.847387132245458e+01, -2.292164278017208e+00},
	{"XMJ", -3.051999405954320e+01, -1.433828701510583e+01},
	{"XMK", -3.083605117500214e+01, -1.465434413056477e+01},
	{"XML", -2.835344401986924e+01, -1.217173697543186e+01},
	{"XMM", -2.537760414113698e+01, -9.195897096699603e+00},
	{"XMN", -2.731276303035424e+01, -1.113105598591686e+01},
	{"XMO", -1.829154786641263e+01, -2.109840821975252e+00},
	{"XMP", -2.450970723606202e+01, -8.328000191624648e+00},
	{"XMQ", -3.344436790541960e+01, -1.726266086098222e+01},
	{"XMR", -2.768269009257988e+01, -1.150098304814251e+01},
	{"XMS", -2.521530657619844e+01, -9.033599531761062e+00},
	{"XMT", -2.492450707948250e+01, -8.742800035045120e+00},
	{"XMU", -1.894977225352979e+01, -2.768065209092412e+00},
	{"XMV", -3.017864907622477e+01, -1.399694203178739e+01},
	{"XMW", -2.664027993918302e+01, -1.045857289474565e+01},
	{"XMX", -3.508405736237307e+01, -1.890235031793569e+01},
	{"XMY", -2.195342151330916e+01, -5.771714468871783e+00},
	{"XMZ", -3.371313148139994e+01, -1.753142443696256e+01},
	{"XNA", -2.196242053347702e+01, -3.271695432482976e+00},
	{"XNB", -2.776250076573936e+01, -9.071775664745319e+00},
	{"XNC", -2.583549858569043e+01, -7.144773484696378e+00},
	{"XND", -2.369575217823662e+01, -5.005027077242578e+00},
	{"XNE", -2.079841761823814e+01, -2.107692517244089e+00},
	{"XNF", -2.751668064959795e+01, -8.825955548603908e+00},
	{"XNG", -2.458466221358910e+01, -5.893937112595054e+00},
	{"XNH", -2.723131968007680e+01, -8.540594579082752e+00},
	{"XNI", -2.252256224815047e+01, -3.831837147156423e+00},
	{"XNJ", -2.992347558331979e+01, -1.123275048232575e+01},
	{"XNK", -2.858072027090422e+01, -9.889995169910177e+00},
	{"XNL", -2.798596489115442e+01, -9.295239790160375e+00},
	{"XNM", -2.793671161976511e+01, -9.245986518771060e+00},
	{"XNN", -2.788783443026414e+01, -9.197109329270090e+00},
	{"XNO", -1.974653179848049e+01, -1.055806697486442e+00},
	{"XNP", -2.842660298283024e+01, -9.735877881836197e+00},
	{"XNQ", -3.083429052251086e+01, -1.214356542151681e+01},
	{"XNR", -2.899293582204463e+01, -1.030221072105059e+01},
	{"XNS", -2.535393488879430e+01, -6.663209787800253e+00},
	{"XNT", -2.396470838565601e+01, -5.273983284661959e+00},
	{"XNU", -2.795154789689387e+01, -9.260822795899829e+00},
	{"XNV", -2.907880989859306e+01, -1.038808479759901e+01},
	{"XNW", -2.743097750685825e+01, -8.740252405864203e+00},
	{"XNX", -3.289086466469356e+01, -1.420013956369951e+01},
	{"XNY", -2.745638659729968e+01, -8.765661496305636e+00},
	{"XNZ", -3.339956970847315e+01, -1.470884460747911e+01},
	{"XOA", -2.336731729904685e+01, -8.171239091534181e+00},
	{"XOB", -2.569784360258530e+01, -1.050176539507264e+01},
	{"XOC", -2.085429924579174e+01, -5.658221038279080e+00},
	{"XOD", -2.318684796787853e+01, -7.990769760365861e+00},
	{"XOE", -2.673741806607898e+01, -1.154133985856631e+01},
	{"XOF", -1.728398457996677e+01, -2.087906372454100e+00},
	{"XOG", -2.261555526431220e+01, -7.419477056799534e+00},
	{"XOH", -2.605257784786365e+01, -1.085649964035098e+01},
	{"XOI", -2.163236835650493e+01, -6.436290148992270e+00},
	{"XOJ", -2.782553829051616e+01, -1.262946008300349e+01},
	{"XOK", -2.632168570920891e+01, -1.112560750169624e+01},
	{"XOL", -2.078883905146100e+01, -5.592760843948338e+00},
	{"XOM", -2.208486071016251e+01, -6.888782502649843e+00},
	{"XON", -1.668626787049120e+01, -1.490189662978538e+00},
	{"XOO", -2.469747779104355e+01, -9.501399583530887e+00},
	{"XOP", -2.496688625234027e+01, -9.770808044827600e+00},
	{"XOQ", -3.114065674953099e+01, -1.594457854201833e+01},
	{"XOR", -1.708253780528254e+01, -1.886459597769875e+00},
	{"XOS", -2.445336462999517e+01, -9.257286422482508e+00},
	{"XOT", -2.051064221279912e+01, -5.314564005286457e+00},
	{"XOU", -2.055357754701293e+01, -5.357499339500266e+00},
	{"XOV", -2.250109358442701e+01, -7.305015376914350e+00},
	{"XOW", -2.414065290273997e+01, -8.944574695227304e+00},
	{"XOX", -2.968809939532026e+01, -1.449202118780760e+01},
	{"XOY", -2.683625172097683e+01, -1.164017351346416e+01},
	{"XOZ", -3.092127751252751e+01, -1.572519930501484e+01},
	{"XPA", -1.592547186950782e+01, -4.111005371311927e+00},
	{"XPB", -2.832998356752191e+01, -1.651551706932602e+01},
	{"XPC", -2.922275710672931e+01, -1.740829060853342e+01},
	{"XPD", -2.976269799531275e+01, -1.794823149711686e+01},
	{"XPE", -1.293378794835081e+01, -1.119321450154921e+00},
	{"XPF", -2.830456854508096e+01, -1.649010204688507e+01},
	{"XPG", -2.911390206965187e+01, -1.729943557145598e+01},
	{"XPH", -2.124034923804186e+01, -9.425882739845969e+00},
	{"XPI", -1.734687242888663e+01, -5.532405930690735e+00},
	{"XPJ", -3.193815936991727e+01, -2.012369287172138e+01},
	{"XPK", -3.182107997793618e+01, -2.000661347974028e+01},
	{"XPL", -1.415767203341099e+01, -2.343205535215097e+00},
	{"XPM", -2.752563278177934e+01, -1.571116628358345e+01},
	{"XPN", -2.965744407862083e+01, -1.784297758042494e+01},
	{"XPO", -1.511141579236981e+01, -3.296949294173923e+00},
	{"XPP", -2.181337789834118e+01, -9.998911400145284e+00},
	{"XPQ", -3.319443003557841e+01, -2.137996353738253e+01},
	{"XPR", -1.455073021968566e+01, -2.736263721489763e+00},
	{"XPS", -2.334036218578258e+01, -1.152589568758669e+01},
	{"XPT", -2.292453554782911e+01, -1.111006904963321e+01},
	{"XPU", -1.883050985525614e+01, -7.016043357060245e+00},
	{"XPV", -3.135239767082205e+01, -1.953793117262616e+01},
	{"XPW", -2.362098016111378e+01, -1.180651366291789e+01},
	{"XPX", -3.669560874098622e+01, -2.488114224279033e+01},
	{"XPY", -2.690623539794656e+01, -1.509176889975067e+01},
	{"XPZ", -3.500072436643732e+01, -2.318625786824143e+01},
	{"XQA", -3.035807739934057e+01, -1.200458063045440e+01},
	{"XQB", -3.298549934648285e+01, -1.463200257759668e+01},
	{"XQC", -3.189649856437973e+01, -1.354300179549356e+01},
	{"XQD", -3.350720320657278e+01, -1.515370643768660e+01},
	{"XQE", -3.389509775071701e+01, -1.554160098183085e+01},
	{"XQF", -3.225400214997362e+01, -1.390050538108746e+01},
	{"XQG", -3.897082612435513e+01, -2.061732935546896e+01},
	{"XQH", -3.280556080683275e+01, -1.445206403794658e+01},
	{"XQI", -2.869712141472480e+01, -1.034362464583864e+01},
	{"XQJ", -3.477087258197454e+01, -1.641737581308838e+01},
	{"XQK", -4.060301131929387e+01, -2.224951455040770e+01},
	{"XQL", -3.324794838027575e+01, -1.489445161138958e+01},
	{"XQM", -3.242556153813507e+01, -1.407206476924890e+01},
	{"XQN", -3.525487891510381e+01, -1.690138214621764e+01},
	{"XQO", -3.345132474582925e+01, -1.509782797694308e+01},
	{"XQP", -3.345351013225510e+01, -1.510001336336894e+01},
	{"XQQ", -3.533491308099220e+01, -1.698141631210603e+01},
	{"XQR", -3.330021358370696e+01, -1.494671681482080e+01},
	{"XQS", -3.037252573899571e+01, -1.201902897010955e+01},
	{"XQT", -3.087219674293002e+01, -1.251869997404386e+01},
	{"XQU", -1.835634887635389e+01, -2.852107467720204e-03},
	{"XQV", -3.616606676134548e+01, -1.781256999245931e+01},
	{"XQW", -3.252431958549175e+01, -1.417082281660559e+01},
	{"XQX", -4.262614327717680e+01, -2.427264650829063e+01},
	{"XQY", -3.681886347862358e+01, -1.846536670973742e+01},
	{"XQZ", -4.376571071392733e+01, -2.541221394504116e+01},
	{"XRA", -1.852348479635026e+01, -1.551800629510830e+00},
	{"XRB", -2.789548074047345e+01, -1.092379657363402e+01},
	{"XRC", -2.688659417744134e+01, -9.914910010601906e+00},
	{"XRD", -2.593516569656064e+01, -8.963481529721214e+00},
	{"XRE", -1.800750880208669e+01, -1.035824635247263e+00},
	{"XRF", -2.772485066046857e+01, -1.075316649362914e+01},
	{"XRG", -2.734786806629937e+01, -1.037618389945994e+01},
	{"XRH", -2.752985577631595e+01, -1.055817160947652e+01},
	{"XRI", -2.238987880695754e+01, -5.418194640118114e+00},
	{"XRJ", -3.081783851300014e+01, -1.384615434616071e+01},
	{"XRK", -2.768526492456103e+01, -1.071358075772160e+01},
	{"XRL", -2.755255897527284e+01, -1.058087480843341e+01},
	{"XRM", -2.656045670393410e+01, -9.588772537094670e+00},
	{"XRN", -2.661586554389162e+01, -9.644181377052185e+00},
	{"XRO", -2.031598153865867e+01, -3.344297371819238e+00},
	{"XRP", -2.781833065339081e+01, -1.084664648655138e+01},
	{"XRQ", -3.220437464324090e+01, -1.523269047640148e+01},
	{"XRR", -2.708760143077740e+01, -1.011591726393797e+01},
	{"XRS", -2.532438623019465e+01, -8.352702063355220e+00},
	{"XRT", -2.503270373691366e+01, -8.061019570074230e+00},
	{"XRU", -2.208220968781316e+01, -5.110525520973732e+00},
	{"XRV", -2.813551798315800e+01, -1.116383381631857e+01},
	{"XRW", -2.749108779877121e+01, -1.051940363193179e+01},
	{"XRX", -3.286950081600036e+01, -1.589781664916093e+01},
	{"XRY", -2.629922617112838e+01, -9.327542004288956e+00},
	{"XRZ", -3.380062334984662e+01, -1.682893918300719e+01},
	{"XSA", -1.980033212057177e+01, -3.536762499721263e+00},
	{"XSB", -2.524427356451892e+01, -8.980703943668411e+00},
	{"XSC", -2.100278142778467e+01, -4.739211806934156e+00},
	{"XSD", -2.591281157608276e+01, -9.649241955232249e+00},
	{"XSE", -1.923333721158998e+01, -2.969767590739470e+00},
	{"XSF", -2.517424602889785e+01, -8.910676408047337e+00},
	{"XSG", -2.353699766717754e+01, -7.273428046327025e+00},
	{"XSH", -1.888440277633681e+01, -2.620833155486296e+00},
	{"XSI", -2.126123412299783e+01, -4.997664502147314e+00},
	{"XSJ", -2.869662548397744e+01, -1.243305586312692e+01},
	{"XSK", -2.699458410245187e+01, -1.073101448160136e+01},
	{"XSL", -2.199664644708356e+01, -5.733076826233047e+00},
	{"XSM", -2.328629994813056e+01, -7.022730327280043e+00},
	{"XSN", -2.570884269080804e+01, -9.445273069957533e+00},
	{"XSO", -1.867765090858114e+01, -2.414081287730627e+00},
	{"XSP", -2.078137959090132e+01, -4.517809970050811e+00},
	{"XSQ", -2.860770587926839e+01, -1.234413625841788e+01},
	{"XSR", -2.594292590808749e+01, -9.679356287236978e+00},
	{"XSS", -2.247677219932684e+01, -6.213202578476326e+00},
	{"XST", -1.874255833636570e+01, -2.478988715515191e+00},
	{"XSU", -2.016814665269581e+01, -3.904577031845299e+00},
	{"XSV", -2.784668955797530e+01, -1.158311993712478e+01},
	{"XSW", -2.427532223700608e+01, -8.011752616155565e+00},
	{"XSX", -3.067234226617033e+01, -1.440877264531982e+01},
	{"XSY", -2.207248902439953e+01, -5.808919403549022e+00},
	{"XSZ", -3.213531673828046e+01, -1.587174711742995e+01},
	{"XTA", -1.663649788798347e+01, -5.022896533168724e+00},
	{"XTB", -1.806740392995307e+01, -6.453802575138321e+00},
	{"XTC", -1.733918013677459e+01, -5.725578781959848e+00},
	{"XTD", -1.634189064172237e+01, -4.728289286907625e+00},
	{"XTE", -1.358363155497339e+01, -1.970030200158639e+00},
	{"XTF", -1.732235698312507e+01, -5.708755628310318e+00},
	{"XTG", -2.000593100266374e+01, -8.392329647848992e+00},
	{"XTH", -1.491679949919041e+01, -3.303198144375664e+00},
	{"XTI", -1.555714412651110e+01, -3.943542771696351e+00},
	{"XTJ", -2.909539618615984e+01, -1.748179483134508e+01},
	{"XTK", -2.269881231909639e+01, -1.108521096428164e+01},
	{"XTL", -2.049729920599197e+01, -8.883697851177221e+00},
	{"XTM", -1.698718685499835e+01, -5.373585500183600e+00},
	{"XTN", -1.945952914719180e+01, -7.845927792377050e+00},
	{"XTO", -1.589975872100455e+01, -4.286157366189806e+00},
	{"XTP", -1.842780741492028e+01, -6.814206060105535e+00},
	{"XTQ", -2.271374092230470e+01, -1.110013956748995e+01},
	{"XTR", -1.430276310448888e+01, -2.689161749674129e+00},
	{"XTS", -1.595091969688736e+01, -4.337318342072614e+00},
	{"XTT", -1.594148247371312e+01, -4.327881118898373e+00},
	{"XTU", -1.611476671861482e+01, -4.501165363800066e+00},
	{"XTV", -2.025551968792231e+01, -8.641918333107562e+00},
	{"XTW", -1.764030562470787e+01, -6.026704269893125e+00},
	{"XTX", -3.377060043623841e+01, -2.215699908142367e+01},
	{"XTY", -1.594716967500490e+01, -4.333568320190150e+00},
	{"XTZ", -3.124383389319928e+01, -1.963023253838453e+01},
	{"XUA", -1.651770533999390e+01, -1.041138385634577e+00},
	{"XUB", -2.109120057432474e+01, -5.614633619965420e+00},
	{"XUC", -2.534783204548878e+01, -9.871265091129457e+00},
	{"XUD", -2.204449072883975e+01, -6.567923774480427e+00},
	{"XUE", -2.579582333603760e+01, -1.031925638167827e+01},
	{"XUF", -2.774735383938921e+01, -1.227078688502988e+01},
	{"XUG", -2.530344211008395e+01, -9.826875155724625e+00},
	{"XUH", -2.841751088853277e+01, -1.294094393417345e+01},
	{"XUI", -2.583287285671539e+01, -1.035630590235607e+01},
	{"XUJ", -3.270525628521199e+01, -1.722868933085267e+01},
	{"XUK", -2.890990298705345e+01, -1.343333603269413e+01},
	{"XUL", -1.934597788459709e+01, -3.869410930237772e+00},
	{"XUM", -2.560110363418994e+01, -1.012453667983062e+01},
	{"XUN", -2.137037275745448e+01, -5.893805803095153e+00},
	{"XUO", -2.905056371999551e+01, -1.357399676563618e+01},
	{"XUP", -1.959605160936903e+01, -4.119484655009714e+00},
	{"XUQ", -3.416686023624737e+01, -1.869029328188805e+01},
	{"XUR", -1.717859824310741e+01, -1.702031288748086e+00},
	{"XUS", -2.086620152394797e+01, -5.389634569588648e+00},
	{"XUT", -2.352739735030424e+01, -8.050830395944917e+00},
	{"XUU", -3.151002826957173e+01, -1.603346131521241e+01},
	{"XUV", -3.085232591970851e+01, -1.537575896534919e+01},
	{"XUW", -2.853241712737081e+01, -1.305585017301149e+01},
	{"XUX", -3.112781678025369e+01, -1.565124982589437e+01},
	{"XUY", -3.027881176878251e+01, -1.480224481442318e+01},
	{"XUZ", -3.075082687048731e+01, -1.527425991612799e+01},
	{"XVA", -1.887987294480549e+01, -3.781132737968076e+00},
	{"XVB", -2.171962665292467e+01, -6.620886446087257e+00},
	{"XVC", -2.271874440228459e+01, -7.620004195447175e+00},
	{"XVD", -2.171908754226165e+01, -6.620347335424241e+00},
	{"XVE", -1.934201025936658e+01, -4.243270052529168e+00},
	{"XVF", -2.026082141707534e+01, -5.162081210237925e+00},
	{"XVG", -3.297238993844402e+01, -1.787364973160660e+01},
	{"XVH", -1.955022247312797e+01, -4.451482266290558e+00},
	{"XVI", -1.595757223506825e+01, -8.588320282308358e-01},
	{"XVJ", -2.371822927982935e+01, -8.619489072991936e+00},
	{"XVK", -3.477484826186296e+01, -1.967610805502554e+01},
	{"XVL", -3.204709133354846e+01, -1.694835112671105e+01},
	{"XVM", -2.371182713299391e+01, -8.613086926156493e+00},
	{"XVN", -3.015007265959846e+01, -1.505133245276105e+01},
	{"XVO", -1.990815288001064e+01, -4.809412673173222e+00},
	{"XVP", -2.091221554539606e+01, -5.813475338558651e+00},
	{"XVQ", -3.872704303519844e+01, -2.362830282836103e+01},
	{"XVR", -2.908342792952898e+01, -1.398468772269157e+01},
	{"XVS", -1.991221520567434e+01, -4.813474998836926e+00},
	{"XVT", -1.859072478742973e+01, -3.491984580592314e+00},
	{"XVU", -2.368468868393050e+01, -8.585948477093087e+00},
	{"XVV", -3.355689767452075e+01, -1.845815746768334e+01},
	{"XVW", -1.981316752411562e+01, -4.714427317278210e+00},
	{"XVX", -3.535286385229510e+01, -2.025412364545769e+01},
	{"XVY", -2.717570628826567e+01, -1.207696608142825e+01},
	{"XVZ", -3.876274273485282e+01, -2.366400252801540e+01},
	{"XWA", -1.815330052855927e+01, -1.866001207121723e+00},
	{"XWB", -2.896872790429470e+01, -1.268142858285715e+01},
	{"XWC", -2.902661952322198e+01, -1.273932020178443e+01},
	{"XWD", -2.854010952334571e+01, -1.225281020190816e+01},
	{"XWE", -1.854531903149521e+01, -2.258019710057658e+00},
	{"XWF", -2.882169730948143e+01, -1.253439798804388e+01},
	{"XWG", -2.994844073946709e+01, -1.366114141802954e+01},
	{"XWH", -1.825020203424151e+01, -1.962902712803964e+00},
	{"XWI", -1.838945271463635e+01, -2.102153393198799e+00},
	{"XWJ", -3.130513520228450e+01, -1.501783588084695e+01},
	{"XWK", -3.146014766581052e+01, -1.517284834437297e+01},
	{"XWL", -2.789017992631199e+01, -1.160288060487444e+01},
	{"XWM", -2.859101216241948e+01, -1.230371284098193e+01},
	{"XWN", -2.546530212381624e+01, -9.178002802378693e+00},
	{"XWO", -2.183585993967690e+01, -5.548560618239356e+00},
	{"XWP", -2.967887582944939e+01, -1.339157650801184e+01},
	{"XWQ", -3.393249697616052e+01, -1.764519765472297e+01},
	{"XWR", -2.711345545854942e+01, -1.082615613711187e+01},
	{"XWS", -2.672547447259102e+01, -1.043817515115347e+01},
	{"XWT", -2.659549673773327e+01, -1.030819741629572e+01},
	{"XWU", -3.006210751120964e+01, -1.377480818977209e+01},
	{"XWV", -3.178267033880570e+01, -1.549537101736815e+01},
	{"XWW", -2.781468977789599e+01, -1.152739045645843e+01},
	{"XWX", -4.112630324228593e+01, -2.483900392084838e+01},
	{"XWY", -2.876519177995256e+01, -1.247789245851501e+01},
	{"XWZ", -3.452223710053430e+01, -1.823493777909675e+01},
	{"XXA", -2.166375914591204e+01, -5.779516584895160e+00},
	{"XXB", -2.806560490189041e+01, -1.218136234087353e+01},
	{"XXC", -2.302660455944056e+01, -7.142361998423685e+00},
	{"XXD", -2.745808492242239e+01, -1.157384236140551e+01},
	{"XXE", -2.190131126392594e+01, -6.017068702909062e+00},
	{"XXF", -2.760110252086586e+01, -1.171685995984898e+01},
	{"XXG", -2.890016706098162e+01, -1.301592449996474e+01},
	{"XXH", -2.525834088684493e+01, -9.374098325828056e+00},
	{"XXI", -1.716056065388021e+01, -1.276318092863339e+00},
	{"XXJ", -3.011313618700553e+01, -1.422889362598866e+01},
	{"XXK", -3.101122247745192e+01, -1.512697991643504e+01},
	{"XXL", -2.755845649427539e+01, -1.167421393325851e+01},
	{"XXM", -2.264264226382858e+01, -6.758399702811702e+00},
	{"XXN", -2.934729328959857e+01, -1.346305072858169e+01},
	{"XXO", -2.585571425836158e+01, -9.971471697344706e+00},
	{"XXP", -2.247437287342294e+01, -6.590130312406068e+00},
	{"XXQ", -2.901343183671868e+01, -1.312918927570180e+01},
	{"XXR", -2.763161923467194e+01, -1.174737667365507e+01},
	{"XXS", -2.264698186912718e+01, -6.762739308110303e+00},
	{"XXT", -2.044071637139287e+01, -4.556473810375996e+00},
	{"XXU", -2.613650202219183e+01, -1.025225946117496e+01},
	{"XXV", -1.788439335268355e+01, -2.000150791666680e+00},
	{"XXW", -2.694659739537516e+01, -1.106235483435829e+01},
	{"XXX", -1.807551062440355e+01, -2.191268063386678e+00},
	{"XXY", -2.673069032025522e+01, -1.084644775923835e+01},
	{"XXZ", -4.055045158961828e+01, -2.466620902860140e+01},
	{"XYA", -2.138112524060660e+01, -5.310369988183887e+00},
	{"XYB", -2.321758800585199e+01, -7.146832753429279e+00},
	{"XYC", -2.510798942305640e+01, -9.037234170633685e+00},
	{"XYD", -2.545538264284488e+01, -9.384627390422168e+00},
	{"XYE", -1.799651919238536e+01, -1.925763939962642e+00},
	{"XYF", -2.515570078242031e+01, -9.084945529997594e+00},
	{"XYG", -1.687417071611545e+01, -8.034154636927362e-01},
	{"XYH", -2.499111579177234e+01, -8.920360539349625e+00},
	{"XYI", -2.429155411949813e+01, -8.220798867075409e+00},
	{"XYJ", -2.833568501841443e+01, -1.226492976599171e+01},
	{"XYK", -2.813236823841940e+01, -1.206161298599668e+01},
	{"XYL", -2.571412287635111e+01, -9.643367623928391e+00},
	{"XYM", -2.507146582951747e+01, -9.000710577094756e+00},
	{"XYN", -2.622057555852553e+01, -1.014982030610282e+01},
	{"XYO", -2.017722623018339e+01, -4.106470977760671e+00},
	{"XYP", -2.519683812592217e+01, -9.126082873499460e+00},
	{"XYQ", -3.025211617650727e+01, -1.418136092408456e+01},
	{"XYR", -2.559665907603678e+01, -9.525903823614071e+00},
	{"XYS", -2.071067803307287e+01, -4.639922780650161e+00},
	{"XYT", -2.348344269642100e+01, -7.412687443998293e+00},
	{"XYU", -2.690400560825018e+01, -1.083325035582747e+01},
	{"XYV", -2.802748068802041e+01, -1.195672543559770e+01},
	{"XYW", -2.305394515729036e+01, -6.983189904867650e+00},
	{"XYX", -3.233504734198591e+01, -1.626429208956320e+01},
	{"XYY", -2.733962313742467e+01, -1.126886788500195e+01},
	{"XYZ", -3.165237434724348e+01, -1.558161909482077e+01},
	{"XZA", -3.218433911991654e+01, -2.293822598130778e+00},
	{"XZB", -3.753618236567950e+01, -7.645665843893735e+00},
	{"XZC", -3.842109718392108e+01, -8.530580662135309e+00},
	{"XZD", -3.878026302532391e+01, -8.889746503538143e+00},
	{"XZE", -3.111002449540662e+01, -1.219507973620853e+00},
	{"XZF", -3.836739459169851e+01, -8.476878069912736e+00},
	{"XZG", -3.889036376482572e+01, -8.999847243039955e+00},
	{"XZH", -3.750710089497561e+01, -7.616584373189839e+00},
	{"XZI", -3.273473841177027e+01, -2.844221889984504e+00},
	{"XZJ", -4.141408846698288e+01, -1.152357194519712e+01},
	{"XZK", -4.004958852736924e+01, -1.015907200558347e+01},
	{"XZL", -3.573982366401569e+01, -5.849307142229925e+00},
	{"XZM", -3.794807959370571e+01, -8.057563071919942e+00},
	{"XZN", -3.905090722232536e+01, -9.160390700539589e+00},
	{"XZO", -3.406240837487402e+01, -4.171891853088263e+00},
	{"XZP", -3.686647194255555e+01, -6.975955420769782e+00},
	{"XZQ", -4.533030235630623e+01, -1.543978583452046e+01},
	{"XZR", -3.607922859255792e+01, -6.188712070772155e+00},
	{"XZS", -3.769805133561382e+01, -7.807534813828052e+00},
	{"XZT", -3.619798361673715e+01, -6.307467094951393e+00},
	{"XZU", -3.560022200183324e+01, -5.709705480047471e+00},
	{"XZV", -3.849778316045052e+01, -8.607266638664759e+00},
	{"XZW", -3.716127033558639e+01, -7.270753813800627e+00},
	{"XZX", -4.813843891775107e+01, -1.824792239596530e+01},
	{"XZY", -3.657391816607674e+01, -6.683401644290976e+00},
	{"XZZ", -3.416879647123317e+01, -4.278279949447406e+00},
	{"YAA", -2.012167371617844e+01, -1.092065712569359e+01},
	{"YAB", -1.458526131629093e+01, -5.384244725806083e+00},
	{"YAC", -1.397719946176520e+01, -4.776182871280356e+00},
	{"YAD", -1.461512957385589e+01, -5.414112983371052e+00},
	{"YAE", -1.925180939579883e+01, -1.005079280531399e+01},
	{"YAF", -1.417897032112364e+01, -4.977953730638800e+00},
	{"YAG", -1.405059198383629e+01, -4.849575393351451e+00},
	{"YAH", -1.675081707597434e+01, -7.549800485489500e+00},
	{"YAI", -1.675172838463946e+01, -7.550711794154615e+00},
	{"YAJ", -1.932449771967473e+01, -1.012348112918989e+01},
	{"YAK", -1.905440671282105e+01, -9.853390122336210e+00},
	{"YAL", -1.260867848800967e+01, -3.407661897524824e+00},
	{"YAM", -1.447340795977168e+01, -5.272391369286841e+00},
	{"YAN", -1.051083034929815e+01, -1.309813758813308e+00},
	{"YAO", -2.090375909998738e+01, -1.170274250950254e+01},
	{"YAP", -1.457021290560768e+01, -5.369196315122839e+00},
	{"YAQ", -1.971602765496737e+01, -1.051501106448252e+01},
	{"YAR", -1.229634838999474e+01, -3.095331799509895e+00},
	{"YAS", -1.275922344243733e+01, -3.558206851952483e+00},
	{"YAT", -1.345831169536817e+01, -4.257295104883323e+00},
	{"YAU", -1.585881302382113e+01, -6.657796433336292e+00},
	{"YAV", -1.597957462243491e+01, -6.778558031950069e+00},
	{"YAW", -1.558787874883322e+01, -6.386862158348380e+00},
	{"YAX", -2.211784398410606e+01, -1.291682739362122e+01},
	{"YAY", -1.860227526911537e+01, -9.401258678630532e+00},
	{"YAZ", -2.170649259203750e+01, -1.250547600155265e+01},
	{"YBA", -1.493613595324779e+01, -4.386399486942614e+00},
	{"YBB", -2.668170608912829e+01, -1.613196962282312e+01},
	{"YBC", -1.858635279696450e+01, -8.036616330659328e+00},
	{"YBD", -2.868947854188765e+01, -1.813974207558247e+01},
	{"YBE", -1.179359356689812e+01, -1.243857100592947e+00},
	{"YBF", -2.212881101982804e+01, -1.157907455352286e+01},
	{"YBG", -2.371376870681743e+01, -1.316403224051226e+01},
	{"YBH", -2.912206492145350e+01, -1.857232845514832e+01},
	{"YBI", -1.626919998724937e+01, -5.719463520944195e+00},
	{"YBJ", -2.354422832851452e+01, -1.299449186220934e+01},
	{"YBK", -3.213276141596073e+01, -2.158302494965556e+01},
	{"YBL", -1.599137326629863e+01, -5.441636799993450e+00},
	{"YBM", -2.845130187720593e+01, -1.790156541090075e+01},
	{"YBN", -1.925800695772180e+01, -8.708270491416620e+00},
	{"YBO", -1.356784942861620e+01, -3.018112962311024e+00},
	{"YBP", -2.270922076541662e+01, -1.215948429911144e+01},
	{"YBQ", -3.600015248740780e+01, -2.545041602110263e+01},
	{"YBR", -1.386024585819274e+01, -3.310509391887564e+00},
	{"YBS", -2.329199536937735e+01, -1.274225890307217e+01},
	{"YBT", -2.203371699886182e+01, -1.148398053255664e+01},
	{"YBU", -1.312521435017506e+01, -2.575477883869890e+00},
	{"YBV", -2.991465911685856e+01, -1.936492265055339e+01},
	{"YBW", -2.368945731805783e+01, -1.313972085175266e+01},
	{"YBX", -3.928736032664840e+01, -2.873762386034323e+01},
	{"YBY", -1.405043170235944e+01, -3.500695236054264e+00},
	{"YBZ", -3.379546420241581e+01, -2.324572773611063e+01},
	{"YCA", -1.287270138265638e+01, -2.194144970579497e+00},
	{"YCB", -2.947859536912368e+01, -1.880003895704680e+01},
	{"YCC", -2.239498865250404e+01, -1.171643224042716e+01},
	{"YCD", -2.211589883259742e+01, -1.143734242052054e+01},
	{"YCE", -1.586864947089387e+01, -5.190093058816982e+00},
	{"YCF", -2.270420443464503e+01, -1.202564802256815e+01},
	{"YCG", -2.271126123854821e+01, -1.203270482647133e+01},
	{"YCH", -1.386927540084725e+01, -3.190718988770365e+00},
	{"YCI", -1.593577019579831e+01, -5.257213783721431e+00},
	{"YCJ", -3.223204160843299e+01, -2.155348519635611e+01},
	{"YCK", -1.948315959594200e+01, -8.804603183865119e+00},
	{"YCL", -1.467228007732160e+01, -3.993723665244722e+00},
	{"YCM", -2.924240604552745e+01, -1.856384963345057e+01},
	{"YCN", -2.071669337129488e+01, -1.003813695921799e+01},
	{"YCO", -1.177804485371970e+01, -1.099488441642814e+00},
	{"YCP", -2.170604313876570e+01, -1.102748672668881e+01},
	{"YCQ", -2.864148733640778e+01, -1.796293092433090e+01},
	{"YCR", -1.498807190109411e+01, -4.309515489017225e+00},
	{"YCS", -2.208916152761229e+01, -1.141060511553541e+01},
	{"YCT", -2.276004978856600e+01, -1.208149337648912e+01},
	{"YCU", -1.566488598648433e+01, -4.986329574407447e+00},
	{"YCV", -3.190661922574870e+01, -2.122806281367182e+01},
	{"YCW", -2.137765241353241e+01, -1.069909600145553e+01},
	{"YCX", -3.320037928629620e+01, -2.252182287421932e+01},
	{"YCY", -2.068731125216078e+01, -1.000875484008389e+01},
	{"YCZ", -3.186102478693931e+01, -2.118246837486243e+01},
	{"YDA", -1.396164392119902e+01, -2.935694289333651e+00},
	{"YDB", -2.073786277323740e+01, -9.711913141372039e+00},
	{"YDC", -2.322864959625867e+01, -1.220269996439330e+01},
	{"YDD", -2.063684316696986e+01, -9.610893535104493e+00},
	{"YDE", -1.280590867251604e+01, -1.779959040650671e+00},
	{"YDF", -2.188323770340314e+01, -1.085728807153778e+01},
	{"YDG", -1.952155941081856e+01, -8.495609778953193e+00},
	{"YDH", -1.933396999900993e+01, -8.308020367144570e+00},
	{"YDI", -1.288699668058011e+01, -1.861047048714745e+00},
	{"YDJ", -2.264066235903084e+01, -1.161471272716547e+01},
	{"YDK", -2.364942562593986e+01, -1.262347599407449e+01},
	{"YDL", -2.048808547067694e+01, -9.462135838811577e+00},
	{"YDM", -2.046668079941093e+01, -9.440731167545563e+00},
	{"YDN", -1.977038997255605e+01, -8.744440340690684e+00},
	{"YDO", -1.376645926536840e+01, -2.740509633503031e+00},
	{"YDP", -2.529789940307657e+01, -1.427194977121121e+01},
	{"YDQ", -2.950781467405736e+01, -1.848186504219199e+01},
	{"YDR", -1.455967393473559e+01, -3.533724302870221e+00},
	{"YDS", -1.976861785763241e+01, -8.742668225767041e+00},
	{"YDT", -1.983371099479239e+01, -8.807761362927026e+00},
	{"YDU", -1.592651245087832e+01, -4.900562819012952e+00},
	{"YDV", -2.659308446780433e+01, -1.556713483593897e+01},
	{"YDW", -1.736399621576122e+01, -6.338046583895856e+00},
	{"YDX", -3.440700497533155e+01, -2.338105534346619e+01},
	{"YDY", -2.035050266147325e+01, -9.324553029607889e+00},
	{"YDZ", -3.048944677565006e+01, -1.946349714378469e+01},
	{"YEA", -1.149825173384155e+01, -2.059192965055080e+00},
	{"YEB", -1.567726918634191e+01, -6.238210417555439e+00},
	{"YEC", -1.620201195358311e+01, -6.762953184796641e+00},
	{"YED", -1.281534625780470e+01, -3.376287489018225e+00},
	{"YEE", -1.583025541753966e+01, -6.391196648753183e+00},
	{"YEF", -1.618953898021360e+01, -6.750480211427126e+00},
	{"YEG", -1.709811982665360e+01, -7.659061057867126e+00},
	{"YEH", -1.474848055945251e+01, -5.309421790666038e+00},
	{"YEI", -1.571366243963769e+01, -6.274603670851215e+00},
	{"YEJ", -1.971420758041860e+01, -1.027514881163212e+01},
	{"YEK", -1.708742348594201e+01, -7.648364717155542e+00},
	{"YEL", -1.458893065531887e+01, -5.149871886532392e+00},
	{"YEM", -1.489206247372605e+01, -5.453003704939573e+00},
	{"YEN", -1.384449056925718e+01, -4.405431800470706e+00},
	{"YEO", -1.626928529639365e+01, -6.830226527607172e+00},
	{"YEP", -1.699471468357939e+01, -7.555655914792911e+00},
	{"YEQ", -1.798881969851211e+01, -8.549760929725638e+00},
	{"YER", -1.358100417737873e+01, -4.141945408592251e+00},
	{"YES", -1.193087375270160e+01, -2.491814983915128e+00},
	{"YET", -1.239125558875231e+01, -2.952196819965833e+00},
	{"YEU", -1.746703844605325e+01, -8.027979677266776e+00},
	{"YEV", -1.459848868262037e+01, -5.159429913833896e+00},
	{"YEW", -1.546701148551630e+01, -6.027952716729824e+00},
	{"YEX", -1.419468040951100e+01, -4.755621640724527e+00},
	{"YEY", -1.632255139656225e+01, -6.883492627775778e+00},
	{"YEZ", -2.976196659718724e+01, -2.032290782840076e+01},
	{"YFA", -1.320865245998469e+01, -2.482384688543895e+00},
	{"YFB", -2.350404574717176e+01, -1.277777797573097e+01},
	{"YFC", -2.577207125024321e+01, -1.504580347880242e+01},
	{"YFD", -2.665404414103268e+01, -1.592777636959189e+01},
	{"YFE", -1.431751845441492e+01, -3.591250682974130e+00},
	{"YFF", -2.118864192937954e+01, -1.046237415793875e+01},
	{"YFG", -2.630820316539452e+01, -1.558193539395373e+01},
	{"YFH", -2.510891246903709e+01, -1.438264469759630e+01},
	{"YFI", -1.381428759782117e+01, -3.088019826380379e+00},
	{"YFJ", -2.709690823480815e+01, -1.637064046336736e+01},
	{"YFK", -2.899308899975767e+01, -1.826682122831689e+01},
	{"YFL", -1.530322531002543e+01, -4.576957538584636e+00},
	{"YFM", -2.544005033723859e+01, -1.471378256579780e+01},
	{"YFN", -2.706183011939907e+01, -1.633556234795828e+01},
	{"YFO", -1.217693345716104e+01, -1.450665685720249e+00},
	{"YFP", -2.257495694959787e+01, -1.184868917815708e+01},
	{"YFQ", -3.123993457003026e+01, -2.051366679858946e+01},
	{"YFR", -1.321779862872205e+01, -2.491530857281257e+00},
	{"YFS", -2.330278257098698e+01, -1.257651479954619e+01},
	{"YFT", -2.182761239266672e+01, -1.110134462122592e+01},
	{"YFU", -1.565012689631914e+01, -4.923859124878345e+00},
	{"YFV", -2.827391686333470e+01, -1.754764909189391e+01},
	{"YFW", -2.602623178793337e+01, -1.529996401649257e+01},
	{"YFX", -3.355130607436376e+01, -2.282503830292297e+01},
	{"YFY", -2.666876413213973e+01, -1.594249636069894e+01},
	{"YFZ", -2.967989953389029e+01, -1.895363176244950e+01},
	{"YGA", -1.509853923698606e+01, -3.259548271464088e+00},
	{"YGB", -2.634309423401744e+01, -1.450410326849547e+01},
	{"YGC", -2.659412079402687e+01, -1.475512982850490e+01},
	{"YGD", -2.646522584748594e+01, -1.462623488196398e+01},
	{"YGE", -1.476175952304995e+01, -2.922768557527976e+00},
	{"YGF", -2.614880462272863e+01, -1.430981365720666e+01},
	{"YGG", -2.629029476276683e+01, -1.445130379724485e+01},
	{"YGH", -1.710610111933257e+01, -5.267110153810600e+00},
	{"YGI", -1.532635429309301e+01, -3.487363327571040e+00},
	{"YGJ", -2.981814537071034e+01, -1.797915440518837e+01},
	{"YGK", -3.005095472963408e+01, -1.821196376411211e+01},
	{"YGL", -1.622304879554790e+01, -4.384057830025929e+00},
	{"YGM", -2.346564616126731e+01, -1.162665519574534e+01},
	{"YGN", -2.105107403258169e+01, -9.212083067059718e+00},
	{"YGO", -1.334766252169348e+01, -1.508671556171510e+00},
	{"YGP", -2.167034475783142e+01, -9.831353792309450e+00},
	{"YGQ", -3.134953839862564e+01, -1.951054743310367e+01},
	{"YGR", -1.408203959893983e+01, -2.243048633417856e+00},
	{"YGS", -2.442635856518273e+01, -1.258736759966077e+01},
	{"YGT", -2.353907078066263e+01, -1.170007981514066e+01},
	{"YGU", -1.674652402344154e+01, -4.907533057919575e+00},
	{"YGV", -2.918998018054614e+01, -1.735098921502417e+01},
	{"YGW", -2.255470563858301e+01, -1.071571467306104e+01},
	{"YGX", -3.456835886507300e+01, -2.272936789955103e+01},
	{"YGY", -2.352832385358522e+01, -1.168933288806325e+01},
	{"YGZ", -3.315661237910523e+01, -2.131762141358326e+01},
	{"YHA", -1.181693879683201e+01, -1.255091617091907e+00},
	{"YHB", -2.770116261524239e+01, -1.713931543550228e+01},
	{"YHC", -2.210304342149020e+01, -1.154119624175010e+01},
	{"YHD", -2.815259175514158e+01, -1.759074457540148e+01},
	{"YHE", -1.239106389443772e+01, -1.829216714697626e+00},
	{"YHF", -2.768782383435118e+01, -1.712597665461108e+01},
	{"YHG", -2.367280409173285e+01, -1.311095691199275e+01},
	{"YHH", -2.262450443250712e+01, -1.206265725276702e+01},
	{"YHI", -1.318153106265121e+01, -2.619683882911109e+00},
	{"YHJ", -3.058986088982325e+01, -2.002801371008315e+01},
	{"YHK", -3.091346427854065e+01, -2.035161709880055e+01},
	{"YHL", -2.821070001082533e+01, -1.764885283108523e+01},
	{"YHM", -2.111256786733256e+01, -1.055072068759246e+01},
	{"YHN", -2.812416396200194e+01, -1.756231678226185e+01},
	{"YHO", -1.386197272726550e+01, -3.300125547525398e+00},
	{"YHP", -2.805562015848471e+01, -1.749377297874461e+01},
	{"YHQ", -3.234585878171222e+01, -2.178401160197213e+01},
	{"YHR", -2.133910469470936e+01, -1.077725751496926e+01},
	{"YHS", -2.666093840400885e+01, -1.609909122426875e+01},
	{"YHT", -1.909075301723473e+01, -8.528905837494634e+00},
	{"YHU", -1.566779239534003e+01, -5.105945215599929e+00},
	{"YHV", -3.082859547895245e+01, -2.026674829921235e+01},
	{"YHW", -2.679931603966669e+01, -1.623746885992660e+01},
	{"YHX", -3.634179581065538e+01, -2.577994863091529e+01},
	{"YHY", -1.979514304651937e+01, -9.233295866779272e+00},
	{"YHZ", -3.335367805652909e+01, -2.279183087678899e+01},
	{"YIA", -1.706449733647434e+01, -7.202376227955731e+00},
	{"YIB", -1.875285147595541e+01, -8.890730367436799e+00},
	{"YIC", -1.723486543048697e+01, -7.372744321968367e+00},
	{"YID", -1.655935883516648e+01, -6.697237726647870e+00},
	{"YIE", -1.565830057465099e+01, -5.796179466132378e+00},
	{"YIF", -1.499920481124021e+01, -5.137083702721602e+00},
	{"YIG", -1.786619973214959e+01, -8.004078623630983e+00},
	{"YIH", -1.664087370666195e+01, -6.778752598143342e+00},
	{"YII", -1.896124765474162e+01, -9.099126546223012e+00},
	{"YIJ", -2.071723920112922e+01, -1.085511809261062e+01},
	{"YIK", -1.938689044691335e+01, -9.524769338394744e+00},
	{"YIL", -1.572210399202942e+01, -5.859982883510816e+00},
	{"YIM", -1.474997949413661e+01, -4.887858385618002e+00},
	{"YIN", -1.051886728655138e+01, -6.567461780327722e-01},
	{"YIO", -1.967265580954188e+01, -9.810534701023274e+00},
	{"YIP", -1.924424597028969e+01, -9.382124861771084e+00},
	{"YIQ", -2.929017606632499e+01, -1.942805495780638e+01},
	{"YIR", -1.688472268427546e+01, -7.022601575756850e+00},
	{"YIS", -1.325813179896527e+01, -3.396010690446658e+00},
	{"YIT", -1.310387453595998e+01, -3.241753427441368e+00},
	{"YIU", -2.110671255145765e+01, -1.124459144293904e+01},
	{"YIV", -1.833840163107294e+01, -8.476280522554328e+00},
	{"YIW", -1.616310841479391e+01, -6.300987306275307e+00},
	{"YIX", -2.363623386569044e+01, -1.377411275717184e+01},
	{"YIY", -3.285140014997705e+01, -2.298927904145844e+01},
	{"YIZ", -2.699085377331870e+01, -1.712873266480009e+01},
	{"YJA", -1.657255388956938e+01, -2.666301882134472e+00},
	{"YJB", -2.170908266998411e+01, -7.802830662549192e+00},
	{"YJC", -2.369580392832498e+01, -9.789551920890069e+00},
	{"YJD", -3.150196319239473e+01, -1.759571118495981e+01},
	{"YJE", -1.698177092713319e+01, -3.075518919698280e+00},
	{"YJF", -3.062564908879902e+01, -1.671939708136410e+01},
	{"YJG", -3.020407232973810e+01, -1.629782032230319e+01},
	{"YJH", -1.981125846931763e+01, -5.905006461882720e+00},
	{"YJI", -1.870666409809589e+01, -4.800412090660974e+00},
	{"YJJ", -2.940212570792994e+01, -1.549587370049503e+01},
	{"YJK", -3.209069721580124e+01, -1.818444520836632e+01},
	{"YJL", -2.370776439526667e+01, -9.801512387831757e+00},
	{"YJM", -2.371042303557420e+01, -9.804171028139285e+00},
	{"YJN", -3.390552518741791e+01, -1.999927317998300e+01},
	{"YJO", -1.589977948589972e+01, -1.993527478464812e+00},
	{"YJP", -3.036730772158433e+01, -1.646105571414942e+01},
	{"YJQ", -3.335355946251021e+01, -1.944730745507530e+01},
	{"YJR", -2.957378486965319e+01, -1.566753286221828e+01},
	{"YJS", -3.001117243463003e+01, -1.610492042719512e+01},
	{"YJT", -3.010494969666814e+01, -1.619869768923322e+01},
	{"YJU", -1.518496514013276e+01, -1.278713132697848e+00},
	{"YJV", -3.697261268211106e+01, -2.306636067467615e+01},
	{"YJW", -2.934686872568204e+01, -1.544061671824712e+01},
	{"YJX", -3.965191808917989e+01, -2.574566608174498e+01},
	{"YJY", -3.612178884002451e+01, -2.221553683258959e+01},
	{"YJZ", -3.422678993348293e+01, -2.032053792604802e+01},
	{"YKA", -1.995941290909045e+01, -6.256477681650564e+00},
	{"YKB", -2.689176103587144e+01, -1.318882580843156e+01},
	{"YKC", -2.732363441819523e+01, -1.362069919075535e+01},
	{"YKD", -2.364513481652310e+01, -9.942199589083222e+00},
	{"YKE", -1.614208074984834e+01, -2.439145522408459e+00},
	{"YKF", -2.678816937399358e+01, -1.308523414655370e+01},
	{"YKG", -2.906077015131072e+01, -1.535783492387085e+01},
	{"YKH", -2.645801438879019e+01, -1.275507916135031e+01},
	{"YKI", -1.511330058213993e+01, -1.410365354700051e+00},
	{"YKJ", -3.063894463271117e+01, -1.693600940527129e+01},
	{"YKK", -2.997067472516346e+01, -1.626773949772358e+01},
	{"YKL", -2.634930328529088e+01, -1.264636805785100e+01},
	{"YKM", -2.732367192723560e+01, -1.362073669979572e+01},
	{"YKN", -1.495563580339288e+01, -1.252700575952999e+00},
	{"YKO", -2.494893290185806e+01, -1.124599767441818e+01},
	{"YKP", -2.767461157270178e+01, -1.397167634526190e+01},
	{"YKQ", -3.331808442728424e+01, -1.961514919984436e+01},
	{"YKR", -2.365248030802494e+01, -9.949545080585057e+00},
	{"YKS", -2.422842511790664e+01, -1.052548989046676e+01},
	{"YKT", -2.499340965759820e+01, -1.129047443015832e+01},
	{"YKU", -2.263913173103589e+01, -8.936196503596006e+00},
	{"YKV", -3.047909969855586e+01, -1.677616447111598e+01},
	{"YKW", -2.616491792154810e+01, -1.246198269410822e+01},
	{"YKX", -3.429013129317750e+01, -2.058719606573762e+01},
	{"YKY", -2.683513905823879e+01, -1.313220383079891e+01},
	{"YKZ", -3.239199417904724e+01, -1.868905895160736e+01},
	{"YLA", -1.352898874260726e+01, -2.244298877235670e+00},
	{"YLB", -2.200642979534599e+01, -1.072173992997440e+01},
	{"YLC", -2.068647428810662e+01, -9.401784422735025e+00},
	{"YLD", -2.348385012865562e+01, -1.219916026328403e+01},
	{"YLE", -1.388754844292434e+01, -2.602858577552750e+00},
	{"YLF", -2.532241110331166e+01, -1.403772123794006e+01},
	{"YLG", -2.700707750768013e+01, -1.572238764230855e+01},
	{"YLH", -2.643849141847991e+01, -1.515380155310832e+01},
	{"YLI", -1.326646278483230e+01, -1.981772919460713e+00},
	{"YLJ", -2.973910512496836e+01, -1.845441525959678e+01},
	{"YLK", -2.701073392034928e+01, -1.572604405497770e+01},
	{"YLL", -1.707866451299478e+01, -5.793974647623191e+00},
	{"YLM", -2.204350188873784e+01, -1.075881202336626e+01},
	{"YLN", -2.355714293339299e+01, -1.227245306802140e+01},
	{"YLO", -1.309153492025526e+01, -1.806845054883667e+00},
	{"YLP", -2.607140950961271e+01, -1.478671964424112e+01},
	{"YLQ", -3.082780937979821e+01, -1.954311951442662e+01},
	{"YLR", -2.660244396466808e+01, -1.531775409929650e+01},
	{"YLS", -1.975187407408446e+01, -8.467184208712871e+00},
	{"YLT", -2.040941969813669e+01, -9.124729832765100e+00},
	{"YLU", -1.694507581248239e+01, -5.660385947110800e+00},
	{"YLV", -1.626627516159465e+01, -4.981585296223058e+00},
	{"YLW", -2.606823867625114e+01, -1.478354881087956e+01},
	{"YLX", -3.412977756392571e+01, -2.284508769855411e+01},
	{"YLY", -1.825275573586807e+01, -6.968065870496478e+00},
	{"YLZ", -3.279126803704147e+01, -2.150657817166988e+01},
	{"YMA", -1.229430756585921e+01, -1.652274747321260e+00},
	{"YMB", -1.767970450711650e+01, -7.037671688578547e+00},
	{"YMC", -2.088618824850819e+01, -1.024415542997024e+01},
	{"YMD", -1.871388760791644e+01, -8.071854789378481e+00},
	{"YME", -1.286104465144731e+01, -2.219011832909354e+00},
	{"YMF", -2.205259229117230e+01, -1.141055947263435e+01},
	{"YMG", -2.210751695396910e+01, -1.146548413543115e+01},
	{"YMH", -2.586424016970543e+01, -1.522220735116747e+01},
	{"YMI", -1.382821410833070e+01, -3.186181289792745e+00},
	{"YMJ", -2.932064186507965e+01, -1.867860904654169e+01},
	{"YMK", -2.962829487907934e+01, -1.898626206054139e+01},
	{"YML", -2.265351009740732e+01, -1.201147727886937e+01},
	{"YMM", -1.860075848743206e+01, -7.958725668894104e+00},
	{"YMN", -1.730622276976048e+01, -6.664189951222526e+00},
	{"YMO", -1.316089706947660e+01, -2.518864250938645e+00},
	{"YMP", -1.508102335111390e+01, -4.438990532575943e+00},
	{"YMQ", -3.224071660429333e+01, -2.159868378575537e+01},
	{"YMR", -1.717740260339734e+01, -6.535369784859385e+00},
	{"YMS", -2.285779856694718e+01, -1.221576574840923e+01},
	{"YMT", -2.013404740461261e+01, -9.492014586074658e+00},
	{"YMU", -1.478603882947198e+01, -4.144006010934027e+00},
	{"YMV", -2.270006220735670e+01, -1.205802938881875e+01},
	{"YMW", -2.543662863805675e+01, -1.479459581951880e+01},
	{"YMX", -3.388040606124679e+01, -2.323837324270883e+01},
	{"YMY", -1.527205335951612e+01, -4.630020540978165e+00},
	{"YMZ", -3.247959116677146e+01, -2.183755834823350e+01},
	{"YNA", -1.396804628730560e+01, -2.176903739759582e+00},
	{"YNB", -2.254114227606398e+01, -1.074999972851796e+01},
	{"YNC", -1.739671186185271e+01, -5.605569314306695e+00},
	{"YND", -1.997603272095317e+01, -8.184890173407153e+00},
	{"YNE", -1.384684825787493e+01, -2.055705710328915e+00},
	{"YNF", -2.540678239132820e+01, -1.361563984378219e+01},
	{"YNG", -2.021165899261268e+01, -8.420516445066665e+00},
	{"YNH", -2.512146086439407e+01, -1.333031831684806e+01},
	{"YNI", -1.530032750885999e+01, -3.509184961313973e+00},
	{"YNJ", -2.781379711907086e+01, -1.602265457152484e+01},
	{"YNK", -2.647058230441261e+01, -1.467943975686659e+01},
	{"YNL", -2.587598214803849e+01, -1.408483960049247e+01},
	{"YNM", -2.341762051677768e+01, -1.162647796923166e+01},
	{"YNN", -1.952952196480946e+01, -7.738379417263443e+00},
	{"YNO", -1.317095322684921e+01, -1.379810679303189e+00},
	{"YNP", -2.631651156549572e+01, -1.452536901794970e+01},
	{"YNQ", -2.872242218292985e+01, -1.693127963538384e+01},
	{"YNR", -2.688325735779570e+01, -1.509211481024968e+01},
	{"YNS", -2.008752910849183e+01, -8.296386560945809e+00},
	{"YNT", -1.873491841691537e+01, -6.943775869369348e+00},
	{"YNU", -1.750463218374580e+01, -5.713489636199784e+00},
	{"YNV", -2.696913143434413e+01, -1.517798888679811e+01},
	{"YNW", -2.532109192426529e+01, -1.352994937671927e+01},
	{"YNX", -2.025813157226634e+01, -8.466989024720322e+00},
	{"YNY", -2.534649733484517e+01, -1.355535478729915e+01},
	{"YNZ", -3.128989124422422e+01, -1.949874869667820e+01},
	{"YOA", -1.951826719028534e+01, -1.096463837944937e+01},
	{"YOB", -1.567789359608656e+01, -7.124264785250591e+00},
	{"YOC", -1.589618576546634e+01, -7.342556954630369e+00},
	{"YOD", -1.942414302056958e+01, -1.087051420973361e+01},
	{"YOE", -2.087601714539838e+01, -1.232238833456241e+01},
	{"YOF", -1.060482016683932e+01, -2.051191356003349e+00},
	{"YOG", -2.108581244348303e+01, -1.253218363264706e+01},
	{"YOH", -1.828315968071180e+01, -9.729530869875832e+00},
	{"YOI", -1.987721831511918e+01, -1.132358950428321e+01},
	{"YOJ", -2.733026171159028e+01, -1.877663290075431e+01},
	{"YOK", -1.685790859330174e+01, -8.304279782465773e+00},
	{"YOL", -1.667597867865106e+01, -8.122349867815089e+00},
	{"YOM", -1.827421582280398e+01, -9.720587011968005e+00},
	{"YON", -1.205355703905020e+01, -3.499928228214234e+00},
	{"YOO", -2.148154139225149e+01, -1.292791258141552e+01},
	{"YOP", -1.569311642759950e+01, -7.139487616763526e+00},
	{"YOQ", -3.064621397978746e+01, -2.209258516895149e+01},
	{"YOR", -1.308923797806744e+01, -4.535609167231470e+00},
	{"YOS", -1.863783073842653e+01, -1.008420192759056e+01},
	{"YOT", -1.454453200936909e+01, -5.990903198533122e+00},
	{"YOU", -9.377200052561109e+00, -8.235712417251403e-01},
	{"YOV", -1.558715680500873e+01, -7.033527994172766e+00},
	{"YOW", -1.590465915172368e+01, -7.351030340887712e+00},
	{"YOX", -2.054524960286196e+01, -1.199162079202599e+01},
	{"YOY", -2.260615603621306e+01, -1.405252722537709e+01},
	{"YOZ", -3.042683474278397e+01, -2.187320593194800e+01},
	{"YPA", -1.362452280187446e+01, -2.856928089950586e+00},
	{"YPB", -2.805003029422362e+01, -1.728243558229974e+01},
	{"YPC", -2.368079847535278e+01, -1.291320376342890e+01},
	{"YPD", -2.948274472201446e+01, -1.871515001009058e+01},
	{"YPE", -1.314819168536010e+01, -2.380596973436225e+00},
	{"YPF", -2.802625396404757e+01, -1.725865925212369e+01},
	{"YPG", -1.919350573203199e+01, -8.425911020108117e+00},
	{"YPH", -1.597273191025699e+01, -5.205137198333117e+00},
	{"YPI", -1.579411516770466e+01, -5.026520455780785e+00},
	{"YPJ", -3.165820609661898e+01, -2.089061138469510e+01},
	{"YPK", -3.152577373421142e+01, -2.075817902228754e+01},
	{"YPL", -1.456489206525953e+01, -3.797297353335651e+00},
	{"YPM", -2.070330891845191e+01, -9.935714206528035e+00},
	{"YPN", -2.270463572308324e+01, -1.193704101115936e+01},
	{"YPO", -1.392377883075468e+01, -3.156184118830804e+00},
	{"YPP", -1.902367428284521e+01, -8.256079570921335e+00},
	{"YPQ", -3.291447676228012e+01, -2.214688205035624e+01},
	{"YPR", -1.281597106447037e+01, -2.048376352546488e+00},
	{"YPS", -2.021246630949763e+01, -9.444871597573753e+00},
	{"YPT", -1.381064985018041e+01, -3.043055138256532e+00},
	{"YPU", -1.495817362453403e+01, -4.190578912610148e+00},
	{"YPV", -3.107244439752376e+01, -2.030484968559988e+01},
	{"YPW", -2.727420175712906e+01, -1.650660704520518e+01},
	{"YPX", -3.641565546768793e+01, -2.564806075576405e+01},
	{"YPY", -2.052773794717672e+01, -9.760143235252841e+00},
	{"YPZ", -3.472077109313902e+01, -2.395317638121514e+01},
	{"YQA", -2.833581318118415e+01, -1.251313001565639e+01},
	{"YQB", -3.096323512832642e+01, -1.514055196279867e+01},
	{"YQC", -2.987423434622330e+01, -1.405155118069555e+01},
	{"YQD", -3.148493898841635e+01, -1.566225582288859e+01},
	{"YQE", -3.187283353256059e+01, -1.605015036703284e+01},
	{"YQF", -3.022554350173234e+01, -1.440286033620459e+01},
	{"YQG", -3.694856190619871e+01, -2.112587874067095e+01},
	{"YQH", -3.078329658867633e+01, -1.496061342314857e+01},
	{"YQI", -2.667485719656839e+01, -1.085217403104063e+01},
	{"YQJ", -3.274860836381813e+01, -1.692592519829037e+01},
	{"YQK", -3.858074710113745e+01, -2.275806393560969e+01},
	{"YQL", -3.122568416211933e+01, -1.540300099659157e+01},
	{"YQM", -3.039632257490275e+01, -1.457363940937499e+01},
	{"YQN", -3.323261469694739e+01, -1.740993153141963e+01},
	{"YQO", -3.142906052767283e+01, -1.560637736214507e+01},
	{"YQP", -3.143124591409868e+01, -1.560856274857093e+01},
	{"YQQ", -3.331264886283578e+01, -1.748996569730803e+01},
	{"YQR", -3.127794936555054e+01, -1.545526620002279e+01},
	{"YQS", -2.835026152083929e+01, -1.252757835531154e+01},
	{"YQT", -2.884993252477360e+01, -1.302724935924585e+01},
	{"YQU", -1.582468826258109e+01, -2.005097053339329e-03},
	{"YQV", -3.405325376260842e+01, -1.823057059708066e+01},
	{"YQW", -3.050205536733533e+01, -1.467937220180757e+01},
	{"YQX", -4.060387905902038e+01, -2.478119589349262e+01},
	{"YQY", -3.479659926046716e+01, -1.897391609493940e+01},
	{"YQZ", -4.174344649577091e+01, -2.592076333024315e+01},
	{"YRA", -1.443750063857761e+01, -3.270274573520339e+00},
	{"YRB", -2.132846687178230e+01, -1.016124080672504e+01},
	{"YRC", -2.063331262703278e+01, -9.466086561975507e+00},
	{"YRD", -2.026673765805048e+01, -9.099511592993212e+00},
	{"YRE", -1.218476745962313e+01, -1.017541394565863e+00},
	{"YRF", -2.559264000932307e+01, -1.442541394426580e+01},
	{"YRG", -2.248340551708690e+01, -1.131617945202963e+01},
	{"YRH", -2.035239939514179e+01, -9.185173330084517e+00},
	{"YRI", -1.329116107357116e+01, -2.123935008513888e+00},
	{"YRJ", -2.868374616055081e+01, -1.751652009549354e+01},
	{"YRK", -2.555306103905395e+01, -1.438583497399668e+01},
	{"YRL", -2.542037646307072e+01, -1.425315039801345e+01},
	{"YRM", -2.079052245360461e+01, -9.623296388547338e+00},
	{"YRN", -1.950236219142212e+01, -8.335136126364851e+00},
	{"YRO", -1.469257042295021e+01, -3.525344357892938e+00},
	{"YRP", -2.339018860840902e+01, -1.222296254335175e+01},
	{"YRQ", -3.007241398393456e+01, -1.890518791887730e+01},
	{"YRR", -1.711248401224664e+01, -5.945257947189374e+00},
	{"YRS", -1.936535332482163e+01, -8.198127259764366e+00},
	{"YRT", -1.934275465057235e+01, -8.175528585515080e+00},
	{"YRU", -1.544523733429931e+01, -4.278011269242043e+00},
	{"YRV", -2.600355732385164e+01, -1.483633125879438e+01},
	{"YRW", -2.331727387251840e+01, -1.215004780746113e+01},
	{"YRX", -3.073754015669402e+01, -1.957031409163675e+01},
	{"YRY", -2.292557611326014e+01, -1.175835004820287e+01},
	{"YRZ", -3.166866269054027e+01, -2.050143662548300e+01},
	{"YSA", -1.235922662413834e+01, -3.153504879551910e+00},
	{"YSB", -1.533749775313454e+01, -6.131776008548114e+00},
	{"YSC", -1.486173025496534e+01, -5.656008510378906e+00},
	{"YSD", -1.599579022780411e+01, -6.790068483217675e+00},
	{"YSE", -1.206191978624498e+01, -2.856198041658552e+00},
	{"YSF", -1.586415599470544e+01, -6.658434250119012e+00},
	{"YSG", -1.649799928248377e+01, -7.292277537897335e+00},
	{"YSH", -1.212172752347354e+01, -2.916005778887111e+00},
	{"YSI", -1.264672765262153e+01, -3.441005908035100e+00},
	{"YSJ", -1.788486966551440e+01, -8.679147920927972e+00},
	{"YSK", -1.687165018048944e+01, -7.665928435903007e+00},
	{"YSL", -1.515513044586365e+01, -5.949408701277219e+00},
	{"YSM", -1.484091362722019e+01, -5.635191882633757e+00},
	{"YSN", -1.652581579652173e+01, -7.320094051935296e+00},
	{"YSO", -1.229811733723908e+01, -3.092395592652654e+00},
	{"YSP", -1.405733598964017e+01, -4.851614245053737e+00},
	{"YSQ", -1.763040519842629e+01, -8.424683453839855e+00},
	{"YSR", -1.663907705743960e+01, -7.433355312853175e+00},
	{"YSS", -1.469719033281642e+01, -5.491468588229986e+00},
	{"YST", -1.192545935155538e+01, -2.719737606968947e+00},
	{"YSU", -1.365690582067430e+01, -4.451184076087872e+00},
	{"YSV", -1.862825194445449e+01, -9.422530199868060e+00},
	{"YSW", -1.441760276592202e+01, -5.211881021335585e+00},
	{"YSX", -3.033929730527048e+01, -2.113357556068405e+01},
	{"YSY", -1.639545830501874e+01, -7.189736560432308e+00},
	{"YSZ", -3.180227177738061e+01, -2.259655003279418e+01},
	{"YTA", -1.464800140640734e+01, -5.593933907611985e+00},
	{"YTB", -2.677130966169989e+01, -1.771724216290454e+01},
	{"YTC", -2.356210168921886e+01, -1.450803419042350e+01},
	{"YTD", -2.749321110333130e+01, -1.843914360453595e+01},
	{"YTE", -1.460485047823768e+01, -5.550782979442328e+00},
	{"YTF", -2.700162813373784e+01, -1.794756063494249e+01},
	{"YTG", -2.794326303685489e+01, -1.888919553805955e+01},
	{"YTH", -9.582741004969428e+00, -5.286735061740755e-01},
	{"YTI", -1.477881258983202e+01, -5.724745091036665e+00},
	{"YTJ", -3.009877032672986e+01, -2.104470282793450e+01},
	{"YTK", -2.992902909908942e+01, -2.087496160029406e+01},
	{"YTL", -2.634626689345284e+01, -1.729219939465749e+01},
	{"YTM", -2.685520735613506e+01, -1.780113985733970e+01},
	{"YTN", -2.753508022568012e+01, -1.848101272688477e+01},
	{"YTO", -1.145301529840519e+01, -2.398947799609834e+00},
	{"YTP", -2.760671719099005e+01, -1.855264969219470e+01},
	{"YTQ", -3.206533453391822e+01, -2.301126703512286e+01},
	{"YTR", -1.399690657290795e+01, -4.942839074112596e+00},
	{"YTS", -2.127731948066999e+01, -1.222325198187463e+01},
	{"YTT", -2.231456868415420e+01, -1.326050118535885e+01},
	{"YTU", -1.579251799718275e+01, -6.738450498387400e+00},
	{"YTV", -3.005507628044290e+01, -2.100100878164755e+01},
	{"YTW", -1.531242451862499e+01, -6.258357019829641e+00},
	{"YTX", -3.477113732068182e+01, -2.571706982188647e+01},
	{"YTY", -1.912089192538390e+01, -1.006682442658855e+01},
	{"YTZ", -3.224437077764269e+01, -2.319030327884733e+01},
	{"YUA", -2.496462523254968e+01, -1.249005263527901e+01},
	{"YUB", -2.535417304270131e+01, -1.287960044543063e+01},
	{"YUC", -2.006745986292692e+01, -7.592887265656247e+00},
	{"YUD", -2.527968473690103e+01, -1.280511213963036e+01},
	{"YUE", -2.498766390853890e+01, -1.251309131126823e+01},
	{"YUF", -2.693919441189051e+01, -1.446462181461984e+01},
	{"YUG", -2.079599823592190e+01, -8.321425638651228e+00},
	{"YUH", -2.760834045513499e+01, -1.513376785786432e+01},
	{"YUI", -2.502471342921670e+01, -1.255014083194602e+01},
	{"YUJ", -3.189709685771329e+01, -1.942252426044262e+01},
	{"YUK", -2.810032150386908e+01, -1.562574890659840e+01},
	{"YUL", -2.106809091114189e+01, -8.593518313871217e+00},
	{"YUM", -2.155703427370435e+01, -9.082461676433676e+00},
	{"YUN", -1.320627696176874e+01, -7.317043644980730e-01},
	{"YUO", -2.824083668334178e+01, -1.576626408607111e+01},
	{"YUP", -1.480977401816687e+01, -2.335201420896202e+00},
	{"YUQ", -3.335870080874868e+01, -2.088412821147800e+01},
	{"YUR", -1.872011271650509e+01, -6.245540119234421e+00},
	{"YUS", -1.525480542105473e+01, -2.780232823784055e+00},
	{"YUT", -1.767455041486485e+01, -5.199977817594173e+00},
	{"YUU", -3.070186884207304e+01, -1.822729624480236e+01},
	{"YUV", -3.004416649220981e+01, -1.756959389493914e+01},
	{"YUW", -2.772425769987211e+01, -1.524968510260144e+01},
	{"YUX", -3.031965735275499e+01, -1.784508475548432e+01},
	{"YUY", -2.947065234128381e+01, -1.699607974401314e+01},
	{"YUZ", -2.993757955032344e+01, -1.746300695305277e+01},
	{"YVA", -1.619769897540595e+01, -2.599651298365051e+00},
	{"YVB", -3.309201352483917e+01, -1.949396584779828e+01},
	{"YVC", -3.328136985217938e+01, -1.968332217513849e+01},
	{"YVD", -3.253644198592342e+01, -1.893839430888251e+01},
	{"YVE", -1.551958978499671e+01, -1.921542107955811e+00},
	{"YVF", -3.274078923121095e+01, -1.914274155417005e+01},
	{"YVG", -3.404918161853244e+01, -2.045113394149153e+01},
	{"YVH", -3.176402259396088e+01, -1.816597491691999e+01},
	{"YVI", -1.507738495696743e+01, -1.479337279926532e+00},
	{"YVJ", -3.397203931917305e+01, -2.037399164213215e+01},
	{"YVK", -3.585163994195137e+01, -2.225359226491047e+01},
	{"YVL", -3.312388301363687e+01, -1.952583533659597e+01},
	{"YVM", -3.211125754402788e+01, -1.851320986698698e+01},
	{"YVN", -2.213196593382736e+01, -8.533918256786468e+00},
	{"YVO", -1.589622641690590e+01, -2.298178739865005e+00},
	{"YVP", -3.220699280034684e+01, -1.860894512330594e+01},
	{"YVQ", -3.980383471528685e+01, -2.620578703824595e+01},
	{"YVR", -3.016302834743762e+01, -1.656498067039673e+01},
	{"YVS", -2.139602552927958e+01, -7.797977852238682e+00},
	{"YVT", -3.050914901581030e+01, -1.691110133876941e+01},
	{"YVU", -2.271093055350194e+01, -9.112882876461047e+00},
	{"YVV", -3.469741188089773e+01, -2.109936420385683e+01},
	{"YVW", -3.184017150874009e+01, -1.824212383169920e+01},
	{"YVX", -3.642965553238351e+01, -2.283160785534261e+01},
	{"YVY", -2.825249796835408e+01, -1.465445029131318e+01},
	{"YVZ", -3.983953441494123e+01, -2.624148673790033e+01},
	{"YWA", -1.244090263313137e+01, -2.384058041727853e+00},
	{"YWB", -2.786490205698655e+01, -1.780805746558303e+01},
	{"YWC", -2.792400161071879e+01, -1.786715701931528e+01},
	{"YWD", -2.743749161084252e+01, -1.738064701943900e+01},
	{"YWE", -1.221129790678230e+01, -2.154453315378786e+00},
	{"YWF", -2.771907939697824e+01, -1.766223480557472e+01},
	{"YWG", -2.884582282696390e+01, -1.878897823556038e+01},
	{"YWH", -1.202363890722987e+01, -1.966794315826356e+00},
	{"YWI", -1.239873767588420e+01, -2.341893084480684e+00},
	{"YWJ", -2.271077328279361e+01, -1.265392869139009e+01},
	{"YWK", -3.035752975330733e+01, -2.030068516190381e+01},
	{"YWL", -2.678756201380880e+01, -1.673071742240528e+01},
	{"YWM", -2.361669464324581e+01, -1.355985005184230e+01},
	{"YWN", -2.436257765650911e+01, -1.430573306510559e+01},
	{"YWO", -1.319088754525510e+01, -3.134042953851580e+00},
	{"YWP", -2.857428229540771e+01, -1.851743770400419e+01},
	{"YWQ", -3.282987906365733e+01, -2.277303447225382e+01},
	{"YWR", -1.603792928745700e+01, -5.981084696053487e+00},
	{"YWS", -2.562285656008783e+01, -1.556601196868431e+01},
	{"YWT", -2.334875091131064e+01, -1.329190631990713e+01},
	{"YWU", -2.112752583445806e+01, -1.107068124305455e+01},
	{"YWV", -3.068005242630250e+01, -2.062320783489899e+01},
	{"YWW", -2.671152893580953e+01, -1.665468434440601e+01},
	{"YWX", -4.002368532978274e+01, -2.996684073837922e+01},
	{"YWY", -2.362794688973007e+01, -1.357110229832655e+01},
	{"YWZ", -3.354666898042190e+01, -2.348982438901838e+01},
	{"YXA", -2.025708151701943e+01, -2.351467186013037e+00},
	{"YXB", -2.808066289794773e+01, -1.017504856694133e+01},
	{"YXC", -2.304162048306392e+01, -5.136006152057521e+00},
	{"YXD", -2.747405105086767e+01, -9.568436719861278e+00},
	{"YXE", -2.034124335777607e+01, -2.435629026769681e+00},
	{"YXF", -2.761616051692317e+01, -9.710546185916781e+00},
	{"YXG", -2.891522505703893e+01, -1.100961072603254e+01},
	{"YXH", -2.527320127977912e+01, -7.367586948772726e+00},
	{"YXI", -2.102874056633337e+01, -3.123126235326974e+00},
	{"YXJ", -3.012248724325631e+01, -1.221687291224992e+01},
	{"YXK", -3.102628047350923e+01, -1.312066614250284e+01},
	{"YXL", -2.757351449033270e+01, -9.667900159326310e+00},
	{"YXM", -2.685610806213389e+01, -8.950493731127498e+00},
	{"YXN", -2.936571816488387e+01, -1.146010383387748e+01},
	{"YXO", -2.344207746881763e+01, -5.536463137811234e+00},
	{"YXP", -2.248945956208572e+01, -4.583845231079326e+00},
	{"YXQ", -2.902848983277599e+01, -1.112287550176960e+01},
	{"YXR", -2.764667723072925e+01, -9.741062899722863e+00},
	{"YXS", -2.090888577876004e+01, -3.003271447753652e+00},
	{"YXT", -2.098747833751836e+01, -3.081864006511966e+00},
	{"YXU", -2.615156001824915e+01, -8.245945687242754e+00},
	{"YXV", -2.342349872922894e+01, -5.517884398222542e+00},
	{"YXW", -2.696165539143248e+01, -9.056041060426084e+00},
	{"YXX", -2.090225984327503e+01, -2.996645512268634e+00},
	{"YXY", -2.674574831631254e+01, -8.840133985306148e+00},
	{"YXZ", -4.056550958567559e+01, -2.265989525466920e+01},
	{"YYA", -1.860320504038208e+01, -5.693014913936924e+00},
	{"YYB", -2.562833735814269e+01, -1.271814723169754e+01},
	{"YYC", -2.575741347739886e+01, -1.284722335095371e+01},
	{"YYD", -2.610480669718734e+01, -1.319461657074219e+01},
	{"YYE", -1.392868379621317e+01, -1.018493669768017e+00},
	{"YYF", -2.580512483676277e+01, -1.289493471031762e+01},
	{"YYG", -2.691784803084395e+01, -1.400765790439880e+01},
	{"YYH", -2.564070424506208e+01, -1.273051411861693e+01},
	{"YYI", -1.951526504273693e+01, -6.605074916291777e+00},
	{"YYJ", -2.898510907275689e+01, -1.607491894631174e+01},
	{"YYK", -2.878179229276186e+01, -1.587160216631671e+01},
	{"YYL", -2.636354693069357e+01, -1.345335680424842e+01},
	{"YYM", -2.572088988385994e+01, -1.281069975741478e+01},
	{"YYN", -2.686999961286800e+01, -1.395980948642285e+01},
	{"YYO", -1.399112843461016e+01, -1.080938308165009e+00},
	{"YYP", -2.584645177724586e+01, -1.293626165080071e+01},
	{"YYQ", -3.090154023084973e+01, -1.799135010440458e+01},
	{"YYR", -2.624608313037925e+01, -1.333589300393410e+01},
	{"YYS", -2.297430103369152e+01, -1.006411090724637e+01},
	{"YYT", -2.413292456411733e+01, -1.122273443767218e+01},
	{"YYU", -2.755342966259265e+01, -1.464323953614750e+01},
	{"YYV", -2.867690474236288e+01, -1.576671461591772e+01},
	{"YYW", -2.513570165672549e+01, -1.222551153028034e+01},
	{"YYX", -3.298447139632837e+01, -2.007428126988322e+01},
	{"YYY", -2.268220541582143e+01, -9.772015289376281e+00},
	{"YYZ", -3.231853354262529e+01, -1.940834341618014e+01},
	{"YZA", -2.140393667354106e+01, -4.164260196237756e+00},
	{"YZB", -2.905533552266155e+01, -1.181565904535824e+01},
	{"YZC", -2.994025034090312e+01, -1.270057386359981e+01},
	{"YZD", -3.029941618230595e+01, -1.305973970500265e+01},
	{"YZE", -1.786989444802018e+01, -6.302179707168691e-01},
	{"YZF", -2.988654774868055e+01, -1.264687127137724e+01},
	{"YZG", -3.040951692180777e+01, -1.316984044450446e+01},
	{"YZH", -2.902625405195765e+01, -1.178657757465434e+01},
	{"YZI", -1.975917895291139e+01, -2.519502475608078e+00},
	{"YZJ", -3.293324162396493e+01, -1.569356514666162e+01},
	{"YZK", -3.156874168435128e+01, -1.432906520704798e+01},
	{"YZL", -2.725897682099774e+01, -1.001930034369443e+01},
	{"YZM", -2.946723275068776e+01, -1.222755627338445e+01},
	{"YZN", -3.057006037930740e+01, -1.333038390200409e+01},
	{"YZO", -2.037012144246988e+01, -3.130444965166575e+00},
	{"YZP", -2.838562509953759e+01, -1.114594862223429e+01},
	{"YZQ", -3.684945551328828e+01, -1.960977903598497e+01},
	{"YZR", -2.759838174953996e+01, -1.035870527223666e+01},
	{"YZS", -2.921720449259587e+01, -1.197752801529256e+01},
	{"YZT", -2.771713677371921e+01, -1.047746029641590e+01},
	{"YZU", -2.711937515881528e+01, -9.879698681511975e+00},
	{"YZV", -3.001693631743257e+01, -1.277725984012926e+01},
	{"YZW", -2.867831863402470e+01, -1.143864215672140e+01},
	{"YZX", -3.965759207473312e+01, -2.241791559742981e+01},
	{"YZY", -2.809307132305879e+01, -1.085339484575548e+01},
	{"YZZ", -2.568794962821522e+01, -8.448273150911911e+00},
	{"ZAA", -1.871342284533866e+01, -5.916893047294942e+00},
	{"ZAB", -1.584365914679865e+01, -3.047129348754935e+00},
	{"ZAC", -1.839687274180723e+01, -5.600342943763511e+00},
	{"ZAD", -1.769438798445231e+01, -4.897858186408592e+00},
	{"ZAE", -2.088860103169396e+01, -8.092071233650236e+00},
	{"ZAF", -2.161516294156024e+01, -8.818633143516518e+00},
	{"ZAG", -1.942902864814272e+01, -6.632498850099004e+00},
	{"ZAH", -1.822027718268791e+01, -5.423747384644194e+00},
	{"ZAI", -1.990801884683378e+01, -7.111489048790061e+00},
	{"ZAJ", -2.898644617659802e+01, -1.618991637855430e+01},
	{"ZAK", -2.065930931375975e+01, -7.862779515716030e+00},
	{"ZAL", -1.828522846999144e+01, -5.488698671947723e+00},
	{"ZAM", -1.920411770529805e+01, -6.407587907254337e+00},
	{"ZAN", -1.638255875159665e+01, -3.586028953552935e+00},
	{"ZAO", -2.269310651263595e+01, -9.896576714592229e+00},
	{"ZAP", -1.950953099426315e+01, -6.713001196219432e+00},
	{"ZAQ", -2.888259057922635e+01, -1.608606078118263e+01},
	{"ZAR", -1.462372555377834e+01, -1.827195755734619e+00},
	{"ZAS", -2.052224062499451e+01, -7.725710826950794e+00},
	{"ZAT", -1.438377249806520e+01, -1.587242700021479e+00},
	{"ZAU", -2.335006278107294e+01, -1.055353298302922e+01},
	{"ZAV", -2.303127323256904e+01, -1.023474343452532e+01},
	{"ZAW", -2.066725680767925e+01, -7.870727009635531e+00},
	{"ZAX", -2.874209176524786e+01, -1.594556196720414e+01},
	{"ZAY", -2.300616228010401e+01, -1.020963248206030e+01},
	{"ZAZ", -2.090379412834294e+01, -8.107264330299225e+00},
	{"ZBA", -1.977691554252800e+01, -1.628542498721325e+00},
	{"ZBB", -2.813726748910268e+01, -9.988894445296003e+00},
	{"ZBC", -2.884121170968511e+01, -1.069283866587844e+01},
	{"ZBD", -3.014664804701184e+01, -1.199827500320517e+01},
	{"ZBE", -1.961969171668062e+01, -1.471318672873947e+00},
	{"ZBF", -3.173545296439433e+01, -1.358707992058765e+01},
	{"ZBG", -3.333197605802035e+01, -1.518360301421368e+01},
	{"ZBH", -3.057709451417417e+01, -1.242872147036749e+01},
	{"ZBI", -2.253170310724675e+01, -4.383330063440070e+00},
	{"ZBJ", -2.813245827319131e+01, -9.984085229384640e+00},
	{"ZBK", -3.358779100868140e+01, -1.543941796487473e+01},
	{"ZBL", -2.421863081669292e+01, -6.070257772886246e+00},
	{"ZBM", -2.990633146992660e+01, -1.175795842611993e+01},
	{"ZBN", -3.068537914408598e+01, -1.253700610027931e+01},
	{"ZBO", -2.078090442271066e+01, -2.632531378903981e+00},
	{"ZBP", -3.139702166234501e+01, -1.324864861853834e+01},
	{"ZBQ", -3.745518208012847e+01, -1.930680903632180e+01},
	{"ZBR", -2.466865832820930e+01, -6.520285284402627e+00},
	{"ZBS", -2.671225864357120e+01, -8.563885599764530e+00},
	{"ZBT", -2.738669800578438e+01, -9.238324961977712e+00},
	{"ZBU", -2.285001103365816e+01, -4.701637989851492e+00},
	{"ZBV", -3.136968870957923e+01, -1.322131566577256e+01},
	{"ZBW", -3.077825175063560e+01, -1.262987870682893e+01},
	{"ZBX", -4.074238991936907e+01, -2.259401687556240e+01},
	{"ZBY", -2.301453915991278e+01, -4.866166116106103e+00},
	{"ZBZ", -3.525049379513648e+01, -1.710212075132980e+01},
	{"ZCA", -2.020821901588253e+01, -1.174931153834281e+00},
	{"ZCB", -3.195290843484772e+01, -1.291962057279948e+01},
	{"ZCC", -2.718367346640781e+01, -8.150385604359563e+00},
	{"ZCD", -3.092685278473587e+01, -1.189356492268762e+01},
	{"ZCE", -2.428568236841845e+01, -5.252394506370201e+00},
	{"ZCF", -3.181171856859063e+01, -1.277843070654239e+01},
	{"ZCG", -3.276727002002078e+01, -1.373398215797253e+01},
	{"ZCH", -2.434281255404757e+01, -5.309524691999322e+00},
	{"ZCI", -2.585765364333039e+01, -6.824365781282140e+00},
	{"ZCJ", -3.473148968934723e+01, -1.569820182729898e+01},
	{"ZCK", -2.644568834726884e+01, -7.412400485220593e+00},
	{"ZCL", -2.652286201926700e+01, -7.489574157218749e+00},
	{"ZCM", -3.171985964944716e+01, -1.268657178739891e+01},
	{"ZCN", -3.258616468507223e+01, -1.355287682302398e+01},
	{"ZCO", -2.030249565453331e+01, -1.269207792485058e+00},
	{"ZCP", -3.100480824366544e+01, -1.197152038161719e+01},
	{"ZCQ", -3.111580040213182e+01, -1.208251254008357e+01},
	{"ZCR", -2.352873279024161e+01, -4.495444928193367e+00},
	{"ZCS", -2.959813456990349e+01, -1.056484670785524e+01},
	{"ZCT", -2.523439794184231e+01, -6.201110079794065e+00},
	{"ZCU", -2.659619627140358e+01, -7.562908409355336e+00},
	{"ZCV", -3.438093229147274e+01, -1.534764442942449e+01},
	{"ZCW", -3.008919612080837e+01, -1.105590825876012e+01},
	{"ZCX", -3.572428800813793e+01, -1.669100014608968e+01},
	{"ZCY", -2.869342292138304e+01, -9.660135059334790e+00},
	{"ZCZ", -3.433533785266335e+01, -1.530204999061510e+01},
	{"ZDA", -2.394140687808873e+01, -4.548953174637646e+00},
	{"ZDB", -2.533409758512710e+01, -5.941643881676014e+00},
	{"ZDC", -2.647950364992452e+01, -7.087049946473442e+00},
	{"ZDD", -2.627085223406763e+01, -6.878398530616549e+00},
	{"ZDE", -2.168451609490701e+01, -2.292062391455927e+00},
	{"ZDF", -2.598694357305178e+01, -6.594489869600695e+00},
	{"ZDG", -2.671420970269356e+01, -7.321755999242475e+00},
	{"ZDH", -2.534031288624614e+01, -5.947859182795058e+00},
	{"ZDI", -2.173348920916176e+01, -2.341035505710683e+00},
	{"ZDJ", -2.834210769327763e+01, -8.949653989826551e+00},
	{"ZDK", -2.951895351365344e+01, -1.012649981020236e+01},
	{"ZDL", -2.654277374495671e+01, -7.150320041505631e+00},
	{"ZDM", -2.609661762526449e+01, -6.704163921813405e+00},
	{"ZDN", -2.636570268781906e+01, -6.973248984367980e+00},
	{"ZDO", -2.232314132383804e+01, -2.930687620386963e+00},
	{"ZDP", -2.675313355541722e+01, -7.360679851966143e+00},
	{"ZDQ", -3.096284504416696e+01, -1.157039134071588e+01},
	{"ZDR", -2.569260630425103e+01, -6.300152600799944e+00},
	{"ZDS", -2.463110596535028e+01, -5.238652261899201e+00},
	{"ZDT", -2.370142568741553e+01, -4.308971983964450e+00},
	{"ZDU", -2.162905397432548e+01, -2.236600270874400e+00},
	{"ZDV", -2.804811483791394e+01, -8.655661134462855e+00},
	{"ZDW", -2.542009571908788e+01, -6.027642015636801e+00},
	{"ZDX", -3.586203534544116e+01, -1.646958164199008e+01},
	{"ZDY", -2.678883794443097e+01, -7.396384240979891e+00},
	{"ZDZ", -3.194447714575966e+01, -1.255202344230858e+01},
	{"ZEA", -1.543200470412363e+01, -3.709789530589841e+00},
	{"ZEB", -1.636505328729996e+01, -4.642838113766171e+00},
	{"ZEC", -1.769352281964791e+01, -5.971307646114122e+00},
	{"ZED", -1.334131776739970e+01, -1.619102593865908e+00},
	{"ZEE", -1.788703071272365e+01, -6.164815539189859e+00},
	{"ZEF", -1.852054223671511e+01, -6.798327063181317e+00},
	{"ZEG", -2.065030041173941e+01, -8.928085238205622e+00},
	{"ZEH", -1.794922022553188e+01, -6.227005051998092e+00},
	{"ZEI", -1.765464887064998e+01, -5.932433697116191e+00},
	{"ZEJ", -2.811029255011513e+01, -1.638807737658134e+01},
	{"ZEK", -1.679727926610400e+01, -5.075064092570206e+00},
	{"ZEL", -1.739332890751173e+01, -5.671113733977935e+00},
	{"ZEM", -1.747009625270115e+01, -5.747881079167358e+00},
	{"ZEN", -1.445933981616447e+01, -2.737124642630677e+00},
	{"ZEO", -1.670921636499128e+01, -4.987001191457492e+00},
	{"ZEP", -1.802604597495657e+01, -6.303830801422776e+00},
	{"ZEQ", -2.759183929178880e+01, -1.586962411825501e+01},
	{"ZER", -1.519253660917599e+01, -3.470321435642201e+00},
	{"ZES", -1.640808401937849e+01, -4.685868845844695e+00},
	{"ZET", -1.557968906458430e+01, -3.857473891050511e+00},
	{"ZEU", -1.850087033192784e+01, -6.778655158394051e+00},
	{"ZEV", -2.192704371118142e+01, -1.020482853764763e+01},
	{"ZEW", -1.796925381481505e+01, -6.247038641281265e+00},
	{"ZEX", -2.597272040628980e+01, -1.425050523275601e+01},
	{"ZEY", -2.033550022782076e+01, -8.613285054286969e+00},
	{"ZEZ", -2.112916462967835e+01, -9.406949456144563e+00},
	{"ZFA", -2.063488871023376e+01, -1.655303440408086e+00},
	{"ZFB", -2.769574785234835e+01, -8.716162582522678e+00},
	{"ZFC", -2.710962000167313e+01, -8.130034731847450e+00},
	{"ZFD", -2.799159289246259e+01, -9.012007622636917e+00},
	{"ZFE", -2.477789343109377e+01, -5.798308161268091e+00},
	{"ZFF", -2.542132253423689e+01, -6.441737264411215e+00},
	{"ZFG", -2.764616241229598e+01, -8.666577142470302e+00},
	{"ZFH", -2.644663997251146e+01, -7.467054702685784e+00},
	{"ZFI", -2.236631990933004e+01, -3.386734639504363e+00},
	{"ZFJ", -2.843445698623806e+01, -9.454871716412383e+00},
	{"ZFK", -3.033063775118759e+01, -1.135105248136191e+01},
	{"ZFL", -2.613727903233870e+01, -7.157693762513025e+00},
	{"ZFM", -2.677782396326170e+01, -7.798238693436018e+00},
	{"ZFN", -2.839937887082899e+01, -9.419793601003310e+00},
	{"ZFO", -2.091084168081354e+01, -1.931256410987863e+00},
	{"ZFP", -2.730985681777695e+01, -8.330271547951273e+00},
	{"ZFQ", -3.257748332146016e+01, -1.359789805163449e+01},
	{"ZFR", -2.127896869015335e+01, -2.299383420327675e+00},
	{"ZFS", -2.663744363487499e+01, -7.657858365049313e+00},
	{"ZFT", -2.361837887787607e+01, -4.638793608050394e+00},
	{"ZFU", -2.608496935555981e+01, -7.105384085734137e+00},
	{"ZFV", -2.961146561476461e+01, -1.063188034493893e+01},
	{"ZFW", -2.736378053936328e+01, -8.384195269537603e+00},
	{"ZFX", -3.488885482579367e+01, -1.590926955596800e+01},
	{"ZFY", -2.800631288356964e+01, -9.026727613743963e+00},
	{"ZFZ", -3.101744828532020e+01, -1.203786301549453e+01},
	{"ZGA", -2.156302080671978e+01, -2.060466363766882e+00},
	{"ZGB", -2.786004597239783e+01, -8.357491529444944e+00},
	{"ZGC", -2.811107253240726e+01, -8.608518089454366e+00},
	{"ZGD", -2.798217758586634e+01, -8.479623142913445e+00},
	{"ZGE", -2.123293820814282e+01, -1.730383765189929e+00},
	{"ZGF", -2.766575636110903e+01, -8.163201918156130e+00},
	{"ZGG", -2.780724650114722e+01, -8.304692058194325e+00},
	{"ZGH", -2.432971095291288e+01, -4.827156509959986e+00},
	{"ZGI", -2.514314417387500e+01, -5.640589730922103e+00},
	{"ZGJ", -3.133509710909073e+01, -1.183254266613784e+01},
	{"ZGK", -3.157341104238797e+01, -1.207085659943508e+01},
	{"ZGL", -2.621695644583706e+01, -6.714402002884160e+00},
	{"ZGM", -2.761754137671119e+01, -8.114986933758299e+00},
	{"ZGN", -2.672983519896151e+01, -7.227280756008618e+00},
	{"ZGO", -2.239647929589562e+01, -2.893924852942731e+00},
	{"ZGP", -2.810333353361299e+01, -8.600779090660092e+00},
	{"ZGQ", -3.286649013700604e+01, -1.336393569405314e+01},
	{"ZGR", -2.501987703962880e+01, -5.517322596675910e+00},
	{"ZGS", -2.594331030356313e+01, -6.440755860610236e+00},
	{"ZGT", -2.505602251904302e+01, -5.553468076090132e+00},
	{"ZGU", -2.602838730036219e+01, -6.525832857409294e+00},
	{"ZGV", -3.070693191892653e+01, -1.120437747597364e+01},
	{"ZGW", -2.212466808967189e+01, -2.622113646718990e+00},
	{"ZGX", -3.608531060345339e+01, -1.658275616050051e+01},
	{"ZGY", -2.805992075826597e+01, -8.557366315313075e+00},
	{"ZGZ", -3.467356411748563e+01, -1.517100967453273e+01},
	{"ZHA", -1.972163025701859e+01, -1.602338683915812e+00},
	{"ZHB", -2.927165889209781e+01, -1.115236731899503e+01},
	{"ZHC", -2.924363500517065e+01, -1.112434343206787e+01},
	{"ZHD", -2.972308803199700e+01, -1.160379645889422e+01},
	{"ZHE", -1.966907193809188e+01, -1.549780364989099e+00},
	{"ZHF", -2.925832011120660e+01, -1.113902853810382e+01},
	{"ZHG", -3.024192713754872e+01, -1.212263556444594e+01},
	{"ZHH", -2.817901020214245e+01, -1.005971862903967e+01},
	{"ZHI", -2.016116846020609e+01, -2.041876887103311e+00},
	{"ZHJ", -3.216035716667868e+01, -1.404106559357590e+01},
	{"ZHK", -3.248396055539608e+01, -1.436466898229330e+01},
	{"ZHL", -2.978273170334534e+01, -1.166344013024256e+01},
	{"ZHM", -2.878365831202182e+01, -1.066436673891904e+01},
	{"ZHN", -2.969466023885737e+01, -1.157536866575459e+01},
	{"ZHO", -2.193772325394136e+01, -3.818431680838578e+00},
	{"ZHP", -2.962749529072357e+01, -1.150820371762079e+01},
	{"ZHQ", -3.391635505856765e+01, -1.579706348546487e+01},
	{"ZHR", -2.758304660878258e+01, -9.463755035679805e+00},
	{"ZHS", -2.823195894368725e+01, -1.011266737058447e+01},
	{"ZHT", -2.575091773539796e+01, -7.631626162295179e+00},
	{"ZHU", -2.762252478655937e+01, -9.503233213456593e+00},
	{"ZHV", -3.239909175580787e+01, -1.427980018270510e+01},
	{"ZHW", -2.836981231652212e+01, -1.025052074341934e+01},
	{"ZHX", -3.791229208751081e+01, -1.979300051440803e+01},
	{"ZHY", -2.780829321253127e+01, -9.689001639428492e+00},
	{"ZHZ", -3.492417433338452e+01, -1.680488276028174e+01},
	{"ZIA", -1.724873833413373e+01, -3.901809244236285e+00},
	{"ZIB", -1.862161462921215e+01, -5.274685539314707e+00},
	{"ZIC", -1.875400435154092e+01, -5.407075261643474e+00},
	{"ZID", -1.753251828226476e+01, -4.185589192367315e+00},
	{"ZIE", -1.767842967358091e+01, -4.331500583683472e+00},
	{"ZIF", -2.319707527321736e+01, -9.850146183319918e+00},
	{"ZIG", -2.017840911233953e+01, -6.831480022442087e+00},
	{"ZIH", -2.209525763060326e+01, -8.748328540705812e+00},
	{"ZII", -2.366233507281547e+01, -1.031540598291802e+01},
	{"ZIJ", -3.095470424814554e+01, -1.760777515824810e+01},
	{"ZIK", -1.989892602515146e+01, -6.551996935254024e+00},
	{"ZIL", -1.807021017538153e+01, -4.723281085484087e+00},
	{"ZIM", -1.868083327437773e+01, -5.333904184480284e+00},
	{"ZIN", -1.448387352618318e+01, -1.136944436285735e+00},
	{"ZIO", -1.634070544848172e+01, -2.993776358584283e+00},
	{"ZIP", -1.785504760687997e+01, -4.508118516982528e+00},
	{"ZIQ", -2.961422611863728e+01, -1.626729702873984e+01},
	{"ZIR", -2.093701805067627e+01, -7.590088960778822e+00},
	{"ZIS", -2.190207307139148e+01, -8.555143981494036e+00},
	{"ZIT", -1.814665768262254e+01, -4.799728592725097e+00},
	{"ZIU", -2.717776320362445e+01, -1.383083411372700e+01},
	{"ZIV", -2.465506653887919e+01, -1.130813744898175e+01},
	{"ZIW", -1.931783875948183e+01, -5.970909669584389e+00},
	{"ZIX", -2.812735438118681e+01, -1.478042529128937e+01},
	{"ZIY", -3.321100119921631e+01, -1.986407210931886e+01},
	{"ZIZ", -2.024735845288924e+01, -6.900429362991797e+00},
	{"ZJA", -2.500412545724434e+01, -2.977846312134286e+00},
	{"ZJB", -3.087201683115046e+01, -8.845737686040410e+00},
	{"ZJC", -3.172140647864700e+01, -9.695127333536941e+00},
	{"ZJD", -3.361556406091044e+01, -1.158928491580038e+01},
	{"ZJE", -2.358190490570112e+01, -1.555625760591059e+00},
	{"ZJF", -3.273924995731473e+01, -1.071297081220467e+01},
	{"ZJG", -3.232379085345400e+01, -1.029751170834394e+01},
	{"ZJH", -3.150993386014610e+01, -9.483654715036044e+00},
	{"ZJI", -2.758009232498019e+01, -5.553813179870128e+00},
	{"ZJJ", -3.151572657644566e+01, -9.489447431335599e+00},
	{"ZJK", -3.420429808431695e+01, -1.217801893920689e+01},
	{"ZJL", -3.271313095355355e+01, -1.068685180844350e+01},
	{"ZJM", -3.306905632728101e+01, -1.104277718217095e+01},
	{"ZJN", -3.601912605593363e+01, -1.399284691082357e+01},
	{"ZJO", -2.424299458059116e+01, -2.216715435481106e+00},
	{"ZJP", -3.248090859010004e+01, -1.045462944498999e+01},
	{"ZJQ", -3.546716033102592e+01, -1.344088118591586e+01},
	{"ZJR", -3.169133506784636e+01, -9.665055922736308e+00},
	{"ZJS", -3.213012388437497e+01, -1.010384473926492e+01},
	{"ZJT", -3.222426120659402e+01, -1.019798206148396e+01},
	{"ZJU", -2.385294751577254e+01, -1.826668370662481e+00},
	{"ZJV", -3.908621355062677e+01, -1.705993440551672e+01},
	{"ZJW", -3.146046959419775e+01, -9.434190449087692e+00},
	{"ZJX", -4.176551895769560e+01, -1.973923981258555e+01},
	{"ZJY", -3.823538970854021e+01, -1.620911056343015e+01},
	{"ZJZ", -3.634039080199864e+01, -1.431411165688859e+01},
	{"ZKA", -2.586127179712767e+01, -5.199492591631262e+00},
	{"ZKB", -2.817364672912604e+01, -7.511867523629630e+00},
	{"ZKC", -2.860552011144983e+01, -7.943740905953418e+00},
	{"ZKD", -2.923872832383533e+01, -8.576949118338920e+00},
	{"ZKE", -2.340187036444793e+01, -2.740091158951517e+00},
	{"ZKF", -2.807005506724817e+01, -7.408275861751767e+00},
	{"ZKG", -3.034265584456532e+01, -9.680876639068915e+00},
	{"ZKH", -2.774035522143531e+01, -7.078576015938905e+00},
	{"ZKI", -2.130005248280830e+01, -6.382732773118883e-01},
	{"ZKJ", -3.192083032596576e+01, -1.125905112046935e+01},
	{"ZKK", -3.125256041841806e+01, -1.059078121292165e+01},
	{"ZKL", -2.763118897854548e+01, -6.969409773049074e+00},
	{"ZKM", -2.860555762049020e+01, -7.943778414993792e+00},
	{"ZKN", -2.537928046920018e+01, -4.717501263703771e+00},
	{"ZKO", -2.623045890748020e+01, -5.568679701983789e+00},
	{"ZKP", -2.895649726595638e+01, -8.294718060459971e+00},
	{"ZKQ", -3.459997012053884e+01, -1.393819091504243e+01},
	{"ZKR", -2.938888688924892e+01, -8.727107683752511e+00},
	{"ZKS", -2.551040784367362e+01, -4.848628638177208e+00},
	{"ZKT", -2.627529535085280e+01, -5.613516145356390e+00},
	{"ZKU", -2.812336095360795e+01, -7.461581748111546e+00},
	{"ZKV", -3.176098539181046e+01, -1.109920618631405e+01},
	{"ZKW", -2.744680361480270e+01, -6.785024409306292e+00},
	{"ZKX", -3.557201698643210e+01, -1.491023778093569e+01},
	{"ZKY", -2.811702475149339e+01, -7.455245545996982e+00},
	{"ZKZ", -3.367387987230184e+01, -1.301210066680543e+01},
	{"ZLA", -2.230569407644324e+01, -5.953679734300376e+00},
	{"ZLB", -2.715569004037621e+01, -1.080367569823335e+01},
	{"ZLC", -2.776756744483000e+01, -1.141555310268713e+01},
	{"ZLD", -2.506835239178391e+01, -8.716338049641047e+00},
	{"ZLE", -1.681159461787961e+01, -4.595802757367489e-01},
	{"ZLF", -2.690691336643994e+01, -1.055489902429708e+01},
	{"ZLG", -2.859157977080843e+01, -1.223956542866556e+01},
	{"ZLH", -2.802344299725120e+01, -1.167142865510833e+01},
	{"ZLI", -1.860160882772352e+01, -2.249594485580657e+00},
	{"ZLJ", -3.132360738809666e+01, -1.497159304595379e+01},
	{"ZLK", -2.859590429140692e+01, -1.224388994926405e+01},
	{"ZLL", -2.384798425921137e+01, -7.495969917068502e+00},
	{"ZLM", -2.767066550407747e+01, -1.131865116193461e+01},
	{"ZLN", -2.838007928588940e+01, -1.202806494374654e+01},
	{"ZLO", -2.152700059508798e+01, -5.174986252945114e+00},
	{"ZLP", -2.765626013707059e+01, -1.130424579492773e+01},
	{"ZLQ", -3.241231164292650e+01, -1.606029730078364e+01},
	{"ZLR", -2.818694622779637e+01, -1.183493188565351e+01},
	{"ZLS", -2.595328316988827e+01, -9.601268827745406e+00},
	{"ZLT", -2.543408593771524e+01, -9.082071595572378e+00},
	{"ZLU", -2.655755569660279e+01, -1.020554135445993e+01},
	{"ZLV", -2.795627218994411e+01, -1.160425784780125e+01},
	{"ZLW", -2.765308853880366e+01, -1.130107419666079e+01},
	{"ZLX", -3.571427982705399e+01, -1.936226548491113e+01},
	{"ZLY", -2.503770034633474e+01, -8.685686004191876e+00},
	{"ZLZ", -3.437577030016977e+01, -1.802375595802690e+01},
	{"ZMA", -1.972796797848965e+01, -1.167697706656767e+00},
	{"ZMB", -2.632737044160323e+01, -7.767100169770345e+00},
	{"ZMC", -2.894553990677808e+01, -1.038526963494519e+01},
	{"ZMD", -2.911394251197669e+01, -1.055367224014381e+01},
	{"ZME", -2.255718191137687e+01, -3.996911639543991e+00},
	{"ZMF", -2.845590155231057e+01, -9.895631280477696e+00},
	{"ZMG", -3.010867686222073e+01, -1.154840659038785e+01},
	{"ZMH", -2.807752263832500e+01, -9.517252366492116e+00},
	{"ZMI", -2.064481473367277e+01, -2.084544461839892e+00},
	{"ZMJ", -3.153693832862280e+01, -1.297666805678992e+01},
	{"ZMK", -3.184538059273193e+01, -1.328511032089904e+01},
	{"ZML", -2.936108274467079e+01, -1.080081247283791e+01},
	{"ZMM", -2.638693355886677e+01, -7.826663287033885e+00},
	{"ZMN", -2.832209244808402e+01, -9.761822176251140e+00},
	{"ZMO", -2.081456478427151e+01, -2.254294512438632e+00},
	{"ZMP", -2.551903665379181e+01, -6.958766381958929e+00},
	{"ZMQ", -3.445369732314938e+01, -1.589342705131650e+01},
	{"ZMR", -2.869308258109196e+01, -1.013281230925908e+01},
	{"ZMS", -2.622463599392822e+01, -7.664365722095342e+00},
	{"ZMT", -2.593383649721228e+01, -7.373566225379402e+00},
	{"ZMU", -2.644350637773382e+01, -7.883236105900934e+00},
	{"ZMV",