package dtl

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CostPropertyType enumerates the values for cost property type.
type CostPropertyType string

const (
	// Projected ...
	Projected CostPropertyType = "Projected"
	// Reported ...
	Reported CostPropertyType = "Reported"
	// Unavailable ...
	Unavailable CostPropertyType = "Unavailable"
)

// PossibleCostPropertyTypeValues returns an array of possible values for the CostPropertyType const type.
func PossibleCostPropertyTypeValues() []CostPropertyType {
	return []CostPropertyType{Projected, Reported, Unavailable}
}

// CustomImageOsType enumerates the values for custom image os type.
type CustomImageOsType string

const (
	// Linux ...
	Linux CustomImageOsType = "Linux"
	// None ...
	None CustomImageOsType = "None"
	// Windows ...
	Windows CustomImageOsType = "Windows"
)

// PossibleCustomImageOsTypeValues returns an array of possible values for the CustomImageOsType const type.
func PossibleCustomImageOsTypeValues() []CustomImageOsType {
	return []CustomImageOsType{Linux, None, Windows}
}

// EnableStatus enumerates the values for enable status.
type EnableStatus string

const (
	// Disabled ...
	Disabled EnableStatus = "Disabled"
	// Enabled ...
	Enabled EnableStatus = "Enabled"
)

// PossibleEnableStatusValues returns an array of possible values for the EnableStatus const type.
func PossibleEnableStatusValues() []EnableStatus {
	return []EnableStatus{Disabled, Enabled}
}

// LabStorageType enumerates the values for lab storage type.
type LabStorageType string

const (
	// Premium ...
	Premium LabStorageType = "Premium"
	// Standard ...
	Standard LabStorageType = "Standard"
)

// PossibleLabStorageTypeValues returns an array of possible values for the LabStorageType const type.
func PossibleLabStorageTypeValues() []LabStorageType {
	return []LabStorageType{Premium, Standard}
}

// LinuxOsState enumerates the values for linux os state.
type LinuxOsState string

const (
	// DeprovisionApplied ...
	DeprovisionApplied LinuxOsState = "DeprovisionApplied"
	// DeprovisionRequested ...
	DeprovisionRequested LinuxOsState = "DeprovisionRequested"
	// NonDeprovisioned ...
	NonDeprovisioned LinuxOsState = "NonDeprovisioned"
)

// PossibleLinuxOsStateValues returns an array of possible values for the LinuxOsState const type.
func PossibleLinuxOsStateValues() []LinuxOsState {
	return []LinuxOsState{DeprovisionApplied, DeprovisionRequested, NonDeprovisioned}
}

// PolicyEvaluatorType enumerates the values for policy evaluator type.
type PolicyEvaluatorType string

const (
	// AllowedValuesPolicy ...
	AllowedValuesPolicy PolicyEvaluatorType = "AllowedValuesPolicy"
	// MaxValuePolicy ...
	MaxValuePolicy PolicyEvaluatorType = "MaxValuePolicy"
)

// PossiblePolicyEvaluatorTypeValues returns an array of possible values for the PolicyEvaluatorType const type.
func PossiblePolicyEvaluatorTypeValues() []PolicyEvaluatorType {
	return []PolicyEvaluatorType{AllowedValuesPolicy, MaxValuePolicy}
}

// PolicyFactName enumerates the values for policy fact name.
type PolicyFactName string

const (
	// PolicyFactNameGalleryImage ...
	PolicyFactNameGalleryImage PolicyFactName = "GalleryImage"
	// PolicyFactNameLabVMCount ...
	PolicyFactNameLabVMCount PolicyFactName = "LabVmCount"
	// PolicyFactNameLabVMSize ...
	PolicyFactNameLabVMSize PolicyFactName = "LabVmSize"
	// PolicyFactNameUserOwnedLabVMCount ...
	PolicyFactNameUserOwnedLabVMCount PolicyFactName = "UserOwnedLabVmCount"
	// PolicyFactNameUserOwnedLabVMCountInSubnet ...
	PolicyFactNameUserOwnedLabVMCountInSubnet PolicyFactName = "UserOwnedLabVmCountInSubnet"
)

// PossiblePolicyFactNameValues returns an array of possible values for the PolicyFactName const type.
func PossiblePolicyFactNameValues() []PolicyFactName {
	return []PolicyFactName{PolicyFactNameGalleryImage, PolicyFactNameLabVMCount, PolicyFactNameLabVMSize, PolicyFactNameUserOwnedLabVMCount, PolicyFactNameUserOwnedLabVMCountInSubnet}
}

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled ...
	PolicyStatusDisabled PolicyStatus = "Disabled"
	// PolicyStatusEnabled ...
	PolicyStatusEnabled PolicyStatus = "Enabled"
)

// PossiblePolicyStatusValues returns an array of possible values for the PolicyStatus const type.
func PossiblePolicyStatusValues() []PolicyStatus {
	return []PolicyStatus{PolicyStatusDisabled, PolicyStatusEnabled}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// GitHub ...
	GitHub SourceControlType = "GitHub"
	// VsoGit ...
	VsoGit SourceControlType = "VsoGit"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{GitHub, VsoGit}
}

// SubscriptionNotificationState enumerates the values for subscription notification state.
type SubscriptionNotificationState string

const (
	// Deleted ...
	Deleted SubscriptionNotificationState = "Deleted"
	// NotDefined ...
	NotDefined SubscriptionNotificationState = "NotDefined"
	// Registered ...
	Registered SubscriptionNotificationState = "Registered"
	// Suspended ...
	Suspended SubscriptionNotificationState = "Suspended"
	// Unregistered ...
	Unregistered SubscriptionNotificationState = "Unregistered"
	// Warned ...
	Warned SubscriptionNotificationState = "Warned"
)

// PossibleSubscriptionNotificationStateValues returns an array of possible values for the SubscriptionNotificationState const type.
func PossibleSubscriptionNotificationStateValues() []SubscriptionNotificationState {
	return []SubscriptionNotificationState{Deleted, NotDefined, Registered, Suspended, Unregistered, Warned}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// LabBillingTask ...
	LabBillingTask TaskType = "LabBillingTask"
	// LabVmsShutdownTask ...
	LabVmsShutdownTask TaskType = "LabVmsShutdownTask"
	// LabVmsStartupTask ...
	LabVmsStartupTask TaskType = "LabVmsStartupTask"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{LabBillingTask, LabVmsShutdownTask, LabVmsStartupTask}
}

// UsagePermissionType enumerates the values for usage permission type.
type UsagePermissionType string

const (
	// Allow ...
	Allow UsagePermissionType = "Allow"
	// Default ...
	Default UsagePermissionType = "Default"
	// Deny ...
	Deny UsagePermissionType = "Deny"
)

// PossibleUsagePermissionTypeValues returns an array of possible values for the UsagePermissionType const type.
func PossibleUsagePermissionTypeValues() []UsagePermissionType {
	return []UsagePermissionType{Allow, Default, Deny}
}

// WindowsOsState enumerates the values for windows os state.
type WindowsOsState string

const (
	// NonSysprepped ...
	NonSysprepped WindowsOsState = "NonSysprepped"
	// SysprepApplied ...
	SysprepApplied WindowsOsState = "SysprepApplied"
	// SysprepRequested ...
	SysprepRequested WindowsOsState = "SysprepRequested"
)

// PossibleWindowsOsStateValues returns an array of possible values for the WindowsOsState const type.
func PossibleWindowsOsStateValues() []WindowsOsState {
	return []WindowsOsState{NonSysprepped, SysprepApplied, SysprepRequested}
}

// ApplyArtifactsRequest request body for applying artifacts to a virtual machine.
type ApplyArtifactsRequest struct {
	// Artifacts - The list of artifacts to apply.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
}

// ArmTemplateInfo information about a generated ARM template.
type ArmTemplateInfo struct {
	autorest.Response `json:"-"`
	// Template - The template's contents.
	Template interface{} `json:"template,omitempty"`
	// Parameters - The parameters of the ARM template.
	Parameters interface{} `json:"parameters,omitempty"`
}

// Artifact an artifact.
type Artifact struct {
	autorest.Response `json:"-"`
	// ArtifactProperties - The properties of the resource.
	*ArtifactProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ArtifactProperties != nil {
		objectMap["properties"] = a.ArtifactProperties
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Artifact struct.
func (a *Artifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactProperties ArtifactProperties
				err = json.Unmarshal(*v, &artifactProperties)
				if err != nil {
					return err
				}
				a.ArtifactProperties = &artifactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactDeploymentStatusProperties properties of an artifact deployment.
type ArtifactDeploymentStatusProperties struct {
	// DeploymentStatus - The deployment status of the artifact.
	DeploymentStatus *string `json:"deploymentStatus,omitempty"`
	// ArtifactsApplied - The total count of the artifacts that were successfully applied.
	ArtifactsApplied *int32 `json:"artifactsApplied,omitempty"`
	// TotalArtifacts - The total count of the artifacts that were tentatively applied.
	TotalArtifacts *int32 `json:"totalArtifacts,omitempty"`
}

// ArtifactInstallProperties properties of an artifact.
type ArtifactInstallProperties struct {
	// ArtifactID - The artifact's identifier.
	ArtifactID *string `json:"artifactId,omitempty"`
	// Parameters - The parameters of the artifact.
	Parameters *[]ArtifactParameterProperties `json:"parameters,omitempty"`
}

// ArtifactParameterProperties properties of an artifact parameter.
type ArtifactParameterProperties struct {
	// Name - The name of the artifact parameter.
	Name *string `json:"name,omitempty"`
	// Value - The value of the artifact parameter.
	Value *string `json:"value,omitempty"`
}

// ArtifactProperties properties of an artifact.
type ArtifactProperties struct {
	// Title - The title of the artifact.
	Title *string `json:"title,omitempty"`
	// Description - The description of the artifact.
	Description *string `json:"description,omitempty"`
	// FilePath - The file path of the artifact.
	FilePath *string `json:"filePath,omitempty"`
	// Icon - The icon of the artifact.
	Icon *string `json:"icon,omitempty"`
	// TargetOsType - Gets or sets the type of the target os.
	TargetOsType *string `json:"targetOsType,omitempty"`
	// Parameters - The parameters of the artifact.
	Parameters interface{} `json:"parameters,omitempty"`
}

// ArtifactSource properties of an artifact source.
type ArtifactSource struct {
	autorest.Response `json:"-"`
	// ArtifactSourceProperties - The properties of the resource.
	*ArtifactSourceProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ArtifactSource.
func (as ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.ArtifactSourceProperties != nil {
		objectMap["properties"] = as.ArtifactSourceProperties
	}
	if as.ID != nil {
		objectMap["id"] = as.ID
	}
	if as.Name != nil {
		objectMap["name"] = as.Name
	}
	if as.Type != nil {
		objectMap["type"] = as.Type
	}
	if as.Location != nil {
		objectMap["location"] = as.Location
	}
	if as.Tags != nil {
		objectMap["tags"] = as.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArtifactSource struct.
func (as *ArtifactSource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var artifactSourceProperties ArtifactSourceProperties
				err = json.Unmarshal(*v, &artifactSourceProperties)
				if err != nil {
					return err
				}
				as.ArtifactSourceProperties = &artifactSourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				as.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				as.Tags = tags
			}
		}
	}

	return nil
}

// ArtifactSourceProperties properties of an artifact source.
type ArtifactSourceProperties struct {
	// DisplayName - The display name of the artifact source.
	DisplayName *string `json:"displayName,omitempty"`
	// URI - The URI of the artifact source.
	URI *string `json:"uri,omitempty"`
	// SourceType - The type of the artifact source. Possible values include: 'VsoGit', 'GitHub'
	SourceType SourceControlType `json:"sourceType,omitempty"`
	// FolderPath - The folder path of the artifact source.
	FolderPath *string `json:"folderPath,omitempty"`
	// BranchRef - The branch reference of the artifact source.
	BranchRef *string `json:"branchRef,omitempty"`
	// SecurityToken - The security token of the artifact source.
	SecurityToken *string `json:"securityToken,omitempty"`
	// Status - The status of the artifact source. Possible values include: 'Enabled', 'Disabled'
	Status EnableStatus `json:"status,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// CloudError ...
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody ...
type CloudErrorBody struct {
	Code    *string           `json:"code,omitempty"`
	Message *string           `json:"message,omitempty"`
	Target  *string           `json:"target,omitempty"`
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// Cost a cost item.
type Cost struct {
	autorest.Response `json:"-"`
	// CostProperties - The properties of the resource.
	*CostProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Cost.
func (c Cost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CostProperties != nil {
		objectMap["properties"] = c.CostProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cost struct.
func (c *Cost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var costProperties CostProperties
				err = json.Unmarshal(*v, &costProperties)
				if err != nil {
					return err
				}
				c.CostProperties = &costProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// CostInsight ...
type CostInsight struct {
	autorest.Response `json:"-"`
	// CostInsightProperties - The properties of the resource.
	*CostInsightProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CostInsight.
func (ci CostInsight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CostInsightProperties != nil {
		objectMap["properties"] = ci.CostInsightProperties
	}
	if ci.ID != nil {
		objectMap["id"] = ci.ID
	}
	if ci.Name != nil {
		objectMap["name"] = ci.Name
	}
	if ci.Type != nil {
		objectMap["type"] = ci.Type
	}
	if ci.Location != nil {
		objectMap["location"] = ci.Location
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CostInsight struct.
func (ci *CostInsight) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var costInsightProperties CostInsightProperties
				err = json.Unmarshal(*v, &costInsightProperties)
				if err != nil {
					return err
				}
				ci.CostInsightProperties = &costInsightProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ci.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ci.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ci.Tags = tags
			}
		}
	}

	return nil
}

// CostInsightProperties ...
type CostInsightProperties struct {
	CurrencyCode *string             `json:"currencyCode,omitempty"`
	VMCosts      *[]VMCostProperties `json:"vmCosts,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// CostInsightRefreshDataFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CostInsightRefreshDataFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CostInsightRefreshDataFuture) Result(client CostInsightClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CostInsightRefreshDataFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.CostInsightRefreshDataFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CostPerDayProperties the per-day properties of a cost item.
type CostPerDayProperties struct {
	// Date - The date of the cost item.
	Date *date.Time `json:"date,omitempty"`
	// Cost - The cost of the cost item.
	Cost *float64 `json:"cost,omitempty"`
	// CostType - The type of the cost. Possible values include: 'Unavailable', 'Reported', 'Projected'
	CostType CostPropertyType `json:"costType,omitempty"`
}

// CostProperties properties of a cost item.
type CostProperties struct {
	// CurrencyCode - The currency code of the cost.
	CurrencyCode *string `json:"currencyCode,omitempty"`
	// Costs - The per-day costs items of the cost.
	Costs *[]CostPerDayProperties `json:"costs,omitempty"`
}

// CostRefreshDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CostRefreshDataFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CostRefreshDataFuture) Result(client CostClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CostRefreshDataFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.CostRefreshDataFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CustomImage a custom image.
type CustomImage struct {
	autorest.Response `json:"-"`
	// CustomImageProperties - The properties of the resource.
	*CustomImageProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomImage.
func (ci CustomImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CustomImageProperties != nil {
		objectMap["properties"] = ci.CustomImageProperties
	}
	if ci.ID != nil {
		objectMap["id"] = ci.ID
	}
	if ci.Name != nil {
		objectMap["name"] = ci.Name
	}
	if ci.Type != nil {
		objectMap["type"] = ci.Type
	}
	if ci.Location != nil {
		objectMap["location"] = ci.Location
	}
	if ci.Tags != nil {
		objectMap["tags"] = ci.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomImage struct.
func (ci *CustomImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customImageProperties CustomImageProperties
				err = json.Unmarshal(*v, &customImageProperties)
				if err != nil {
					return err
				}
				ci.CustomImageProperties = &customImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ci.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ci.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ci.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ci.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ci.Tags = tags
			}
		}
	}

	return nil
}

// CustomImageCreateOrUpdateResourceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CustomImageCreateOrUpdateResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomImageCreateOrUpdateResourceFuture) Result(client CustomImageClient) (ci CustomImage, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CustomImageCreateOrUpdateResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.CustomImageCreateOrUpdateResourceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ci.Response.Response, err = future.GetResult(sender); err == nil && ci.Response.Response.StatusCode != http.StatusNoContent {
		ci, err = client.CreateOrUpdateResourceResponder(ci.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.CustomImageCreateOrUpdateResourceFuture", "Result", ci.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomImageDeleteResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomImageDeleteResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomImageDeleteResourceFuture) Result(client CustomImageClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.CustomImageDeleteResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.CustomImageDeleteResourceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CustomImageProperties properties of a custom image.
type CustomImageProperties struct {
	VM *CustomImagePropertiesFromVM `json:"vm,omitempty"`
	// Vhd - The VHD from which the image is to be created.
	Vhd *CustomImagePropertiesCustom `json:"vhd,omitempty"`
	// Description - The description of the custom image.
	Description *string `json:"description,omitempty"`
	// OsType - The OS type of the custom image. Possible values include: 'Windows', 'Linux', 'None'
	OsType CustomImageOsType `json:"osType,omitempty"`
	// Author - The author of the custom image.
	Author *string `json:"author,omitempty"`
	// CreationDate - The creation date of the custom image.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// CustomImagePropertiesCustom properties for creating a custom image from a VHD.
type CustomImagePropertiesCustom struct {
	// ImageName - The image name.
	ImageName *string `json:"imageName,omitempty"`
	// SysPrep - Indicates whether sysprep has been run on the VHD.
	SysPrep *bool `json:"sysPrep,omitempty"`
}

// CustomImagePropertiesFromVM properties for creating a custom image from a virtual machine.
type CustomImagePropertiesFromVM struct {
	// SourceVMID - The source vm identifier.
	SourceVMID *string `json:"sourceVmId,omitempty"`
	// SysPrep - Indicates whether sysprep has been run on the VHD.
	SysPrep *bool `json:"sysPrep,omitempty"`
	// WindowsOsInfo - The Windows OS information of the VM.
	WindowsOsInfo *WindowsOsInfo `json:"windowsOsInfo,omitempty"`
	// LinuxOsInfo - The Linux OS information of the VM.
	LinuxOsInfo *LinuxOsInfo `json:"linuxOsInfo,omitempty"`
}

// DayDetails properties of a daily schedule.
type DayDetails struct {
	Time *string `json:"time,omitempty"`
}

// EvaluatePoliciesProperties properties for evaluating a policy set.
type EvaluatePoliciesProperties struct {
	// FactName - The fact name.
	FactName *string `json:"factName,omitempty"`
	// FactData - The fact data.
	FactData *string `json:"factData,omitempty"`
	// ValueOffset - The value offset.
	ValueOffset *string `json:"valueOffset,omitempty"`
}

// EvaluatePoliciesRequest request body for evaluating a policy set.
type EvaluatePoliciesRequest struct {
	// Policies - Policies to evaluate.
	Policies *[]EvaluatePoliciesProperties `json:"policies,omitempty"`
}

// EvaluatePoliciesResponse response body for evaluating a policy set.
type EvaluatePoliciesResponse struct {
	autorest.Response `json:"-"`
	// Results - Results of evaluating a policy set.
	Results *[]PolicySetResult `json:"results,omitempty"`
}

// Formula a formula.
type Formula struct {
	autorest.Response `json:"-"`
	// FormulaProperties - The properties of the resource.
	*FormulaProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Formula.
func (f Formula) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.FormulaProperties != nil {
		objectMap["properties"] = f.FormulaProperties
	}
	if f.ID != nil {
		objectMap["id"] = f.ID
	}
	if f.Name != nil {
		objectMap["name"] = f.Name
	}
	if f.Type != nil {
		objectMap["type"] = f.Type
	}
	if f.Location != nil {
		objectMap["location"] = f.Location
	}
	if f.Tags != nil {
		objectMap["tags"] = f.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Formula struct.
func (f *Formula) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var formulaProperties FormulaProperties
				err = json.Unmarshal(*v, &formulaProperties)
				if err != nil {
					return err
				}
				f.FormulaProperties = &formulaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				f.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				f.Tags = tags
			}
		}
	}

	return nil
}

// FormulaCreateOrUpdateResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FormulaCreateOrUpdateResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FormulaCreateOrUpdateResourceFuture) Result(client FormulaClient) (f Formula, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.FormulaCreateOrUpdateResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.FormulaCreateOrUpdateResourceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CreateOrUpdateResourceResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.FormulaCreateOrUpdateResourceFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FormulaProperties properties of a formula.
type FormulaProperties struct {
	// Description - The description of the formula.
	Description *string `json:"description,omitempty"`
	// Author - The author of the formula.
	Author *string `json:"author,omitempty"`
	// OsType - The OS type of the formula.
	OsType *string `json:"osType,omitempty"`
	// CreationDate - The creation date of the formula.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// FormulaContent - The content of the formula.
	FormulaContent *LabVirtualMachine `json:"formulaContent,omitempty"`
	// VM - Information about a VM from which a formula is to be created.
	VM *FormulaPropertiesFromVM `json:"vm,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// FormulaPropertiesFromVM information about a VM from which a formula is to be created.
type FormulaPropertiesFromVM struct {
	// LabVMID - The identifier of the VM from which a formula is to be created.
	LabVMID *string `json:"labVmId,omitempty"`
}

// GalleryImage a gallery image.
type GalleryImage struct {
	// GalleryImageProperties - The properties of the resource.
	*GalleryImageProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImage.
func (gi GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gi.GalleryImageProperties != nil {
		objectMap["properties"] = gi.GalleryImageProperties
	}
	if gi.ID != nil {
		objectMap["id"] = gi.ID
	}
	if gi.Name != nil {
		objectMap["name"] = gi.Name
	}
	if gi.Type != nil {
		objectMap["type"] = gi.Type
	}
	if gi.Location != nil {
		objectMap["location"] = gi.Location
	}
	if gi.Tags != nil {
		objectMap["tags"] = gi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImage struct.
func (gi *GalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageProperties GalleryImageProperties
				err = json.Unmarshal(*v, &galleryImageProperties)
				if err != nil {
					return err
				}
				gi.GalleryImageProperties = &galleryImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gi.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageProperties properties of a gallery image.
type GalleryImageProperties struct {
	// Author - The author of the gallery image.
	Author *string `json:"author,omitempty"`
	// CreatedDate - The creation date of the gallery image.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Description - The description of the gallery image.
	Description *string `json:"description,omitempty"`
	// ImageReference - The image reference of the gallery image.
	ImageReference *GalleryImageReference `json:"imageReference,omitempty"`
	// Icon - The icon of the gallery image.
	Icon *string `json:"icon,omitempty"`
	// Enabled - Indicates whether this gallery image is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// GalleryImageReference the reference information for an Azure Marketplace image.
type GalleryImageReference struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GenerateArmTemplateRequest parameters for generating an ARM template for deploying artifacts.
type GenerateArmTemplateRequest struct {
	// VirtualMachineName - The resource name of the virtual machine.
	VirtualMachineName *string `json:"virtualMachineName,omitempty"`
	// Parameters - The parameters of the ARM template.
	Parameters *[]ParameterInfo `json:"parameters,omitempty"`
	// Location - The location of the virtual machine.
	Location *string `json:"location,omitempty"`
}

// GenerateUploadURIParameter properties for generating an upload URI.
type GenerateUploadURIParameter struct {
	// BlobName - The blob name of the upload URI.
	BlobName *string `json:"blobName,omitempty"`
}

// GenerateUploadURIResponse reponse body for generating an upload URI.
type GenerateUploadURIResponse struct {
	autorest.Response `json:"-"`
	// UploadURI - The upload URI for the VHD.
	UploadURI *string `json:"uploadUri,omitempty"`
}

// HourDetails properties of an hourly schedule.
type HourDetails struct {
	// Minute - Minutes of the hour the schedule will run.
	Minute *int32 `json:"minute,omitempty"`
}

// Lab a lab.
type Lab struct {
	autorest.Response `json:"-"`
	// LabProperties - The properties of the resource.
	*LabProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LabProperties != nil {
		objectMap["properties"] = l.LabProperties
	}
	if l.ID != nil {
		objectMap["id"] = l.ID
	}
	if l.Name != nil {
		objectMap["name"] = l.Name
	}
	if l.Type != nil {
		objectMap["type"] = l.Type
	}
	if l.Location != nil {
		objectMap["location"] = l.Location
	}
	if l.Tags != nil {
		objectMap["tags"] = l.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Lab struct.
func (l *Lab) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labProperties LabProperties
				err = json.Unmarshal(*v, &labProperties)
				if err != nil {
					return err
				}
				l.LabProperties = &labProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				l.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				l.Tags = tags
			}
		}
	}

	return nil
}

// LabCreateEnvironmentFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabCreateEnvironmentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabCreateEnvironmentFuture) Result(client LabClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabCreateEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabCreateEnvironmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabCreateOrUpdateResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabCreateOrUpdateResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabCreateOrUpdateResourceFuture) Result(client LabClient) (l Lab, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabCreateOrUpdateResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabCreateOrUpdateResourceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if l.Response.Response, err = future.GetResult(sender); err == nil && l.Response.Response.StatusCode != http.StatusNoContent {
		l, err = client.CreateOrUpdateResourceResponder(l.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.LabCreateOrUpdateResourceFuture", "Result", l.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LabDeleteResourceFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabDeleteResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LabDeleteResourceFuture) Result(client LabClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.LabDeleteResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.LabDeleteResourceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabProperties properties of a lab.
type LabProperties struct {
	// DefaultStorageAccount - The lab's default storage account.
	DefaultStorageAccount *string `json:"defaultStorageAccount,omitempty"`
	// ArtifactsStorageAccount - The artifact storage account of the lab.
	ArtifactsStorageAccount *string `json:"artifactsStorageAccount,omitempty"`
	// StorageAccounts - The storage accounts of the lab.
	StorageAccounts *[]string `json:"storageAccounts,omitempty"`
	// VaultName - The name of the key vault of the lab.
	VaultName *string `json:"vaultName,omitempty"`
	// LabStorageType - The type of the lab storage. Possible values include: 'Standard', 'Premium'
	LabStorageType LabStorageType `json:"labStorageType,omitempty"`
	// DefaultVirtualNetworkID - The default virtual network identifier of the lab.
	DefaultVirtualNetworkID *string `json:"defaultVirtualNetworkId,omitempty"`
	// CreatedDate - The creation date of the lab.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LabVhd properties of a VHD in the lab.
type LabVhd struct {
	// ID - The absolute URI of the VHD.
	ID *string `json:"id,omitempty"`
}

// LabVirtualMachine a virtual machine.
type LabVirtualMachine struct {
	autorest.Response `json:"-"`
	// LabVirtualMachineProperties - The properties of the resource.
	*LabVirtualMachineProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabVirtualMachine.
func (lvm LabVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lvm.LabVirtualMachineProperties != nil {
		objectMap["properties"] = lvm.LabVirtualMachineProperties
	}
	if lvm.ID != nil {
		objectMap["id"] = lvm.ID
	}
	if lvm.Name != nil {
		objectMap["name"] = lvm.Name
	}
	if lvm.Type != nil {
		objectMap["type"] = lvm.Type
	}
	if lvm.Location != nil {
		objectMap["location"] = lvm.Location
	}
	if lvm.Tags != nil {
		objectMap["tags"] = lvm.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabVirtualMachine struct.
func (lvm *LabVirtualMachine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labVirtualMachineProperties LabVirtualMachineProperties
				err = json.Unmarshal(*v, &labVirtualMachineProperties)
				if err != nil {
					return err
				}
				lvm.LabVirtualMachineProperties = &labVirtualMachineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lvm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lvm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lvm.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lvm.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lvm.Tags = tags
			}
		}
	}

	return nil
}

// LabVirtualMachineProperties properties of a virtual machine.
type LabVirtualMachineProperties struct {
	// Notes - The notes of the virtual machine.
	Notes *string `json:"notes,omitempty"`
	// OwnerObjectID - The object identifier of the owner of the virtual machine.
	OwnerObjectID *string `json:"ownerObjectId,omitempty"`
	// CreatedByUserID - The object identifier of the creator of the virtual machine.
	CreatedByUserID *string `json:"createdByUserId,omitempty"`
	// CreatedByUser - The email address of creator of the virtual machine.
	CreatedByUser *string `json:"createdByUser,omitempty"`
	// ComputeID - The resource identifier (Microsoft.Compute) of the virtual machine.
	ComputeID *string `json:"computeId,omitempty"`
	// CustomImageID - The custom image identifier of the virtual machine.
	CustomImageID *string `json:"customImageId,omitempty"`
	// OsType - The OS type of the virtual machine.
	OsType *string `json:"osType,omitempty"`
	// Size - The size of the virtual machine.
	Size *string `json:"size,omitempty"`
	// UserName - The user name of the virtual machine.
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine administrator.
	Password *string `json:"password,omitempty"`
	// SSHKey - The SSH key of the virtual machine administrator.
	SSHKey *string `json:"sshKey,omitempty"`
	// IsAuthenticationWithSSHKey - A value indicating whether this virtual machine uses an SSH key for authentication.
	IsAuthenticationWithSSHKey *bool `json:"isAuthenticationWithSshKey,omitempty"`
	// Fqdn - The fully-qualified domain name of the virtual machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// LabSubnetName - The lab subnet name of the virtual machine.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// LabVirtualNetworkID - The lab virtual network identifier of the virtual machine.
	LabVirtualNetworkID *string `json:"labVirtualNetworkId,omitempty"`
	// DisallowPublicIPAddress - Indicates whether the virtual machine is to be created without a public IP address.
	DisallowPublicIPAddress *bool `json:"disallowPublicIpAddress,omitempty"`
	// Artifacts - The artifacts to be installed on the virtual machine.
	Artifacts *[]ArtifactInstallProperties `json:"artifacts,omitempty"`
	// ArtifactDeploymentStatus - The artifact deployment status for the virtual machine.
	ArtifactDeploymentStatus *ArtifactDeploymentStatusProperties `json:"artifactDeploymentStatus,omitempty"`
	// GalleryImageReference - The Microsoft Azure Marketplace image reference of the virtual machine.
	GalleryImageReference *GalleryImageReference `json:"galleryImageReference,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LinuxOsInfo information about a Linux OS.
type LinuxOsInfo struct {
	// LinuxOsState - The state of the Linux OS. Possible values include: 'NonDeprovisioned', 'DeprovisionRequested', 'DeprovisionApplied'
	LinuxOsState LinuxOsState `json:"linuxOsState,omitempty"`
}

// ParameterInfo ...
type ParameterInfo struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// Policy a Policy.
type Policy struct {
	autorest.Response `json:"-"`
	// PolicyProperties - The properties of the resource.
	*PolicyProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PolicyProperties != nil {
		objectMap["properties"] = p.PolicyProperties
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Policy struct.
func (p *Policy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				p.PolicyProperties = &policyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		}
	}

	return nil
}

// PolicyProperties properties of a Policy.
type PolicyProperties struct {
	// Description - The description of the policy.
	Description *string `json:"description,omitempty"`
	// Status - The status of the policy. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
	// FactName - The fact name of the policy. Possible values include: 'PolicyFactNameUserOwnedLabVMCount', 'PolicyFactNameLabVMCount', 'PolicyFactNameLabVMSize', 'PolicyFactNameGalleryImage', 'PolicyFactNameUserOwnedLabVMCountInSubnet'
	FactName PolicyFactName `json:"factName,omitempty"`
	// FactData - The fact data of the policy.
	FactData *string `json:"factData,omitempty"`
	// Threshold - The threshold of the policy.
	Threshold *string `json:"threshold,omitempty"`
	// EvaluatorType - The evaluator type of the policy. Possible values include: 'AllowedValuesPolicy', 'MaxValuePolicy'
	EvaluatorType PolicyEvaluatorType `json:"evaluatorType,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PolicySetResult result of a policy set evaluation.
type PolicySetResult struct {
	// HasError - A value indicating whether this policy set evaluation has discovered violations.
	HasError *bool `json:"hasError,omitempty"`
	// PolicyViolations - The list of policy violations.
	PolicyViolations *[]PolicyViolation `json:"policyViolations,omitempty"`
}

// PolicyViolation policy violation.
type PolicyViolation struct {
	// Code - The code of the policy violation.
	Code *string `json:"code,omitempty"`
	// Message - The message of the policy violation.
	Message *string `json:"message,omitempty"`
}

// ResponseWithContinuationArtifact the response of a list operation.
type ResponseWithContinuationArtifact struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Artifact `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArtifactIterator provides access to a complete listing of Artifact values.
type ResponseWithContinuationArtifactIterator struct {
	i    int
	page ResponseWithContinuationArtifactPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationArtifactIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationArtifactIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationArtifactIterator) Response() ResponseWithContinuationArtifact {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationArtifactIterator) Value() Artifact {
	if !iter.page.NotDone() {
		return Artifact{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcA ResponseWithContinuationArtifact) IsEmpty() bool {
	return rwcA.Value == nil || len(*rwcA.Value) == 0
}

// responseWithContinuationArtifactPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcA ResponseWithContinuationArtifact) responseWithContinuationArtifactPreparer() (*http.Request, error) {
	if rwcA.NextLink == nil || len(to.String(rwcA.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcA.NextLink)))
}

// ResponseWithContinuationArtifactPage contains a page of Artifact values.
type ResponseWithContinuationArtifactPage struct {
	fn   func(ResponseWithContinuationArtifact) (ResponseWithContinuationArtifact, error)
	rwca ResponseWithContinuationArtifact
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationArtifactPage) Next() error {
	next, err := page.fn(page.rwca)
	if err != nil {
		return err
	}
	page.rwca = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationArtifactPage) NotDone() bool {
	return !page.rwca.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationArtifactPage) Response() ResponseWithContinuationArtifact {
	return page.rwca
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationArtifactPage) Values() []Artifact {
	if page.rwca.IsEmpty() {
		return nil
	}
	return *page.rwca.Value
}

// ResponseWithContinuationArtifactSource the response of a list operation.
type ResponseWithContinuationArtifactSource struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]ArtifactSource `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationArtifactSourceIterator provides access to a complete listing of ArtifactSource values.
type ResponseWithContinuationArtifactSourceIterator struct {
	i    int
	page ResponseWithContinuationArtifactSourcePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationArtifactSourceIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationArtifactSourceIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationArtifactSourceIterator) Response() ResponseWithContinuationArtifactSource {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationArtifactSourceIterator) Value() ArtifactSource {
	if !iter.page.NotDone() {
		return ArtifactSource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcAs ResponseWithContinuationArtifactSource) IsEmpty() bool {
	return rwcAs.Value == nil || len(*rwcAs.Value) == 0
}

// responseWithContinuationArtifactSourcePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcAs ResponseWithContinuationArtifactSource) responseWithContinuationArtifactSourcePreparer() (*http.Request, error) {
	if rwcAs.NextLink == nil || len(to.String(rwcAs.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcAs.NextLink)))
}

// ResponseWithContinuationArtifactSourcePage contains a page of ArtifactSource values.
type ResponseWithContinuationArtifactSourcePage struct {
	fn    func(ResponseWithContinuationArtifactSource) (ResponseWithContinuationArtifactSource, error)
	rwcas ResponseWithContinuationArtifactSource
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationArtifactSourcePage) Next() error {
	next, err := page.fn(page.rwcas)
	if err != nil {
		return err
	}
	page.rwcas = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationArtifactSourcePage) NotDone() bool {
	return !page.rwcas.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationArtifactSourcePage) Response() ResponseWithContinuationArtifactSource {
	return page.rwcas
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationArtifactSourcePage) Values() []ArtifactSource {
	if page.rwcas.IsEmpty() {
		return nil
	}
	return *page.rwcas.Value
}

// ResponseWithContinuationCost the response of a list operation.
type ResponseWithContinuationCost struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Cost `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationCostInsight the response of a list operation.
type ResponseWithContinuationCostInsight struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]CostInsight `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationCostInsightIterator provides access to a complete listing of CostInsight values.
type ResponseWithContinuationCostInsightIterator struct {
	i    int
	page ResponseWithContinuationCostInsightPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationCostInsightIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationCostInsightIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationCostInsightIterator) Response() ResponseWithContinuationCostInsight {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationCostInsightIterator) Value() CostInsight {
	if !iter.page.NotDone() {
		return CostInsight{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcCi ResponseWithContinuationCostInsight) IsEmpty() bool {
	return rwcCi.Value == nil || len(*rwcCi.Value) == 0
}

// responseWithContinuationCostInsightPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcCi ResponseWithContinuationCostInsight) responseWithContinuationCostInsightPreparer() (*http.Request, error) {
	if rwcCi.NextLink == nil || len(to.String(rwcCi.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcCi.NextLink)))
}

// ResponseWithContinuationCostInsightPage contains a page of CostInsight values.
type ResponseWithContinuationCostInsightPage struct {
	fn    func(ResponseWithContinuationCostInsight) (ResponseWithContinuationCostInsight, error)
	rwcci ResponseWithContinuationCostInsight
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationCostInsightPage) Next() error {
	next, err := page.fn(page.rwcci)
	if err != nil {
		return err
	}
	page.rwcci = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationCostInsightPage) NotDone() bool {
	return !page.rwcci.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationCostInsightPage) Response() ResponseWithContinuationCostInsight {
	return page.rwcci
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationCostInsightPage) Values() []CostInsight {
	if page.rwcci.IsEmpty() {
		return nil
	}
	return *page.rwcci.Value
}

// ResponseWithContinuationCostIterator provides access to a complete listing of Cost values.
type ResponseWithContinuationCostIterator struct {
	i    int
	page ResponseWithContinuationCostPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationCostIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationCostIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationCostIterator) Response() ResponseWithContinuationCost {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationCostIterator) Value() Cost {
	if !iter.page.NotDone() {
		return Cost{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcC ResponseWithContinuationCost) IsEmpty() bool {
	return rwcC.Value == nil || len(*rwcC.Value) == 0
}

// responseWithContinuationCostPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcC ResponseWithContinuationCost) responseWithContinuationCostPreparer() (*http.Request, error) {
	if rwcC.NextLink == nil || len(to.String(rwcC.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcC.NextLink)))
}

// ResponseWithContinuationCostPage contains a page of Cost values.
type ResponseWithContinuationCostPage struct {
	fn   func(ResponseWithContinuationCost) (ResponseWithContinuationCost, error)
	rwcc ResponseWithContinuationCost
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationCostPage) Next() error {
	next, err := page.fn(page.rwcc)
	if err != nil {
		return err
	}
	page.rwcc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationCostPage) NotDone() bool {
	return !page.rwcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationCostPage) Response() ResponseWithContinuationCost {
	return page.rwcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationCostPage) Values() []Cost {
	if page.rwcc.IsEmpty() {
		return nil
	}
	return *page.rwcc.Value
}

// ResponseWithContinuationCustomImage the response of a list operation.
type ResponseWithContinuationCustomImage struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]CustomImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationCustomImageIterator provides access to a complete listing of CustomImage values.
type ResponseWithContinuationCustomImageIterator struct {
	i    int
	page ResponseWithContinuationCustomImagePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationCustomImageIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationCustomImageIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationCustomImageIterator) Response() ResponseWithContinuationCustomImage {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationCustomImageIterator) Value() CustomImage {
	if !iter.page.NotDone() {
		return CustomImage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcCi ResponseWithContinuationCustomImage) IsEmpty() bool {
	return rwcCi.Value == nil || len(*rwcCi.Value) == 0
}

// responseWithContinuationCustomImagePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcCi ResponseWithContinuationCustomImage) responseWithContinuationCustomImagePreparer() (*http.Request, error) {
	if rwcCi.NextLink == nil || len(to.String(rwcCi.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcCi.NextLink)))
}

// ResponseWithContinuationCustomImagePage contains a page of CustomImage values.
type ResponseWithContinuationCustomImagePage struct {
	fn    func(ResponseWithContinuationCustomImage) (ResponseWithContinuationCustomImage, error)
	rwcci ResponseWithContinuationCustomImage
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationCustomImagePage) Next() error {
	next, err := page.fn(page.rwcci)
	if err != nil {
		return err
	}
	page.rwcci = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationCustomImagePage) NotDone() bool {
	return !page.rwcci.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationCustomImagePage) Response() ResponseWithContinuationCustomImage {
	return page.rwcci
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationCustomImagePage) Values() []CustomImage {
	if page.rwcci.IsEmpty() {
		return nil
	}
	return *page.rwcci.Value
}

// ResponseWithContinuationFormula the response of a list operation.
type ResponseWithContinuationFormula struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Formula `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationFormulaIterator provides access to a complete listing of Formula values.
type ResponseWithContinuationFormulaIterator struct {
	i    int
	page ResponseWithContinuationFormulaPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationFormulaIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationFormulaIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationFormulaIterator) Response() ResponseWithContinuationFormula {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationFormulaIterator) Value() Formula {
	if !iter.page.NotDone() {
		return Formula{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcF ResponseWithContinuationFormula) IsEmpty() bool {
	return rwcF.Value == nil || len(*rwcF.Value) == 0
}

// responseWithContinuationFormulaPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcF ResponseWithContinuationFormula) responseWithContinuationFormulaPreparer() (*http.Request, error) {
	if rwcF.NextLink == nil || len(to.String(rwcF.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcF.NextLink)))
}

// ResponseWithContinuationFormulaPage contains a page of Formula values.
type ResponseWithContinuationFormulaPage struct {
	fn   func(ResponseWithContinuationFormula) (ResponseWithContinuationFormula, error)
	rwcf ResponseWithContinuationFormula
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationFormulaPage) Next() error {
	next, err := page.fn(page.rwcf)
	if err != nil {
		return err
	}
	page.rwcf = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationFormulaPage) NotDone() bool {
	return !page.rwcf.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationFormulaPage) Response() ResponseWithContinuationFormula {
	return page.rwcf
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationFormulaPage) Values() []Formula {
	if page.rwcf.IsEmpty() {
		return nil
	}
	return *page.rwcf.Value
}

// ResponseWithContinuationGalleryImage the response of a list operation.
type ResponseWithContinuationGalleryImage struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]GalleryImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationGalleryImageIterator provides access to a complete listing of GalleryImage values.
type ResponseWithContinuationGalleryImageIterator struct {
	i    int
	page ResponseWithContinuationGalleryImagePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationGalleryImageIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationGalleryImageIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationGalleryImageIterator) Response() ResponseWithContinuationGalleryImage {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationGalleryImageIterator) Value() GalleryImage {
	if !iter.page.NotDone() {
		return GalleryImage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcGi ResponseWithContinuationGalleryImage) IsEmpty() bool {
	return rwcGi.Value == nil || len(*rwcGi.Value) == 0
}

// responseWithContinuationGalleryImagePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcGi ResponseWithContinuationGalleryImage) responseWithContinuationGalleryImagePreparer() (*http.Request, error) {
	if rwcGi.NextLink == nil || len(to.String(rwcGi.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcGi.NextLink)))
}

// ResponseWithContinuationGalleryImagePage contains a page of GalleryImage values.
type ResponseWithContinuationGalleryImagePage struct {
	fn    func(ResponseWithContinuationGalleryImage) (ResponseWithContinuationGalleryImage, error)
	rwcgi ResponseWithContinuationGalleryImage
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationGalleryImagePage) Next() error {
	next, err := page.fn(page.rwcgi)
	if err != nil {
		return err
	}
	page.rwcgi = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationGalleryImagePage) NotDone() bool {
	return !page.rwcgi.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationGalleryImagePage) Response() ResponseWithContinuationGalleryImage {
	return page.rwcgi
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationGalleryImagePage) Values() []GalleryImage {
	if page.rwcgi.IsEmpty() {
		return nil
	}
	return *page.rwcgi.Value
}

// ResponseWithContinuationLab the response of a list operation.
type ResponseWithContinuationLab struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Lab `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabIterator provides access to a complete listing of Lab values.
type ResponseWithContinuationLabIterator struct {
	i    int
	page ResponseWithContinuationLabPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabIterator) Response() ResponseWithContinuationLab {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabIterator) Value() Lab {
	if !iter.page.NotDone() {
		return Lab{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcL ResponseWithContinuationLab) IsEmpty() bool {
	return rwcL.Value == nil || len(*rwcL.Value) == 0
}

// responseWithContinuationLabPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcL ResponseWithContinuationLab) responseWithContinuationLabPreparer() (*http.Request, error) {
	if rwcL.NextLink == nil || len(to.String(rwcL.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcL.NextLink)))
}

// ResponseWithContinuationLabPage contains a page of Lab values.
type ResponseWithContinuationLabPage struct {
	fn   func(ResponseWithContinuationLab) (ResponseWithContinuationLab, error)
	rwcl ResponseWithContinuationLab
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabPage) Next() error {
	next, err := page.fn(page.rwcl)
	if err != nil {
		return err
	}
	page.rwcl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabPage) NotDone() bool {
	return !page.rwcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabPage) Response() ResponseWithContinuationLab {
	return page.rwcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabPage) Values() []Lab {
	if page.rwcl.IsEmpty() {
		return nil
	}
	return *page.rwcl.Value
}

// ResponseWithContinuationLabVhd the response of a list operation.
type ResponseWithContinuationLabVhd struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabVhd `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabVhdIterator provides access to a complete listing of LabVhd values.
type ResponseWithContinuationLabVhdIterator struct {
	i    int
	page ResponseWithContinuationLabVhdPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabVhdIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabVhdIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabVhdIterator) Response() ResponseWithContinuationLabVhd {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabVhdIterator) Value() LabVhd {
	if !iter.page.NotDone() {
		return LabVhd{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcLv ResponseWithContinuationLabVhd) IsEmpty() bool {
	return rwcLv.Value == nil || len(*rwcLv.Value) == 0
}

// responseWithContinuationLabVhdPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcLv ResponseWithContinuationLabVhd) responseWithContinuationLabVhdPreparer() (*http.Request, error) {
	if rwcLv.NextLink == nil || len(to.String(rwcLv.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcLv.NextLink)))
}

// ResponseWithContinuationLabVhdPage contains a page of LabVhd values.
type ResponseWithContinuationLabVhdPage struct {
	fn    func(ResponseWithContinuationLabVhd) (ResponseWithContinuationLabVhd, error)
	rwclv ResponseWithContinuationLabVhd
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabVhdPage) Next() error {
	next, err := page.fn(page.rwclv)
	if err != nil {
		return err
	}
	page.rwclv = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabVhdPage) NotDone() bool {
	return !page.rwclv.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabVhdPage) Response() ResponseWithContinuationLabVhd {
	return page.rwclv
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabVhdPage) Values() []LabVhd {
	if page.rwclv.IsEmpty() {
		return nil
	}
	return *page.rwclv.Value
}

// ResponseWithContinuationLabVirtualMachine the response of a list operation.
type ResponseWithContinuationLabVirtualMachine struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabVirtualMachine `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabVirtualMachineIterator provides access to a complete listing of LabVirtualMachine
// values.
type ResponseWithContinuationLabVirtualMachineIterator struct {
	i    int
	page ResponseWithContinuationLabVirtualMachinePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabVirtualMachineIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabVirtualMachineIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabVirtualMachineIterator) Response() ResponseWithContinuationLabVirtualMachine {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabVirtualMachineIterator) Value() LabVirtualMachine {
	if !iter.page.NotDone() {
		return LabVirtualMachine{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcLvm ResponseWithContinuationLabVirtualMachine) IsEmpty() bool {
	return rwcLvm.Value == nil || len(*rwcLvm.Value) == 0
}

// responseWithContinuationLabVirtualMachinePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcLvm ResponseWithContinuationLabVirtualMachine) responseWithContinuationLabVirtualMachinePreparer() (*http.Request, error) {
	if rwcLvm.NextLink == nil || len(to.String(rwcLvm.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcLvm.NextLink)))
}

// ResponseWithContinuationLabVirtualMachinePage contains a page of LabVirtualMachine values.
type ResponseWithContinuationLabVirtualMachinePage struct {
	fn     func(ResponseWithContinuationLabVirtualMachine) (ResponseWithContinuationLabVirtualMachine, error)
	rwclvm ResponseWithContinuationLabVirtualMachine
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabVirtualMachinePage) Next() error {
	next, err := page.fn(page.rwclvm)
	if err != nil {
		return err
	}
	page.rwclvm = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabVirtualMachinePage) NotDone() bool {
	return !page.rwclvm.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabVirtualMachinePage) Response() ResponseWithContinuationLabVirtualMachine {
	return page.rwclvm
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabVirtualMachinePage) Values() []LabVirtualMachine {
	if page.rwclvm.IsEmpty() {
		return nil
	}
	return *page.rwclvm.Value
}

// ResponseWithContinuationPolicy the response of a list operation.
type ResponseWithContinuationPolicy struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Policy `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationPolicyIterator provides access to a complete listing of Policy values.
type ResponseWithContinuationPolicyIterator struct {
	i    int
	page ResponseWithContinuationPolicyPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationPolicyIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationPolicyIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationPolicyIterator) Response() ResponseWithContinuationPolicy {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationPolicyIterator) Value() Policy {
	if !iter.page.NotDone() {
		return Policy{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcP ResponseWithContinuationPolicy) IsEmpty() bool {
	return rwcP.Value == nil || len(*rwcP.Value) == 0
}

// responseWithContinuationPolicyPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcP ResponseWithContinuationPolicy) responseWithContinuationPolicyPreparer() (*http.Request, error) {
	if rwcP.NextLink == nil || len(to.String(rwcP.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcP.NextLink)))
}

// ResponseWithContinuationPolicyPage contains a page of Policy values.
type ResponseWithContinuationPolicyPage struct {
	fn   func(ResponseWithContinuationPolicy) (ResponseWithContinuationPolicy, error)
	rwcp ResponseWithContinuationPolicy
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationPolicyPage) Next() error {
	next, err := page.fn(page.rwcp)
	if err != nil {
		return err
	}
	page.rwcp = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationPolicyPage) NotDone() bool {
	return !page.rwcp.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationPolicyPage) Response() ResponseWithContinuationPolicy {
	return page.rwcp
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationPolicyPage) Values() []Policy {
	if page.rwcp.IsEmpty() {
		return nil
	}
	return *page.rwcp.Value
}

// ResponseWithContinuationSchedule the response of a list operation.
type ResponseWithContinuationSchedule struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Schedule `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationScheduleIterator provides access to a complete listing of Schedule values.
type ResponseWithContinuationScheduleIterator struct {
	i    int
	page ResponseWithContinuationSchedulePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationScheduleIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationScheduleIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationScheduleIterator) Response() ResponseWithContinuationSchedule {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationScheduleIterator) Value() Schedule {
	if !iter.page.NotDone() {
		return Schedule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcS ResponseWithContinuationSchedule) IsEmpty() bool {
	return rwcS.Value == nil || len(*rwcS.Value) == 0
}

// responseWithContinuationSchedulePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcS ResponseWithContinuationSchedule) responseWithContinuationSchedulePreparer() (*http.Request, error) {
	if rwcS.NextLink == nil || len(to.String(rwcS.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcS.NextLink)))
}

// ResponseWithContinuationSchedulePage contains a page of Schedule values.
type ResponseWithContinuationSchedulePage struct {
	fn   func(ResponseWithContinuationSchedule) (ResponseWithContinuationSchedule, error)
	rwcs ResponseWithContinuationSchedule
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationSchedulePage) Next() error {
	next, err := page.fn(page.rwcs)
	if err != nil {
		return err
	}
	page.rwcs = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationSchedulePage) NotDone() bool {
	return !page.rwcs.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationSchedulePage) Response() ResponseWithContinuationSchedule {
	return page.rwcs
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationSchedulePage) Values() []Schedule {
	if page.rwcs.IsEmpty() {
		return nil
	}
	return *page.rwcs.Value
}

// ResponseWithContinuationVirtualNetwork the response of a list operation.
type ResponseWithContinuationVirtualNetwork struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]VirtualNetwork `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationVirtualNetworkIterator provides access to a complete listing of VirtualNetwork values.
type ResponseWithContinuationVirtualNetworkIterator struct {
	i    int
	page ResponseWithContinuationVirtualNetworkPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationVirtualNetworkIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationVirtualNetworkIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationVirtualNetworkIterator) Response() ResponseWithContinuationVirtualNetwork {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationVirtualNetworkIterator) Value() VirtualNetwork {
	if !iter.page.NotDone() {
		return VirtualNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcVn ResponseWithContinuationVirtualNetwork) IsEmpty() bool {
	return rwcVn.Value == nil || len(*rwcVn.Value) == 0
}

// responseWithContinuationVirtualNetworkPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcVn ResponseWithContinuationVirtualNetwork) responseWithContinuationVirtualNetworkPreparer() (*http.Request, error) {
	if rwcVn.NextLink == nil || len(to.String(rwcVn.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcVn.NextLink)))
}

// ResponseWithContinuationVirtualNetworkPage contains a page of VirtualNetwork values.
type ResponseWithContinuationVirtualNetworkPage struct {
	fn    func(ResponseWithContinuationVirtualNetwork) (ResponseWithContinuationVirtualNetwork, error)
	rwcvn ResponseWithContinuationVirtualNetwork
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationVirtualNetworkPage) Next() error {
	next, err := page.fn(page.rwcvn)
	if err != nil {
		return err
	}
	page.rwcvn = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationVirtualNetworkPage) NotDone() bool {
	return !page.rwcvn.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationVirtualNetworkPage) Response() ResponseWithContinuationVirtualNetwork {
	return page.rwcvn
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationVirtualNetworkPage) Values() []VirtualNetwork {
	if page.rwcvn.IsEmpty() {
		return nil
	}
	return *page.rwcvn.Value
}

// Schedule a schedule.
type Schedule struct {
	autorest.Response `json:"-"`
	// ScheduleProperties - The properties of the resource.
	*ScheduleProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ScheduleProperties != nil {
		objectMap["properties"] = s.ScheduleProperties
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Schedule struct.
func (s *Schedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleProperties ScheduleProperties
				err = json.Unmarshal(*v, &scheduleProperties)
				if err != nil {
					return err
				}
				s.ScheduleProperties = &scheduleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		}
	}

	return nil
}

// ScheduleCreateOrUpdateResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScheduleCreateOrUpdateResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ScheduleCreateOrUpdateResourceFuture) Result(client ScheduleClient) (s Schedule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ScheduleCreateOrUpdateResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ScheduleCreateOrUpdateResourceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResourceResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.ScheduleCreateOrUpdateResourceFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ScheduleDeleteResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScheduleDeleteResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ScheduleDeleteResourceFuture) Result(client ScheduleClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ScheduleDeleteResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ScheduleDeleteResourceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ScheduleExecuteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ScheduleExecuteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ScheduleExecuteFuture) Result(client ScheduleClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.ScheduleExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.ScheduleExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ScheduleProperties properties of a schedule.
type ScheduleProperties struct {
	// Status - The status of the schedule. Possible values include: 'Enabled', 'Disabled'
	Status EnableStatus `json:"status,omitempty"`
	// TaskType - The task type of the schedule. Possible values include: 'LabVmsShutdownTask', 'LabVmsStartupTask', 'LabBillingTask'
	TaskType TaskType `json:"taskType,omitempty"`
	// WeeklyRecurrence - The weekly recurrence of the schedule.
	WeeklyRecurrence *WeekDetails `json:"weeklyRecurrence,omitempty"`
	// DailyRecurrence - The daily recurrence of the schedule.
	DailyRecurrence *DayDetails `json:"dailyRecurrence,omitempty"`
	// HourlyRecurrence - The hourly recurrence of the schedule.
	HourlyRecurrence *HourDetails `json:"hourlyRecurrence,omitempty"`
	// TimeZoneID - The time zone id.
	TimeZoneID *string `json:"timeZoneId,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Subnet ...
type Subnet struct {
	ResourceID    *string `json:"resourceId,omitempty"`
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// AllowPublicIP - Possible values include: 'Default', 'Deny', 'Allow'
	AllowPublicIP UsagePermissionType `json:"allowPublicIp,omitempty"`
}

// SubnetOverride property overrides on a subnet of a virtual network.
type SubnetOverride struct {
	// ResourceID - The resource identifier of the subnet.
	ResourceID *string `json:"resourceId,omitempty"`
	// LabSubnetName - The name given to the subnet within the lab.
	LabSubnetName *string `json:"labSubnetName,omitempty"`
	// UseInVMCreationPermission - Indicates whether this subnet can be used during virtual machine creation. Possible values include: 'Default', 'Deny', 'Allow'
	UseInVMCreationPermission UsagePermissionType `json:"useInVmCreationPermission,omitempty"`
	// UsePublicIPAddressPermission - Indicates whether public IP addresses can be assigned to virtual machines on this subnet. Possible values include: 'Default', 'Deny', 'Allow'
	UsePublicIPAddressPermission UsagePermissionType `json:"usePublicIpAddressPermission,omitempty"`
}

// SubscriptionNotification ...
type SubscriptionNotification struct {
	RegistrationDate *string `json:"registrationDate,omitempty"`
	// State - Possible values include: 'NotDefined', 'Registered', 'Unregistered', 'Warned', 'Suspended', 'Deleted'
	State      SubscriptionNotificationState       `json:"state,omitempty"`
	Properties *SubscriptionNotificationProperties `json:"properties,omitempty"`
}

// SubscriptionNotificationProperties ...
type SubscriptionNotificationProperties struct {
	TenantID *string `json:"tenantId,omitempty"`
}

// VirtualMachineApplyArtifactsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachineApplyArtifactsFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachineApplyArtifactsFuture) Result(client VirtualMachineClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineApplyArtifactsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineApplyArtifactsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineCreateOrUpdateResourceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualMachineCreateOrUpdateResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachineCreateOrUpdateResourceFuture) Result(client VirtualMachineClient) (lvm LabVirtualMachine, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineCreateOrUpdateResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineCreateOrUpdateResourceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lvm.Response.Response, err = future.GetResult(sender); err == nil && lvm.Response.Response.StatusCode != http.StatusNoContent {
		lvm, err = client.CreateOrUpdateResourceResponder(lvm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.VirtualMachineCreateOrUpdateResourceFuture", "Result", lvm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualMachineDeleteResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualMachineDeleteResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachineDeleteResourceFuture) Result(client VirtualMachineClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineDeleteResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineDeleteResourceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VirtualMachineStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachineStartFuture) Result(client VirtualMachineClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VirtualMachineStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualMachineStopFuture) Result(client VirtualMachineClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualMachineStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualMachineStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetwork a virtual network.
type VirtualNetwork struct {
	autorest.Response `json:"-"`
	// VirtualNetworkProperties - The properties of the resource.
	*VirtualNetworkProperties `json:"properties,omitempty"`
	// ID - The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualNetwork.
func (vn VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vn.VirtualNetworkProperties != nil {
		objectMap["properties"] = vn.VirtualNetworkProperties
	}
	if vn.ID != nil {
		objectMap["id"] = vn.ID
	}
	if vn.Name != nil {
		objectMap["name"] = vn.Name
	}
	if vn.Type != nil {
		objectMap["type"] = vn.Type
	}
	if vn.Location != nil {
		objectMap["location"] = vn.Location
	}
	if vn.Tags != nil {
		objectMap["tags"] = vn.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetwork struct.
func (vn *VirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkProperties VirtualNetworkProperties
				err = json.Unmarshal(*v, &virtualNetworkProperties)
				if err != nil {
					return err
				}
				vn.VirtualNetworkProperties = &virtualNetworkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vn.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vn.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vn.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vn.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkCreateOrUpdateResourceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkCreateOrUpdateResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkCreateOrUpdateResourceFuture) Result(client VirtualNetworkClient) (vn VirtualNetwork, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualNetworkCreateOrUpdateResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualNetworkCreateOrUpdateResourceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vn.Response.Response, err = future.GetResult(sender); err == nil && vn.Response.Response.StatusCode != http.StatusNoContent {
		vn, err = client.CreateOrUpdateResourceResponder(vn.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "dtl.VirtualNetworkCreateOrUpdateResourceFuture", "Result", vn.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkDeleteResourceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualNetworkDeleteResourceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkDeleteResourceFuture) Result(client VirtualNetworkClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dtl.VirtualNetworkDeleteResourceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("dtl.VirtualNetworkDeleteResourceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkProperties properties of a virtual network.
type VirtualNetworkProperties struct {
	// AllowedSubnets - The allowed subnets of the virtual network.
	AllowedSubnets *[]Subnet `json:"allowedSubnets,omitempty"`
	// Description - The description of the virtual network.
	Description *string `json:"description,omitempty"`
	// ExternalProviderResourceID - The Microsoft.Network resource identifier of the virtual network.
	ExternalProviderResourceID *string `json:"externalProviderResourceId,omitempty"`
	// SubnetOverrides - The subnet overrides of the virtual network.
	SubnetOverrides *[]SubnetOverride `json:"subnetOverrides,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// VMCostProperties ...
type VMCostProperties struct {
	Name              *string  `json:"name,omitempty"`
	ResourceGroupName *string  `json:"resourceGroupName,omitempty"`
	Cost              *float64 `json:"cost,omitempty"`
}

// WeekDetails properties of a weekly schedule.
type WeekDetails struct {
	// Weekdays - The days of the week.
	Weekdays *[]string `json:"weekdays,omitempty"`
	// Time - The time of the day.
	Time *string `json:"time,omitempty"`
}

// WindowsOsInfo information about a Windows OS.
type WindowsOsInfo struct {
	// WindowsOsState - The state of the Windows OS. Possible values include: 'NonSysprepped', 'SysprepRequested', 'SysprepApplied'
	WindowsOsState WindowsOsState `json:"windowsOsState,omitempty"`
}
