/*
  tables.c
  Produce figures illustrating fancynum
  Part of the fancynum package
  Copyright (c) J.J.Green 1999. 
  j.j.green@sheffield.ac.uk
  $Id: tables.c,v 1.7 2000/03/15 18:53:47 ap1jjg Exp $
*/


#include <stdlib.h>
#include <stdio.h>

/*
  static constants
*/

static const double sampledouble = 3.141592653589793238462643383;

static const char table_line[] = 
  "\\verb|\%%%s| & \\verb|%s| & $\\fnum{%s}$";
static char texformat[100];

/*
  static prototypes
*/

static void maketable(char*,
		      char* (*)(char*,const char*),
		      const char**,
		      char*,
		      char*);
static void tabulate(FILE*,
		     char* (*)(char*,const char*),
		     const char**,
		     char*,
		     char*);
static char* dblsample(char*,const char*);

int main(void)
{
  const char* dblformats[] = 
  {"%f","%e","%g","%.9f","%.9e","%.9g",NULL}; 
  
  maketable(
	    "dbltable.tex",
	    dblsample,
	    dblformats,
	    "Double conversions for $\\pi$",
	    "dbltable");
  
  return EXIT_SUCCESS;
}

static void maketable(
		      char* filename, 
		      char* (*linefn)(char*,const char*), 
		      const char** samples,
		      char* title,
		      char* label)
{
  FILE* texfile;

  texfile = fopen(filename,"w");
  if (texfile == NULL) return;

  tabulate(texfile,linefn,samples,title,label);
  (void)fclose(texfile);;
}


static char* dblsample(char* buffer,const char* format)
{
  double a =  sampledouble;

  sprintf(texformat,table_line,format,format,format);
  sprintf(buffer,(const char*)texformat,a,a);

  return buffer;
}

static void tabulate(
		     FILE* texfile, 
		     char* (*linefn)(char*,const char*), 
		     const char** samples,
		     char* title,
		     char* label)
{
  char* line;
  char buffer[500];

  fprintf(texfile,"%% automatically generated by tables.c\n");
  fprintf(texfile,"\\begin{table}[tbh]\n");
  fprintf(texfile,"\\begin{center}\n");  
  fprintf(texfile,"\\begin{tabular}{|c|c|c|}\n");
  fprintf(texfile,"\\hline\n");  
  fprintf(texfile,"Format & Output & Typeset \\\\ \\hline \n");
  while (*samples != NULL)
    {
      line = linefn(buffer,*samples);
      fprintf(texfile,"%s \\\\\n",line);
      samples++;
    }
  fprintf(texfile,"\\hline\n");    
  fprintf(texfile,"\\end{tabular}\n");
  fprintf(texfile,"\\end{center}\n");
  fprintf(texfile,"\\caption{%s\\label{%s}}\n",title,label);
  fprintf(texfile,"\\end{table}\n");
}









